/*
 * intl_text.c - Translation texts to be included in intl.c
 *
 * Written by
 *  Marco van den Heuvel <blackystardust68@yahoo.com>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

intl_translate_t intl_string_table[] = {

/* en */ { IDMS_FILE,    "File" },
/* da */ { IDMS_FILE_DA, "Fil" },
/* de */ { IDMS_FILE_DE, "Datei" },
/* es */ { IDMS_FILE_ES, "Archivo" },
/* fr */ { IDMS_FILE_FR, "Fichier" },
/* hu */ { IDMS_FILE_HU, "Fjl" },
/* it */ { IDMS_FILE_IT, "File" },
/* ko */ { IDMS_FILE_KO, "" },
/* nl */ { IDMS_FILE_NL, "Bestand" },
/* pl */ { IDMS_FILE_PL, "Plik" },
/* ru */ { IDMS_FILE_RU, "" },
/* sv */ { IDMS_FILE_SV, "Arkiv" },
/* tr */ { IDMS_FILE_TR, "Dosya" },

/* en */ { IDMS_AUTOSTART_IMAGE,    "Autostart disk/tape image..." },
/* da */ { IDMS_AUTOSTART_IMAGE_DA, "Autostart disk-/bnd-image..." },
/* de */ { IDMS_AUTOSTART_IMAGE_DE, "Autostart von Disk/Band Image..." },
/* es */ { IDMS_AUTOSTART_IMAGE_ES, "Autoarranque imagen de disco/cinta..." },
/* fr */ { IDMS_AUTOSTART_IMAGE_FR, "Autodmarrage image disque/datassette..." },
/* hu */ { IDMS_AUTOSTART_IMAGE_HU, "Lemez/szalag kpms automatikus indtsa..." },
/* it */ { IDMS_AUTOSTART_IMAGE_IT, "Avvia automaticamente immagine disco/cassetta..." },
/* ko */ { IDMS_AUTOSTART_IMAGE_KO, "ڵ  ũ/ ̹..." },
/* nl */ { IDMS_AUTOSTART_IMAGE_NL, "Autostart disk-/tapebestand..." },
/* pl */ { IDMS_AUTOSTART_IMAGE_PL, "Automatycznie startuj z obrazu dysku lub tamy..." },
/* ru */ { IDMS_AUTOSTART_IMAGE_RU, "   /..." },
/* sv */ { IDMS_AUTOSTART_IMAGE_SV, "Autostarta disk-/bandavbildningsfil..." },
/* tr */ { IDMS_AUTOSTART_IMAGE_TR, "Disk/Teyp imajn otomatik balat..." },

/* en */ { IDMS_ATTACH_DISK_IMAGE,    "Attach disk image" },
/* da */ { IDMS_ATTACH_DISK_IMAGE_DA, "Tilslut disk-image" },
/* de */ { IDMS_ATTACH_DISK_IMAGE_DE, "Disk Image einlegen" },
/* es */ { IDMS_ATTACH_DISK_IMAGE_ES, "Insertar imagen de disco" },
/* fr */ { IDMS_ATTACH_DISK_IMAGE_FR, "Insrer une image de disque" },
/* hu */ { IDMS_ATTACH_DISK_IMAGE_HU, "Lemez kpms csatolsa" },
/* it */ { IDMS_ATTACH_DISK_IMAGE_IT, "Seleziona immagine disco" },
/* ko */ { IDMS_ATTACH_DISK_IMAGE_KO, "ũ ̹ ٿֱ" },
/* nl */ { IDMS_ATTACH_DISK_IMAGE_NL, "Koppel schijfbestand aan" },
/* pl */ { IDMS_ATTACH_DISK_IMAGE_PL, "Zamontuj obraz dyskietki" },
/* ru */ { IDMS_ATTACH_DISK_IMAGE_RU, "  " },
/* sv */ { IDMS_ATTACH_DISK_IMAGE_SV, "Anslut diskettavbildningsfil" },
/* tr */ { IDMS_ATTACH_DISK_IMAGE_TR, "Disk imajn yerletir" },

/* en */ {IDMS_DRIVE_8,    "Drive 8" },
/* da */ {IDMS_DRIVE_8_DA, "Drev 8" },
/* de */ {IDMS_DRIVE_8_DE, "Laufwerk 8" },
/* es */ {IDMS_DRIVE_8_ES, "Unidad disco 8" },
/* fr */ {IDMS_DRIVE_8_FR, "Lecteur #8" },
/* hu */ {IDMS_DRIVE_8_HU, "#8-as lemezegysg" },
/* it */ {IDMS_DRIVE_8_IT, "Drive 8" },
/* ko */ {IDMS_DRIVE_8_KO, "̺8" },
/* nl */ {IDMS_DRIVE_8_NL, "Drive 8" },
/* pl */ {IDMS_DRIVE_8_PL, "Napd 8" },
/* ru */ {IDMS_DRIVE_8_RU, " 8" },
/* sv */ {IDMS_DRIVE_8_SV, "Enhet 8" },
/* tr */ {IDMS_DRIVE_8_TR, "Src 8" },

/* en */ { IDMS_DRIVE_9,    "Drive 9" },
/* da */ { IDMS_DRIVE_9_DA, "Drev 9" },
/* de */ { IDMS_DRIVE_9_DE, "Laufwerk 9" },
/* es */ { IDMS_DRIVE_9_ES, "Unidad disco 9" },
/* fr */ { IDMS_DRIVE_9_FR, "Lecteur #9" },
/* hu */ { IDMS_DRIVE_9_HU, "#9-es lemezegysg" },
/* it */ { IDMS_DRIVE_9_IT, "Drive 9" },
/* ko */ { IDMS_DRIVE_9_KO, "̺9" },
/* nl */ { IDMS_DRIVE_9_NL, "Drive 9" },
/* pl */ { IDMS_DRIVE_9_PL, "Napd 9" },
/* ru */ { IDMS_DRIVE_9_RU, " 9" },
/* sv */ { IDMS_DRIVE_9_SV, "Enhet 9" },
/* tr */ { IDMS_DRIVE_9_TR, "Src 9" },

/* en */ { IDMS_DRIVE_10,    "Drive 10" },
/* da */ { IDMS_DRIVE_10_DA, "Drev 10" },
/* de */ { IDMS_DRIVE_10_DE, "Laufwerk 10" },
/* es */ { IDMS_DRIVE_10_ES, "Unidad disco 10" },
/* fr */ { IDMS_DRIVE_10_FR, "Lecteur #10" },
/* hu */ { IDMS_DRIVE_10_HU, "#10-es lemezegysg" },
/* it */ { IDMS_DRIVE_10_IT, "Drive 10" },
/* ko */ { IDMS_DRIVE_10_KO, "̺10" },
/* nl */ { IDMS_DRIVE_10_NL, "Drive 10" },
/* pl */ { IDMS_DRIVE_10_PL, "Napd 10" },
/* ru */ { IDMS_DRIVE_10_RU, " 10" },
/* sv */ { IDMS_DRIVE_10_SV, "Enhet 10" },
/* tr */ { IDMS_DRIVE_10_TR, "Src 10" },

/* en */ { IDMS_DRIVE_11,    "Drive 11" },
/* da */ { IDMS_DRIVE_11_DA, "Drev 11" },
/* de */ { IDMS_DRIVE_11_DE, "Laufwerk 11" },
/* es */ { IDMS_DRIVE_11_ES, "Unidad disco 11" },
/* fr */ { IDMS_DRIVE_11_FR, "Lecteur #11" },
/* hu */ { IDMS_DRIVE_11_HU, "#11-es lemezegysg" },
/* it */ { IDMS_DRIVE_11_IT, "Drive 11" },
/* ko */ { IDMS_DRIVE_11_KO, "̺11" },
/* nl */ { IDMS_DRIVE_11_NL, "Drive 11" },
/* pl */ { IDMS_DRIVE_11_PL, "Napd 11" },
/* ru */ { IDMS_DRIVE_11_RU, " 11" },
/* sv */ { IDMS_DRIVE_11_SV, "Enhet 11" },
/* tr */ { IDMS_DRIVE_11_TR, "Src 11" },

/* en */ { IDMS_DETACH_DISK_IMAGE,    "Detach disk image" },
/* da */ { IDMS_DETACH_DISK_IMAGE_DA, "Frakobl disk-image" },
/* de */ { IDMS_DETACH_DISK_IMAGE_DE, "Disk Image entfernen" },
/* es */ { IDMS_DETACH_DISK_IMAGE_ES, "Extraer imagen de disco" },
/* fr */ { IDMS_DETACH_DISK_IMAGE_FR, "Dtacher une image de disque" },
/* hu */ { IDMS_DETACH_DISK_IMAGE_HU, "Lemezkpms levlasztsa" },
/* it */ { IDMS_DETACH_DISK_IMAGE_IT, "Rimuovi immagine disco" },
/* ko */ { IDMS_DETACH_DISK_IMAGE_KO, "ũ ̹ " },
/* nl */ { IDMS_DETACH_DISK_IMAGE_NL, "Ontkoppel schijfbestand" },
/* pl */ { IDMS_DETACH_DISK_IMAGE_PL, "Wyjmij obraz dyskietki" },
/* ru */ { IDMS_DETACH_DISK_IMAGE_RU, "  " },
/* sv */ { IDMS_DETACH_DISK_IMAGE_SV, "Koppla frn diskettavbildningsfil" },
/* tr */ { IDMS_DETACH_DISK_IMAGE_TR, "Disk imajn kart" },

/* en */ { IDMS_ALL,    "All" },
/* da */ { IDMS_ALL_DA, "Alle" },
/* de */ { IDMS_ALL_DE, "Alle" },
/* es */ { IDMS_ALL_ES, "Todo" },
/* fr */ { IDMS_ALL_FR, "Tous" },
/* hu */ { IDMS_ALL_HU, "sszes" },
/* it */ { IDMS_ALL_IT, "Tutti" },
/* ko */ { IDMS_ALL_KO, "" },
/* nl */ { IDMS_ALL_NL, "Alles" },
/* pl */ { IDMS_ALL_PL, "Wszystkie" },
/* ru */ { IDMS_ALL_RU, "" },
/* sv */ { IDMS_ALL_SV, "Alla" },
/* tr */ { IDMS_ALL_TR, "Tm" },

/* en */ { IDMS_JAM_ACTION_SETTINGS,    "CPU JAM action settings" },
/* da */ { IDMS_JAM_ACTION_SETTINGS_DA, "" },  /* fuzzy */
/* de */ { IDMS_JAM_ACTION_SETTINGS_DE, "CPU JAM Aktion Einstellungen" },
/* es */ { IDMS_JAM_ACTION_SETTINGS_ES, "Ajustes accin CPU JAM" },
/* fr */ { IDMS_JAM_ACTION_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_JAM_ACTION_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_JAM_ACTION_SETTINGS_IT, "Impostazioni azione al JAM della CPU" },
/* ko */ { IDMS_JAM_ACTION_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_JAM_ACTION_SETTINGS_NL, "CPU JAM aktie instellingen" },
/* pl */ { IDMS_JAM_ACTION_SETTINGS_PL, "Ustawienia dziaania CPU JAM" },
/* ru */ { IDMS_JAM_ACTION_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_JAM_ACTION_SETTINGS_SV, "" },  /* fuzzy */
/* tr */ { IDMS_JAM_ACTION_SETTINGS_TR, "" },  /* fuzzy */

/* en */ { IDMS_FLIP_LIST,    "Flip list" },
/* da */ { IDMS_FLIP_LIST_DA, "Bladreliste" },
/* de */ { IDMS_FLIP_LIST_DE, "Flipliste" },
/* es */ { IDMS_FLIP_LIST_ES, "Lista agrupacin discos" },
/* fr */ { IDMS_FLIP_LIST_FR, "Groupement de disques" },
/* hu */ { IDMS_FLIP_LIST_HU, "Lemezlista" },
/* it */ { IDMS_FLIP_LIST_IT, "Flip list" },
/* ko */ { IDMS_FLIP_LIST_KO, "" },  /* fuzzy */
/* nl */ { IDMS_FLIP_LIST_NL, "Flip lijst" },
/* pl */ { IDMS_FLIP_LIST_PL, "Lista podmiany nonika" },
/* ru */ { IDMS_FLIP_LIST_RU, "Flip list" },
/* sv */ { IDMS_FLIP_LIST_SV, "Vallista" },
/* tr */ { IDMS_FLIP_LIST_TR, "Sralama listesi" },

/* en */ { IDMS_ADD_CURRENT_IMAGE,    "Add current image (Unit 8)" },
/* da */ { IDMS_ADD_CURRENT_IMAGE_DA, "Tilfj nuvrende image (Enhed 8)" },
/* de */ { IDMS_ADD_CURRENT_IMAGE_DE, "Aktuelles Image hinzufgen (Gert 8)" },
/* es */ { IDMS_ADD_CURRENT_IMAGE_ES, "Aadir imagen actual (Unidad 8)" },
/* fr */ { IDMS_ADD_CURRENT_IMAGE_FR, "Ajouter l'image de disque courante (#8) au groupement" },
/* hu */ { IDMS_ADD_CURRENT_IMAGE_HU, "Az aktulis kpms hozzadsa (8-as egysg)" },
/* it */ { IDMS_ADD_CURRENT_IMAGE_IT, "Aggiungi immagine attuale (Unit 8)" },
/* ko */ { IDMS_ADD_CURRENT_IMAGE_KO, " ̹ (Unit 8) ϱ" },
/* nl */ { IDMS_ADD_CURRENT_IMAGE_NL, "Voeg huidig bestand toe (Drive 8)" },
/* pl */ { IDMS_ADD_CURRENT_IMAGE_PL, "Dodaj aktualny obraz (jednostka 8)" },
/* ru */ { IDMS_ADD_CURRENT_IMAGE_RU, "Add current image (Unit 8)" },
/* sv */ { IDMS_ADD_CURRENT_IMAGE_SV, "Lgg till aktuell avbildning (enhet 8)" },
/* tr */ { IDMS_ADD_CURRENT_IMAGE_TR, "Geerli imaj ekle (Birim 8)" },

/* en */ { IDMS_REMOVE_CURRENT_IMAGE,    "Remove current image (Unit 8)" },
/* da */ { IDMS_REMOVE_CURRENT_IMAGE_DA, "Fjern nuvrende image (Enhed 8)" },
/* de */ { IDMS_REMOVE_CURRENT_IMAGE_DE, "Aktuelles Image entfernen (Gert 8)" },
/* es */ { IDMS_REMOVE_CURRENT_IMAGE_ES, "Quitar imagen actual (Unidad 8)" },
/* fr */ { IDMS_REMOVE_CURRENT_IMAGE_FR, "Retirer l'image de disque courante (#8) au groupement" },
/* hu */ { IDMS_REMOVE_CURRENT_IMAGE_HU, "Az aktulis kpms eltvoltsa (8-as egysg)" },
/* it */ { IDMS_REMOVE_CURRENT_IMAGE_IT, "Rimuovi immagine attuale (Unit 8)" },
/* ko */ { IDMS_REMOVE_CURRENT_IMAGE_KO, " ̹ (Unit 8) ϱ" },
/* nl */ { IDMS_REMOVE_CURRENT_IMAGE_NL, "Verwijder huidig bestand (Drive 8)" },
/* pl */ { IDMS_REMOVE_CURRENT_IMAGE_PL, "Usu aktualny obraz (jednostka 8)" },
/* ru */ { IDMS_REMOVE_CURRENT_IMAGE_RU, "Remove current image (Unit 8)" },
/* sv */ { IDMS_REMOVE_CURRENT_IMAGE_SV, "Ta bort aktuell avbildning (enhet 8)" },
/* tr */ { IDMS_REMOVE_CURRENT_IMAGE_TR, "Geerli imaj kaldr (Birim 8)" },

/* en */ { IDMS_ATTACH_NEXT_IMAGE,    "Attach next image (Unit 8)" },
/* da */ { IDMS_ATTACH_NEXT_IMAGE_DA, "Tilslut nste image (Enhed 8)" },
/* de */ { IDMS_ATTACH_NEXT_IMAGE_DE, "Nchstes Image (Gert 8)" },
/* es */ { IDMS_ATTACH_NEXT_IMAGE_ES, "Insertar imagen siguiente (Unidad 8)" },
/* fr */ { IDMS_ATTACH_NEXT_IMAGE_FR, "Insrer le prochain disque du groupement dans le lecteur #8" },
/* hu */ { IDMS_ATTACH_NEXT_IMAGE_HU, "Kvetkez kpms csatolsa (8-as egysg)" },
/* it */ { IDMS_ATTACH_NEXT_IMAGE_IT, "Seleziona immagine successiva (Unit 8)" },
/* ko */ { IDMS_ATTACH_NEXT_IMAGE_KO, " ̹ (Unit 8) ̱" },
/* nl */ { IDMS_ATTACH_NEXT_IMAGE_NL, "Koppel volgend bestand (Drive 8)" },
/* pl */ { IDMS_ATTACH_NEXT_IMAGE_PL, "Zamontuj nastpny obraz (jednostka 8)" },
/* ru */ { IDMS_ATTACH_NEXT_IMAGE_RU, "Attach next image (Unit 8)" },
/* sv */ { IDMS_ATTACH_NEXT_IMAGE_SV, "Anslut nsta avbildning (enhet 8)" },
/* tr */ { IDMS_ATTACH_NEXT_IMAGE_TR, "Sonraki imaj yerletir (Birim 8)" },

/* en */ { IDMS_ATTACH_PREVIOUS_IMAGE,    "Attach previous image (Unit 8)" },
/* da */ { IDMS_ATTACH_PREVIOUS_IMAGE_DA, "Tilslut forrige image (Enhed 8)" },
/* de */ { IDMS_ATTACH_PREVIOUS_IMAGE_DE, "Voriges Image (Gert 8)" },
/* es */ { IDMS_ATTACH_PREVIOUS_IMAGE_ES, "Insertar imagen previa (Unidad 8)" },
/* fr */ { IDMS_ATTACH_PREVIOUS_IMAGE_FR, "Insrer le disque prcdent du groupement dans le lecteur #8" },
/* hu */ { IDMS_ATTACH_PREVIOUS_IMAGE_HU, "Elz kpms csatolsa (8-as egysg)" },
/* it */ { IDMS_ATTACH_PREVIOUS_IMAGE_IT, "Seleziona immagine precedente (Unit 8)" },
/* ko */ { IDMS_ATTACH_PREVIOUS_IMAGE_KO, " ̹ (Unit 8) ̱" },
/* nl */ { IDMS_ATTACH_PREVIOUS_IMAGE_NL, "Koppel vorig bestand (Drive 8)" },
/* pl */ { IDMS_ATTACH_PREVIOUS_IMAGE_PL, "Zamontuj poprzedni obraz (jednostka 8)" },
/* ru */ { IDMS_ATTACH_PREVIOUS_IMAGE_RU, "Attach previous image (Unit 8)" },
/* sv */ { IDMS_ATTACH_PREVIOUS_IMAGE_SV, "Anslut fregende avbildning (enhet 8)" },
/* tr */ { IDMS_ATTACH_PREVIOUS_IMAGE_TR, "nceki imaj yerletir (Birim 8)" },

/* en */ { IDMS_LOAD_FLIP_LIST,    "Load flip list file" },
/* da */ { IDMS_LOAD_FLIP_LIST_DA, "Indls bladrelistefil" },
/* de */ { IDMS_LOAD_FLIP_LIST_DE, "Fliplist Datei laden" },
/* es */ { IDMS_LOAD_FLIP_LIST_ES, "Cargar lista de ficheros a conmutar" },
/* fr */ { IDMS_LOAD_FLIP_LIST_FR, "Charger un fichier de groupement de disques" },
/* hu */ { IDMS_LOAD_FLIP_LIST_HU, "Lemezlista betltse" },
/* it */ { IDMS_LOAD_FLIP_LIST_IT, "Carica file fliplist" },
/* ko */ { IDMS_LOAD_FLIP_LIST_KO, "ø Ʈ  ҷ" },
/* nl */ { IDMS_LOAD_FLIP_LIST_NL, "Laad fliplijstbestand" },
/* pl */ { IDMS_LOAD_FLIP_LIST_PL, "Wczytaj plik listy podmiany nonikw" },
/* ru */ { IDMS_LOAD_FLIP_LIST_RU, "Load flip list file" },
/* sv */ { IDMS_LOAD_FLIP_LIST_SV, "Ls vallistefil" },
/* tr */ { IDMS_LOAD_FLIP_LIST_TR, "Sralama listesi dosyasn ykle" },

/* en */ { IDMS_SAVE_FLIP_LIST,    "Save flip list file" },
/* da */ { IDMS_SAVE_FLIP_LIST_DA, "Gem bladrelistefil" },
/* de */ { IDMS_SAVE_FLIP_LIST_DE, "Fliplist Datei speichern" },
/* es */ { IDMS_SAVE_FLIP_LIST_ES, "Grabar lista de ficheros a conmutar" },
/* fr */ { IDMS_SAVE_FLIP_LIST_FR, "Enregistrer le fichier de groupement de disques actuel" },
/* hu */ { IDMS_SAVE_FLIP_LIST_HU, "Lemezlista mentse fjlba" },
/* it */ { IDMS_SAVE_FLIP_LIST_IT, "Salva file fliplist" },
/* ko */ { IDMS_SAVE_FLIP_LIST_KO, "ø Ʈ  ϱ" },
/* nl */ { IDMS_SAVE_FLIP_LIST_NL, "Fliplijstbestand opslaan" },
/* pl */ { IDMS_SAVE_FLIP_LIST_PL, "Zapisz plik listy podmiany nonikw" },
/* ru */ { IDMS_SAVE_FLIP_LIST_RU, "Save flip list file" },
/* sv */ { IDMS_SAVE_FLIP_LIST_SV, "Spara vallistefil" },
/* tr */ { IDMS_SAVE_FLIP_LIST_TR, "Sralama listesi dosyasn kaydet" },

/* en */ { IDMS_ATTACH_TAPE_IMAGE,    "Attach tape image..." },
/* da */ { IDMS_ATTACH_TAPE_IMAGE_DA, "Tilslut bnd-image..." },
/* de */ { IDMS_ATTACH_TAPE_IMAGE_DE, "Band Image einlegen..." },
/* es */ { IDMS_ATTACH_TAPE_IMAGE_ES, "Insertar imagen de cinta..." },
/* fr */ { IDMS_ATTACH_TAPE_IMAGE_FR, "Insrer une image de datassette..." },
/* hu */ { IDMS_ATTACH_TAPE_IMAGE_HU, "Szalag kpms csatolsa..." },
/* it */ { IDMS_ATTACH_TAPE_IMAGE_IT, "Seleziona immagine cassetta..." },
/* ko */ { IDMS_ATTACH_TAPE_IMAGE_KO, " ̹ ٿֱ..." },
/* nl */ { IDMS_ATTACH_TAPE_IMAGE_NL, "Koppel tapebestand aan..." },
/* pl */ { IDMS_ATTACH_TAPE_IMAGE_PL, "Zamontuj obraz tamy..." },
/* ru */ { IDMS_ATTACH_TAPE_IMAGE_RU, "  ..." },
/* sv */ { IDMS_ATTACH_TAPE_IMAGE_SV, "Anslut bandavbildningsfil..." },
/* tr */ { IDMS_ATTACH_TAPE_IMAGE_TR, "Teyp imajn yerletir..." },

/* en */ { IDMS_DETACH_TAPE_IMAGE,    "Detach tape image" },
/* da */ { IDMS_DETACH_TAPE_IMAGE_DA, "Frakobl bnd-image" },
/* de */ { IDMS_DETACH_TAPE_IMAGE_DE, "Band Image entfernen" },
/* es */ { IDMS_DETACH_TAPE_IMAGE_ES, "Extraer imagen de cinta" },
/* fr */ { IDMS_DETACH_TAPE_IMAGE_FR, "Dtacher une image datassette..." },
/* hu */ { IDMS_DETACH_TAPE_IMAGE_HU, "Szalag kpms levlasztsa" },
/* it */ { IDMS_DETACH_TAPE_IMAGE_IT, "Rimuovi immagine cassetta" },
/* ko */ { IDMS_DETACH_TAPE_IMAGE_KO, " ̹ " },
/* nl */ { IDMS_DETACH_TAPE_IMAGE_NL, "Ontkoppel tapebestand" },
/* pl */ { IDMS_DETACH_TAPE_IMAGE_PL, "Wyjmij obraz tamy" },
/* ru */ { IDMS_DETACH_TAPE_IMAGE_RU, "  " },
/* sv */ { IDMS_DETACH_TAPE_IMAGE_SV, "Koppla frn bandavbildningsfil" },
/* tr */ { IDMS_DETACH_TAPE_IMAGE_TR, "Teyp imajn kart" },

/* en */ { IDMS_DATASSETTE_CONTROL,    "Datassette control" },
/* da */ { IDMS_DATASSETTE_CONTROL_DA, "Datasettestyring" },
/* de */ { IDMS_DATASSETTE_CONTROL_DE, "Bandlaufwerk Kontrolle" },
/* es */ { IDMS_DATASSETTE_CONTROL_ES, "Control del datasette" },
/* fr */ { IDMS_DATASSETTE_CONTROL_FR, "Contrle datassette" },
/* hu */ { IDMS_DATASSETTE_CONTROL_HU, "Magn vezrls" },
/* it */ { IDMS_DATASSETTE_CONTROL_IT, "Comandi registratore" },
/* ko */ { IDMS_DATASSETTE_CONTROL_KO, "Ÿ ĿƮ" },
/* nl */ { IDMS_DATASSETTE_CONTROL_NL, "Datasette regeling" },
/* pl */ { IDMS_DATASSETTE_CONTROL_PL, "Zarzdzanie magnetofonem" },
/* ru */ { IDMS_DATASSETTE_CONTROL_RU, "Datassette control" },
/* sv */ { IDMS_DATASSETTE_CONTROL_SV, "Datasettestyrning" },
/* tr */ { IDMS_DATASSETTE_CONTROL_TR, "Teyp kontrol" },

/* en */ { IDMS_STOP,    "Stop" },
/* da */ { IDMS_STOP_DA, "Stop" },
/* de */ { IDMS_STOP_DE, "Stop" },
/* es */ { IDMS_STOP_ES, "Detener" },
/* fr */ { IDMS_STOP_FR, "Arrt" },
/* hu */ { IDMS_STOP_HU, "Lellts" },
/* it */ { IDMS_STOP_IT, "Stop" },
/* ko */ { IDMS_STOP_KO, "" },
/* nl */ { IDMS_STOP_NL, "Stop" },
/* pl */ { IDMS_STOP_PL, "Zatrzymaj" },
/* ru */ { IDMS_STOP_RU, "" },
/* sv */ { IDMS_STOP_SV, "Stoppa" },
/* tr */ { IDMS_STOP_TR, "Dur" },

/* en */ { IDMS_START,    "Start" },
/* da */ { IDMS_START_DA, "Start" },
/* de */ { IDMS_START_DE, "Start" },
/* es */ { IDMS_START_ES, "Arrancar" },
/* fr */ { IDMS_START_FR, "Dmarrer" },
/* hu */ { IDMS_START_HU, "Indts" },
/* it */ { IDMS_START_IT, "Avvia" },
/* ko */ { IDMS_START_KO, "" },
/* nl */ { IDMS_START_NL, "Start" },
/* pl */ { IDMS_START_PL, "Start" },
/* ru */ { IDMS_START_RU, "Start" },
/* sv */ { IDMS_START_SV, "Starta" },
/* tr */ { IDMS_START_TR, "Balat" },

/* en */ { IDMS_FORWARD,    "Forward" },
/* da */ { IDMS_FORWARD_DA, "Spol frem" },
/* de */ { IDMS_FORWARD_DE, "Forward" },
/* es */ { IDMS_FORWARD_ES, "Avance rpido" },
/* fr */ { IDMS_FORWARD_FR, "En avant" },
/* hu */ { IDMS_FORWARD_HU, "Elrecsvls" },
/* it */ { IDMS_FORWARD_IT, "Avanti" },
/* ko */ { IDMS_FORWARD_KO, "" },
/* nl */ { IDMS_FORWARD_NL, "Vooruit" },
/* pl */ { IDMS_FORWARD_PL, "Przewi do przodu" },
/* ru */ { IDMS_FORWARD_RU, " " },
/* sv */ { IDMS_FORWARD_SV, "Spola framt" },
/* tr */ { IDMS_FORWARD_TR, "leri" },

/* en */ { IDMS_REWIND,    "Rewind" },
/* da */ { IDMS_REWIND_DA, "Spol tilbage" },
/* de */ { IDMS_REWIND_DE, "Rewind" },
/* es */ { IDMS_REWIND_ES, "Rebobinar" },
/* fr */ { IDMS_REWIND_FR, "En arrire" },
/* hu */ { IDMS_REWIND_HU, "Visszacsvls" },
/* it */ { IDMS_REWIND_IT, "Indietro" },
/* ko */ { IDMS_REWIND_KO, "ǰ" },
/* nl */ { IDMS_REWIND_NL, "Terug" },
/* pl */ { IDMS_REWIND_PL, "Przewi do tyu" },
/* ru */ { IDMS_REWIND_RU, " " },
/* sv */ { IDMS_REWIND_SV, "Spola bakt" },
/* tr */ { IDMS_REWIND_TR, "Geri" },

/* en */ { IDMS_RECORD,    "Record" },
/* da */ { IDMS_RECORD_DA, "Optag" },
/* de */ { IDMS_RECORD_DE, "Record" },
/* es */ { IDMS_RECORD_ES, "Grabar" },
/* fr */ { IDMS_RECORD_FR, "Enregistrer" },
/* hu */ { IDMS_RECORD_HU, "Felvtel" },
/* it */ { IDMS_RECORD_IT, "Registra" },
/* ko */ { IDMS_RECORD_KO, "ȭ" },
/* nl */ { IDMS_RECORD_NL, "Opname" },
/* pl */ { IDMS_RECORD_PL, "Nagrywaj" },
/* ru */ { IDMS_RECORD_RU, "" },
/* sv */ { IDMS_RECORD_SV, "Spela in" },
/* tr */ { IDMS_RECORD_TR, "Kayt" },

/* en */ { IDMS_RESET,    "Reset" },
/* da */ { IDMS_RESET_DA, "Reset" },
/* de */ { IDMS_RESET_DE, "Reset" },
/* es */ { IDMS_RESET_ES, "Reiniciar" },
/* fr */ { IDMS_RESET_FR, "Rinitialiser" },
/* hu */ { IDMS_RESET_HU, "Reset" },
/* it */ { IDMS_RESET_IT, "Reset" },
/* ko */ { IDMS_RESET_KO, "" },
/* nl */ { IDMS_RESET_NL, "Reset" },
/* pl */ { IDMS_RESET_PL, "Reset" },
/* ru */ { IDMS_RESET_RU, "Reset" },
/* sv */ { IDMS_RESET_SV, "terstll" },
/* tr */ { IDMS_RESET_TR, "Reset" },

/* en */ { IDMS_RESET_COUNTER,    "Reset Counter" },
/* da */ { IDMS_RESET_COUNTER_DA, "Nulstil tller" },
/* de */ { IDMS_RESET_COUNTER_DE, "Zhler zurcksetzen" },
/* es */ { IDMS_RESET_COUNTER_ES, "Reiniciar contador" },
/* fr */ { IDMS_RESET_COUNTER_FR, "Rinialiser le compteur" },
/* hu */ { IDMS_RESET_COUNTER_HU, "Szmll nullzsa" },
/* it */ { IDMS_RESET_COUNTER_IT, "Reset contantore" },
/* ko */ { IDMS_RESET_COUNTER_KO, " ī" },
/* nl */ { IDMS_RESET_COUNTER_NL, "Reset Teller" },
/* pl */ { IDMS_RESET_COUNTER_PL, "Skasuj licznik" },
/* ru */ { IDMS_RESET_COUNTER_RU, "Reset Counter" },
/* sv */ { IDMS_RESET_COUNTER_SV, "Nollstll rknare" },
/* tr */ { IDMS_RESET_COUNTER_TR, "Sayac Resetle" },

/* en */ { IDMS_ATTACH_CART_IMAGE,    "Attach cartridge image..." },
/* da */ { IDMS_ATTACH_CART_IMAGE_DA, "Tilslut cartridge-image..." },
/* de */ { IDMS_ATTACH_CART_IMAGE_DE, "Erweiterungsmodul einlegen..." },
/* es */ { IDMS_ATTACH_CART_IMAGE_ES, "Insertar imagen de cartucho..." },
/* fr */ { IDMS_ATTACH_CART_IMAGE_FR, "Insrer une cartouche..." },
/* hu */ { IDMS_ATTACH_CART_IMAGE_HU, "Cartridge kpms csatolsa..." },
/* it */ { IDMS_ATTACH_CART_IMAGE_IT, "Seleziona immagine cartuccia..." },
/* ko */ { IDMS_ATTACH_CART_IMAGE_KO, "īƮ ̹ ̱..." },
/* nl */ { IDMS_ATTACH_CART_IMAGE_NL, "Koppel cartridge bestand..." },
/* pl */ { IDMS_ATTACH_CART_IMAGE_PL, "Zamontuj obraz kartrida..." },
/* ru */ { IDMS_ATTACH_CART_IMAGE_RU, "  ..." },
/* sv */ { IDMS_ATTACH_CART_IMAGE_SV, "Anslut insticksmodulfil..." },
/* tr */ { IDMS_ATTACH_CART_IMAGE_TR, "Kartu imaj yerletir..." },

/* en */ { IDMS_GENERIC_IMAGE,    "Generic image..." },
/* da */ { IDMS_GENERIC_IMAGE_DA, "Standard-image..." },
/* de */ { IDMS_GENERIC_IMAGE_DE, "Generisches Image..." },
/* es */ { IDMS_GENERIC_IMAGE_ES, "Imagen generica..." },
/* fr */ { IDMS_GENERIC_IMAGE_FR, "Image gnrique..." },
/* hu */ { IDMS_GENERIC_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_GENERIC_IMAGE_IT, "Immagine generica..." },
/* ko */ { IDMS_GENERIC_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_GENERIC_IMAGE_NL, "Algemeen bestand..." },
/* pl */ { IDMS_GENERIC_IMAGE_PL, "Standardowy obraz..." },
/* ru */ { IDMS_GENERIC_IMAGE_RU, "Generic image..." },
/* sv */ { IDMS_GENERIC_IMAGE_SV, "Generisk avbild..." },
/* tr */ { IDMS_GENERIC_IMAGE_TR, "Jenerik imaj..." },

/* en */ { IDMS_MEGA_CART_IMAGE,    "Mega-Cart image..." },
/* da */ { IDMS_MEGA_CART_IMAGE_DA, "Mega-Cart image..." },
/* de */ { IDMS_MEGA_CART_IMAGE_DE, "Mega-Cart Image..." },
/* es */ { IDMS_MEGA_CART_IMAGE_ES, "Imagen Mega-Cart..." },
/* fr */ { IDMS_MEGA_CART_IMAGE_FR, "Image Mega-Cart..." },
/* hu */ { IDMS_MEGA_CART_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_MEGA_CART_IMAGE_IT, "Immagine Mega-Cart..." },
/* ko */ { IDMS_MEGA_CART_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_MEGA_CART_IMAGE_NL, "Mega-Cart bestand..." },
/* pl */ { IDMS_MEGA_CART_IMAGE_PL, "Obraz Mega-Cart..." },
/* ru */ { IDMS_MEGA_CART_IMAGE_RU, "Mega-Cart image..." },
/* sv */ { IDMS_MEGA_CART_IMAGE_SV, "Mega-Cart-avbildning..." },
/* tr */ { IDMS_MEGA_CART_IMAGE_TR, "Mega-Cart imaj..." },

/* en */ { IDMS_FINAL_EXPANSION_IMAGE,    "Final Expansion image..." },
/* da */ { IDMS_FINAL_EXPANSION_IMAGE_DA, "Final Expansion-image..." },
/* de */ { IDMS_FINAL_EXPANSION_IMAGE_DE, "Final Expansion Image..." },
/* es */ { IDMS_FINAL_EXPANSION_IMAGE_ES, "Imagen Final Expansion..." },
/* fr */ { IDMS_FINAL_EXPANSION_IMAGE_FR, "Image Final Expansion..." },
/* hu */ { IDMS_FINAL_EXPANSION_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_FINAL_EXPANSION_IMAGE_IT, "Immagine Final Expansion..." },
/* ko */ { IDMS_FINAL_EXPANSION_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_FINAL_EXPANSION_IMAGE_NL, "Final Expansion bestand..." },
/* pl */ { IDMS_FINAL_EXPANSION_IMAGE_PL, "Obraz Final Expansion..." },
/* ru */ { IDMS_FINAL_EXPANSION_IMAGE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_FINAL_EXPANSION_IMAGE_SV, "Final Expansion-fil..." },
/* tr */ { IDMS_FINAL_EXPANSION_IMAGE_TR, "Final Expansion imaj..." },

/* en */ { IDMS_FP_IMAGE,    "Vic Flash Plugin image..." },
/* da */ { IDMS_FP_IMAGE_DA, "Vic Flash Plugin-image..." },
/* de */ { IDMS_FP_IMAGE_DE, "Vic Flash Plugin Image..." },
/* es */ { IDMS_FP_IMAGE_ES, "Imagen Vic Flash Plugin..." },
/* fr */ { IDMS_FP_IMAGE_FR, "Image Vic Flash Plugin..." },
/* hu */ { IDMS_FP_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_FP_IMAGE_IT, "Immagine Vic Flash Plugin..." },
/* ko */ { IDMS_FP_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_FP_IMAGE_NL, "Vic Flash Plugin bestand..." },
/* pl */ { IDMS_FP_IMAGE_PL, "Obraz Vic Flash Plugin..." },
/* ru */ { IDMS_FP_IMAGE_RU, "Vic Flash Plugin image..." },
/* sv */ { IDMS_FP_IMAGE_SV, "Vic Flash insticksmodul-fil..." },
/* tr */ { IDMS_FP_IMAGE_TR, "Vic Flash Plugin imaj..." },

/* en */ { IDMS_UM_IMAGE,    "UltiMem image..." },
/* da */ { IDMS_UM_IMAGE_DA, "" },  /* fuzzy */
/* de */ { IDMS_UM_IMAGE_DE, "UltiMem Image..." },
/* es */ { IDMS_UM_IMAGE_ES, "" },  /* fuzzy */
/* fr */ { IDMS_UM_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_UM_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_UM_IMAGE_IT, "" },  /* fuzzy */
/* ko */ { IDMS_UM_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_UM_IMAGE_NL, "UltiMem bestand..." },
/* pl */ { IDMS_UM_IMAGE_PL, "" },  /* fuzzy */
/* ru */ { IDMS_UM_IMAGE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_UM_IMAGE_SV, "" },  /* fuzzy */
/* tr */ { IDMS_UM_IMAGE_TR, "" },  /* fuzzy */

/* en */ { IDMS_ADD_TO_GENERIC,    "Add to generic cartridge..." },
/* da */ { IDMS_ADD_TO_GENERIC_DA, "Tilfj til standardcartridge..." },
/* de */ { IDMS_ADD_TO_GENERIC_DE, "Zu universellem Erweiterungsmodul hinzufgen..." },
/* es */ { IDMS_ADD_TO_GENERIC_ES, "Aadir al cartucho generico..." },
/* fr */ { IDMS_ADD_TO_GENERIC_FR, "Ajouter  une cartouche gnrique..." },
/* hu */ { IDMS_ADD_TO_GENERIC_HU, "Hozzads ltalnos cartridge-hoz..." },
/* it */ { IDMS_ADD_TO_GENERIC_IT, "Aggiungi a cartuccia generica..." },
/* ko */ { IDMS_ADD_TO_GENERIC_KO, "ʸ īƮ ϱ..." },
/* nl */ { IDMS_ADD_TO_GENERIC_NL, "Voeg toe aan algemeen cartridge..." },
/* pl */ { IDMS_ADD_TO_GENERIC_PL, "Dodaj do standardowego kartrida..." },
/* ru */ { IDMS_ADD_TO_GENERIC_RU, "Add to generic cartridge..." },
/* sv */ { IDMS_ADD_TO_GENERIC_SV, "Lgg till generisk insticksmodul..." },
/* tr */ { IDMS_ADD_TO_GENERIC_TR, "Jenerik kartua ekle..." },

/* en */ { IDMS_SMART_ATTACH_IMAGE,    "Smart-attach image..." },
/* da */ { IDMS_SMART_ATTACH_IMAGE_DA, "Smart-tilslut image..." },
/* de */ { IDMS_SMART_ATTACH_IMAGE_DE, "Smart-Einlegen Image Date..." },
/* es */ { IDMS_SMART_ATTACH_IMAGE_ES, "Imagen Smart-attach..." },
/* fr */ { IDMS_SMART_ATTACH_IMAGE_FR, "Insertion intelligente d'une image..." },
/* hu */ { IDMS_SMART_ATTACH_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_SMART_ATTACH_IMAGE_IT, "Immagine Smart-attach..." },
/* ko */ { IDMS_SMART_ATTACH_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_SMART_ATTACH_IMAGE_NL, "Slimme bestandskoppeling..." },
/* pl */ { IDMS_SMART_ATTACH_IMAGE_PL, "Inteligentne montowanie obrazu..." },
/* ru */ { IDMS_SMART_ATTACH_IMAGE_RU, "Smart-attach image..." },
/* sv */ { IDMS_SMART_ATTACH_IMAGE_SV, "Smartanslut avbildning..." },
/* tr */ { IDMS_SMART_ATTACH_IMAGE_TR, "Smart-attach imaj..." },

/* en */ { IDMS_4_8_16KB_AT_2000,    "4/8/16KB image at $2000..." },
/* da */ { IDMS_4_8_16KB_AT_2000_DA, "4/8/16KB-image p $2000..." },
/* de */ { IDMS_4_8_16KB_AT_2000_DE, "4/8/16KB Image bei $2000..." },
/* es */ { IDMS_4_8_16KB_AT_2000_ES, "4/8/16KB imagen en $2000..." },
/* fr */ { IDMS_4_8_16KB_AT_2000_FR, "image 4/8/16 ko  $2000..." },
/* hu */ { IDMS_4_8_16KB_AT_2000_HU, "" },  /* fuzzy */
/* it */ { IDMS_4_8_16KB_AT_2000_IT, "Immagine di 4/8/16KB a $2000..." },
/* ko */ { IDMS_4_8_16KB_AT_2000_KO, "" },  /* fuzzy */
/* nl */ { IDMS_4_8_16KB_AT_2000_NL, "4/8/16KB bestand in $2000..." },
/* pl */ { IDMS_4_8_16KB_AT_2000_PL, "4/8/16KB obraz w $2000..." },
/* ru */ { IDMS_4_8_16KB_AT_2000_RU, "4/8/16KB image at $2000..." },
/* sv */ { IDMS_4_8_16KB_AT_2000_SV, "4/8/16KB-fil vid $2000..." },
/* tr */ { IDMS_4_8_16KB_AT_2000_TR, "4/8/16KB imaj $2000 adresinde..." },

/* en */ { IDMS_4_8_16KB_AT_4000,    "4/8/16KB image at $4000..." },
/* da */ { IDMS_4_8_16KB_AT_4000_DA, "4/8/16KB-image p $4000..." },
/* de */ { IDMS_4_8_16KB_AT_4000_DE, "4/8/16KB Image bei $4000..." },
/* es */ { IDMS_4_8_16KB_AT_4000_ES, "4/8/16KB imagen en $4000..." },
/* fr */ { IDMS_4_8_16KB_AT_4000_FR, "image 4/8/16 ko  $4000..." },
/* hu */ { IDMS_4_8_16KB_AT_4000_HU, "" },  /* fuzzy */
/* it */ { IDMS_4_8_16KB_AT_4000_IT, "Immagine di 4/8/16KB a $4000..." },
/* ko */ { IDMS_4_8_16KB_AT_4000_KO, "" },  /* fuzzy */
/* nl */ { IDMS_4_8_16KB_AT_4000_NL, "4/8/16KB bestand in $4000..." },
/* pl */ { IDMS_4_8_16KB_AT_4000_PL, "4/8/16KB obraz w $4000..." },
/* ru */ { IDMS_4_8_16KB_AT_4000_RU, "4/8/16KB image at $4000..." },
/* sv */ { IDMS_4_8_16KB_AT_4000_SV, "4/8/16KB-fil vid $4000..." },
/* tr */ { IDMS_4_8_16KB_AT_4000_TR, "4/8/16KB imaj $4000 adresinde..." },

/* en */ { IDMS_4_8_16KB_AT_6000,    "4/8/16KB image at $6000..." },
/* da */ { IDMS_4_8_16KB_AT_6000_DA, "4/8/16KB-image p $6000..." },
/* de */ { IDMS_4_8_16KB_AT_6000_DE, "4/8/16KB Image bei $6000..." },
/* es */ { IDMS_4_8_16KB_AT_6000_ES, "4/8/16KB imagen en $6000..." },
/* fr */ { IDMS_4_8_16KB_AT_6000_FR, "image 4/8/16 ko  $6000..." },
/* hu */ { IDMS_4_8_16KB_AT_6000_HU, "" },  /* fuzzy */
/* it */ { IDMS_4_8_16KB_AT_6000_IT, "Immagine di 4/8/16KB a $6000..." },
/* ko */ { IDMS_4_8_16KB_AT_6000_KO, "" },  /* fuzzy */
/* nl */ { IDMS_4_8_16KB_AT_6000_NL, "4/8/16KB bestand in $6000..." },
/* pl */ { IDMS_4_8_16KB_AT_6000_PL, "4/8/16KB obraz w $6000..." },
/* ru */ { IDMS_4_8_16KB_AT_6000_RU, "4/8/16KB image at $6000..." },
/* sv */ { IDMS_4_8_16KB_AT_6000_SV, "4/8/16KB-fil vid $6000..." },
/* tr */ { IDMS_4_8_16KB_AT_6000_TR, "4/8/16KB imaj $6000 adresinde..." },

/* en */ { IDMS_4_8KB_AT_A000,    "4/8KB image at $A000..." },
/* da */ { IDMS_4_8KB_AT_A000_DA, "4/8KB-image p $A000..." },
/* de */ { IDMS_4_8KB_AT_A000_DE, "4/8KB Image bei $A000..." },
/* es */ { IDMS_4_8KB_AT_A000_ES, "4/8KB imagen en $A000..." },
/* fr */ { IDMS_4_8KB_AT_A000_FR, "image 4/8 ko  $A000..." },
/* hu */ { IDMS_4_8KB_AT_A000_HU, "" },  /* fuzzy */
/* it */ { IDMS_4_8KB_AT_A000_IT, "Immagine di 4/8KB a $A000..." },
/* ko */ { IDMS_4_8KB_AT_A000_KO, "" },  /* fuzzy */
/* nl */ { IDMS_4_8KB_AT_A000_NL, "4/8KB bestand in $A000..." },
/* pl */ { IDMS_4_8KB_AT_A000_PL, "4/8KB obraz w $A000..." },
/* ru */ { IDMS_4_8KB_AT_A000_RU, "4/8KB image at $A000..." },
/* sv */ { IDMS_4_8KB_AT_A000_SV, "4/8KB-fil vid $A000..." },
/* tr */ { IDMS_4_8KB_AT_A000_TR, "4/8KB imaj $A000 adresinde..." },

/* en */ { IDMS_4KB_AT_B000,    "4KB image at $B000..." },
/* da */ { IDMS_4KB_AT_B000_DA, "4KB-image p $B000..." },
/* de */ { IDMS_4KB_AT_B000_DE, "4KB Image bei $B000..." },
/* es */ { IDMS_4KB_AT_B000_ES, "4KB imagen en $B000..." },
/* fr */ { IDMS_4KB_AT_B000_FR, "image 4 ko  $B000..." },
/* hu */ { IDMS_4KB_AT_B000_HU, "" },  /* fuzzy */
/* it */ { IDMS_4KB_AT_B000_IT, "Immagine di 4KB a $B000..." },
/* ko */ { IDMS_4KB_AT_B000_KO, "" },  /* fuzzy */
/* nl */ { IDMS_4KB_AT_B000_NL, "4KB bestand in $B000..." },
/* pl */ { IDMS_4KB_AT_B000_PL, "4KB obraz w $B000..." },
/* ru */ { IDMS_4KB_AT_B000_RU, "4KB image at $B000..." },
/* sv */ { IDMS_4KB_AT_B000_SV, "4KB-fil vid $B000..." },
/* tr */ { IDMS_4KB_AT_B000_TR, "4KB imaj $B000 adresinde..." },

/* en */ { IDMS_DETACH_CART_IMAGE,    "Detach cartridge image(s)" },
/* da */ { IDMS_DETACH_CART_IMAGE_DA, "Frakobl cartridge-image" },
/* de */ { IDMS_DETACH_CART_IMAGE_DE, "Erweiterungsmodul Image(s) entfernen" },
/* es */ { IDMS_DETACH_CART_IMAGE_ES, "Extraer imagen(es) cartucho" },
/* fr */ { IDMS_DETACH_CART_IMAGE_FR, "Dtacher une cartouche" },
/* hu */ { IDMS_DETACH_CART_IMAGE_HU, "Cartridge kpms(ok) levlasztsa" },
/* it */ { IDMS_DETACH_CART_IMAGE_IT, "Rimuovi le immagini delle cartucce" },
/* ko */ { IDMS_DETACH_CART_IMAGE_KO, "īƮ ̹ " },
/* nl */ { IDMS_DETACH_CART_IMAGE_NL, "Ontkoppel cartridge bestand(en)" },
/* pl */ { IDMS_DETACH_CART_IMAGE_PL, "Wysu obraz(y) kartrida" },
/* ru */ { IDMS_DETACH_CART_IMAGE_RU, "  " },
/* sv */ { IDMS_DETACH_CART_IMAGE_SV, "Koppla frn insticksmodulfil(er)" },
/* tr */ { IDMS_DETACH_CART_IMAGE_TR, "Kartu imaj(lar)n kart" },

/* en */ { IDMS_C0_LOW_IMAGE,    "C0 low  image..." },
/* da */ { IDMS_C0_LOW_IMAGE_DA, "C0 lav-image..." },
/* de */ { IDMS_C0_LOW_IMAGE_DE, "C0 low Image Datei..." },
/* es */ { IDMS_C0_LOW_IMAGE_ES, "Imagen C0 bajo..." },
/* fr */ { IDMS_C0_LOW_IMAGE_FR, "Image C0 basse..." },
/* hu */ { IDMS_C0_LOW_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_C0_LOW_IMAGE_IT, "Immagine C0 bassa..." },
/* ko */ { IDMS_C0_LOW_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C0_LOW_IMAGE_NL, "C0 low bestand..." },
/* pl */ { IDMS_C0_LOW_IMAGE_PL, "Obraz C0 low..." },
/* ru */ { IDMS_C0_LOW_IMAGE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C0_LOW_IMAGE_SV, "C0 lg-avbildning..." },
/* tr */ { IDMS_C0_LOW_IMAGE_TR, "C0 low  imaj..." },

/* en */ { IDMS_C0_HIGH_IMAGE,    "C0 high image..." },
/* da */ { IDMS_C0_HIGH_IMAGE_DA, "C0 hj-image..." },
/* de */ { IDMS_C0_HIGH_IMAGE_DE, "C0 high Image Datei..." },
/* es */ { IDMS_C0_HIGH_IMAGE_ES, "Imagen C0 alto..." },
/* fr */ { IDMS_C0_HIGH_IMAGE_FR, "Image C0 haute..." },
/* hu */ { IDMS_C0_HIGH_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_C0_HIGH_IMAGE_IT, "Immagine C0 alta..." },
/* ko */ { IDMS_C0_HIGH_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C0_HIGH_IMAGE_NL, "C0 high bestand..." },
/* pl */ { IDMS_C0_HIGH_IMAGE_PL, "Obraz C0 high..." },
/* ru */ { IDMS_C0_HIGH_IMAGE_RU, "C0 high image..." },
/* sv */ { IDMS_C0_HIGH_IMAGE_SV, "C0 hg-avbildning..." },
/* tr */ { IDMS_C0_HIGH_IMAGE_TR, "C0 high imaj..." },

/* en */ { IDMS_C1_LOW_IMAGE,    "C1 low  image..." },
/* da */ { IDMS_C1_LOW_IMAGE_DA, "C1 lav-image..." },
/* de */ { IDMS_C1_LOW_IMAGE_DE, "C1 low Image Datei..." },
/* es */ { IDMS_C1_LOW_IMAGE_ES, "C1 imagen bajo..." },
/* fr */ { IDMS_C1_LOW_IMAGE_FR, "Image C1 basse..." },
/* hu */ { IDMS_C1_LOW_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_C1_LOW_IMAGE_IT, "Immagine C1 bassa..." },
/* ko */ { IDMS_C1_LOW_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C1_LOW_IMAGE_NL, "C1 low bestand..." },
/* pl */ { IDMS_C1_LOW_IMAGE_PL, "Obraz C1 low..." },
/* ru */ { IDMS_C1_LOW_IMAGE_RU, "C1 low  image..." },
/* sv */ { IDMS_C1_LOW_IMAGE_SV, "C1 lg-avbildning..." },
/* tr */ { IDMS_C1_LOW_IMAGE_TR, "C1 low  imaj..." },

/* en */ { IDMS_C1_HIGH_IMAGE,    "C1 high image..." },
/* da */ { IDMS_C1_HIGH_IMAGE_DA, "C1 hj-image..." },
/* de */ { IDMS_C1_HIGH_IMAGE_DE, "C1 high Image Datei..." },
/* es */ { IDMS_C1_HIGH_IMAGE_ES, "C1 imagen alto..." },
/* fr */ { IDMS_C1_HIGH_IMAGE_FR, "Image C1 haute..." },
/* hu */ { IDMS_C1_HIGH_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_C1_HIGH_IMAGE_IT, "Immagine C1 alta..." },
/* ko */ { IDMS_C1_HIGH_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C1_HIGH_IMAGE_NL, "C1 high bestand..." },
/* pl */ { IDMS_C1_HIGH_IMAGE_PL, "Obraz C1 high..." },
/* ru */ { IDMS_C1_HIGH_IMAGE_RU, "C1 high image..." },
/* sv */ { IDMS_C1_HIGH_IMAGE_SV, "C1 hg-avbildning..." },
/* tr */ { IDMS_C1_HIGH_IMAGE_TR, "C1 high imaj..." },

/* en */ { IDMS_C2_LOW_IMAGE,    "C2 low  image..." },
/* da */ { IDMS_C2_LOW_IMAGE_DA, "C2 lav-image..." },
/* de */ { IDMS_C2_LOW_IMAGE_DE, "C2 low  Image Datei..." },
/* es */ { IDMS_C2_LOW_IMAGE_ES, "C2 imagen bajo..." },
/* fr */ { IDMS_C2_LOW_IMAGE_FR, "Image C2 basse..." },
/* hu */ { IDMS_C2_LOW_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_C2_LOW_IMAGE_IT, "Immagine C2 bassa..." },
/* ko */ { IDMS_C2_LOW_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C2_LOW_IMAGE_NL, "C2 low bestand..." },
/* pl */ { IDMS_C2_LOW_IMAGE_PL, "Obraz C2 low..." },
/* ru */ { IDMS_C2_LOW_IMAGE_RU, "C2 low  image..." },
/* sv */ { IDMS_C2_LOW_IMAGE_SV, "C2 lg-avbildning..." },
/* tr */ { IDMS_C2_LOW_IMAGE_TR, "C2 low  imaj..." },

/* en */ { IDMS_C2_HIGH_IMAGE,    "C2 high image..." },
/* da */ { IDMS_C2_HIGH_IMAGE_DA, "C2 hj-image..." },
/* de */ { IDMS_C2_HIGH_IMAGE_DE, "C2 high Image Datei..." },
/* es */ { IDMS_C2_HIGH_IMAGE_ES, "C2 imagen alto..." },
/* fr */ { IDMS_C2_HIGH_IMAGE_FR, "Image C2 haute..." },
/* hu */ { IDMS_C2_HIGH_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_C2_HIGH_IMAGE_IT, "Immagine C2 alta..." },
/* ko */ { IDMS_C2_HIGH_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C2_HIGH_IMAGE_NL, "C2 high bestand..." },
/* pl */ { IDMS_C2_HIGH_IMAGE_PL, "Obraz C2 low..." },
/* ru */ { IDMS_C2_HIGH_IMAGE_RU, "C2 high image..." },
/* sv */ { IDMS_C2_HIGH_IMAGE_SV, "C2 hg-avbildning..." },
/* tr */ { IDMS_C2_HIGH_IMAGE_TR, "C2 high imaj..." },

/* en */ { IDMS_FUNCTION_LOW_3PLUS1,    "Function low  image (3plus1)..." },
/* da */ { IDMS_FUNCTION_LOW_3PLUS1_DA, "Funktion lav-image (3plus1)..." },
/* de */ { IDMS_FUNCTION_LOW_3PLUS1_DE, "Funktions ROM Image Datei low (3plus1)..." },
/* es */ { IDMS_FUNCTION_LOW_3PLUS1_ES, "Funcin imagen bajo (3plus1)..." },
/* fr */ { IDMS_FUNCTION_LOW_3PLUS1_FR, "Image Fonction basse (3plus1)..." },
/* hu */ { IDMS_FUNCTION_LOW_3PLUS1_HU, "" },  /* fuzzy */
/* it */ { IDMS_FUNCTION_LOW_3PLUS1_IT, "Immagine Function low (3plus1)..." },
/* ko */ { IDMS_FUNCTION_LOW_3PLUS1_KO, "" },  /* fuzzy */
/* nl */ { IDMS_FUNCTION_LOW_3PLUS1_NL, "Function low bestand (3plus1)..." },
/* pl */ { IDMS_FUNCTION_LOW_3PLUS1_PL, "Obraz Function low (3plus1)..." },
/* ru */ { IDMS_FUNCTION_LOW_3PLUS1_RU, "" },  /* fuzzy */
/* sv */ { IDMS_FUNCTION_LOW_3PLUS1_SV, "Funktion lg-avbildning (3plus1)..." },
/* tr */ { IDMS_FUNCTION_LOW_3PLUS1_TR, "Function low  imaj (3plus1)..." },

/* en */ { IDMS_FUNCTION_HIGH_3PLUS1,    "Function high image (3plus1)..." },
/* da */ { IDMS_FUNCTION_HIGH_3PLUS1_DA, "Funktion hj-image (3plus1)..." },
/* de */ { IDMS_FUNCTION_HIGH_3PLUS1_DE, "Funktions ROM Image Datei high (3plus1)..." },
/* es */ { IDMS_FUNCTION_HIGH_3PLUS1_ES, "Funcin imagen alto (3plus1)..." },
/* fr */ { IDMS_FUNCTION_HIGH_3PLUS1_FR, "Image Fonction haute (3plus1)..." },
/* hu */ { IDMS_FUNCTION_HIGH_3PLUS1_HU, "" },  /* fuzzy */
/* it */ { IDMS_FUNCTION_HIGH_3PLUS1_IT, "Immagine Function high (3plus1)..." },
/* ko */ { IDMS_FUNCTION_HIGH_3PLUS1_KO, "" },  /* fuzzy */
/* nl */ { IDMS_FUNCTION_HIGH_3PLUS1_NL, "Function high bestand (3plus1)..." },
/* pl */ { IDMS_FUNCTION_HIGH_3PLUS1_PL, "Obraz Function high (3plus1)..." },
/* ru */ { IDMS_FUNCTION_HIGH_3PLUS1_RU, "" },  /* fuzzy */
/* sv */ { IDMS_FUNCTION_HIGH_3PLUS1_SV, "Funktion hg-avbildning (3plus1)..." },
/* tr */ { IDMS_FUNCTION_HIGH_3PLUS1_TR, "Function high imaj (3plus1)..." },

/* en */ { IDMS_LOAD_CART_1XXX,    "Load new Cart $1***" },
/* da */ { IDMS_LOAD_CART_1XXX_DA, "Indls nyt cartridge $1***" },
/* de */ { IDMS_LOAD_CART_1XXX_DE, "Modul bei $1*** laden" },
/* es */ { IDMS_LOAD_CART_1XXX_ES, "Cargar nuevo Cart $1***" },
/* fr */ { IDMS_LOAD_CART_1XXX_FR, "Charger la cartouche $1***" },
/* hu */ { IDMS_LOAD_CART_1XXX_HU, "j Cart. betltse a $1*** cmre" },
/* it */ { IDMS_LOAD_CART_1XXX_IT, "Carica nuova cartuccia $1***" },
/* ko */ { IDMS_LOAD_CART_1XXX_KO, "" },  /* fuzzy */
/* nl */ { IDMS_LOAD_CART_1XXX_NL, "Laad nieuw Cart $1***" },
/* pl */ { IDMS_LOAD_CART_1XXX_PL, "Wczytaj nowy kartrid $1***" },
/* ru */ { IDMS_LOAD_CART_1XXX_RU, "   $1***" },
/* sv */ { IDMS_LOAD_CART_1XXX_SV, "Ls ny insticksmodul $1***" },
/* tr */ { IDMS_LOAD_CART_1XXX_TR, "Yeni Kartu $1*** ykle" },

/* en */ { IDMS_UNLOAD_CART_1XXX,    "Unload Cart $1***" },
/* da */ { IDMS_UNLOAD_CART_1XXX_DA, "Afbryd cartridge $1***" },
/* de */ { IDMS_UNLOAD_CART_1XXX_DE, "Modul bei $1*** entfernen" },
/* es */ { IDMS_UNLOAD_CART_1XXX_ES, "Extraer Cart $1***" },
/* fr */ { IDMS_UNLOAD_CART_1XXX_FR, "Dcharger la cassette $1***" },
/* hu */ { IDMS_UNLOAD_CART_1XXX_HU, "Cart. levlasztsa a $1*** cmrl" },
/* it */ { IDMS_UNLOAD_CART_1XXX_IT, "Scarica cartuccia $1***" },
/* ko */ { IDMS_UNLOAD_CART_1XXX_KO, "" },  /* fuzzy */
/* nl */ { IDMS_UNLOAD_CART_1XXX_NL, "Verwijder Cart $1***" },
/* pl */ { IDMS_UNLOAD_CART_1XXX_PL, "Usu kartrid $1***" },
/* ru */ { IDMS_UNLOAD_CART_1XXX_RU, "  $1***" },
/* sv */ { IDMS_UNLOAD_CART_1XXX_SV, "Ls ur insticksmodul $1***" },
/* tr */ { IDMS_UNLOAD_CART_1XXX_TR, "Kartu $1*** kaldr" },

/* en */ { IDMS_LOAD_CART_2_3XXX,    "Load new Cart $2-3***" },
/* da */ { IDMS_LOAD_CART_2_3XXX_DA, "Indls nyt cartridge $2-3***" },
/* de */ { IDMS_LOAD_CART_2_3XXX_DE, "Modul bei $2-3*** laden" },
/* es */ { IDMS_LOAD_CART_2_3XXX_ES, "Cargar nuevo Cart $2-3***" },
/* fr */ { IDMS_LOAD_CART_2_3XXX_FR, "Charger la cartouche $2-3***" },
/* hu */ { IDMS_LOAD_CART_2_3XXX_HU, "j Cart. betltse a $2-$3*** cmre" },
/* it */ { IDMS_LOAD_CART_2_3XXX_IT, "Carica nuova cartuccia $2-3***" },
/* ko */ { IDMS_LOAD_CART_2_3XXX_KO, "" },  /* fuzzy */
/* nl */ { IDMS_LOAD_CART_2_3XXX_NL, "Laad nieuw Cart $2-3***" },
/* pl */ { IDMS_LOAD_CART_2_3XXX_PL, "Wczytaj nowy kartrid $2-3***" },
/* ru */ { IDMS_LOAD_CART_2_3XXX_RU, "   $2-3***" },
/* sv */ { IDMS_LOAD_CART_2_3XXX_SV, "Ls ny insticksmodul $2-3***" },
/* tr */ { IDMS_LOAD_CART_2_3XXX_TR, "Yeni Kartu $2-3*** ykle" },

/* en */ { IDMS_UNLOAD_CART_2_3XXX,    "Unload Cart $2-3***" },
/* da */ { IDMS_UNLOAD_CART_2_3XXX_DA, "Afbryd cartridge $2-3***" },
/* de */ { IDMS_UNLOAD_CART_2_3XXX_DE, "Modul bei $2-3*** entfernen" },
/* es */ { IDMS_UNLOAD_CART_2_3XXX_ES, "Extraer Cart $2-3***" },
/* fr */ { IDMS_UNLOAD_CART_2_3XXX_FR, "Dcharger la cassette $2-3***" },
/* hu */ { IDMS_UNLOAD_CART_2_3XXX_HU, "Cart. levlasztsa a $2-3*** cmrl" },
/* it */ { IDMS_UNLOAD_CART_2_3XXX_IT, "Scarica cartuccia $2-3***" },
/* ko */ { IDMS_UNLOAD_CART_2_3XXX_KO, "" },  /* fuzzy */
/* nl */ { IDMS_UNLOAD_CART_2_3XXX_NL, "Verwijder Cart $2-3***" },
/* pl */ { IDMS_UNLOAD_CART_2_3XXX_PL, "Usu kartrid $2-3***" },
/* ru */ { IDMS_UNLOAD_CART_2_3XXX_RU, "  $2-3***" },
/* sv */ { IDMS_UNLOAD_CART_2_3XXX_SV, "Ls ur insticksmodul $2-3***" },
/* tr */ { IDMS_UNLOAD_CART_2_3XXX_TR, "Kartu $2-3*** kaldr" },

/* en */ { IDMS_LOAD_CART_4_5XXX,    "Load new Cart $4-5***" },
/* da */ { IDMS_LOAD_CART_4_5XXX_DA, "Indls nyt cartridge $4-5***" },
/* de */ { IDMS_LOAD_CART_4_5XXX_DE, "Modul bei $4-5*** laden" },
/* es */ { IDMS_LOAD_CART_4_5XXX_ES, "Cargar nuevo Cart $4-5***" },
/* fr */ { IDMS_LOAD_CART_4_5XXX_FR, "Charger la cartouche $4-5***" },
/* hu */ { IDMS_LOAD_CART_4_5XXX_HU, "j Cart. betltse a $4-$5*** cmre" },
/* it */ { IDMS_LOAD_CART_4_5XXX_IT, "Carica nuova cartuccia $4-5***" },
/* ko */ { IDMS_LOAD_CART_4_5XXX_KO, "" },  /* fuzzy */
/* nl */ { IDMS_LOAD_CART_4_5XXX_NL, "Laad nieuw Cart $4-5***" },
/* pl */ { IDMS_LOAD_CART_4_5XXX_PL, "Wczytaj nowy kartrid $4-5***" },
/* ru */ { IDMS_LOAD_CART_4_5XXX_RU, "   $4-5***" },
/* sv */ { IDMS_LOAD_CART_4_5XXX_SV, "Ls ny insticksmodul $4-5***" },
/* tr */ { IDMS_LOAD_CART_4_5XXX_TR, "Yeni Kartu $4-5*** ykle" },

/* en */ { IDMS_UNLOAD_CART_4_5XXX,    "Unload Cart $4-5***" },
/* da */ { IDMS_UNLOAD_CART_4_5XXX_DA, "Afbryd cartridge $4-5***" },
/* de */ { IDMS_UNLOAD_CART_4_5XXX_DE, "Modul bei $4-5*** entfernen" },
/* es */ { IDMS_UNLOAD_CART_4_5XXX_ES, "Extraer Cart $4-5***" },
/* fr */ { IDMS_UNLOAD_CART_4_5XXX_FR, "Dcharger la cassette $4-5***" },
/* hu */ { IDMS_UNLOAD_CART_4_5XXX_HU, "Cart. levlasztsa a $4-5*** cmrl" },
/* it */ { IDMS_UNLOAD_CART_4_5XXX_IT, "Scarica cartuccia $4-5***" },
/* ko */ { IDMS_UNLOAD_CART_4_5XXX_KO, "" },  /* fuzzy */
/* nl */ { IDMS_UNLOAD_CART_4_5XXX_NL, "Verwijder Cart $4-5***" },
/* pl */ { IDMS_UNLOAD_CART_4_5XXX_PL, "Usu kartrid $4-5***" },
/* ru */ { IDMS_UNLOAD_CART_4_5XXX_RU, "  $4-5***" },
/* sv */ { IDMS_UNLOAD_CART_4_5XXX_SV, "Ls ur insticksmodul $4-5***" },
/* tr */ { IDMS_UNLOAD_CART_4_5XXX_TR, "Kartu $4-5*** kaldr" },

/* en */ { IDMS_LOAD_CART_6_7XXX,    "Load new Cart $6-7***" },
/* da */ { IDMS_LOAD_CART_6_7XXX_DA, "Indls nyt cartridge $6-7***" },
/* de */ { IDMS_LOAD_CART_6_7XXX_DE, "Modul bei $6-7*** laden" },
/* es */ { IDMS_LOAD_CART_6_7XXX_ES, "Cargar nuevo Cart $6-7***" },
/* fr */ { IDMS_LOAD_CART_6_7XXX_FR, "Charger la cartouche $6-7***" },
/* hu */ { IDMS_LOAD_CART_6_7XXX_HU, "j Cart. betltse a $6-$7*** cmre" },
/* it */ { IDMS_LOAD_CART_6_7XXX_IT, "Carica nuova cartuccia $6-7***" },
/* ko */ { IDMS_LOAD_CART_6_7XXX_KO, "" },  /* fuzzy */
/* nl */ { IDMS_LOAD_CART_6_7XXX_NL, "Laad nieuw Cart $6-7***" },
/* pl */ { IDMS_LOAD_CART_6_7XXX_PL, "Wczytaj nowy kartrid $6-7***" },
/* ru */ { IDMS_LOAD_CART_6_7XXX_RU, "   $6-7***" },
/* sv */ { IDMS_LOAD_CART_6_7XXX_SV, "Ls ny insticksmodul $6-7***" },
/* tr */ { IDMS_LOAD_CART_6_7XXX_TR, "Yeni Kartu $6-7*** ykle" },

/* en */ { IDMS_UNLOAD_CART_6_7XXX,    "Unload Cart $6-7***" },
/* da */ { IDMS_UNLOAD_CART_6_7XXX_DA, "Afbryd cartridge $6-7***" },
/* de */ { IDMS_UNLOAD_CART_6_7XXX_DE, "Modul bei $6-7*** entfernen" },
/* es */ { IDMS_UNLOAD_CART_6_7XXX_ES, "Extraer Cart $6-7***" },
/* fr */ { IDMS_UNLOAD_CART_6_7XXX_FR, "Dcharger la cassette $6-7***" },
/* hu */ { IDMS_UNLOAD_CART_6_7XXX_HU, "Cart. levlasztsa a $6-7*** cmrl" },
/* it */ { IDMS_UNLOAD_CART_6_7XXX_IT, "Scarica cartuccia $6-7***" },
/* ko */ { IDMS_UNLOAD_CART_6_7XXX_KO, "" },  /* fuzzy */
/* nl */ { IDMS_UNLOAD_CART_6_7XXX_NL, "Verwijder Cart $6-7***" },
/* pl */ { IDMS_UNLOAD_CART_6_7XXX_PL, "Usu kartrid $6-7***" },
/* ru */ { IDMS_UNLOAD_CART_6_7XXX_RU, "  $6-7***" },
/* sv */ { IDMS_UNLOAD_CART_6_7XXX_SV, "Ls ur insticksmodul $6-7***" },
/* tr */ { IDMS_UNLOAD_CART_6_7XXX_TR, "Kartu $6-7*** kaldr" },

/* en */ { IDMS_FUNCTION_HIGH_3PLUS1,    "Function high image (3plus1)..." },
/* da */ { IDMS_FUNCTION_HIGH_3PLUS1_DA, "Funktion hj-image (3plus1)..." },
/* de */ { IDMS_FUNCTION_HIGH_3PLUS1_DE, "Funktions ROM Image Datei high (3plus1)..." },
/* es */ { IDMS_FUNCTION_HIGH_3PLUS1_ES, "Funcin imagen alto (3plus1)..." },
/* fr */ { IDMS_FUNCTION_HIGH_3PLUS1_FR, "Image Fonction haute (3plus1)..." },
/* hu */ { IDMS_FUNCTION_HIGH_3PLUS1_HU, "" },  /* fuzzy */
/* it */ { IDMS_FUNCTION_HIGH_3PLUS1_IT, "Immagine Function high (3plus1)..." },
/* ko */ { IDMS_FUNCTION_HIGH_3PLUS1_KO, "" },  /* fuzzy */
/* nl */ { IDMS_FUNCTION_HIGH_3PLUS1_NL, "Function high bestand (3plus1)..." },
/* pl */ { IDMS_FUNCTION_HIGH_3PLUS1_PL, "Obraz Function high (3plus1)..." },
/* ru */ { IDMS_FUNCTION_HIGH_3PLUS1_RU, "" },  /* fuzzy */
/* sv */ { IDMS_FUNCTION_HIGH_3PLUS1_SV, "Funktion hg-avbildning (3plus1)..." },
/* tr */ { IDMS_FUNCTION_HIGH_3PLUS1_TR, "Function high imaj (3plus1)..." },

/* en */ { IDMS_CRT_IMAGE,    "CRT image..." },
/* da */ { IDMS_CRT_IMAGE_DA, "CRT-fil..." },
/* de */ { IDMS_CRT_IMAGE_DE, "CRT Image..." },
/* es */ { IDMS_CRT_IMAGE_ES, "Imagen CRT..." },
/* fr */ { IDMS_CRT_IMAGE_FR, "Image CRT..." },
/* hu */ { IDMS_CRT_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_CRT_IMAGE_IT, "Immagine CRT..." },
/* ko */ { IDMS_CRT_IMAGE_KO, "CRT ̹..." },
/* nl */ { IDMS_CRT_IMAGE_NL, "CRT bestand..." },
/* pl */ { IDMS_CRT_IMAGE_PL, "Obraz CRT..." },
/* ru */ { IDMS_CRT_IMAGE_RU, "CRT image..." },
/* sv */ { IDMS_CRT_IMAGE_SV, "CRT-fil..." },
/* tr */ { IDMS_CRT_IMAGE_TR, "CRT imaj..." },

/* en */ { IDMS_GENERIC_8KB_IMAGE,    "Generic 8KB image..." },
/* da */ { IDMS_GENERIC_8KB_IMAGE_DA, "Standard 8KB-image..." },
/* de */ { IDMS_GENERIC_8KB_IMAGE_DE, "Generisches 8kB Image..." },
/* es */ { IDMS_GENERIC_8KB_IMAGE_ES, "Imagen genrica 8KB..." },
/* fr */ { IDMS_GENERIC_8KB_IMAGE_FR, "Image gnrique 8 ko..." },
/* hu */ { IDMS_GENERIC_8KB_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_GENERIC_8KB_IMAGE_IT, "Immagine generica di 8KB..." },
/* ko */ { IDMS_GENERIC_8KB_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_GENERIC_8KB_IMAGE_NL, "Algemeen 8KB bestand..." },
/* pl */ { IDMS_GENERIC_8KB_IMAGE_PL, "Obraz Generic 8KB..." },
/* ru */ { IDMS_GENERIC_8KB_IMAGE_RU, "Generic 8KB image..." },
/* sv */ { IDMS_GENERIC_8KB_IMAGE_SV, "Vanlig 8KB-fil..." },
/* tr */ { IDMS_GENERIC_8KB_IMAGE_TR, "8KB Jenerik imaj..." },

/* en */ { IDMS_GENERIC_16KB_IMAGE,    "Generic 16KB image..." },
/* da */ { IDMS_GENERIC_16KB_IMAGE_DA, "Standard 16KB-image..." },
/* de */ { IDMS_GENERIC_16KB_IMAGE_DE, "Generisches 16kB Image..." },
/* es */ { IDMS_GENERIC_16KB_IMAGE_ES, "Imagen genrica 16KB..." },
/* fr */ { IDMS_GENERIC_16KB_IMAGE_FR, "Image gnrique 16 ko..." },
/* hu */ { IDMS_GENERIC_16KB_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_GENERIC_16KB_IMAGE_IT, "Immagine generica di 16KB..." },
/* ko */ { IDMS_GENERIC_16KB_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_GENERIC_16KB_IMAGE_NL, "Algemeen 16KB bestand..." },
/* pl */ { IDMS_GENERIC_16KB_IMAGE_PL, "Obraz Generic 16KB..." },
/* ru */ { IDMS_GENERIC_16KB_IMAGE_RU, "Generic 16KB image..." },
/* sv */ { IDMS_GENERIC_16KB_IMAGE_SV, "Vanlig 16KB-fil..." },
/* tr */ { IDMS_GENERIC_16KB_IMAGE_TR, "16KB Jenerik imaj..." },

/* en */ { IDMS_ACTION_REPLAY_IMAGE,    "Action Replay image..." },
/* da */ { IDMS_ACTION_REPLAY_IMAGE_DA, "Action Replay-image..." },
/* de */ { IDMS_ACTION_REPLAY_IMAGE_DE, "Action Replay Image..." },
/* es */ { IDMS_ACTION_REPLAY_IMAGE_ES, "Imagen Action Replay..." },
/* fr */ { IDMS_ACTION_REPLAY_IMAGE_FR, "Image Action Replay..." },
/* hu */ { IDMS_ACTION_REPLAY_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_ACTION_REPLAY_IMAGE_IT, "Immagine Action Replay..." },
/* ko */ { IDMS_ACTION_REPLAY_IMAGE_KO, "Action Replay ̹..." },
/* nl */ { IDMS_ACTION_REPLAY_IMAGE_NL, "Action Replay bestand..." },
/* pl */ { IDMS_ACTION_REPLAY_IMAGE_PL, "Obraz Action Replay..." },
/* ru */ { IDMS_ACTION_REPLAY_IMAGE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_ACTION_REPLAY_IMAGE_SV, "Action Replay-fil..." },
/* tr */ { IDMS_ACTION_REPLAY_IMAGE_TR, "Action Replay imaj..." },

/* en */ { IDMS_ACTION_REPLAY3_IMAGE,    "Action Replay MK3 image..." },
/* da */ { IDMS_ACTION_REPLAY3_IMAGE_DA, "Action Replay MK3 image..." },
/* de */ { IDMS_ACTION_REPLAY3_IMAGE_DE, "Action Replay MK3 Image..." },
/* es */ { IDMS_ACTION_REPLAY3_IMAGE_ES, "Imagen Action Replay MK3..." },
/* fr */ { IDMS_ACTION_REPLAY3_IMAGE_FR, "Image Action Replay MK3..." },
/* hu */ { IDMS_ACTION_REPLAY3_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_ACTION_REPLAY3_IMAGE_IT, "Immagine Action Replay MK3..." },
/* ko */ { IDMS_ACTION_REPLAY3_IMAGE_KO, "Action Replay MK3 ̹..." },
/* nl */ { IDMS_ACTION_REPLAY3_IMAGE_NL, "Action Replay MK3 bestand..." },
/* pl */ { IDMS_ACTION_REPLAY3_IMAGE_PL, "Obraz Action Replay MK3..." },
/* ru */ { IDMS_ACTION_REPLAY3_IMAGE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_ACTION_REPLAY3_IMAGE_SV, "Action Replay MK3-fil..." },
/* tr */ { IDMS_ACTION_REPLAY3_IMAGE_TR, "Action Replay MK3 imaj..." },

/* en */ { IDMS_ACTION_REPLAY4_IMAGE,    "Action Replay MK4 image..." },
/* da */ { IDMS_ACTION_REPLAY4_IMAGE_DA, "Action Replay MK4 image..." },
/* de */ { IDMS_ACTION_REPLAY4_IMAGE_DE, "Action Replay MK4 Image..." },
/* es */ { IDMS_ACTION_REPLAY4_IMAGE_ES, "Imagen Action Replay MK4..." },
/* fr */ { IDMS_ACTION_REPLAY4_IMAGE_FR, "Image Action Replay MK4..." },
/* hu */ { IDMS_ACTION_REPLAY4_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_ACTION_REPLAY4_IMAGE_IT, "Immagine Action Replay MK4..." },
/* ko */ { IDMS_ACTION_REPLAY4_IMAGE_KO, "Action Replay MK4 ̹..." },
/* nl */ { IDMS_ACTION_REPLAY4_IMAGE_NL, "Action Replay MK4 bestand..." },
/* pl */ { IDMS_ACTION_REPLAY4_IMAGE_PL, "Obraz Action Replay MK4..." },
/* ru */ { IDMS_ACTION_REPLAY4_IMAGE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_ACTION_REPLAY4_IMAGE_SV, "Action Replay MK4-fil..." },
/* tr */ { IDMS_ACTION_REPLAY4_IMAGE_TR, "Action Replay MK4 imaj..." },

/* en */ { IDMS_STARDOS_IMAGE,    "Stardos image..." },
/* da */ { IDMS_STARDOS_IMAGE_DA, "Stardos image..." },
/* de */ { IDMS_STARDOS_IMAGE_DE, "Stardos Image..." },
/* es */ { IDMS_STARDOS_IMAGE_ES, "Imagen Stardos..." },
/* fr */ { IDMS_STARDOS_IMAGE_FR, "Image Stardos..." },
/* hu */ { IDMS_STARDOS_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_STARDOS_IMAGE_IT, "Immagine Stardos..." },
/* ko */ { IDMS_STARDOS_IMAGE_KO, "Stardos ̹..." },
/* nl */ { IDMS_STARDOS_IMAGE_NL, "Stardos bestand..." },
/* pl */ { IDMS_STARDOS_IMAGE_PL, "Obraz Stardos..." },
/* ru */ { IDMS_STARDOS_IMAGE_RU, "Stardos image..." },
/* sv */ { IDMS_STARDOS_IMAGE_SV, "Stardos-fil..." },
/* tr */ { IDMS_STARDOS_IMAGE_TR, "Stardos imaj..." },

/* en */ { IDMS_ATOMIC_POWER_IMAGE,    "Atomic Power image..." },
/* da */ { IDMS_ATOMIC_POWER_IMAGE_DA, "Atomic Power-image..." },
/* de */ { IDMS_ATOMIC_POWER_IMAGE_DE, "Atomic Power Image..." },
/* es */ { IDMS_ATOMIC_POWER_IMAGE_ES, "Imagen Atomic Power..." },
/* fr */ { IDMS_ATOMIC_POWER_IMAGE_FR, "Image Atomic Power..." },
/* hu */ { IDMS_ATOMIC_POWER_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_ATOMIC_POWER_IMAGE_IT, "Immagine Atomic Power..." },
/* ko */ { IDMS_ATOMIC_POWER_IMAGE_KO, "Atomic Power ̹..." },
/* nl */ { IDMS_ATOMIC_POWER_IMAGE_NL, "Atomic Power bestand..." },
/* pl */ { IDMS_ATOMIC_POWER_IMAGE_PL, "Obraz Atomic Power..." },
/* ru */ { IDMS_ATOMIC_POWER_IMAGE_RU, "Atomic Power image..." },
/* sv */ { IDMS_ATOMIC_POWER_IMAGE_SV, "Atomic Power-fil..." },
/* tr */ { IDMS_ATOMIC_POWER_IMAGE_TR, "Atomic Power imaj..." },

/* en */ { IDMS_EPYX_FASTLOAD_IMAGE,    "Epyx FastLoad image..." },
/* da */ { IDMS_EPYX_FASTLOAD_IMAGE_DA, "Epyx FastLoad image..." },
/* de */ { IDMS_EPYX_FASTLOAD_IMAGE_DE, "Epyx Fastload Image..." },
/* es */ { IDMS_EPYX_FASTLOAD_IMAGE_ES, "Imagen Epyx FastLoad..." },
/* fr */ { IDMS_EPYX_FASTLOAD_IMAGE_FR, "Image Epyx FastLoad..." },
/* hu */ { IDMS_EPYX_FASTLOAD_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_EPYX_FASTLOAD_IMAGE_IT, "Immagine Epyx FastLoad..." },
/* ko */ { IDMS_EPYX_FASTLOAD_IMAGE_KO, "Epyx FastLoad ̹..." },
/* nl */ { IDMS_EPYX_FASTLOAD_IMAGE_NL, "Epyx FastLoad bestand..." },
/* pl */ { IDMS_EPYX_FASTLOAD_IMAGE_PL, "Obraz Epyx FastLoad..." },
/* ru */ { IDMS_EPYX_FASTLOAD_IMAGE_RU, "Epyx FastLoad image..." },
/* sv */ { IDMS_EPYX_FASTLOAD_IMAGE_SV, "Epyx FastLoad-fil..." },
/* tr */ { IDMS_EPYX_FASTLOAD_IMAGE_TR, "Epyx FastLoad imaj..." },

/* en */ { IDMS_IEEE488_INTERFACE_IMAGE,    "IEEE488 Interface image..." },
/* da */ { IDMS_IEEE488_INTERFACE_IMAGE_DA, "IEEE488-interface image..." },
/* de */ { IDMS_IEEE488_INTERFACE_IMAGE_DE, "IEEE 488 Schnittstellenmodul..." },
/* es */ { IDMS_IEEE488_INTERFACE_IMAGE_ES, "Imagen perifrico IEEE 488..." },
/* fr */ { IDMS_IEEE488_INTERFACE_IMAGE_FR, "Image d'Interface IEEE-488..." },
/* hu */ { IDMS_IEEE488_INTERFACE_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_IEEE488_INTERFACE_IMAGE_IT, "Immagine interfaccia IEEE 488..." },
/* ko */ { IDMS_IEEE488_INTERFACE_IMAGE_KO, "IEEE488 ̽ ̹..." },
/* nl */ { IDMS_IEEE488_INTERFACE_IMAGE_NL, "IEEE488 interfacebestand..." },
/* pl */ { IDMS_IEEE488_INTERFACE_IMAGE_PL, "Obraz interfejsu IEEE488..." },
/* ru */ { IDMS_IEEE488_INTERFACE_IMAGE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_IEEE488_INTERFACE_IMAGE_SV, "IEEE488-grnssnittsfil..." },
/* tr */ { IDMS_IEEE488_INTERFACE_IMAGE_TR, "IEEE 488 Arabirimi imaj..." },

/* en */ { IDMS_RETRO_REPLAY_IMAGE,    "Retro Replay image..." },
/* da */ { IDMS_RETRO_REPLAY_IMAGE_DA, "Retro Replay-image..." },
/* de */ { IDMS_RETRO_REPLAY_IMAGE_DE, "Retro Replay Image..." },
/* es */ { IDMS_RETRO_REPLAY_IMAGE_ES, "Imagen Retro Replay..." },
/* fr */ { IDMS_RETRO_REPLAY_IMAGE_FR, "Image Retro Replay..." },
/* hu */ { IDMS_RETRO_REPLAY_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_RETRO_REPLAY_IMAGE_IT, "Immagine Retro Replay..." },
/* ko */ { IDMS_RETRO_REPLAY_IMAGE_KO, "Retro Replay ̹..." },
/* nl */ { IDMS_RETRO_REPLAY_IMAGE_NL, "Retro Replay bestand..." },
/* pl */ { IDMS_RETRO_REPLAY_IMAGE_PL, "Obraz Retro Replay..." },
/* ru */ { IDMS_RETRO_REPLAY_IMAGE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_RETRO_REPLAY_IMAGE_SV, "Retro Replay-fil..." },
/* tr */ { IDMS_RETRO_REPLAY_IMAGE_TR, "Retro Replay imaj..." },

/* en */ { IDMS_IDE64_INTERFACE_IMAGE,    "IDE64 interface image..." },
/* da */ { IDMS_IDE64_INTERFACE_IMAGE_DA, "IDE64-interface image..." },
/* de */ { IDMS_IDE64_INTERFACE_IMAGE_DE, "IDE64 Schnittstellenmodul..." },
/* es */ { IDMS_IDE64_INTERFACE_IMAGE_ES, "Imagen interface IDE64..." },
/* fr */ { IDMS_IDE64_INTERFACE_IMAGE_FR, "Image d'Interface IDE64..." },
/* hu */ { IDMS_IDE64_INTERFACE_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_IDE64_INTERFACE_IMAGE_IT, "Immagine interfaccia IDE64..." },
/* ko */ { IDMS_IDE64_INTERFACE_IMAGE_KO, "IDE64 ̽ ̹..." },
/* nl */ { IDMS_IDE64_INTERFACE_IMAGE_NL, "IDE64 interfacebestand..." },
/* pl */ { IDMS_IDE64_INTERFACE_IMAGE_PL, "Obraz interfejsu IDE64..." },
/* ru */ { IDMS_IDE64_INTERFACE_IMAGE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_IDE64_INTERFACE_IMAGE_SV, "IDE64-grnssnittsfil..." },
/* tr */ { IDMS_IDE64_INTERFACE_IMAGE_TR, "IDE64 arabirim imaj..." },

/* en */ { IDMS_SUPER_SNAPSHOT_4_IMAGE,    "Super Snapshot V4 image..." },
/* da */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_DA, "Super Snapshot V4 image..." },
/* de */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_DE, "Super Snapshot V4 Image..." },
/* es */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_ES, "Imagen Super Snapshot V4..." },
/* fr */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_FR, "Image Super Snapshot V4..." },
/* hu */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_IT, "Immagine Super Snapshot V4..." },
/* ko */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_KO, "Super Snapshot V4 ̹..." },
/* nl */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_NL, "Super Snapshot V4 bestand..." },
/* pl */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_PL, "Obraz Super Snapshot V4..." },
/* ru */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_RU, "Super Snapshot V4 image..." },
/* sv */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_SV, "Super Snapshot V4-fil..." },
/* tr */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_TR, "Super Snapshot V4 imaj..." },

/* en */ { IDMS_SUPER_SNAPSHOT_5_IMAGE,    "Super Snapshot V5 image..." },
/* da */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_DA, "Super Snapshot V5 image..." },
/* de */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_DE, "Super Snapshot V5 Image..." },
/* es */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_ES, "Imagen Super Snapshot V5..." },
/* fr */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_FR, "Image Super Snapshot V5..." },
/* hu */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_IT, "Immagine Super Snapshot V5..." },
/* ko */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_KO, "Super Snapshot V5 ̹..." },
/* nl */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_NL, "Super Snapshot V5 bestand..." },
/* pl */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_PL, "Obraz Super Snapshot V5..." },
/* ru */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_RU, "Super Snapshot V5 image..." },
/* sv */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_SV, "Super Snapshot V5-fil..." },
/* tr */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_TR, "Super Snapshot V5 imaj..." },

/* en */ { IDMS_STRUCTURED_BASIC_IMAGE,    "Structured BASIC image..." },
/* da */ { IDMS_STRUCTURED_BASIC_IMAGE_DA, "Structured BASIC-image..." },
/* de */ { IDMS_STRUCTURED_BASIC_IMAGE_DE, "Structured Basic Image..." },
/* es */ { IDMS_STRUCTURED_BASIC_IMAGE_ES, "Imagen Structured BASIC..." },
/* fr */ { IDMS_STRUCTURED_BASIC_IMAGE_FR, "Image BASIC structure..." },
/* hu */ { IDMS_STRUCTURED_BASIC_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_STRUCTURED_BASIC_IMAGE_IT, "Immagine Structured BASIC..." },
/* ko */ { IDMS_STRUCTURED_BASIC_IMAGE_KO, "Structured BASIC ̹..." },
/* nl */ { IDMS_STRUCTURED_BASIC_IMAGE_NL, "Structured BASIC bestand..." },
/* pl */ { IDMS_STRUCTURED_BASIC_IMAGE_PL, "Obraz Structured BASIC..." },
/* ru */ { IDMS_STRUCTURED_BASIC_IMAGE_RU, "Structured BASIC image..." },
/* sv */ { IDMS_STRUCTURED_BASIC_IMAGE_SV, "Structured BASIC-fil..." },
/* tr */ { IDMS_STRUCTURED_BASIC_IMAGE_TR, "Structured BASIC imaj..." },

/* en */ { IDMS_ENABLE,    "Enable" },
/* da */ { IDMS_ENABLE_DA, "Aktivr" },
/* de */ { IDMS_ENABLE_DE, "Aktivieren" },
/* es */ { IDMS_ENABLE_ES, "Permitir" },
/* fr */ { IDMS_ENABLE_FR, "Activer" },
/* hu */ { IDMS_ENABLE_HU, "Engedlyezs" },
/* it */ { IDMS_ENABLE_IT, "Attiva" },
/* ko */ { IDMS_ENABLE_KO, "۵Ű" },
/* nl */ { IDMS_ENABLE_NL, "Activeer" },
/* pl */ { IDMS_ENABLE_PL, "Wcz" },
/* ru */ { IDMS_ENABLE_RU, "" },
/* sv */ { IDMS_ENABLE_SV, "Aktivera" },
/* tr */ { IDMS_ENABLE_TR, "Aktif Et" },

/* en */ { IDMS_SET_CART_AS_DEFAULT,    "Set cartridge as default" },
/* da */ { IDMS_SET_CART_AS_DEFAULT_DA, "Vlg cartridge som standard" },
/* de */ { IDMS_SET_CART_AS_DEFAULT_DE, "Aktuelles Erweiterungsmodul als Standard aktivieren" },
/* es */ { IDMS_SET_CART_AS_DEFAULT_ES, "Usar cartucho por defecto" },
/* fr */ { IDMS_SET_CART_AS_DEFAULT_FR, "Dfinir cette cartouche par dfaut" },
/* hu */ { IDMS_SET_CART_AS_DEFAULT_HU, "Cartridge alaprtelmezett ttele" },
/* it */ { IDMS_SET_CART_AS_DEFAULT_IT, "Imposta la cartuccia come predefinita" },
/* ko */ { IDMS_SET_CART_AS_DEFAULT_KO, "īƮ Ʈ  ϱ" },
/* nl */ { IDMS_SET_CART_AS_DEFAULT_NL, "Zet cartridge als standaard" },
/* pl */ { IDMS_SET_CART_AS_DEFAULT_PL, "Ustaw kartrid jako domylny" },
/* ru */ { IDMS_SET_CART_AS_DEFAULT_RU, "   " },
/* sv */ { IDMS_SET_CART_AS_DEFAULT_SV, "Vlj insticksmodul som frval" },
/* tr */ { IDMS_SET_CART_AS_DEFAULT_TR, "Kartuu varsaylan yap" },

/* en */ { IDMS_RESET_ON_CART_CHANGE,    "Reset on cart change" },
/* da */ { IDMS_RESET_ON_CART_CHANGE_DA, "Reset ved cartridge-skift" },
/* de */ { IDMS_RESET_ON_CART_CHANGE_DE, "Reset bei Wechsel von Erweiterungsmodulen" },
/* es */ { IDMS_RESET_ON_CART_CHANGE_ES, "Reiniciar al cambiar cartucho" },
/* fr */ { IDMS_RESET_ON_CART_CHANGE_FR, "Rinialiser sur changement de cartouche" },
/* hu */ { IDMS_RESET_ON_CART_CHANGE_HU, "jraindts cartridge csernl" },
/* it */ { IDMS_RESET_ON_CART_CHANGE_IT, "Reset al cambio di cartuccia" },
/* ko */ { IDMS_RESET_ON_CART_CHANGE_KO, "īƮ  " },
/* nl */ { IDMS_RESET_ON_CART_CHANGE_NL, "Reset bij cartwisseling" },
/* pl */ { IDMS_RESET_ON_CART_CHANGE_PL, "Restart przy zmianie kartrida" },
/* ru */ { IDMS_RESET_ON_CART_CHANGE_RU, "Reset on cart change" },
/* sv */ { IDMS_RESET_ON_CART_CHANGE_SV, "Nollstll vid modulbyte" },
/* tr */ { IDMS_RESET_ON_CART_CHANGE_TR, "Kartu deiiminde resetle" },

/* en */ { IDMS_CART_FREEZE,    "Cartridge freeze" },
/* da */ { IDMS_CART_FREEZE_DA, "Cartridgets frys-funktion" },
/* de */ { IDMS_CART_FREEZE_DE, "Erweiterungsmodul Freeze" },
/* es */ { IDMS_CART_FREEZE_ES, "Congelar cartucho" },
/* fr */ { IDMS_CART_FREEZE_FR, "Geler la cartouche" },
/* hu */ { IDMS_CART_FREEZE_HU, "Fagyaszts Cartridge-dzsel" },
/* it */ { IDMS_CART_FREEZE_IT, "Freeze cartuccia" },
/* ko */ { IDMS_CART_FREEZE_KO, "īƮ " },
/* nl */ { IDMS_CART_FREEZE_NL, "Cartridge freeze" },
/* pl */ { IDMS_CART_FREEZE_PL, "Zamroenie kartrida" },
/* ru */ { IDMS_CART_FREEZE_RU, "Cartridge freeze" },
/* sv */ { IDMS_CART_FREEZE_SV, "Insticksmodulens frysfunktion" },
/* tr */ { IDMS_CART_FREEZE_TR, "Kartu freeze" },

/* en */ { IDMS_PAUSE,    "Pause" },
/* da */ { IDMS_PAUSE_DA, "Pause" },
/* de */ { IDMS_PAUSE_DE, "Pause" },
/* es */ { IDMS_PAUSE_ES, "Pausa" },
/* fr */ { IDMS_PAUSE_FR, "Pause" },
/* hu */ { IDMS_PAUSE_HU, "Sznet" },
/* it */ { IDMS_PAUSE_IT, "Pausa" },
/* ko */ { IDMS_PAUSE_KO, "Ͻ" },
/* nl */ { IDMS_PAUSE_NL, "Pauze" },
/* pl */ { IDMS_PAUSE_PL, "Pauza" },
/* ru */ { IDMS_PAUSE_RU, "" },
/* sv */ { IDMS_PAUSE_SV, "Paus" },
/* tr */ { IDMS_PAUSE_TR, "Duraklat" },

/* en */ { IDMS_SINGLE_FRAME_ADVANCE,    "Single frame advance" },
/* da */ { IDMS_SINGLE_FRAME_ADVANCE_DA, "" },  /* fuzzy */
/* de */ { IDMS_SINGLE_FRAME_ADVANCE_DE, "" },  /* fuzzy */
/* es */ { IDMS_SINGLE_FRAME_ADVANCE_ES, "" },  /* fuzzy */
/* fr */ { IDMS_SINGLE_FRAME_ADVANCE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SINGLE_FRAME_ADVANCE_HU, "" },  /* fuzzy */
/* it */ { IDMS_SINGLE_FRAME_ADVANCE_IT, "" },  /* fuzzy */
/* ko */ { IDMS_SINGLE_FRAME_ADVANCE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_SINGLE_FRAME_ADVANCE_NL, "Een frame vooruit" },
/* pl */ { IDMS_SINGLE_FRAME_ADVANCE_PL, "" },  /* fuzzy */
/* ru */ { IDMS_SINGLE_FRAME_ADVANCE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_SINGLE_FRAME_ADVANCE_SV, "" },  /* fuzzy */
/* tr */ { IDMS_SINGLE_FRAME_ADVANCE_TR, "" },  /* fuzzy */

/* en */ { IDMS_IO_COLLISION_SETTINGS,    "I/O collision settings" },
/* da */ { IDMS_IO_COLLISION_SETTINGS_DA, "" },  /* fuzzy */
/* de */ { IDMS_IO_COLLISION_SETTINGS_DE, "" },  /* fuzzy */
/* es */ { IDMS_IO_COLLISION_SETTINGS_ES, "" },  /* fuzzy */
/* fr */ { IDMS_IO_COLLISION_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_IO_COLLISION_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_IO_COLLISION_SETTINGS_IT, "" },  /* fuzzy */
/* ko */ { IDMS_IO_COLLISION_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_IO_COLLISION_SETTINGS_NL, "I/O conflict instellingen" },
/* pl */ { IDMS_IO_COLLISION_SETTINGS_PL, "" },  /* fuzzy */
/* ru */ { IDMS_IO_COLLISION_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_IO_COLLISION_SETTINGS_SV, "" },  /* fuzzy */
/* tr */ { IDMS_IO_COLLISION_SETTINGS_TR, "" },  /* fuzzy */

/* en */ { IDMS_MONITOR,    "Monitor" },
/* da */ { IDMS_MONITOR_DA, "Monitor" },
/* de */ { IDMS_MONITOR_DE, "Monitor" },
/* es */ { IDMS_MONITOR_ES, "Monitor" },
/* fr */ { IDMS_MONITOR_FR, "Moniteur" },
/* hu */ { IDMS_MONITOR_HU, "Monitor" },
/* it */ { IDMS_MONITOR_IT, "Monitor" },
/* ko */ { IDMS_MONITOR_KO, "" },
/* nl */ { IDMS_MONITOR_NL, "Monitor" },
/* pl */ { IDMS_MONITOR_PL, "Monitor" },
/* ru */ { IDMS_MONITOR_RU, "" },
/* sv */ { IDMS_MONITOR_SV, "Monitor" },
/* tr */ { IDMS_MONITOR_TR, "Monitr" },

/* en */ { IDMS_HARD,    "Hard" },
/* da */ { IDMS_HARD_DA, "Hrd" },
/* de */ { IDMS_HARD_DE, "Hart" },
/* es */ { IDMS_HARD_ES, "Hard" },
/* fr */ { IDMS_HARD_FR, " froid" },
/* hu */ { IDMS_HARD_HU, "Hideg" },
/* it */ { IDMS_HARD_IT, "Hard" },
/* ko */ { IDMS_HARD_KO, "ܴ" },
/* nl */ { IDMS_HARD_NL, "Hard" },
/* pl */ { IDMS_HARD_PL, "Twardy" },
/* ru */ { IDMS_HARD_RU, "Hard" },
/* sv */ { IDMS_HARD_SV, "Hrd" },
/* tr */ { IDMS_HARD_TR, "Hard" },

/* en */ { IDMS_SOFT,    "Soft" },
/* da */ { IDMS_SOFT_DA, "Bld" },
/* de */ { IDMS_SOFT_DE, "Weich" },
/* es */ { IDMS_SOFT_ES, "Soft" },
/* fr */ { IDMS_SOFT_FR, " chaud" },
/* hu */ { IDMS_SOFT_HU, "Meleg" },
/* it */ { IDMS_SOFT_IT, "Soft" },
/* ko */ { IDMS_SOFT_KO, "ε巯" },
/* nl */ { IDMS_SOFT_NL, "Zacht" },
/* pl */ { IDMS_SOFT_PL, "Mikki" },
/* ru */ { IDMS_SOFT_RU, "Soft" },
/* sv */ { IDMS_SOFT_SV, "Mjuk" },
/* tr */ { IDMS_SOFT_TR, "Soft" },

/* en */ { IDMS_EXIT,    "Exit" },
/* da */ { IDMS_EXIT_DA, "Afslut" },
/* de */ { IDMS_EXIT_DE, "Exit" },
/* es */ { IDMS_EXIT_ES, "Salir" },
/* fr */ { IDMS_EXIT_FR, "Sortie" },
/* hu */ { IDMS_EXIT_HU, "Kilps" },
/* it */ { IDMS_EXIT_IT, "Esci" },
/* ko */ { IDMS_EXIT_KO, "" },
/* nl */ { IDMS_EXIT_NL, "Afsluiten" },
/* pl */ { IDMS_EXIT_PL, "Wyjcie" },
/* ru */ { IDMS_EXIT_RU, "" },
/* sv */ { IDMS_EXIT_SV, "Avsluta" },
/* tr */ { IDMS_EXIT_TR, "k" },

/* en */ { IDMS_EDIT,    "Edit" },
/* da */ { IDMS_EDIT_DA, "Redigr" },
/* de */ { IDMS_EDIT_DE, "Bearbeiten" },
/* es */ { IDMS_EDIT_ES, "Editar" },
/* fr */ { IDMS_EDIT_FR, "dition" },
/* hu */ { IDMS_EDIT_HU, "Szerkeszt" },
/* it */ { IDMS_EDIT_IT, "Modifica" },
/* ko */ { IDMS_EDIT_KO, "" },
/* nl */ { IDMS_EDIT_NL, "Bewerken" },
/* pl */ { IDMS_EDIT_PL, "Edycja" },
/* ru */ { IDMS_EDIT_RU, "" },
/* sv */ { IDMS_EDIT_SV, "Redigera" },
/* tr */ { IDMS_EDIT_TR, "Dzenle" },

/* en */ { IDMS_COPY,    "Copy" },
/* da */ { IDMS_COPY_DA, "Kopir" },
/* de */ { IDMS_COPY_DE, "Kopie" },
/* es */ { IDMS_COPY_ES, "Copiar" },
/* fr */ { IDMS_COPY_FR, "Copier" },
/* hu */ { IDMS_COPY_HU, "Msol" },
/* it */ { IDMS_COPY_IT, "Copia" },
/* ko */ { IDMS_COPY_KO, "" },
/* nl */ { IDMS_COPY_NL, "Kopie" },
/* pl */ { IDMS_COPY_PL, "Kopiuj" },
/* ru */ { IDMS_COPY_RU, "" },
/* sv */ { IDMS_COPY_SV, "Kopiera" },
/* tr */ { IDMS_COPY_TR, "Kopyala" },

/* en */ { IDMS_PASTE,    "Paste" },
/* da */ { IDMS_PASTE_DA, "Indst" },
/* de */ { IDMS_PASTE_DE, "Einfgen" },
/* es */ { IDMS_PASTE_ES, "Pegar" },
/* fr */ { IDMS_PASTE_FR, "Coller" },
/* hu */ { IDMS_PASTE_HU, "Beilleszt" },
/* it */ { IDMS_PASTE_IT, "Incolla" },
/* ko */ { IDMS_PASTE_KO, "ٿֱ" },
/* nl */ { IDMS_PASTE_NL, "Plakken" },
/* pl */ { IDMS_PASTE_PL, "Wklej" },
/* ru */ { IDMS_PASTE_RU, "" },
/* sv */ { IDMS_PASTE_SV, "Klistra in" },
/* tr */ { IDMS_PASTE_TR, "Yaptr" },

/* en */ { IDMS_SNAPSHOT,    "Snapshot" },
/* da */ { IDMS_SNAPSHOT_DA, "Snapshot" },
/* de */ { IDMS_SNAPSHOT_DE, "Snapshot" },
/* es */ { IDMS_SNAPSHOT_ES, "Instantnea" },
/* fr */ { IDMS_SNAPSHOT_FR, "Instantans" },
/* hu */ { IDMS_SNAPSHOT_HU, "Pillanatkp" },
/* it */ { IDMS_SNAPSHOT_IT, "Snapshot" },
/* ko */ { IDMS_SNAPSHOT_KO, "" },
/* nl */ { IDMS_SNAPSHOT_NL, "Momentopname" },
/* pl */ { IDMS_SNAPSHOT_PL, "Zrzut" },
/* ru */ { IDMS_SNAPSHOT_RU, "" },
/* sv */ { IDMS_SNAPSHOT_SV, "gonblicksbild" },
/* tr */ { IDMS_SNAPSHOT_TR, "Anlk Grnt" },

/* en */ { IDMS_LOAD_SNAPSHOT_IMAGE,    "Load snapshot image..." },
/* da */ { IDMS_LOAD_SNAPSHOT_IMAGE_DA, "Indls snapshot..." },
/* de */ { IDMS_LOAD_SNAPSHOT_IMAGE_DE, "Snapshot laden..." },
/* es */ { IDMS_LOAD_SNAPSHOT_IMAGE_ES, "Cargar Instantnea..." },
/* fr */ { IDMS_LOAD_SNAPSHOT_IMAGE_FR, "Charger le fichier de sauvegarde..." },
/* hu */ { IDMS_LOAD_SNAPSHOT_IMAGE_HU, "Pillanatkp betltse..." },
/* it */ { IDMS_LOAD_SNAPSHOT_IMAGE_IT, "Carica immagine snapshot..." },
/* ko */ { IDMS_LOAD_SNAPSHOT_IMAGE_KO, " ̹ ҷ..." },
/* nl */ { IDMS_LOAD_SNAPSHOT_IMAGE_NL, "Laad momentopnamebestand..." },
/* pl */ { IDMS_LOAD_SNAPSHOT_IMAGE_PL, "Wczytaj obraz zrzutu..." },
/* ru */ { IDMS_LOAD_SNAPSHOT_IMAGE_RU, " ..." },
/* sv */ { IDMS_LOAD_SNAPSHOT_IMAGE_SV, "Lser in gonblicksbild..." },
/* tr */ { IDMS_LOAD_SNAPSHOT_IMAGE_TR, "Anlk grnt imajn ykle..." },

/* en */ { IDMS_SAVE_SNAPSHOT_IMAGE,    "Save snapshot image..." },
/* da */ { IDMS_SAVE_SNAPSHOT_IMAGE_DA, "Gem snapshot..." },
/* de */ { IDMS_SAVE_SNAPSHOT_IMAGE_DE, "Snapshot Datei speichern..." },
/* es */ { IDMS_SAVE_SNAPSHOT_IMAGE_ES, "Grabar Instantnea..." },
/* fr */ { IDMS_SAVE_SNAPSHOT_IMAGE_FR, "Enregistrer le fichier de sauvegarde..." },
/* hu */ { IDMS_SAVE_SNAPSHOT_IMAGE_HU, "Pillanatkp fjl mentse..." },
/* it */ { IDMS_SAVE_SNAPSHOT_IMAGE_IT, "Salva immagine snapshot..." },
/* ko */ { IDMS_SAVE_SNAPSHOT_IMAGE_KO, " ̹ ..." },
/* nl */ { IDMS_SAVE_SNAPSHOT_IMAGE_NL, "Momentopnamebestand opslaan..." },
/* pl */ { IDMS_SAVE_SNAPSHOT_IMAGE_PL, "Zapisz obraz zrzutu..." },
/* ru */ { IDMS_SAVE_SNAPSHOT_IMAGE_RU, " ..." },
/* sv */ { IDMS_SAVE_SNAPSHOT_IMAGE_SV, "Spara gonblicksbildfil..." },
/* tr */ { IDMS_SAVE_SNAPSHOT_IMAGE_TR, "Anlk grnt imajn kaydet..." },

/* en */ { IDMS_START_STOP_RECORDING,    "Start/Stop Recording History" },
/* da */ { IDMS_START_STOP_RECORDING_DA, "Start/stop optagelse af historik" },
/* de */ { IDMS_START_STOP_RECORDING_DE, "Start/Stop Aufnahme History" },
/* es */ { IDMS_START_STOP_RECORDING_ES, "Iniciar/finalizar grabacin historial" },
/* fr */ { IDMS_START_STOP_RECORDING_FR, "Dmarrer/Arrter l'historique de l'enregistrement" },
/* hu */ { IDMS_START_STOP_RECORDING_HU, "Esemny felvtel indtsa/meglltsa" },
/* it */ { IDMS_START_STOP_RECORDING_IT, "Avvia/termina registrazione cronologia" },
/* ko */ { IDMS_START_STOP_RECORDING_KO, "/ ڵ 丮" },
/* nl */ { IDMS_START_STOP_RECORDING_NL, "Start/Stop Opnamegeschiedenis" },
/* pl */ { IDMS_START_STOP_RECORDING_PL, "Odtwarzaj/Zatrzymaj histori zapisu" },
/* ru */ { IDMS_START_STOP_RECORDING_RU, "Start/Stop Recording History" },
/* sv */ { IDMS_START_STOP_RECORDING_SV, "Brja/sluta spela in hndelser" },
/* tr */ { IDMS_START_STOP_RECORDING_TR, "Kayt Tarihesini Balat/Durdur" },

/* en */ { IDMS_START_STOP_PLAYBACK,    "Start/Stop Playback History" },
/* da */ { IDMS_START_STOP_PLAYBACK_DA, "Start/stop afspilning af historik" },
/* de */ { IDMS_START_STOP_PLAYBACK_DE, "Start/Stop Wiedergabe History" },
/* es */ { IDMS_START_STOP_PLAYBACK_ES, "Iniciar/finalizar reproduccin historial" },
/* fr */ { IDMS_START_STOP_PLAYBACK_FR, "Dmarrer/Arrter l'historique de la lecture" },
/* hu */ { IDMS_START_STOP_PLAYBACK_HU, "Esemny visszajtszs indtsa/meglltsa" },
/* it */ { IDMS_START_STOP_PLAYBACK_IT, "Avvia/termina riproduzione cronologia" },
/* ko */ { IDMS_START_STOP_PLAYBACK_KO, "/  丮" },
/* nl */ { IDMS_START_STOP_PLAYBACK_NL, "Start/Stop Afspeelgeschiedenis" },
/* pl */ { IDMS_START_STOP_PLAYBACK_PL, "Odtwarzaj/Zatrzymaj histori odtwarzania" },
/* ru */ { IDMS_START_STOP_PLAYBACK_RU, "Start/Stop Playback History" },
/* sv */ { IDMS_START_STOP_PLAYBACK_SV, "Brja/sluta spela upp hndelser" },
/* tr */ { IDMS_START_STOP_PLAYBACK_TR, "Kayttan Yrtme Tarihesini Balat/Durdur" },

/* en */ { IDMS_SET_MILESTONE,    "Set recording milestone" },
/* da */ { IDMS_SET_MILESTONE_DA, "Angiv optagelses-bogmrke" },
/* de */ { IDMS_SET_MILESTONE_DE, "Setze Aufnahme Meilenstein" },
/* es */ { IDMS_SET_MILESTONE_ES, "Insertar marca de grabacin" },
/* fr */ { IDMS_SET_MILESTONE_FR, "Lever le signet d'enregistrement" },
/* hu */ { IDMS_SET_MILESTONE_HU, "Kilmterk elhelyezse a felvtelben" },
/* it */ { IDMS_SET_MILESTONE_IT, "Imposta segnalibro" },
/* ko */ { IDMS_SET_MILESTONE_KO, "ڵ Ͻ " },
/* nl */ { IDMS_SET_MILESTONE_NL, "Zet opname mijlpaal" },
/* pl */ { IDMS_SET_MILESTONE_PL, "Ustaw kamie milowy zapisu" },
/* ru */ { IDMS_SET_MILESTONE_RU, "  " },
/* sv */ { IDMS_SET_MILESTONE_SV, "Ange inspelningsbokmrke" },
/* tr */ { IDMS_SET_MILESTONE_TR, "Kayt kilometre ta koy" },

/* en */ { IDMS_RETURN_TO_MILESTONE,    "Return to milestone" },
/* da */ { IDMS_RETURN_TO_MILESTONE_DA, "G til bogmrke" },
/* de */ { IDMS_RETURN_TO_MILESTONE_DE, "Rckkehr zum Meilenstein" },
/* es */ { IDMS_RETURN_TO_MILESTONE_ES, "Volver a la marca" },
/* fr */ { IDMS_RETURN_TO_MILESTONE_FR, "Retourner au signet d'enregistrement" },
/* hu */ { IDMS_RETURN_TO_MILESTONE_HU, "Visszaugrs az elz kilmterkhz" },
/* it */ { IDMS_RETURN_TO_MILESTONE_IT, "Vai al segnalibro" },
/* ko */ { IDMS_RETURN_TO_MILESTONE_KO, "Ͻ  ư" },
/* nl */ { IDMS_RETURN_TO_MILESTONE_NL, "Ga terug naar mijlpaal" },
/* pl */ { IDMS_RETURN_TO_MILESTONE_PL, "Powr do kamienia milowego" },
/* ru */ { IDMS_RETURN_TO_MILESTONE_RU, "Return to milestone" },
/* sv */ { IDMS_RETURN_TO_MILESTONE_SV, "terg till bokmrke" },
/* tr */ { IDMS_RETURN_TO_MILESTONE_TR, "Kilometre tana geri dn" },

/* en */ { IDMS_RECORDING_START_MODE,    "Recording start mode" },
/* da */ { IDMS_RECORDING_START_MODE_DA, "Start-tilstand for optagelse" },
/* de */ { IDMS_RECORDING_START_MODE_DE, "Aufnahme Start Modus" },
/* es */ { IDMS_RECORDING_START_MODE_ES, "Grabar modo de inicio" },
/* fr */ { IDMS_RECORDING_START_MODE_FR, "Mode de dpart d'enregistrement" },
/* hu */ { IDMS_RECORDING_START_MODE_HU, "Rgzts indtsnak mdja" },
/* it */ { IDMS_RECORDING_START_MODE_IT, "Modalit di avvio registrazione" },
/* ko */ { IDMS_RECORDING_START_MODE_KO, "ڵ  " },
/* nl */ { IDMS_RECORDING_START_MODE_NL, "Opname start modus" },
/* pl */ { IDMS_RECORDING_START_MODE_PL, "Rozpocznij tryb zapisu" },
/* ru */ { IDMS_RECORDING_START_MODE_RU, "Recording start mode" },
/* sv */ { IDMS_RECORDING_START_MODE_SV, "Spelar in startlge" },
/* tr */ { IDMS_RECORDING_START_MODE_TR, "Kayt balang modu" },

/* en */ { IDMS_SAVE_NEW_SNAPSHOT,    "Save new snapshot" },
/* da */ { IDMS_SAVE_NEW_SNAPSHOT_DA, "Gem nyt snapshot" },
/* de */ { IDMS_SAVE_NEW_SNAPSHOT_DE, "Speichere neuen Snapshot" },
/* es */ { IDMS_SAVE_NEW_SNAPSHOT_ES, "Grabar nueva Instantnea" },
/* fr */ { IDMS_SAVE_NEW_SNAPSHOT_FR, "Enregistrer une nouvelle sauvegarde" },
/* hu */ { IDMS_SAVE_NEW_SNAPSHOT_HU, "j pillanatkp mentse" },
/* it */ { IDMS_SAVE_NEW_SNAPSHOT_IT, "Salva nuovo snapshot" },
/* ko */ { IDMS_SAVE_NEW_SNAPSHOT_KO, "ο  " },
/* nl */ { IDMS_SAVE_NEW_SNAPSHOT_NL, "Opslaan nieuwe momentopname" },
/* pl */ { IDMS_SAVE_NEW_SNAPSHOT_PL, "Zapisz nowy zrzut" },
/* ru */ { IDMS_SAVE_NEW_SNAPSHOT_RU, "  " },
/* sv */ { IDMS_SAVE_NEW_SNAPSHOT_SV, "Spara ny gonblicksbild" },
/* tr */ { IDMS_SAVE_NEW_SNAPSHOT_TR, "Yeni anlk grnt kaydet" },

/* en */ { IDMS_LOAD_EXISTING_SNAPSHOT,    "Load existing snapshot" },
/* da */ { IDMS_LOAD_EXISTING_SNAPSHOT_DA, "Indls eksisterende snapshot" },
/* de */ { IDMS_LOAD_EXISTING_SNAPSHOT_DE, "Lade existierenden Snapshot" },
/* es */ { IDMS_LOAD_EXISTING_SNAPSHOT_ES, "Cargar Instantnea existente" },
/* fr */ { IDMS_LOAD_EXISTING_SNAPSHOT_FR, "Charger un instantan" },
/* hu */ { IDMS_LOAD_EXISTING_SNAPSHOT_HU, "Ltez pillanatkp betltse" },
/* it */ { IDMS_LOAD_EXISTING_SNAPSHOT_IT, "Carica snapshot esistente" },
/* ko */ { IDMS_LOAD_EXISTING_SNAPSHOT_KO, "ϴ  ҷ" },
/* nl */ { IDMS_LOAD_EXISTING_SNAPSHOT_NL, "Laad bestaande momentopname" },
/* pl */ { IDMS_LOAD_EXISTING_SNAPSHOT_PL, "Wczytaj istniejcy zrzut" },
/* ru */ { IDMS_LOAD_EXISTING_SNAPSHOT_RU, "  " },
/* sv */ { IDMS_LOAD_EXISTING_SNAPSHOT_SV, "Ls in existerande gonblicksbild" },
/* tr */ { IDMS_LOAD_EXISTING_SNAPSHOT_TR, "Varolan anlk grnty ykle" },

/* en */ { IDMS_START_WITH_RESET,    "Start with reset" },
/* da */ { IDMS_START_WITH_RESET_DA, "Start med reset" },
/* de */ { IDMS_START_WITH_RESET_DE, "Mit Reset starten" },
/* es */ { IDMS_START_WITH_RESET_ES, "Comenzar con reinicio" },
/* fr */ { IDMS_START_WITH_RESET_FR, "Rinitialiser au dmarrage" },
/* hu */ { IDMS_START_WITH_RESET_HU, "Induls RESET-tel" },
/* it */ { IDMS_START_WITH_RESET_IT, "Avvia con reset" },
/* ko */ { IDMS_START_WITH_RESET_KO, " ϱ" },
/* nl */ { IDMS_START_WITH_RESET_NL, "Start met reset" },
/* pl */ { IDMS_START_WITH_RESET_PL, "Rozpocznij z resetem" },
/* ru */ { IDMS_START_WITH_RESET_RU, "Start with reset" },
/* sv */ { IDMS_START_WITH_RESET_SV, "Starta med nollstllning" },
/* tr */ { IDMS_START_WITH_RESET_TR, "Reset ile balat" },

/* en */ { IDMS_OVERWRITE_PLAYBACK,    "Overwrite Playback" },
/* da */ { IDMS_OVERWRITE_PLAYBACK_DA, "Overskriv afspilning" },
/* de */ { IDMS_OVERWRITE_PLAYBACK_DE, "Laufende Aufnahme berschreiben" },
/* es */ { IDMS_OVERWRITE_PLAYBACK_ES, "Sobrescribir reproduccin" },
/* fr */ { IDMS_OVERWRITE_PLAYBACK_FR, "craser la lecture actuelle" },
/* hu */ { IDMS_OVERWRITE_PLAYBACK_HU, "Visszajtszs fellrsa" },
/* it */ { IDMS_OVERWRITE_PLAYBACK_IT, "Sovrascrivi riproduzione" },
/* ko */ { IDMS_OVERWRITE_PLAYBACK_KO, " " },
/* nl */ { IDMS_OVERWRITE_PLAYBACK_NL, "Overschrijf weergave" },
/* pl */ { IDMS_OVERWRITE_PLAYBACK_PL, "Nadpisuj wyjciowy sygna" },
/* ru */ { IDMS_OVERWRITE_PLAYBACK_RU, "Overwrite Playback" },
/* sv */ { IDMS_OVERWRITE_PLAYBACK_SV, "Skriv ver aktiv uppspelning" },
/* tr */ { IDMS_OVERWRITE_PLAYBACK_TR, "Kayttan Yrtmenin zerine Yaz" },

/* en */ { IDMS_SELECT_HISTORY_DIR,    "Select History files/directory" },
/* da */ { IDMS_SELECT_HISTORY_DIR_DA, "Vlg historikfiler/-katalog" },
/* de */ { IDMS_SELECT_HISTORY_DIR_DE, "Verzeichnis fr Event Aufnahme" },
/* es */ { IDMS_SELECT_HISTORY_DIR_ES, "Seleccionar historial ficheros/directorios" },
/* fr */ { IDMS_SELECT_HISTORY_DIR_FR, "Slectionnez le rpertoire des captures" },
/* hu */ { IDMS_SELECT_HISTORY_DIR_HU, "Vlassza ki a felvteleket/knyvtrat" },
/* it */ { IDMS_SELECT_HISTORY_DIR_IT, "Seleziona file/directory della cronologia" },
/* ko */ { IDMS_SELECT_HISTORY_DIR_KO, " 丮 /丮" },
/* nl */ { IDMS_SELECT_HISTORY_DIR_NL, "Selecteer geschiedenisdirectory" },
/* pl */ { IDMS_SELECT_HISTORY_DIR_PL, "Wybierz pliki lub katalog historii" },
/* ru */ { IDMS_SELECT_HISTORY_DIR_RU, "Select History files/directory" },
/* sv */ { IDMS_SELECT_HISTORY_DIR_SV, "Vlj historikfiler/-katalog" },
/* tr */ { IDMS_SELECT_HISTORY_DIR_TR, "Tarihe dosyalar/dizin se" },

/* en */ { IDMS_SAVE_STOP_MEDIA_FILE,    "Save screenshot file..." },
/* da */ { IDMS_SAVE_STOP_MEDIA_FILE_DA, "Gem screenshot..." },
/* de */ { IDMS_SAVE_STOP_MEDIA_FILE_DE, "Screenshot speichern..." },
/* es */ { IDMS_SAVE_STOP_MEDIA_FILE_ES, "Grabar fichero de captura de pantalla..." },
/* fr */ { IDMS_SAVE_STOP_MEDIA_FILE_FR, "Enregistrer une capture d'cran..." },
/* hu */ { IDMS_SAVE_STOP_MEDIA_FILE_HU, "Fnykp fjl mentse..." },
/* it */ { IDMS_SAVE_STOP_MEDIA_FILE_IT, "Salva schermata su file..." },
/* ko */ { IDMS_SAVE_STOP_MEDIA_FILE_KO, "ũ  ..." },
/* nl */ { IDMS_SAVE_STOP_MEDIA_FILE_NL, "Opslaan schermafdrukbestand..." },
/* pl */ { IDMS_SAVE_STOP_MEDIA_FILE_PL, "Zapisz plik zrzutu ekranu..." },
/* ru */ { IDMS_SAVE_STOP_MEDIA_FILE_RU, "  ..." },
/* sv */ { IDMS_SAVE_STOP_MEDIA_FILE_SV, "Spara skrmdump..." },
/* tr */ { IDMS_SAVE_STOP_MEDIA_FILE_TR, "Ekran grnts dosyas kaydet..." },

/* en */ { IDMS_NATIVE_SCREENSHOT_SETTINGS,    "Native screenshot settings..." },
/* da */ { IDMS_NATIVE_SCREENSHOT_SETTINGS_DA, "" },  /* fuzzy */
/* de */ { IDMS_NATIVE_SCREENSHOT_SETTINGS_DE, "" },  /* fuzzy */
/* es */ { IDMS_NATIVE_SCREENSHOT_SETTINGS_ES, "" },  /* fuzzy */
/* fr */ { IDMS_NATIVE_SCREENSHOT_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_NATIVE_SCREENSHOT_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_NATIVE_SCREENSHOT_SETTINGS_IT, "" },  /* fuzzy */
/* ko */ { IDMS_NATIVE_SCREENSHOT_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_NATIVE_SCREENSHOT_SETTINGS_NL, "Koala/doodle scherm afdruk instellingen..." },
/* pl */ { IDMS_NATIVE_SCREENSHOT_SETTINGS_PL, "" },  /* fuzzy */
/* ru */ { IDMS_NATIVE_SCREENSHOT_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_NATIVE_SCREENSHOT_SETTINGS_SV, "" },  /* fuzzy */
/* tr */ { IDMS_NATIVE_SCREENSHOT_SETTINGS_TR, "" },  /* fuzzy */

/* en */ { IDMS_NETPLAY,    "Netplay (experimental)..." },
/* da */ { IDMS_NETPLAY_DA, "Netvrksspil (eksperimentelt)..." },
/* de */ { IDMS_NETPLAY_DE, "Netplay (experimentell)..." },
/* es */ { IDMS_NETPLAY_ES, "Juego en red (experimental)..." },
/* fr */ { IDMS_NETPLAY_FR, "Jeu en rseau (experimental)..." },
/* hu */ { IDMS_NETPLAY_HU, "Hlzati jtk (ksrleti)..." },
/* it */ { IDMS_NETPLAY_IT, "Netplay (sperimentale)..." },
/* ko */ { IDMS_NETPLAY_KO, "÷ ()..." },
/* nl */ { IDMS_NETPLAY_NL, "Netplay (experimenteel)..." },
/* pl */ { IDMS_NETPLAY_PL, "Gra sieciowa (eksperymentalne)..." },
/* ru */ { IDMS_NETPLAY_RU, "Netplay (experimental)..." },
/* sv */ { IDMS_NETPLAY_SV, "Ntverksspel (experimentellt)..." },
/* tr */ { IDMS_NETPLAY_TR, "Netplay (deneysel)..." },

/* en */ { IDMS_OPTIONS,    "Options" },
/* da */ { IDMS_OPTIONS_DA, "Valg" },
/* de */ { IDMS_OPTIONS_DE, "Optionen" },
/* es */ { IDMS_OPTIONS_ES, "Opciones" },
/* fr */ { IDMS_OPTIONS_FR, "Options" },
/* hu */ { IDMS_OPTIONS_HU, "Opcik" },
/* it */ { IDMS_OPTIONS_IT, "Opzioni" },
/* ko */ { IDMS_OPTIONS_KO, "" },
/* nl */ { IDMS_OPTIONS_NL, "Opties" },
/* pl */ { IDMS_OPTIONS_PL, "Opcje" },
/* ru */ { IDMS_OPTIONS_RU, "" },
/* sv */ { IDMS_OPTIONS_SV, "Alternativ" },
/* tr */ { IDMS_OPTIONS_TR, "Seenekler" },

/* en */ { IDMS_REFRESH_RATE,    "Refresh rate" },
/* da */ { IDMS_REFRESH_RATE_DA, "Opdateringsfrekvens" },
/* de */ { IDMS_REFRESH_RATE_DE, "Wiederholrate" },
/* es */ { IDMS_REFRESH_RATE_ES, "Velocidad de refresco" },
/* fr */ { IDMS_REFRESH_RATE_FR, "Taux de rafrachissement" },
/* hu */ { IDMS_REFRESH_RATE_HU, "Frisstsi rta" },
/* it */ { IDMS_REFRESH_RATE_IT, "Frequenza di aggiornamento" },
/* ko */ { IDMS_REFRESH_RATE_KO, "" },
/* nl */ { IDMS_REFRESH_RATE_NL, "Vernieuwing snelheid" },
/* pl */ { IDMS_REFRESH_RATE_PL, "Czstotliwo odwieania" },
/* ru */ { IDMS_REFRESH_RATE_RU, " " },
/* sv */ { IDMS_REFRESH_RATE_SV, "Uppdateringshastighet" },
/* tr */ { IDMS_REFRESH_RATE_TR, "Yenileme hz" },

/* en */ { IDMS_AUTO,    "Auto" },
/* da */ { IDMS_AUTO_DA, "Auto" },
/* de */ { IDMS_AUTO_DE, "Automatisch" },
/* es */ { IDMS_AUTO_ES, "Auto" },
/* fr */ { IDMS_AUTO_FR, "Automatique" },
/* hu */ { IDMS_AUTO_HU, "Automatikus" },
/* it */ { IDMS_AUTO_IT, "Auto" },
/* ko */ { IDMS_AUTO_KO, "ڵ" },
/* nl */ { IDMS_AUTO_NL, "Auto" },
/* pl */ { IDMS_AUTO_PL, "Automatyczna" },
/* ru */ { IDMS_AUTO_RU, "" },
/* sv */ { IDMS_AUTO_SV, "Auto" },
/* tr */ { IDMS_AUTO_TR, "Otomatik" },

/* en */ { IDMS_1_1,    "1/1" },
/* da */ { IDMS_1_1_DA, "1/1" },
/* de */ { IDMS_1_1_DE, "1/1" },
/* es */ { IDMS_1_1_ES, "1/1" },
/* fr */ { IDMS_1_1_FR, "1/1" },
/* hu */ { IDMS_1_1_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_1_IT, "1/1" },
/* ko */ { IDMS_1_1_KO, "1/1" },
/* nl */ { IDMS_1_1_NL, "1/1" },
/* pl */ { IDMS_1_1_PL, "1/1" },
/* ru */ { IDMS_1_1_RU, "1/1" },
/* sv */ { IDMS_1_1_SV, "1/1" },
/* tr */ { IDMS_1_1_TR, "1/1" },

/* en */ { IDMS_1_2,    "1/2" },
/* da */ { IDMS_1_2_DA, "1/2" },
/* de */ { IDMS_1_2_DE, "1/2" },
/* es */ { IDMS_1_2_ES, "1/2" },
/* fr */ { IDMS_1_2_FR, "1/2" },
/* hu */ { IDMS_1_2_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_2_IT, "1/2" },
/* ko */ { IDMS_1_2_KO, "1/2" },
/* nl */ { IDMS_1_2_NL, "1/2" },
/* pl */ { IDMS_1_2_PL, "1/2" },
/* ru */ { IDMS_1_2_RU, "1/2" },
/* sv */ { IDMS_1_2_SV, "1/2" },
/* tr */ { IDMS_1_2_TR, "1/2" },

/* en */ { IDMS_1_3,    "1/3" },
/* da */ { IDMS_1_3_DA, "1/3" },
/* de */ { IDMS_1_3_DE, "1/3" },
/* es */ { IDMS_1_3_ES, "1/3" },
/* fr */ { IDMS_1_3_FR, "1/3" },
/* hu */ { IDMS_1_3_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_3_IT, "1/3" },
/* ko */ { IDMS_1_3_KO, "1/3" },
/* nl */ { IDMS_1_3_NL, "1/3" },
/* pl */ { IDMS_1_3_PL, "1/3" },
/* ru */ { IDMS_1_3_RU, "1/3" },
/* sv */ { IDMS_1_3_SV, "1/3" },
/* tr */ { IDMS_1_3_TR, "1/3" },

/* en */ { IDMS_1_4,    "1/4" },
/* da */ { IDMS_1_4_DA, "1/4" },
/* de */ { IDMS_1_4_DE, "1/4" },
/* es */ { IDMS_1_4_ES, "1/4" },
/* fr */ { IDMS_1_4_FR, "1/4" },
/* hu */ { IDMS_1_4_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_4_IT, "1/4" },
/* ko */ { IDMS_1_4_KO, "1/4" },
/* nl */ { IDMS_1_4_NL, "1/4" },
/* pl */ { IDMS_1_4_PL, "1/4" },
/* ru */ { IDMS_1_4_RU, "1/4" },
/* sv */ { IDMS_1_4_SV, "1/4" },
/* tr */ { IDMS_1_4_TR, "1/4" },

/* en */ { IDMS_1_5,    "1/5" },
/* da */ { IDMS_1_5_DA, "1/5" },
/* de */ { IDMS_1_5_DE, "1/5" },
/* es */ { IDMS_1_5_ES, "1/5" },
/* fr */ { IDMS_1_5_FR, "1/5" },
/* hu */ { IDMS_1_5_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_5_IT, "1/5" },
/* ko */ { IDMS_1_5_KO, "1/5" },
/* nl */ { IDMS_1_5_NL, "1/5" },
/* pl */ { IDMS_1_5_PL, "1/5" },
/* ru */ { IDMS_1_5_RU, "1/5" },
/* sv */ { IDMS_1_5_SV, "1/5" },
/* tr */ { IDMS_1_5_TR, "1/5" },

/* en */ { IDMS_1_6,    "1/6" },
/* da */ { IDMS_1_6_DA, "1/6" },
/* de */ { IDMS_1_6_DE, "1/6" },
/* es */ { IDMS_1_6_ES, "1/6" },
/* fr */ { IDMS_1_6_FR, "1/6" },
/* hu */ { IDMS_1_6_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_6_IT, "1/6" },
/* ko */ { IDMS_1_6_KO, "1/6" },
/* nl */ { IDMS_1_6_NL, "1/6" },
/* pl */ { IDMS_1_6_PL, "1/6" },
/* ru */ { IDMS_1_6_RU, "1/6" },
/* sv */ { IDMS_1_6_SV, "1/6" },
/* tr */ { IDMS_1_6_TR, "1/6" },

/* en */ { IDMS_1_7,    "1/7" },
/* da */ { IDMS_1_7_DA, "1/7" },
/* de */ { IDMS_1_7_DE, "1/7" },
/* es */ { IDMS_1_7_ES, "1/7" },
/* fr */ { IDMS_1_7_FR, "1/7" },
/* hu */ { IDMS_1_7_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_7_IT, "1/7" },
/* ko */ { IDMS_1_7_KO, "1/7" },
/* nl */ { IDMS_1_7_NL, "1/7" },
/* pl */ { IDMS_1_7_PL, "1/7" },
/* ru */ { IDMS_1_7_RU, "1/7" },
/* sv */ { IDMS_1_7_SV, "1/7" },
/* tr */ { IDMS_1_7_TR, "1/7" },

/* en */ { IDMS_1_8,    "1/8" },
/* da */ { IDMS_1_8_DA, "1/8" },
/* de */ { IDMS_1_8_DE, "1/8" },
/* es */ { IDMS_1_8_ES, "1/8" },
/* fr */ { IDMS_1_8_FR, "1/8" },
/* hu */ { IDMS_1_8_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_8_IT, "1/8" },
/* ko */ { IDMS_1_8_KO, "1/8" },
/* nl */ { IDMS_1_8_NL, "1/8" },
/* pl */ { IDMS_1_8_PL, "1/8" },
/* ru */ { IDMS_1_8_RU, "1/8" },
/* sv */ { IDMS_1_8_SV, "1/8" },
/* tr */ { IDMS_1_8_TR, "1/8" },

/* en */ { IDMS_1_9,    "1/9" },
/* da */ { IDMS_1_9_DA, "1/9" },
/* de */ { IDMS_1_9_DE, "1/9" },
/* es */ { IDMS_1_9_ES, "1/9" },
/* fr */ { IDMS_1_9_FR, "1/9" },
/* hu */ { IDMS_1_9_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_9_IT, "1/9" },
/* ko */ { IDMS_1_9_KO, "1/9" },
/* nl */ { IDMS_1_9_NL, "1/9" },
/* pl */ { IDMS_1_9_PL, "1/9" },
/* ru */ { IDMS_1_9_RU, "1/9" },
/* sv */ { IDMS_1_9_SV, "1/9" },
/* tr */ { IDMS_1_9_TR, "1/9" },

/* en */ { IDMS_1_10,    "1/10" },
/* da */ { IDMS_1_10_DA, "1/10" },
/* de */ { IDMS_1_10_DE, "1/10" },
/* es */ { IDMS_1_10_ES, "1/10" },
/* fr */ { IDMS_1_10_FR, "1/10" },
/* hu */ { IDMS_1_10_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_10_IT, "1/10" },
/* ko */ { IDMS_1_10_KO, "1/10" },
/* nl */ { IDMS_1_10_NL, "1/10" },
/* pl */ { IDMS_1_10_PL, "1/10" },
/* ru */ { IDMS_1_10_RU, "1/10" },
/* sv */ { IDMS_1_10_SV, "1/10" },
/* tr */ { IDMS_1_10_TR, "1/10" },

/* en */ { IDMS_MAXIMUM_SPEED,    "Maximum speed" },
/* da */ { IDMS_MAXIMUM_SPEED_DA, "Maksimal hastighed" },
/* de */ { IDMS_MAXIMUM_SPEED_DE, "Maximale Geschwindigkeit" },
/* es */ { IDMS_MAXIMUM_SPEED_ES, "Velocidad mxima" },
/* fr */ { IDMS_MAXIMUM_SPEED_FR, "Vitesse maximale" },
/* hu */ { IDMS_MAXIMUM_SPEED_HU, "Maximlis sebessg" },
/* it */ { IDMS_MAXIMUM_SPEED_IT, "Velocit massima" },
/* ko */ { IDMS_MAXIMUM_SPEED_KO, "" },  /* fuzzy */
/* nl */ { IDMS_MAXIMUM_SPEED_NL, "Maximale snelheid" },
/* pl */ { IDMS_MAXIMUM_SPEED_PL, "Maksymalna prdko" },
/* ru */ { IDMS_MAXIMUM_SPEED_RU, " " },
/* sv */ { IDMS_MAXIMUM_SPEED_SV, "Maximal hastighet" },
/* tr */ { IDMS_MAXIMUM_SPEED_TR, "Maksimum hz" },

/* en */ { IDMS_200_PERCENT,    "200%" },
/* da */ { IDMS_200_PERCENT_DA, "200%" },
/* de */ { IDMS_200_PERCENT_DE, "200%" },
/* es */ { IDMS_200_PERCENT_ES, "200%" },
/* fr */ { IDMS_200_PERCENT_FR, "200%" },
/* hu */ { IDMS_200_PERCENT_HU, "" },  /* fuzzy */
/* it */ { IDMS_200_PERCENT_IT, "200%" },
/* ko */ { IDMS_200_PERCENT_KO, "200%" },
/* nl */ { IDMS_200_PERCENT_NL, "200%" },
/* pl */ { IDMS_200_PERCENT_PL, "200%" },
/* ru */ { IDMS_200_PERCENT_RU, "200%" },
/* sv */ { IDMS_200_PERCENT_SV, "200%" },
/* tr */ { IDMS_200_PERCENT_TR, "200%" },

/* en */ { IDMS_100_PERCENT,    "100%" },
/* da */ { IDMS_100_PERCENT_DA, "100%" },
/* de */ { IDMS_100_PERCENT_DE, "100%" },
/* es */ { IDMS_100_PERCENT_ES, "100%" },
/* fr */ { IDMS_100_PERCENT_FR, "100%" },
/* hu */ { IDMS_100_PERCENT_HU, "" },  /* fuzzy */
/* it */ { IDMS_100_PERCENT_IT, "100%" },
/* ko */ { IDMS_100_PERCENT_KO, "100%" },
/* nl */ { IDMS_100_PERCENT_NL, "100%" },
/* pl */ { IDMS_100_PERCENT_PL, "100%" },
/* ru */ { IDMS_100_PERCENT_RU, "100%" },
/* sv */ { IDMS_100_PERCENT_SV, "100%" },
/* tr */ { IDMS_100_PERCENT_TR, "100%" },

/* en */ { IDMS_50_PERCENT,    "50%" },
/* da */ { IDMS_50_PERCENT_DA, "50%" },
/* de */ { IDMS_50_PERCENT_DE, "50%" },
/* es */ { IDMS_50_PERCENT_ES, "50%" },
/* fr */ { IDMS_50_PERCENT_FR, "50%" },
/* hu */ { IDMS_50_PERCENT_HU, "" },  /* fuzzy */
/* it */ { IDMS_50_PERCENT_IT, "50%" },
/* ko */ { IDMS_50_PERCENT_KO, "50%" },
/* nl */ { IDMS_50_PERCENT_NL, "50%" },
/* pl */ { IDMS_50_PERCENT_PL, "50%" },
/* ru */ { IDMS_50_PERCENT_RU, "50%" },
/* sv */ { IDMS_50_PERCENT_SV, "50%" },
/* tr */ { IDMS_50_PERCENT_TR, "50%" },

/* en */ { IDMS_20_PERCENT,    "20%" },
/* da */ { IDMS_20_PERCENT_DA, "20%" },
/* de */ { IDMS_20_PERCENT_DE, "20%" },
/* es */ { IDMS_20_PERCENT_ES, "20%" },
/* fr */ { IDMS_20_PERCENT_FR, "20%" },
/* hu */ { IDMS_20_PERCENT_HU, "" },  /* fuzzy */
/* it */ { IDMS_20_PERCENT_IT, "20%" },
/* ko */ { IDMS_20_PERCENT_KO, "20%" },
/* nl */ { IDMS_20_PERCENT_NL, "20%" },
/* pl */ { IDMS_20_PERCENT_PL, "20%" },
/* ru */ { IDMS_20_PERCENT_RU, "20%" },
/* sv */ { IDMS_20_PERCENT_SV, "20%" },
/* tr */ { IDMS_20_PERCENT_TR, "20%" },

/* en */ { IDMS_10_PERCENT,    "10%" },
/* da */ { IDMS_10_PERCENT_DA, "10%" },
/* de */ { IDMS_10_PERCENT_DE, "10%" },
/* es */ { IDMS_10_PERCENT_ES, "10%" },
/* fr */ { IDMS_10_PERCENT_FR, "10%" },
/* hu */ { IDMS_10_PERCENT_HU, "" },  /* fuzzy */
/* it */ { IDMS_10_PERCENT_IT, "10%" },
/* ko */ { IDMS_10_PERCENT_KO, "10%" },
/* nl */ { IDMS_10_PERCENT_NL, "10%" },
/* pl */ { IDMS_10_PERCENT_PL, "10%" },
/* ru */ { IDMS_10_PERCENT_RU, "10%" },
/* sv */ { IDMS_10_PERCENT_SV, "10%" },
/* tr */ { IDMS_10_PERCENT_TR, "10%" },

/* en */ { IDMS_NO_LIMIT,    "No limit" },
/* da */ { IDMS_NO_LIMIT_DA, "Ubegrnset" },
/* de */ { IDMS_NO_LIMIT_DE, "Kein Limit" },
/* es */ { IDMS_NO_LIMIT_ES, "Sin lmite" },
/* fr */ { IDMS_NO_LIMIT_FR, "Aucune limite" },
/* hu */ { IDMS_NO_LIMIT_HU, "Nincs hatr" },
/* it */ { IDMS_NO_LIMIT_IT, "Nessun limite" },
/* ko */ { IDMS_NO_LIMIT_KO, "Ѱ" },
/* nl */ { IDMS_NO_LIMIT_NL, "Geen limiet" },
/* pl */ { IDMS_NO_LIMIT_PL, "Bez limitu" },
/* ru */ { IDMS_NO_LIMIT_RU, "No limit" },
/* sv */ { IDMS_NO_LIMIT_SV, "Ingen grns" },
/* tr */ { IDMS_NO_LIMIT_TR, "Limitsiz" },

/* en */ { IDMS_CUSTOM,    "Custom" },
/* da */ { IDMS_CUSTOM_DA, "Egen" },
/* de */ { IDMS_CUSTOM_DE, "Benutzerdefiniert" },
/* es */ { IDMS_CUSTOM_ES, "Personalizado" },
/* fr */ { IDMS_CUSTOM_FR, "Personnalis" },
/* hu */ { IDMS_CUSTOM_HU, "Egyni" },
/* it */ { IDMS_CUSTOM_IT, "Personalizzato" },
/* ko */ { IDMS_CUSTOM_KO, "Ŀ" },
/* nl */ { IDMS_CUSTOM_NL, "Aangepast" },
/* pl */ { IDMS_CUSTOM_PL, "Wasna" },
/* ru */ { IDMS_CUSTOM_RU, "Custom" },
/* sv */ { IDMS_CUSTOM_SV, "Egen" },
/* tr */ { IDMS_CUSTOM_TR, "zel" },

/* en */ { IDMS_WARP_MODE,    "Warp mode" },
/* da */ { IDMS_WARP_MODE_DA, "Warp-tilstand" },
/* de */ { IDMS_WARP_MODE_DE, "Warp modus" },
/* es */ { IDMS_WARP_MODE_ES, "Modo mxima velocidad" },
/* fr */ { IDMS_WARP_MODE_FR, "Mode Turbo " },
/* hu */ { IDMS_WARP_MODE_HU, "Hipergyors md" },
/* it */ { IDMS_WARP_MODE_IT, "Modalit turbo" },
/* ko */ { IDMS_WARP_MODE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_WARP_MODE_NL, "Warpmodus" },
/* pl */ { IDMS_WARP_MODE_PL, "Tryb przyspieszony" },
/* ru */ { IDMS_WARP_MODE_RU, "Warp mode" },
/* sv */ { IDMS_WARP_MODE_SV, "Warplge" },
/* tr */ { IDMS_WARP_MODE_TR, "Warp modu" },

/* en */ { IDMS_FULLSCREEN,    "Fullscreen" },
/* da */ { IDMS_FULLSCREEN_DA, "Fuldskrm" },
/* de */ { IDMS_FULLSCREEN_DE, "Vollbild" },
/* es */ { IDMS_FULLSCREEN_ES, "Pantalla completa" },
/* fr */ { IDMS_FULLSCREEN_FR, "Plein cran" },
/* hu */ { IDMS_FULLSCREEN_HU, "Teljes kperny" },
/* it */ { IDMS_FULLSCREEN_IT, "Schermo intero" },
/* ko */ { IDMS_FULLSCREEN_KO, "üȭ" },
/* nl */ { IDMS_FULLSCREEN_NL, "Volscherm" },
/* pl */ { IDMS_FULLSCREEN_PL, "Peny ekran" },
/* ru */ { IDMS_FULLSCREEN_RU, "  " },
/* sv */ { IDMS_FULLSCREEN_SV, "Fullskrm" },
/* tr */ { IDMS_FULLSCREEN_TR, "Tam ekran" },

/* en */ { IDMS_VIDEO_CACHE,    "Video cache" },
/* da */ { IDMS_VIDEO_CACHE_DA, "Grafikcache" },
/* de */ { IDMS_VIDEO_CACHE_DE, "Video Cache" },
/* es */ { IDMS_VIDEO_CACHE_ES, "Cach de video" },
/* fr */ { IDMS_VIDEO_CACHE_FR, "Cache vido" },
/* hu */ { IDMS_VIDEO_CACHE_HU, "Kp gyorsttr" },
/* it */ { IDMS_VIDEO_CACHE_IT, "Cache video" },
/* ko */ { IDMS_VIDEO_CACHE_KO, " ĳ" },
/* nl */ { IDMS_VIDEO_CACHE_NL, "Videocache" },
/* pl */ { IDMS_VIDEO_CACHE_PL, "Cache wideo" },
/* ru */ { IDMS_VIDEO_CACHE_RU, " " },
/* sv */ { IDMS_VIDEO_CACHE_SV, "Grafikcache" },
/* tr */ { IDMS_VIDEO_CACHE_TR, "Grnt nbellei" },

/* en */ { IDMS_DOUBLE_SIZE,    "Double size" },
/* da */ { IDMS_DOUBLE_SIZE_DA, "Dobbelt strrelse" },
/* de */ { IDMS_DOUBLE_SIZE_DE, "Doppelte Gre" },
/* es */ { IDMS_DOUBLE_SIZE_ES, "Tamao doble" },
/* fr */ { IDMS_DOUBLE_SIZE_FR, "Double taille" },
/* hu */ { IDMS_DOUBLE_SIZE_HU, "Dupla mret" },
/* it */ { IDMS_DOUBLE_SIZE_IT, "Dimensione doppia" },
/* ko */ { IDMS_DOUBLE_SIZE_KO, " " },
/* nl */ { IDMS_DOUBLE_SIZE_NL, "Dubbele grootte" },
/* pl */ { IDMS_DOUBLE_SIZE_PL, "Podwjny rozmiar" },
/* ru */ { IDMS_DOUBLE_SIZE_RU, " " },
/* sv */ { IDMS_DOUBLE_SIZE_SV, "Dubbel storlek" },
/* tr */ { IDMS_DOUBLE_SIZE_TR, "ift boyut" },

/* en */ { IDMS_DOUBLE_SCAN,    "Double scan" },
/* da */ { IDMS_DOUBLE_SCAN_DA, "Dobbelt-skan" },
/* de */ { IDMS_DOUBLE_SCAN_DE, "Doppelt Scan" },
/* es */ { IDMS_DOUBLE_SCAN_ES, "Doble escaneo" },
/* fr */ { IDMS_DOUBLE_SCAN_FR, "Double scan" },
/* hu */ { IDMS_DOUBLE_SCAN_HU, "Dupla psztzs" },
/* it */ { IDMS_DOUBLE_SCAN_IT, "Scansione doppia" },
/* ko */ { IDMS_DOUBLE_SCAN_KO, " ĵ" },
/* nl */ { IDMS_DOUBLE_SCAN_NL, "Dubbele scan" },
/* pl */ { IDMS_DOUBLE_SCAN_PL, "Podwjne skanowanie" },
/* ru */ { IDMS_DOUBLE_SCAN_RU, "Double scan" },
/* sv */ { IDMS_DOUBLE_SCAN_SV, "Dubbelskanning" },
/* tr */ { IDMS_DOUBLE_SCAN_TR, "ift tarama" },

/* en */ { IDMS_VERTICAL_STRETCH,    "Vertical stretch" },
/* da */ { IDMS_VERTICAL_STRETCH_DA, "Vertikal strk" },
/* de */ { IDMS_VERTICAL_STRETCH_DE, "Vertikale Dehnung" },
/* es */ { IDMS_VERTICAL_STRETCH_ES, "Extensin vertical" },
/* fr */ { IDMS_VERTICAL_STRETCH_FR, "tirement vertical" },
/* hu */ { IDMS_VERTICAL_STRETCH_HU, "" },  /* fuzzy */
/* it */ { IDMS_VERTICAL_STRETCH_IT, "Estensione verticale" },
/* ko */ { IDMS_VERTICAL_STRETCH_KO, "" },  /* fuzzy */
/* nl */ { IDMS_VERTICAL_STRETCH_NL, "Vertikale rek" },
/* pl */ { IDMS_VERTICAL_STRETCH_PL, "Rozcignicie w pionie" },
/* ru */ { IDMS_VERTICAL_STRETCH_RU, "  " },
/* sv */ { IDMS_VERTICAL_STRETCH_SV, "Vertikal strckning" },
/* tr */ { IDMS_VERTICAL_STRETCH_TR, "Dikey uzatma" },

/* en */ { IDMS_VDC_SETTINGS,    "VDC settings" },
/* da */ { IDMS_VDC_SETTINGS_DA, "VDC-indstillinger" },
/* de */ { IDMS_VDC_SETTINGS_DE, "VDC Einstellungen" },
/* es */ { IDMS_VDC_SETTINGS_ES, "Ajustes VDC" },
/* fr */ { IDMS_VDC_SETTINGS_FR, "Paramtres VDC" },
/* hu */ { IDMS_VDC_SETTINGS_HU, "VDC belltsai" },
/* it */ { IDMS_VDC_SETTINGS_IT, "Impostazioni VDC" },
/* ko */ { IDMS_VDC_SETTINGS_KO, "VDC " },
/* nl */ { IDMS_VDC_SETTINGS_NL, "VDC instellingen" },
/* pl */ { IDMS_VDC_SETTINGS_PL, "Ustawienia VDC" },
/* ru */ { IDMS_VDC_SETTINGS_RU, " VDC" },
/* sv */ { IDMS_VDC_SETTINGS_SV, "VDC-instllningar" },
/* tr */ { IDMS_VDC_SETTINGS_TR, "VDC ayarlar" },

/* en */ { IDMS_64KB_VIDEO_MEMORY,    "64KB video memory" },
/* da */ { IDMS_64KB_VIDEO_MEMORY_DA, "64KB grafikhukommelse" },
/* de */ { IDMS_64KB_VIDEO_MEMORY_DE, "64KB Bildschirm Speicher" },
/* es */ { IDMS_64KB_VIDEO_MEMORY_ES, "Memoria de vdeo 64KB" },
/* fr */ { IDMS_64KB_VIDEO_MEMORY_FR, "Mmoire vido de 64Ko" },
/* hu */ { IDMS_64KB_VIDEO_MEMORY_HU, "64KB kperny memria" },
/* it */ { IDMS_64KB_VIDEO_MEMORY_IT, "Memoria video di 64KB" },
/* ko */ { IDMS_64KB_VIDEO_MEMORY_KO, "64KB  ޸" },
/* nl */ { IDMS_64KB_VIDEO_MEMORY_NL, "64KB videogeheugen" },
/* pl */ { IDMS_64KB_VIDEO_MEMORY_PL, "Pami wideo 64KB" },
/* ru */ { IDMS_64KB_VIDEO_MEMORY_RU, "64KB video memory" },
/* sv */ { IDMS_64KB_VIDEO_MEMORY_SV, "64KB grafikminne" },
/* tr */ { IDMS_64KB_VIDEO_MEMORY_TR, "64KB grnt bellei" },

/* en */ { IDMS_VDC_REVISION,    "VDC revision" },
/* da */ { IDMS_VDC_REVISION_DA, "VDC-revision" },
/* de */ { IDMS_VDC_REVISION_DE, "VDC Revision" },
/* es */ { IDMS_VDC_REVISION_ES, "Revisin VDC" },
/* fr */ { IDMS_VDC_REVISION_FR, "Rvision VDC" },
/* hu */ { IDMS_VDC_REVISION_HU, "VDC vltozat" },
/* it */ { IDMS_VDC_REVISION_IT, "Revisione VDC" },
/* ko */ { IDMS_VDC_REVISION_KO, "" },  /* fuzzy */
/* nl */ { IDMS_VDC_REVISION_NL, "VDC revisie" },
/* pl */ { IDMS_VDC_REVISION_PL, "Wersja VDC" },
/* ru */ { IDMS_VDC_REVISION_RU, "VDC revision" },
/* sv */ { IDMS_VDC_REVISION_SV, "VDC-revision" },
/* tr */ { IDMS_VDC_REVISION_TR, "VDC revizyonu" },

/* en */ { IDMS_VDC_REV_0,    "Rev 0" },
/* da */ { IDMS_VDC_REV_0_DA, "Udgave 0" },
/* de */ { IDMS_VDC_REV_0_DE, "Rev 0" },
/* es */ { IDMS_VDC_REV_0_ES, "Rev 0" },
/* fr */ { IDMS_VDC_REV_0_FR, "Rv 0" },
/* hu */ { IDMS_VDC_REV_0_HU, "0-s vltozat" },
/* it */ { IDMS_VDC_REV_0_IT, "Rev 0" },
/* ko */ { IDMS_VDC_REV_0_KO, " 0" },
/* nl */ { IDMS_VDC_REV_0_NL, "Revisie 0" },
/* pl */ { IDMS_VDC_REV_0_PL, "Rev 0" },
/* ru */ { IDMS_VDC_REV_0_RU, "Rev 0" },
/* sv */ { IDMS_VDC_REV_0_SV, "Utgva 0" },
/* tr */ { IDMS_VDC_REV_0_TR, "Rev 0" },

/* en */ { IDMS_VDC_REV_1,    "Rev 1" },
/* da */ { IDMS_VDC_REV_1_DA, "Udgave 1" },
/* de */ { IDMS_VDC_REV_1_DE, "Rev 1" },
/* es */ { IDMS_VDC_REV_1_ES, "Rev 1" },
/* fr */ { IDMS_VDC_REV_1_FR, "Rv 1" },
/* hu */ { IDMS_VDC_REV_1_HU, "1-es vltozat" },
/* it */ { IDMS_VDC_REV_1_IT, "Rev 1" },
/* ko */ { IDMS_VDC_REV_1_KO, " 1" },
/* nl */ { IDMS_VDC_REV_1_NL, "Revisie 1" },
/* pl */ { IDMS_VDC_REV_1_PL, "Rev 1" },
/* ru */ { IDMS_VDC_REV_1_RU, "Rev 1" },
/* sv */ { IDMS_VDC_REV_1_SV, "Utgva 1" },
/* tr */ { IDMS_VDC_REV_1_TR, "Rev 1" },

/* en */ { IDMS_VDC_REV_2,    "Rev 2" },
/* da */ { IDMS_VDC_REV_2_DA, "Udgave 2" },
/* de */ { IDMS_VDC_REV_2_DE, "Rev 2" },
/* es */ { IDMS_VDC_REV_2_ES, "Rev 2" },
/* fr */ { IDMS_VDC_REV_2_FR, "Rv 2" },
/* hu */ { IDMS_VDC_REV_2_HU, "2-es vltozat" },
/* it */ { IDMS_VDC_REV_2_IT, "Rev 2" },
/* ko */ { IDMS_VDC_REV_2_KO, " 2" },
/* nl */ { IDMS_VDC_REV_2_NL, "Revisie 2" },
/* pl */ { IDMS_VDC_REV_2_PL, "Rev 2" },
/* ru */ { IDMS_VDC_REV_2_RU, "Rev 2" },
/* sv */ { IDMS_VDC_REV_2_SV, "Utgva 2" },
/* tr */ { IDMS_VDC_REV_2_TR, "Rev 2" },

/* en */ { IDMS_SWAP_JOYSTICKS,    "Swap joysticks" },
/* da */ { IDMS_SWAP_JOYSTICKS_DA, "Byt om p joystickportene" },
/* de */ { IDMS_SWAP_JOYSTICKS_DE, "Joystick ports austauschen" },
/* es */ { IDMS_SWAP_JOYSTICKS_ES, "Intercambiar joysticks" },
/* fr */ { IDMS_SWAP_JOYSTICKS_FR, "Permuter les ports Joysticks" },
/* hu */ { IDMS_SWAP_JOYSTICKS_HU, "" },  /* fuzzy */
/* it */ { IDMS_SWAP_JOYSTICKS_IT, "Scambia joystick" },
/* ko */ { IDMS_SWAP_JOYSTICKS_KO, "̽ƽ ٲټ" },
/* nl */ { IDMS_SWAP_JOYSTICKS_NL, "Verwissel joysticks" },
/* pl */ { IDMS_SWAP_JOYSTICKS_PL, "Zamie joysticki" },
/* ru */ { IDMS_SWAP_JOYSTICKS_RU, "Swap joysticks" },
/* sv */ { IDMS_SWAP_JOYSTICKS_SV, "Vxla spelportarna" },
/* tr */ { IDMS_SWAP_JOYSTICKS_TR, "Joystickleri deitir" },

/* en */ { IDMS_SWAP_USERPORT_JOYSTICKS,    "Swap userport joysticks" },
/* da */ { IDMS_SWAP_USERPORT_JOYSTICKS_DA, "Byt om p brugerportjoysticks" },
/* de */ { IDMS_SWAP_USERPORT_JOYSTICKS_DE, "Userport Joystick ports austauschen" },
/* es */ { IDMS_SWAP_USERPORT_JOYSTICKS_ES, "Intercambiar puertos joysticks" },
/* fr */ { IDMS_SWAP_USERPORT_JOYSTICKS_FR, "Permuter les joysticks de port" },
/* hu */ { IDMS_SWAP_USERPORT_JOYSTICKS_HU, "" },  /* fuzzy */
/* it */ { IDMS_SWAP_USERPORT_JOYSTICKS_IT, "Scambia joystick su userport" },
/* ko */ { IDMS_SWAP_USERPORT_JOYSTICKS_KO, "Ʈ ̽ƽ ٲټ" },
/* nl */ { IDMS_SWAP_USERPORT_JOYSTICKS_NL, "Verwissel userport joysticks" },
/* pl */ { IDMS_SWAP_USERPORT_JOYSTICKS_PL, "Zamie joysticki w userportach" },
/* ru */ { IDMS_SWAP_USERPORT_JOYSTICKS_RU, "Swap userport joysticks" },
/* sv */ { IDMS_SWAP_USERPORT_JOYSTICKS_SV, "Vxla anvndarportstyrspakar" },
/* tr */ { IDMS_SWAP_USERPORT_JOYSTICKS_TR, "Userport joysticklerini yer deitir" },

/* en */ { IDMS_CGA_USERPORT_JOY_ADAPTER,    "CGA userport joy adapter" },
/* da */ { IDMS_CGA_USERPORT_JOY_ADAPTER_DA, "CGA brugerportjoystickadapter" },
/* de */ { IDMS_CGA_USERPORT_JOY_ADAPTER_DE, "CGA Userport Joystick Adapter" },
/* es */ { IDMS_CGA_USERPORT_JOY_ADAPTER_ES, "Adaptador de puerto de juegos CGA" },
/* fr */ { IDMS_CGA_USERPORT_JOY_ADAPTER_FR, "Adaptateur joystick port utilisateur CGA" },
/* hu */ { IDMS_CGA_USERPORT_JOY_ADAPTER_HU, "CGA userport botkormny adapter" },
/* it */ { IDMS_CGA_USERPORT_JOY_ADAPTER_IT, "Adattatore joystick CGA su userport" },
/* ko */ { IDMS_CGA_USERPORT_JOY_ADAPTER_KO, "CGA Ʈ  ƴ" },
/* nl */ { IDMS_CGA_USERPORT_JOY_ADAPTER_NL, "CGA userport joy adapter" },
/* pl */ { IDMS_CGA_USERPORT_JOY_ADAPTER_PL, "Zcze CGA userportu joysticka" },
/* ru */ { IDMS_CGA_USERPORT_JOY_ADAPTER_RU, "CGA userport joy adapter" },
/* sv */ { IDMS_CGA_USERPORT_JOY_ADAPTER_SV, "CGA-anvndarportsspakadapter" },
/* tr */ { IDMS_CGA_USERPORT_JOY_ADAPTER_TR, "CGA userport joy dntrc" },

/* en */ { IDMS_PET_USERPORT_JOY_ADAPTER,    "PET userport joy adapter" },
/* da */ { IDMS_PET_USERPORT_JOY_ADAPTER_DA, "PET brugerportjoystickadapter" },
/* de */ { IDMS_PET_USERPORT_JOY_ADAPTER_DE, "PET Userport Joystick Adapter" },
/* es */ { IDMS_PET_USERPORT_JOY_ADAPTER_ES, "Adaptador de puerto de juegos PET" },
/* fr */ { IDMS_PET_USERPORT_JOY_ADAPTER_FR, "Adaptateur joystick port utilisateur PET" },
/* hu */ { IDMS_PET_USERPORT_JOY_ADAPTER_HU, "PET userport botkormny adapter" },
/* it */ { IDMS_PET_USERPORT_JOY_ADAPTER_IT, "Adattatore joystick PET su userport" },
/* ko */ { IDMS_PET_USERPORT_JOY_ADAPTER_KO, "PET Ʈ  ƴ" },
/* nl */ { IDMS_PET_USERPORT_JOY_ADAPTER_NL, "PET userport joy adapter" },
/* pl */ { IDMS_PET_USERPORT_JOY_ADAPTER_PL, "Zcze PET userportu joysticka" },
/* ru */ { IDMS_PET_USERPORT_JOY_ADAPTER_RU, "PET userport joy adapter" },
/* sv */ { IDMS_PET_USERPORT_JOY_ADAPTER_SV, "PET-anvndarportsspakadapter" },
/* tr */ { IDMS_PET_USERPORT_JOY_ADAPTER_TR, "PET userport joy dntrc" },

/* en */ { IDMS_HUMMER_USERPORT_JOY_ADAPTER,    "Hummer userport joy adapter" },
/* da */ { IDMS_HUMMER_USERPORT_JOY_ADAPTER_DA, "Hummer brugerport joystick adapter" },
/* de */ { IDMS_HUMMER_USERPORT_JOY_ADAPTER_DE, "Hummer Userport Joystick Adapter" },
/* es */ { IDMS_HUMMER_USERPORT_JOY_ADAPTER_ES, "Adaptador de puerto de juegos Hummer" },
/* fr */ { IDMS_HUMMER_USERPORT_JOY_ADAPTER_FR, "Adaptateur joystick port utilisateur Hummer" },
/* hu */ { IDMS_HUMMER_USERPORT_JOY_ADAPTER_HU, "" },  /* fuzzy */
/* it */ { IDMS_HUMMER_USERPORT_JOY_ADAPTER_IT, "Adattatore joystick HUMMER su userport" },
/* ko */ { IDMS_HUMMER_USERPORT_JOY_ADAPTER_KO, "Hummer Ʈ  ƴ" },
/* nl */ { IDMS_HUMMER_USERPORT_JOY_ADAPTER_NL, "Hummer userport joystick adapter" },
/* pl */ { IDMS_HUMMER_USERPORT_JOY_ADAPTER_PL, "Zcze Hummer userportu joysticka" },
/* ru */ { IDMS_HUMMER_USERPORT_JOY_ADAPTER_RU, "Hummer userport joy adapter" },
/* sv */ { IDMS_HUMMER_USERPORT_JOY_ADAPTER_SV, "Hummer-anvndarportsspakadapter" },
/* tr */ { IDMS_HUMMER_USERPORT_JOY_ADAPTER_TR, "Hummer userport joy dntrc" },

/* en */ { IDMS_OEM_USERPORT_JOY_ADAPTER,    "OEM userport joy adapter" },
/* da */ { IDMS_OEM_USERPORT_JOY_ADAPTER_DA, "OEM brugerportjoystickadapter" },
/* de */ { IDMS_OEM_USERPORT_JOY_ADAPTER_DE, "OEM Userport Joystick Adapter" },
/* es */ { IDMS_OEM_USERPORT_JOY_ADAPTER_ES, "Adaptador de puerto de juegos OEM" },
/* fr */ { IDMS_OEM_USERPORT_JOY_ADAPTER_FR, "Adaptateur joystick port utilisateur OEM" },
/* hu */ { IDMS_OEM_USERPORT_JOY_ADAPTER_HU, "OEM userport botkormny adapter" },
/* it */ { IDMS_OEM_USERPORT_JOY_ADAPTER_IT, "Adattatore joystick OEM su userport" },
/* ko */ { IDMS_OEM_USERPORT_JOY_ADAPTER_KO, "OEM Ʈ  ƴ" },
/* nl */ { IDMS_OEM_USERPORT_JOY_ADAPTER_NL, "OEM userport joy adapter" },
/* pl */ { IDMS_OEM_USERPORT_JOY_ADAPTER_PL, "Zcze OEM userportu joysticka" },
/* ru */ { IDMS_OEM_USERPORT_JOY_ADAPTER_RU, "OEM userport joy adapter" },
/* sv */ { IDMS_OEM_USERPORT_JOY_ADAPTER_SV, "OEM-anvndarportsspakadapter" },
/* tr */ { IDMS_OEM_USERPORT_JOY_ADAPTER_TR, "OEM userport joy dntrc" },

/* en */ { IDMS_HIT_USERPORT_JOY_ADAPTER,    "HIT userport joy adapter" },
/* da */ { IDMS_HIT_USERPORT_JOY_ADAPTER_DA, "HIT brugerportjoystickadapter" },
/* de */ { IDMS_HIT_USERPORT_JOY_ADAPTER_DE, "HIT Userport Joystick Adapter" },
/* es */ { IDMS_HIT_USERPORT_JOY_ADAPTER_ES, "Adaptador de puerto de juegos HIT" },
/* fr */ { IDMS_HIT_USERPORT_JOY_ADAPTER_FR, "Adaptateur joystick port utilisateur HIT" },
/* hu */ { IDMS_HIT_USERPORT_JOY_ADAPTER_HU, "HIT userport botkormny adapter" },
/* it */ { IDMS_HIT_USERPORT_JOY_ADAPTER_IT, "Adattatore joystick HIT su userport" },
/* ko */ { IDMS_HIT_USERPORT_JOY_ADAPTER_KO, "HIT Ʈ  ƴ" },
/* nl */ { IDMS_HIT_USERPORT_JOY_ADAPTER_NL, "HIT userport joy adapter" },
/* pl */ { IDMS_HIT_USERPORT_JOY_ADAPTER_PL, "Zcze HIT userportu joysticka" },
/* ru */ { IDMS_HIT_USERPORT_JOY_ADAPTER_RU, "HIT userport joy adapter" },
/* sv */ { IDMS_HIT_USERPORT_JOY_ADAPTER_SV, "HIT-anvndarportsspakadapter" },
/* tr */ { IDMS_HIT_USERPORT_JOY_ADAPTER_TR, "HIT userport joy dntrc" },

/* en */ { IDMS_KINGSOFT_USERPORT_JOY_ADAPTER,    "Kingsoft userport joy adapter" },
/* da */ { IDMS_KINGSOFT_USERPORT_JOY_ADAPTER_DA, "Kingsoft brugerportjoystickadapter" },
/* de */ { IDMS_KINGSOFT_USERPORT_JOY_ADAPTER_DE, "Kingsoft Userport Joystick Adapter" },
/* es */ { IDMS_KINGSOFT_USERPORT_JOY_ADAPTER_ES, "Adaptador puerto joy Kingsoft" },
/* fr */ { IDMS_KINGSOFT_USERPORT_JOY_ADAPTER_FR, "Adaptateur joystick port utilisateur Kingsoft" },
/* hu */ { IDMS_KINGSOFT_USERPORT_JOY_ADAPTER_HU, "" },  /* fuzzy */
/* it */ { IDMS_KINGSOFT_USERPORT_JOY_ADAPTER_IT, "Adattatore joystick Kingsoft su userport" },
/* ko */ { IDMS_KINGSOFT_USERPORT_JOY_ADAPTER_KO, "" },  /* fuzzy */
/* nl */ { IDMS_KINGSOFT_USERPORT_JOY_ADAPTER_NL, "Kingsoft userport joy adapter" },
/* pl */ { IDMS_KINGSOFT_USERPORT_JOY_ADAPTER_PL, "Zcze userportu joysticka Kingsoft" },
/* ru */ { IDMS_KINGSOFT_USERPORT_JOY_ADAPTER_RU, "" },  /* fuzzy */
/* sv */ { IDMS_KINGSOFT_USERPORT_JOY_ADAPTER_SV, "Kingsoft anvndarportsspakadapter" },
/* tr */ { IDMS_KINGSOFT_USERPORT_JOY_ADAPTER_TR, "Kingsoft userport joy dntrc" },

/* en */ { IDMS_STARBYTE_USERPORT_JOY_ADAPTER,    "Starbyte userport joy adapter" },
/* da */ { IDMS_STARBYTE_USERPORT_JOY_ADAPTER_DA, "Starbyte brugerportjoystickadapter" },
/* de */ { IDMS_STARBYTE_USERPORT_JOY_ADAPTER_DE, "Starbyte Userport Joystick Adapter" },
/* es */ { IDMS_STARBYTE_USERPORT_JOY_ADAPTER_ES, "Adaptador puerto joy Starbyte" },
/* fr */ { IDMS_STARBYTE_USERPORT_JOY_ADAPTER_FR, "Adaptateur joystick port utilisateur Starbyte" },
/* hu */ { IDMS_STARBYTE_USERPORT_JOY_ADAPTER_HU, "" },  /* fuzzy */
/* it */ { IDMS_STARBYTE_USERPORT_JOY_ADAPTER_IT, "Adattatore joystick Starbyte su userport " },
/* ko */ { IDMS_STARBYTE_USERPORT_JOY_ADAPTER_KO, "" },  /* fuzzy */
/* nl */ { IDMS_STARBYTE_USERPORT_JOY_ADAPTER_NL, "Starbyte userport joy adapter" },
/* pl */ { IDMS_STARBYTE_USERPORT_JOY_ADAPTER_PL, "Zcze userportu joysticka Starbyte" },
/* ru */ { IDMS_STARBYTE_USERPORT_JOY_ADAPTER_RU, "" },  /* fuzzy */
/* sv */ { IDMS_STARBYTE_USERPORT_JOY_ADAPTER_SV, "Starbyte anvndarportsspakadapter" },
/* tr */ { IDMS_STARBYTE_USERPORT_JOY_ADAPTER_TR, "Starbyte userport joy dntrc" },

/* en */ { IDMS_ENABLE_JOY_KEYS,    "Enable Joy Keys" },
/* da */ { IDMS_ENABLE_JOY_KEYS_DA, "Aktivr joystick via keyboard" },
/* de */ { IDMS_ENABLE_JOY_KEYS_DE, "Joystick Tasten aktivieren" },
/* es */ { IDMS_ENABLE_JOY_KEYS_ES, "Permitir Teclas en joy" },
/* fr */ { IDMS_ENABLE_JOY_KEYS_FR, "Activer les touches joystick" },
/* hu */ { IDMS_ENABLE_JOY_KEYS_HU, "Botkormny gombok engedlyezse" },
/* it */ { IDMS_ENABLE_JOY_KEYS_IT, "Attiva tasti joystick" },
/* ko */ { IDMS_ENABLE_JOY_KEYS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_ENABLE_JOY_KEYS_NL, "Activeer Joy Keys" },
/* pl */ { IDMS_ENABLE_JOY_KEYS_PL, "Wcz klawisze joysticka" },
/* ru */ { IDMS_ENABLE_JOY_KEYS_RU, "Enable Joy Keys" },
/* sv */ { IDMS_ENABLE_JOY_KEYS_SV, "Aktivera styrspak via tangenter" },
/* tr */ { IDMS_ENABLE_JOY_KEYS_TR, "Joy Tularn Aktif Et" },

/* en */ { IDMS_OPPOSITE_JOY_DIR,    "Allow opposite directions" },
/* da */ { IDMS_OPPOSITE_JOY_DIR_DA, "Tillad modsatte retninger" },
/* de */ { IDMS_OPPOSITE_JOY_DIR_DE, "Gegenberliegende Richtungen zulassen" },
/* es */ { IDMS_OPPOSITE_JOY_DIR_ES, "Permitir direcciones opuestas" },
/* fr */ { IDMS_OPPOSITE_JOY_DIR_FR, "Permettre des directions opposes simultanment" },
/* hu */ { IDMS_OPPOSITE_JOY_DIR_HU, "" },  /* fuzzy */
/* it */ { IDMS_OPPOSITE_JOY_DIR_IT, "Consenti direzioni opposte" },
/* ko */ { IDMS_OPPOSITE_JOY_DIR_KO, "ݴ  㰡ϱ" },
/* nl */ { IDMS_OPPOSITE_JOY_DIR_NL, "Tegenovergestelde richtingen toestaan" },
/* pl */ { IDMS_OPPOSITE_JOY_DIR_PL, "Pozwl na przeciwstawne kierunki" },
/* ru */ { IDMS_OPPOSITE_JOY_DIR_RU, "Allow opposite directions" },
/* sv */ { IDMS_OPPOSITE_JOY_DIR_SV, "Tillt motsatta riktningar" },
/* tr */ { IDMS_OPPOSITE_JOY_DIR_TR, "Zt ynlere izin ver" },

/* en */ { IDMS_SOUND_PLAYBACK,    "Sound playback" },
/* da */ { IDMS_SOUND_PLAYBACK_DA, "Sl lydemulering til" },
/* de */ { IDMS_SOUND_PLAYBACK_DE, "Sound Wiedergabe" },
/* es */ { IDMS_SOUND_PLAYBACK_ES, "Reproduccin sonido" },
/* fr */ { IDMS_SOUND_PLAYBACK_FR, "Lecture audio" },
/* hu */ { IDMS_SOUND_PLAYBACK_HU, "Hangok engedlyezse" },
/* it */ { IDMS_SOUND_PLAYBACK_IT, "Riproduzione audio" },
/* ko */ { IDMS_SOUND_PLAYBACK_KO, "Ҹ " },
/* nl */ { IDMS_SOUND_PLAYBACK_NL, "Geluidsuitvoer" },
/* pl */ { IDMS_SOUND_PLAYBACK_PL, "Odtwarzanie dwiku" },
/* ru */ { IDMS_SOUND_PLAYBACK_RU, "Sound playback" },
/* sv */ { IDMS_SOUND_PLAYBACK_SV, "Aktivera ljudtergivning" },
/* tr */ { IDMS_SOUND_PLAYBACK_TR, "Ses" },

/* en */ { IDMS_TRUE_DRIVE_EMU,    "True drive emulation" },
/* da */ { IDMS_TRUE_DRIVE_EMU_DA, "gte drev-emulering" },
/* de */ { IDMS_TRUE_DRIVE_EMU_DE, "Przise Floppy Emulation" },
/* es */ { IDMS_TRUE_DRIVE_EMU_ES, "Emulacin unidad disco verdadera" },
/* fr */ { IDMS_TRUE_DRIVE_EMU_FR, "Activer l'mulation relle des lecteurs" },
/* hu */ { IDMS_TRUE_DRIVE_EMU_HU, "Vals lemezegysg emulci" },
/* it */ { IDMS_TRUE_DRIVE_EMU_IT, "Attiva emulazione hardware dei drive" },
/* ko */ { IDMS_TRUE_DRIVE_EMU_KO, "Ʈ ̺ ķ" },
/* nl */ { IDMS_TRUE_DRIVE_EMU_NL, "Hardwarematige driveemulatie" },
/* pl */ { IDMS_TRUE_DRIVE_EMU_PL, "Rzeczywista emulacja napdu" },
/* ru */ { IDMS_TRUE_DRIVE_EMU_RU, "True drive emulation" },
/* sv */ { IDMS_TRUE_DRIVE_EMU_SV, "kta diskettenhetsemulering" },
/* tr */ { IDMS_TRUE_DRIVE_EMU_TR, "Gerek src emlasyonu" },

/* en */ { IDMS_DRIVE_SOUND_SETTINGS,    "Drive sound emulation settings" },
/* da */ { IDMS_DRIVE_SOUND_SETTINGS_DA, "" },  /* fuzzy */
/* de */ { IDMS_DRIVE_SOUND_SETTINGS_DE, "Laufwerk Geruschemulation Einstellungen" },
/* es */ { IDMS_DRIVE_SOUND_SETTINGS_ES, "Ajustes Emulacin controlador de sonido" },
/* fr */ { IDMS_DRIVE_SOUND_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_DRIVE_SOUND_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_DRIVE_SOUND_SETTINGS_IT, "Impostazione emulazione suoni del drive" },
/* ko */ { IDMS_DRIVE_SOUND_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_DRIVE_SOUND_SETTINGS_NL, "Drive geluiden emulatie instellingen" },
/* pl */ { IDMS_DRIVE_SOUND_SETTINGS_PL, "Ustawienia emulacji dwikw napdu" },
/* ru */ { IDMS_DRIVE_SOUND_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_DRIVE_SOUND_SETTINGS_SV, "" },  /* fuzzy */
/* tr */ { IDMS_DRIVE_SOUND_SETTINGS_TR, "" },  /* fuzzy */

/* en */ { IDMS_AUTOSTART_HANDLE_TDE,    "Handle True Drive Emulation on autostart" },
/* da */ { IDMS_AUTOSTART_HANDLE_TDE_DA, "Anvend gte drev-emulering ved autostart" },
/* de */ { IDMS_AUTOSTART_HANDLE_TDE_DE, "Przise Floppy Emulation bei Autostart beachten" },
/* es */ { IDMS_AUTOSTART_HANDLE_TDE_ES, "Manejar en autoarranque emulacin de disco verdadera" },
/* fr */ { IDMS_AUTOSTART_HANDLE_TDE_FR, "Activer l'mulation Relle de Lecteur  l'autodmarrage" },
/* hu */ { IDMS_AUTOSTART_HANDLE_TDE_HU, "Vals lemezegysg emulci kezelse autostartnl" },
/* it */ { IDMS_AUTOSTART_HANDLE_TDE_IT, "Emulazione hardware dei drive all'avvio automatico" },
/* ko */ { IDMS_AUTOSTART_HANDLE_TDE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_AUTOSTART_HANDLE_TDE_NL, "Manipuleer hardwarematige drive emulatie bij autostarten" },
/* pl */ { IDMS_AUTOSTART_HANDLE_TDE_PL, "Wcz rzeczywist emulacj napdu przy autostarcie" },
/* ru */ { IDMS_AUTOSTART_HANDLE_TDE_RU, "Handle True Drive Emulation on autostart" },
/* sv */ { IDMS_AUTOSTART_HANDLE_TDE_SV, "Hantera kta diskettenhetsemulering vid autostart" },
/* tr */ { IDMS_AUTOSTART_HANDLE_TDE_TR, "Otomatik balatmada Gerek Src Emlasyonu'nu denetle" },

/* en */ { IDMS_VIRTUAL_DEVICE_TRAPS,    "Virtual device traps" },
/* da */ { IDMS_VIRTUAL_DEVICE_TRAPS_DA, "Virtuelle enheds-traps" },
/* de */ { IDMS_VIRTUAL_DEVICE_TRAPS_DE, "Virtuelle Gerte Traps" },
/* es */ { IDMS_VIRTUAL_DEVICE_TRAPS_ES, "Interceptar perifricos virtuales" },
/* fr */ { IDMS_VIRTUAL_DEVICE_TRAPS_FR, "Activer les priphriques virtuels" },
/* hu */ { IDMS_VIRTUAL_DEVICE_TRAPS_HU, "Virtulis eszkzk ciklus kihagysa" },
/* it */ { IDMS_VIRTUAL_DEVICE_TRAPS_IT, "Attiva periferiche virtuali" },
/* ko */ { IDMS_VIRTUAL_DEVICE_TRAPS_KO, " ̽ Ʈ" },
/* nl */ { IDMS_VIRTUAL_DEVICE_TRAPS_NL, "Virtuele apparaattraps" },
/* pl */ { IDMS_VIRTUAL_DEVICE_TRAPS_PL, "Traps urzdzenia wirtualnego." },
/* ru */ { IDMS_VIRTUAL_DEVICE_TRAPS_RU, "Virtual device traps" },
/* sv */ { IDMS_VIRTUAL_DEVICE_TRAPS_SV, "Virtuella enhetstrap:ar" },
/* tr */ { IDMS_VIRTUAL_DEVICE_TRAPS_TR, "Sanal aygt trapleri" },

/* en */ { IDMS_DRIVE_SYNC_FACTOR,    "Drive sync factor" },
/* da */ { IDMS_DRIVE_SYNC_FACTOR_DA, "Synkfaktor for diskettedrev" },
/* de */ { IDMS_DRIVE_SYNC_FACTOR_DE, "Laufwerkt Sync Faktor" },
/* es */ { IDMS_DRIVE_SYNC_FACTOR_ES, "Factor sincronizacin unidad disco" },
/* fr */ { IDMS_DRIVE_SYNC_FACTOR_FR, "Facteur de synchro du lecteur" },
/* hu */ { IDMS_DRIVE_SYNC_FACTOR_HU, "Lemezegysg szinkron faktor" },
/* it */ { IDMS_DRIVE_SYNC_FACTOR_IT, "Fattore di sincronizzazione del drive" },
/* ko */ { IDMS_DRIVE_SYNC_FACTOR_KO, "" },  /* fuzzy */
/* nl */ { IDMS_DRIVE_SYNC_FACTOR_NL, "Drive synchronisatiefactor" },
/* pl */ { IDMS_DRIVE_SYNC_FACTOR_PL, "Czynnik synchronizacji stacji" },
/* ru */ { IDMS_DRIVE_SYNC_FACTOR_RU, "Drive sync factor" },
/* sv */ { IDMS_DRIVE_SYNC_FACTOR_SV, "Synkfaktor fr diskettstation" },
/* tr */ { IDMS_DRIVE_SYNC_FACTOR_TR, "Src senkron faktr" },

/* en */ { IDMS_PAL,    "PAL" },
/* da */ { IDMS_PAL_DA, "PAL-G" },
/* de */ { IDMS_PAL_DE, "PAL" },
/* es */ { IDMS_PAL_ES, "PAL" },
/* fr */ { IDMS_PAL_FR, "PAL" },
/* hu */ { IDMS_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_PAL_IT, "PAL" },
/* ko */ { IDMS_PAL_KO, "" },  /* fuzzy */
/* nl */ { IDMS_PAL_NL, "PAL" },
/* pl */ { IDMS_PAL_PL, "PAL" },
/* ru */ { IDMS_PAL_RU, "PAL" },
/* sv */ { IDMS_PAL_SV, "PAL" },
/* tr */ { IDMS_PAL_TR, "PAL" },

/* en */ { IDMS_NTSC,    "NTSC" },
/* da */ { IDMS_NTSC_DA, "NTSC-M" },
/* de */ { IDMS_NTSC_DE, "NTSC" },
/* es */ { IDMS_NTSC_ES, "NTSC" },
/* fr */ { IDMS_NTSC_FR, "NTSC" },
/* hu */ { IDMS_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_NTSC_IT, "NTSC" },
/* ko */ { IDMS_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_NTSC_NL, "NTSC" },
/* pl */ { IDMS_NTSC_PL, "NTSC" },
/* ru */ { IDMS_NTSC_RU, "NTSC" },
/* sv */ { IDMS_NTSC_SV, "NTSC-M" },
/* tr */ { IDMS_NTSC_TR, "NTSC" },

/* en */ { IDMS_VIDEO_STANDARD,    "Video standard" },
/* da */ { IDMS_VIDEO_STANDARD_DA, "TV-standard" },
/* de */ { IDMS_VIDEO_STANDARD_DE, "Video Standard" },
/* es */ { IDMS_VIDEO_STANDARD_ES, "Vdeo estandar" },
/* fr */ { IDMS_VIDEO_STANDARD_FR, "Standard vido" },
/* hu */ { IDMS_VIDEO_STANDARD_HU, "Vide szabvny" },
/* it */ { IDMS_VIDEO_STANDARD_IT, "Standard video" },
/* ko */ { IDMS_VIDEO_STANDARD_KO, "ǥ " },
/* nl */ { IDMS_VIDEO_STANDARD_NL, "Videostandaard" },
/* pl */ { IDMS_VIDEO_STANDARD_PL, "Standard wideo" },
/* ru */ { IDMS_VIDEO_STANDARD_RU, " " },
/* sv */ { IDMS_VIDEO_STANDARD_SV, "TV-standard" },
/* tr */ { IDMS_VIDEO_STANDARD_TR, "Grnt standard" },

/* en */ { IDMS_PAL_G,    "PAL-G" },
/* da */ { IDMS_PAL_G_DA, "PAL-G" },
/* de */ { IDMS_PAL_G_DE, "PAL-G" },
/* es */ { IDMS_PAL_G_ES, "PAL-G" },
/* fr */ { IDMS_PAL_G_FR, "PAL-G" },
/* hu */ { IDMS_PAL_G_HU, "" },  /* fuzzy */
/* it */ { IDMS_PAL_G_IT, "PAL-G" },
/* ko */ { IDMS_PAL_G_KO, "" },  /* fuzzy */
/* nl */ { IDMS_PAL_G_NL, "PAL-G" },
/* pl */ { IDMS_PAL_G_PL, "PAL-G" },
/* ru */ { IDMS_PAL_G_RU, "PAL-G" },
/* sv */ { IDMS_PAL_G_SV, "PAL-G" },
/* tr */ { IDMS_PAL_G_TR, "PAL-G" },

/* en */ { IDMS_NTSC_M,    "NTSC-M" },
/* da */ { IDMS_NTSC_M_DA, "NTSC-M" },
/* de */ { IDMS_NTSC_M_DE, "NTSC-M" },
/* es */ { IDMS_NTSC_M_ES, "NTSC-M" },
/* fr */ { IDMS_NTSC_M_FR, "NTSC-M" },
/* hu */ { IDMS_NTSC_M_HU, "" },  /* fuzzy */
/* it */ { IDMS_NTSC_M_IT, "NTSC-M" },
/* ko */ { IDMS_NTSC_M_KO, "" },  /* fuzzy */
/* nl */ { IDMS_NTSC_M_NL, "NTSC-M" },
/* pl */ { IDMS_NTSC_M_PL, "NTSC-M" },
/* ru */ { IDMS_NTSC_M_RU, "NTSC-M" },
/* sv */ { IDMS_NTSC_M_SV, "NTSC-M" },
/* tr */ { IDMS_NTSC_M_TR, "NTSC-M" },

/* en */ { IDMS_OLD_NTSC_M,    "Old NTSC-M" },
/* da */ { IDMS_OLD_NTSC_M_DA, "Gammel NTSC-M" },
/* de */ { IDMS_OLD_NTSC_M_DE, "NTSC-M alt" },
/* es */ { IDMS_OLD_NTSC_M_ES, "Antiguo NTSC-M" },
/* fr */ { IDMS_OLD_NTSC_M_FR, "Ancien NTSC-M" },
/* hu */ { IDMS_OLD_NTSC_M_HU, "Rgi NTSC-M" },
/* it */ { IDMS_OLD_NTSC_M_IT, "NTSC-M vecchio" },
/* ko */ { IDMS_OLD_NTSC_M_KO, "õ NTSC-M" },
/* nl */ { IDMS_OLD_NTSC_M_NL, "Oud NTSC-M" },
/* pl */ { IDMS_OLD_NTSC_M_PL, "Stary NTSC-M" },
/* ru */ { IDMS_OLD_NTSC_M_RU, "Old NTSC-M" },
/* sv */ { IDMS_OLD_NTSC_M_SV, "Gammal NTSC-M" },
/* tr */ { IDMS_OLD_NTSC_M_TR, "Eski NTSC-M" },

/* en */ { IDMS_VIC_1112_IEEE_488,    "VIC-1112 IEEE-488 module" },
/* da */ { IDMS_VIC_1112_IEEE_488_DA, "VIC-1112 IEEE-488-modul" },
/* de */ { IDMS_VIC_1112_IEEE_488_DE, "VIC-1112 IEEE-488 Modul" },
/* es */ { IDMS_VIC_1112_IEEE_488_ES, "Mdulo VIC-1112 IEEE-488" },
/* fr */ { IDMS_VIC_1112_IEEE_488_FR, "Module VIC-1112 IEEE 488" },
/* hu */ { IDMS_VIC_1112_IEEE_488_HU, "" },  /* fuzzy */
/* it */ { IDMS_VIC_1112_IEEE_488_IT, "Modulo VIC-1112 IEEE-488" },
/* ko */ { IDMS_VIC_1112_IEEE_488_KO, "" },  /* fuzzy */
/* nl */ { IDMS_VIC_1112_IEEE_488_NL, "VIC-1112 IEEE-488 module" },
/* pl */ { IDMS_VIC_1112_IEEE_488_PL, "Modu IEEE-488 VIC-1112" },
/* ru */ { IDMS_VIC_1112_IEEE_488_RU, "VIC-1112 IEEE-488 module" },
/* sv */ { IDMS_VIC_1112_IEEE_488_SV, "VIC-1112 IEEE-488-modul" },
/* tr */ { IDMS_VIC_1112_IEEE_488_TR, "VIC-1112 IEEE-488 modl" },

/* en */ { IDMS_IEEE_488_INTERFACE,    "IEEE488 Interface emulation" },
/* da */ { IDMS_IEEE_488_INTERFACE_DA, "Emulering af IEEE488-interface" },
/* de */ { IDMS_IEEE_488_INTERFACE_DE, "IEEE488 Schnittstellen-Emulation" },
/* es */ { IDMS_IEEE_488_INTERFACE_ES, "Emulacin de interface IEEE488" },
/* fr */ { IDMS_IEEE_488_INTERFACE_FR, "Interface d'mulation IEEE488" },
/* hu */ { IDMS_IEEE_488_INTERFACE_HU, "" },  /* fuzzy */
/* it */ { IDMS_IEEE_488_INTERFACE_IT, "Emulazione interfaccia IEEE488" },
/* ko */ { IDMS_IEEE_488_INTERFACE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_IEEE_488_INTERFACE_NL, "IEEE488 Interface emulatie" },
/* pl */ { IDMS_IEEE_488_INTERFACE_PL, "Emulacja interfejsu IEEE488" },
/* ru */ { IDMS_IEEE_488_INTERFACE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_IEEE_488_INTERFACE_SV, "Emulering av IEEE488-grnssnitt" },
/* tr */ { IDMS_IEEE_488_INTERFACE_TR, "IEEE488 Arabirimi emlasyonu" },

/* en */ { IDMS_GRAB_MOUSE,    "Grab mouse events" },
/* da */ { IDMS_GRAB_MOUSE_DA, "Fang mussehndelser" },
/* de */ { IDMS_GRAB_MOUSE_DE, "Maus Ereignisse abfangen" },
/* es */ { IDMS_GRAB_MOUSE_ES, "Capturar eventos del ratn" },
/* fr */ { IDMS_GRAB_MOUSE_FR, "Attraper les vnements souris" },
/* hu */ { IDMS_GRAB_MOUSE_HU, "Egr esemnyek elkapsa" },
/* it */ { IDMS_GRAB_MOUSE_IT, "Cattura eventi mouse" },
/* ko */ { IDMS_GRAB_MOUSE_KO, "׷ 콺 ̺Ʈ" },
/* nl */ { IDMS_GRAB_MOUSE_NL, "Gebruik de muis" },
/* pl */ { IDMS_GRAB_MOUSE_PL, "Przechwytuj zdarzenia myszy" },
/* ru */ { IDMS_GRAB_MOUSE_RU, "Grab mouse events" },
/* sv */ { IDMS_GRAB_MOUSE_SV, "Fnga mushndelser" },
/* tr */ { IDMS_GRAB_MOUSE_TR, "Mouse olaylarn yakala" },

/* en */ { IDMS_PS2_MOUSE,    "PS/2 mouse on Userport" },
/* da */ { IDMS_PS2_MOUSE_DA, "PS/2-mus p brugerporten" },
/* de */ { IDMS_PS2_MOUSE_DE, "PS/2 Userport Mausemulation" },
/* es */ { IDMS_PS2_MOUSE_ES, "Ratn PS/2 en puerto usuario" },
/* fr */ { IDMS_PS2_MOUSE_FR, "Souris PS/2 sur port utilisateur" },
/* hu */ { IDMS_PS2_MOUSE_HU, "PS/2 egr a userporton" },
/* it */ { IDMS_PS2_MOUSE_IT, "Mouse PS/2 su userport" },
/* ko */ { IDMS_PS2_MOUSE_KO, "Ʈ PS/S 콺 " },
/* nl */ { IDMS_PS2_MOUSE_NL, "Aktiveer emulatie van een PS/2 muis op de userport" },
/* pl */ { IDMS_PS2_MOUSE_PL, "Mysz PS/2 w userporcie" },
/* ru */ { IDMS_PS2_MOUSE_RU, "PS/2 mouse on Userport" },
/* sv */ { IDMS_PS2_MOUSE_SV, "PS/2-mus p anvndarport" },
/* tr */ { IDMS_PS2_MOUSE_TR, "Userport zerinde PS/2 mouse" },

/* en */ { IDMS_SETTINGS,    "Settings" },
/* da */ { IDMS_SETTINGS_DA, "Indstillinger" },
/* de */ { IDMS_SETTINGS_DE, "Einstellungen" },
/* es */ { IDMS_SETTINGS_ES, "Ajustes" },
/* fr */ { IDMS_SETTINGS_FR, "Paramtres" },
/* hu */ { IDMS_SETTINGS_HU, "Belltsok" },
/* it */ { IDMS_SETTINGS_IT, "Impostazioni" },
/* ko */ { IDMS_SETTINGS_KO, "" },
/* nl */ { IDMS_SETTINGS_NL, "Instellingen" },
/* pl */ { IDMS_SETTINGS_PL, "Ustawienia" },
/* ru */ { IDMS_SETTINGS_RU, "" },
/* sv */ { IDMS_SETTINGS_SV, "Instllningar" },
/* tr */ { IDMS_SETTINGS_TR, "Ayarlar" },

/* en */ { IDMS_C64_MODEL_SETTINGS,    "C64 model settings..." },
/* da */ { IDMS_C64_MODEL_SETTINGS_DA, "C64-model indstillinger..." },
/* de */ { IDMS_C64_MODEL_SETTINGS_DE, "C64 Modell Einstellungen..." },
/* es */ { IDMS_C64_MODEL_SETTINGS_ES, "Ajustes modelo C64..." },
/* fr */ { IDMS_C64_MODEL_SETTINGS_FR, "Paramtres du modle C64..." },
/* hu */ { IDMS_C64_MODEL_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64_MODEL_SETTINGS_IT, "Impostazioni modello C64..." },
/* ko */ { IDMS_C64_MODEL_SETTINGS_KO, "C64  ..." },
/* nl */ { IDMS_C64_MODEL_SETTINGS_NL, "C64 model instellingen..." },
/* pl */ { IDMS_C64_MODEL_SETTINGS_PL, "Ustawienia modelu C64..." },
/* ru */ { IDMS_C64_MODEL_SETTINGS_RU, "C64 model settings..." },
/* sv */ { IDMS_C64_MODEL_SETTINGS_SV, "C64-modellinstllningar..." },
/* tr */ { IDMS_C64_MODEL_SETTINGS_TR, "C64 model ayarlar..." },

/* en */ { IDMS_C64_PAL,    "C64 PAL" },
/* da */ { IDMS_C64_PAL_DA, "C64 PAL" },
/* de */ { IDMS_C64_PAL_DE, "C64 PAL" },
/* es */ { IDMS_C64_PAL_ES, "C64 PAL" },
/* fr */ { IDMS_C64_PAL_FR, "RTC baseC64 PAL" },
/* hu */ { IDMS_C64_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64_PAL_IT, "C64 PAL" },
/* ko */ { IDMS_C64_PAL_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C64_PAL_NL, "C64 PAL" },
/* pl */ { IDMS_C64_PAL_PL, "C64 PAL" },
/* ru */ { IDMS_C64_PAL_RU, "C64 PAL" },
/* sv */ { IDMS_C64_PAL_SV, "C64 PAL" },
/* tr */ { IDMS_C64_PAL_TR, "C64 PAL" },

/* en */ { IDMS_C64C_PAL,    "C64C PAL" },
/* da */ { IDMS_C64C_PAL_DA, "C64C PAL" },
/* de */ { IDMS_C64C_PAL_DE, "C64C PAL" },
/* es */ { IDMS_C64C_PAL_ES, "C64C PAL" },
/* fr */ { IDMS_C64C_PAL_FR, "C64C PAL" },
/* hu */ { IDMS_C64C_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64C_PAL_IT, "C64C PAL" },
/* ko */ { IDMS_C64C_PAL_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C64C_PAL_NL, "C64C PAL" },
/* pl */ { IDMS_C64C_PAL_PL, "C64C PAL" },
/* ru */ { IDMS_C64C_PAL_RU, "C64C PAL" },
/* sv */ { IDMS_C64C_PAL_SV, "C64C PAL" },
/* tr */ { IDMS_C64C_PAL_TR, "C64C PAL" },

/* en */ { IDMS_C64_OLD_PAL,    "C64 old PAL" },
/* da */ { IDMS_C64_OLD_PAL_DA, "C64 gammel PAL" },
/* de */ { IDMS_C64_OLD_PAL_DE, "C64 alt PAL" },
/* es */ { IDMS_C64_OLD_PAL_ES, "C64 PAL antiguo" },
/* fr */ { IDMS_C64_OLD_PAL_FR, "Ancien PAL C64" },
/* hu */ { IDMS_C64_OLD_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64_OLD_PAL_IT, "C64 PAL vecchio" },
/* ko */ { IDMS_C64_OLD_PAL_KO, "C64 õ PAL" },
/* nl */ { IDMS_C64_OLD_PAL_NL, "C64 oud PAL" },
/* pl */ { IDMS_C64_OLD_PAL_PL, "C64 stary PAL" },
/* ru */ { IDMS_C64_OLD_PAL_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C64_OLD_PAL_SV, "C64 gammal PAL" },
/* tr */ { IDMS_C64_OLD_PAL_TR, "C64 eski PAL" },

/* en */ { IDMS_C64_NTSC,    "C64 NTSC" },
/* da */ { IDMS_C64_NTSC_DA, "C64 NTSC" },
/* de */ { IDMS_C64_NTSC_DE, "C64 NTSC" },
/* es */ { IDMS_C64_NTSC_ES, "C64 NTSC" },
/* fr */ { IDMS_C64_NTSC_FR, "NTSC C64" },
/* hu */ { IDMS_C64_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64_NTSC_IT, "C64 NTSC" },
/* ko */ { IDMS_C64_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C64_NTSC_NL, "C64 NTSC" },
/* pl */ { IDMS_C64_NTSC_PL, "C64 NTSC" },
/* ru */ { IDMS_C64_NTSC_RU, "C64 NTSC" },
/* sv */ { IDMS_C64_NTSC_SV, "C64 NTSC" },
/* tr */ { IDMS_C64_NTSC_TR, "C64 NTSC" },

/* en */ { IDMS_C64C_NTSC,    "C64C NTSC" },
/* da */ { IDMS_C64C_NTSC_DA, "C64C NTSC" },
/* de */ { IDMS_C64C_NTSC_DE, "C64C NTSC" },
/* es */ { IDMS_C64C_NTSC_ES, "C64C NTSC" },
/* fr */ { IDMS_C64C_NTSC_FR, "NTSC C64C" },
/* hu */ { IDMS_C64C_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64C_NTSC_IT, "C64C NTSC" },
/* ko */ { IDMS_C64C_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C64C_NTSC_NL, "C64C NTSC" },
/* pl */ { IDMS_C64C_NTSC_PL, "C64C NTSC" },
/* ru */ { IDMS_C64C_NTSC_RU, "C64C NTSC" },
/* sv */ { IDMS_C64C_NTSC_SV, "C64C NTSC" },
/* tr */ { IDMS_C64C_NTSC_TR, "C64C NTSC" },

/* en */ { IDMS_C64_OLD_NTSC,    "C64 old NTSC" },
/* da */ { IDMS_C64_OLD_NTSC_DA, "C64 gammel NTSC" },
/* de */ { IDMS_C64_OLD_NTSC_DE, "C64 alt NTSC" },
/* es */ { IDMS_C64_OLD_NTSC_ES, "C64 NTSC antiguo" },
/* fr */ { IDMS_C64_OLD_NTSC_FR, "Ancien NTSC C64" },
/* hu */ { IDMS_C64_OLD_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64_OLD_NTSC_IT, "C64 NTSC vecchio" },
/* ko */ { IDMS_C64_OLD_NTSC_KO, "C64 õ NTSC" },
/* nl */ { IDMS_C64_OLD_NTSC_NL, "C64 oud NTSC" },
/* pl */ { IDMS_C64_OLD_NTSC_PL, "C64 stary NTSC" },
/* ru */ { IDMS_C64_OLD_NTSC_RU, "C64 old NTSC" },
/* sv */ { IDMS_C64_OLD_NTSC_SV, "C64 gammal NTSC" },
/* tr */ { IDMS_C64_OLD_NTSC_TR, "C64 eski NTSC" },

/* en */ { IDMS_DREAN,    "Drean" },
/* da */ { IDMS_DREAN_DA, "Drean" },
/* de */ { IDMS_DREAN_DE, "Drean" },
/* es */ { IDMS_DREAN_ES, "Drean" },
/* fr */ { IDMS_DREAN_FR, "Rve" },
/* hu */ { IDMS_DREAN_HU, "" },  /* fuzzy */
/* it */ { IDMS_DREAN_IT, "Drean" },
/* ko */ { IDMS_DREAN_KO, "帰" },
/* nl */ { IDMS_DREAN_NL, "Drean" },
/* pl */ { IDMS_DREAN_PL, "Drean" },
/* ru */ { IDMS_DREAN_RU, "Drean" },
/* sv */ { IDMS_DREAN_SV, "Drean" },
/* tr */ { IDMS_DREAN_TR, "Drean" },

/* en */ { IDMS_C64SX_PAL,    "C64 SX PAL" },
/* da */ { IDMS_C64SX_PAL_DA, "" },  /* fuzzy */
/* de */ { IDMS_C64SX_PAL_DE, "C64 SX PAL" },
/* es */ { IDMS_C64SX_PAL_ES, "C64 SX PAL" },
/* fr */ { IDMS_C64SX_PAL_FR, "" },  /* fuzzy */
/* hu */ { IDMS_C64SX_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64SX_PAL_IT, "C64 SX PAL" },
/* ko */ { IDMS_C64SX_PAL_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C64SX_PAL_NL, "C64 SX PAL" },
/* pl */ { IDMS_C64SX_PAL_PL, "C64 SX PAL" },
/* ru */ { IDMS_C64SX_PAL_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C64SX_PAL_SV, "C64 SX PAL" },
/* tr */ { IDMS_C64SX_PAL_TR, "" },  /* fuzzy */

/* en */ { IDMS_C64SX_NTSC,    "C64 SX NTSC" },
/* da */ { IDMS_C64SX_NTSC_DA, "" },  /* fuzzy */
/* de */ { IDMS_C64SX_NTSC_DE, "C64 SX NTSC" },
/* es */ { IDMS_C64SX_NTSC_ES, "C64 SX NTSC" },
/* fr */ { IDMS_C64SX_NTSC_FR, "" },  /* fuzzy */
/* hu */ { IDMS_C64SX_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64SX_NTSC_IT, "C64 SX NTSC" },
/* ko */ { IDMS_C64SX_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C64SX_NTSC_NL, "C64 SX NTSC" },
/* pl */ { IDMS_C64SX_NTSC_PL, "C64 SX NTSC" },
/* ru */ { IDMS_C64SX_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C64SX_NTSC_SV, "C64 SX NTSC" },
/* tr */ { IDMS_C64SX_NTSC_TR, "" },  /* fuzzy */

/* en */ { IDMS_C64_JAP,    "Japanese" },
/* da */ { IDMS_C64_JAP_DA, "" },  /* fuzzy */
/* de */ { IDMS_C64_JAP_DE, "Japanisch" },
/* es */ { IDMS_C64_JAP_ES, "Japons" },
/* fr */ { IDMS_C64_JAP_FR, "" },  /* fuzzy */
/* hu */ { IDMS_C64_JAP_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64_JAP_IT, "Giapponese" },
/* ko */ { IDMS_C64_JAP_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C64_JAP_NL, "Japans" },
/* pl */ { IDMS_C64_JAP_PL, "Japoski" },
/* ru */ { IDMS_C64_JAP_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C64_JAP_SV, "japansk" },
/* tr */ { IDMS_C64_JAP_TR, "" },  /* fuzzy */

/* en */ { IDMS_C64_GS,    "C64 GS" },
/* da */ { IDMS_C64_GS_DA, "" },  /* fuzzy */
/* de */ { IDMS_C64_GS_DE, "C64 GS" },
/* es */ { IDMS_C64_GS_ES, "C64 GS" },
/* fr */ { IDMS_C64_GS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_C64_GS_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64_GS_IT, "C64 GS" },
/* ko */ { IDMS_C64_GS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C64_GS_NL, "C64 GS" },
/* pl */ { IDMS_C64_GS_PL, "C64 GS" },
/* ru */ { IDMS_C64_GS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C64_GS_SV, "C64 GS" },
/* tr */ { IDMS_C64_GS_TR, "" },  /* fuzzy */

/* en */ { IDMS_PET64_PAL,    "PET64 PAL" },
/* da */ { IDMS_PET64_PAL_DA, "" },  /* fuzzy */
/* de */ { IDMS_PET64_PAL_DE, "PET64 PAL" },
/* es */ { IDMS_PET64_PAL_ES, "PET64 PAL" },
/* fr */ { IDMS_PET64_PAL_FR, "" },  /* fuzzy */
/* hu */ { IDMS_PET64_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_PET64_PAL_IT, "PET64 PAL" },
/* ko */ { IDMS_PET64_PAL_KO, "" },  /* fuzzy */
/* nl */ { IDMS_PET64_PAL_NL, "PET64 PAL" },
/* pl */ { IDMS_PET64_PAL_PL, "PET64 PAL" },
/* ru */ { IDMS_PET64_PAL_RU, "" },  /* fuzzy */
/* sv */ { IDMS_PET64_PAL_SV, "PET64 PAL" },
/* tr */ { IDMS_PET64_PAL_TR, "" },  /* fuzzy */

/* en */ { IDMS_PET64_NTSC,    "PET64 NTSC" },
/* da */ { IDMS_PET64_NTSC_DA, "" },  /* fuzzy */
/* de */ { IDMS_PET64_NTSC_DE, "PET64 NTSC" },
/* es */ { IDMS_PET64_NTSC_ES, "PET64 NTSC" },
/* fr */ { IDMS_PET64_NTSC_FR, "" },  /* fuzzy */
/* hu */ { IDMS_PET64_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_PET64_NTSC_IT, "PET64 NTSC" },
/* ko */ { IDMS_PET64_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_PET64_NTSC_NL, "PET64 NTSC" },
/* pl */ { IDMS_PET64_NTSC_PL, "PET64 NTSC" },
/* ru */ { IDMS_PET64_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDMS_PET64_NTSC_SV, "PET64 NTSC" },
/* tr */ { IDMS_PET64_NTSC_TR, "" },  /* fuzzy */

/* en */ { IDMS_ULTIMAX,    "MAX Machine" },
/* da */ { IDMS_ULTIMAX_DA, "" },  /* fuzzy */
/* de */ { IDMS_ULTIMAX_DE, "MAX Machine" },
/* es */ { IDMS_ULTIMAX_ES, "Mquina MAX" },
/* fr */ { IDMS_ULTIMAX_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ULTIMAX_HU, "" },  /* fuzzy */
/* it */ { IDMS_ULTIMAX_IT, "MAX Machine" },
/* ko */ { IDMS_ULTIMAX_KO, "" },  /* fuzzy */
/* nl */ { IDMS_ULTIMAX_NL, "MAX Machine" },
/* pl */ { IDMS_ULTIMAX_PL, "MAX Machine" },
/* ru */ { IDMS_ULTIMAX_RU, "" },  /* fuzzy */
/* sv */ { IDMS_ULTIMAX_SV, "MAX-maskin" },
/* tr */ { IDMS_ULTIMAX_TR, "" },  /* fuzzy */

/* en */ { IDMS_CUSTOM_C64_MODEL,    "Custom C64 model" },
/* da */ { IDMS_CUSTOM_C64_MODEL_DA, "Speciel C64 model" },
/* de */ { IDMS_CUSTOM_C64_MODEL_DE, "Modifiziertes C64 Modell" },
/* es */ { IDMS_CUSTOM_C64_MODEL_ES, "Modelo C64 a medida" },
/* fr */ { IDMS_CUSTOM_C64_MODEL_FR, "Modle personnalis C64" },
/* hu */ { IDMS_CUSTOM_C64_MODEL_HU, "" },  /* fuzzy */
/* it */ { IDMS_CUSTOM_C64_MODEL_IT, "Modello C64 personalizzato" },
/* ko */ { IDMS_CUSTOM_C64_MODEL_KO, "" },  /* fuzzy */
/* nl */ { IDMS_CUSTOM_C64_MODEL_NL, "Aangepast C64 model" },
/* pl */ { IDMS_CUSTOM_C64_MODEL_PL, "Wasny model C64" },
/* ru */ { IDMS_CUSTOM_C64_MODEL_RU, "" },  /* fuzzy */
/* sv */ { IDMS_CUSTOM_C64_MODEL_SV, "Speciell C64-modell" },
/* tr */ { IDMS_CUSTOM_C64_MODEL_TR, "zel C64 modeli" },

/* en */ { IDMS_PLUS4_MODEL_SETTINGS,    "Plus4 model settings..." },
/* da */ { IDMS_PLUS4_MODEL_SETTINGS_DA, "Plus4-model indstillinger..." },
/* de */ { IDMS_PLUS4_MODEL_SETTINGS_DE, "Plus4 Modell Einstellungen..." },
/* es */ { IDMS_PLUS4_MODEL_SETTINGS_ES, "Ajustes modelo Plus4..." },
/* fr */ { IDMS_PLUS4_MODEL_SETTINGS_FR, "Paramtres du modle Plus4..." },
/* hu */ { IDMS_PLUS4_MODEL_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_PLUS4_MODEL_SETTINGS_IT, "Impostazioni modello Plus4..." },
/* ko */ { IDMS_PLUS4_MODEL_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_PLUS4_MODEL_SETTINGS_NL, "Plus4 model instellingen..." },
/* pl */ { IDMS_PLUS4_MODEL_SETTINGS_PL, "Ustawienia modelu Plus4..." },
/* ru */ { IDMS_PLUS4_MODEL_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_PLUS4_MODEL_SETTINGS_SV, "Plus4-modellinstllningar..." },
/* tr */ { IDMS_PLUS4_MODEL_SETTINGS_TR, "Plus4 model ayarlar..." },

/* en */ { IDMS_C16_PAL,    "C16 PAL" },
/* da */ { IDMS_C16_PAL_DA, "C16 PAL" },
/* de */ { IDMS_C16_PAL_DE, "C16 PAL" },
/* es */ { IDMS_C16_PAL_ES, "C16 PAL" },
/* fr */ { IDMS_C16_PAL_FR, "PAL C16" },
/* hu */ { IDMS_C16_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_C16_PAL_IT, "C16 PAL" },
/* ko */ { IDMS_C16_PAL_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C16_PAL_NL, "C16 PAL" },
/* pl */ { IDMS_C16_PAL_PL, "C16 PAL" },
/* ru */ { IDMS_C16_PAL_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C16_PAL_SV, "C16 PAL" },
/* tr */ { IDMS_C16_PAL_TR, "C16 PAL" },

/* en */ { IDMS_C16_NTSC,    "C16 NTSC" },
/* da */ { IDMS_C16_NTSC_DA, "C16 NTSC" },
/* de */ { IDMS_C16_NTSC_DE, "C16 NTSC" },
/* es */ { IDMS_C16_NTSC_ES, "C16 NTSC" },
/* fr */ { IDMS_C16_NTSC_FR, "NTSC C16" },
/* hu */ { IDMS_C16_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_C16_NTSC_IT, "C16 NTSC" },
/* ko */ { IDMS_C16_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C16_NTSC_NL, "C16 NTSC" },
/* pl */ { IDMS_C16_NTSC_PL, "C16 NTSC" },
/* ru */ { IDMS_C16_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C16_NTSC_SV, "C16 NTSC" },
/* tr */ { IDMS_C16_NTSC_TR, "C16 NTSC" },

/* en */ { IDMS_PLUS4_PAL,    "Plus4 PAL" },
/* da */ { IDMS_PLUS4_PAL_DA, "Plus4 PAL" },
/* de */ { IDMS_PLUS4_PAL_DE, "Plus4 PAL" },
/* es */ { IDMS_PLUS4_PAL_ES, "Plus4 PAL" },
/* fr */ { IDMS_PLUS4_PAL_FR, "Plus4 PAL" },
/* hu */ { IDMS_PLUS4_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_PLUS4_PAL_IT, "Plus4 PAL" },
/* ko */ { IDMS_PLUS4_PAL_KO, "" },  /* fuzzy */
/* nl */ { IDMS_PLUS4_PAL_NL, "Plus4 PAL" },
/* pl */ { IDMS_PLUS4_PAL_PL, "Plus4 PAL" },
/* ru */ { IDMS_PLUS4_PAL_RU, "" },  /* fuzzy */
/* sv */ { IDMS_PLUS4_PAL_SV, "Plus4 PAL" },
/* tr */ { IDMS_PLUS4_PAL_TR, "Plus4 PAL" },

/* en */ { IDMS_PLUS4_NTSC,    "Plus4 NTSC" },
/* da */ { IDMS_PLUS4_NTSC_DA, "Plus4 NTSC" },
/* de */ { IDMS_PLUS4_NTSC_DE, "Plus4 NTSC" },
/* es */ { IDMS_PLUS4_NTSC_ES, "Plus4 NTSC" },
/* fr */ { IDMS_PLUS4_NTSC_FR, "NTSC Plus4" },
/* hu */ { IDMS_PLUS4_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_PLUS4_NTSC_IT, "Plus4 NTSC" },
/* ko */ { IDMS_PLUS4_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_PLUS4_NTSC_NL, "Plus4 NTSC" },
/* pl */ { IDMS_PLUS4_NTSC_PL, "Plus4 NTSC" },
/* ru */ { IDMS_PLUS4_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDMS_PLUS4_NTSC_SV, "Plus4 NTSC" },
/* tr */ { IDMS_PLUS4_NTSC_TR, "Plus4 NTSC" },

/* en */ { IDMS_V364_NTSC,    "V364 NTSC" },
/* da */ { IDMS_V364_NTSC_DA, "V364 NTSC" },
/* de */ { IDMS_V364_NTSC_DE, "V364 NTSC" },
/* es */ { IDMS_V364_NTSC_ES, "V364 NTSC" },
/* fr */ { IDMS_V364_NTSC_FR, "NTSC-M V364" },
/* hu */ { IDMS_V364_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_V364_NTSC_IT, "V364 NTSC" },
/* ko */ { IDMS_V364_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_V364_NTSC_NL, "V364 NTSC" },
/* pl */ { IDMS_V364_NTSC_PL, "V364 NTSC" },
/* ru */ { IDMS_V364_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDMS_V364_NTSC_SV, "V364 NTSC" },
/* tr */ { IDMS_V364_NTSC_TR, "V364 NTSC" },

/* en */ { IDMS_C232_NTSC,    "C232 NTSC" },
/* da */ { IDMS_C232_NTSC_DA, "C232 NTSC" },
/* de */ { IDMS_C232_NTSC_DE, "C232 NTSC" },
/* es */ { IDMS_C232_NTSC_ES, "C232 NTSC" },
/* fr */ { IDMS_C232_NTSC_FR, "NTSC C232" },
/* hu */ { IDMS_C232_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_C232_NTSC_IT, "C232 NTSC" },
/* ko */ { IDMS_C232_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C232_NTSC_NL, "C232 NTSC" },
/* pl */ { IDMS_C232_NTSC_PL, "C232 NTSC" },
/* ru */ { IDMS_C232_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C232_NTSC_SV, "C232 NTSC" },
/* tr */ { IDMS_C232_NTSC_TR, "C232 NTSC" },

/* en */ { IDMS_VIC20_MODEL_SETTINGS,    "VIC20 model settings..." },
/* da */ { IDMS_VIC20_MODEL_SETTINGS_DA, "" },  /* fuzzy */
/* de */ { IDMS_VIC20_MODEL_SETTINGS_DE, "VIC20 Modell Einstellungen..." },
/* es */ { IDMS_VIC20_MODEL_SETTINGS_ES, "Ajustes modelo VIC20..." },
/* fr */ { IDMS_VIC20_MODEL_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_VIC20_MODEL_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_VIC20_MODEL_SETTINGS_IT, "Impostazioni modello VIC20..." },
/* ko */ { IDMS_VIC20_MODEL_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_VIC20_MODEL_SETTINGS_NL, "VIC20 model instellingen..." },
/* pl */ { IDMS_VIC20_MODEL_SETTINGS_PL, "Ustawienia modelu VIC20..." },
/* ru */ { IDMS_VIC20_MODEL_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_VIC20_MODEL_SETTINGS_SV, "VIC20-modellinstllningar..." },
/* tr */ { IDMS_VIC20_MODEL_SETTINGS_TR, "" },  /* fuzzy */

/* en */ { IDMS_VIC20_PAL,    "VIC20 PAL" },
/* da */ { IDMS_VIC20_PAL_DA, "" },  /* fuzzy */
/* de */ { IDMS_VIC20_PAL_DE, "VIC20 PAL" },
/* es */ { IDMS_VIC20_PAL_ES, "VIC20 PAL" },
/* fr */ { IDMS_VIC20_PAL_FR, "" },  /* fuzzy */
/* hu */ { IDMS_VIC20_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_VIC20_PAL_IT, "VIC20 PAL" },
/* ko */ { IDMS_VIC20_PAL_KO, "" },  /* fuzzy */
/* nl */ { IDMS_VIC20_PAL_NL, "VIC20 PAL" },
/* pl */ { IDMS_VIC20_PAL_PL, "VIC20 PAL" },
/* ru */ { IDMS_VIC20_PAL_RU, "" },  /* fuzzy */
/* sv */ { IDMS_VIC20_PAL_SV, "VIC20 PAL" },
/* tr */ { IDMS_VIC20_PAL_TR, "" },  /* fuzzy */

/* en */ { IDMS_VIC20_NTSC,    "VIC20 NTSC" },
/* da */ { IDMS_VIC20_NTSC_DA, "" },  /* fuzzy */
/* de */ { IDMS_VIC20_NTSC_DE, "VIC20 NTSC" },
/* es */ { IDMS_VIC20_NTSC_ES, "VIC20 NTSC" },
/* fr */ { IDMS_VIC20_NTSC_FR, "" },  /* fuzzy */
/* hu */ { IDMS_VIC20_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_VIC20_NTSC_IT, "VIC20 NTSC" },
/* ko */ { IDMS_VIC20_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_VIC20_NTSC_NL, "VIC20 NTSC" },
/* pl */ { IDMS_VIC20_NTSC_PL, "VIC20 NTSC" },
/* ru */ { IDMS_VIC20_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDMS_VIC20_NTSC_SV, "VIC20 NTSC" },
/* tr */ { IDMS_VIC20_NTSC_TR, "" },  /* fuzzy */

/* en */ { IDMS_VIC21,    "VIC21" },
/* da */ { IDMS_VIC21_DA, "" },  /* fuzzy */
/* de */ { IDMS_VIC21_DE, "VIC21" },
/* es */ { IDMS_VIC21_ES, "VIC21" },
/* fr */ { IDMS_VIC21_FR, "" },  /* fuzzy */
/* hu */ { IDMS_VIC21_HU, "" },  /* fuzzy */
/* it */ { IDMS_VIC21_IT, "VIC21" },
/* ko */ { IDMS_VIC21_KO, "" },  /* fuzzy */
/* nl */ { IDMS_VIC21_NL, "VIC21" },
/* pl */ { IDMS_VIC21_PL, "VIC21" },
/* ru */ { IDMS_VIC21_RU, "" },  /* fuzzy */
/* sv */ { IDMS_VIC21_SV, "VIC21" },
/* tr */ { IDMS_VIC21_TR, "" },  /* fuzzy */

/* en */ { IDMS_C64DTV_MODEL_SETTINGS,    "C64DTV model settings..." },
/* da */ { IDMS_C64DTV_MODEL_SETTINGS_DA, "C64DTV-modelindstillinger..." },
/* de */ { IDMS_C64DTV_MODEL_SETTINGS_DE, "C64DTV Modell Einstellungen..." },
/* es */ { IDMS_C64DTV_MODEL_SETTINGS_ES, "Ajustes modelo C64DTV..." },
/* fr */ { IDMS_C64DTV_MODEL_SETTINGS_FR, "Paramtres du modle C64DTV..." },
/* hu */ { IDMS_C64DTV_MODEL_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64DTV_MODEL_SETTINGS_IT, "Impostazioni modello C64DTV..." },
/* ko */ { IDMS_C64DTV_MODEL_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C64DTV_MODEL_SETTINGS_NL, "C64DTV model instellingen..." },
/* pl */ { IDMS_C64DTV_MODEL_SETTINGS_PL, "Ustawienia modelu C64DTV..." },
/* ru */ { IDMS_C64DTV_MODEL_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C64DTV_MODEL_SETTINGS_SV, "C64DTV-modellinstllningar..." },
/* tr */ { IDMS_C64DTV_MODEL_SETTINGS_TR, "C64DTV model ayarlar..." },

/* en */ { IDMS_C64DTV2_PAL,    "C64DTV V2 PAL" },
/* da */ { IDMS_C64DTV2_PAL_DA, "C64DTV V2 PAL" },
/* de */ { IDMS_C64DTV2_PAL_DE, "C64DTV V2 PAL" },
/* es */ { IDMS_C64DTV2_PAL_ES, "C64DTV V2 PAL" },
/* fr */ { IDMS_C64DTV2_PAL_FR, "PAL C64DTV V2" },
/* hu */ { IDMS_C64DTV2_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64DTV2_PAL_IT, "C64DTV V2 PAL" },
/* ko */ { IDMS_C64DTV2_PAL_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C64DTV2_PAL_NL, "C64DTV V2 PAL" },
/* pl */ { IDMS_C64DTV2_PAL_PL, "C64DTV V2 PAL" },
/* ru */ { IDMS_C64DTV2_PAL_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C64DTV2_PAL_SV, "C64DTV V2 PAL" },
/* tr */ { IDMS_C64DTV2_PAL_TR, "C64DTV V2 PAL" },

/* en */ { IDMS_C64DTV2_NTSC,    "C64DTV V2 NTSC" },
/* da */ { IDMS_C64DTV2_NTSC_DA, "C64DTV V2 NTSC" },
/* de */ { IDMS_C64DTV2_NTSC_DE, "C64DTV V2 NTSC" },
/* es */ { IDMS_C64DTV2_NTSC_ES, "C64DTV V2 PAL" },
/* fr */ { IDMS_C64DTV2_NTSC_FR, "NTSC C64DTV V2" },
/* hu */ { IDMS_C64DTV2_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64DTV2_NTSC_IT, "C64DTV V2 NTSC" },
/* ko */ { IDMS_C64DTV2_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C64DTV2_NTSC_NL, "C64DTV V2 NTSC" },
/* pl */ { IDMS_C64DTV2_NTSC_PL, "C64DTV V2 NTSC" },
/* ru */ { IDMS_C64DTV2_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C64DTV2_NTSC_SV, "C64DTV V2 NTSC" },
/* tr */ { IDMS_C64DTV2_NTSC_TR, "C64DTV V2 NTSC" },

/* en */ { IDMS_C64DTV3_PAL,    "C64DTV V3 PAL" },
/* da */ { IDMS_C64DTV3_PAL_DA, "C64DTV V3 PAL" },
/* de */ { IDMS_C64DTV3_PAL_DE, "C64DTV V3 PAL" },
/* es */ { IDMS_C64DTV3_PAL_ES, "C64DTV V2 PAL" },
/* fr */ { IDMS_C64DTV3_PAL_FR, "PAL C64DTV V3" },
/* hu */ { IDMS_C64DTV3_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64DTV3_PAL_IT, "C64DTV V3 PAL" },
/* ko */ { IDMS_C64DTV3_PAL_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C64DTV3_PAL_NL, "C64DTV V3 PAL" },
/* pl */ { IDMS_C64DTV3_PAL_PL, "C64DTV V3 PAL" },
/* ru */ { IDMS_C64DTV3_PAL_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C64DTV3_PAL_SV, "C64DTV V3 PAL" },
/* tr */ { IDMS_C64DTV3_PAL_TR, "C64DTV V3 PAL" },

/* en */ { IDMS_C64DTV3_NTSC,    "C64DTV V3 NTSC" },
/* da */ { IDMS_C64DTV3_NTSC_DA, "C64DTV V3 NTSC" },
/* de */ { IDMS_C64DTV3_NTSC_DE, "C64DTV V3 NTSC" },
/* es */ { IDMS_C64DTV3_NTSC_ES, "C64DTV V3 NTSC" },
/* fr */ { IDMS_C64DTV3_NTSC_FR, "NTSC C64DTV V3" },
/* hu */ { IDMS_C64DTV3_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64DTV3_NTSC_IT, "C64DTV V3 NTSC" },
/* ko */ { IDMS_C64DTV3_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C64DTV3_NTSC_NL, "C64DTV V3 NTSC" },
/* pl */ { IDMS_C64DTV3_NTSC_PL, "C64DTV V3 NTSC" },
/* ru */ { IDMS_C64DTV3_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C64DTV3_NTSC_SV, "C64DTV V3 NTSC" },
/* tr */ { IDMS_C64DTV3_NTSC_TR, "C64DTV V3 NTSC" },

/* en */ { IDMS_HUMMER_NTSC,    "Hummer NTSC" },
/* da */ { IDMS_HUMMER_NTSC_DA, "Hummer NTSC" },
/* de */ { IDMS_HUMMER_NTSC_DE, "Hummer NTSC" },
/* es */ { IDMS_HUMMER_NTSC_ES, "Hummer NTSC" },
/* fr */ { IDMS_HUMMER_NTSC_FR, "NTSC Hummer" },
/* hu */ { IDMS_HUMMER_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_HUMMER_NTSC_IT, "Hummer NTSC" },
/* ko */ { IDMS_HUMMER_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_HUMMER_NTSC_NL, "Hummer NTSC" },
/* pl */ { IDMS_HUMMER_NTSC_PL, "Hummer NTSC" },
/* ru */ { IDMS_HUMMER_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDMS_HUMMER_NTSC_SV, "Hummer NTSC" },
/* tr */ { IDMS_HUMMER_NTSC_TR, "Hummer NTSC" },

/* en */ { IDMS_C128_MODEL_SETTINGS,    "C128 model settings..." },
/* da */ { IDMS_C128_MODEL_SETTINGS_DA, "C128-modelindstillinger..." },
/* de */ { IDMS_C128_MODEL_SETTINGS_DE, "C128 Modell Einstellungen..." },
/* es */ { IDMS_C128_MODEL_SETTINGS_ES, "Ajustes modelo C128..." },
/* fr */ { IDMS_C128_MODEL_SETTINGS_FR, "Paramtres du modle C128..." },
/* hu */ { IDMS_C128_MODEL_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_C128_MODEL_SETTINGS_IT, "Impostazioni modello C128..." },
/* ko */ { IDMS_C128_MODEL_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C128_MODEL_SETTINGS_NL, "C128 model instellingen..." },
/* pl */ { IDMS_C128_MODEL_SETTINGS_PL, "Ustawienia modelu C128..." },
/* ru */ { IDMS_C128_MODEL_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C128_MODEL_SETTINGS_SV, "C128-modellinstllningar..." },
/* tr */ { IDMS_C128_MODEL_SETTINGS_TR, "C128 model ayarlar..." },

/* en */ { IDMS_C128_PAL,    "C128 PAL" },
/* da */ { IDMS_C128_PAL_DA, "C128 PAL" },
/* de */ { IDMS_C128_PAL_DE, "C128 PAL" },
/* es */ { IDMS_C128_PAL_ES, "C128 PAL" },
/* fr */ { IDMS_C128_PAL_FR, "C128 PAL" },
/* hu */ { IDMS_C128_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_C128_PAL_IT, "C128 PAL" },
/* ko */ { IDMS_C128_PAL_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C128_PAL_NL, "C128 PAL" },
/* pl */ { IDMS_C128_PAL_PL, "C128 PAL" },
/* ru */ { IDMS_C128_PAL_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C128_PAL_SV, "C128 PAL" },
/* tr */ { IDMS_C128_PAL_TR, "C128 PAL" },

/* en */ { IDMS_C128DCR_PAL,    "C128DCR PAL" },
/* da */ { IDMS_C128DCR_PAL_DA, "C128DCR PAL" },
/* de */ { IDMS_C128DCR_PAL_DE, "C128DCR PAL" },
/* es */ { IDMS_C128DCR_PAL_ES, "C128DCR PAL" },
/* fr */ { IDMS_C128DCR_PAL_FR, "C128DCR PAL" },
/* hu */ { IDMS_C128DCR_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_C128DCR_PAL_IT, "C128DCR PAL" },
/* ko */ { IDMS_C128DCR_PAL_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C128DCR_PAL_NL, "C128DCR PAL" },
/* pl */ { IDMS_C128DCR_PAL_PL, "C128DCR PAL" },
/* ru */ { IDMS_C128DCR_PAL_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C128DCR_PAL_SV, "C128DCR PAL" },
/* tr */ { IDMS_C128DCR_PAL_TR, "C128DCR PAL" },

/* en */ { IDMS_C128_NTSC,    "C128 NTSC" },
/* da */ { IDMS_C128_NTSC_DA, "C128 NTSC" },
/* de */ { IDMS_C128_NTSC_DE, "C128 NTSC" },
/* es */ { IDMS_C128_NTSC_ES, "C128 NTSC" },
/* fr */ { IDMS_C128_NTSC_FR, "NTSC C128" },
/* hu */ { IDMS_C128_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_C128_NTSC_IT, "C128 NTSC" },
/* ko */ { IDMS_C128_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C128_NTSC_NL, "C128 NTSC" },
/* pl */ { IDMS_C128_NTSC_PL, "C128 NTSC" },
/* ru */ { IDMS_C128_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C128_NTSC_SV, "C128 NTSC" },
/* tr */ { IDMS_C128_NTSC_TR, "C128 NTSC" },

/* en */ { IDMS_C128DCR_NTSC,    "C128DCR NTSC" },
/* da */ { IDMS_C128DCR_NTSC_DA, "C128DCR NTSC" },
/* de */ { IDMS_C128DCR_NTSC_DE, "C128DCR NTSC" },
/* es */ { IDMS_C128DCR_NTSC_ES, "C128DCR NTSC" },
/* fr */ { IDMS_C128DCR_NTSC_FR, "NTSC C128DCR" },
/* hu */ { IDMS_C128DCR_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_C128DCR_NTSC_IT, "C128DCR NTSC" },
/* ko */ { IDMS_C128DCR_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C128DCR_NTSC_NL, "C128DCR NTSC" },
/* pl */ { IDMS_C128DCR_NTSC_PL, "C128DCR NTSC" },
/* ru */ { IDMS_C128DCR_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C128DCR_NTSC_SV, "C128DCR NTSC" },
/* tr */ { IDMS_C128DCR_NTSC_TR, "C128DCR NTSC" },

/* en */ { IDMS_PET_MODEL_SETTINGS,    "PET model settings..." },
/* da */ { IDMS_PET_MODEL_SETTINGS_DA, "PET-model indstillinger..." },
/* de */ { IDMS_PET_MODEL_SETTINGS_DE, "PET Modell Einstellungen..." },
/* es */ { IDMS_PET_MODEL_SETTINGS_ES, "Ajustes modelo PET..." },
/* fr */ { IDMS_PET_MODEL_SETTINGS_FR, "Paramtres du modle PET..." },
/* hu */ { IDMS_PET_MODEL_SETTINGS_HU, "PET modell belltsai..." },
/* it */ { IDMS_PET_MODEL_SETTINGS_IT, "Impostazioni modello PET..." },
/* ko */ { IDMS_PET_MODEL_SETTINGS_KO, "PET  ..." },
/* nl */ { IDMS_PET_MODEL_SETTINGS_NL, "PET model instellingen..." },
/* pl */ { IDMS_PET_MODEL_SETTINGS_PL, "Ustawienia modelu PET..." },
/* ru */ { IDMS_PET_MODEL_SETTINGS_RU, "  PET..." },
/* sv */ { IDMS_PET_MODEL_SETTINGS_SV, "Instllningar fr PET-modell..." },
/* tr */ { IDMS_PET_MODEL_SETTINGS_TR, "PET model ayarlar..." },

/* en */ { IDMS_2001,    "2001" },
/* da */ { IDMS_2001_DA, "2001" },
/* de */ { IDMS_2001_DE, "2001" },
/* es */ { IDMS_2001_ES, "2001" },
/* fr */ { IDMS_2001_FR, "2001" },
/* hu */ { IDMS_2001_HU, "" },  /* fuzzy */
/* it */ { IDMS_2001_IT, "2001" },
/* ko */ { IDMS_2001_KO, "" },  /* fuzzy */
/* nl */ { IDMS_2001_NL, "2001" },
/* pl */ { IDMS_2001_PL, "2001" },
/* ru */ { IDMS_2001_RU, "2001" },
/* sv */ { IDMS_2001_SV, "2001" },
/* tr */ { IDMS_2001_TR, "2001" },

/* en */ { IDMS_3008,    "3008" },
/* da */ { IDMS_3008_DA, "3008" },
/* de */ { IDMS_3008_DE, "3008" },
/* es */ { IDMS_3008_ES, "3008" },
/* fr */ { IDMS_3008_FR, "3008" },
/* hu */ { IDMS_3008_HU, "" },  /* fuzzy */
/* it */ { IDMS_3008_IT, "3008" },
/* ko */ { IDMS_3008_KO, "" },  /* fuzzy */
/* nl */ { IDMS_3008_NL, "3008" },
/* pl */ { IDMS_3008_PL, "3008" },
/* ru */ { IDMS_3008_RU, "3008" },
/* sv */ { IDMS_3008_SV, "3008" },
/* tr */ { IDMS_3008_TR, "3008" },

/* en */ { IDMS_3016,    "3016" },
/* da */ { IDMS_3016_DA, "3016" },
/* de */ { IDMS_3016_DE, "3016" },
/* es */ { IDMS_3016_ES, "3016" },
/* fr */ { IDMS_3016_FR, "3016" },
/* hu */ { IDMS_3016_HU, "" },  /* fuzzy */
/* it */ { IDMS_3016_IT, "3016" },
/* ko */ { IDMS_3016_KO, "" },  /* fuzzy */
/* nl */ { IDMS_3016_NL, "3016" },
/* pl */ { IDMS_3016_PL, "3016" },
/* ru */ { IDMS_3016_RU, "3016" },
/* sv */ { IDMS_3016_SV, "3016" },
/* tr */ { IDMS_3016_TR, "3016" },

/* en */ { IDMS_3032,    "3032" },
/* da */ { IDMS_3032_DA, "3032" },
/* de */ { IDMS_3032_DE, "3032" },
/* es */ { IDMS_3032_ES, "3032" },
/* fr */ { IDMS_3032_FR, "3032" },
/* hu */ { IDMS_3032_HU, "" },  /* fuzzy */
/* it */ { IDMS_3032_IT, "3032" },
/* ko */ { IDMS_3032_KO, "" },  /* fuzzy */
/* nl */ { IDMS_3032_NL, "3032" },
/* pl */ { IDMS_3032_PL, "3032" },
/* ru */ { IDMS_3032_RU, "3032" },
/* sv */ { IDMS_3032_SV, "3032" },
/* tr */ { IDMS_3032_TR, "3032" },

/* en */ { IDMS_3032B,    "3032B" },
/* da */ { IDMS_3032B_DA, "3032B" },
/* de */ { IDMS_3032B_DE, "3032B" },
/* es */ { IDMS_3032B_ES, "3032B" },
/* fr */ { IDMS_3032B_FR, "3032B" },
/* hu */ { IDMS_3032B_HU, "" },  /* fuzzy */
/* it */ { IDMS_3032B_IT, "3032B" },
/* ko */ { IDMS_3032B_KO, "" },  /* fuzzy */
/* nl */ { IDMS_3032B_NL, "3032B" },
/* pl */ { IDMS_3032B_PL, "3032B" },
/* ru */ { IDMS_3032B_RU, "3032B" },
/* sv */ { IDMS_3032B_SV, "3032B" },
/* tr */ { IDMS_3032B_TR, "3032B" },

/* en */ { IDMS_4016,    "4016" },
/* da */ { IDMS_4016_DA, "4016" },
/* de */ { IDMS_4016_DE, "4016" },
/* es */ { IDMS_4016_ES, "4016" },
/* fr */ { IDMS_4016_FR, "4016" },
/* hu */ { IDMS_4016_HU, "" },  /* fuzzy */
/* it */ { IDMS_4016_IT, "4016" },
/* ko */ { IDMS_4016_KO, "" },  /* fuzzy */
/* nl */ { IDMS_4016_NL, "4016" },
/* pl */ { IDMS_4016_PL, "4016" },
/* ru */ { IDMS_4016_RU, "4016" },
/* sv */ { IDMS_4016_SV, "4016" },
/* tr */ { IDMS_4016_TR, "4016" },

/* en */ { IDMS_4032,    "4032" },
/* da */ { IDMS_4032_DA, "4032" },
/* de */ { IDMS_4032_DE, "4032" },
/* es */ { IDMS_4032_ES, "4032" },
/* fr */ { IDMS_4032_FR, "4032" },
/* hu */ { IDMS_4032_HU, "" },  /* fuzzy */
/* it */ { IDMS_4032_IT, "4032" },
/* ko */ { IDMS_4032_KO, "" },  /* fuzzy */
/* nl */ { IDMS_4032_NL, "4032" },
/* pl */ { IDMS_4032_PL, "4032" },
/* ru */ { IDMS_4032_RU, "4032" },
/* sv */ { IDMS_4032_SV, "4032" },
/* tr */ { IDMS_4032_TR, "4032" },

/* en */ { IDMS_4032B,    "4032B" },
/* da */ { IDMS_4032B_DA, "4032B" },
/* de */ { IDMS_4032B_DE, "4032B" },
/* es */ { IDMS_4032B_ES, "4032B" },
/* fr */ { IDMS_4032B_FR, "4032B" },
/* hu */ { IDMS_4032B_HU, "" },  /* fuzzy */
/* it */ { IDMS_4032B_IT, "4032B" },
/* ko */ { IDMS_4032B_KO, "" },  /* fuzzy */
/* nl */ { IDMS_4032B_NL, "4032B" },
/* pl */ { IDMS_4032B_PL, "4032B" },
/* ru */ { IDMS_4032B_RU, "4032B" },
/* sv */ { IDMS_4032B_SV, "4032B" },
/* tr */ { IDMS_4032B_TR, "4032B" },

/* en */ { IDMS_8032,    "8032" },
/* da */ { IDMS_8032_DA, "8032" },
/* de */ { IDMS_8032_DE, "8032" },
/* es */ { IDMS_8032_ES, "8032" },
/* fr */ { IDMS_8032_FR, "8032" },
/* hu */ { IDMS_8032_HU, "" },  /* fuzzy */
/* it */ { IDMS_8032_IT, "8032" },
/* ko */ { IDMS_8032_KO, "" },  /* fuzzy */
/* nl */ { IDMS_8032_NL, "8032" },
/* pl */ { IDMS_8032_PL, "8032" },
/* ru */ { IDMS_8032_RU, "8032" },
/* sv */ { IDMS_8032_SV, "8032" },
/* tr */ { IDMS_8032_TR, "8032" },

/* en */ { IDMS_8096,    "8096" },
/* da */ { IDMS_8096_DA, "8096" },
/* de */ { IDMS_8096_DE, "8096" },
/* es */ { IDMS_8096_ES, "8096" },
/* fr */ { IDMS_8096_FR, "8096" },
/* hu */ { IDMS_8096_HU, "" },  /* fuzzy */
/* it */ { IDMS_8096_IT, "8096" },
/* ko */ { IDMS_8096_KO, "" },  /* fuzzy */
/* nl */ { IDMS_8096_NL, "8096" },
/* pl */ { IDMS_8096_PL, "8096" },
/* ru */ { IDMS_8096_RU, "8096" },
/* sv */ { IDMS_8096_SV, "8096" },
/* tr */ { IDMS_8096_TR, "8096" },

/* en */ { IDMS_8296,    "8296" },
/* da */ { IDMS_8296_DA, "8296" },
/* de */ { IDMS_8296_DE, "8296" },
/* es */ { IDMS_8296_ES, "8293" },
/* fr */ { IDMS_8296_FR, "8296" },
/* hu */ { IDMS_8296_HU, "" },  /* fuzzy */
/* it */ { IDMS_8296_IT, "8296" },
/* ko */ { IDMS_8296_KO, "" },  /* fuzzy */
/* nl */ { IDMS_8296_NL, "8296" },
/* pl */ { IDMS_8296_PL, "8296" },
/* ru */ { IDMS_8296_RU, "8296" },
/* sv */ { IDMS_8296_SV, "8296" },
/* tr */ { IDMS_8296_TR, "8296" },

/* en */ { IDMS_SUPERPET,    "SuperPET" },
/* da */ { IDMS_SUPERPET_DA, "SuperPET" },
/* de */ { IDMS_SUPERPET_DE, "SuperPET" },
/* es */ { IDMS_SUPERPET_ES, "SuperPET" },
/* fr */ { IDMS_SUPERPET_FR, "SuperPET" },
/* hu */ { IDMS_SUPERPET_HU, "" },  /* fuzzy */
/* it */ { IDMS_SUPERPET_IT, "SuperPET" },
/* ko */ { IDMS_SUPERPET_KO, "" },  /* fuzzy */
/* nl */ { IDMS_SUPERPET_NL, "SuperPET" },
/* pl */ { IDMS_SUPERPET_PL, "SuperPET" },
/* ru */ { IDMS_SUPERPET_RU, "" },  /* fuzzy */
/* sv */ { IDMS_SUPERPET_SV, "SuperPET" },
/* tr */ { IDMS_SUPERPET_TR, "SuperPET" },

/* en */ { IDMS_CBM2_MODEL_SETTINGS,    "CBM2 model settings..." },
/* da */ { IDMS_CBM2_MODEL_SETTINGS_DA, "CBM2-modelindstillinger..." },
/* de */ { IDMS_CBM2_MODEL_SETTINGS_DE, "CBM2 Modell Einstellungen..." },
/* es */ { IDMS_CBM2_MODEL_SETTINGS_ES, "Ajustes modelo CBM2..." },
/* fr */ { IDMS_CBM2_MODEL_SETTINGS_FR, "Paramtres du modle CBM2..." },
/* hu */ { IDMS_CBM2_MODEL_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_CBM2_MODEL_SETTINGS_IT, "Impostazioni modello CBM2..." },
/* ko */ { IDMS_CBM2_MODEL_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_CBM2_MODEL_SETTINGS_NL, "CBM2 model instellingen..." },
/* pl */ { IDMS_CBM2_MODEL_SETTINGS_PL, "Ustawienia modelu CBM2..." },
/* ru */ { IDMS_CBM2_MODEL_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_CBM2_MODEL_SETTINGS_SV, "CBM2-modellinstllningar..." },
/* tr */ { IDMS_CBM2_MODEL_SETTINGS_TR, "CBM2 model ayarlar..." },

/* en */ { IDMS_610_PAL,    "CBM610 PAL" },
/* da */ { IDMS_610_PAL_DA, "CBM610 PAL" },
/* de */ { IDMS_610_PAL_DE, "CBM610 PAL" },
/* es */ { IDMS_610_PAL_ES, "CBM610 PAL" },
/* fr */ { IDMS_610_PAL_FR, "CBM610 PAL" },
/* hu */ { IDMS_610_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_610_PAL_IT, "CBM610 PAL" },
/* ko */ { IDMS_610_PAL_KO, "" },  /* fuzzy */
/* nl */ { IDMS_610_PAL_NL, "CBM610 PAL" },
/* pl */ { IDMS_610_PAL_PL, "CBM610 PAL" },
/* ru */ { IDMS_610_PAL_RU, "" },  /* fuzzy */
/* sv */ { IDMS_610_PAL_SV, "CBM610 PAL" },
/* tr */ { IDMS_610_PAL_TR, "CBM610 PAL" },

/* en */ { IDMS_610_NTSC,    "CBM610 NTSC" },
/* da */ { IDMS_610_NTSC_DA, "CBM610 NTSC" },
/* de */ { IDMS_610_NTSC_DE, "CBM610 NTSC" },
/* es */ { IDMS_610_NTSC_ES, "CBM610 NTSC" },
/* fr */ { IDMS_610_NTSC_FR, "NTSC CBM610" },
/* hu */ { IDMS_610_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_610_NTSC_IT, "CBM610 NTSC" },
/* ko */ { IDMS_610_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_610_NTSC_NL, "CBM610 NTSC" },
/* pl */ { IDMS_610_NTSC_PL, "CBM610 NTSC" },
/* ru */ { IDMS_610_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDMS_610_NTSC_SV, "CBM610 NTSC" },
/* tr */ { IDMS_610_NTSC_TR, "CBM610 NTSC" },

/* en */ { IDMS_620_PAL,    "CBM620 PAL" },
/* da */ { IDMS_620_PAL_DA, "CBM620 PAL" },
/* de */ { IDMS_620_PAL_DE, "CBM620 PAL" },
/* es */ { IDMS_620_PAL_ES, "CBM620 PAL" },
/* fr */ { IDMS_620_PAL_FR, "CBM620 PAL" },
/* hu */ { IDMS_620_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_620_PAL_IT, "CBM620 PAL" },
/* ko */ { IDMS_620_PAL_KO, "" },  /* fuzzy */
/* nl */ { IDMS_620_PAL_NL, "CBM620 PAL" },
/* pl */ { IDMS_620_PAL_PL, "CBM620 PAL" },
/* ru */ { IDMS_620_PAL_RU, "" },  /* fuzzy */
/* sv */ { IDMS_620_PAL_SV, "CBM620 PAL" },
/* tr */ { IDMS_620_PAL_TR, "CBM620 PAL" },

/* en */ { IDMS_620_NTSC,    "CBM620 NTSC" },
/* da */ { IDMS_620_NTSC_DA, "CBM620 NTSC" },
/* de */ { IDMS_620_NTSC_DE, "CBM620 NTSC" },
/* es */ { IDMS_620_NTSC_ES, "CBM620 NTSC" },
/* fr */ { IDMS_620_NTSC_FR, "NTSC CBM620" },
/* hu */ { IDMS_620_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_620_NTSC_IT, "CBM620 NTSC" },
/* ko */ { IDMS_620_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_620_NTSC_NL, "CBM620 NTSC" },
/* pl */ { IDMS_620_NTSC_PL, "CBM620 NTSC" },
/* ru */ { IDMS_620_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDMS_620_NTSC_SV, "CBM620 NTSC" },
/* tr */ { IDMS_620_NTSC_TR, "CBM620 NTSC" },

/* en */ { IDMS_620PLUS_PAL,    "CBM620+ PAL" },
/* da */ { IDMS_620PLUS_PAL_DA, "CBM620+ PAL" },
/* de */ { IDMS_620PLUS_PAL_DE, "CBM620+ PAL" },
/* es */ { IDMS_620PLUS_PAL_ES, "CBM620+ PAL" },
/* fr */ { IDMS_620PLUS_PAL_FR, "CBM620+ PAL" },
/* hu */ { IDMS_620PLUS_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_620PLUS_PAL_IT, "CBM620+ PAL" },
/* ko */ { IDMS_620PLUS_PAL_KO, "" },  /* fuzzy */
/* nl */ { IDMS_620PLUS_PAL_NL, "CBM620+ PAL" },
/* pl */ { IDMS_620PLUS_PAL_PL, "CBM620+ PAL" },
/* ru */ { IDMS_620PLUS_PAL_RU, "" },  /* fuzzy */
/* sv */ { IDMS_620PLUS_PAL_SV, "CBM620+ PAL" },
/* tr */ { IDMS_620PLUS_PAL_TR, "CBM620+ PAL" },

/* en */ { IDMS_620PLUS_NTSC,    "CBM620+ NTSC" },
/* da */ { IDMS_620PLUS_NTSC_DA, "CBM620+ NTSC" },
/* de */ { IDMS_620PLUS_NTSC_DE, "CBM620+ NTSC" },
/* es */ { IDMS_620PLUS_NTSC_ES, "CBM620+ NTSC" },
/* fr */ { IDMS_620PLUS_NTSC_FR, "NTSC CBM620+" },
/* hu */ { IDMS_620PLUS_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_620PLUS_NTSC_IT, "CBM620+ NTSC" },
/* ko */ { IDMS_620PLUS_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_620PLUS_NTSC_NL, "CBM620+ NTSC" },
/* pl */ { IDMS_620PLUS_NTSC_PL, "CBM620+ NTSC" },
/* ru */ { IDMS_620PLUS_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDMS_620PLUS_NTSC_SV, "CBM620+ NTSC" },
/* tr */ { IDMS_620PLUS_NTSC_TR, "CBM620+ NTSC" },

/* en */ { IDMS_710_NTSC,    "CBM710 NTSC" },
/* da */ { IDMS_710_NTSC_DA, "CBM710 NTSC" },
/* de */ { IDMS_710_NTSC_DE, "CBM710 NTSC" },
/* es */ { IDMS_710_NTSC_ES, "CBM710 NTSC" },
/* fr */ { IDMS_710_NTSC_FR, "NTSC CBM710" },
/* hu */ { IDMS_710_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_710_NTSC_IT, "CBM710 NTSC" },
/* ko */ { IDMS_710_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_710_NTSC_NL, "CBM710 NTSC" },
/* pl */ { IDMS_710_NTSC_PL, "CBM710 NTSC" },
/* ru */ { IDMS_710_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDMS_710_NTSC_SV, "CBM710 NTSC" },
/* tr */ { IDMS_710_NTSC_TR, "CBM710 NTSC" },

/* en */ { IDMS_720_NTSC,    "CBM720 NTSC" },
/* da */ { IDMS_720_NTSC_DA, "CBM720 NTSC" },
/* de */ { IDMS_720_NTSC_DE, "CBM720 NTSC" },
/* es */ { IDMS_720_NTSC_ES, "CBM720 NTSC" },
/* fr */ { IDMS_720_NTSC_FR, "NTSC CBM720" },
/* hu */ { IDMS_720_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_720_NTSC_IT, "CBM720 NTSC" },
/* ko */ { IDMS_720_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_720_NTSC_NL, "CBM720 NTSC" },
/* pl */ { IDMS_720_NTSC_PL, "CBM720 NTSC" },
/* ru */ { IDMS_720_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDMS_720_NTSC_SV, "CBM720 NTSC" },
/* tr */ { IDMS_720_NTSC_TR, "CBM720 NTSC" },

/* en */ { IDMS_720PLUS_NTSC,    "CBM720+ NTSC" },
/* da */ { IDMS_720PLUS_NTSC_DA, "CBM720+ NTSC" },
/* de */ { IDMS_720PLUS_NTSC_DE, "CBM720+ NTSC" },
/* es */ { IDMS_720PLUS_NTSC_ES, "CBM720+ NTSC" },
/* fr */ { IDMS_720PLUS_NTSC_FR, "NTSC CBM720+" },
/* hu */ { IDMS_720PLUS_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_720PLUS_NTSC_IT, "CBM720+ NTSC" },
/* ko */ { IDMS_720PLUS_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_720PLUS_NTSC_NL, "CBM720+ NTSC" },
/* pl */ { IDMS_720PLUS_NTSC_PL, "CBM720+ NTSC" },
/* ru */ { IDMS_720PLUS_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDMS_720PLUS_NTSC_SV, "CBM720+ NTSC" },
/* tr */ { IDMS_720PLUS_NTSC_TR, "CBM720+ NTSC" },

/* en */ { IDMS_CBM5X0_MODEL_SETTINGS,    "CBM5x0 model settings..." },
/* da */ { IDMS_CBM5X0_MODEL_SETTINGS_DA, "CBM5x0-modelindstillinger..." },
/* de */ { IDMS_CBM5X0_MODEL_SETTINGS_DE, "CBM5x0 Modell Einstellungen..." },
/* es */ { IDMS_CBM5X0_MODEL_SETTINGS_ES, "Ajustes modelo CBM5x0..." },
/* fr */ { IDMS_CBM5X0_MODEL_SETTINGS_FR, "Paramtres du modle CBM5x0..." },
/* hu */ { IDMS_CBM5X0_MODEL_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_CBM5X0_MODEL_SETTINGS_IT, "Impostazioni modello CBM5x0..." },
/* ko */ { IDMS_CBM5X0_MODEL_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_CBM5X0_MODEL_SETTINGS_NL, "CBM5x0 model instellingen..." },
/* pl */ { IDMS_CBM5X0_MODEL_SETTINGS_PL, "Ustawienia modelu CBM5x0..." },
/* ru */ { IDMS_CBM5X0_MODEL_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_CBM5X0_MODEL_SETTINGS_SV, "CBM5x0-modellinstllningar..." },
/* tr */ { IDMS_CBM5X0_MODEL_SETTINGS_TR, "CBM5x0 model ayarlar..." },

/* en */ { IDMS_510_PAL,    "CBM510 PAL" },
/* da */ { IDMS_510_PAL_DA, "CBM510 PAL" },
/* de */ { IDMS_510_PAL_DE, "CBM510 PAL" },
/* es */ { IDMS_510_PAL_ES, "CBM510 PAL" },
/* fr */ { IDMS_510_PAL_FR, "CBM510 PAL" },
/* hu */ { IDMS_510_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_510_PAL_IT, "CBM510 PAL" },
/* ko */ { IDMS_510_PAL_KO, "" },  /* fuzzy */
/* nl */ { IDMS_510_PAL_NL, "CBM510 PAL" },
/* pl */ { IDMS_510_PAL_PL, "CBM510 PAL" },
/* ru */ { IDMS_510_PAL_RU, "CBM510 PAL" },
/* sv */ { IDMS_510_PAL_SV, "CBM510 PAL" },
/* tr */ { IDMS_510_PAL_TR, "CBM510 PAL" },

/* en */ { IDMS_510_NTSC,    "CBM510 NTSC" },
/* da */ { IDMS_510_NTSC_DA, "CBM510 NTSC" },
/* de */ { IDMS_510_NTSC_DE, "CBM510 NTSC" },
/* es */ { IDMS_510_NTSC_ES, "CBM510 NTSC" },
/* fr */ { IDMS_510_NTSC_FR, "NTSC CBM510" },
/* hu */ { IDMS_510_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_510_NTSC_IT, "CBM510 NTSC" },
/* ko */ { IDMS_510_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_510_NTSC_NL, "CBM510 NTSC" },
/* pl */ { IDMS_510_NTSC_PL, "CBM510 NTSC" },
/* ru */ { IDMS_510_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDMS_510_NTSC_SV, "CBM510 NTSC" },
/* tr */ { IDMS_510_NTSC_TR, "CBM510 NTSC" },

/* en */ { IDMS_AUTOSTART_SETTINGS,    "Autostart settings..." },
/* da */ { IDMS_AUTOSTART_SETTINGS_DA, "Autostart-indstillinger..." },
/* de */ { IDMS_AUTOSTART_SETTINGS_DE, "Autostart Einstellungen..." },
/* es */ { IDMS_AUTOSTART_SETTINGS_ES, "Ajustes de autoinicio..." },
/* fr */ { IDMS_AUTOSTART_SETTINGS_FR, "Paramtres Autodmarrage..." },
/* hu */ { IDMS_AUTOSTART_SETTINGS_HU, "Autostart belltsai..." },
/* it */ { IDMS_AUTOSTART_SETTINGS_IT, "Impostazioni avvio automatico..." },
/* ko */ { IDMS_AUTOSTART_SETTINGS_KO, "ڵ ..." },
/* nl */ { IDMS_AUTOSTART_SETTINGS_NL, "Autostart instellingen..." },
/* pl */ { IDMS_AUTOSTART_SETTINGS_PL, "Ustawienia autostartu..." },
/* ru */ { IDMS_AUTOSTART_SETTINGS_RU, " ..." },
/* sv */ { IDMS_AUTOSTART_SETTINGS_SV, "Autostartinstllningar..." },
/* tr */ { IDMS_AUTOSTART_SETTINGS_TR, "Otomatik balatma ayarlar..." },

/* en */ { IDMS_VICII_VIDEO_SETTINGS,    "VICII video settings..." },
/* da */ { IDMS_VICII_VIDEO_SETTINGS_DA, "VICII grafikindstillinger..." },
/* de */ { IDMS_VICII_VIDEO_SETTINGS_DE, "VICII Video Einstellungen..." },
/* es */ { IDMS_VICII_VIDEO_SETTINGS_ES, "Ajustes de vdeo VIC II..." },
/* fr */ { IDMS_VICII_VIDEO_SETTINGS_FR, "Paramtres vido VICII..." },
/* hu */ { IDMS_VICII_VIDEO_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_VICII_VIDEO_SETTINGS_IT, "Impostazioni video VICII..." },
/* ko */ { IDMS_VICII_VIDEO_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_VICII_VIDEO_SETTINGS_NL, "VICII video instellingen..." },
/* pl */ { IDMS_VICII_VIDEO_SETTINGS_PL, "Ustawienia wideo VICII..." },
/* ru */ { IDMS_VICII_VIDEO_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_VICII_VIDEO_SETTINGS_SV, "Grafikinstllningar fr VICII..." },
/* tr */ { IDMS_VICII_VIDEO_SETTINGS_TR, "VICII grnt ayarlar..." },

/* en */ { IDMS_VIC_VIDEO_SETTINGS,    "VIC video settings..." },
/* da */ { IDMS_VIC_VIDEO_SETTINGS_DA, "VIC grafikindstillinger..." },
/* de */ { IDMS_VIC_VIDEO_SETTINGS_DE, "VIC Video Einstellungen..." },
/* es */ { IDMS_VIC_VIDEO_SETTINGS_ES, "Ajustes de vdeo VIC..." },
/* fr */ { IDMS_VIC_VIDEO_SETTINGS_FR, "Paramtres vido VIC..." },
/* hu */ { IDMS_VIC_VIDEO_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_VIC_VIDEO_SETTINGS_IT, "Impostazioni video VIC..." },
/* ko */ { IDMS_VIC_VIDEO_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_VIC_VIDEO_SETTINGS_NL, "VIC video instellingen..." },
/* pl */ { IDMS_VIC_VIDEO_SETTINGS_PL, "Ustawienia wideo VIC..." },
/* ru */ { IDMS_VIC_VIDEO_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_VIC_VIDEO_SETTINGS_SV, "Grafikinstllningar fr VIC..." },
/* tr */ { IDMS_VIC_VIDEO_SETTINGS_TR, "VIC grnt ayarlar..." },

/* en */ { IDMS_VDC_VIDEO_SETTINGS,    "VDC video settings..." },
/* da */ { IDMS_VDC_VIDEO_SETTINGS_DA, "VDC grafikindstillinger..." },
/* de */ { IDMS_VDC_VIDEO_SETTINGS_DE, "VDC Video Einstellungen..." },
/* es */ { IDMS_VDC_VIDEO_SETTINGS_ES, "Ajustes de vdeo VDC..." },
/* fr */ { IDMS_VDC_VIDEO_SETTINGS_FR, "Paramtres vido VDC..." },
/* hu */ { IDMS_VDC_VIDEO_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_VDC_VIDEO_SETTINGS_IT, "Impostazioni video VDC..." },
/* ko */ { IDMS_VDC_VIDEO_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_VDC_VIDEO_SETTINGS_NL, "VDC video instellingen..." },
/* pl */ { IDMS_VDC_VIDEO_SETTINGS_PL, "Ustawienia wideo VDC..." },
/* ru */ { IDMS_VDC_VIDEO_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_VDC_VIDEO_SETTINGS_SV, "Grafikinstllningar fr VDC..." },
/* tr */ { IDMS_VDC_VIDEO_SETTINGS_TR, "VDC grnt ayarlar..." },

/* en */ { IDMS_CRTC_VIDEO_SETTINGS,    "CRTC video settings..." },
/* da */ { IDMS_CRTC_VIDEO_SETTINGS_DA, "CRTC grafikindstillinger..." },
/* de */ { IDMS_CRTC_VIDEO_SETTINGS_DE, "CRTC Video Einstellungen..." },
/* es */ { IDMS_CRTC_VIDEO_SETTINGS_ES, "Ajustes vdeo CRTC..." },
/* fr */ { IDMS_CRTC_VIDEO_SETTINGS_FR, "Paramtres vido CRTC..." },
/* hu */ { IDMS_CRTC_VIDEO_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_CRTC_VIDEO_SETTINGS_IT, "Impostazioni video  CRTC..." },
/* ko */ { IDMS_CRTC_VIDEO_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_CRTC_VIDEO_SETTINGS_NL, "CRTC video instellingen..." },
/* pl */ { IDMS_CRTC_VIDEO_SETTINGS_PL, "Ustawienia wideo CRTC..." },
/* ru */ { IDMS_CRTC_VIDEO_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_CRTC_VIDEO_SETTINGS_SV, "Grafikinstllningar fr CRTC..." },
/* tr */ { IDMS_CRTC_VIDEO_SETTINGS_TR, "CRTC grnt ayarlar..." },

/* en */ { IDMS_TED_VIDEO_SETTINGS,    "TED video settings..." },
/* da */ { IDMS_TED_VIDEO_SETTINGS_DA, "TED grafikindstillinger..." },
/* de */ { IDMS_TED_VIDEO_SETTINGS_DE, "TED Video Einstellungen..." },
/* es */ { IDMS_TED_VIDEO_SETTINGS_ES, "Ajustes de vdeo TED..." },
/* fr */ { IDMS_TED_VIDEO_SETTINGS_FR, "Paramtres vido TED..." },
/* hu */ { IDMS_TED_VIDEO_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_TED_VIDEO_SETTINGS_IT, "Impostazioni video TED..." },
/* ko */ { IDMS_TED_VIDEO_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_TED_VIDEO_SETTINGS_NL, "TED video instellingen..." },
/* pl */ { IDMS_TED_VIDEO_SETTINGS_PL, "Ustawienia wideo TED..." },
/* ru */ { IDMS_TED_VIDEO_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_TED_VIDEO_SETTINGS_SV, "Grafikinstllningar fr TED..." },
/* tr */ { IDMS_TED_VIDEO_SETTINGS_TR, "TED grnt ayarlar..." },

/* en */ { IDMS_AUDIO_LEAK,    "Audio leak" },
/* da */ { IDMS_AUDIO_LEAK_DA, "Audiolkage" },
/* de */ { IDMS_AUDIO_LEAK_DE, "Audio Leak" },
/* es */ { IDMS_AUDIO_LEAK_ES, "Filtro audio" },
/* fr */ { IDMS_AUDIO_LEAK_FR, "Fuite audio" },
/* hu */ { IDMS_AUDIO_LEAK_HU, "" },  /* fuzzy */
/* it */ { IDMS_AUDIO_LEAK_IT, "Audio leak" },
/* ko */ { IDMS_AUDIO_LEAK_KO, "" },  /* fuzzy */
/* nl */ { IDMS_AUDIO_LEAK_NL, "Audio lek" },
/* pl */ { IDMS_AUDIO_LEAK_PL, "Audio leak" },
/* ru */ { IDMS_AUDIO_LEAK_RU, "" },  /* fuzzy */
/* sv */ { IDMS_AUDIO_LEAK_SV, "Audiolckage" },
/* tr */ { IDMS_AUDIO_LEAK_TR, "Ses kaa" },

/* en */ { IDMS_PALETTE_SETTINGS,    "Palette settings..." },
/* da */ { IDMS_PALETTE_SETTINGS_DA, "Paletteindstillinger..." },
/* de */ { IDMS_PALETTE_SETTINGS_DE, "Paletteneinstellungen..." },
/* es */ { IDMS_PALETTE_SETTINGS_ES, "Ajustes Paleta..." },
/* fr */ { IDMS_PALETTE_SETTINGS_FR, "Paramtres Palette..." },
/* hu */ { IDMS_PALETTE_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_PALETTE_SETTINGS_IT, "Impostazioni palette..." },
/* ko */ { IDMS_PALETTE_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_PALETTE_SETTINGS_NL, "Palette instellingen..." },
/* pl */ { IDMS_PALETTE_SETTINGS_PL, "Ustawienia palety barw..." },
/* ru */ { IDMS_PALETTE_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_PALETTE_SETTINGS_SV, "Palettinstllningar..." },
/* tr */ { IDMS_PALETTE_SETTINGS_TR, "Palet ayarlar..." },

/* en */ { IDMS_COLOR_SETTINGS,    "Color settings..." },
/* da */ { IDMS_COLOR_SETTINGS_DA, "Farveindstillinger..." },
/* de */ { IDMS_COLOR_SETTINGS_DE, "Farb Einstellungen..." },
/* es */ { IDMS_COLOR_SETTINGS_ES, "Ajustes color..." },
/* fr */ { IDMS_COLOR_SETTINGS_FR, "Paramtres de couleurs..." },
/* hu */ { IDMS_COLOR_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_COLOR_SETTINGS_IT, "Impostazioni colori..." },
/* ko */ { IDMS_COLOR_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_COLOR_SETTINGS_NL, "Kleur instellingen..." },
/* pl */ { IDMS_COLOR_SETTINGS_PL, "Ustawienia koloru..." },
/* ru */ { IDMS_COLOR_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_COLOR_SETTINGS_SV, "Frginstllningar..." },
/* tr */ { IDMS_COLOR_SETTINGS_TR, "Renk ayarlar..." },

/* en */ { IDMS_RENDER_FILTER,    "Render filter settings..." },
/* da */ { IDMS_RENDER_FILTER_DA, "Renderingsfilterindstillinger..." },
/* de */ { IDMS_RENDER_FILTER_DE, "Render Filter Einstellungen..." },
/* es */ { IDMS_RENDER_FILTER_ES, "Ajuste filtro de renderizado..." },
/* fr */ { IDMS_RENDER_FILTER_FR, "Paramtres filtres de rendu..." },
/* hu */ { IDMS_RENDER_FILTER_HU, "" },  /* fuzzy */
/* it */ { IDMS_RENDER_FILTER_IT, "Impostazioni filtro di render..." },
/* ko */ { IDMS_RENDER_FILTER_KO, "" },  /* fuzzy */
/* nl */ { IDMS_RENDER_FILTER_NL, "Render filter instellingen..." },
/* pl */ { IDMS_RENDER_FILTER_PL, "Ustawienia filtra renderera..." },
/* ru */ { IDMS_RENDER_FILTER_RU, "" },  /* fuzzy */
/* sv */ { IDMS_RENDER_FILTER_SV, "Instllningar fr rendrerarfilter..." },
/* tr */ { IDMS_RENDER_FILTER_TR, "mge oluturma filtresi ayarlar..." },

/* en */ { IDMS_CRT_EMULATION_SETTINGS,    "CRT emulation settings..." },
/* da */ { IDMS_CRT_EMULATION_SETTINGS_DA, "Indstillinger for CRT-emulering..." },
/* de */ { IDMS_CRT_EMULATION_SETTINGS_DE, "CRT Emulator Einstellungen..." },
/* es */ { IDMS_CRT_EMULATION_SETTINGS_ES, "Ajustes de emulacin CRT..." },
/* fr */ { IDMS_CRT_EMULATION_SETTINGS_FR, "Paramtres d'mulation CRT..." },
/* hu */ { IDMS_CRT_EMULATION_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_CRT_EMULATION_SETTINGS_IT, "Impostazioni emulazione CRT..." },
/* ko */ { IDMS_CRT_EMULATION_SETTINGS_KO, "  ͹̳ ..." },
/* nl */ { IDMS_CRT_EMULATION_SETTINGS_NL, "CRT emulatie instellingen..." },
/* pl */ { IDMS_CRT_EMULATION_SETTINGS_PL, "Ustawienia emulacji CRT..." },
/* ru */ { IDMS_CRT_EMULATION_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_CRT_EMULATION_SETTINGS_SV, "Instllningar fr CRT-emulering..." },
/* tr */ { IDMS_CRT_EMULATION_SETTINGS_TR, "CRT emlasyonu ayarlar..." },

/* en */ { IDMS_VIC20_SETTINGS,    "VIC20 settings..." },
/* da */ { IDMS_VIC20_SETTINGS_DA, "VIC20-indstillinger..." },
/* de */ { IDMS_VIC20_SETTINGS_DE, "VIC20 Einstellungen..." },
/* es */ { IDMS_VIC20_SETTINGS_ES, "Ajustes VIC20..." },
/* fr */ { IDMS_VIC20_SETTINGS_FR, "Paramtres VIC20..." },
/* hu */ { IDMS_VIC20_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_VIC20_SETTINGS_IT, "Impostazioni VIC20..." },
/* ko */ { IDMS_VIC20_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_VIC20_SETTINGS_NL, "VIC20 instellingen..." },
/* pl */ { IDMS_VIC20_SETTINGS_PL, "Ustawienia VIC20..." },
/* ru */ { IDMS_VIC20_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_VIC20_SETTINGS_SV, "VIC20-instllningar..." },
/* tr */ { IDMS_VIC20_SETTINGS_TR, "VIC20 ayarlar..." },

/* en */ { IDMS_CBM2_SETTINGS,    "CBM2 settings..." },
/* da */ { IDMS_CBM2_SETTINGS_DA, "CBM2-indstillinger..." },
/* de */ { IDMS_CBM2_SETTINGS_DE, "CBM2 Einstellungen..." },
/* es */ { IDMS_CBM2_SETTINGS_ES, "Ajustes CBM2..." },
/* fr */ { IDMS_CBM2_SETTINGS_FR, "Paramtres CBM2..." },
/* hu */ { IDMS_CBM2_SETTINGS_HU, "CBM2 belltsai..." },
/* it */ { IDMS_CBM2_SETTINGS_IT, "Impostazioni CBM2..." },
/* ko */ { IDMS_CBM2_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_CBM2_SETTINGS_NL, "CBM2 instellingen..." },
/* pl */ { IDMS_CBM2_SETTINGS_PL, "Ustawienia CBM2..." },
/* ru */ { IDMS_CBM2_SETTINGS_RU, "CBM2 settings..." },
/* sv */ { IDMS_CBM2_SETTINGS_SV, "CBM2-instllningar..." },
/* tr */ { IDMS_CBM2_SETTINGS_TR, "CBM2 ayarlar..." },

/* en */ { IDMS_CBM5X0_SETTINGS,    "CBM5x0 settings..." },
/* da */ { IDMS_CBM5X0_SETTINGS_DA, "CBM5x0-indstillinger..." },
/* de */ { IDMS_CBM5X0_SETTINGS_DE, "CBM5x0 Einstellungen..." },
/* es */ { IDMS_CBM5X0_SETTINGS_ES, "Ajustes CBM5x0..." },
/* fr */ { IDMS_CBM5X0_SETTINGS_FR, "Paramtres CBM5x0..." },
/* hu */ { IDMS_CBM5X0_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_CBM5X0_SETTINGS_IT, "Impostazioni CBM5x0..." },
/* ko */ { IDMS_CBM5X0_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_CBM5X0_SETTINGS_NL, "CBM5x0 instellingen..." },
/* pl */ { IDMS_CBM5X0_SETTINGS_PL, "Ustawienia CBM5x0..." },
/* ru */ { IDMS_CBM5X0_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_CBM5X0_SETTINGS_SV, "CBM5x0-instllningar..." },
/* tr */ { IDMS_CBM5X0_SETTINGS_TR, "CBM5x0 ayarlar..." },

/* en */ { IDMS_PET_SETTINGS,    "PET settings..." },
/* da */ { IDMS_PET_SETTINGS_DA, "PET-indstillinger..." },
/* de */ { IDMS_PET_SETTINGS_DE, "PET Einstellungen..." },
/* es */ { IDMS_PET_SETTINGS_ES, "Ajustes PET..." },
/* fr */ { IDMS_PET_SETTINGS_FR, "Paramtres PET..." },
/* hu */ { IDMS_PET_SETTINGS_HU, "PET belltsai..." },
/* it */ { IDMS_PET_SETTINGS_IT, "Impostazioni PET..." },
/* ko */ { IDMS_PET_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_PET_SETTINGS_NL, "PET instellingen..." },
/* pl */ { IDMS_PET_SETTINGS_PL, "Ustawienia PET..." },
/* ru */ { IDMS_PET_SETTINGS_RU, "PET settings..." },
/* sv */ { IDMS_PET_SETTINGS_SV, "PET-instllningar..." },
/* tr */ { IDMS_PET_SETTINGS_TR, "PET ayarlar..." },

/* en */ { IDMS_PERIPHERAL_SETTINGS,    "Peripheral settings..." },
/* da */ { IDMS_PERIPHERAL_SETTINGS_DA, "Eksterne enhedsindstillinger..." },
/* de */ { IDMS_PERIPHERAL_SETTINGS_DE, "Peripherie Einstellungen..." },
/* es */ { IDMS_PERIPHERAL_SETTINGS_ES, "Ajustes de perifricos..." },
/* fr */ { IDMS_PERIPHERAL_SETTINGS_FR, "Paramtres des priphriques..." },
/* hu */ { IDMS_PERIPHERAL_SETTINGS_HU, "Perifrik belltsai..." },
/* it */ { IDMS_PERIPHERAL_SETTINGS_IT, "Impostazioni periferiche..." },
/* ko */ { IDMS_PERIPHERAL_SETTINGS_KO, "ֺġ ..." },
/* nl */ { IDMS_PERIPHERAL_SETTINGS_NL, "Randapparaten instellingen..." },
/* pl */ { IDMS_PERIPHERAL_SETTINGS_PL, "Ustawienia zewntrzne..." },
/* ru */ { IDMS_PERIPHERAL_SETTINGS_RU, "Peripheral settings..." },
/* sv */ { IDMS_PERIPHERAL_SETTINGS_SV, "Instllningar fr kringutrustning..." },
/* tr */ { IDMS_PERIPHERAL_SETTINGS_TR, "evresel ayarlar..." },

/* en */ { IDMS_DRIVE_SETTINGS,    "Drive settings..." },
/* da */ { IDMS_DRIVE_SETTINGS_DA, "Diskettedrevsindstillinger..." },
/* de */ { IDMS_DRIVE_SETTINGS_DE, "Floppy Einstellungen..." },
/* es */ { IDMS_DRIVE_SETTINGS_ES, "Ajustes unidad disco..." },
/* fr */ { IDMS_DRIVE_SETTINGS_FR, "Paramtres des lecteurs..." },
/* hu */ { IDMS_DRIVE_SETTINGS_HU, "Lemezegysg belltsai..." },
/* it */ { IDMS_DRIVE_SETTINGS_IT, "Impostazioni drive..." },
/* ko */ { IDMS_DRIVE_SETTINGS_KO, "̺ ..." },
/* nl */ { IDMS_DRIVE_SETTINGS_NL, "Drive instellingen..." },
/* pl */ { IDMS_DRIVE_SETTINGS_PL, "Ustawienia napdu..." },
/* ru */ { IDMS_DRIVE_SETTINGS_RU, "Drive settings..." },
/* sv */ { IDMS_DRIVE_SETTINGS_SV, "Diskettenhetsinstllningar..." },
/* tr */ { IDMS_DRIVE_SETTINGS_TR, "Src ayarlar..." },

/* en */ { IDMS_PRINTER_SETTINGS,    "Printer settings..." },
/* da */ { IDMS_PRINTER_SETTINGS_DA, "Printerindstillinger..." },
/* de */ { IDMS_PRINTER_SETTINGS_DE, "Drucker Einstellungen..." },
/* es */ { IDMS_PRINTER_SETTINGS_ES, "Ajustes de impresora..." },
/* fr */ { IDMS_PRINTER_SETTINGS_FR, "Paramtres d'imprimante..." },
/* hu */ { IDMS_PRINTER_SETTINGS_HU, "Nyomtat belltsai..." },
/* it */ { IDMS_PRINTER_SETTINGS_IT, "Impostazioni stampanti..." },
/* ko */ { IDMS_PRINTER_SETTINGS_KO, " ..." },
/* nl */ { IDMS_PRINTER_SETTINGS_NL, "Printer instellingen..." },
/* pl */ { IDMS_PRINTER_SETTINGS_PL, "Ustawienia drukarki..." },
/* ru */ { IDMS_PRINTER_SETTINGS_RU, " ..." },
/* sv */ { IDMS_PRINTER_SETTINGS_SV, "Skrivarinstllningar..." },
/* tr */ { IDMS_PRINTER_SETTINGS_TR, "Yazc ayarlar..." },

/* en */ { IDMS_DATASETTE_SETTINGS,    "Datasette settings..." },
/* da */ { IDMS_DATASETTE_SETTINGS_DA, "Datasetteindstillinger..." },
/* de */ { IDMS_DATASETTE_SETTINGS_DE, "Datasette Einstellungen..." },
/* es */ { IDMS_DATASETTE_SETTINGS_ES, "Ajustes Datasette..." },
/* fr */ { IDMS_DATASETTE_SETTINGS_FR, "Paramtres datassette..." },
/* hu */ { IDMS_DATASETTE_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_DATASETTE_SETTINGS_IT, "Impostazioni registratore..." },
/* ko */ { IDMS_DATASETTE_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_DATASETTE_SETTINGS_NL, "Datasette instellingen..." },
/* pl */ { IDMS_DATASETTE_SETTINGS_PL, "Ustawienia magnetofonu..." },
/* ru */ { IDMS_DATASETTE_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_DATASETTE_SETTINGS_SV, "Datasetteinstllningar..." },
/* tr */ { IDMS_DATASETTE_SETTINGS_TR, "Teyp Ayarlar..." },

/* en */ { IDMS_PLUS4_SETTINGS,    "Plus4 settings..." },
/* da */ { IDMS_PLUS4_SETTINGS_DA, "Plus4-indstillinger..." },
/* de */ { IDMS_PLUS4_SETTINGS_DE, "Plus4 Einstellungen..." },
/* es */ { IDMS_PLUS4_SETTINGS_ES, "Ajustes Plus4..." },
/* fr */ { IDMS_PLUS4_SETTINGS_FR, "Paramtres Plus4..." },
/* hu */ { IDMS_PLUS4_SETTINGS_HU, "Plus4 belltsai..." },
/* it */ { IDMS_PLUS4_SETTINGS_IT, "Impostazioni Plus4..." },
/* ko */ { IDMS_PLUS4_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_PLUS4_SETTINGS_NL, "Plus4 instellingen..." },
/* pl */ { IDMS_PLUS4_SETTINGS_PL, "Ustawienia Plus4..." },
/* ru */ { IDMS_PLUS4_SETTINGS_RU, "Plus4 settings..." },
/* sv */ { IDMS_PLUS4_SETTINGS_SV, "Plus4-instllningar..." },
/* tr */ { IDMS_PLUS4_SETTINGS_TR, "Plus4 ayarlar..." },

/* en */ { IDMS_VICII_SETTINGS,    "VIC-II settings..." },
/* da */ { IDMS_VICII_SETTINGS_DA, "VIC-II-indstillinger..." },
/* de */ { IDMS_VICII_SETTINGS_DE, "VIC-II Einstellungen..." },
/* es */ { IDMS_VICII_SETTINGS_ES, "Ajustes VIC-II..." },
/* fr */ { IDMS_VICII_SETTINGS_FR, "Paramtres VIC-II..." },
/* hu */ { IDMS_VICII_SETTINGS_HU, "VIC-II belltsai..." },
/* it */ { IDMS_VICII_SETTINGS_IT, "Impostazioni VIC-II..." },
/* ko */ { IDMS_VICII_SETTINGS_KO, "VIC-II ..." },
/* nl */ { IDMS_VICII_SETTINGS_NL, "VIC-II instellingen..." },
/* pl */ { IDMS_VICII_SETTINGS_PL, "Ustawienia VIC-II..." },
/* ru */ { IDMS_VICII_SETTINGS_RU, " VIC-II..." },
/* sv */ { IDMS_VICII_SETTINGS_SV, "VIC-II-instllningar..." },
/* tr */ { IDMS_VICII_SETTINGS_TR, "VIC-II ayarlar..." },

/* en */ { IDMS_SCPU64_SETTINGS,    "SuperCPU64 settings..." },
/* da */ { IDMS_SCPU64_SETTINGS_DA, "" },  /* fuzzy */
/* de */ { IDMS_SCPU64_SETTINGS_DE, "SuperCPU64 Einstellungen..." },
/* es */ { IDMS_SCPU64_SETTINGS_ES, "Ajustes SuperCPU64..." },
/* fr */ { IDMS_SCPU64_SETTINGS_FR, "Paramtres SuperCPU64..." },
/* hu */ { IDMS_SCPU64_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_SCPU64_SETTINGS_IT, "Impostazioni SuperCPU64..." },
/* ko */ { IDMS_SCPU64_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_SCPU64_SETTINGS_NL, "SuperCPU64 instellingen..." },
/* pl */ { IDMS_SCPU64_SETTINGS_PL, "Ustawienia SuperCPU64..." },
/* ru */ { IDMS_SCPU64_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_SCPU64_SETTINGS_SV, "SuperCPU64-instllningar..." },
/* tr */ { IDMS_SCPU64_SETTINGS_TR, "" },  /* fuzzy */

/* en */ { IDMS_VIC_SETTINGS,    "VIC settings..." },
/* da */ { IDMS_VIC_SETTINGS_DA, "VIC-indstillinger..." },
/* de */ { IDMS_VIC_SETTINGS_DE, "VIC Einstellungen..." },
/* es */ { IDMS_VIC_SETTINGS_ES, "Ajustes VIC..." },
/* fr */ { IDMS_VIC_SETTINGS_FR, "Paramtres VIC..." },
/* hu */ { IDMS_VIC_SETTINGS_HU, "VIC belltsai..." },
/* it */ { IDMS_VIC_SETTINGS_IT, "Impostazioni VIC..." },
/* ko */ { IDMS_VIC_SETTINGS_KO, "VIC ..." },
/* nl */ { IDMS_VIC_SETTINGS_NL, "VIC instellingen..." },
/* pl */ { IDMS_VIC_SETTINGS_PL, "Ustawienia VIC..." },
/* ru */ { IDMS_VIC_SETTINGS_RU, "VIC settings..." },
/* sv */ { IDMS_VIC_SETTINGS_SV, "VIC-instllningar..." },
/* tr */ { IDMS_VIC_SETTINGS_TR, "VIC ayarlar..." },

/* en */ { IDMS_TED_SETTINGS,    "TED settings..." },
/* da */ { IDMS_TED_SETTINGS_DA, "TED-indstillinger..." },
/* de */ { IDMS_TED_SETTINGS_DE, "TED Einstellungen..." },
/* es */ { IDMS_TED_SETTINGS_ES, "Ajustes TED..." },
/* fr */ { IDMS_TED_SETTINGS_FR, "Paramtres TED..." },
/* hu */ { IDMS_TED_SETTINGS_HU, "TED belltsai..." },
/* it */ { IDMS_TED_SETTINGS_IT, "Impostazioni TED..." },
/* ko */ { IDMS_TED_SETTINGS_KO, "TED ..." },
/* nl */ { IDMS_TED_SETTINGS_NL, "TED instellingen..." },
/* pl */ { IDMS_TED_SETTINGS_PL, "Ustawienia TED..." },
/* ru */ { IDMS_TED_SETTINGS_RU, " TED..." },
/* sv */ { IDMS_TED_SETTINGS_SV, "TED-instllningar..." },
/* tr */ { IDMS_TED_SETTINGS_TR, "TED ayarlar..." },

/* en */ { IDMS_JOYPORT_SETTINGS,    "Control port settings..." },
/* da */ { IDMS_JOYPORT_SETTINGS_DA, "" },  /* fuzzy */
/* de */ { IDMS_JOYPORT_SETTINGS_DE, "Control Port Einstellungen..." },
/* es */ { IDMS_JOYPORT_SETTINGS_ES, "" },  /* fuzzy */
/* fr */ { IDMS_JOYPORT_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_JOYPORT_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_JOYPORT_SETTINGS_IT, "" },  /* fuzzy */
/* ko */ { IDMS_JOYPORT_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_JOYPORT_SETTINGS_NL, "Spel connector instellingen..." },
/* pl */ { IDMS_JOYPORT_SETTINGS_PL, "" },  /* fuzzy */
/* ru */ { IDMS_JOYPORT_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_JOYPORT_SETTINGS_SV, "" },  /* fuzzy */
/* tr */ { IDMS_JOYPORT_SETTINGS_TR, "" },  /* fuzzy */

/* en */ { IDMS_JOYSTICK_SETTINGS,    "Joystick settings..." },
/* da */ { IDMS_JOYSTICK_SETTINGS_DA, "Joystick indstillinger..." },
/* de */ { IDMS_JOYSTICK_SETTINGS_DE, "Joystick Einstellungen..." },
/* es */ { IDMS_JOYSTICK_SETTINGS_ES, "Ajustes de joystick..." },
/* fr */ { IDMS_JOYSTICK_SETTINGS_FR, "Paramtres des joysticks..." },
/* hu */ { IDMS_JOYSTICK_SETTINGS_HU, "Botkormny belltsai..." },
/* it */ { IDMS_JOYSTICK_SETTINGS_IT, "Impostazioni joystick..." },
/* ko */ { IDMS_JOYSTICK_SETTINGS_KO, "̽ƽ ..." },
/* nl */ { IDMS_JOYSTICK_SETTINGS_NL, "Joystick instellingen..." },
/* pl */ { IDMS_JOYSTICK_SETTINGS_PL, "Ustawienia joysticka..." },
/* ru */ { IDMS_JOYSTICK_SETTINGS_RU, " ..." },
/* sv */ { IDMS_JOYSTICK_SETTINGS_SV, "Instllningar fr styrspak..." },
/* tr */ { IDMS_JOYSTICK_SETTINGS_TR, "Joystick ayarlar..." },

/* en */ { IDMS_JOYSTICK_DEVICE_SELECT,    "Joystick device selection" },
/* da */ { IDMS_JOYSTICK_DEVICE_SELECT_DA, "Joystick enheds-valg" },
/* de */ { IDMS_JOYSTICK_DEVICE_SELECT_DE, "Joystick Gerte Auswahl" },
/* es */ { IDMS_JOYSTICK_DEVICE_SELECT_ES, "Seleccin perifrico joystick" },
/* fr */ { IDMS_JOYSTICK_DEVICE_SELECT_FR, "Slection des priphriques Joystick" },
/* hu */ { IDMS_JOYSTICK_DEVICE_SELECT_HU, "Botkormny eszkz kivlasztsa" },
/* it */ { IDMS_JOYSTICK_DEVICE_SELECT_IT, "Selezione dispositivo joystick" },
/* ko */ { IDMS_JOYSTICK_DEVICE_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDMS_JOYSTICK_DEVICE_SELECT_NL, "Joystickapparaatselectie" },
/* pl */ { IDMS_JOYSTICK_DEVICE_SELECT_PL, "Wybr urzdzenia joysticka" },
/* ru */ { IDMS_JOYSTICK_DEVICE_SELECT_RU, "Joystick device selection" },
/* sv */ { IDMS_JOYSTICK_DEVICE_SELECT_SV, "Vlj styrspakenhet" },
/* tr */ { IDMS_JOYSTICK_DEVICE_SELECT_TR, "Joystick aygt seimi" },

/* en */ { IDMS_JOYSTICK_FIRE_SELECT,    "Joystick fire button selection" },
/* da */ { IDMS_JOYSTICK_FIRE_SELECT_DA, "Vlg fireknap for joystick" },
/* de */ { IDMS_JOYSTICK_FIRE_SELECT_DE, "Joystick Feuerknopf Wahl" },
/* es */ { IDMS_JOYSTICK_FIRE_SELECT_ES, "Seleccin botn disparo joystick" },
/* fr */ { IDMS_JOYSTICK_FIRE_SELECT_FR, "Slection du bouton FEU du Joystick" },
/* hu */ { IDMS_JOYSTICK_FIRE_SELECT_HU, "Botkormny tzgomb kivlaszts" },
/* it */ { IDMS_JOYSTICK_FIRE_SELECT_IT, "Selezione pulsante di fuoco del joystick" },
/* ko */ { IDMS_JOYSTICK_FIRE_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDMS_JOYSTICK_FIRE_SELECT_NL, "Joystickvuurknopselectie" },
/* pl */ { IDMS_JOYSTICK_FIRE_SELECT_PL, "Wybr przycisku fire joysticka" },
/* ru */ { IDMS_JOYSTICK_FIRE_SELECT_RU, "Joystick fire button selection" },
/* sv */ { IDMS_JOYSTICK_FIRE_SELECT_SV, "Vlj fireknapp fr styrspak" },
/* tr */ { IDMS_JOYSTICK_FIRE_SELECT_TR, "Joystick ate dmesi seimi" },

/* en */ { IDMS_KEYBOARD_SETTINGS,    "Keyboard settings..." },
/* da */ { IDMS_KEYBOARD_SETTINGS_DA, "Tastaturindstillinger..." },
/* de */ { IDMS_KEYBOARD_SETTINGS_DE, "Tastatur Einstellungen..." },
/* es */ { IDMS_KEYBOARD_SETTINGS_ES, "Ajustes de teclado..." },
/* fr */ { IDMS_KEYBOARD_SETTINGS_FR, "Paramtres du clavier..." },
/* hu */ { IDMS_KEYBOARD_SETTINGS_HU, "Billentyzet belltsai..." },
/* it */ { IDMS_KEYBOARD_SETTINGS_IT, "Impostazioni tastiera..." },
/* ko */ { IDMS_KEYBOARD_SETTINGS_KO, "Ű ..." },
/* nl */ { IDMS_KEYBOARD_SETTINGS_NL, "Toetsenbord instellingen..." },
/* pl */ { IDMS_KEYBOARD_SETTINGS_PL, "Ustawienia klawiatury..." },
/* ru */ { IDMS_KEYBOARD_SETTINGS_RU, " ..." },
/* sv */ { IDMS_KEYBOARD_SETTINGS_SV, "Tangentbordsinstllningar..." },
/* tr */ { IDMS_KEYBOARD_SETTINGS_TR, "Klavye ayarlar..." },

/* en */ { IDMS_MOUSE_SETTINGS,    "Mouse settings..." },
/* da */ { IDMS_MOUSE_SETTINGS_DA, "Musseindstillinger..." },
/* de */ { IDMS_MOUSE_SETTINGS_DE, "Maus Einstellungen..." },
/* es */ { IDMS_MOUSE_SETTINGS_ES, "Ajustes ratn..." },
/* fr */ { IDMS_MOUSE_SETTINGS_FR, "Paramtres de souris..." },
/* hu */ { IDMS_MOUSE_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_MOUSE_SETTINGS_IT, "Impostazioni mouse..." },
/* ko */ { IDMS_MOUSE_SETTINGS_KO, "콺 ..." },
/* nl */ { IDMS_MOUSE_SETTINGS_NL, "Muis instellingen..." },
/* pl */ { IDMS_MOUSE_SETTINGS_PL, "Ustawienia myszy..." },
/* ru */ { IDMS_MOUSE_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_MOUSE_SETTINGS_SV, "Musinstllningar..." },
/* tr */ { IDMS_MOUSE_SETTINGS_TR, "Mouse Ayarlar..." },

/* en */ { IDMS_SOUND_SETTINGS,    "Sound settings..." },
/* da */ { IDMS_SOUND_SETTINGS_DA, "Lydindstillinger..." },
/* de */ { IDMS_SOUND_SETTINGS_DE, "Sound Einstellungen..." },
/* es */ { IDMS_SOUND_SETTINGS_ES, "Ajustes de sonido..." },
/* fr */ { IDMS_SOUND_SETTINGS_FR, "Paramtres son..." },
/* hu */ { IDMS_SOUND_SETTINGS_HU, "Hang belltsai..." },
/* it */ { IDMS_SOUND_SETTINGS_IT, "Impostazioni audio..." },
/* ko */ { IDMS_SOUND_SETTINGS_KO, "Ҹ ..." },
/* nl */ { IDMS_SOUND_SETTINGS_NL, "Geluidsinstellingen..." },
/* pl */ { IDMS_SOUND_SETTINGS_PL, "Ustawienia dwiku..." },
/* ru */ { IDMS_SOUND_SETTINGS_RU, " ..." },
/* sv */ { IDMS_SOUND_SETTINGS_SV, "Ljudinstllningar..." },
/* tr */ { IDMS_SOUND_SETTINGS_TR, "Ses ayarlar..." },

/* en */ { IDMS_SAMPLER_SETTINGS,    "Sampler settings..." },
/* da */ { IDMS_SAMPLER_SETTINGS_DA, "" },  /* fuzzy */
/* de */ { IDMS_SAMPLER_SETTINGS_DE, "Sampler Einstellungen..." },
/* es */ { IDMS_SAMPLER_SETTINGS_ES, "" },  /* fuzzy */
/* fr */ { IDMS_SAMPLER_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SAMPLER_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_SAMPLER_SETTINGS_IT, "" },  /* fuzzy */
/* ko */ { IDMS_SAMPLER_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_SAMPLER_SETTINGS_NL, "Sampler instellingen..." },
/* pl */ { IDMS_SAMPLER_SETTINGS_PL, "" },  /* fuzzy */
/* ru */ { IDMS_SAMPLER_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_SAMPLER_SETTINGS_SV, "" },  /* fuzzy */
/* tr */ { IDMS_SAMPLER_SETTINGS_TR, "" },  /* fuzzy */

/* en */ { IDMS_SID_SETTINGS,    "SID settings..." },
/* da */ { IDMS_SID_SETTINGS_DA, "SID-indstillinger..." },
/* de */ { IDMS_SID_SETTINGS_DE, "SID Einstellungen..." },
/* es */ { IDMS_SID_SETTINGS_ES, "Ajustes SID..." },
/* fr */ { IDMS_SID_SETTINGS_FR, "Paramtres SID..." },
/* hu */ { IDMS_SID_SETTINGS_HU, "SID belltsai..." },
/* it */ { IDMS_SID_SETTINGS_IT, "Impostazioni SID..." },
/* ko */ { IDMS_SID_SETTINGS_KO, "SID ..." },
/* nl */ { IDMS_SID_SETTINGS_NL, "SID instellingen..." },
/* pl */ { IDMS_SID_SETTINGS_PL, "Ustawienia SID..." },
/* ru */ { IDMS_SID_SETTINGS_RU, " SID..." },
/* sv */ { IDMS_SID_SETTINGS_SV, "SID-instllningar..." },
/* tr */ { IDMS_SID_SETTINGS_TR, "SID ayarlar..." },

/* en */ { IDMS_CIA_SETTINGS,    "CIA settings..." },
/* da */ { IDMS_CIA_SETTINGS_DA, "CIA-indstillinger..." },
/* de */ { IDMS_CIA_SETTINGS_DE, "CIA Einstellungen..." },
/* es */ { IDMS_CIA_SETTINGS_ES, "Ajustes CIA..." },
/* fr */ { IDMS_CIA_SETTINGS_FR, "Paramtres CIA..." },
/* hu */ { IDMS_CIA_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_CIA_SETTINGS_IT, "Impostazioni CIA..." },
/* ko */ { IDMS_CIA_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_CIA_SETTINGS_NL, "CIA instellingen..." },
/* pl */ { IDMS_CIA_SETTINGS_PL, "Ustawienia CIA..." },
/* ru */ { IDMS_CIA_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_CIA_SETTINGS_SV, "CIA-instllningar..." },
/* tr */ { IDMS_CIA_SETTINGS_TR, "CIA ayarlar..." },

/* en */ { IDMS_COMPUTER_ROM_SETTINGS,    "Computer ROM settings..." },
/* da */ { IDMS_COMPUTER_ROM_SETTINGS_DA, "Computer ROM-indstillinger..." },
/* de */ { IDMS_COMPUTER_ROM_SETTINGS_DE, "Computer ROM Einstellungen..." },
/* es */ { IDMS_COMPUTER_ROM_SETTINGS_ES, "Ajustes ROM ordenador..." },
/* fr */ { IDMS_COMPUTER_ROM_SETTINGS_FR, "Paramtres ROM ordinateur..." },
/* hu */ { IDMS_COMPUTER_ROM_SETTINGS_HU, "Szmtgp ROM belltsai..." },
/* it */ { IDMS_COMPUTER_ROM_SETTINGS_IT, "Impostazioni ROM del computer..." },
/* ko */ { IDMS_COMPUTER_ROM_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_COMPUTER_ROM_SETTINGS_NL, "Computer ROM instellingen..." },
/* pl */ { IDMS_COMPUTER_ROM_SETTINGS_PL, "Ustawienia ROM-u komputera..." },
/* ru */ { IDMS_COMPUTER_ROM_SETTINGS_RU, "Computer ROM settings..." },
/* sv */ { IDMS_COMPUTER_ROM_SETTINGS_SV, "ROM-instllningar fr dator..." },
/* tr */ { IDMS_COMPUTER_ROM_SETTINGS_TR, "Bilgisayar ROM ayarlar..." },

/* en */ { IDMS_DRIVE_ROM_SETTINGS,    "Drive ROM settings..." },
/* da */ { IDMS_DRIVE_ROM_SETTINGS_DA, "Drev ROM-indstillinger..." },
/* de */ { IDMS_DRIVE_ROM_SETTINGS_DE, "Floppy ROM Einstellungen..." },
/* es */ { IDMS_DRIVE_ROM_SETTINGS_ES, "Ajustes ROM unidad disco..." },
/* fr */ { IDMS_DRIVE_ROM_SETTINGS_FR, "Paramtres ROM Lecteur..." },
/* hu */ { IDMS_DRIVE_ROM_SETTINGS_HU, "Lemezegysg ROM belltsai..." },
/* it */ { IDMS_DRIVE_ROM_SETTINGS_IT, "Impostazioni ROM del drive..." },
/* ko */ { IDMS_DRIVE_ROM_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_DRIVE_ROM_SETTINGS_NL, "Drive ROM instellingen..." },
/* pl */ { IDMS_DRIVE_ROM_SETTINGS_PL, "Ustawienia ROM-u napdu..." },
/* ru */ { IDMS_DRIVE_ROM_SETTINGS_RU, "Drive ROM settings..." },
/* sv */ { IDMS_DRIVE_ROM_SETTINGS_SV, "ROM-instllningar fr diskettenhet..." },
/* tr */ { IDMS_DRIVE_ROM_SETTINGS_TR, "Src ROM ayarlar..." },

/* en */ { IDMS_RAM_SETTINGS,    "RAM settings..." },
/* da */ { IDMS_RAM_SETTINGS_DA, "RAM-indstillinger..." },
/* de */ { IDMS_RAM_SETTINGS_DE, "RAM Einstellungen..." },
/* es */ { IDMS_RAM_SETTINGS_ES, "Ajustes RAM..." },
/* fr */ { IDMS_RAM_SETTINGS_FR, "Paramtres de la RAM..." },
/* hu */ { IDMS_RAM_SETTINGS_HU, "RAM belltsai..." },
/* it */ { IDMS_RAM_SETTINGS_IT, "Impostazioni RAM..." },
/* ko */ { IDMS_RAM_SETTINGS_KO, "RAM ..." },
/* nl */ { IDMS_RAM_SETTINGS_NL, "RAM instellingen..." },
/* pl */ { IDMS_RAM_SETTINGS_PL, "Ustawienia RAM..." },
/* ru */ { IDMS_RAM_SETTINGS_RU, " RAM..." },
/* sv */ { IDMS_RAM_SETTINGS_SV, "RAM-instllningar..." },
/* tr */ { IDMS_RAM_SETTINGS_TR, "RAM ayarlar..." },

/* en */ { IDMS_RS232_SETTINGS,    "RS232 settings..." },
/* da */ { IDMS_RS232_SETTINGS_DA, "RS232-indstillinger..." },
/* de */ { IDMS_RS232_SETTINGS_DE, "RS232 Einstellungen..." },
/* es */ { IDMS_RS232_SETTINGS_ES, "Ajustes RS232..." },
/* fr */ { IDMS_RS232_SETTINGS_FR, "Paramtres RS232..." },
/* hu */ { IDMS_RS232_SETTINGS_HU, "RS232 belltsai..." },
/* it */ { IDMS_RS232_SETTINGS_IT, "Impostazioni RS232..." },
/* ko */ { IDMS_RS232_SETTINGS_KO, "RS232 ..." },
/* nl */ { IDMS_RS232_SETTINGS_NL, "RS232 instellingen..." },
/* pl */ { IDMS_RS232_SETTINGS_PL, "Ustawienia RS232..." },
/* ru */ { IDMS_RS232_SETTINGS_RU, " RS232..." },
/* sv */ { IDMS_RS232_SETTINGS_SV, "RS232-instllningar..." },
/* tr */ { IDMS_RS232_SETTINGS_TR, "RS232 ayarlar..." },

/* en */ { IDMS_C128_SETTINGS,    "C128 settings..." },
/* da */ { IDMS_C128_SETTINGS_DA, "C128-indstillinger..." },
/* de */ { IDMS_C128_SETTINGS_DE, "C128 Einstellungen..." },
/* es */ { IDMS_C128_SETTINGS_ES, "Ajustes C128..." },
/* fr */ { IDMS_C128_SETTINGS_FR, "Paramtres C128..." },
/* hu */ { IDMS_C128_SETTINGS_HU, "C128 belltsai..." },
/* it */ { IDMS_C128_SETTINGS_IT, "Impostazioni C128..." },
/* ko */ { IDMS_C128_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C128_SETTINGS_NL, "C128 instellingen..." },
/* pl */ { IDMS_C128_SETTINGS_PL, "Ustawienia C128..." },
/* ru */ { IDMS_C128_SETTINGS_RU, " C128..." },
/* sv */ { IDMS_C128_SETTINGS_SV, "C128-instllningar..." },
/* tr */ { IDMS_C128_SETTINGS_TR, "C128 ayarlar..." },

/* en */ { IDMS_CART_IO_SETTINGS,    "Cartridge/IO settings" },
/* da */ { IDMS_CART_IO_SETTINGS_DA, "Modul/IO-indstillinger" },
/* de */ { IDMS_CART_IO_SETTINGS_DE, "Erweiterungsmodul I/O Einstellungen" },
/* es */ { IDMS_CART_IO_SETTINGS_ES, "Ajustes entrada/salida cartucho" },
/* fr */ { IDMS_CART_IO_SETTINGS_FR, "Paramtres E/S cartouche" },
/* hu */ { IDMS_CART_IO_SETTINGS_HU, "Cartridge/IO belltsai" },
/* it */ { IDMS_CART_IO_SETTINGS_IT, "Impostazioni cartuccia/IO" },
/* ko */ { IDMS_CART_IO_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_CART_IO_SETTINGS_NL, "Cartridge/IO instellingen" },
/* pl */ { IDMS_CART_IO_SETTINGS_PL, "Ustawienia kartrida i we/wy" },
/* ru */ { IDMS_CART_IO_SETTINGS_RU, "Cartridge/IO settings" },
/* sv */ { IDMS_CART_IO_SETTINGS_SV, "Modul/IO-instllningar" },
/* tr */ { IDMS_CART_IO_SETTINGS_TR, "Kartu/G ayarlar" },

/* en */ { IDMS_REU_SETTINGS,    "REU settings..." },
/* da */ { IDMS_REU_SETTINGS_DA, "REU-indstillinger..." },
/* de */ { IDMS_REU_SETTINGS_DE, "REU Einstellungen..." },
/* es */ { IDMS_REU_SETTINGS_ES, "Ajustes REU..." },
/* fr */ { IDMS_REU_SETTINGS_FR, "Paramtres REU..." },
/* hu */ { IDMS_REU_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_REU_SETTINGS_IT, "Impostazioni REU..." },
/* ko */ { IDMS_REU_SETTINGS_KO, "REU ..." },
/* nl */ { IDMS_REU_SETTINGS_NL, "REU instellingen..." },
/* pl */ { IDMS_REU_SETTINGS_PL, "Ustawienia REU..." },
/* ru */ { IDMS_REU_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_REU_SETTINGS_SV, "REU-Instllningar..." },
/* tr */ { IDMS_REU_SETTINGS_TR, "REU Ayarlar..." },

/* en */ { IDMS_MAGIC_VOICE_SETTINGS,    "Magic Voice settings..." },
/* da */ { IDMS_MAGIC_VOICE_SETTINGS_DA, "Magic Voice indstillinger..." },
/* de */ { IDMS_MAGIC_VOICE_SETTINGS_DE, "Magic Voice Einstellungen..." },
/* es */ { IDMS_MAGIC_VOICE_SETTINGS_ES, "Ajustes Magic Voice..." },
/* fr */ { IDMS_MAGIC_VOICE_SETTINGS_FR, "Paramtres Magic Voice..." },
/* hu */ { IDMS_MAGIC_VOICE_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_MAGIC_VOICE_SETTINGS_IT, "Impostazioni Magic Voice..." },
/* ko */ { IDMS_MAGIC_VOICE_SETTINGS_KO, "Magic Voice ..." },
/* nl */ { IDMS_MAGIC_VOICE_SETTINGS_NL, "Magic Voice instellingen..." },
/* pl */ { IDMS_MAGIC_VOICE_SETTINGS_PL, "Ustawienia Magic Voice..." },
/* ru */ { IDMS_MAGIC_VOICE_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_MAGIC_VOICE_SETTINGS_SV, "Magic Voice-instllningar..." },
/* tr */ { IDMS_MAGIC_VOICE_SETTINGS_TR, "Magic Voice ayarlar..." },

/* en */ { IDMS_GEORAM_SETTINGS,    "GEO-RAM settings..." },
/* da */ { IDMS_GEORAM_SETTINGS_DA, "GEO-RAM-indstillinger..." },
/* de */ { IDMS_GEORAM_SETTINGS_DE, "GEO-RAM Einstellungen..." },
/* es */ { IDMS_GEORAM_SETTINGS_ES, "Ajustes GEO-RAM..." },
/* fr */ { IDMS_GEORAM_SETTINGS_FR, "Paramtres GEO-RAM..." },
/* hu */ { IDMS_GEORAM_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_GEORAM_SETTINGS_IT, "Impostazioni GEO-RAM..." },
/* ko */ { IDMS_GEORAM_SETTINGS_KO, "GEO-RAM ..." },
/* nl */ { IDMS_GEORAM_SETTINGS_NL, "GEO-RAM instellingen..." },
/* pl */ { IDMS_GEORAM_SETTINGS_PL, "Ustawienia GEO-RAM..." },
/* ru */ { IDMS_GEORAM_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_GEORAM_SETTINGS_SV, "GEO-RAM-instllningar..." },
/* tr */ { IDMS_GEORAM_SETTINGS_TR, "GEO-RAM ayarlar..." },

/* en */ { IDMS_GEORAM_SETTINGS_MASCUERADE,    "GEO-RAM settings (MasC=uerade)..." },
/* da */ { IDMS_GEORAM_SETTINGS_MASCUERADE_DA, "GEO-RAM-indstillinger (MasC=uerade)..." },
/* de */ { IDMS_GEORAM_SETTINGS_MASCUERADE_DE, "GEO-RAM Einstellungen (MasC=uerade)..." },
/* es */ { IDMS_GEORAM_SETTINGS_MASCUERADE_ES, "Ajustes GEO-RAM (MasC=uerade)..." },
/* fr */ { IDMS_GEORAM_SETTINGS_MASCUERADE_FR, "Paramtres GEO-RAM (MasC=uerade)..." },
/* hu */ { IDMS_GEORAM_SETTINGS_MASCUERADE_HU, "" },  /* fuzzy */
/* it */ { IDMS_GEORAM_SETTINGS_MASCUERADE_IT, "Impostazioni GEO-RAM (MasC=uerade)..." },
/* ko */ { IDMS_GEORAM_SETTINGS_MASCUERADE_KO, "GEO-RAM  (MasC=uerade)..." },
/* nl */ { IDMS_GEORAM_SETTINGS_MASCUERADE_NL, "GEO-RAM instellingen (MasC=uerade)..." },
/* pl */ { IDMS_GEORAM_SETTINGS_MASCUERADE_PL, "Ustawienia GEO-RAM (MasC=uerade)..." },
/* ru */ { IDMS_GEORAM_SETTINGS_MASCUERADE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_GEORAM_SETTINGS_MASCUERADE_SV, "GEO-RAM-instllningar (MasC=uerade)..." },
/* tr */ { IDMS_GEORAM_SETTINGS_MASCUERADE_TR, "GEO-RAM ayarlar (MasC=uerade)..." },

/* en */ { IDMS_RAMCART_SETTINGS,    "RamCart settings..." },
/* da */ { IDMS_RAMCART_SETTINGS_DA, "RamCart-indstillinger..." },
/* de */ { IDMS_RAMCART_SETTINGS_DE, "RamCart Einstellungen..." },
/* es */ { IDMS_RAMCART_SETTINGS_ES, "Ajustes RamCart..." },
/* fr */ { IDMS_RAMCART_SETTINGS_FR, "Paramtres RamCart..." },
/* hu */ { IDMS_RAMCART_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_RAMCART_SETTINGS_IT, "Impostazioni RamCart ..." },
/* ko */ { IDMS_RAMCART_SETTINGS_KO, "RamCart ..." },
/* nl */ { IDMS_RAMCART_SETTINGS_NL, "RamCart instellingen..." },
/* pl */ { IDMS_RAMCART_SETTINGS_PL, "Ustawienia RamCart..." },
/* ru */ { IDMS_RAMCART_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_RAMCART_SETTINGS_SV, "RamCart-instllningar..." },
/* tr */ { IDMS_RAMCART_SETTINGS_TR, "RamCart ayarlar..." },

/* en */ { IDMS_DQBB_SETTINGS,    "Double Quick Brown Box settings..." },
/* da */ { IDMS_DQBB_SETTINGS_DA, "Double Quick Brown Box indstillinger..." },
/* de */ { IDMS_DQBB_SETTINGS_DE, "Double Quick Brown Box Einstellungen..." },
/* es */ { IDMS_DQBB_SETTINGS_ES, "Ajustes Double Quick Brown Box..." },
/* fr */ { IDMS_DQBB_SETTINGS_FR, "Paramtres Double Quick Brown Box..." },
/* hu */ { IDMS_DQBB_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_DQBB_SETTINGS_IT, "Impostazioni Double Quick Brown Box..." },
/* ko */ { IDMS_DQBB_SETTINGS_KO, "Double Quick Brown Box ..." },
/* nl */ { IDMS_DQBB_SETTINGS_NL, "Double Quick Brown Box instellingen..." },
/* pl */ { IDMS_DQBB_SETTINGS_PL, "Ustawienia Double Quick Brown Box..." },
/* ru */ { IDMS_DQBB_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_DQBB_SETTINGS_SV, "Instllninga fr dubbel Quick Brown Box..." },
/* tr */ { IDMS_DQBB_SETTINGS_TR, "Double Quick Brown Box ayarlar..." },

/* en */ { IDMS_ISEPIC_SETTINGS,    "ISEPIC settings..." },
/* da */ { IDMS_ISEPIC_SETTINGS_DA, "ISEPIC-indstillinger..." },
/* de */ { IDMS_ISEPIC_SETTINGS_DE, "ISEPIC Einstellungen..." },
/* es */ { IDMS_ISEPIC_SETTINGS_ES, "Ajustes ISEPIC..." },
/* fr */ { IDMS_ISEPIC_SETTINGS_FR, "Paramtres ISEPIC..." },
/* hu */ { IDMS_ISEPIC_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_ISEPIC_SETTINGS_IT, "Impostazioni ISEPIC..." },
/* ko */ { IDMS_ISEPIC_SETTINGS_KO, "ISEPIC ..." },
/* nl */ { IDMS_ISEPIC_SETTINGS_NL, "ISEPIC instellingen..." },
/* pl */ { IDMS_ISEPIC_SETTINGS_PL, "Ustawienia ISEPIC..." },
/* ru */ { IDMS_ISEPIC_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_ISEPIC_SETTINGS_SV, "ISEPIC-instllningar..." },
/* tr */ { IDMS_ISEPIC_SETTINGS_TR, "ISEPIC ayarlar..." },

/* en */ { IDMS_EXPERT_SETTINGS,    "Expert Cartridge settings..." },
/* da */ { IDMS_EXPERT_SETTINGS_DA, "Expert Cartridge-indstillinger..." },
/* de */ { IDMS_EXPERT_SETTINGS_DE, "Expert Cartridge Einstellungen..." },
/* es */ { IDMS_EXPERT_SETTINGS_ES, "Ajustes Expert Cartrige..." },
/* fr */ { IDMS_EXPERT_SETTINGS_FR, "Paramtres Cartouche Expert..." },
/* hu */ { IDMS_EXPERT_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_EXPERT_SETTINGS_IT, "Impostazioni Expert Cartridge..." },
/* ko */ { IDMS_EXPERT_SETTINGS_KO, "Expert īƮ ..." },
/* nl */ { IDMS_EXPERT_SETTINGS_NL, "Expert Cartridge instellingen..." },
/* pl */ { IDMS_EXPERT_SETTINGS_PL, "Ustawienia Expert Cartridge..." },
/* ru */ { IDMS_EXPERT_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_EXPERT_SETTINGS_SV, "Instllningar fr Expert Cartridge..." },
/* tr */ { IDMS_EXPERT_SETTINGS_TR, "Expert Kartuu ayarlar..." },

/* en */ { IDMS_C64_MEMORY_HACKS_SETTINGS,    "Memory expansion hacks settings..." },
/* da */ { IDMS_C64_MEMORY_HACKS_SETTINGS_DA, "" },  /* fuzzy */
/* de */ { IDMS_C64_MEMORY_HACKS_SETTINGS_DE, "Speicher Erweiterungshack Einstellungen..." },
/* es */ { IDMS_C64_MEMORY_HACKS_SETTINGS_ES, "" },  /* fuzzy */
/* fr */ { IDMS_C64_MEMORY_HACKS_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_C64_MEMORY_HACKS_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64_MEMORY_HACKS_SETTINGS_IT, "" },  /* fuzzy */
/* ko */ { IDMS_C64_MEMORY_HACKS_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C64_MEMORY_HACKS_SETTINGS_NL, "Geheugen uitbreiding hacks instellingen..." },
/* pl */ { IDMS_C64_MEMORY_HACKS_SETTINGS_PL, "Ustawienia hackw rozszerzenia pamici..." },
/* ru */ { IDMS_C64_MEMORY_HACKS_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C64_MEMORY_HACKS_SETTINGS_SV, "" },  /* fuzzy */
/* tr */ { IDMS_C64_MEMORY_HACKS_SETTINGS_TR, "" },  /* fuzzy */

/* en */ { IDS_PLUS256K_FILENAME,    "PLUS256K file" },
/* da */ { IDS_PLUS256K_FILENAME_DA, "PLUS256K-fil" },
/* de */ { IDS_PLUS256K_FILENAME_DE, "PLUS256K Image Name" },
/* es */ { IDS_PLUS256K_FILENAME_ES, "Fichero PLUS256K" },
/* fr */ { IDS_PLUS256K_FILENAME_FR, "Fichier PLUS256K" },
/* hu */ { IDS_PLUS256K_FILENAME_HU, "PLUS256K fjl" },
/* it */ { IDS_PLUS256K_FILENAME_IT, "File PLUS256K" },
/* ko */ { IDS_PLUS256K_FILENAME_KO, "PLUS256K " },
/* nl */ { IDS_PLUS256K_FILENAME_NL, "PLUS256K bestand" },
/* pl */ { IDS_PLUS256K_FILENAME_PL, "Plik PLUS256K" },
/* ru */ { IDS_PLUS256K_FILENAME_RU, "PLUS256K file" },
/* sv */ { IDS_PLUS256K_FILENAME_SV, "PLUS256K-fil" },
/* tr */ { IDS_PLUS256K_FILENAME_TR, "PLUS256K dosyas" },

/* en */ { IDS_PLUS256K_FILENAME_SELECT,    "Select file for PLUS256K" },
/* da */ { IDS_PLUS256K_FILENAME_SELECT_DA, "Vlg fil for PLUS256K" },
/* de */ { IDS_PLUS256K_FILENAME_SELECT_DE, "Datei fr PLUS256K auswhlen" },
/* es */ { IDS_PLUS256K_FILENAME_SELECT_ES, "Seleccionar fichero para PLUS256K" },
/* fr */ { IDS_PLUS256K_FILENAME_SELECT_FR, "Slectionner fichier pour PLUS256K" },
/* hu */ { IDS_PLUS256K_FILENAME_SELECT_HU, "Vlasszon fjlt a PLUS256K-hoz" },
/* it */ { IDS_PLUS256K_FILENAME_SELECT_IT, "Seleziona file per PLUS256K" },
/* ko */ { IDS_PLUS256K_FILENAME_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_PLUS256K_FILENAME_SELECT_NL, "Selecteer bestand voor PLUS256K" },
/* pl */ { IDS_PLUS256K_FILENAME_SELECT_PL, "Wybierz plik PLUS256K" },
/* ru */ { IDS_PLUS256K_FILENAME_SELECT_RU, "Select file for PLUS256K" },
/* sv */ { IDS_PLUS256K_FILENAME_SELECT_SV, "Ange fil fr PLUS256K" },
/* tr */ { IDS_PLUS256K_FILENAME_SELECT_TR, "PLUS256K iin dosya sein" },

/* en */ { IDMS_IDE64_SETTINGS,    "IDE64 settings..." },
/* da */ { IDMS_IDE64_SETTINGS_DA, "IDE64-indstillinger..." },
/* de */ { IDMS_IDE64_SETTINGS_DE, "IDE64 Einstellungen..." },
/* es */ { IDMS_IDE64_SETTINGS_ES, "Ajustes IDE64..." },
/* fr */ { IDMS_IDE64_SETTINGS_FR, "Paramtres IDE64..." },
/* hu */ { IDMS_IDE64_SETTINGS_HU, "IDE64 belltsai..." },
/* it */ { IDMS_IDE64_SETTINGS_IT, "Impostazioni IDE64..." },
/* ko */ { IDMS_IDE64_SETTINGS_KO, "IDE64 ..." },
/* nl */ { IDMS_IDE64_SETTINGS_NL, "IDE64 instellingen..." },
/* pl */ { IDMS_IDE64_SETTINGS_PL, "Ustawienia IDE64..." },
/* ru */ { IDMS_IDE64_SETTINGS_RU, "IDE64 settings..." },
/* sv */ { IDMS_IDE64_SETTINGS_SV, "IDE64-instllningar..." },
/* tr */ { IDMS_IDE64_SETTINGS_TR, "IDE64 ayarlar..." },

/* en */ { IDMS_MMC64_SETTINGS,    "MMC64 settings..." },
/* da */ { IDMS_MMC64_SETTINGS_DA, "MMC64-indstillinger..." },
/* de */ { IDMS_MMC64_SETTINGS_DE, "MMC64 Einstellungen..." },
/* es */ { IDMS_MMC64_SETTINGS_ES, "Ajustes MMC64..." },
/* fr */ { IDMS_MMC64_SETTINGS_FR, "Paramtres MMC64......" },
/* hu */ { IDMS_MMC64_SETTINGS_HU, "MMC64 belltsai..." },
/* it */ { IDMS_MMC64_SETTINGS_IT, "Impostazioni MMC64..." },
/* ko */ { IDMS_MMC64_SETTINGS_KO, "MMC64 ..." },
/* nl */ { IDMS_MMC64_SETTINGS_NL, "MMC64 instellingen..." },
/* pl */ { IDMS_MMC64_SETTINGS_PL, "Ustawienia MMC64..." },
/* ru */ { IDMS_MMC64_SETTINGS_RU, "MMC64 settings..." },
/* sv */ { IDMS_MMC64_SETTINGS_SV, "MMC64-instllningar......" },
/* tr */ { IDMS_MMC64_SETTINGS_TR, "MMC64 ayarlar..." },

/* en */ { IDMS_MMCREPLAY_SETTINGS,    "MMC Replay settings..." },
/* da */ { IDMS_MMCREPLAY_SETTINGS_DA, "MMC Replay-indstillinger..." },
/* de */ { IDMS_MMCREPLAY_SETTINGS_DE, "MMC Replay Einstellungen..." },
/* es */ { IDMS_MMCREPLAY_SETTINGS_ES, "Ajustes MMC Replay..." },
/* fr */ { IDMS_MMCREPLAY_SETTINGS_FR, "Paramtres MMC Replay..." },
/* hu */ { IDMS_MMCREPLAY_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_MMCREPLAY_SETTINGS_IT, "Impostazioni MMC Replay..." },
/* ko */ { IDMS_MMCREPLAY_SETTINGS_KO, "MMC Replay ..." },
/* nl */ { IDMS_MMCREPLAY_SETTINGS_NL, "MMC Replay instellingen..." },
/* pl */ { IDMS_MMCREPLAY_SETTINGS_PL, "Ustawienia MMC Replay..." },
/* ru */ { IDMS_MMCREPLAY_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_MMCREPLAY_SETTINGS_SV, "MMC Replay-instllningar..." },
/* tr */ { IDMS_MMCREPLAY_SETTINGS_TR, "MMC Replay ayarlar..." },

/* en */ { IDMS_RETROREPLAY_SETTINGS,    "Retro Replay settings..." },
/* da */ { IDMS_RETROREPLAY_SETTINGS_DA, "Retro Replay-indstillinger..." },
/* de */ { IDMS_RETROREPLAY_SETTINGS_DE, "Retro Replay Einstellungen..." },
/* es */ { IDMS_RETROREPLAY_SETTINGS_ES, "Ajustes Retro Replay..." },
/* fr */ { IDMS_RETROREPLAY_SETTINGS_FR, "Paramtres Retro Replay..." },
/* hu */ { IDMS_RETROREPLAY_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_RETROREPLAY_SETTINGS_IT, "Impostazioni Retro Replay..." },
/* ko */ { IDMS_RETROREPLAY_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_RETROREPLAY_SETTINGS_NL, "Retro Replay instellingen..." },
/* pl */ { IDMS_RETROREPLAY_SETTINGS_PL, "Ustawienia Retro Replay..." },
/* ru */ { IDMS_RETROREPLAY_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_RETROREPLAY_SETTINGS_SV, "Retro Replay-instllningar..." },
/* tr */ { IDMS_RETROREPLAY_SETTINGS_TR, "Retro Replay ayarlar..." },

/* en */ { IDMS_DIGIMAX_SETTINGS,    "DigiMAX settings..." },
/* da */ { IDMS_DIGIMAX_SETTINGS_DA, "DigiMAX-indstillinger..." },
/* de */ { IDMS_DIGIMAX_SETTINGS_DE, "DigiMAX Einstellungen..." },
/* es */ { IDMS_DIGIMAX_SETTINGS_ES, "Ajustes DigiMAX..." },
/* fr */ { IDMS_DIGIMAX_SETTINGS_FR, "Paramtres DigiMAX..." },
/* hu */ { IDMS_DIGIMAX_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_DIGIMAX_SETTINGS_IT, "Impostazioni DigiMAX..." },
/* ko */ { IDMS_DIGIMAX_SETTINGS_KO, "DigiMAX ..." },
/* nl */ { IDMS_DIGIMAX_SETTINGS_NL, "DigiMAX instellingen..." },
/* pl */ { IDMS_DIGIMAX_SETTINGS_PL, "Ustawienia DigiMAX..." },
/* ru */ { IDMS_DIGIMAX_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_DIGIMAX_SETTINGS_SV, "DigiMAX-instllningar..." },
/* tr */ { IDMS_DIGIMAX_SETTINGS_TR, "DigiMAX ayarlar..." },

/* en */ { IDMS_DIGIMAX_SETTINGS_MASCUERADE,    "DigiMAX settings (MasC=uerade)..." },
/* da */ { IDMS_DIGIMAX_SETTINGS_MASCUERADE_DA, "DigiMAX-indstillinger (MasC=uerade)..." },
/* de */ { IDMS_DIGIMAX_SETTINGS_MASCUERADE_DE, "DigiMAX Einstellungen (MasC=uerade)..." },
/* es */ { IDMS_DIGIMAX_SETTINGS_MASCUERADE_ES, "Ajustes DigiMAX (MasC=uerade)..." },
/* fr */ { IDMS_DIGIMAX_SETTINGS_MASCUERADE_FR, "Paramtres DigiMAX (MasC=uerade)..." },
/* hu */ { IDMS_DIGIMAX_SETTINGS_MASCUERADE_HU, "" },  /* fuzzy */
/* it */ { IDMS_DIGIMAX_SETTINGS_MASCUERADE_IT, "Impostazioni DigiMAX (MasC=uerade)..." },
/* ko */ { IDMS_DIGIMAX_SETTINGS_MASCUERADE_KO, "DigiMAX  (MasC=uerade)..." },
/* nl */ { IDMS_DIGIMAX_SETTINGS_MASCUERADE_NL, "DigiMAX instellingen (MasC=uerade)..." },
/* pl */ { IDMS_DIGIMAX_SETTINGS_MASCUERADE_PL, "Ustawienia DigiMAX (MasC=uerade)..." },
/* ru */ { IDMS_DIGIMAX_SETTINGS_MASCUERADE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_DIGIMAX_SETTINGS_MASCUERADE_SV, "DigiMAX-instllningar (MasC=uerade)..." },
/* tr */ { IDMS_DIGIMAX_SETTINGS_MASCUERADE_TR, "DigiMAX ayarlar (MasC=uerade)..." },

/* en */ { IDMS_DS12C887RTC_SETTINGS,    "DS12C887 RTC settings..." },
/* da */ { IDMS_DS12C887RTC_SETTINGS_DA, "DS12C887 RTC-indstillinger..." },
/* de */ { IDMS_DS12C887RTC_SETTINGS_DE, "DS12C887 RTC Einstellungen..." },
/* es */ { IDMS_DS12C887RTC_SETTINGS_ES, "Ajustes DS12C887 RTC..." },
/* fr */ { IDMS_DS12C887RTC_SETTINGS_FR, "Paramtres DS12C887 RTC..." },
/* hu */ { IDMS_DS12C887RTC_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_DS12C887RTC_SETTINGS_IT, "Impostazioni RTC DS12C887..." },
/* ko */ { IDMS_DS12C887RTC_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_DS12C887RTC_SETTINGS_NL, "DS12C887 RTC instellingen..." },
/* pl */ { IDMS_DS12C887RTC_SETTINGS_PL, "Ustawienia DS12C887 RTC..." },
/* ru */ { IDMS_DS12C887RTC_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_DS12C887RTC_SETTINGS_SV, "DS12C887 RTC-instllningar..." },
/* tr */ { IDMS_DS12C887RTC_SETTINGS_TR, "DS12C887 RTC ayarlar..." },

/* en */ { IDMS_DS12C887RTC_SETTINGS_MASCUERADE,    "DS12C887 RTC settings (MasC=uerade)..." },
/* da */ { IDMS_DS12C887RTC_SETTINGS_MASCUERADE_DA, "DS12C887 RTC-indstillinger (MasC=uerade)..." },
/* de */ { IDMS_DS12C887RTC_SETTINGS_MASCUERADE_DE, "DS12C887 RTC Einstellungen (MasC=uerade)..." },
/* es */ { IDMS_DS12C887RTC_SETTINGS_MASCUERADE_ES, "Ajustes DS12C887 RTC (MasC=uerade)..." },
/* fr */ { IDMS_DS12C887RTC_SETTINGS_MASCUERADE_FR, "Paramtres DS12C887 RTC (MasC=uerade)..." },
/* hu */ { IDMS_DS12C887RTC_SETTINGS_MASCUERADE_HU, "" },  /* fuzzy */
/* it */ { IDMS_DS12C887RTC_SETTINGS_MASCUERADE_IT, "Impostazioni RTC DS12C887 (MasC=uerade)..." },
/* ko */ { IDMS_DS12C887RTC_SETTINGS_MASCUERADE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_DS12C887RTC_SETTINGS_MASCUERADE_NL, "DS12C887 RTC instellingen (MasC=uerade)..." },
/* pl */ { IDMS_DS12C887RTC_SETTINGS_MASCUERADE_PL, "Ustawienia DS12C887 RTC (MasC=uerade)..." },
/* ru */ { IDMS_DS12C887RTC_SETTINGS_MASCUERADE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_DS12C887RTC_SETTINGS_MASCUERADE_SV, "DS12C887 RTC-instllningar (MasC=uerade)..." },
/* tr */ { IDMS_DS12C887RTC_SETTINGS_MASCUERADE_TR, "DS12C887 RTC ayarlar (MasC=uerade)..." },

/* en */ { IDMS_SFX_SE_SETTINGS,    "SFX Sound Expander settings..." },
/* da */ { IDMS_SFX_SE_SETTINGS_DA, "SFX Sound Expander-indstillinger..." },
/* de */ { IDMS_SFX_SE_SETTINGS_DE, "SFX Sound Expander Einstellungen..." },
/* es */ { IDMS_SFX_SE_SETTINGS_ES, "Ajustes SFX Sound Expander..." },
/* fr */ { IDMS_SFX_SE_SETTINGS_FR, "Paramtres du SFX Sound Expander..." },
/* hu */ { IDMS_SFX_SE_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_SFX_SE_SETTINGS_IT, "Impostazioni SFX Sound Expander..." },
/* ko */ { IDMS_SFX_SE_SETTINGS_KO, "SFX Sound Expander ..." },
/* nl */ { IDMS_SFX_SE_SETTINGS_NL, "SFX Sound Expander instellingen..." },
/* pl */ { IDMS_SFX_SE_SETTINGS_PL, "Ustawienia SFX Sound Expander..." },
/* ru */ { IDMS_SFX_SE_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_SFX_SE_SETTINGS_SV, "Instllningar fr SFX Sound Expander..." },
/* tr */ { IDMS_SFX_SE_SETTINGS_TR, "SFX Sound Expander Ayarlar..." },

/* en */ { IDMS_SFX_SE_SETTINGS_MASCUERADE,    "SFX Sound Expander settings (MasC=uerade)..." },
/* da */ { IDMS_SFX_SE_SETTINGS_MASCUERADE_DA, "SFX Sound Expander-indstillinger (MasC=uerade)..." },
/* de */ { IDMS_SFX_SE_SETTINGS_MASCUERADE_DE, "SFX Sound Expander Einstellungen (MasC=uerade)..." },
/* es */ { IDMS_SFX_SE_SETTINGS_MASCUERADE_ES, "Ajustes SFX Sound Expander (MasC=uerade)..." },
/* fr */ { IDMS_SFX_SE_SETTINGS_MASCUERADE_FR, "Paramtres du SFX Sound Expander (MasC=uerade)..." },
/* hu */ { IDMS_SFX_SE_SETTINGS_MASCUERADE_HU, "" },  /* fuzzy */
/* it */ { IDMS_SFX_SE_SETTINGS_MASCUERADE_IT, "Impostazioni SFX Sound Expander (MasC=uerade)..." },
/* ko */ { IDMS_SFX_SE_SETTINGS_MASCUERADE_KO, "SFX Sound Expander  (MasC=uerade)..." },
/* nl */ { IDMS_SFX_SE_SETTINGS_MASCUERADE_NL, "SFX Sound Expander instellingen (MasC=uerade)..." },
/* pl */ { IDMS_SFX_SE_SETTINGS_MASCUERADE_PL, "Ustawienia SFX Sound Expander (MasC=uerade)..." },
/* ru */ { IDMS_SFX_SE_SETTINGS_MASCUERADE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_SFX_SE_SETTINGS_MASCUERADE_SV, "Instllningar fr SFX Sound Expander (MasC=uerade)..." },
/* tr */ { IDMS_SFX_SE_SETTINGS_MASCUERADE_TR, "SFX Sound Expander Ayarlar (MasC=uerade)..." },

/* en */ { IDMS_SFX_SS_SETTINGS_MASCUERADE,    "SFX Sound Sampler settings (MasC=uerade)..." },
/* da */ { IDMS_SFX_SS_SETTINGS_MASCUERADE_DA, "SFX Sound Sampler-indstillinger (MasC=uerade)..." },
/* de */ { IDMS_SFX_SS_SETTINGS_MASCUERADE_DE, "SFX Sound Sampler Einstellungen (MasC=uerade)..." },
/* es */ { IDMS_SFX_SS_SETTINGS_MASCUERADE_ES, "Ajustes SFX Sound Sampler (MasC=uerade)..." },
/* fr */ { IDMS_SFX_SS_SETTINGS_MASCUERADE_FR, "Paramtres du SFX Sound Sampler (MasC=uerade)..." },
/* hu */ { IDMS_SFX_SS_SETTINGS_MASCUERADE_HU, "" },  /* fuzzy */
/* it */ { IDMS_SFX_SS_SETTINGS_MASCUERADE_IT, "Impostazioni SFX Sound Sampler (MasC=uerade)..." },
/* ko */ { IDMS_SFX_SS_SETTINGS_MASCUERADE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_SFX_SS_SETTINGS_MASCUERADE_NL, "SFX Sound Sampler instellingen (MasC=uerade)..." },
/* pl */ { IDMS_SFX_SS_SETTINGS_MASCUERADE_PL, "Ustawienia samplera dwiku SFX (MasC=uerade)..." },
/* ru */ { IDMS_SFX_SS_SETTINGS_MASCUERADE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_SFX_SS_SETTINGS_MASCUERADE_SV, "Instllningar fr SFX Sound Sampler (MasC=uerade)..." },
/* tr */ { IDMS_SFX_SS_SETTINGS_MASCUERADE_TR, "SFX Sound Sampler ayarlar (MasC=uerade)..." },

/* en */ { IDMS_EASYFLASH_SETTINGS,    "EasyFlash settings..." },
/* da */ { IDMS_EASYFLASH_SETTINGS_DA, "EasyFlash-indstillinger..." },
/* de */ { IDMS_EASYFLASH_SETTINGS_DE, "EasyFlash Einstellungen..." },
/* es */ { IDMS_EASYFLASH_SETTINGS_ES, "Ajustes EasyFlash..." },
/* fr */ { IDMS_EASYFLASH_SETTINGS_FR, "Paramtres datassette..." },
/* hu */ { IDMS_EASYFLASH_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_EASYFLASH_SETTINGS_IT, "Impostazioni EasyFlash..." },
/* ko */ { IDMS_EASYFLASH_SETTINGS_KO, "EasyFlash ..." },
/* nl */ { IDMS_EASYFLASH_SETTINGS_NL, "EasyFlash instellingen..." },
/* pl */ { IDMS_EASYFLASH_SETTINGS_PL, "Ustawienia EasyFlash..." },
/* ru */ { IDMS_EASYFLASH_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_EASYFLASH_SETTINGS_SV, "EasyFlash-instllningar..." },
/* tr */ { IDMS_EASYFLASH_SETTINGS_TR, "EasyFlash ayarlar..." },

/* en */ { IDMS_ENABLE_SFX_SS,    "Enable the SFX Sound Sampler cartridge" },
/* da */ { IDMS_ENABLE_SFX_SS_DA, "Aktivr SFX Sound Sampler cartridge" },
/* de */ { IDMS_ENABLE_SFX_SS_DE, "SFX Sound Sampler Modul aktivieren" },
/* es */ { IDMS_ENABLE_SFX_SS_ES, "Permitir cartucho SFX Sound Sampler" },
/* fr */ { IDMS_ENABLE_SFX_SS_FR, "Activer la cartouche SFX Sound Sampler" },
/* hu */ { IDMS_ENABLE_SFX_SS_HU, "SFX Sound Sampler engedlyezse" },
/* it */ { IDMS_ENABLE_SFX_SS_IT, "Attiva cartuccia SFX Sound Sampler" },
/* ko */ { IDMS_ENABLE_SFX_SS_KO, "SFX Sound Sampler īƮ  ۵Ų" },
/* nl */ { IDMS_ENABLE_SFX_SS_NL, "Activeer de SFX Sound Sampler cartridge" },
/* pl */ { IDMS_ENABLE_SFX_SS_PL, "Wcz kartrid SFX Sound Sampler" },
/* ru */ { IDMS_ENABLE_SFX_SS_RU, "Enable the SFX Sound Sampler cartridge" },
/* sv */ { IDMS_ENABLE_SFX_SS_SV, "Aktivera SFX Sound Sampler-insticksmodul" },
/* tr */ { IDMS_ENABLE_SFX_SS_TR, "SFX Sound Sampler kartuunu aktif et" },

/* en */ { IDMS_ENABLE_CPM_CART,    "Enable the CP/M cartridge" },
/* da */ { IDMS_ENABLE_CPM_CART_DA, "" },  /* fuzzy */
/* de */ { IDMS_ENABLE_CPM_CART_DE, "CP/M Modul aktivieren" },
/* es */ { IDMS_ENABLE_CPM_CART_ES, "" },  /* fuzzy */
/* fr */ { IDMS_ENABLE_CPM_CART_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ENABLE_CPM_CART_HU, "" },  /* fuzzy */
/* it */ { IDMS_ENABLE_CPM_CART_IT, "" },  /* fuzzy */
/* ko */ { IDMS_ENABLE_CPM_CART_KO, "" },  /* fuzzy */
/* nl */ { IDMS_ENABLE_CPM_CART_NL, "Activeer de CP/M cartridge" },
/* pl */ { IDMS_ENABLE_CPM_CART_PL, "" },  /* fuzzy */
/* ru */ { IDMS_ENABLE_CPM_CART_RU, "" },  /* fuzzy */
/* sv */ { IDMS_ENABLE_CPM_CART_SV, "" },  /* fuzzy */
/* tr */ { IDMS_ENABLE_CPM_CART_TR, "" },  /* fuzzy */

/* en */ { IDMS_ENABLE_USERPORT_RTC_58321A,    "Enable the Userport RTC (58321a)" },
/* da */ { IDMS_ENABLE_USERPORT_RTC_58321A_DA, "" },  /* fuzzy */
/* de */ { IDMS_ENABLE_USERPORT_RTC_58321A_DE, "Userport RTC (58321a) aktivieren" },
/* es */ { IDMS_ENABLE_USERPORT_RTC_58321A_ES, "" },  /* fuzzy */
/* fr */ { IDMS_ENABLE_USERPORT_RTC_58321A_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ENABLE_USERPORT_RTC_58321A_HU, "" },  /* fuzzy */
/* it */ { IDMS_ENABLE_USERPORT_RTC_58321A_IT, "" },  /* fuzzy */
/* ko */ { IDMS_ENABLE_USERPORT_RTC_58321A_KO, "" },  /* fuzzy */
/* nl */ { IDMS_ENABLE_USERPORT_RTC_58321A_NL, "Activeer de Userport RTC (58321a)" },
/* pl */ { IDMS_ENABLE_USERPORT_RTC_58321A_PL, "" },  /* fuzzy */
/* ru */ { IDMS_ENABLE_USERPORT_RTC_58321A_RU, "" },  /* fuzzy */
/* sv */ { IDMS_ENABLE_USERPORT_RTC_58321A_SV, "" },  /* fuzzy */
/* tr */ { IDMS_ENABLE_USERPORT_RTC_58321A_TR, "" },  /* fuzzy */

/* en */ { IDMS_USERPORT_RTC_58321A_SAVE,    "Enable saving the Userport RTC (58321a) data" },
/* da */ { IDMS_USERPORT_RTC_58321A_SAVE_DA, "" },  /* fuzzy */
/* de */ { IDMS_USERPORT_RTC_58321A_SAVE_DE, "Userport RTC (58321a) Datenspeicherung aktivieren" },
/* es */ { IDMS_USERPORT_RTC_58321A_SAVE_ES, "" },  /* fuzzy */
/* fr */ { IDMS_USERPORT_RTC_58321A_SAVE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_USERPORT_RTC_58321A_SAVE_HU, "" },  /* fuzzy */
/* it */ { IDMS_USERPORT_RTC_58321A_SAVE_IT, "" },  /* fuzzy */
/* ko */ { IDMS_USERPORT_RTC_58321A_SAVE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_USERPORT_RTC_58321A_SAVE_NL, "Activeer opslaan van de Userport RTC (58321a) data" },
/* pl */ { IDMS_USERPORT_RTC_58321A_SAVE_PL, "" },  /* fuzzy */
/* ru */ { IDMS_USERPORT_RTC_58321A_SAVE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_USERPORT_RTC_58321A_SAVE_SV, "" },  /* fuzzy */
/* tr */ { IDMS_USERPORT_RTC_58321A_SAVE_TR, "" },  /* fuzzy */

/* en */ { IDMS_BURST_MOD_SETTINGS,    "Drive burst modification settings..." },
/* da */ { IDMS_BURST_MOD_SETTINGS_DA, "Drev burst-modifikations-indstillinger..." },
/* de */ { IDMS_BURST_MOD_SETTINGS_DE, "Laufwerk Burstmodifkation Einstellungen..." },
/* es */ { IDMS_BURST_MOD_SETTINGS_ES, "Ajuste modificacin Burst en controlador..." },
/* fr */ { IDMS_BURST_MOD_SETTINGS_FR, "Activer l'mulation de Burst Lecteur..." },
/* hu */ { IDMS_BURST_MOD_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_BURST_MOD_SETTINGS_IT, "Impostazioni modifica burst del drive..." },
/* ko */ { IDMS_BURST_MOD_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_BURST_MOD_SETTINGS_NL, "Drive burst modificatie instellingen..." },
/* pl */ { IDMS_BURST_MOD_SETTINGS_PL, "Ustawienia trybu synchronicznego napdu..." },
/* ru */ { IDMS_BURST_MOD_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_BURST_MOD_SETTINGS_SV, "Instllningar fr diskettburstmodifiering..." },
/* tr */ { IDMS_BURST_MOD_SETTINGS_TR, "Src atlama modifikasyon ayarlar..." },

/* en */ { IDMS_ENABLE_PETHRE,    "Enable PET High Res Emulator board" },
/* da */ { IDMS_ENABLE_PETHRE_DA, "" },  /* fuzzy */
/* de */ { IDMS_ENABLE_PETHRE_DE, "PET Hi-Res Emulator Karte aktivieren" },
/* es */ { IDMS_ENABLE_PETHRE_ES, "Permitir tableta grfica PET alta resolucin" },
/* fr */ { IDMS_ENABLE_PETHRE_FR, "Activer la carte haute-rs PET" },
/* hu */ { IDMS_ENABLE_PETHRE_HU, "" },  /* fuzzy */
/* it */ { IDMS_ENABLE_PETHRE_IT, "Attiva scheda alta risoluzione del PET" },
/* ko */ { IDMS_ENABLE_PETHRE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_ENABLE_PETHRE_NL, "Activeer PET High Res Emulator bord" },
/* pl */ { IDMS_ENABLE_PETHRE_PL, "Wcz ukad emulatora PET hi-res" },
/* ru */ { IDMS_ENABLE_PETHRE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_ENABLE_PETHRE_SV, "Aktivera PET-hgupplsningsemuleringskort" },
/* tr */ { IDMS_ENABLE_PETHRE_TR, "" },  /* fuzzy */

/* en */ { IDMS_ENABLE_USERPORT_DAC,    "Enable Userport DAC for sound output" },
/* da */ { IDMS_ENABLE_USERPORT_DAC_DA, "Aktivr brugerport DAC for lydoutput" },
/* de */ { IDMS_ENABLE_USERPORT_DAC_DE, "Userport DAC Sound aktivieren" },
/* es */ { IDMS_ENABLE_USERPORT_DAC_ES, "Permitir puerto DAC para salida de sonido" },
/* fr */ { IDMS_ENABLE_USERPORT_DAC_FR, "Activer DAC port utilisateur comme sortie de son" },
/* hu */ { IDMS_ENABLE_USERPORT_DAC_HU, "" },  /* fuzzy */
/* it */ { IDMS_ENABLE_USERPORT_DAC_IT, "Attiva DAC su userport per la riproduzione audio" },
/* ko */ { IDMS_ENABLE_USERPORT_DAC_KO, "" },  /* fuzzy */
/* nl */ { IDMS_ENABLE_USERPORT_DAC_NL, "Activeer userport DAC voor geluidsuitvoer" },
/* pl */ { IDMS_ENABLE_USERPORT_DAC_PL, "Wcz userport DAC jako wyjcie dwiku" },
/* ru */ { IDMS_ENABLE_USERPORT_DAC_RU, "Enable Userport DAC for sound output" },
/* sv */ { IDMS_ENABLE_USERPORT_DAC_SV, "Aktivera D/A-omvandlare p anvndarporten fr ljudutdata" },
/* tr */ { IDMS_ENABLE_USERPORT_DAC_TR, "Ses k iin Userport DAC' aktif et" },

/* en */ { IDMS_ETHERNET_SETTINGS,    "Ethernet settings..." },
/* da */ { IDMS_ETHERNET_SETTINGS_DA, "Ethernetindstillinger..." },
/* de */ { IDMS_ETHERNET_SETTINGS_DE, "Ethernet Einstellungen..." },
/* es */ { IDMS_ETHERNET_SETTINGS_ES, "Ajustes Ethernet..." },
/* fr */ { IDMS_ETHERNET_SETTINGS_FR, "Paramtres Ethernet..." },
/* hu */ { IDMS_ETHERNET_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_ETHERNET_SETTINGS_IT, "Impostazioni Ethernet..." },
/* ko */ { IDMS_ETHERNET_SETTINGS_KO, "̴ ..." },
/* nl */ { IDMS_ETHERNET_SETTINGS_NL, "Ethernet instellingen..." },
/* pl */ { IDMS_ETHERNET_SETTINGS_PL, "Ustawienia Ethernet..." },
/* ru */ { IDMS_ETHERNET_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_ETHERNET_SETTINGS_SV, "Ethernetinstllningar..." },
/* tr */ { IDMS_ETHERNET_SETTINGS_TR, "Ethernet Ayarlar..." },

/* en */ { IDMS_ACIA_SETTINGS,    "ACIA settings..." },
/* da */ { IDMS_ACIA_SETTINGS_DA, "ACIA-indstillinger..." },
/* de */ { IDMS_ACIA_SETTINGS_DE, "ACIA Einstellungen..." },
/* es */ { IDMS_ACIA_SETTINGS_ES, "Ajustes ACIA..." },
/* fr */ { IDMS_ACIA_SETTINGS_FR, "Paramtres ACIA..." },
/* hu */ { IDMS_ACIA_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_ACIA_SETTINGS_IT, "Impostazioni ACIA..." },
/* ko */ { IDMS_ACIA_SETTINGS_KO, "ACIA ..." },
/* nl */ { IDMS_ACIA_SETTINGS_NL, "ACIA instellingen..." },
/* pl */ { IDMS_ACIA_SETTINGS_PL, "Ustawienia ACIA..." },
/* ru */ { IDMS_ACIA_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_ACIA_SETTINGS_SV, "ACIA-instllningar..." },
/* tr */ { IDMS_ACIA_SETTINGS_TR, "ACIA Ayarlar..." },

/* en */ { IDMS_ACIA_SETTINGS_MASCUERADE,    "ACIA settings (MasC=uerade)..." },
/* da */ { IDMS_ACIA_SETTINGS_MASCUERADE_DA, "ACIA-indstillinger (MasC=uerade)..." },
/* de */ { IDMS_ACIA_SETTINGS_MASCUERADE_DE, "ACIA Einstellungen (MasC=uerade)..." },
/* es */ { IDMS_ACIA_SETTINGS_MASCUERADE_ES, "Ajustes ACIA (MasC=uerade)..." },
/* fr */ { IDMS_ACIA_SETTINGS_MASCUERADE_FR, "Paramtres ACIA (MasC=uerade)..." },
/* hu */ { IDMS_ACIA_SETTINGS_MASCUERADE_HU, "" },  /* fuzzy */
/* it */ { IDMS_ACIA_SETTINGS_MASCUERADE_IT, "Impostazioni ACIA (MasC=uerade)..." },
/* ko */ { IDMS_ACIA_SETTINGS_MASCUERADE_KO, "ACIA  (MasC=uerade)..." },
/* nl */ { IDMS_ACIA_SETTINGS_MASCUERADE_NL, "ACIA instellingen (MasC=uerade)..." },
/* pl */ { IDMS_ACIA_SETTINGS_MASCUERADE_PL, "Ustawienia ACIA (MasC=uerade)..." },
/* ru */ { IDMS_ACIA_SETTINGS_MASCUERADE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_ACIA_SETTINGS_MASCUERADE_SV, "ACIA-instllningar (MasC=uerade)..." },
/* tr */ { IDMS_ACIA_SETTINGS_MASCUERADE_TR, "ACIA Ayarlar (MasC=uerade)..." },

/* en */ { IDMS_PETREU_SETTINGS,    "PET REU settings..." },
/* da */ { IDMS_PETREU_SETTINGS_DA, "PET REU-indstillinger..." },
/* de */ { IDMS_PETREU_SETTINGS_DE, "PET REU Einstellungen..." },
/* es */ { IDMS_PETREU_SETTINGS_ES, "Ajustes PET REU..." },
/* fr */ { IDMS_PETREU_SETTINGS_FR, "Paramtres PET REU..." },
/* hu */ { IDMS_PETREU_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_PETREU_SETTINGS_IT, "Impostazioni PET REU..." },
/* ko */ { IDMS_PETREU_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_PETREU_SETTINGS_NL, "PET REU instellingen..." },
/* pl */ { IDMS_PETREU_SETTINGS_PL, "Ustawienia PET REU..." },
/* ru */ { IDMS_PETREU_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_PETREU_SETTINGS_SV, "PET REU-Instllningar..." },
/* tr */ { IDMS_PETREU_SETTINGS_TR, "PET REU Ayarlar..." },

/* en */ { IDMS_V364_SPEECH_SETTINGS,    "V364 Speech settings..." },
/* da */ { IDMS_V364_SPEECH_SETTINGS_DA, "V364 tale-indstillinger..." },
/* de */ { IDMS_V364_SPEECH_SETTINGS_DE, "V364 Stimme Einstellungen..." },
/* es */ { IDMS_V364_SPEECH_SETTINGS_ES, "Ajustes V364 Speech..." },
/* fr */ { IDMS_V364_SPEECH_SETTINGS_FR, "Paramtres du V364 Speech..." },
/* hu */ { IDMS_V364_SPEECH_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_V364_SPEECH_SETTINGS_IT, "Impostazioni V364 Speech..." },
/* ko */ { IDMS_V364_SPEECH_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_V364_SPEECH_SETTINGS_NL, "V364 Spraak instellingen..." },
/* pl */ { IDMS_V364_SPEECH_SETTINGS_PL, "Ustawienia mowy V364..." },
/* ru */ { IDMS_V364_SPEECH_SETTINGS_RU, "  V364..." },
/* sv */ { IDMS_V364_SPEECH_SETTINGS_SV, "V364-rstinstllningar..." },
/* tr */ { IDMS_V364_SPEECH_SETTINGS_TR, "V364 Speech ayarlar..." },

/* en */ { IDMS_SIDCART_SETTINGS,    "SID cart settings..." },
/* da */ { IDMS_SIDCART_SETTINGS_DA, "SID-cartridgeindstillinger..." },
/* de */ { IDMS_SIDCART_SETTINGS_DE, "SID Modul Einstellungen..." },
/* es */ { IDMS_SIDCART_SETTINGS_ES, "Ajustes SID Cart..." },
/* fr */ { IDMS_SIDCART_SETTINGS_FR, "Paramtres SID Cart..." },
/* hu */ { IDMS_SIDCART_SETTINGS_HU, "SID krtya belltsai......" },
/* it */ { IDMS_SIDCART_SETTINGS_IT, "Impostazioni cartuccia SID..." },
/* ko */ { IDMS_SIDCART_SETTINGS_KO, "SID īƮ ..." },
/* nl */ { IDMS_SIDCART_SETTINGS_NL, "SID cart instellingen..." },
/* pl */ { IDMS_SIDCART_SETTINGS_PL, "Ustawienia karty SID..." },
/* ru */ { IDMS_SIDCART_SETTINGS_RU, "SID cart settings..." },
/* sv */ { IDMS_SIDCART_SETTINGS_SV, "SID-modulinstllningarg..." },
/* tr */ { IDMS_SIDCART_SETTINGS_TR, "SID kartuu ayarlar..." },

/* en */ { IDMS_PETDWW_SETTINGS,    "PET DWW settings..." },
/* da */ { IDMS_PETDWW_SETTINGS_DA, "PET DWW-indstillinger..." },
/* de */ { IDMS_PETDWW_SETTINGS_DE, "PET DWW Einstellungen..." },
/* es */ { IDMS_PETDWW_SETTINGS_ES, "Ajustes PET DWW..." },
/* fr */ { IDMS_PETDWW_SETTINGS_FR, "Paramtres PET DWW..." },
/* hu */ { IDMS_PETDWW_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_PETDWW_SETTINGS_IT, "Impostazioni PET DWW..." },
/* ko */ { IDMS_PETDWW_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_PETDWW_SETTINGS_NL, "PET DWW instellingen..." },
/* pl */ { IDMS_PETDWW_SETTINGS_PL, "Ustawienia PET DWW..." },
/* ru */ { IDMS_PETDWW_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_PETDWW_SETTINGS_SV, "PET DWW-Instllningar..." },
/* tr */ { IDMS_PETDWW_SETTINGS_TR, "PET DWW Ayarlar..." },

/* en */ { IDMS_PETCOLOUR_SETTINGS,    "PET Colour board settings..." },
/* da */ { IDMS_PETCOLOUR_SETTINGS_DA, "" },  /* fuzzy */
/* de */ { IDMS_PETCOLOUR_SETTINGS_DE, "PET Farbkarte Einstellungen..." },
/* es */ { IDMS_PETCOLOUR_SETTINGS_ES, "Ajustes color PET..." },
/* fr */ { IDMS_PETCOLOUR_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_PETCOLOUR_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_PETCOLOUR_SETTINGS_IT, "Impostazioni scheda PET Colour..." },
/* ko */ { IDMS_PETCOLOUR_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_PETCOLOUR_SETTINGS_NL, "PET Colour bord instellingen..." },
/* pl */ { IDMS_PETCOLOUR_SETTINGS_PL, "Ustawienia koloru karty PET..." },
/* ru */ { IDMS_PETCOLOUR_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_PETCOLOUR_SETTINGS_SV, "Instllningar fr PET-frgkort..." },
/* tr */ { IDMS_PETCOLOUR_SETTINGS_TR, "" },  /* fuzzy */

/* en */ { IDMS_FINAL_EXPANSION_WRITEBACK,    "Enable Final Expansion write back to ROM file" },
/* da */ { IDMS_FINAL_EXPANSION_WRITEBACK_DA, "Aktivr Final Expansion tilbageskrivning til ROM-fil" },
/* de */ { IDMS_FINAL_EXPANSION_WRITEBACK_DE, "Final Expansion ROM Schreibzugriff aktivieren" },
/* es */ { IDMS_FINAL_EXPANSION_WRITEBACK_ES, "Permitir grabacin en fichero ROM Final Expansion" },
/* fr */ { IDMS_FINAL_EXPANSION_WRITEBACK_FR, "Activer la rcriture du fichier ROM Final Expansion" },
/* hu */ { IDMS_FINAL_EXPANSION_WRITEBACK_HU, "Final Expansion ROM fjlba visszars engedlyezse" },
/* it */ { IDMS_FINAL_EXPANSION_WRITEBACK_IT, "Attiva write back per Final Expansion su file ROM" },
/* ko */ { IDMS_FINAL_EXPANSION_WRITEBACK_KO, "" },  /* fuzzy */
/* nl */ { IDMS_FINAL_EXPANSION_WRITEBACK_NL, "Activeer terug schrijven naar ROM bestand voor Final Expansion" },
/* pl */ { IDMS_FINAL_EXPANSION_WRITEBACK_PL, "Wcz zapis do pliku ROM Final Expansion" },
/* ru */ { IDMS_FINAL_EXPANSION_WRITEBACK_RU, "Enable Final Expansion write back to ROM file" },
/* sv */ { IDMS_FINAL_EXPANSION_WRITEBACK_SV, "Aktivera terskrivning till ROM-fil fr Final Expansion" },
/* tr */ { IDMS_FINAL_EXPANSION_WRITEBACK_TR, "Final Expansion ROM dosyasna geri yazmay aktif et" },

/* en */ { IDMS_FP_WRITEBACK,    "Enable Vic Flash Plugin write back to ROM file" },
/* da */ { IDMS_FP_WRITEBACK_DA, "Aktivr Vic Flash Plugin tilbageskrivning til ROM-fil" },
/* de */ { IDMS_FP_WRITEBACK_DE, "Vic Flash Plugin Rckschreiben auf ROM Datei aktivieren" },
/* es */ { IDMS_FP_WRITEBACK_ES, "Permitir grabacin en ROM Vic Flash Plugin" },
/* fr */ { IDMS_FP_WRITEBACK_FR, "Activer la rcriture du fichier ROM Vic Flash Plugin" },
/* hu */ { IDMS_FP_WRITEBACK_HU, "" },  /* fuzzy */
/* it */ { IDMS_FP_WRITEBACK_IT, "Attiva write back per Vic Flash Plugin su file ROM" },
/* ko */ { IDMS_FP_WRITEBACK_KO, "" },  /* fuzzy */
/* nl */ { IDMS_FP_WRITEBACK_NL, "Activeer terug schrijven naar ROM bestand voor Vic Flash Plugin" },
/* pl */ { IDMS_FP_WRITEBACK_PL, "Wcz zapis do pliku ROM Vic Flash Plugin" },
/* ru */ { IDMS_FP_WRITEBACK_RU, "Enable Vic Flash Plugin write back to ROM file" },
/* sv */ { IDMS_FP_WRITEBACK_SV, "Aktivera terskrivning till ROM-fil fr Vic Flash-insticksmodul" },
/* tr */ { IDMS_FP_WRITEBACK_TR, "Flash Plugin ROM dosyasna geri yazmay aktif et" },

/* en */ { IDMS_UM_WRITEBACK,    "Enable UltiMem write back to ROM file" },
/* da */ { IDMS_UM_WRITEBACK_DA, "" },  /* fuzzy */
/* de */ { IDMS_UM_WRITEBACK_DE, "UltiMem ROM Schreibzugriff aktivieren" },
/* es */ { IDMS_UM_WRITEBACK_ES, "" },  /* fuzzy */
/* fr */ { IDMS_UM_WRITEBACK_FR, "" },  /* fuzzy */
/* hu */ { IDMS_UM_WRITEBACK_HU, "" },  /* fuzzy */
/* it */ { IDMS_UM_WRITEBACK_IT, "" },  /* fuzzy */
/* ko */ { IDMS_UM_WRITEBACK_KO, "" },  /* fuzzy */
/* nl */ { IDMS_UM_WRITEBACK_NL, "Activeer terug schrijven naar ROM bestand voor UltiMem" },
/* pl */ { IDMS_UM_WRITEBACK_PL, "" },  /* fuzzy */
/* ru */ { IDMS_UM_WRITEBACK_RU, "" },  /* fuzzy */
/* sv */ { IDMS_UM_WRITEBACK_SV, "" },  /* fuzzy */
/* tr */ { IDMS_UM_WRITEBACK_TR, "" },  /* fuzzy */

/* en */ { IDMS_MEGACART_WRITEBACK,    "Enable Mega-Cart NvRAM writeback" },
/* da */ { IDMS_MEGACART_WRITEBACK_DA, "Aktivr Mega-Cart NvRAM tilbageskrivning" },
/* de */ { IDMS_MEGACART_WRITEBACK_DE, "Mega-Cart NvRAM Rckschreiben aktivieren" },
/* es */ { IDMS_MEGACART_WRITEBACK_ES, "Permitir respuesta Mega-Cart NvRAM" },
/* fr */ { IDMS_MEGACART_WRITEBACK_FR, "Permettre la rcriture de l'image Mega-Cart" },
/* hu */ { IDMS_MEGACART_WRITEBACK_HU, "" },  /* fuzzy */
/* it */ { IDMS_MEGACART_WRITEBACK_IT, "Write back NvRAM Mega-Cart" },
/* ko */ { IDMS_MEGACART_WRITEBACK_KO, "" },  /* fuzzy */
/* nl */ { IDMS_MEGACART_WRITEBACK_NL, "Activeer Mega-Cart NvRAM terug schrijven" },
/* pl */ { IDMS_MEGACART_WRITEBACK_PL, "Wcz zapis do NvRAM Mega-Cart" },
/* ru */ { IDMS_MEGACART_WRITEBACK_RU, "Enable Mega-Cart NvRAM writeback" },
/* sv */ { IDMS_MEGACART_WRITEBACK_SV, "Aktivera Mega-Cart NvRAM-terskrivning" },
/* tr */ { IDMS_MEGACART_WRITEBACK_TR, "Mega-Cart NvRAM geri yazmay aktif et" },

/* en */ { IDMS_MEGACART_WRITEBACK_FILE,    "Select Mega-Cart non-volatile RAM file" },
/* da */ { IDMS_MEGACART_WRITEBACK_FILE_DA, "Vlg Mega-Cart NVRAM-fil" },
/* de */ { IDMS_MEGACART_WRITEBACK_FILE_DE, "Mega-Cart nicht-flchtiges RAM Datei whlen" },
/* es */ { IDMS_MEGACART_WRITEBACK_FILE_ES, "Seleccionar fichero RAM Mega-Cart no volatil" },
/* fr */ { IDMS_MEGACART_WRITEBACK_FILE_FR, "Slectionner le fichier de RAM non-volatile Mega-Cart" },
/* hu */ { IDMS_MEGACART_WRITEBACK_FILE_HU, "Vlassza ki az NvRAM kpfjlt" },
/* it */ { IDMS_MEGACART_WRITEBACK_FILE_IT, "Seleziona file non-volatile RAM Mega-Cart" },
/* ko */ { IDMS_MEGACART_WRITEBACK_FILE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_MEGACART_WRITEBACK_FILE_NL, "Selecteer Mega-Cart non-volatile RAM bestand" },
/* pl */ { IDMS_MEGACART_WRITEBACK_FILE_PL, "Wybierz stay plik RAM Mega-Cart" },
/* ru */ { IDMS_MEGACART_WRITEBACK_FILE_RU, "Select Mega-Cart non-volatile RAM file" },
/* sv */ { IDMS_MEGACART_WRITEBACK_FILE_SV, "Vlj NvRAM-fil fr Mega-Cart" },
/* tr */ { IDMS_MEGACART_WRITEBACK_FILE_TR, "Mega-Cart non-volatile RAM dosyasn se" },

/* en */ { IDMS_IO2_RAM_ENABLE,    "Enable I/O-2 RAM" },
/* da */ { IDMS_IO2_RAM_ENABLE_DA, "" },  /* fuzzy */
/* de */ { IDMS_IO2_RAM_ENABLE_DE, "I/O-2 RAM aktivieren" },
/* es */ { IDMS_IO2_RAM_ENABLE_ES, "" },  /* fuzzy */
/* fr */ { IDMS_IO2_RAM_ENABLE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_IO2_RAM_ENABLE_HU, "" },  /* fuzzy */
/* it */ { IDMS_IO2_RAM_ENABLE_IT, "" },  /* fuzzy */
/* ko */ { IDMS_IO2_RAM_ENABLE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_IO2_RAM_ENABLE_NL, "Activeer I/O-2 RAM" },
/* pl */ { IDMS_IO2_RAM_ENABLE_PL, "" },  /* fuzzy */
/* ru */ { IDMS_IO2_RAM_ENABLE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_IO2_RAM_ENABLE_SV, "" },  /* fuzzy */
/* tr */ { IDMS_IO2_RAM_ENABLE_TR, "" },  /* fuzzy */

/* en */ { IDMS_IO3_RAM_ENABLE,    "Enable I/O-3 RAM" },
/* da */ { IDMS_IO3_RAM_ENABLE_DA, "" },  /* fuzzy */
/* de */ { IDMS_IO3_RAM_ENABLE_DE, "I/O-3 RAM aktivieren" },
/* es */ { IDMS_IO3_RAM_ENABLE_ES, "" },  /* fuzzy */
/* fr */ { IDMS_IO3_RAM_ENABLE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_IO3_RAM_ENABLE_HU, "" },  /* fuzzy */
/* it */ { IDMS_IO3_RAM_ENABLE_IT, "" },  /* fuzzy */
/* ko */ { IDMS_IO3_RAM_ENABLE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_IO3_RAM_ENABLE_NL, "Activeer I/O-3 RAM" },
/* pl */ { IDMS_IO3_RAM_ENABLE_PL, "" },  /* fuzzy */
/* ru */ { IDMS_IO3_RAM_ENABLE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_IO3_RAM_ENABLE_SV, "" },  /* fuzzy */
/* tr */ { IDMS_IO3_RAM_ENABLE_TR, "" },  /* fuzzy */

/* en */ { IDMS_C64DTV_SETTINGS,    "C64DTV settings..." },
/* da */ { IDMS_C64DTV_SETTINGS_DA, "C64DTV-indstillinger..." },
/* de */ { IDMS_C64DTV_SETTINGS_DE, "C64DTV Einstellungen..." },
/* es */ { IDMS_C64DTV_SETTINGS_ES, "Ajustes C64DTV..." },
/* fr */ { IDMS_C64DTV_SETTINGS_FR, "Paramtres C64DTV..." },
/* hu */ { IDMS_C64DTV_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64DTV_SETTINGS_IT, "Impostazioni C64DTV..." },
/* ko */ { IDMS_C64DTV_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_C64DTV_SETTINGS_NL, "C64DTV Instellingen..." },
/* pl */ { IDMS_C64DTV_SETTINGS_PL, "Ustawienia C64DTV..." },
/* ru */ { IDMS_C64DTV_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_C64DTV_SETTINGS_SV, "C64DTV-instllningar..." },
/* tr */ { IDMS_C64DTV_SETTINGS_TR, "C64DTV Ayarlar..." },

/* en */ { IDMS_RS232_USERPORT_SETTINGS,    "RS232 userport settings..." },
/* da */ { IDMS_RS232_USERPORT_SETTINGS_DA, "RS232-brugerportindstillinger..." },
/* de */ { IDMS_RS232_USERPORT_SETTINGS_DE, "RS232 Userport Einstellungen..." },
/* es */ { IDMS_RS232_USERPORT_SETTINGS_ES, "Ajustes puerto RS232..." },
/* fr */ { IDMS_RS232_USERPORT_SETTINGS_FR, "Paramtres port utilisateur RS232..." },
/* hu */ { IDMS_RS232_USERPORT_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_RS232_USERPORT_SETTINGS_IT, "Impostazioni RS232 su userport..." },
/* ko */ { IDMS_RS232_USERPORT_SETTINGS_KO, "RS232 Ʈ ..." },
/* nl */ { IDMS_RS232_USERPORT_SETTINGS_NL, "RS232 userport instellingen..." },
/* pl */ { IDMS_RS232_USERPORT_SETTINGS_PL, "Ustawienia userportu RS232..." },
/* ru */ { IDMS_RS232_USERPORT_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_RS232_USERPORT_SETTINGS_SV, "RS232-anvndarportinstllningar..." },
/* tr */ { IDMS_RS232_USERPORT_SETTINGS_TR, "RS232 userport ayarlar..." },

/* en */ { IDMS_SAVE_CURRENT_SETTINGS_FILE,    "Save current settings to specified file" },
/* da */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_DA, "Gem indstillinger som" },
/* de */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_DE, "Speichere Einstellungen in angegebene Datei" },
/* es */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_ES, "Grabar ajustes actuales en el fichero especificado" },
/* fr */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_FR, "Enregistrer les paramtres courants" },
/* hu */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_HU, "Jelenlegi belltsok mentse adott fjlba" },
/* it */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_IT, "Salva impostazioni attuali sul file specificato" },
/* ko */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_KO, "   õ Ͽ  մϴ" },
/* nl */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_NL, "Huidige instellingen opslaan naar opgegeven bestand" },
/* pl */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_PL, "Zapisz obecne ustawienia do danego pliku" },
/* ru */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_RU, "     " },
/* sv */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_SV, "Spara nuvarande instllningar till den angivna filen" },
/* tr */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_TR, "Belirtilen dosyaya geerli ayarlar kaydet" },

/* en */ { IDMS_LOAD_SAVED_SETTINGS_FILE,    "Load settings from specified file" },
/* da */ { IDMS_LOAD_SAVED_SETTINGS_FILE_DA, "Indls indstillinger fra" },
/* de */ { IDMS_LOAD_SAVED_SETTINGS_FILE_DE, "Lade Einstellungen aus Datei" },
/* es */ { IDMS_LOAD_SAVED_SETTINGS_FILE_ES, "Cargar ajustes desde el fichero especificado" },
/* fr */ { IDMS_LOAD_SAVED_SETTINGS_FILE_FR, "Charger les paramtres depuis le fichier spcifi" },
/* hu */ { IDMS_LOAD_SAVED_SETTINGS_FILE_HU, "Belltsok betltse a megadott fjlbl" },
/* it */ { IDMS_LOAD_SAVED_SETTINGS_FILE_IT, "Carica impostazioni dal file specificato" },
/* ko */ { IDMS_LOAD_SAVED_SETTINGS_FILE_KO, "õ Ͽ  ҷɴϴ" },
/* nl */ { IDMS_LOAD_SAVED_SETTINGS_FILE_NL, "Instellingen laden van opgegeven bestand" },
/* pl */ { IDMS_LOAD_SAVED_SETTINGS_FILE_PL, "Wczytaj ustawienia z danego pliku" },
/* ru */ { IDMS_LOAD_SAVED_SETTINGS_FILE_RU, "    " },
/* sv */ { IDMS_LOAD_SAVED_SETTINGS_FILE_SV, "Ls instllningar frn den angivna filen" },
/* tr */ { IDMS_LOAD_SAVED_SETTINGS_FILE_TR, "Belirtilen dosyadan ayarlar ykle" },

/* en */ { IDMS_SAVE_CURRENT_SETTINGS,    "Save current settings" },
/* da */ { IDMS_SAVE_CURRENT_SETTINGS_DA, "Gen aktuelle indstillinger" },
/* de */ { IDMS_SAVE_CURRENT_SETTINGS_DE, "Einstellungen speichern" },
/* es */ { IDMS_SAVE_CURRENT_SETTINGS_ES, "Grabar ajustes actuales" },
/* fr */ { IDMS_SAVE_CURRENT_SETTINGS_FR, "Enregistrer les paramtres courants" },
/* hu */ { IDMS_SAVE_CURRENT_SETTINGS_HU, "Jelenlegi belltsok mentse" },
/* it */ { IDMS_SAVE_CURRENT_SETTINGS_IT, "Salva impostazioni attuali" },
/* ko */ { IDMS_SAVE_CURRENT_SETTINGS_KO, "  " },
/* nl */ { IDMS_SAVE_CURRENT_SETTINGS_NL, "Huidige instellingen opslaan" },
/* pl */ { IDMS_SAVE_CURRENT_SETTINGS_PL, "Zapisz obecne ustawienia" },
/* ru */ { IDMS_SAVE_CURRENT_SETTINGS_RU, "  " },
/* sv */ { IDMS_SAVE_CURRENT_SETTINGS_SV, "Spara nuvarande instllningar" },
/* tr */ { IDMS_SAVE_CURRENT_SETTINGS_TR, "Geerli ayarlar kaydet" },

/* en */ { IDMS_LOAD_SAVED_SETTINGS,    "Load saved settings" },
/* da */ { IDMS_LOAD_SAVED_SETTINGS_DA, "Indls gemte indstillinger" },
/* de */ { IDMS_LOAD_SAVED_SETTINGS_DE, "Gespeicherte Einstellungen Laden" },
/* es */ { IDMS_LOAD_SAVED_SETTINGS_ES, "Cargar ajustes grabados" },
/* fr */ { IDMS_LOAD_SAVED_SETTINGS_FR, "Charger les paramtres enregistrs" },
/* hu */ { IDMS_LOAD_SAVED_SETTINGS_HU, "Belltsok betltse" },
/* it */ { IDMS_LOAD_SAVED_SETTINGS_IT, "Carica impostazioni salvate" },
/* ko */ { IDMS_LOAD_SAVED_SETTINGS_KO, "  ҷ" },
/* nl */ { IDMS_LOAD_SAVED_SETTINGS_NL, "Opgeslagen instellingen laden" },
/* pl */ { IDMS_LOAD_SAVED_SETTINGS_PL, "Wczytaj zapisane ustawienia" },
/* ru */ { IDMS_LOAD_SAVED_SETTINGS_RU, "  " },
/* sv */ { IDMS_LOAD_SAVED_SETTINGS_SV, "Ls sparade instllningar" },
/* tr */ { IDMS_LOAD_SAVED_SETTINGS_TR, "Kaydedilmi ayarlar ykle" },

/* en */ { IDMS_SET_DEFAULT_SETTINGS,    "Set default settings" },
/* da */ { IDMS_SET_DEFAULT_SETTINGS_DA, "Gendan standard indstillinger" },
/* de */ { IDMS_SET_DEFAULT_SETTINGS_DE, "Standard Einstellungen wiederherstellen" },
/* es */ { IDMS_SET_DEFAULT_SETTINGS_ES, "Usar ajustes por defecto" },
/* fr */ { IDMS_SET_DEFAULT_SETTINGS_FR, "Rtablir les paramtres par dfaut" },
/* hu */ { IDMS_SET_DEFAULT_SETTINGS_HU, "Alaprtelmezs belltsa" },
/* it */ { IDMS_SET_DEFAULT_SETTINGS_IT, "Ripristina impostazioni originarie" },
/* ko */ { IDMS_SET_DEFAULT_SETTINGS_KO, " ʱȭ" },
/* nl */ { IDMS_SET_DEFAULT_SETTINGS_NL, "Herstel standaard instellingen" },
/* pl */ { IDMS_SET_DEFAULT_SETTINGS_PL, "Ustaw domylne ustawienia" },
/* ru */ { IDMS_SET_DEFAULT_SETTINGS_RU, "   " },
/* sv */ { IDMS_SET_DEFAULT_SETTINGS_SV, "terstll frvalda instllningar" },
/* tr */ { IDMS_SET_DEFAULT_SETTINGS_TR, "Mevcut ayarlar varsaylan olarak kaydet" },

/* en */ { IDMS_SAVE_SETTING_ON_EXIT,    "Save settings on exit" },
/* da */ { IDMS_SAVE_SETTING_ON_EXIT_DA, "Gem indstillinger nr programmet afsluttes" },
/* de */ { IDMS_SAVE_SETTING_ON_EXIT_DE, "Einstellungen beim Beenden speichern" },
/* es */ { IDMS_SAVE_SETTING_ON_EXIT_ES, "Grabar ajustes al salir" },
/* fr */ { IDMS_SAVE_SETTING_ON_EXIT_FR, "Enregistrer les paramtres  la sortie" },
/* hu */ { IDMS_SAVE_SETTING_ON_EXIT_HU, "Belltsok mentse kilpskor" },
/* it */ { IDMS_SAVE_SETTING_ON_EXIT_IT, "Salva impostazioni in uscita" },
/* ko */ { IDMS_SAVE_SETTING_ON_EXIT_KO, "  ϱ" },
/* nl */ { IDMS_SAVE_SETTING_ON_EXIT_NL, "Sla instellingen op bij afsluiten" },
/* pl */ { IDMS_SAVE_SETTING_ON_EXIT_PL, "Zapisz ustawienia przy wyjciu" },
/* ru */ { IDMS_SAVE_SETTING_ON_EXIT_RU, "   " },
/* sv */ { IDMS_SAVE_SETTING_ON_EXIT_SV, "Spara instllningar vid avslut" },
/* tr */ { IDMS_SAVE_SETTING_ON_EXIT_TR, "kta ayarlar kaydet" },

/* en */ { IDMS_CONFIRM_ON_EXIT,    "Confirm quitting VICE" },
/* da */ { IDMS_CONFIRM_ON_EXIT_DA, "Bekrft programafslutning" },
/* de */ { IDMS_CONFIRM_ON_EXIT_DE, "Besttige Beenden von VICE" },
/* es */ { IDMS_CONFIRM_ON_EXIT_ES, "Confirmar cierre de VICE" },
/* fr */ { IDMS_CONFIRM_ON_EXIT_FR, "Confirmer avant de quitter VICE" },
/* hu */ { IDMS_CONFIRM_ON_EXIT_HU, "" },  /* fuzzy */
/* it */ { IDMS_CONFIRM_ON_EXIT_IT, "Conferma l'uscita da VICE" },
/* ko */ { IDMS_CONFIRM_ON_EXIT_KO, "VICE Ȯ " },
/* nl */ { IDMS_CONFIRM_ON_EXIT_NL, "Bevestigen van het aflsuiten van VICE" },
/* pl */ { IDMS_CONFIRM_ON_EXIT_PL, "Potwierdzaj zamknicie VICE" },
/* ru */ { IDMS_CONFIRM_ON_EXIT_RU, "  VICE" },
/* sv */ { IDMS_CONFIRM_ON_EXIT_SV, "Bekrfta fr att avsluta VICE" },
/* tr */ { IDMS_CONFIRM_ON_EXIT_TR, "VICE'dan k teyit et" },

/* en */ { IDMS_HELP,    "Help" },
/* da */ { IDMS_HELP_DA, "Hjlp" },
/* de */ { IDMS_HELP_DE, "Hilfe" },
/* es */ { IDMS_HELP_ES, "Ayuda" },
/* fr */ { IDMS_HELP_FR, "Aide" },
/* hu */ { IDMS_HELP_HU, "Segtsg" },
/* it */ { IDMS_HELP_IT, "Aiuto" },
/* ko */ { IDMS_HELP_KO, "" },
/* nl */ { IDMS_HELP_NL, "Help" },
/* pl */ { IDMS_HELP_PL, "Pomoc" },
/* ru */ { IDMS_HELP_RU, "" },
/* sv */ { IDMS_HELP_SV, "Hjlp" },
/* tr */ { IDMS_HELP_TR, "Yardm" },

/* en */ { IDMS_ABOUT,    "About VICE..." },
/* da */ { IDMS_ABOUT_DA, "Om VICE..." },
/* de */ { IDMS_ABOUT_DE, "ber VICE..." },
/* es */ { IDMS_ABOUT_ES, "Acerca de VICE..." },
/* fr */ { IDMS_ABOUT_FR, " propos de VICE..." },
/* hu */ { IDMS_ABOUT_HU, "A VICE nvjegye..." },
/* it */ { IDMS_ABOUT_IT, "Informazioni su VICE..." },
/* ko */ { IDMS_ABOUT_KO, " VICE..." },
/* nl */ { IDMS_ABOUT_NL, "Over VICE..." },
/* pl */ { IDMS_ABOUT_PL, "O VICE..." },
/* ru */ { IDMS_ABOUT_RU, "  VICE..." },
/* sv */ { IDMS_ABOUT_SV, "Om VICE..." },
/* tr */ { IDMS_ABOUT_TR, "VICE Hakknda..." },

/* en */ { IDMS_COMMAND_LINE_OPTIONS,    "Command line options" },
/* da */ { IDMS_COMMAND_LINE_OPTIONS_DA, "Kommandolinjeparametre" },
/* de */ { IDMS_COMMAND_LINE_OPTIONS_DE, "Kommandozeilen Parameter" },
/* es */ { IDMS_COMMAND_LINE_OPTIONS_ES, "Opciones de la linea de comandos" },
/* fr */ { IDMS_COMMAND_LINE_OPTIONS_FR, "Options de ligne de commande" },
/* hu */ { IDMS_COMMAND_LINE_OPTIONS_HU, "Parancssori opcik" },
/* it */ { IDMS_COMMAND_LINE_OPTIONS_IT, "Parametri della riga di comando" },
/* ko */ { IDMS_COMMAND_LINE_OPTIONS_KO, "Ŀǵ  ɼ" },
/* nl */ { IDMS_COMMAND_LINE_OPTIONS_NL, "Commando opties" },
/* pl */ { IDMS_COMMAND_LINE_OPTIONS_PL, "Opcje wiersza polece" },
/* ru */ { IDMS_COMMAND_LINE_OPTIONS_RU, "  " },
/* sv */ { IDMS_COMMAND_LINE_OPTIONS_SV, "Kommandoradsflaggor" },
/* tr */ { IDMS_COMMAND_LINE_OPTIONS_TR, "Komut satr seenekleri" },

/* en */ { IDMS_COMPILE_FEATURES,    "Compile time features" },
/* da */ { IDMS_COMPILE_FEATURES_DA, "" },  /* fuzzy */
/* de */ { IDMS_COMPILE_FEATURES_DE, "Kompilierte Funktionen" },
/* es */ { IDMS_COMPILE_FEATURES_ES, "Utilidades tiempo de compilacin" },
/* fr */ { IDMS_COMPILE_FEATURES_FR, "" },  /* fuzzy */
/* hu */ { IDMS_COMPILE_FEATURES_HU, "" },  /* fuzzy */
/* it */ { IDMS_COMPILE_FEATURES_IT, "Opzioni di compilazione" },
/* ko */ { IDMS_COMPILE_FEATURES_KO, "" },  /* fuzzy */
/* nl */ { IDMS_COMPILE_FEATURES_NL, "Speciale opties aanwezig bij het compileren" },
/* pl */ { IDMS_COMPILE_FEATURES_PL, "Opcje kompilacji" },
/* ru */ { IDMS_COMPILE_FEATURES_RU, "" },  /* fuzzy */
/* sv */ { IDMS_COMPILE_FEATURES_SV, "" },  /* fuzzy */
/* tr */ { IDMS_COMPILE_FEATURES_TR, "" },  /* fuzzy */

/* en */ { IDMS_CONTRIBUTORS,    "Contributors" },
/* da */ { IDMS_CONTRIBUTORS_DA, "Bidragsydere" },
/* de */ { IDMS_CONTRIBUTORS_DE, "VICE Hackers" },
/* es */ { IDMS_CONTRIBUTORS_ES, "Contribuyentes" },
/* fr */ { IDMS_CONTRIBUTORS_FR, "Contributeurs" },
/* hu */ { IDMS_CONTRIBUTORS_HU, "Kzremkdk" },
/* it */ { IDMS_CONTRIBUTORS_IT, "Collaboratori" },
/* ko */ { IDMS_CONTRIBUTORS_KO, "" },
/* nl */ { IDMS_CONTRIBUTORS_NL, "Medewerkers" },
/* pl */ { IDMS_CONTRIBUTORS_PL, "Wsppracownicy" },
/* ru */ { IDMS_CONTRIBUTORS_RU, "Contributors" },
/* sv */ { IDMS_CONTRIBUTORS_SV, "Bidragslmnare" },
/* tr */ { IDMS_CONTRIBUTORS_TR, "Katlmclar" },

/* en */ { IDMS_LICENSE,    "License" },
/* da */ { IDMS_LICENSE_DA, "Licens" },
/* de */ { IDMS_LICENSE_DE, "Lizenz" },
/* es */ { IDMS_LICENSE_ES, "Licencia" },
/* fr */ { IDMS_LICENSE_FR, "License" },
/* hu */ { IDMS_LICENSE_HU, "Licensz" },
/* it */ { IDMS_LICENSE_IT, "Licenza" },
/* ko */ { IDMS_LICENSE_KO, "" },
/* nl */ { IDMS_LICENSE_NL, "Licentie" },
/* pl */ { IDMS_LICENSE_PL, "Licencja" },
/* ru */ { IDMS_LICENSE_RU, "" },
/* sv */ { IDMS_LICENSE_SV, "Licens" },
/* tr */ { IDMS_LICENSE_TR, "Lisans" },

/* en */ { IDMS_NO_WARRANTY,    "No warranty!" },
/* da */ { IDMS_NO_WARRANTY_DA, "Ingen garanti!" },
/* de */ { IDMS_NO_WARRANTY_DE, "Keine Garantie!" },
/* es */ { IDMS_NO_WARRANTY_ES, "Sin garantas!" },
/* fr */ { IDMS_NO_WARRANTY_FR, "Aucune garantie!" },
/* hu */ { IDMS_NO_WARRANTY_HU, "Nincs garancia!" },
/* it */ { IDMS_NO_WARRANTY_IT, "Nessuna garanzia!" },
/* ko */ { IDMS_NO_WARRANTY_KO, "Ƽ ϴ" },
/* nl */ { IDMS_NO_WARRANTY_NL, "Geen garantie!" },
/* pl */ { IDMS_NO_WARRANTY_PL, "Bez gwarancji!" },
/* ru */ { IDMS_NO_WARRANTY_RU, " !" },
/* sv */ { IDMS_NO_WARRANTY_SV, "Ingen garanti!" },
/* tr */ { IDMS_NO_WARRANTY_TR, "Garanti verilmez!" },

/* en */ { IDMS_LANGUAGE_INTERNATIONAL,    "International" },
/* da */ { IDMS_LANGUAGE_INTERNATIONAL_DA, "International" },
/* de */ { IDMS_LANGUAGE_INTERNATIONAL_DE, "International" },
/* es */ { IDMS_LANGUAGE_INTERNATIONAL_ES, "Internacional" },
/* fr */ { IDMS_LANGUAGE_INTERNATIONAL_FR, "International" },
/* hu */ { IDMS_LANGUAGE_INTERNATIONAL_HU, "Nemzetkzi" },
/* it */ { IDMS_LANGUAGE_INTERNATIONAL_IT, "Internazionale" },
/* ko */ { IDMS_LANGUAGE_INTERNATIONAL_KO, "" },
/* nl */ { IDMS_LANGUAGE_INTERNATIONAL_NL, "Internationaal" },
/* pl */ { IDMS_LANGUAGE_INTERNATIONAL_PL, "Midzynarodowy" },
/* ru */ { IDMS_LANGUAGE_INTERNATIONAL_RU, "" },
/* sv */ { IDMS_LANGUAGE_INTERNATIONAL_SV, "Internationell" },
/* tr */ { IDMS_LANGUAGE_INTERNATIONAL_TR, "Uluslararas" },

/* en */ { IDMS_LANGUAGE_ENGLISH,    "English" },
/* da */ { IDMS_LANGUAGE_ENGLISH_DA, "Engelsk" },
/* de */ { IDMS_LANGUAGE_ENGLISH_DE, "Englisch" },
/* es */ { IDMS_LANGUAGE_ENGLISH_ES, "Ingls" },
/* fr */ { IDMS_LANGUAGE_ENGLISH_FR, "Anglais" },
/* hu */ { IDMS_LANGUAGE_ENGLISH_HU, "Angol" },
/* it */ { IDMS_LANGUAGE_ENGLISH_IT, "Inglese" },
/* ko */ { IDMS_LANGUAGE_ENGLISH_KO, "" },
/* nl */ { IDMS_LANGUAGE_ENGLISH_NL, "Engels" },
/* pl */ { IDMS_LANGUAGE_ENGLISH_PL, "Angielski" },
/* ru */ { IDMS_LANGUAGE_ENGLISH_RU, "" },
/* sv */ { IDMS_LANGUAGE_ENGLISH_SV, "Engelska" },
/* tr */ { IDMS_LANGUAGE_ENGLISH_TR, "ngilizce" },

/* en */ { IDMS_LANGUAGE_DANISH,    "Danish" },
/* da */ { IDMS_LANGUAGE_DANISH_DA, "Dansk" },
/* de */ { IDMS_LANGUAGE_DANISH_DE, "Dnisch" },
/* es */ { IDMS_LANGUAGE_DANISH_ES, "Dans" },
/* fr */ { IDMS_LANGUAGE_DANISH_FR, "Danois" },
/* hu */ { IDMS_LANGUAGE_DANISH_HU, "Dn" },
/* it */ { IDMS_LANGUAGE_DANISH_IT, "Danese" },
/* ko */ { IDMS_LANGUAGE_DANISH_KO, "ũ" },
/* nl */ { IDMS_LANGUAGE_DANISH_NL, "Deens" },
/* pl */ { IDMS_LANGUAGE_DANISH_PL, "Duski" },
/* ru */ { IDMS_LANGUAGE_DANISH_RU, "" },
/* sv */ { IDMS_LANGUAGE_DANISH_SV, "Danska" },
/* tr */ { IDMS_LANGUAGE_DANISH_TR, "Danimarkaca" },

/* en */ { IDMS_LANGUAGE_GERMAN,    "German" },
/* da */ { IDMS_LANGUAGE_GERMAN_DA, "Tysk" },
/* de */ { IDMS_LANGUAGE_GERMAN_DE, "Deutsch" },
/* es */ { IDMS_LANGUAGE_GERMAN_ES, "Alemn" },
/* fr */ { IDMS_LANGUAGE_GERMAN_FR, "Allemand" },
/* hu */ { IDMS_LANGUAGE_GERMAN_HU, "Nmet" },
/* it */ { IDMS_LANGUAGE_GERMAN_IT, "Tedesco" },
/* ko */ { IDMS_LANGUAGE_GERMAN_KO, "Ͼ" },
/* nl */ { IDMS_LANGUAGE_GERMAN_NL, "Duits" },
/* pl */ { IDMS_LANGUAGE_GERMAN_PL, "Niemiecki" },
/* ru */ { IDMS_LANGUAGE_GERMAN_RU, "" },
/* sv */ { IDMS_LANGUAGE_GERMAN_SV, "Tyska" },
/* tr */ { IDMS_LANGUAGE_GERMAN_TR, "Almanca" },

/* en */ { IDMS_LANGUAGE_SPANISH,    "Spanish" },
/* da */ { IDMS_LANGUAGE_SPANISH_DA, "Spansk" },
/* de */ { IDMS_LANGUAGE_SPANISH_DE, "Spanisch" },
/* es */ { IDMS_LANGUAGE_SPANISH_ES, "Espaol" },
/* fr */ { IDMS_LANGUAGE_SPANISH_FR, "Espagnol" },
/* hu */ { IDMS_LANGUAGE_SPANISH_HU, "" },  /* fuzzy */
/* it */ { IDMS_LANGUAGE_SPANISH_IT, "Spagnolo" },
/* ko */ { IDMS_LANGUAGE_SPANISH_KO, "" },  /* fuzzy */
/* nl */ { IDMS_LANGUAGE_SPANISH_NL, "Spaans" },
/* pl */ { IDMS_LANGUAGE_SPANISH_PL, "Hiszpaski" },
/* ru */ { IDMS_LANGUAGE_SPANISH_RU, "" },
/* sv */ { IDMS_LANGUAGE_SPANISH_SV, "Spanska" },
/* tr */ { IDMS_LANGUAGE_SPANISH_TR, "spanyolca" },

/* en */ { IDMS_LANGUAGE_FINNISH,    "Finnish" },
/* da */ { IDMS_LANGUAGE_FINNISH_DA, "Finsk" },
/* de */ { IDMS_LANGUAGE_FINNISH_DE, "Finnisch" },
/* es */ { IDMS_LANGUAGE_FINNISH_ES, "Finlands" },
/* fr */ { IDMS_LANGUAGE_FINNISH_FR, "Finlandais" },
/* hu */ { IDMS_LANGUAGE_FINNISH_HU, "Finn" },
/* it */ { IDMS_LANGUAGE_FINNISH_IT, "Finlandese" },
/* ko */ { IDMS_LANGUAGE_FINNISH_KO, "ɶ" },
/* nl */ { IDMS_LANGUAGE_FINNISH_NL, "Fins" },
/* pl */ { IDMS_LANGUAGE_FINNISH_PL, "Fiski" },
/* ru */ { IDMS_LANGUAGE_FINNISH_RU, "" },
/* sv */ { IDMS_LANGUAGE_FINNISH_SV, "Finska" },
/* tr */ { IDMS_LANGUAGE_FINNISH_TR, "Fince" },

/* en */ { IDMS_LANGUAGE_FRENCH,    "French" },
/* da */ { IDMS_LANGUAGE_FRENCH_DA, "Fransk" },
/* de */ { IDMS_LANGUAGE_FRENCH_DE, "Franzsisch" },
/* es */ { IDMS_LANGUAGE_FRENCH_ES, "Francs" },
/* fr */ { IDMS_LANGUAGE_FRENCH_FR, "Franais" },
/* hu */ { IDMS_LANGUAGE_FRENCH_HU, "Francia" },
/* it */ { IDMS_LANGUAGE_FRENCH_IT, "Francese" },
/* ko */ { IDMS_LANGUAGE_FRENCH_KO, "" },
/* nl */ { IDMS_LANGUAGE_FRENCH_NL, "Frans" },
/* pl */ { IDMS_LANGUAGE_FRENCH_PL, "Francuski" },
/* ru */ { IDMS_LANGUAGE_FRENCH_RU, "" },
/* sv */ { IDMS_LANGUAGE_FRENCH_SV, "Franska" },
/* tr */ { IDMS_LANGUAGE_FRENCH_TR, "Franszca" },

/* en */ { IDMS_LANGUAGE_HUNGARIAN,    "Hungarian" },
/* da */ { IDMS_LANGUAGE_HUNGARIAN_DA, "Ungarsk" },
/* de */ { IDMS_LANGUAGE_HUNGARIAN_DE, "Ungarisch" },
/* es */ { IDMS_LANGUAGE_HUNGARIAN_ES, "Hngaro" },
/* fr */ { IDMS_LANGUAGE_HUNGARIAN_FR, "Hungarian" },
/* hu */ { IDMS_LANGUAGE_HUNGARIAN_HU, "Magyar" },
/* it */ { IDMS_LANGUAGE_HUNGARIAN_IT, "Ungherese" },
/* ko */ { IDMS_LANGUAGE_HUNGARIAN_KO, "밡" },
/* nl */ { IDMS_LANGUAGE_HUNGARIAN_NL, "Hongaars" },
/* pl */ { IDMS_LANGUAGE_HUNGARIAN_PL, "Wgierski" },
/* ru */ { IDMS_LANGUAGE_HUNGARIAN_RU, "" },
/* sv */ { IDMS_LANGUAGE_HUNGARIAN_SV, "Ungerska" },
/* tr */ { IDMS_LANGUAGE_HUNGARIAN_TR, "Macarca" },

/* en */ { IDMS_LANGUAGE_ITALIAN,    "Italian" },
/* da */ { IDMS_LANGUAGE_ITALIAN_DA, "Italiensk" },
/* de */ { IDMS_LANGUAGE_ITALIAN_DE, "Italienisch" },
/* es */ { IDMS_LANGUAGE_ITALIAN_ES, "Italiano" },
/* fr */ { IDMS_LANGUAGE_ITALIAN_FR, "Italien" },
/* hu */ { IDMS_LANGUAGE_ITALIAN_HU, "Olasz" },
/* it */ { IDMS_LANGUAGE_ITALIAN_IT, "Italiano" },
/* ko */ { IDMS_LANGUAGE_ITALIAN_KO, "Żƾ" },
/* nl */ { IDMS_LANGUAGE_ITALIAN_NL, "Italiaans" },
/* pl */ { IDMS_LANGUAGE_ITALIAN_PL, "Woski" },
/* ru */ { IDMS_LANGUAGE_ITALIAN_RU, "" },
/* sv */ { IDMS_LANGUAGE_ITALIAN_SV, "Italienska" },
/* tr */ { IDMS_LANGUAGE_ITALIAN_TR, "talyanca" },

/* en */ { IDMS_LANGUAGE_KOREAN,    "Korean" },
/* da */ { IDMS_LANGUAGE_KOREAN_DA, "Koreansk" },
/* de */ { IDMS_LANGUAGE_KOREAN_DE, "Koreanisch" },
/* es */ { IDMS_LANGUAGE_KOREAN_ES, "Coreano" },
/* fr */ { IDMS_LANGUAGE_KOREAN_FR, "Koren" },
/* hu */ { IDMS_LANGUAGE_KOREAN_HU, "" },  /* fuzzy */
/* it */ { IDMS_LANGUAGE_KOREAN_IT, "Coreano" },
/* ko */ { IDMS_LANGUAGE_KOREAN_KO, "ѱ" },
/* nl */ { IDMS_LANGUAGE_KOREAN_NL, "Koreaans" },
/* pl */ { IDMS_LANGUAGE_KOREAN_PL, "Koreaski" },
/* ru */ { IDMS_LANGUAGE_KOREAN_RU, "" },  /* fuzzy */
/* sv */ { IDMS_LANGUAGE_KOREAN_SV, "Koreanska" },
/* tr */ { IDMS_LANGUAGE_KOREAN_TR, "Korece" },

/* en */ { IDMS_LANGUAGE_DUTCH,    "Dutch" },
/* da */ { IDMS_LANGUAGE_DUTCH_DA, "Hollandsk" },
/* de */ { IDMS_LANGUAGE_DUTCH_DE, "Hollndisch" },
/* es */ { IDMS_LANGUAGE_DUTCH_ES, "Holands" },
/* fr */ { IDMS_LANGUAGE_DUTCH_FR, "Hollandais" },
/* hu */ { IDMS_LANGUAGE_DUTCH_HU, "Holland" },
/* it */ { IDMS_LANGUAGE_DUTCH_IT, "Olandese" },
/* ko */ { IDMS_LANGUAGE_DUTCH_KO, "״" },
/* nl */ { IDMS_LANGUAGE_DUTCH_NL, "Nederlands" },
/* pl */ { IDMS_LANGUAGE_DUTCH_PL, "Holenderski" },
/* ru */ { IDMS_LANGUAGE_DUTCH_RU, "" },
/* sv */ { IDMS_LANGUAGE_DUTCH_SV, "Nederlndska" },
/* tr */ { IDMS_LANGUAGE_DUTCH_TR, "Hollandaca" },

/* en */ { IDMS_LANGUAGE_POLISH,    "Polish" },
/* da */ { IDMS_LANGUAGE_POLISH_DA, "Polsk" },
/* de */ { IDMS_LANGUAGE_POLISH_DE, "Polnisch" },
/* es */ { IDMS_LANGUAGE_POLISH_ES, "Polaco" },
/* fr */ { IDMS_LANGUAGE_POLISH_FR, "Polonais" },
/* hu */ { IDMS_LANGUAGE_POLISH_HU, "Lengyel" },
/* it */ { IDMS_LANGUAGE_POLISH_IT, "Polacco" },
/* ko */ { IDMS_LANGUAGE_POLISH_KO, "" },
/* nl */ { IDMS_LANGUAGE_POLISH_NL, "Pools" },
/* pl */ { IDMS_LANGUAGE_POLISH_PL, "Polski" },
/* ru */ { IDMS_LANGUAGE_POLISH_RU, "" },
/* sv */ { IDMS_LANGUAGE_POLISH_SV, "Polska" },
/* tr */ { IDMS_LANGUAGE_POLISH_TR, "Polonyaca" },

/* en */ { IDMS_LANGUAGE_NORWEGIAN,    "Norwegian" },
/* da */ { IDMS_LANGUAGE_NORWEGIAN_DA, "Norsk" },
/* de */ { IDMS_LANGUAGE_NORWEGIAN_DE, "Norwegisch" },
/* es */ { IDMS_LANGUAGE_NORWEGIAN_ES, "Noruego" },
/* fr */ { IDMS_LANGUAGE_NORWEGIAN_FR, "Norvgien" },
/* hu */ { IDMS_LANGUAGE_NORWEGIAN_HU, "Norvg" },
/* it */ { IDMS_LANGUAGE_NORWEGIAN_IT, "Norvegese" },
/* ko */ { IDMS_LANGUAGE_NORWEGIAN_KO, "븣̾" },
/* nl */ { IDMS_LANGUAGE_NORWEGIAN_NL, "Noors" },
/* pl */ { IDMS_LANGUAGE_NORWEGIAN_PL, "Norweski" },
/* ru */ { IDMS_LANGUAGE_NORWEGIAN_RU, "" },
/* sv */ { IDMS_LANGUAGE_NORWEGIAN_SV, "Norska" },
/* tr */ { IDMS_LANGUAGE_NORWEGIAN_TR, "Norvee" },

/* en */ { IDMS_LANGUAGE_RUSSIAN,    "Russian" },
/* da */ { IDMS_LANGUAGE_RUSSIAN_DA, "Russisk" },
/* de */ { IDMS_LANGUAGE_RUSSIAN_DE, "Russisch" },
/* es */ { IDMS_LANGUAGE_RUSSIAN_ES, "Ruso" },
/* fr */ { IDMS_LANGUAGE_RUSSIAN_FR, "Russe" },
/* hu */ { IDMS_LANGUAGE_RUSSIAN_HU, "" },  /* fuzzy */
/* it */ { IDMS_LANGUAGE_RUSSIAN_IT, "Russo" },
/* ko */ { IDMS_LANGUAGE_RUSSIAN_KO, "þƾ" },
/* nl */ { IDMS_LANGUAGE_RUSSIAN_NL, "Russies" },
/* pl */ { IDMS_LANGUAGE_RUSSIAN_PL, "Rosyjski" },
/* ru */ { IDMS_LANGUAGE_RUSSIAN_RU, "" },
/* sv */ { IDMS_LANGUAGE_RUSSIAN_SV, "Ryska" },
/* tr */ { IDMS_LANGUAGE_RUSSIAN_TR, "Rusa" },

/* en */ { IDMS_LANGUAGE_SWEDISH,    "Swedish" },
/* da */ { IDMS_LANGUAGE_SWEDISH_DA, "Svensk" },
/* de */ { IDMS_LANGUAGE_SWEDISH_DE, "Schwedisch" },
/* es */ { IDMS_LANGUAGE_SWEDISH_ES, "Sueco" },
/* fr */ { IDMS_LANGUAGE_SWEDISH_FR, "Sudois" },
/* hu */ { IDMS_LANGUAGE_SWEDISH_HU, "Svd" },
/* it */ { IDMS_LANGUAGE_SWEDISH_IT, "Svedese" },
/* ko */ { IDMS_LANGUAGE_SWEDISH_KO, "" },
/* nl */ { IDMS_LANGUAGE_SWEDISH_NL, "Zweeds" },
/* pl */ { IDMS_LANGUAGE_SWEDISH_PL, "Szwedzki" },
/* ru */ { IDMS_LANGUAGE_SWEDISH_RU, "" },
/* sv */ { IDMS_LANGUAGE_SWEDISH_SV, "Svenska" },
/* tr */ { IDMS_LANGUAGE_SWEDISH_TR, "svee" },

/* en */ { IDMS_LANGUAGE_SWISS,    "Swiss" },
/* da */ { IDMS_LANGUAGE_SWISS_DA, "" },  /* fuzzy */
/* de */ { IDMS_LANGUAGE_SWISS_DE, "Schweiz" },
/* es */ { IDMS_LANGUAGE_SWISS_ES, "Suizo" },
/* fr */ { IDMS_LANGUAGE_SWISS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_LANGUAGE_SWISS_HU, "" },  /* fuzzy */
/* it */ { IDMS_LANGUAGE_SWISS_IT, "Svizzero" },
/* ko */ { IDMS_LANGUAGE_SWISS_KO, "" },  /* fuzzy */
/* nl */ { IDMS_LANGUAGE_SWISS_NL, "Zwitser" },
/* pl */ { IDMS_LANGUAGE_SWISS_PL, "Szwajcarski" },
/* ru */ { IDMS_LANGUAGE_SWISS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_LANGUAGE_SWISS_SV, "" },  /* fuzzy */
/* tr */ { IDMS_LANGUAGE_SWISS_TR, "" },  /* fuzzy */

/* en */ { IDMS_LANGUAGE_TURKISH,    "Turkish" },
/* da */ { IDMS_LANGUAGE_TURKISH_DA, "Tyrkisk" },
/* de */ { IDMS_LANGUAGE_TURKISH_DE, "Trkisch" },
/* es */ { IDMS_LANGUAGE_TURKISH_ES, "Turco" },
/* fr */ { IDMS_LANGUAGE_TURKISH_FR, "Turc" },
/* hu */ { IDMS_LANGUAGE_TURKISH_HU, "Trk" },
/* it */ { IDMS_LANGUAGE_TURKISH_IT, "Turco" },
/* ko */ { IDMS_LANGUAGE_TURKISH_KO, "Ű" },
/* nl */ { IDMS_LANGUAGE_TURKISH_NL, "Turks" },
/* pl */ { IDMS_LANGUAGE_TURKISH_PL, "Turecki" },
/* ru */ { IDMS_LANGUAGE_TURKISH_RU, "" },
/* sv */ { IDMS_LANGUAGE_TURKISH_SV, "Turkiska" },
/* tr */ { IDMS_LANGUAGE_TURKISH_TR, "Trke" },

/* en */ { IDMS_LANGUAGE,    "Language" },
/* da */ { IDMS_LANGUAGE_DA, "Sprog" },
/* de */ { IDMS_LANGUAGE_DE, "Sprache" },
/* es */ { IDMS_LANGUAGE_ES, "Idioma" },
/* fr */ { IDMS_LANGUAGE_FR, "Langage" },
/* hu */ { IDMS_LANGUAGE_HU, "Nyelv" },
/* it */ { IDMS_LANGUAGE_IT, "Lingua" },
/* ko */ { IDMS_LANGUAGE_KO, "" },
/* nl */ { IDMS_LANGUAGE_NL, "Taal" },
/* pl */ { IDMS_LANGUAGE_PL, "Jzyk" },
/* ru */ { IDMS_LANGUAGE_RU, "" },
/* sv */ { IDMS_LANGUAGE_SV, "Sprk" },
/* tr */ { IDMS_LANGUAGE_TR, "Dil" },

/* en */ { IDMS_FULLSCREEN_STATUSBAR,    "Fullscreen Statusbar" },
/* da */ { IDMS_FULLSCREEN_STATUSBAR_DA, "Statusbar i fullscreen" },
/* de */ { IDMS_FULLSCREEN_STATUSBAR_DE, "Vollbild Statusleiste" },
/* es */ { IDMS_FULLSCREEN_STATUSBAR_ES, "Barra estado pantalla completa" },
/* fr */ { IDMS_FULLSCREEN_STATUSBAR_FR, "Barre de statut Plein cran" },
/* hu */ { IDMS_FULLSCREEN_STATUSBAR_HU, "llapotsor teljes kpernynl" },
/* it */ { IDMS_FULLSCREEN_STATUSBAR_IT, "Barra di stato nella modalit a schermo intero" },
/* ko */ { IDMS_FULLSCREEN_STATUSBAR_KO, "" },  /* fuzzy */
/* nl */ { IDMS_FULLSCREEN_STATUSBAR_NL, "Volscherm Statusbalk" },
/* pl */ { IDMS_FULLSCREEN_STATUSBAR_PL, "Pasek stanu w trybie penego ekranu" },
/* ru */ { IDMS_FULLSCREEN_STATUSBAR_RU, "Fullscreen Statusbar" },
/* sv */ { IDMS_FULLSCREEN_STATUSBAR_SV, "Statusrad i fullskrm" },
/* tr */ { IDMS_FULLSCREEN_STATUSBAR_TR, "Tam ekran durum ubuu" },

/* en */ { IDMS_VIDEO_OVERLAY,    "Video overlay" },
/* da */ { IDMS_VIDEO_OVERLAY_DA, "Video-overlay" },
/* de */ { IDMS_VIDEO_OVERLAY_DE, "Video Overlay" },
/* es */ { IDMS_VIDEO_OVERLAY_ES, "Vdeo overlay" },
/* fr */ { IDMS_VIDEO_OVERLAY_FR, "Superposition vido" },
/* hu */ { IDMS_VIDEO_OVERLAY_HU, "Vide overlay" },
/* it */ { IDMS_VIDEO_OVERLAY_IT, "Overlay video" },
/* ko */ { IDMS_VIDEO_OVERLAY_KO, "" },  /* fuzzy */
/* nl */ { IDMS_VIDEO_OVERLAY_NL, "Video overlay" },
/* pl */ { IDMS_VIDEO_OVERLAY_PL, "Video overlay" },
/* ru */ { IDMS_VIDEO_OVERLAY_RU, "Video overlay" },
/* sv */ { IDMS_VIDEO_OVERLAY_SV, "Video-overlay" },
/* tr */ { IDMS_VIDEO_OVERLAY_TR, "Grnt bindirme" },

/* en */ { IDMS_START_SOUND_RECORD,    "Start Sound Record..." },
/* da */ { IDMS_START_SOUND_RECORD_DA, "Start lydoptagelse..." },
/* de */ { IDMS_START_SOUND_RECORD_DE, "Tonaufnahme starten..." },
/* es */ { IDMS_START_SOUND_RECORD_ES, "Iniciar grabacin sonido..." },
/* fr */ { IDMS_START_SOUND_RECORD_FR, "Dmarrer l'enregistrement du son..." },
/* hu */ { IDMS_START_SOUND_RECORD_HU, "" },  /* fuzzy */
/* it */ { IDMS_START_SOUND_RECORD_IT, "Avvia la registrazione audio..." },
/* ko */ { IDMS_START_SOUND_RECORD_KO, "" },  /* fuzzy */
/* nl */ { IDMS_START_SOUND_RECORD_NL, "Start Geluidsopname..." },
/* pl */ { IDMS_START_SOUND_RECORD_PL, "Rozpocznij zapis dwiku..." },
/* ru */ { IDMS_START_SOUND_RECORD_RU, "  ..." },
/* sv */ { IDMS_START_SOUND_RECORD_SV, "Starta ljudinspelning..." },
/* tr */ { IDMS_START_SOUND_RECORD_TR, "Ses Kaydn Balat..." },

/* en */ { IDMS_STOP_SOUND_RECORD,    "Stop Sound record" },
/* da */ { IDMS_STOP_SOUND_RECORD_DA, "Stop lydoptagelse" },
/* de */ { IDMS_STOP_SOUND_RECORD_DE, "Tonaufnahme stoppen" },
/* es */ { IDMS_STOP_SOUND_RECORD_ES, "Finalizar grabacin de sonido" },
/* fr */ { IDMS_STOP_SOUND_RECORD_FR, "Arrter l'enregistrement du son" },
/* hu */ { IDMS_STOP_SOUND_RECORD_HU, "Hangfelvtel lelltsa" },
/* it */ { IDMS_STOP_SOUND_RECORD_IT, "Interrompi registrazione audio" },
/* ko */ { IDMS_STOP_SOUND_RECORD_KO, " ڵ " },
/* nl */ { IDMS_STOP_SOUND_RECORD_NL, "Stop geluidsopname" },
/* pl */ { IDMS_STOP_SOUND_RECORD_PL, "Zatrzymaj zapis dwiku" },
/* ru */ { IDMS_STOP_SOUND_RECORD_RU, "  " },
/* sv */ { IDMS_STOP_SOUND_RECORD_SV, "Stoppa ljudinspelning" },
/* tr */ { IDMS_STOP_SOUND_RECORD_TR, "Ses kaydn durdur" },

/* en */ { IDMS_LOAD_PSID_FILE,    "Load PSID file" },
/* da */ { IDMS_LOAD_PSID_FILE_DA, "Indls PSID-fil" },
/* de */ { IDMS_LOAD_PSID_FILE_DE, "PSID Datei laden" },
/* es */ { IDMS_LOAD_PSID_FILE_ES, "Cargar fichero PSID" },
/* fr */ { IDMS_LOAD_PSID_FILE_FR, "Charger le fichier PSID" },
/* hu */ { IDMS_LOAD_PSID_FILE_HU, "PSID fjl betltse" },
/* it */ { IDMS_LOAD_PSID_FILE_IT, "Carica file PSID" },
/* ko */ { IDMS_LOAD_PSID_FILE_KO, "PSID  ҷ" },
/* nl */ { IDMS_LOAD_PSID_FILE_NL, "Laad PSID bestand" },
/* pl */ { IDMS_LOAD_PSID_FILE_PL, "Wczytaj plik PSID" },
/* ru */ { IDMS_LOAD_PSID_FILE_RU, "Load PSID file" },
/* sv */ { IDMS_LOAD_PSID_FILE_SV, "Ls PSID-fil" },
/* tr */ { IDMS_LOAD_PSID_FILE_TR, "PSID dosyas ykle" },

/* en */ { IDMS_NEXT_TUNE,    "Next tune" },
/* da */ { IDMS_NEXT_TUNE_DA, "Nste sang" },
/* de */ { IDMS_NEXT_TUNE_DE, "Nchster Titel " },
/* es */ { IDMS_NEXT_TUNE_ES, "Siguiente melodia" },
/* fr */ { IDMS_NEXT_TUNE_FR, "Clip suivant" },
/* hu */ { IDMS_NEXT_TUNE_HU, "" },  /* fuzzy */
/* it */ { IDMS_NEXT_TUNE_IT, "Melodia successiva" },
/* ko */ { IDMS_NEXT_TUNE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_NEXT_TUNE_NL, "Volgend deuntje" },
/* pl */ { IDMS_NEXT_TUNE_PL, "Nastpny ton" },
/* ru */ { IDMS_NEXT_TUNE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_NEXT_TUNE_SV, "Nsta lt" },
/* tr */ { IDMS_NEXT_TUNE_TR, "Sonraki ark" },

/* en */ { IDMS_PREVIOUS_TUNE,    "Previous tune" },
/* da */ { IDMS_PREVIOUS_TUNE_DA, "Forrige sang" },
/* de */ { IDMS_PREVIOUS_TUNE_DE, "Vorheriger Titel " },
/* es */ { IDMS_PREVIOUS_TUNE_ES, "Meloda previa" },
/* fr */ { IDMS_PREVIOUS_TUNE_FR, "Clip prcdent" },
/* hu */ { IDMS_PREVIOUS_TUNE_HU, "" },  /* fuzzy */
/* it */ { IDMS_PREVIOUS_TUNE_IT, "Melodia precedente" },
/* ko */ { IDMS_PREVIOUS_TUNE_KO, "" },  /* fuzzy */
/* nl */ { IDMS_PREVIOUS_TUNE_NL, "Vorig deuntje" },
/* pl */ { IDMS_PREVIOUS_TUNE_PL, "Poprzedni ton" },
/* ru */ { IDMS_PREVIOUS_TUNE_RU, "" },  /* fuzzy */
/* sv */ { IDMS_PREVIOUS_TUNE_SV, "Fregende lt" },
/* tr */ { IDMS_PREVIOUS_TUNE_TR, "nceki ark" },

/* en */ { IDMS_MEDIA,    "Media" },
/* da */ { IDMS_MEDIA_DA, "Medie" },
/* de */ { IDMS_MEDIA_DE, "Medien" },
/* es */ { IDMS_MEDIA_ES, "Medio" },
/* fr */ { IDMS_MEDIA_FR, "Mdia" },
/* hu */ { IDMS_MEDIA_HU, "" },  /* fuzzy */
/* it */ { IDMS_MEDIA_IT, "Media" },
/* ko */ { IDMS_MEDIA_KO, "" },  /* fuzzy */
/* nl */ { IDMS_MEDIA_NL, "Media" },
/* pl */ { IDMS_MEDIA_PL, "Media" },
/* ru */ { IDMS_MEDIA_RU, "" },  /* fuzzy */
/* sv */ { IDMS_MEDIA_SV, "Media" },
/* tr */ { IDMS_MEDIA_TR, "Ortam" },

/* en */ { IDMS_OVERRIDE_PSID_SETTINGS,    "Override PSID settings" },
/* da */ { IDMS_OVERRIDE_PSID_SETTINGS_DA, "Overstyr PSID-indstillinger" },
/* de */ { IDMS_OVERRIDE_PSID_SETTINGS_DE, "PSID Einstellungen ignorieren" },
/* es */ { IDMS_OVERRIDE_PSID_SETTINGS_ES, "No utilizar ajustes PSID" },
/* fr */ { IDMS_OVERRIDE_PSID_SETTINGS_FR, "craser les paramtres PSID" },
/* hu */ { IDMS_OVERRIDE_PSID_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_OVERRIDE_PSID_SETTINGS_IT, "Sovrascrivi impostazioni PSID" },
/* ko */ { IDMS_OVERRIDE_PSID_SETTINGS_KO, "PSID  ̵ ϱ" },
/* nl */ { IDMS_OVERRIDE_PSID_SETTINGS_NL, "Overschrijf PSID instellingen" },
/* pl */ { IDMS_OVERRIDE_PSID_SETTINGS_PL, "Nadpisz ustawienia PSID" },
/* ru */ { IDMS_OVERRIDE_PSID_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDMS_OVERRIDE_PSID_SETTINGS_SV, "verskugga PSID-instllningar" },
/* tr */ { IDMS_OVERRIDE_PSID_SETTINGS_TR, "PSID ayarlarn geersiz kl" },

/* en */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD,    "Value %d out of range, range is from %d to %d, using %d instead" },
/* da */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_DA, "Vrdi %d ugyldig. Tilladt vrdi fra %d til %d. Bruger %d istedet" },
/* de */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_DE, "Wert %d ist unzulssig, Bereich muss zwischen %d und %d liegen, benutze %d" },
/* es */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_ES, "Valor %d fuera de rango, rango de %d a %d, usando %d en su lugar" },
/* fr */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_FR, "Valeur %d en dehors de la plage %d to %d, utilisation de %d  la place" },
/* hu */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_HU, "" },  /* fuzzy */
/* it */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_IT, "Valore %d fuori dai limiti, l' intervallo  da %d a %d, uso %d al suo posto" },
/* ko */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_KO, "" },  /* fuzzy */
/* nl */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_NL, "Waarde %d is buiten het bereik, het bereik is van %d tot %d, %d zal gebruikt worden" },
/* pl */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_PL, "Warto %d jest poza zakresem, zakres to %d do %d, uywam %d" },
/* ru */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_RU, "Value %d out of range, range is from %d to %d, using %d instead" },
/* sv */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_SV, "Vrdet %d r utanfr grnserna, giltiga vrden mellan %d och %d, anvnder %d istllet" },
/* tr */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_TR, "%d deeri alan dna kt, alan %d - %d aralnda, yerine %d kullanlyor" },

/* en */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD,    "Value %.3f out of range, range is from %.3f to %.3f, using %.3f instead" },
/* da */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_DA, "Vrdi %.3f ugyldig. Tilladt vrdi fra %.3f til %.3f. Bruger %.3f istedet" },
/* de */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_DE, "Wert %.3f ist unzulssig, Bereich muss zwischen %.3f und %.3f liegen, benutze %.3f" },
/* es */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_ES, "Valor %.3f fuera de rango, rango de %.3f a %.3f, usando %.3f en su lugar" },
/* fr */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_FR, "Valeur %.3f en dehors de la plage %.3f to %.3f, utilisation de %.3f  la place" },
/* hu */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_HU, "" },  /* fuzzy */
/* it */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_IT, "Valore %.3f fuori dai limiti, l' intervallo  da %.3f a %.3f, uso %.3f al suo posto" },
/* ko */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_KO, "" },  /* fuzzy */
/* nl */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_NL, "Waarde %.3f is buiten het bereik, het bereik is van %.3f tot %.3f, %.3f zal gebruikt worden" },
/* pl */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_PL, "Warto %.3f jest poza zakresem, zakres to %.3f do %.3f, uywam %.3f" },
/* ru */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_RU, "Value %.3f out of range, range is from %.3f to %.3f, using %.3f instead" },
/* sv */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_SV, "Vrdet %.3f r utanfr grnserna, giltiga vrden mellan %.3f och %.3f, anvnder %.3f istllet" },
/* tr */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_TR, "%.3f deeri alan dna kt, alan %.3f - %.3f aralnda, yerine %.3f kullanlyor" },

/* en */ { IDMES_SETTINGS_SAVED_SUCCESS,    "Settings saved successfully." },
/* da */ { IDMES_SETTINGS_SAVED_SUCCESS_DA, "Indstillingerne er gemt." },
/* de */ { IDMES_SETTINGS_SAVED_SUCCESS_DE, "Einstellungen erfolgreich gespeichert" },
/* es */ { IDMES_SETTINGS_SAVED_SUCCESS_ES, "Ajustes grabados correctamente" },
/* fr */ { IDMES_SETTINGS_SAVED_SUCCESS_FR, "Sauvegarde des paramtres effectue correctement." },
/* hu */ { IDMES_SETTINGS_SAVED_SUCCESS_HU, "Belltsok sikeresen elmentve." },
/* it */ { IDMES_SETTINGS_SAVED_SUCCESS_IT, "Impostazioni salvate con successo." },
/* ko */ { IDMES_SETTINGS_SAVED_SUCCESS_KO, "" },  /* fuzzy */
/* nl */ { IDMES_SETTINGS_SAVED_SUCCESS_NL, "Instellingen met succes opgeslagen." },
/* pl */ { IDMES_SETTINGS_SAVED_SUCCESS_PL, "Zapisywanie ustawie powiodo si." },
/* ru */ { IDMES_SETTINGS_SAVED_SUCCESS_RU, "  " },
/* sv */ { IDMES_SETTINGS_SAVED_SUCCESS_SV, "Instllningarna har sparats." },
/* tr */ { IDMES_SETTINGS_SAVED_SUCCESS_TR, "Ayarlar baaryla kaydedildi." },

/* en */ { IDMES_SETTINGS_LOAD_SUCCESS,    "Settings loaded successfully." },
/* da */ { IDMES_SETTINGS_LOAD_SUCCESS_DA, "Indstillinger indlst med success." },
/* de */ { IDMES_SETTINGS_LOAD_SUCCESS_DE, "Einstellungen erfolgreich geladen." },
/* es */ { IDMES_SETTINGS_LOAD_SUCCESS_ES, "Ajustes cargados con xito." },
/* fr */ { IDMES_SETTINGS_LOAD_SUCCESS_FR, "Chargement des paramtres russi." },
/* hu */ { IDMES_SETTINGS_LOAD_SUCCESS_HU, "Belltsok sikeresen elmentve." },
/* it */ { IDMES_SETTINGS_LOAD_SUCCESS_IT, "Impostazioni caricate con successo." },
/* ko */ { IDMES_SETTINGS_LOAD_SUCCESS_KO, "  ҷ ϴ" },
/* nl */ { IDMES_SETTINGS_LOAD_SUCCESS_NL, "Instellingen met succes geladen." },
/* pl */ { IDMES_SETTINGS_LOAD_SUCCESS_PL, "Wczytywanie ustawie powiodo si." },
/* ru */ { IDMES_SETTINGS_LOAD_SUCCESS_RU, "  ." },
/* sv */ { IDMES_SETTINGS_LOAD_SUCCESS_SV, "Instllningarna har lsts in." },
/* tr */ { IDMES_SETTINGS_LOAD_SUCCESS_TR, "Ayarlar baaryla yklendi." },

/* en */ { IDMES_DFLT_SETTINGS_RESTORED,    "Default settings restored." },
/* da */ { IDMES_DFLT_SETTINGS_RESTORED_DA, "Standardindstillinger gendannet." },
/* de */ { IDMES_DFLT_SETTINGS_RESTORED_DE, "Standard wiederhergestellt" },
/* es */ { IDMES_DFLT_SETTINGS_RESTORED_ES, "Ajustes por defecto restaurados." },
/* fr */ { IDMES_DFLT_SETTINGS_RESTORED_FR, "Paramtres par dfaut restaurs." },
/* hu */ { IDMES_DFLT_SETTINGS_RESTORED_HU, "Alaprtelmezett belltsok visszalltva." },
/* it */ { IDMES_DFLT_SETTINGS_RESTORED_IT, "Impostazioni originarie ripristinate." },
/* ko */ { IDMES_DFLT_SETTINGS_RESTORED_KO, "" },  /* fuzzy */
/* nl */ { IDMES_DFLT_SETTINGS_RESTORED_NL, "Standaard instellingen hersteld." },
/* pl */ { IDMES_DFLT_SETTINGS_RESTORED_PL, "Przywrono domylne ustawienia." },
/* ru */ { IDMES_DFLT_SETTINGS_RESTORED_RU, "   " },
/* sv */ { IDMES_DFLT_SETTINGS_RESTORED_SV, "Frvalda instllningar terstllda." },
/* tr */ { IDMES_DFLT_SETTINGS_RESTORED_TR, "Varsaylan ayarlara geri dnld." },

/* en */ { IDMES_VICE_MESSAGE,    "VICE Message" },
/* da */ { IDMES_VICE_MESSAGE_DA, "VICE-besked" },
/* de */ { IDMES_VICE_MESSAGE_DE, "VICE Nachricht" },
/* es */ { IDMES_VICE_MESSAGE_ES, "Mensaje VICE" },
/* fr */ { IDMES_VICE_MESSAGE_FR, "Message VICE" },
/* hu */ { IDMES_VICE_MESSAGE_HU, "VICE zenet" },
/* it */ { IDMES_VICE_MESSAGE_IT, "Messaggio di VICE" },
/* ko */ { IDMES_VICE_MESSAGE_KO, "VICE ޼" },
/* nl */ { IDMES_VICE_MESSAGE_NL, "VICE bericht" },
/* pl */ { IDMES_VICE_MESSAGE_PL, "Komunikat VICE" },
/* ru */ { IDMES_VICE_MESSAGE_RU, " VICE" },
/* sv */ { IDMES_VICE_MESSAGE_SV, "VICE-meddelande" },
/* tr */ { IDMES_VICE_MESSAGE_TR, "VICE Mesaj" },

/* en */ { IDMES_OK,    "OK" },
/* da */ { IDMES_OK_DA, "OK" },
/* de */ { IDMES_OK_DE, "OK" },
/* es */ { IDMES_OK_ES, "OK" },
/* fr */ { IDMES_OK_FR, "OK" },
/* hu */ { IDMES_OK_HU, "OK" },
/* it */ { IDMES_OK_IT, "OK" },
/* ko */ { IDMES_OK_KO, "ok" },
/* nl */ { IDMES_OK_NL, "OK" },
/* pl */ { IDMES_OK_PL, "OK" },
/* ru */ { IDMES_OK_RU, "OK" },
/* sv */ { IDMES_OK_SV, "OK" },
/* tr */ { IDMES_OK_TR, "Tamam" },

/* en */ { IDMES_VICE_CONTRIBUTORS,    "VICE contributors" },
/* da */ { IDMES_VICE_CONTRIBUTORS_DA, "VICE bidragsydere" },
/* de */ { IDMES_VICE_CONTRIBUTORS_DE, "VICE Hackers" },
/* es */ { IDMES_VICE_CONTRIBUTORS_ES, "Colaboradores VICE" },
/* fr */ { IDMES_VICE_CONTRIBUTORS_FR, "Contributeurs  VICE" },
/* hu */ { IDMES_VICE_CONTRIBUTORS_HU, "VICE - kzremkdk" },
/* it */ { IDMES_VICE_CONTRIBUTORS_IT, "Collaboratori" },
/* ko */ { IDMES_VICE_CONTRIBUTORS_KO, "VICE " },
/* nl */ { IDMES_VICE_CONTRIBUTORS_NL, "VICE medewerkers" },
/* pl */ { IDMES_VICE_CONTRIBUTORS_PL, "Wsppracownicy VICE" },
/* ru */ { IDMES_VICE_CONTRIBUTORS_RU, "VICE contributors" },
/* sv */ { IDMES_VICE_CONTRIBUTORS_SV, "Bidragslmnare till VICE" },
/* tr */ { IDMES_VICE_CONTRIBUTORS_TR, "VICE katlmclar" },

/* en */ { IDMES_WHO_MADE_WHAT,    "Who made what?" },
/* da */ { IDMES_WHO_MADE_WHAT_DA, "Hvem har lavet hvad?" },
/* de */ { IDMES_WHO_MADE_WHAT_DE, "Wer hat was gemacht?" },
/* es */ { IDMES_WHO_MADE_WHAT_ES, "Quien hizo qu?" },
/* fr */ { IDMES_WHO_MADE_WHAT_FR, "Qui fait quoi?" },
/* hu */ { IDMES_WHO_MADE_WHAT_HU, "Ki mit csinlt?" },
/* it */ { IDMES_WHO_MADE_WHAT_IT, "Chi ha fatto cosa?" },
/* ko */ { IDMES_WHO_MADE_WHAT_KO, "  ?" },
/* nl */ { IDMES_WHO_MADE_WHAT_NL, "Wie heeft wat gemaakt?" },
/* pl */ { IDMES_WHO_MADE_WHAT_PL, "Kto co zrobi?" },
/* ru */ { IDMES_WHO_MADE_WHAT_RU, "Who made what?" },
/* sv */ { IDMES_WHO_MADE_WHAT_SV, "Vem gjorde vad?" },
/* tr */ { IDMES_WHO_MADE_WHAT_TR, "Kim ne yapt?" },

/* en */ { IDMES_VICE_DIST_NO_WARRANTY,    "VICE is distributed WITHOUT ANY WARRANTY!" },
/* da */ { IDMES_VICE_DIST_NO_WARRANTY_DA, "VICE distribueres UDEN NOGEN SOM HELST GARANTI!" },
/* de */ { IDMES_VICE_DIST_NO_WARRANTY_DE, "VICE ist ohne Garantie" },
/* es */ { IDMES_VICE_DIST_NO_WARRANTY_ES, "VICE se distribuye SIN NINGUNA GARANTA!" },
/* fr */ { IDMES_VICE_DIST_NO_WARRANTY_FR, "VICE est distribu SANS AUCUN GARANTIE!" },
/* hu */ { IDMES_VICE_DIST_NO_WARRANTY_HU, "A VICE-t garancia nlkl terjesztjk!" },
/* it */ { IDMES_VICE_DIST_NO_WARRANTY_IT, "VICE  distribuito SENZA NESSUNA GARANZIA!" },
/* ko */ { IDMES_VICE_DIST_NO_WARRANTY_KO, "VICE   Ƽ  ǰ ֽϴ!" },
/* nl */ { IDMES_VICE_DIST_NO_WARRANTY_NL, "VICE heeft ABSOLUUT GEEN GARANTIE!" },
/* pl */ { IDMES_VICE_DIST_NO_WARRANTY_PL, "VICE jest rozpowszechniany BEZ ADNEJ GWARANCJI!" },
/* ru */ { IDMES_VICE_DIST_NO_WARRANTY_RU, "VICE   ¸!" },
/* sv */ { IDMES_VICE_DIST_NO_WARRANTY_SV, "VICE distribueras UTAN NGON SOM HELST GARANTI!" },
/* tr */ { IDMES_VICE_DIST_NO_WARRANTY_TR, "VICE HBR GARANT VERLMEDEN datlmtr!" },

/* en */ { IDMES_WHICH_COMMANDS_AVAILABLE,    "Which command line options are available?" },
/* da */ { IDMES_WHICH_COMMANDS_AVAILABLE_DA, "Hvilke kommandolinjeparametre er tilgngelige?" },
/* de */ { IDMES_WHICH_COMMANDS_AVAILABLE_DE, "Welche Kommandozeilen Parameter sind verfgbar?" },
/* es */ { IDMES_WHICH_COMMANDS_AVAILABLE_ES, "Qu opciones L.comandos estn disponibles?" },
/* fr */ { IDMES_WHICH_COMMANDS_AVAILABLE_FR, "Quelles sont les lignes de commandes disponibles?" },
/* hu */ { IDMES_WHICH_COMMANDS_AVAILABLE_HU, "Milyen parancssori opcik lehetsgesek?" },
/* it */ { IDMES_WHICH_COMMANDS_AVAILABLE_IT, "Quali parametri della riga di comando sono disponibili?" },
/* ko */ { IDMES_WHICH_COMMANDS_AVAILABLE_KO, " Ŀǵ  ɼ մϱ?" },
/* nl */ { IDMES_WHICH_COMMANDS_AVAILABLE_NL, "Welke commando opties zijn beschikbaar?" },
/* pl */ { IDMES_WHICH_COMMANDS_AVAILABLE_PL, "Ktre opcje wiersza polece s dostpne?" },
/* ru */ { IDMES_WHICH_COMMANDS_AVAILABLE_RU, "      ?" },
/* sv */ { IDMES_WHICH_COMMANDS_AVAILABLE_SV, "Vilka kommandoradsflaggor r tillgngliga?" },
/* tr */ { IDMES_WHICH_COMMANDS_AVAILABLE_TR, "Hangi komut satr seenekleri mevcut?" },

/* en */ { IDMES_WHICH_COMPILE_FEATURES_AVAILABLE,    "Which compile time features are available?" },
/* da */ { IDMES_WHICH_COMPILE_FEATURES_AVAILABLE_DA, "" },  /* fuzzy */
/* de */ { IDMES_WHICH_COMPILE_FEATURES_AVAILABLE_DE, "Welche kompilierten Funktionen sind verfgbar?" },
/* es */ { IDMES_WHICH_COMPILE_FEATURES_AVAILABLE_ES, "Qu opciones en tiempo de compilacin estn disponibles?" },
/* fr */ { IDMES_WHICH_COMPILE_FEATURES_AVAILABLE_FR, "" },  /* fuzzy */
/* hu */ { IDMES_WHICH_COMPILE_FEATURES_AVAILABLE_HU, "" },  /* fuzzy */
/* it */ { IDMES_WHICH_COMPILE_FEATURES_AVAILABLE_IT, "" },  /* fuzzy */
/* ko */ { IDMES_WHICH_COMPILE_FEATURES_AVAILABLE_KO, "" },  /* fuzzy */
/* nl */ { IDMES_WHICH_COMPILE_FEATURES_AVAILABLE_NL, "Welke speciale compileer opties zijn beschikbaar?" },
/* pl */ { IDMES_WHICH_COMPILE_FEATURES_AVAILABLE_PL, "Ktre opcje kompilacji s dostpne?" },
/* ru */ { IDMES_WHICH_COMPILE_FEATURES_AVAILABLE_RU, "" },  /* fuzzy */
/* sv */ { IDMES_WHICH_COMPILE_FEATURES_AVAILABLE_SV, "" },  /* fuzzy */
/* tr */ { IDMES_WHICH_COMPILE_FEATURES_AVAILABLE_TR, "" },  /* fuzzy */

/* en */ { IDMES_CANNOT_SAVE_SETTINGS,    "Cannot save settings." },
/* da */ { IDMES_CANNOT_SAVE_SETTINGS_DA, "Kunne ikke gemme indstillinger." },
/* de */ { IDMES_CANNOT_SAVE_SETTINGS_DE, "Fehler beim Speichern der Einstellungen." },
/* es */ { IDMES_CANNOT_SAVE_SETTINGS_ES, "No puedo grabar ajustes" },
/* fr */ { IDMES_CANNOT_SAVE_SETTINGS_FR, "Impossible d'enregistrer les paramtres." },
/* hu */ { IDMES_CANNOT_SAVE_SETTINGS_HU, "A belltsok mentse nem sikerlt." },
/* it */ { IDMES_CANNOT_SAVE_SETTINGS_IT, "Non  possibile salvare le impostazioni." },
/* ko */ { IDMES_CANNOT_SAVE_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMES_CANNOT_SAVE_SETTINGS_NL, "Kan de instellingen niet opslaan." },
/* pl */ { IDMES_CANNOT_SAVE_SETTINGS_PL, "Nie mona zapisa ustawie." },
/* ru */ { IDMES_CANNOT_SAVE_SETTINGS_RU, "   " },
/* sv */ { IDMES_CANNOT_SAVE_SETTINGS_SV, "Kan inte spara instllningar." },
/* tr */ { IDMES_CANNOT_SAVE_SETTINGS_TR, "Ayarlar kaydedilemedi." },

/* en */ { IDMES_CANNOT_LOAD_SETTINGS,    "Cannot load settings." },
/* da */ { IDMES_CANNOT_LOAD_SETTINGS_DA, "Kunne ikke indlse indstillinger." },
/* de */ { IDMES_CANNOT_LOAD_SETTINGS_DE, "Fehler beim Laden der Einstellungen." },
/* es */ { IDMES_CANNOT_LOAD_SETTINGS_ES, "No puedo cargar ajustes." },
/* fr */ { IDMES_CANNOT_LOAD_SETTINGS_FR, "Impossible de charger les paramtres." },
/* hu */ { IDMES_CANNOT_LOAD_SETTINGS_HU, "A belltsok betltse nem sikerlt." },
/* it */ { IDMES_CANNOT_LOAD_SETTINGS_IT, "Non  possibile caricare le impostazioni." },
/* ko */ { IDMES_CANNOT_LOAD_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDMES_CANNOT_LOAD_SETTINGS_NL, "Kan de instellingen niet laden." },
/* pl */ { IDMES_CANNOT_LOAD_SETTINGS_PL, "Nie mona wczyta ustawie." },
/* ru */ { IDMES_CANNOT_LOAD_SETTINGS_RU, "   ." },
/* sv */ { IDMES_CANNOT_LOAD_SETTINGS_SV, "Kan inte lsa instllningar." },
/* tr */ { IDMES_CANNOT_LOAD_SETTINGS_TR, "Ayarlar yklenemedi." },

/* en */ { IDMES_VICE_ERROR,    "VICE Error!" },
/* da */ { IDMES_VICE_ERROR_DA, "VICE-fejl!" },
/* de */ { IDMES_VICE_ERROR_DE, "VICE Fehler!" },
/* es */ { IDMES_VICE_ERROR_ES, "Error VICE!" },
/* fr */ { IDMES_VICE_ERROR_FR, "Erreur VICE!" },
/* hu */ { IDMES_VICE_ERROR_HU, "VICE hiba!" },
/* it */ { IDMES_VICE_ERROR_IT, "Errore di VICE!" },
/* ko */ { IDMES_VICE_ERROR_KO, "VICE !" },
/* nl */ { IDMES_VICE_ERROR_NL, "VICE Fout!" },
/* pl */ { IDMES_VICE_ERROR_PL, "Bd VICE!" },
/* ru */ { IDMES_VICE_ERROR_RU, " VICE!" },
/* sv */ { IDMES_VICE_ERROR_SV, "VICE-fel!" },
/* tr */ { IDMES_VICE_ERROR_TR, "VICE Hatas!" },

/* en */ { IDMES_DEVICE_NOT_GAMEPAD,    "The device on this port is not a gamepad" },
/* da */ { IDMES_DEVICE_NOT_GAMEPAD_DA, "Enheden p denne port er ikke en joypad" },
/* de */ { IDMES_DEVICE_NOT_GAMEPAD_DE, "Das Gert in diesem Port ist kein Gamepad" },
/* es */ { IDMES_DEVICE_NOT_GAMEPAD_ES, "El perifrico en este puerto no es un gamepad" },
/* fr */ { IDMES_DEVICE_NOT_GAMEPAD_FR, "Le priphrique sur ce port nest pas une manette" },
/* hu */ { IDMES_DEVICE_NOT_GAMEPAD_HU, "Az eszkz ezen a porton nem gamepad" },
/* it */ { IDMES_DEVICE_NOT_GAMEPAD_IT, "Il dispositivo su questa porta non  un gamepad" },
/* ko */ { IDMES_DEVICE_NOT_GAMEPAD_KO, "" },  /* fuzzy */
/* nl */ { IDMES_DEVICE_NOT_GAMEPAD_NL, "Het apparaat op deze poort is geen gamepad" },
/* pl */ { IDMES_DEVICE_NOT_GAMEPAD_PL, "Urzdzenie w tym porcie nie jest padem" },
/* ru */ { IDMES_DEVICE_NOT_GAMEPAD_RU, "The device on this port is not a gamepad" },
/* sv */ { IDMES_DEVICE_NOT_GAMEPAD_SV, "Enheten p denna port r inte en styrplatta" },
/* tr */ { IDMES_DEVICE_NOT_GAMEPAD_TR, "Bu port zerindeki aygt gamepad deil" },

/* en */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT,    "The port is not mapped to an Amiga port" },
/* da */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_DA, "Denne port er ikke koblet til en Amigaport" },
/* de */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_DE, "Dieses Port ist keinem Amiga Port zugeordnet" },
/* es */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_ES, "El puerto no est mapeado como puerto Amiga" },
/* fr */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_FR, "Le port nest pas mapp sur un port Amiga" },
/* hu */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_HU, "A port nincs lekpezve egy Amiga portra" },
/* it */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_IT, "Questa porta non  mappata su una porta dell'Amiga" },
/* ko */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_KO, "" },  /* fuzzy */
/* nl */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_NL, "De poort is niet verbonden met een Amigapoort" },
/* pl */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_PL, "Port nie jest zmapowany do portu Amigi" },
/* ru */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_RU, "The port is not mapped to an Amiga port" },
/* sv */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_SV, "Porten r inte kopplad till en Amigaport" },
/* tr */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_TR, "Port bir Amiga portuyla eletirilemedi" },

/* en */ { IDMES_CANNOT_AUTOSTART_FILE,    "Cannot autostart specified file." },
/* da */ { IDMES_CANNOT_AUTOSTART_FILE_DA, "Kan ikke autostarte valgt fil" },
/* de */ { IDMES_CANNOT_AUTOSTART_FILE_DE, "Autostart von angeforderter Datei fehlgeschlagen." },
/* es */ { IDMES_CANNOT_AUTOSTART_FILE_ES, "No puedo autoarrancar el fichero especificado." },
/* fr */ { IDMES_CANNOT_AUTOSTART_FILE_FR, "Impossible d'autocharger le fichier spcifi" },
/* hu */ { IDMES_CANNOT_AUTOSTART_FILE_HU, "Nem lehet automatikusan elindtani a megadott fjlt." },
/* it */ { IDMES_CANNOT_AUTOSTART_FILE_IT, "Non  possibile avviare automaticamente il file specificato." },
/* ko */ { IDMES_CANNOT_AUTOSTART_FILE_KO, "" },  /* fuzzy */
/* nl */ { IDMES_CANNOT_AUTOSTART_FILE_NL, "Kan opgegeven bestand niet autostarten." },
/* pl */ { IDMES_CANNOT_AUTOSTART_FILE_PL, "Nie mona automatycznie wystartowa z danego pliku." },
/* ru */ { IDMES_CANNOT_AUTOSTART_FILE_RU, "Cannot autostart specified file." },
/* sv */ { IDMES_CANNOT_AUTOSTART_FILE_SV, "Kan inte autostarta angiven fil." },
/* tr */ { IDMES_CANNOT_AUTOSTART_FILE_TR, "Belirtilen dosya otomatik balatlamad." },

/* en */ { IDMES_CANNOT_ATTACH_FILE,    "Cannot attach specified file" },
/* da */ { IDMES_CANNOT_ATTACH_FILE_DA, "Kan ikke tilslutte den valgte fil" },
/* de */ { IDMES_CANNOT_ATTACH_FILE_DE, "Kann Image Datei nicht einlegen" },
/* es */ { IDMES_CANNOT_ATTACH_FILE_ES, "No puedo insertar el fichero especificado" },
/* fr */ { IDMES_CANNOT_ATTACH_FILE_FR, "Impossible d'attacher le fichier spcifi" },
/* hu */ { IDMES_CANNOT_ATTACH_FILE_HU, "Nem lehet csatolni a megadott fjlt" },
/* it */ { IDMES_CANNOT_ATTACH_FILE_IT, "Non  possibile selezionare il file specificato" },
/* ko */ { IDMES_CANNOT_ATTACH_FILE_KO, "" },  /* fuzzy */
/* nl */ { IDMES_CANNOT_ATTACH_FILE_NL, "Kan het opgegeven bestand niet koppelen" },
/* pl */ { IDMES_CANNOT_ATTACH_FILE_PL, "Nie mona zamontowa danego pliku" },
/* ru */ { IDMES_CANNOT_ATTACH_FILE_RU, "    " },
/* sv */ { IDMES_CANNOT_ATTACH_FILE_SV, "Kan inte ansluta filen" },
/* tr */ { IDMES_CANNOT_ATTACH_FILE_TR, "Belirtilen dosya yerletirilemedi" },

/* en */ { IDMES_INVALID_CART,    "Invalid cartridge image" },
/* da */ { IDMES_INVALID_CART_DA, "Ugyldigt cartridge-image" },
/* de */ { IDMES_INVALID_CART_DE, "Ungltiges Erweiterungsmodul Image" },
/* es */ { IDMES_INVALID_CART_ES, "Imagen de cartucho incorrecta" },
/* fr */ { IDMES_INVALID_CART_FR, "Image de cartouche invalide" },
/* hu */ { IDMES_INVALID_CART_HU, "rvnytelen cartridge kpms" },
/* it */ { IDMES_INVALID_CART_IT, "Immagine cartuccia non valida" },
/* ko */ { IDMES_INVALID_CART_KO, "īƮ ̹ Ұ" },
/* nl */ { IDMES_INVALID_CART_NL, "Ongeldig cartridge bestand" },
/* pl */ { IDMES_INVALID_CART_PL, "Nieprawidowy obraz kartrida" },
/* ru */ { IDMES_INVALID_CART_RU, "  " },
/* sv */ { IDMES_INVALID_CART_SV, "Ogiltig insticksmodulfil" },
/* tr */ { IDMES_INVALID_CART_TR, "Geersiz kartu imaj" },

/* en */ { IDMES_BAD_CART_CONFIG_IN_UI,    "Bad cartridge config in UI!" },
/* da */ { IDMES_BAD_CART_CONFIG_IN_UI_DA, "Ugyldig cartridgekonfiguration i brugergrnseflade!" },
/* de */ { IDMES_BAD_CART_CONFIG_IN_UI_DE, "Fehlerhafte Modul Konfiguration im UI!" },
/* es */ { IDMES_BAD_CART_CONFIG_IN_UI_ES, "Configuracin errnea del cartucho en UI!" },
/* fr */ { IDMES_BAD_CART_CONFIG_IN_UI_FR, "Mauvaise configuration de la cartouche dans l'interface utilisateur!" },
/* hu */ { IDMES_BAD_CART_CONFIG_IN_UI_HU, "Rossz cartridge konfigurci!" },
/* it */ { IDMES_BAD_CART_CONFIG_IN_UI_IT, "Configurazione della cartuccia errata nell'IU!" },
/* ko */ { IDMES_BAD_CART_CONFIG_IN_UI_KO, "UI  ߸ īƮ ֽϴ" },
/* nl */ { IDMES_BAD_CART_CONFIG_IN_UI_NL, "Slechte cartridge configuratie in UI!" },
/* pl */ { IDMES_BAD_CART_CONFIG_IN_UI_PL, "Za konfiguracja kartrida w UI!" },
/* ru */ { IDMES_BAD_CART_CONFIG_IN_UI_RU, "Bad cartridge config in UI!" },
/* sv */ { IDMES_BAD_CART_CONFIG_IN_UI_SV, "Felaktiga insticksmodulsinstllningar i UI!" },
/* tr */ { IDMES_BAD_CART_CONFIG_IN_UI_TR, "UI'de kt kartu konfigrasyonu!" },

/* en */ { IDMES_INVALID_CART_IMAGE,    "Invalid cartridge image" },
/* da */ { IDMES_INVALID_CART_IMAGE_DA, "Ugyldigt cartridge-image" },
/* de */ { IDMES_INVALID_CART_IMAGE_DE, "Ungltiges Erweiterungsmodul Image" },
/* es */ { IDMES_INVALID_CART_IMAGE_ES, "Imagen de cartucho incorrecta" },
/* fr */ { IDMES_INVALID_CART_IMAGE_FR, "Image de cartouche invalide" },
/* hu */ { IDMES_INVALID_CART_IMAGE_HU, "rvnytelen cartridge kpms" },
/* it */ { IDMES_INVALID_CART_IMAGE_IT, "Immagine cartuccia non valida" },
/* ko */ { IDMES_INVALID_CART_IMAGE_KO, "īƮ ̹ Ұ" },
/* nl */ { IDMES_INVALID_CART_IMAGE_NL, "Ongeldig cartridge bestand" },
/* pl */ { IDMES_INVALID_CART_IMAGE_PL, "Nieprawidowy obraz kartrida" },
/* ru */ { IDMES_INVALID_CART_IMAGE_RU, "  " },
/* sv */ { IDMES_INVALID_CART_IMAGE_SV, "Ogiltig insticksmodulfil" },
/* tr */ { IDMES_INVALID_CART_IMAGE_TR, "Geersiz kartu imaj" },

/* en */ { IDMES_CANNOT_CREATE_IMAGE,    "Cannot create image file!" },
/* da */ { IDMES_CANNOT_CREATE_IMAGE_DA, "Kunne ikke oprette image-fil!" },
/* de */ { IDMES_CANNOT_CREATE_IMAGE_DE, "Kann Imagedatei nicht erzeugen!" },
/* es */ { IDMES_CANNOT_CREATE_IMAGE_ES, "No puedo crear fichero imagen!" },
/* fr */ { IDMES_CANNOT_CREATE_IMAGE_FR, "Impossible de crer le fichier image!" },
/* hu */ { IDMES_CANNOT_CREATE_IMAGE_HU, "Nem sikerlt a kpms fjlt ltrehozni!" },
/* it */ { IDMES_CANNOT_CREATE_IMAGE_IT, "Non  possibile creare il file immagine!" },
/* ko */ { IDMES_CANNOT_CREATE_IMAGE_KO, "̹  Ҽ ϴ!" },
/* nl */ { IDMES_CANNOT_CREATE_IMAGE_NL, "Kan bestand niet maken!" },
/* pl */ { IDMES_CANNOT_CREATE_IMAGE_PL, "Nie mona utworzy pliku obrazu!" },
/* ru */ { IDMES_CANNOT_CREATE_IMAGE_RU, "    !" },
/* sv */ { IDMES_CANNOT_CREATE_IMAGE_SV, "Kan inte skapa avbildningsfil!" },
/* tr */ { IDMES_CANNOT_CREATE_IMAGE_TR, "Imaj dosyas yaratlamad!" },

/* en */ { IDMES_ERROR_STARTING_SERVER,    "An error occured starting the server." },
/* da */ { IDMES_ERROR_STARTING_SERVER_DA, "Fejl under start af serveren." },
/* de */ { IDMES_ERROR_STARTING_SERVER_DE, "Fehler beim Starten des Netplay Servers." },
/* es */ { IDMES_ERROR_STARTING_SERVER_ES, "Ha ocurrido error al iniciar el servidor" },
/* fr */ { IDMES_ERROR_STARTING_SERVER_FR, "Il y a eu une erreur au dmarrage du serveur." },
/* hu */ { IDMES_ERROR_STARTING_SERVER_HU, "Hiba trtnt a jtk kiszolgl indtsakor." },
/* it */ { IDMES_ERROR_STARTING_SERVER_IT, "Si  verificato un errore all'avvio del server." },
/* ko */ { IDMES_ERROR_STARTING_SERVER_KO, " ϴ  ߻߽ϴ" },
/* nl */ { IDMES_ERROR_STARTING_SERVER_NL, "Een fout is opgetreden bij het starten van de server." },
/* pl */ { IDMES_ERROR_STARTING_SERVER_PL, "Wystpi bd poczas uruchamiania serwera." },
/* ru */ { IDMES_ERROR_STARTING_SERVER_RU, "An error occured starting the server." },
/* sv */ { IDMES_ERROR_STARTING_SERVER_SV, "Fel vid start av servern." },
/* tr */ { IDMES_ERROR_STARTING_SERVER_TR, "Sunucu balatlrken bir hata olutu." },

/* en */ { IDMES_ERROR_CONNECTING_CLIENT,    "An error occured connecting the client." },
/* da */ { IDMES_ERROR_CONNECTING_CLIENT_DA, "Fejl under tilslutning af klienten." },
/* de */ { IDMES_ERROR_CONNECTING_CLIENT_DE, "Fehler beim Verbindungsaufbau zum Client" },
/* es */ { IDMES_ERROR_CONNECTING_CLIENT_ES, "Ha ocurrido error al conectar el cliente" },
/* fr */ { IDMES_ERROR_CONNECTING_CLIENT_FR, "Il y a eu une erreur de connexion avec le client." },
/* hu */ { IDMES_ERROR_CONNECTING_CLIENT_HU, "Hiba trtnt a kapcsoldskor." },
/* it */ { IDMES_ERROR_CONNECTING_CLIENT_IT, "Si  verificato un errore durante il collegamento col client." },
/* ko */ { IDMES_ERROR_CONNECTING_CLIENT_KO, "ũ̾Ʈ   ߻߽ϴ" },
/* nl */ { IDMES_ERROR_CONNECTING_CLIENT_NL, "Een fout is opgetreden bij het verbinden." },
/* pl */ { IDMES_ERROR_CONNECTING_CLIENT_PL, "Wydarzy si bd podczas czenia z klientem." },
/* ru */ { IDMES_ERROR_CONNECTING_CLIENT_RU, "An error occured connecting the client." },
/* sv */ { IDMES_ERROR_CONNECTING_CLIENT_SV, "Fel vid anslutning til klienten." },
/* tr */ { IDMES_ERROR_CONNECTING_CLIENT_TR, "stemciye balanrken bir hata olutu." },

/* en */ { IDMES_INVALID_PORT_NUMBER,    "Invalid port number" },
/* da */ { IDMES_INVALID_PORT_NUMBER_DA, "Ugyldigt portnummer" },
/* de */ { IDMES_INVALID_PORT_NUMBER_DE, "Ungltige Port Nummer" },
/* es */ { IDMES_INVALID_PORT_NUMBER_ES, "Nmero de puerto incorrecto" },
/* fr */ { IDMES_INVALID_PORT_NUMBER_FR, "Numro de port invalide" },
/* hu */ { IDMES_INVALID_PORT_NUMBER_HU, "rvnytelen port szm" },
/* it */ { IDMES_INVALID_PORT_NUMBER_IT, "Numero di porta non valido" },
/* ko */ { IDMES_INVALID_PORT_NUMBER_KO, "Ұ Ʈ ѹ" },
/* nl */ { IDMES_INVALID_PORT_NUMBER_NL, "Ongeldig poort nummer" },
/* pl */ { IDMES_INVALID_PORT_NUMBER_PL, "Bdny numer portu" },
/* ru */ { IDMES_INVALID_PORT_NUMBER_RU, " " },
/* sv */ { IDMES_INVALID_PORT_NUMBER_SV, "Ogiltigt portnummer" },
/* tr */ { IDMES_INVALID_PORT_NUMBER_TR, "Geersiz port numaras" },

/* en */ { IDMES_THIS_MACHINE_NO_SID,    "This machine may not have a SID" },
/* da */ { IDMES_THIS_MACHINE_NO_SID_DA, "Denne maskine kan ikke have en SID" },
/* de */ { IDMES_THIS_MACHINE_NO_SID_DE, "Diese Maschine hat mglicherweise keinen SID" },
/* es */ { IDMES_THIS_MACHINE_NO_SID_ES, "Esta mquina dispone de SID" },
/* fr */ { IDMES_THIS_MACHINE_NO_SID_FR, "Cette machine n'a peut-tre pas de SID" },
/* hu */ { IDMES_THIS_MACHINE_NO_SID_HU, "Ennek a gpnek nem lehet SIDje" },
/* it */ { IDMES_THIS_MACHINE_NO_SID_IT, "Questo computer potrebbe non avere un SID" },
/* ko */ { IDMES_THIS_MACHINE_NO_SID_KO, "" },  /* fuzzy */
/* nl */ { IDMES_THIS_MACHINE_NO_SID_NL, "Deze machine heeft mogelijk geen SID" },
/* pl */ { IDMES_THIS_MACHINE_NO_SID_PL, "W tej maszynie moe nie by SID" },
/* ru */ { IDMES_THIS_MACHINE_NO_SID_RU, "This machine may not have a SID" },
/* sv */ { IDMES_THIS_MACHINE_NO_SID_SV, "Denna maskin kan inte ha en SID" },
/* tr */ { IDMES_THIS_MACHINE_NO_SID_TR, "Bu makinede SID olmayabilir" },

/* en */ { IDMES_SCREENSHOT_SAVE_S_FAILED,    "Screenshot save of %s failed" },
/* da */ { IDMES_SCREENSHOT_SAVE_S_FAILED_DA, "Kunne ikke gemme screenshot %s" },
/* de */ { IDMES_SCREENSHOT_SAVE_S_FAILED_DE, "Screenshot speicherung von %s ist fehlgeschlagen" },
/* es */ { IDMES_SCREENSHOT_SAVE_S_FAILED_ES, "Error en la grabacin Captura de pantalla %s" },
/* fr */ { IDMES_SCREENSHOT_SAVE_S_FAILED_FR, "L'enregistrement de la capture d'cran %s  chou" },
/* hu */ { IDMES_SCREENSHOT_SAVE_S_FAILED_HU, "Fnykp fjl mentse %s fjlba nem sikerlt" },
/* it */ { IDMES_SCREENSHOT_SAVE_S_FAILED_IT, "Il salvataggio della schermata %s  fallito" },
/* ko */ { IDMES_SCREENSHOT_SAVE_S_FAILED_KO, "" },  /* fuzzy */
/* nl */ { IDMES_SCREENSHOT_SAVE_S_FAILED_NL, "Opslaan schermafdrukbestand %s is mislukt" },
/* pl */ { IDMES_SCREENSHOT_SAVE_S_FAILED_PL, "Zapis zrzutu ekranu %s nie powid si" },
/* ru */ { IDMES_SCREENSHOT_SAVE_S_FAILED_RU, "Screenshot save of %s failed" },
/* sv */ { IDMES_SCREENSHOT_SAVE_S_FAILED_SV, "Kunde inte spara skrmdump %s" },
/* tr */ { IDMES_SCREENSHOT_SAVE_S_FAILED_TR, "%s ekran grnts kaydedilemedi" },

/* en */ { IDMES_SCREENSHOT_S_SAVED,    "Screenshot %s saved." },
/* da */ { IDMES_SCREENSHOT_S_SAVED_DA, "Screenshot %s gemt." },
/* de */ { IDMES_SCREENSHOT_S_SAVED_DE, "Screenshots %s gespeicher." },
/* es */ { IDMES_SCREENSHOT_S_SAVED_ES, "Captura de pantalla %s grabada." },
/* fr */ { IDMES_SCREENSHOT_S_SAVED_FR, "Capture d'cran %s enregistre." },
/* hu */ { IDMES_SCREENSHOT_S_SAVED_HU, "Fnykp %s fjlba elmentve." },
/* it */ { IDMES_SCREENSHOT_S_SAVED_IT, "Schermata %s salvata." },
/* ko */ { IDMES_SCREENSHOT_S_SAVED_KO, "" },  /* fuzzy */
/* nl */ { IDMES_SCREENSHOT_S_SAVED_NL, "Scherm afdruk %s opgeslagen." },
/* pl */ { IDMES_SCREENSHOT_S_SAVED_PL, "Zapisano zrzut ekranu %s." },
/* ru */ { IDMES_SCREENSHOT_S_SAVED_RU, "Screenshot %s saved." },
/* sv */ { IDMES_SCREENSHOT_S_SAVED_SV, "Skrmdump %s sparad." },
/* tr */ { IDMES_SCREENSHOT_S_SAVED_TR, "%s ekran grnts kaydedildi." },

/* en */ { IDS_PRESS_KEY_BUTTON,    "Press desired key/button, move stick or press ESC for no key." },
/* da */ { IDS_PRESS_KEY_BUTTON_DA, "Tryk nsket tast, bevg joystick eller tryk ESC for ingen binding." },
/* de */ { IDS_PRESS_KEY_BUTTON_DE, "Gewnschte Taste/Knopf drcken, Knppel bewegen oder ESC fr keine Taste drcken." },
/* es */ { IDS_PRESS_KEY_BUTTON_ES, "Pulsa la tecla deseada/botn, mueve stick o pulsa ESC para ninguna tecla." },
/* fr */ { IDS_PRESS_KEY_BUTTON_FR, "Appuyez sur la touche/bouton desire(e), dplacez le stick ou appuyez sur ESC pour effacer cette touche." },
/* hu */ { IDS_PRESS_KEY_BUTTON_HU, "Nyomja meg a vlasztott gombot, mozdtsa a botkormnyt, vagy nyomjon ESC-et reshez" },
/* it */ { IDS_PRESS_KEY_BUTTON_IT, "Premi il tasto/bottone desiderato, muovi la leva o premi ESC per non selezionare alcun tasto." },
/* ko */ { IDS_PRESS_KEY_BUTTON_KO, "" },  /* fuzzy */
/* nl */ { IDS_PRESS_KEY_BUTTON_NL, "Druk de toets/knop, beweeg de joystick of druk op ESC voor geen toets." },
/* pl */ { IDS_PRESS_KEY_BUTTON_PL, "Wcinij podany klawisz, rusz drkiem, albo wcinij ESC by nie ustawia klawisza." },
/* ru */ { IDS_PRESS_KEY_BUTTON_RU, "Press desired key/button, move stick or press ESC for no key." },
/* sv */ { IDS_PRESS_KEY_BUTTON_SV, "Tryck nskad tangent/knapp, flytta styrspaken eller tryck ESC fr att inte koppla ngon tangent." },
/* tr */ { IDS_PRESS_KEY_BUTTON_TR, "stenilen tu/dmeye basn, ubuu hareket ettirin veya tu sememek iin ESC'e basn." },

/* en */ { IDS_SAVE,    "Save" },
/* da */ { IDS_SAVE_DA, "Gem" },
/* de */ { IDS_SAVE_DE, "Speichern" },
/* es */ { IDS_SAVE_ES, "Grabacin" },
/* fr */ { IDS_SAVE_FR, "Enregistrer" },
/* hu */ { IDS_SAVE_HU, "Ments" },
/* it */ { IDS_SAVE_IT, "Salva" },
/* ko */ { IDS_SAVE_KO, "" },
/* nl */ { IDS_SAVE_NL, "Opslaan" },
/* pl */ { IDS_SAVE_PL, "Zapisz" },
/* ru */ { IDS_SAVE_RU, "" },
/* sv */ { IDS_SAVE_SV, "Spara" },
/* tr */ { IDS_SAVE_TR, "Kaydet" },

/* en */ { IDS_BROWSE,    "Browse" },
/* da */ { IDS_BROWSE_DA, "Gennemse" },
/* de */ { IDS_BROWSE_DE, "Stbern" },
/* es */ { IDS_BROWSE_ES, "Explora" },
/* fr */ { IDS_BROWSE_FR, "Parcourir" },
/* hu */ { IDS_BROWSE_HU, "Tallz" },
/* it */ { IDS_BROWSE_IT, "Sfoglia" },
/* ko */ { IDS_BROWSE_KO, "콺" },
/* nl */ { IDS_BROWSE_NL, "Bladeren" },
/* pl */ { IDS_BROWSE_PL, "Przegldaj" },
/* ru */ { IDS_BROWSE_RU, "" },
/* sv */ { IDS_BROWSE_SV, "Blddra" },
/* tr */ { IDS_BROWSE_TR, "Gz at" },

/* en */ { IDS_CURRENT_MODE,    "Current mode" },
/* da */ { IDS_CURRENT_MODE_DA, "Nuvrende tilstand" },
/* de */ { IDS_CURRENT_MODE_DE, "Aktueller Modus" },
/* es */ { IDS_CURRENT_MODE_ES, "Modo actual" },
/* fr */ { IDS_CURRENT_MODE_FR, "Mode actuel" },
/* hu */ { IDS_CURRENT_MODE_HU, "Jelenlegi md" },
/* it */ { IDS_CURRENT_MODE_IT, "Modalit attuale" },
/* ko */ { IDS_CURRENT_MODE_KO, " " },
/* nl */ { IDS_CURRENT_MODE_NL, "Huidige modus" },
/* pl */ { IDS_CURRENT_MODE_PL, "Obecny tryb" },
/* ru */ { IDS_CURRENT_MODE_RU, " " },
/* sv */ { IDS_CURRENT_MODE_SV, "Nuvarande lge" },
/* tr */ { IDS_CURRENT_MODE_TR, "Geerli mod" },

/* en */ { IDS_TCP_PORT,    "TCP port" },
/* da */ { IDS_TCP_PORT_DA, "TCP-port" },
/* de */ { IDS_TCP_PORT_DE, "TCP Port: " },
/* es */ { IDS_TCP_PORT_ES, "Puerto TCP" },
/* fr */ { IDS_TCP_PORT_FR, "Port TCP" },
/* hu */ { IDS_TCP_PORT_HU, "TCP port" },
/* it */ { IDS_TCP_PORT_IT, "Porta TCP" },
/* ko */ { IDS_TCP_PORT_KO, "TCP Ʈ" },
/* nl */ { IDS_TCP_PORT_NL, "TCP poort" },
/* pl */ { IDS_TCP_PORT_PL, "Port TCP" },
/* ru */ { IDS_TCP_PORT_RU, "TCP " },
/* sv */ { IDS_TCP_PORT_SV, "TCP-port" },
/* tr */ { IDS_TCP_PORT_TR, "TCP portu" },

/* en */ { IDS_START_SERVER,    "Start server" },
/* da */ { IDS_START_SERVER_DA, "Start server" },
/* de */ { IDS_START_SERVER_DE, "Server starten" },
/* es */ { IDS_START_SERVER_ES, "Iniciar servidor" },
/* fr */ { IDS_START_SERVER_FR, "Dmarrer le serveur" },
/* hu */ { IDS_START_SERVER_HU, "Kiszolgl elindtsa" },
/* it */ { IDS_START_SERVER_IT, "Avvia server" },
/* ko */ { IDS_START_SERVER_KO, " " },
/* nl */ { IDS_START_SERVER_NL, "Start server" },
/* pl */ { IDS_START_SERVER_PL, "Uruchom serwer" },
/* ru */ { IDS_START_SERVER_RU, "Start server" },
/* sv */ { IDS_START_SERVER_SV, "Starta server" },
/* tr */ { IDS_START_SERVER_TR, "Sunucuyu balat" },

/* en */ { IDS_SERVER_BIND,    "Server Bind" },
/* da */ { IDS_SERVER_BIND_DA, "Serverbinding" },
/* de */ { IDS_SERVER_BIND_DE, "Server Bind" },
/* es */ { IDS_SERVER_BIND_ES, "Server Bind" },
/* fr */ { IDS_SERVER_BIND_FR, "Lien Serveur" },
/* hu */ { IDS_SERVER_BIND_HU, "Szerver cm+port" },
/* it */ { IDS_SERVER_BIND_IT, "Server Bind" },
/* ko */ { IDS_SERVER_BIND_KO, " ε" },
/* nl */ { IDS_SERVER_BIND_NL, "Server binding" },
/* pl */ { IDS_SERVER_BIND_PL, "Poczenie serwera" },
/* ru */ { IDS_SERVER_BIND_RU, "Server Bind" },
/* sv */ { IDS_SERVER_BIND_SV, "Serverbindning" },
/* tr */ { IDS_SERVER_BIND_TR, "Sunucu Balants" },

/* en */ { IDS_CONNECT_TO,    "Connect to" },
/* da */ { IDS_CONNECT_TO_DA, "Tilslut til" },
/* de */ { IDS_CONNECT_TO_DE, "Verbinden mit" },
/* es */ { IDS_CONNECT_TO_ES, "Conectar a" },
/* fr */ { IDS_CONNECT_TO_FR, "Se connecter " },
/* hu */ { IDS_CONNECT_TO_HU, "Kapcsolds ehhez:" },
/* it */ { IDS_CONNECT_TO_IT, "Connetti a" },
/* ko */ { IDS_CONNECT_TO_KO, "" },
/* nl */ { IDS_CONNECT_TO_NL, "Maak verbinding naar" },
/* pl */ { IDS_CONNECT_TO_PL, "Pocz z" },
/* ru */ { IDS_CONNECT_TO_RU, " " },
/* sv */ { IDS_CONNECT_TO_SV, "Anslut till" },
/* tr */ { IDS_CONNECT_TO_TR, "Balanlan" },

/* en */ { IDS_DISCONNECT,    "Disconnect" },
/* da */ { IDS_DISCONNECT_DA, "Afbryd forbindelse" },
/* de */ { IDS_DISCONNECT_DE, "Verbindung Trennen" },
/* es */ { IDS_DISCONNECT_ES, "Desconectar" },
/* fr */ { IDS_DISCONNECT_FR, "Se dconnecter du serveur" },
/* hu */ { IDS_DISCONNECT_HU, "Sztkapcsolds" },
/* it */ { IDS_DISCONNECT_IT, "Disconnetti" },
/* ko */ { IDS_DISCONNECT_KO, " " },
/* nl */ { IDS_DISCONNECT_NL, "Verbreek verbinding" },
/* pl */ { IDS_DISCONNECT_PL, "Rozcz" },
/* ru */ { IDS_DISCONNECT_RU, "Disconnect" },
/* sv */ { IDS_DISCONNECT_SV, "Koppla frn" },
/* tr */ { IDS_DISCONNECT_TR, "Balanty kes" },

/* en */ { IDS_IDLE,    "Idle" },
/* da */ { IDS_IDLE_DA, "Venter" },
/* de */ { IDS_IDLE_DE, "Idle" },
/* es */ { IDS_IDLE_ES, "Inactivo" },
/* fr */ { IDS_IDLE_FR, "Inactif" },
/* hu */ { IDS_IDLE_HU, "Ttlen" },
/* it */ { IDS_IDLE_IT, "Inattivo" },
/* ko */ { IDS_IDLE_KO, "ʴ" },
/* nl */ { IDS_IDLE_NL, "Idle" },
/* pl */ { IDS_IDLE_PL, "Bezczynny" },
/* ru */ { IDS_IDLE_RU, "Idle" },
/* sv */ { IDS_IDLE_SV, "Vntar" },
/* tr */ { IDS_IDLE_TR, "Boa vakit geirme" },

/* en */ { IDS_SERVER_LISTENING,    "Server listening" },
/* da */ { IDS_SERVER_LISTENING_DA, "Server lytter" },
/* de */ { IDS_SERVER_LISTENING_DE, "Server wartet auf Verbindung" },
/* es */ { IDS_SERVER_LISTENING_ES, "Servidor en escucha" },
/* fr */ { IDS_SERVER_LISTENING_FR, "Le serveur coute" },
/* hu */ { IDS_SERVER_LISTENING_HU, "Vrakozs kliensre" },
/* it */ { IDS_SERVER_LISTENING_IT, "Server in ascolto" },
/* ko */ { IDS_SERVER_LISTENING_KO, " " },
/* nl */ { IDS_SERVER_LISTENING_NL, "Server wacht op verbinding" },
/* pl */ { IDS_SERVER_LISTENING_PL, "Serwer nasuchuje" },
/* ru */ { IDS_SERVER_LISTENING_RU, "Server listening" },
/* sv */ { IDS_SERVER_LISTENING_SV, "Servern lyssnar" },
/* tr */ { IDS_SERVER_LISTENING_TR, "Sunucu dinleniyor" },

/* en */ { IDS_CONNECTED_SERVER,    "Connected server" },
/* da */ { IDS_CONNECTED_SERVER_DA, "Tilsluttet server" },
/* de */ { IDS_CONNECTED_SERVER_DE, "Server verbunden" },
/* es */ { IDS_CONNECTED_SERVER_ES, "Servidor conectado" },
/* fr */ { IDS_CONNECTED_SERVER_FR, "Connect au serveur" },
/* hu */ { IDS_CONNECTED_SERVER_HU, "Kapcsoldva kiszolglhoz" },
/* it */ { IDS_CONNECTED_SERVER_IT, "Server connesso" },
/* ko */ { IDS_CONNECTED_SERVER_KO, " " },
/* nl */ { IDS_CONNECTED_SERVER_NL, "Verbonden server" },
/* pl */ { IDS_CONNECTED_SERVER_PL, "Poczony serwer" },
/* ru */ { IDS_CONNECTED_SERVER_RU, "Connected server" },
/* sv */ { IDS_CONNECTED_SERVER_SV, "Ansluten server" },
/* tr */ { IDS_CONNECTED_SERVER_TR, "Sunucuya balanld" },

/* en */ { IDS_CONNECTED_CLIENT,    "Connected client" },
/* da */ { IDS_CONNECTED_CLIENT_DA, "Tilsluttet klient" },
/* de */ { IDS_CONNECTED_CLIENT_DE, "Verbunden, Client" },
/* es */ { IDS_CONNECTED_CLIENT_ES, "Cliente conectado" },
/* fr */ { IDS_CONNECTED_CLIENT_FR, "Client connect" },
/* hu */ { IDS_CONNECTED_CLIENT_HU, "Kapcsold kliens" },
/* it */ { IDS_CONNECTED_CLIENT_IT, "Client connesso" },
/* ko */ { IDS_CONNECTED_CLIENT_KO, " Ŭ̾Ʈ" },
/* nl */ { IDS_CONNECTED_CLIENT_NL, "Verbonden client" },
/* pl */ { IDS_CONNECTED_CLIENT_PL, "Poczony klient" },
/* ru */ { IDS_CONNECTED_CLIENT_RU, "Connected client" },
/* sv */ { IDS_CONNECTED_CLIENT_SV, "Ansluten klient" },
/* tr */ { IDS_CONNECTED_CLIENT_TR, "Bal istemci" },

/* en */ { IDS_NETPLAY_SETTINGS,    "Netplay Settings" },
/* da */ { IDS_NETPLAY_SETTINGS_DA, "Ntvrksspilindstillinger" },
/* de */ { IDS_NETPLAY_SETTINGS_DE, "Netplay Einstellungen" },
/* es */ { IDS_NETPLAY_SETTINGS_ES, "Ajustes Netplay" },
/* fr */ { IDS_NETPLAY_SETTINGS_FR, "Paramtres de jeu en rseau" },
/* hu */ { IDS_NETPLAY_SETTINGS_HU, "Hlzati jtk belltsai" },
/* it */ { IDS_NETPLAY_SETTINGS_IT, "Impostazioni Netplay" },
/* ko */ { IDS_NETPLAY_SETTINGS_KO, "÷ " },
/* nl */ { IDS_NETPLAY_SETTINGS_NL, "Netplay instellingen" },
/* pl */ { IDS_NETPLAY_SETTINGS_PL, "Ustawienia gry sieciowej" },
/* ru */ { IDS_NETPLAY_SETTINGS_RU, "  " },
/* sv */ { IDS_NETPLAY_SETTINGS_SV, "Instllningar fr ntverksspel" },
/* tr */ { IDS_NETPLAY_SETTINGS_TR, "Netplay Ayarlar" },

/* en */ { IDS_SAVE_SCREENSHOT,    "Save screenshot file" },
/* da */ { IDS_SAVE_SCREENSHOT_DA, "Gem screenshot" },
/* de */ { IDS_SAVE_SCREENSHOT_DE, "Screenshot speichern" },
/* es */ { IDS_SAVE_SCREENSHOT_ES, "Grabar fichero de captura de pantalla" },
/* fr */ { IDS_SAVE_SCREENSHOT_FR, "Enregistrer une capture d'cran" },
/* hu */ { IDS_SAVE_SCREENSHOT_HU, "Fnykp fjl mentse" },
/* it */ { IDS_SAVE_SCREENSHOT_IT, "Salva schermata su file" },
/* ko */ { IDS_SAVE_SCREENSHOT_KO, "ũ  " },
/* nl */ { IDS_SAVE_SCREENSHOT_NL, "Opslaan schermafdrukbestand" },
/* pl */ { IDS_SAVE_SCREENSHOT_PL, "Zapisz plik zrzutu ekranu" },
/* ru */ { IDS_SAVE_SCREENSHOT_RU, "  " },
/* sv */ { IDS_SAVE_SCREENSHOT_SV, "Spara skrmdump" },
/* tr */ { IDS_SAVE_SCREENSHOT_TR, "Ekran grnts dosyas kaydet" },

/* en */ { IDS_CANCEL,    "Cancel" },
/* da */ { IDS_CANCEL_DA, "Annullr" },
/* de */ { IDS_CANCEL_DE, "Abbruch" },
/* es */ { IDS_CANCEL_ES, "Cancelar" },
/* fr */ { IDS_CANCEL_FR, "Annuler" },
/* hu */ { IDS_CANCEL_HU, "Mgsem" },
/* it */ { IDS_CANCEL_IT, "Annulla" },
/* ko */ { IDS_CANCEL_KO, "" },
/* nl */ { IDS_CANCEL_NL, "Annuleren" },
/* pl */ { IDS_CANCEL_PL, "Anuluj" },
/* ru */ { IDS_CANCEL_RU, "" },
/* sv */ { IDS_CANCEL_SV, "Avbryt" },
/* tr */ { IDS_CANCEL_TR, "ptal" },

/* en */ { IDS_CHOOSE_SCREENSHOT_FORMAT,    "Choose screenshot format" },
/* da */ { IDS_CHOOSE_SCREENSHOT_FORMAT_DA, "Vlg screenshot format" },
/* de */ { IDS_CHOOSE_SCREENSHOT_FORMAT_DE, "Whle Screenshot Format" },
/* es */ { IDS_CHOOSE_SCREENSHOT_FORMAT_ES, "Elige formato Captura de pantalla" },
/* fr */ { IDS_CHOOSE_SCREENSHOT_FORMAT_FR, "Chosir le format de capture d'cran" },
/* hu */ { IDS_CHOOSE_SCREENSHOT_FORMAT_HU, "Vlasszon fnykp formtumot" },
/* it */ { IDS_CHOOSE_SCREENSHOT_FORMAT_IT, "Seleziona il formato per il salvataggio della schermata" },
/* ko */ { IDS_CHOOSE_SCREENSHOT_FORMAT_KO, "" },  /* fuzzy */
/* nl */ { IDS_CHOOSE_SCREENSHOT_FORMAT_NL, "Kies schermafdrukformaat" },
/* pl */ { IDS_CHOOSE_SCREENSHOT_FORMAT_PL, "Wybierz format zrzutu ekranu" },
/* ru */ { IDS_CHOOSE_SCREENSHOT_FORMAT_RU, "  " },
/* sv */ { IDS_CHOOSE_SCREENSHOT_FORMAT_SV, "Vlj format p skrmdump" },
/* tr */ { IDS_CHOOSE_SCREENSHOT_FORMAT_TR, "Ekran grnts biimi sein" },

/* en */ { IDS_SAVE_S_SCREENSHOT,    "Save %s screenshot" },
/* da */ { IDS_SAVE_S_SCREENSHOT_DA, "Gem %s-screenshot" },
/* de */ { IDS_SAVE_S_SCREENSHOT_DE, "Screenshot %s speichern" },
/* es */ { IDS_SAVE_S_SCREENSHOT_ES, "Graba %s Captura de pantalla" },
/* fr */ { IDS_SAVE_S_SCREENSHOT_FR, "Enregistrer une capture d'cran %s" },
/* hu */ { IDS_SAVE_S_SCREENSHOT_HU, "%s fnykp mentse" },
/* it */ { IDS_SAVE_S_SCREENSHOT_IT, "Salva schermata %s" },
/* ko */ { IDS_SAVE_S_SCREENSHOT_KO, "" },  /* fuzzy */
/* nl */ { IDS_SAVE_S_SCREENSHOT_NL, "Scherm afdruk %s opslaan" },
/* pl */ { IDS_SAVE_S_SCREENSHOT_PL, "Zapisz zrzut ekranu %s" },
/* ru */ { IDS_SAVE_S_SCREENSHOT_RU, "Save %s screenshot" },
/* sv */ { IDS_SAVE_S_SCREENSHOT_SV, "Spara %s-skrmdump" },
/* tr */ { IDS_SAVE_S_SCREENSHOT_TR, "%s ekran grntsn kaydet" },

/* en */ { IDS_DETACHED_DEVICE_D,    "Detached device %d" },
/* da */ { IDS_DETACHED_DEVICE_D_DA, "Frakoblet enhed %d" },
/* de */ { IDS_DETACHED_DEVICE_D_DE, "Gert %d entfernt" },
/* es */ { IDS_DETACHED_DEVICE_D_ES, "Perifrico extrado %d" },
/* fr */ { IDS_DETACHED_DEVICE_D_FR, "Priphrique dtach %d" },
/* hu */ { IDS_DETACHED_DEVICE_D_HU, "%d eszkz levlasztva" },
/* it */ { IDS_DETACHED_DEVICE_D_IT, "Rimosso dispositivo %d" },
/* ko */ { IDS_DETACHED_DEVICE_D_KO, "" },  /* fuzzy */
/* nl */ { IDS_DETACHED_DEVICE_D_NL, "Apparaat %d ontkoppeld" },
/* pl */ { IDS_DETACHED_DEVICE_D_PL, "Odczono urzdzenie %d" },
/* ru */ { IDS_DETACHED_DEVICE_D_RU, "Detached device %d" },
/* sv */ { IDS_DETACHED_DEVICE_D_SV, "Kopplade frn enhet %d" },
/* tr */ { IDS_DETACHED_DEVICE_D_TR, "kartlm aygt %d" },

/* en */ { IDS_ATTACHED_S_TO_DEVICE_D,    "Attached %s to device#%d" },
/* da */ { IDS_ATTACHED_S_TO_DEVICE_D_DA, "Tilsluttet %s til enhed #%d" },
/* de */ { IDS_ATTACHED_S_TO_DEVICE_D_DE, "%s mit Gert#%d verbunden" },
/* es */ { IDS_ATTACHED_S_TO_DEVICE_D_ES, "Insertado %s en unidad#%d" },
/* fr */ { IDS_ATTACHED_S_TO_DEVICE_D_FR, "%s attach au priphrique #%d" },
/* hu */ { IDS_ATTACHED_S_TO_DEVICE_D_HU, "%s csatolva #%d eszkzhz" },
/* it */ { IDS_ATTACHED_S_TO_DEVICE_D_IT, "Selezionato %s per la periferica #%d" },
/* ko */ { IDS_ATTACHED_S_TO_DEVICE_D_KO, "" },  /* fuzzy */
/* nl */ { IDS_ATTACHED_S_TO_DEVICE_D_NL, "%s aan apparaat#%d gekoppelt" },
/* pl */ { IDS_ATTACHED_S_TO_DEVICE_D_PL, "Podczono %s pod urzdzenie#%d" },
/* ru */ { IDS_ATTACHED_S_TO_DEVICE_D_RU, "Attached %s to device#%d" },
/* sv */ { IDS_ATTACHED_S_TO_DEVICE_D_SV, "Anslt %s till enhet %d" },
/* tr */ { IDS_ATTACHED_S_TO_DEVICE_D_TR, "%s aygt#%d'e balanm" },

/* en */ { IDS_VICE_QUESTION,    "VICE Question" },
/* da */ { IDS_VICE_QUESTION_DA, "VICE-sprgsml" },
/* de */ { IDS_VICE_QUESTION_DE, "VICE Frage" },
/* es */ { IDS_VICE_QUESTION_ES, "VICE cuestion" },
/* fr */ { IDS_VICE_QUESTION_FR, "Question VICE" },
/* hu */ { IDS_VICE_QUESTION_HU, "VICE krds" },
/* it */ { IDS_VICE_QUESTION_IT, "Domanda di VICE" },
/* ko */ { IDS_VICE_QUESTION_KO, "" },  /* fuzzy */
/* nl */ { IDS_VICE_QUESTION_NL, "VICE vraag" },
/* pl */ { IDS_VICE_QUESTION_PL, "Pytanie VICE" },
/* ru */ { IDS_VICE_QUESTION_RU, "VICE Question" },
/* sv */ { IDS_VICE_QUESTION_SV, "VICE-frga" },
/* tr */ { IDS_VICE_QUESTION_TR, "VICE Sorusu" },

/* en */ { IDS_EXTEND_TO_40_TRACK,    "Do you want to extend the image?" },
/* da */ { IDS_EXTEND_TO_40_TRACK_DA, "" },  /* fuzzy */
/* de */ { IDS_EXTEND_TO_40_TRACK_DE, "Soll das Diskimage erweitert werden?" },
/* es */ { IDS_EXTEND_TO_40_TRACK_ES, "Quieres extender la imagen?" },
/* fr */ { IDS_EXTEND_TO_40_TRACK_FR, "" },  /* fuzzy */
/* hu */ { IDS_EXTEND_TO_40_TRACK_HU, "" },  /* fuzzy */
/* it */ { IDS_EXTEND_TO_40_TRACK_IT, "Vuoi estendere l'immagine?" },
/* ko */ { IDS_EXTEND_TO_40_TRACK_KO, "" },  /* fuzzy */
/* nl */ { IDS_EXTEND_TO_40_TRACK_NL, "Wilt u het bestand uitbreiden?" },
/* pl */ { IDS_EXTEND_TO_40_TRACK_PL, "Czy chcesz rozszerzy obraz ?" },
/* ru */ { IDS_EXTEND_TO_40_TRACK_RU, "" },  /* fuzzy */
/* sv */ { IDS_EXTEND_TO_40_TRACK_SV, "" },  /* fuzzy */
/* tr */ { IDS_EXTEND_TO_40_TRACK_TR, "" },  /* fuzzy */

/* en */ { IDS_YES_NO,    "Yes|No" },
/* da */ { IDS_YES_NO_DA, "Ja|Nej" },
/* de */ { IDS_YES_NO_DE, "Ja|Nein" },
/* es */ { IDS_YES_NO_ES, "S/No" },
/* fr */ { IDS_YES_NO_FR, "Oui|Non" },
/* hu */ { IDS_YES_NO_HU, "Igen|Nem" },
/* it */ { IDS_YES_NO_IT, "S|No" },
/* ko */ { IDS_YES_NO_KO, "|ƴϿ" },
/* nl */ { IDS_YES_NO_NL, "Ja|Nee" },
/* pl */ { IDS_YES_NO_PL, "Tak|Nie" },
/* ru */ { IDS_YES_NO_RU, "|" },
/* sv */ { IDS_YES_NO_SV, "Ja|Nej" },
/* tr */ { IDS_YES_NO_TR, "Evet|Hayr" },

/* en */ { IDS_DETACHED_TAPE,    "Detached tape" },
/* da */ { IDS_DETACHED_TAPE_DA, "Frakoblet bnd" },
/* de */ { IDS_DETACHED_TAPE_DE, "Band Image entfernt" },
/* es */ { IDS_DETACHED_TAPE_ES, "Cinta extraida" },
/* fr */ { IDS_DETACHED_TAPE_FR, "Datassette dtach" },
/* hu */ { IDS_DETACHED_TAPE_HU, "Szalag levlasztva" },
/* it */ { IDS_DETACHED_TAPE_IT, "Cassetta rimossa" },
/* ko */ { IDS_DETACHED_TAPE_KO, "" },  /* fuzzy */
/* nl */ { IDS_DETACHED_TAPE_NL, "Tape ontkoppeld" },
/* pl */ { IDS_DETACHED_TAPE_PL, "Odczono tam" },
/* ru */ { IDS_DETACHED_TAPE_RU, "Detached tape" },
/* sv */ { IDS_DETACHED_TAPE_SV, "Kopplade frn band" },
/* tr */ { IDS_DETACHED_TAPE_TR, "Teyp kartld" },

/* en */ { IDS_ATTACHED_TAPE_S,    "Attached tape %s" },
/* da */ { IDS_ATTACHED_TAPE_S_DA, "Tilsluttet bnd %s" },
/* de */ { IDS_ATTACHED_TAPE_S_DE, "Band Image %s eingelegt" },
/* es */ { IDS_ATTACHED_TAPE_S_ES, "Cinta insertada %s" },
/* fr */ { IDS_ATTACHED_TAPE_S_FR, "Datassette %s attach" },
/* hu */ { IDS_ATTACHED_TAPE_S_HU, "%s szalag csatolva" },
/* it */ { IDS_ATTACHED_TAPE_S_IT, "Cassetta %s selezionata" },
/* ko */ { IDS_ATTACHED_TAPE_S_KO, "" },  /* fuzzy */
/* nl */ { IDS_ATTACHED_TAPE_S_NL, "Tape %s gekoppelt" },
/* pl */ { IDS_ATTACHED_TAPE_S_PL, "Zamontowana tama %s" },
/* ru */ { IDS_ATTACHED_TAPE_S_RU, "Attached tape %s" },
/* sv */ { IDS_ATTACHED_TAPE_S_SV, "Anslt band %s" },
/* tr */ { IDS_ATTACHED_TAPE_S_TR, "Yerletirilmi teyp %s" },

/* en */ { IDS_SELECT_START_SNAPSHOT,    "Select start snapshot for event history" },
/* da */ { IDS_SELECT_START_SNAPSHOT_DA, "Vlg start-snapshot for hndelseshistorik" },
/* de */ { IDS_SELECT_START_SNAPSHOT_DE, "Startsnapshot fr Ereignishistory festlegen" },
/* es */ { IDS_SELECT_START_SNAPSHOT_ES, "Seleccionar inicio volcado para historial de eventos" },
/* fr */ { IDS_SELECT_START_SNAPSHOT_FR, "Slectionner l'instantan de dpart pour l'historique des vnements" },
/* hu */ { IDS_SELECT_START_SNAPSHOT_HU, "Vlasszon kezdeti pillanatkpet az esemny rgztshez" },
/* it */ { IDS_SELECT_START_SNAPSHOT_IT, "Seleziona snapshot iniziale per la cronologia degli eventi" },
/* ko */ { IDS_SELECT_START_SNAPSHOT_KO, "̺Ʈ 丮    ϼ" },
/* nl */ { IDS_SELECT_START_SNAPSHOT_NL, "Selecteer start momentopname voor gebeurtenis geschiedenis" },
/* pl */ { IDS_SELECT_START_SNAPSHOT_PL, "Wybierz pocztkowy zrzut historii zdarze" },
/* ru */ { IDS_SELECT_START_SNAPSHOT_RU, "Select start snapshot for event history" },
/* sv */ { IDS_SELECT_START_SNAPSHOT_SV, "Vlj startgonblicksmodul fr hndelsehistorik" },
/* tr */ { IDS_SELECT_START_SNAPSHOT_TR, "Olay tarihesi iin balang anlk grntsn se" },

/* en */ { IDS_SELECT_END_SNAPSHOT,    "Select end snapshot for event history" },
/* da */ { IDS_SELECT_END_SNAPSHOT_DA, "Vlg slut-snapshot for hndelseshistorik" },
/* de */ { IDS_SELECT_END_SNAPSHOT_DE, "Startsnapshot fr Ereignishistory festlegen" },
/* es */ { IDS_SELECT_END_SNAPSHOT_ES, "Seleccionar fin volcado para historial de eventos" },
/* fr */ { IDS_SELECT_END_SNAPSHOT_FR, "Slectionner l'instantan de dpart pour l'historique des vnements" },
/* hu */ { IDS_SELECT_END_SNAPSHOT_HU, "Vlasszon vgs pillanatkpet az esemny rgztshez" },
/* it */ { IDS_SELECT_END_SNAPSHOT_IT, "Seleziona snapshot finale per la cronologia degli eventi" },
/* ko */ { IDS_SELECT_END_SNAPSHOT_KO, "̺Ʈ 丮    ϼ" },
/* nl */ { IDS_SELECT_END_SNAPSHOT_NL, "Selecteer eind momentopname voor gebeurtenis geschiedenis" },
/* pl */ { IDS_SELECT_END_SNAPSHOT_PL, "Wybierz kocowy zrzut historii zdarze" },
/* ru */ { IDS_SELECT_END_SNAPSHOT_RU, "Select end snapshot for event history" },
/* sv */ { IDS_SELECT_END_SNAPSHOT_SV, "Vlj slutgonblicksbild fr hndelsehistorik" },
/* tr */ { IDS_SELECT_END_SNAPSHOT_TR, "Olay tarihesi iin biti anlk grntsn se" },

/* en */ { IDS_REALLY_EXIT,    "Do you really want to exit?\n\nAll the data present in the emulated RAM will be lost." },
/* da */ { IDS_REALLY_EXIT_DA, "Vil du virkelig afslutte?\n\nAlle data i emuleret RAM gr tabt." },
/* de */ { IDS_REALLY_EXIT_DE, "Willst Du wirklich beenden?\nDaten im emulierten Speicher RAM gehen verloren." },
/* es */ { IDS_REALLY_EXIT_ES, "Realmente quieres salir?\n\nSe perdern todos los datos presentes en la RAM emulada." },
/* fr */ { IDS_REALLY_EXIT_FR, "Dsirez-vous vraiment quitter?\n\nToutes les donnes prsentes dans la mmoire de l'mulateur seront perdues." },
/* hu */ { IDS_REALLY_EXIT_HU, "Biztosan kilp?\n\nAz emullt memria teljes tartalma el fog veszni." },
/* it */ { IDS_REALLY_EXIT_IT, "Uscire davvero?\n\nTutti i dati presenti nella RAM emulata saranno persi." },
/* ko */ { IDS_REALLY_EXIT_KO, "" },  /* fuzzy */
/* nl */ { IDS_REALLY_EXIT_NL, "Wilt U echt afsluiten?\n\nAlle data in gemuleerd geheugen zal verloren gaan." },
/* pl */ { IDS_REALLY_EXIT_PL, "Na pewno wyj?\n\nWszystkie dane w emulowanym RAM-ie zostan utracone." },
/* ru */ { IDS_REALLY_EXIT_RU, "Do you really want to exit?\n\nAll the data present in the emulated RAM will be lost." },
/* sv */ { IDS_REALLY_EXIT_SV, "Vill du verkligen avsluta?\n\nAlla data i emulerat RAM kommer frloras." },
/* tr */ { IDS_REALLY_EXIT_TR, "kmak istediinizden emin misiniz?\n\nEmle edilmi RAM'de bulunan mevcut tm veri kaybedilecektir." },

/* en */ { IDS_ATTACH_CRT_IMAGE,    "Attach CRT cartridge image" },
/* da */ { IDS_ATTACH_CRT_IMAGE_DA, "Tilslut CRT-cartridge image" },
/* de */ { IDS_ATTACH_CRT_IMAGE_DE, "CRT Erweiterungsmodul Image einlegen" },
/* es */ { IDS_ATTACH_CRT_IMAGE_ES, "Insertar imagen de cartucho CRT" },
/* fr */ { IDS_ATTACH_CRT_IMAGE_FR, "Insrer une cartouche CRT" },
/* hu */ { IDS_ATTACH_CRT_IMAGE_HU, "CRT cartridge kpms csatolsa" },
/* it */ { IDS_ATTACH_CRT_IMAGE_IT, "Seleziona immagine cartuccia CRT" },
/* ko */ { IDS_ATTACH_CRT_IMAGE_KO, "CRT īƮ ̹ ٿÿ" },
/* nl */ { IDS_ATTACH_CRT_IMAGE_NL, "Koppel CRT cartridge bestand aan" },
/* pl */ { IDS_ATTACH_CRT_IMAGE_PL, "Zamontuj obraz kartrida CRT" },
/* ru */ { IDS_ATTACH_CRT_IMAGE_RU, "Attach CRT cartridge image" },
/* sv */ { IDS_ATTACH_CRT_IMAGE_SV, "Anslut CRT-insticksmodulfil" },
/* tr */ { IDS_ATTACH_CRT_IMAGE_TR, "CRT kartu imaj yerletir" },

/* en */ { IDS_ATTACH_RAW_8KB_IMAGE,    "Attach raw 8KB cartridge image" },
/* da */ { IDS_ATTACH_RAW_8KB_IMAGE_DA, "Tilslut rt 8kB-cartridge image" },
/* de */ { IDS_ATTACH_RAW_8KB_IMAGE_DE, "8KB Erweiterungsmodul (raw) Image einlegen" },
/* es */ { IDS_ATTACH_RAW_8KB_IMAGE_ES, "Insertar imagen de cartucho 8KB" },
/* fr */ { IDS_ATTACH_RAW_8KB_IMAGE_FR, "Insrer une cartouche 8KO" },
/* hu */ { IDS_ATTACH_RAW_8KB_IMAGE_HU, "Nyers 8KB-os cartridge kpms csatolsa" },
/* it */ { IDS_ATTACH_RAW_8KB_IMAGE_IT, "Seleziona immagine cartuccia di 8KB" },
/* ko */ { IDS_ATTACH_RAW_8KB_IMAGE_KO, "8kb īƮ ̹ ̼" },
/* nl */ { IDS_ATTACH_RAW_8KB_IMAGE_NL, "Koppel binair 8KB cartridge bestand" },
/* pl */ { IDS_ATTACH_RAW_8KB_IMAGE_PL, "Zamontuj surowy obraz kartrida 8KB" },
/* ru */ { IDS_ATTACH_RAW_8KB_IMAGE_RU, "   8 " },
/* sv */ { IDS_ATTACH_RAW_8KB_IMAGE_SV, "Anslut r 8KB-insticksmodulavbildning" },
/* tr */ { IDS_ATTACH_RAW_8KB_IMAGE_TR, "Dz 8KB kartu imaj yerletir" },

/* en */ { IDS_ATTACH_RAW_16KB_IMAGE,    "Attach raw 16KB cartridge image" },
/* da */ { IDS_ATTACH_RAW_16KB_IMAGE_DA, "Tilslut rt 16kB-cartridge image" },
/* de */ { IDS_ATTACH_RAW_16KB_IMAGE_DE, "16KB Erweiterungsmodul (raw) Image einlegen" },
/* es */ { IDS_ATTACH_RAW_16KB_IMAGE_ES, "Insertar imagen de cartucho 16KB" },
/* fr */ { IDS_ATTACH_RAW_16KB_IMAGE_FR, "Insrer une cartouche 16KO" },
/* hu */ { IDS_ATTACH_RAW_16KB_IMAGE_HU, "Nyers 16KB-os cartridge kpms csatolsa" },
/* it */ { IDS_ATTACH_RAW_16KB_IMAGE_IT, "Seleziona immagine cartuccia di 16KB" },
/* ko */ { IDS_ATTACH_RAW_16KB_IMAGE_KO, "16kb īƮ ̹ ̼" },
/* nl */ { IDS_ATTACH_RAW_16KB_IMAGE_NL, "Koppel binair 16KB cartridge bestand" },
/* pl */ { IDS_ATTACH_RAW_16KB_IMAGE_PL, "Zamontuj surowy obraz kartrida 16KB" },
/* ru */ { IDS_ATTACH_RAW_16KB_IMAGE_RU, "   16 " },
/* sv */ { IDS_ATTACH_RAW_16KB_IMAGE_SV, "Anslut r 16KB-insticksmodulavbildning" },
/* tr */ { IDS_ATTACH_RAW_16KB_IMAGE_TR, "Dz 16KB kartu imaj yerletir" },

/* en */ { IDS_ATTACH_ACTION_REPLAY_IMAGE,    "Attach raw 32KB Action Replay cartridge image" },
/* da */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_DA, "Tilslut rt 32KB Action Replay cartridge image" },
/* de */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_DE, "32kB Action Replay Image (raw) einlegen" },
/* es */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_ES, "Insertar imagen cartucho Action Replay 32KB" },
/* fr */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_FR, "Insrer une cartouche Action Replay 32KO" },
/* hu */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_HU, "32KB-os Action Replay cartridge kpms csatolsa" },
/* it */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_IT, "Seleziona immagine cartuccia Action Replay di 32KB" },
/* ko */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_NL, "Koppel binair 32KB Action Replay cartridge bestand" },
/* pl */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_PL, "Zamontuj surowy obraz kartida 32KB Action Replay" },
/* ru */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_RU, "Attach raw 32KB Action Replay cartridge image" },
/* sv */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_SV, "Anslut r 32KB-Action Replay-insticksmodulfil" },
/* tr */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_TR, "Dz 32KB Action Replay kartu imaj yerletir" },

/* en */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE,    "Attach raw 16KB Action Replay MK3 cartridge image" },
/* da */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_DA, "Tilslut rt 16KB Action Replay MK3 cartridge image" },
/* de */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_DE, "16kB Action Replay MK3 Image (raw) einlegen" },
/* es */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_ES, "Insertar imagen cartucho Action Replay MK3 16KB" },
/* fr */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_FR, "Attacher une image de cartouche 16 ko Action Replay MK3" },
/* hu */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_IT, "Seleziona immagine cartuccia Action Replay MK3 di 16KB" },
/* ko */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_NL, "Koppel binair 16KB Action Replay MK3 cartridge bestand" },
/* pl */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_PL, "Zamontuj surowy obraz kartrida 16KB Action Replay MK3" },
/* ru */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_RU, "Attach raw 16KB Action Replay MK3 cartridge image" },
/* sv */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_SV, "Anslut r 16KB-Action Replay MK3-insticksmodulfil" },
/* tr */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_TR, "Dz 16KB Action Replay MK3 kartu imaj yerletir" },

/* en */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE,    "Attach raw 32KB Action Replay MK4 cartridge image" },
/* da */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_DA, "Tilslut rt 32KB Action Replay MK4 cartridge image" },
/* de */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_DE, "32kB Action Replay MK4 Image einlegen" },
/* es */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_ES, "Insertar imagen cartucho Action Replay MK4 32KB" },
/* fr */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_FR, "Attacher une image de cartouche 2 ko Action Replay MK4" },
/* hu */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_IT, "Seleziona immagine cartuccia Action Replay MK4 di 326KB" },
/* ko */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_NL, "Koppel binair 32KB Action Replay MK4 cartridge bestand" },
/* pl */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_PL, "Zamontuj surowy obraz kartrida 32KB Action Replay MK4" },
/* ru */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_RU, "Attach raw 32KB Action Replay MK4 cartridge image" },
/* sv */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_SV, "Anslut r 32KB-Action Replay MK4-insticksmodulfil" },
/* tr */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_TR, "Dz 32KB Action Replay MK4 kartu imaj yerletir" },

/* en */ { IDS_ATTACH_STARDOS_IMAGE,    "Attach raw 16KB Stardos cartridge image" },
/* da */ { IDS_ATTACH_STARDOS_IMAGE_DA, "Tilslut rt 16KB StarDOS cartridge image" },
/* de */ { IDS_ATTACH_STARDOS_IMAGE_DE, "16kB Stardos Erweiterungsmodul Image (raw) einlegen" },
/* es */ { IDS_ATTACH_STARDOS_IMAGE_ES, "Insertar imagen cartucho Stardos 16KB" },
/* fr */ { IDS_ATTACH_STARDOS_IMAGE_FR, "Attacher une image de cartouche 16 ko Stardos" },
/* hu */ { IDS_ATTACH_STARDOS_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDS_ATTACH_STARDOS_IMAGE_IT, "Seleziona immagine cartuccia Stardos di 16KB" },
/* ko */ { IDS_ATTACH_STARDOS_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDS_ATTACH_STARDOS_IMAGE_NL, "Koppel binair 16KB Stardos cartridge bestand" },
/* pl */ { IDS_ATTACH_STARDOS_IMAGE_PL, "Zamontuj surowy obraz kartrida 16KB Stardos" },
/* ru */ { IDS_ATTACH_STARDOS_IMAGE_RU, "Attach raw 16KB Stardos cartridge image" },
/* sv */ { IDS_ATTACH_STARDOS_IMAGE_SV, "Anslut r 16KB Stardos-insticksmodulfil" },
/* tr */ { IDS_ATTACH_STARDOS_IMAGE_TR, "Dz 16KB Stardos kartu imaj yerletir" },

/* en */ { IDS_ATTACH_ATOMIC_POWER_IMAGE,    "Attach raw 32KB Atomic Power cartridge image" },
/* da */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_DA, "Tilslut rt 32kB Atomic Power-cartridge image" },
/* de */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_DE, "32kB Atomic Power Image einlegen" },
/* es */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_ES, "Insertar imagen cartucho Atomic Power 32KB" },
/* fr */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_FR, "Insrer une cartouche Atomic Power 32KO" },
/* hu */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_HU, "32KB-os Atomic Power cartridge kpms csatolsa" },
/* it */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_IT, "Seleziona immagine cartuccia Atomic Power di 32KB" },
/* ko */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_KO, "32kb Atomic Power īƮ ̹ ̼" },
/* nl */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_NL, "Koppel binair 32KB Atomic Power cartridge bestand" },
/* pl */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_PL, "Zamontuj surowy obraz kartrida 32KB Atomic Power" },
/* ru */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_RU, "Attach raw 32KB Atomic Power cartridge image" },
/* sv */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_SV, "Anslut r 32KB Atomic Power-insticksmodulfil" },
/* tr */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_TR, "Dz 32KB Atomic Power kartu imaj yerletir" },

/* en */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE,    "Attach raw 8KB Epyx FastLoad cartridge image" },
/* da */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_DA, "Tilslut rt 8kB Epyx FastLoad cartridge image" },
/* de */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_DE, "8kB Epyx Fastload Image (raw) einlegen" },
/* es */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_ES, "Insertar imagen cartucho Epyx Fastload 8KB" },
/* fr */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_FR, "Attacher une image de cartouche 8 ko Epyx FastLoad" },
/* hu */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_IT, "Seleziona immagine cartuccia Epyx FastLoad di 8KB" },
/* ko */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_KO, "8kb Epyx FastLoad īƮ ̹ ̼" },
/* nl */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_NL, "Koppel binair 8KB Epyx FastLoad cartridge bestand" },
/* pl */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_PL, "Zamontuj surowy obraz kartrida 8KB Epyx FastLoad" },
/* ru */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_RU, "Attach raw 8KB Epyx FastLoad cartridge image" },
/* sv */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_SV, "Anslut r 8KB Epyx FastLoad-insticksmodulfil" },
/* tr */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_TR, "Dz 8KB Epyx FastLoad kartu imaj yerletir" },

/* en */ { IDS_ATTACH_IEEE488_IMAGE,    "Attach IEEE-488 Interface cartridge image" },
/* da */ { IDS_ATTACH_IEEE488_IMAGE_DA, "Tilslut IEEE-488 interface cartridge image" },
/* de */ { IDS_ATTACH_IEEE488_IMAGE_DE, "IEEE Schnittstellen Erweiterungsmodul Image einlegen" },
/* es */ { IDS_ATTACH_IEEE488_IMAGE_ES, "Insertar imagen de cartucho Interface IEEE-488" },
/* fr */ { IDS_ATTACH_IEEE488_IMAGE_FR, "Attacher une image de cartouche Interface IEEE-488" },
/* hu */ { IDS_ATTACH_IEEE488_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDS_ATTACH_IEEE488_IMAGE_IT, "Seleziona immagine cartuccia interfaccia IEEE" },
/* ko */ { IDS_ATTACH_IEEE488_IMAGE_KO, "IEEE-488 ̽ īƮ ̹ ٿ" },
/* nl */ { IDS_ATTACH_IEEE488_IMAGE_NL, "Koppel IEEE-488 Interface cartridge bestand" },
/* pl */ { IDS_ATTACH_IEEE488_IMAGE_PL, "Zamontuj obraz kartrida IEEE-488 Interface" },
/* ru */ { IDS_ATTACH_IEEE488_IMAGE_RU, "Attach IEEE-488 Interface cartridge image" },
/* sv */ { IDS_ATTACH_IEEE488_IMAGE_SV, "Anslut IEEE-488-grnssnittsavbildningsfil" },
/* tr */ { IDS_ATTACH_IEEE488_IMAGE_TR, "IEEE-488 Arabirimi kartu imaj yerletir" },

/* en */ { IDS_ATTACH_RETRO_REPLAY_IMAGE,    "Attach raw 64KB Retro Replay cartridge image" },
/* da */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_DA, "Tilslut rt 64kB-Retro Replay-cartridge image" },
/* de */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_DE, "64kB Retro Replay Image einlegen" },
/* es */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_ES, "Insertar imagen cartucho Retro Replay 64KB" },
/* fr */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_FR, "Insrer une cartouche Retro Replay 64KO" },
/* hu */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_HU, "64KB-os Retro Replay cartridge kpms csatolsa" },
/* it */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_IT, "Seleziona immagine cartuccia Retro Replay di 64KB" },
/* ko */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_KO, "64KB Retro Replay īƮ ̹ ̼" },
/* nl */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_NL, "Koppel binair 64KB Retro Replay cartridge bestand" },
/* pl */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_PL, "Zamontuj surowy obraz kartrida 64KB Retro Replay" },
/* ru */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_RU, "Attach raw 64KB Retro Replay cartridge image" },
/* sv */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_SV, "Anslut r 64KB-Retro Replay-insticksmodulfil" },
/* tr */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_TR, "Dz 64KB Retro Replay kartu imaj yerletir" },

/* en */ { IDS_ATTACH_IDE64_IMAGE,    "Attach raw 64KB IDE64 cartridge image" },
/* da */ { IDS_ATTACH_IDE64_IMAGE_DA, "Tilslut rt 64kB IDE64-cartridge image" },
/* de */ { IDS_ATTACH_IDE64_IMAGE_DE, "64kB IDE64 Image einlegen" },
/* es */ { IDS_ATTACH_IDE64_IMAGE_ES, "Insertar imagen cartucho IDE64 64KB" },
/* fr */ { IDS_ATTACH_IDE64_IMAGE_FR, "Insrer une cartouche IDE64 64KO" },
/* hu */ { IDS_ATTACH_IDE64_IMAGE_HU, "64KB-os IDE64 cartridge kpms csatolsa" },
/* it */ { IDS_ATTACH_IDE64_IMAGE_IT, "Seleziona immagine cartuccia IDE64 di 64KB" },
/* ko */ { IDS_ATTACH_IDE64_IMAGE_KO, "64kb IDE64 īƮ ̹ ̼" },
/* nl */ { IDS_ATTACH_IDE64_IMAGE_NL, "Koppel binair 64KB IDE64 cartridge bestand" },
/* pl */ { IDS_ATTACH_IDE64_IMAGE_PL, "Zamontuj surowy obraz kartrida 64KB IDE64" },
/* ru */ { IDS_ATTACH_IDE64_IMAGE_RU, "Attach raw 64KB IDE64 cartridge image" },
/* sv */ { IDS_ATTACH_IDE64_IMAGE_SV, "Anslut r 64KB IDE64-insticksmodulfil" },
/* tr */ { IDS_ATTACH_IDE64_IMAGE_TR, "Dz 64KB IDE64 kartu imaj yerletir" },

/* en */ { IDS_ATTACH_SS4_IMAGE,    "Attach raw 32KB Super Snapshot V4 cartridge image" },
/* da */ { IDS_ATTACH_SS4_IMAGE_DA, "Tilslut rt 32kB Super Snapshot V4 cartridge image" },
/* de */ { IDS_ATTACH_SS4_IMAGE_DE, "32kB Super Snapshot V4 Image (raw) einlegen" },
/* es */ { IDS_ATTACH_SS4_IMAGE_ES, "Insertar imagen cartucho Super Snapshot V4 32KB" },
/* fr */ { IDS_ATTACH_SS4_IMAGE_FR, "Attacher une image de cartouche 32 ko Super Snapshot V4" },
/* hu */ { IDS_ATTACH_SS4_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDS_ATTACH_SS4_IMAGE_IT, "Seleziona immagine cartuccia Super Snapshot V4 di 32KB" },
/* ko */ { IDS_ATTACH_SS4_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDS_ATTACH_SS4_IMAGE_NL, "Koppel binair 32KB Super Snapshot V4 cartridge bestand" },
/* pl */ { IDS_ATTACH_SS4_IMAGE_PL, "Zamontuj surowy obraz kartrida 32KB Super Snapshot V4" },
/* ru */ { IDS_ATTACH_SS4_IMAGE_RU, "Attach raw 32KB Super Snapshot V4 cartridge image" },
/* sv */ { IDS_ATTACH_SS4_IMAGE_SV, "Anslut r 32KB Super Snapshot V4-insticksmodulfil" },
/* tr */ { IDS_ATTACH_SS4_IMAGE_TR, "Dz 32KB Super Snapshot V4 kartu imaj yerletir" },

/* en */ { IDS_ATTACH_SS5_IMAGE,    "Attach raw 64KB Super Snapshot V5 cartridge image" },
/* da */ { IDS_ATTACH_SS5_IMAGE_DA, "Tilslut rt 64kB Super Snapshot V5 cartridge image" },
/* de */ { IDS_ATTACH_SS5_IMAGE_DE, "64kB Super Snapshot V5 Image (raw) einlegen" },
/* es */ { IDS_ATTACH_SS5_IMAGE_ES, "Insertar imagen cartucho Super Snapshot V5 64KB" },
/* fr */ { IDS_ATTACH_SS5_IMAGE_FR, "Attacher une image de cartouche 64 ko Super Snapshot V5" },
/* hu */ { IDS_ATTACH_SS5_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDS_ATTACH_SS5_IMAGE_IT, "Seleziona immagine cartuccia Super Snapshot V5 di 64KB" },
/* ko */ { IDS_ATTACH_SS5_IMAGE_KO, "64KB Super Snapshot V5 īƮ ̹ ̼" },
/* nl */ { IDS_ATTACH_SS5_IMAGE_NL, "Koppel binair 64KB Super Snapshot V5 cartridge bestand" },
/* pl */ { IDS_ATTACH_SS5_IMAGE_PL, "Zamontuj surowy obraz kartrida Super Snapshot V5" },
/* ru */ { IDS_ATTACH_SS5_IMAGE_RU, "Attach raw 64KB Super Snapshot V5 cartridge image" },
/* sv */ { IDS_ATTACH_SS5_IMAGE_SV, "Anslut r 64KB-Super Snapshot V5-insticksmodulfil" },
/* tr */ { IDS_ATTACH_SS5_IMAGE_TR, "Dz 64KB Super Snapshot V5 kartu imaj yerletir" },

/* en */ { IDS_ATTACH_SB_IMAGE,    "Attach raw Structured Basic cartridge image" },
/* da */ { IDS_ATTACH_SB_IMAGE_DA, "Tilslut r Strucured BASIC-cartridge image" },
/* de */ { IDS_ATTACH_SB_IMAGE_DE, "Erweiterungsmodul Structured Basic (raw) Image einlegen" },
/* es */ { IDS_ATTACH_SB_IMAGE_ES, "Insertar imagen cartucho Structured Basic" },
/* fr */ { IDS_ATTACH_SB_IMAGE_FR, "Insrer une cartouche Raw Structured Basic" },
/* hu */ { IDS_ATTACH_SB_IMAGE_HU, "Structured Basic cartridge kpms csatolsa" },
/* it */ { IDS_ATTACH_SB_IMAGE_IT, "Seleziona immagine cartuccia Structured Basic" },
/* ko */ { IDS_ATTACH_SB_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDS_ATTACH_SB_IMAGE_NL, "Koppel binair Structured Basic cartridge bestand aan" },
/* pl */ { IDS_ATTACH_SB_IMAGE_PL, "Zamontuj surowy obraz kartrida Structured Basic" },
/* ru */ { IDS_ATTACH_SB_IMAGE_RU, "Attach raw Structured Basic cartridge image" },
/* sv */ { IDS_ATTACH_SB_IMAGE_SV, "Anslut r Strucured Basic-insticksmodulfil" },
/* tr */ { IDS_ATTACH_SB_IMAGE_TR, "Dz yaplandrlm Basic kartu imaj yerletir" },

/* en */ { IDS_AVAILABLE_CMDLINE_OPTIONS,    "\nAvailable command-line options:\n\n" },
/* da */ { IDS_AVAILABLE_CMDLINE_OPTIONS_DA, "\nMulige kommandolinjeparametre:\n\n" },
/* de */ { IDS_AVAILABLE_CMDLINE_OPTIONS_DE, "\nZulssige Kommandozeilen Optionen:\n\n" },
/* es */ { IDS_AVAILABLE_CMDLINE_OPTIONS_ES, "\nOpciones de comando disponibles:\n\n" },
/* fr */ { IDS_AVAILABLE_CMDLINE_OPTIONS_FR, "\nOptions de ligne de commande disponibles:\n\n" },
/* hu */ { IDS_AVAILABLE_CMDLINE_OPTIONS_HU, "\nLehetsges parancssori opcik:\n\n" },
/* it */ { IDS_AVAILABLE_CMDLINE_OPTIONS_IT, "\nOpzioni disponibili da riga di comando:\n\n" },
/* ko */ { IDS_AVAILABLE_CMDLINE_OPTIONS_KO, "\n밡 Ŀǵ  ɼ:\n\n" },
/* nl */ { IDS_AVAILABLE_CMDLINE_OPTIONS_NL, "\nBeschikbare command-line opties:\n\n" },
/* pl */ { IDS_AVAILABLE_CMDLINE_OPTIONS_PL, "\nDostpne opcje wiersza polece:\n\n" },
/* ru */ { IDS_AVAILABLE_CMDLINE_OPTIONS_RU, "\n   :\n\n" },
/* sv */ { IDS_AVAILABLE_CMDLINE_OPTIONS_SV, "\nTillgngliga kommandoradsflaggor:\n\n" },
/* tr */ { IDS_AVAILABLE_CMDLINE_OPTIONS_TR, "\nMevcut komut satr seenekleri:\n\n" },

/* en */ { IDS_ATTACH_4_8_16KB_AT_2000,    "Attach 4/8/16KB cartridge image at $2000" },
/* da */ { IDS_ATTACH_4_8_16KB_AT_2000_DA, "Tilslut 4/8/16kB-cartridge image p $2000" },
/* de */ { IDS_ATTACH_4_8_16KB_AT_2000_DE, "4/8/16KB Modul Image bei $2000 einlegen" },
/* es */ { IDS_ATTACH_4_8_16KB_AT_2000_ES, "Insertar 4/8/16KB imagen cartucho en $2000" },
/* fr */ { IDS_ATTACH_4_8_16KB_AT_2000_FR, "Insertion d'une image 4/8/16 ko  $2000" },
/* hu */ { IDS_ATTACH_4_8_16KB_AT_2000_HU, "4/8/16KB kpms csatolsa $2000 cmre" },
/* it */ { IDS_ATTACH_4_8_16KB_AT_2000_IT, "Seleziona immagine cartuccia di 4/8/16KB a $2000" },
/* ko */ { IDS_ATTACH_4_8_16KB_AT_2000_KO, "4/8/16KB īƮ ̹   $2000  ̱" },
/* nl */ { IDS_ATTACH_4_8_16KB_AT_2000_NL, "Koppel 4/8/16KB bestand op $2000" },
/* pl */ { IDS_ATTACH_4_8_16KB_AT_2000_PL, "Wsu 4/8/16KB obraz w $2000" },
/* ru */ { IDS_ATTACH_4_8_16KB_AT_2000_RU, "Attach 4/8/16KB cartridge image at $2000" },
/* sv */ { IDS_ATTACH_4_8_16KB_AT_2000_SV, "Anslut 4/8/16KB-modulfil vid $2000" },
/* tr */ { IDS_ATTACH_4_8_16KB_AT_2000_TR, "$2000 adresine 4/8/16KB kartu imaj yerletir" },

/* en */ { IDS_ATTACH_4_8_16KB_AT_4000,    "Attach 4/8/16KB cartridge image at $4000" },
/* da */ { IDS_ATTACH_4_8_16KB_AT_4000_DA, "Tilslut 4/8/16kB-cartridge image p $4000" },
/* de */ { IDS_ATTACH_4_8_16KB_AT_4000_DE, "4/8/16KB Modul Image bei $4000 einlegen" },
/* es */ { IDS_ATTACH_4_8_16KB_AT_4000_ES, "Insertar 4/8/16KB imagen cartucho en $4000" },
/* fr */ { IDS_ATTACH_4_8_16KB_AT_4000_FR, "Insertion d'une image 4/8/16 ko  $4000" },
/* hu */ { IDS_ATTACH_4_8_16KB_AT_4000_HU, "4/8/16KB kpms csatolsa $4000 cmre" },
/* it */ { IDS_ATTACH_4_8_16KB_AT_4000_IT, "Seleziona immagine cartuccia di 4/8/16KB a $4000" },
/* ko */ { IDS_ATTACH_4_8_16KB_AT_4000_KO, "4/8/16KB īƮ ̹   $4000  ̱" },
/* nl */ { IDS_ATTACH_4_8_16KB_AT_4000_NL, "Koppel 4/8/16KB bestand op $4000" },
/* pl */ { IDS_ATTACH_4_8_16KB_AT_4000_PL, "Wsu 4/8/16KB obraz w $4000" },
/* ru */ { IDS_ATTACH_4_8_16KB_AT_4000_RU, "Attach 4/8/16KB cartridge image at $4000" },
/* sv */ { IDS_ATTACH_4_8_16KB_AT_4000_SV, "Anslut 4/8/16KB-modulfil vid $4000" },
/* tr */ { IDS_ATTACH_4_8_16KB_AT_4000_TR, "$4000 adresine 4/8/16KB kartu imaj yerletir" },

/* en */ { IDS_ATTACH_4_8_16KB_AT_6000,    "Attach 4/8/16KB cartridge image at $6000" },
/* da */ { IDS_ATTACH_4_8_16KB_AT_6000_DA, "Tilslut 4/8/16kB-cartridge image p $6000" },
/* de */ { IDS_ATTACH_4_8_16KB_AT_6000_DE, "4/8/16KB Modul Image bei $6000 einlegen" },
/* es */ { IDS_ATTACH_4_8_16KB_AT_6000_ES, "Insertar 4/8/16KB imagen cartucho en $6000" },
/* fr */ { IDS_ATTACH_4_8_16KB_AT_6000_FR, "Insertion d'une image 4/8/16 ko  $6000" },
/* hu */ { IDS_ATTACH_4_8_16KB_AT_6000_HU, "4/8/16KB kpms csatolsa $6000 cmre" },
/* it */ { IDS_ATTACH_4_8_16KB_AT_6000_IT, "Seleziona immagine cartuccia di 4/8/16KB a $6000" },
/* ko */ { IDS_ATTACH_4_8_16KB_AT_6000_KO, "4/8/16KB īƮ ̹   $6000  ̱" },
/* nl */ { IDS_ATTACH_4_8_16KB_AT_6000_NL, "Koppel 4/8/16KB bestand op $6000" },
/* pl */ { IDS_ATTACH_4_8_16KB_AT_6000_PL, "Wsu 4/8/16KB obraz w $6000" },
/* ru */ { IDS_ATTACH_4_8_16KB_AT_6000_RU, "Attach 4/8/16KB cartridge image at $6000" },
/* sv */ { IDS_ATTACH_4_8_16KB_AT_6000_SV, "Anslut 4/8/16KB-modulfil vid $6000" },
/* tr */ { IDS_ATTACH_4_8_16KB_AT_6000_TR, "$6000 adresine 4/8/16KB kartu imaj yerletir" },

/* en */ { IDS_ATTACH_4_8KB_AT_A000,    "Attach 4/8KB cartridge image at $A000" },
/* da */ { IDS_ATTACH_4_8KB_AT_A000_DA, "Tilslut 4/8kB-cartridge image p $A000" },
/* de */ { IDS_ATTACH_4_8KB_AT_A000_DE, "4/8KB Modul Image bei $A000 einlegen" },
/* es */ { IDS_ATTACH_4_8KB_AT_A000_ES, "Insertar 4/8KB imagen cartucho en $A000" },
/* fr */ { IDS_ATTACH_4_8KB_AT_A000_FR, "Insertion d'une image 4/8 ko  $A000" },
/* hu */ { IDS_ATTACH_4_8KB_AT_A000_HU, "4/8KB kpms csatolsa $A000 cmre" },
/* it */ { IDS_ATTACH_4_8KB_AT_A000_IT, "Seleziona immagine cartuccia di 4/8KB a $A000" },
/* ko */ { IDS_ATTACH_4_8KB_AT_A000_KO, "4/8KB īƮ ̹   $A000  ̱" },
/* nl */ { IDS_ATTACH_4_8KB_AT_A000_NL, "Koppel 4/8KB bestand op $A000" },
/* pl */ { IDS_ATTACH_4_8KB_AT_A000_PL, "Wsu 4/8KB obraz w $A000" },
/* ru */ { IDS_ATTACH_4_8KB_AT_A000_RU, "Attach 4/8KB cartridge image at $A000" },
/* sv */ { IDS_ATTACH_4_8KB_AT_A000_SV, "Anslut 4/8KB-modulfil vid $A000" },
/* tr */ { IDS_ATTACH_4_8KB_AT_A000_TR, "$A000 adresine 4/8KB kartu imaj yerletir" },

/* en */ { IDS_ATTACH_4KB_AT_B000,    "Attach 4KB cartridge image at $B000" },
/* da */ { IDS_ATTACH_4KB_AT_B000_DA, "Tilslut 4kB-cartridge image p $B000" },
/* de */ { IDS_ATTACH_4KB_AT_B000_DE, "4KB Modul Image bei $B000 einlegen" },
/* es */ { IDS_ATTACH_4KB_AT_B000_ES, "Insertar 4KB imagen cartucho en $B000" },
/* fr */ { IDS_ATTACH_4KB_AT_B000_FR, "Insertion d'une image 4 ko  $B000" },
/* hu */ { IDS_ATTACH_4KB_AT_B000_HU, "4KB kpms csatolsa $B000 cmre" },
/* it */ { IDS_ATTACH_4KB_AT_B000_IT, "Seleziona immagine cartuccia di 4KB a $B000" },
/* ko */ { IDS_ATTACH_4KB_AT_B000_KO, "4KB īƮ ̹   $B000  ̱" },
/* nl */ { IDS_ATTACH_4KB_AT_B000_NL, "Koppel 4KB bestand op $B000" },
/* pl */ { IDS_ATTACH_4KB_AT_B000_PL, "Wsu 4KB obraz w $B000" },
/* ru */ { IDS_ATTACH_4KB_AT_B000_RU, "Attach 4KB cartridge image at $B000" },
/* sv */ { IDS_ATTACH_4KB_AT_B000_SV, "Anslut 4KB-modulfil vid $B000" },
/* tr */ { IDS_ATTACH_4KB_AT_B000_TR, "$B000 adresine 4KB kartu imaj yerletir" },

/* en */ { IDS_S_AT_D_SPEED,    "%s at %d%% speed, %d fps%s" },
/* da */ { IDS_S_AT_D_SPEED_DA, "%s med %d%% hastighed, %d b/s%s" },
/* de */ { IDS_S_AT_D_SPEED_DE, "%s bei %d%% Geschwindigkeit, %d fps%s" },
/* es */ { IDS_S_AT_D_SPEED_ES, "%s a %d%% velocidad, %d fps%s" },
/* fr */ { IDS_S_AT_D_SPEED_FR, "%s  %d%% de vitesse et %d ips%s" },
/* hu */ { IDS_S_AT_D_SPEED_HU, "%s %d%% sebessgen, %d fps%s" },
/* it */ { IDS_S_AT_D_SPEED_IT, "velocit %s al %d%%, %d fps%s" },
/* ko */ { IDS_S_AT_D_SPEED_KO, "%s  %d%% ǵ, %d fps%s" },
/* nl */ { IDS_S_AT_D_SPEED_NL, "%s met %d%% snelheid, %d fps%s" },
/* pl */ { IDS_S_AT_D_SPEED_PL, "%s, prdko %d%%, %d fps%s" },
/* ru */ { IDS_S_AT_D_SPEED_RU, "%s at %d%% speed, %d fps%s" },
/* sv */ { IDS_S_AT_D_SPEED_SV, "%s med %d%% hastighet, %d b/s%s" },
/* tr */ { IDS_S_AT_D_SPEED_TR, "%s %d%% hznda, %d fps%s" },

/* en */ { IDS_ATTACH,    "Attach" },
/* da */ { IDS_ATTACH_DA, "Tilslut" },
/* de */ { IDS_ATTACH_DE, "Einlegen" },
/* es */ { IDS_ATTACH_ES, "Insertar" },
/* fr */ { IDS_ATTACH_FR, "Insrer" },
/* hu */ { IDS_ATTACH_HU, "Csatols" },
/* it */ { IDS_ATTACH_IT, "Seleziona" },
/* ko */ { IDS_ATTACH_KO, "̴" },
/* nl */ { IDS_ATTACH_NL, "Koppel" },
/* pl */ { IDS_ATTACH_PL, "Zamontuj" },
/* ru */ { IDS_ATTACH_RU, "Attach" },
/* sv */ { IDS_ATTACH_SV, "Anslut" },
/* tr */ { IDS_ATTACH_TR, "Yerletir" },

/* en */ { IDS_PARENT,    "Parent" },
/* da */ { IDS_PARENT_DA, "Forlder" },
/* de */ { IDS_PARENT_DE, "Vorgnger" },
/* es */ { IDS_PARENT_ES, "Padre" },
/* fr */ { IDS_PARENT_FR, "Parent" },
/* hu */ { IDS_PARENT_HU, "Szl" },
/* it */ { IDS_PARENT_IT, "Su" },
/* ko */ { IDS_PARENT_KO, "θ" },
/* nl */ { IDS_PARENT_NL, "Bevenliggende directory" },
/* pl */ { IDS_PARENT_PL, "Nadrzdny" },
/* ru */ { IDS_PARENT_RU, "Parent" },
/* sv */ { IDS_PARENT_SV, "Frlder" },
/* tr */ { IDS_PARENT_TR, "st e" },

/* en */ { IDS_ATTACH_READ_ONLY,    "Attach read only" },
/* da */ { IDS_ATTACH_READ_ONLY_DA, "Tilslut skrivebeskyttet" },
/* de */ { IDS_ATTACH_READ_ONLY_DE, "Schreibgeschtzt einlegen" },
/* es */ { IDS_ATTACH_READ_ONLY_ES, "Inserta slo lectura" },
/* fr */ { IDS_ATTACH_READ_ONLY_FR, "Insrer en lecture seule" },
/* hu */ { IDS_ATTACH_READ_ONLY_HU, "Csatols csak olvashat mdon" },
/* it */ { IDS_ATTACH_READ_ONLY_IT, "Seleziona in sola lettura" },
/* ko */ { IDS_ATTACH_READ_ONLY_KO, "" },  /* fuzzy */
/* nl */ { IDS_ATTACH_READ_ONLY_NL, "Alleen lezen" },
/* pl */ { IDS_ATTACH_READ_ONLY_PL, "Zamontuj tylko do odczytu" },
/* ru */ { IDS_ATTACH_READ_ONLY_RU, "Attach read only" },
/* sv */ { IDS_ATTACH_READ_ONLY_SV, "Anslut skrivskyddat" },
/* tr */ { IDS_ATTACH_READ_ONLY_TR, "Salt okunur yerletir" },

/* en */ { IDS_NAME,    "Name" },
/* da */ { IDS_NAME_DA, "Navn" },
/* de */ { IDS_NAME_DE, "Name" },
/* es */ { IDS_NAME_ES, "Nombre" },
/* fr */ { IDS_NAME_FR, "Nom" },
/* hu */ { IDS_NAME_HU, "Nv" },
/* it */ { IDS_NAME_IT, "Nome" },
/* ko */ { IDS_NAME_KO, "̸" },
/* nl */ { IDS_NAME_NL, "Naam" },
/* pl */ { IDS_NAME_PL, "Nazwa" },
/* ru */ { IDS_NAME_RU, "" },
/* sv */ { IDS_NAME_SV, "Namn" },
/* tr */ { IDS_NAME_TR, "sim" },

/* en */ { IDS_CREATE_IMAGE,    "Create Image" },
/* da */ { IDS_CREATE_IMAGE_DA, "Opret image" },
/* de */ { IDS_CREATE_IMAGE_DE, "Image Datei erzeugen" },
/* es */ { IDS_CREATE_IMAGE_ES, "Crear imagen" },
/* fr */ { IDS_CREATE_IMAGE_FR, "Cration d'image" },
/* hu */ { IDS_CREATE_IMAGE_HU, "Kpms ltrehozsa" },
/* it */ { IDS_CREATE_IMAGE_IT, "Crea immagine" },
/* ko */ { IDS_CREATE_IMAGE_KO, "̹ " },
/* nl */ { IDS_CREATE_IMAGE_NL, "Maak Bestand" },
/* pl */ { IDS_CREATE_IMAGE_PL, "Utwrz obraz" },
/* ru */ { IDS_CREATE_IMAGE_RU, "Create Image" },
/* sv */ { IDS_CREATE_IMAGE_SV, "Skapa avbildning" },
/* tr */ { IDS_CREATE_IMAGE_TR, "Imaj Yarat" },

/* en */ { IDS_NEW_IMAGE,    "New Image" },
/* da */ { IDS_NEW_IMAGE_DA, "Nyt image" },
/* de */ { IDS_NEW_IMAGE_DE, "Neue Image Datei" },
/* es */ { IDS_NEW_IMAGE_ES, "Nueva imagen" },
/* fr */ { IDS_NEW_IMAGE_FR, "Nouvelle image" },
/* hu */ { IDS_NEW_IMAGE_HU, "j kpms" },
/* it */ { IDS_NEW_IMAGE_IT, "Nuova immagine" },
/* ko */ { IDS_NEW_IMAGE_KO, "ο ̹" },
/* nl */ { IDS_NEW_IMAGE_NL, "Nieuw Bestand" },
/* pl */ { IDS_NEW_IMAGE_PL, "Nowy obraz" },
/* ru */ { IDS_NEW_IMAGE_RU, "New Image" },
/* sv */ { IDS_NEW_IMAGE_SV, "Ny avbildning" },
/* tr */ { IDS_NEW_IMAGE_TR, "Yeni maj" },

/* en */ { IDS_NEW_TAP_IMAGE,    "New TAP Image" },
/* da */ { IDS_NEW_TAP_IMAGE_DA, "Nyt TAP-image" },
/* de */ { IDS_NEW_TAP_IMAGE_DE, "Neue TAP Image Datei" },
/* es */ { IDS_NEW_TAP_IMAGE_ES, "Nueva imagen TAP" },
/* fr */ { IDS_NEW_TAP_IMAGE_FR, "Nouvelle image TAP" },
/* hu */ { IDS_NEW_TAP_IMAGE_HU, "j TAP kpms" },
/* it */ { IDS_NEW_TAP_IMAGE_IT, "Nuova immagine TAP" },
/* ko */ { IDS_NEW_TAP_IMAGE_KO, "ο TAP ̹" },
/* nl */ { IDS_NEW_TAP_IMAGE_NL, "Nieuw TAP bestand" },
/* pl */ { IDS_NEW_TAP_IMAGE_PL, "Obraz New TAP" },
/* ru */ { IDS_NEW_TAP_IMAGE_RU, "New TAP Image" },
/* sv */ { IDS_NEW_TAP_IMAGE_SV, "Ny TAP-avbildning" },
/* tr */ { IDS_NEW_TAP_IMAGE_TR, "Yeni TAP Imaj" },

/* en */ { IDS_OVERWRITE_EXISTING_IMAGE,    "Overwrite existing image?" },
/* da */ { IDS_OVERWRITE_EXISTING_IMAGE_DA, "Overskriv eksisterende image?" },
/* de */ { IDS_OVERWRITE_EXISTING_IMAGE_DE, "Existierende Datei berschreiben?" },
/* es */ { IDS_OVERWRITE_EXISTING_IMAGE_ES, "Sobrescribo la imagen actual?" },
/* fr */ { IDS_OVERWRITE_EXISTING_IMAGE_FR, "craser les images existantes?" },
/* hu */ { IDS_OVERWRITE_EXISTING_IMAGE_HU, "Fellrjam a meglv kpmst?" },
/* it */ { IDS_OVERWRITE_EXISTING_IMAGE_IT, "Sovrascrivo l'immagine esistente?" },
/* ko */ { IDS_OVERWRITE_EXISTING_IMAGE_KO, " ̹   ұ?" },
/* nl */ { IDS_OVERWRITE_EXISTING_IMAGE_NL, "Bestaand bestand overschrijven?" },
/* pl */ { IDS_OVERWRITE_EXISTING_IMAGE_PL, "Nadpisa istniejcy obraz?" },
/* ru */ { IDS_OVERWRITE_EXISTING_IMAGE_RU, "  ?" },
/* sv */ { IDS_OVERWRITE_EXISTING_IMAGE_SV, "Skriva ver existerande avbildning?" },
/* tr */ { IDS_OVERWRITE_EXISTING_IMAGE_TR, "Varolan imajn zerine yazlsn m?" },

/* en */ { IDS_ABOUT,    "About VICE" },
/* da */ { IDS_ABOUT_DA, "Om VICE" },
/* de */ { IDS_ABOUT_DE, "ber VICE" },
/* es */ { IDS_ABOUT_ES, "Acerca de VICE" },
/* fr */ { IDS_ABOUT_FR, " propos de VICE" },
/* hu */ { IDS_ABOUT_HU, "A VICE nvjegye" },
/* it */ { IDS_ABOUT_IT, "Informazioni su VICE" },
/* ko */ { IDS_ABOUT_KO, " VICE" },
/* nl */ { IDS_ABOUT_NL, "Over VICE" },
/* pl */ { IDS_ABOUT_PL, "O VICE" },
/* ru */ { IDS_ABOUT_RU, "  VICE" },
/* sv */ { IDS_ABOUT_SV, "Om VICE" },
/* tr */ { IDS_ABOUT_TR, "VICE Hakknda" },

/* en */ { IDS_IMAGE_CONTENTS,    "Image Contents" },
/* da */ { IDS_IMAGE_CONTENTS_DA, "Indhold i image" },
/* de */ { IDS_IMAGE_CONTENTS_DE, "Image Datei Inhalt" },
/* es */ { IDS_IMAGE_CONTENTS_ES, "Contenidos imagen" },
/* fr */ { IDS_IMAGE_CONTENTS_FR, "Contenu de l'image" },
/* hu */ { IDS_IMAGE_CONTENTS_HU, "Tartalom" },
/* it */ { IDS_IMAGE_CONTENTS_IT, "Contenuti immagine" },
/* ko */ { IDS_IMAGE_CONTENTS_KO, "̹ " },
/* nl */ { IDS_IMAGE_CONTENTS_NL, "bestandsinhoud" },
/* pl */ { IDS_IMAGE_CONTENTS_PL, "Zawarto obrazu" },
/* ru */ { IDS_IMAGE_CONTENTS_RU, "Image Contents" },
/* sv */ { IDS_IMAGE_CONTENTS_SV, "Innehll i avbildning" },
/* tr */ { IDS_IMAGE_CONTENTS_TR, "Imaj erii" },

/* en */ { IDMS_DISABLED,    "Disabled" },
/* da */ { IDMS_DISABLED_DA, "Deaktiveret" },
/* de */ { IDMS_DISABLED_DE, "Deaktiviert" },
/* es */ { IDMS_DISABLED_ES, "Deshabilitado" },
/* fr */ { IDMS_DISABLED_FR, "Dsactiv" },
/* hu */ { IDMS_DISABLED_HU, "Tiltva" },
/* it */ { IDMS_DISABLED_IT, "Disattivo" },
/* ko */ { IDMS_DISABLED_KO, "۵" },
/* nl */ { IDMS_DISABLED_NL, "Uit" },
/* pl */ { IDMS_DISABLED_PL, "Wycz" },
/* ru */ { IDMS_DISABLED_RU, "Disabled" },
/* sv */ { IDMS_DISABLED_SV, "Inaktiverad" },
/* tr */ { IDMS_DISABLED_TR, "Pasif" },

/* en */ { IDS_ENABLED,    "Enabled" },
/* da */ { IDS_ENABLED_DA, "Aktiveret" },
/* de */ { IDS_ENABLED_DE, "Aktiviert" },
/* es */ { IDS_ENABLED_ES, "Habilitado" },
/* fr */ { IDS_ENABLED_FR, "Activ" },
/* hu */ { IDS_ENABLED_HU, "Engedlyezve" },
/* it */ { IDS_ENABLED_IT, "Attivato" },
/* ko */ { IDS_ENABLED_KO, "۵" },
/* nl */ { IDS_ENABLED_NL, "Aan" },
/* pl */ { IDS_ENABLED_PL, "Wcz" },
/* ru */ { IDS_ENABLED_RU, "Enabled" },
/* sv */ { IDS_ENABLED_SV, "Aktiverad" },
/* tr */ { IDS_ENABLED_TR, "Aktif" },

/* en */ { IDS_RS232_DEVICE_1,    "RS232 device 1" },
/* da */ { IDS_RS232_DEVICE_1_DA, "RS232-enhed 1" },
/* de */ { IDS_RS232_DEVICE_1_DE, "RS232 Gert 1" },
/* es */ { IDS_RS232_DEVICE_1_ES, "Perifrico RS232 1" },
/* fr */ { IDS_RS232_DEVICE_1_FR, "1er Priphrique RS232" },
/* hu */ { IDS_RS232_DEVICE_1_HU, "RS232 1-es eszkz" },
/* it */ { IDS_RS232_DEVICE_1_IT, "Dispositivo RS232 #1" },
/* ko */ { IDS_RS232_DEVICE_1_KO, "RS232 ̽ 1" },
/* nl */ { IDS_RS232_DEVICE_1_NL, "RS232 apparaat 1" },
/* pl */ { IDS_RS232_DEVICE_1_PL, "Urzdzenie RS232 1" },
/* ru */ { IDS_RS232_DEVICE_1_RU, "RS232 device 1" },
/* sv */ { IDS_RS232_DEVICE_1_SV, "RS232-enhet 1" },
/* tr */ { IDS_RS232_DEVICE_1_TR, "RS232 aygt 1" },

/* en */ { IDS_RS232_DEVICE_2,    "RS232 device 2" },
/* da */ { IDS_RS232_DEVICE_2_DA, "RS232-enhed 2" },
/* de */ { IDS_RS232_DEVICE_2_DE, "RS232 Gert 2" },
/* es */ { IDS_RS232_DEVICE_2_ES, "Perifrico RS232 2" },
/* fr */ { IDS_RS232_DEVICE_2_FR, "2e Priphrique RS232" },
/* hu */ { IDS_RS232_DEVICE_2_HU, "RS232 2-es eszkz" },
/* it */ { IDS_RS232_DEVICE_2_IT, "Dispositivo RS232 #2" },
/* ko */ { IDS_RS232_DEVICE_2_KO, "RS232 ̽ 2" },
/* nl */ { IDS_RS232_DEVICE_2_NL, "RS232 apparaat 2" },
/* pl */ { IDS_RS232_DEVICE_2_PL, "Urzdzenie RS232 2" },
/* ru */ { IDS_RS232_DEVICE_2_RU, "RS232 device 2" },
/* sv */ { IDS_RS232_DEVICE_2_SV, "RS232-enhet 2" },
/* tr */ { IDS_RS232_DEVICE_2_TR, "RS232 aygt 2" },

/* en */ { IDS_RS232_DEVICE_3,    "RS232 device 3" },
/* da */ { IDS_RS232_DEVICE_3_DA, "RS232-enhed 3" },
/* de */ { IDS_RS232_DEVICE_3_DE, "RS232 Gert 3" },
/* es */ { IDS_RS232_DEVICE_3_ES, "Perifrico RS232 3" },
/* fr */ { IDS_RS232_DEVICE_3_FR, "3e Priphrique RS232" },
/* hu */ { IDS_RS232_DEVICE_3_HU, "RS232 3-as eszkz" },
/* it */ { IDS_RS232_DEVICE_3_IT, "Dispositivo RS232 #3" },
/* ko */ { IDS_RS232_DEVICE_3_KO, "RS232 ̽ 3" },
/* nl */ { IDS_RS232_DEVICE_3_NL, "RS232 apparaat 3" },
/* pl */ { IDS_RS232_DEVICE_3_PL, "Urzdzenie RS232 3" },
/* ru */ { IDS_RS232_DEVICE_3_RU, "RS232 device 3" },
/* sv */ { IDS_RS232_DEVICE_3_SV, "RS232-enhet 3" },
/* tr */ { IDS_RS232_DEVICE_3_TR, "RS232 aygt 3" },

/* en */ { IDS_RS232_DEVICE_4,    "RS232 device 4" },
/* da */ { IDS_RS232_DEVICE_4_DA, "RS232-enhed 4" },
/* de */ { IDS_RS232_DEVICE_4_DE, "RS232 Gert 4" },
/* es */ { IDS_RS232_DEVICE_4_ES, "Perifrico RS232 4" },
/* fr */ { IDS_RS232_DEVICE_4_FR, "4e Priphrique RS232" },
/* hu */ { IDS_RS232_DEVICE_4_HU, "RS232 4-es eszkz" },
/* it */ { IDS_RS232_DEVICE_4_IT, "Dispositivo RS232 #4" },
/* ko */ { IDS_RS232_DEVICE_4_KO, "RS232 ̽ 4" },
/* nl */ { IDS_RS232_DEVICE_4_NL, "RS232 apparaat 4" },
/* pl */ { IDS_RS232_DEVICE_4_PL, "Urzdzenie RS232 4" },
/* ru */ { IDS_RS232_DEVICE_4_RU, "RS232 device 4" },
/* sv */ { IDS_RS232_DEVICE_4_SV, "RS232-enhet 4" },
/* tr */ { IDS_RS232_DEVICE_4_TR, "RS232 aygt 4" },

/* en */ { IDS_NONE,    "None" },
/* da */ { IDS_NONE_DA, "Ingen" },
/* de */ { IDS_NONE_DE, "Kein" },
/* es */ { IDS_NONE_ES, "No" },
/* fr */ { IDS_NONE_FR, "Aucun" },
/* hu */ { IDS_NONE_HU, "Nincs" },
/* it */ { IDS_NONE_IT, "Nessuno" },
/* ko */ { IDS_NONE_KO, "" },
/* nl */ { IDS_NONE_NL, "Geen" },
/* pl */ { IDS_NONE_PL, "Brak" },
/* ru */ { IDS_NONE_RU, "None" },
/* sv */ { IDS_NONE_SV, "Ingen" },
/* tr */ { IDS_NONE_TR, "Yok" },

/* en */ { IDS_STANDARD,    "Standard" },
/* da */ { IDS_STANDARD_DA, "Standard" },
/* de */ { IDS_STANDARD_DE, "Standard" },
/* es */ { IDS_STANDARD_ES, "Estandar" },
/* fr */ { IDS_STANDARD_FR, "Standard" },
/* hu */ { IDS_STANDARD_HU, "" },  /* fuzzy */
/* it */ { IDS_STANDARD_IT, "Standard" },
/* ko */ { IDS_STANDARD_KO, "" },  /* fuzzy */
/* nl */ { IDS_STANDARD_NL, "Standaard" },
/* pl */ { IDS_STANDARD_PL, "Standard" },
/* ru */ { IDS_STANDARD_RU, "" },  /* fuzzy */
/* sv */ { IDS_STANDARD_SV, "Standard" },
/* tr */ { IDS_STANDARD_TR, "Standart" },

/* en */ { IDS_DD3,    "Dolphin Dos 3" },
/* da */ { IDS_DD3_DA, "Dolphin DOS 3" },
/* de */ { IDS_DD3_DE, "Dolphin Dos 3" },
/* es */ { IDS_DD3_ES, "Dolphin DOS 3" },
/* fr */ { IDS_DD3_FR, "Dolphin DOS 3" },
/* hu */ { IDS_DD3_HU, "" },  /* fuzzy */
/* it */ { IDS_DD3_IT, "Dolphin Dos 3" },
/* ko */ { IDS_DD3_KO, "" },  /* fuzzy */
/* nl */ { IDS_DD3_NL, "Dolphin DOS 3" },
/* pl */ { IDS_DD3_PL, "Dolphin Dos 3" },
/* ru */ { IDS_DD3_RU, "" },  /* fuzzy */
/* sv */ { IDS_DD3_SV, "Dolphin Dos 3" },
/* tr */ { IDS_DD3_TR, "Dolphin Dos 3" },

/* en */ { IDS_FORMEL64,    "Formel64" },
/* da */ { IDS_FORMEL64_DA, "Formel64" },
/* de */ { IDS_FORMEL64_DE, "Formel64" },
/* es */ { IDS_FORMEL64_ES, "Formel 64" },
/* fr */ { IDS_FORMEL64_FR, "Formel64" },
/* hu */ { IDS_FORMEL64_HU, "" },  /* fuzzy */
/* it */ { IDS_FORMEL64_IT, "Formel64" },
/* ko */ { IDS_FORMEL64_KO, "" },  /* fuzzy */
/* nl */ { IDS_FORMEL64_NL, "Formel64" },
/* pl */ { IDS_FORMEL64_PL, "Formel64" },
/* ru */ { IDS_FORMEL64_RU, "Formel64" },
/* sv */ { IDS_FORMEL64_SV, "Formel64" },
/* tr */ { IDS_FORMEL64_TR, "Formel64" },

/* en */ { IDS_FILESYSTEM,    "Filesystem" },
/* da */ { IDS_FILESYSTEM_DA, "Filsystem" },
/* de */ { IDS_FILESYSTEM_DE, "Dateisystem" },
/* es */ { IDS_FILESYSTEM_ES, "Sistema de ficheros" },
/* fr */ { IDS_FILESYSTEM_FR, "Systme de fichiers" },
/* hu */ { IDS_FILESYSTEM_HU, "" },  /* fuzzy */
/* it */ { IDS_FILESYSTEM_IT, "Filesystem" },
/* ko */ { IDS_FILESYSTEM_KO, "Ͻý" },
/* nl */ { IDS_FILESYSTEM_NL, "Bestandssysteem" },
/* pl */ { IDS_FILESYSTEM_PL, "System plikw" },
/* ru */ { IDS_FILESYSTEM_RU, " " },
/* sv */ { IDS_FILESYSTEM_SV, "Filsystem" },
/* tr */ { IDS_FILESYSTEM_TR, "Dosya sistemi" },

/* en */ { IDS_RAW,    "Raw" },
/* da */ { IDS_RAW_DA, "R" },
/* de */ { IDS_RAW_DE, "Raw" },
/* es */ { IDS_RAW_ES, "Sin formato" },
/* fr */ { IDS_RAW_FR, "Raw" },
/* hu */ { IDS_RAW_HU, "" },  /* fuzzy */
/* it */ { IDS_RAW_IT, "Raw" },
/* ko */ { IDS_RAW_KO, "Raw" },
/* nl */ { IDS_RAW_NL, "Raw" },
/* pl */ { IDS_RAW_PL, "Surowy" },
/* ru */ { IDS_RAW_RU, "Raw" },
/* sv */ { IDS_RAW_SV, "Rtt" },
/* tr */ { IDS_RAW_TR, "Dz" },

/* en */ { IDS_JOYSTICK,    "Joystick" },
/* da */ { IDS_JOYSTICK_DA, "Joystick" },
/* de */ { IDS_JOYSTICK_DE, "Joystick" },
/* es */ { IDS_JOYSTICK_ES, "Joystick" },
/* fr */ { IDS_JOYSTICK_FR, "Joystick" },
/* hu */ { IDS_JOYSTICK_HU, "Botkormny" },
/* it */ { IDS_JOYSTICK_IT, "Joystick" },
/* ko */ { IDS_JOYSTICK_KO, "̽ƽ" },
/* nl */ { IDS_JOYSTICK_NL, "Joystick" },
/* pl */ { IDS_JOYSTICK_PL, "Joystick" },
/* ru */ { IDS_JOYSTICK_RU, "" },
/* sv */ { IDS_JOYSTICK_SV, "Styrspak" },
/* tr */ { IDS_JOYSTICK_TR, "Joystick" },

/* en */ { IDS_IRQ,    "IRQ" },
/* da */ { IDS_IRQ_DA, "IRQ" },
/* de */ { IDS_IRQ_DE, "IRQ" },
/* es */ { IDS_IRQ_ES, "IRQ" },
/* fr */ { IDS_IRQ_FR, "IRQ" },
/* hu */ { IDS_IRQ_HU, "IRQ" },
/* it */ { IDS_IRQ_IT, "IRQ" },
/* ko */ { IDS_IRQ_KO, "IRQ" },
/* nl */ { IDS_IRQ_NL, "IRQ" },
/* pl */ { IDS_IRQ_PL, "IRQ" },
/* ru */ { IDS_IRQ_RU, "IRQ" },
/* sv */ { IDS_IRQ_SV, "IRQ" },
/* tr */ { IDS_IRQ_TR, "IRQ" },

/* en */ { IDS_NMI,    "NMI" },
/* da */ { IDS_NMI_DA, "NMI" },
/* de */ { IDS_NMI_DE, "NMI" },
/* es */ { IDS_NMI_ES, "NMI" },
/* fr */ { IDS_NMI_FR, "NMI" },
/* hu */ { IDS_NMI_HU, "NMI" },
/* it */ { IDS_NMI_IT, "NMI" },
/* ko */ { IDS_NMI_KO, "NMI" },
/* nl */ { IDS_NMI_NL, "NMI" },
/* pl */ { IDS_NMI_PL, "NMI" },
/* ru */ { IDS_NMI_RU, "NMI" },
/* sv */ { IDS_NMI_SV, "NMI" },
/* tr */ { IDS_NMI_TR, "NMI" },

/* en */ { IDS_ACIA_DEVICE,    "ACIA device" },
/* da */ { IDS_ACIA_DEVICE_DA, "ACIA-enhed" },
/* de */ { IDS_ACIA_DEVICE_DE, "ACIA Gert" },
/* es */ { IDS_ACIA_DEVICE_ES, "Perifrico ACIA" },
/* fr */ { IDS_ACIA_DEVICE_FR, "Priphrique ACIA" },
/* hu */ { IDS_ACIA_DEVICE_HU, "ACIA eszkz" },
/* it */ { IDS_ACIA_DEVICE_IT, "Dispositivo ACIA" },
/* ko */ { IDS_ACIA_DEVICE_KO, "" },  /* fuzzy */
/* nl */ { IDS_ACIA_DEVICE_NL, "ACIA apparaat" },
/* pl */ { IDS_ACIA_DEVICE_PL, "Urzdzenia ACIA" },
/* ru */ { IDS_ACIA_DEVICE_RU, "ACIA device" },
/* sv */ { IDS_ACIA_DEVICE_SV, "ACIA-enhet" },
/* tr */ { IDS_ACIA_DEVICE_TR, "ACIA aygt" },

/* en */ { IDS_ACIA_BASE,    "ACIA base address" },
/* da */ { IDS_ACIA_BASE_DA, "ACIA baseadresse" },
/* de */ { IDS_ACIA_BASE_DE, "ACIA Basis Adresse" },
/* es */ { IDS_ACIA_BASE_ES, "ACIA direccin base" },
/* fr */ { IDS_ACIA_BASE_FR, "Adresse de base ACIA" },
/* hu */ { IDS_ACIA_BASE_HU, "" },  /* fuzzy */
/* it */ { IDS_ACIA_BASE_IT, "indirizzo base ACIA" },
/* ko */ { IDS_ACIA_BASE_KO, "" },  /* fuzzy */
/* nl */ { IDS_ACIA_BASE_NL, "ACIA basisadres" },
/* pl */ { IDS_ACIA_BASE_PL, "Adres bazowy ACIA" },
/* ru */ { IDS_ACIA_BASE_RU, "" },  /* fuzzy */
/* sv */ { IDS_ACIA_BASE_SV, "ACIA-basadress" },
/* tr */ { IDS_ACIA_BASE_TR, "ACIA taban adresi" },

/* en */ { IDS_ACIA_INTERRUPT,    "ACIA interrupt" },
/* da */ { IDS_ACIA_INTERRUPT_DA, "ACIA-interrupt" },
/* de */ { IDS_ACIA_INTERRUPT_DE, "ACIA Interrupt" },
/* es */ { IDS_ACIA_INTERRUPT_ES, "Interruptor ACIA" },
/* fr */ { IDS_ACIA_INTERRUPT_FR, "Interruption ACIA" },
/* hu */ { IDS_ACIA_INTERRUPT_HU, "ACIA megszakts" },
/* it */ { IDS_ACIA_INTERRUPT_IT, "Interrupt ACIA" },
/* ko */ { IDS_ACIA_INTERRUPT_KO, "" },  /* fuzzy */
/* nl */ { IDS_ACIA_INTERRUPT_NL, "ACIA interrupt" },
/* pl */ { IDS_ACIA_INTERRUPT_PL, "Przerwanie ACIA" },
/* ru */ { IDS_ACIA_INTERRUPT_RU, "ACIA interrupt" },
/* sv */ { IDS_ACIA_INTERRUPT_SV, "ACIA-avbrott" },
/* tr */ { IDS_ACIA_INTERRUPT_TR, "ACIA kesmesi" },

/* en */ { IDS_ACIA_MODE,    "ACIA mode" },
/* da */ { IDS_ACIA_MODE_DA, "ACIA-tilstand" },
/* de */ { IDS_ACIA_MODE_DE, "ACIA Modus" },
/* es */ { IDS_ACIA_MODE_ES, "Modo ACIA" },
/* fr */ { IDS_ACIA_MODE_FR, "Mode ACIA" },
/* hu */ { IDS_ACIA_MODE_HU, "ACIA md" },
/* it */ { IDS_ACIA_MODE_IT, "Modalit ACIA" },
/* ko */ { IDS_ACIA_MODE_KO, "" },  /* fuzzy */
/* nl */ { IDS_ACIA_MODE_NL, "ACIA modus" },
/* pl */ { IDS_ACIA_MODE_PL, "Tryb ACIA" },
/* ru */ { IDS_ACIA_MODE_RU, "ACIA mode" },
/* sv */ { IDS_ACIA_MODE_SV, "ACIA-lge" },
/* tr */ { IDS_ACIA_MODE_TR, "ACIA modu" },

/* en */ { IDS_ACIA_SETTINGS,    "ACIA settings" },
/* da */ { IDS_ACIA_SETTINGS_DA, "ACIA-indstillinger" },
/* de */ { IDS_ACIA_SETTINGS_DE, "ACIA Einstellungen" },
/* es */ { IDS_ACIA_SETTINGS_ES, "Ajustes ACIA" },
/* fr */ { IDS_ACIA_SETTINGS_FR, "Paramtres ACIA" },
/* hu */ { IDS_ACIA_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_ACIA_SETTINGS_IT, "Impostazioni ACIA" },
/* ko */ { IDS_ACIA_SETTINGS_KO, "ACIA " },
/* nl */ { IDS_ACIA_SETTINGS_NL, "ACIA instellingen" },
/* pl */ { IDS_ACIA_SETTINGS_PL, "Ustawienia ACIA" },
/* ru */ { IDS_ACIA_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_ACIA_SETTINGS_SV, "ACIA-instllningar" },
/* tr */ { IDS_ACIA_SETTINGS_TR, "ACIA Ayarlar" },

/* en */ { IDS_256K_BASE,    "256K base address" },
/* da */ { IDS_256K_BASE_DA, "256k-baseadresse" },
/* de */ { IDS_256K_BASE_DE, "256K Basis Adresse" },
/* es */ { IDS_256K_BASE_ES, "Direccin base 256K" },
/* fr */ { IDS_256K_BASE_FR, "Adresse de base 256K" },
/* hu */ { IDS_256K_BASE_HU, "256K bziscm" },
/* it */ { IDS_256K_BASE_IT, "indirizzo base 256K" },
/* ko */ { IDS_256K_BASE_KO, "" },  /* fuzzy */
/* nl */ { IDS_256K_BASE_NL, "256K basisadres" },
/* pl */ { IDS_256K_BASE_PL, "Adres bazowy 256K" },
/* ru */ { IDS_256K_BASE_RU, "256K base address" },
/* sv */ { IDS_256K_BASE_SV, "256K-basadress" },
/* tr */ { IDS_256K_BASE_TR, "256K taban adresi" },

/* en */ { IDS_256K_FILENAME,    "256K file" },
/* da */ { IDS_256K_FILENAME_DA, "256k-fil" },
/* de */ { IDS_256K_FILENAME_DE, "256K Datei" },
/* es */ { IDS_256K_FILENAME_ES, "Fichero 256K" },
/* fr */ { IDS_256K_FILENAME_FR, "Fichier 256K" },
/* hu */ { IDS_256K_FILENAME_HU, "256K fjl" },
/* it */ { IDS_256K_FILENAME_IT, "File 256K" },
/* ko */ { IDS_256K_FILENAME_KO, "256k " },
/* nl */ { IDS_256K_FILENAME_NL, "256K bestand" },
/* pl */ { IDS_256K_FILENAME_PL, "Plik 256K" },
/* ru */ { IDS_256K_FILENAME_RU, "256K file" },
/* sv */ { IDS_256K_FILENAME_SV, "256K-fil" },
/* tr */ { IDS_256K_FILENAME_TR, "256K dosyas" },

/* en */ { IDS_256K_FILENAME_SELECT,    "Select file for 256K" },
/* da */ { IDS_256K_FILENAME_SELECT_DA, "Angiv fil for 256k" },
/* de */ { IDS_256K_FILENAME_SELECT_DE, "Datei fr 256K auswhlen" },
/* es */ { IDS_256K_FILENAME_SELECT_ES, "Seleccionar fichero para 256K" },
/* fr */ { IDS_256K_FILENAME_SELECT_FR, "Slectionner fichier pour 256K" },
/* hu */ { IDS_256K_FILENAME_SELECT_HU, "Vlasszon fjlt a 256K-hoz" },
/* it */ { IDS_256K_FILENAME_SELECT_IT, "Seleziona file per 256K" },
/* ko */ { IDS_256K_FILENAME_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_256K_FILENAME_SELECT_NL, "Selecteer bestand voor 256K" },
/* pl */ { IDS_256K_FILENAME_SELECT_PL, "Wybierz plik 256K" },
/* ru */ { IDS_256K_FILENAME_SELECT_RU, "Select file for 256K" },
/* sv */ { IDS_256K_FILENAME_SELECT_SV, "Ange fil fr 256K" },
/* tr */ { IDS_256K_FILENAME_SELECT_TR, "256K iin dosya sein" },

/* en */ { IDS_C64DTV_ROM_FILENAME_SELECT,    "Select file for C64DTV ROM" },
/* da */ { IDS_C64DTV_ROM_FILENAME_SELECT_DA, "Vlg fil for C64DTV-ROM" },
/* de */ { IDS_C64DTV_ROM_FILENAME_SELECT_DE, "Datei fr C64DTV ROM auswhlen" },
/* es */ { IDS_C64DTV_ROM_FILENAME_SELECT_ES, "Seleccionar fichero para C64DTV ROM" },
/* fr */ { IDS_C64DTV_ROM_FILENAME_SELECT_FR, "Slectionner fichier RO C64DTV" },
/* hu */ { IDS_C64DTV_ROM_FILENAME_SELECT_HU, "Vlasszon fjlt a C64DTV ROM-hoz" },
/* it */ { IDS_C64DTV_ROM_FILENAME_SELECT_IT, "Seleziona il file per la ROM C64DTV" },
/* ko */ { IDS_C64DTV_ROM_FILENAME_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_C64DTV_ROM_FILENAME_SELECT_NL, "Selecteer bestand voor C64DTV ROM" },
/* pl */ { IDS_C64DTV_ROM_FILENAME_SELECT_PL, "Wybierz plik ROM C64DTV" },
/* ru */ { IDS_C64DTV_ROM_FILENAME_SELECT_RU, "Select file for C64DTV ROM" },
/* sv */ { IDS_C64DTV_ROM_FILENAME_SELECT_SV, "Vlj fil fr C64DTV-ROM" },
/* tr */ { IDS_C64DTV_ROM_FILENAME_SELECT_TR, "C64DTV ROM'u iin dosya sein" },

/* en */ { IDS_C64DTV_ROM_FILENAME,    "C64DTV ROM file" },
/* da */ { IDS_C64DTV_ROM_FILENAME_DA, "C64DTV-ROM-fil" },
/* de */ { IDS_C64DTV_ROM_FILENAME_DE, "C64DTV ROM Datei" },
/* es */ { IDS_C64DTV_ROM_FILENAME_ES, "Fichero C64DTV ROM" },
/* fr */ { IDS_C64DTV_ROM_FILENAME_FR, "Fichier ROM C64DTV" },
/* hu */ { IDS_C64DTV_ROM_FILENAME_HU, "C64DTV ROM fjl" },
/* it */ { IDS_C64DTV_ROM_FILENAME_IT, "File ROM C64DTV" },
/* ko */ { IDS_C64DTV_ROM_FILENAME_KO, "C64DTV ROM " },
/* nl */ { IDS_C64DTV_ROM_FILENAME_NL, "C64DTV ROM bestand" },
/* pl */ { IDS_C64DTV_ROM_FILENAME_PL, "Plik ROM C64DTV" },
/* ru */ { IDS_C64DTV_ROM_FILENAME_RU, "C64DTV ROM file" },
/* sv */ { IDS_C64DTV_ROM_FILENAME_SV, "C64DTV-ROM-fil" },
/* tr */ { IDS_C64DTV_ROM_FILENAME_TR, "C64DTV ROM dosyas" },

/* en */ { IDS_C64DTV_REVISION,    "DTV revision" },
/* da */ { IDS_C64DTV_REVISION_DA, "DTV-revision" },
/* de */ { IDS_C64DTV_REVISION_DE, "DTV Revision" },
/* es */ { IDS_C64DTV_REVISION_ES, "Revisin DTV" },
/* fr */ { IDS_C64DTV_REVISION_FR, "Rvision DTV" },
/* hu */ { IDS_C64DTV_REVISION_HU, "" },  /* fuzzy */
/* it */ { IDS_C64DTV_REVISION_IT, "Revisione DTV" },
/* ko */ { IDS_C64DTV_REVISION_KO, "DTV " },
/* nl */ { IDS_C64DTV_REVISION_NL, "DTV revisie" },
/* pl */ { IDS_C64DTV_REVISION_PL, "Wersja DRV" },
/* ru */ { IDS_C64DTV_REVISION_RU, "DTV revision" },
/* sv */ { IDS_C64DTV_REVISION_SV, "DTV-utgva" },
/* tr */ { IDS_C64DTV_REVISION_TR, "DTV revizyonu" },

/* en */ { IDS_C64DTV_WRITE_ENABLE,    "Writes to C64DTV ROM" },
/* da */ { IDS_C64DTV_WRITE_ENABLE_DA, "Skrivning til C64DTV-ROM" },
/* de */ { IDS_C64DTV_WRITE_ENABLE_DE, "Schreibzugriff auf C64DTV ROM" },
/* es */ { IDS_C64DTV_WRITE_ENABLE_ES, "Escribir en C64DTV ROM" },
/* fr */ { IDS_C64DTV_WRITE_ENABLE_FR, "criture dans le ROM C64DTV" },
/* hu */ { IDS_C64DTV_WRITE_ENABLE_HU, "C64DTV ROM-ba rsok" },
/* it */ { IDS_C64DTV_WRITE_ENABLE_IT, "Scrivi sulla ROM C64DTV" },
/* ko */ { IDS_C64DTV_WRITE_ENABLE_KO, "" },  /* fuzzy */
/* nl */ { IDS_C64DTV_WRITE_ENABLE_NL, "Schrijven naar C64DTV ROM" },
/* pl */ { IDS_C64DTV_WRITE_ENABLE_PL, "Zapis do ROM-u C64DTV" },
/* ru */ { IDS_C64DTV_WRITE_ENABLE_RU, "Writes to C64DTV ROM" },
/* sv */ { IDS_C64DTV_WRITE_ENABLE_SV, "Skrivningar till C64DTV-ROM" },
/* tr */ { IDS_C64DTV_WRITE_ENABLE_TR, "C64DTV ROM'una yazar" },

/* en */ { IDS_C64DTV_HUMMER_ADC,    "Hummer ADC" },
/* da */ { IDS_C64DTV_HUMMER_ADC_DA, "Hummer ADC" },
/* de */ { IDS_C64DTV_HUMMER_ADC_DE, "Hummer ADC" },
/* es */ { IDS_C64DTV_HUMMER_ADC_ES, "Hummer ADC" },
/* fr */ { IDS_C64DTV_HUMMER_ADC_FR, "Hummer ADC" },
/* hu */ { IDS_C64DTV_HUMMER_ADC_HU, "" },  /* fuzzy */
/* it */ { IDS_C64DTV_HUMMER_ADC_IT, "Hummer ADC" },
/* ko */ { IDS_C64DTV_HUMMER_ADC_KO, " ADC" },
/* nl */ { IDS_C64DTV_HUMMER_ADC_NL, "Hummer ADC" },
/* pl */ { IDS_C64DTV_HUMMER_ADC_PL, "Hummer ADC" },
/* ru */ { IDS_C64DTV_HUMMER_ADC_RU, "Hummer ADC" },
/* sv */ { IDS_C64DTV_HUMMER_ADC_SV, "Hummer A/D-omvandlare" },
/* tr */ { IDS_C64DTV_HUMMER_ADC_TR, "Hummer ADC" },

/* en */ { IDS_C64DTV_SETTINGS,    "C64DTV settings" },
/* da */ { IDS_C64DTV_SETTINGS_DA, "C64DTV-indstillinger" },
/* de */ { IDS_C64DTV_SETTINGS_DE, "C64DTV Einstellungen" },
/* es */ { IDS_C64DTV_SETTINGS_ES, "Ajustes C64DTV" },
/* fr */ { IDS_C64DTV_SETTINGS_FR, "Paramtres C64DTV" },
/* hu */ { IDS_C64DTV_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_C64DTV_SETTINGS_IT, "Impostazioni C64DTV" },
/* ko */ { IDS_C64DTV_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_C64DTV_SETTINGS_NL, "C64DTV Instellingen" },
/* pl */ { IDS_C64DTV_SETTINGS_PL, "Ustawienia C64DTV" },
/* ru */ { IDS_C64DTV_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_C64DTV_SETTINGS_SV, "C64DTV-instllningar" },
/* tr */ { IDS_C64DTV_SETTINGS_TR, "C64DTV Ayarlar" },

/* en */ { IDS_MODEL_LINE,    "Model line" },
/* da */ { IDS_MODEL_LINE_DA, "Modelltyp" },
/* de */ { IDS_MODEL_LINE_DE, "Modell Linie" },
/* es */ { IDS_MODEL_LINE_ES, "Linea modelo" },
/* fr */ { IDS_MODEL_LINE_FR, "Ligne du modle" },
/* hu */ { IDS_MODEL_LINE_HU, "" },  /* fuzzy */
/* it */ { IDS_MODEL_LINE_IT, "Linea" },
/* ko */ { IDS_MODEL_LINE_KO, "" },  /* fuzzy */
/* nl */ { IDS_MODEL_LINE_NL, "Model lijn" },
/* pl */ { IDS_MODEL_LINE_PL, "Linia modelu" },
/* ru */ { IDS_MODEL_LINE_RU, "" },  /* fuzzy */
/* sv */ { IDS_MODEL_LINE_SV, "Modelltyp" },
/* tr */ { IDS_MODEL_LINE_TR, "Model hatt" },

/* en */ { IDS_RAM_SIZE,    "RAM size" },
/* da */ { IDS_RAM_SIZE_DA, "RAM-strrelse" },
/* de */ { IDS_RAM_SIZE_DE, "RAM Gre" },
/* es */ { IDS_RAM_SIZE_ES, "Tamao RAM" },
/* fr */ { IDS_RAM_SIZE_FR, "Taille de la RAM" },
/* hu */ { IDS_RAM_SIZE_HU, "" },  /* fuzzy */
/* it */ { IDS_RAM_SIZE_IT, "Dimensione RAM" },
/* ko */ { IDS_RAM_SIZE_KO, "" },  /* fuzzy */
/* nl */ { IDS_RAM_SIZE_NL, "RAM grootte" },
/* pl */ { IDS_RAM_SIZE_PL, "Rozmiar RAM" },
/* ru */ { IDS_RAM_SIZE_RU, "" },  /* fuzzy */
/* sv */ { IDS_RAM_SIZE_SV, "RAM-storlek" },
/* tr */ { IDS_RAM_SIZE_TR, "RAM boyutu" },

/* en */ { IDS_RAM_BLOCK_0400_0FFF,    "RAM Block $0400-$0FFF" },
/* da */ { IDS_RAM_BLOCK_0400_0FFF_DA, "RAM-blok $0400-$0FFF" },
/* de */ { IDS_RAM_BLOCK_0400_0FFF_DE, "RAM Block $0400-$0FFF" },
/* es */ { IDS_RAM_BLOCK_0400_0FFF_ES, "Bloque RAM $0400-$0FFF" },
/* fr */ { IDS_RAM_BLOCK_0400_0FFF_FR, "Bloc 0 (3 ko  $0400-$0FFF)" },
/* hu */ { IDS_RAM_BLOCK_0400_0FFF_HU, "Memria blokk $0400-$0FFF" },
/* it */ { IDS_RAM_BLOCK_0400_0FFF_IT, "Blocco RAM $0400-$0FFF" },
/* ko */ { IDS_RAM_BLOCK_0400_0FFF_KO, "" },  /* fuzzy */
/* nl */ { IDS_RAM_BLOCK_0400_0FFF_NL, "RAM blok $0400-$0FFF" },
/* pl */ { IDS_RAM_BLOCK_0400_0FFF_PL, "Blok RAM $0400-$0FFF" },
/* ru */ { IDS_RAM_BLOCK_0400_0FFF_RU, "RAM Block $0400-$0FFF" },
/* sv */ { IDS_RAM_BLOCK_0400_0FFF_SV, "RAM-block $0400-$0FFF" },
/* tr */ { IDS_RAM_BLOCK_0400_0FFF_TR, "RAM Blok $0400-$0FFF" },

/* en */ { IDS_RAM_BLOCK_0800_0FFF,    "RAM Block $0800-$0FFF" },
/* da */ { IDS_RAM_BLOCK_0800_0FFF_DA, "RAM-blok $0800-$0FFF" },
/* de */ { IDS_RAM_BLOCK_0800_0FFF_DE, "RAM Block $0800-$0FFF" },
/* es */ { IDS_RAM_BLOCK_0800_0FFF_ES, "Bloque RAM $0800-$0FFF" },
/* fr */ { IDS_RAM_BLOCK_0800_0FFF_FR, "Bloc 0 (3 ko  $0400-$0FFF)" },
/* hu */ { IDS_RAM_BLOCK_0800_0FFF_HU, "Memria blokk $0800-$0FFF" },
/* it */ { IDS_RAM_BLOCK_0800_0FFF_IT, "Blocco RAM $0800-$0FFF" },
/* ko */ { IDS_RAM_BLOCK_0800_0FFF_KO, "" },  /* fuzzy */
/* nl */ { IDS_RAM_BLOCK_0800_0FFF_NL, "RAM blok $0800-$0FFF" },
/* pl */ { IDS_RAM_BLOCK_0800_0FFF_PL, "Blok RAM $0800-$0FFF" },
/* ru */ { IDS_RAM_BLOCK_0800_0FFF_RU, "RAM Block $0800-$0FFF" },
/* sv */ { IDS_RAM_BLOCK_0800_0FFF_SV, "RAM-block $0800-$0FFF" },
/* tr */ { IDS_RAM_BLOCK_0800_0FFF_TR, "RAM Blok $0800-$0FFF" },

/* en */ { IDS_RAM_BLOCK_1000_1FFF,    "RAM Block $1000-$1FFF" },
/* da */ { IDS_RAM_BLOCK_1000_1FFF_DA, "RAM-blok $1000-$1FFF" },
/* de */ { IDS_RAM_BLOCK_1000_1FFF_DE, "RAM Block $1000-$1FFF" },
/* es */ { IDS_RAM_BLOCK_1000_1FFF_ES, "Bloque RAM $1000-$1FFF" },
/* fr */ { IDS_RAM_BLOCK_1000_1FFF_FR, "Bloc RAM $1000-$1FFF" },
/* hu */ { IDS_RAM_BLOCK_1000_1FFF_HU, "Memria blokk $1000-$1FFF" },
/* it */ { IDS_RAM_BLOCK_1000_1FFF_IT, "Blocco RAM $1000-$1FFF" },
/* ko */ { IDS_RAM_BLOCK_1000_1FFF_KO, "" },  /* fuzzy */
/* nl */ { IDS_RAM_BLOCK_1000_1FFF_NL, "RAM blok $1000-$1FFF" },
/* pl */ { IDS_RAM_BLOCK_1000_1FFF_PL, "Blok RAM $1000-$1FFF" },
/* ru */ { IDS_RAM_BLOCK_1000_1FFF_RU, "RAM Block $1000-$1FFF" },
/* sv */ { IDS_RAM_BLOCK_1000_1FFF_SV, "RAM-block $1000-$1FFF" },
/* tr */ { IDS_RAM_BLOCK_1000_1FFF_TR, "RAM Blok $1000-$1FFF" },

/* en */ { IDS_RAM_BLOCK_2000_3FFF,    "RAM Block $2000-$3FFF" },
/* da */ { IDS_RAM_BLOCK_2000_3FFF_DA, "RAM-blok $2000-$3FFF" },
/* de */ { IDS_RAM_BLOCK_2000_3FFF_DE, "RAM Block $2000-$3FFF" },
/* es */ { IDS_RAM_BLOCK_2000_3FFF_ES, "Bloque RAM $2000-$3FFF" },
/* fr */ { IDS_RAM_BLOCK_2000_3FFF_FR, "Bloc 1 (8 ko  $2000-$3FFF)" },
/* hu */ { IDS_RAM_BLOCK_2000_3FFF_HU, "Memria blokk $2000-$3FFF" },
/* it */ { IDS_RAM_BLOCK_2000_3FFF_IT, "Blocco RAM $2000-$3FFF" },
/* ko */ { IDS_RAM_BLOCK_2000_3FFF_KO, "" },  /* fuzzy */
/* nl */ { IDS_RAM_BLOCK_2000_3FFF_NL, "RAM blok $2000-$3FFF" },
/* pl */ { IDS_RAM_BLOCK_2000_3FFF_PL, "Blok RAM $2000-$3FFF" },
/* ru */ { IDS_RAM_BLOCK_2000_3FFF_RU, "RAM Block $2000-$3FFF" },
/* sv */ { IDS_RAM_BLOCK_2000_3FFF_SV, "RAM-block $2000-$3FFF" },
/* tr */ { IDS_RAM_BLOCK_2000_3FFF_TR, "RAM Blok $2000-$3FFF" },

/* en */ { IDS_RAM_BLOCK_4000_5FFF,    "RAM Block $4000-$5FFF" },
/* da */ { IDS_RAM_BLOCK_4000_5FFF_DA, "RAM-blok $4000-$5FFF" },
/* de */ { IDS_RAM_BLOCK_4000_5FFF_DE, "RAM Block $4000-$5FFF" },
/* es */ { IDS_RAM_BLOCK_4000_5FFF_ES, "Bloque RAM $4000-$5FFF" },
/* fr */ { IDS_RAM_BLOCK_4000_5FFF_FR, "Bloc 2 (8 ko  $4000-$5FFF)" },
/* hu */ { IDS_RAM_BLOCK_4000_5FFF_HU, "Memria blokk $4000-$5FFF" },
/* it */ { IDS_RAM_BLOCK_4000_5FFF_IT, "Blocco RAM $4000-$5FFF" },
/* ko */ { IDS_RAM_BLOCK_4000_5FFF_KO, "" },  /* fuzzy */
/* nl */ { IDS_RAM_BLOCK_4000_5FFF_NL, "RAM blok $4000-$5FFF" },
/* pl */ { IDS_RAM_BLOCK_4000_5FFF_PL, "Blok RAM $4000-$5FFF" },
/* ru */ { IDS_RAM_BLOCK_4000_5FFF_RU, "RAM Block $4000-$5FFF" },
/* sv */ { IDS_RAM_BLOCK_4000_5FFF_SV, "RAM-block $4000-$5FFF" },
/* tr */ { IDS_RAM_BLOCK_4000_5FFF_TR, "RAM Blok $4000-$5FFF" },

/* en */ { IDS_RAM_BLOCK_6000_7FFF,    "RAM Block $6000-$7FFF" },
/* da */ { IDS_RAM_BLOCK_6000_7FFF_DA, "RAM-blok $6000-$7FFF" },
/* de */ { IDS_RAM_BLOCK_6000_7FFF_DE, "RAM Block $6000-$7FFF" },
/* es */ { IDS_RAM_BLOCK_6000_7FFF_ES, "Bloque RAM $6000-$7FFF" },
/* fr */ { IDS_RAM_BLOCK_6000_7FFF_FR, "Bloc 3 (8 ko  $6000-$7FFF)" },
/* hu */ { IDS_RAM_BLOCK_6000_7FFF_HU, "Memria blokk $6000-$7FFF" },
/* it */ { IDS_RAM_BLOCK_6000_7FFF_IT, "Blocco RAM $6000-$7FFF" },
/* ko */ { IDS_RAM_BLOCK_6000_7FFF_KO, "" },  /* fuzzy */
/* nl */ { IDS_RAM_BLOCK_6000_7FFF_NL, "RAM blok $6000-$7FFF" },
/* pl */ { IDS_RAM_BLOCK_6000_7FFF_PL, "Blok RAM $6000-$7FFF" },
/* ru */ { IDS_RAM_BLOCK_6000_7FFF_RU, "RAM Block $6000-$7FFF" },
/* sv */ { IDS_RAM_BLOCK_6000_7FFF_SV, "RAM-block $6000-$7FFF" },
/* tr */ { IDS_RAM_BLOCK_6000_7FFF_TR, "RAM Blok $6000-$7FFF" },

/* en */ { IDS_RAM_BLOCK_A000_BFFF,    "RAM Block $A000-$BFFF" },
/* da */ { IDS_RAM_BLOCK_A000_BFFF_DA, "RAM-blok $A000-$BFFF" },
/* de */ { IDS_RAM_BLOCK_A000_BFFF_DE, "RAM Block $A000-$BFFF" },
/* es */ { IDS_RAM_BLOCK_A000_BFFF_ES, "Bloque RAM $A000-$BFFF" },
/* fr */ { IDS_RAM_BLOCK_A000_BFFF_FR, "Bloc 5 (8 ko  $A000-$BFFF)" },
/* hu */ { IDS_RAM_BLOCK_A000_BFFF_HU, "Memria blokk $A000-$BFFF" },
/* it */ { IDS_RAM_BLOCK_A000_BFFF_IT, "Blocco RAM $A000-$BFFF" },
/* ko */ { IDS_RAM_BLOCK_A000_BFFF_KO, "" },  /* fuzzy */
/* nl */ { IDS_RAM_BLOCK_A000_BFFF_NL, "RAM blok $A000-$BFFF" },
/* pl */ { IDS_RAM_BLOCK_A000_BFFF_PL, "Blok RAM $A000-$BFFF" },
/* ru */ { IDS_RAM_BLOCK_A000_BFFF_RU, "RAM Block $A000-$BFFF" },
/* sv */ { IDS_RAM_BLOCK_A000_BFFF_SV, "RAM-block $A000-$BFFF" },
/* tr */ { IDS_RAM_BLOCK_A000_BFFF_TR, "RAM Blok $A000-$BFFF" },

/* en */ { IDS_RAM_BLOCK_C000_CFFF,    "RAM Block $C000-$CFFF" },
/* da */ { IDS_RAM_BLOCK_C000_CFFF_DA, "RAM-blok $C000-$CFFF" },
/* de */ { IDS_RAM_BLOCK_C000_CFFF_DE, "RAM Block $C000-$CFFF" },
/* es */ { IDS_RAM_BLOCK_C000_CFFF_ES, "Bloque RAM $C000-$CFFF" },
/* fr */ { IDS_RAM_BLOCK_C000_CFFF_FR, "Bloc RAM $C000-$CFFF" },
/* hu */ { IDS_RAM_BLOCK_C000_CFFF_HU, "Memria blokk $C000-$CFFF" },
/* it */ { IDS_RAM_BLOCK_C000_CFFF_IT, "Blocco RAM $C000-$CFFF" },
/* ko */ { IDS_RAM_BLOCK_C000_CFFF_KO, "" },  /* fuzzy */
/* nl */ { IDS_RAM_BLOCK_C000_CFFF_NL, "RAM blok $C000-$CFFF" },
/* pl */ { IDS_RAM_BLOCK_C000_CFFF_PL, "Blok RAM $C000-$CFFF" },
/* ru */ { IDS_RAM_BLOCK_C000_CFFF_RU, "RAM Block $C000-$CFFF" },
/* sv */ { IDS_RAM_BLOCK_C000_CFFF_SV, "RAM-block $C000-$CFFF" },
/* tr */ { IDS_RAM_BLOCK_C000_CFFF_TR, "RAM Blok $C000-$CFFF" },

/* en */ { IDS_CBM2_SETTINGS,    "CBM2 settings" },
/* da */ { IDS_CBM2_SETTINGS_DA, "CBM2-indstillinger" },
/* de */ { IDS_CBM2_SETTINGS_DE, "CBM2 Einstellungen" },
/* es */ { IDS_CBM2_SETTINGS_ES, "Ajustes CBM2" },
/* fr */ { IDS_CBM2_SETTINGS_FR, "Paramtres CBM2" },
/* hu */ { IDS_CBM2_SETTINGS_HU, "CBM2 belltsai" },
/* it */ { IDS_CBM2_SETTINGS_IT, "Impostazioni CBM2" },
/* ko */ { IDS_CBM2_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_CBM2_SETTINGS_NL, "CBM2 instellingen" },
/* pl */ { IDS_CBM2_SETTINGS_PL, "Ustawienia CBM2" },
/* ru */ { IDS_CBM2_SETTINGS_RU, "CBM2 settings" },
/* sv */ { IDS_CBM2_SETTINGS_SV, "CBM2-instllningar" },
/* tr */ { IDS_CBM2_SETTINGS_TR, "CBM2 ayarlar" },

/* en */ { IDS_CBM5X0_SETTINGS,    "CBM5x0 settings" },
/* da */ { IDS_CBM5X0_SETTINGS_DA, "CBM5x0-indstillinger" },
/* de */ { IDS_CBM5X0_SETTINGS_DE, "CBM5x0 Einstellungen" },
/* es */ { IDS_CBM5X0_SETTINGS_ES, "Ajustes CBM5x0" },
/* fr */ { IDS_CBM5X0_SETTINGS_FR, "Paramtres CBM5x0" },
/* hu */ { IDS_CBM5X0_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_CBM5X0_SETTINGS_IT, "Impostazioni CBM5x0" },
/* ko */ { IDS_CBM5X0_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_CBM5X0_SETTINGS_NL, "CBM5x0 instellingen" },
/* pl */ { IDS_CBM5X0_SETTINGS_PL, "Ustawienia CBM5x0" },
/* ru */ { IDS_CBM5X0_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_CBM5X0_SETTINGS_SV, "CBM5x0-instllningar" },
/* tr */ { IDS_CBM5X0_SETTINGS_TR, "CBM5x0 ayarlar" },

/* en */ { IDS_RESET_DATASETTE_WITH_CPU,    "Reset Datasette with CPU" },
/* da */ { IDS_RESET_DATASETTE_WITH_CPU_DA, "Reset Datasette ved CPU-reset" },
/* de */ { IDS_RESET_DATASETTE_WITH_CPU_DE, "Zurcksetzen des Bandlaufwerks bei CPU Reset" },
/* es */ { IDS_RESET_DATASETTE_WITH_CPU_ES, "Reiniciar Datasette con la CPU" },
/* fr */ { IDS_RESET_DATASETTE_WITH_CPU_FR, "Rinitialiser la datassette avec l'UCT" },
/* hu */ { IDS_RESET_DATASETTE_WITH_CPU_HU, "Alaphelyzetbe hozs CPU Reset esetn" },
/* it */ { IDS_RESET_DATASETTE_WITH_CPU_IT, "Reset del registratore con CPU" },
/* ko */ { IDS_RESET_DATASETTE_WITH_CPU_KO, "Ÿ  CPU   Ͻÿ" },
/* nl */ { IDS_RESET_DATASETTE_WITH_CPU_NL, "Reset Datasette met CPU" },
/* pl */ { IDS_RESET_DATASETTE_WITH_CPU_PL, "Resetuj magnetofon razem z CPU" },
/* ru */ { IDS_RESET_DATASETTE_WITH_CPU_RU, "Reset Datasette with CPU" },
/* sv */ { IDS_RESET_DATASETTE_WITH_CPU_SV, "Nollstll Datasette med CPU" },
/* tr */ { IDS_RESET_DATASETTE_WITH_CPU_TR, "CPU ile birlikte Teyp'i resetle" },

/* en */ { IDS_ADDITIONAL_DELAY,    "Additional Delay" },
/* da */ { IDS_ADDITIONAL_DELAY_DA, "Yderligere forsinkelse" },
/* de */ { IDS_ADDITIONAL_DELAY_DE, "Zustzliche Verzgerung" },
/* es */ { IDS_ADDITIONAL_DELAY_ES, "Retardo adicional" },
/* fr */ { IDS_ADDITIONAL_DELAY_FR, "Dlai additionnel" },
/* hu */ { IDS_ADDITIONAL_DELAY_HU, "Tbblet sznet" },
/* it */ { IDS_ADDITIONAL_DELAY_IT, "Ritardo aggiuntivo" },
/* ko */ { IDS_ADDITIONAL_DELAY_KO, "" },  /* fuzzy */
/* nl */ { IDS_ADDITIONAL_DELAY_NL, "Extra vertraging" },
/* pl */ { IDS_ADDITIONAL_DELAY_PL, "Dodatkowy delay" },
/* ru */ { IDS_ADDITIONAL_DELAY_RU, "Additional Delay" },
/* sv */ { IDS_ADDITIONAL_DELAY_SV, "Ytterligare frdrjning" },
/* tr */ { IDS_ADDITIONAL_DELAY_TR, "Ekstra Bekletme" },

/* en */ { IDS_DELAY_AT_ZERO_VALUES,    "Datasette zero gap delay" },
/* da */ { IDS_DELAY_AT_ZERO_VALUES_DA, "Datasette nulgabs-forsinkelse" },
/* de */ { IDS_DELAY_AT_ZERO_VALUES_DE, "Bandlaufwerk Zero Gap Verzgerung" },
/* es */ { IDS_DELAY_AT_ZERO_VALUES_ES, "Retardo datasette zero gap" },
/* fr */ { IDS_DELAY_AT_ZERO_VALUES_FR, "Dlai du datassette lors de la lecture des groupes de zros" },
/* hu */ { IDS_DELAY_AT_ZERO_VALUES_HU, "Magn res rs ksleltets" },
/* it */ { IDS_DELAY_AT_ZERO_VALUES_IT, "Ritardo del gap di zero del registratore" },
/* ko */ { IDS_DELAY_AT_ZERO_VALUES_KO, "Ÿ   " },
/* nl */ { IDS_DELAY_AT_ZERO_VALUES_NL, "Datasette zero gap vertraging" },
/* pl */ { IDS_DELAY_AT_ZERO_VALUES_PL, "Opnienie pocztkowej przerwy magnetofonu" },
/* ru */ { IDS_DELAY_AT_ZERO_VALUES_RU, "Datasette zero gap delay" },
/* sv */ { IDS_DELAY_AT_ZERO_VALUES_SV, "Datasette nollgapsfrdrjning" },
/* tr */ { IDS_DELAY_AT_ZERO_VALUES_TR, "Teyp sfr ara beklemesi" },

/* en */ { IDS_DATASETTE_SETTINGS,    "Datasette settings" },
/* da */ { IDS_DATASETTE_SETTINGS_DA, "Datasetteindstillinger" },
/* de */ { IDS_DATASETTE_SETTINGS_DE, "Datasette Einstellungen" },
/* es */ { IDS_DATASETTE_SETTINGS_ES, "Ajustes Datasette" },
/* fr */ { IDS_DATASETTE_SETTINGS_FR, "Paramtres datassette" },
/* hu */ { IDS_DATASETTE_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_DATASETTE_SETTINGS_IT, "Impostazioni registratore" },
/* ko */ { IDS_DATASETTE_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_DATASETTE_SETTINGS_NL, "Datasette instellingen" },
/* pl */ { IDS_DATASETTE_SETTINGS_PL, "Ustawienia magnetofonu" },
/* ru */ { IDS_DATASETTE_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_DATASETTE_SETTINGS_SV, "Datasetteinstllningar" },
/* tr */ { IDS_DATASETTE_SETTINGS_TR, "Teyp Ayarlar" },

/* en */ { IDS_NEVER_EXTEND,    "Never extend" },
/* da */ { IDS_NEVER_EXTEND_DA, "Udvid aldrig" },
/* de */ { IDS_NEVER_EXTEND_DE, "Nie Erweitern" },
/* es */ { IDS_NEVER_EXTEND_ES, "No extender nunca" },
/* fr */ { IDS_NEVER_EXTEND_FR, "Ne jamais tendre" },
/* hu */ { IDS_NEVER_EXTEND_HU, "Nincs kiterjeszts" },
/* it */ { IDS_NEVER_EXTEND_IT, "Mai" },
/* ko */ { IDS_NEVER_EXTEND_KO, " ʱ" },
/* nl */ { IDS_NEVER_EXTEND_NL, "Nooit uitbreiden" },
/* pl */ { IDS_NEVER_EXTEND_PL, "Nigdy nie rozszerzaj" },
/* ru */ { IDS_NEVER_EXTEND_RU, "Never extend" },
/* sv */ { IDS_NEVER_EXTEND_SV, "Utka aldrig" },
/* tr */ { IDS_NEVER_EXTEND_TR, "Asla geniletme" },

/* en */ { IDS_ASK_ON_EXTEND,    "Ask on extend" },
/* da */ { IDS_ASK_ON_EXTEND_DA, "Sprg ved udviddelse" },
/* de */ { IDS_ASK_ON_EXTEND_DE, "Bei Erweiterung Rckfrage" },
/* es */ { IDS_ASK_ON_EXTEND_ES, "Preguntar antes de extender" },
/* fr */ { IDS_ASK_ON_EXTEND_FR, "Demander avant d'tendre" },
/* hu */ { IDS_ASK_ON_EXTEND_HU, "Krds kiterjeszts esetn" },
/* it */ { IDS_ASK_ON_EXTEND_IT, "Chiedi all'accesso" },
/* ko */ { IDS_ASK_ON_EXTEND_KO, "ϴ°Ϳ  " },
/* nl */ { IDS_ASK_ON_EXTEND_NL, "Vragen bij uitbreiden" },
/* pl */ { IDS_ASK_ON_EXTEND_PL, "Zapytaj przy rozszerzaniu" },
/* ru */ { IDS_ASK_ON_EXTEND_RU, "Ask on extend" },
/* sv */ { IDS_ASK_ON_EXTEND_SV, "Frga vid utkning" },
/* tr */ { IDS_ASK_ON_EXTEND_TR, "Geniletirken sor" },

/* en */ { IDS_EXTEND_ON_ACCESS,    "Extend on access" },
/* da */ { IDS_EXTEND_ON_ACCESS_DA, "Udvid ved tilgang" },
/* de */ { IDS_EXTEND_ON_ACCESS_DE, "Erweitern wenn ntig" },
/* es */ { IDS_EXTEND_ON_ACCESS_ES, "Extender al acceder" },
/* fr */ { IDS_EXTEND_ON_ACCESS_FR, "tendre  l'accs" },
/* hu */ { IDS_EXTEND_ON_ACCESS_HU, "Kiterjeszts hozzfrskor" },
/* it */ { IDS_EXTEND_ON_ACCESS_IT, "All'accesso" },
/* ko */ { IDS_EXTEND_ON_ACCESS_KO, " ϱ" },
/* nl */ { IDS_EXTEND_ON_ACCESS_NL, "Uitbreiden bij toegang" },
/* pl */ { IDS_EXTEND_ON_ACCESS_PL, "Rozszerz przy dostpie" },
/* ru */ { IDS_EXTEND_ON_ACCESS_RU, "Extend on access" },
/* sv */ { IDS_EXTEND_ON_ACCESS_SV, "Utka vid tkomst" },
/* tr */ { IDS_EXTEND_ON_ACCESS_TR, "Eriildiinde genilet" },

/* en */ { IDS_NO_TRAPS,    "No traps" },
/* da */ { IDS_NO_TRAPS_DA, "Ingen traps" },
/* de */ { IDS_NO_TRAPS_DE, "Keine Traps" },
/* es */ { IDS_NO_TRAPS_ES, "No interceptar" },
/* fr */ { IDS_NO_TRAPS_FR, "Pas de trappes" },
/* hu */ { IDS_NO_TRAPS_HU, "Folyamatos emulci" },
/* it */ { IDS_NO_TRAPS_IT, "Non rilevare" },
/* ko */ { IDS_NO_TRAPS_KO, "Ʈ ϴ" },
/* nl */ { IDS_NO_TRAPS_NL, "Geen traps" },
/* pl */ { IDS_NO_TRAPS_PL, "No traps" },
/* ru */ { IDS_NO_TRAPS_RU, "No traps" },
/* sv */ { IDS_NO_TRAPS_SV, "Ingen infngning" },
/* tr */ { IDS_NO_TRAPS_TR, "Trap Yok" },

/* en */ { IDS_SKIP_CYCLES,    "Skip cycles" },
/* da */ { IDS_SKIP_CYCLES_DA, "Spring over cykler" },
/* de */ { IDS_SKIP_CYCLES_DE, "Zyklen auslassen" },
/* es */ { IDS_SKIP_CYCLES_ES, "Saltar ciclos" },
/* fr */ { IDS_SKIP_CYCLES_FR, "Sauter des cycles" },
/* hu */ { IDS_SKIP_CYCLES_HU, "Ciklusok kihagysa" },
/* it */ { IDS_SKIP_CYCLES_IT, "Salta cicli" },
/* ko */ { IDS_SKIP_CYCLES_KO, "Ŭ Ѿ" },
/* nl */ { IDS_SKIP_CYCLES_NL, "Sla cycli over" },
/* pl */ { IDS_SKIP_CYCLES_PL, "Opuszczaj cykle" },
/* ru */ { IDS_SKIP_CYCLES_RU, "Skip cycles" },
/* sv */ { IDS_SKIP_CYCLES_SV, "Hoppa cykler" },
/* tr */ { IDS_SKIP_CYCLES_TR, "Cyclelar atla" },

/* en */ { IDS_TRAP_IDLE,    "Trap idle" },
/* da */ { IDS_TRAP_IDLE_DA, "Fang inaktive" },
/* de */ { IDS_TRAP_IDLE_DE, "Trap idle" },
/* es */ { IDS_TRAP_IDLE_ES, "Interceptar tiempos muertos" },
/* fr */ { IDS_TRAP_IDLE_FR, "Traper linactivit" },
/* hu */ { IDS_TRAP_IDLE_HU, "res ciklusok kihagysa" },
/* it */ { IDS_TRAP_IDLE_IT, "Rileva inattivit" },
/* ko */ { IDS_TRAP_IDLE_KO, "Ʈ ̵" },
/* nl */ { IDS_TRAP_IDLE_NL, "Trap idle" },
/* pl */ { IDS_TRAP_IDLE_PL, "Trap idle" },
/* ru */ { IDS_TRAP_IDLE_RU, "Trap idle" },
/* sv */ { IDS_TRAP_IDLE_SV, "Fnga inaktiva" },
/* tr */ { IDS_TRAP_IDLE_TR, "Trap boa vakit geirme" },

/* en */ { IDS_DRIVE_TYPE,    "Drive type" },
/* da */ { IDS_DRIVE_TYPE_DA, "Drevtype" },
/* de */ { IDS_DRIVE_TYPE_DE, "Gerte Typ" },
/* es */ { IDS_DRIVE_TYPE_ES, "Tipo unidad disco" },
/* fr */ { IDS_DRIVE_TYPE_FR, "Type de lecteur" },
/* hu */ { IDS_DRIVE_TYPE_HU, "Lemezegysg tpus" },
/* it */ { IDS_DRIVE_TYPE_IT, "Tipo drive" },
/* ko */ { IDS_DRIVE_TYPE_KO, "̺ Ÿ" },
/* nl */ { IDS_DRIVE_TYPE_NL, "Drivesoort" },
/* pl */ { IDS_DRIVE_TYPE_PL, "Typ napdu" },
/* ru */ { IDS_DRIVE_TYPE_RU, "Drive type" },
/* sv */ { IDS_DRIVE_TYPE_SV, "Enhetstyp" },
/* tr */ { IDS_DRIVE_TYPE_TR, "Src tipi" },

/* en */ { IDS_40_TRACK_HANDLING,    "40 track handling" },
/* da */ { IDS_40_TRACK_HANDLING_DA, "Hndtering af 40 spor" },
/* de */ { IDS_40_TRACK_HANDLING_DE, "40 Spur Umgang" },
/* es */ { IDS_40_TRACK_HANDLING_ES, "Manejador 40 pistas" },
/* fr */ { IDS_40_TRACK_HANDLING_FR, "Prise en charge du 40 pistes" },
/* hu */ { IDS_40_TRACK_HANDLING_HU, "40 sv kezelse" },
/* it */ { IDS_40_TRACK_HANDLING_IT, "Gestione 40 tracce" },
/* ko */ { IDS_40_TRACK_HANDLING_KO, "40 Ʈ ڵ帵" },
/* nl */ { IDS_40_TRACK_HANDLING_NL, "40-sporenondersteuning" },
/* pl */ { IDS_40_TRACK_HANDLING_PL, "Obsuga 40 cieek" },
/* ru */ { IDS_40_TRACK_HANDLING_RU, "40 track handling" },
/* sv */ { IDS_40_TRACK_HANDLING_SV, "Hantering av 40 spr" },
/* tr */ { IDS_40_TRACK_HANDLING_TR, "40 track ileme" },

/* en */ { IDS_DRIVE_EXPANSION,    "Drive expansion" },
/* da */ { IDS_DRIVE_EXPANSION_DA, "Drevudviddelse" },
/* de */ { IDS_DRIVE_EXPANSION_DE, "Laufwerk Erweiterung" },
/* es */ { IDS_DRIVE_EXPANSION_ES, "Expansin Unidad disco" },
/* fr */ { IDS_DRIVE_EXPANSION_FR, "Expansion de lecteur" },
/* hu */ { IDS_DRIVE_EXPANSION_HU, "Lemezegysg bvts" },
/* it */ { IDS_DRIVE_EXPANSION_IT, "Espasione del drive" },
/* ko */ { IDS_DRIVE_EXPANSION_KO, "̺ Ȯ" },
/* nl */ { IDS_DRIVE_EXPANSION_NL, "Drive uitbreiding" },
/* pl */ { IDS_DRIVE_EXPANSION_PL, "Rozszerzenie napdu" },
/* ru */ { IDS_DRIVE_EXPANSION_RU, "Drive expansion" },
/* sv */ { IDS_DRIVE_EXPANSION_SV, "Enhetsutkning" },
/* tr */ { IDS_DRIVE_EXPANSION_TR, "Src genilemesi" },

/* en */ { IDS_IDLE_METHOD,    "Idle method" },
/* da */ { IDS_IDLE_METHOD_DA, "Tomgangsmetode" },
/* de */ { IDS_IDLE_METHOD_DE, "Idle Methode" },
/* es */ { IDS_IDLE_METHOD_ES, "Mtodo tiempo inactivo" },
/* fr */ { IDS_IDLE_METHOD_FR, "Mthode d'idle" },
/* hu */ { IDS_IDLE_METHOD_HU, "resjrat md" },
/* it */ { IDS_IDLE_METHOD_IT, "Rileva inattivit" },
/* ko */ { IDS_IDLE_METHOD_KO, "" },
/* nl */ { IDS_IDLE_METHOD_NL, "Idlemethode" },
/* pl */ { IDS_IDLE_METHOD_PL, "Metoda bezczynnoci" },
/* ru */ { IDS_IDLE_METHOD_RU, "Idle method" },
/* sv */ { IDS_IDLE_METHOD_SV, "Pausmetod" },
/* tr */ { IDS_IDLE_METHOD_TR, "Boa vakit geirme metodu" },

/* en */ { IDS_PARALLEL_CABLE,    "Parallel cable" },
/* da */ { IDS_PARALLEL_CABLE_DA, "Parallelkabel" },
/* de */ { IDS_PARALLEL_CABLE_DE, "Parallel Kabel" },
/* es */ { IDS_PARALLEL_CABLE_ES, "Cable paralelo" },
/* fr */ { IDS_PARALLEL_CABLE_FR, "Cble parallle" },
/* hu */ { IDS_PARALLEL_CABLE_HU, "Prhuzamos kbel" },
/* it */ { IDS_PARALLEL_CABLE_IT, "Cavo parallelo" },
/* ko */ { IDS_PARALLEL_CABLE_KO, " ĳ̺" },
/* nl */ { IDS_PARALLEL_CABLE_NL, "Parallelle kabel" },
/* pl */ { IDS_PARALLEL_CABLE_PL, "cze portu rwnolegego" },
/* ru */ { IDS_PARALLEL_CABLE_RU, "Parallel cable" },
/* sv */ { IDS_PARALLEL_CABLE_SV, "Parallellkabel" },
/* tr */ { IDS_PARALLEL_CABLE_TR, "Paralel kablo" },

/* en */ { IDS_PROFESSIONAL_DOS,    "Professional DOS" },
/* da */ { IDS_PROFESSIONAL_DOS_DA, "" },  /* fuzzy */
/* de */ { IDS_PROFESSIONAL_DOS_DE, "Professional DOS" },
/* es */ { IDS_PROFESSIONAL_DOS_ES, "DOS profesional" },
/* fr */ { IDS_PROFESSIONAL_DOS_FR, "" },  /* fuzzy */
/* hu */ { IDS_PROFESSIONAL_DOS_HU, "" },  /* fuzzy */
/* it */ { IDS_PROFESSIONAL_DOS_IT, "Professional DOS" },
/* ko */ { IDS_PROFESSIONAL_DOS_KO, "" },  /* fuzzy */
/* nl */ { IDS_PROFESSIONAL_DOS_NL, "Professional DOS" },
/* pl */ { IDS_PROFESSIONAL_DOS_PL, "Professional DOS" },
/* ru */ { IDS_PROFESSIONAL_DOS_RU, "" },  /* fuzzy */
/* sv */ { IDS_PROFESSIONAL_DOS_SV, "" },  /* fuzzy */
/* tr */ { IDS_PROFESSIONAL_DOS_TR, "" },  /* fuzzy */

/* en */ { IDS_SUPERCARD_PLUS,    "SuperCard+" },
/* da */ { IDS_SUPERCARD_PLUS_DA, "" },  /* fuzzy */
/* de */ { IDS_SUPERCARD_PLUS_DE, "SuperCard+" },
/* es */ { IDS_SUPERCARD_PLUS_ES, "SuperCard+" },
/* fr */ { IDS_SUPERCARD_PLUS_FR, "" },  /* fuzzy */
/* hu */ { IDS_SUPERCARD_PLUS_HU, "" },  /* fuzzy */
/* it */ { IDS_SUPERCARD_PLUS_IT, "SuperCard+" },
/* ko */ { IDS_SUPERCARD_PLUS_KO, "" },  /* fuzzy */
/* nl */ { IDS_SUPERCARD_PLUS_NL, "SuperCard+" },
/* pl */ { IDS_SUPERCARD_PLUS_PL, "SuperCard+" },
/* ru */ { IDS_SUPERCARD_PLUS_RU, "" },  /* fuzzy */
/* sv */ { IDS_SUPERCARD_PLUS_SV, "" },  /* fuzzy */
/* tr */ { IDS_SUPERCARD_PLUS_TR, "" },  /* fuzzy */

/* en */ { IDS_DRIVE_RTC_SAVE,    "Enable FD2000/4000 RTC data saving" },
/* da */ { IDS_DRIVE_RTC_SAVE_DA, "" },  /* fuzzy */
/* de */ { IDS_DRIVE_RTC_SAVE_DE, "FD2000/4000 RTC Datenspeichung aktivieren" },
/* es */ { IDS_DRIVE_RTC_SAVE_ES, "Permitir grabar datos  FD2000/4000 RTC" },
/* fr */ { IDS_DRIVE_RTC_SAVE_FR, "" },  /* fuzzy */
/* hu */ { IDS_DRIVE_RTC_SAVE_HU, "" },  /* fuzzy */
/* it */ { IDS_DRIVE_RTC_SAVE_IT, "Attiva il salvataggio dei dati RTC del FD2000/4000" },
/* ko */ { IDS_DRIVE_RTC_SAVE_KO, "" },  /* fuzzy */
/* nl */ { IDS_DRIVE_RTC_SAVE_NL, "Activeer opslaan van de FD2000/4000 RTC data" },
/* pl */ { IDS_DRIVE_RTC_SAVE_PL, "Wcz zapis zegara FD2000/4000" },
/* ru */ { IDS_DRIVE_RTC_SAVE_RU, "" },  /* fuzzy */
/* sv */ { IDS_DRIVE_RTC_SAVE_SV, "" },  /* fuzzy */
/* tr */ { IDS_DRIVE_RTC_SAVE_TR, "" },  /* fuzzy */

/* en */ { IDS_DRIVE_SETTINGS,    "Drive settings" },
/* da */ { IDS_DRIVE_SETTINGS_DA, "Diskettedrevsindstillinger" },
/* de */ { IDS_DRIVE_SETTINGS_DE, "Floppy Einstellungen" },
/* es */ { IDS_DRIVE_SETTINGS_ES, "Ajustes unidad disco" },
/* fr */ { IDS_DRIVE_SETTINGS_FR, "Paramtres des lecteurs" },
/* hu */ { IDS_DRIVE_SETTINGS_HU, "Lemezegysg belltsai" },
/* it */ { IDS_DRIVE_SETTINGS_IT, "Impostazioni drive" },
/* ko */ { IDS_DRIVE_SETTINGS_KO, "̺ " },
/* nl */ { IDS_DRIVE_SETTINGS_NL, "Drive instellingen" },
/* pl */ { IDS_DRIVE_SETTINGS_PL, "Ustawienia napdu" },
/* ru */ { IDS_DRIVE_SETTINGS_RU, "Drive settings" },
/* sv */ { IDS_DRIVE_SETTINGS_SV, "Diskettenhetsinstllningar" },
/* tr */ { IDS_DRIVE_SETTINGS_TR, "Src ayarlar" },

/* en */ { IDS_GEORAM_SIZE,    "GEO-RAM size" },
/* da */ { IDS_GEORAM_SIZE_DA, "GEO-RAM-strrelse" },
/* de */ { IDS_GEORAM_SIZE_DE, "GEO-RAM Gre" },
/* es */ { IDS_GEORAM_SIZE_ES, "Tamao GEO-RAM" },
/* fr */ { IDS_GEORAM_SIZE_FR, "Taille du GEO-RAM" },
/* hu */ { IDS_GEORAM_SIZE_HU, "" },  /* fuzzy */
/* it */ { IDS_GEORAM_SIZE_IT, "Dimensione GEO-RAM" },
/* ko */ { IDS_GEORAM_SIZE_KO, "" },  /* fuzzy */
/* nl */ { IDS_GEORAM_SIZE_NL, "GEO-RAM grootte" },
/* pl */ { IDS_GEORAM_SIZE_PL, "Rozmiar GEO-RAM" },
/* ru */ { IDS_GEORAM_SIZE_RU, "" },  /* fuzzy */
/* sv */ { IDS_GEORAM_SIZE_SV, "GEO-RAM-storlek" },
/* tr */ { IDS_GEORAM_SIZE_TR, "GEO-RAM boyutu" },

/* en */ { IDS_MASCUERADE_IO_SWAP,    "MasC=uerade I/O swap" },
/* da */ { IDS_MASCUERADE_IO_SWAP_DA, "MasC=uerade I/O ombytning" },
/* de */ { IDS_MASCUERADE_IO_SWAP_DE, "MasC=uerade I/O swap" },
/* es */ { IDS_MASCUERADE_IO_SWAP_ES, "Intercambio mscara Entrada/Salida" },
/* fr */ { IDS_MASCUERADE_IO_SWAP_FR, "Permutation E/S MasC=uerade" },
/* hu */ { IDS_MASCUERADE_IO_SWAP_HU, "" },  /* fuzzy */
/* it */ { IDS_MASCUERADE_IO_SWAP_IT, "I/O swap MasC=uerade" },
/* ko */ { IDS_MASCUERADE_IO_SWAP_KO, "MasC=uerade I/O " },
/* nl */ { IDS_MASCUERADE_IO_SWAP_NL, "MasC=uerade I/O verwisseling" },
/* pl */ { IDS_MASCUERADE_IO_SWAP_PL, "Zamiana we/wy MasC=uerade" },
/* ru */ { IDS_MASCUERADE_IO_SWAP_RU, "MasC=uerade I/O swap" },
/* sv */ { IDS_MASCUERADE_IO_SWAP_SV, "MasC=uerade I/O-vxling" },
/* tr */ { IDS_MASCUERADE_IO_SWAP_TR, "MasC=uerade G/ deiimi" },

/* en */ { IDS_GEORAM_FILENAME,    "GEO-RAM file" },
/* da */ { IDS_GEORAM_FILENAME_DA, "GEO-RAM-fil" },
/* de */ { IDS_GEORAM_FILENAME_DE, "GEO-RAM Datei" },
/* es */ { IDS_GEORAM_FILENAME_ES, "Fulcro GEO-RAM" },
/* fr */ { IDS_GEORAM_FILENAME_FR, "Fichier GEO-RAM" },
/* hu */ { IDS_GEORAM_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_GEORAM_FILENAME_IT, "File GEO-RAM" },
/* ko */ { IDS_GEORAM_FILENAME_KO, "GEO-RAM " },
/* nl */ { IDS_GEORAM_FILENAME_NL, "GEO-RAM bestand" },
/* pl */ { IDS_GEORAM_FILENAME_PL, "Plik GEO-RAM" },
/* ru */ { IDS_GEORAM_FILENAME_RU, "GEO-RAM file" },
/* sv */ { IDS_GEORAM_FILENAME_SV, "GEO-RAM-fil" },
/* tr */ { IDS_GEORAM_FILENAME_TR, "GEO-RAM dosyas" },

/* en */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED,    "Save GEO-RAM image when changed" },
/* da */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_DA, "Gem GEO-RAM image ved ndringer" },
/* de */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_DE, "GEO-RAM Imagedatei bei nderung speichern" },
/* es */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_ES, "Grabar imagen GEO-RAM cuando cambie" },
/* fr */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_FR, "Enregistrer l'image GEO-RAM lorsque modifie" },
/* hu */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_HU, "" },  /* fuzzy */
/* it */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_IT, "Salva immagine GEO-RAM alla modifica" },
/* ko */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_KO, "" },  /* fuzzy */
/* nl */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_NL, "GEO-RAM bestand opslaan indien gewijzigd" },
/* pl */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_PL, "Zapisuj obraz GEO-RAM przy zmianie" },
/* ru */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_RU, "Save GEO-RAM image when changed" },
/* sv */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_SV, "Spara GEO-RAM-avbildning vid ndringar" },
/* tr */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_TR, "GEO-RAM imaj deitiinde kaydet" },

/* en */ { IDS_GEORAM_FILENAME_SELECT,    "Select file for GEO-RAM" },
/* da */ { IDS_GEORAM_FILENAME_SELECT_DA, "Vlg fil for GEO-RAM" },
/* de */ { IDS_GEORAM_FILENAME_SELECT_DE, "Datei fr GEO-RAM auswhlen" },
/* es */ { IDS_GEORAM_FILENAME_SELECT_ES, "Seleccionar fichero para GEO-RAM" },
/* fr */ { IDS_GEORAM_FILENAME_SELECT_FR, "Slectionner le fichier GEO-RAM" },
/* hu */ { IDS_GEORAM_FILENAME_SELECT_HU, "" },  /* fuzzy */
/* it */ { IDS_GEORAM_FILENAME_SELECT_IT, "Seleziona file per GEO-RAM" },
/* ko */ { IDS_GEORAM_FILENAME_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_GEORAM_FILENAME_SELECT_NL, "Selecteer bestand voor GEO-RAM" },
/* pl */ { IDS_GEORAM_FILENAME_SELECT_PL, "Wybierz plik GEO-RAM" },
/* ru */ { IDS_GEORAM_FILENAME_SELECT_RU, "Select file for GEO-RAM" },
/* sv */ { IDS_GEORAM_FILENAME_SELECT_SV, "Vlj fil fr GEO-RAM" },
/* tr */ { IDS_GEORAM_FILENAME_SELECT_TR, "GEO-RAM iin dosya sein" },

/* en */ { IDS_GEORAM_SETTINGS,    "GEO-RAM settings" },
/* da */ { IDS_GEORAM_SETTINGS_DA, "GEO-RAM-indstillinger" },
/* de */ { IDS_GEORAM_SETTINGS_DE, "GEO-RAM Einstellungen" },
/* es */ { IDS_GEORAM_SETTINGS_ES, "Ajustes GEO-RAM" },
/* fr */ { IDS_GEORAM_SETTINGS_FR, "Paramtres GEO-RAM" },
/* hu */ { IDS_GEORAM_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_GEORAM_SETTINGS_IT, "Impostazioni GEO-RAM" },
/* ko */ { IDS_GEORAM_SETTINGS_KO, "GEO-RAM " },
/* nl */ { IDS_GEORAM_SETTINGS_NL, "GEO-RAM instellingen" },
/* pl */ { IDS_GEORAM_SETTINGS_PL, "Ustawienia GEO-RAM" },
/* ru */ { IDS_GEORAM_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_GEORAM_SETTINGS_SV, "GEO-RAM-instllningar" },
/* tr */ { IDS_GEORAM_SETTINGS_TR, "GEO-RAM ayarlar" },

/* en */ { IDS_SAMPLER_FILENAME_SELECT,    "Select file to be used as sampler input" },
/* da */ { IDS_SAMPLER_FILENAME_SELECT_DA, "" },  /* fuzzy */
/* de */ { IDS_SAMPLER_FILENAME_SELECT_DE, "Datei fr Sample Input auswhlen" },
/* es */ { IDS_SAMPLER_FILENAME_SELECT_ES, "" },  /* fuzzy */
/* fr */ { IDS_SAMPLER_FILENAME_SELECT_FR, "" },  /* fuzzy */
/* hu */ { IDS_SAMPLER_FILENAME_SELECT_HU, "" },  /* fuzzy */
/* it */ { IDS_SAMPLER_FILENAME_SELECT_IT, "" },  /* fuzzy */
/* ko */ { IDS_SAMPLER_FILENAME_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_SAMPLER_FILENAME_SELECT_NL, "Selecteer het bestand dat gebruikt gaat worden als sampler invoer" },
/* pl */ { IDS_SAMPLER_FILENAME_SELECT_PL, "" },  /* fuzzy */
/* ru */ { IDS_SAMPLER_FILENAME_SELECT_RU, "" },  /* fuzzy */
/* sv */ { IDS_SAMPLER_FILENAME_SELECT_SV, "" },  /* fuzzy */
/* tr */ { IDS_SAMPLER_FILENAME_SELECT_TR, "" },  /* fuzzy */

/* en */ { IDS_SAMPLER_DEVICE,    "Sampler device" },
/* da */ { IDS_SAMPLER_DEVICE_DA, "" },  /* fuzzy */
/* de */ { IDS_SAMPLER_DEVICE_DE, "Sampler Gert" },
/* es */ { IDS_SAMPLER_DEVICE_ES, "" },  /* fuzzy */
/* fr */ { IDS_SAMPLER_DEVICE_FR, "" },  /* fuzzy */
/* hu */ { IDS_SAMPLER_DEVICE_HU, "" },  /* fuzzy */
/* it */ { IDS_SAMPLER_DEVICE_IT, "" },  /* fuzzy */
/* ko */ { IDS_SAMPLER_DEVICE_KO, "" },  /* fuzzy */
/* nl */ { IDS_SAMPLER_DEVICE_NL, "Sampler apparaat" },
/* pl */ { IDS_SAMPLER_DEVICE_PL, "" },  /* fuzzy */
/* ru */ { IDS_SAMPLER_DEVICE_RU, "" },  /* fuzzy */
/* sv */ { IDS_SAMPLER_DEVICE_SV, "" },  /* fuzzy */
/* tr */ { IDS_SAMPLER_DEVICE_TR, "" },  /* fuzzy */

/* en */ { IDS_SAMPLER_FILENAME,    "Sampler input media file" },
/* da */ { IDS_SAMPLER_FILENAME_DA, "" },  /* fuzzy */
/* de */ { IDS_SAMPLER_FILENAME_DE, "Sample Input Mediendatei" },
/* es */ { IDS_SAMPLER_FILENAME_ES, "" },  /* fuzzy */
/* fr */ { IDS_SAMPLER_FILENAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_SAMPLER_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_SAMPLER_FILENAME_IT, "" },  /* fuzzy */
/* ko */ { IDS_SAMPLER_FILENAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_SAMPLER_FILENAME_NL, "Sampler invoer mediabestand" },
/* pl */ { IDS_SAMPLER_FILENAME_PL, "" },  /* fuzzy */
/* ru */ { IDS_SAMPLER_FILENAME_RU, "" },  /* fuzzy */
/* sv */ { IDS_SAMPLER_FILENAME_SV, "" },  /* fuzzy */
/* tr */ { IDS_SAMPLER_FILENAME_TR, "" },  /* fuzzy */

/* en */ { IDS_SAMPLER_SETTINGS,    "Sampler settings" },
/* da */ { IDS_SAMPLER_SETTINGS_DA, "" },  /* fuzzy */
/* de */ { IDS_SAMPLER_SETTINGS_DE, "Sampler Einstellungen" },
/* es */ { IDS_SAMPLER_SETTINGS_ES, "" },  /* fuzzy */
/* fr */ { IDS_SAMPLER_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_SAMPLER_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_SAMPLER_SETTINGS_IT, "" },  /* fuzzy */
/* ko */ { IDS_SAMPLER_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_SAMPLER_SETTINGS_NL, "Sampler instellingen" },
/* pl */ { IDS_SAMPLER_SETTINGS_PL, "" },  /* fuzzy */
/* ru */ { IDS_SAMPLER_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_SAMPLER_SETTINGS_SV, "" },  /* fuzzy */
/* tr */ { IDS_SAMPLER_SETTINGS_TR, "" },  /* fuzzy */

/* en */ { IDS_EXPERT_MODE,    "Expert Cartridge mode" },
/* da */ { IDS_EXPERT_MODE_DA, "Expert Cartridge-tilstand" },
/* de */ { IDS_EXPERT_MODE_DE, "Expert Cartridge Modus" },
/* es */ { IDS_EXPERT_MODE_ES, "Modo Expert Cartridge" },
/* fr */ { IDS_EXPERT_MODE_FR, "Mode Cartouche Expert" },
/* hu */ { IDS_EXPERT_MODE_HU, "" },  /* fuzzy */
/* it */ { IDS_EXPERT_MODE_IT, "Modalit Expert Cartridge" },
/* ko */ { IDS_EXPERT_MODE_KO, "" },  /* fuzzy */
/* nl */ { IDS_EXPERT_MODE_NL, "Expert Cartridge modus" },
/* pl */ { IDS_EXPERT_MODE_PL, "Tryb Expert Cartridge" },
/* ru */ { IDS_EXPERT_MODE_RU, "" },  /* fuzzy */
/* sv */ { IDS_EXPERT_MODE_SV, "Expert Cartridge-lge" },
/* tr */ { IDS_EXPERT_MODE_TR, "Expert Kartuu modu" },

/* en */ { IDS_OFF,    "Off" },
/* da */ { IDS_OFF_DA, "Slukket" },
/* de */ { IDS_OFF_DE, "Aus" },
/* es */ { IDS_OFF_ES, "Apagado" },
/* fr */ { IDS_OFF_FR, "Off" },
/* hu */ { IDS_OFF_HU, "Ki" },
/* it */ { IDS_OFF_IT, "No" },
/* ko */ { IDS_OFF_KO, "" },
/* nl */ { IDS_OFF_NL, "Uit" },
/* pl */ { IDS_OFF_PL, "Wycz" },
/* ru */ { IDS_OFF_RU, "Off" },
/* sv */ { IDS_OFF_SV, "Av" },
/* tr */ { IDS_OFF_TR, "Kapal" },

/* en */ { IDS_PRG,    "Prg" },
/* da */ { IDS_PRG_DA, "Prg" },
/* de */ { IDS_PRG_DE, "Prg" },
/* es */ { IDS_PRG_ES, "Prg" },
/* fr */ { IDS_PRG_FR, "Prg" },
/* hu */ { IDS_PRG_HU, "Prg" },
/* it */ { IDS_PRG_IT, "Prg" },
/* ko */ { IDS_PRG_KO, "Prg" },
/* nl */ { IDS_PRG_NL, "Prg" },
/* pl */ { IDS_PRG_PL, "Prg" },
/* ru */ { IDS_PRG_RU, "Prg" },
/* sv */ { IDS_PRG_SV, "Prg" },
/* tr */ { IDS_PRG_TR, "Prg" },

/* en */ { IDS_ON,    "On" },
/* da */ { IDS_ON_DA, "Tndt" },
/* de */ { IDS_ON_DE, "Ein" },
/* es */ { IDS_ON_ES, "Encendido" },
/* fr */ { IDS_ON_FR, "On" },
/* hu */ { IDS_ON_HU, "Be" },
/* it */ { IDS_ON_IT, "S" },
/* ko */ { IDS_ON_KO, "" },
/* nl */ { IDS_ON_NL, "Aan" },
/* pl */ { IDS_ON_PL, "Wcz" },
/* ru */ { IDS_ON_RU, "On" },
/* sv */ { IDS_ON_SV, "P" },
/* tr */ { IDS_ON_TR, "Ak" },

/* en */ { IDS_EXPERT_FILENAME,    "Expert Cartridge file" },
/* da */ { IDS_EXPERT_FILENAME_DA, "Expert Cartridge-fil" },
/* de */ { IDS_EXPERT_FILENAME_DE, "Expert Cartridge Imagedatei" },
/* es */ { IDS_EXPERT_FILENAME_ES, "Fichero Expert Cartrige" },
/* fr */ { IDS_EXPERT_FILENAME_FR, "Fichier Cartouche Expert" },
/* hu */ { IDS_EXPERT_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_EXPERT_FILENAME_IT, "File Expert Cartridge" },
/* ko */ { IDS_EXPERT_FILENAME_KO, "Expert īƮ " },
/* nl */ { IDS_EXPERT_FILENAME_NL, "Expert Cartridge bestand" },
/* pl */ { IDS_EXPERT_FILENAME_PL, "Plik Expert Cartridge" },
/* ru */ { IDS_EXPERT_FILENAME_RU, "" },  /* fuzzy */
/* sv */ { IDS_EXPERT_FILENAME_SV, "Expert Cartridge-fil" },
/* tr */ { IDS_EXPERT_FILENAME_TR, "Expert Kartuu dosyas" },

/* en */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED,    "Save Expert Cartridge image when changed" },
/* da */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_DA, "Gem Expert Cartridge image ved ndringer" },
/* de */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_DE, "Expert Cartridge Imagedatei bei nderungen speichern" },
/* es */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_ES, "Grabar imagen Expert Cartridge cuando cambie" },
/* fr */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_FR, "Sauvegarder l'image Cartouche Expert lorsque modifie" },
/* hu */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_HU, "" },  /* fuzzy */
/* it */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_IT, "Salva immagine Expert Cartridge alla modifica" },
/* ko */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_KO, "" },  /* fuzzy */
/* nl */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_NL, "Expert Cartridge bestand opslaan indien gewijzigd" },
/* pl */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_PL, "Zapisuj obraz Expert Cartridge przy zmianie" },
/* ru */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_RU, "Save Expert Cartridge image when changed" },
/* sv */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_SV, "Spara Expert Cartrdige-avbildning vid ndringar" },
/* tr */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_TR, "Expert Kartu imajn deitiinde kaydet" },

/* en */ { IDS_EXPERT_FILENAME_SELECT,    "Select file for Expert Cartridge" },
/* da */ { IDS_EXPERT_FILENAME_SELECT_DA, "Vlg fil for Expert Cartridge" },
/* de */ { IDS_EXPERT_FILENAME_SELECT_DE, "Export Cartridge Imagedatei auswhlen" },
/* es */ { IDS_EXPERT_FILENAME_SELECT_ES, "Seleccionar fichero para Expert Cartrige" },
/* fr */ { IDS_EXPERT_FILENAME_SELECT_FR, "Slectionner fichier pour Cartouche Expert" },
/* hu */ { IDS_EXPERT_FILENAME_SELECT_HU, "" },  /* fuzzy */
/* it */ { IDS_EXPERT_FILENAME_SELECT_IT, "Seleziona file per Expert Cartridge" },
/* ko */ { IDS_EXPERT_FILENAME_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_EXPERT_FILENAME_SELECT_NL, "Selecteer bestand voor Expert Cartridge" },
/* pl */ { IDS_EXPERT_FILENAME_SELECT_PL, "Wybierz plik Expert Cartridge" },
/* ru */ { IDS_EXPERT_FILENAME_SELECT_RU, "" },  /* fuzzy */
/* sv */ { IDS_EXPERT_FILENAME_SELECT_SV, "Vlj fil fr Expert Cartridge" },
/* tr */ { IDS_EXPERT_FILENAME_SELECT_TR, "Expert Kartuu iin dosya sein" },

/* en */ { IDS_EXPERT_SETTINGS,    "Expert Cartridge settings" },
/* da */ { IDS_EXPERT_SETTINGS_DA, "Expert Cartridge-indstillinger" },
/* de */ { IDS_EXPERT_SETTINGS_DE, "Expert Cartridge Einstellungen" },
/* es */ { IDS_EXPERT_SETTINGS_ES, "Ajustes Expert Cartrige" },
/* fr */ { IDS_EXPERT_SETTINGS_FR, "Paramtres Cartouche Expert" },
/* hu */ { IDS_EXPERT_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_EXPERT_SETTINGS_IT, "Impostazioni Expert Cartridge" },
/* ko */ { IDS_EXPERT_SETTINGS_KO, "Expert īƮ " },
/* nl */ { IDS_EXPERT_SETTINGS_NL, "Expert Cartridge instellingen" },
/* pl */ { IDS_EXPERT_SETTINGS_PL, "Ustawienia Expert Cartridge" },
/* ru */ { IDS_EXPERT_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_EXPERT_SETTINGS_SV, "Instllningar fr Expert Cartridge" },
/* tr */ { IDS_EXPERT_SETTINGS_TR, "Expert Kartuu ayarlar" },

/* en */ { IDS_DQBB_FILENAME,    "DQBB file" },
/* da */ { IDS_DQBB_FILENAME_DA, "DQBB-fil" },
/* de */ { IDS_DQBB_FILENAME_DE, "DQBB Datei" },
/* es */ { IDS_DQBB_FILENAME_ES, "Fichero DQBB" },
/* fr */ { IDS_DQBB_FILENAME_FR, "Fichier DQBB" },
/* hu */ { IDS_DQBB_FILENAME_HU, "DQBB fjl" },
/* it */ { IDS_DQBB_FILENAME_IT, "File DQBB" },
/* ko */ { IDS_DQBB_FILENAME_KO, "DQBB " },
/* nl */ { IDS_DQBB_FILENAME_NL, "DQBB bestand" },
/* pl */ { IDS_DQBB_FILENAME_PL, "Plik DQBB" },
/* ru */ { IDS_DQBB_FILENAME_RU, " DQBB" },
/* sv */ { IDS_DQBB_FILENAME_SV, "DQBB-fil" },
/* tr */ { IDS_DQBB_FILENAME_TR, "DQBB dosyas" },

/* en */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED,    "Save DQBB image when changed" },
/* da */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_DA, "Gem DQBB image ved ndringer" },
/* de */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_DE, "DQBB Imagedatei bei nderung speichern" },
/* es */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_ES, "Grabar imagen DQBB cuando cambie" },
/* fr */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_FR, "Enregistrer l'image DQBB lorsque modifie" },
/* hu */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_HU, "" },  /* fuzzy */
/* it */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_IT, "Salva immagine DQBB alla modifica" },
/* ko */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_KO, "" },  /* fuzzy */
/* nl */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_NL, "DQBB bestand opslaan indien gewijzigd" },
/* pl */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_PL, "Zapisuj obraz DQBB przy zmianie" },
/* ru */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_RU, "Save DQBB image when changed" },
/* sv */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_SV, "Spara DQBB-avbildning vid ndringar" },
/* tr */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_TR, "DQBB imaj deitiinde kaydet" },

/* en */ { IDS_DQBB_FILENAME_SELECT,    "Select file for DQBB" },
/* da */ { IDS_DQBB_FILENAME_SELECT_DA, "Vlg fil for DQBB" },
/* de */ { IDS_DQBB_FILENAME_SELECT_DE, "Datei fr DQBB auswhlen" },
/* es */ { IDS_DQBB_FILENAME_SELECT_ES, "Seleccionar fichero para DQBB" },
/* fr */ { IDS_DQBB_FILENAME_SELECT_FR, "Slectionner fichier pour DQBB" },
/* hu */ { IDS_DQBB_FILENAME_SELECT_HU, "Vlasszon fjlt a DQBB-hez" },
/* it */ { IDS_DQBB_FILENAME_SELECT_IT, "Seleziona file per DQBB" },
/* ko */ { IDS_DQBB_FILENAME_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_DQBB_FILENAME_SELECT_NL, "Selecteer bestand voor DQBB" },
/* pl */ { IDS_DQBB_FILENAME_SELECT_PL, "Wybierz plik DQBB" },
/* ru */ { IDS_DQBB_FILENAME_SELECT_RU, "Select file for DQBB" },
/* sv */ { IDS_DQBB_FILENAME_SELECT_SV, "Vlj fil fr DQBB" },
/* tr */ { IDS_DQBB_FILENAME_SELECT_TR, "DQBB iin dosya se" },

/* en */ { IDS_DQBB_SETTINGS,    "Double Quick Brown Box settings" },
/* da */ { IDS_DQBB_SETTINGS_DA, "Double Quick Brown Box indstillinger" },
/* de */ { IDS_DQBB_SETTINGS_DE, "Double Quick Brown Box Einstellungen" },
/* es */ { IDS_DQBB_SETTINGS_ES, "Ajustes Double Quick Brown Box" },
/* fr */ { IDS_DQBB_SETTINGS_FR, "Paramtres Double Quick Brown Box" },
/* hu */ { IDS_DQBB_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_DQBB_SETTINGS_IT, "Impostazioni Double Quick Brown Box" },
/* ko */ { IDS_DQBB_SETTINGS_KO, "Double Quick Brown Box " },
/* nl */ { IDS_DQBB_SETTINGS_NL, "Double Quick Brown Box instellingen" },
/* pl */ { IDS_DQBB_SETTINGS_PL, "Ustawienia Double Quick Brown Box" },
/* ru */ { IDS_DQBB_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_DQBB_SETTINGS_SV, "Instllninga fr dubbel Quick Brown Box" },
/* tr */ { IDS_DQBB_SETTINGS_TR, "Double Quick Brown Box ayarlar" },

/* en */ { IDS_ISEPIC_SETTINGS,    "ISEPIC settings" },
/* da */ { IDS_ISEPIC_SETTINGS_DA, "ISEPIC-indstillinger" },
/* de */ { IDS_ISEPIC_SETTINGS_DE, "ISEPIC Einstellungen" },
/* es */ { IDS_ISEPIC_SETTINGS_ES, "Ajustes ISEPIC" },
/* fr */ { IDS_ISEPIC_SETTINGS_FR, "Paramtres ISEPIC" },
/* hu */ { IDS_ISEPIC_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_ISEPIC_SETTINGS_IT, "Impostazioni ISEPIC" },
/* ko */ { IDS_ISEPIC_SETTINGS_KO, "ISEPIC " },
/* nl */ { IDS_ISEPIC_SETTINGS_NL, "ISEPIC instellingen" },
/* pl */ { IDS_ISEPIC_SETTINGS_PL, "Ustawienia ISEPIC" },
/* ru */ { IDS_ISEPIC_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_ISEPIC_SETTINGS_SV, "ISEPIC-instllningar" },
/* tr */ { IDS_ISEPIC_SETTINGS_TR, "ISEPIC ayarlar" },

/* en */ { IDS_ISEPIC_SWITCH,    "ISEPIC switch" },
/* da */ { IDS_ISEPIC_SWITCH_DA, "ISEPIC-kontakt" },
/* de */ { IDS_ISEPIC_SWITCH_DE, "ISEPIC Schalter" },
/* es */ { IDS_ISEPIC_SWITCH_ES, "interruptor ISEPIC" },
/* fr */ { IDS_ISEPIC_SWITCH_FR, "Paramtres d'interrupteur ISEPIC" },
/* hu */ { IDS_ISEPIC_SWITCH_HU, "" },  /* fuzzy */
/* it */ { IDS_ISEPIC_SWITCH_IT, "Pulsante ISEPIC" },
/* ko */ { IDS_ISEPIC_SWITCH_KO, "" },  /* fuzzy */
/* nl */ { IDS_ISEPIC_SWITCH_NL, "ISEPIC schakelaar" },
/* pl */ { IDS_ISEPIC_SWITCH_PL, "Przecznik ISEPIC" },
/* ru */ { IDS_ISEPIC_SWITCH_RU, "ISEPIC switch" },
/* sv */ { IDS_ISEPIC_SWITCH_SV, "ISEPIC-omkopplare" },
/* tr */ { IDS_ISEPIC_SWITCH_TR, "ISEPIC anahtar" },

/* en */ { IDS_ISEPIC_FILENAME,    "ISEPIC file" },
/* da */ { IDS_ISEPIC_FILENAME_DA, "ISEPIC-fil" },
/* de */ { IDS_ISEPIC_FILENAME_DE, "ISEPIC Imagedatei" },
/* es */ { IDS_ISEPIC_FILENAME_ES, "Fichero ISEPIC" },
/* fr */ { IDS_ISEPIC_FILENAME_FR, "Fichier ISEPIC" },
/* hu */ { IDS_ISEPIC_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_ISEPIC_FILENAME_IT, "File ISEPIC" },
/* ko */ { IDS_ISEPIC_FILENAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_ISEPIC_FILENAME_NL, "ISEPIC bestand" },
/* pl */ { IDS_ISEPIC_FILENAME_PL, "Plik ISEPIC" },
/* ru */ { IDS_ISEPIC_FILENAME_RU, "" },  /* fuzzy */
/* sv */ { IDS_ISEPIC_FILENAME_SV, "ISEPIC-fil" },
/* tr */ { IDS_ISEPIC_FILENAME_TR, "ISEPIC dosyas" },

/* en */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED,    "Save ISEPIC image when changed" },
/* da */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_DA, "Gem ISEPIC image ved ndringer" },
/* de */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_DE, "ISEPIC Imagedatei bei nderung speichern" },
/* es */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_ES, "Grabar imagen ISEPIC cuando cambie" },
/* fr */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_FR, "Enregistrer l'image ISEPIC lorsque modifie" },
/* hu */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_HU, "" },  /* fuzzy */
/* it */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_IT, "Salva immagine ISEPIC alla modifica" },
/* ko */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_KO, "" },  /* fuzzy */
/* nl */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_NL, "ISEPIC bestand opslaan indien gewijzigd" },
/* pl */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_PL, "Zapisuj obraz ISEPIC przy zmianie" },
/* ru */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_RU, "Save ISEPIC image when changed" },
/* sv */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_SV, "Spara ISEPIC-avbildning vid ndringar" },
/* tr */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_TR, "ISEPIC imaj deitiinde kaydet" },

/* en */ { IDS_ISEPIC_FILENAME_SELECT,    "Select file for ISEPIC" },
/* da */ { IDS_ISEPIC_FILENAME_SELECT_DA, "Vlg fil for ISEPIC" },
/* de */ { IDS_ISEPIC_FILENAME_SELECT_DE, "Datei fr ISEPIC auswhlen" },
/* es */ { IDS_ISEPIC_FILENAME_SELECT_ES, "Seleccionar fichero para ISEPIC" },
/* fr */ { IDS_ISEPIC_FILENAME_SELECT_FR, "Slectionner fichier pour ISEPIC" },
/* hu */ { IDS_ISEPIC_FILENAME_SELECT_HU, "" },  /* fuzzy */
/* it */ { IDS_ISEPIC_FILENAME_SELECT_IT, "Seleziona file per ISEPIC" },
/* ko */ { IDS_ISEPIC_FILENAME_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_ISEPIC_FILENAME_SELECT_NL, "Selecteer bestand voor ISEPIC" },
/* pl */ { IDS_ISEPIC_FILENAME_SELECT_PL, "Wybierz plik ISEPIC" },
/* ru */ { IDS_ISEPIC_FILENAME_SELECT_RU, "Select file for ISEPIC" },
/* sv */ { IDS_ISEPIC_FILENAME_SELECT_SV, "Vlj fil fr ISEPIC" },
/* tr */ { IDS_ISEPIC_FILENAME_SELECT_TR, "ISEPIC iin dosya sein" },

/* en */ { IDS_EASYFLASH_SETTINGS,    "EasyFlash settings" },
/* da */ { IDS_EASYFLASH_SETTINGS_DA, "EasyFlash-indstillinger" },
/* de */ { IDS_EASYFLASH_SETTINGS_DE, "EasyFlash Einstellungen" },
/* es */ { IDS_EASYFLASH_SETTINGS_ES, "Ajustes EasyFlash" },
/* fr */ { IDS_EASYFLASH_SETTINGS_FR, "Paramtres datassette" },
/* hu */ { IDS_EASYFLASH_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_EASYFLASH_SETTINGS_IT, "Impostazioni EasyFlash" },
/* ko */ { IDS_EASYFLASH_SETTINGS_KO, "EasyFlash " },
/* nl */ { IDS_EASYFLASH_SETTINGS_NL, "EasyFlash instellingen" },
/* pl */ { IDS_EASYFLASH_SETTINGS_PL, "Ustawienia EasyFlash" },
/* ru */ { IDS_EASYFLASH_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_EASYFLASH_SETTINGS_SV, "EasyFlash-instllningar" },
/* tr */ { IDS_EASYFLASH_SETTINGS_TR, "EasyFlash ayarlar" },

/* en */ { IDS_CONFIG_FILENAME_SELECT,    "Select config file" },
/* da */ { IDS_CONFIG_FILENAME_SELECT_DA, "Vlg konfigurationsfil" },
/* de */ { IDS_CONFIG_FILENAME_SELECT_DE, "Konfigurationsdateiname whlen" },
/* es */ { IDS_CONFIG_FILENAME_SELECT_ES, "Seleccionar fichero de configuracin" },
/* fr */ { IDS_CONFIG_FILENAME_SELECT_FR, "Slectionnez le fichier de configuration" },
/* hu */ { IDS_CONFIG_FILENAME_SELECT_HU, "Vlassza ki a konfigurcis fjlt" },
/* it */ { IDS_CONFIG_FILENAME_SELECT_IT, "Seleziona il file di configurazione" },
/* ko */ { IDS_CONFIG_FILENAME_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_CONFIG_FILENAME_SELECT_NL, "Selecteer configuratie bestand" },
/* pl */ { IDS_CONFIG_FILENAME_SELECT_PL, "Wybierz plik konfiguracji" },
/* ru */ { IDS_CONFIG_FILENAME_SELECT_RU, "Select config file" },
/* sv */ { IDS_CONFIG_FILENAME_SELECT_SV, "Ange instllningsfil" },
/* tr */ { IDS_CONFIG_FILENAME_SELECT_TR, "Konfigrasyon dosyasn sein" },

/* en */ { IDS_JOYSTICK_1,    "Joystick #1" },
/* da */ { IDS_JOYSTICK_1_DA, "" },  /* fuzzy */
/* de */ { IDS_JOYSTICK_1_DE, "Joystick #1" },
/* es */ { IDS_JOYSTICK_1_ES, "" },  /* fuzzy */
/* fr */ { IDS_JOYSTICK_1_FR, "" },  /* fuzzy */
/* hu */ { IDS_JOYSTICK_1_HU, "" },  /* fuzzy */
/* it */ { IDS_JOYSTICK_1_IT, "" },  /* fuzzy */
/* ko */ { IDS_JOYSTICK_1_KO, "" },  /* fuzzy */
/* nl */ { IDS_JOYSTICK_1_NL, "Joystick #1" },
/* pl */ { IDS_JOYSTICK_1_PL, "" },  /* fuzzy */
/* ru */ { IDS_JOYSTICK_1_RU, "" },  /* fuzzy */
/* sv */ { IDS_JOYSTICK_1_SV, "" },  /* fuzzy */
/* tr */ { IDS_JOYSTICK_1_TR, "" },  /* fuzzy */

/* en */ { IDS_JOYSTICK_2,    "Joystick #2" },
/* da */ { IDS_JOYSTICK_2_DA, "" },  /* fuzzy */
/* de */ { IDS_JOYSTICK_2_DE, "Joystick #2" },
/* es */ { IDS_JOYSTICK_2_ES, "" },  /* fuzzy */
/* fr */ { IDS_JOYSTICK_2_FR, "" },  /* fuzzy */
/* hu */ { IDS_JOYSTICK_2_HU, "" },  /* fuzzy */
/* it */ { IDS_JOYSTICK_2_IT, "" },  /* fuzzy */
/* ko */ { IDS_JOYSTICK_2_KO, "" },  /* fuzzy */
/* nl */ { IDS_JOYSTICK_2_NL, "Joystick #2" },
/* pl */ { IDS_JOYSTICK_2_PL, "" },  /* fuzzy */
/* ru */ { IDS_JOYSTICK_2_RU, "" },  /* fuzzy */
/* sv */ { IDS_JOYSTICK_2_SV, "" },  /* fuzzy */
/* tr */ { IDS_JOYSTICK_2_TR, "" },  /* fuzzy */

/* en */ { IDS_USERPORT_ADAPTER,    "Userport joystick adapter" },
/* da */ { IDS_USERPORT_ADAPTER_DA, "Brugerportjoystickadapter" },
/* de */ { IDS_USERPORT_ADAPTER_DE, "Userport Joystick Adapter" },
/* es */ { IDS_USERPORT_ADAPTER_ES, "Adaptador de puerto usuario joystick" },
/* fr */ { IDS_USERPORT_ADAPTER_FR, "Adaptateur joystick port utilisateur" },
/* hu */ { IDS_USERPORT_ADAPTER_HU, "Userport botkormny adapter" },
/* it */ { IDS_USERPORT_ADAPTER_IT, "Adattatore joystick su userport" },
/* ko */ { IDS_USERPORT_ADAPTER_KO, "Ʈ ̽ƽ ƴ" },
/* nl */ { IDS_USERPORT_ADAPTER_NL, "Userport joystick adapter" },
/* pl */ { IDS_USERPORT_ADAPTER_PL, "Zcze userportu joysticka" },
/* ru */ { IDS_USERPORT_ADAPTER_RU, "Userport joystick adapter" },
/* sv */ { IDS_USERPORT_ADAPTER_SV, "Adapter fr anvndarportstyrspakar" },
/* tr */ { IDS_USERPORT_ADAPTER_TR, "Userport joystick dntrc" },

/* en */ { IDS_USERPORT_ADAPTER_TYPE,    "Userport joystick adapter type" },
/* da */ { IDS_USERPORT_ADAPTER_TYPE_DA, "Brugerportjoystickadapter-type" },
/* de */ { IDS_USERPORT_ADAPTER_TYPE_DE, "Userport Joystick Adadptertype" },
/* es */ { IDS_USERPORT_ADAPTER_TYPE_ES, "Tipo de adaptador de puerto usuario joystick" },
/* fr */ { IDS_USERPORT_ADAPTER_TYPE_FR, "Type d'adaptateur joystick port utilisateur " },
/* hu */ { IDS_USERPORT_ADAPTER_TYPE_HU, "Userport botkormny adapter tpusa" },
/* it */ { IDS_USERPORT_ADAPTER_TYPE_IT, "Tipo adattatore joystick su userport" },
/* ko */ { IDS_USERPORT_ADAPTER_TYPE_KO, "Ʈ ̽ƽ ƴ " },
/* nl */ { IDS_USERPORT_ADAPTER_TYPE_NL, "Userport joystick adapter model" },
/* pl */ { IDS_USERPORT_ADAPTER_TYPE_PL, "Typ zcza userportu joysticka" },
/* ru */ { IDS_USERPORT_ADAPTER_TYPE_RU, "Userport joystick adapter type" },
/* sv */ { IDS_USERPORT_ADAPTER_TYPE_SV, "Typ av adapter fr anvndarportstyrspakar" },
/* tr */ { IDS_USERPORT_ADAPTER_TYPE_TR, "Userport joystick dntrc tipi" },

/* en */ { IDS_JOYSTICK_IN_USERPORT_PORT_1,    "Joystick in extra port #1" },
/* da */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_DA, "Joystick i ekstra port 1" },
/* de */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_DE, "Joystick in extra Port #1" },
/* es */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_ES, "Joystick en puerto suplementario #1" },
/* fr */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_FR, "Joystick dans le port suppplmentaire #1" },
/* hu */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_HU, "" },  /* fuzzy */
/* it */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_IT, "Joystick nella porta supplementare #1" },
/* ko */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_KO, "Ʈ Ʈ #1  ̽ƽ" },
/* nl */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_NL, "Joystick in extra poort #1" },
/* pl */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_PL, "Joystick w dodatkowym porcie #1" },
/* ru */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_RU, "    1" },
/* sv */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_SV, "Styrspak i extraport #1" },
/* tr */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_TR, "Joystick ekstra port #1'de" },

/* en */ { IDS_JOYSTICK_IN_USERPORT_PORT_2,    "Joystick in extra port #2" },
/* da */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_DA, "Joystick i ekstra port 2" },
/* de */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_DE, "Joystick in extra Port #2" },
/* es */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_ES, "Joystick en puerto suplementario #2" },
/* fr */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_FR, "Joystick dans le port suppplmentaire #2" },
/* hu */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_HU, "" },  /* fuzzy */
/* it */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_IT, "Joystick nella porta supplementare #2" },
/* ko */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_KO, "Ʈ Ʈ #2  ̽ƽ" },
/* nl */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_NL, "Joystick in extra poort #2" },
/* pl */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_PL, "Joystick w dodatkowym porcie #2" },
/* ru */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_RU, "    2" },
/* sv */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_SV, "Styrspak i extraport #2" },
/* tr */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_TR, "Joystick ekstra port #2'de" },

/* en */ { IDS_SIDCART_JOY,    "SIDcart joystick" },
/* da */ { IDS_SIDCART_JOY_DA, "SIDcart joystick" },
/* de */ { IDS_SIDCART_JOY_DE, "SIDcart Joystick" },
/* es */ { IDS_SIDCART_JOY_ES, "Joystick SIDcart" },
/* fr */ { IDS_SIDCART_JOY_FR, "Joystick SIDcart" },
/* hu */ { IDS_SIDCART_JOY_HU, "SIDcart botkormny" },
/* it */ { IDS_SIDCART_JOY_IT, "Joystick SIDcart" },
/* ko */ { IDS_SIDCART_JOY_KO, "SIDcard ̽ƽ" },
/* nl */ { IDS_SIDCART_JOY_NL, "SIDcart joystick" },
/* pl */ { IDS_SIDCART_JOY_PL, "Joystick SIDcart" },
/* ru */ { IDS_SIDCART_JOY_RU, "SIDcart joystick" },
/* sv */ { IDS_SIDCART_JOY_SV, "SIDcart-styrspak" },
/* tr */ { IDS_SIDCART_JOY_TR, "SID kartuu joystick'i" },


/* en */ { IDS_JOYSTICK_IN_SIDCART_PORT,    "Joystick in SIDcart joystick port" },
/* da */ { IDS_JOYSTICK_IN_SIDCART_PORT_DA, "Joystick i SIDcart joystickport" },
/* de */ { IDS_JOYSTICK_IN_SIDCART_PORT_DE, "Joystick in SIDcart Joystick Port" },
/* es */ { IDS_JOYSTICK_IN_SIDCART_PORT_ES, "Joystick en puerto joystick SIDcart" },
/* fr */ { IDS_JOYSTICK_IN_SIDCART_PORT_FR, "Joystick dans le port joystick SIDcart" },
/* hu */ { IDS_JOYSTICK_IN_SIDCART_PORT_HU, "Botkormny a SIDcart porton" },
/* it */ { IDS_JOYSTICK_IN_SIDCART_PORT_IT, "Joystick nella porta joystick su SIDcart" },
/* ko */ { IDS_JOYSTICK_IN_SIDCART_PORT_KO, "" },  /* fuzzy */
/* nl */ { IDS_JOYSTICK_IN_SIDCART_PORT_NL, "Joystick in SIDcart joystick poort" },
/* pl */ { IDS_JOYSTICK_IN_SIDCART_PORT_PL, "Joystick w porcie joysticka SIDcart" },
/* ru */ { IDS_JOYSTICK_IN_SIDCART_PORT_RU, "Joystick in SIDcart joystick port" },
/* sv */ { IDS_JOYSTICK_IN_SIDCART_PORT_SV, "Styrspak i SIDcart-spelport" },
/* tr */ { IDS_JOYSTICK_IN_SIDCART_PORT_TR, "Joystick SID kartuu joystick portuna takl" },

/* en */ { IDS_JOYSTICK_SETTINGS,    "Joystick settings" },
/* da */ { IDS_JOYSTICK_SETTINGS_DA, "Joystick indstillinger" },
/* de */ { IDS_JOYSTICK_SETTINGS_DE, "Joystick Einstellungen" },
/* es */ { IDS_JOYSTICK_SETTINGS_ES, "Ajustes de joystick" },
/* fr */ { IDS_JOYSTICK_SETTINGS_FR, "Paramtres des joysticks" },
/* hu */ { IDS_JOYSTICK_SETTINGS_HU, "Botkormny belltsai" },
/* it */ { IDS_JOYSTICK_SETTINGS_IT, "Impostazioni joystick" },
/* ko */ { IDS_JOYSTICK_SETTINGS_KO, "̽ƽ " },
/* nl */ { IDS_JOYSTICK_SETTINGS_NL, "Joystick instellingen" },
/* pl */ { IDS_JOYSTICK_SETTINGS_PL, "Ustawienia joysticka" },
/* ru */ { IDS_JOYSTICK_SETTINGS_RU, " " },
/* sv */ { IDS_JOYSTICK_SETTINGS_SV, "Instllningar fr styrspak" },
/* tr */ { IDS_JOYSTICK_SETTINGS_TR, "Joystick ayarlar" },

/* en */ { IDS_KEYPAD,    "Numpad" },
/* da */ { IDS_KEYPAD_DA, "Numerisk tastatur" },
/* de */ { IDS_KEYPAD_DE, "Ziffernblock" },
/* es */ { IDS_KEYPAD_ES, "Teclado numrico" },
/* fr */ { IDS_KEYPAD_FR, "Pav num." },
/* hu */ { IDS_KEYPAD_HU, "Numerikus billentyk" },
/* it */ { IDS_KEYPAD_IT, "Tastierino numerico" },
/* ko */ { IDS_KEYPAD_KO, "е" },
/* nl */ { IDS_KEYPAD_NL, "Numpad" },
/* pl */ { IDS_KEYPAD_PL, "Klawiatura numeryczna" },
/* ru */ { IDS_KEYPAD_RU, "Numpad" },
/* sv */ { IDS_KEYPAD_SV, "Numeriskt tangentbord" },
/* tr */ { IDS_KEYPAD_TR, "Numpad" },

/* en */ { IDS_JOY_PORT_0,    "Joy Port 0" },
/* da */ { IDS_JOY_PORT_0_DA, "Joystickport 0" },
/* de */ { IDS_JOY_PORT_0_DE, "Joystick Port 0" },
/* es */ { IDS_JOY_PORT_0_ES, "Puerto Joy 0" },
/* fr */ { IDS_JOY_PORT_0_FR, "Port joystick 0" },
/* hu */ { IDS_JOY_PORT_0_HU, "Botkormny port 0" },
/* it */ { IDS_JOY_PORT_0_IT, "Joystick nella porta 0" },
/* ko */ { IDS_JOY_PORT_0_KO, "" },  /* fuzzy */
/* nl */ { IDS_JOY_PORT_0_NL, "Joy Poort 0" },
/* pl */ { IDS_JOY_PORT_0_PL, "Port joysticka 0" },
/* ru */ { IDS_JOY_PORT_0_RU, "Joy Port 0" },
/* sv */ { IDS_JOY_PORT_0_SV, "Spelport 0" },
/* tr */ { IDS_JOY_PORT_0_TR, "Joy Port 0" },

/* en */ { IDS_JOY_PORT_1,    "Joy Port 1" },
/* da */ { IDS_JOY_PORT_1_DA, "Joystickport 1" },
/* de */ { IDS_JOY_PORT_1_DE, "Joystick Port 1" },
/* es */ { IDS_JOY_PORT_1_ES, "Puerto Joy 1" },
/* fr */ { IDS_JOY_PORT_1_FR, "Port joystick 1" },
/* hu */ { IDS_JOY_PORT_1_HU, "Botkormny port 1" },
/* it */ { IDS_JOY_PORT_1_IT, "Joystick nella porta 1" },
/* ko */ { IDS_JOY_PORT_1_KO, "" },  /* fuzzy */
/* nl */ { IDS_JOY_PORT_1_NL, "Joy Poort 1" },
/* pl */ { IDS_JOY_PORT_1_PL, "Port joysticka 1" },
/* ru */ { IDS_JOY_PORT_1_RU, "Joy Port 1" },
/* sv */ { IDS_JOY_PORT_1_SV, "Spelport 1" },
/* tr */ { IDS_JOY_PORT_1_TR, "Joy Port 1" },

/* en */ { IDS_JOY_PORT_2,    "Joy Port 2" },
/* da */ { IDS_JOY_PORT_2_DA, "Joystickport 2" },
/* de */ { IDS_JOY_PORT_2_DE, "Joystick Port 2" },
/* es */ { IDS_JOY_PORT_2_ES, "Puerto Joy 2" },
/* fr */ { IDS_JOY_PORT_2_FR, "Port joystick 2" },
/* hu */ { IDS_JOY_PORT_2_HU, "Botkormny port 2" },
/* it */ { IDS_JOY_PORT_2_IT, "Joystick nella porta 2" },
/* ko */ { IDS_JOY_PORT_2_KO, "" },  /* fuzzy */
/* nl */ { IDS_JOY_PORT_2_NL, "Joy Poort 2" },
/* pl */ { IDS_JOY_PORT_2_PL, "Port joysticka 2" },
/* ru */ { IDS_JOY_PORT_2_RU, "Joy Port 2" },
/* sv */ { IDS_JOY_PORT_2_SV, "Spelport 2" },
/* tr */ { IDS_JOY_PORT_2_TR, "Joy Port 2" },

/* en */ { IDS_JOY_PORT_3,    "Joy Port 3" },
/* da */ { IDS_JOY_PORT_3_DA, "Joystickport 2" },
/* de */ { IDS_JOY_PORT_3_DE, "Joystick Port 3" },
/* es */ { IDS_JOY_PORT_3_ES, "Puerto Joy 3" },
/* fr */ { IDS_JOY_PORT_3_FR, "Port joystick 3" },
/* hu */ { IDS_JOY_PORT_3_HU, "Botkormny port 3" },
/* it */ { IDS_JOY_PORT_3_IT, "Joystick nella porta 3" },
/* ko */ { IDS_JOY_PORT_3_KO, "" },  /* fuzzy */
/* nl */ { IDS_JOY_PORT_3_NL, "Joy Poort 3" },
/* pl */ { IDS_JOY_PORT_3_PL, "Port joysticka 3" },
/* ru */ { IDS_JOY_PORT_3_RU, "Joy Port 3" },
/* sv */ { IDS_JOY_PORT_3_SV, "Spelport 2" },
/* tr */ { IDS_JOY_PORT_3_TR, "Joy Port 3" },

/* en */ { IDS_STOP_BLUE,    "Stop/Blue" },
/* da */ { IDS_STOP_BLUE_DA, "Stop/Bl" },
/* de */ { IDS_STOP_BLUE_DE, "Stop/Blau" },
/* es */ { IDS_STOP_BLUE_ES, "Parar/Azul" },
/* fr */ { IDS_STOP_BLUE_FR, "Arrt/Bleu" },
/* hu */ { IDS_STOP_BLUE_HU, "Lellt/Kk" },
/* it */ { IDS_STOP_BLUE_IT, "Stop/Blu" },
/* ko */ { IDS_STOP_BLUE_KO, "/Ķ" },
/* nl */ { IDS_STOP_BLUE_NL, "Stop/Blauw" },
/* pl */ { IDS_STOP_BLUE_PL, "Zatrzymaj/Bkitny" },
/* ru */ { IDS_STOP_BLUE_RU, "Stop/Blue" },
/* sv */ { IDS_STOP_BLUE_SV, "Stopp/Bl" },
/* tr */ { IDS_STOP_BLUE_TR, "Durdur/Mavi" },

/* en */ { IDS_SELECT_RED,    "Select/Red" },
/* da */ { IDS_SELECT_RED_DA, "Vlg/Rd" },
/* de */ { IDS_SELECT_RED_DE, "Auswahl/Rot" },
/* es */ { IDS_SELECT_RED_ES, "Seleccionar/Rojo" },
/* fr */ { IDS_SELECT_RED_FR, "Slectionner/Rouge" },
/* hu */ { IDS_SELECT_RED_HU, "Kivlaszt/Piros" },
/* it */ { IDS_SELECT_RED_IT, "Seleziona/Rosso" },
/* ko */ { IDS_SELECT_RED_KO, "/" },
/* nl */ { IDS_SELECT_RED_NL, "Selecy/Rood" },
/* pl */ { IDS_SELECT_RED_PL, "Wybierz/Czerwony" },
/* ru */ { IDS_SELECT_RED_RU, "Select/Red" },
/* sv */ { IDS_SELECT_RED_SV, "Vlj/Rd" },
/* tr */ { IDS_SELECT_RED_TR, "Seim/Krmz" },

/* en */ { IDS_REPEAT_YELLOW,    "Repeat/Yellow" },
/* da */ { IDS_REPEAT_YELLOW_DA, "Gentag/Gul" },
/* de */ { IDS_REPEAT_YELLOW_DE, "Wiederhole/Gelb" },
/* es */ { IDS_REPEAT_YELLOW_ES, "Repetir/Amarillo" },
/* fr */ { IDS_REPEAT_YELLOW_FR, "Rpter/Jaune" },
/* hu */ { IDS_REPEAT_YELLOW_HU, "Ismtel/Srga" },
/* it */ { IDS_REPEAT_YELLOW_IT, "Ripeti/Giallo" },
/* ko */ { IDS_REPEAT_YELLOW_KO, "ݺ/" },
/* nl */ { IDS_REPEAT_YELLOW_NL, "Repeat/Geel" },
/* pl */ { IDS_REPEAT_YELLOW_PL, "Powtarzaj/ty" },
/* ru */ { IDS_REPEAT_YELLOW_RU, "Repeat/Yellow" },
/* sv */ { IDS_REPEAT_YELLOW_SV, "Repetera/Gul" },
/* tr */ { IDS_REPEAT_YELLOW_TR, "Tekrar/Sar" },

/* en */ { IDS_SHUFFLE_GREEN,    "Shuffle/Green" },
/* da */ { IDS_SHUFFLE_GREEN_DA, "Bland/Grn" },
/* de */ { IDS_SHUFFLE_GREEN_DE, "Mische/Grn" },
/* es */ { IDS_SHUFFLE_GREEN_ES, "Shuffle/Verde" },
/* fr */ { IDS_SHUFFLE_GREEN_FR, "Mlanger/Vert" },
/* hu */ { IDS_SHUFFLE_GREEN_HU, "Vletlenszer/Zld" },
/* it */ { IDS_SHUFFLE_GREEN_IT, "Mischia/Verde" },
/* ko */ { IDS_SHUFFLE_GREEN_KO, "/ʷ" },
/* nl */ { IDS_SHUFFLE_GREEN_NL, "Shuffle/Groen" },
/* pl */ { IDS_SHUFFLE_GREEN_PL, "Losuj/Zielony" },
/* ru */ { IDS_SHUFFLE_GREEN_RU, "Shuffle/Green" },
/* sv */ { IDS_SHUFFLE_GREEN_SV, "Blanda/Grn" },
/* tr */ { IDS_SHUFFLE_GREEN_TR, "Kartr/Yeil" },

/* en */ { IDS_FORWARD_CHARCOAL,    "Forward/Charcoal" },
/* da */ { IDS_FORWARD_CHARCOAL_DA, "Fremad/Grafit" },
/* de */ { IDS_FORWARD_CHARCOAL_DE, "Vorwrts/Kohle" },
/* es */ { IDS_FORWARD_CHARCOAL_ES, "Adelante/Negro" },
/* fr */ { IDS_FORWARD_CHARCOAL_FR, "Avancer/Charcoal" },
/* hu */ { IDS_FORWARD_CHARCOAL_HU, "Elre/Fekete" },
/* it */ { IDS_FORWARD_CHARCOAL_IT, "Avanti/Carboncino" },
/* ko */ { IDS_FORWARD_CHARCOAL_KO, "/£ ȸ" },
/* nl */ { IDS_FORWARD_CHARCOAL_NL, "Forward/Charcoal" },
/* pl */ { IDS_FORWARD_CHARCOAL_PL, "W przd/Wgiel drzewny" },
/* ru */ { IDS_FORWARD_CHARCOAL_RU, "Forward/Charcoal" },
/* sv */ { IDS_FORWARD_CHARCOAL_SV, "Framt/Svart" },
/* tr */ { IDS_FORWARD_CHARCOAL_TR, "leri/Kmr" },

/* en */ { IDS_REVERSE_CHARCOAL,    "Reverse/Charcoal" },
/* da */ { IDS_REVERSE_CHARCOAL_DA, "Bagud/Grafit" },
/* de */ { IDS_REVERSE_CHARCOAL_DE, "Rckwrts/Kohle" },
/* es */ { IDS_REVERSE_CHARCOAL_ES, "Atrs/Negro" },
/* fr */ { IDS_REVERSE_CHARCOAL_FR, "Reculer/Charcoal" },
/* hu */ { IDS_REVERSE_CHARCOAL_HU, "Vissza/Fekete" },
/* it */ { IDS_REVERSE_CHARCOAL_IT, "Indietro/Carboncino" },
/* ko */ { IDS_REVERSE_CHARCOAL_KO, "/£ ȸ" },
/* nl */ { IDS_REVERSE_CHARCOAL_NL, "Reverse/Charcoal" },
/* pl */ { IDS_REVERSE_CHARCOAL_PL, "Do tyu/Wglowy" },
/* ru */ { IDS_REVERSE_CHARCOAL_RU, "Reverse/Charcoal" },
/* sv */ { IDS_REVERSE_CHARCOAL_SV, "Bakt/Svart" },
/* tr */ { IDS_REVERSE_CHARCOAL_TR, "Ters/Kmr" },

/* en */ { IDS_PLAY_PAUSE_GREY,    "Play-Pause/Grey" },
/* da */ { IDS_PLAY_PAUSE_GREY_DA, "Play-Pause/Gr" },
/* de */ { IDS_PLAY_PAUSE_GREY_DE, "Play-Pause/Grau" },
/* es */ { IDS_PLAY_PAUSE_GREY_ES, "Iniciar-Pausa/Gris" },
/* fr */ { IDS_PLAY_PAUSE_GREY_FR, "Play-Pause/Gris" },
/* hu */ { IDS_PLAY_PAUSE_GREY_HU, "Lejtszs-Megllts/Szrke" },
/* it */ { IDS_PLAY_PAUSE_GREY_IT, "Avvia-Pausa/Grigio" },
/* ko */ { IDS_PLAY_PAUSE_GREY_KO, "-/ȸ" },
/* nl */ { IDS_PLAY_PAUSE_GREY_NL, "Play-Pause/Grijs" },
/* pl */ { IDS_PLAY_PAUSE_GREY_PL, "Odtwarzaj-Pauza/Szary" },
/* ru */ { IDS_PLAY_PAUSE_GREY_RU, "Play-Pause/Grey" },
/* sv */ { IDS_PLAY_PAUSE_GREY_SV, "Spela-Paus/Gr" },
/* tr */ { IDS_PLAY_PAUSE_GREY_TR, "al-Duraklat/Gri" },

/* en */ { IDS_JOY_1_DEVICE,    "Joy 1 Device" },
/* da */ { IDS_JOY_1_DEVICE_DA, "Joystick 1 enhed" },
/* de */ { IDS_JOY_1_DEVICE_DE, "Joystick 1 Gert" },
/* es */ { IDS_JOY_1_DEVICE_ES, "Perifrico Joy 1" },
/* fr */ { IDS_JOY_1_DEVICE_FR, "Priphrique joystick 1" },
/* hu */ { IDS_JOY_1_DEVICE_HU, "1-es botkormny eszkz" },
/* it */ { IDS_JOY_1_DEVICE_IT, "Dispositivo Joystick 1" },
/* ko */ { IDS_JOY_1_DEVICE_KO, "" },  /* fuzzy */
/* nl */ { IDS_JOY_1_DEVICE_NL, "Joy 1 apparaat" },
/* pl */ { IDS_JOY_1_DEVICE_PL, "Urzdzenie joysticka 1" },
/* ru */ { IDS_JOY_1_DEVICE_RU, "Joy 1 Device" },
/* sv */ { IDS_JOY_1_DEVICE_SV, "Enhet fr styrspak 1" },
/* tr */ { IDS_JOY_1_DEVICE_TR, "Joy 1 Aygt" },

/* en */ { IDS_JOY_2_DEVICE,    "Joy 2 Device" },
/* da */ { IDS_JOY_2_DEVICE_DA, "Joystick 2 enhed" },
/* de */ { IDS_JOY_2_DEVICE_DE, "Joystick 2 Gert" },
/* es */ { IDS_JOY_2_DEVICE_ES, "Perifrico Joy 2" },
/* fr */ { IDS_JOY_2_DEVICE_FR, "Priphrique joystick 2" },
/* hu */ { IDS_JOY_2_DEVICE_HU, "2-es botkormny eszkz" },
/* it */ { IDS_JOY_2_DEVICE_IT, "Dispositivo Joystick 2" },
/* ko */ { IDS_JOY_2_DEVICE_KO, "" },  /* fuzzy */
/* nl */ { IDS_JOY_2_DEVICE_NL, "Joy 2 apparaat" },
/* pl */ { IDS_JOY_2_DEVICE_PL, "Urzdzenie joysticka 2" },
/* ru */ { IDS_JOY_2_DEVICE_RU, "Joy 2 Device" },
/* sv */ { IDS_JOY_2_DEVICE_SV, "Enhet fr styrspak 2" },
/* tr */ { IDS_JOY_2_DEVICE_TR, "Joy 2 Aygt" },

/* en */ { IDS_USERPORT_JOY_1_DEVICE,    "Userport Joy 1 Device" },
/* da */ { IDS_USERPORT_JOY_1_DEVICE_DA, "Brugerport Joystick 1 enhed" },
/* de */ { IDS_USERPORT_JOY_1_DEVICE_DE, "Userport Joystick 1 Gert" },
/* es */ { IDS_USERPORT_JOY_1_DEVICE_ES, "Puerto Perifrico Joy 1" },
/* fr */ { IDS_USERPORT_JOY_1_DEVICE_FR, "Priphrique Joystick 1 port utilisateur" },
/* hu */ { IDS_USERPORT_JOY_1_DEVICE_HU, "Userport 1-es botkormny eszkz" },
/* it */ { IDS_USERPORT_JOY_1_DEVICE_IT, "Dispositivo joystick 1 su userport" },
/* ko */ { IDS_USERPORT_JOY_1_DEVICE_KO, "" },  /* fuzzy */
/* nl */ { IDS_USERPORT_JOY_1_DEVICE_NL, "Userport Joy 1 apparaat" },
/* pl */ { IDS_USERPORT_JOY_1_DEVICE_PL, "Urzdzenie userportu joysticka 1" },
/* ru */ { IDS_USERPORT_JOY_1_DEVICE_RU, "Userport Joy 1 Device" },
/* sv */ { IDS_USERPORT_JOY_1_DEVICE_SV, "Anvndarportspak 1 enhet" },
/* tr */ { IDS_USERPORT_JOY_1_DEVICE_TR, "Userport Joy 1 Aygt" },

/* en */ { IDS_USERPORT_JOY_2_DEVICE,    "Userport Joy 2 Device" },
/* da */ { IDS_USERPORT_JOY_2_DEVICE_DA, "Brugerport Joystick 2 enhed" },
/* de */ { IDS_USERPORT_JOY_2_DEVICE_DE, "Userport Joystick 2 Gert" },
/* es */ { IDS_USERPORT_JOY_2_DEVICE_ES, "Puerto Perifrico Joy 2" },
/* fr */ { IDS_USERPORT_JOY_2_DEVICE_FR, "Priphrique Joystick 2 port utilisateur" },
/* hu */ { IDS_USERPORT_JOY_2_DEVICE_HU, "Userport 2-es botkormny eszkz" },
/* it */ { IDS_USERPORT_JOY_2_DEVICE_IT, "Dispositivo joystick 2 su userport" },
/* ko */ { IDS_USERPORT_JOY_2_DEVICE_KO, "" },  /* fuzzy */
/* nl */ { IDS_USERPORT_JOY_2_DEVICE_NL, "Userport Joy 2 apparaat" },
/* pl */ { IDS_USERPORT_JOY_2_DEVICE_PL, "Urzdzenie userportu joysticka 2" },
/* ru */ { IDS_USERPORT_JOY_2_DEVICE_RU, "Userport Joy 2 Device" },
/* sv */ { IDS_USERPORT_JOY_2_DEVICE_SV, "Anvndarportspak 2 enhet" },
/* tr */ { IDS_USERPORT_JOY_2_DEVICE_TR, "Userport Joy 2 Aygt" },

/* en */ { IDS_SIDCART_JOY_DEVICE,    "SIDcart Joy Device" },
/* da */ { IDS_SIDCART_JOY_DEVICE_DA, "SIDcart joystick-enhed" },
/* de */ { IDS_SIDCART_JOY_DEVICE_DE, "SIDcart Joystick Gert" },
/* es */ { IDS_SIDCART_JOY_DEVICE_ES, "Perifrico Joy SIDCart" },
/* fr */ { IDS_SIDCART_JOY_DEVICE_FR, "Priphrique Joystick SIDcart" },
/* hu */ { IDS_SIDCART_JOY_DEVICE_HU, "SIDcart botkormny eszkz" },
/* it */ { IDS_SIDCART_JOY_DEVICE_IT, "Dispositivo Joystick SIDcart" },
/* ko */ { IDS_SIDCART_JOY_DEVICE_KO, "" },  /* fuzzy */
/* nl */ { IDS_SIDCART_JOY_DEVICE_NL, "SIDcart Joy apparaat" },
/* pl */ { IDS_SIDCART_JOY_DEVICE_PL, "Urzdzenie joysticka SIDcart" },
/* ru */ { IDS_SIDCART_JOY_DEVICE_RU, "SIDcart Joy Device" },
/* sv */ { IDS_SIDCART_JOY_DEVICE_SV, "SIDcart-spakenhet" },
/* tr */ { IDS_SIDCART_JOY_DEVICE_TR, "SID Kartuu Joy Aygt" },

/* en */ { IDS_JOY_1_FIRE,    "Joy 1 Fire" },
/* da */ { IDS_JOY_1_FIRE_DA, "Joystick 1 skydeknap" },
/* de */ { IDS_JOY_1_FIRE_DE, "Joystick 1 Feuer" },
/* es */ { IDS_JOY_1_FIRE_ES, "Joy 1 Disparo" },
/* fr */ { IDS_JOY_1_FIRE_FR, "Jeu joystick 1" },
/* hu */ { IDS_JOY_1_FIRE_HU, "1-es botkormny tz" },
/* it */ { IDS_JOY_1_FIRE_IT, "Fuoco Joystick 1" },
/* ko */ { IDS_JOY_1_FIRE_KO, "" },  /* fuzzy */
/* nl */ { IDS_JOY_1_FIRE_NL, "Joy 1 Vuur" },
/* pl */ { IDS_JOY_1_FIRE_PL, "Fire joysticka 1" },
/* ru */ { IDS_JOY_1_FIRE_RU, "Joy 1 Fire" },
/* sv */ { IDS_JOY_1_FIRE_SV, "Fire fr styrspak 1" },
/* tr */ { IDS_JOY_1_FIRE_TR, "Joy 1 Ate" },

/* en */ { IDS_JOY_2_FIRE,    "Joy 2 Fire" },
/* da */ { IDS_JOY_2_FIRE_DA, "Joystick 2 skydeknap" },
/* de */ { IDS_JOY_2_FIRE_DE, "Joystick 2 Feuer" },
/* es */ { IDS_JOY_2_FIRE_ES, "Joy 2 Disparo" },
/* fr */ { IDS_JOY_2_FIRE_FR, "Jeu joystick 2" },
/* hu */ { IDS_JOY_2_FIRE_HU, "2-es botkormny tz" },
/* it */ { IDS_JOY_2_FIRE_IT, "Fuoco Joystick 2" },
/* ko */ { IDS_JOY_2_FIRE_KO, "" },  /* fuzzy */
/* nl */ { IDS_JOY_2_FIRE_NL, "Joy 2 Vuur" },
/* pl */ { IDS_JOY_2_FIRE_PL, "Fire joysticka 2" },
/* ru */ { IDS_JOY_2_FIRE_RU, "Joy 2 Fire" },
/* sv */ { IDS_JOY_2_FIRE_SV, "Fire fr styrspak 2" },
/* tr */ { IDS_JOY_2_FIRE_TR, "Joy 2 Ate" },

/* en */ { IDS_USERPORT_JOY_1_FIRE,    "Userport Joy 1 Fire" },
/* da */ { IDS_USERPORT_JOY_1_FIRE_DA, "Brugerport joystick 1 skydeknap" },
/* de */ { IDS_USERPORT_JOY_1_FIRE_DE, "Userport Joystick 1 Feuer" },
/* es */ { IDS_USERPORT_JOY_1_FIRE_ES, "Puerto Joy 1 Disparo" },
/* fr */ { IDS_USERPORT_JOY_1_FIRE_FR, "FEU Joystick port utilisateur 1" },
/* hu */ { IDS_USERPORT_JOY_1_FIRE_HU, "1-es userport botkormny tz" },
/* it */ { IDS_USERPORT_JOY_1_FIRE_IT, "Fuoco joystick 1 su userport" },
/* ko */ { IDS_USERPORT_JOY_1_FIRE_KO, "" },  /* fuzzy */
/* nl */ { IDS_USERPORT_JOY_1_FIRE_NL, "Userport Joy 1 Vuur" },
/* pl */ { IDS_USERPORT_JOY_1_FIRE_PL, "Fire userportu joysticka 1" },
/* ru */ { IDS_USERPORT_JOY_1_FIRE_RU, "Userport Joy 1 Fire" },
/* sv */ { IDS_USERPORT_JOY_1_FIRE_SV, "Anvndarportspak 1 fire" },
/* tr */ { IDS_USERPORT_JOY_1_FIRE_TR, "Userport Joy 1 Ate" },

/* en */ { IDS_USERPORT_JOY_2_FIRE,    "Userport Joy 2 Fire" },
/* da */ { IDS_USERPORT_JOY_2_FIRE_DA, "Brugerport joystick 2 skydeknap" },
/* de */ { IDS_USERPORT_JOY_2_FIRE_DE, "Userport Joystick 2 Feuer" },
/* es */ { IDS_USERPORT_JOY_2_FIRE_ES, "Puerto Joy 2 Disparo" },
/* fr */ { IDS_USERPORT_JOY_2_FIRE_FR, "FEU Joystick port utilisateur 2" },
/* hu */ { IDS_USERPORT_JOY_2_FIRE_HU, "2-es userport botkormny tz" },
/* it */ { IDS_USERPORT_JOY_2_FIRE_IT, "Fuoco joystick 2 su userport" },
/* ko */ { IDS_USERPORT_JOY_2_FIRE_KO, "" },  /* fuzzy */
/* nl */ { IDS_USERPORT_JOY_2_FIRE_NL, "Userport Joy 2 Vuur" },
/* pl */ { IDS_USERPORT_JOY_2_FIRE_PL, "Fire userportu joysticka 2" },
/* ru */ { IDS_USERPORT_JOY_2_FIRE_RU, "Userport Joy 2 Fire" },
/* sv */ { IDS_USERPORT_JOY_2_FIRE_SV, "Anvndarportspak 2 fire" },
/* tr */ { IDS_USERPORT_JOY_2_FIRE_TR, "Userport Joy 2 Ate" },

/* en */ { IDS_SIDCART_JOY_FIRE,    "SIDcart Joy Fire" },
/* da */ { IDS_SIDCART_JOY_FIRE_DA, "SIDcart joystick skydeknap" },
/* de */ { IDS_SIDCART_JOY_FIRE_DE, "SIDcart Joystick Feuer" },
/* es */ { IDS_SIDCART_JOY_FIRE_ES, "Joy SIDCart Disparo" },
/* fr */ { IDS_SIDCART_JOY_FIRE_FR, "FEU du Joystick SIDcart" },
/* hu */ { IDS_SIDCART_JOY_FIRE_HU, "SIDcart botkormny tz" },
/* it */ { IDS_SIDCART_JOY_FIRE_IT, "Fuoco joystick su SIDcart" },
/* ko */ { IDS_SIDCART_JOY_FIRE_KO, "" },  /* fuzzy */
/* nl */ { IDS_SIDCART_JOY_FIRE_NL, "SIDcart Joy Vuur" },
/* pl */ { IDS_SIDCART_JOY_FIRE_PL, "Fire joysticka SIDcart" },
/* ru */ { IDS_SIDCART_JOY_FIRE_RU, "SIDcart Joy Fire" },
/* sv */ { IDS_SIDCART_JOY_FIRE_SV, "SIDcart-spak fire" },
/* tr */ { IDS_SIDCART_JOY_FIRE_TR, "SID kartuu Joy Ate" },

/* en */ { IDS_SET_INPUT_JOYSTICK_1,    "Joystick #1 emulation: (0: None, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* da */ { IDS_SET_INPUT_JOYSTICK_1_DA, "" },  /* fuzzy */
/* de */ { IDS_SET_INPUT_JOYSTICK_1_DE, "Joystick #1 Emulation: (0: Keine, 1: Numpad, 2: Keysatz A/AI, 3: Keysatz B/AI)" },
/* es */ { IDS_SET_INPUT_JOYSTICK_1_ES, "Emulacin Joystick #1:  (0: Ninguno, 1: Teclado numerico, 2: Tecladot A/AI, 3: Teclado B/AI)" },
/* fr */ { IDS_SET_INPUT_JOYSTICK_1_FR, "" },  /* fuzzy */
/* hu */ { IDS_SET_INPUT_JOYSTICK_1_HU, "" },  /* fuzzy */
/* it */ { IDS_SET_INPUT_JOYSTICK_1_IT, "Emulazione joystick #1: (0: Nessuno, 1: Tastierino numerico, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* ko */ { IDS_SET_INPUT_JOYSTICK_1_KO, "" },  /* fuzzy */
/* nl */ { IDS_SET_INPUT_JOYSTICK_1_NL, "Emulatie joystick #1: (0: Geen, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* pl */ { IDS_SET_INPUT_JOYSTICK_1_PL, "Emulacja joysticka #1: (0: Brak, 1: Klawiatura numeryczna, 2: Klawisze A/AI, 3: Klawisze B/AI)" },
/* ru */ { IDS_SET_INPUT_JOYSTICK_1_RU, "" },  /* fuzzy */
/* sv */ { IDS_SET_INPUT_JOYSTICK_1_SV, "" },  /* fuzzy */
/* tr */ { IDS_SET_INPUT_JOYSTICK_1_TR, "" },  /* fuzzy */

/* en */ { IDS_SET_INPUT_JOYSTICK_2,    "Joystick #2 emulation: (0: None, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* da */ { IDS_SET_INPUT_JOYSTICK_2_DA, "Emulering af Joystick 2: (0: ingen, 1: numerisk, 2: tastest A/AI, 3: tastest B/AI)" },
/* de */ { IDS_SET_INPUT_JOYSTICK_2_DE, "Joystick #2 Emulation: (0: Keine, 1: Numpad, 2: Keysatz A/AI, 3: Keysatz B/AI)" },
/* es */ { IDS_SET_INPUT_JOYSTICK_2_ES, "Emulacin Joystick #2: (0:No, 1: Teclado numrico, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* fr */ { IDS_SET_INPUT_JOYSTICK_2_FR, "mulation joystick #2: (0: Aucune, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* hu */ { IDS_SET_INPUT_JOYSTICK_2_HU, "#2-es botkormny emulci: (0: Nincs, 1: numerikus, 2: 'A' gombkszlet, 3: 'B' gombkszlet)" },
/* it */ { IDS_SET_INPUT_JOYSTICK_2_IT, "Emulazione joystick #2: (0: Nessuna, 1: Tastierino numerico, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* ko */ { IDS_SET_INPUT_JOYSTICK_2_KO, "" },  /* fuzzy */
/* nl */ { IDS_SET_INPUT_JOYSTICK_2_NL, "Emulatie joystick #2: (0: Geen, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* pl */ { IDS_SET_INPUT_JOYSTICK_2_PL, "Emulacja joysticka #2: (0: brak, 1: numeryczna, 2: klawisze A/AI, 3: klawisze B/AI)" },
/* ru */ { IDS_SET_INPUT_JOYSTICK_2_RU, "Joystick #2 emulation: (0: None, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* sv */ { IDS_SET_INPUT_JOYSTICK_2_SV, "Emulering fr styrspak 2: (0: ingen, 1: numerisk, 2: tangentuppsttning A/AI, 3: tangentuppsttning B/AI)" },
/* tr */ { IDS_SET_INPUT_JOYSTICK_2_TR, "Joystick #2 emlasyonu: (0:Yok, 1: Numpad, 2: Tu Seti A/AI, 3: Tu Seti B/AI)" },

/* en */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1,    "Extra joystick #1 emulation: (0: None, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* da */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_DA, "" },  /* fuzzy */
/* de */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_DE, "Extra Joystick #1 Emulation: (0: Keine, 1: Numpad, 2: Keysatz A/AI, 3: Keysatz B/AI)" },
/* es */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_ES, "Emulacin Joystick suplementario #1: (0:Ninguno, 1: Teclado numrico, 2: Teclado A/AI, 3: Teclado B/AI)" },
/* fr */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_FR, "" },  /* fuzzy */
/* hu */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_HU, "" },  /* fuzzy */
/* it */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_IT, "Emulazione joystick supplementare #1: (0: Nessuno, 1: Tastierino numerico, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* ko */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_KO, "" },  /* fuzzy */
/* nl */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_NL, "Emulatie extra joystick #1: (0: Geen, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* pl */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_PL, "Emulacja dodatkowego joysticka #1: (0: Brak, 1: Klawiatura numeryczna, 2: Klawisze A/AI, 3: Klawisze B/AI)" },
/* ru */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_RU, "" },  /* fuzzy */
/* sv */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_SV, "" },  /* fuzzy */
/* tr */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_TR, "" },  /* fuzzy */

/* en */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2,    "Extra joystick #2 emulation: (0: None, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* da */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_DA, "Emulering af Joystick 2: (0: ingen, 1: numerisk, 2: tastest A/AI, 3: tastest B/AI)" },
/* de */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_DE, "Extra Joystick #2 Emulation: (0: Keine, 1: Numpad, 2: Keysatz A/AI, 3: Keysatz B/AI)" },
/* es */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_ES, "Emulacin Joystick suplementario #2: (0:No, 1: Teclado numrico, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* fr */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_FR, "mulation Joystick supplmentaire 2: (0: Aucune, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* hu */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_HU, "" },  /* fuzzy */
/* it */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_IT, "Emulazione joystick supplementare #2: (0: Nessuna, 1: Tastierino numerico, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* ko */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_KO, "" },  /* fuzzy */
/* nl */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_NL, "Emulatie extra joystick #2: (0: Geen, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* pl */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_PL, "Emulacja dodatkowego joysticka #2: (0: brak, 1: numeryczna, 2: klawisze A/AI, 3: klawisze B/AI)" },
/* ru */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_RU, "Extra joystick #2 emulation: (0: None, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* sv */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_SV, "Emulering fr extra styrspak 2: (0: ingen, 1: numerisk, 2: tangentuppsttning A/AI, 3: tangentuppsttning B/AI)" },
/* tr */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_TR, "Ekstra joystick #2 emlasyonu: (0:Yok, 1: Numpad, 2: Tu Seti A/AI, 3: Tu Seti B/AI)" },

/* en */ { IDS_SET_INPUT_EXTRA_JOYSTICK_3,    "Extra joystick #3 emulation: (0: None, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* da */ { IDS_SET_INPUT_EXTRA_JOYSTICK_3_DA, "" },  /* fuzzy */
/* de */ { IDS_SET_INPUT_EXTRA_JOYSTICK_3_DE, "Extra Joystick #3 Emulation: (0: Keine, 1: Numpad, 2: Keysatz A/AI, 3: Keysatz B/AI)" },
/* es */ { IDS_SET_INPUT_EXTRA_JOYSTICK_3_ES, "" },  /* fuzzy */
/* fr */ { IDS_SET_INPUT_EXTRA_JOYSTICK_3_FR, "" },  /* fuzzy */
/* hu */ { IDS_SET_INPUT_EXTRA_JOYSTICK_3_HU, "" },  /* fuzzy */
/* it */ { IDS_SET_INPUT_EXTRA_JOYSTICK_3_IT, "" },  /* fuzzy */
/* ko */ { IDS_SET_INPUT_EXTRA_JOYSTICK_3_KO, "" },  /* fuzzy */
/* nl */ { IDS_SET_INPUT_EXTRA_JOYSTICK_3_NL, "Emulatie extra joystick #3: (0: Geen, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* pl */ { IDS_SET_INPUT_EXTRA_JOYSTICK_3_PL, "" },  /* fuzzy */
/* ru */ { IDS_SET_INPUT_EXTRA_JOYSTICK_3_RU, "" },  /* fuzzy */
/* sv */ { IDS_SET_INPUT_EXTRA_JOYSTICK_3_SV, "" },  /* fuzzy */
/* tr */ { IDS_SET_INPUT_EXTRA_JOYSTICK_3_TR, "" },  /* fuzzy */

/* en */ { IDS_SET_INPUT_JOYLL_1,    "Joystick #1 emulation: (0: None, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* da */ { IDS_SET_INPUT_JOYLL_1_DA, "Joystick 1 emularing: (0: ingen, 1: numerisk, 2-5: Amigajoystick 0-3)" },
/* de */ { IDS_SET_INPUT_JOYLL_1_DE, "Joystick #1 Emulation: (0: Keine, 1: Numpad, 2-5: Amiga Joystick 0-3)" },
/* es */ { IDS_SET_INPUT_JOYLL_1_ES, "Emulacin Joystick #1: (0:No, 1: Teclado numrico, 2-5: Amiga Joy0-3 )" },
/* fr */ { IDS_SET_INPUT_JOYLL_1_FR, "mulation Joystick 1: (0: Aucune, 1: Pav.Num., 2-5: Amiga Joy 0-3)" },
/* hu */ { IDS_SET_INPUT_JOYLL_1_HU, "#1-es botkormny emulci: (0: nincs, 1: numerikus billentyk, 2-5: amiga botkormny 0-3)" },
/* it */ { IDS_SET_INPUT_JOYLL_1_IT, "Emulazione joystick #1: (0: Nessuna, 1: Tastierino numerico, 2-5: Joy Amiga 0-3)" },
/* ko */ { IDS_SET_INPUT_JOYLL_1_KO, "" },  /* fuzzy */
/* nl */ { IDS_SET_INPUT_JOYLL_1_NL, "Emulatie joystick #1: (0: Geen, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* pl */ { IDS_SET_INPUT_JOYLL_1_PL, "Emulacja joysticka #1: (0: brak, 1: numeryczna, 2-5: joystick Amigi 0-3)" },
/* ru */ { IDS_SET_INPUT_JOYLL_1_RU, "Joystick #1 emulation: (0: None, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* sv */ { IDS_SET_INPUT_JOYLL_1_SV, "Emulering fr styrspak 1: (0: ingen, 1: numerisk, 2-5: Amigastyrspak 0-3)" },
/* tr */ { IDS_SET_INPUT_JOYLL_1_TR, "Joystick #1 emlasyonu: (0: Yok, 1: Numpad, 2-5: Amiga Joy 0-3)" },

/* en */ { IDS_SET_INPUT_JOYLL_2,    "Joystick #2 emulation: (0: None, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* da */ { IDS_SET_INPUT_JOYLL_2_DA, "Joystick 2 emularing: (0: ingen, 1: numerisk, 2-5: Amigajoystick 0-3)" },
/* de */ { IDS_SET_INPUT_JOYLL_2_DE, "Joystick #2 Emulation: (0: Keine, 1: Numpad, 2-5: Amiga Joystick 0-3)" },
/* es */ { IDS_SET_INPUT_JOYLL_2_ES, "Emulacin Joystick #2: (0:No, 1: Teclado numrico, 2-5: Amiga Joy0-3 )" },
/* fr */ { IDS_SET_INPUT_JOYLL_2_FR, "mulation Joystick 2: (0: Aucune, 1: Numpad, 2-5: Amiga Joy 0-33)" },
/* hu */ { IDS_SET_INPUT_JOYLL_2_HU, "#2-es botkormny emulci: (0: nincs, 1: numerikus billentyk, 2-5: amiga botkormny 0-3)" },
/* it */ { IDS_SET_INPUT_JOYLL_2_IT, "Emulazione joystick #2: (0: Nessuna, 1: Tastierino numerico, 2-5: Joy Amiga 0-3)" },
/* ko */ { IDS_SET_INPUT_JOYLL_2_KO, "" },  /* fuzzy */
/* nl */ { IDS_SET_INPUT_JOYLL_2_NL, "Emulatie joystick #2: (0: Geen, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* pl */ { IDS_SET_INPUT_JOYLL_2_PL, "Emulacja joysticka #2: (0: brak, 1: numeryczna, 2-5: joystick Amigi 0-3)" },
/* ru */ { IDS_SET_INPUT_JOYLL_2_RU, "Joystick #2 emulation: (0: None, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* sv */ { IDS_SET_INPUT_JOYLL_2_SV, "Emulering fr styrspak 2: (0: ingen, 1: numerisk, 2-5: Amigastyrspak 0-3)" },
/* tr */ { IDS_SET_INPUT_JOYLL_2_TR, "Joystick #2 emlasyonu: (0: Yok, 1: Numpad, 2-5: Amiga Joy 0-3)" },

/* en */ { IDS_SET_INPUT_EXTRA_JOYLL_1,    "Extra joystick #1 emulation: (0: None, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* da */ { IDS_SET_INPUT_EXTRA_JOYLL_1_DA, "Ekstra joystick 1 emulering: (0: ingen, 1: numerisk, 2-5: Amigajoystick 0-3)" },
/* de */ { IDS_SET_INPUT_EXTRA_JOYLL_1_DE, "Extra Joystick #1 Emulation: (0: Keine, 1: Numpad, 2-5: Amiga Joystick 0-3)" },
/* es */ { IDS_SET_INPUT_EXTRA_JOYLL_1_ES, "Emulacin Joystick suplementario #1: (0:No, 1: Teclado numrico, 2-5: Amiga Joy0-3 )" },
/* fr */ { IDS_SET_INPUT_EXTRA_JOYLL_1_FR, "mulation Joystick supplmentaire 1: (0: Aucune, 1: Pav.Num., 2-5: Amiga Joy 0-3)" },
/* hu */ { IDS_SET_INPUT_EXTRA_JOYLL_1_HU, "#1-es extra botkormny emulci (0: Nincs, 1: numerikus, 2-5: Amiga botkormny 0-3)" },
/* it */ { IDS_SET_INPUT_EXTRA_JOYLL_1_IT, "Emulazione joystick supplementare #1: (0: Nessuna, 1: Tastierino numerico, 2-5: Joy Amiga 0-3)" },
/* ko */ { IDS_SET_INPUT_EXTRA_JOYLL_1_KO, "" },  /* fuzzy */
/* nl */ { IDS_SET_INPUT_EXTRA_JOYLL_1_NL, "Emulatie extra joystick #1: (0: Geen, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* pl */ { IDS_SET_INPUT_EXTRA_JOYLL_1_PL, "Emulacja dodatkowego joysticka #1: (0: brak, 1: numeryczna, 2-5: joystick Amigi 0-3)" },
/* ru */ { IDS_SET_INPUT_EXTRA_JOYLL_1_RU, "Extra joystick #1 emulation: (0: None, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* sv */ { IDS_SET_INPUT_EXTRA_JOYLL_1_SV, "Emulering fr extra styrspak 1: (0: ingen, 1: numerisk, 2-5: Amigastyrspak 0-3)" },
/* tr */ { IDS_SET_INPUT_EXTRA_JOYLL_1_TR, "Ekstra joystick #1 emlasyonu: (0: Yok, 1: Numpad, 2-5: Amiga Joy 0-3)" },

/* en */ { IDS_SET_INPUT_EXTRA_JOYLL_2,    "Extra joystick #2 emulation: (0: None, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* da */ { IDS_SET_INPUT_EXTRA_JOYLL_2_DA, "Ekstra joystick 2 emulering: (0: ingen, 1: numerisk, 2-5: Amigajoystick 0-3)" },
/* de */ { IDS_SET_INPUT_EXTRA_JOYLL_2_DE, "Extra Joystick #2 Emulation: (0: Keine, 1: Numpad, 2-5: Amiga Joystick 0-3)" },
/* es */ { IDS_SET_INPUT_EXTRA_JOYLL_2_ES, "Emulacin Joystick suplementario #2: (0:No, 1: Teclado numrico, 2-5: Amiga Joy0-3 )" },
/* fr */ { IDS_SET_INPUT_EXTRA_JOYLL_2_FR, "mulation Joystick supplmentaire 2: (0: Aucune, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* hu */ { IDS_SET_INPUT_EXTRA_JOYLL_2_HU, "#2-es extra botkormny emulci (0: Nincs, 1: numerikus, 2-5: Amiga botkormny 0-3)" },
/* it */ { IDS_SET_INPUT_EXTRA_JOYLL_2_IT, "Emulazione joystick supplementare #2: (0: Nessuna, 1: Tastierino numerico, 2-5: Joy Amiga 0-3)" },
/* ko */ { IDS_SET_INPUT_EXTRA_JOYLL_2_KO, "" },  /* fuzzy */
/* nl */ { IDS_SET_INPUT_EXTRA_JOYLL_2_NL, "Emulatie extra joystick #2: (0: Geen, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* pl */ { IDS_SET_INPUT_EXTRA_JOYLL_2_PL, "Emulacja dodatkowego joysticka #2: (0: brak, 1: numeryczna, 2-5: joystick Amigi 0-3)" },
/* ru */ { IDS_SET_INPUT_EXTRA_JOYLL_2_RU, "Extra joystick #2 emulation: (0: None, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* sv */ { IDS_SET_INPUT_EXTRA_JOYLL_2_SV, "Emulering fr extra styrspak 2: (0: ingen, 1: numerisk, 2-5: Amigastyrspak 0-3)" },
/* tr */ { IDS_SET_INPUT_EXTRA_JOYLL_2_TR, "Ekstra joystick #2 emlasyonu: (0: Yok, 1: Numpad, 2-5: Amiga Joy 0-3)" },

/* en */ { IDS_SET_INPUT_EXTRA_JOYLL_3,    "Extra joystick #3 emulation: (0: None, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* da */ { IDS_SET_INPUT_EXTRA_JOYLL_3_DA, "" },  /* fuzzy */
/* de */ { IDS_SET_INPUT_EXTRA_JOYLL_3_DE, "Extra Joystick #3 Emulation: (0: Keine, 1: Numpad, 2-5: Amiga Joystick 0-3)" },
/* es */ { IDS_SET_INPUT_EXTRA_JOYLL_3_ES, "" },  /* fuzzy */
/* fr */ { IDS_SET_INPUT_EXTRA_JOYLL_3_FR, "" },  /* fuzzy */
/* hu */ { IDS_SET_INPUT_EXTRA_JOYLL_3_HU, "" },  /* fuzzy */
/* it */ { IDS_SET_INPUT_EXTRA_JOYLL_3_IT, "" },  /* fuzzy */
/* ko */ { IDS_SET_INPUT_EXTRA_JOYLL_3_KO, "" },  /* fuzzy */
/* nl */ { IDS_SET_INPUT_EXTRA_JOYLL_3_NL, "Emulatie extra joystick #3: (0: Geen, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* pl */ { IDS_SET_INPUT_EXTRA_JOYLL_3_PL, "" },  /* fuzzy */
/* ru */ { IDS_SET_INPUT_EXTRA_JOYLL_3_RU, "" },  /* fuzzy */
/* sv */ { IDS_SET_INPUT_EXTRA_JOYLL_3_SV, "" },  /* fuzzy */
/* tr */ { IDS_SET_INPUT_EXTRA_JOYLL_3_TR, "" },  /* fuzzy */

/* en */ { IDS_SAVE_SETTINGS_ON_EXIT,    "Save settings on exit" },
/* da */ { IDS_SAVE_SETTINGS_ON_EXIT_DA, "Gem indstillinger nr programmet afsluttes" },
/* de */ { IDS_SAVE_SETTINGS_ON_EXIT_DE, "Einstellungen beim Beenden speichern" },
/* es */ { IDS_SAVE_SETTINGS_ON_EXIT_ES, "Grabar ajustes al salir" },
/* fr */ { IDS_SAVE_SETTINGS_ON_EXIT_FR, "Enregistrer les paramtres  la sortie" },
/* hu */ { IDS_SAVE_SETTINGS_ON_EXIT_HU, "Belltsok mentse kilpskor" },
/* it */ { IDS_SAVE_SETTINGS_ON_EXIT_IT, "Salva impostazioni in uscita" },
/* ko */ { IDS_SAVE_SETTINGS_ON_EXIT_KO, "  ϱ" },
/* nl */ { IDS_SAVE_SETTINGS_ON_EXIT_NL, "Sla instellingen op bij afsluiten" },
/* pl */ { IDS_SAVE_SETTINGS_ON_EXIT_PL, "Zapisz ustawienia przy wyjciu" },
/* ru */ { IDS_SAVE_SETTINGS_ON_EXIT_RU, "   " },
/* sv */ { IDS_SAVE_SETTINGS_ON_EXIT_SV, "Spara instllningar vid avslut" },
/* tr */ { IDS_SAVE_SETTINGS_ON_EXIT_TR, "kta ayarlar kaydet" },

/* en */ { IDS_NEVER_SAVE_SETTINGS_EXIT,    "Never save settings on exit" },
/* da */ { IDS_NEVER_SAVE_SETTINGS_EXIT_DA, "Gem aldrig indstillinger nr programmet afsluttes" },
/* de */ { IDS_NEVER_SAVE_SETTINGS_EXIT_DE, "Einstellungen beim Beenden nie speichern" },
/* es */ { IDS_NEVER_SAVE_SETTINGS_EXIT_ES, "no grabar ajustes al salir" },
/* fr */ { IDS_NEVER_SAVE_SETTINGS_EXIT_FR, "NE PAS enregistrer les paramtres  la sortie" },
/* hu */ { IDS_NEVER_SAVE_SETTINGS_EXIT_HU, "" },  /* fuzzy */
/* it */ { IDS_NEVER_SAVE_SETTINGS_EXIT_IT, "Non salvare impostazioni in uscita" },
/* ko */ { IDS_NEVER_SAVE_SETTINGS_EXIT_KO, "    ʽϴ" },
/* nl */ { IDS_NEVER_SAVE_SETTINGS_EXIT_NL, "Instellingen nooit opslaan bij afsluiten" },
/* pl */ { IDS_NEVER_SAVE_SETTINGS_EXIT_PL, "Nigdy nie zapisuj ustawie przy wyjciu" },
/* ru */ { IDS_NEVER_SAVE_SETTINGS_EXIT_RU, "     " },
/* sv */ { IDS_NEVER_SAVE_SETTINGS_EXIT_SV, "Spara aldrig instllningar vid avslut" },
/* tr */ { IDS_NEVER_SAVE_SETTINGS_EXIT_TR, "kta ayarlar asla kaydetme" },

/* en */ { IDS_CONFIRM_QUITING_VICE,    "Confirm quitting VICE" },
/* da */ { IDS_CONFIRM_QUITING_VICE_DA, "Bekrft programafslutning" },
/* de */ { IDS_CONFIRM_QUITING_VICE_DE, "Besttige Beenden von VICE" },
/* es */ { IDS_CONFIRM_QUITING_VICE_ES, "Confirmar cierre de VICE" },
/* fr */ { IDS_CONFIRM_QUITING_VICE_FR, "Confirmer avant de quitter VICE" },
/* hu */ { IDS_CONFIRM_QUITING_VICE_HU, "" },  /* fuzzy */
/* it */ { IDS_CONFIRM_QUITING_VICE_IT, "Conferma l'uscita da VICE" },
/* ko */ { IDS_CONFIRM_QUITING_VICE_KO, "VICE Ȯ " },
/* nl */ { IDS_CONFIRM_QUITING_VICE_NL, "Bevestigen van het aflsuiten van VICE" },
/* pl */ { IDS_CONFIRM_QUITING_VICE_PL, "Potwierdzaj zamknicie VICE" },
/* ru */ { IDS_CONFIRM_QUITING_VICE_RU, "  VICE" },
/* sv */ { IDS_CONFIRM_QUITING_VICE_SV, "Bekrfta fr att avsluta VICE" },
/* tr */ { IDS_CONFIRM_QUITING_VICE_TR, "VICE'dan k teyit et" },

/* en */ { IDS_NEVER_CONFIRM_QUITING_VICE,    "Never confirm quitting VICE" },
/* da */ { IDS_NEVER_CONFIRM_QUITING_VICE_DA, "Bekrft ikke programafslutning" },
/* de */ { IDS_NEVER_CONFIRM_QUITING_VICE_DE, "Keine Besttigung beim Beenden von VICE" },
/* es */ { IDS_NEVER_CONFIRM_QUITING_VICE_ES, "Nunca confirmar cierre de VICE" },
/* fr */ { IDS_NEVER_CONFIRM_QUITING_VICE_FR, "Ne pas confirmer pour quitter VICE" },
/* hu */ { IDS_NEVER_CONFIRM_QUITING_VICE_HU, "" },  /* fuzzy */
/* it */ { IDS_NEVER_CONFIRM_QUITING_VICE_IT, "Never confirm quitting VICE" },
/* ko */ { IDS_NEVER_CONFIRM_QUITING_VICE_KO, "VICE    ʽϴ" },
/* nl */ { IDS_NEVER_CONFIRM_QUITING_VICE_NL, "Niet bevestigen van het afsluiten van VICE" },
/* pl */ { IDS_NEVER_CONFIRM_QUITING_VICE_PL, "Nigdy nie potwierdzaj zamknicia VICE" },
/* ru */ { IDS_NEVER_CONFIRM_QUITING_VICE_RU, "    VICE" },
/* sv */ { IDS_NEVER_CONFIRM_QUITING_VICE_SV, "Bekrfta inte fr att avsluta VICE" },
/* tr */ { IDS_NEVER_CONFIRM_QUITING_VICE_TR, "VICE'dan k asla teyit etme" },

/* en */ { IDS_SPECIFY_INITIAL_DEFAULT_DIR,    "Specify initial default directory." },
/* da */ { IDS_SPECIFY_INITIAL_DEFAULT_DIR_DA, "" },  /* fuzzy */
/* de */ { IDS_SPECIFY_INITIAL_DEFAULT_DIR_DE, "Initiales Standardverzeichnis whlen." },
/* es */ { IDS_SPECIFY_INITIAL_DEFAULT_DIR_ES, "Especificar directorio por defecto inicial" },
/* fr */ { IDS_SPECIFY_INITIAL_DEFAULT_DIR_FR, "" },  /* fuzzy */
/* hu */ { IDS_SPECIFY_INITIAL_DEFAULT_DIR_HU, "" },  /* fuzzy */
/* it */ { IDS_SPECIFY_INITIAL_DEFAULT_DIR_IT, "Specifica la directory predefinita." },
/* ko */ { IDS_SPECIFY_INITIAL_DEFAULT_DIR_KO, "" },  /* fuzzy */
/* nl */ { IDS_SPECIFY_INITIAL_DEFAULT_DIR_NL, "Selecteer aanvankelijke standaard folder." },
/* pl */ { IDS_SPECIFY_INITIAL_DEFAULT_DIR_PL, "Okrel pocztkowy katalog domylny." },
/* ru */ { IDS_SPECIFY_INITIAL_DEFAULT_DIR_RU, "" },  /* fuzzy */
/* sv */ { IDS_SPECIFY_INITIAL_DEFAULT_DIR_SV, "" },  /* fuzzy */
/* tr */ { IDS_SPECIFY_INITIAL_DEFAULT_DIR_TR, "" },  /* fuzzy */

/* en */ { IDS_SPECIFY_INITIAL_TAPE_DIR,    "Specify initial tape directory." },
/* da */ { IDS_SPECIFY_INITIAL_TAPE_DIR_DA, "" },  /* fuzzy */
/* de */ { IDS_SPECIFY_INITIAL_TAPE_DIR_DE, "Intiales Bandverzeichnis whlen." },
/* es */ { IDS_SPECIFY_INITIAL_TAPE_DIR_ES, "Especificar directorio inicial de Cinta" },
/* fr */ { IDS_SPECIFY_INITIAL_TAPE_DIR_FR, "" },  /* fuzzy */
/* hu */ { IDS_SPECIFY_INITIAL_TAPE_DIR_HU, "" },  /* fuzzy */
/* it */ { IDS_SPECIFY_INITIAL_TAPE_DIR_IT, "Specifica la directory iniziale delle cassette." },
/* ko */ { IDS_SPECIFY_INITIAL_TAPE_DIR_KO, "" },  /* fuzzy */
/* nl */ { IDS_SPECIFY_INITIAL_TAPE_DIR_NL, "Selecteer aanvankelijke tape folder." },
/* pl */ { IDS_SPECIFY_INITIAL_TAPE_DIR_PL, "Wybierz pocztkowy katalog tamy" },
/* ru */ { IDS_SPECIFY_INITIAL_TAPE_DIR_RU, "" },  /* fuzzy */
/* sv */ { IDS_SPECIFY_INITIAL_TAPE_DIR_SV, "" },  /* fuzzy */
/* tr */ { IDS_SPECIFY_INITIAL_TAPE_DIR_TR, "" },  /* fuzzy */

/* en */ { IDS_SPECIFY_INITIAL_DISK_DIR,    "Specify initial disk directory." },
/* da */ { IDS_SPECIFY_INITIAL_DISK_DIR_DA, "" },  /* fuzzy */
/* de */ { IDS_SPECIFY_INITIAL_DISK_DIR_DE, "Initiales Diskverzeichnis whlen." },
/* es */ { IDS_SPECIFY_INITIAL_DISK_DIR_ES, "Especificar directorio inicial de Disco" },
/* fr */ { IDS_SPECIFY_INITIAL_DISK_DIR_FR, "" },  /* fuzzy */
/* hu */ { IDS_SPECIFY_INITIAL_DISK_DIR_HU, "" },  /* fuzzy */
/* it */ { IDS_SPECIFY_INITIAL_DISK_DIR_IT, "Specifica la directory iniziale dei dischi." },
/* ko */ { IDS_SPECIFY_INITIAL_DISK_DIR_KO, "" },  /* fuzzy */
/* nl */ { IDS_SPECIFY_INITIAL_DISK_DIR_NL, "Selecteer aanvankelijke disk folder." },
/* pl */ { IDS_SPECIFY_INITIAL_DISK_DIR_PL, "Wybierz pocztkowy katalog dysku" },
/* ru */ { IDS_SPECIFY_INITIAL_DISK_DIR_RU, "" },  /* fuzzy */
/* sv */ { IDS_SPECIFY_INITIAL_DISK_DIR_SV, "" },  /* fuzzy */
/* tr */ { IDS_SPECIFY_INITIAL_DISK_DIR_TR, "" },  /* fuzzy */

/* en */ { IDS_SPECIFY_INITIAL_AUTOSTART_DIR,    "Specify initial autostart directory." },
/* da */ { IDS_SPECIFY_INITIAL_AUTOSTART_DIR_DA, "" },  /* fuzzy */
/* de */ { IDS_SPECIFY_INITIAL_AUTOSTART_DIR_DE, "Initiales Autostartverzeichnis whlen." },
/* es */ { IDS_SPECIFY_INITIAL_AUTOSTART_DIR_ES, "Seleccionar directorio inicial de Autoarranque" },
/* fr */ { IDS_SPECIFY_INITIAL_AUTOSTART_DIR_FR, "" },  /* fuzzy */
/* hu */ { IDS_SPECIFY_INITIAL_AUTOSTART_DIR_HU, "" },  /* fuzzy */
/* it */ { IDS_SPECIFY_INITIAL_AUTOSTART_DIR_IT, "Specifica la directory iniziale dell'avvio automatico." },
/* ko */ { IDS_SPECIFY_INITIAL_AUTOSTART_DIR_KO, "" },  /* fuzzy */
/* nl */ { IDS_SPECIFY_INITIAL_AUTOSTART_DIR_NL, "Selecteer aanvankelijke autostart folder." },
/* pl */ { IDS_SPECIFY_INITIAL_AUTOSTART_DIR_PL, "Wybierz pocztkowy katalog autostartu" },
/* ru */ { IDS_SPECIFY_INITIAL_AUTOSTART_DIR_RU, "" },  /* fuzzy */
/* sv */ { IDS_SPECIFY_INITIAL_AUTOSTART_DIR_SV, "" },  /* fuzzy */
/* tr */ { IDS_SPECIFY_INITIAL_AUTOSTART_DIR_TR, "" },  /* fuzzy */

/* en */ { IDS_SPECIFY_INITIAL_CART_DIR,    "Specify initial cartridge directory." },
/* da */ { IDS_SPECIFY_INITIAL_CART_DIR_DA, "" },  /* fuzzy */
/* de */ { IDS_SPECIFY_INITIAL_CART_DIR_DE, "Initiales Modulverzeichnis whlen." },
/* es */ { IDS_SPECIFY_INITIAL_CART_DIR_ES, "Especificar directorio inicial de Cartuchos" },
/* fr */ { IDS_SPECIFY_INITIAL_CART_DIR_FR, "" },  /* fuzzy */
/* hu */ { IDS_SPECIFY_INITIAL_CART_DIR_HU, "" },  /* fuzzy */
/* it */ { IDS_SPECIFY_INITIAL_CART_DIR_IT, "Specifica la directory iniziale delle cartucce." },
/* ko */ { IDS_SPECIFY_INITIAL_CART_DIR_KO, "" },  /* fuzzy */
/* nl */ { IDS_SPECIFY_INITIAL_CART_DIR_NL, "Selecteer aanvankelijke cartridge folder." },
/* pl */ { IDS_SPECIFY_INITIAL_CART_DIR_PL, "Wybierz pocztkowy katalog kartridy" },
/* ru */ { IDS_SPECIFY_INITIAL_CART_DIR_RU, "" },  /* fuzzy */
/* sv */ { IDS_SPECIFY_INITIAL_CART_DIR_SV, "" },  /* fuzzy */
/* tr */ { IDS_SPECIFY_INITIAL_CART_DIR_TR, "" },  /* fuzzy */

/* en */ { IDS_SPECIFY_INITIAL_SNAPSHOT_DIR,    "Specify initial snapshot directory." },
/* da */ { IDS_SPECIFY_INITIAL_SNAPSHOT_DIR_DA, "" },  /* fuzzy */
/* de */ { IDS_SPECIFY_INITIAL_SNAPSHOT_DIR_DE, "Initiales Snapshot verzeichnis whlen." },
/* es */ { IDS_SPECIFY_INITIAL_SNAPSHOT_DIR_ES, "Especificar directorio inicial de Instantaneas" },
/* fr */ { IDS_SPECIFY_INITIAL_SNAPSHOT_DIR_FR, "" },  /* fuzzy */
/* hu */ { IDS_SPECIFY_INITIAL_SNAPSHOT_DIR_HU, "" },  /* fuzzy */
/* it */ { IDS_SPECIFY_INITIAL_SNAPSHOT_DIR_IT, "Specifica la directory iniziale degli snapshot." },
/* ko */ { IDS_SPECIFY_INITIAL_SNAPSHOT_DIR_KO, "" },  /* fuzzy */
/* nl */ { IDS_SPECIFY_INITIAL_SNAPSHOT_DIR_NL, "Selecteer aanvankelijke snapshot folder." },
/* pl */ { IDS_SPECIFY_INITIAL_SNAPSHOT_DIR_PL, "Wybierz pocztkowy katalog zrzutw" },
/* ru */ { IDS_SPECIFY_INITIAL_SNAPSHOT_DIR_RU, "" },  /* fuzzy */
/* sv */ { IDS_SPECIFY_INITIAL_SNAPSHOT_DIR_SV, "" },  /* fuzzy */
/* tr */ { IDS_SPECIFY_INITIAL_SNAPSHOT_DIR_TR, "" },  /* fuzzy */

/* en */ { IDS_ENABLE_FULLSCREEN,    "Enable fullscreen." },
/* da */ { IDS_ENABLE_FULLSCREEN_DA, "" },  /* fuzzy */
/* de */ { IDS_ENABLE_FULLSCREEN_DE, "Vollbild Modus aktivieren." },
/* es */ { IDS_ENABLE_FULLSCREEN_ES, "Permitir pantalla completa" },
/* fr */ { IDS_ENABLE_FULLSCREEN_FR, "" },  /* fuzzy */
/* hu */ { IDS_ENABLE_FULLSCREEN_HU, "" },  /* fuzzy */
/* it */ { IDS_ENABLE_FULLSCREEN_IT, "Attiva schermo intero." },
/* ko */ { IDS_ENABLE_FULLSCREEN_KO, "" },  /* fuzzy */
/* nl */ { IDS_ENABLE_FULLSCREEN_NL, "Activeer volscherm." },
/* pl */ { IDS_ENABLE_FULLSCREEN_PL, "Wcz peny ekran." },
/* ru */ { IDS_ENABLE_FULLSCREEN_RU, "" },  /* fuzzy */
/* sv */ { IDS_ENABLE_FULLSCREEN_SV, "" },  /* fuzzy */
/* tr */ { IDS_ENABLE_FULLSCREEN_TR, "" },  /* fuzzy */

/* en */ { IDS_DISABLE_FULLSCREEN,    "Disable fullscreen." },
/* da */ { IDS_DISABLE_FULLSCREEN_DA, "" },  /* fuzzy */
/* de */ { IDS_DISABLE_FULLSCREEN_DE, "Vollbild Modus deaktivieren." },
/* es */ { IDS_DISABLE_FULLSCREEN_ES, "inhabilitar  pantalla completa" },
/* fr */ { IDS_DISABLE_FULLSCREEN_FR, "" },  /* fuzzy */
/* hu */ { IDS_DISABLE_FULLSCREEN_HU, "" },  /* fuzzy */
/* it */ { IDS_DISABLE_FULLSCREEN_IT, "Disattiva schermo intero." },
/* ko */ { IDS_DISABLE_FULLSCREEN_KO, "" },  /* fuzzy */
/* nl */ { IDS_DISABLE_FULLSCREEN_NL, "Volscherm uitschakelen." },
/* pl */ { IDS_DISABLE_FULLSCREEN_PL, "Wycz peny ekran." },
/* ru */ { IDS_DISABLE_FULLSCREEN_RU, "" },  /* fuzzy */
/* sv */ { IDS_DISABLE_FULLSCREEN_SV, "" },  /* fuzzy */
/* tr */ { IDS_DISABLE_FULLSCREEN_TR, "" },  /* fuzzy */

/* en */ { IDS_ENABLE_STATUSBAR,    "Enable statusbar." },
/* da */ { IDS_ENABLE_STATUSBAR_DA, "" },  /* fuzzy */
/* de */ { IDS_ENABLE_STATUSBAR_DE, "Statusleiste aktivieren." },
/* es */ { IDS_ENABLE_STATUSBAR_ES, "Permitir barra de estado" },
/* fr */ { IDS_ENABLE_STATUSBAR_FR, "" },  /* fuzzy */
/* hu */ { IDS_ENABLE_STATUSBAR_HU, "" },  /* fuzzy */
/* it */ { IDS_ENABLE_STATUSBAR_IT, "Attiva barra di stato." },
/* ko */ { IDS_ENABLE_STATUSBAR_KO, "" },  /* fuzzy */
/* nl */ { IDS_ENABLE_STATUSBAR_NL, "Activeer statusbalk" },
/* pl */ { IDS_ENABLE_STATUSBAR_PL, "Wcz pasek stanu." },
/* ru */ { IDS_ENABLE_STATUSBAR_RU, "" },  /* fuzzy */
/* sv */ { IDS_ENABLE_STATUSBAR_SV, "" },  /* fuzzy */
/* tr */ { IDS_ENABLE_STATUSBAR_TR, "" },  /* fuzzy */

/* en */ { IDS_DISABLE_STATUSBAR,    "Disable statusbar." },
/* da */ { IDS_DISABLE_STATUSBAR_DA, "" },  /* fuzzy */
/* de */ { IDS_DISABLE_STATUSBAR_DE, "Statusleiste deaktivieren." },
/* es */ { IDS_DISABLE_STATUSBAR_ES, "inhabilitar  barra de estado" },
/* fr */ { IDS_DISABLE_STATUSBAR_FR, "" },  /* fuzzy */
/* hu */ { IDS_DISABLE_STATUSBAR_HU, "" },  /* fuzzy */
/* it */ { IDS_DISABLE_STATUSBAR_IT, "Disattiva barra di stato." },
/* ko */ { IDS_DISABLE_STATUSBAR_KO, "" },  /* fuzzy */
/* nl */ { IDS_DISABLE_STATUSBAR_NL, "Statusbalk uitschakelen" },
/* pl */ { IDS_DISABLE_STATUSBAR_PL, "Wycz pasek stanu." },
/* ru */ { IDS_DISABLE_STATUSBAR_RU, "" },  /* fuzzy */
/* sv */ { IDS_DISABLE_STATUSBAR_SV, "" },  /* fuzzy */
/* tr */ { IDS_DISABLE_STATUSBAR_TR, "" },  /* fuzzy */

#if defined(HAVE_PROTO_CYBERGRAPHICS_H) && defined(HAVE_XVIDEO)
/* en */ { IDS_ENABLE_VIDEOOVERLAY,    "Enable video overlay." },
/* da */ { IDS_ENABLE_VIDEOOVERLAY_DA, "" },  /* fuzzy */
/* de */ { IDS_ENABLE_VIDEOOVERLAY_DE, "Video Overlay aktivieren." },
/* es */ { IDS_ENABLE_VIDEOOVERLAY_ES, "Permitir Video overlay" },
/* fr */ { IDS_ENABLE_VIDEOOVERLAY_FR, "" },  /* fuzzy */
/* hu */ { IDS_ENABLE_VIDEOOVERLAY_HU, "" },  /* fuzzy */
/* it */ { IDS_ENABLE_VIDEOOVERLAY_IT, "Attiva overlay video." },
/* ko */ { IDS_ENABLE_VIDEOOVERLAY_KO, "" },  /* fuzzy */
/* nl */ { IDS_ENABLE_VIDEOOVERLAY_NL, "Activeer video overlay" },
/* pl */ { IDS_ENABLE_VIDEOOVERLAY_PL, "Wcz video overlay" },
/* ru */ { IDS_ENABLE_VIDEOOVERLAY_RU, "" },  /* fuzzy */
/* sv */ { IDS_ENABLE_VIDEOOVERLAY_SV, "" },  /* fuzzy */
/* tr */ { IDS_ENABLE_VIDEOOVERLAY_TR, "" },  /* fuzzy */

/* en */ { IDS_DISABLE_VIDEOOVERLAY,    "Disable video overlay." },
/* da */ { IDS_DISABLE_VIDEOOVERLAY_DA, "" },  /* fuzzy */
/* de */ { IDS_DISABLE_VIDEOOVERLAY_DE, "Video Overlay deaktivieren." },
/* es */ { IDS_DISABLE_VIDEOOVERLAY_ES, "Inhabilitar Video overlay" },
/* fr */ { IDS_DISABLE_VIDEOOVERLAY_FR, "" },  /* fuzzy */
/* hu */ { IDS_DISABLE_VIDEOOVERLAY_HU, "" },  /* fuzzy */
/* it */ { IDS_DISABLE_VIDEOOVERLAY_IT, "Disattiva overlay video." },
/* ko */ { IDS_DISABLE_VIDEOOVERLAY_KO, "" },  /* fuzzy */
/* nl */ { IDS_DISABLE_VIDEOOVERLAY_NL, "Video overlay uitschakelen" },
/* pl */ { IDS_DISABLE_VIDEOOVERLAY_PL, "Wycz video overlay" },
/* ru */ { IDS_DISABLE_VIDEOOVERLAY_RU, "" },  /* fuzzy */
/* sv */ { IDS_DISABLE_VIDEOOVERLAY_SV, "" },  /* fuzzy */
/* tr */ { IDS_DISABLE_VIDEOOVERLAY_TR, "" },  /* fuzzy */

/* en */ { IDS_PET_REU_SIZE,    "PET REU size" },
/* da */ { IDS_PET_REU_SIZE_DA, "PET REU strrelse" },
/* de */ { IDS_PET_REU_SIZE_DE, "PET REU Gre" },
/* es */ { IDS_PET_REU_SIZE_ES, "Tamao REU PET" },
/* fr */ { IDS_PET_REU_SIZE_FR, "Taille du PET REU" },
/* hu */ { IDS_PET_REU_SIZE_HU, "PET REU mrete" },
/* it */ { IDS_PET_REU_SIZE_IT, "Dimensione PET REU" },
/* ko */ { IDS_PET_REU_SIZE_KO, "" },  /* fuzzy */
/* nl */ { IDS_PET_REU_SIZE_NL, "PET REU grootte" },
/* pl */ { IDS_PET_REU_SIZE_PL, "Rozmiar PET REU" },
/* ru */ { IDS_PET_REU_SIZE_RU, "PET REU size" },
/* sv */ { IDS_PET_REU_SIZE_SV, "Storlek p PET REU" },
/* tr */ { IDS_PET_REU_SIZE_TR, "PET REU boyutu" },

/* en */ { IDS_PET_REU_FILENAME,    "PET REU file" },
/* da */ { IDS_PET_REU_FILENAME_DA, "PET REU-fil" },
/* de */ { IDS_PET_REU_FILENAME_DE, "PET REU Datei" },
/* es */ { IDS_PET_REU_FILENAME_ES, "Fichero REU PET" },
/* fr */ { IDS_PET_REU_FILENAME_FR, "Fichier PET REU" },
/* hu */ { IDS_PET_REU_FILENAME_HU, "PET REU fjl" },
/* it */ { IDS_PET_REU_FILENAME_IT, "File PET REU" },
/* ko */ { IDS_PET_REU_FILENAME_KO, "PET REU " },
/* nl */ { IDS_PET_REU_FILENAME_NL, "PET REU bestand" },
/* pl */ { IDS_PET_REU_FILENAME_PL, "Plik PET REU" },
/* ru */ { IDS_PET_REU_FILENAME_RU, "PET REU file" },
/* sv */ { IDS_PET_REU_FILENAME_SV, "PET REU-fil" },
/* tr */ { IDS_PET_REU_FILENAME_TR, "PET REU dosyas" },

/* en */ { IDS_PET_REU_FILENAME_SELECT,    "Select file for PET REU" },
/* da */ { IDS_PET_REU_FILENAME_SELECT_DA, "Vlg fil for PET REU" },
/* de */ { IDS_PET_REU_FILENAME_SELECT_DE, "Datei fr PET REU auswhlen" },
/* es */ { IDS_PET_REU_FILENAME_SELECT_ES, "Seleccionar fichero para REU PET" },
/* fr */ { IDS_PET_REU_FILENAME_SELECT_FR, "Slectionner fichier pour PET REU" },
/* hu */ { IDS_PET_REU_FILENAME_SELECT_HU, "Vlasszon fjlt a PET REU-hoz" },
/* it */ { IDS_PET_REU_FILENAME_SELECT_IT, "Seleziona il file per il PET REU" },
/* ko */ { IDS_PET_REU_FILENAME_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_PET_REU_FILENAME_SELECT_NL, "Selecteer bestand voor PET REU" },
/* pl */ { IDS_PET_REU_FILENAME_SELECT_PL, "Wybierz plik PET REU" },
/* ru */ { IDS_PET_REU_FILENAME_SELECT_RU, "Select file for PET REU" },
/* sv */ { IDS_PET_REU_FILENAME_SELECT_SV, "Vlj fil fr PET REU" },
/* tr */ { IDS_PET_REU_FILENAME_SELECT_TR, "PET REU iin dosya sein" },

/* en */ { IDS_PET_REU_SETTINGS,    "PET REU settings" },
/* da */ { IDS_PET_REU_SETTINGS_DA, "PET REU-indstillinger" },
/* de */ { IDS_PET_REU_SETTINGS_DE, "PET REU Einstellungen" },
/* es */ { IDS_PET_REU_SETTINGS_ES, "Ajustes PET REU" },
/* fr */ { IDS_PET_REU_SETTINGS_FR, "Paramtres PET REU" },
/* hu */ { IDS_PET_REU_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_PET_REU_SETTINGS_IT, "Impostazioni PET REU" },
/* ko */ { IDS_PET_REU_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_PET_REU_SETTINGS_NL, "PET REU instellingen" },
/* pl */ { IDS_PET_REU_SETTINGS_PL, "Ustawienia PET REU" },
/* ru */ { IDS_PET_REU_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_PET_REU_SETTINGS_SV, "PET REU-Instllningar" },
/* tr */ { IDS_PET_REU_SETTINGS_TR, "PET REU Ayarlar" },

/* en */ { IDS_RGBI,    "RGBI" },
/* da */ { IDS_RGBI_DA, "" },  /* fuzzy */
/* de */ { IDS_RGBI_DE, "RGBI" },
/* es */ { IDS_RGBI_ES, "RGBI" },
/* fr */ { IDS_RGBI_FR, "" },  /* fuzzy */
/* hu */ { IDS_RGBI_HU, "" },  /* fuzzy */
/* it */ { IDS_RGBI_IT, "RGBI" },
/* ko */ { IDS_RGBI_KO, "" },  /* fuzzy */
/* nl */ { IDS_RGBI_NL, "RGBI" },
/* pl */ { IDS_RGBI_PL, "RGBI" },
/* ru */ { IDS_RGBI_RU, "" },  /* fuzzy */
/* sv */ { IDS_RGBI_SV, "RGBI" },
/* tr */ { IDS_RGBI_TR, "" },  /* fuzzy */

/* en */ { IDS_ANALOG,    "Analog" },
/* da */ { IDS_ANALOG_DA, "" },  /* fuzzy */
/* de */ { IDS_ANALOG_DE, "Analog" },
/* es */ { IDS_ANALOG_ES, "Analgico" },
/* fr */ { IDS_ANALOG_FR, "" },  /* fuzzy */
/* hu */ { IDS_ANALOG_HU, "" },  /* fuzzy */
/* it */ { IDS_ANALOG_IT, "Analogico" },
/* ko */ { IDS_ANALOG_KO, "" },  /* fuzzy */
/* nl */ { IDS_ANALOG_NL, "Analoog" },
/* pl */ { IDS_ANALOG_PL, "Analog" },
/* ru */ { IDS_ANALOG_RU, "" },  /* fuzzy */
/* sv */ { IDS_ANALOG_SV, "Analog" },
/* tr */ { IDS_ANALOG_TR, "" },  /* fuzzy */

/* en */ { IDS_PET_COLOUR_TYPE,    "PET Colour type" },
/* da */ { IDS_PET_COLOUR_TYPE_DA, "" },  /* fuzzy */
/* de */ { IDS_PET_COLOUR_TYPE_DE, "PET Farbtyp" },
/* es */ { IDS_PET_COLOUR_TYPE_ES, "Tipo de color PET" },
/* fr */ { IDS_PET_COLOUR_TYPE_FR, "" },  /* fuzzy */
/* hu */ { IDS_PET_COLOUR_TYPE_HU, "" },  /* fuzzy */
/* it */ { IDS_PET_COLOUR_TYPE_IT, "Tipo PET Colour" },
/* ko */ { IDS_PET_COLOUR_TYPE_KO, "" },  /* fuzzy */
/* nl */ { IDS_PET_COLOUR_TYPE_NL, "PET Colour soort" },
/* pl */ { IDS_PET_COLOUR_TYPE_PL, "Rodzaj koloru PET" },
/* ru */ { IDS_PET_COLOUR_TYPE_RU, "" },  /* fuzzy */
/* sv */ { IDS_PET_COLOUR_TYPE_SV, "PET frgtyp" },
/* tr */ { IDS_PET_COLOUR_TYPE_TR, "" },  /* fuzzy */

/* en */ { IDS_PET_COLOUR_BACKGROUND,    "PET Colour background" },
/* da */ { IDS_PET_COLOUR_BACKGROUND_DA, "" },  /* fuzzy */
/* de */ { IDS_PET_COLOUR_BACKGROUND_DE, "PET Hintergrundfarbe" },
/* es */ { IDS_PET_COLOUR_BACKGROUND_ES, "Color del fondo PET" },
/* fr */ { IDS_PET_COLOUR_BACKGROUND_FR, "" },  /* fuzzy */
/* hu */ { IDS_PET_COLOUR_BACKGROUND_HU, "" },  /* fuzzy */
/* it */ { IDS_PET_COLOUR_BACKGROUND_IT, "Sfondo PET Colour" },
/* ko */ { IDS_PET_COLOUR_BACKGROUND_KO, "" },  /* fuzzy */
/* nl */ { IDS_PET_COLOUR_BACKGROUND_NL, "PET Colour achtergrond kleur" },
/* pl */ { IDS_PET_COLOUR_BACKGROUND_PL, "To koloru PET" },
/* ru */ { IDS_PET_COLOUR_BACKGROUND_RU, "" },  /* fuzzy */
/* sv */ { IDS_PET_COLOUR_BACKGROUND_SV, "PET bakgrundsfrg" },
/* tr */ { IDS_PET_COLOUR_BACKGROUND_TR, "" },  /* fuzzy */

/* en */ { IDS_PET_COLOUR_SETTINGS,    "PET Colour settings" },
/* da */ { IDS_PET_COLOUR_SETTINGS_DA, "" },  /* fuzzy */
/* de */ { IDS_PET_COLOUR_SETTINGS_DE, "PET Farb Einstellungen" },
/* es */ { IDS_PET_COLOUR_SETTINGS_ES, "Ajustes color PET" },
/* fr */ { IDS_PET_COLOUR_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_PET_COLOUR_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_PET_COLOUR_SETTINGS_IT, "Impostazioni PET Colour" },
/* ko */ { IDS_PET_COLOUR_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_PET_COLOUR_SETTINGS_NL, "PET Colour instellingen" },
/* pl */ { IDS_PET_COLOUR_SETTINGS_PL, "Ustawienia koloru PET" },
/* ru */ { IDS_PET_COLOUR_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_PET_COLOUR_SETTINGS_SV, "PET-frginstllningar" },
/* tr */ { IDS_PET_COLOUR_SETTINGS_TR, "" },  /* fuzzy */

/* en */ { IDS_V364_SPEECH_FILENAME,    "V364 Speech ROM file" },
/* da */ { IDS_V364_SPEECH_FILENAME_DA, "V364 Speech ROM-fil" },
/* de */ { IDS_V364_SPEECH_FILENAME_DE, "V364 Stimme ROM Datei" },
/* es */ { IDS_V364_SPEECH_FILENAME_ES, "Fichero ROM  V364 Speech" },
/* fr */ { IDS_V364_SPEECH_FILENAME_FR, "Slectionner le fichier ROM V364 Speech" },
/* hu */ { IDS_V364_SPEECH_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_V364_SPEECH_FILENAME_IT, "File ROM V364 Speech" },
/* ko */ { IDS_V364_SPEECH_FILENAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_V364_SPEECH_FILENAME_NL, "V364 spraak ROM bestand" },
/* pl */ { IDS_V364_SPEECH_FILENAME_PL, "Plik ROM V364 Speech" },
/* ru */ { IDS_V364_SPEECH_FILENAME_RU, "" },  /* fuzzy */
/* sv */ { IDS_V364_SPEECH_FILENAME_SV, "ROM-fil fr V364-rst" },
/* tr */ { IDS_V364_SPEECH_FILENAME_TR, "V364 Speech ROM dosyas" },

/* en */ { IDS_V364_SPEECH_FILENAME_SELECT,    "Select file for V364 Speech" },
/* da */ { IDS_V364_SPEECH_FILENAME_SELECT_DA, "Angiv fil for V364 Speech" },
/* de */ { IDS_V364_SPEECH_FILENAME_SELECT_DE, "Datei fr V364 Stimme auswhlen" },
/* es */ { IDS_V364_SPEECH_FILENAME_SELECT_ES, "Seleccionar fichero para V364 Speech" },
/* fr */ { IDS_V364_SPEECH_FILENAME_SELECT_FR, "Slectionner fichier pour V364 Speech" },
/* hu */ { IDS_V364_SPEECH_FILENAME_SELECT_HU, "" },  /* fuzzy */
/* it */ { IDS_V364_SPEECH_FILENAME_SELECT_IT, "Seleziona file per V364 Speech" },
/* ko */ { IDS_V364_SPEECH_FILENAME_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_V364_SPEECH_FILENAME_SELECT_NL, "Selecteer bestand voor V364 Spraak" },
/* pl */ { IDS_V364_SPEECH_FILENAME_SELECT_PL, "Wybierz plik mowy V364" },
/* ru */ { IDS_V364_SPEECH_FILENAME_SELECT_RU, "Select file for V364 Speech" },
/* sv */ { IDS_V364_SPEECH_FILENAME_SELECT_SV, "Vlj fil fr V364-rst" },
/* tr */ { IDS_V364_SPEECH_FILENAME_SELECT_TR, "V364 Speech iin dosya sein" },

/* en */ { IDS_V364_SPEECH_SETTINGS,    "V364 Speech settings" },
/* da */ { IDS_V364_SPEECH_SETTINGS_DA, "V364 tale-indstillinger" },
/* de */ { IDS_V364_SPEECH_SETTINGS_DE, "V364 Stimme Einstellungen" },
/* es */ { IDS_V364_SPEECH_SETTINGS_ES, "Ajustes V364 Speech" },
/* fr */ { IDS_V364_SPEECH_SETTINGS_FR, "Paramtres du V364 Speech" },
/* hu */ { IDS_V364_SPEECH_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_V364_SPEECH_SETTINGS_IT, "Impostazioni V364 Speech" },
/* ko */ { IDS_V364_SPEECH_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_V364_SPEECH_SETTINGS_NL, "V364 Spraak instellingen" },
/* pl */ { IDS_V364_SPEECH_SETTINGS_PL, "Ustawienia mowy V364" },
/* ru */ { IDS_V364_SPEECH_SETTINGS_RU, "  V364" },
/* sv */ { IDS_V364_SPEECH_SETTINGS_SV, "V364-rstinstllningar" },
/* tr */ { IDS_V364_SPEECH_SETTINGS_TR, "V364 Speech ayarlar" },

/* en */ { IDS_PET_DWW_FILENAME,    "PET DWW file" },
/* da */ { IDS_PET_DWW_FILENAME_DA, "PET DWW fil" },
/* de */ { IDS_PET_DWW_FILENAME_DE, "PET DWW Datei" },
/* es */ { IDS_PET_DWW_FILENAME_ES, "Fichero DWW PET" },
/* fr */ { IDS_PET_DWW_FILENAME_FR, "Fichier PET DWW" },
/* hu */ { IDS_PET_DWW_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_PET_DWW_FILENAME_IT, "File PET DWW" },
/* ko */ { IDS_PET_DWW_FILENAME_KO, "PET DWW " },
/* nl */ { IDS_PET_DWW_FILENAME_NL, "PET DWW bestand" },
/* pl */ { IDS_PET_DWW_FILENAME_PL, "Plik PET DWW" },
/* ru */ { IDS_PET_DWW_FILENAME_RU, "PET DWW file" },
/* sv */ { IDS_PET_DWW_FILENAME_SV, "PET DWW-fil" },
/* tr */ { IDS_PET_DWW_FILENAME_TR, "PET DWW dosyas" },

/* en */ { IDS_PET_DWW_FILENAME_SELECT,    "Select file for PET DWW" },
/* da */ { IDS_PET_DWW_FILENAME_SELECT_DA, "Vlg fil for PET DWW" },
/* de */ { IDS_PET_DWW_FILENAME_SELECT_DE, "Datei fr PET DWW auswhlen" },
/* es */ { IDS_PET_DWW_FILENAME_SELECT_ES, "Seleccionar fichero para DWW PET" },
/* fr */ { IDS_PET_DWW_FILENAME_SELECT_FR, "Slectionner fichier pour PET DWW" },
/* hu */ { IDS_PET_DWW_FILENAME_SELECT_HU, "" },  /* fuzzy */
/* it */ { IDS_PET_DWW_FILENAME_SELECT_IT, "Seleziona file per il PET DWW" },
/* ko */ { IDS_PET_DWW_FILENAME_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_PET_DWW_FILENAME_SELECT_NL, "Selecteer bestand voor PET DWW" },
/* pl */ { IDS_PET_DWW_FILENAME_SELECT_PL, "Wybierz plik PET DWW" },
/* ru */ { IDS_PET_DWW_FILENAME_SELECT_RU, "Select file for PET DWW" },
/* sv */ { IDS_PET_DWW_FILENAME_SELECT_SV, "Vlj fil fr PET DWW" },
/* tr */ { IDS_PET_DWW_FILENAME_SELECT_TR, "PET DWW iin dosya sein" },

/* en */ { IDS_PET_DWW_SETTINGS,    "PET DWW settings" },
/* da */ { IDS_PET_DWW_SETTINGS_DA, "PET DWW-indstillinger" },
/* de */ { IDS_PET_DWW_SETTINGS_DE, "PET DWW Einstellungen" },
/* es */ { IDS_PET_DWW_SETTINGS_ES, "Ajustes PET DWW" },
/* fr */ { IDS_PET_DWW_SETTINGS_FR, "Paramtres PET DWW" },
/* hu */ { IDS_PET_DWW_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_PET_DWW_SETTINGS_IT, "Impostazioni PET DWW" },
/* ko */ { IDS_PET_DWW_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_PET_DWW_SETTINGS_NL, "PET DWW instellingen" },
/* pl */ { IDS_PET_DWW_SETTINGS_PL, "Ustawienia PET DWW" },
/* ru */ { IDS_PET_DWW_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_PET_DWW_SETTINGS_SV, "PET DWW-Instllningar" },
/* tr */ { IDS_PET_DWW_SETTINGS_TR, "PET DWW Ayarlar" },

/* en */ { IDS_MEMORY_HACK_DEVICE,    "Memory expansion hack device" },
/* da */ { IDS_MEMORY_HACK_DEVICE_DA, "" },  /* fuzzy */
/* de */ { IDS_MEMORY_HACK_DEVICE_DE, "Speicher Erweiterungeshack Gert" },
/* es */ { IDS_MEMORY_HACK_DEVICE_ES, "" },  /* fuzzy */
/* fr */ { IDS_MEMORY_HACK_DEVICE_FR, "" },  /* fuzzy */
/* hu */ { IDS_MEMORY_HACK_DEVICE_HU, "" },  /* fuzzy */
/* it */ { IDS_MEMORY_HACK_DEVICE_IT, "" },  /* fuzzy */
/* ko */ { IDS_MEMORY_HACK_DEVICE_KO, "" },  /* fuzzy */
/* nl */ { IDS_MEMORY_HACK_DEVICE_NL, "Geheugen uitbreidingen hack apparaat" },
/* pl */ { IDS_MEMORY_HACK_DEVICE_PL, "Urzdzenie hacka rozszerzenia pamici" },
/* ru */ { IDS_MEMORY_HACK_DEVICE_RU, "" },  /* fuzzy */
/* sv */ { IDS_MEMORY_HACK_DEVICE_SV, "" },  /* fuzzy */
/* tr */ { IDS_MEMORY_HACK_DEVICE_TR, "" },  /* fuzzy */

/* en */ { IDS_PLUS60K_BASE,    "PLUS60K base address" },
/* da */ { IDS_PLUS60K_BASE_DA, "Baseadresse for PLUS60K" },
/* de */ { IDS_PLUS60K_BASE_DE, "PLUS60K Basis Adresse" },
/* es */ { IDS_PLUS60K_BASE_ES, "Direccin base PLUS60K" },
/* fr */ { IDS_PLUS60K_BASE_FR, "Adresse de base PLUS60K" },
/* hu */ { IDS_PLUS60K_BASE_HU, "PLUS60K bziscme" },
/* it */ { IDS_PLUS60K_BASE_IT, "indirizzo base PLUS60K" },
/* ko */ { IDS_PLUS60K_BASE_KO, "" },  /* fuzzy */
/* nl */ { IDS_PLUS60K_BASE_NL, "PLUS60K basisadres" },
/* pl */ { IDS_PLUS60K_BASE_PL, "Adres bazowy PLUS60K" },
/* ru */ { IDS_PLUS60K_BASE_RU, "PLUS60K base address" },
/* sv */ { IDS_PLUS60K_BASE_SV, "Basadress fr PLUS60K" },
/* tr */ { IDS_PLUS60K_BASE_TR, "PLUS60K taban adresi" },

/* en */ { IDS_PLUS60K_FILENAME,    "PLUS60K file" },
/* da */ { IDS_PLUS60K_FILENAME_DA, "PLUS60K-fil" },
/* de */ { IDS_PLUS60K_FILENAME_DE, "PLUS60K Datei" },
/* es */ { IDS_PLUS60K_FILENAME_ES, "Fichero PLUS60K" },
/* fr */ { IDS_PLUS60K_FILENAME_FR, "Fichier POLUS60K" },
/* hu */ { IDS_PLUS60K_FILENAME_HU, "PLUS60K fjl" },
/* it */ { IDS_PLUS60K_FILENAME_IT, "File PLUS60K" },
/* ko */ { IDS_PLUS60K_FILENAME_KO, "PLUS60K " },
/* nl */ { IDS_PLUS60K_FILENAME_NL, "PLUS60K bestand" },
/* pl */ { IDS_PLUS60K_FILENAME_PL, "Plik PLUS60K" },
/* ru */ { IDS_PLUS60K_FILENAME_RU, "PLUS60K file" },
/* sv */ { IDS_PLUS60K_FILENAME_SV, "PLUS60K-fil" },
/* tr */ { IDS_PLUS60K_FILENAME_TR, "PLUS60K dosyas" },

/* en */ { IDS_PLUS60K_FILENAME_SELECT,    "Select file for PLUS60K" },
/* da */ { IDS_PLUS60K_FILENAME_SELECT_DA, "Vlg fil for PLUS60K" },
/* de */ { IDS_PLUS60K_FILENAME_SELECT_DE, "Datei fr PLUS60K auswhlen" },
/* es */ { IDS_PLUS60K_FILENAME_SELECT_ES, "Seleccionar fichero para PLUS60K" },
/* fr */ { IDS_PLUS60K_FILENAME_SELECT_FR, "Slectionner fichier pour PLUS60K" },
/* hu */ { IDS_PLUS60K_FILENAME_SELECT_HU, "Vlasszon fjlt a PLUS60K-hoz" },
/* it */ { IDS_PLUS60K_FILENAME_SELECT_IT, "Seleziona file per PLUS60K" },
/* ko */ { IDS_PLUS60K_FILENAME_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_PLUS60K_FILENAME_SELECT_NL, "Selecteer bestand voor PLUS60K" },
/* pl */ { IDS_PLUS60K_FILENAME_SELECT_PL, "Wybierz plik PLUS60K" },
/* ru */ { IDS_PLUS60K_FILENAME_SELECT_RU, "Select file for PLUS60K" },
/* sv */ { IDS_PLUS60K_FILENAME_SELECT_SV, "Ange fil fr PLUS60K" },
/* tr */ { IDS_PLUS60K_FILENAME_SELECT_TR, "PLUS60K iin dosya sein" },

/* en */ { IDS_C64_MEMORY_HACKS_SETTINGS,    "Memory expansion hacks settings" },
/* da */ { IDS_C64_MEMORY_HACKS_SETTINGS_DA, "" },  /* fuzzy */
/* de */ { IDS_C64_MEMORY_HACKS_SETTINGS_DE, "Speicher Erweiterungshack Einstellungen" },
/* es */ { IDS_C64_MEMORY_HACKS_SETTINGS_ES, "" },  /* fuzzy */
/* fr */ { IDS_C64_MEMORY_HACKS_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_C64_MEMORY_HACKS_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_C64_MEMORY_HACKS_SETTINGS_IT, "" },  /* fuzzy */
/* ko */ { IDS_C64_MEMORY_HACKS_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_C64_MEMORY_HACKS_SETTINGS_NL, "Geheugen uitbreiding hacks instellingen" },
/* pl */ { IDS_C64_MEMORY_HACKS_SETTINGS_PL, "Ustawienia hackw rozszerzenia pamici" },
/* ru */ { IDS_C64_MEMORY_HACKS_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_C64_MEMORY_HACKS_SETTINGS_SV, "" },  /* fuzzy */
/* tr */ { IDS_C64_MEMORY_HACKS_SETTINGS_TR, "" },  /* fuzzy */

/* en */ { IDS_VALUE_FIRST_BYTE,    "Value of first byte" },
/* da */ { IDS_VALUE_FIRST_BYTE_DA, "Vrdi p frste byte" },
/* de */ { IDS_VALUE_FIRST_BYTE_DE, "Wert erstes Byte" },
/* es */ { IDS_VALUE_FIRST_BYTE_ES, "Valor del primer byte" },
/* fr */ { IDS_VALUE_FIRST_BYTE_FR, "Valeur du premier octet" },
/* hu */ { IDS_VALUE_FIRST_BYTE_HU, "Els bjt rtke" },
/* it */ { IDS_VALUE_FIRST_BYTE_IT, "Valore del primo byte" },
/* ko */ { IDS_VALUE_FIRST_BYTE_KO, "" },  /* fuzzy */
/* nl */ { IDS_VALUE_FIRST_BYTE_NL, "Waarde van eerste byte" },
/* pl */ { IDS_VALUE_FIRST_BYTE_PL, "Warto pierwszego bajta" },
/* ru */ { IDS_VALUE_FIRST_BYTE_RU, "Value of first byte" },
/* sv */ { IDS_VALUE_FIRST_BYTE_SV, "Vrde p frsta byte" },
/* tr */ { IDS_VALUE_FIRST_BYTE_TR, "lk byte deeri" },

/* en */ { IDS_LENGTH_CONSTANT_VALUES,    "Length of constant values" },
/* da */ { IDS_LENGTH_CONSTANT_VALUES_DA, "Lngde af konstant vrdi" },
/* de */ { IDS_LENGTH_CONSTANT_VALUES_DE, "Lnge der konstanten Werte" },
/* es */ { IDS_LENGTH_CONSTANT_VALUES_ES, "Longitud de valores constantes" },
/* fr */ { IDS_LENGTH_CONSTANT_VALUES_FR, "Longeur des valeurs constantes" },
/* hu */ { IDS_LENGTH_CONSTANT_VALUES_HU, "lland rtkek hossza" },
/* it */ { IDS_LENGTH_CONSTANT_VALUES_IT, "Lunghezza dei valori costanti" },
/* ko */ { IDS_LENGTH_CONSTANT_VALUES_KO, "" },  /* fuzzy */
/* nl */ { IDS_LENGTH_CONSTANT_VALUES_NL, "Lengte van constante waarden" },
/* pl */ { IDS_LENGTH_CONSTANT_VALUES_PL, "Dugo staych wartoci" },
/* ru */ { IDS_LENGTH_CONSTANT_VALUES_RU, "Length of constant values" },
/* sv */ { IDS_LENGTH_CONSTANT_VALUES_SV, "Lngd p konstanta vrden" },
/* tr */ { IDS_LENGTH_CONSTANT_VALUES_TR, "Sabit deerlerin uzunluu" },

/* en */ { IDS_LENGTH_CONSTANT_PATTERN,    "Length of constant pattern" },
/* da */ { IDS_LENGTH_CONSTANT_PATTERN_DA, "Lngde af konstant mnster" },
/* de */ { IDS_LENGTH_CONSTANT_PATTERN_DE, "Lnge des konstanten Musters" },
/* es */ { IDS_LENGTH_CONSTANT_PATTERN_ES, "Longitud de patrones constantes" },
/* fr */ { IDS_LENGTH_CONSTANT_PATTERN_FR, "Longeur des contantes pattern" },
/* hu */ { IDS_LENGTH_CONSTANT_PATTERN_HU, "lland minta hossza" },
/* it */ { IDS_LENGTH_CONSTANT_PATTERN_IT, "Lunghezza dei pattern costanti" },
/* ko */ { IDS_LENGTH_CONSTANT_PATTERN_KO, "" },  /* fuzzy */
/* nl */ { IDS_LENGTH_CONSTANT_PATTERN_NL, "Lengte van constant patroon" },
/* pl */ { IDS_LENGTH_CONSTANT_PATTERN_PL, "Lugo staego wzorca" },
/* ru */ { IDS_LENGTH_CONSTANT_PATTERN_RU, "Length of constant pattern" },
/* sv */ { IDS_LENGTH_CONSTANT_PATTERN_SV, "Lngd p konstant mnster" },
/* tr */ { IDS_LENGTH_CONSTANT_PATTERN_TR, "Sabit desenlerin uzunluu" },

/* en */ { IDS_RAM_SETTINGS,    "RAM settings" },
/* da */ { IDS_RAM_SETTINGS_DA, "RAM-indstillinger" },
/* de */ { IDS_RAM_SETTINGS_DE, "RAM Einstellungen" },
/* es */ { IDS_RAM_SETTINGS_ES, "Ajustes RAM" },
/* fr */ { IDS_RAM_SETTINGS_FR, "Paramtres de la RAM" },
/* hu */ { IDS_RAM_SETTINGS_HU, "RAM belltsai" },
/* it */ { IDS_RAM_SETTINGS_IT, "Impostazioni RAM" },
/* ko */ { IDS_RAM_SETTINGS_KO, "RAM " },
/* nl */ { IDS_RAM_SETTINGS_NL, "RAM instellingen" },
/* pl */ { IDS_RAM_SETTINGS_PL, "Ustawienia RAM" },
/* ru */ { IDS_RAM_SETTINGS_RU, " RAM" },
/* sv */ { IDS_RAM_SETTINGS_SV, "RAM-instllningar" },
/* tr */ { IDS_RAM_SETTINGS_TR, "RAM ayarlar" },

/* en */ { IDS_READ_WRITE,    "read/write" },
/* da */ { IDS_READ_WRITE_DA, "skrivbar" },
/* de */ { IDS_READ_WRITE_DE, "lese/schreibe" },
/* es */ { IDS_READ_WRITE_ES, "Leer/Grabar" },
/* fr */ { IDS_READ_WRITE_FR, "lecture/criture" },
/* hu */ { IDS_READ_WRITE_HU, "rhat/olvashat" },
/* it */ { IDS_READ_WRITE_IT, "lettura/scrittura" },
/* ko */ { IDS_READ_WRITE_KO, "б/" },
/* nl */ { IDS_READ_WRITE_NL, "lees/schrijf" },
/* pl */ { IDS_READ_WRITE_PL, "oczyt/zapis" },
/* ru */ { IDS_READ_WRITE_RU, "read/write" },
/* sv */ { IDS_READ_WRITE_SV, "skrivbar" },
/* tr */ { IDS_READ_WRITE_TR, "oku/yaz" },

/* en */ { IDS_READ_ONLY,    "Read-only" },
/* da */ { IDS_READ_ONLY_DA, "Kun lseadgang" },
/* de */ { IDS_READ_ONLY_DE, "Schreibgeschtzt" },
/* es */ { IDS_READ_ONLY_ES, "Slo lectura" },
/* fr */ { IDS_READ_ONLY_FR, "Lecture seule" },
/* hu */ { IDS_READ_ONLY_HU, "" },  /* fuzzy */
/* it */ { IDS_READ_ONLY_IT, "Sola lettura" },
/* ko */ { IDS_READ_ONLY_KO, "б " },
/* nl */ { IDS_READ_ONLY_NL, "Alleen-lezen" },
/* pl */ { IDS_READ_ONLY_PL, "Tylko do odczytu" },
/* ru */ { IDS_READ_ONLY_RU, " " },
/* sv */ { IDS_READ_ONLY_SV, "Endast lsning" },
/* tr */ { IDS_READ_ONLY_TR, "Salt okunur" },

/* en */ { IDS_RAMCART_READ_WRITE,    "RamCart Read/Write" },
/* da */ { IDS_RAMCART_READ_WRITE_DA, "RamCart ls/skriv" },
/* de */ { IDS_RAMCART_READ_WRITE_DE, "RamCart Lesen/Schreiben" },
/* es */ { IDS_RAMCART_READ_WRITE_ES, "Lectura/Grabacin RamCart" },
/* fr */ { IDS_RAMCART_READ_WRITE_FR, "lecture/criture RamCart" },
/* hu */ { IDS_RAMCART_READ_WRITE_HU, "" },  /* fuzzy */
/* it */ { IDS_RAMCART_READ_WRITE_IT, "RamCart in lettura/scrittura" },
/* ko */ { IDS_RAMCART_READ_WRITE_KO, "" },  /* fuzzy */
/* nl */ { IDS_RAMCART_READ_WRITE_NL, "RamCart lees/schrijf" },
/* pl */ { IDS_RAMCART_READ_WRITE_PL, "Odczyt i zapis na RamCart" },
/* ru */ { IDS_RAMCART_READ_WRITE_RU, "RamCart Read/Write" },
/* sv */ { IDS_RAMCART_READ_WRITE_SV, "Skrivbart RamCart" },
/* tr */ { IDS_RAMCART_READ_WRITE_TR, "RamCart Oku/Yaz" },

/* en */ { IDS_RAMCART_SIZE,    "RamCart size" },
/* da */ { IDS_RAMCART_SIZE_DA, "RamCart-strrelse" },
/* de */ { IDS_RAMCART_SIZE_DE, "RamCart Gre" },
/* es */ { IDS_RAMCART_SIZE_ES, "Tamao RamCart" },
/* fr */ { IDS_RAMCART_SIZE_FR, "Taille de l'extention RAMCART" },
/* hu */ { IDS_RAMCART_SIZE_HU, "" },  /* fuzzy */
/* it */ { IDS_RAMCART_SIZE_IT, "Dimensione RamCart" },
/* ko */ { IDS_RAMCART_SIZE_KO, "" },  /* fuzzy */
/* nl */ { IDS_RAMCART_SIZE_NL, "RamCart grootte" },
/* pl */ { IDS_RAMCART_SIZE_PL, "Rozmiar RamCart" },
/* ru */ { IDS_RAMCART_SIZE_RU, "" },  /* fuzzy */
/* sv */ { IDS_RAMCART_SIZE_SV, "RamCart-storlek" },
/* tr */ { IDS_RAMCART_SIZE_TR, "RamCart boyutu" },

/* en */ { IDS_RAMCART_FILENAME,    "RamCart file" },
/* da */ { IDS_RAMCART_FILENAME_DA, "RamCart fil" },
/* de */ { IDS_RAMCART_FILENAME_DE, "RamCart Datei" },
/* es */ { IDS_RAMCART_FILENAME_ES, "Fichero RamCart" },
/* fr */ { IDS_RAMCART_FILENAME_FR, "Fichier RamCart" },
/* hu */ { IDS_RAMCART_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_RAMCART_FILENAME_IT, "File RamCart" },
/* ko */ { IDS_RAMCART_FILENAME_KO, "RamCart " },
/* nl */ { IDS_RAMCART_FILENAME_NL, "RamCart bestand" },
/* pl */ { IDS_RAMCART_FILENAME_PL, "Plik RamCart" },
/* ru */ { IDS_RAMCART_FILENAME_RU, "RamCart file" },
/* sv */ { IDS_RAMCART_FILENAME_SV, "RamCart-fil" },
/* tr */ { IDS_RAMCART_FILENAME_TR, "RamCart dosyas" },

/* en */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED,    "Save RamCart image when changed" },
/* da */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_DA, "Gem RamCart image ved ndringer" },
/* de */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_DE, "RamCart Imagedatei bei nderung speichern" },
/* es */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_ES, "Grabar imagen RamChart cuando cambie" },
/* fr */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_FR, "Enregistrer l'image RAMCART lorsque modifie" },
/* hu */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_HU, "" },  /* fuzzy */
/* it */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_IT, "Salva immagine RamCart alla modifica" },
/* ko */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_KO, "" },  /* fuzzy */
/* nl */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_NL, "Ramcart bestand opslaan indien gewijzigd" },
/* pl */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_PL, "Zapisuj obraz RamCart przy zmianie" },
/* ru */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_RU, "Save RamCart image when changed" },
/* sv */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_SV, "Spara RamCart-avbildning vid ndringar" },
/* tr */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_TR, "RamCart imaj deitiinde kaydet" },

/* en */ { IDS_RAMCART_FILENAME_SELECT,    "Select file for RamCart" },
/* da */ { IDS_RAMCART_FILENAME_SELECT_DA, "Vlg fil for RamCart" },
/* de */ { IDS_RAMCART_FILENAME_SELECT_DE, "Datei fr RamCart auswhlen" },
/* es */ { IDS_RAMCART_FILENAME_SELECT_ES, "Seleccionar fichero para RamCart" },
/* fr */ { IDS_RAMCART_FILENAME_SELECT_FR, "Slectionner fichier pour RamCart" },
/* hu */ { IDS_RAMCART_FILENAME_SELECT_HU, "" },  /* fuzzy */
/* it */ { IDS_RAMCART_FILENAME_SELECT_IT, "Seleziona file per RamCart" },
/* ko */ { IDS_RAMCART_FILENAME_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_RAMCART_FILENAME_SELECT_NL, "Selecteer bestand voor RamCart" },
/* pl */ { IDS_RAMCART_FILENAME_SELECT_PL, "Wybierz plik RamCart" },
/* ru */ { IDS_RAMCART_FILENAME_SELECT_RU, "Select file for RamCart" },
/* sv */ { IDS_RAMCART_FILENAME_SELECT_SV, "Vlj fil fr RamCart" },
/* tr */ { IDS_RAMCART_FILENAME_SELECT_TR, "RamCart iin dosya sein" },

/* en */ { IDS_RAMCART_SETTINGS,    "RamCart settings" },
/* da */ { IDS_RAMCART_SETTINGS_DA, "RamCart-indstillinger" },
/* de */ { IDS_RAMCART_SETTINGS_DE, "RamCart Einstellungen" },
/* es */ { IDS_RAMCART_SETTINGS_ES, "Ajustes RamCart" },
/* fr */ { IDS_RAMCART_SETTINGS_FR, "Paramtres RamCart" },
/* hu */ { IDS_RAMCART_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_RAMCART_SETTINGS_IT, "Impostazioni RamCart " },
/* ko */ { IDS_RAMCART_SETTINGS_KO, "RamCart " },
/* nl */ { IDS_RAMCART_SETTINGS_NL, "RamCart instellingen" },
/* pl */ { IDS_RAMCART_SETTINGS_PL, "Ustawienia RamCart" },
/* ru */ { IDS_RAMCART_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_RAMCART_SETTINGS_SV, "RamCart-instllningar" },
/* tr */ { IDS_RAMCART_SETTINGS_TR, "RamCart ayarlar" },

/* en */ { IDS_REU_SIZE,    "REU size" },
/* da */ { IDS_REU_SIZE_DA, "REU strrelse" },
/* de */ { IDS_REU_SIZE_DE, "REU Gre" },
/* es */ { IDS_REU_SIZE_ES, "Tamao REU" },
/* fr */ { IDS_REU_SIZE_FR, "Taille du REU" },
/* hu */ { IDS_REU_SIZE_HU, "REU mrete" },
/* it */ { IDS_REU_SIZE_IT, "Dimensione REU" },
/* ko */ { IDS_REU_SIZE_KO, "" },  /* fuzzy */
/* nl */ { IDS_REU_SIZE_NL, "REU grootte" },
/* pl */ { IDS_REU_SIZE_PL, "Rozmiar REU" },
/* ru */ { IDS_REU_SIZE_RU, "REU size" },
/* sv */ { IDS_REU_SIZE_SV, "Storlek p minnesexpansion" },
/* tr */ { IDS_REU_SIZE_TR, "REU boyutu" },

/* en */ { IDS_REU_FILENAME,    "REU file" },
/* da */ { IDS_REU_FILENAME_DA, "REU-fil" },
/* de */ { IDS_REU_FILENAME_DE, "REU Datei" },
/* es */ { IDS_REU_FILENAME_ES, "Fichero REU" },
/* fr */ { IDS_REU_FILENAME_FR, "Fichier REU" },
/* hu */ { IDS_REU_FILENAME_HU, "REU fjl" },
/* it */ { IDS_REU_FILENAME_IT, "File del REU" },
/* ko */ { IDS_REU_FILENAME_KO, "REU " },
/* nl */ { IDS_REU_FILENAME_NL, "REU bestand" },
/* pl */ { IDS_REU_FILENAME_PL, "Plik REU" },
/* ru */ { IDS_REU_FILENAME_RU, "REU file" },
/* sv */ { IDS_REU_FILENAME_SV, "REU-fil" },
/* tr */ { IDS_REU_FILENAME_TR, "REU dosyas" },

/* en */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED,    "Save REU image when changed" },
/* da */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_DA, "Gem REU image ved ndringer" },
/* de */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_DE, "REU Imagedatei bei nderung speichern" },
/* es */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_ES, "Grabar imagen REU cuando cambie" },
/* fr */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_FR, "Enregistrer l'image REU lorsque modifie" },
/* hu */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_HU, "" },  /* fuzzy */
/* it */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_IT, "Salva immagine REU alla modifica" },
/* ko */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_KO, "" },  /* fuzzy */
/* nl */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_NL, "REU bestand opslaan indien gewijzigd" },
/* pl */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_PL, "Zapisuj obraz REU przy zmianie" },
/* ru */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_RU, "Save REU image when changed" },
/* sv */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_SV, "Spara REU-avbildning vid ndringar" },
/* tr */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_TR, "REU imaj deitiinde kaydet" },

/* en */ { IDS_REU_FILENAME_SELECT,    "Select file for REU" },
/* da */ { IDS_REU_FILENAME_SELECT_DA, "Vlg fil for REU" },
/* de */ { IDS_REU_FILENAME_SELECT_DE, "Datei fr REU auswhlen" },
/* es */ { IDS_REU_FILENAME_SELECT_ES, "Seleccionar fichero para REU" },
/* fr */ { IDS_REU_FILENAME_SELECT_FR, "Slectionner fichier pour REU" },
/* hu */ { IDS_REU_FILENAME_SELECT_HU, "Vlasszon fjlt a REU-hoz" },
/* it */ { IDS_REU_FILENAME_SELECT_IT, "Seleziona il file per il REU" },
/* ko */ { IDS_REU_FILENAME_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_REU_FILENAME_SELECT_NL, "Selecteer bestand voor REU" },
/* pl */ { IDS_REU_FILENAME_SELECT_PL, "Wybierz plik REU" },
/* ru */ { IDS_REU_FILENAME_SELECT_RU, "Select file for REU" },
/* sv */ { IDS_REU_FILENAME_SELECT_SV, "Vlj fil fr REU" },
/* tr */ { IDS_REU_FILENAME_SELECT_TR, "REU iin dosya sein" },

/* en */ { IDS_REU_SETTINGS,    "REU settings" },
/* da */ { IDS_REU_SETTINGS_DA, "REU-indstillinger" },
/* de */ { IDS_REU_SETTINGS_DE, "REU Einstellungen" },
/* es */ { IDS_REU_SETTINGS_ES, "Ajustes REU" },
/* fr */ { IDS_REU_SETTINGS_FR, "Paramtres REU" },
/* hu */ { IDS_REU_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_REU_SETTINGS_IT, "Impostazioni REU" },
/* ko */ { IDS_REU_SETTINGS_KO, "REU " },
/* nl */ { IDS_REU_SETTINGS_NL, "REU instellingen" },
/* pl */ { IDS_REU_SETTINGS_PL, "Ustawienia REU" },
/* ru */ { IDS_REU_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_REU_SETTINGS_SV, "REU-Instllningar" },
/* tr */ { IDS_REU_SETTINGS_TR, "REU Ayarlar" },

/* en */ { IDS_BURST_MOD_SETTINGS,    "Drive burst modification settings" },
/* da */ { IDS_BURST_MOD_SETTINGS_DA, "Drev burst-modifikations-indstillinger" },
/* de */ { IDS_BURST_MOD_SETTINGS_DE, "Laufwerk Burstmodifkation Einstellungen" },
/* es */ { IDS_BURST_MOD_SETTINGS_ES, "Ajuste modificacin Burst en controlador" },
/* fr */ { IDS_BURST_MOD_SETTINGS_FR, "Activer l'mulation de Burst Lecteur" },
/* hu */ { IDS_BURST_MOD_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_BURST_MOD_SETTINGS_IT, "Impostazioni modifica burst del drive" },
/* ko */ { IDS_BURST_MOD_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_BURST_MOD_SETTINGS_NL, "Drive burst modificatie instellingen" },
/* pl */ { IDS_BURST_MOD_SETTINGS_PL, "Ustawienia trybu synchronicznego napdu" },
/* ru */ { IDS_BURST_MOD_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_BURST_MOD_SETTINGS_SV, "Instllningar fr diskettburstmodifiering" },
/* tr */ { IDS_BURST_MOD_SETTINGS_TR, "Src atlama modifikasyon ayarlar" },

/* en */ { IDS_PALETTE_SETTINGS,    "Palette settings" },
/* da */ { IDS_PALETTE_SETTINGS_DA, "Paletteindstillinger" },
/* de */ { IDS_PALETTE_SETTINGS_DE, "Paletteneinstellungen" },
/* es */ { IDS_PALETTE_SETTINGS_ES, "Ajustes Paleta" },
/* fr */ { IDS_PALETTE_SETTINGS_FR, "Paramtres Palette" },
/* hu */ { IDS_PALETTE_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_PALETTE_SETTINGS_IT, "Impostazioni palette" },
/* ko */ { IDS_PALETTE_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_PALETTE_SETTINGS_NL, "Palette instellingen" },
/* pl */ { IDS_PALETTE_SETTINGS_PL, "Ustawienia palety barw" },
/* ru */ { IDS_PALETTE_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_PALETTE_SETTINGS_SV, "Palettinstllningar" },
/* tr */ { IDS_PALETTE_SETTINGS_TR, "Palet ayarlar" },

/* en */ { IDS_COLOR_SETTINGS,    "Color settings" },
/* da */ { IDS_COLOR_SETTINGS_DA, "Farveindstillinger" },
/* de */ { IDS_COLOR_SETTINGS_DE, "Farb Einstellungen" },
/* es */ { IDS_COLOR_SETTINGS_ES, "Ajustes color" },
/* fr */ { IDS_COLOR_SETTINGS_FR, "Paramtres de couleurs" },
/* hu */ { IDS_COLOR_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_COLOR_SETTINGS_IT, "Impostazioni colori" },
/* ko */ { IDS_COLOR_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_COLOR_SETTINGS_NL, "Kleur instellingen" },
/* pl */ { IDS_COLOR_SETTINGS_PL, "Ustawienia koloru" },
/* ru */ { IDS_COLOR_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_COLOR_SETTINGS_SV, "Frginstllningar" },
/* tr */ { IDS_COLOR_SETTINGS_TR, "Renk ayarlar" },

/* en */ { IDS_RENDER_FILTER_SETTINGS,    "Render filter settings" },
/* da */ { IDS_RENDER_FILTER_SETTINGS_DA, "Renderingsfilterindstillinger" },
/* de */ { IDS_RENDER_FILTER_SETTINGS_DE, "Render Filter Einstellungen" },
/* es */ { IDS_RENDER_FILTER_SETTINGS_ES, "Ajuste filtro de renderizado" },
/* fr */ { IDS_RENDER_FILTER_SETTINGS_FR, "Paramtres filtres de rendu" },
/* hu */ { IDS_RENDER_FILTER_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_RENDER_FILTER_SETTINGS_IT, "Impostazioni filtro di render" },
/* ko */ { IDS_RENDER_FILTER_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_RENDER_FILTER_SETTINGS_NL, "Render filter instellingen" },
/* pl */ { IDS_RENDER_FILTER_SETTINGS_PL, "Ustawienia filtra renderera" },
/* ru */ { IDS_RENDER_FILTER_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_RENDER_FILTER_SETTINGS_SV, "Instllningar fr rendrerarfilter" },
/* tr */ { IDS_RENDER_FILTER_SETTINGS_TR, "mge oluturma filtresi ayarlar" },

/* en */ { IDS_CRT_SETTINGS,    "CRT emulation settings" },
/* da */ { IDS_CRT_SETTINGS_DA, "Indstillinger for CRT-emulering" },
/* de */ { IDS_CRT_SETTINGS_DE, "CRT Emulator Einstellungen" },
/* es */ { IDS_CRT_SETTINGS_ES, "Ajustes de emulacin CRT" },
/* fr */ { IDS_CRT_SETTINGS_FR, "Paramtres d'mulation CRT" },
/* hu */ { IDS_CRT_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_CRT_SETTINGS_IT, "Impostazioni emulazione CRT" },
/* ko */ { IDS_CRT_SETTINGS_KO, "  ͹̳ " },
/* nl */ { IDS_CRT_SETTINGS_NL, "CRT emulatie instellingen" },
/* pl */ { IDS_CRT_SETTINGS_PL, "Ustawienia emulacji CRT" },
/* ru */ { IDS_CRT_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_CRT_SETTINGS_SV, "Instllningar fr CRT-emulering" },
/* tr */ { IDS_CRT_SETTINGS_TR, "CRT emlasyonu ayarlar" },

/* en */ { IDS_VICII_PALETTE_FILENAME,    "VICII palette file" },
/* da */ { IDS_VICII_PALETTE_FILENAME_DA, "VICII-palettefil" },
/* de */ { IDS_VICII_PALETTE_FILENAME_DE, "VICII Paletten Datei" },
/* es */ { IDS_VICII_PALETTE_FILENAME_ES, "Fichero paleta VICII" },
/* fr */ { IDS_VICII_PALETTE_FILENAME_FR, "Fichier de palette VICII" },
/* hu */ { IDS_VICII_PALETTE_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_VICII_PALETTE_FILENAME_IT, "File palette VICII" },
/* ko */ { IDS_VICII_PALETTE_FILENAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_VICII_PALETTE_FILENAME_NL, "VICII palet bestand" },
/* pl */ { IDS_VICII_PALETTE_FILENAME_PL, "Plik palety VICII" },
/* ru */ { IDS_VICII_PALETTE_FILENAME_RU, "" },  /* fuzzy */
/* sv */ { IDS_VICII_PALETTE_FILENAME_SV, "VICII-palettfil" },
/* tr */ { IDS_VICII_PALETTE_FILENAME_TR, "VICII palet dosyas" },

/* en */ { IDS_VIC_PALETTE_FILENAME,    "VIC palette file" },
/* da */ { IDS_VIC_PALETTE_FILENAME_DA, "VIC-palettefil" },
/* de */ { IDS_VIC_PALETTE_FILENAME_DE, "VIC Paletten Datei" },
/* es */ { IDS_VIC_PALETTE_FILENAME_ES, "Fichero paleta VIC" },
/* fr */ { IDS_VIC_PALETTE_FILENAME_FR, "Fichier de palette VIC" },
/* hu */ { IDS_VIC_PALETTE_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_VIC_PALETTE_FILENAME_IT, "File palette VIC" },
/* ko */ { IDS_VIC_PALETTE_FILENAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_VIC_PALETTE_FILENAME_NL, "VIC palet bestand" },
/* pl */ { IDS_VIC_PALETTE_FILENAME_PL, "Plik palety VIC" },
/* ru */ { IDS_VIC_PALETTE_FILENAME_RU, "" },  /* fuzzy */
/* sv */ { IDS_VIC_PALETTE_FILENAME_SV, "VIC-palettfil" },
/* tr */ { IDS_VIC_PALETTE_FILENAME_TR, "VIC palet dosyas" },

/* en */ { IDS_VDC_PALETTE_FILENAME,    "VDC palette file" },
/* da */ { IDS_VDC_PALETTE_FILENAME_DA, "VDC-palettefil" },
/* de */ { IDS_VDC_PALETTE_FILENAME_DE, "VDC Paletten Datei" },
/* es */ { IDS_VDC_PALETTE_FILENAME_ES, "Fichero paleta VDC" },
/* fr */ { IDS_VDC_PALETTE_FILENAME_FR, "Fichier de palette VDC" },
/* hu */ { IDS_VDC_PALETTE_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_VDC_PALETTE_FILENAME_IT, "File palette VDC" },
/* ko */ { IDS_VDC_PALETTE_FILENAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_VDC_PALETTE_FILENAME_NL, "VDC palet bestand" },
/* pl */ { IDS_VDC_PALETTE_FILENAME_PL, "Plik palety VDC" },
/* ru */ { IDS_VDC_PALETTE_FILENAME_RU, "" },  /* fuzzy */
/* sv */ { IDS_VDC_PALETTE_FILENAME_SV, "VDC-palettfil" },
/* tr */ { IDS_VDC_PALETTE_FILENAME_TR, "VDC palet dosyas" },

/* en */ { IDS_CRTC_PALETTE_FILENAME,    "CRTC palette file" },
/* da */ { IDS_CRTC_PALETTE_FILENAME_DA, "CRTC-palettefil" },
/* de */ { IDS_CRTC_PALETTE_FILENAME_DE, "CRTC Paletten Datei" },
/* es */ { IDS_CRTC_PALETTE_FILENAME_ES, "Fichero paleta CRT" },
/* fr */ { IDS_CRTC_PALETTE_FILENAME_FR, "Fichier de palette CTRC" },
/* hu */ { IDS_CRTC_PALETTE_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_CRTC_PALETTE_FILENAME_IT, "File palette CRTC" },
/* ko */ { IDS_CRTC_PALETTE_FILENAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_CRTC_PALETTE_FILENAME_NL, "CRTC palet bestand" },
/* pl */ { IDS_CRTC_PALETTE_FILENAME_PL, "Plik palety CRTC" },
/* ru */ { IDS_CRTC_PALETTE_FILENAME_RU, "" },  /* fuzzy */
/* sv */ { IDS_CRTC_PALETTE_FILENAME_SV, "CRTC-palettfil" },
/* tr */ { IDS_CRTC_PALETTE_FILENAME_TR, "CRTC palet dosyas" },

/* en */ { IDS_TED_PALETTE_FILENAME,    "TED palette file" },
/* da */ { IDS_TED_PALETTE_FILENAME_DA, "TED-palettefil" },
/* de */ { IDS_TED_PALETTE_FILENAME_DE, "TED Paletten Datei" },
/* es */ { IDS_TED_PALETTE_FILENAME_ES, "Fichero paleta TED" },
/* fr */ { IDS_TED_PALETTE_FILENAME_FR, "Fichier de palette TED" },
/* hu */ { IDS_TED_PALETTE_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_TED_PALETTE_FILENAME_IT, "File palette TED" },
/* ko */ { IDS_TED_PALETTE_FILENAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_TED_PALETTE_FILENAME_NL, "TED palet bestand" },
/* pl */ { IDS_TED_PALETTE_FILENAME_PL, "Plik palety TED" },
/* ru */ { IDS_TED_PALETTE_FILENAME_RU, "TED palette file" },
/* sv */ { IDS_TED_PALETTE_FILENAME_SV, "TED-palettfil" },
/* tr */ { IDS_TED_PALETTE_FILENAME_TR, "TED palet dosyas" },

/* en */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT,    "Select printer dump file" },
/* da */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_DA, "Vlg udskriftsdumpfil" },
/* de */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_DE, "Drucker Ausgabedatei whlen" },
/* es */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_ES, "Seleccionar fichero de volcado impresion" },
/* fr */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_FR, "Slectionnez le fichier de sortie d'imprimante" },
/* hu */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_HU, "Vlassza ki a nyomtat kimeneti fjlt" },
/* it */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_IT, "Seleziona file su cui stampare" },
/* ko */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_KO, "   ϼ" },
/* nl */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_NL, "Selecteer printerdumpbestand" },
/* pl */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_PL, "Wybierz plik zrzutu drukarki" },
/* ru */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_RU, "Select printer dump file" },
/* sv */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_SV, "Vlj utskriftsdumpfil" },
/* tr */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_TR, "Yazc dkm dosyasn sein" },

/* en */ { IDS_PRINTER_4_EMULATION,    "Printer #4 emulation" },
/* da */ { IDS_PRINTER_4_EMULATION_DA, "Printer #4 emulering" },
/* de */ { IDS_PRINTER_4_EMULATION_DE, "Drucker #4 Emulation" },
/* es */ { IDS_PRINTER_4_EMULATION_ES, "Emulacin impresora #4" },
/* fr */ { IDS_PRINTER_4_EMULATION_FR, "mulation d'imprimante 4" },
/* hu */ { IDS_PRINTER_4_EMULATION_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_4_EMULATION_IT, "Emulazione stampante #4" },
/* ko */ { IDS_PRINTER_4_EMULATION_KO, " #4 ķ̼" },
/* nl */ { IDS_PRINTER_4_EMULATION_NL, "Printer #4 emulatie" },
/* pl */ { IDS_PRINTER_4_EMULATION_PL, "Emulacja drukarki #4" },
/* ru */ { IDS_PRINTER_4_EMULATION_RU, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_4_EMULATION_SV, "Emulering av skrivare 4" },
/* tr */ { IDS_PRINTER_4_EMULATION_TR, "Yazc #4 emlasyonu" },

/* en */ { IDS_PRINTER_5_EMULATION,    "Printer #5 emulation" },
/* da */ { IDS_PRINTER_5_EMULATION_DA, "Printer #5 emulering" },
/* de */ { IDS_PRINTER_5_EMULATION_DE, "Drucker #5 Emulation" },
/* es */ { IDS_PRINTER_5_EMULATION_ES, "Emulacin impresora #5" },
/* fr */ { IDS_PRINTER_5_EMULATION_FR, "mulation d'imprimante 5" },
/* hu */ { IDS_PRINTER_5_EMULATION_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_5_EMULATION_IT, "Emulazione stampante #5" },
/* ko */ { IDS_PRINTER_5_EMULATION_KO, " #5 ķ̼" },
/* nl */ { IDS_PRINTER_5_EMULATION_NL, "Printer #5 emulatie" },
/* pl */ { IDS_PRINTER_5_EMULATION_PL, "Emulacja drukarki #5" },
/* ru */ { IDS_PRINTER_5_EMULATION_RU, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_5_EMULATION_SV, "Emulering av skrivare 5" },
/* tr */ { IDS_PRINTER_5_EMULATION_TR, "Yazc #5 emlasyonu" },

/* en */ { IDS_PRINTER_6_EMULATION,    "Printer #6 emulation" },
/* da */ { IDS_PRINTER_6_EMULATION_DA, "" },  /* fuzzy */
/* de */ { IDS_PRINTER_6_EMULATION_DE, "Drucker #6 Emulation" },
/* es */ { IDS_PRINTER_6_EMULATION_ES, "Emulacin impresora #6" },
/* fr */ { IDS_PRINTER_6_EMULATION_FR, "" },  /* fuzzy */
/* hu */ { IDS_PRINTER_6_EMULATION_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_6_EMULATION_IT, "Emulazione stampante #6" },
/* ko */ { IDS_PRINTER_6_EMULATION_KO, "" },  /* fuzzy */
/* nl */ { IDS_PRINTER_6_EMULATION_NL, "Printer #6 emulatie" },
/* pl */ { IDS_PRINTER_6_EMULATION_PL, "Emulacja drukarki #6" },
/* ru */ { IDS_PRINTER_6_EMULATION_RU, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_6_EMULATION_SV, "" },  /* fuzzy */
/* tr */ { IDS_PRINTER_6_EMULATION_TR, "" },  /* fuzzy */

/* en */ { IDS_USERPORT_PRINTER_EMULATION,    "Userport printer emulation" },
/* da */ { IDS_USERPORT_PRINTER_EMULATION_DA, "Emulering af printer p brugerporten" },
/* de */ { IDS_USERPORT_PRINTER_EMULATION_DE, "Userport Drucker Emulation" },
/* es */ { IDS_USERPORT_PRINTER_EMULATION_ES, "Emulacin puerto usuario impresora" },
/* fr */ { IDS_USERPORT_PRINTER_EMULATION_FR, "mulation d'imprimante port utilisateur" },
/* hu */ { IDS_USERPORT_PRINTER_EMULATION_HU, "" },  /* fuzzy */
/* it */ { IDS_USERPORT_PRINTER_EMULATION_IT, "Stampante su userport: emulazione" },
/* ko */ { IDS_USERPORT_PRINTER_EMULATION_KO, "Ʈ  ķ̼" },
/* nl */ { IDS_USERPORT_PRINTER_EMULATION_NL, "Userport printer emulatie" },
/* pl */ { IDS_USERPORT_PRINTER_EMULATION_PL, "Emulacja drukarki w userporcie" },
/* ru */ { IDS_USERPORT_PRINTER_EMULATION_RU, "" },  /* fuzzy */
/* sv */ { IDS_USERPORT_PRINTER_EMULATION_SV, "Emulering av skrivare p anvndarporten" },
/* tr */ { IDS_USERPORT_PRINTER_EMULATION_TR, "Userport yazcs emlasyonu" },

/* en */ { IDS_PRINTER_4_DRIVER,    "Printer #4 driver" },
/* da */ { IDS_PRINTER_4_DRIVER_DA, "Printer #4 driver" },
/* de */ { IDS_PRINTER_4_DRIVER_DE, "Drucker #4 Treiber" },
/* es */ { IDS_PRINTER_4_DRIVER_ES, "Controlador impresora #4" },
/* fr */ { IDS_PRINTER_4_DRIVER_FR, "Pilote d'imprimante 4" },
/* hu */ { IDS_PRINTER_4_DRIVER_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_4_DRIVER_IT, "Driver stampante #4" },
/* ko */ { IDS_PRINTER_4_DRIVER_KO, " #4 ̹" },
/* nl */ { IDS_PRINTER_4_DRIVER_NL, "Printer #4 stuurprogramma" },
/* pl */ { IDS_PRINTER_4_DRIVER_PL, "Sterownik drukarki #4" },
/* ru */ { IDS_PRINTER_4_DRIVER_RU, "Printer #4 driver" },
/* sv */ { IDS_PRINTER_4_DRIVER_SV, "Drivrutin fr skrivare 4" },
/* tr */ { IDS_PRINTER_4_DRIVER_TR, "Yazc #4 srcs" },

/* en */ { IDS_PRINTER_5_DRIVER,    "Printer #5 driver" },
/* da */ { IDS_PRINTER_5_DRIVER_DA, "Printer #5 driver" },
/* de */ { IDS_PRINTER_5_DRIVER_DE, "Drucker #5 Treiber" },
/* es */ { IDS_PRINTER_5_DRIVER_ES, "Controlador impresora #5" },
/* fr */ { IDS_PRINTER_5_DRIVER_FR, "Pilote d'imprimante 5" },
/* hu */ { IDS_PRINTER_5_DRIVER_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_5_DRIVER_IT, "Driver stampante #5" },
/* ko */ { IDS_PRINTER_5_DRIVER_KO, "IEC  #5 ̹" },
/* nl */ { IDS_PRINTER_5_DRIVER_NL, "Printer #5 stuurprogramma" },
/* pl */ { IDS_PRINTER_5_DRIVER_PL, "Sterownik drukarki #5" },
/* ru */ { IDS_PRINTER_5_DRIVER_RU, "Printer #5 driver" },
/* sv */ { IDS_PRINTER_5_DRIVER_SV, "Drivrutin fr skrivare 5" },
/* tr */ { IDS_PRINTER_5_DRIVER_TR, "Yazc #5 srcs" },

/* en */ { IDS_PRINTER_6_DRIVER,    "Printer #6 driver" },
/* da */ { IDS_PRINTER_6_DRIVER_DA, "" },  /* fuzzy */
/* de */ { IDS_PRINTER_6_DRIVER_DE, "Drucker #6 Treiber" },
/* es */ { IDS_PRINTER_6_DRIVER_ES, "Controlador impresora #6" },
/* fr */ { IDS_PRINTER_6_DRIVER_FR, "" },  /* fuzzy */
/* hu */ { IDS_PRINTER_6_DRIVER_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_6_DRIVER_IT, "Driver stampante #6" },
/* ko */ { IDS_PRINTER_6_DRIVER_KO, "" },  /* fuzzy */
/* nl */ { IDS_PRINTER_6_DRIVER_NL, "Printer #6 stuurprogramma" },
/* pl */ { IDS_PRINTER_6_DRIVER_PL, "Sterownik drukarki #6" },
/* ru */ { IDS_PRINTER_6_DRIVER_RU, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_6_DRIVER_SV, "" },  /* fuzzy */
/* tr */ { IDS_PRINTER_6_DRIVER_TR, "" },  /* fuzzy */

/* en */ { IDS_USERPORT_PRINTER_DRIVER,    "Userport printer driver" },
/* da */ { IDS_USERPORT_PRINTER_DRIVER_DA, "Printerdriver for brugerporten" },
/* de */ { IDS_USERPORT_PRINTER_DRIVER_DE, "Userport Drucker Treiber" },
/* es */ { IDS_USERPORT_PRINTER_DRIVER_ES, "controlador puerto usuario" },
/* fr */ { IDS_USERPORT_PRINTER_DRIVER_FR, "Pilote de l'imprimante sur port utilisateur" },
/* hu */ { IDS_USERPORT_PRINTER_DRIVER_HU, "Userport-os nyomtat meghajt" },
/* it */ { IDS_USERPORT_PRINTER_DRIVER_IT, "Stampante su userport: driver" },
/* ko */ { IDS_USERPORT_PRINTER_DRIVER_KO, "Ʈ  ̹" },
/* nl */ { IDS_USERPORT_PRINTER_DRIVER_NL, "Userport printer stuurprogramma" },
/* pl */ { IDS_USERPORT_PRINTER_DRIVER_PL, "Sterownik drukarki w userporcie" },
/* ru */ { IDS_USERPORT_PRINTER_DRIVER_RU, "Userport printer driver" },
/* sv */ { IDS_USERPORT_PRINTER_DRIVER_SV, "Skrivardrivrutin fr anvndarporten" },
/* tr */ { IDS_USERPORT_PRINTER_DRIVER_TR, "Userport yazcs srcs" },

/* en */ { IDS_PRINTER_4_OUTPUT_TYPE,    "Printer #4 output type" },
/* da */ { IDS_PRINTER_4_OUTPUT_TYPE_DA, "Printer #4 uddatatype" },
/* de */ { IDS_PRINTER_4_OUTPUT_TYPE_DE, "Drucker #4 Ausgabetyp" },
/* es */ { IDS_PRINTER_4_OUTPUT_TYPE_ES, "Tipo salida impresora #4" },
/* fr */ { IDS_PRINTER_4_OUTPUT_TYPE_FR, "Type de sortie de l'imprimante 4" },
/* hu */ { IDS_PRINTER_4_OUTPUT_TYPE_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_4_OUTPUT_TYPE_IT, "Tipo di output stampante #4" },
/* ko */ { IDS_PRINTER_4_OUTPUT_TYPE_KO, "" },  /* fuzzy */
/* nl */ { IDS_PRINTER_4_OUTPUT_TYPE_NL, "Printer #4 uitvoer soort" },
/* pl */ { IDS_PRINTER_4_OUTPUT_TYPE_PL, "Typ wyjcia drukarki #4" },
/* ru */ { IDS_PRINTER_4_OUTPUT_TYPE_RU, "Printer #4 output type" },
/* sv */ { IDS_PRINTER_4_OUTPUT_TYPE_SV, "Utdatatyp fr skrivare 4" },
/* tr */ { IDS_PRINTER_4_OUTPUT_TYPE_TR, "Yazc #4 kt tipi" },

/* en */ { IDS_PRINTER_5_OUTPUT_TYPE,    "Printer #5 output type" },
/* da */ { IDS_PRINTER_5_OUTPUT_TYPE_DA, "Printer #5 uddatatype" },
/* de */ { IDS_PRINTER_5_OUTPUT_TYPE_DE, "Drucker #5 Ausgabetyp" },
/* es */ { IDS_PRINTER_5_OUTPUT_TYPE_ES, "Tipo salida impresora #5" },
/* fr */ { IDS_PRINTER_5_OUTPUT_TYPE_FR, "Type de sortie de l'imprimante 5" },
/* hu */ { IDS_PRINTER_5_OUTPUT_TYPE_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_5_OUTPUT_TYPE_IT, "Tipo di output stampante #5" },
/* ko */ { IDS_PRINTER_5_OUTPUT_TYPE_KO, "" },  /* fuzzy */
/* nl */ { IDS_PRINTER_5_OUTPUT_TYPE_NL, "Printer #5 uitvoer soort" },
/* pl */ { IDS_PRINTER_5_OUTPUT_TYPE_PL, "Typ wyjcia drukarki #5" },
/* ru */ { IDS_PRINTER_5_OUTPUT_TYPE_RU, "Printer #5 output type" },
/* sv */ { IDS_PRINTER_5_OUTPUT_TYPE_SV, "Utdatatyp fr skrivare 5" },
/* tr */ { IDS_PRINTER_5_OUTPUT_TYPE_TR, "Yazc #5 kt tipi" },

/* en */ { IDS_PRINTER_6_OUTPUT_TYPE,    "Printer #6 output type" },
/* da */ { IDS_PRINTER_6_OUTPUT_TYPE_DA, "" },  /* fuzzy */
/* de */ { IDS_PRINTER_6_OUTPUT_TYPE_DE, "Drucker #6 Ausgabetyp" },
/* es */ { IDS_PRINTER_6_OUTPUT_TYPE_ES, "Tipo salida impresora #6" },
/* fr */ { IDS_PRINTER_6_OUTPUT_TYPE_FR, "" },  /* fuzzy */
/* hu */ { IDS_PRINTER_6_OUTPUT_TYPE_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_6_OUTPUT_TYPE_IT, "Tipo di output stampante #6" },
/* ko */ { IDS_PRINTER_6_OUTPUT_TYPE_KO, "" },  /* fuzzy */
/* nl */ { IDS_PRINTER_6_OUTPUT_TYPE_NL, "Printer #6 uitvoer soort" },
/* pl */ { IDS_PRINTER_6_OUTPUT_TYPE_PL, "Typ wyjcia drukarki #6" },
/* ru */ { IDS_PRINTER_6_OUTPUT_TYPE_RU, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_6_OUTPUT_TYPE_SV, "" },  /* fuzzy */
/* tr */ { IDS_PRINTER_6_OUTPUT_TYPE_TR, "" },  /* fuzzy */

/* en */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE,    "Userport printer output type" },
/* da */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_DA, "Printer uddatatype p brugerporten" },
/* de */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_DE, "Userport Drucker Ausgabetyp" },
/* es */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_ES, "Tipo salida puerto impresora" },
/* fr */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_FR, "Type de sortie de l'imprimante port utilisateur" },
/* hu */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_HU, "" },  /* fuzzy */
/* it */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_IT, "Tipo di output stampante su userport" },
/* ko */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_KO, "" },  /* fuzzy */
/* nl */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_NL, "Userport printer uitvoer soort" },
/* pl */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_PL, "Typ wyjcia drukarki w userporcie" },
/* ru */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_RU, "Userport printer output type" },
/* sv */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_SV, "Utdatatyp fr anvndarportskrivare" },
/* tr */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_TR, "Userport yazcs kt tipi" },

/* en */ { IDS_PRINTER_4_OUTPUT_DEVICE,    "Printer #4 output device" },
/* da */ { IDS_PRINTER_4_OUTPUT_DEVICE_DA, "Printer #4 uddataenhed" },
/* de */ { IDS_PRINTER_4_OUTPUT_DEVICE_DE, "Drucker #4 Ausgabegert" },
/* es */ { IDS_PRINTER_4_OUTPUT_DEVICE_ES, "Perifrico salida impresora #4" },
/* fr */ { IDS_PRINTER_4_OUTPUT_DEVICE_FR, "Priphrique de sortie de l'imprimante 4" },
/* hu */ { IDS_PRINTER_4_OUTPUT_DEVICE_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_4_OUTPUT_DEVICE_IT, "Dispositivo di output stampante #4" },
/* ko */ { IDS_PRINTER_4_OUTPUT_DEVICE_KO, "" },  /* fuzzy */
/* nl */ { IDS_PRINTER_4_OUTPUT_DEVICE_NL, "Printer #4 uitvoer apparaat" },
/* pl */ { IDS_PRINTER_4_OUTPUT_DEVICE_PL, "Urzdzenie wyjcia drukarki #4" },
/* ru */ { IDS_PRINTER_4_OUTPUT_DEVICE_RU, "Printer #4 output device" },
/* sv */ { IDS_PRINTER_4_OUTPUT_DEVICE_SV, "Textutenhet fr skrivare 4" },
/* tr */ { IDS_PRINTER_4_OUTPUT_DEVICE_TR, "Yazc #4 kt aygt" },

/* en */ { IDS_PRINTER_5_OUTPUT_DEVICE,    "Printer #5 output device" },
/* da */ { IDS_PRINTER_5_OUTPUT_DEVICE_DA, "Printer #5 uddataenhed" },
/* de */ { IDS_PRINTER_5_OUTPUT_DEVICE_DE, "Drucker #5 Ausgabegert" },
/* es */ { IDS_PRINTER_5_OUTPUT_DEVICE_ES, "Perifrico salida impresora #5" },
/* fr */ { IDS_PRINTER_5_OUTPUT_DEVICE_FR, "Priphrique de sortie de l'imprimante 5" },
/* hu */ { IDS_PRINTER_5_OUTPUT_DEVICE_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_5_OUTPUT_DEVICE_IT, "Dispositivo di output stampante #5" },
/* ko */ { IDS_PRINTER_5_OUTPUT_DEVICE_KO, "" },  /* fuzzy */
/* nl */ { IDS_PRINTER_5_OUTPUT_DEVICE_NL, "Printer #5 uitvoer apparaat" },
/* pl */ { IDS_PRINTER_5_OUTPUT_DEVICE_PL, "Urzdzenie wyjcia drukarki #5" },
/* ru */ { IDS_PRINTER_5_OUTPUT_DEVICE_RU, "Printer #5 output device" },
/* sv */ { IDS_PRINTER_5_OUTPUT_DEVICE_SV, "Textutenhet fr skrivare 5" },
/* tr */ { IDS_PRINTER_5_OUTPUT_DEVICE_TR, "Yazc #5 kt aygt" },

/* en */ { IDS_PRINTER_6_OUTPUT_DEVICE,    "Printer #6 output device" },
/* da */ { IDS_PRINTER_6_OUTPUT_DEVICE_DA, "" },  /* fuzzy */
/* de */ { IDS_PRINTER_6_OUTPUT_DEVICE_DE, "Drucker #6 Ausgabegert" },
/* es */ { IDS_PRINTER_6_OUTPUT_DEVICE_ES, "Perifrico salida impresora #6" },
/* fr */ { IDS_PRINTER_6_OUTPUT_DEVICE_FR, "" },  /* fuzzy */
/* hu */ { IDS_PRINTER_6_OUTPUT_DEVICE_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_6_OUTPUT_DEVICE_IT, "Dispositivo di output stampante #6" },
/* ko */ { IDS_PRINTER_6_OUTPUT_DEVICE_KO, "" },  /* fuzzy */
/* nl */ { IDS_PRINTER_6_OUTPUT_DEVICE_NL, "Printer #6 uitvoer apparaat" },
/* pl */ { IDS_PRINTER_6_OUTPUT_DEVICE_PL, "Urzdzenie wyjcia drukarki #6" },
/* ru */ { IDS_PRINTER_6_OUTPUT_DEVICE_RU, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_6_OUTPUT_DEVICE_SV, "" },  /* fuzzy */
/* tr */ { IDS_PRINTER_6_OUTPUT_DEVICE_TR, "" },  /* fuzzy */

/* en */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE,    "Userport printer output device" },
/* da */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_DA, "Brugerport printer uddataenhed" },
/* de */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_DE, "Userport Drucker Ausgabegert" },
/* es */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_ES, "Perifrico salida puerto impresora" },
/* fr */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_FR, "Priphrique de sortie de l'imprimante port utilisateur" },
/* hu */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_HU, "" },  /* fuzzy */
/* it */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_IT, "Dispositivo di output stampante su userport" },
/* ko */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_KO, "" },  /* fuzzy */
/* nl */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_NL, "Userport printer uitvoer apparaat" },
/* pl */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_PL, "Urzdzenie wyjcia drukarki w userporcie" },
/* ru */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_RU, "Userport printer output device" },
/* sv */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_SV, "Textutenhet fr anvndarportskrivare" },
/* tr */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_TR, "Userport yazcs kt aygt" },

/* en */ { IDS_PRINTER_4_SEND_FORMFEED,    "Send formfeed to printer #4" },
/* da */ { IDS_PRINTER_4_SEND_FORMFEED_DA, "Send sideskift til printer #4" },
/* de */ { IDS_PRINTER_4_SEND_FORMFEED_DE, "Seitenvorschub zu Drucker #4 senden" },
/* es */ { IDS_PRINTER_4_SEND_FORMFEED_ES, "Enviar alimentacin formulario a impresora #4" },
/* fr */ { IDS_PRINTER_4_SEND_FORMFEED_FR, "Envoyer saut-de-page  l'imprimante 4" },
/* hu */ { IDS_PRINTER_4_SEND_FORMFEED_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_4_SEND_FORMFEED_IT, "Invia formfeed alla stampante #4" },
/* ko */ { IDS_PRINTER_4_SEND_FORMFEED_KO, "" },  /* fuzzy */
/* nl */ { IDS_PRINTER_4_SEND_FORMFEED_NL, "Zend formfeed naar printer #4" },
/* pl */ { IDS_PRINTER_4_SEND_FORMFEED_PL, "Wylij Form Feed do drukarki #4" },
/* ru */ { IDS_PRINTER_4_SEND_FORMFEED_RU, "Send formfeed to printer #4" },
/* sv */ { IDS_PRINTER_4_SEND_FORMFEED_SV, "Snd sidmatning till skrivare 4" },
/* tr */ { IDS_PRINTER_4_SEND_FORMFEED_TR, "Yazc #4'e sayfa ilerletme gnder" },

/* en */ { IDS_PRINTER_5_SEND_FORMFEED,    "Send formfeed to printer #5" },
/* da */ { IDS_PRINTER_5_SEND_FORMFEED_DA, "Send sideskift til printer #5" },
/* de */ { IDS_PRINTER_5_SEND_FORMFEED_DE, "Seitenvorschub zu Drucker #5 senden" },
/* es */ { IDS_PRINTER_5_SEND_FORMFEED_ES, "Enviar alimentacin formulario a impresora #5" },
/* fr */ { IDS_PRINTER_5_SEND_FORMFEED_FR, "Envoyer saut-de-page  l'imprimante 5" },
/* hu */ { IDS_PRINTER_5_SEND_FORMFEED_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_5_SEND_FORMFEED_IT, "Invia formfeed alla stampante #5" },
/* ko */ { IDS_PRINTER_5_SEND_FORMFEED_KO, "" },  /* fuzzy */
/* nl */ { IDS_PRINTER_5_SEND_FORMFEED_NL, "Zend formfeed naar printer #5" },
/* pl */ { IDS_PRINTER_5_SEND_FORMFEED_PL, "Wylij Form Feed do drukarki #5" },
/* ru */ { IDS_PRINTER_5_SEND_FORMFEED_RU, "Send formfeed to printer #5" },
/* sv */ { IDS_PRINTER_5_SEND_FORMFEED_SV, "Snd sidmatning till skrivare 5" },
/* tr */ { IDS_PRINTER_5_SEND_FORMFEED_TR, "Yazc #5'e sayfa ilerletme gnder" },

/* en */ { IDS_PRINTER_6_SEND_FORMFEED,    "Send formfeed to printer #6" },
/* da */ { IDS_PRINTER_6_SEND_FORMFEED_DA, "" },  /* fuzzy */
/* de */ { IDS_PRINTER_6_SEND_FORMFEED_DE, "Seitenvorschub zu Drucker #6 senden" },
/* es */ { IDS_PRINTER_6_SEND_FORMFEED_ES, "Enviar alimentacin formulario a impresora #6" },
/* fr */ { IDS_PRINTER_6_SEND_FORMFEED_FR, "" },  /* fuzzy */
/* hu */ { IDS_PRINTER_6_SEND_FORMFEED_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_6_SEND_FORMFEED_IT, "Invia formfeed alla stampante #6" },
/* ko */ { IDS_PRINTER_6_SEND_FORMFEED_KO, "" },  /* fuzzy */
/* nl */ { IDS_PRINTER_6_SEND_FORMFEED_NL, "Zend formfeed naar printer #6" },
/* pl */ { IDS_PRINTER_6_SEND_FORMFEED_PL, "Wylij Form Feed do drukarki #6" },
/* ru */ { IDS_PRINTER_6_SEND_FORMFEED_RU, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_6_SEND_FORMFEED_SV, "" },  /* fuzzy */
/* tr */ { IDS_PRINTER_6_SEND_FORMFEED_TR, "" },  /* fuzzy */

/* en */ { IDS_USERPORT_PRINTER_SEND_FORMFEED,    "Send formfeed to userport printer" },
/* da */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_DA, "Send sideskift til brugerports-printer" },
/* de */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_DE, "Seitenvorschub zui Userport Drucker senden" },
/* es */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_ES, "Enviar alimentacin formulario a puerto impresora" },
/* fr */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_FR, "Envoyer saut-de-page  l'imprimante sur port utilisateur" },
/* hu */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_HU, "" },  /* fuzzy */
/* it */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_IT, "Invia formfeed alla stampante su userport" },
/* ko */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_KO, "" },  /* fuzzy */
/* nl */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_NL, "Zend formfeed naar userport printer" },
/* pl */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_PL, "Wylij Form Feed do drukarki w userporcie" },
/* ru */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_RU, "Send formfeed to userport printer" },
/* sv */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_SV, "Snd sidmatning till anvndarportskrivare" },
/* tr */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_TR, "Userport yazcs'na sayfa ilerletme gnder" },

/* en */ { IDS_PRINTER_DEVICE_1_FILENAME,    "Printer device #1 output" },
/* da */ { IDS_PRINTER_DEVICE_1_FILENAME_DA, "Printer enhed #1 uddata" },
/* de */ { IDS_PRINTER_DEVICE_1_FILENAME_DE, "Drucker Gert #1 Ausgabe" },
/* es */ { IDS_PRINTER_DEVICE_1_FILENAME_ES, "Perifrico de salida impresora #1" },
/* fr */ { IDS_PRINTER_DEVICE_1_FILENAME_FR, "Sortie du priphrique d'imprimante texte 1" },
/* hu */ { IDS_PRINTER_DEVICE_1_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_DEVICE_1_FILENAME_IT, "Output stampante #1..." },
/* ko */ { IDS_PRINTER_DEVICE_1_FILENAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_PRINTER_DEVICE_1_FILENAME_NL, "Printer apparaat #1 uitvoer" },
/* pl */ { IDS_PRINTER_DEVICE_1_FILENAME_PL, "Wyjcie urzdzenia drukarki #1" },
/* ru */ { IDS_PRINTER_DEVICE_1_FILENAME_RU, "Printer device #1 output" },
/* sv */ { IDS_PRINTER_DEVICE_1_FILENAME_SV, "Utdata fr skrivarenhet 1" },
/* tr */ { IDS_PRINTER_DEVICE_1_FILENAME_TR, "Yazc aygt #1 kts" },

/* en */ { IDS_PRINTER_DEVICE_2_FILENAME,    "Printer device #2 output" },
/* da */ { IDS_PRINTER_DEVICE_2_FILENAME_DA, "Printer enhed #2 uddata" },
/* de */ { IDS_PRINTER_DEVICE_2_FILENAME_DE, "Drucker Gert #2 Ausgabe" },
/* es */ { IDS_PRINTER_DEVICE_2_FILENAME_ES, "Perifrico de salida impresora #2" },
/* fr */ { IDS_PRINTER_DEVICE_2_FILENAME_FR, "Sortie du priphrique d'imprimante texte 2" },
/* hu */ { IDS_PRINTER_DEVICE_2_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_DEVICE_2_FILENAME_IT, "Output stampante #2..." },
/* ko */ { IDS_PRINTER_DEVICE_2_FILENAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_PRINTER_DEVICE_2_FILENAME_NL, "Printer apparaat #2 uitvoer" },
/* pl */ { IDS_PRINTER_DEVICE_2_FILENAME_PL, "Wyjcie urzdzenia drukarki #2" },
/* ru */ { IDS_PRINTER_DEVICE_2_FILENAME_RU, "Printer device #2 output" },
/* sv */ { IDS_PRINTER_DEVICE_2_FILENAME_SV, "Utdata fr skrivarenhet 2" },
/* tr */ { IDS_PRINTER_DEVICE_2_FILENAME_TR, "Yazc aygt #2 kts" },

/* en */ { IDS_PRINTER_DEVICE_3_FILENAME,    "Printer device #3 output" },
/* da */ { IDS_PRINTER_DEVICE_3_FILENAME_DA, "Printer enhed #3 uddata" },
/* de */ { IDS_PRINTER_DEVICE_3_FILENAME_DE, "Drucker Gert #3 Ausgabe" },
/* es */ { IDS_PRINTER_DEVICE_3_FILENAME_ES, "Perifrico de salida impresora #3" },
/* fr */ { IDS_PRINTER_DEVICE_3_FILENAME_FR, "Sortie du priphrique d'imprimante texte 3" },
/* hu */ { IDS_PRINTER_DEVICE_3_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_DEVICE_3_FILENAME_IT, "Output stampante #3..." },
/* ko */ { IDS_PRINTER_DEVICE_3_FILENAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_PRINTER_DEVICE_3_FILENAME_NL, "Printer apparaat #3 uitvoer" },
/* pl */ { IDS_PRINTER_DEVICE_3_FILENAME_PL, "Wyjcie urzdzenia drukarki #3" },
/* ru */ { IDS_PRINTER_DEVICE_3_FILENAME_RU, "Printer device #3 output" },
/* sv */ { IDS_PRINTER_DEVICE_3_FILENAME_SV, "Utdata fr skrivarenhet 3" },
/* tr */ { IDS_PRINTER_DEVICE_3_FILENAME_TR, "Yazc aygt #3 kts" },

/* en */ { IDS_ENABLE_IEC_PRINTER_4,    "IEC emulation for printer #4" },
/* da */ { IDS_ENABLE_IEC_PRINTER_4_DA, "IEC-emulering for printer #4" },
/* de */ { IDS_ENABLE_IEC_PRINTER_4_DE, "IEC Gerte Emulation fr Drucker #4" },
/* es */ { IDS_ENABLE_IEC_PRINTER_4_ES, "Emulacin IEC para impresora #4" },
/* fr */ { IDS_ENABLE_IEC_PRINTER_4_FR, "Activer l'mulation IEC pour l'imprimante 4" },
/* hu */ { IDS_ENABLE_IEC_PRINTER_4_HU, "" },  /* fuzzy */
/* it */ { IDS_ENABLE_IEC_PRINTER_4_IT, "Emulazione IEC per la stampante #4" },
/* ko */ { IDS_ENABLE_IEC_PRINTER_4_KO, "" },  /* fuzzy */
/* nl */ { IDS_ENABLE_IEC_PRINTER_4_NL, "IEC emulatie voor printer #4" },
/* pl */ { IDS_ENABLE_IEC_PRINTER_4_PL, "Emulacja IEC drukarki #4" },
/* ru */ { IDS_ENABLE_IEC_PRINTER_4_RU, "IEC emulation for printer #4" },
/* sv */ { IDS_ENABLE_IEC_PRINTER_4_SV, "IEC-emulering fr skrivare 4" },
/* tr */ { IDS_ENABLE_IEC_PRINTER_4_TR, "Yazc #4 iin IEC emlasyonu" },

/* en */ { IDS_ENABLE_IEC_PRINTER_5,    "IEC emulation for printer #5" },
/* da */ { IDS_ENABLE_IEC_PRINTER_5_DA, "IEC-emulering for printer #5" },
/* de */ { IDS_ENABLE_IEC_PRINTER_5_DE, "IEC Gerte Emulation fr Drucker #5" },
/* es */ { IDS_ENABLE_IEC_PRINTER_5_ES, "Emulacin IEC para impresora #5" },
/* fr */ { IDS_ENABLE_IEC_PRINTER_5_FR, "Activer l'mulation IEC pour l'imprimante 5" },
/* hu */ { IDS_ENABLE_IEC_PRINTER_5_HU, "" },  /* fuzzy */
/* it */ { IDS_ENABLE_IEC_PRINTER_5_IT, "Emulazione IEC per la stampante #5" },
/* ko */ { IDS_ENABLE_IEC_PRINTER_5_KO, "" },  /* fuzzy */
/* nl */ { IDS_ENABLE_IEC_PRINTER_5_NL, "IEC emulatie voor printer #5" },
/* pl */ { IDS_ENABLE_IEC_PRINTER_5_PL, "Emulacja IEC drukarki #5" },
/* ru */ { IDS_ENABLE_IEC_PRINTER_5_RU, "IEC emulation for printer #5" },
/* sv */ { IDS_ENABLE_IEC_PRINTER_5_SV, "IEC-emulering fr skrivare 5" },
/* tr */ { IDS_ENABLE_IEC_PRINTER_5_TR, "Yazc #5 iin IEC emlasyonu" },

/* en */ { IDS_ENABLE_IEC_PRINTER_6,    "IEC emulation for printer #6" },
/* da */ { IDS_ENABLE_IEC_PRINTER_6_DA, "" },  /* fuzzy */
/* de */ { IDS_ENABLE_IEC_PRINTER_6_DE, "IEC Gerte Emulation fr Drucker #6" },
/* es */ { IDS_ENABLE_IEC_PRINTER_6_ES, "Emulacin IEC para impresora #6" },
/* fr */ { IDS_ENABLE_IEC_PRINTER_6_FR, "" },  /* fuzzy */
/* hu */ { IDS_ENABLE_IEC_PRINTER_6_HU, "" },  /* fuzzy */
/* it */ { IDS_ENABLE_IEC_PRINTER_6_IT, "Emulazione IEC per la stampante #6" },
/* ko */ { IDS_ENABLE_IEC_PRINTER_6_KO, "" },  /* fuzzy */
/* nl */ { IDS_ENABLE_IEC_PRINTER_6_NL, "IEC emulatie voor printer #6" },
/* pl */ { IDS_ENABLE_IEC_PRINTER_6_PL, "Emulacja IEC drukarki #6" },
/* ru */ { IDS_ENABLE_IEC_PRINTER_6_RU, "" },  /* fuzzy */
/* sv */ { IDS_ENABLE_IEC_PRINTER_6_SV, "" },  /* fuzzy */
/* tr */ { IDS_ENABLE_IEC_PRINTER_6_TR, "" },  /* fuzzy */

/* en */ { IDS_ENABLE_IEC_DEVICE_7,    "IEC emulation for device #7" },
/* da */ { IDS_ENABLE_IEC_DEVICE_7_DA, "" },  /* fuzzy */
/* de */ { IDS_ENABLE_IEC_DEVICE_7_DE, "IEC Emulation fr Gert #7" },
/* es */ { IDS_ENABLE_IEC_DEVICE_7_ES, "Emulacin IEC para impresora #7" },
/* fr */ { IDS_ENABLE_IEC_DEVICE_7_FR, "" },  /* fuzzy */
/* hu */ { IDS_ENABLE_IEC_DEVICE_7_HU, "" },  /* fuzzy */
/* it */ { IDS_ENABLE_IEC_DEVICE_7_IT, "Emulazione IEC per la stampante #7" },
/* ko */ { IDS_ENABLE_IEC_DEVICE_7_KO, "" },  /* fuzzy */
/* nl */ { IDS_ENABLE_IEC_DEVICE_7_NL, "IEC emulatie voor printer #7" },
/* pl */ { IDS_ENABLE_IEC_DEVICE_7_PL, "Emulacja IEC urzdzenia #7" },
/* ru */ { IDS_ENABLE_IEC_DEVICE_7_RU, "" },  /* fuzzy */
/* sv */ { IDS_ENABLE_IEC_DEVICE_7_SV, "" },  /* fuzzy */
/* tr */ { IDS_ENABLE_IEC_DEVICE_7_TR, "" },  /* fuzzy */

/* en */ { IDS_PRINTER_SETTINGS,    "Printer settings" },
/* da */ { IDS_PRINTER_SETTINGS_DA, "Printerindstillinger" },
/* de */ { IDS_PRINTER_SETTINGS_DE, "Drucker Einstellungen" },
/* es */ { IDS_PRINTER_SETTINGS_ES, "Ajustes de impresora" },
/* fr */ { IDS_PRINTER_SETTINGS_FR, "Paramtres d'imprimante" },
/* hu */ { IDS_PRINTER_SETTINGS_HU, "Nyomtat belltsai" },
/* it */ { IDS_PRINTER_SETTINGS_IT, "Impostazioni stampanti" },
/* ko */ { IDS_PRINTER_SETTINGS_KO, " " },
/* nl */ { IDS_PRINTER_SETTINGS_NL, "Printer instellingen" },
/* pl */ { IDS_PRINTER_SETTINGS_PL, "Ustawienia drukarki" },
/* ru */ { IDS_PRINTER_SETTINGS_RU, " " },
/* sv */ { IDS_PRINTER_SETTINGS_SV, "Skrivarinstllningar" },
/* tr */ { IDS_PRINTER_SETTINGS_TR, "Yazc ayarlar" },

/* en */ { IDS_MAGIC_VOICE_FILENAME,    "Magic Voice file" },
/* da */ { IDS_MAGIC_VOICE_FILENAME_DA, "Magic Voice-fil" },
/* de */ { IDS_MAGIC_VOICE_FILENAME_DE, "Magic Voice Datei" },
/* es */ { IDS_MAGIC_VOICE_FILENAME_ES, "Fichero Magic Voice" },
/* fr */ { IDS_MAGIC_VOICE_FILENAME_FR, "Fichier Magic Voice" },
/* hu */ { IDS_MAGIC_VOICE_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_MAGIC_VOICE_FILENAME_IT, "File Magic Voice" },
/* ko */ { IDS_MAGIC_VOICE_FILENAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_MAGIC_VOICE_FILENAME_NL, "Magic Voice bestand" },
/* pl */ { IDS_MAGIC_VOICE_FILENAME_PL, "Plik Magic Voice" },
/* ru */ { IDS_MAGIC_VOICE_FILENAME_RU, "" },  /* fuzzy */
/* sv */ { IDS_MAGIC_VOICE_FILENAME_SV, "Magic Voice-fil" },
/* tr */ { IDS_MAGIC_VOICE_FILENAME_TR, "Magic Voice dosyas" },

/* en */ { IDS_MAGIC_VOICE_FILENAME_SELECT,    "Select file for Magic Voice" },
/* da */ { IDS_MAGIC_VOICE_FILENAME_SELECT_DA, "Vlg fil for Magic Voice" },
/* de */ { IDS_MAGIC_VOICE_FILENAME_SELECT_DE, "Datei fr Magic Voice auswhlen" },
/* es */ { IDS_MAGIC_VOICE_FILENAME_SELECT_ES, "Seleccionar fichero para Magic Voice" },
/* fr */ { IDS_MAGIC_VOICE_FILENAME_SELECT_FR, "Slectionner fichier pour Magic Voice" },
/* hu */ { IDS_MAGIC_VOICE_FILENAME_SELECT_HU, "" },  /* fuzzy */
/* it */ { IDS_MAGIC_VOICE_FILENAME_SELECT_IT, "Seleziona file per Magic Voice" },
/* ko */ { IDS_MAGIC_VOICE_FILENAME_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_MAGIC_VOICE_FILENAME_SELECT_NL, "Selecteer bestand voor Magic Voice" },
/* pl */ { IDS_MAGIC_VOICE_FILENAME_SELECT_PL, "Wybierz filtr Magic Voice" },
/* ru */ { IDS_MAGIC_VOICE_FILENAME_SELECT_RU, "Select file for Magic Voice" },
/* sv */ { IDS_MAGIC_VOICE_FILENAME_SELECT_SV, "Vlj fil fr Magic Voice" },
/* tr */ { IDS_MAGIC_VOICE_FILENAME_SELECT_TR, "Magic Voice iin dosya sein" },

/* en */ { IDS_MAGIC_VOICE_SETTINGS,    "Magic Voice settings" },
/* da */ { IDS_MAGIC_VOICE_SETTINGS_DA, "Magic Voice indstillinger" },
/* de */ { IDS_MAGIC_VOICE_SETTINGS_DE, "Magic Voice Einstellungen" },
/* es */ { IDS_MAGIC_VOICE_SETTINGS_ES, "Ajustes Magic Voice" },
/* fr */ { IDS_MAGIC_VOICE_SETTINGS_FR, "Paramtres Magic Voice" },
/* hu */ { IDS_MAGIC_VOICE_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_MAGIC_VOICE_SETTINGS_IT, "Impostazioni Magic Voice" },
/* ko */ { IDS_MAGIC_VOICE_SETTINGS_KO, "Magic Voice " },
/* nl */ { IDS_MAGIC_VOICE_SETTINGS_NL, "Magic Voice instellingen" },
/* pl */ { IDS_MAGIC_VOICE_SETTINGS_PL, "Ustawienia Magic Voice" },
/* ru */ { IDS_MAGIC_VOICE_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_MAGIC_VOICE_SETTINGS_SV, "Magic Voice-instllningar" },
/* tr */ { IDS_MAGIC_VOICE_SETTINGS_TR, "Magic Voice ayarlar" },

/* en */ { IDS_USERPORT_RS232,    "Userport RS232" },
/* da */ { IDS_USERPORT_RS232_DA, "Brugerport RS232" },
/* de */ { IDS_USERPORT_RS232_DE, "Userport RS232" },
/* es */ { IDS_USERPORT_RS232_ES, "Puerto RS232" },
/* fr */ { IDS_USERPORT_RS232_FR, "RS232 port utilisateur" },
/* hu */ { IDS_USERPORT_RS232_HU, "Userport RS232" },
/* it */ { IDS_USERPORT_RS232_IT, "Userport RS232" },
/* ko */ { IDS_USERPORT_RS232_KO, "" },  /* fuzzy */
/* nl */ { IDS_USERPORT_RS232_NL, "Userport RS232" },
/* pl */ { IDS_USERPORT_RS232_PL, "Userport RS232" },
/* ru */ { IDS_USERPORT_RS232_RU, "Userport RS232" },
/* sv */ { IDS_USERPORT_RS232_SV, "Anvndarport-RS232" },
/* tr */ { IDS_USERPORT_RS232_TR, "Userport RS232" },

/* en */ { IDS_USERPORT_DEVICE,    "Userport RS232 device" },
/* da */ { IDS_USERPORT_DEVICE_DA, "Brugerportens RS232-enhed" },
/* de */ { IDS_USERPORT_DEVICE_DE, "Userport RS232 Gert" },
/* es */ { IDS_USERPORT_DEVICE_ES, "Perifrico puerto RS232" },
/* fr */ { IDS_USERPORT_DEVICE_FR, "Priphrique de port utilisateur RS232" },
/* hu */ { IDS_USERPORT_DEVICE_HU, "Userport RS232 eszkz" },
/* it */ { IDS_USERPORT_DEVICE_IT, "Dispositivo RS232 su userport" },
/* ko */ { IDS_USERPORT_DEVICE_KO, "" },  /* fuzzy */
/* nl */ { IDS_USERPORT_DEVICE_NL, "Userport RS232 apparaat" },
/* pl */ { IDS_USERPORT_DEVICE_PL, "Urzdzenie userportu RS232" },
/* ru */ { IDS_USERPORT_DEVICE_RU, "Userport RS232 device" },
/* sv */ { IDS_USERPORT_DEVICE_SV, "Anvndarportens RS232-enhet" },
/* tr */ { IDS_USERPORT_DEVICE_TR, "Userport RS232 aygt" },

/* en */ { IDS_USERPORT_BAUD_RATE,    "Userport RS232 baud rate" },
/* da */ { IDS_USERPORT_BAUD_RATE_DA, "Brugerportens RS232-baudhastighet" },
/* de */ { IDS_USERPORT_BAUD_RATE_DE, "Userport RS232 Baud Rate" },
/* es */ { IDS_USERPORT_BAUD_RATE_ES, "Velocidad (baudios) puerto RS232" },
/* fr */ { IDS_USERPORT_BAUD_RATE_FR, "Priphrique de port utilisateur RS232" },
/* hu */ { IDS_USERPORT_BAUD_RATE_HU, "Userport RS232 tviteli rta" },
/* it */ { IDS_USERPORT_BAUD_RATE_IT, "Velocit RS232 su userport" },
/* ko */ { IDS_USERPORT_BAUD_RATE_KO, "" },  /* fuzzy */
/* nl */ { IDS_USERPORT_BAUD_RATE_NL, "Userport RS232 baudrate" },
/* pl */ { IDS_USERPORT_BAUD_RATE_PL, "Szybko transmisji userportu RS232" },
/* ru */ { IDS_USERPORT_BAUD_RATE_RU, "Userport RS232 baud rate" },
/* sv */ { IDS_USERPORT_BAUD_RATE_SV, "Anvndarportens RS232-baudhastighet" },
/* tr */ { IDS_USERPORT_BAUD_RATE_TR, "Userport RS232 baud rate" },

/* en */ { IDS_RS232_USERPORT_SETTINGS,    "RS232 userport settings" },
/* da */ { IDS_RS232_USERPORT_SETTINGS_DA, "RS232-brugerportindstillinger" },
/* de */ { IDS_RS232_USERPORT_SETTINGS_DE, "RS232 Userport Einstellungen" },
/* es */ { IDS_RS232_USERPORT_SETTINGS_ES, "Ajustes puerto RS232" },
/* fr */ { IDS_RS232_USERPORT_SETTINGS_FR, "Paramtres port utilisateur RS232" },
/* hu */ { IDS_RS232_USERPORT_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_RS232_USERPORT_SETTINGS_IT, "Impostazioni RS232 su userport" },
/* ko */ { IDS_RS232_USERPORT_SETTINGS_KO, "RS232 Ʈ " },
/* nl */ { IDS_RS232_USERPORT_SETTINGS_NL, "RS232 userport instellingen" },
/* pl */ { IDS_RS232_USERPORT_SETTINGS_PL, "Ustawienia userportu RS232" },
/* ru */ { IDS_RS232_USERPORT_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_RS232_USERPORT_SETTINGS_SV, "RS232-anvndarportinstllningar" },
/* tr */ { IDS_RS232_USERPORT_SETTINGS_TR, "RS232 userport ayarlar" },

/* en */ { IDS_FAST,    "Fast" },
/* da */ { IDS_FAST_DA, "Hurtig" },
/* de */ { IDS_FAST_DE, "Schnell" },
/* es */ { IDS_FAST_ES, "Rpido" },
/* fr */ { IDS_FAST_FR, "Rapide" },
/* hu */ { IDS_FAST_HU, "" },  /* fuzzy */
/* it */ { IDS_FAST_IT, "Veloce" },
/* ko */ { IDS_FAST_KO, "" },
/* nl */ { IDS_FAST_NL, "Snel" },
/* pl */ { IDS_FAST_PL, "Szybko" },
/* ru */ { IDS_FAST_RU, "Fast" },
/* sv */ { IDS_FAST_SV, "Snabbt" },
/* tr */ { IDS_FAST_TR, "Hzl" },

/* en */ { IDS_INTERPOLATING,    "Interpolating" },
/* da */ { IDS_INTERPOLATING_DA, "Interpolerende" },
/* de */ { IDS_INTERPOLATING_DE, "Interpolierend" },
/* es */ { IDS_INTERPOLATING_ES, "Interpolando" },
/* fr */ { IDS_INTERPOLATING_FR, "Par interpolation" },
/* hu */ { IDS_INTERPOLATING_HU, "" },  /* fuzzy */
/* it */ { IDS_INTERPOLATING_IT, "Interpolazione" },
/* ko */ { IDS_INTERPOLATING_KO, "ϴ" },
/* nl */ { IDS_INTERPOLATING_NL, "Interpoleren" },
/* pl */ { IDS_INTERPOLATING_PL, "Interpolacja" },
/* ru */ { IDS_INTERPOLATING_RU, "" },  /* fuzzy */
/* sv */ { IDS_INTERPOLATING_SV, "Interpolerande" },
/* tr */ { IDS_INTERPOLATING_TR, "Ara deer bulma" },

/* en */ { IDS_RESAMPLING,    "Resampling" },
/* da */ { IDS_RESAMPLING_DA, "Resampling" },
/* de */ { IDS_RESAMPLING_DE, "Resampling" },
/* es */ { IDS_RESAMPLING_ES, "Remuestreo" },
/* fr */ { IDS_RESAMPLING_FR, "Rchantillonnage" },
/* hu */ { IDS_RESAMPLING_HU, "" },  /* fuzzy */
/* it */ { IDS_RESAMPLING_IT, "Ricampionamento" },
/* ko */ { IDS_RESAMPLING_KO, "ø" },
/* nl */ { IDS_RESAMPLING_NL, "Resampling" },
/* pl */ { IDS_RESAMPLING_PL, "Przesamplowanie" },
/* ru */ { IDS_RESAMPLING_RU, "Resampling" },
/* sv */ { IDS_RESAMPLING_SV, "Omsamplande" },
/* tr */ { IDS_RESAMPLING_TR, "Yeniden rnekleme" },

/* en */ { IDS_FAST_RESAMPLING,    "Fast resampling" },
/* da */ { IDS_FAST_RESAMPLING_DA, "Hurtig omsampling" },
/* de */ { IDS_FAST_RESAMPLING_DE, "Schnelles Resampling" },
/* es */ { IDS_FAST_RESAMPLING_ES, "Remuestreo rpido" },
/* fr */ { IDS_FAST_RESAMPLING_FR, "Rchantillonage rapide" },
/* hu */ { IDS_FAST_RESAMPLING_HU, "" },  /* fuzzy */
/* it */ { IDS_FAST_RESAMPLING_IT, "Ricampionamento veloce" },
/* ko */ { IDS_FAST_RESAMPLING_KO, " " },
/* nl */ { IDS_FAST_RESAMPLING_NL, "Snelle resampling" },
/* pl */ { IDS_FAST_RESAMPLING_PL, "Szybkie przesamplowanie" },
/* ru */ { IDS_FAST_RESAMPLING_RU, "Fast resampling" },
/* sv */ { IDS_FAST_RESAMPLING_SV, "Snabb omsampling" },
/* tr */ { IDS_FAST_RESAMPLING_TR, "Hzl yeniden rnekleme" },

/* en */ { IDS_SID_STEREO,    "SID Stereo" },
/* da */ { IDS_SID_STEREO_DA, "SID-stereo" },
/* de */ { IDS_SID_STEREO_DE, "SID Stereo" },
/* es */ { IDS_SID_STEREO_ES, "SID estereo" },
/* fr */ { IDS_SID_STEREO_FR, "SID Stro" },
/* hu */ { IDS_SID_STEREO_HU, "SID sztere" },
/* it */ { IDS_SID_STEREO_IT, "Stereo SID" },
/* ko */ { IDS_SID_STEREO_KO, "" },  /* fuzzy */
/* nl */ { IDS_SID_STEREO_NL, "Stereo SID" },
/* pl */ { IDS_SID_STEREO_PL, "Stereo SID" },
/* ru */ { IDS_SID_STEREO_RU, "SID Stereo" },
/* sv */ { IDS_SID_STEREO_SV, "SID-stereo" },
/* tr */ { IDS_SID_STEREO_TR, "Stereo SID" },

/* en */ { IDS_AMOUNT_OF_EXTRA_SIDS,    "Amount of extra sids" },
/* da */ { IDS_AMOUNT_OF_EXTRA_SIDS_DA, "Antal ekstra SID-kredse" },
/* de */ { IDS_AMOUNT_OF_EXTRA_SIDS_DE, "Anzahl der extra SID Chips" },
/* es */ { IDS_AMOUNT_OF_EXTRA_SIDS_ES, "Cantidad de chips SID extra" },
/* fr */ { IDS_AMOUNT_OF_EXTRA_SIDS_FR, "Quantit de SIDs supplmantaires" },
/* hu */ { IDS_AMOUNT_OF_EXTRA_SIDS_HU, "" },  /* fuzzy */
/* it */ { IDS_AMOUNT_OF_EXTRA_SIDS_IT, "Numero di sid aggiuntivi" },
/* ko */ { IDS_AMOUNT_OF_EXTRA_SIDS_KO, "" },  /* fuzzy */
/* nl */ { IDS_AMOUNT_OF_EXTRA_SIDS_NL, "Aantal extra SID chips" },
/* pl */ { IDS_AMOUNT_OF_EXTRA_SIDS_PL, "Liczba dodatkowych SID-w" },
/* ru */ { IDS_AMOUNT_OF_EXTRA_SIDS_RU, "" },  /* fuzzy */
/* sv */ { IDS_AMOUNT_OF_EXTRA_SIDS_SV, "Antal extra SID-kretsar" },
/* tr */ { IDS_AMOUNT_OF_EXTRA_SIDS_TR, "Ekstra sid adedi" },

/* en */ { IDS_STEREO_SID_AT,    "Stereo SID at" },
/* da */ { IDS_STEREO_SID_AT_DA, "Stereo-SID p" },
/* de */ { IDS_STEREO_SID_AT_DE, "Stereo SID bei" },
/* es */ { IDS_STEREO_SID_AT_ES, "SID estereo en" },
/* fr */ { IDS_STEREO_SID_AT_FR, "SID Stro " },
/* hu */ { IDS_STEREO_SID_AT_HU, "Sztere SID itt:" },
/* it */ { IDS_STEREO_SID_AT_IT, "Stereo SID a" },
/* ko */ { IDS_STEREO_SID_AT_KO, "" },  /* fuzzy */
/* nl */ { IDS_STEREO_SID_AT_NL, "Stereo SID op" },
/* pl */ { IDS_STEREO_SID_AT_PL, "SID stereo w" },
/* ru */ { IDS_STEREO_SID_AT_RU, "Stereo SID at" },
/* sv */ { IDS_STEREO_SID_AT_SV, "Stereo-SID p" },
/* tr */ { IDS_STEREO_SID_AT_TR, "Stereo SID konumu" },

/* en */ { IDS_TRIPLE_SID_AT,    "Triple SID at" },
/* da */ { IDS_TRIPLE_SID_AT_DA, "Tredie SID p" },
/* de */ { IDS_TRIPLE_SID_AT_DE, "Dritter SID auf" },
/* es */ { IDS_TRIPLE_SID_AT_ES, "Triple SID en" },
/* fr */ { IDS_TRIPLE_SID_AT_FR, "Triple SID " },
/* hu */ { IDS_TRIPLE_SID_AT_HU, "" },  /* fuzzy */
/* it */ { IDS_TRIPLE_SID_AT_IT, "Triplo SID a" },
/* ko */ { IDS_TRIPLE_SID_AT_KO, "" },  /* fuzzy */
/* nl */ { IDS_TRIPLE_SID_AT_NL, "Derde SID op" },
/* pl */ { IDS_TRIPLE_SID_AT_PL, "Potrjny SID w" },
/* ru */ { IDS_TRIPLE_SID_AT_RU, "" },  /* fuzzy */
/* sv */ { IDS_TRIPLE_SID_AT_SV, "Trippel-SID p" },
/* tr */ { IDS_TRIPLE_SID_AT_TR, "l SID konumu" },

/* en */ { IDS_SID_FILTERS,    "SID filters" },
/* da */ { IDS_SID_FILTERS_DA, "SID-filtre" },
/* de */ { IDS_SID_FILTERS_DE, "SID Filter" },
/* es */ { IDS_SID_FILTERS_ES, "Filtros SID" },
/* fr */ { IDS_SID_FILTERS_FR, "Filtres SID" },
/* hu */ { IDS_SID_FILTERS_HU, "" },  /* fuzzy */
/* it */ { IDS_SID_FILTERS_IT, "Filtri SID" },
/* ko */ { IDS_SID_FILTERS_KO, "SID " },
/* nl */ { IDS_SID_FILTERS_NL, "SID filters" },
/* pl */ { IDS_SID_FILTERS_PL, "Filtry SID" },
/* ru */ { IDS_SID_FILTERS_RU, " SID" },
/* sv */ { IDS_SID_FILTERS_SV, "SID-filter" },
/* tr */ { IDS_SID_FILTERS_TR, "SID filtreleri" },

/* en */ { IDS_SAMPLE_METHOD,    "Sample method" },
/* da */ { IDS_SAMPLE_METHOD_DA, "Samplingmetode" },
/* de */ { IDS_SAMPLE_METHOD_DE, "Sample Methode" },
/* es */ { IDS_SAMPLE_METHOD_ES, "Mtodo de muestreo" },
/* fr */ { IDS_SAMPLE_METHOD_FR, "Mthode d'chantillonnage" },
/* hu */ { IDS_SAMPLE_METHOD_HU, "Mintavtelezs mdja" },
/* it */ { IDS_SAMPLE_METHOD_IT, "Metodo di campionamento" },
/* ko */ { IDS_SAMPLE_METHOD_KO, "" },  /* fuzzy */
/* nl */ { IDS_SAMPLE_METHOD_NL, "Sample methode" },
/* pl */ { IDS_SAMPLE_METHOD_PL, "Metoda samplowania" },
/* ru */ { IDS_SAMPLE_METHOD_RU, "Sample method" },
/* sv */ { IDS_SAMPLE_METHOD_SV, "Samplingsmetod" },
/* tr */ { IDS_SAMPLE_METHOD_TR, "rnekleme metodu" },

/* en */ { IDS_PASSBAND_0_90,    "Passband (0..90%)" },
/* da */ { IDS_PASSBAND_0_90_DA, "Pasbnd (0..90%)" },
/* de */ { IDS_PASSBAND_0_90_DE, "Passband (0..90%)" },
/* es */ { IDS_PASSBAND_0_90_ES, "Pasabanda (0..90%)" },
/* fr */ { IDS_PASSBAND_0_90_FR, "Bande passante (0..90%)" },
/* hu */ { IDS_PASSBAND_0_90_HU, "" },  /* fuzzy */
/* it */ { IDS_PASSBAND_0_90_IT, "Banda passante (0..90%)" },
/* ko */ { IDS_PASSBAND_0_90_KO, "" },  /* fuzzy */
/* nl */ { IDS_PASSBAND_0_90_NL, "Passband (0..90%)" },
/* pl */ { IDS_PASSBAND_0_90_PL, "Pasmo przepuszczania (0..90%)" },
/* ru */ { IDS_PASSBAND_0_90_RU, "Passband (0..90%)" },
/* sv */ { IDS_PASSBAND_0_90_SV, "Passband (0..90%)" },
/* tr */ { IDS_PASSBAND_0_90_TR, "Passband (0..90%)" },

/* en */ { IDS_GAIN_90_100,    "Gain (90..100)" },
/* da */ { IDS_GAIN_90_100_DA, "" },  /* fuzzy */
/* de */ { IDS_GAIN_90_100_DE, "Gain (90..100)" },
/* es */ { IDS_GAIN_90_100_ES, "Ganancia (90..100)" },
/* fr */ { IDS_GAIN_90_100_FR, "" },  /* fuzzy */
/* hu */ { IDS_GAIN_90_100_HU, "" },  /* fuzzy */
/* it */ { IDS_GAIN_90_100_IT, "Guadagno (90..100)" },
/* ko */ { IDS_GAIN_90_100_KO, "" },  /* fuzzy */
/* nl */ { IDS_GAIN_90_100_NL, "Toename (90..100)" },
/* pl */ { IDS_GAIN_90_100_PL, "Wzmocnienie (90..100)" },
/* ru */ { IDS_GAIN_90_100_RU, "" },  /* fuzzy */
/* sv */ { IDS_GAIN_90_100_SV, "" },  /* fuzzy */
/* tr */ { IDS_GAIN_90_100_TR, "" },  /* fuzzy */

/* en */ { IDS_GAIN_1_200,    "Gain (1..200)" },
/* da */ { IDS_GAIN_1_200_DA, "" },  /* fuzzy */
/* de */ { IDS_GAIN_1_200_DE, "Gain (1..200)" },
/* es */ { IDS_GAIN_1_200_ES, "Ganancia (1..200)" },
/* fr */ { IDS_GAIN_1_200_FR, "" },  /* fuzzy */
/* hu */ { IDS_GAIN_1_200_HU, "" },  /* fuzzy */
/* it */ { IDS_GAIN_1_200_IT, "Guadagno (1..200)" },
/* ko */ { IDS_GAIN_1_200_KO, "" },  /* fuzzy */
/* nl */ { IDS_GAIN_1_200_NL, "Toename (1..200)" },
/* pl */ { IDS_GAIN_1_200_PL, "Wzmocnienie (1..200)" },
/* ru */ { IDS_GAIN_1_200_RU, "" },  /* fuzzy */
/* sv */ { IDS_GAIN_1_200_SV, "" },  /* fuzzy */
/* tr */ { IDS_GAIN_1_200_TR, "" },  /* fuzzy */

/* en */ { IDS_BIAS_M5000_P5000,    "Filter bias (-5000..5000)" },
/* da */ { IDS_BIAS_M5000_P5000_DA, "" },  /* fuzzy */
/* de */ { IDS_BIAS_M5000_P5000_DE, "Filter Bias (-5000..5000)" },
/* es */ { IDS_BIAS_M5000_P5000_ES, "Filtros bias (-5000..5000)" },
/* fr */ { IDS_BIAS_M5000_P5000_FR, "" },  /* fuzzy */
/* hu */ { IDS_BIAS_M5000_P5000_HU, "" },  /* fuzzy */
/* it */ { IDS_BIAS_M5000_P5000_IT, "Bias del filtro (-5000..5000)" },
/* ko */ { IDS_BIAS_M5000_P5000_KO, "" },  /* fuzzy */
/* nl */ { IDS_BIAS_M5000_P5000_NL, "Filter voorkeur (-5000..5000)" },
/* pl */ { IDS_BIAS_M5000_P5000_PL, "Nastawienie filtra (-5000..5000)" },
/* ru */ { IDS_BIAS_M5000_P5000_RU, "" },  /* fuzzy */
/* sv */ { IDS_BIAS_M5000_P5000_SV, "" },  /* fuzzy */
/* tr */ { IDS_BIAS_M5000_P5000_TR, "" },  /* fuzzy */

/* en */ { IDS_NOT_IMPLEMENTED_YET,    "Not implemented yet!" },
/* da */ { IDS_NOT_IMPLEMENTED_YET_DA, "Endnu ikke implementeret!" },
/* de */ { IDS_NOT_IMPLEMENTED_YET_DE, "Noch nicht implementiert!" },
/* es */ { IDS_NOT_IMPLEMENTED_YET_ES, "No implementado an!" },
/* fr */ { IDS_NOT_IMPLEMENTED_YET_FR, "Pas encore implment!" },
/* hu */ { IDS_NOT_IMPLEMENTED_YET_HU, "Mg nem implementlt!" },
/* it */ { IDS_NOT_IMPLEMENTED_YET_IT, "Non ancora implementato!" },
/* ko */ { IDS_NOT_IMPLEMENTED_YET_KO, "" },  /* fuzzy */
/* nl */ { IDS_NOT_IMPLEMENTED_YET_NL, "Nog niet ondersteund!" },
/* pl */ { IDS_NOT_IMPLEMENTED_YET_PL, "Jeszcze nie zaimplementowano!" },
/* ru */ { IDS_NOT_IMPLEMENTED_YET_RU, "Not implemented yet!" },
/* sv */ { IDS_NOT_IMPLEMENTED_YET_SV, "Ej implementerat nnu!" },
/* tr */ { IDS_NOT_IMPLEMENTED_YET_TR, "Henz tamamlanmad!" },

/* en */ { IDS_SID_SETTINGS,    "SID settings" },
/* da */ { IDS_SID_SETTINGS_DA, "SID-indstillinger" },
/* de */ { IDS_SID_SETTINGS_DE, "SID Einstellungen" },
/* es */ { IDS_SID_SETTINGS_ES, "Ajustes SID" },
/* fr */ { IDS_SID_SETTINGS_FR, "Paramtres SID" },
/* hu */ { IDS_SID_SETTINGS_HU, "SID belltsai" },
/* it */ { IDS_SID_SETTINGS_IT, "Impostazioni SID" },
/* ko */ { IDS_SID_SETTINGS_KO, "SID " },
/* nl */ { IDS_SID_SETTINGS_NL, "SID instellingen" },
/* pl */ { IDS_SID_SETTINGS_PL, "Ustawienia SID" },
/* ru */ { IDS_SID_SETTINGS_RU, " SID" },
/* sv */ { IDS_SID_SETTINGS_SV, "SID-instllningar" },
/* tr */ { IDS_SID_SETTINGS_TR, "SID ayarlar" },

/* en */ { IDS_FLEXIBLE,    "Flexible" },
/* da */ { IDS_FLEXIBLE_DA, "Fleksibel" },
/* de */ { IDS_FLEXIBLE_DE, "Flexibel" },
/* es */ { IDS_FLEXIBLE_ES, "Flexible" },
/* fr */ { IDS_FLEXIBLE_FR, "Flexible" },
/* hu */ { IDS_FLEXIBLE_HU, "Rugalmas" },
/* it */ { IDS_FLEXIBLE_IT, "Flessibile" },
/* ko */ { IDS_FLEXIBLE_KO, "" },
/* nl */ { IDS_FLEXIBLE_NL, "Flexibel" },
/* pl */ { IDS_FLEXIBLE_PL, "Elastyczna" },
/* ru */ { IDS_FLEXIBLE_RU, "Flexible" },
/* sv */ { IDS_FLEXIBLE_SV, "Flexibel" },
/* tr */ { IDS_FLEXIBLE_TR, "Esnek" },

/* en */ { IDS_ADJUSTING,    "Adjusting" },
/* da */ { IDS_ADJUSTING_DA, "Tilpassende" },
/* de */ { IDS_ADJUSTING_DE, "Anpassend" },
/* es */ { IDS_ADJUSTING_ES, "Ajustado" },
/* fr */ { IDS_ADJUSTING_FR, "Ajust" },
/* hu */ { IDS_ADJUSTING_HU, "Igazod" },
/* it */ { IDS_ADJUSTING_IT, "Adattabile" },
/* ko */ { IDS_ADJUSTING_KO, "" },
/* nl */ { IDS_ADJUSTING_NL, "Aanpassend" },
/* pl */ { IDS_ADJUSTING_PL, "Dopasowana" },
/* ru */ { IDS_ADJUSTING_RU, "Adjusting" },
/* sv */ { IDS_ADJUSTING_SV, "Anpassande" },
/* tr */ { IDS_ADJUSTING_TR, "Dzeltme" },

/* en */ { IDS_EXACT,    "Exact" },
/* da */ { IDS_EXACT_DA, "Njagtig" },
/* de */ { IDS_EXACT_DE, "Exakt" },
/* es */ { IDS_EXACT_ES, "Exacto" },
/* fr */ { IDS_EXACT_FR, "Exact" },
/* hu */ { IDS_EXACT_HU, "Pontos" },
/* it */ { IDS_EXACT_IT, "Esatta" },
/* ko */ { IDS_EXACT_KO, "Ȯ" },
/* nl */ { IDS_EXACT_NL, "Exact" },
/* pl */ { IDS_EXACT_PL, "Dokadna" },
/* ru */ { IDS_EXACT_RU, "Exact" },
/* sv */ { IDS_EXACT_SV, "Exakt" },
/* tr */ { IDS_EXACT_TR, "Aynen" },

/* en */ { IDS_SAMPLE_RATE,    "Sample rate" },
/* da */ { IDS_SAMPLE_RATE_DA, "Samplingfrekvens" },
/* de */ { IDS_SAMPLE_RATE_DE, "Sample Rate" },
/* es */ { IDS_SAMPLE_RATE_ES, "Velocidad de sampleado" },
/* fr */ { IDS_SAMPLE_RATE_FR, "Taux d'chantillonage" },
/* hu */ { IDS_SAMPLE_RATE_HU, "Mintavtelezsi rta" },
/* it */ { IDS_SAMPLE_RATE_IT, "Frequenza di campionamento" },
/* ko */ { IDS_SAMPLE_RATE_KO, " Ʈ" },
/* nl */ { IDS_SAMPLE_RATE_NL, "Sample snelheid" },
/* pl */ { IDS_SAMPLE_RATE_PL, "Prbkowanie" },
/* ru */ { IDS_SAMPLE_RATE_RU, "Sample rate" },
/* sv */ { IDS_SAMPLE_RATE_SV, "Samplingshastighet" },
/* tr */ { IDS_SAMPLE_RATE_TR, "rnek hz" },

/* en */ { IDS_BUFFER_SIZE,    "Buffer size" },
/* da */ { IDS_BUFFER_SIZE_DA, "Bufferstrrelse" },
/* de */ { IDS_BUFFER_SIZE_DE, "Puffergre" },
/* es */ { IDS_BUFFER_SIZE_ES, "Tamao del buffer" },
/* fr */ { IDS_BUFFER_SIZE_FR, "Taille du tampon" },
/* hu */ { IDS_BUFFER_SIZE_HU, "Puffer mret" },
/* it */ { IDS_BUFFER_SIZE_IT, "Dimensione buffer" },
/* ko */ { IDS_BUFFER_SIZE_KO, " " },
/* nl */ { IDS_BUFFER_SIZE_NL, "Buffergrootte" },
/* pl */ { IDS_BUFFER_SIZE_PL, "Rozmiar buffora" },
/* ru */ { IDS_BUFFER_SIZE_RU, "Buffer size" },
/* sv */ { IDS_BUFFER_SIZE_SV, "Buffertstorlek" },
/* tr */ { IDS_BUFFER_SIZE_TR, "Arabellek boyutu" },

/* en */ { IDS_FRAGMENT_SIZE,    "Fragment size" },
/* da */ { IDS_FRAGMENT_SIZE_DA, "Fragmentstrrelse" },
/* de */ { IDS_FRAGMENT_SIZE_DE, "Fragmentgre" },
/* es */ { IDS_FRAGMENT_SIZE_ES, "Tamao de fragmento" },
/* fr */ { IDS_FRAGMENT_SIZE_FR, "taille du fragment" },
/* hu */ { IDS_FRAGMENT_SIZE_HU, "Tredk mrete" },
/* it */ { IDS_FRAGMENT_SIZE_IT, "Dimensione frammento" },
/* ko */ { IDS_FRAGMENT_SIZE_KO, "" },  /* fuzzy */
/* nl */ { IDS_FRAGMENT_SIZE_NL, "Fragment grootte" },
/* pl */ { IDS_FRAGMENT_SIZE_PL, "Rozmiar fragmentu" },
/* ru */ { IDS_FRAGMENT_SIZE_RU, "Fragment size" },
/* sv */ { IDS_FRAGMENT_SIZE_SV, "Fragmentstorlek" },
/* tr */ { IDS_FRAGMENT_SIZE_TR, "Para boyutu" },

/* en */ { IDS_SPEED_ADJUSTMENT,    "Speed Adjustment" },
/* da */ { IDS_SPEED_ADJUSTMENT_DA, "Hastighedsjustering" },
/* de */ { IDS_SPEED_ADJUSTMENT_DE, "Geschwindigkeitsanpassung" },
/* es */ { IDS_SPEED_ADJUSTMENT_ES, "Ajuste velocidad" },
/* fr */ { IDS_SPEED_ADJUSTMENT_FR, "Ajustement de vitesse" },
/* hu */ { IDS_SPEED_ADJUSTMENT_HU, "Sebessg bellts" },
/* it */ { IDS_SPEED_ADJUSTMENT_IT, "Variazione velocit" },
/* ko */ { IDS_SPEED_ADJUSTMENT_KO, "" },  /* fuzzy */
/* nl */ { IDS_SPEED_ADJUSTMENT_NL, "Snelheidsaanpassing" },
/* pl */ { IDS_SPEED_ADJUSTMENT_PL, "Regulacja prdkoci" },
/* ru */ { IDS_SPEED_ADJUSTMENT_RU, " " },
/* sv */ { IDS_SPEED_ADJUSTMENT_SV, "Hastighetsjusering" },
/* tr */ { IDS_SPEED_ADJUSTMENT_TR, "Hz Ayarlamas" },

/* en */ { IDS_SOUND_SETTINGS,    "Sound settings" },
/* da */ { IDS_SOUND_SETTINGS_DA, "Lydindstillinger" },
/* de */ { IDS_SOUND_SETTINGS_DE, "Sound Einstellungen" },
/* es */ { IDS_SOUND_SETTINGS_ES, "Ajustes de sonido" },
/* fr */ { IDS_SOUND_SETTINGS_FR, "Paramtres son" },
/* hu */ { IDS_SOUND_SETTINGS_HU, "Hang belltsai" },
/* it */ { IDS_SOUND_SETTINGS_IT, "Impostazioni audio" },
/* ko */ { IDS_SOUND_SETTINGS_KO, "Ҹ " },
/* nl */ { IDS_SOUND_SETTINGS_NL, "Geluidsinstellingen" },
/* pl */ { IDS_SOUND_SETTINGS_PL, "Ustawienia dwiku" },
/* ru */ { IDS_SOUND_SETTINGS_RU, " " },
/* sv */ { IDS_SOUND_SETTINGS_SV, "Ljudinstllningar" },
/* tr */ { IDS_SOUND_SETTINGS_TR, "Ses ayarlar" },

/* en */ { IDS_VIC20_SETTINGS,    "VIC20 settings" },
/* da */ { IDS_VIC20_SETTINGS_DA, "VIC20-indstillinger" },
/* de */ { IDS_VIC20_SETTINGS_DE, "VIC20 Einstellungen" },
/* es */ { IDS_VIC20_SETTINGS_ES, "Ajustes VIC20" },
/* fr */ { IDS_VIC20_SETTINGS_FR, "Paramtres VIC20" },
/* hu */ { IDS_VIC20_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_VIC20_SETTINGS_IT, "Impostazioni VIC20" },
/* ko */ { IDS_VIC20_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_VIC20_SETTINGS_NL, "VIC20 instellingen" },
/* pl */ { IDS_VIC20_SETTINGS_PL, "Ustawienia VIC20" },
/* ru */ { IDS_VIC20_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_VIC20_SETTINGS_SV, "VIC20-instllningar" },
/* tr */ { IDS_VIC20_SETTINGS_TR, "VIC20 ayarlar" },

/* en */ { IDS_SPRITE_SPRITE_COL,    "Sprite-sprite collisions" },
/* da */ { IDS_SPRITE_SPRITE_COL_DA, "Sprite-til-sprite-kollision" },
/* de */ { IDS_SPRITE_SPRITE_COL_DE, "Sprite-sprite Kollisionen" },
/* es */ { IDS_SPRITE_SPRITE_COL_ES, "Colisiones sprite-sprite" },
/* fr */ { IDS_SPRITE_SPRITE_COL_FR, "Collisions sprite-sprite" },
/* hu */ { IDS_SPRITE_SPRITE_COL_HU, "" },  /* fuzzy */
/* it */ { IDS_SPRITE_SPRITE_COL_IT, "Collisioni sprite-sprite" },
/* ko */ { IDS_SPRITE_SPRITE_COL_KO, "Ʈ-Ʈ 浹" },
/* nl */ { IDS_SPRITE_SPRITE_COL_NL, "Sprite-sprite botsingen" },
/* pl */ { IDS_SPRITE_SPRITE_COL_PL, "Kolizje duszkw" },
/* ru */ { IDS_SPRITE_SPRITE_COL_RU, "Sprite-sprite collisions" },
/* sv */ { IDS_SPRITE_SPRITE_COL_SV, "Sprite-till-sprite-kollision" },
/* tr */ { IDS_SPRITE_SPRITE_COL_TR, "Yartk-yaratk arpmalar" },

/* en */ { IDS_SPRITE_BACKGROUND_COL,    "Sprite-background collisions" },
/* da */ { IDS_SPRITE_BACKGROUND_COL_DA, "Sprite-til-baggrunds-kollision" },
/* de */ { IDS_SPRITE_BACKGROUND_COL_DE, "Sprite-Hintergrund Kollisionen" },
/* es */ { IDS_SPRITE_BACKGROUND_COL_ES, "Colisiones sprite-fondo" },
/* fr */ { IDS_SPRITE_BACKGROUND_COL_FR, "Collisions sprite-arrire-plan" },
/* hu */ { IDS_SPRITE_BACKGROUND_COL_HU, "" },  /* fuzzy */
/* it */ { IDS_SPRITE_BACKGROUND_COL_IT, "Collisioni sprite-sfondo" },
/* ko */ { IDS_SPRITE_BACKGROUND_COL_KO, "Ʈ- 浹" },
/* nl */ { IDS_SPRITE_BACKGROUND_COL_NL, "Sprite-achtergrond botsingen" },
/* pl */ { IDS_SPRITE_BACKGROUND_COL_PL, "Kolizje duszkw z tem" },
/* ru */ { IDS_SPRITE_BACKGROUND_COL_RU, "Sprite-background collisions" },
/* sv */ { IDS_SPRITE_BACKGROUND_COL_SV, "Sprite-till-bakgrund-kollision" },
/* tr */ { IDS_SPRITE_BACKGROUND_COL_TR, "Yaratk-arkaplan arpmalar" },

/* en */ { IDS_NEW_LUMINANCES,    "New luminances" },
/* da */ { IDS_NEW_LUMINANCES_DA, "Nye lysstyrker" },
/* de */ { IDS_NEW_LUMINANCES_DE, "Neue Helligkeitsemulation" },
/* es */ { IDS_NEW_LUMINANCES_ES, "Nuevas luminancias" },
/* fr */ { IDS_NEW_LUMINANCES_FR, "Nouvelles luminescences" },
/* hu */ { IDS_NEW_LUMINANCES_HU, "" },  /* fuzzy */
/* it */ { IDS_NEW_LUMINANCES_IT, "Nuove luminanze" },
/* ko */ { IDS_NEW_LUMINANCES_KO, "ο " },
/* nl */ { IDS_NEW_LUMINANCES_NL, "Nieuwe kleuren" },
/* pl */ { IDS_NEW_LUMINANCES_PL, "Nowy typ jaskrawoci" },
/* ru */ { IDS_NEW_LUMINANCES_RU, "New luminances" },
/* sv */ { IDS_NEW_LUMINANCES_SV, "Nya ljusstyrkor" },
/* tr */ { IDS_NEW_LUMINANCES_TR, "Yeni parlaklklar" },

/* en */ { IDS_VICII_SETTINGS,    "VIC-II settings" },
/* da */ { IDS_VICII_SETTINGS_DA, "VIC-II-indstillinger" },
/* de */ { IDS_VICII_SETTINGS_DE, "VIC-II Einstellungen" },
/* es */ { IDS_VICII_SETTINGS_ES, "Ajustes VIC-II" },
/* fr */ { IDS_VICII_SETTINGS_FR, "Paramtres VIC-II" },
/* hu */ { IDS_VICII_SETTINGS_HU, "VIC-II belltsai" },
/* it */ { IDS_VICII_SETTINGS_IT, "Impostazioni VIC-II" },
/* ko */ { IDS_VICII_SETTINGS_KO, "VIC-II " },
/* nl */ { IDS_VICII_SETTINGS_NL, "VIC-II instellingen" },
/* pl */ { IDS_VICII_SETTINGS_PL, "Ustawienia VIC-II" },
/* ru */ { IDS_VICII_SETTINGS_RU, " VIC-II" },
/* sv */ { IDS_VICII_SETTINGS_SV, "VIC-II-instllningar" },
/* tr */ { IDS_VICII_SETTINGS_TR, "VIC-II ayarlar" },

/* en */ { IDS_VIC_SETTINGS,    "VIC settings" },
/* da */ { IDS_VIC_SETTINGS_DA, "VIC-indstillinger" },
/* de */ { IDS_VIC_SETTINGS_DE, "VIC Einstellungen" },
/* es */ { IDS_VIC_SETTINGS_ES, "Ajustes VIC" },
/* fr */ { IDS_VIC_SETTINGS_FR, "Paramtres VIC" },
/* hu */ { IDS_VIC_SETTINGS_HU, "VIC belltsai" },
/* it */ { IDS_VIC_SETTINGS_IT, "Impostazioni VIC" },
/* ko */ { IDS_VIC_SETTINGS_KO, "VIC " },
/* nl */ { IDS_VIC_SETTINGS_NL, "VIC instellingen" },
/* pl */ { IDS_VIC_SETTINGS_PL, "Ustawienia VIC" },
/* ru */ { IDS_VIC_SETTINGS_RU, "VIC settings" },
/* sv */ { IDS_VIC_SETTINGS_SV, "VIC-instllningar" },
/* tr */ { IDS_VIC_SETTINGS_TR, "VIC ayarlar" },

/* en */ { IDS_TED_SETTINGS,    "TED settings" },
/* da */ { IDS_TED_SETTINGS_DA, "TED-indstillinger" },
/* de */ { IDS_TED_SETTINGS_DE, "TED Einstellungen" },
/* es */ { IDS_TED_SETTINGS_ES, "Ajustes TED" },
/* fr */ { IDS_TED_SETTINGS_FR, "Paramtres TED" },
/* hu */ { IDS_TED_SETTINGS_HU, "TED belltsai" },
/* it */ { IDS_TED_SETTINGS_IT, "Impostazioni TED" },
/* ko */ { IDS_TED_SETTINGS_KO, "TED " },
/* nl */ { IDS_TED_SETTINGS_NL, "TED instellingen" },
/* pl */ { IDS_TED_SETTINGS_PL, "Ustawienia TED" },
/* ru */ { IDS_TED_SETTINGS_RU, " TED" },
/* sv */ { IDS_TED_SETTINGS_SV, "TED-instllningar" },
/* tr */ { IDS_TED_SETTINGS_TR, "TED ayarlar" },

/* en */ { IDS_ATTACH_TAPE_IMAGE,    "Attach tape image" },
/* da */ { IDS_ATTACH_TAPE_IMAGE_DA, "Tilslut bnd-image" },
/* de */ { IDS_ATTACH_TAPE_IMAGE_DE, "Band Image einlegen" },
/* es */ { IDS_ATTACH_TAPE_IMAGE_ES, "Insertar imagen de cinta" },
/* fr */ { IDS_ATTACH_TAPE_IMAGE_FR, "Insrer une image de datassette" },
/* hu */ { IDS_ATTACH_TAPE_IMAGE_HU, "Szalag kpms csatolsa" },
/* it */ { IDS_ATTACH_TAPE_IMAGE_IT, "Seleziona immagine cassetta" },
/* ko */ { IDS_ATTACH_TAPE_IMAGE_KO, " ̹ ٿֱ" },
/* nl */ { IDS_ATTACH_TAPE_IMAGE_NL, "Koppel tapebestand aan" },
/* pl */ { IDS_ATTACH_TAPE_IMAGE_PL, "Zamontuj obraz tamy" },
/* ru */ { IDS_ATTACH_TAPE_IMAGE_RU, "  " },
/* sv */ { IDS_ATTACH_TAPE_IMAGE_SV, "Anslut bandavbildningsfil" },
/* tr */ { IDS_ATTACH_TAPE_IMAGE_TR, "Teyp imajn yerletir" },

/* en */ { IDS_AUTOSTART_IMAGE,    "Autostart disk/tape image" },
/* da */ { IDS_AUTOSTART_IMAGE_DA, "Autostart disk-/bnd-image" },
/* de */ { IDS_AUTOSTART_IMAGE_DE, "Autostart von Disk/Band Image" },
/* es */ { IDS_AUTOSTART_IMAGE_ES, "Autoarranque imagen de disco/cinta" },
/* fr */ { IDS_AUTOSTART_IMAGE_FR, "Autodmarrage image disque/datassette" },
/* hu */ { IDS_AUTOSTART_IMAGE_HU, "Lemez/szalag kpms automatikus indtsa" },
/* it */ { IDS_AUTOSTART_IMAGE_IT, "Avvia automaticamente immagine disco/cassetta" },
/* ko */ { IDS_AUTOSTART_IMAGE_KO, "ڵ  ũ/ ̹" },
/* nl */ { IDS_AUTOSTART_IMAGE_NL, "Autostart disk-/tapebestand" },
/* pl */ { IDS_AUTOSTART_IMAGE_PL, "Automatycznie startuj z obrazu dysku lub tamy" },
/* ru */ { IDS_AUTOSTART_IMAGE_RU, "   /" },
/* sv */ { IDS_AUTOSTART_IMAGE_SV, "Autostarta disk-/bandavbildningsfil" },
/* tr */ { IDS_AUTOSTART_IMAGE_TR, "Disk/Teyp imajn otomatik balat" },

/* en */ { IDS_IDE64_FILENAME,    "HD image file" },
/* da */ { IDS_IDE64_FILENAME_DA, "HD-imagefil" },
/* de */ { IDS_IDE64_FILENAME_DE, "HD Image Name" },
/* es */ { IDS_IDE64_FILENAME_ES, "Fichero imagen HD" },
/* fr */ { IDS_IDE64_FILENAME_FR, "Nom d'image HD" },
/* hu */ { IDS_IDE64_FILENAME_HU, "Merevlemez kpms fjl" },
/* it */ { IDS_IDE64_FILENAME_IT, "File immagine HD" },
/* ko */ { IDS_IDE64_FILENAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_IDE64_FILENAME_NL, "HD bestand" },
/* pl */ { IDS_IDE64_FILENAME_PL, "Plik obrazu HD" },
/* ru */ { IDS_IDE64_FILENAME_RU, "" },  /* fuzzy */
/* sv */ { IDS_IDE64_FILENAME_SV, "HD-avbildningsfil" },
/* tr */ { IDS_IDE64_FILENAME_TR, "HD imaj dosyas" },

/* en */ { IDS_IDE64_FILENAME_SELECT,    "Select HD image file" },
/* da */ { IDS_IDE64_FILENAME_SELECT_DA, "Angiv HD-imagefil" },
/* de */ { IDS_IDE64_FILENAME_SELECT_DE, "HD Image Datei auswhlen" },
/* es */ { IDS_IDE64_FILENAME_SELECT_ES, "Seleccionar fichero imagen HD" },
/* fr */ { IDS_IDE64_FILENAME_SELECT_FR, "Slectionnez le fichier image du D.D." },
/* hu */ { IDS_IDE64_FILENAME_SELECT_HU, "Vlassza ki a merevlemez kpms fjlt" },
/* it */ { IDS_IDE64_FILENAME_SELECT_IT, "Seleziona il file immagine HD" },
/* ko */ { IDS_IDE64_FILENAME_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_IDE64_FILENAME_SELECT_NL, "Selecteer HD bestand" },
/* pl */ { IDS_IDE64_FILENAME_SELECT_PL, "Wybierz plik obrazu HD" },
/* ru */ { IDS_IDE64_FILENAME_SELECT_RU, "Select HD image file" },
/* sv */ { IDS_IDE64_FILENAME_SELECT_SV, "Ange HD-avbildningsfil" },
/* tr */ { IDS_IDE64_FILENAME_SELECT_TR, "HD imaj dosyas se" },

/* en */ { IDS_IDE64_HD_1_SETTINGS,    "IDE64 primary master device settings" },
/* da */ { IDS_IDE64_HD_1_SETTINGS_DA, "IDE64 primr master enhedsindstillinger" },
/* de */ { IDS_IDE64_HD_1_SETTINGS_DE, "IDE64 Primr Master Gerte Einstellungen" },
/* es */ { IDS_IDE64_HD_1_SETTINGS_ES, "Ajustes perifrico maestro primario IDE64" },
/* fr */ { IDS_IDE64_HD_1_SETTINGS_FR, "Paramtres priphrique matre primaire IDE64" },
/* hu */ { IDS_IDE64_HD_1_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_IDE64_HD_1_SETTINGS_IT, "Impostazioni dispositivo IDE64 master sul canale primario" },
/* ko */ { IDS_IDE64_HD_1_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_IDE64_HD_1_SETTINGS_NL, "IDE64 primair hoofd apparaat instellingen" },
/* pl */ { IDS_IDE64_HD_1_SETTINGS_PL, "Ustawienia pierwszego urzdzenia master IDE64" },
/* ru */ { IDS_IDE64_HD_1_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_IDE64_HD_1_SETTINGS_SV, "Instllningar fr primr IDE64-masterenhet" },
/* tr */ { IDS_IDE64_HD_1_SETTINGS_TR, "IDE64 birincil ana src ayarlar" },

/* en */ { IDS_IDE64_HD_2_SETTINGS,    "IDE64 primary slave device settings" },
/* da */ { IDS_IDE64_HD_2_SETTINGS_DA, "IDE64 primr slave enhedsindstillinger" },
/* de */ { IDS_IDE64_HD_2_SETTINGS_DE, "IDE64 Primr Slave Gerte Einstellungen" },
/* es */ { IDS_IDE64_HD_2_SETTINGS_ES, "Ajustes perifrico esclavo primario IDE64" },
/* fr */ { IDS_IDE64_HD_2_SETTINGS_FR, "Paramtres priphrique esclave primaire IDE64" },
/* hu */ { IDS_IDE64_HD_2_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_IDE64_HD_2_SETTINGS_IT, "Impostazioni dispositivo IDE64 slave sul canale primario" },
/* ko */ { IDS_IDE64_HD_2_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_IDE64_HD_2_SETTINGS_NL, "IDE64 HD primair slaaf apparaat instellingen" },
/* pl */ { IDS_IDE64_HD_2_SETTINGS_PL, "Ustawienia pierwszego urzdzenia slave IDE64" },
/* ru */ { IDS_IDE64_HD_2_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_IDE64_HD_2_SETTINGS_SV, "Instllningar fr primr IDE64-slavenhet" },
/* tr */ { IDS_IDE64_HD_2_SETTINGS_TR, "IDE64 birincil baml src ayarlar" },

/* en */ { IDS_IDE64_HD_3_SETTINGS,    "IDE64 secondary master device settings" },
/* da */ { IDS_IDE64_HD_3_SETTINGS_DA, "IDE64 sekundr master enhedsindstillinger" },
/* de */ { IDS_IDE64_HD_3_SETTINGS_DE, "IDE64 Sekundr Master Gerte Einstellungen" },
/* es */ { IDS_IDE64_HD_3_SETTINGS_ES, "Ajustes perifrico maestro secundario IDE64" },
/* fr */ { IDS_IDE64_HD_3_SETTINGS_FR, "Paramtres priphrique matre secondaire IDE64" },
/* hu */ { IDS_IDE64_HD_3_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_IDE64_HD_3_SETTINGS_IT, "Impostazioni dispositivo IDE64 slave sul canale secondario" },
/* ko */ { IDS_IDE64_HD_3_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_IDE64_HD_3_SETTINGS_NL, "IDE64 secondair hoofd apparaat instellingen" },
/* pl */ { IDS_IDE64_HD_3_SETTINGS_PL, "Ustawienia drugiego urzdzenia master IDE64" },
/* ru */ { IDS_IDE64_HD_3_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_IDE64_HD_3_SETTINGS_SV, "Instllningar fr sekundr IDE64-masterenhet" },
/* tr */ { IDS_IDE64_HD_3_SETTINGS_TR, "IDE64 ikincil ana src ayarlar" },

/* en */ { IDS_IDE64_HD_4_SETTINGS,    "IDE64 secondary slave device settings" },
/* da */ { IDS_IDE64_HD_4_SETTINGS_DA, "IDE64 sekundr slave enhedsindstillinger" },
/* de */ { IDS_IDE64_HD_4_SETTINGS_DE, "IDE64 Sekundr Slave Gerte Einstellungen" },
/* es */ { IDS_IDE64_HD_4_SETTINGS_ES, "Ajustes perifrico esclavo secundario IDE64" },
/* fr */ { IDS_IDE64_HD_4_SETTINGS_FR, "Paramtres esclave secondaire IDE64" },
/* hu */ { IDS_IDE64_HD_4_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_IDE64_HD_4_SETTINGS_IT, "Impostazioni dispositivo IDE64 master sul canale secondario" },
/* ko */ { IDS_IDE64_HD_4_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_IDE64_HD_4_SETTINGS_NL, "IDE64 secondair slaaf apparaat instellingen" },
/* pl */ { IDS_IDE64_HD_4_SETTINGS_PL, "Ustawienia drugiego urzdzenia slave IDE64" },
/* ru */ { IDS_IDE64_HD_4_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_IDE64_HD_4_SETTINGS_SV, "Instllningar fr sekundr IDE64-slavenhet" },
/* tr */ { IDS_IDE64_HD_4_SETTINGS_TR, "IDE64 ikincil baml src ayarlar" },

/* en */ { IDS_IDE64_VERSION,    "IDE64 version" },
/* da */ { IDS_IDE64_VERSION_DA, "" },  /* fuzzy */
/* de */ { IDS_IDE64_VERSION_DE, "IDE64 Version" },
/* es */ { IDS_IDE64_VERSION_ES, "" },  /* fuzzy */
/* fr */ { IDS_IDE64_VERSION_FR, "" },  /* fuzzy */
/* hu */ { IDS_IDE64_VERSION_HU, "" },  /* fuzzy */
/* it */ { IDS_IDE64_VERSION_IT, "" },  /* fuzzy */
/* ko */ { IDS_IDE64_VERSION_KO, "" },  /* fuzzy */
/* nl */ { IDS_IDE64_VERSION_NL, "IDE64 versie" },
/* pl */ { IDS_IDE64_VERSION_PL, "Wersja IDE64" },
/* ru */ { IDS_IDE64_VERSION_RU, "" },  /* fuzzy */
/* sv */ { IDS_IDE64_VERSION_SV, "" },  /* fuzzy */
/* tr */ { IDS_IDE64_VERSION_TR, "" },  /* fuzzy */

/* en */ { IDS_USB_SERVER,    "USB Server" },
/* da */ { IDS_USB_SERVER_DA, "" },  /* fuzzy */
/* de */ { IDS_USB_SERVER_DE, "USB Server" },
/* es */ { IDS_USB_SERVER_ES, "Servidor USB" },
/* fr */ { IDS_USB_SERVER_FR, "" },  /* fuzzy */
/* hu */ { IDS_USB_SERVER_HU, "" },  /* fuzzy */
/* it */ { IDS_USB_SERVER_IT, "Server USB" },
/* ko */ { IDS_USB_SERVER_KO, "" },  /* fuzzy */
/* nl */ { IDS_USB_SERVER_NL, "USB Server" },
/* pl */ { IDS_USB_SERVER_PL, "Serwer USB" },
/* ru */ { IDS_USB_SERVER_RU, "" },  /* fuzzy */
/* sv */ { IDS_USB_SERVER_SV, "" },  /* fuzzy */
/* tr */ { IDS_USB_SERVER_TR, "" },  /* fuzzy */

/* en */ { IDS_USB_SERVER_ADDRESS,    "USB Server address to bind to" },
/* da */ { IDS_USB_SERVER_ADDRESS_DA, "" },  /* fuzzy */
/* de */ { IDS_USB_SERVER_ADDRESS_DE, "USB Server Adresse" },
/* es */ { IDS_USB_SERVER_ADDRESS_ES, "Seleccionar direccin servidorUSB" },
/* fr */ { IDS_USB_SERVER_ADDRESS_FR, "" },  /* fuzzy */
/* hu */ { IDS_USB_SERVER_ADDRESS_HU, "" },  /* fuzzy */
/* it */ { IDS_USB_SERVER_ADDRESS_IT, "Indirizzo server USB a cui collegarsi" },
/* ko */ { IDS_USB_SERVER_ADDRESS_KO, "" },  /* fuzzy */
/* nl */ { IDS_USB_SERVER_ADDRESS_NL, "USB server adres waaraan gebonden moet worden" },
/* pl */ { IDS_USB_SERVER_ADDRESS_PL, "Wprowad adres serwera USB" },
/* ru */ { IDS_USB_SERVER_ADDRESS_RU, "" },  /* fuzzy */
/* sv */ { IDS_USB_SERVER_ADDRESS_SV, "" },  /* fuzzy */
/* tr */ { IDS_USB_SERVER_ADDRESS_TR, "" },  /* fuzzy */

/* en */ { IDS_IDE64_RTC_SAVE,    "Enable saving of the IDE64 RTC data" },
/* da */ { IDS_IDE64_RTC_SAVE_DA, "" },  /* fuzzy */
/* de */ { IDS_IDE64_RTC_SAVE_DE, "IDE64 RTC Datenspeicherung aktivieren" },
/* es */ { IDS_IDE64_RTC_SAVE_ES, "Permitir grabar datos de IDE64 RTC" },
/* fr */ { IDS_IDE64_RTC_SAVE_FR, "" },  /* fuzzy */
/* hu */ { IDS_IDE64_RTC_SAVE_HU, "" },  /* fuzzy */
/* it */ { IDS_IDE64_RTC_SAVE_IT, "Attiva salvataggio dei dati RTC dell'IDE64" },
/* ko */ { IDS_IDE64_RTC_SAVE_KO, "" },  /* fuzzy */
/* nl */ { IDS_IDE64_RTC_SAVE_NL, "Activeer opslaan van de IDE64 RTC data" },
/* pl */ { IDS_IDE64_RTC_SAVE_PL, "Wcz zapis zegara IDE64" },
/* ru */ { IDS_IDE64_RTC_SAVE_RU, "" },  /* fuzzy */
/* sv */ { IDS_IDE64_RTC_SAVE_SV, "" },  /* fuzzy */
/* tr */ { IDS_IDE64_RTC_SAVE_TR, "" },  /* fuzzy */

/* en */ { IDS_AUTODETECT,    "Autodetect image size" },
/* da */ { IDS_AUTODETECT_DA, "Autodetektr strrelse p image" },
/* de */ { IDS_AUTODETECT_DE, "Image Gre automatisch erkennen" },
/* es */ { IDS_AUTODETECT_ES, "Autodeteccin del tamao de la imagen" },
/* fr */ { IDS_AUTODETECT_FR, "Autodtection de la taille de l'image" },
/* hu */ { IDS_AUTODETECT_HU, "" },  /* fuzzy */
/* it */ { IDS_AUTODETECT_IT, "Rileva automaticamente immagine" },
/* ko */ { IDS_AUTODETECT_KO, "̹ ũ ڵ ã" },
/* nl */ { IDS_AUTODETECT_NL, "Automatisch detecteren bestandsgrootte" },
/* pl */ { IDS_AUTODETECT_PL, "Automatycznie wykrywaj rozmiar obrazu" },
/* ru */ { IDS_AUTODETECT_RU, "   " },
/* sv */ { IDS_AUTODETECT_SV, "Autodetektera storlek p avbildning" },
/* tr */ { IDS_AUTODETECT_TR, "Imaj boyutunu otomatik algla" },

/* en */ { IDS_CYLINDERS,    "Cylinders" },
/* da */ { IDS_CYLINDERS_DA, "Cylindrer" },
/* de */ { IDS_CYLINDERS_DE, "Zylinder" },
/* es */ { IDS_CYLINDERS_ES, "Cilindros" },
/* fr */ { IDS_CYLINDERS_FR, "Cylindres" },
/* hu */ { IDS_CYLINDERS_HU, "Svok" },
/* it */ { IDS_CYLINDERS_IT, "Cilindri" },
/* ko */ { IDS_CYLINDERS_KO, "Ǹ" },
/* nl */ { IDS_CYLINDERS_NL, "Cylinders" },
/* pl */ { IDS_CYLINDERS_PL, "Cylindry" },
/* ru */ { IDS_CYLINDERS_RU, "Cylinders" },
/* sv */ { IDS_CYLINDERS_SV, "Cylindrar" },
/* tr */ { IDS_CYLINDERS_TR, "Silindirler" },

/* en */ { IDS_HEADS,    "Heads" },
/* da */ { IDS_HEADS_DA, "Hoveder" },
/* de */ { IDS_HEADS_DE, "Kpfe" },
/* es */ { IDS_HEADS_ES, "Cabezas" },
/* fr */ { IDS_HEADS_FR, "Ttes" },
/* hu */ { IDS_HEADS_HU, "Fejek" },
/* it */ { IDS_HEADS_IT, "Testine" },
/* ko */ { IDS_HEADS_KO, "" },
/* nl */ { IDS_HEADS_NL, "Koppen" },
/* pl */ { IDS_HEADS_PL, "Gowice" },
/* ru */ { IDS_HEADS_RU, "Heads" },
/* sv */ { IDS_HEADS_SV, "Huvuden" },
/* tr */ { IDS_HEADS_TR, "Kafalar" },

/* en */ { IDS_SECTORS,    "Sectors" },
/* da */ { IDS_SECTORS_DA, "Sektorer" },
/* de */ { IDS_SECTORS_DE, "Sektoren" },
/* es */ { IDS_SECTORS_ES, "Sectores" },
/* fr */ { IDS_SECTORS_FR, "Secteurs" },
/* hu */ { IDS_SECTORS_HU, "Szektorok" },
/* it */ { IDS_SECTORS_IT, "Settori" },
/* ko */ { IDS_SECTORS_KO, "" },
/* nl */ { IDS_SECTORS_NL, "Sectors" },
/* pl */ { IDS_SECTORS_PL, "Sektory" },
/* ru */ { IDS_SECTORS_RU, "Sectors" },
/* sv */ { IDS_SECTORS_SV, "Sektorer" },
/* tr */ { IDS_SECTORS_TR, "Sektrler" },

/* en */ { IDS_IDE64_SETTINGS,    "IDE64 settings" },
/* da */ { IDS_IDE64_SETTINGS_DA, "IDE64-indstillinger" },
/* de */ { IDS_IDE64_SETTINGS_DE, "IDE64 Einstellungen" },
/* es */ { IDS_IDE64_SETTINGS_ES, "Ajustes IDE64" },
/* fr */ { IDS_IDE64_SETTINGS_FR, "Paramtres IDE64" },
/* hu */ { IDS_IDE64_SETTINGS_HU, "IDE64 belltsai" },
/* it */ { IDS_IDE64_SETTINGS_IT, "Impostazioni IDE64" },
/* ko */ { IDS_IDE64_SETTINGS_KO, "IDE64 " },
/* nl */ { IDS_IDE64_SETTINGS_NL, "IDE64 instellingen" },
/* pl */ { IDS_IDE64_SETTINGS_PL, "Ustawienia IDE64" },
/* ru */ { IDS_IDE64_SETTINGS_RU, "IDE64 settings" },
/* sv */ { IDS_IDE64_SETTINGS_SV, "IDE64-instllningar" },
/* tr */ { IDS_IDE64_SETTINGS_TR, "IDE64 ayarlar" },

/* en */ { IDS_BIOS_REVISION,    "BIOS Revision" },
/* da */ { IDS_BIOS_REVISION_DA, "BIOS-revision" },
/* de */ { IDS_BIOS_REVISION_DE, "BIOS Revision" },
/* es */ { IDS_BIOS_REVISION_ES, "Revisin BIOS" },
/* fr */ { IDS_BIOS_REVISION_FR, "Rvision BIOS" },
/* hu */ { IDS_BIOS_REVISION_HU, "BIOS vltozat" },
/* it */ { IDS_BIOS_REVISION_IT, "Revisione BIOS" },
/* ko */ { IDS_BIOS_REVISION_KO, "" },  /* fuzzy */
/* nl */ { IDS_BIOS_REVISION_NL, "BIOS revisie" },
/* pl */ { IDS_BIOS_REVISION_PL, "Wersja BIOS" },
/* ru */ { IDS_BIOS_REVISION_RU, "BIOS Revision" },
/* sv */ { IDS_BIOS_REVISION_SV, "BIOS-utgva" },
/* tr */ { IDS_BIOS_REVISION_TR, "BIOS Revizyonu" },

/* en */ { IDS_BIOS_FLASH_JUMPER,    "BIOS Flash Jumper" },
/* da */ { IDS_BIOS_FLASH_JUMPER_DA, "BIOS-flashjumper" },
/* de */ { IDS_BIOS_FLASH_JUMPER_DE, "BIOS Flashjumper" },
/* es */ { IDS_BIOS_FLASH_JUMPER_ES, "BIOS Flash Jumper" },
/* fr */ { IDS_BIOS_FLASH_JUMPER_FR, "Flash Jumper BIOS" },
/* hu */ { IDS_BIOS_FLASH_JUMPER_HU, "BIOS Flash jumper" },
/* it */ { IDS_BIOS_FLASH_JUMPER_IT, "Flash Jumper del BIOS" },
/* ko */ { IDS_BIOS_FLASH_JUMPER_KO, "" },  /* fuzzy */
/* nl */ { IDS_BIOS_FLASH_JUMPER_NL, "BIOS Flash Jumper" },
/* pl */ { IDS_BIOS_FLASH_JUMPER_PL, "Zworka BIOS Flash" },
/* ru */ { IDS_BIOS_FLASH_JUMPER_RU, "BIOS Flash Jumper" },
/* sv */ { IDS_BIOS_FLASH_JUMPER_SV, "BIOS-flashbygel" },
/* tr */ { IDS_BIOS_FLASH_JUMPER_TR, "BIOS Flash Jumper" },

/* en */ { IDS_BIOS_FLASH_JUMPER,    "BIOS Flash Jumper" },
/* da */ { IDS_BIOS_FLASH_JUMPER_DA, "BIOS-flashjumper" },
/* de */ { IDS_BIOS_FLASH_JUMPER_DE, "BIOS Flashjumper" },
/* es */ { IDS_BIOS_FLASH_JUMPER_ES, "BIOS Flash Jumper" },
/* fr */ { IDS_BIOS_FLASH_JUMPER_FR, "Flash Jumper BIOS" },
/* hu */ { IDS_BIOS_FLASH_JUMPER_HU, "BIOS Flash jumper" },
/* it */ { IDS_BIOS_FLASH_JUMPER_IT, "Flash Jumper del BIOS" },
/* ko */ { IDS_BIOS_FLASH_JUMPER_KO, "" },  /* fuzzy */
/* nl */ { IDS_BIOS_FLASH_JUMPER_NL, "BIOS Flash Jumper" },
/* pl */ { IDS_BIOS_FLASH_JUMPER_PL, "Zworka BIOS Flash" },
/* ru */ { IDS_BIOS_FLASH_JUMPER_RU, "BIOS Flash Jumper" },
/* sv */ { IDS_BIOS_FLASH_JUMPER_SV, "BIOS-flashbygel" },
/* tr */ { IDS_BIOS_FLASH_JUMPER_TR, "BIOS Flash Jumper" },

/* en */ { IDS_BANK_JUMPER,    "Bank jumper" },
/* da */ { IDS_BANK_JUMPER_DA, "Bank Jumper" },
/* de */ { IDS_BANK_JUMPER_DE, "Bank Jumper" },
/* es */ { IDS_BANK_JUMPER_ES, "Seleccionar conmutador banco" },
/* fr */ { IDS_BANK_JUMPER_FR, "Bank jumper" },
/* hu */ { IDS_BANK_JUMPER_HU, "" },  /* fuzzy */
/* it */ { IDS_BANK_JUMPER_IT, "Ponticello bank" },
/* ko */ { IDS_BANK_JUMPER_KO, "" },  /* fuzzy */
/* nl */ { IDS_BANK_JUMPER_NL, "Bank jumper" },
/* pl */ { IDS_BANK_JUMPER_PL, "Zworka bankw" },
/* ru */ { IDS_BANK_JUMPER_RU, "" },  /* fuzzy */
/* sv */ { IDS_BANK_JUMPER_SV, "Bankbygel" },
/* tr */ { IDS_BANK_JUMPER_TR, "Bank jumper" },

/* en */ { IDS_SAVE_BIOS_WHEN_CHANGED,    "Save BIOS when changed" },
/* da */ { IDS_SAVE_BIOS_WHEN_CHANGED_DA, "Gem BIOS ved ndringer" },
/* de */ { IDS_SAVE_BIOS_WHEN_CHANGED_DE, "BIOS bei nderung speichern" },
/* es */ { IDS_SAVE_BIOS_WHEN_CHANGED_ES, "Grabar BIOS cuando cambien" },
/* fr */ { IDS_SAVE_BIOS_WHEN_CHANGED_FR, "Enregistrer le BIOS lorsque modifi" },
/* hu */ { IDS_SAVE_BIOS_WHEN_CHANGED_HU, "BIOS mentse vltozs utn" },
/* it */ { IDS_SAVE_BIOS_WHEN_CHANGED_IT, "Salva BIOS alla modifica" },
/* ko */ { IDS_SAVE_BIOS_WHEN_CHANGED_KO, "" },  /* fuzzy */
/* nl */ { IDS_SAVE_BIOS_WHEN_CHANGED_NL, "Sla de MMC64 BIOS op als er veranderingen zijn gemaakt" },
/* pl */ { IDS_SAVE_BIOS_WHEN_CHANGED_PL, "Zapisuj BIOS przy zmianie" },
/* ru */ { IDS_SAVE_BIOS_WHEN_CHANGED_RU, "Save BIOS when changed" },
/* sv */ { IDS_SAVE_BIOS_WHEN_CHANGED_SV, "Spara BIOS vid ndring" },
/* tr */ { IDS_SAVE_BIOS_WHEN_CHANGED_TR, "BIOS deitiinde kaydet" },

/* en */ { IDS_BIOS_FILE,    "BIOS File" },
/* da */ { IDS_BIOS_FILE_DA, "BIOS-fil" },
/* de */ { IDS_BIOS_FILE_DE, "BIOS Datei" },
/* es */ { IDS_BIOS_FILE_ES, "Fichero BIOS" },
/* fr */ { IDS_BIOS_FILE_FR, "Fichier du BIOS" },
/* hu */ { IDS_BIOS_FILE_HU, "BIOS fjl" },
/* it */ { IDS_BIOS_FILE_IT, "File BIOS" },
/* ko */ { IDS_BIOS_FILE_KO, "" },  /* fuzzy */
/* nl */ { IDS_BIOS_FILE_NL, "BIOS bestand" },
/* pl */ { IDS_BIOS_FILE_PL, "Plik BIOS" },
/* ru */ { IDS_BIOS_FILE_RU, "BIOS File" },
/* sv */ { IDS_BIOS_FILE_SV, "BIOS-fil" },
/* tr */ { IDS_BIOS_FILE_TR, "BIOS Dosyas" },

/* en */ { IDS_SELECT_BIOS_FILE,    "Select BIOS file" },
/* da */ { IDS_SELECT_BIOS_FILE_DA, "Vlg BIOS-fil" },
/* de */ { IDS_SELECT_BIOS_FILE_DE, "BIOS Datei whlen" },
/* es */ { IDS_SELECT_BIOS_FILE_ES, "Seleccionar fichero BIOS" },
/* fr */ { IDS_SELECT_BIOS_FILE_FR, "Slectionner le fichier du BIOS" },
/* hu */ { IDS_SELECT_BIOS_FILE_HU, "Vlasszon BIOS fjlt" },
/* it */ { IDS_SELECT_BIOS_FILE_IT, "Seleziona file BIOS" },
/* ko */ { IDS_SELECT_BIOS_FILE_KO, "" },  /* fuzzy */
/* nl */ { IDS_SELECT_BIOS_FILE_NL, "Selecteer BIOS bestand" },
/* pl */ { IDS_SELECT_BIOS_FILE_PL, "Wybierz plik BIOS" },
/* ru */ { IDS_SELECT_BIOS_FILE_RU, "Select BIOS file" },
/* sv */ { IDS_SELECT_BIOS_FILE_SV, "Vlj BIOS-fil" },
/* tr */ { IDS_SELECT_BIOS_FILE_TR, "BIOS dosyas sein" },

/* en */ { IDS_MMC64_IMAGE_READ_ONLY,    "MMC/SD Image read-only" },
/* da */ { IDS_MMC64_IMAGE_READ_ONLY_DA, "MMC/SD-image skrivebeskyttet" },
/* de */ { IDS_MMC64_IMAGE_READ_ONLY_DE, "MMC/SD Image Schreibschutz" },
/* es */ { IDS_MMC64_IMAGE_READ_ONLY_ES, "Imagen MMC/SD de slo lectura" },
/* fr */ { IDS_MMC64_IMAGE_READ_ONLY_FR, "Image MMC/SD en lecture seule" },
/* hu */ { IDS_MMC64_IMAGE_READ_ONLY_HU, "MMC/SD kpms csak olvashat" },
/* it */ { IDS_MMC64_IMAGE_READ_ONLY_IT, "Immagine MMC/SD in sola lettura" },
/* ko */ { IDS_MMC64_IMAGE_READ_ONLY_KO, "" },  /* fuzzy */
/* nl */ { IDS_MMC64_IMAGE_READ_ONLY_NL, "MMC/SD bestand alleen-lezen" },
/* pl */ { IDS_MMC64_IMAGE_READ_ONLY_PL, "Obraz MMC/SC tylko do odczytu" },
/* ru */ { IDS_MMC64_IMAGE_READ_ONLY_RU, "MMC/SD Image read-only" },
/* sv */ { IDS_MMC64_IMAGE_READ_ONLY_SV, "MMC/SD-avbildning skrivskyddad" },
/* tr */ { IDS_MMC64_IMAGE_READ_ONLY_TR, "Salt Okunur MMC/SD Imaj" },

/* en */ { IDS_MMC64_IMAGE_FILE,    "MMC/SD Image File" },
/* da */ { IDS_MMC64_IMAGE_FILE_DA, "MMC/SD-image" },
/* de */ { IDS_MMC64_IMAGE_FILE_DE, "MMC/SD Image Name" },
/* es */ { IDS_MMC64_IMAGE_FILE_ES, "Fichero imagen MMC/SD" },
/* fr */ { IDS_MMC64_IMAGE_FILE_FR, "Nom d'image MMC/SD" },
/* hu */ { IDS_MMC64_IMAGE_FILE_HU, "MMC/SD kpms fjl" },
/* it */ { IDS_MMC64_IMAGE_FILE_IT, "File immagine MMC/SD" },
/* ko */ { IDS_MMC64_IMAGE_FILE_KO, "" },  /* fuzzy */
/* nl */ { IDS_MMC64_IMAGE_FILE_NL, "MMC/SD bestand" },
/* pl */ { IDS_MMC64_IMAGE_FILE_PL, "Plik obrazu MMC/SD" },
/* ru */ { IDS_MMC64_IMAGE_FILE_RU, "MMC/SD Image File" },
/* sv */ { IDS_MMC64_IMAGE_FILE_SV, "MMC/SD-avbildningsfil" },
/* tr */ { IDS_MMC64_IMAGE_FILE_TR, "MMC/SD Imaj Dosyas" },

/* en */ { IDS_SD_TYPE,    "Card type" },
/* da */ { IDS_SD_TYPE_DA, "Korttype" },
/* de */ { IDS_SD_TYPE_DE, "Card Typ" },
/* es */ { IDS_SD_TYPE_ES, "Tipo de tarjeta" },
/* fr */ { IDS_SD_TYPE_FR, "Type de carte" },
/* hu */ { IDS_SD_TYPE_HU, "" },  /* fuzzy */
/* it */ { IDS_SD_TYPE_IT, "Tipo card" },
/* ko */ { IDS_SD_TYPE_KO, "ī " },
/* nl */ { IDS_SD_TYPE_NL, "Card soort" },
/* pl */ { IDS_SD_TYPE_PL, "Typ karty" },
/* ru */ { IDS_SD_TYPE_RU, "" },  /* fuzzy */
/* sv */ { IDS_SD_TYPE_SV, "Korttyp" },
/* tr */ { IDS_SD_TYPE_TR, "Kart tipi" },

/* en */ { IDS_SELECT_MMC64_IMAGE_FILE,    "Select MMC/SD image file" },
/* da */ { IDS_SELECT_MMC64_IMAGE_FILE_DA, "Vlg MMC/SD-image" },
/* de */ { IDS_SELECT_MMC64_IMAGE_FILE_DE, "MMC/SD Image Date whlen" },
/* es */ { IDS_SELECT_MMC64_IMAGE_FILE_ES, "Seleccionar fichero imagen MMC/SD" },
/* fr */ { IDS_SELECT_MMC64_IMAGE_FILE_FR, "Slectionnez le fichier image du MMC/SD" },
/* hu */ { IDS_SELECT_MMC64_IMAGE_FILE_HU, "Vlassza ki az MMC/SD kpms fjlt" },
/* it */ { IDS_SELECT_MMC64_IMAGE_FILE_IT, "Seleziona file immagine MMC/SD" },
/* ko */ { IDS_SELECT_MMC64_IMAGE_FILE_KO, "" },  /* fuzzy */
/* nl */ { IDS_SELECT_MMC64_IMAGE_FILE_NL, "Selecteer MMC/SD bestand" },
/* pl */ { IDS_SELECT_MMC64_IMAGE_FILE_PL, "Wybierz plik obrazu MMC/SD" },
/* ru */ { IDS_SELECT_MMC64_IMAGE_FILE_RU, "Select MMC/SD image file" },
/* sv */ { IDS_SELECT_MMC64_IMAGE_FILE_SV, "Ange MMC/SD-avbildningsfil" },
/* tr */ { IDS_SELECT_MMC64_IMAGE_FILE_TR, "MMC/SD imaj dosyas sein" },

/* en */ { IDS_MMC64_SETTINGS,    "MMC64 settings" },
/* da */ { IDS_MMC64_SETTINGS_DA, "MMC64-indstillinger" },
/* de */ { IDS_MMC64_SETTINGS_DE, "MMC64 Einstellungen" },
/* es */ { IDS_MMC64_SETTINGS_ES, "Ajustes MMC64" },
/* fr */ { IDS_MMC64_SETTINGS_FR, "Paramtres MMC64..." },
/* hu */ { IDS_MMC64_SETTINGS_HU, "MMC64 belltsai" },
/* it */ { IDS_MMC64_SETTINGS_IT, "Impostazioni MMC64" },
/* ko */ { IDS_MMC64_SETTINGS_KO, "MMC64 " },
/* nl */ { IDS_MMC64_SETTINGS_NL, "MMC64 instellingen" },
/* pl */ { IDS_MMC64_SETTINGS_PL, "Ustawienia MMC64" },
/* ru */ { IDS_MMC64_SETTINGS_RU, "MMC64 settings" },
/* sv */ { IDS_MMC64_SETTINGS_SV, "MMC64-instllningar..." },
/* tr */ { IDS_MMC64_SETTINGS_TR, "MMC64 ayarlar" },

/* en */ { IDS_SELECT_EEPROM_FILE,    "Select EEPROM file" },
/* da */ { IDS_SELECT_EEPROM_FILE_DA, "Vlg EEPROM-fil" },
/* de */ { IDS_SELECT_EEPROM_FILE_DE, "EEPROM Datei whlen" },
/* es */ { IDS_SELECT_EEPROM_FILE_ES, "Seleccionar fichero EEPROM" },
/* fr */ { IDS_SELECT_EEPROM_FILE_FR, "Slectionner le fichier EEPROM" },
/* hu */ { IDS_SELECT_EEPROM_FILE_HU, "" },  /* fuzzy */
/* it */ { IDS_SELECT_EEPROM_FILE_IT, "Seleziona file EEPROM" },
/* ko */ { IDS_SELECT_EEPROM_FILE_KO, "" },  /* fuzzy */
/* nl */ { IDS_SELECT_EEPROM_FILE_NL, "Selecteer EEPROM bestand" },
/* pl */ { IDS_SELECT_EEPROM_FILE_PL, "Wybierz plik EEPROM" },
/* ru */ { IDS_SELECT_EEPROM_FILE_RU, "Select EEPROM file" },
/* sv */ { IDS_SELECT_EEPROM_FILE_SV, "Vlj EEPROM-fil" },
/* tr */ { IDS_SELECT_EEPROM_FILE_TR, "EEPROM dosyas sein" },

/* en */ { IDS_SELECT_CARD_IMAGE_FILE,    "Select card image file" },
/* da */ { IDS_SELECT_CARD_IMAGE_FILE_DA, "Angiv kortimagefil" },
/* de */ { IDS_SELECT_CARD_IMAGE_FILE_DE, "Card Image Datei auswhlen" },
/* es */ { IDS_SELECT_CARD_IMAGE_FILE_ES, "Seleccionar fichero imagen tarjeta" },
/* fr */ { IDS_SELECT_CARD_IMAGE_FILE_FR, "Slectionnez le fichier image carte" },
/* hu */ { IDS_SELECT_CARD_IMAGE_FILE_HU, "" },  /* fuzzy */
/* it */ { IDS_SELECT_CARD_IMAGE_FILE_IT, "Seleziona file immagine card" },
/* ko */ { IDS_SELECT_CARD_IMAGE_FILE_KO, "" },  /* fuzzy */
/* nl */ { IDS_SELECT_CARD_IMAGE_FILE_NL, "Selecteer card bestand" },
/* pl */ { IDS_SELECT_CARD_IMAGE_FILE_PL, "Wybierz plik obrazu karty" },
/* ru */ { IDS_SELECT_CARD_IMAGE_FILE_RU, "Select card image file" },
/* sv */ { IDS_SELECT_CARD_IMAGE_FILE_SV, "Ange kortavbildningsfil" },
/* tr */ { IDS_SELECT_CARD_IMAGE_FILE_TR, "Kart imaj dosyas se" },

/* en */ { IDS_CARD_FILE,    "Card image file" },
/* da */ { IDS_CARD_FILE_DA, "Kortimagefil" },
/* de */ { IDS_CARD_FILE_DE, "Card Image Datei" },
/* es */ { IDS_CARD_FILE_ES, "Fichero imagen tarjeta" },
/* fr */ { IDS_CARD_FILE_FR, "Fichier image de carte" },
/* hu */ { IDS_CARD_FILE_HU, "" },  /* fuzzy */
/* it */ { IDS_CARD_FILE_IT, "File immagine Card" },
/* ko */ { IDS_CARD_FILE_KO, "ī ̹ " },
/* nl */ { IDS_CARD_FILE_NL, "Card bestand" },
/* pl */ { IDS_CARD_FILE_PL, "Plik obrazu karty" },
/* ru */ { IDS_CARD_FILE_RU, "" },  /* fuzzy */
/* sv */ { IDS_CARD_FILE_SV, "Kortavbildningsfil" },
/* tr */ { IDS_CARD_FILE_TR, "Kart imaj dosyas" },

/* en */ { IDS_CARD_READ_WRITE,    "Card read/write" },
/* da */ { IDS_CARD_READ_WRITE_DA, "Kort ls/skriv" },
/* de */ { IDS_CARD_READ_WRITE_DE, "Card lese/schreibe" },
/* es */ { IDS_CARD_READ_WRITE_ES, "Tarjeta lectura/grabacin" },
/* fr */ { IDS_CARD_READ_WRITE_FR, "Lecture/criture Carte" },
/* hu */ { IDS_CARD_READ_WRITE_HU, "" },  /* fuzzy */
/* it */ { IDS_CARD_READ_WRITE_IT, "Card in lettura/scrittura" },
/* ko */ { IDS_CARD_READ_WRITE_KO, "" },  /* fuzzy */
/* nl */ { IDS_CARD_READ_WRITE_NL, "Card lees/schrijf" },
/* pl */ { IDS_CARD_READ_WRITE_PL, "odczyt/zapis na kart" },
/* ru */ { IDS_CARD_READ_WRITE_RU, "" },  /* fuzzy */
/* sv */ { IDS_CARD_READ_WRITE_SV, "Skrivbart kort" },
/* tr */ { IDS_CARD_READ_WRITE_TR, "Kart oku/yaz" },

/* en */ { IDS_EEPROM_FILE,    "EEPROM image file" },
/* da */ { IDS_EEPROM_FILE_DA, "EEPROM image-fil" },
/* de */ { IDS_EEPROM_FILE_DE, "EEPROM Image Datei" },
/* es */ { IDS_EEPROM_FILE_ES, "Fichero imagen EEPROM" },
/* fr */ { IDS_EEPROM_FILE_FR, "Nom d'image EEPROM" },
/* hu */ { IDS_EEPROM_FILE_HU, "" },  /* fuzzy */
/* it */ { IDS_EEPROM_FILE_IT, "File immagine EEPROM" },
/* ko */ { IDS_EEPROM_FILE_KO, "EEPROM ̹ " },
/* nl */ { IDS_EEPROM_FILE_NL, "EEPROM bestand" },
/* pl */ { IDS_EEPROM_FILE_PL, "Plik obrazu EEPROM" },
/* ru */ { IDS_EEPROM_FILE_RU, "" },  /* fuzzy */
/* sv */ { IDS_EEPROM_FILE_SV, "EEPROM-avbildningsfil" },
/* tr */ { IDS_EEPROM_FILE_TR, "EEPROM imaj dosyas" },

/* en */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED,    "Save EEPROM image when changed" },
/* da */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_DA, "Gem EEPROM image ved ndringer" },
/* de */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_DE, "GEO-RAM Imagedatei bei nderung speichern" },
/* es */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_ES, "Grabar imagen EEPROM cuando cambie" },
/* fr */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_FR, "Enregistrer l'image EEPROM lorsque modifie" },
/* hu */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_HU, "" },  /* fuzzy */
/* it */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_IT, "Salva immagine EEPROM alla modifica" },
/* ko */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_KO, "" },  /* fuzzy */
/* nl */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_NL, "GEO-RAM bestand opslaan indien gewijzigd" },
/* pl */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_PL, "Zapisuj obraz EEPROM przy zmianie" },
/* ru */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_RU, "Save EEPROM image when changed" },
/* sv */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_SV, "Spara EEPROM-avbildning vid ndringar" },
/* tr */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_TR, "EEPROM imaj deitiinde kaydet" },

/* en */ { IDS_EEPROM_READ_WRITE,    "EEPROM read/write" },
/* da */ { IDS_EEPROM_READ_WRITE_DA, "EEPROM ls/skriv" },
/* de */ { IDS_EEPROM_READ_WRITE_DE, "EEPROM lese/schreibe" },
/* es */ { IDS_EEPROM_READ_WRITE_ES, "Lectura/grabacin EEPROM" },
/* fr */ { IDS_EEPROM_READ_WRITE_FR, "Lecture/criture EEPROM" },
/* hu */ { IDS_EEPROM_READ_WRITE_HU, "" },  /* fuzzy */
/* it */ { IDS_EEPROM_READ_WRITE_IT, "EEPROM in lettura/scrittura" },
/* ko */ { IDS_EEPROM_READ_WRITE_KO, "" },  /* fuzzy */
/* nl */ { IDS_EEPROM_READ_WRITE_NL, "EEPROM lees/schrijf" },
/* pl */ { IDS_EEPROM_READ_WRITE_PL, "odczyt/zapis EEPROM" },
/* ru */ { IDS_EEPROM_READ_WRITE_RU, "EEPROM read/write" },
/* sv */ { IDS_EEPROM_READ_WRITE_SV, "Skrivbar EEPROM" },
/* tr */ { IDS_EEPROM_READ_WRITE_TR, "EEPROM oku/yaz" },

/* en */ { IDS_RESCUE_MODE,    "Rescue mode" },
/* da */ { IDS_RESCUE_MODE_DA, "Fejlsikret tilstand" },
/* de */ { IDS_RESCUE_MODE_DE, "Rescue Modus" },
/* es */ { IDS_RESCUE_MODE_ES, "Modo rescate" },
/* fr */ { IDS_RESCUE_MODE_FR, "Mode de secours" },
/* hu */ { IDS_RESCUE_MODE_HU, "" },  /* fuzzy */
/* it */ { IDS_RESCUE_MODE_IT, "Modalit ripristino" },
/* ko */ { IDS_RESCUE_MODE_KO, "" },  /* fuzzy */
/* nl */ { IDS_RESCUE_MODE_NL, "Reddingsmodus" },
/* pl */ { IDS_RESCUE_MODE_PL, "Tryb ratunkowy" },
/* ru */ { IDS_RESCUE_MODE_RU, "Rescue mode" },
/* sv */ { IDS_RESCUE_MODE_SV, "Rddningslge" },
/* tr */ { IDS_RESCUE_MODE_TR, "Kurtarma modu" },

/* en */ { IDS_MMCREPLAY_SETTINGS,    "MMC Replay settings" },
/* da */ { IDS_MMCREPLAY_SETTINGS_DA, "MMC Replay-indstillinger" },
/* de */ { IDS_MMCREPLAY_SETTINGS_DE, "MMC Replay Einstellungen" },
/* es */ { IDS_MMCREPLAY_SETTINGS_ES, "Ajustes MMC Replay" },
/* fr */ { IDS_MMCREPLAY_SETTINGS_FR, "Paramtres MMC Replay" },
/* hu */ { IDS_MMCREPLAY_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_MMCREPLAY_SETTINGS_IT, "Impostazioni MMC Replay" },
/* ko */ { IDS_MMCREPLAY_SETTINGS_KO, "MMC Replay " },
/* nl */ { IDS_MMCREPLAY_SETTINGS_NL, "MMC Replay instellingen" },
/* pl */ { IDS_MMCREPLAY_SETTINGS_PL, "Ustawienia MMC Replay" },
/* ru */ { IDS_MMCREPLAY_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_MMCREPLAY_SETTINGS_SV, "MMC Replay-instllningar" },
/* tr */ { IDS_MMCREPLAY_SETTINGS_TR, "MMC Replay ayarlar" },

/* en */ { IDS_RETROREPLAY_SETTINGS,    "Retro Replay settings" },
/* da */ { IDS_RETROREPLAY_SETTINGS_DA, "Retro Replay-indstillinger" },
/* de */ { IDS_RETROREPLAY_SETTINGS_DE, "Retro Replay Einstellungen" },
/* es */ { IDS_RETROREPLAY_SETTINGS_ES, "Ajustes Retro Replay" },
/* fr */ { IDS_RETROREPLAY_SETTINGS_FR, "Paramtres Retro Replay" },
/* hu */ { IDS_RETROREPLAY_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_RETROREPLAY_SETTINGS_IT, "Impostazioni Retro Replay" },
/* ko */ { IDS_RETROREPLAY_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_RETROREPLAY_SETTINGS_NL, "Retro Replay instellingen" },
/* pl */ { IDS_RETROREPLAY_SETTINGS_PL, "Ustawienia Retro Replay" },
/* ru */ { IDS_RETROREPLAY_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_RETROREPLAY_SETTINGS_SV, "Retro Replay-instllningar" },
/* tr */ { IDS_RETROREPLAY_SETTINGS_TR, "Retro Replay ayarlar" },

/* en */ { IDS_SELECT_GENERIC,    "Select generic cartridge image" },
/* da */ { IDS_SELECT_GENERIC_DA, "Vlg standardcartridgeimage" },
/* de */ { IDS_SELECT_GENERIC_DE, "Unverselles Erweiterungsmodul Image Datei whlen" },
/* es */ { IDS_SELECT_GENERIC_ES, "Seleccionar imagen cartucho generico" },
/* fr */ { IDS_SELECT_GENERIC_FR, "Slectionner l'image de cartouche gnrique" },
/* hu */ { IDS_SELECT_GENERIC_HU, "" },  /* fuzzy */
/* it */ { IDS_SELECT_GENERIC_IT, "Seleziona immagine cartuccia generica" },
/* ko */ { IDS_SELECT_GENERIC_KO, "" },  /* fuzzy */
/* nl */ { IDS_SELECT_GENERIC_NL, "Selecteer algemeen cartridge bestand" },
/* pl */ { IDS_SELECT_GENERIC_PL, "Wybierz typowy obraz kartrida" },
/* ru */ { IDS_SELECT_GENERIC_RU, "Select generic cartridge image" },
/* sv */ { IDS_SELECT_GENERIC_SV, "Vlj generisk insticksmodulavbildning" },
/* tr */ { IDS_SELECT_GENERIC_TR, "Jenerik kartu imaj se" },

/* en */ { IDS_SELECT_UM,    "Select UltiMem image" },
/* da */ { IDS_SELECT_UM_DA, "" },  /* fuzzy */
/* de */ { IDS_SELECT_UM_DE, "UltiMem Image whlen" },
/* es */ { IDS_SELECT_UM_ES, "" },  /* fuzzy */
/* fr */ { IDS_SELECT_UM_FR, "" },  /* fuzzy */
/* hu */ { IDS_SELECT_UM_HU, "" },  /* fuzzy */
/* it */ { IDS_SELECT_UM_IT, "" },  /* fuzzy */
/* ko */ { IDS_SELECT_UM_KO, "" },  /* fuzzy */
/* nl */ { IDS_SELECT_UM_NL, "Selecteer UltiMem bestand" },
/* pl */ { IDS_SELECT_UM_PL, "" },  /* fuzzy */
/* ru */ { IDS_SELECT_UM_RU, "" },  /* fuzzy */
/* sv */ { IDS_SELECT_UM_SV, "" },  /* fuzzy */
/* tr */ { IDS_SELECT_UM_TR, "" },  /* fuzzy */

/* en */ { IDS_SELECT_FP,    "Select Vic Flash Plugin image" },
/* da */ { IDS_SELECT_FP_DA, "Vlg Vic Flash Plugin-image" },
/* de */ { IDS_SELECT_FP_DE, "Vic Flash Plugin Image auswhlen" },
/* es */ { IDS_SELECT_FP_ES, "Seleccionar imagen Vic Flash Plugin" },
/* fr */ { IDS_SELECT_FP_FR, "Slectionner l'image Vic Flash Plugin" },
/* hu */ { IDS_SELECT_FP_HU, "" },  /* fuzzy */
/* it */ { IDS_SELECT_FP_IT, "Seleziona immagine Vic Flash Plugin " },
/* ko */ { IDS_SELECT_FP_KO, "" },  /* fuzzy */
/* nl */ { IDS_SELECT_FP_NL, "Selecteer Vic Flash Plugin bestand" },
/* pl */ { IDS_SELECT_FP_PL, "Wybierz obraz Vic Flash Plugin" },
/* ru */ { IDS_SELECT_FP_RU, "Select Vic Flash Plugin image" },
/* sv */ { IDS_SELECT_FP_SV, "Vlj avbildning fr Vic Flash-insticksmodul" },
/* tr */ { IDS_SELECT_FP_TR, "Vic Flash Plugin imaj se" },

/* en */ { IDS_SELECT_MEGACART,    "Select Mega-Cart image" },
/* da */ { IDS_SELECT_MEGACART_DA, "Vlg MegaCart-imagefil" },
/* de */ { IDS_SELECT_MEGACART_DE, "Mega-Cart Image Date whlen" },
/* es */ { IDS_SELECT_MEGACART_ES, "Seleccionar imagen Mega-Cart" },
/* fr */ { IDS_SELECT_MEGACART_FR, "Slectionner l'image Mega-Cart" },
/* hu */ { IDS_SELECT_MEGACART_HU, "Vlassza ki a Mega-Cart kpmst" },
/* it */ { IDS_SELECT_MEGACART_IT, "Seleziona immagine Mega-Cart" },
/* ko */ { IDS_SELECT_MEGACART_KO, "" },  /* fuzzy */
/* nl */ { IDS_SELECT_MEGACART_NL, "Selecteer Mega-Cart bestand" },
/* pl */ { IDS_SELECT_MEGACART_PL, "Wybierz obraz Mega-Cart" },
/* ru */ { IDS_SELECT_MEGACART_RU, "Select Mega-Cart image" },
/* sv */ { IDS_SELECT_MEGACART_SV, "Vlj Mega-Cart-modulfil" },
/* tr */ { IDS_SELECT_MEGACART_TR, "Mega-Cart imaj se" },

/* en */ { IDS_SELECT_FINAL_EXPANSION,    "Select Final Expansion image" },
/* da */ { IDS_SELECT_FINAL_EXPANSION_DA, "Vlg Final Expansion-imagefil" },
/* de */ { IDS_SELECT_FINAL_EXPANSION_DE, "Final Expansion Image Datei auswhlen" },
/* es */ { IDS_SELECT_FINAL_EXPANSION_ES, "Seleccionar imagen Final Expansion" },
/* fr */ { IDS_SELECT_FINAL_EXPANSION_FR, "Slectionner l'image ROM Final Expansion" },
/* hu */ { IDS_SELECT_FINAL_EXPANSION_HU, "Vlassza ki a Final Expansion kpmst" },
/* it */ { IDS_SELECT_FINAL_EXPANSION_IT, "Seleziona immagine Final Expansion" },
/* ko */ { IDS_SELECT_FINAL_EXPANSION_KO, "" },  /* fuzzy */
/* nl */ { IDS_SELECT_FINAL_EXPANSION_NL, "Selecteer Final Expansion bestand" },
/* pl */ { IDS_SELECT_FINAL_EXPANSION_PL, "Wybierz obraz Final Expansion" },
/* ru */ { IDS_SELECT_FINAL_EXPANSION_RU, "Select Final Expansion image" },
/* sv */ { IDS_SELECT_FINAL_EXPANSION_SV, "Vlj avbildning fr Final Expansion" },
/* tr */ { IDS_SELECT_FINAL_EXPANSION_TR, "Final Expansion imaj se" },

/* en */ { IDS_SELECT_CARTRIDGE_IMAGE,    "Select cartridge file" },
/* da */ { IDS_SELECT_CARTRIDGE_IMAGE_DA, "Vlg cartridge-fil" },
/* de */ { IDS_SELECT_CARTRIDGE_IMAGE_DE, "Erweiterungsmodul Image Datei whlen" },
/* es */ { IDS_SELECT_CARTRIDGE_IMAGE_ES, "Seleccionar imagen cartucho" },
/* fr */ { IDS_SELECT_CARTRIDGE_IMAGE_FR, "Slection le fichier de cartouche" },
/* hu */ { IDS_SELECT_CARTRIDGE_IMAGE_HU, "Cartridge fjl kivlasztsa" },
/* it */ { IDS_SELECT_CARTRIDGE_IMAGE_IT, "Seleziona file cartuccia" },
/* ko */ { IDS_SELECT_CARTRIDGE_IMAGE_KO, "" },  /* fuzzy */
/* nl */ { IDS_SELECT_CARTRIDGE_IMAGE_NL, "Selecteer cartridge bestand" },
/* pl */ { IDS_SELECT_CARTRIDGE_IMAGE_PL, "Wybierz plik kartrida" },
/* ru */ { IDS_SELECT_CARTRIDGE_IMAGE_RU, "  " },
/* sv */ { IDS_SELECT_CARTRIDGE_IMAGE_SV, "Vlj insticksmodulfil" },
/* tr */ { IDS_SELECT_CARTRIDGE_IMAGE_TR, "Kartu dosyasn se" },

/* en */ { IDS_SID_CART,    "SID cartridge" },
/* da */ { IDS_SID_CART_DA, "SID-cartridge" },
/* de */ { IDS_SID_CART_DE, "SID Modul" },
/* es */ { IDS_SID_CART_ES, "Cartucho SID" },
/* fr */ { IDS_SID_CART_FR, "Cartouche SID" },
/* hu */ { IDS_SID_CART_HU, "SID cartridge" },
/* it */ { IDS_SID_CART_IT, "Cartuccia SID" },
/* ko */ { IDS_SID_CART_KO, "SID īƮ" },
/* nl */ { IDS_SID_CART_NL, "SID cartridge" },
/* pl */ { IDS_SID_CART_PL, "Kartrid SID" },
/* ru */ { IDS_SID_CART_RU, " SID" },
/* sv */ { IDS_SID_CART_SV, "SID-insticksmodul" },
/* tr */ { IDS_SID_CART_TR, "SID kartuu" },

/* en */ { IDS_SID_ENGINE_MODEL,    "SID engine and model" },
/* da */ { IDS_SID_ENGINE_MODEL_DA, "SID-motor og -model" },
/* de */ { IDS_SID_ENGINE_MODEL_DE, "SID Engine und Modell" },
/* es */ { IDS_SID_ENGINE_MODEL_ES, "Modelo y motor SID" },
/* fr */ { IDS_SID_ENGINE_MODEL_FR, "Engin SID et modle" },
/* hu */ { IDS_SID_ENGINE_MODEL_HU, "" },  /* fuzzy */
/* it */ { IDS_SID_ENGINE_MODEL_IT, "Motore e modello  SID" },
/* ko */ { IDS_SID_ENGINE_MODEL_KO, "" },  /* fuzzy */
/* nl */ { IDS_SID_ENGINE_MODEL_NL, "SID kern en model" },
/* pl */ { IDS_SID_ENGINE_MODEL_PL, "silnik i model SID" },
/* ru */ { IDS_SID_ENGINE_MODEL_RU, "" },  /* fuzzy */
/* sv */ { IDS_SID_ENGINE_MODEL_SV, "SID-motor och -modell" },
/* tr */ { IDS_SID_ENGINE_MODEL_TR, "SID motoru ve modeli" },

/* en */ { IDS_SID_ENGINE,    "SID engine" },
/* da */ { IDS_SID_ENGINE_DA, "SID-motor" },
/* de */ { IDS_SID_ENGINE_DE, "SID Engine" },
/* es */ { IDS_SID_ENGINE_ES, "Motor SID" },
/* fr */ { IDS_SID_ENGINE_FR, "Engin SID" },
/* hu */ { IDS_SID_ENGINE_HU, "" },  /* fuzzy */
/* it */ { IDS_SID_ENGINE_IT, "Motore SID" },
/* ko */ { IDS_SID_ENGINE_KO, "" },  /* fuzzy */
/* nl */ { IDS_SID_ENGINE_NL, "SID kern" },
/* pl */ { IDS_SID_ENGINE_PL, "Silnik SID" },
/* ru */ { IDS_SID_ENGINE_RU, "" },  /* fuzzy */
/* sv */ { IDS_SID_ENGINE_SV, "SID-motor" },
/* tr */ { IDS_SID_ENGINE_TR, "SID motoru" },

/* en */ { IDS_SID_MODEL,    "SID model" },
/* da */ { IDS_SID_MODEL_DA, "SID-model" },
/* de */ { IDS_SID_MODEL_DE, "SID Modell" },
/* es */ { IDS_SID_MODEL_ES, "Modelo SID" },
/* fr */ { IDS_SID_MODEL_FR, "Modle SID" },
/* hu */ { IDS_SID_MODEL_HU, "SID modell" },
/* it */ { IDS_SID_MODEL_IT, "Modello SID" },
/* ko */ { IDS_SID_MODEL_KO, "SID " },
/* nl */ { IDS_SID_MODEL_NL, "SID model" },
/* pl */ { IDS_SID_MODEL_PL, "Model SID-a" },
/* ru */ { IDS_SID_MODEL_RU, "  SID" },
/* sv */ { IDS_SID_MODEL_SV, "SID-modell" },
/* tr */ { IDS_SID_MODEL_TR, "SID modeli" },

/* en */ { IDS_SID_ADDRESS,    "SID address" },
/* da */ { IDS_SID_ADDRESS_DA, "SID-adresse" },
/* de */ { IDS_SID_ADDRESS_DE, "SID Adresse" },
/* es */ { IDS_SID_ADDRESS_ES, "Direccin SID" },
/* fr */ { IDS_SID_ADDRESS_FR, "Adresse SID" },
/* hu */ { IDS_SID_ADDRESS_HU, "SID cm" },
/* it */ { IDS_SID_ADDRESS_IT, "Indirizzo SID" },
/* ko */ { IDS_SID_ADDRESS_KO, "SID ּ" },
/* nl */ { IDS_SID_ADDRESS_NL, "SID adres" },
/* pl */ { IDS_SID_ADDRESS_PL, "Adres SID" },
/* ru */ { IDS_SID_ADDRESS_RU, " SID" },
/* sv */ { IDS_SID_ADDRESS_SV, "SID-adress" },
/* tr */ { IDS_SID_ADDRESS_TR, "SID adresi" },

/* en */ { IDS_SID_CLOCK,    "SID clock" },
/* da */ { IDS_SID_CLOCK_DA, "SID-klok" },
/* de */ { IDS_SID_CLOCK_DE, "SID Takt" },
/* es */ { IDS_SID_CLOCK_ES, "Reloj SID" },
/* fr */ { IDS_SID_CLOCK_FR, "Horloge SID" },
/* hu */ { IDS_SID_CLOCK_HU, "SID rajel" },
/* it */ { IDS_SID_CLOCK_IT, "Clock SID" },
/* ko */ { IDS_SID_CLOCK_KO, "SID Ŭ" },
/* nl */ { IDS_SID_CLOCK_NL, "SID klok" },
/* pl */ { IDS_SID_CLOCK_PL, "Zegar SID" },
/* ru */ { IDS_SID_CLOCK_RU, "SID " },
/* sv */ { IDS_SID_CLOCK_SV, "SID-klocka" },
/* tr */ { IDS_SID_CLOCK_TR, "SID saati" },

/* en */ { IDS_SID_DIGIBLASTER,    "Digiblaster add-on" },
/* da */ { IDS_SID_DIGIBLASTER_DA, "Digiblaster udviddelse" },
/* de */ { IDS_SID_DIGIBLASTER_DE, "Digiblaster add-on" },
/* es */ { IDS_SID_DIGIBLASTER_ES, "Aadir Digiblaster" },
/* fr */ { IDS_SID_DIGIBLASTER_FR, "Add-on digiblaster" },
/* hu */ { IDS_SID_DIGIBLASTER_HU, "Digiblaster kiterjeszts" },
/* it */ { IDS_SID_DIGIBLASTER_IT, "Estensione digiblaster" },
/* ko */ { IDS_SID_DIGIBLASTER_KO, "Digiblaster  " },
/* nl */ { IDS_SID_DIGIBLASTER_NL, "Digiblaster add-on" },
/* pl */ { IDS_SID_DIGIBLASTER_PL, "Dodatek digiblaster" },
/* ru */ { IDS_SID_DIGIBLASTER_RU, "Digiblaster add-on" },
/* sv */ { IDS_SID_DIGIBLASTER_SV, "Digiblaster-tillgg" },
/* tr */ { IDS_SID_DIGIBLASTER_TR, "Digiblaster eklentisi" },

/* en */ { IDS_SIDCART_SETTINGS,    "SID cart settings" },
/* da */ { IDS_SIDCART_SETTINGS_DA, "SID-cartridgeindstillinger" },
/* de */ { IDS_SIDCART_SETTINGS_DE, "SID Modul Einstellungen" },
/* es */ { IDS_SIDCART_SETTINGS_ES, "Ajustes SID Cart" },
/* fr */ { IDS_SIDCART_SETTINGS_FR, "Paramtres SID Cart" },
/* hu */ { IDS_SIDCART_SETTINGS_HU, "SID krtya belltsai..." },
/* it */ { IDS_SIDCART_SETTINGS_IT, "Impostazioni cartuccia SID" },
/* ko */ { IDS_SIDCART_SETTINGS_KO, "SID īƮ " },
/* nl */ { IDS_SIDCART_SETTINGS_NL, "SID cart instellingen" },
/* pl */ { IDS_SIDCART_SETTINGS_PL, "Ustawienia karty SID" },
/* ru */ { IDS_SIDCART_SETTINGS_RU, "SID cart settings" },
/* sv */ { IDS_SIDCART_SETTINGS_SV, "SID-modulinstllningarg" },
/* tr */ { IDS_SIDCART_SETTINGS_TR, "SID kartuu ayarlar" },

/* en */ { IDS_LOAD_FLIP_LIST_FILE,    "Load flip list file" },
/* da */ { IDS_LOAD_FLIP_LIST_FILE_DA, "Indls bladrelistefil" },
/* de */ { IDS_LOAD_FLIP_LIST_FILE_DE, "Fliplist Datei laden" },
/* es */ { IDS_LOAD_FLIP_LIST_FILE_ES, "Cargar lista de ficheros a conmutar" },
/* fr */ { IDS_LOAD_FLIP_LIST_FILE_FR, "Charger un fichier de groupement de disques" },
/* hu */ { IDS_LOAD_FLIP_LIST_FILE_HU, "Lemezlista betltse" },
/* it */ { IDS_LOAD_FLIP_LIST_FILE_IT, "Carica file fliplist" },
/* ko */ { IDS_LOAD_FLIP_LIST_FILE_KO, "ø Ʈ  ҷ" },
/* nl */ { IDS_LOAD_FLIP_LIST_FILE_NL, "Laad fliplijstbestand" },
/* pl */ { IDS_LOAD_FLIP_LIST_FILE_PL, "Wczytaj plik listy podmiany nonikw" },
/* ru */ { IDS_LOAD_FLIP_LIST_FILE_RU, "Load flip list file" },
/* sv */ { IDS_LOAD_FLIP_LIST_FILE_SV, "Ls vallistefil" },
/* tr */ { IDS_LOAD_FLIP_LIST_FILE_TR, "Sralama listesi dosyasn ykle" },

/* en */ { IDS_CANNOT_READ_FLIP_LIST,    "Cannot read flip list file" },
/* da */ { IDS_CANNOT_READ_FLIP_LIST_DA, "Kunne ikke lse bladrelistefil" },
/* de */ { IDS_CANNOT_READ_FLIP_LIST_DE, "Lesen von Fliplist Datei fehlgeschlagen" },
/* es */ { IDS_CANNOT_READ_FLIP_LIST_ES, "No puedo leer fichero de lista de intercambio" },
/* fr */ { IDS_CANNOT_READ_FLIP_LIST_FR, "Impossible de lire le fichier de groupement" },
/* hu */ { IDS_CANNOT_READ_FLIP_LIST_HU, "Nem lehet olvasni a lemezlista fjlt" },
/* it */ { IDS_CANNOT_READ_FLIP_LIST_IT, "Non  possibile caricare il file della flip list" },
/* ko */ { IDS_CANNOT_READ_FLIP_LIST_KO, "ø Ʈ   ϴ" },
/* nl */ { IDS_CANNOT_READ_FLIP_LIST_NL, "Kan het fliplijstbestand niet lezen" },
/* pl */ { IDS_CANNOT_READ_FLIP_LIST_PL, "Nie mona odczyta pliku listy podmiany nonikw" },
/* ru */ { IDS_CANNOT_READ_FLIP_LIST_RU, "Cannot read flip list file" },
/* sv */ { IDS_CANNOT_READ_FLIP_LIST_SV, "Kunde inte lsa vallistefil" },
/* tr */ { IDS_CANNOT_READ_FLIP_LIST_TR, "Sralama listesi dosyas okunamad" },

/* en */ { IDS_SAVE_FLIP_LIST_FILE,    "Save flip list file" },
/* da */ { IDS_SAVE_FLIP_LIST_FILE_DA, "Gem bladrelistefil" },
/* de */ { IDS_SAVE_FLIP_LIST_FILE_DE, "Fliplist Datei speichern" },
/* es */ { IDS_SAVE_FLIP_LIST_FILE_ES, "Grabar lista de ficheros a conmutar" },
/* fr */ { IDS_SAVE_FLIP_LIST_FILE_FR, "Enregistrer le fichier de groupement de disques actuel" },
/* hu */ { IDS_SAVE_FLIP_LIST_FILE_HU, "Lemezlista mentse fjlba" },
/* it */ { IDS_SAVE_FLIP_LIST_FILE_IT, "Salva file fliplist" },
/* ko */ { IDS_SAVE_FLIP_LIST_FILE_KO, "ø Ʈ  ϱ" },
/* nl */ { IDS_SAVE_FLIP_LIST_FILE_NL, "Fliplijstbestand opslaan" },
/* pl */ { IDS_SAVE_FLIP_LIST_FILE_PL, "Zapisz plik listy podmiany nonikw" },
/* ru */ { IDS_SAVE_FLIP_LIST_FILE_RU, "Save flip list file" },
/* sv */ { IDS_SAVE_FLIP_LIST_FILE_SV, "Spara vallistefil" },
/* tr */ { IDS_SAVE_FLIP_LIST_FILE_TR, "Sralama listesi dosyasn kaydet" },

/* en */ { IDS_CANNOT_WRITE_FLIP_LIST,    "Cannot write flip list file" },
/* da */ { IDS_CANNOT_WRITE_FLIP_LIST_DA, "Kunne ikke skrive bladrelistefil" },
/* de */ { IDS_CANNOT_WRITE_FLIP_LIST_DE, "Schreiben von Fliplist Datei fehlgeschlagen" },
/* es */ { IDS_CANNOT_WRITE_FLIP_LIST_ES, "No puedo grabar fichero de lista de intercambio" },
/* fr */ { IDS_CANNOT_WRITE_FLIP_LIST_FR, "Impossible d'crire le fichier de groupement de disques" },
/* hu */ { IDS_CANNOT_WRITE_FLIP_LIST_HU, "Nem sikerlt a lemezlistt fjlba rni" },
/* it */ { IDS_CANNOT_WRITE_FLIP_LIST_IT, "Non  possibile scrivere il file della flip list" },
/* ko */ { IDS_CANNOT_WRITE_FLIP_LIST_KO, "ø Ʈ   ϴ" },
/* nl */ { IDS_CANNOT_WRITE_FLIP_LIST_NL, "Kan fliplijstbestand niet schrijven" },
/* pl */ { IDS_CANNOT_WRITE_FLIP_LIST_PL, "Nie mona zapisa pliku listy wymiany nonikw" },
/* ru */ { IDS_CANNOT_WRITE_FLIP_LIST_RU, "Cannot write flip list file" },
/* sv */ { IDS_CANNOT_WRITE_FLIP_LIST_SV, "Kan inte skriva vallistefil" },
/* tr */ { IDS_CANNOT_WRITE_FLIP_LIST_TR, "Sralama listesi dosyas yazlamad" },

/* en */ { IDS_ATTACH_CART0_LOW,    "Attach cartridge image for Cartridge0 Low" },
/* da */ { IDS_ATTACH_CART0_LOW_DA, "Tilslut cartridge image for Cartridge0 Lav" },
/* de */ { IDS_ATTACH_CART0_LOW_DE, "Cartridge0 (low) Erweiterungsmodul einlegen" },
/* es */ { IDS_ATTACH_CART0_LOW_ES, "Insertar imagen cartucho para cartucho0 bajo" },
/* fr */ { IDS_ATTACH_CART0_LOW_FR, "Attacher une image de cartouche pour la Cartouche0 Basse" },
/* hu */ { IDS_ATTACH_CART0_LOW_HU, "" },  /* fuzzy */
/* it */ { IDS_ATTACH_CART0_LOW_IT, "Seleziona immagine cartuccia per la Cartridge0 Low" },
/* ko */ { IDS_ATTACH_CART0_LOW_KO, "" },  /* fuzzy */
/* nl */ { IDS_ATTACH_CART0_LOW_NL, "Koppel cartridge bestand voor 'Cartridge0 Low'" },
/* pl */ { IDS_ATTACH_CART0_LOW_PL, "Zamontuj obraz kartrida do Cartridge0 Low" },
/* ru */ { IDS_ATTACH_CART0_LOW_RU, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_CART0_LOW_SV, "Anslut insticksmodulfil fr modul0 lg" },
/* tr */ { IDS_ATTACH_CART0_LOW_TR, "Kartu0 Low iin kartu imaj yerletirin" },

/* en */ { IDS_ATTACH_CART0_HIGH,    "Attach cartridge image for Cartridge0 High" },
/* da */ { IDS_ATTACH_CART0_HIGH_DA, "Tilslut cartridge image for Cartridge0 Hj" },
/* de */ { IDS_ATTACH_CART0_HIGH_DE, "Cartridge0 (high) Erweiterungsmodul einlegen" },
/* es */ { IDS_ATTACH_CART0_HIGH_ES, "Insertar imagen cartucho para cartucho0 alto" },
/* fr */ { IDS_ATTACH_CART0_HIGH_FR, "Attacher une image de cartouche pour la Cartouche0 Haute" },
/* hu */ { IDS_ATTACH_CART0_HIGH_HU, "" },  /* fuzzy */
/* it */ { IDS_ATTACH_CART0_HIGH_IT, "Seleziona immagine cartuccia per la Cartridge0 High" },
/* ko */ { IDS_ATTACH_CART0_HIGH_KO, "" },  /* fuzzy */
/* nl */ { IDS_ATTACH_CART0_HIGH_NL, "Koppel cartridge bestand voor 'Cartridge0 High'" },
/* pl */ { IDS_ATTACH_CART0_HIGH_PL, "Zamontuj obraz kartrida do Cartridge0 High" },
/* ru */ { IDS_ATTACH_CART0_HIGH_RU, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_CART0_HIGH_SV, "Anslut insticksmodulfil fr modul0 hg" },
/* tr */ { IDS_ATTACH_CART0_HIGH_TR, "Kartu0 High iin kartu imaj yerletirin" },

/* en */ { IDS_ATTACH_CART1_LOW,    "Attach cartridge image for Cartridge1 Low" },
/* da */ { IDS_ATTACH_CART1_LOW_DA, "Tilslut cartridge image for Cartridge1 Lav" },
/* de */ { IDS_ATTACH_CART1_LOW_DE, "Cartridge1 (low) Erweiterungsmodul einlegen" },
/* es */ { IDS_ATTACH_CART1_LOW_ES, "Insertar imagen cartucho para cartucho1 bajo" },
/* fr */ { IDS_ATTACH_CART1_LOW_FR, "Insrer une cartouche pour Cartouche1 basse" },
/* hu */ { IDS_ATTACH_CART1_LOW_HU, "Cartridge kpms csatolsa als Cartridge1-hez" },
/* it */ { IDS_ATTACH_CART1_LOW_IT, "Seleziona immagine cartuccia per la Cartridge Low" },
/* ko */ { IDS_ATTACH_CART1_LOW_KO, "" },  /* fuzzy */
/* nl */ { IDS_ATTACH_CART1_LOW_NL, "Koppel cartridge bestand voor 'Cartridge1 Low'" },
/* pl */ { IDS_ATTACH_CART1_LOW_PL, "Zamontuj obraz kartrida do Cartridge1 Low" },
/* ru */ { IDS_ATTACH_CART1_LOW_RU, "Attach cartridge image for Cartridge1 Low" },
/* sv */ { IDS_ATTACH_CART1_LOW_SV, "Anslut insticksmodulfil fr modul1 lg" },
/* tr */ { IDS_ATTACH_CART1_LOW_TR, "Kartu1 Low iin kartu imaj yerletirin" },

/* en */ { IDS_ATTACH_CART1_HIGH,    "Attach cartridge image for Cartridge1 High" },
/* da */ { IDS_ATTACH_CART1_HIGH_DA, "Tilslut cartridge image for Cartridge1 Hj" },
/* de */ { IDS_ATTACH_CART1_HIGH_DE, "Cartridge1 (high) Erweiterungsmodul einlegen" },
/* es */ { IDS_ATTACH_CART1_HIGH_ES, "Insertar imagen cartucho para cartucho1 alto" },
/* fr */ { IDS_ATTACH_CART1_HIGH_FR, "Insrer une cartouche pour Cartouche1 haute" },
/* hu */ { IDS_ATTACH_CART1_HIGH_HU, "Cartridge kpms csatolsa fels Cartridge1-hez" },
/* it */ { IDS_ATTACH_CART1_HIGH_IT, "Seleziona immagine cartuccia per la Cartridge1 High" },
/* ko */ { IDS_ATTACH_CART1_HIGH_KO, "" },  /* fuzzy */
/* nl */ { IDS_ATTACH_CART1_HIGH_NL, "Koppel cartridge bestand voor 'Cartridge1 High'" },
/* pl */ { IDS_ATTACH_CART1_HIGH_PL, "Zamontuj obraz kartrida do Cartridge1 High" },
/* ru */ { IDS_ATTACH_CART1_HIGH_RU, "Attach cartridge image for Cartridge1 High" },
/* sv */ { IDS_ATTACH_CART1_HIGH_SV, "Anslut insticksmodulfil fr modul1 hg" },
/* tr */ { IDS_ATTACH_CART1_HIGH_TR, "Kartu1 High iin kartu imaj yerletirin" },

/* en */ { IDS_ATTACH_CART2_LOW,    "Attach cartridge image for Cartridge2 Low" },
/* da */ { IDS_ATTACH_CART2_LOW_DA, "Tilslut cartridge image for Cartridge2 Lav" },
/* de */ { IDS_ATTACH_CART2_LOW_DE, "Cartridge2 (low) Erweiterungsmodul einlegen" },
/* es */ { IDS_ATTACH_CART2_LOW_ES, "Insertar imagen cartucho para cartucho2 bajo" },
/* fr */ { IDS_ATTACH_CART2_LOW_FR, "Insrer une cartouche pour Cartouche2 basse" },
/* hu */ { IDS_ATTACH_CART2_LOW_HU, "Cartridge kpms csatolsa als Cartridge2-hz" },
/* it */ { IDS_ATTACH_CART2_LOW_IT, "Seleziona immagine cartuccia per la Cartridge2 Low" },
/* ko */ { IDS_ATTACH_CART2_LOW_KO, "" },  /* fuzzy */
/* nl */ { IDS_ATTACH_CART2_LOW_NL, "Koppel cartridge bestand voor 'Cartridge2 Low'" },
/* pl */ { IDS_ATTACH_CART2_LOW_PL, "Zamontuj obraz kartrida do Cartridge2 Low" },
/* ru */ { IDS_ATTACH_CART2_LOW_RU, "Attach cartridge image for Cartridge2 Low" },
/* sv */ { IDS_ATTACH_CART2_LOW_SV, "Anslut insticksmodulfil fr modul2 lg" },
/* tr */ { IDS_ATTACH_CART2_LOW_TR, "Kartu2 Low iin kartu imaj yerletirin" },

/* en */ { IDS_ATTACH_CART2_HIGH,    "Attach cartridge image for Cartridge2 High" },
/* da */ { IDS_ATTACH_CART2_HIGH_DA, "Tilslut cartridge image for Cartridge2 Hj" },
/* de */ { IDS_ATTACH_CART2_HIGH_DE, "Cartridge1 (high) Erweiterungsmodul einlegen" },
/* es */ { IDS_ATTACH_CART2_HIGH_ES, "Insertar imagen cartucho para cartucho2 alto" },
/* fr */ { IDS_ATTACH_CART2_HIGH_FR, "Insrer une cartouche pour Cartouche2 haute" },
/* hu */ { IDS_ATTACH_CART2_HIGH_HU, "Cartridge kpms csatolsa fels Cartridge2-hz" },
/* it */ { IDS_ATTACH_CART2_HIGH_IT, "Seleziona immagine cartuccia per la Cartridge2 High" },
/* ko */ { IDS_ATTACH_CART2_HIGH_KO, "" },  /* fuzzy */
/* nl */ { IDS_ATTACH_CART2_HIGH_NL, "Koppel cartridge bestand voor 'Cartridge2 High'" },
/* pl */ { IDS_ATTACH_CART2_HIGH_PL, "Zamontuj obraz kartrida do Cartridge2 High" },
/* ru */ { IDS_ATTACH_CART2_HIGH_RU, "Attach cartridge image for Cartridge2 High" },
/* sv */ { IDS_ATTACH_CART2_HIGH_SV, "Anslut insticksmodulfil fr modul2 hg" },
/* tr */ { IDS_ATTACH_CART2_HIGH_TR, "Kartu2 High iin kartu imaj yerletirin" },

/* en */ { IDS_ATTACH_CART,    "Attach cartridge image" },
/* da */ { IDS_ATTACH_CART_DA, "Tilslut cartridge-image" },
/* de */ { IDS_ATTACH_CART_DE, "Erweiterungsmodul einlegen" },
/* es */ { IDS_ATTACH_CART_ES, "Insertar imagen de cartucho" },
/* fr */ { IDS_ATTACH_CART_FR, "Insrer une cartouche" },
/* hu */ { IDS_ATTACH_CART_HU, "Cartridge kpms csatolsa" },
/* it */ { IDS_ATTACH_CART_IT, "Seleziona immagine cartuccia" },
/* ko */ { IDS_ATTACH_CART_KO, "īƮ ̹ ̱" },
/* nl */ { IDS_ATTACH_CART_NL, "Koppel cartridge bestand" },
/* pl */ { IDS_ATTACH_CART_PL, "Zamontuj obraz kartrida" },
/* ru */ { IDS_ATTACH_CART_RU, "  " },
/* sv */ { IDS_ATTACH_CART_SV, "Anslut insticksmodulfil" },
/* tr */ { IDS_ATTACH_CART_TR, "Kartu imaj yerletir" },

/* en */ { IDS_SAVE_SNAPSHOT_IMAGE,    "Save snapshot image" },
/* da */ { IDS_SAVE_SNAPSHOT_IMAGE_DA, "Gem snapshot" },
/* de */ { IDS_SAVE_SNAPSHOT_IMAGE_DE, "Snapshot Datei speichern" },
/* es */ { IDS_SAVE_SNAPSHOT_IMAGE_ES, "Grabar Instantnea" },
/* fr */ { IDS_SAVE_SNAPSHOT_IMAGE_FR, "Enregistrer le fichier de sauvegarde" },
/* hu */ { IDS_SAVE_SNAPSHOT_IMAGE_HU, "Pillanatkp fjl mentse" },
/* it */ { IDS_SAVE_SNAPSHOT_IMAGE_IT, "Salva immagine snapshot" },
/* ko */ { IDS_SAVE_SNAPSHOT_IMAGE_KO, " ̹ " },
/* nl */ { IDS_SAVE_SNAPSHOT_IMAGE_NL, "Momentopnamebestand opslaan" },
/* pl */ { IDS_SAVE_SNAPSHOT_IMAGE_PL, "Zapisz obraz zrzutu" },
/* ru */ { IDS_SAVE_SNAPSHOT_IMAGE_RU, " " },
/* sv */ { IDS_SAVE_SNAPSHOT_IMAGE_SV, "Spara gonblicksbildfil" },
/* tr */ { IDS_SAVE_SNAPSHOT_IMAGE_TR, "Anlk grnt imajn kaydet" },

/* en */ { IDS_LOAD_SNAPSHOT_IMAGE,    "Load snapshot image" },
/* da */ { IDS_LOAD_SNAPSHOT_IMAGE_DA, "Indls snapshot" },
/* de */ { IDS_LOAD_SNAPSHOT_IMAGE_DE, "Snapshot laden" },
/* es */ { IDS_LOAD_SNAPSHOT_IMAGE_ES, "Cargar Instantnea" },
/* fr */ { IDS_LOAD_SNAPSHOT_IMAGE_FR, "Charger le fichier de sauvegarde" },
/* hu */ { IDS_LOAD_SNAPSHOT_IMAGE_HU, "Pillanatkp betltse" },
/* it */ { IDS_LOAD_SNAPSHOT_IMAGE_IT, "Carica immagine snapshot" },
/* ko */ { IDS_LOAD_SNAPSHOT_IMAGE_KO, " ̹ ҷ" },
/* nl */ { IDS_LOAD_SNAPSHOT_IMAGE_NL, "Laad momentopnamebestand" },
/* pl */ { IDS_LOAD_SNAPSHOT_IMAGE_PL, "Wczytaj obraz zrzutu" },
/* ru */ { IDS_LOAD_SNAPSHOT_IMAGE_RU, " " },
/* sv */ { IDS_LOAD_SNAPSHOT_IMAGE_SV, "Lser in gonblicksbild" },
/* tr */ { IDS_LOAD_SNAPSHOT_IMAGE_TR, "Anlk grnt imajn ykle" },

/* en */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS,    "Save currently attached disk images" },
/* da */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_DA, "Gem tilsluttede disk-images" },
/* de */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_DE, "Aktuell eingelegte Diskimages speichern" },
/* es */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_ES, "Grabar imgenes de disco actualmente insertados" },
/* fr */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_FR, "Sauvegarder les disques prsentement attachs" },
/* hu */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_HU, "A jelenleg csatolt lemezek mentse" },
/* it */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_IT, "Salva immagini dischi attualmente selezionati" },
/* ko */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_KO, " پִ ũ ̹ " },
/* nl */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_NL, "Opslaan huidige gekoppelde schijfbestanden" },
/* pl */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_PL, "Zapisz zaontowane obrazy dyskietek" },
/* ru */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_RU, "   " },
/* sv */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_SV, "Spara anslutna diskettavbildningar" },
/* tr */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_TR, "Halihazrda yerletirilmi disk imajlarn kaydet" },

/* en */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS,    "Save currently loaded ROM images" },
/* da */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_DA, "Gem tilsluttede ROM-images" },
/* de */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_DE, "Aktuelle ROMs speichern" },
/* es */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_ES, "Grabar imgenes ROM actualmente cargadas" },
/* fr */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_FR, "Sauvegarder les images ROM prsentement chargs" },
/* hu */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_HU, "A jelenleg betlttt ROM-ok mentse" },
/* it */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_IT, "Salva immagini ROM attualmente caricate" },
/* ko */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_KO, " ҷ  ROM ̹ " },
/* nl */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_NL, "Opslaan huidig gekoppelde ROMs" },
/* pl */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_PL, "Zapisz wczytane obrazy ROM-w" },
/* ru */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_RU, "  ROM " },
/* sv */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_SV, "Spara inlsta ROM-avbildningar" },
/* tr */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_TR, "Halihazrda yklenmi ROM imajlarn kaydet" },

/* en */ { IDS_CANNOT_WRITE_SNAPSHOT_S,    "Cannot write snapshot file `%s'." },
/* da */ { IDS_CANNOT_WRITE_SNAPSHOT_S_DA, "Kunne ikke gemme snapshot \"%s\"." },
/* de */ { IDS_CANNOT_WRITE_SNAPSHOT_S_DE, "Kann Snapshot Datei `%s' nicht speichern." },
/* es */ { IDS_CANNOT_WRITE_SNAPSHOT_S_ES, "No puedo grabar Instantnea `%s'." },
/* fr */ { IDS_CANNOT_WRITE_SNAPSHOT_S_FR, "Impossible d'crire le fichier d'instantan `%s'." },
/* hu */ { IDS_CANNOT_WRITE_SNAPSHOT_S_HU, "Nem sikerlt a pillanatkp rsa %s fjlba." },
/* it */ { IDS_CANNOT_WRITE_SNAPSHOT_S_IT, "Non  possibile scrivere il file di snapshot `%s'." },
/* ko */ { IDS_CANNOT_WRITE_SNAPSHOT_S_KO, "  `%s'   ϴ." },
/* nl */ { IDS_CANNOT_WRITE_SNAPSHOT_S_NL, "Kan momentopnamebestand `%s' niet schrijven." },
/* pl */ { IDS_CANNOT_WRITE_SNAPSHOT_S_PL, "Nie mona zapisa pliku zrzutu '%s'" },
/* ru */ { IDS_CANNOT_WRITE_SNAPSHOT_S_RU, "Cannot write snapshot file `%s'." },
/* sv */ { IDS_CANNOT_WRITE_SNAPSHOT_S_SV, "Kan inte skriva gonblicksbildfil \"%s\"." },
/* tr */ { IDS_CANNOT_WRITE_SNAPSHOT_S_TR, "Anlk grnt dosyas yazlamad `%s'." },

/* en */ { IDS_CANNOT_READ_SNAPSHOT_IMG,    "Cannot read snapshot image" },
/* da */ { IDS_CANNOT_READ_SNAPSHOT_IMG_DA, "Kunne ikke indlse snapshot fil" },
/* de */ { IDS_CANNOT_READ_SNAPSHOT_IMG_DE, "Kann Snapshot Datei nicht laden" },
/* es */ { IDS_CANNOT_READ_SNAPSHOT_IMG_ES, "No puedo leer Instantnea" },
/* fr */ { IDS_CANNOT_READ_SNAPSHOT_IMG_FR, "Impossible de charger l'instantan." },
/* hu */ { IDS_CANNOT_READ_SNAPSHOT_IMG_HU, "A pillanatkp fjl nem olvashat" },
/* it */ { IDS_CANNOT_READ_SNAPSHOT_IMG_IT, "Non  possibile leggere l'immagine dello snapshot" },
/* ko */ { IDS_CANNOT_READ_SNAPSHOT_IMG_KO, "Ǽ   ϴ" },
/* nl */ { IDS_CANNOT_READ_SNAPSHOT_IMG_NL, "Kan momentopnamebestand niet lezen" },
/* pl */ { IDS_CANNOT_READ_SNAPSHOT_IMG_PL, "Nie mona wczyta obrazu zrzutu" },
/* ru */ { IDS_CANNOT_READ_SNAPSHOT_IMG_RU, "    " },
/* sv */ { IDS_CANNOT_READ_SNAPSHOT_IMG_SV, "Kan inte lsa in gonblicksbildfil" },
/* tr */ { IDS_CANNOT_READ_SNAPSHOT_IMG_TR, "Anlk grnt dosyas okunamad." },

/* en */ { IDS_SNAPSHOT_FILE,    "snapshot file" },
/* da */ { IDS_SNAPSHOT_FILE_DA, "snapshot-fil" },
/* de */ { IDS_SNAPSHOT_FILE_DE, "Snapshot Datei" },
/* es */ { IDS_SNAPSHOT_FILE_ES, "Fichero Instantnea" },
/* fr */ { IDS_SNAPSHOT_FILE_FR, "Fichier de sauvegarde" },
/* hu */ { IDS_SNAPSHOT_FILE_HU, "pillanatkp fjl" },
/* it */ { IDS_SNAPSHOT_FILE_IT, "File snapshot" },
/* ko */ { IDS_SNAPSHOT_FILE_KO, "" },  /* fuzzy */
/* nl */ { IDS_SNAPSHOT_FILE_NL, "momentopnamebestand" },
/* pl */ { IDS_SNAPSHOT_FILE_PL, "plik zrzutu" },
/* ru */ { IDS_SNAPSHOT_FILE_RU, "snapshot file" },
/* sv */ { IDS_SNAPSHOT_FILE_SV, "gonblicksbildfil" },
/* tr */ { IDS_SNAPSHOT_FILE_TR, "Anlk grnt dosyas" },

/* en */ { IDS_SELECT_SNAPSHOT_FILE,    "Select snapshot file" },
/* da */ { IDS_SELECT_SNAPSHOT_FILE_DA, "Vlg snapshot-fil" },
/* de */ { IDS_SELECT_SNAPSHOT_FILE_DE, "Snapshot Datei whlen" },
/* es */ { IDS_SELECT_SNAPSHOT_FILE_ES, "Seleccionar fichero Instantnea" },
/* fr */ { IDS_SELECT_SNAPSHOT_FILE_FR, "Slectionner le fichier de sauvegarde" },
/* hu */ { IDS_SELECT_SNAPSHOT_FILE_HU, "Vlasszon pillanatkp fjlt" },
/* it */ { IDS_SELECT_SNAPSHOT_FILE_IT, "Seleziona file snapshot" },
/* ko */ { IDS_SELECT_SNAPSHOT_FILE_KO, "" },  /* fuzzy */
/* nl */ { IDS_SELECT_SNAPSHOT_FILE_NL, "Selecteer momentopnamebestand" },
/* pl */ { IDS_SELECT_SNAPSHOT_FILE_PL, "Wybierz plik zrzutu" },
/* ru */ { IDS_SELECT_SNAPSHOT_FILE_RU, "Select snapshot file" },
/* sv */ { IDS_SELECT_SNAPSHOT_FILE_SV, "Vlj gonblicksbildfil" },
/* tr */ { IDS_SELECT_SNAPSHOT_FILE_TR, "Anlk grnt dosyas sein" },

/* en */ { IDS_CRT_EMULATION,    "CRT emulation" },
/* da */ { IDS_CRT_EMULATION_DA, "CRT-emulering" },
/* de */ { IDS_CRT_EMULATION_DE, "CRT Emulation" },
/* es */ { IDS_CRT_EMULATION_ES, "Emulacin CRT" },
/* fr */ { IDS_CRT_EMULATION_FR, "mulation CRT" },
/* hu */ { IDS_CRT_EMULATION_HU, "" },  /* fuzzy */
/* it */ { IDS_CRT_EMULATION_IT, "Emulazione CRT" },
/* ko */ { IDS_CRT_EMULATION_KO, "  ͹̳ ķ" },
/* nl */ { IDS_CRT_EMULATION_NL, "CRT emulatie" },
/* pl */ { IDS_CRT_EMULATION_PL, "Emulacja CRT" },
/* ru */ { IDS_CRT_EMULATION_RU, "" },  /* fuzzy */
/* sv */ { IDS_CRT_EMULATION_SV, "CRT-emulering" },
/* tr */ { IDS_CRT_EMULATION_TR, "CRT emlasyonu" },

/* en */ { IDS_SCALE2X,    "Scale2x" },
/* da */ { IDS_SCALE2X_DA, "Scale2x" },
/* de */ { IDS_SCALE2X_DE, "Scale2x" },
/* es */ { IDS_SCALE2X_ES, "Scale2x" },
/* fr */ { IDS_SCALE2X_FR, "Scale2x" },
/* hu */ { IDS_SCALE2X_HU, "lsimts" },
/* it */ { IDS_SCALE2X_IT, "Scale2x" },
/* ko */ { IDS_SCALE2X_KO, "Scale2x" },
/* nl */ { IDS_SCALE2X_NL, "Scale2x" },
/* pl */ { IDS_SCALE2X_PL, "Scale2x" },
/* ru */ { IDS_SCALE2X_RU, "Scale2x" },
/* sv */ { IDS_SCALE2X_SV, "Scale2x" },
/* tr */ { IDS_SCALE2X_TR, "Scale2x" },

/* en */ { IDS_RENDER_FILTER,    "Render filter" },
/* da */ { IDS_RENDER_FILTER_DA, "Renderingsfilter" },
/* de */ { IDS_RENDER_FILTER_DE, "Render Filter" },
/* es */ { IDS_RENDER_FILTER_ES, "Filtro de renderizado" },
/* fr */ { IDS_RENDER_FILTER_FR, "Filtre de rendu" },
/* hu */ { IDS_RENDER_FILTER_HU, "" },  /* fuzzy */
/* it */ { IDS_RENDER_FILTER_IT, "Filtro di render" },
/* ko */ { IDS_RENDER_FILTER_KO, " " },
/* nl */ { IDS_RENDER_FILTER_NL, "Render filter" },
/* pl */ { IDS_RENDER_FILTER_PL, "Filtr renderera" },
/* ru */ { IDS_RENDER_FILTER_RU, "Render filter" },
/* sv */ { IDS_RENDER_FILTER_SV, "Rendrerarfilter" },
/* tr */ { IDS_RENDER_FILTER_TR, "mge oluturma filtresi" },

/* en */ { IDS_EXTERNAL_PALETTE_SELECT,    "Select External Palette file" },
/* da */ { IDS_EXTERNAL_PALETTE_SELECT_DA, "Brug ekstern palette-fil" },
/* de */ { IDS_EXTERNAL_PALETTE_SELECT_DE, "Benutze externe Palette (Datei)" },
/* es */ { IDS_EXTERNAL_PALETTE_SELECT_ES, "Seleccionar fichero paleta externa" },
/* fr */ { IDS_EXTERNAL_PALETTE_SELECT_FR, "Utiliser une palette externe (fichier)" },
/* hu */ { IDS_EXTERNAL_PALETTE_SELECT_HU, "Vlasszon kls paletta fjlt" },
/* it */ { IDS_EXTERNAL_PALETTE_SELECT_IT, "Seleziona file palette esterna" },
/* ko */ { IDS_EXTERNAL_PALETTE_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_EXTERNAL_PALETTE_SELECT_NL, "Selecteer extern paletbestand" },
/* pl */ { IDS_EXTERNAL_PALETTE_SELECT_PL, "Wybierz plik zewntrznej palety kolorw" },
/* ru */ { IDS_EXTERNAL_PALETTE_SELECT_RU, "Select External Palette file" },
/* sv */ { IDS_EXTERNAL_PALETTE_SELECT_SV, "Anvnd en extern palett (fil)" },
/* tr */ { IDS_EXTERNAL_PALETTE_SELECT_TR, "Harici Palet dosyas sein" },

/* en */ { IDS_GAMMA_0_4,    "Gamma (0..4)" },
/* da */ { IDS_GAMMA_0_4_DA, "Gamma (0..4)" },
/* de */ { IDS_GAMMA_0_4_DE, "Gamma (0..4)" },
/* es */ { IDS_GAMMA_0_4_ES, "Gamma (0..4)" },
/* fr */ { IDS_GAMMA_0_4_FR, "Intensit (0..4)" },
/* hu */ { IDS_GAMMA_0_4_HU, "Gamma (0..4)" },
/* it */ { IDS_GAMMA_0_4_IT, "Gamma (0..4)" },
/* ko */ { IDS_GAMMA_0_4_KO, " (0..4)" },
/* nl */ { IDS_GAMMA_0_4_NL, "Gamma (0..4)" },
/* pl */ { IDS_GAMMA_0_4_PL, "Gamma (0..4)" },
/* ru */ { IDS_GAMMA_0_4_RU, "Gamma (0..4)" },
/* sv */ { IDS_GAMMA_0_4_SV, "Gamma (0..4)" },
/* tr */ { IDS_GAMMA_0_4_TR, "Gama (0..4)" },

/* en */ { IDS_SCANLINE_SHADE_0_1,    "Scanline shade (0..1)" },
/* da */ { IDS_SCANLINE_SHADE_0_1_DA, "Skanlinjeskygge (0..1)" },
/* de */ { IDS_SCANLINE_SHADE_0_1_DE, "Scanline Schatten (0..1)" },
/* es */ { IDS_SCANLINE_SHADE_0_1_ES, "Sombra linea de escaneo (0..1)" },
/* fr */ { IDS_SCANLINE_SHADE_0_1_FR, "Ombrage des lignes de balayage (0..1)" },
/* hu */ { IDS_SCANLINE_SHADE_0_1_HU, "" },  /* fuzzy */
/* it */ { IDS_SCANLINE_SHADE_0_1_IT, "Ombra scanline (0..1)" },
/* ko */ { IDS_SCANLINE_SHADE_0_1_KO, "ֻ缱  (0..1)" },
/* nl */ { IDS_SCANLINE_SHADE_0_1_NL, "Scanlijnschaduw (0..1)" },
/* pl */ { IDS_SCANLINE_SHADE_0_1_PL, "Cieniowane scanline (0..1)" },
/* ru */ { IDS_SCANLINE_SHADE_0_1_RU, "Scanline shade (0..1)" },
/* sv */ { IDS_SCANLINE_SHADE_0_1_SV, "Skuggning av skannlinjer (0..1)" },
/* tr */ { IDS_SCANLINE_SHADE_0_1_TR, "Tarama satr nans (0..1)" },

/* en */ { IDS_BLUR_0_1,    "Blur (0..1)" },
/* da */ { IDS_BLUR_0_1_DA, "Udtvring (0..1)" },
/* de */ { IDS_BLUR_0_1_DE, "Unschrfe (0..1)" },
/* es */ { IDS_BLUR_0_1_ES, "Blur (0..1)" },
/* fr */ { IDS_BLUR_0_1_FR, "Flou (0..1)" },
/* hu */ { IDS_BLUR_0_1_HU, "" },  /* fuzzy */
/* it */ { IDS_BLUR_0_1_IT, "Sfuocatura (0..1)" },
/* ko */ { IDS_BLUR_0_1_KO, "帴 (0..1)" },
/* nl */ { IDS_BLUR_0_1_NL, "Wazigheid (0..1)" },
/* pl */ { IDS_BLUR_0_1_PL, "Rozmycie (0..1)" },
/* ru */ { IDS_BLUR_0_1_RU, "Blur (0..1)" },
/* sv */ { IDS_BLUR_0_1_SV, "Suddighet (0..1)" },
/* tr */ { IDS_BLUR_0_1_TR, "Bulanklk (0..1)" },

/* en */ { IDS_TINT_0_2,    "Tint (0..2)" },
/* da */ { IDS_TINT_0_2_DA, "Farvetone (0..2)" },
/* de */ { IDS_TINT_0_2_DE, "Farbton (0..2)" },
/* es */ { IDS_TINT_0_2_ES, "Matiz (0..2)" },
/* fr */ { IDS_TINT_0_2_FR, "Teinte (0..2)" },
/* hu */ { IDS_TINT_0_2_HU, "Szn (0..2)" },
/* it */ { IDS_TINT_0_2_IT, "Sfumatura (0..2)" },
/* ko */ { IDS_TINT_0_2_KO, "ƾƮ (0..2)" },
/* nl */ { IDS_TINT_0_2_NL, "Tint (0..2)" },
/* pl */ { IDS_TINT_0_2_PL, "Odcie (0..2)" },
/* ru */ { IDS_TINT_0_2_RU, " (0..2)" },
/* sv */ { IDS_TINT_0_2_SV, "Frgton (0..2)" },
/* tr */ { IDS_TINT_0_2_TR, "Ton (0..2)" },

/* en */ { IDS_ODDLINE_PHASE_0_2,    "Odd lines phase (0..2)" },
/* da */ { IDS_ODDLINE_PHASE_0_2_DA, "Fase for ulige linjer (0..2)" },
/* de */ { IDS_ODDLINE_PHASE_0_2_DE, "Ungerade Zeilenphase (0..2)" },
/* es */ { IDS_ODDLINE_PHASE_0_2_ES, "Lineas fase impar (0..2)" },
/* fr */ { IDS_ODDLINE_PHASE_0_2_FR, "Phase lignes impaires (0..2)" },
/* hu */ { IDS_ODDLINE_PHASE_0_2_HU, "" },  /* fuzzy */
/* it */ { IDS_ODDLINE_PHASE_0_2_IT, "Fase linee dispari (0..2)" },
/* ko */ { IDS_ODDLINE_PHASE_0_2_KO, "" },  /* fuzzy */
/* nl */ { IDS_ODDLINE_PHASE_0_2_NL, "Oneven lijnen fase (0..2)" },
/* pl */ { IDS_ODDLINE_PHASE_0_2_PL, "Faza linii nieparzystych (0..2)" },
/* ru */ { IDS_ODDLINE_PHASE_0_2_RU, "Odd lines phase (0..2)" },
/* sv */ { IDS_ODDLINE_PHASE_0_2_SV, "Fas fr udda linjer (0..2)" },
/* tr */ { IDS_ODDLINE_PHASE_0_2_TR, "Tek satr faz (0..2)" },

/* en */ { IDS_ODDLINE_OFFSET_0_2,    "Odd lines offset (0..2)" },
/* da */ { IDS_ODDLINE_OFFSET_0_2_DA, "Offset for ulige linjer (0..2)" },
/* de */ { IDS_ODDLINE_OFFSET_0_2_DE, "Ungerader Zeilenoffset (0..2)" },
/* es */ { IDS_ODDLINE_OFFSET_0_2_ES, "Offset lineas impares (0..2)" },
/* fr */ { IDS_ODDLINE_OFFSET_0_2_FR, "Dcalage lignes impaires (0..2)" },
/* hu */ { IDS_ODDLINE_OFFSET_0_2_HU, "" },  /* fuzzy */
/* it */ { IDS_ODDLINE_OFFSET_0_2_IT, "Offset linee dispari (0..2)" },
/* ko */ { IDS_ODDLINE_OFFSET_0_2_KO, "Ȧ   (0..2)" },
/* nl */ { IDS_ODDLINE_OFFSET_0_2_NL, "Oneven lijnen compensatie (0..2)" },
/* pl */ { IDS_ODDLINE_OFFSET_0_2_PL, "Wyrwnanie linii nieparzystych (0..2)" },
/* ru */ { IDS_ODDLINE_OFFSET_0_2_RU, "Odd lines offset (0..2)" },
/* sv */ { IDS_ODDLINE_OFFSET_0_2_SV, "Utjmning fr udda linjer (0..2)" },
/* tr */ { IDS_ODDLINE_OFFSET_0_2_TR, "Tek satr ofseti (0..2)" },

/* en */ { IDS_VICII_EXTERNAL_PALETTE,    "External VICII palette" },
/* da */ { IDS_VICII_EXTERNAL_PALETTE_DA, "Ekstern VICII palette" },
/* de */ { IDS_VICII_EXTERNAL_PALETTE_DE, "Externe VICII Palette" },
/* es */ { IDS_VICII_EXTERNAL_PALETTE_ES, "Paleta VICII externa" },
/* fr */ { IDS_VICII_EXTERNAL_PALETTE_FR, "Palette externe VICII" },
/* hu */ { IDS_VICII_EXTERNAL_PALETTE_HU, "" },  /* fuzzy */
/* it */ { IDS_VICII_EXTERNAL_PALETTE_IT, "Palette VICII esterna" },
/* ko */ { IDS_VICII_EXTERNAL_PALETTE_KO, "" },  /* fuzzy */
/* nl */ { IDS_VICII_EXTERNAL_PALETTE_NL, "Extern VICII palet" },
/* pl */ { IDS_VICII_EXTERNAL_PALETTE_PL, "Zewntrzna paleta VICII" },
/* ru */ { IDS_VICII_EXTERNAL_PALETTE_RU, "External VICII palette" },
/* sv */ { IDS_VICII_EXTERNAL_PALETTE_SV, "Extern VICII-palett" },
/* tr */ { IDS_VICII_EXTERNAL_PALETTE_TR, "Harici VICII paleti" },

/* en */ { IDS_VIC_EXTERNAL_PALETTE,    "External VIC palette" },
/* da */ { IDS_VIC_EXTERNAL_PALETTE_DA, "Ekstern VIC palette" },
/* de */ { IDS_VIC_EXTERNAL_PALETTE_DE, "Externe VIC Palette" },
/* es */ { IDS_VIC_EXTERNAL_PALETTE_ES, "Paleta VIC externa" },
/* fr */ { IDS_VIC_EXTERNAL_PALETTE_FR, "Palette externe VIC" },
/* hu */ { IDS_VIC_EXTERNAL_PALETTE_HU, "" },  /* fuzzy */
/* it */ { IDS_VIC_EXTERNAL_PALETTE_IT, "Palette VIC esterna" },
/* ko */ { IDS_VIC_EXTERNAL_PALETTE_KO, "" },  /* fuzzy */
/* nl */ { IDS_VIC_EXTERNAL_PALETTE_NL, "Extern VIC palet" },
/* pl */ { IDS_VIC_EXTERNAL_PALETTE_PL, "Zewntrzna paleta VIC" },
/* ru */ { IDS_VIC_EXTERNAL_PALETTE_RU, "External VIC palette" },
/* sv */ { IDS_VIC_EXTERNAL_PALETTE_SV, "Extern VIC-palett" },
/* tr */ { IDS_VIC_EXTERNAL_PALETTE_TR, "Harici VIC paleti" },

/* en */ { IDS_TED_EXTERNAL_PALETTE,    "External TED palette" },
/* da */ { IDS_TED_EXTERNAL_PALETTE_DA, "Ekstern TED palette" },
/* de */ { IDS_TED_EXTERNAL_PALETTE_DE, "Externe TED Palette" },
/* es */ { IDS_TED_EXTERNAL_PALETTE_ES, "Paleta TED externa" },
/* fr */ { IDS_TED_EXTERNAL_PALETTE_FR, "Palette externe TED" },
/* hu */ { IDS_TED_EXTERNAL_PALETTE_HU, "" },  /* fuzzy */
/* it */ { IDS_TED_EXTERNAL_PALETTE_IT, "Palette TED esterna" },
/* ko */ { IDS_TED_EXTERNAL_PALETTE_KO, "" },  /* fuzzy */
/* nl */ { IDS_TED_EXTERNAL_PALETTE_NL, "Extern TED palet" },
/* pl */ { IDS_TED_EXTERNAL_PALETTE_PL, "Zewntrzna paleta TED" },
/* ru */ { IDS_TED_EXTERNAL_PALETTE_RU, "External TED palette" },
/* sv */ { IDS_TED_EXTERNAL_PALETTE_SV, "Extern TED-palett" },
/* tr */ { IDS_TED_EXTERNAL_PALETTE_TR, "Harici TED paleti" },

/* en */ { IDS_VDC_EXTERNAL_PALETTE,    "External VDC palette" },
/* da */ { IDS_VDC_EXTERNAL_PALETTE_DA, "Ekstern VDC palette" },
/* de */ { IDS_VDC_EXTERNAL_PALETTE_DE, "Externe VDC Palette" },
/* es */ { IDS_VDC_EXTERNAL_PALETTE_ES, "Paleta VDC externa" },
/* fr */ { IDS_VDC_EXTERNAL_PALETTE_FR, "Palette externe VDC" },
/* hu */ { IDS_VDC_EXTERNAL_PALETTE_HU, "" },  /* fuzzy */
/* it */ { IDS_VDC_EXTERNAL_PALETTE_IT, "Palette VDC esterna" },
/* ko */ { IDS_VDC_EXTERNAL_PALETTE_KO, "" },  /* fuzzy */
/* nl */ { IDS_VDC_EXTERNAL_PALETTE_NL, "Extern VDC palet" },
/* pl */ { IDS_VDC_EXTERNAL_PALETTE_PL, "Zewntrzna paleta VDC" },
/* ru */ { IDS_VDC_EXTERNAL_PALETTE_RU, "External VDC palette" },
/* sv */ { IDS_VDC_EXTERNAL_PALETTE_SV, "Extern VDC-palett" },
/* tr */ { IDS_VDC_EXTERNAL_PALETTE_TR, "Harici VDC paleti" },

/* en */ { IDS_CRTC_EXTERNAL_PALETTE,    "External CRTC palette" },
/* da */ { IDS_CRTC_EXTERNAL_PALETTE_DA, "Ekstern CRTC palette" },
/* de */ { IDS_CRTC_EXTERNAL_PALETTE_DE, "Externe CRTC Palette" },
/* es */ { IDS_CRTC_EXTERNAL_PALETTE_ES, "Paleta CRT externa" },
/* fr */ { IDS_CRTC_EXTERNAL_PALETTE_FR, "Palette externe CRTC" },
/* hu */ { IDS_CRTC_EXTERNAL_PALETTE_HU, "" },  /* fuzzy */
/* it */ { IDS_CRTC_EXTERNAL_PALETTE_IT, "Palette CRTC esterna" },
/* ko */ { IDS_CRTC_EXTERNAL_PALETTE_KO, "" },  /* fuzzy */
/* nl */ { IDS_CRTC_EXTERNAL_PALETTE_NL, "Extern CRTC palet" },
/* pl */ { IDS_CRTC_EXTERNAL_PALETTE_PL, "Zewntrzna paleta CRTC" },
/* ru */ { IDS_CRTC_EXTERNAL_PALETTE_RU, "External CRTC palette" },
/* sv */ { IDS_CRTC_EXTERNAL_PALETTE_SV, "Extern CRTC-palett" },
/* tr */ { IDS_CRTC_EXTERNAL_PALETTE_TR, "Harici CRTC paleti" },

/* en */ { IDS_VICII_PALETTE_NAME,    "VICII palette file" },
/* da */ { IDS_VICII_PALETTE_NAME_DA, "VICII-palettefil" },
/* de */ { IDS_VICII_PALETTE_NAME_DE, "VICII Paletten Datei" },
/* es */ { IDS_VICII_PALETTE_NAME_ES, "Fichero paleta VICII" },
/* fr */ { IDS_VICII_PALETTE_NAME_FR, "Fichier de palette VICII" },
/* hu */ { IDS_VICII_PALETTE_NAME_HU, "" },  /* fuzzy */
/* it */ { IDS_VICII_PALETTE_NAME_IT, "File palette VICII" },
/* ko */ { IDS_VICII_PALETTE_NAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_VICII_PALETTE_NAME_NL, "VICII palet bestand" },
/* pl */ { IDS_VICII_PALETTE_NAME_PL, "Plik palety VICII" },
/* ru */ { IDS_VICII_PALETTE_NAME_RU, "" },  /* fuzzy */
/* sv */ { IDS_VICII_PALETTE_NAME_SV, "VICII-palettfil" },
/* tr */ { IDS_VICII_PALETTE_NAME_TR, "VICII palet dosyas" },

/* en */ { IDS_VIC_PALETTE_NAME,    "VIC palette file" },
/* da */ { IDS_VIC_PALETTE_NAME_DA, "VIC-palettefil" },
/* de */ { IDS_VIC_PALETTE_NAME_DE, "VIC Paletten Datei" },
/* es */ { IDS_VIC_PALETTE_NAME_ES, "Fichero paleta VIC" },
/* fr */ { IDS_VIC_PALETTE_NAME_FR, "Fichier de palette VIC" },
/* hu */ { IDS_VIC_PALETTE_NAME_HU, "" },  /* fuzzy */
/* it */ { IDS_VIC_PALETTE_NAME_IT, "File palette VIC" },
/* ko */ { IDS_VIC_PALETTE_NAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_VIC_PALETTE_NAME_NL, "VIC palet bestand" },
/* pl */ { IDS_VIC_PALETTE_NAME_PL, "Plik palety VIC" },
/* ru */ { IDS_VIC_PALETTE_NAME_RU, "" },  /* fuzzy */
/* sv */ { IDS_VIC_PALETTE_NAME_SV, "VIC-palettfil" },
/* tr */ { IDS_VIC_PALETTE_NAME_TR, "VIC palet dosyas" },

/* en */ { IDS_TED_PALETTE_NAME,    "TED palette file" },
/* da */ { IDS_TED_PALETTE_NAME_DA, "TED-palettefil" },
/* de */ { IDS_TED_PALETTE_NAME_DE, "TED Paletten Datei" },
/* es */ { IDS_TED_PALETTE_NAME_ES, "Fichero paleta TED" },
/* fr */ { IDS_TED_PALETTE_NAME_FR, "Fichier de palette TED" },
/* hu */ { IDS_TED_PALETTE_NAME_HU, "" },  /* fuzzy */
/* it */ { IDS_TED_PALETTE_NAME_IT, "File palette TED" },
/* ko */ { IDS_TED_PALETTE_NAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_TED_PALETTE_NAME_NL, "TED palet bestand" },
/* pl */ { IDS_TED_PALETTE_NAME_PL, "Plik palety TED" },
/* ru */ { IDS_TED_PALETTE_NAME_RU, "TED palette file" },
/* sv */ { IDS_TED_PALETTE_NAME_SV, "TED-palettfil" },
/* tr */ { IDS_TED_PALETTE_NAME_TR, "TED palet dosyas" },

/* en */ { IDS_VDC_PALETTE_NAME,    "VDC palette file" },
/* da */ { IDS_VDC_PALETTE_NAME_DA, "VDC-palettefil" },
/* de */ { IDS_VDC_PALETTE_NAME_DE, "VDC Paletten Datei" },
/* es */ { IDS_VDC_PALETTE_NAME_ES, "Fichero paleta VDC" },
/* fr */ { IDS_VDC_PALETTE_NAME_FR, "Fichier de palette VDC" },
/* hu */ { IDS_VDC_PALETTE_NAME_HU, "" },  /* fuzzy */
/* it */ { IDS_VDC_PALETTE_NAME_IT, "File palette VDC" },
/* ko */ { IDS_VDC_PALETTE_NAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_VDC_PALETTE_NAME_NL, "VDC palet bestand" },
/* pl */ { IDS_VDC_PALETTE_NAME_PL, "Plik palety VDC" },
/* ru */ { IDS_VDC_PALETTE_NAME_RU, "" },  /* fuzzy */
/* sv */ { IDS_VDC_PALETTE_NAME_SV, "VDC-palettfil" },
/* tr */ { IDS_VDC_PALETTE_NAME_TR, "VDC palet dosyas" },

/* en */ { IDS_CRTC_PALETTE_NAME,    "CRTC palette file" },
/* da */ { IDS_CRTC_PALETTE_NAME_DA, "CRTC-palettefil" },
/* de */ { IDS_CRTC_PALETTE_NAME_DE, "CRTC Paletten Datei" },
/* es */ { IDS_CRTC_PALETTE_NAME_ES, "Fichero paleta CRT" },
/* fr */ { IDS_CRTC_PALETTE_NAME_FR, "Fichier de palette CTRC" },
/* hu */ { IDS_CRTC_PALETTE_NAME_HU, "" },  /* fuzzy */
/* it */ { IDS_CRTC_PALETTE_NAME_IT, "File palette CRTC" },
/* ko */ { IDS_CRTC_PALETTE_NAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_CRTC_PALETTE_NAME_NL, "CRTC palet bestand" },
/* pl */ { IDS_CRTC_PALETTE_NAME_PL, "Plik palety CRTC" },
/* ru */ { IDS_CRTC_PALETTE_NAME_RU, "" },  /* fuzzy */
/* sv */ { IDS_CRTC_PALETTE_NAME_SV, "CRTC-palettfil" },
/* tr */ { IDS_CRTC_PALETTE_NAME_TR, "CRTC palet dosyas" },

/* en */ { IDS_SATURATION_0_2,    "Saturation (0..2)" },
/* da */ { IDS_SATURATION_0_2_DA, "Mtning (0..2)" },
/* de */ { IDS_SATURATION_0_2_DE, "Sttigung (0..2)" },
/* es */ { IDS_SATURATION_0_2_ES, "Saturacion (0..2)" },
/* fr */ { IDS_SATURATION_0_2_FR, "Saturation (0..2)" },
/* hu */ { IDS_SATURATION_0_2_HU, "Teltettsg (0..2)" },
/* it */ { IDS_SATURATION_0_2_IT, "Saturazione (0..2)" },
/* ko */ { IDS_SATURATION_0_2_KO, "ȭ (0..2)" },
/* nl */ { IDS_SATURATION_0_2_NL, "Verzadiging (0..2)" },
/* pl */ { IDS_SATURATION_0_2_PL, "Nasycenie (0..2)" },
/* ru */ { IDS_SATURATION_0_2_RU, "Saturation (0..2)" },
/* sv */ { IDS_SATURATION_0_2_SV, "Mttnad (0..2)" },
/* tr */ { IDS_SATURATION_0_2_TR, "Doygunluk (0..2)" },

/* en */ { IDS_CONTRAST_0_2,    "Contrast (0..2)" },
/* da */ { IDS_CONTRAST_0_2_DA, "Kontrast (0..2)" },
/* de */ { IDS_CONTRAST_0_2_DE, "Kontrast (0..2)" },
/* es */ { IDS_CONTRAST_0_2_ES, "Contraste (0..2)" },
/* fr */ { IDS_CONTRAST_0_2_FR, "Contraste (0..2)" },
/* hu */ { IDS_CONTRAST_0_2_HU, "Kontraszt (0..2)" },
/* it */ { IDS_CONTRAST_0_2_IT, "Contrasto (0..2)" },
/* ko */ { IDS_CONTRAST_0_2_KO, " (0..2)" },
/* nl */ { IDS_CONTRAST_0_2_NL, "Contrast (0..2)" },
/* pl */ { IDS_CONTRAST_0_2_PL, "Kontrast (0..2)" },
/* ru */ { IDS_CONTRAST_0_2_RU, " (0..2)" },
/* sv */ { IDS_CONTRAST_0_2_SV, "Kontrast (0..2)" },
/* tr */ { IDS_CONTRAST_0_2_TR, "Kartlk (0..2)" },

/* en */ { IDS_BRIGHTNESS_0_2,    "Brightness (0..2)" },
/* da */ { IDS_BRIGHTNESS_0_2_DA, "Lysstyrke (0..2)" },
/* de */ { IDS_BRIGHTNESS_0_2_DE, "Helligkeit (0..2)" },
/* es */ { IDS_BRIGHTNESS_0_2_ES, "Brillo (0..2)" },
/* fr */ { IDS_BRIGHTNESS_0_2_FR, "Luminosit (0..2)" },
/* hu */ { IDS_BRIGHTNESS_0_2_HU, "Fnyessg (0..2)" },
/* it */ { IDS_BRIGHTNESS_0_2_IT, "Luminosit (0..2)" },
/* ko */ { IDS_BRIGHTNESS_0_2_KO, " (0..2)" },
/* nl */ { IDS_BRIGHTNESS_0_2_NL, "Helderheid (0..2)" },
/* pl */ { IDS_BRIGHTNESS_0_2_PL, "Jasno (0..2)" },
/* ru */ { IDS_BRIGHTNESS_0_2_RU, " (0..2)" },
/* sv */ { IDS_BRIGHTNESS_0_2_SV, "Ljusstyrka (0..2)" },
/* tr */ { IDS_BRIGHTNESS_0_2_TR, "Parlaklk (0..2)" },

/* en */ { IDS_VIDEO_SETTINGS,    "Video settings" },
/* da */ { IDS_VIDEO_SETTINGS_DA, "Grafikindstillinger" },
/* de */ { IDS_VIDEO_SETTINGS_DE, "Video Einstellungen" },
/* es */ { IDS_VIDEO_SETTINGS_ES, "Ajustes de video" },
/* fr */ { IDS_VIDEO_SETTINGS_FR, "Paramtres vido" },
/* hu */ { IDS_VIDEO_SETTINGS_HU, "Vide belltsai" },
/* it */ { IDS_VIDEO_SETTINGS_IT, "Impostazioni video" },
/* ko */ { IDS_VIDEO_SETTINGS_KO, " " },
/* nl */ { IDS_VIDEO_SETTINGS_NL, "Video instellingen" },
/* pl */ { IDS_VIDEO_SETTINGS_PL, "Ustawienia wideo" },
/* ru */ { IDS_VIDEO_SETTINGS_RU, " " },
/* sv */ { IDS_VIDEO_SETTINGS_SV, "Grafikinstllningar" },
/* tr */ { IDS_VIDEO_SETTINGS_TR, "Grnt ayarlar" },

/* en */ { IDS_AUTO_FROM_ROM,    "Auto (from ROM)" },
/* da */ { IDS_AUTO_FROM_ROM_DA, "Automatisk (fra ROM)" },
/* de */ { IDS_AUTO_FROM_ROM_DE, "Automatisch (von ROM)" },
/* es */ { IDS_AUTO_FROM_ROM_ES, "Auto (desde ROM)" },
/* fr */ { IDS_AUTO_FROM_ROM_FR, "Auto (depuis ROM)" },
/* hu */ { IDS_AUTO_FROM_ROM_HU, "Automatikus (ROM-bl)" },
/* it */ { IDS_AUTO_FROM_ROM_IT, "Auto (dalla ROM)" },
/* ko */ { IDS_AUTO_FROM_ROM_KO, "ڵ (ROM )" },
/* nl */ { IDS_AUTO_FROM_ROM_NL, "Automatisch (van ROM)" },
/* pl */ { IDS_AUTO_FROM_ROM_PL, "Automatycznie (z ROM)" },
/* ru */ { IDS_AUTO_FROM_ROM_RU, "Auto (from ROM)" },
/* sv */ { IDS_AUTO_FROM_ROM_SV, "Automatisk (frn ROM)" },
/* tr */ { IDS_AUTO_FROM_ROM_TR, "Otomatik (ROM'dan)" },

/* en */ { IDS_40_COLUMNS,    "40 Columns" },
/* da */ { IDS_40_COLUMNS_DA, "40 kolonner" },
/* de */ { IDS_40_COLUMNS_DE, "40 Spalten" },
/* es */ { IDS_40_COLUMNS_ES, "40 columnas" },
/* fr */ { IDS_40_COLUMNS_FR, "40 Colonnes" },
/* hu */ { IDS_40_COLUMNS_HU, "40 Oszlop" },
/* it */ { IDS_40_COLUMNS_IT, "40 Colonne" },
/* ko */ { IDS_40_COLUMNS_KO, "40ĭ" },
/* nl */ { IDS_40_COLUMNS_NL, "40 Kolommen" },
/* pl */ { IDS_40_COLUMNS_PL, "40 kolumn" },
/* ru */ { IDS_40_COLUMNS_RU, "40 " },
/* sv */ { IDS_40_COLUMNS_SV, "40 kolumner" },
/* tr */ { IDS_40_COLUMNS_TR, "40 Stun" },

/* en */ { IDS_80_COLUMNS,    "80 Columns" },
/* da */ { IDS_80_COLUMNS_DA, "80 kolonner" },
/* de */ { IDS_80_COLUMNS_DE, "80 Spalten" },
/* es */ { IDS_80_COLUMNS_ES, "80 columnas" },
/* fr */ { IDS_80_COLUMNS_FR, "80 Colonnes" },
/* hu */ { IDS_80_COLUMNS_HU, "80 Oszlop" },
/* it */ { IDS_80_COLUMNS_IT, "80 Colonne" },
/* ko */ { IDS_80_COLUMNS_KO, "80ĭ" },
/* nl */ { IDS_80_COLUMNS_NL, "80 Kolommen" },
/* pl */ { IDS_80_COLUMNS_PL, "80 kolumn" },
/* ru */ { IDS_80_COLUMNS_RU, "80 " },
/* sv */ { IDS_80_COLUMNS_SV, "80 kolumner" },
/* tr */ { IDS_80_COLUMNS_TR, "80 Stun" },

/* en */ { IDS_256_BYTE,    "256 Byte" },
/* da */ { IDS_256_BYTE_DA, "256 byte" },
/* de */ { IDS_256_BYTE_DE, "256 Byte" },
/* es */ { IDS_256_BYTE_ES, "256 Bytes" },
/* fr */ { IDS_256_BYTE_FR, "256 Octets" },
/* hu */ { IDS_256_BYTE_HU, "256 Bjt" },
/* it */ { IDS_256_BYTE_IT, "256 Byte" },
/* ko */ { IDS_256_BYTE_KO, "256 byte" },
/* nl */ { IDS_256_BYTE_NL, "256 Byte" },
/* pl */ { IDS_256_BYTE_PL, "256 bajtw" },
/* ru */ { IDS_256_BYTE_RU, "256 Byte" },
/* sv */ { IDS_256_BYTE_SV, "256 byte" },
/* tr */ { IDS_256_BYTE_TR, "256 Byte" },

/* en */ { IDS_2_KBYTE,    "2 kByte" },
/* da */ { IDS_2_KBYTE_DA, "2 kbyte" },
/* de */ { IDS_2_KBYTE_DE, "2 kByte" },
/* es */ { IDS_2_KBYTE_ES, "2 kBytes" },
/* fr */ { IDS_2_KBYTE_FR, "2 ko" },
/* hu */ { IDS_2_KBYTE_HU, "2 kBjt" },
/* it */ { IDS_2_KBYTE_IT, "2 kByte" },
/* ko */ { IDS_2_KBYTE_KO, "2 kbyte" },
/* nl */ { IDS_2_KBYTE_NL, "2 kByte" },
/* pl */ { IDS_2_KBYTE_PL, "2 kBajty " },
/* ru */ { IDS_2_KBYTE_RU, "2 kByte" },
/* sv */ { IDS_2_KBYTE_SV, "2 kbyte" },
/* tr */ { IDS_2_KBYTE_TR, "2 kByte" },

/* en */ { IDS_GRAPHICS,    "Graphics" },
/* da */ { IDS_GRAPHICS_DA, "Grafisk" },
/* de */ { IDS_GRAPHICS_DE, "Grafik" },
/* es */ { IDS_GRAPHICS_ES, "Grficos" },
/* fr */ { IDS_GRAPHICS_FR, "Graphiques" },
/* hu */ { IDS_GRAPHICS_HU, "Grafikus" },
/* it */ { IDS_GRAPHICS_IT, "Grafica" },
/* ko */ { IDS_GRAPHICS_KO, "׷" },
/* nl */ { IDS_GRAPHICS_NL, "Grafiek" },
/* pl */ { IDS_GRAPHICS_PL, "Grafika" },
/* ru */ { IDS_GRAPHICS_RU, "" },
/* sv */ { IDS_GRAPHICS_SV, "Grafisk" },
/* tr */ { IDS_GRAPHICS_TR, "Grafikler" },

/* en */ { IDS_TEXT,    "Text" },
/* da */ { IDS_TEXT_DA, "Tekst" },
/* de */ { IDS_TEXT_DE, "Text" },
/* es */ { IDS_TEXT_ES, "Texto" },
/* fr */ { IDS_TEXT_FR, "Texte" },
/* hu */ { IDS_TEXT_HU, "" },  /* fuzzy */
/* it */ { IDS_TEXT_IT, "Testo" },
/* ko */ { IDS_TEXT_KO, "ؽƮ" },
/* nl */ { IDS_TEXT_NL, "Tekst" },
/* pl */ { IDS_TEXT_PL, "Tekst" },
/* ru */ { IDS_TEXT_RU, "" },
/* sv */ { IDS_TEXT_SV, "Text" },
/* tr */ { IDS_TEXT_TR, "Metin" },

/* en */ { IDS_BUSINESS_UK,    "Business (UK)" },
/* da */ { IDS_BUSINESS_UK_DA, "Business (Storbritannien)" },
/* de */ { IDS_BUSINESS_UK_DE, "Business (UK)" },
/* es */ { IDS_BUSINESS_UK_ES, "Negocios (UK)" },
/* fr */ { IDS_BUSINESS_UK_FR, "Bureautique (UK)" },
/* hu */ { IDS_BUSINESS_UK_HU, "Hivatalos (UK)" },
/* it */ { IDS_BUSINESS_UK_IT, "Business (UK)" },
/* ko */ { IDS_BUSINESS_UK_KO, "Ͻ(UK)" },
/* nl */ { IDS_BUSINESS_UK_NL, "Zakelijk (UK)" },
/* pl */ { IDS_BUSINESS_UK_PL, "Biznesowa (UK)" },
/* ru */ { IDS_BUSINESS_UK_RU, "Business (UK)" },
/* sv */ { IDS_BUSINESS_UK_SV, "Business (Storbritannien)" },
/* tr */ { IDS_BUSINESS_UK_TR, "Business (UK)" },

/* en */ { IDS_MEMORY,    "Memory" },
/* da */ { IDS_MEMORY_DA, "Hukommelse" },
/* de */ { IDS_MEMORY_DE, "Speicher" },
/* es */ { IDS_MEMORY_ES, "Memoria" },
/* fr */ { IDS_MEMORY_FR, "Mmoire" },
/* hu */ { IDS_MEMORY_HU, "Memria" },
/* it */ { IDS_MEMORY_IT, "Memoria" },
/* ko */ { IDS_MEMORY_KO, "޸" },
/* nl */ { IDS_MEMORY_NL, "Geheugen" },
/* pl */ { IDS_MEMORY_PL, "Pami" },
/* ru */ { IDS_MEMORY_RU, "" },
/* sv */ { IDS_MEMORY_SV, "Minne" },
/* tr */ { IDS_MEMORY_TR, "Bellek" },

/* en */ { IDS_VIDEO_SIZE,    "Video size" },
/* da */ { IDS_VIDEO_SIZE_DA, "Skrmbredde" },
/* de */ { IDS_VIDEO_SIZE_DE, "Videospeichergre" },
/* es */ { IDS_VIDEO_SIZE_ES, "Tamao de pantalla" },
/* fr */ { IDS_VIDEO_SIZE_FR, "Taille vido" },
/* hu */ { IDS_VIDEO_SIZE_HU, "Vide mret" },
/* it */ { IDS_VIDEO_SIZE_IT, "Dimensione video" },
/* ko */ { IDS_VIDEO_SIZE_KO, " ũ" },
/* nl */ { IDS_VIDEO_SIZE_NL, "Videogrootte" },
/* pl */ { IDS_VIDEO_SIZE_PL, "Rozmiar wideo" },
/* ru */ { IDS_VIDEO_SIZE_RU, " " },
/* sv */ { IDS_VIDEO_SIZE_SV, "Skrmbredd" },
/* tr */ { IDS_VIDEO_SIZE_TR, "Grnt boyutu" },

/* en */ { IDS_IO_SIZE,    "I/O size" },
/* da */ { IDS_IO_SIZE_DA, "I/O-strrelse" },
/* de */ { IDS_IO_SIZE_DE, "I/O Gre" },
/* es */ { IDS_IO_SIZE_ES, "Tamao de entradas/salidas" },
/* fr */ { IDS_IO_SIZE_FR, "Taille d'E/S" },
/* hu */ { IDS_IO_SIZE_HU, "I/O mret" },
/* it */ { IDS_IO_SIZE_IT, "Dimensione I/O" },
/* ko */ { IDS_IO_SIZE_KO, "I/O ũ" },
/* nl */ { IDS_IO_SIZE_NL, "I/O grootte" },
/* pl */ { IDS_IO_SIZE_PL, "Rozmiar we/wy" },
/* ru */ { IDS_IO_SIZE_RU, " I/O" },
/* sv */ { IDS_IO_SIZE_SV, "I/O-utrymme" },
/* tr */ { IDS_IO_SIZE_TR, "G/ boyutu" },

/* en */ { IDS_KEYBOARD,    "Keyboard" },
/* da */ { IDS_KEYBOARD_DA, "Tastatur" },
/* de */ { IDS_KEYBOARD_DE, "Tastatur" },
/* es */ { IDS_KEYBOARD_ES, "Teclado" },
/* fr */ { IDS_KEYBOARD_FR, "Clavier" },
/* hu */ { IDS_KEYBOARD_HU, "Billentyzet" },
/* it */ { IDS_KEYBOARD_IT, "Tastiera" },
/* ko */ { IDS_KEYBOARD_KO, "Ű" },
/* nl */ { IDS_KEYBOARD_NL, "Toetsenbord" },
/* pl */ { IDS_KEYBOARD_PL, "Klawiatura" },
/* ru */ { IDS_KEYBOARD_RU, "" },
/* sv */ { IDS_KEYBOARD_SV, "Tangentbord" },
/* tr */ { IDS_KEYBOARD_TR, "Klavye" },

/* en */ { IDS_CRTC_CHIP,    "CRTC chip" },
/* da */ { IDS_CRTC_CHIP_DA, "CRTC-kreds" },
/* de */ { IDS_CRTC_CHIP_DE, "CRTC Chip" },
/* es */ { IDS_CRTC_CHIP_ES, "Chip CRTC" },
/* fr */ { IDS_CRTC_CHIP_FR, "Puce CRTC" },
/* hu */ { IDS_CRTC_CHIP_HU, "CRTC csip" },
/* it */ { IDS_CRTC_CHIP_IT, "Chip CRTC" },
/* ko */ { IDS_CRTC_CHIP_KO, "" },  /* fuzzy */
/* nl */ { IDS_CRTC_CHIP_NL, "CRTC chip" },
/* pl */ { IDS_CRTC_CHIP_PL, "Ukad CRTC" },
/* ru */ { IDS_CRTC_CHIP_RU, "CRTC chip" },
/* sv */ { IDS_CRTC_CHIP_SV, "CRTC-krets" },
/* tr */ { IDS_CRTC_CHIP_TR, "CRTC ipi" },

/* en */ { IDS_SUPERPET_IO,    "SuperPET I/O enable (disables 8x96)" },
/* da */ { IDS_SUPERPET_IO_DA, "Aktivr SuperPET-I/O (deaktiverer 8x96)" },
/* de */ { IDS_SUPERPET_IO_DE, "SuperPET I/O aktivieren (deaktiviert 8x96)" },
/* es */ { IDS_SUPERPET_IO_ES, "SuperPET entradas/salidas habilitadas (deshabilitado 8x96)" },
/* fr */ { IDS_SUPERPET_IO_FR, "E/S SuperPET activ (dsactive 8x96)" },
/* hu */ { IDS_SUPERPET_IO_HU, "SuperPET I/O engedlyezse (8x96-ot tiltja)" },
/* it */ { IDS_SUPERPET_IO_IT, "Attiva I/O SuperPET (disattiva 8x96)" },
/* ko */ { IDS_SUPERPET_IO_KO, "SuperPET I/O ϱ (ʱ 8x96)" },
/* nl */ { IDS_SUPERPET_IO_NL, "SuperPET I/O activeren (zet 8x96 uit)" },
/* pl */ { IDS_SUPERPET_IO_PL, "Wcz SuperPET I/O (wycza 8x96)" },
/* ru */ { IDS_SUPERPET_IO_RU, "SuperPET I/O enable (disables 8x96)" },
/* sv */ { IDS_SUPERPET_IO_SV, "Aktivera SuperPET-I/O (inaktiverar 8x96)" },
/* tr */ { IDS_SUPERPET_IO_TR, "SuperPET G/ aktif et (8x96'y pasifletir)" },

/* en */ { IDS_9xxx_AS_RAM,    "$9*** as RAM" },
/* da */ { IDS_9xxx_AS_RAM_DA, "$9*** som RAM" },
/* de */ { IDS_9xxx_AS_RAM_DE, "$9*** als RAM" },
/* es */ { IDS_9xxx_AS_RAM_ES, "$9*** como RAM" },
/* fr */ { IDS_9xxx_AS_RAM_FR, "$9*** comme RAM" },
/* hu */ { IDS_9xxx_AS_RAM_HU, "$9*** RAM-knt" },
/* it */ { IDS_9xxx_AS_RAM_IT, "$9*** come RAM" },
/* ko */ { IDS_9xxx_AS_RAM_KO, "" },  /* fuzzy */
/* nl */ { IDS_9xxx_AS_RAM_NL, "$9*** als RAM" },
/* pl */ { IDS_9xxx_AS_RAM_PL, "$9*** jako RAM" },
/* ru */ { IDS_9xxx_AS_RAM_RU, "$9*** as RAM" },
/* sv */ { IDS_9xxx_AS_RAM_SV, "$9*** som RAM" },
/* tr */ { IDS_9xxx_AS_RAM_TR, "RAM olarak $9***" },

/* en */ { IDS_Axxx_AS_RAM,    "$A*** as RAM" },
/* da */ { IDS_Axxx_AS_RAM_DA, "$A*** som RAM" },
/* de */ { IDS_Axxx_AS_RAM_DE, "$A*** als RAM" },
/* es */ { IDS_Axxx_AS_RAM_ES, "$A*** como RAM" },
/* fr */ { IDS_Axxx_AS_RAM_FR, "$A*** comme RAM (8296 seulement)" },
/* hu */ { IDS_Axxx_AS_RAM_HU, "$A*** RAM-knt" },
/* it */ { IDS_Axxx_AS_RAM_IT, "$A*** come RAM" },
/* ko */ { IDS_Axxx_AS_RAM_KO, "" },  /* fuzzy */
/* nl */ { IDS_Axxx_AS_RAM_NL, "$A*** als RAM" },
/* pl */ { IDS_Axxx_AS_RAM_PL, "$A*** jako RAM" },
/* ru */ { IDS_Axxx_AS_RAM_RU, "$A*** as RAM" },
/* sv */ { IDS_Axxx_AS_RAM_SV, "$A*** som RAM" },
/* tr */ { IDS_Axxx_AS_RAM_TR, "RAM olarak $A***" },

/* en */ { IDS_PET_SETTINGS,    "PET settings" },
/* da */ { IDS_PET_SETTINGS_DA, "PET-indstillinger" },
/* de */ { IDS_PET_SETTINGS_DE, "PET Einstellungen" },
/* es */ { IDS_PET_SETTINGS_ES, "Ajustes PET" },
/* fr */ { IDS_PET_SETTINGS_FR, "Paramtres PET" },
/* hu */ { IDS_PET_SETTINGS_HU, "PET belltsai" },
/* it */ { IDS_PET_SETTINGS_IT, "Impostazioni PET" },
/* ko */ { IDS_PET_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_PET_SETTINGS_NL, "PET instellingen" },
/* pl */ { IDS_PET_SETTINGS_PL, "Ustawienia PET" },
/* ru */ { IDS_PET_SETTINGS_RU, "PET settings" },
/* sv */ { IDS_PET_SETTINGS_SV, "PET-instllningar" },
/* tr */ { IDS_PET_SETTINGS_TR, "PET ayarlar" },

/* en */ { IDS_CURRENT_MODEL,    "Current Model" },
/* da */ { IDS_CURRENT_MODEL_DA, "Nuvrende model" },
/* de */ { IDS_CURRENT_MODEL_DE, "Aktuelles Modell" },
/* es */ { IDS_CURRENT_MODEL_ES, "modelo actual" },
/* fr */ { IDS_CURRENT_MODEL_FR, "Modle actuel" },
/* hu */ { IDS_CURRENT_MODEL_HU, "Jelenlegi modell" },
/* it */ { IDS_CURRENT_MODEL_IT, "Modello attuale" },
/* ko */ { IDS_CURRENT_MODEL_KO, "" },  /* fuzzy */
/* nl */ { IDS_CURRENT_MODEL_NL, "Huidig model" },
/* pl */ { IDS_CURRENT_MODEL_PL, "Obecny model" },
/* ru */ { IDS_CURRENT_MODEL_RU, "Current Model" },
/* sv */ { IDS_CURRENT_MODEL_SV, "Aktuell modell" },
/* tr */ { IDS_CURRENT_MODEL_TR, "Geerli Model" },

/* en */ { IDS_PET_MODEL,    "PET Model" },
/* da */ { IDS_PET_MODEL_DA, "PET-model" },
/* de */ { IDS_PET_MODEL_DE, "PET Modell" },
/* es */ { IDS_PET_MODEL_ES, "Modelo PET" },
/* fr */ { IDS_PET_MODEL_FR, "Modle PET" },
/* hu */ { IDS_PET_MODEL_HU, "PET modell" },
/* it */ { IDS_PET_MODEL_IT, "Modello PET" },
/* ko */ { IDS_PET_MODEL_KO, "" },  /* fuzzy */
/* nl */ { IDS_PET_MODEL_NL, "PET model" },
/* pl */ { IDS_PET_MODEL_PL, "Model PET" },
/* ru */ { IDS_PET_MODEL_RU, " PET" },
/* sv */ { IDS_PET_MODEL_SV, "PET-modell" },
/* tr */ { IDS_PET_MODEL_TR, "PET Modeli" },

/* en */ { IDS_PLUS4_SETTINGS,    "Plus4 settings" },
/* da */ { IDS_PLUS4_SETTINGS_DA, "Plus4-indstillinger" },
/* de */ { IDS_PLUS4_SETTINGS_DE, "Plus4 Einstellungen" },
/* es */ { IDS_PLUS4_SETTINGS_ES, "Ajustes Plus4" },
/* fr */ { IDS_PLUS4_SETTINGS_FR, "Paramtres Plus4" },
/* hu */ { IDS_PLUS4_SETTINGS_HU, "Plus4 belltsai" },
/* it */ { IDS_PLUS4_SETTINGS_IT, "Impostazioni Plus4" },
/* ko */ { IDS_PLUS4_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_PLUS4_SETTINGS_NL, "Plus4 instellingen" },
/* pl */ { IDS_PLUS4_SETTINGS_PL, "Ustawienia Plus4" },
/* ru */ { IDS_PLUS4_SETTINGS_RU, "Plus4 settings" },
/* sv */ { IDS_PLUS4_SETTINGS_SV, "Plus4-instllningar" },
/* tr */ { IDS_PLUS4_SETTINGS_TR, "Plus4 ayarlar" },

/* en */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME,    "Select Internal Function ROM file" },
/* da */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_DA, "Vlg image for intern funktions-ROM" },
/* de */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_DE, "Internes Funktions ROM Image Datei auswhlen" },
/* es */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_ES, "Seleccionar fichero ROM funcin interno" },
/* fr */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_FR, "Slectionner le fichier image ROM Fonction interne" },
/* hu */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_HU, "Adja meg a bels Function ROM kpms nevt" },
/* it */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_IT, "Seleziona file Function ROM interna" },
/* ko */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_NL, "Selecteer intern functie ROM bestand" },
/* pl */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_PL, "Wybierz plik wewntrznego Function ROM-u" },
/* ru */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_RU, "Select Internal Function ROM file" },
/* sv */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_SV, "Vlj avbildning fr internt funktions-ROM" },
/* tr */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_TR, "Dahili Function ROM dosyas sein" },

/* en */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME,    "Select External Function ROM file" },
/* da */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_DA, "Vlg image for ekstern funktions-ROM" },
/* de */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_DE, "Externes Funktions ROM Image Datei auswhlen" },
/* es */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_ES, "Seleccionar fichero ROM funcin externo" },
/* fr */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_FR, "Slectionner le fichier image ROM Fonction externe" },
/* hu */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_HU, "Adja meg a kls Function ROM kpms nevt" },
/* it */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_IT, "Seleziona file Function ROM esterna" },
/* ko */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_KO, "" },  /* fuzzy */
/* nl */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_NL, "Selecteer extern functie ROM bestand" },
/* pl */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_PL, "Wybierz plik zewntrznego Function ROM-u" },
/* ru */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_RU, "Select External Function ROM file" },
/* sv */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_SV, "Vlj avbildning fr externt funktions-ROM" },
/* tr */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_TR, "Harici Function ROM dosyas sein" },

/* en */ { IDS_MACHINE_TYPE,    "Machine type" },
/* da */ { IDS_MACHINE_TYPE_DA, "Maskintype" },
/* de */ { IDS_MACHINE_TYPE_DE, "Maschinen Typ" },
/* es */ { IDS_MACHINE_TYPE_ES, "Tipo de mquina" },
/* fr */ { IDS_MACHINE_TYPE_FR, "Type de machine" },
/* hu */ { IDS_MACHINE_TYPE_HU, "Gp tpus" },
/* it */ { IDS_MACHINE_TYPE_IT, "Tipo computer" },
/* ko */ { IDS_MACHINE_TYPE_KO, "ӽ " },
/* nl */ { IDS_MACHINE_TYPE_NL, "Machinesoort" },
/* pl */ { IDS_MACHINE_TYPE_PL, "Typ maszyny" },
/* ru */ { IDS_MACHINE_TYPE_RU, " " },
/* sv */ { IDS_MACHINE_TYPE_SV, "Maskintyp" },
/* tr */ { IDS_MACHINE_TYPE_TR, "Makine tipi" },

/* en */ { IDS_INTERNAL_FUNCTION_ROM,    "Internal Function ROM" },
/* da */ { IDS_INTERNAL_FUNCTION_ROM_DA, "Intern funktions-ROM" },
/* de */ { IDS_INTERNAL_FUNCTION_ROM_DE, "Internes Funktions ROM" },
/* es */ { IDS_INTERNAL_FUNCTION_ROM_ES, "ROM de funcin interna" },
/* fr */ { IDS_INTERNAL_FUNCTION_ROM_FR, "Image ROM Fonction interne" },
/* hu */ { IDS_INTERNAL_FUNCTION_ROM_HU, "Bels Function ROM" },
/* it */ { IDS_INTERNAL_FUNCTION_ROM_IT, "Function ROM interna" },
/* ko */ { IDS_INTERNAL_FUNCTION_ROM_KO, "" },  /* fuzzy */
/* nl */ { IDS_INTERNAL_FUNCTION_ROM_NL, "Interne functie ROM" },
/* pl */ { IDS_INTERNAL_FUNCTION_ROM_PL, "Wewntrzny Function ROM" },
/* ru */ { IDS_INTERNAL_FUNCTION_ROM_RU, "Internal Function ROM" },
/* sv */ { IDS_INTERNAL_FUNCTION_ROM_SV, "Internt funktions-ROM" },
/* tr */ { IDS_INTERNAL_FUNCTION_ROM_TR, "Uluslararas Function ROM" },

/* en */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME,    "Internal Function ROM file" },
/* da */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_DA, "Intern funktions-ROM" },
/* de */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_DE, "Interne Funktions ROM Datei" },
/* es */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_ES, "Fichero ROM funcin interno" },
/* fr */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_FR, "Fichier ROM Fonction interne" },
/* hu */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_HU, "Bels Function ROM fjl" },
/* it */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_IT, "File Function ROM interna" },
/* ko */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_KO, "ͳ Function ROM " },
/* nl */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_NL, "Intern functie ROM bestand" },
/* pl */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_PL, "Plik wewntrznego Function ROM-u" },
/* ru */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_RU, "Internal Function ROM file" },
/* sv */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_SV, "Internt funktions-ROM-fil" },
/* tr */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_TR, "Dahili Function ROM dosyas" },

/* en */ { IDS_EXTERNAL_FUNCTION_ROM,    "External Function ROM" },
/* da */ { IDS_EXTERNAL_FUNCTION_ROM_DA, "Extern funktions-ROM" },
/* de */ { IDS_EXTERNAL_FUNCTION_ROM_DE, "Externes Funktions ROM" },
/* es */ { IDS_EXTERNAL_FUNCTION_ROM_ES, "ROM de funcin externa" },
/* fr */ { IDS_EXTERNAL_FUNCTION_ROM_FR, "Image ROM Fonction externe" },
/* hu */ { IDS_EXTERNAL_FUNCTION_ROM_HU, "Kls Function ROM" },
/* it */ { IDS_EXTERNAL_FUNCTION_ROM_IT, "Function ROM esterna" },
/* ko */ { IDS_EXTERNAL_FUNCTION_ROM_KO, "" },  /* fuzzy */
/* nl */ { IDS_EXTERNAL_FUNCTION_ROM_NL, "Externe functie ROM" },
/* pl */ { IDS_EXTERNAL_FUNCTION_ROM_PL, "Zewntrzny Function ROM" },
/* ru */ { IDS_EXTERNAL_FUNCTION_ROM_RU, "External Function ROM" },
/* sv */ { IDS_EXTERNAL_FUNCTION_ROM_SV, "Externt funktions-ROM" },
/* tr */ { IDS_EXTERNAL_FUNCTION_ROM_TR, "Harici Function ROM" },

/* en */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME,    "External Function ROM file" },
/* da */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_DA, "Extern funktions-ROM" },
/* de */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_DE, "Externe Funktions ROM Datei" },
/* es */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_ES, "Fichero ROM funcin externo" },
/* fr */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_FR, "Fichier ROM Fonction externe" },
/* hu */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_HU, "Kls Function ROM fjl" },
/* it */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_IT, "File Function ROM esterna" },
/* ko */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_KO, "ܺԼ ROM " },
/* nl */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_NL, "Extern functie ROM bestand" },
/* pl */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_PL, "Plik zewntrznego Function ROM-u" },
/* ru */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_RU, "External Function ROM file" },
/* sv */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_SV, "Externt funktions-ROM" },
/* tr */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_TR, "Harici Function ROM dosyas" },

/* en */ { IDS_RAM_BANKS_2_AND_3,    "RAM banks 2 & 3" },
/* da */ { IDS_RAM_BANKS_2_AND_3_DA, "RAM bank 2 & 3" },
/* de */ { IDS_RAM_BANKS_2_AND_3_DE, "RAM Bnkte 2 & 3" },
/* es */ { IDS_RAM_BANKS_2_AND_3_ES, "RAM bancos 2 y 3" },
/* fr */ { IDS_RAM_BANKS_2_AND_3_FR, "Banques RAM 2 & 3" },
/* hu */ { IDS_RAM_BANKS_2_AND_3_HU, "2-es s 3-as RAM bankok" },
/* it */ { IDS_RAM_BANKS_2_AND_3_IT, "Banchi RAM 2 & 3" },
/* ko */ { IDS_RAM_BANKS_2_AND_3_KO, "" },  /* fuzzy */
/* nl */ { IDS_RAM_BANKS_2_AND_3_NL, "RAM banken 2 & 3" },
/* pl */ { IDS_RAM_BANKS_2_AND_3_PL, "Banki RAM 2 i 3" },
/* ru */ { IDS_RAM_BANKS_2_AND_3_RU, "RAM banks 2 & 3" },
/* sv */ { IDS_RAM_BANKS_2_AND_3_SV, "RAM-bank 2 & 3" },
/* tr */ { IDS_RAM_BANKS_2_AND_3_TR, "RAM banklar 2 & 3" },

/* en */ { IDS_INTERNAL_FUNCTION_RTC_SAVE,    "Enable Internal Function RTC data saving" },
/* da */ { IDS_INTERNAL_FUNCTION_RTC_SAVE_DA, "" },  /* fuzzy */
/* de */ { IDS_INTERNAL_FUNCTION_RTC_SAVE_DE, "Interne Funktions RTC Speicherung aktivieren" },
/* es */ { IDS_INTERNAL_FUNCTION_RTC_SAVE_ES, "Permitir grabar datos de Internal Function RTC" },
/* fr */ { IDS_INTERNAL_FUNCTION_RTC_SAVE_FR, "" },  /* fuzzy */
/* hu */ { IDS_INTERNAL_FUNCTION_RTC_SAVE_HU, "" },  /* fuzzy */
/* it */ { IDS_INTERNAL_FUNCTION_RTC_SAVE_IT, "Attiva salvataggio dei dati RTC dell'Internal Function" },
/* ko */ { IDS_INTERNAL_FUNCTION_RTC_SAVE_KO, "" },  /* fuzzy */
/* nl */ { IDS_INTERNAL_FUNCTION_RTC_SAVE_NL, "Activeer het opslaan van de interne functie RTC data" },
/* pl */ { IDS_INTERNAL_FUNCTION_RTC_SAVE_PL, "Wcz zapis zegara wewntrznego Function ROM-u" },
/* ru */ { IDS_INTERNAL_FUNCTION_RTC_SAVE_RU, "" },  /* fuzzy */
/* sv */ { IDS_INTERNAL_FUNCTION_RTC_SAVE_SV, "" },  /* fuzzy */
/* tr */ { IDS_INTERNAL_FUNCTION_RTC_SAVE_TR, "" },  /* fuzzy */

/* en */ { IDS_EXTERNAL_FUNCTION_RTC_SAVE,    "Enable External Function RTC data saving" },
/* da */ { IDS_EXTERNAL_FUNCTION_RTC_SAVE_DA, "" },  /* fuzzy */
/* de */ { IDS_EXTERNAL_FUNCTION_RTC_SAVE_DE, "Externe Funktions RTC Speicherung aktivieren" },
/* es */ { IDS_EXTERNAL_FUNCTION_RTC_SAVE_ES, "Permitir grabar datos de External Function RTC" },
/* fr */ { IDS_EXTERNAL_FUNCTION_RTC_SAVE_FR, "" },  /* fuzzy */
/* hu */ { IDS_EXTERNAL_FUNCTION_RTC_SAVE_HU, "" },  /* fuzzy */
/* it */ { IDS_EXTERNAL_FUNCTION_RTC_SAVE_IT, "Attiva salvataggio dei dati RTC dell'External Function" },
/* ko */ { IDS_EXTERNAL_FUNCTION_RTC_SAVE_KO, "" },  /* fuzzy */
/* nl */ { IDS_EXTERNAL_FUNCTION_RTC_SAVE_NL, "Activeer het opslaan van de externe functie RTC data" },
/* pl */ { IDS_EXTERNAL_FUNCTION_RTC_SAVE_PL, "Wcz zapis zegara zewntrznego Function ROM-u" },
/* ru */ { IDS_EXTERNAL_FUNCTION_RTC_SAVE_RU, "" },  /* fuzzy */
/* sv */ { IDS_EXTERNAL_FUNCTION_RTC_SAVE_SV, "" },  /* fuzzy */
/* tr */ { IDS_EXTERNAL_FUNCTION_RTC_SAVE_TR, "" },  /* fuzzy */

/* en */ { IDS_C128_SETTINGS,    "C128 settings" },
/* da */ { IDS_C128_SETTINGS_DA, "C128-indstillinger" },
/* de */ { IDS_C128_SETTINGS_DE, "C128 Einstellungen" },
/* es */ { IDS_C128_SETTINGS_ES, "Ajustes C128" },
/* fr */ { IDS_C128_SETTINGS_FR, "Paramtres C128" },
/* hu */ { IDS_C128_SETTINGS_HU, "C128 belltsai" },
/* it */ { IDS_C128_SETTINGS_IT, "Impostazioni C128" },
/* ko */ { IDS_C128_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_C128_SETTINGS_NL, "C128 instellingen" },
/* pl */ { IDS_C128_SETTINGS_PL, "Ustawienia C128" },
/* ru */ { IDS_C128_SETTINGS_RU, " C128" },
/* sv */ { IDS_C128_SETTINGS_SV, "C128-instllningar" },
/* tr */ { IDS_C128_SETTINGS_TR, "C128 ayarlar" },

/* en */ { IDS_SELECT_ROM_FILE,    "Select ROM file" },
/* da */ { IDS_SELECT_ROM_FILE_DA, "Vlg ROM-fil" },
/* de */ { IDS_SELECT_ROM_FILE_DE, "ROM Datei whlen" },
/* es */ { IDS_SELECT_ROM_FILE_ES, "Seleccionar fichero ROM" },
/* fr */ { IDS_SELECT_ROM_FILE_FR, "Slectionner fichier ROM" },
/* hu */ { IDS_SELECT_ROM_FILE_HU, "Vlasszon ROM fjlt" },
/* it */ { IDS_SELECT_ROM_FILE_IT, "Seleziona file ROM" },
/* ko */ { IDS_SELECT_ROM_FILE_KO, "" },  /* fuzzy */
/* nl */ { IDS_SELECT_ROM_FILE_NL, "Selecteer ROM bestand" },
/* pl */ { IDS_SELECT_ROM_FILE_PL, "wybierz plik ROM" },
/* ru */ { IDS_SELECT_ROM_FILE_RU, "  ROM" },
/* sv */ { IDS_SELECT_ROM_FILE_SV, "Vlj ROM-fil" },
/* tr */ { IDS_SELECT_ROM_FILE_TR, "ROM dosyas sein" },

/* en */ { IDS_COMPUTER_ROM_SETTINGS,    "Computer ROM settings" },
/* da */ { IDS_COMPUTER_ROM_SETTINGS_DA, "Computer ROM-indstillinger" },
/* de */ { IDS_COMPUTER_ROM_SETTINGS_DE, "Computer ROM Einstellungen" },
/* es */ { IDS_COMPUTER_ROM_SETTINGS_ES, "Ajustes ROM ordenador" },
/* fr */ { IDS_COMPUTER_ROM_SETTINGS_FR, "Paramtres ROM ordinateur" },
/* hu */ { IDS_COMPUTER_ROM_SETTINGS_HU, "Szmtgp ROM belltsai" },
/* it */ { IDS_COMPUTER_ROM_SETTINGS_IT, "Impostazioni ROM del computer" },
/* ko */ { IDS_COMPUTER_ROM_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_COMPUTER_ROM_SETTINGS_NL, "Computer ROM instellingen" },
/* pl */ { IDS_COMPUTER_ROM_SETTINGS_PL, "Ustawienia ROM-u komputera" },
/* ru */ { IDS_COMPUTER_ROM_SETTINGS_RU, "Computer ROM settings" },
/* sv */ { IDS_COMPUTER_ROM_SETTINGS_SV, "ROM-instllningar fr dator" },
/* tr */ { IDS_COMPUTER_ROM_SETTINGS_TR, "Bilgisayar ROM ayarlar" },

/* en */ { IDS_DRIVE_ROM_SETTINGS,    "Drive ROM settings" },
/* da */ { IDS_DRIVE_ROM_SETTINGS_DA, "Drev ROM-indstillinger" },
/* de */ { IDS_DRIVE_ROM_SETTINGS_DE, "Floppy ROM Einstellungen" },
/* es */ { IDS_DRIVE_ROM_SETTINGS_ES, "Ajustes ROM unidad disco" },
/* fr */ { IDS_DRIVE_ROM_SETTINGS_FR, "Paramtres ROM Lecteur" },
/* hu */ { IDS_DRIVE_ROM_SETTINGS_HU, "Lemezegysg ROM belltsai" },
/* it */ { IDS_DRIVE_ROM_SETTINGS_IT, "Impostazioni ROM del drive" },
/* ko */ { IDS_DRIVE_ROM_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_DRIVE_ROM_SETTINGS_NL, "Drive ROM instellingen" },
/* pl */ { IDS_DRIVE_ROM_SETTINGS_PL, "Ustawienia ROM-u napdu" },
/* ru */ { IDS_DRIVE_ROM_SETTINGS_RU, "Drive ROM settings" },
/* sv */ { IDS_DRIVE_ROM_SETTINGS_SV, "ROM-instllningar fr diskettenhet" },
/* tr */ { IDS_DRIVE_ROM_SETTINGS_TR, "Src ROM ayarlar" },

/* en */ { IDS_DIGIMAX_ENABLED,    "DigiMAX Enabled" },
/* da */ { IDS_DIGIMAX_ENABLED_DA, "DigiMAX aktivret" },
/* de */ { IDS_DIGIMAX_ENABLED_DE, "DigiMAX aktiviert" },
/* es */ { IDS_DIGIMAX_ENABLED_ES, "Permitir DigiMAX" },
/* fr */ { IDS_DIGIMAX_ENABLED_FR, "DigiMAX Activ" },
/* hu */ { IDS_DIGIMAX_ENABLED_HU, "" },  /* fuzzy */
/* it */ { IDS_DIGIMAX_ENABLED_IT, "Attivato DigiMAX" },
/* ko */ { IDS_DIGIMAX_ENABLED_KO, "" },  /* fuzzy */
/* nl */ { IDS_DIGIMAX_ENABLED_NL, "DigiMAX Aan/Uit" },
/* pl */ { IDS_DIGIMAX_ENABLED_PL, "DigiMAX wczony" },
/* ru */ { IDS_DIGIMAX_ENABLED_RU, "DigiMAX Enabled" },
/* sv */ { IDS_DIGIMAX_ENABLED_SV, "DigiMAX aktiverad" },
/* tr */ { IDS_DIGIMAX_ENABLED_TR, "DigiMAX' Aktif Et" },

/* en */ { IDS_DIGIMAX_BASE,    "DigiMAX base" },
/* da */ { IDS_DIGIMAX_BASE_DA, "DigiMAX-base" },
/* de */ { IDS_DIGIMAX_BASE_DE, "DigiMAX Basis" },
/* es */ { IDS_DIGIMAX_BASE_ES, "DigiMAX base" },
/* fr */ { IDS_DIGIMAX_BASE_FR, "Base DigiMAX" },
/* hu */ { IDS_DIGIMAX_BASE_HU, "" },  /* fuzzy */
/* it */ { IDS_DIGIMAX_BASE_IT, "Indirizzo base DigiMAX" },
/* ko */ { IDS_DIGIMAX_BASE_KO, "" },  /* fuzzy */
/* nl */ { IDS_DIGIMAX_BASE_NL, "DigiMAX basisadres" },
/* pl */ { IDS_DIGIMAX_BASE_PL, "Baza DigiMAX" },
/* ru */ { IDS_DIGIMAX_BASE_RU, "DigiMAX base" },
/* sv */ { IDS_DIGIMAX_BASE_SV, "DigiMAX-bas" },
/* tr */ { IDS_DIGIMAX_BASE_TR, "DigiMAX taban" },

/* en */ { IDS_DIGIMAX_SETTINGS,    "DigiMAX settings" },
/* da */ { IDS_DIGIMAX_SETTINGS_DA, "DigiMAX-indstillinger" },
/* de */ { IDS_DIGIMAX_SETTINGS_DE, "DigiMAX Einstellungen" },
/* es */ { IDS_DIGIMAX_SETTINGS_ES, "Ajustes DigiMAX" },
/* fr */ { IDS_DIGIMAX_SETTINGS_FR, "Paramtres DigiMAX" },
/* hu */ { IDS_DIGIMAX_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_DIGIMAX_SETTINGS_IT, "Impostazioni DigiMAX" },
/* ko */ { IDS_DIGIMAX_SETTINGS_KO, "DigiMAX " },
/* nl */ { IDS_DIGIMAX_SETTINGS_NL, "DigiMAX instellingen" },
/* pl */ { IDS_DIGIMAX_SETTINGS_PL, "Ustawienia DigiMAX" },
/* ru */ { IDS_DIGIMAX_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_DIGIMAX_SETTINGS_SV, "DigiMAX-instllningar" },
/* tr */ { IDS_DIGIMAX_SETTINGS_TR, "DigiMAX ayarlar" },

/* en */ { IDS_ASK,    "Ask" },
/* da */ { IDS_ASK_DA, "" },  /* fuzzy */
/* de */ { IDS_ASK_DE, "Nachfragen" },
/* es */ { IDS_ASK_ES, "Preguntar" },
/* fr */ { IDS_ASK_FR, "" },  /* fuzzy */
/* hu */ { IDS_ASK_HU, "" },  /* fuzzy */
/* it */ { IDS_ASK_IT, "Chiedi" },
/* ko */ { IDS_ASK_KO, "" },  /* fuzzy */
/* nl */ { IDS_ASK_NL, "Vraag" },
/* pl */ { IDS_ASK_PL, "Spytaj" },
/* ru */ { IDS_ASK_RU, "" },  /* fuzzy */
/* sv */ { IDS_ASK_SV, "Frga" },
/* tr */ { IDS_ASK_TR, "" },  /* fuzzy */

/* en */ { IDS_CONTINUE,    "Continue" },
/* da */ { IDS_CONTINUE_DA, "Fortst" },
/* de */ { IDS_CONTINUE_DE, "Fortsetzen" },
/* es */ { IDS_CONTINUE_ES, "Continuar" },
/* fr */ { IDS_CONTINUE_FR, "" },  /* fuzzy */
/* hu */ { IDS_CONTINUE_HU, "Folytats" },
/* it */ { IDS_CONTINUE_IT, "Continua" },
/* ko */ { IDS_CONTINUE_KO, "" },
/* nl */ { IDS_CONTINUE_NL, "Door gaan" },
/* pl */ { IDS_CONTINUE_PL, "Kontynuuj" },
/* ru */ { IDS_CONTINUE_RU, "" },
/* sv */ { IDS_CONTINUE_SV, "Fortstt" },
/* tr */ { IDS_CONTINUE_TR, "Devam" },

/* en */ { IDS_START_MONITOR,    "Start monitor" },
/* da */ { IDS_START_MONITOR_DA, "" },  /* fuzzy */
/* de */ { IDS_START_MONITOR_DE, "Monitor aktivieren" },
/* es */ { IDS_START_MONITOR_ES, "Activar monitor" },
/* fr */ { IDS_START_MONITOR_FR, "" },  /* fuzzy */
/* hu */ { IDS_START_MONITOR_HU, "" },  /* fuzzy */
/* it */ { IDS_START_MONITOR_IT, "Attiva monitor" },
/* ko */ { IDS_START_MONITOR_KO, "" },  /* fuzzy */
/* nl */ { IDS_START_MONITOR_NL, "Start monitor" },
/* pl */ { IDS_START_MONITOR_PL, "Uruchom monitor" },
/* ru */ { IDS_START_MONITOR_RU, "" },  /* fuzzy */
/* sv */ { IDS_START_MONITOR_SV, "Starta monitor" },
/* tr */ { IDS_START_MONITOR_TR, "" },  /* fuzzy */

/* en */ { IDS_HARD_RESET,    "Hard reset" },
/* da */ { IDS_HARD_RESET_DA, "" },  /* fuzzy */
/* de */ { IDS_HARD_RESET_DE, "Harter Reset" },
/* es */ { IDS_HARD_RESET_ES, "Reiniciar en frio" },
/* fr */ { IDS_HARD_RESET_FR, "" },  /* fuzzy */
/* hu */ { IDS_HARD_RESET_HU, "" },  /* fuzzy */
/* it */ { IDS_HARD_RESET_IT, "Hard Reset" },
/* ko */ { IDS_HARD_RESET_KO, "" },  /* fuzzy */
/* nl */ { IDS_HARD_RESET_NL, "Harde reset" },
/* pl */ { IDS_HARD_RESET_PL, "Reset sprztu" },
/* ru */ { IDS_HARD_RESET_RU, "" },  /* fuzzy */
/* sv */ { IDS_HARD_RESET_SV, "Hrd nollstllning" },
/* tr */ { IDS_HARD_RESET_TR, "" },  /* fuzzy */

/* en */ { IDS_QUIT_EMULATOR,    "Quit emulator" },
/* da */ { IDS_QUIT_EMULATOR_DA, "" },  /* fuzzy */
/* de */ { IDS_QUIT_EMULATOR_DE, "Emulator beenden" },
/* es */ { IDS_QUIT_EMULATOR_ES, "Salir del emulador" },
/* fr */ { IDS_QUIT_EMULATOR_FR, "" },  /* fuzzy */
/* hu */ { IDS_QUIT_EMULATOR_HU, "" },  /* fuzzy */
/* it */ { IDS_QUIT_EMULATOR_IT, "Esci" },
/* ko */ { IDS_QUIT_EMULATOR_KO, "" },  /* fuzzy */
/* nl */ { IDS_QUIT_EMULATOR_NL, "Emulator uitschakelen" },
/* pl */ { IDS_QUIT_EMULATOR_PL, "Wyjcie z emulatora" },
/* ru */ { IDS_QUIT_EMULATOR_RU, "" },  /* fuzzy */
/* sv */ { IDS_QUIT_EMULATOR_SV, "" },  /* fuzzy */
/* tr */ { IDS_QUIT_EMULATOR_TR, "" },  /* fuzzy */

/* en */ { IDS_JOYPORT_S_DEVICE,    "%s device" },
/* da */ { IDS_JOYPORT_S_DEVICE_DA, "" },  /* fuzzy */
/* de */ { IDS_JOYPORT_S_DEVICE_DE, "%s Gert" },
/* es */ { IDS_JOYPORT_S_DEVICE_ES, "" },  /* fuzzy */
/* fr */ { IDS_JOYPORT_S_DEVICE_FR, "" },  /* fuzzy */
/* hu */ { IDS_JOYPORT_S_DEVICE_HU, "" },  /* fuzzy */
/* it */ { IDS_JOYPORT_S_DEVICE_IT, "" },  /* fuzzy */
/* ko */ { IDS_JOYPORT_S_DEVICE_KO, "" },  /* fuzzy */
/* nl */ { IDS_JOYPORT_S_DEVICE_NL, "%s apparaat" },
/* pl */ { IDS_JOYPORT_S_DEVICE_PL, "" },  /* fuzzy */
/* ru */ { IDS_JOYPORT_S_DEVICE_RU, "" },  /* fuzzy */
/* sv */ { IDS_JOYPORT_S_DEVICE_SV, "" },  /* fuzzy */
/* tr */ { IDS_JOYPORT_S_DEVICE_TR, "" },  /* fuzzy */

/* en */ { IDS_JOYPORT_SETTINGS,    "Control port settings" },
/* da */ { IDS_JOYPORT_SETTINGS_DA, "" },  /* fuzzy */
/* de */ { IDS_JOYPORT_SETTINGS_DE, "Control Port Einstellungen" },
/* es */ { IDS_JOYPORT_SETTINGS_ES, "" },  /* fuzzy */
/* fr */ { IDS_JOYPORT_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_JOYPORT_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_JOYPORT_SETTINGS_IT, "" },  /* fuzzy */
/* ko */ { IDS_JOYPORT_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_JOYPORT_SETTINGS_NL, "Spel connector instellingen" },
/* pl */ { IDS_JOYPORT_SETTINGS_PL, "" },  /* fuzzy */
/* ru */ { IDS_JOYPORT_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_JOYPORT_SETTINGS_SV, "" },  /* fuzzy */
/* tr */ { IDS_JOYPORT_SETTINGS_TR, "" },  /* fuzzy */

/* en */ { IDS_DEFAULT_JAM_ACTION,    "Default CPU JAM action" },
/* da */ { IDS_DEFAULT_JAM_ACTION_DA, "" },  /* fuzzy */
/* de */ { IDS_DEFAULT_JAM_ACTION_DE, "Standard CPU JAM Aktion" },
/* es */ { IDS_DEFAULT_JAM_ACTION_ES, "Accin CPU JAM por defecto" },
/* fr */ { IDS_DEFAULT_JAM_ACTION_FR, "" },  /* fuzzy */
/* hu */ { IDS_DEFAULT_JAM_ACTION_HU, "" },  /* fuzzy */
/* it */ { IDS_DEFAULT_JAM_ACTION_IT, "Azione predefinita al JAM della CPU" },
/* ko */ { IDS_DEFAULT_JAM_ACTION_KO, "" },  /* fuzzy */
/* nl */ { IDS_DEFAULT_JAM_ACTION_NL, "Standaard CPU JAM aktie" },
/* pl */ { IDS_DEFAULT_JAM_ACTION_PL, "Domylne dziaanie zatkania CPU" },
/* ru */ { IDS_DEFAULT_JAM_ACTION_RU, "" },  /* fuzzy */
/* sv */ { IDS_DEFAULT_JAM_ACTION_SV, "" },  /* fuzzy */
/* tr */ { IDS_DEFAULT_JAM_ACTION_TR, "" },  /* fuzzy */

/* en */ { IDS_JAMACTION_SETTINGS,    "CPU JAM action settings" },
/* da */ { IDS_JAMACTION_SETTINGS_DA, "" },  /* fuzzy */
/* de */ { IDS_JAMACTION_SETTINGS_DE, "CPU JAM Aktion Einstellungen" },
/* es */ { IDS_JAMACTION_SETTINGS_ES, "Ajustes accin CPU JAM" },
/* fr */ { IDS_JAMACTION_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_JAMACTION_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_JAMACTION_SETTINGS_IT, "Impostazioni azione al JAM della CPU" },
/* ko */ { IDS_JAMACTION_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_JAMACTION_SETTINGS_NL, "CPU JAM aktie instellingen" },
/* pl */ { IDS_JAMACTION_SETTINGS_PL, "Ustawienia dziaania CPU JAM" },
/* ru */ { IDS_JAMACTION_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_JAMACTION_SETTINGS_SV, "" },  /* fuzzy */
/* tr */ { IDS_JAMACTION_SETTINGS_TR, "" },  /* fuzzy */

/* en */ { IDS_DRIVESOUND_ENABLED,    "Drive sound enabled" },
/* da */ { IDS_DRIVESOUND_ENABLED_DA, "" },  /* fuzzy */
/* de */ { IDS_DRIVESOUND_ENABLED_DE, "Laufwerk Geruschemulation aktivieren" },
/* es */ { IDS_DRIVESOUND_ENABLED_ES, "Permitir controlador de sonido" },
/* fr */ { IDS_DRIVESOUND_ENABLED_FR, "" },  /* fuzzy */
/* hu */ { IDS_DRIVESOUND_ENABLED_HU, "" },  /* fuzzy */
/* it */ { IDS_DRIVESOUND_ENABLED_IT, "Emulazione suoni del drive attiva" },
/* ko */ { IDS_DRIVESOUND_ENABLED_KO, "" },  /* fuzzy */
/* nl */ { IDS_DRIVESOUND_ENABLED_NL, "Drive geluiden aan/uit" },
/* pl */ { IDS_DRIVESOUND_ENABLED_PL, "Wcz dwiki napdu" },
/* ru */ { IDS_DRIVESOUND_ENABLED_RU, "" },  /* fuzzy */
/* sv */ { IDS_DRIVESOUND_ENABLED_SV, "" },  /* fuzzy */
/* tr */ { IDS_DRIVESOUND_ENABLED_TR, "" },  /* fuzzy */

/* en */ { IDS_DRIVESOUND_SETTINGS,    "Drive sound settings" },
/* da */ { IDS_DRIVESOUND_SETTINGS_DA, "" },  /* fuzzy */
/* de */ { IDS_DRIVESOUND_SETTINGS_DE, "Laufwerk Geruschemulation Einstellungen" },
/* es */ { IDS_DRIVESOUND_SETTINGS_ES, "Ajustes controlador de sonido" },
/* fr */ { IDS_DRIVESOUND_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_DRIVESOUND_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_DRIVESOUND_SETTINGS_IT, "Impostazioni suoni del drive" },
/* ko */ { IDS_DRIVESOUND_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_DRIVESOUND_SETTINGS_NL, "Drive geluiden instellingen" },
/* pl */ { IDS_DRIVESOUND_SETTINGS_PL, "Ustawienia dwikw napdu" },
/* ru */ { IDS_DRIVESOUND_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_DRIVESOUND_SETTINGS_SV, "" },  /* fuzzy */
/* tr */ { IDS_DRIVESOUND_SETTINGS_TR, "" },  /* fuzzy */

/* en */ { IDS_DS12C887RTC_ENABLED,    "DS12C887 RTC Enabled" },
/* da */ { IDS_DS12C887RTC_ENABLED_DA, "DS12C887 RTC Aktiveret" },
/* de */ { IDS_DS12C887RTC_ENABLED_DE, "DS12C887 RTC aktiviert" },
/* es */ { IDS_DS12C887RTC_ENABLED_ES, "DS12C887 RTC Permitida" },
/* fr */ { IDS_DS12C887RTC_ENABLED_FR, "DS12C887 RTC Activ" },
/* hu */ { IDS_DS12C887RTC_ENABLED_HU, "" },  /* fuzzy */
/* it */ { IDS_DS12C887RTC_ENABLED_IT, "Attivato DS12C887 RTC" },
/* ko */ { IDS_DS12C887RTC_ENABLED_KO, "" },  /* fuzzy */
/* nl */ { IDS_DS12C887RTC_ENABLED_NL, "DS12C887 Aan/Uit" },
/* pl */ { IDS_DS12C887RTC_ENABLED_PL, "Wczenie DS12C887 RTC" },
/* ru */ { IDS_DS12C887RTC_ENABLED_RU, "DS12C887 RTC Enabled" },
/* sv */ { IDS_DS12C887RTC_ENABLED_SV, "DS12C887 RTC aktiverad" },
/* tr */ { IDS_DS12C887RTC_ENABLED_TR, "DS12C887 RTC Aktif" },

/* en */ { IDS_DS12C887RTC_BASE,    "DS12C887 RTC base" },
/* da */ { IDS_DS12C887RTC_BASE_DA, "DS12C887 RTC base" },
/* de */ { IDS_DS12C887RTC_BASE_DE, "DS12C887 RTC Base" },
/* es */ { IDS_DS12C887RTC_BASE_ES, "DS12C887 RTC base" },
/* fr */ { IDS_DS12C887RTC_BASE_FR, "Base RTC DS12C887" },
/* hu */ { IDS_DS12C887RTC_BASE_HU, "" },  /* fuzzy */
/* it */ { IDS_DS12C887RTC_BASE_IT, "Indirizzo base RTC DS12C887" },
/* ko */ { IDS_DS12C887RTC_BASE_KO, "" },  /* fuzzy */
/* nl */ { IDS_DS12C887RTC_BASE_NL, "DS12C887 RTC basis adres" },
/* pl */ { IDS_DS12C887RTC_BASE_PL, "Baza DS12C887 RTC" },
/* ru */ { IDS_DS12C887RTC_BASE_RU, "DS12C887 RTC base" },
/* sv */ { IDS_DS12C887RTC_BASE_SV, "DS12C887 RTC-bas" },
/* tr */ { IDS_DS12C887RTC_BASE_TR, "DS12C887 RTC taban" },

/* en */ { IDS_DS12C887RTC_SAVE,    "Enable DS12C887 RTC data saving" },
/* da */ { IDS_DS12C887RTC_SAVE_DA, "" },  /* fuzzy */
/* de */ { IDS_DS12C887RTC_SAVE_DE, "DS12C887 RTC Speicherung aktivieren" },
/* es */ { IDS_DS12C887RTC_SAVE_ES, "Permitir grabar datos de  DS12C887 RTC" },
/* fr */ { IDS_DS12C887RTC_SAVE_FR, "" },  /* fuzzy */
/* hu */ { IDS_DS12C887RTC_SAVE_HU, "" },  /* fuzzy */
/* it */ { IDS_DS12C887RTC_SAVE_IT, "Attiva salvataggio dei dati RTC del DS12C887" },
/* ko */ { IDS_DS12C887RTC_SAVE_KO, "" },  /* fuzzy */
/* nl */ { IDS_DS12C887RTC_SAVE_NL, "Activeer het opslaan van de DS12C887 RTC data" },
/* pl */ { IDS_DS12C887RTC_SAVE_PL, "Wcz zapis zegara DS12C887" },
/* ru */ { IDS_DS12C887RTC_SAVE_RU, "" },  /* fuzzy */
/* sv */ { IDS_DS12C887RTC_SAVE_SV, "" },  /* fuzzy */
/* tr */ { IDS_DS12C887RTC_SAVE_TR, "" },  /* fuzzy */

/* en */ { IDS_DS12C887RTC_SETTINGS,    "DS12C887 RTC settings" },
/* da */ { IDS_DS12C887RTC_SETTINGS_DA, "DS12C887 RTC-indstillinger" },
/* de */ { IDS_DS12C887RTC_SETTINGS_DE, "DS12C887 RTC Einstellungen" },
/* es */ { IDS_DS12C887RTC_SETTINGS_ES, "Ajustes DS12C887 RTC" },
/* fr */ { IDS_DS12C887RTC_SETTINGS_FR, "Paramtres DS12C887 RTC" },
/* hu */ { IDS_DS12C887RTC_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_DS12C887RTC_SETTINGS_IT, "Impostazioni RTC DS12C887" },
/* ko */ { IDS_DS12C887RTC_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_DS12C887RTC_SETTINGS_NL, "DS12C887 RTC instellingen" },
/* pl */ { IDS_DS12C887RTC_SETTINGS_PL, "Ustawienia DS12C887 RTC" },
/* ru */ { IDS_DS12C887RTC_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_DS12C887RTC_SETTINGS_SV, "DS12C887 RTC-instllningar" },
/* tr */ { IDS_DS12C887RTC_SETTINGS_TR, "DS12C887 RTC ayarlar" },

/* en */ { IDS_SFX_SE_ENABLED,    "SFX Sound Expander Enabled" },
/* da */ { IDS_SFX_SE_ENABLED_DA, "SFX Sound Expander Aktiveret" },
/* de */ { IDS_SFX_SE_ENABLED_DE, "SFX Sound Expander aktiviert" },
/* es */ { IDS_SFX_SE_ENABLED_ES, "Permitir SFX Sound Expander" },
/* fr */ { IDS_SFX_SE_ENABLED_FR, "SFX Sound Expander Activ" },
/* hu */ { IDS_SFX_SE_ENABLED_HU, "SFX Sound Expander engedlyezve" },
/* it */ { IDS_SFX_SE_ENABLED_IT, "Attivato SFX Sound Expander" },
/* ko */ { IDS_SFX_SE_ENABLED_KO, "" },  /* fuzzy */
/* nl */ { IDS_SFX_SE_ENABLED_NL, "SFX Sound Expander Aan/Uit" },
/* pl */ { IDS_SFX_SE_ENABLED_PL, "SFX Sound Expander wczony" },
/* ru */ { IDS_SFX_SE_ENABLED_RU, "SFX Sound Expander Enabled" },
/* sv */ { IDS_SFX_SE_ENABLED_SV, "SFX Sound Expander aktiverad" },
/* tr */ { IDS_SFX_SE_ENABLED_TR, "SFX Sound Expander Aktif" },

/* en */ { IDS_SFX_SE_CHIP,    "SFX Sound Expander Chip" },
/* da */ { IDS_SFX_SE_CHIP_DA, "SFX Sound Expander chip" },
/* de */ { IDS_SFX_SE_CHIP_DE, "SFX Sound Expander Chip" },
/* es */ { IDS_SFX_SE_CHIP_ES, "SFX Sound Expander Chip" },
/* fr */ { IDS_SFX_SE_CHIP_FR, "Puce SFX Sound Expander" },
/* hu */ { IDS_SFX_SE_CHIP_HU, "SFX Sound Expander csip" },
/* it */ { IDS_SFX_SE_CHIP_IT, "Chip SFX Sound Expander" },
/* ko */ { IDS_SFX_SE_CHIP_KO, "" },  /* fuzzy */
/* nl */ { IDS_SFX_SE_CHIP_NL, "SFX Sound Expander Chip" },
/* pl */ { IDS_SFX_SE_CHIP_PL, "Ukad SFX Sound Expander" },
/* ru */ { IDS_SFX_SE_CHIP_RU, "SFX Sound Expander Chip" },
/* sv */ { IDS_SFX_SE_CHIP_SV, "SFX Sound Expander-krets" },
/* tr */ { IDS_SFX_SE_CHIP_TR, "SFX Sound Expander ipi" },

/* en */ { IDS_SFX_SS_ENABLED,    "SFX Sound Sampler Enabled" },
/* da */ { IDS_SFX_SS_ENABLED_DA, "SFX Sound Sampler Aktiveret" },
/* de */ { IDS_SFX_SS_ENABLED_DE, "SFX Sound Sampler aktiviert" },
/* es */ { IDS_SFX_SS_ENABLED_ES, "Permitir SFX Sound Sampler" },
/* fr */ { IDS_SFX_SS_ENABLED_FR, "SFX Sound Sampler Activ" },
/* hu */ { IDS_SFX_SS_ENABLED_HU, "" },  /* fuzzy */
/* it */ { IDS_SFX_SS_ENABLED_IT, "Attivato SFX Sound Sampler" },
/* ko */ { IDS_SFX_SS_ENABLED_KO, "" },  /* fuzzy */
/* nl */ { IDS_SFX_SS_ENABLED_NL, "SFX Sound Sampler Aan/Uit" },
/* pl */ { IDS_SFX_SS_ENABLED_PL, "Wczony sampler dwiku SFX" },
/* ru */ { IDS_SFX_SS_ENABLED_RU, "" },  /* fuzzy */
/* sv */ { IDS_SFX_SS_ENABLED_SV, "SFX Sound Sampler aktiverad" },
/* tr */ { IDS_SFX_SS_ENABLED_TR, "SFX Sound Sampler Aktif" },

/* en */ { IDS_SFX_SE_SETTINGS,    "SFX Sound Expander settings" },
/* da */ { IDS_SFX_SE_SETTINGS_DA, "SFX Sound Expander-indstillinger" },
/* de */ { IDS_SFX_SE_SETTINGS_DE, "SFX Sound Expander Einstellungen" },
/* es */ { IDS_SFX_SE_SETTINGS_ES, "Ajustes SFX Sound Expander" },
/* fr */ { IDS_SFX_SE_SETTINGS_FR, "Paramtres du SFX Sound Expander" },
/* hu */ { IDS_SFX_SE_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_SFX_SE_SETTINGS_IT, "Impostazioni SFX Sound Expander" },
/* ko */ { IDS_SFX_SE_SETTINGS_KO, "SFX Sound Expander " },
/* nl */ { IDS_SFX_SE_SETTINGS_NL, "SFX Sound Expander instellingen" },
/* pl */ { IDS_SFX_SE_SETTINGS_PL, "Ustawienia SFX Sound Expander" },
/* ru */ { IDS_SFX_SE_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_SFX_SE_SETTINGS_SV, "Instllningar fr SFX Sound Expander" },
/* tr */ { IDS_SFX_SE_SETTINGS_TR, "SFX Sound Expander Ayarlar" },

/* en */ { IDS_SFX_SS_SETTINGS,    "SFX Sound Sampler settings" },
/* da */ { IDS_SFX_SS_SETTINGS_DA, "SFX Sound Sampler-indstillinger" },
/* de */ { IDS_SFX_SS_SETTINGS_DE, "SFX Sound Sampler Einstellungen" },
/* es */ { IDS_SFX_SS_SETTINGS_ES, "Ajustes SFX Sound Sampler" },
/* fr */ { IDS_SFX_SS_SETTINGS_FR, "Paramtres du SFX Sound Sampler" },
/* hu */ { IDS_SFX_SS_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_SFX_SS_SETTINGS_IT, "Impostazioni SFX Sound Sampler" },
/* ko */ { IDS_SFX_SS_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_SFX_SS_SETTINGS_NL, "SFX Sound Sampler instellingen" },
/* pl */ { IDS_SFX_SS_SETTINGS_PL, "Ustawienia samplera dwiku SFX" },
/* ru */ { IDS_SFX_SS_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_SFX_SS_SETTINGS_SV, "Instllningar fr SFX Sound Sampler" },
/* tr */ { IDS_SFX_SS_SETTINGS_TR, "SFX Sound Sampler ayarlar" },

/* en */ { IDS_SCPU64_JIFFY_ENABLED,    "Jiffy switch enabled" },
/* da */ { IDS_SCPU64_JIFFY_ENABLED_DA, "" },  /* fuzzy */
/* de */ { IDS_SCPU64_JIFFY_ENABLED_DE, "Jiffy Schalter aktiviert" },
/* es */ { IDS_SCPU64_JIFFY_ENABLED_ES, "Permitir conmutador Jiffy" },
/* fr */ { IDS_SCPU64_JIFFY_ENABLED_FR, "Jiffy switch active" },
/* hu */ { IDS_SCPU64_JIFFY_ENABLED_HU, "" },  /* fuzzy */
/* it */ { IDS_SCPU64_JIFFY_ENABLED_IT, "Pulsante Jiffy attivo" },
/* ko */ { IDS_SCPU64_JIFFY_ENABLED_KO, "" },  /* fuzzy */
/* nl */ { IDS_SCPU64_JIFFY_ENABLED_NL, "Jiffy schakelaar Aan/Uit" },
/* pl */ { IDS_SCPU64_JIFFY_ENABLED_PL, "Przecznik jiffy wczony" },
/* ru */ { IDS_SCPU64_JIFFY_ENABLED_RU, "" },  /* fuzzy */
/* sv */ { IDS_SCPU64_JIFFY_ENABLED_SV, "jiffyomkopplare aktiverad" },
/* tr */ { IDS_SCPU64_JIFFY_ENABLED_TR, "" },  /* fuzzy */

/* en */ { IDS_SCPU64_SPEED_ENABLED,    "Speed switch enabled" },
/* da */ { IDS_SCPU64_SPEED_ENABLED_DA, "" },  /* fuzzy */
/* de */ { IDS_SCPU64_SPEED_ENABLED_DE, "Speed Schalter aktiviert" },
/* es */ { IDS_SCPU64_SPEED_ENABLED_ES, "Permitir conmutador de velocidad" },
/* fr */ { IDS_SCPU64_SPEED_ENABLED_FR, "Speed switch active" },
/* hu */ { IDS_SCPU64_SPEED_ENABLED_HU, "" },  /* fuzzy */
/* it */ { IDS_SCPU64_SPEED_ENABLED_IT, "Pulsante di velocit attivo" },
/* ko */ { IDS_SCPU64_SPEED_ENABLED_KO, "" },  /* fuzzy */
/* nl */ { IDS_SCPU64_SPEED_ENABLED_NL, "Snelheid schakelaar Aan/Uit" },
/* pl */ { IDS_SCPU64_SPEED_ENABLED_PL, "Przecznik speed wczony" },
/* ru */ { IDS_SCPU64_SPEED_ENABLED_RU, "" },  /* fuzzy */
/* sv */ { IDS_SCPU64_SPEED_ENABLED_SV, "Hastighetsomkopplare aktiverad" },
/* tr */ { IDS_SCPU64_SPEED_ENABLED_TR, "" },  /* fuzzy */

/* en */ { IDS_SCPU64_SIMM_SIZE,    "SIMM size" },
/* da */ { IDS_SCPU64_SIMM_SIZE_DA, "" },  /* fuzzy */
/* de */ { IDS_SCPU64_SIMM_SIZE_DE, "SIMM Gre" },
/* es */ { IDS_SCPU64_SIMM_SIZE_ES, "Tamao SIMM" },
/* fr */ { IDS_SCPU64_SIMM_SIZE_FR, "Taille de la SIMM" },
/* hu */ { IDS_SCPU64_SIMM_SIZE_HU, "" },  /* fuzzy */
/* it */ { IDS_SCPU64_SIMM_SIZE_IT, "Dimensione SIMM" },
/* ko */ { IDS_SCPU64_SIMM_SIZE_KO, "" },  /* fuzzy */
/* nl */ { IDS_SCPU64_SIMM_SIZE_NL, "SIMM grootte" },
/* pl */ { IDS_SCPU64_SIMM_SIZE_PL, "Ilo SIMM" },
/* ru */ { IDS_SCPU64_SIMM_SIZE_RU, "" },  /* fuzzy */
/* sv */ { IDS_SCPU64_SIMM_SIZE_SV, "SIMM-storlek" },
/* tr */ { IDS_SCPU64_SIMM_SIZE_TR, "" },  /* fuzzy */

/* en */ { IDS_SCPU64_SETTINGS,    "SuperCPU64 settings" },
/* da */ { IDS_SCPU64_SETTINGS_DA, "" },  /* fuzzy */
/* de */ { IDS_SCPU64_SETTINGS_DE, "SuperCPU64 Einstellungen" },
/* es */ { IDS_SCPU64_SETTINGS_ES, "Ajustes SuperCPU64" },
/* fr */ { IDS_SCPU64_SETTINGS_FR, "Paramtres SuperCPU64" },
/* hu */ { IDS_SCPU64_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_SCPU64_SETTINGS_IT, "Impostazioni SuperCPU64" },
/* ko */ { IDS_SCPU64_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_SCPU64_SETTINGS_NL, "SuperCPU64 instellingen" },
/* pl */ { IDS_SCPU64_SETTINGS_PL, "Ustawienia SuperCPU64" },
/* ru */ { IDS_SCPU64_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_SCPU64_SETTINGS_SV, "SuperCPU64-instllningar" },
/* tr */ { IDS_SCPU64_SETTINGS_TR, "" },  /* fuzzy */

/* en */ { IDS_SOUND_RECORDING_STOPPED,    "Sound Recording stopped..." },
/* da */ { IDS_SOUND_RECORDING_STOPPED_DA, "Lydoptagelse stoppet..." },
/* de */ { IDS_SOUND_RECORDING_STOPPED_DE, "Tonaufnahme gestoppt..." },
/* es */ { IDS_SOUND_RECORDING_STOPPED_ES, "Grabacin de sonido detenida..." },
/* fr */ { IDS_SOUND_RECORDING_STOPPED_FR, "Enregistrement du son arrt..." },
/* hu */ { IDS_SOUND_RECORDING_STOPPED_HU, "" },  /* fuzzy */
/* it */ { IDS_SOUND_RECORDING_STOPPED_IT, "Registrazione audio interrotta..." },
/* ko */ { IDS_SOUND_RECORDING_STOPPED_KO, " ڵ ..." },
/* nl */ { IDS_SOUND_RECORDING_STOPPED_NL, "Geluidsopname gestopt..." },
/* pl */ { IDS_SOUND_RECORDING_STOPPED_PL, "Zatrzymano odtwarzanie dwiku..." },
/* ru */ { IDS_SOUND_RECORDING_STOPPED_RU, "  ..." },
/* sv */ { IDS_SOUND_RECORDING_STOPPED_SV, "Ljudinspelning stoppad..." },
/* tr */ { IDS_SOUND_RECORDING_STOPPED_TR, "Ses Kayd durduruldu..." },

/* en */ { IDS_SOUND_RECORDING_STARTED,    "Sound Recording started..." },
/* da */ { IDS_SOUND_RECORDING_STARTED_DA, "Lydoptagelse startet..." },
/* de */ { IDS_SOUND_RECORDING_STARTED_DE, "Tonaufnahme gestartet..." },
/* es */ { IDS_SOUND_RECORDING_STARTED_ES, "Grabacin de sonido iniciada..." },
/* fr */ { IDS_SOUND_RECORDING_STARTED_FR, "Dmarrage de l'enregistrement du son..." },
/* hu */ { IDS_SOUND_RECORDING_STARTED_HU, "" },  /* fuzzy */
/* it */ { IDS_SOUND_RECORDING_STARTED_IT, "Registrazione audio avviata..." },
/* ko */ { IDS_SOUND_RECORDING_STARTED_KO, " ڵ ߽ϴ..." },
/* nl */ { IDS_SOUND_RECORDING_STARTED_NL, "Geluidsopname gestart..." },
/* pl */ { IDS_SOUND_RECORDING_STARTED_PL, "Rozpoczto odtwarzanie dwiku..." },
/* ru */ { IDS_SOUND_RECORDING_STARTED_RU, "  ..." },
/* sv */ { IDS_SOUND_RECORDING_STARTED_SV, "Ljudinspelning startad..." },
/* tr */ { IDS_SOUND_RECORDING_STARTED_TR, "Ses Kayd balad..." },

/* en */ { IDS_SELECT_RECORD_FILE,    "Select Sound Record File" },
/* da */ { IDS_SELECT_RECORD_FILE_DA, "Vlg lydoptagelsesfil" },
/* de */ { IDS_SELECT_RECORD_FILE_DE, "Tonaufnahmedatei whlen" },
/* es */ { IDS_SELECT_RECORD_FILE_ES, "Seleccionar fichero grabacin sonido" },
/* fr */ { IDS_SELECT_RECORD_FILE_FR, "Slectionnez le fichier d'enregistrement du son" },
/* hu */ { IDS_SELECT_RECORD_FILE_HU, "Vlassza ki a hangfelvtel kimeneti fjlt" },
/* it */ { IDS_SELECT_RECORD_FILE_IT, "Seleziona file per registrazione audio" },
/* ko */ { IDS_SELECT_RECORD_FILE_KO, "" },  /* fuzzy */
/* nl */ { IDS_SELECT_RECORD_FILE_NL, "Selecteer geluidsopnamebestand" },
/* pl */ { IDS_SELECT_RECORD_FILE_PL, "Wybierz plik zapisu dwiku" },
/* ru */ { IDS_SELECT_RECORD_FILE_RU, "Select Sound Record File" },
/* sv */ { IDS_SELECT_RECORD_FILE_SV, "Vlj ljudinspelningsfil" },
/* tr */ { IDS_SELECT_RECORD_FILE_TR, "Ses Kayt Dosyas Sein" },

/* en */ { IDS_SOUND_RECORD_FORMAT,    "Sound Record Format" },
/* da */ { IDS_SOUND_RECORD_FORMAT_DA, "Format for lydoptagelse" },
/* de */ { IDS_SOUND_RECORD_FORMAT_DE, "Tonaufnahmeformat" },
/* es */ { IDS_SOUND_RECORD_FORMAT_ES, "Formato grabacin de sonido" },
/* fr */ { IDS_SOUND_RECORD_FORMAT_FR, "Format de l'enregistrement du son" },
/* hu */ { IDS_SOUND_RECORD_FORMAT_HU, "Hangfelvtel formtuma" },
/* it */ { IDS_SOUND_RECORD_FORMAT_IT, "Formato registrazione audio" },
/* ko */ { IDS_SOUND_RECORD_FORMAT_KO, " ڵ " },
/* nl */ { IDS_SOUND_RECORD_FORMAT_NL, "Geluidsopname Formaat" },
/* pl */ { IDS_SOUND_RECORD_FORMAT_PL, "Format zapisu dwiku" },
/* ru */ { IDS_SOUND_RECORD_FORMAT_RU, "Sound Record Format" },
/* sv */ { IDS_SOUND_RECORD_FORMAT_SV, "Format fr ljudinspelning" },
/* tr */ { IDS_SOUND_RECORD_FORMAT_TR, "Ses Kayt Biimi" },

/* en */ { IDS_SOUND_RECORD_FILE,    "Sound Record File" },
/* da */ { IDS_SOUND_RECORD_FILE_DA, "Lydoptagelsesfil" },
/* de */ { IDS_SOUND_RECORD_FILE_DE, "Tonaufnahmedatei" },
/* es */ { IDS_SOUND_RECORD_FILE_ES, "Fichero grabacin de sonido" },
/* fr */ { IDS_SOUND_RECORD_FILE_FR, "Fichier d'enregistrement du son" },
/* hu */ { IDS_SOUND_RECORD_FILE_HU, "Hangfelvtel fjl" },
/* it */ { IDS_SOUND_RECORD_FILE_IT, "File registrazione audio" },
/* ko */ { IDS_SOUND_RECORD_FILE_KO, " ڵ " },
/* nl */ { IDS_SOUND_RECORD_FILE_NL, "Geluid opnamebestand" },
/* pl */ { IDS_SOUND_RECORD_FILE_PL, "Plik zapisu dwiku" },
/* ru */ { IDS_SOUND_RECORD_FILE_RU, "Sound Record File" },
/* sv */ { IDS_SOUND_RECORD_FILE_SV, "Ljudinspelningsfil" },
/* tr */ { IDS_SOUND_RECORD_FILE_TR, "Ses Kayt Dosyas" },

/* en */ { IDS_SOUND_RECORD_SETTINGS,    "Sound record settings" },
/* da */ { IDS_SOUND_RECORD_SETTINGS_DA, "Lydoptagelsesindstillinger" },
/* de */ { IDS_SOUND_RECORD_SETTINGS_DE, "Tonaufnahme Einstellungen" },
/* es */ { IDS_SOUND_RECORD_SETTINGS_ES, "Ajustes grabacin de sonido" },
/* fr */ { IDS_SOUND_RECORD_SETTINGS_FR, "Paramtres de l'enregistrement du son" },
/* hu */ { IDS_SOUND_RECORD_SETTINGS_HU, "Hangfelvtel belltsai" },
/* it */ { IDS_SOUND_RECORD_SETTINGS_IT, "Impostazioni registrazione audio" },
/* ko */ { IDS_SOUND_RECORD_SETTINGS_KO, " ڵ " },
/* nl */ { IDS_SOUND_RECORD_SETTINGS_NL, "Geluidsopname instellingen" },
/* pl */ { IDS_SOUND_RECORD_SETTINGS_PL, "Ustawienia zapisu dwiku" },
/* ru */ { IDS_SOUND_RECORD_SETTINGS_RU, "  " },
/* sv */ { IDS_SOUND_RECORD_SETTINGS_SV, "Instllningar fr ljudinspelning" },
/* tr */ { IDS_SOUND_RECORD_SETTINGS_TR, "Ses kayt ayarlar" },

/* en */ { IDS_VERY_SMALL,    "Very small" },
/* da */ { IDS_VERY_SMALL_DA, "" },  /* fuzzy */
/* de */ { IDS_VERY_SMALL_DE, "Sehr klein" },
/* es */ { IDS_VERY_SMALL_ES, "Muy pequeo" },
/* fr */ { IDS_VERY_SMALL_FR, "" },  /* fuzzy */
/* hu */ { IDS_VERY_SMALL_HU, "" },  /* fuzzy */
/* it */ { IDS_VERY_SMALL_IT, "Molto piccolo" },
/* ko */ { IDS_VERY_SMALL_KO, "" },  /* fuzzy */
/* nl */ { IDS_VERY_SMALL_NL, "Erg klein" },
/* pl */ { IDS_VERY_SMALL_PL, "Bardzo may" },
/* ru */ { IDS_VERY_SMALL_RU, "" },  /* fuzzy */
/* sv */ { IDS_VERY_SMALL_SV, "Vldigt liten" },
/* tr */ { IDS_VERY_SMALL_TR, "" },  /* fuzzy */

/* en */ { IDS_SMALL,    "Small" },
/* da */ { IDS_SMALL_DA, "Lille" },
/* de */ { IDS_SMALL_DE, "Klein" },
/* es */ { IDS_SMALL_ES, "Pequeo" },
/* fr */ { IDS_SMALL_FR, "Petit" },
/* hu */ { IDS_SMALL_HU, "Kicsi" },
/* it */ { IDS_SMALL_IT, "Piccolo" },
/* ko */ { IDS_SMALL_KO, "۴" },
/* nl */ { IDS_SMALL_NL, "Klein" },
/* pl */ { IDS_SMALL_PL, "May" },
/* ru */ { IDS_SMALL_RU, "" },
/* sv */ { IDS_SMALL_SV, "Liten" },
/* tr */ { IDS_SMALL_TR, "Kk" },

/* en */ { IDS_MEDIUM,    "Medium" },
/* da */ { IDS_MEDIUM_DA, "Medium" },
/* de */ { IDS_MEDIUM_DE, "Mittel" },
/* es */ { IDS_MEDIUM_ES, "Medio" },
/* fr */ { IDS_MEDIUM_FR, "Moyen" },
/* hu */ { IDS_MEDIUM_HU, "Kzepes" },
/* it */ { IDS_MEDIUM_IT, "Medio" },
/* ko */ { IDS_MEDIUM_KO, "߰" },
/* nl */ { IDS_MEDIUM_NL, "Middelmatig" },
/* pl */ { IDS_MEDIUM_PL, "redni" },
/* ru */ { IDS_MEDIUM_RU, "" },
/* sv */ { IDS_MEDIUM_SV, "Medium" },
/* tr */ { IDS_MEDIUM_TR, "Orta" },

/* en */ { IDS_LARGE,    "Large" },
/* da */ { IDS_LARGE_DA, "Stor" },
/* de */ { IDS_LARGE_DE, "Gro" },
/* es */ { IDS_LARGE_ES, "Grande" },
/* fr */ { IDS_LARGE_FR, "Grand" },
/* hu */ { IDS_LARGE_HU, "Nagy" },
/* it */ { IDS_LARGE_IT, "Grande" },
/* ko */ { IDS_LARGE_KO, "ū" },
/* nl */ { IDS_LARGE_NL, "Groot" },
/* pl */ { IDS_LARGE_PL, "Wielki" },
/* ru */ { IDS_LARGE_RU, "" },
/* sv */ { IDS_LARGE_SV, "Stor" },
/* tr */ { IDS_LARGE_TR, "Byk" },

/* en */ { IDS_VERY_LARGE,    "Very large" },
/* da */ { IDS_VERY_LARGE_DA, "" },  /* fuzzy */
/* de */ { IDS_VERY_LARGE_DE, "Sehr gro" },
/* es */ { IDS_VERY_LARGE_ES, "Muy grande" },
/* fr */ { IDS_VERY_LARGE_FR, "" },  /* fuzzy */
/* hu */ { IDS_VERY_LARGE_HU, "" },  /* fuzzy */
/* it */ { IDS_VERY_LARGE_IT, "Molto grande" },
/* ko */ { IDS_VERY_LARGE_KO, "" },  /* fuzzy */
/* nl */ { IDS_VERY_LARGE_NL, "Erg groot" },
/* pl */ { IDS_VERY_LARGE_PL, "Bardzo duy" },
/* ru */ { IDS_VERY_LARGE_RU, "" },  /* fuzzy */
/* sv */ { IDS_VERY_LARGE_SV, "Vldigt stor" },
/* tr */ { IDS_VERY_LARGE_TR, "" },  /* fuzzy */

/* en */ { IDS_BORDER_MODE,    "Border mode" },
/* da */ { IDS_BORDER_MODE_DA, "Ramme-tilstand" },
/* de */ { IDS_BORDER_MODE_DE, "Rahmen Modus" },
/* es */ { IDS_BORDER_MODE_ES, "Modo del borde" },
/* fr */ { IDS_BORDER_MODE_FR, "Mode Bordure" },
/* hu */ { IDS_BORDER_MODE_HU, "Keret md" },
/* it */ { IDS_BORDER_MODE_IT, "Modalit del bordo" },
/* ko */ { IDS_BORDER_MODE_KO, " " },
/* nl */ { IDS_BORDER_MODE_NL, "Bordermodus" },
/* pl */ { IDS_BORDER_MODE_PL, "Tryb ramki" },
/* ru */ { IDS_BORDER_MODE_RU, "Border mode" },
/* sv */ { IDS_BORDER_MODE_SV, "Ramlge" },
/* tr */ { IDS_BORDER_MODE_TR, "ereve modu" },

/* en */ { IDMS_NORMAL,    "Normal" },
/* da */ { IDMS_NORMAL_DA, "Normal" },
/* de */ { IDMS_NORMAL_DE, "Normal" },
/* es */ { IDMS_NORMAL_ES, "Normal" },
/* fr */ { IDMS_NORMAL_FR, "Normal" },
/* hu */ { IDMS_NORMAL_HU, "Norml" },
/* it */ { IDMS_NORMAL_IT, "Normale" },
/* ko */ { IDMS_NORMAL_KO, "" },
/* nl */ { IDMS_NORMAL_NL, "Normaal" },
/* pl */ { IDMS_NORMAL_PL, "Zwyky" },
/* ru */ { IDMS_NORMAL_RU, "Normal" },
/* sv */ { IDMS_NORMAL_SV, "Normal" },
/* tr */ { IDMS_NORMAL_TR, "Normal" },

/* en */ { IDS_FULL,    "Full" },
/* da */ { IDS_FULL_DA, "Fuld" },
/* de */ { IDS_FULL_DE, "Full" },
/* es */ { IDS_FULL_ES, "Completo" },
/* fr */ { IDS_FULL_FR, "Complet" },
/* hu */ { IDS_FULL_HU, "Teljes" },
/* it */ { IDS_FULL_IT, "Intero" },
/* ko */ { IDS_FULL_KO, "" },
/* nl */ { IDS_FULL_NL, "Volledig" },
/* pl */ { IDS_FULL_PL, "Peny" },
/* ru */ { IDS_FULL_RU, "Full" },
/* sv */ { IDS_FULL_SV, "Full" },
/* tr */ { IDS_FULL_TR, "Tam" },

/* en */ { IDS_DEBUG,    "Debug" },
/* da */ { IDS_DEBUG_DA, "Debug" },
/* de */ { IDS_DEBUG_DE, "Debug" },
/* es */ { IDS_DEBUG_ES, "Depurar" },
/* fr */ { IDS_DEBUG_FR, "Dbug" },
/* hu */ { IDS_DEBUG_HU, "Nyomkvets" },
/* it */ { IDS_DEBUG_IT, "Debug" },
/* ko */ { IDS_DEBUG_KO, "" },
/* nl */ { IDS_DEBUG_NL, "Debug" },
/* pl */ { IDS_DEBUG_PL, "Debug" },
/* ru */ { IDS_DEBUG_RU, "Debug" },
/* sv */ { IDS_DEBUG_SV, "Felsk" },
/* tr */ { IDS_DEBUG_TR, "Hata Ayklama" },

/* en */ { IDS_VOLUME,    "Volume (0-100%)" },
/* da */ { IDS_VOLUME_DA, "Volume (0-100 %)" },
/* de */ { IDS_VOLUME_DE, "Lautstrke (0-100%)" },
/* es */ { IDS_VOLUME_ES, "Volumen (0-100%)" },
/* fr */ { IDS_VOLUME_FR, "Volume (0-100%)" },
/* hu */ { IDS_VOLUME_HU, "Hanger (0-100%)" },
/* it */ { IDS_VOLUME_IT, "Volume (0-100%)" },
/* ko */ { IDS_VOLUME_KO, " (0-100%)" },
/* nl */ { IDS_VOLUME_NL, "Volume (0-100%)" },
/* pl */ { IDS_VOLUME_PL, "Gono (0-100%)" },
/* ru */ { IDS_VOLUME_RU, "Volume (0-100%)" },
/* sv */ { IDS_VOLUME_SV, "Volym (0-100 %)" },
/* tr */ { IDS_VOLUME_TR, "Ses Dzeyi (0-100%)" },

/* en */ { IDS_SOUND_OUTPUT_MODE,    "Sound output mode" },
/* da */ { IDS_SOUND_OUTPUT_MODE_DA, "Lydindstillinger" },
/* de */ { IDS_SOUND_OUTPUT_MODE_DE, "Ton Ausgabe Modus" },
/* es */ { IDS_SOUND_OUTPUT_MODE_ES, "Modo salida sonido" },
/* fr */ { IDS_SOUND_OUTPUT_MODE_FR, "Mode de sortie de son" },
/* hu */ { IDS_SOUND_OUTPUT_MODE_HU, "" },  /* fuzzy */
/* it */ { IDS_SOUND_OUTPUT_MODE_IT, "Modalit di uscita audio" },
/* ko */ { IDS_SOUND_OUTPUT_MODE_KO, "" },  /* fuzzy */
/* nl */ { IDS_SOUND_OUTPUT_MODE_NL, "Geluid uitvoer modus" },
/* pl */ { IDS_SOUND_OUTPUT_MODE_PL, "Tryb wyjcia dwiku" },
/* ru */ { IDS_SOUND_OUTPUT_MODE_RU, "" },  /* fuzzy */
/* sv */ { IDS_SOUND_OUTPUT_MODE_SV, "Utdatalge fr ljud" },
/* tr */ { IDS_SOUND_OUTPUT_MODE_TR, "Ses k modu" },

/* en */ { IDS_SYSTEM,    "System" },
/* da */ { IDS_SYSTEM_DA, "System" },
/* de */ { IDS_SYSTEM_DE, "System" },
/* es */ { IDS_SYSTEM_ES, "Sistema" },
/* fr */ { IDS_SYSTEM_FR, "Systme" },
/* hu */ { IDS_SYSTEM_HU, "" },  /* fuzzy */
/* it */ { IDS_SYSTEM_IT, "Sistema" },
/* ko */ { IDS_SYSTEM_KO, "" },  /* fuzzy */
/* nl */ { IDS_SYSTEM_NL, "Systeem" },
/* pl */ { IDS_SYSTEM_PL, "System" },
/* ru */ { IDS_SYSTEM_RU, "System" },
/* sv */ { IDS_SYSTEM_SV, "System" },
/* tr */ { IDS_SYSTEM_TR, "Sistem" },

/* en */ { IDS_MONO,    "Mono" },
/* da */ { IDS_MONO_DA, "Mono" },
/* de */ { IDS_MONO_DE, "Mono" },
/* es */ { IDS_MONO_ES, "Mono" },
/* fr */ { IDS_MONO_FR, "Mono" },
/* hu */ { IDS_MONO_HU, "" },  /* fuzzy */
/* it */ { IDS_MONO_IT, "Mono" },
/* ko */ { IDS_MONO_KO, "" },  /* fuzzy */
/* nl */ { IDS_MONO_NL, "Mono" },
/* pl */ { IDS_MONO_PL, "Mono" },
/* ru */ { IDS_MONO_RU, "" },
/* sv */ { IDS_MONO_SV, "Mono" },
/* tr */ { IDS_MONO_TR, "Mono" },

/* en */ { IDS_STEREO,    "Stereo" },
/* da */ { IDS_STEREO_DA, "Stereo" },
/* de */ { IDS_STEREO_DE, "Stereo" },
/* es */ { IDS_STEREO_ES, "Estereo" },
/* fr */ { IDS_STEREO_FR, "Stro" },
/* hu */ { IDS_STEREO_HU, "" },  /* fuzzy */
/* it */ { IDS_STEREO_IT, "Stereo" },
/* ko */ { IDS_STEREO_KO, "" },  /* fuzzy */
/* nl */ { IDS_STEREO_NL, "Stereo" },
/* pl */ { IDS_STEREO_PL, "Stereo" },
/* ru */ { IDS_STEREO_RU, "" },
/* sv */ { IDS_STEREO_SV, "Stereo" },
/* tr */ { IDS_STEREO_TR, "Stereo" },

/* en */ { IDS_MOUSE_TYPE,    "Mouse type" },
/* da */ { IDS_MOUSE_TYPE_DA, "Mussetype" },
/* de */ { IDS_MOUSE_TYPE_DE, "Maustyp" },
/* es */ { IDS_MOUSE_TYPE_ES, "Tipo ratn" },
/* fr */ { IDS_MOUSE_TYPE_FR, "Type de souris" },
/* hu */ { IDS_MOUSE_TYPE_HU, "Egr tpusa" },
/* it */ { IDS_MOUSE_TYPE_IT, "Tipo di mouse" },
/* ko */ { IDS_MOUSE_TYPE_KO, "콺 Ÿ" },
/* nl */ { IDS_MOUSE_TYPE_NL, "Muis soort" },
/* pl */ { IDS_MOUSE_TYPE_PL, "Typ myszy" },
/* ru */ { IDS_MOUSE_TYPE_RU, " " },
/* sv */ { IDS_MOUSE_TYPE_SV, "Mustyp" },
/* tr */ { IDS_MOUSE_TYPE_TR, "Mouse tipi" },

/* en */ { IDS_MOUSE_SETTINGS,    "Mouse settings" },
/* da */ { IDS_MOUSE_SETTINGS_DA, "Musseindstillinger" },
/* de */ { IDS_MOUSE_SETTINGS_DE, "Maus Einstellungen" },
/* es */ { IDS_MOUSE_SETTINGS_ES, "Ajustes ratn" },
/* fr */ { IDS_MOUSE_SETTINGS_FR, "Paramtres de souris" },
/* hu */ { IDS_MOUSE_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_MOUSE_SETTINGS_IT, "Impostazioni mouse" },
/* ko */ { IDS_MOUSE_SETTINGS_KO, "콺 " },
/* nl */ { IDS_MOUSE_SETTINGS_NL, "Muis instellingen" },
/* pl */ { IDS_MOUSE_SETTINGS_PL, "Ustawienia myszy" },
/* ru */ { IDS_MOUSE_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_MOUSE_SETTINGS_SV, "Musinstllningar" },
/* tr */ { IDS_MOUSE_SETTINGS_TR, "Mouse Ayarlar" },

/* en */ { IDS_MOUSE_PORT,    "Mouse port" },
/* da */ { IDS_MOUSE_PORT_DA, "Musseport" },
/* de */ { IDS_MOUSE_PORT_DE, "Maus Port" },
/* es */ { IDS_MOUSE_PORT_ES, "Puerto del ratn" },
/* fr */ { IDS_MOUSE_PORT_FR, "Port de la souris" },
/* hu */ { IDS_MOUSE_PORT_HU, "Egr port" },
/* it */ { IDS_MOUSE_PORT_IT, "Porta del mouse" },
/* ko */ { IDS_MOUSE_PORT_KO, "콺 Ʈ" },
/* nl */ { IDS_MOUSE_PORT_NL, "Muis poort" },
/* pl */ { IDS_MOUSE_PORT_PL, "Port myszy" },
/* ru */ { IDS_MOUSE_PORT_RU, " " },
/* sv */ { IDS_MOUSE_PORT_SV, "Musport" },
/* tr */ { IDS_MOUSE_PORT_TR, "Mouse portu" },

/* en */ { IDS_SMART_MOUSE_RTC_SAVE,    "Enable Smart Mouse RTC saving" },
/* da */ { IDS_SMART_MOUSE_RTC_SAVE_DA, "" },  /* fuzzy */
/* de */ { IDS_SMART_MOUSE_RTC_SAVE_DE, "Smart Mouse RTC Speicherung aktivieren" },
/* es */ { IDS_SMART_MOUSE_RTC_SAVE_ES, "Permitir grabar Smart Mouse RTC" },
/* fr */ { IDS_SMART_MOUSE_RTC_SAVE_FR, "" },  /* fuzzy */
/* hu */ { IDS_SMART_MOUSE_RTC_SAVE_HU, "" },  /* fuzzy */
/* it */ { IDS_SMART_MOUSE_RTC_SAVE_IT, "Attiva salvataggio RTC dello Smart Mouse" },
/* ko */ { IDS_SMART_MOUSE_RTC_SAVE_KO, "" },  /* fuzzy */
/* nl */ { IDS_SMART_MOUSE_RTC_SAVE_NL, "Activeer het opslaan van de Smart Mouse RTC" },
/* pl */ { IDS_SMART_MOUSE_RTC_SAVE_PL, "Wcz zapis zegara Smart Mouse" },
/* ru */ { IDS_SMART_MOUSE_RTC_SAVE_RU, "" },  /* fuzzy */
/* sv */ { IDS_SMART_MOUSE_RTC_SAVE_SV, "" },  /* fuzzy */
/* tr */ { IDS_SMART_MOUSE_RTC_SAVE_TR, "" },  /* fuzzy */

/* en */ { IDS_AUTOSTART_VIRTUAL_FS,    "Virtual FS" },
/* da */ { IDS_AUTOSTART_VIRTUAL_FS_DA, "Virtuelt FS" },
/* de */ { IDS_AUTOSTART_VIRTUAL_FS_DE, "Virtual FS" },
/* es */ { IDS_AUTOSTART_VIRTUAL_FS_ES, "FS virtual" },
/* fr */ { IDS_AUTOSTART_VIRTUAL_FS_FR, "SF virtuel" },
/* hu */ { IDS_AUTOSTART_VIRTUAL_FS_HU, "Virtulis fjlrendszer" },
/* it */ { IDS_AUTOSTART_VIRTUAL_FS_IT, "Virtual FS" },
/* ko */ { IDS_AUTOSTART_VIRTUAL_FS_KO, "߾ ϽŸ" },
/* nl */ { IDS_AUTOSTART_VIRTUAL_FS_NL, "Virtueel Bestandssysteem" },
/* pl */ { IDS_AUTOSTART_VIRTUAL_FS_PL, "Wirtualny system plikw" },
/* ru */ { IDS_AUTOSTART_VIRTUAL_FS_RU, "Virtual FS" },
/* sv */ { IDS_AUTOSTART_VIRTUAL_FS_SV, "Virtuellt FS" },
/* tr */ { IDS_AUTOSTART_VIRTUAL_FS_TR, "Sanal FS" },

/* en */ { IDS_AUTOSTART_INJECT,    "Inject to RAM" },
/* da */ { IDS_AUTOSTART_INJECT_DA, "Indskyd til RAM" },
/* de */ { IDS_AUTOSTART_INJECT_DE, "Inject ins RAM" },
/* es */ { IDS_AUTOSTART_INJECT_ES, "Introd. en RAM" },
/* fr */ { IDS_AUTOSTART_INJECT_FR, "Injecter dans le RAM" },
/* hu */ { IDS_AUTOSTART_INJECT_HU, "" },  /* fuzzy */
/* it */ { IDS_AUTOSTART_INJECT_IT, "Immetti su RAM" },
/* ko */ { IDS_AUTOSTART_INJECT_KO, "RAM  ϱ" },
/* nl */ { IDS_AUTOSTART_INJECT_NL, "injecteer in RAM" },
/* pl */ { IDS_AUTOSTART_INJECT_PL, "Wylij do RAM-u" },
/* ru */ { IDS_AUTOSTART_INJECT_RU, "Inject to RAM" },
/* sv */ { IDS_AUTOSTART_INJECT_SV, "Lgg in i RAM" },
/* tr */ { IDS_AUTOSTART_INJECT_TR, "RAM'e enjekte et" },

/* en */ { IDS_AUTOSTART_DISK,    "Disk image" },
/* da */ { IDS_AUTOSTART_DISK_DA, "Diskimage" },
/* de */ { IDS_AUTOSTART_DISK_DE, "Disk Image" },
/* es */ { IDS_AUTOSTART_DISK_ES, "Imag. disco" },
/* fr */ { IDS_AUTOSTART_DISK_FR, "Image de disque" },
/* hu */ { IDS_AUTOSTART_DISK_HU, "Lemez kpms" },
/* it */ { IDS_AUTOSTART_DISK_IT, "Immagine disco" },
/* ko */ { IDS_AUTOSTART_DISK_KO, "ũ ̹" },
/* nl */ { IDS_AUTOSTART_DISK_NL, "Disk bestand" },
/* pl */ { IDS_AUTOSTART_DISK_PL, "Obraz dyskietki" },
/* ru */ { IDS_AUTOSTART_DISK_RU, " " },
/* sv */ { IDS_AUTOSTART_DISK_SV, "Diskavbildning" },
/* tr */ { IDS_AUTOSTART_DISK_TR, "Disk imaj" },

/* en */ { IDS_AUTOSTART_DISK_IMAGE_SELECT,    "Select file for PRG autostart disk" },
/* da */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_DA, "Vlg fil for PRG autostartdiskette" },
/* de */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_DE, "Datei fr PRG Autostart auswhlen" },
/* es */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_ES, "Seleccionar fichero par autorranque disco para PRG" },
/* fr */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_FR, "Slectionner fichier pour autodmarrage PRG" },
/* hu */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_HU, "Vlasszon lemezfjlt a PRG automatikus indtshoz" },
/* it */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_IT, "Seleziona file per avvio automatico PRG" },
/* ko */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_NL, "Selecteer bestand voor PRG autostart disk" },
/* pl */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_PL, "Wybierz plik dysku do automatycznego startu z PRG" },
/* ru */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_RU, "Select file for PRG autostart disk" },
/* sv */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_SV, "Vlj fil fr PRG-autostartdisk" },
/* tr */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_TR, "PRG otomatik balatma iin dosya sein" },

/* en */ { IDS_WARP_ON_AUTOSTART,    "Autostart warp" },
/* da */ { IDS_WARP_ON_AUTOSTART_DA, "Autostart i warp-tilstand" },
/* de */ { IDS_WARP_ON_AUTOSTART_DE, "Autostart Warp" },
/* es */ { IDS_WARP_ON_AUTOSTART_ES, "Autoarranque Warp" },
/* fr */ { IDS_WARP_ON_AUTOSTART_FR, "Turbo  l'autodmarrage" },
/* hu */ { IDS_WARP_ON_AUTOSTART_HU, "Automatikus indts hipergyors" },
/* it */ { IDS_WARP_ON_AUTOSTART_IT, "Avvio automatico in turbo" },
/* ko */ { IDS_WARP_ON_AUTOSTART_KO, "ڵ  warp" },
/* nl */ { IDS_WARP_ON_AUTOSTART_NL, "Autostart warp" },
/* pl */ { IDS_WARP_ON_AUTOSTART_PL, "Turbo przy autostarcie" },
/* ru */ { IDS_WARP_ON_AUTOSTART_RU, "Autostart warp" },
/* sv */ { IDS_WARP_ON_AUTOSTART_SV, "Starta warp automatiskt" },
/* tr */ { IDS_WARP_ON_AUTOSTART_TR, "Warp modunda otomatik balat" },

/* en */ { IDS_AUTOSTART_RANDOM_DELAY,    "Autostart random delay" },
/* da */ { IDS_AUTOSTART_RANDOM_DELAY_DA, "Tilfldig forsinkelse p autostart" },
/* de */ { IDS_AUTOSTART_RANDOM_DELAY_DE, "Autostart Zufallsverzgerung" },
/* es */ { IDS_AUTOSTART_RANDOM_DELAY_ES, "Autoarranque retardo aleatorio" },
/* fr */ { IDS_AUTOSTART_RANDOM_DELAY_FR, "Dlai alatoire  l'autodmarrage" },
/* hu */ { IDS_AUTOSTART_RANDOM_DELAY_HU, "" },  /* fuzzy */
/* it */ { IDS_AUTOSTART_RANDOM_DELAY_IT, "Ritardo casuale all'avvio automatico" },
/* ko */ { IDS_AUTOSTART_RANDOM_DELAY_KO, "" },  /* fuzzy */
/* nl */ { IDS_AUTOSTART_RANDOM_DELAY_NL, "Willekeurige vertraging van de autostart" },
/* pl */ { IDS_AUTOSTART_RANDOM_DELAY_PL, "Losowe opnienie autostartu" },
/* ru */ { IDS_AUTOSTART_RANDOM_DELAY_RU, "Autostart random delay" },
/* sv */ { IDS_AUTOSTART_RANDOM_DELAY_SV, "Slumpmssig frdrjning fr autostart" },
/* tr */ { IDS_AUTOSTART_RANDOM_DELAY_TR, "Rastgele gecikmeyle otomatik balat" },

/* en */ { IDS_RUN_WITH_COLON,    "Use ':' with RUN" },
/* da */ { IDS_RUN_WITH_COLON_DA, "Brug \":\" med RUN" },
/* de */ { IDS_RUN_WITH_COLON_DE, "Verwende ':' mit RUN" },
/* es */ { IDS_RUN_WITH_COLON_ES, "Usar ':' con RUN" },
/* fr */ { IDS_RUN_WITH_COLON_FR, "Utiliser \":\" avec RUN" },
/* hu */ { IDS_RUN_WITH_COLON_HU, "" },  /* fuzzy */
/* it */ { IDS_RUN_WITH_COLON_IT, "Usa ':' con RUN" },
/* ko */ { IDS_RUN_WITH_COLON_KO, "':'  RUN  ϱ" },
/* nl */ { IDS_RUN_WITH_COLON_NL, "Gebruik ':' met RUN" },
/* pl */ { IDS_RUN_WITH_COLON_PL, "Uywaj ':' z RUN" },
/* ru */ { IDS_RUN_WITH_COLON_RU, "Use ':' with RUN" },
/* sv */ { IDS_RUN_WITH_COLON_SV, "Anvnd \":\" med RUN" },
/* tr */ { IDS_RUN_WITH_COLON_TR, "ALITIR ile ':' kullan" },

/* en */ { IDS_AUTOSTART_PRG_MODE,    "PRG autostart mode" },
/* da */ { IDS_AUTOSTART_PRG_MODE_DA, "PRG-autostarttilstand" },
/* de */ { IDS_AUTOSTART_PRG_MODE_DE, "PRG Autostartmodus" },
/* es */ { IDS_AUTOSTART_PRG_MODE_ES, "Modo autoarranque PRG" },
/* fr */ { IDS_AUTOSTART_PRG_MODE_FR, "Mode d'autodmarrage des PRG" },
/* hu */ { IDS_AUTOSTART_PRG_MODE_HU, "PRG automatikus indts md" },
/* it */ { IDS_AUTOSTART_PRG_MODE_IT, "Avvio automatico PRG" },
/* ko */ { IDS_AUTOSTART_PRG_MODE_KO, "PRG 佺Ʈ " },
/* nl */ { IDS_AUTOSTART_PRG_MODE_NL, "PRG autostart modus" },
/* pl */ { IDS_AUTOSTART_PRG_MODE_PL, "Tryb autostartu z PRG" },
/* ru */ { IDS_AUTOSTART_PRG_MODE_RU, "PRG autostart mode" },
/* sv */ { IDS_AUTOSTART_PRG_MODE_SV, "Autostartlge fr PRG" },
/* tr */ { IDS_AUTOSTART_PRG_MODE_TR, "PRG otomatik balatma modu" },

/* en */ { IDS_AUTOSTART_LOAD_TO_BASIC_START,    "Load to BASIC start" },
/* da */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_DA, "Indls ved BASIC start" },
/* de */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_DE, "Lade an Basic Start" },
/* es */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_ES, "Cargar a inicio BASIC" },
/* fr */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_FR, "Charger au dmarrage BASIC" },
/* hu */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_HU, "" },  /* fuzzy */
/* it */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_IT, "Carica all'inizio del BASIC" },
/* ko */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_KO, "BASIC   εϱ" },
/* nl */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_NL, "Laad naar BASIC start" },
/* pl */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_PL, "Wczytuj do BASIC-a" },
/* ru */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_RU, "" },  /* fuzzy */
/* sv */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_SV, "Ls till BASIC-start" },
/* tr */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_TR, "BASIC balangcna ykle" },

/* en */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME,    "PRG autostart disk image" },
/* da */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_DA, "PRG Autostart disk-image" },
/* de */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_DE, "PRG Autostart Disk Image" },
/* es */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_ES, "Autoarranque imagen disco PRG" },
/* fr */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_FR, "Autocharger PRG d'une image de disque" },
/* hu */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_HU, "PRG automatikus indts kpms" },
/* it */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_IT, "Immagine disco avvio automatico PRG" },
/* ko */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_KO, "PRG 佺Ʈ ũ ̹" },
/* nl */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_NL, "PRG autostart disk bestand" },
/* pl */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_PL, "Obraz dyskietki do autostartu z PRG" },
/* ru */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_RU, "PRG autostart disk image" },
/* sv */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_SV, "Autostartdiskavbildning fr PRG" },
/* tr */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_TR, "PRG otomatik balatma disk imaj" },

/* en */ { IDS_AUTOSTART_SETTINGS,    "Autostart settings" },
/* da */ { IDS_AUTOSTART_SETTINGS_DA, "Autostart-indstillinger" },
/* de */ { IDS_AUTOSTART_SETTINGS_DE, "Autostart Einstellungen" },
/* es */ { IDS_AUTOSTART_SETTINGS_ES, "Ajustes de autoinicio" },
/* fr */ { IDS_AUTOSTART_SETTINGS_FR, "Paramtres Autodmarrage" },
/* hu */ { IDS_AUTOSTART_SETTINGS_HU, "Autostart belltsai" },
/* it */ { IDS_AUTOSTART_SETTINGS_IT, "Impostazioni avvio automatico" },
/* ko */ { IDS_AUTOSTART_SETTINGS_KO, "ڵ " },
/* nl */ { IDS_AUTOSTART_SETTINGS_NL, "Autostart instellingen" },
/* pl */ { IDS_AUTOSTART_SETTINGS_PL, "Ustawienia autostartu" },
/* ru */ { IDS_AUTOSTART_SETTINGS_RU, " " },
/* sv */ { IDS_AUTOSTART_SETTINGS_SV, "Autostartinstllningar" },
/* tr */ { IDS_AUTOSTART_SETTINGS_TR, "Otomatik balatma ayarlar" },

/* en */ { IDS_ERROR_SAVING_EASYFLASH_CRT,    "Error saving EasyFlash crt file" },
/* da */ { IDS_ERROR_SAVING_EASYFLASH_CRT_DA, "Fejl under skrivning af EasyFlash CRT-fil" },
/* de */ { IDS_ERROR_SAVING_EASYFLASH_CRT_DE, "Fehler beim Speichern der EasyFlash CRT Datei" },
/* es */ { IDS_ERROR_SAVING_EASYFLASH_CRT_ES, "Error al grabar fichero EasyFlash crt" },
/* fr */ { IDS_ERROR_SAVING_EASYFLASH_CRT_FR, "Erreur de sauvegarde du fichier CRT EasyFlash" },
/* hu */ { IDS_ERROR_SAVING_EASYFLASH_CRT_HU, "Hiba az EasyFlash crt fjl mentse kzben" },
/* it */ { IDS_ERROR_SAVING_EASYFLASH_CRT_IT, "Errore durante il salvataggio del file crt EasyFlash" },
/* ko */ { IDS_ERROR_SAVING_EASYFLASH_CRT_KO, "EasyFlash crt    ߻߽ϴ" },
/* nl */ { IDS_ERROR_SAVING_EASYFLASH_CRT_NL, "Kan het EasyFlash crt bestand niet opslaan" },
/* pl */ { IDS_ERROR_SAVING_EASYFLASH_CRT_PL, "Bd zapisu pliku crt EasyFlash" },
/* ru */ { IDS_ERROR_SAVING_EASYFLASH_CRT_RU, "Error saving EasyFlash crt file" },
/* sv */ { IDS_ERROR_SAVING_EASYFLASH_CRT_SV, "Fel vid skrivning av EasyFlash-crt-fil." },
/* tr */ { IDS_ERROR_SAVING_EASYFLASH_CRT_TR, "EasyFlash crt dosyas kayt hatas" },

/* en */ { IDS_EASYFLASH_JUMPER,    "EasyFlash jumper" },
/* da */ { IDS_EASYFLASH_JUMPER_DA, "EasyFlashjumper" },
/* de */ { IDS_EASYFLASH_JUMPER_DE, "EasyFlash Jumper" },
/* es */ { IDS_EASYFLASH_JUMPER_ES, "Puente EasyFlash" },
/* fr */ { IDS_EASYFLASH_JUMPER_FR, "Jumper EasyFlash" },
/* hu */ { IDS_EASYFLASH_JUMPER_HU, "EasyFlash jumper" },
/* it */ { IDS_EASYFLASH_JUMPER_IT, "Ponticello EasyFlash" },
/* ko */ { IDS_EASYFLASH_JUMPER_KO, "" },  /* fuzzy */
/* nl */ { IDS_EASYFLASH_JUMPER_NL, "EasyFlash jumper" },
/* pl */ { IDS_EASYFLASH_JUMPER_PL, "Zworka EasyFlash" },
/* ru */ { IDS_EASYFLASH_JUMPER_RU, "EasyFlash jumper" },
/* sv */ { IDS_EASYFLASH_JUMPER_SV, "EasyFlash-bygel" },
/* tr */ { IDS_EASYFLASH_JUMPER_TR, "EasyFlash jumper" },

/* en */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH,    "Save to EasyFlash CRT file on detach" },
/* da */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_DA, "Gem til EasyFlash CRT-fil ved afbrydelse" },
/* de */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_DE, "EasyFlash CRT Imagedatei beim entfernen speichern" },
/* es */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_ES, "Grabar fichero al extraer EasyFlash CRT" },
/* fr */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_FR, "Enregistrer sur fichier CRT EasyFlash au dtachement" },
/* hu */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_HU, "EasyFlash CRT fjl mentse levlasztskor" },
/* it */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_IT, "Salva su file CRT EasyFlash alla rimozione" },
/* ko */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_KO, "" },  /* fuzzy */
/* nl */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_NL, "Sla op naar het EasyFlash CRT bestand bij ontkoppelen" },
/* pl */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_PL, "Zapisz do pliku CRT Easy Flash przy odczeniu" },
/* ru */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_RU, "Save to EasyFlash CRT file on detach" },
/* sv */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_SV, "Spara till EasyFlash-CRT-fil vid frnkoppling" },
/* tr */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_TR, "kartldnda EasyFlash CRT dosyasna kaydet" },

/* en */ { IDS_SAVE_EASYFLASH_CRT_NOW,    "Save to EasyFlash CRT now" },
/* da */ { IDS_SAVE_EASYFLASH_CRT_NOW_DA, "Gem til EasyFlash CRT nu" },
/* de */ { IDS_SAVE_EASYFLASH_CRT_NOW_DE, "EasyFlash CRT Imagedatei jetzt speichern" },
/* es */ { IDS_SAVE_EASYFLASH_CRT_NOW_ES, "Grabar en EasyFlash CRT ahora" },
/* fr */ { IDS_SAVE_EASYFLASH_CRT_NOW_FR, "Enregistrer sur fichier CRT EasyFlash maintenant" },
/* hu */ { IDS_SAVE_EASYFLASH_CRT_NOW_HU, "EasyFlash CRT fjl mentse most" },
/* it */ { IDS_SAVE_EASYFLASH_CRT_NOW_IT, "Salva su CRT EasyFlash ora" },
/* ko */ { IDS_SAVE_EASYFLASH_CRT_NOW_KO, "" },  /* fuzzy */
/* nl */ { IDS_SAVE_EASYFLASH_CRT_NOW_NL, "Sla nu op naar het EasyFlash CRT bestand" },
/* pl */ { IDS_SAVE_EASYFLASH_CRT_NOW_PL, "Zapisz do CRT Easy Flash teraz" },
/* ru */ { IDS_SAVE_EASYFLASH_CRT_NOW_RU, "Save to EasyFlash CRT now" },
/* sv */ { IDS_SAVE_EASYFLASH_CRT_NOW_SV, "Spara till EasyFlash-CRT nu" },
/* tr */ { IDS_SAVE_EASYFLASH_CRT_NOW_TR, "Hemen EasyFlash CRT'ye kaydet" },

/* en */ { IDS_6569_PAL,    "6569 (PAL)" },
/* da */ { IDS_6569_PAL_DA, "6569 (PAL)" },
/* de */ { IDS_6569_PAL_DE, "6569 (PAL)" },
/* es */ { IDS_6569_PAL_ES, "6569 (PAL)" },
/* fr */ { IDS_6569_PAL_FR, "6569 (PAL)" },
/* hu */ { IDS_6569_PAL_HU, "" },  /* fuzzy */
/* it */ { IDS_6569_PAL_IT, "6569 (PAL)" },
/* ko */ { IDS_6569_PAL_KO, "" },  /* fuzzy */
/* nl */ { IDS_6569_PAL_NL, "6569 (PAL)" },
/* pl */ { IDS_6569_PAL_PL, "6569 (PAL)" },
/* ru */ { IDS_6569_PAL_RU, "6569 (PAL)" },
/* sv */ { IDS_6569_PAL_SV, "6569 (PAL)" },
/* tr */ { IDS_6569_PAL_TR, "6569 (PAL)" },

/* en */ { IDS_8565_PAL,    "8565 (PAL)" },
/* da */ { IDS_8565_PAL_DA, "8565 (PAL)" },
/* de */ { IDS_8565_PAL_DE, "8565 (PAL)" },
/* es */ { IDS_8565_PAL_ES, "8565 (PAL)" },
/* fr */ { IDS_8565_PAL_FR, "8565 (PAL)" },
/* hu */ { IDS_8565_PAL_HU, "" },  /* fuzzy */
/* it */ { IDS_8565_PAL_IT, "8565 (PAL)" },
/* ko */ { IDS_8565_PAL_KO, "" },  /* fuzzy */
/* nl */ { IDS_8565_PAL_NL, "8565 (PAL)" },
/* pl */ { IDS_8565_PAL_PL, "8565 (PAL)" },
/* ru */ { IDS_8565_PAL_RU, "8565 (PAL)" },
/* sv */ { IDS_8565_PAL_SV, "8565 (PAL)" },
/* tr */ { IDS_8565_PAL_TR, "8565 (PAL)" },

/* en */ { IDS_6569R1_OLD_PAL,    "6569R1 (old PAL)" },
/* da */ { IDS_6569R1_OLD_PAL_DA, "6569R1 (gammel PAL)" },
/* de */ { IDS_6569R1_OLD_PAL_DE, "6569R1 (alt PAL)" },
/* es */ { IDS_6569R1_OLD_PAL_ES, "6569R1 (PAL antiguo)" },
/* fr */ { IDS_6569R1_OLD_PAL_FR, "6569R1 (ancien PAL)" },
/* hu */ { IDS_6569R1_OLD_PAL_HU, "" },  /* fuzzy */
/* it */ { IDS_6569R1_OLD_PAL_IT, "6569R1 (PAL vecchio)" },
/* ko */ { IDS_6569R1_OLD_PAL_KO, "6569R1 (õ PAL)" },
/* nl */ { IDS_6569R1_OLD_PAL_NL, "6569R1 (oud PAL)" },
/* pl */ { IDS_6569R1_OLD_PAL_PL, "6569R1 (stary PAL)" },
/* ru */ { IDS_6569R1_OLD_PAL_RU, "" },  /* fuzzy */
/* sv */ { IDS_6569R1_OLD_PAL_SV, "6569R1 (gammal PAL)" },
/* tr */ { IDS_6569R1_OLD_PAL_TR, "6569R1 (eski PAL)" },

/* en */ { IDS_6567_NTSC,    "6567 (NTSC)" },
/* da */ { IDS_6567_NTSC_DA, "6567 (NTSC)" },
/* de */ { IDS_6567_NTSC_DE, "6567 (NTSC)" },
/* es */ { IDS_6567_NTSC_ES, "6567 (NTSC)" },
/* fr */ { IDS_6567_NTSC_FR, "6567 (NTSC)" },
/* hu */ { IDS_6567_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDS_6567_NTSC_IT, "6567 (NTSC)" },
/* ko */ { IDS_6567_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDS_6567_NTSC_NL, "6567 (NTSC)" },
/* pl */ { IDS_6567_NTSC_PL, "6567 (NTSC)" },
/* ru */ { IDS_6567_NTSC_RU, "6567 (NTSC)" },
/* sv */ { IDS_6567_NTSC_SV, "6567 (NTSC)" },
/* tr */ { IDS_6567_NTSC_TR, "6567 (NTSC)" },

/* en */ { IDS_8562_NTSC,    "8562 (NTSC)" },
/* da */ { IDS_8562_NTSC_DA, "8562 (NTSC)" },
/* de */ { IDS_8562_NTSC_DE, "8562 (NTSC)" },
/* es */ { IDS_8562_NTSC_ES, "8562 (NTSC)" },
/* fr */ { IDS_8562_NTSC_FR, "8562 (NTSC)" },
/* hu */ { IDS_8562_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDS_8562_NTSC_IT, "8562 (NTSC)" },
/* ko */ { IDS_8562_NTSC_KO, "" },  /* fuzzy */
/* nl */ { IDS_8562_NTSC_NL, "8562 (NTSC)" },
/* pl */ { IDS_8562_NTSC_PL, "8562 (NTSC)" },
/* ru */ { IDS_8562_NTSC_RU, "8562 (NTSC)" },
/* sv */ { IDS_8562_NTSC_SV, "8562 (NTSC)" },
/* tr */ { IDS_8562_NTSC_TR, "8562 (NTSC)" },

/* en */ { IDS_6567R56A_OLD_NTSC,    "6567R56A (old NTSC)" },
/* da */ { IDS_6567R56A_OLD_NTSC_DA, "6567R56A (gammel NTSC)" },
/* de */ { IDS_6567R56A_OLD_NTSC_DE, "6567R56A (alt NTSC)" },
/* es */ { IDS_6567R56A_OLD_NTSC_ES, "6567R56A (NTSC antiguo)" },
/* fr */ { IDS_6567R56A_OLD_NTSC_FR, "6567R56A (ancien NTSC)" },
/* hu */ { IDS_6567R56A_OLD_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDS_6567R56A_OLD_NTSC_IT, "6567R56A (NTSC vecchio)" },
/* ko */ { IDS_6567R56A_OLD_NTSC_KO, "6567R56A (õ NTSC)" },
/* nl */ { IDS_6567R56A_OLD_NTSC_NL, "6567R56A (oud NTSC)" },
/* pl */ { IDS_6567R56A_OLD_NTSC_PL, "6567R56A (stary NTSC)" },
/* ru */ { IDS_6567R56A_OLD_NTSC_RU, "" },  /* fuzzy */
/* sv */ { IDS_6567R56A_OLD_NTSC_SV, "6567R56A (gammal NTSC)" },
/* tr */ { IDS_6567R56A_OLD_NTSC_TR, "6567R56A (eski NTSC)" },

/* en */ { IDS_6572_PAL_N,    "6572 (PAL-N)" },
/* da */ { IDS_6572_PAL_N_DA, "6572 (PAL-N)" },
/* de */ { IDS_6572_PAL_N_DE, "6572 (PAL-N)" },
/* es */ { IDS_6572_PAL_N_ES, "6572 (PAL-N)" },
/* fr */ { IDS_6572_PAL_N_FR, "6572 (PAL-N)" },
/* hu */ { IDS_6572_PAL_N_HU, "" },  /* fuzzy */
/* it */ { IDS_6572_PAL_N_IT, "6572 (PAL-N)" },
/* ko */ { IDS_6572_PAL_N_KO, "" },  /* fuzzy */
/* nl */ { IDS_6572_PAL_N_NL, "6572 (PAL-N)" },
/* pl */ { IDS_6572_PAL_N_PL, "6572 (PAL-N)" },
/* ru */ { IDS_6572_PAL_N_RU, "6572 (PAL-N)" },
/* sv */ { IDS_6572_PAL_N_SV, "6572 (PAL-N)" },
/* tr */ { IDS_6572_PAL_N_TR, "6572 (PAL-N)" },

/* en */ { IDS_6526_OLD,    "6526 (old)" },
/* da */ { IDS_6526_OLD_DA, "6526 (gammel)" },
/* de */ { IDS_6526_OLD_DE, "6526 (alt)" },
/* es */ { IDS_6526_OLD_ES, "6526 (antiguo)" },
/* fr */ { IDS_6526_OLD_FR, "6526 (ancien)" },
/* hu */ { IDS_6526_OLD_HU, "" },  /* fuzzy */
/* it */ { IDS_6526_OLD_IT, "6526 (vecchio)" },
/* ko */ { IDS_6526_OLD_KO, "6526 ()" },
/* nl */ { IDS_6526_OLD_NL, "6526 (oud)" },
/* pl */ { IDS_6526_OLD_PL, "6526 (stary)" },
/* ru */ { IDS_6526_OLD_RU, "6526 (old)" },
/* sv */ { IDS_6526_OLD_SV, "6526 (gammal)" },
/* tr */ { IDS_6526_OLD_TR, "6526 (eski)" },

/* en */ { IDS_6526A_NEW,    "6526A (new)" },
/* da */ { IDS_6526A_NEW_DA, "6526A (ny)" },
/* de */ { IDS_6526A_NEW_DE, "6526A (neu)" },
/* es */ { IDS_6526A_NEW_ES, "6526A (nuevo)" },
/* fr */ { IDS_6526A_NEW_FR, "6526A (rcent)" },
/* hu */ { IDS_6526A_NEW_HU, "" },  /* fuzzy */
/* it */ { IDS_6526A_NEW_IT, "6526A (nuovo)" },
/* ko */ { IDS_6526A_NEW_KO, "6526A (ο)" },
/* nl */ { IDS_6526A_NEW_NL, "6526A (nieuw)" },
/* pl */ { IDS_6526A_NEW_PL, "" },  /* fuzzy */
/* ru */ { IDS_6526A_NEW_RU, "6526A (new)" },
/* sv */ { IDS_6526A_NEW_SV, "" },  /* fuzzy */
/* tr */ { IDS_6526A_NEW_TR, "6526A (yeni)" },

/* en */ { IDS_DISCRETE,    "Discrete" },
/* da */ { IDS_DISCRETE_DA, "Diskret" },
/* de */ { IDS_DISCRETE_DE, "Diskret" },
/* es */ { IDS_DISCRETE_ES, "Discreto" },
/* fr */ { IDS_DISCRETE_FR, "Discrte" },
/* hu */ { IDS_DISCRETE_HU, "" },  /* fuzzy */
/* it */ { IDS_DISCRETE_IT, "Discreto" },
/* ko */ { IDS_DISCRETE_KO, "ٸ" },
/* nl */ { IDS_DISCRETE_NL, "Diskreet" },
/* pl */ { IDS_DISCRETE_PL, "Dyskretny" },
/* ru */ { IDS_DISCRETE_RU, "Discrete" },
/* sv */ { IDS_DISCRETE_SV, "Diskret" },
/* tr */ { IDS_DISCRETE_TR, "Balanty kes" },

/* en */ { IDS_CUSTOM_IC,    "Custom IC" },
/* da */ { IDS_CUSTOM_IC_DA, "Egen IC" },
/* de */ { IDS_CUSTOM_IC_DE, "Benutzerdefinierte IC" },
/* es */ { IDS_CUSTOM_IC_ES, "IC habitual" },
/* fr */ { IDS_CUSTOM_IC_FR, "IC Personnalis" },
/* hu */ { IDS_CUSTOM_IC_HU, "" },  /* fuzzy */
/* it */ { IDS_CUSTOM_IC_IT, "IC personalizzato" },
/* ko */ { IDS_CUSTOM_IC_KO, "Ŀ IC" },
/* nl */ { IDS_CUSTOM_IC_NL, "Aangepast IC" },
/* pl */ { IDS_CUSTOM_IC_PL, "Wasne IC" },
/* ru */ { IDS_CUSTOM_IC_RU, "Custom IC" },
/* sv */ { IDS_CUSTOM_IC_SV, "Egen krets" },
/* tr */ { IDS_CUSTOM_IC_TR, "zel IC" },

/* en */ { IDS_VICII_MODEL,    "VIC-II model" },
/* da */ { IDS_VICII_MODEL_DA, "VIC-II-model" },
/* de */ { IDS_VICII_MODEL_DE, "VIC-II Modell" },
/* es */ { IDS_VICII_MODEL_ES, "Modelo VIC-II" },
/* fr */ { IDS_VICII_MODEL_FR, "Modle VIC-II" },
/* hu */ { IDS_VICII_MODEL_HU, "" },  /* fuzzy */
/* it */ { IDS_VICII_MODEL_IT, "Modello VIC-II" },
/* ko */ { IDS_VICII_MODEL_KO, "VIC-II " },
/* nl */ { IDS_VICII_MODEL_NL, "VIC-II model" },
/* pl */ { IDS_VICII_MODEL_PL, "Model VIC-II" },
/* ru */ { IDS_VICII_MODEL_RU, " VIC-II" },
/* sv */ { IDS_VICII_MODEL_SV, "VIC II-modell" },
/* tr */ { IDS_VICII_MODEL_TR, "VIC-II modeli" },

/* en */ { IDS_CIA1_MODEL,    "CIA 1 model" },
/* da */ { IDS_CIA1_MODEL_DA, "CIA 1 model" },
/* de */ { IDS_CIA1_MODEL_DE, "CIA 1 Modell" },
/* es */ { IDS_CIA1_MODEL_ES, "Modelo CIA 1" },
/* fr */ { IDS_CIA1_MODEL_FR, "Modle CIA 1" },
/* hu */ { IDS_CIA1_MODEL_HU, "" },  /* fuzzy */
/* it */ { IDS_CIA1_MODEL_IT, "Modello CIA 1" },
/* ko */ { IDS_CIA1_MODEL_KO, "CIA 1 " },
/* nl */ { IDS_CIA1_MODEL_NL, "CIA 1 model" },
/* pl */ { IDS_CIA1_MODEL_PL, "Model CIA 1" },
/* ru */ { IDS_CIA1_MODEL_RU, " CIA 1" },
/* sv */ { IDS_CIA1_MODEL_SV, "CIA 1-modell" },
/* tr */ { IDS_CIA1_MODEL_TR, "CIA 1 modeli" },

/* en */ { IDS_CIA2_MODEL,    "CIA 2 model" },
/* da */ { IDS_CIA2_MODEL_DA, "CIA 2 model" },
/* de */ { IDS_CIA2_MODEL_DE, "CIA 2 Modell" },
/* es */ { IDS_CIA2_MODEL_ES, "Modelo CIA 2" },
/* fr */ { IDS_CIA2_MODEL_FR, "Modle CIA 2" },
/* hu */ { IDS_CIA2_MODEL_HU, "" },  /* fuzzy */
/* it */ { IDS_CIA2_MODEL_IT, "Modello CIA 2" },
/* ko */ { IDS_CIA2_MODEL_KO, "CIA 2 " },
/* nl */ { IDS_CIA2_MODEL_NL, "CIA 2 model" },
/* pl */ { IDS_CIA2_MODEL_PL, "Model CIA 2" },
/* ru */ { IDS_CIA2_MODEL_RU, " CIA 2" },
/* sv */ { IDS_CIA2_MODEL_SV, "CIA 2-modell" },
/* tr */ { IDS_CIA2_MODEL_TR, "CIA 2 modeli" },

/* en */ { IDS_GLUE_LOGIC,    "Glue logic" },
/* da */ { IDS_GLUE_LOGIC_DA, "Glue logic" },
/* de */ { IDS_GLUE_LOGIC_DE, "Glue Logik" },
/* es */ { IDS_GLUE_LOGIC_ES, "Glue logic" },
/* fr */ { IDS_GLUE_LOGIC_FR, "Glue logic" },
/* hu */ { IDS_GLUE_LOGIC_HU, "" },  /* fuzzy */
/* it */ { IDS_GLUE_LOGIC_IT, "Glue logic" },
/* ko */ { IDS_GLUE_LOGIC_KO, "۷ " },
/* nl */ { IDS_GLUE_LOGIC_NL, "Glue logic" },
/* pl */ { IDS_GLUE_LOGIC_PL, "Glue logic" },
/* ru */ { IDS_GLUE_LOGIC_RU, "Glue logic" },
/* sv */ { IDS_GLUE_LOGIC_SV, "Klisterlogik" },
/* tr */ { IDS_GLUE_LOGIC_TR, "Glue logic" },

/* en */ { IDS_IEC_RESET,    "Reset IEC bus with computer" },
/* da */ { IDS_IEC_RESET_DA, "" },  /* fuzzy */
/* de */ { IDS_IEC_RESET_DE, "IEC mit Computer zurcksetzen" },
/* es */ { IDS_IEC_RESET_ES, "Reiniciar bus IEC con el ordenador" },
/* fr */ { IDS_IEC_RESET_FR, "" },  /* fuzzy */
/* hu */ { IDS_IEC_RESET_HU, "" },  /* fuzzy */
/* it */ { IDS_IEC_RESET_IT, "Reset bus IEC con computer" },
/* ko */ { IDS_IEC_RESET_KO, "" },  /* fuzzy */
/* nl */ { IDS_IEC_RESET_NL, "Reset IEC bus met de computer" },
/* pl */ { IDS_IEC_RESET_PL, "Zeruj szyn IEC z komputerem" },
/* ru */ { IDS_IEC_RESET_RU, "" },  /* fuzzy */
/* sv */ { IDS_IEC_RESET_SV, "" },  /* fuzzy */
/* tr */ { IDS_IEC_RESET_TR, "" },  /* fuzzy */

/* en */ { IDS_C64_MODEL_SETTINGS,    "C64 model settings" },
/* da */ { IDS_C64_MODEL_SETTINGS_DA, "C64-model indstillinger" },
/* de */ { IDS_C64_MODEL_SETTINGS_DE, "C64 Modell Einstellungen" },
/* es */ { IDS_C64_MODEL_SETTINGS_ES, "Ajustes modelo C64" },
/* fr */ { IDS_C64_MODEL_SETTINGS_FR, "Paramtres du modle C64" },
/* hu */ { IDS_C64_MODEL_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_C64_MODEL_SETTINGS_IT, "Impostazioni modello C64" },
/* ko */ { IDS_C64_MODEL_SETTINGS_KO, "C64  " },
/* nl */ { IDS_C64_MODEL_SETTINGS_NL, "C64 model instellingen" },
/* pl */ { IDS_C64_MODEL_SETTINGS_PL, "Ustawienia modelu C64" },
/* ru */ { IDS_C64_MODEL_SETTINGS_RU, "C64 model settings" },
/* sv */ { IDS_C64_MODEL_SETTINGS_SV, "C64-modellinstllningar" },
/* tr */ { IDS_C64_MODEL_SETTINGS_TR, "C64 model ayarlar" },

/* en */ { IDS_CIA_MODEL_SETTINGS,    "CIA model settings" },
/* da */ { IDS_CIA_MODEL_SETTINGS_DA, "CIA-model indstillinger" },
/* de */ { IDS_CIA_MODEL_SETTINGS_DE, "CIA Modell Einstellungen" },
/* es */ { IDS_CIA_MODEL_SETTINGS_ES, "Ajustes modelo CIA" },
/* fr */ { IDS_CIA_MODEL_SETTINGS_FR, "Paramtres du modle CIA" },
/* hu */ { IDS_CIA_MODEL_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_CIA_MODEL_SETTINGS_IT, "Impostazioni modello CIA" },
/* ko */ { IDS_CIA_MODEL_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_CIA_MODEL_SETTINGS_NL, "CIA model instellingen" },
/* pl */ { IDS_CIA_MODEL_SETTINGS_PL, "Ustawienia modelu CIA" },
/* ru */ { IDS_CIA_MODEL_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_CIA_MODEL_SETTINGS_SV, "CIA-modellinstllningar" },
/* tr */ { IDS_CIA_MODEL_SETTINGS_TR, "CIA model ayarlar" },

/* en */ { IDS_SCALE,    "Scale" },
/* da */ { IDS_SCALE_DA, "" },  /* fuzzy */
/* de */ { IDS_SCALE_DE, "" },  /* fuzzy */
/* es */ { IDS_SCALE_ES, "" },  /* fuzzy */
/* fr */ { IDS_SCALE_FR, "" },  /* fuzzy */
/* hu */ { IDS_SCALE_HU, "" },  /* fuzzy */
/* it */ { IDS_SCALE_IT, "" },  /* fuzzy */
/* ko */ { IDS_SCALE_KO, "" },  /* fuzzy */
/* nl */ { IDS_SCALE_NL, "Schaal" },
/* pl */ { IDS_SCALE_PL, "" },  /* fuzzy */
/* ru */ { IDS_SCALE_RU, "" },  /* fuzzy */
/* sv */ { IDS_SCALE_SV, "" },  /* fuzzy */
/* tr */ { IDS_SCALE_TR, "" },  /* fuzzy */

/* en */ { IDS_CROP_LEFT_TOP,    "Crop left top" },
/* da */ { IDS_CROP_LEFT_TOP_DA, "" },  /* fuzzy */
/* de */ { IDS_CROP_LEFT_TOP_DE, "" },  /* fuzzy */
/* es */ { IDS_CROP_LEFT_TOP_ES, "" },  /* fuzzy */
/* fr */ { IDS_CROP_LEFT_TOP_FR, "" },  /* fuzzy */
/* hu */ { IDS_CROP_LEFT_TOP_HU, "" },  /* fuzzy */
/* it */ { IDS_CROP_LEFT_TOP_IT, "" },  /* fuzzy */
/* ko */ { IDS_CROP_LEFT_TOP_KO, "" },  /* fuzzy */
/* nl */ { IDS_CROP_LEFT_TOP_NL, "crop linker bovenkant" },
/* pl */ { IDS_CROP_LEFT_TOP_PL, "" },  /* fuzzy */
/* ru */ { IDS_CROP_LEFT_TOP_RU, "" },  /* fuzzy */
/* sv */ { IDS_CROP_LEFT_TOP_SV, "" },  /* fuzzy */
/* tr */ { IDS_CROP_LEFT_TOP_TR, "" },  /* fuzzy */

/* en */ { IDS_CROP_MIDDLE_TOP,    "Crop middle top" },
/* da */ { IDS_CROP_MIDDLE_TOP_DA, "" },  /* fuzzy */
/* de */ { IDS_CROP_MIDDLE_TOP_DE, "" },  /* fuzzy */
/* es */ { IDS_CROP_MIDDLE_TOP_ES, "" },  /* fuzzy */
/* fr */ { IDS_CROP_MIDDLE_TOP_FR, "" },  /* fuzzy */
/* hu */ { IDS_CROP_MIDDLE_TOP_HU, "" },  /* fuzzy */
/* it */ { IDS_CROP_MIDDLE_TOP_IT, "" },  /* fuzzy */
/* ko */ { IDS_CROP_MIDDLE_TOP_KO, "" },  /* fuzzy */
/* nl */ { IDS_CROP_MIDDLE_TOP_NL, "crop midden bovenkant" },
/* pl */ { IDS_CROP_MIDDLE_TOP_PL, "" },  /* fuzzy */
/* ru */ { IDS_CROP_MIDDLE_TOP_RU, "" },  /* fuzzy */
/* sv */ { IDS_CROP_MIDDLE_TOP_SV, "" },  /* fuzzy */
/* tr */ { IDS_CROP_MIDDLE_TOP_TR, "" },  /* fuzzy */

/* en */ { IDS_CROP_RIGHT_TOP,    "Crop right top" },
/* da */ { IDS_CROP_RIGHT_TOP_DA, "" },  /* fuzzy */
/* de */ { IDS_CROP_RIGHT_TOP_DE, "" },  /* fuzzy */
/* es */ { IDS_CROP_RIGHT_TOP_ES, "" },  /* fuzzy */
/* fr */ { IDS_CROP_RIGHT_TOP_FR, "" },  /* fuzzy */
/* hu */ { IDS_CROP_RIGHT_TOP_HU, "" },  /* fuzzy */
/* it */ { IDS_CROP_RIGHT_TOP_IT, "" },  /* fuzzy */
/* ko */ { IDS_CROP_RIGHT_TOP_KO, "" },  /* fuzzy */
/* nl */ { IDS_CROP_RIGHT_TOP_NL, "crop rechter bovenkant" },
/* pl */ { IDS_CROP_RIGHT_TOP_PL, "" },  /* fuzzy */
/* ru */ { IDS_CROP_RIGHT_TOP_RU, "" },  /* fuzzy */
/* sv */ { IDS_CROP_RIGHT_TOP_SV, "" },  /* fuzzy */
/* tr */ { IDS_CROP_RIGHT_TOP_TR, "" },  /* fuzzy */

/* en */ { IDS_CROP_LEFT_CENTER,    "Crop left center" },
/* da */ { IDS_CROP_LEFT_CENTER_DA, "" },  /* fuzzy */
/* de */ { IDS_CROP_LEFT_CENTER_DE, "" },  /* fuzzy */
/* es */ { IDS_CROP_LEFT_CENTER_ES, "" },  /* fuzzy */
/* fr */ { IDS_CROP_LEFT_CENTER_FR, "" },  /* fuzzy */
/* hu */ { IDS_CROP_LEFT_CENTER_HU, "" },  /* fuzzy */
/* it */ { IDS_CROP_LEFT_CENTER_IT, "" },  /* fuzzy */
/* ko */ { IDS_CROP_LEFT_CENTER_KO, "" },  /* fuzzy */
/* nl */ { IDS_CROP_LEFT_CENTER_NL, "crop linker midden" },
/* pl */ { IDS_CROP_LEFT_CENTER_PL, "" },  /* fuzzy */
/* ru */ { IDS_CROP_LEFT_CENTER_RU, "" },  /* fuzzy */
/* sv */ { IDS_CROP_LEFT_CENTER_SV, "" },  /* fuzzy */
/* tr */ { IDS_CROP_LEFT_CENTER_TR, "" },  /* fuzzy */

/* en */ { IDS_CROP_MIDDLE_CENTER,    "Crop middle center" },
/* da */ { IDS_CROP_MIDDLE_CENTER_DA, "" },  /* fuzzy */
/* de */ { IDS_CROP_MIDDLE_CENTER_DE, "" },  /* fuzzy */
/* es */ { IDS_CROP_MIDDLE_CENTER_ES, "" },  /* fuzzy */
/* fr */ { IDS_CROP_MIDDLE_CENTER_FR, "" },  /* fuzzy */
/* hu */ { IDS_CROP_MIDDLE_CENTER_HU, "" },  /* fuzzy */
/* it */ { IDS_CROP_MIDDLE_CENTER_IT, "" },  /* fuzzy */
/* ko */ { IDS_CROP_MIDDLE_CENTER_KO, "" },  /* fuzzy */
/* nl */ { IDS_CROP_MIDDLE_CENTER_NL, "crop midden midden" },
/* pl */ { IDS_CROP_MIDDLE_CENTER_PL, "" },  /* fuzzy */
/* ru */ { IDS_CROP_MIDDLE_CENTER_RU, "" },  /* fuzzy */
/* sv */ { IDS_CROP_MIDDLE_CENTER_SV, "" },  /* fuzzy */
/* tr */ { IDS_CROP_MIDDLE_CENTER_TR, "" },  /* fuzzy */

/* en */ { IDS_CROP_RIGHT_CENTER,    "Crop right center" },
/* da */ { IDS_CROP_RIGHT_CENTER_DA, "" },  /* fuzzy */
/* de */ { IDS_CROP_RIGHT_CENTER_DE, "" },  /* fuzzy */
/* es */ { IDS_CROP_RIGHT_CENTER_ES, "" },  /* fuzzy */
/* fr */ { IDS_CROP_RIGHT_CENTER_FR, "" },  /* fuzzy */
/* hu */ { IDS_CROP_RIGHT_CENTER_HU, "" },  /* fuzzy */
/* it */ { IDS_CROP_RIGHT_CENTER_IT, "" },  /* fuzzy */
/* ko */ { IDS_CROP_RIGHT_CENTER_KO, "" },  /* fuzzy */
/* nl */ { IDS_CROP_RIGHT_CENTER_NL, "crop rechter midden" },
/* pl */ { IDS_CROP_RIGHT_CENTER_PL, "" },  /* fuzzy */
/* ru */ { IDS_CROP_RIGHT_CENTER_RU, "" },  /* fuzzy */
/* sv */ { IDS_CROP_RIGHT_CENTER_SV, "" },  /* fuzzy */
/* tr */ { IDS_CROP_RIGHT_CENTER_TR, "" },  /* fuzzy */

/* en */ { IDS_CROP_LEFT_BOTTOM,    "Crop left bottom" },
/* da */ { IDS_CROP_LEFT_BOTTOM_DA, "" },  /* fuzzy */
/* de */ { IDS_CROP_LEFT_BOTTOM_DE, "" },  /* fuzzy */
/* es */ { IDS_CROP_LEFT_BOTTOM_ES, "" },  /* fuzzy */
/* fr */ { IDS_CROP_LEFT_BOTTOM_FR, "" },  /* fuzzy */
/* hu */ { IDS_CROP_LEFT_BOTTOM_HU, "" },  /* fuzzy */
/* it */ { IDS_CROP_LEFT_BOTTOM_IT, "" },  /* fuzzy */
/* ko */ { IDS_CROP_LEFT_BOTTOM_KO, "" },  /* fuzzy */
/* nl */ { IDS_CROP_LEFT_BOTTOM_NL, "crop linker onderkant" },
/* pl */ { IDS_CROP_LEFT_BOTTOM_PL, "" },  /* fuzzy */
/* ru */ { IDS_CROP_LEFT_BOTTOM_RU, "" },  /* fuzzy */
/* sv */ { IDS_CROP_LEFT_BOTTOM_SV, "" },  /* fuzzy */
/* tr */ { IDS_CROP_LEFT_BOTTOM_TR, "" },  /* fuzzy */

/* en */ { IDS_CROP_MIDDLE_BOTTOM,    "Crop middle bottom" },
/* da */ { IDS_CROP_MIDDLE_BOTTOM_DA, "" },  /* fuzzy */
/* de */ { IDS_CROP_MIDDLE_BOTTOM_DE, "" },  /* fuzzy */
/* es */ { IDS_CROP_MIDDLE_BOTTOM_ES, "" },  /* fuzzy */
/* fr */ { IDS_CROP_MIDDLE_BOTTOM_FR, "" },  /* fuzzy */
/* hu */ { IDS_CROP_MIDDLE_BOTTOM_HU, "" },  /* fuzzy */
/* it */ { IDS_CROP_MIDDLE_BOTTOM_IT, "" },  /* fuzzy */
/* ko */ { IDS_CROP_MIDDLE_BOTTOM_KO, "" },  /* fuzzy */
/* nl */ { IDS_CROP_MIDDLE_BOTTOM_NL, "crop midden onderkant" },
/* pl */ { IDS_CROP_MIDDLE_BOTTOM_PL, "" },  /* fuzzy */
/* ru */ { IDS_CROP_MIDDLE_BOTTOM_RU, "" },  /* fuzzy */
/* sv */ { IDS_CROP_MIDDLE_BOTTOM_SV, "" },  /* fuzzy */
/* tr */ { IDS_CROP_MIDDLE_BOTTOM_TR, "" },  /* fuzzy */

/* en */ { IDS_CROP_RIGHT_BOTTOM,    "Crop right bottom" },
/* da */ { IDS_CROP_RIGHT_BOTTOM_DA, "" },  /* fuzzy */
/* de */ { IDS_CROP_RIGHT_BOTTOM_DE, "" },  /* fuzzy */
/* es */ { IDS_CROP_RIGHT_BOTTOM_ES, "" },  /* fuzzy */
/* fr */ { IDS_CROP_RIGHT_BOTTOM_FR, "" },  /* fuzzy */
/* hu */ { IDS_CROP_RIGHT_BOTTOM_HU, "" },  /* fuzzy */
/* it */ { IDS_CROP_RIGHT_BOTTOM_IT, "" },  /* fuzzy */
/* ko */ { IDS_CROP_RIGHT_BOTTOM_KO, "" },  /* fuzzy */
/* nl */ { IDS_CROP_RIGHT_BOTTOM_NL, "crop rechter onderkant" },
/* pl */ { IDS_CROP_RIGHT_BOTTOM_PL, "" },  /* fuzzy */
/* ru */ { IDS_CROP_RIGHT_BOTTOM_RU, "" },  /* fuzzy */
/* sv */ { IDS_CROP_RIGHT_BOTTOM_SV, "" },  /* fuzzy */
/* tr */ { IDS_CROP_RIGHT_BOTTOM_TR, "" },  /* fuzzy */

/* en */ { IDS_BORDERIZE,    "Borderize" },
/* da */ { IDS_BORDERIZE_DA, "" },  /* fuzzy */
/* de */ { IDS_BORDERIZE_DE, "" },  /* fuzzy */
/* es */ { IDS_BORDERIZE_ES, "" },  /* fuzzy */
/* fr */ { IDS_BORDERIZE_FR, "" },  /* fuzzy */
/* hu */ { IDS_BORDERIZE_HU, "" },  /* fuzzy */
/* it */ { IDS_BORDERIZE_IT, "" },  /* fuzzy */
/* ko */ { IDS_BORDERIZE_KO, "" },  /* fuzzy */
/* nl */ { IDS_BORDERIZE_NL, "Vul in met border" },
/* pl */ { IDS_BORDERIZE_PL, "" },  /* fuzzy */
/* ru */ { IDS_BORDERIZE_RU, "" },  /* fuzzy */
/* sv */ { IDS_BORDERIZE_SV, "" },  /* fuzzy */
/* tr */ { IDS_BORDERIZE_TR, "" },  /* fuzzy */

/* en */ { IDS_BLACK_AND_WHITE,    "Black & white" },
/* da */ { IDS_BLACK_AND_WHITE_DA, "" },  /* fuzzy */
/* de */ { IDS_BLACK_AND_WHITE_DE, "" },  /* fuzzy */
/* es */ { IDS_BLACK_AND_WHITE_ES, "" },  /* fuzzy */
/* fr */ { IDS_BLACK_AND_WHITE_FR, "" },  /* fuzzy */
/* hu */ { IDS_BLACK_AND_WHITE_HU, "" },  /* fuzzy */
/* it */ { IDS_BLACK_AND_WHITE_IT, "" },  /* fuzzy */
/* ko */ { IDS_BLACK_AND_WHITE_KO, "" },  /* fuzzy */
/* nl */ { IDS_BLACK_AND_WHITE_NL, "Zwart & wit" },
/* pl */ { IDS_BLACK_AND_WHITE_PL, "" },  /* fuzzy */
/* ru */ { IDS_BLACK_AND_WHITE_RU, "" },  /* fuzzy */
/* sv */ { IDS_BLACK_AND_WHITE_SV, "" },  /* fuzzy */
/* tr */ { IDS_BLACK_AND_WHITE_TR, "" },  /* fuzzy */

/* en */ { IDS_2_COLORS,    "2 colors" },
/* da */ { IDS_2_COLORS_DA, "" },  /* fuzzy */
/* de */ { IDS_2_COLORS_DE, "2 Farben" },
/* es */ { IDS_2_COLORS_ES, "2 colores" },
/* fr */ { IDS_2_COLORS_FR, "" },  /* fuzzy */
/* hu */ { IDS_2_COLORS_HU, "" },  /* fuzzy */
/* it */ { IDS_2_COLORS_IT, "2 colori" },
/* ko */ { IDS_2_COLORS_KO, "" },  /* fuzzy */
/* nl */ { IDS_2_COLORS_NL, "2 kleuren" },
/* pl */ { IDS_2_COLORS_PL, "2 barwy" },
/* ru */ { IDS_2_COLORS_RU, "" },  /* fuzzy */
/* sv */ { IDS_2_COLORS_SV, "2 fger" },
/* tr */ { IDS_2_COLORS_TR, "" },  /* fuzzy */

/* en */ { IDS_4_COLORS,    "4 colors" },
/* da */ { IDS_4_COLORS_DA, "" },  /* fuzzy */
/* de */ { IDS_4_COLORS_DE, "4 Farben" },
/* es */ { IDS_4_COLORS_ES, "4 colores" },
/* fr */ { IDS_4_COLORS_FR, "" },  /* fuzzy */
/* hu */ { IDS_4_COLORS_HU, "" },  /* fuzzy */
/* it */ { IDS_4_COLORS_IT, "4 colori" },
/* ko */ { IDS_4_COLORS_KO, "" },  /* fuzzy */
/* nl */ { IDS_4_COLORS_NL, "4 kleuren" },
/* pl */ { IDS_4_COLORS_PL, "4 barwy" },
/* ru */ { IDS_4_COLORS_RU, "" },  /* fuzzy */
/* sv */ { IDS_4_COLORS_SV, "4 frger" },
/* tr */ { IDS_4_COLORS_TR, "" },  /* fuzzy */

/* en */ { IDS_GRAY_SCALE,    "Gray scale" },
/* da */ { IDS_GRAY_SCALE_DA, "" },  /* fuzzy */
/* de */ { IDS_GRAY_SCALE_DE, "" },  /* fuzzy */
/* es */ { IDS_GRAY_SCALE_ES, "" },  /* fuzzy */
/* fr */ { IDS_GRAY_SCALE_FR, "" },  /* fuzzy */
/* hu */ { IDS_GRAY_SCALE_HU, "" },  /* fuzzy */
/* it */ { IDS_GRAY_SCALE_IT, "" },  /* fuzzy */
/* ko */ { IDS_GRAY_SCALE_KO, "" },  /* fuzzy */
/* nl */ { IDS_GRAY_SCALE_NL, "grijs schaal" },
/* pl */ { IDS_GRAY_SCALE_PL, "" },  /* fuzzy */
/* ru */ { IDS_GRAY_SCALE_RU, "" },  /* fuzzy */
/* sv */ { IDS_GRAY_SCALE_SV, "" },  /* fuzzy */
/* tr */ { IDS_GRAY_SCALE_TR, "" },  /* fuzzy */

/* en */ { IDS_DITHER,    "Dither" },
/* da */ { IDS_DITHER_DA, "" },  /* fuzzy */
/* de */ { IDS_DITHER_DE, "" },  /* fuzzy */
/* es */ { IDS_DITHER_ES, "" },  /* fuzzy */
/* fr */ { IDS_DITHER_FR, "" },  /* fuzzy */
/* hu */ { IDS_DITHER_HU, "" },  /* fuzzy */
/* it */ { IDS_DITHER_IT, "" },  /* fuzzy */
/* ko */ { IDS_DITHER_KO, "" },  /* fuzzy */
/* nl */ { IDS_DITHER_NL, "Dither" },
/* pl */ { IDS_DITHER_PL, "" },  /* fuzzy */
/* ru */ { IDS_DITHER_RU, "" },  /* fuzzy */
/* sv */ { IDS_DITHER_SV, "" },  /* fuzzy */
/* tr */ { IDS_DITHER_TR, "" },  /* fuzzy */

/* en */ { IDS_IGNORE,    "Ignore" },
/* da */ { IDS_IGNORE_DA, "" },  /* fuzzy */
/* de */ { IDS_IGNORE_DE, "" },  /* fuzzy */
/* es */ { IDS_IGNORE_ES, "" },  /* fuzzy */
/* fr */ { IDS_IGNORE_FR, "" },  /* fuzzy */
/* hu */ { IDS_IGNORE_HU, "" },  /* fuzzy */
/* it */ { IDS_IGNORE_IT, "" },  /* fuzzy */
/* ko */ { IDS_IGNORE_KO, "" },  /* fuzzy */
/* nl */ { IDS_IGNORE_NL, "Negeren" },
/* pl */ { IDS_IGNORE_PL, "" },  /* fuzzy */
/* ru */ { IDS_IGNORE_RU, "" },  /* fuzzy */
/* sv */ { IDS_IGNORE_SV, "" },  /* fuzzy */
/* tr */ { IDS_IGNORE_TR, "" },  /* fuzzy */

/* en */ { IDS_WHITE,    "White" },
/* da */ { IDS_WHITE_DA, "Hvid" },
/* de */ { IDS_WHITE_DE, "Wei" },
/* es */ { IDS_WHITE_ES, "Blanco" },
/* fr */ { IDS_WHITE_FR, "Blanc" },
/* hu */ { IDS_WHITE_HU, "" },  /* fuzzy */
/* it */ { IDS_WHITE_IT, "Bianco" },
/* ko */ { IDS_WHITE_KO, "" },
/* nl */ { IDS_WHITE_NL, "Wit" },
/* pl */ { IDS_WHITE_PL, "Biae" },
/* ru */ { IDS_WHITE_RU, "White" },
/* sv */ { IDS_WHITE_SV, "Vit" },
/* tr */ { IDS_WHITE_TR, "Beyaz" },

/* en */ { IDS_AMBER,    "Amber" },
/* da */ { IDS_AMBER_DA, "Rav-farvet" },
/* de */ { IDS_AMBER_DE, "Bernstein" },
/* es */ { IDS_AMBER_ES, "Ambar" },
/* fr */ { IDS_AMBER_FR, "Ambre" },
/* hu */ { IDS_AMBER_HU, "" },  /* fuzzy */
/* it */ { IDS_AMBER_IT, "Ambra" },
/* ko */ { IDS_AMBER_KO, "Ȳ" },
/* nl */ { IDS_AMBER_NL, "Amber" },
/* pl */ { IDS_AMBER_PL, "Bursztynowe" },
/* ru */ { IDS_AMBER_RU, "Amber" },
/* sv */ { IDS_AMBER_SV, "Brnstensfrgad" },
/* tr */ { IDS_AMBER_TR, "Kehribar" },

/* en */ { IDS_GREEN,    "Green" },
/* da */ { IDS_GREEN_DA, "" },  /* fuzzy */
/* de */ { IDS_GREEN_DE, "" },  /* fuzzy */
/* es */ { IDS_GREEN_ES, "" },  /* fuzzy */
/* fr */ { IDS_GREEN_FR, "" },  /* fuzzy */
/* hu */ { IDS_GREEN_HU, "" },  /* fuzzy */
/* it */ { IDS_GREEN_IT, "" },  /* fuzzy */
/* ko */ { IDS_GREEN_KO, "" },  /* fuzzy */
/* nl */ { IDS_GREEN_NL, "Groen" },
/* pl */ { IDS_GREEN_PL, "" },  /* fuzzy */
/* ru */ { IDS_GREEN_RU, "" },  /* fuzzy */
/* sv */ { IDS_GREEN_SV, "" },  /* fuzzy */
/* tr */ { IDS_GREEN_TR, "" },  /* fuzzy */

/* en */ { IDS_DOODLE_OVERSIZE_HANDLING,    "Doodle oversize handling" },
/* da */ { IDS_DOODLE_OVERSIZE_HANDLING_DA, "" },  /* fuzzy */
/* de */ { IDS_DOODLE_OVERSIZE_HANDLING_DE, "" },  /* fuzzy */
/* es */ { IDS_DOODLE_OVERSIZE_HANDLING_ES, "" },  /* fuzzy */
/* fr */ { IDS_DOODLE_OVERSIZE_HANDLING_FR, "" },  /* fuzzy */
/* hu */ { IDS_DOODLE_OVERSIZE_HANDLING_HU, "" },  /* fuzzy */
/* it */ { IDS_DOODLE_OVERSIZE_HANDLING_IT, "" },  /* fuzzy */
/* ko */ { IDS_DOODLE_OVERSIZE_HANDLING_KO, "" },  /* fuzzy */
/* nl */ { IDS_DOODLE_OVERSIZE_HANDLING_NL, "Doodle 'te groot' afhandeling" },
/* pl */ { IDS_DOODLE_OVERSIZE_HANDLING_PL, "" },  /* fuzzy */
/* ru */ { IDS_DOODLE_OVERSIZE_HANDLING_RU, "" },  /* fuzzy */
/* sv */ { IDS_DOODLE_OVERSIZE_HANDLING_SV, "" },  /* fuzzy */
/* tr */ { IDS_DOODLE_OVERSIZE_HANDLING_TR, "" },  /* fuzzy */

/* en */ { IDS_DOODLE_UNDERSIZE_HANDLING,    "Doodle undersize handling" },
/* da */ { IDS_DOODLE_UNDERSIZE_HANDLING_DA, "" },  /* fuzzy */
/* de */ { IDS_DOODLE_UNDERSIZE_HANDLING_DE, "" },  /* fuzzy */
/* es */ { IDS_DOODLE_UNDERSIZE_HANDLING_ES, "" },  /* fuzzy */
/* fr */ { IDS_DOODLE_UNDERSIZE_HANDLING_FR, "" },  /* fuzzy */
/* hu */ { IDS_DOODLE_UNDERSIZE_HANDLING_HU, "" },  /* fuzzy */
/* it */ { IDS_DOODLE_UNDERSIZE_HANDLING_IT, "" },  /* fuzzy */
/* ko */ { IDS_DOODLE_UNDERSIZE_HANDLING_KO, "" },  /* fuzzy */
/* nl */ { IDS_DOODLE_UNDERSIZE_HANDLING_NL, "Doodle 'te klein' afhandling" },
/* pl */ { IDS_DOODLE_UNDERSIZE_HANDLING_PL, "" },  /* fuzzy */
/* ru */ { IDS_DOODLE_UNDERSIZE_HANDLING_RU, "" },  /* fuzzy */
/* sv */ { IDS_DOODLE_UNDERSIZE_HANDLING_SV, "" },  /* fuzzy */
/* tr */ { IDS_DOODLE_UNDERSIZE_HANDLING_TR, "" },  /* fuzzy */

/* en */ { IDS_DOODLE_MULTICOLOR_HANDLING,    "Doodle multicolor handling" },
/* da */ { IDS_DOODLE_MULTICOLOR_HANDLING_DA, "" },  /* fuzzy */
/* de */ { IDS_DOODLE_MULTICOLOR_HANDLING_DE, "" },  /* fuzzy */
/* es */ { IDS_DOODLE_MULTICOLOR_HANDLING_ES, "" },  /* fuzzy */
/* fr */ { IDS_DOODLE_MULTICOLOR_HANDLING_FR, "" },  /* fuzzy */
/* hu */ { IDS_DOODLE_MULTICOLOR_HANDLING_HU, "" },  /* fuzzy */
/* it */ { IDS_DOODLE_MULTICOLOR_HANDLING_IT, "" },  /* fuzzy */
/* ko */ { IDS_DOODLE_MULTICOLOR_HANDLING_KO, "" },  /* fuzzy */
/* nl */ { IDS_DOODLE_MULTICOLOR_HANDLING_NL, "Doodle meerdere kleuren afhandeling" },
/* pl */ { IDS_DOODLE_MULTICOLOR_HANDLING_PL, "" },  /* fuzzy */
/* ru */ { IDS_DOODLE_MULTICOLOR_HANDLING_RU, "" },  /* fuzzy */
/* sv */ { IDS_DOODLE_MULTICOLOR_HANDLING_SV, "" },  /* fuzzy */
/* tr */ { IDS_DOODLE_MULTICOLOR_HANDLING_TR, "" },  /* fuzzy */

/* en */ { IDS_DOODLE_TED_LUMINOSITY_HANDLING,    "Doodle TED luminosity handling" },
/* da */ { IDS_DOODLE_TED_LUMINOSITY_HANDLING_DA, "" },  /* fuzzy */
/* de */ { IDS_DOODLE_TED_LUMINOSITY_HANDLING_DE, "" },  /* fuzzy */
/* es */ { IDS_DOODLE_TED_LUMINOSITY_HANDLING_ES, "" },  /* fuzzy */
/* fr */ { IDS_DOODLE_TED_LUMINOSITY_HANDLING_FR, "" },  /* fuzzy */
/* hu */ { IDS_DOODLE_TED_LUMINOSITY_HANDLING_HU, "" },  /* fuzzy */
/* it */ { IDS_DOODLE_TED_LUMINOSITY_HANDLING_IT, "" },  /* fuzzy */
/* ko */ { IDS_DOODLE_TED_LUMINOSITY_HANDLING_KO, "" },  /* fuzzy */
/* nl */ { IDS_DOODLE_TED_LUMINOSITY_HANDLING_NL, "Doodle TED helderheid afhandeling" },
/* pl */ { IDS_DOODLE_TED_LUMINOSITY_HANDLING_PL, "" },  /* fuzzy */
/* ru */ { IDS_DOODLE_TED_LUMINOSITY_HANDLING_RU, "" },  /* fuzzy */
/* sv */ { IDS_DOODLE_TED_LUMINOSITY_HANDLING_SV, "" },  /* fuzzy */
/* tr */ { IDS_DOODLE_TED_LUMINOSITY_HANDLING_TR, "" },  /* fuzzy */

/* en */ { IDS_DOODLE_CRTC_TEXT_COLOR,    "Doodle CRTC text color" },
/* da */ { IDS_DOODLE_CRTC_TEXT_COLOR_DA, "" },  /* fuzzy */
/* de */ { IDS_DOODLE_CRTC_TEXT_COLOR_DE, "" },  /* fuzzy */
/* es */ { IDS_DOODLE_CRTC_TEXT_COLOR_ES, "" },  /* fuzzy */
/* fr */ { IDS_DOODLE_CRTC_TEXT_COLOR_FR, "" },  /* fuzzy */
/* hu */ { IDS_DOODLE_CRTC_TEXT_COLOR_HU, "" },  /* fuzzy */
/* it */ { IDS_DOODLE_CRTC_TEXT_COLOR_IT, "" },  /* fuzzy */
/* ko */ { IDS_DOODLE_CRTC_TEXT_COLOR_KO, "" },  /* fuzzy */
/* nl */ { IDS_DOODLE_CRTC_TEXT_COLOR_NL, "Doodle CRTC text kleur" },
/* pl */ { IDS_DOODLE_CRTC_TEXT_COLOR_PL, "" },  /* fuzzy */
/* ru */ { IDS_DOODLE_CRTC_TEXT_COLOR_RU, "" },  /* fuzzy */
/* sv */ { IDS_DOODLE_CRTC_TEXT_COLOR_SV, "" },  /* fuzzy */
/* tr */ { IDS_DOODLE_CRTC_TEXT_COLOR_TR, "" },  /* fuzzy */

/* en */ { IDS_KOALA_OVERSIZE_HANDLING,    "Koala oversize handling" },
/* da */ { IDS_KOALA_OVERSIZE_HANDLING_DA, "" },  /* fuzzy */
/* de */ { IDS_KOALA_OVERSIZE_HANDLING_DE, "" },  /* fuzzy */
/* es */ { IDS_KOALA_OVERSIZE_HANDLING_ES, "" },  /* fuzzy */
/* fr */ { IDS_KOALA_OVERSIZE_HANDLING_FR, "" },  /* fuzzy */
/* hu */ { IDS_KOALA_OVERSIZE_HANDLING_HU, "" },  /* fuzzy */
/* it */ { IDS_KOALA_OVERSIZE_HANDLING_IT, "" },  /* fuzzy */
/* ko */ { IDS_KOALA_OVERSIZE_HANDLING_KO, "" },  /* fuzzy */
/* nl */ { IDS_KOALA_OVERSIZE_HANDLING_NL, "Koala 'te groot' afhandeling" },
/* pl */ { IDS_KOALA_OVERSIZE_HANDLING_PL, "" },  /* fuzzy */
/* ru */ { IDS_KOALA_OVERSIZE_HANDLING_RU, "" },  /* fuzzy */
/* sv */ { IDS_KOALA_OVERSIZE_HANDLING_SV, "" },  /* fuzzy */
/* tr */ { IDS_KOALA_OVERSIZE_HANDLING_TR, "" },  /* fuzzy */

/* en */ { IDS_KOALA_UNDERSIZE_HANDLING,    "Koala undersize handling" },
/* da */ { IDS_KOALA_UNDERSIZE_HANDLING_DA, "" },  /* fuzzy */
/* de */ { IDS_KOALA_UNDERSIZE_HANDLING_DE, "" },  /* fuzzy */
/* es */ { IDS_KOALA_UNDERSIZE_HANDLING_ES, "" },  /* fuzzy */
/* fr */ { IDS_KOALA_UNDERSIZE_HANDLING_FR, "" },  /* fuzzy */
/* hu */ { IDS_KOALA_UNDERSIZE_HANDLING_HU, "" },  /* fuzzy */
/* it */ { IDS_KOALA_UNDERSIZE_HANDLING_IT, "" },  /* fuzzy */
/* ko */ { IDS_KOALA_UNDERSIZE_HANDLING_KO, "" },  /* fuzzy */
/* nl */ { IDS_KOALA_UNDERSIZE_HANDLING_NL, "Koala 'te klein' afhandling" },
/* pl */ { IDS_KOALA_UNDERSIZE_HANDLING_PL, "" },  /* fuzzy */
/* ru */ { IDS_KOALA_UNDERSIZE_HANDLING_RU, "" },  /* fuzzy */
/* sv */ { IDS_KOALA_UNDERSIZE_HANDLING_SV, "" },  /* fuzzy */
/* tr */ { IDS_KOALA_UNDERSIZE_HANDLING_TR, "" },  /* fuzzy */

/* en */ { IDS_KOALA_TED_LUMINOSITY_HANDLING,    "Koala TED luminosity handling" },
/* da */ { IDS_KOALA_TED_LUMINOSITY_HANDLING_DA, "" },  /* fuzzy */
/* de */ { IDS_KOALA_TED_LUMINOSITY_HANDLING_DE, "" },  /* fuzzy */
/* es */ { IDS_KOALA_TED_LUMINOSITY_HANDLING_ES, "" },  /* fuzzy */
/* fr */ { IDS_KOALA_TED_LUMINOSITY_HANDLING_FR, "" },  /* fuzzy */
/* hu */ { IDS_KOALA_TED_LUMINOSITY_HANDLING_HU, "" },  /* fuzzy */
/* it */ { IDS_KOALA_TED_LUMINOSITY_HANDLING_IT, "" },  /* fuzzy */
/* ko */ { IDS_KOALA_TED_LUMINOSITY_HANDLING_KO, "" },  /* fuzzy */
/* nl */ { IDS_KOALA_TED_LUMINOSITY_HANDLING_NL, "Koala TED helderheid afhandeling" },
/* pl */ { IDS_KOALA_TED_LUMINOSITY_HANDLING_PL, "" },  /* fuzzy */
/* ru */ { IDS_KOALA_TED_LUMINOSITY_HANDLING_RU, "" },  /* fuzzy */
/* sv */ { IDS_KOALA_TED_LUMINOSITY_HANDLING_SV, "" },  /* fuzzy */
/* tr */ { IDS_KOALA_TED_LUMINOSITY_HANDLING_TR, "" },  /* fuzzy */

/* en */ { IDS_KOALA_CRTC_TEXT_COLOR,    "Koala CRTC text color" },
/* da */ { IDS_KOALA_CRTC_TEXT_COLOR_DA, "" },  /* fuzzy */
/* de */ { IDS_KOALA_CRTC_TEXT_COLOR_DE, "" },  /* fuzzy */
/* es */ { IDS_KOALA_CRTC_TEXT_COLOR_ES, "" },  /* fuzzy */
/* fr */ { IDS_KOALA_CRTC_TEXT_COLOR_FR, "" },  /* fuzzy */
/* hu */ { IDS_KOALA_CRTC_TEXT_COLOR_HU, "" },  /* fuzzy */
/* it */ { IDS_KOALA_CRTC_TEXT_COLOR_IT, "" },  /* fuzzy */
/* ko */ { IDS_KOALA_CRTC_TEXT_COLOR_KO, "" },  /* fuzzy */
/* nl */ { IDS_KOALA_CRTC_TEXT_COLOR_NL, "Koala CRTC text kleur" },
/* pl */ { IDS_KOALA_CRTC_TEXT_COLOR_PL, "" },  /* fuzzy */
/* ru */ { IDS_KOALA_CRTC_TEXT_COLOR_RU, "" },  /* fuzzy */
/* sv */ { IDS_KOALA_CRTC_TEXT_COLOR_SV, "" },  /* fuzzy */
/* tr */ { IDS_KOALA_CRTC_TEXT_COLOR_TR, "" },  /* fuzzy */

/* en */ { IDS_SCREENSHOT_SETTINGS,    "Screenshot settings" },
/* da */ { IDS_SCREENSHOT_SETTINGS_DA, "" },  /* fuzzy */
/* de */ { IDS_SCREENSHOT_SETTINGS_DE, "" },  /* fuzzy */
/* es */ { IDS_SCREENSHOT_SETTINGS_ES, "" },  /* fuzzy */
/* fr */ { IDS_SCREENSHOT_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_SCREENSHOT_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_SCREENSHOT_SETTINGS_IT, "" },  /* fuzzy */
/* ko */ { IDS_SCREENSHOT_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_SCREENSHOT_SETTINGS_NL, "Schermafdruk instellingen" },
/* pl */ { IDS_SCREENSHOT_SETTINGS_PL, "" },  /* fuzzy */
/* ru */ { IDS_SCREENSHOT_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_SCREENSHOT_SETTINGS_SV, "" },  /* fuzzy */
/* tr */ { IDS_SCREENSHOT_SETTINGS_TR, "" },  /* fuzzy */

/* en */ { IDS_DETACH_ALL,    "Detach all involved carts" },
/* da */ { IDS_DETACH_ALL_DA, "" },  /* fuzzy */
/* de */ { IDS_DETACH_ALL_DE, "" },  /* fuzzy */
/* es */ { IDS_DETACH_ALL_ES, "" },  /* fuzzy */
/* fr */ { IDS_DETACH_ALL_FR, "" },  /* fuzzy */
/* hu */ { IDS_DETACH_ALL_HU, "" },  /* fuzzy */
/* it */ { IDS_DETACH_ALL_IT, "" },  /* fuzzy */
/* ko */ { IDS_DETACH_ALL_KO, "" },  /* fuzzy */
/* nl */ { IDS_DETACH_ALL_NL, "Ontkoppel alle betrokken cartridges" },
/* pl */ { IDS_DETACH_ALL_PL, "" },  /* fuzzy */
/* ru */ { IDS_DETACH_ALL_RU, "" },  /* fuzzy */
/* sv */ { IDS_DETACH_ALL_SV, "" },  /* fuzzy */
/* tr */ { IDS_DETACH_ALL_TR, "" },  /* fuzzy */

/* en */ { IDS_DETACH_LAST,    "Detach last inserted cart" },
/* da */ { IDS_DETACH_LAST_DA, "" },  /* fuzzy */
/* de */ { IDS_DETACH_LAST_DE, "" },  /* fuzzy */
/* es */ { IDS_DETACH_LAST_ES, "" },  /* fuzzy */
/* fr */ { IDS_DETACH_LAST_FR, "" },  /* fuzzy */
/* hu */ { IDS_DETACH_LAST_HU, "" },  /* fuzzy */
/* it */ { IDS_DETACH_LAST_IT, "" },  /* fuzzy */
/* ko */ { IDS_DETACH_LAST_KO, "" },  /* fuzzy */
/* nl */ { IDS_DETACH_LAST_NL, "Ontkoppel de cartridge die als laatse was geactiveerd" },
/* pl */ { IDS_DETACH_LAST_PL, "" },  /* fuzzy */
/* ru */ { IDS_DETACH_LAST_RU, "" },  /* fuzzy */
/* sv */ { IDS_DETACH_LAST_SV, "" },  /* fuzzy */
/* tr */ { IDS_DETACH_LAST_TR, "" },  /* fuzzy */

/* en */ { IDS_AND_WIRES,    "'AND' the wires" },
/* da */ { IDS_AND_WIRES_DA, "" },  /* fuzzy */
/* de */ { IDS_AND_WIRES_DE, "" },  /* fuzzy */
/* es */ { IDS_AND_WIRES_ES, "" },  /* fuzzy */
/* fr */ { IDS_AND_WIRES_FR, "" },  /* fuzzy */
/* hu */ { IDS_AND_WIRES_HU, "" },  /* fuzzy */
/* it */ { IDS_AND_WIRES_IT, "" },  /* fuzzy */
/* ko */ { IDS_AND_WIRES_KO, "" },  /* fuzzy */
/* nl */ { IDS_AND_WIRES_NL, "'AND' de draden" },
/* pl */ { IDS_AND_WIRES_PL, "" },  /* fuzzy */
/* ru */ { IDS_AND_WIRES_RU, "" },  /* fuzzy */
/* sv */ { IDS_AND_WIRES_SV, "" },  /* fuzzy */
/* tr */ { IDS_AND_WIRES_TR, "" },  /* fuzzy */

/* en */ { IDS_IO_COLLISION_HANDLING,    "I/O collision handling" },
/* da */ { IDS_IO_COLLISION_HANDLING_DA, "I/O kollisionshndtering" },
/* de */ { IDS_IO_COLLISION_HANDLING_DE, "I/O Kollisionsbehandlung" },
/* es */ { IDS_IO_COLLISION_HANDLING_ES, "Manejo de colisiones I/O" },
/* fr */ { IDS_IO_COLLISION_HANDLING_FR, "Prise en charge collision E/S" },
/* hu */ { IDS_IO_COLLISION_HANDLING_HU, "" },  /* fuzzy */
/* it */ { IDS_IO_COLLISION_HANDLING_IT, "Gestione delle collisioni di I/O" },
/* ko */ { IDS_IO_COLLISION_HANDLING_KO, "" },  /* fuzzy */
/* nl */ { IDS_IO_COLLISION_HANDLING_NL, "I/O conflict handeling" },
/* pl */ { IDS_IO_COLLISION_HANDLING_PL, "Obsuga kolizji we/wy" },
/* ru */ { IDS_IO_COLLISION_HANDLING_RU, "I/O collision handling" },
/* sv */ { IDS_IO_COLLISION_HANDLING_SV, "hantering av I/O-kollisioner" },
/* tr */ { IDS_IO_COLLISION_HANDLING_TR, "G/ akma ileme" },

/* en */ { IDS_IO_COLLISION_SETTINGS,    "I/O collision settings" },
/* da */ { IDS_IO_COLLISION_SETTINGS_DA, "" },  /* fuzzy */
/* de */ { IDS_IO_COLLISION_SETTINGS_DE, "" },  /* fuzzy */
/* es */ { IDS_IO_COLLISION_SETTINGS_ES, "" },  /* fuzzy */
/* fr */ { IDS_IO_COLLISION_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_IO_COLLISION_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_IO_COLLISION_SETTINGS_IT, "" },  /* fuzzy */
/* ko */ { IDS_IO_COLLISION_SETTINGS_KO, "" },  /* fuzzy */
/* nl */ { IDS_IO_COLLISION_SETTINGS_NL, "I/O conflict instellingen" },
/* pl */ { IDS_IO_COLLISION_SETTINGS_PL, "" },  /* fuzzy */
/* ru */ { IDS_IO_COLLISION_SETTINGS_RU, "" },  /* fuzzy */
/* sv */ { IDS_IO_COLLISION_SETTINGS_SV, "" },  /* fuzzy */
/* tr */ { IDS_IO_COLLISION_SETTINGS_TR, "" },  /* fuzzy */

/* en */ { IDS_PSID_SELECT,    "Select SID file to load" },
/* da */ { IDS_PSID_SELECT_DA, "Vlg SID-fil" },
/* de */ { IDS_PSID_SELECT_DE, "SID Datei whlen" },
/* es */ { IDS_PSID_SELECT_ES, "Seleccionar fichero SID para cargar" },
/* fr */ { IDS_PSID_SELECT_FR, "Slectionner le fichier SID  charger" },
/* hu */ { IDS_PSID_SELECT_HU, "" },  /* fuzzy */
/* it */ { IDS_PSID_SELECT_IT, "Seleziona un file SID da caricare" },
/* ko */ { IDS_PSID_SELECT_KO, "" },  /* fuzzy */
/* nl */ { IDS_PSID_SELECT_NL, "Selecteer SID bestand voor laden" },
/* pl */ { IDS_PSID_SELECT_PL, "Wybierz plik SID do wczytania" },
/* ru */ { IDS_PSID_SELECT_RU, "" },  /* fuzzy */
/* sv */ { IDS_PSID_SELECT_SV, "Vlj SID-fil att lsa in" },
/* tr */ { IDS_PSID_SELECT_TR, "Yklenecek SID dosyasn sein" },

};
