Author: Andreas Tille <tille@debian.org>
Last-Update: Thu, 19 Oct 2017 14:58:04 +0200
Description: Use Debian packaged CImg.h from cimg-dev package since
 the code copy shipped together with upstream is outdated and does not
 build with recent gcc

--- a/src/CMakeLists.txt
+++ b/src/CMakeLists.txt
@@ -29,7 +29,6 @@
 	spot_document_gnumeric
 	spotSvgDocument
 	images/imageDeNovo
-	CImg
 )
 IF(WIN32)
 ELSE(WIN32)
--- a/src/qtbeads/CMakeLists.txt
+++ b/src/qtbeads/CMakeLists.txt
@@ -30,7 +30,6 @@
 	../spot_document_gnumeric
 	../spotSvgDocument
 	../images/imageDeNovo
-	../CImg
 )
   
 # with SET() command you can change variables or define new ones
--- a/src/images/imageCode.h
+++ b/src/images/imageCode.h
@@ -3,8 +3,10 @@
 
 #include "../config.h"
 
-#include "../CImg.h"
-//#include <CImg.h>
+#include <CImg.h>
+//CImg.h includes Xlib.h, which has evil "#define Bool int" that
+//interferes with QMetaType::Bool in files generated by Qt MOC!
+#undef Bool
 
 //Images pour lesquelles les valeurs des pixels sont des codes et non des valeurs quantitatives
 //Sont des codes: l'image des directions, l'image des numeros
--- a/CMakeLists.txt
+++ b/CMakeLists.txt
@@ -78,6 +78,7 @@
 	FIND_PACKAGE(Pthreads REQUIRED)
 	SET(CMAKE_CXX_FLAGS_RELEASE "-O3 -DNDEBUG")
 	SET ( CIMG_OS 1)
+	SET(EXTRA_CIMG_LIBRARY "X11")
 ENDIF(WIN32)
 
 #
