/*
Copyright 2010, 2012, 2014 Jose Robson Mariano Alves

This file is part of bgfinancas.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*/

package PreRelatorios;

import Biblioteca.Botoes;
import Biblioteca.Calendario;
import Biblioteca.JanelaModal;
import Biblioteca.Janelinha;
import Biblioteca.Visual;
import Relatorios.RDespesas;
import java.sql.SQLException;
import java.text.ParseException;

public class PreDespesas extends JanelaModal {

    private final RDespesas Relatorio = new RDespesas();

    public PreDespesas(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        Visual.JanelaModal(this.getJanela());
        BarraDeFerramentas.add(Botoes.Sair(this));
        PreencherGrupos();
    }

    private void PreencherGrupos()
    {
        try
        {
            Banco.executeQuery("SELECT nome FROM relatorios_grupos ORDER BY nome ASC");
            grupo.addItem(Lingua.getMensagem("nenhum"));
            while(Banco.getResultSet().next())
            {
                grupo.addItem(Banco.getResultSet().getString("nome"));
            }
        }catch(SQLException e)
        {
            Janelinha.Aviso((Lingua.getMensagem("erro")), Lingua.getMensagem("excecao")+" "+e.getMessage());
        }
    }

    @Override
    public void Botoes(String acao)
    {
        if(acao.equals(Lingua.getMensagem("sair")))
        {
            PreDespesas.this.dispose();
        }
    }

    public void Despesas() throws ParseException
    {
        String Grupo=Lingua.getMensagem("nenhum");
        String DataInicial = data_inicial.getSelectedItem().toString();
        String tmp[] = DataInicial.split("/");
        DataInicial = tmp[2]+"-"+tmp[1]+"-"+tmp[0];
        String DataFinal = data_final.getSelectedItem().toString();
        String tmp2[] = DataFinal.split("/");
        DataFinal = tmp2[2]+"-"+tmp2[1]+"-"+tmp2[0];
        if(!grupo.getSelectedItem().toString().equals(Lingua.getMensagem("nenhum")))
        {
            try{
                Banco.executeQuery("SELECT id_relatorios_grupos FROM relatorios_grupos WHERE nome='"+grupo.getSelectedItem()+"'");
                Banco.getResultSet().next();
                Grupo = Banco.getResultSet().getString("id_relatorios_grupos");
            }catch(SQLException e){
                Janelinha.Aviso((Lingua.getMensagem("erro")), Lingua.getMensagem("excecao")+" "+e.getMessage());
            }
        }
        Relatorio.RDespesas(DataInicial,DataFinal,tipo.getSelectedItem().toString(),Grupo,tipo.getSelectedIndex());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        BarraDeFerramentas = new javax.swing.JToolBar();
        INICIO = new javax.swing.JLabel();
        BFiltrar = new javax.swing.JButton();
        FINAL = new javax.swing.JLabel();
        TEXTO = new javax.swing.JLabel();
        data_final = new Calendario(true);
        data_inicial = new Calendario(true);
        FINAL1 = new javax.swing.JLabel();
        tipo = new javax.swing.JComboBox();
        FINAL2 = new javax.swing.JLabel();
        grupo = new javax.swing.JComboBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(Lingua.getMensagem("despesas")+" > "+Lingua.getMensagem("periodo_categoria"));
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        getContentPane().setLayout(null);

        BarraDeFerramentas.setFloatable(false);
        BarraDeFerramentas.setRollover(true);
        getContentPane().add(BarraDeFerramentas);
        BarraDeFerramentas.setBounds(0, 0, 450, 41);

        INICIO.setFont(FonteFinancas);
        INICIO.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        INICIO.setText(Lingua.getMensagem("inicio")+":");
        getContentPane().add(INICIO);
        INICIO.setBounds(30, 90, 110, 20);

        BFiltrar.setFont(FonteFinancas);
        BFiltrar.setText(Lingua.getMensagem("gerar"));
        BFiltrar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                BFiltrarActionPerformed(evt);
            }
        });
        getContentPane().add(BFiltrar);
        BFiltrar.setBounds(150, 210, 110, 20);

        FINAL.setFont(FonteFinancas);
        FINAL.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        FINAL.setText(Lingua.getMensagem("tipo")+":");
        getContentPane().add(FINAL);
        FINAL.setBounds(20, 180, 120, 20);

        TEXTO.setFont(new java.awt.Font("Arial", 0, 11)); // NOI18N
        TEXTO.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        TEXTO.setText(Lingua.getMensagem("mensagem_relatorio")+":");
        getContentPane().add(TEXTO);
        TEXTO.setBounds(0, 56, 400, 20);

        data_final.setFont(FonteFinancas);
        getContentPane().add(data_final);
        data_final.setBounds(150, 120, 120, 20);

        data_inicial.setFont(FonteFinancas);
        getContentPane().add(data_inicial);
        data_inicial.setBounds(150, 90, 120, 20);

        FINAL1.setFont(FonteFinancas);
        FINAL1.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        FINAL1.setText(Lingua.getMensagem("fim")+":");
        getContentPane().add(FINAL1);
        FINAL1.setBounds(20, 120, 120, 20);

        tipo.setFont(FonteFinancas);
        tipo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { Lingua.getMensagem("barras"), Lingua.getMensagem("pizza") }));
        getContentPane().add(tipo);
        tipo.setBounds(150, 180, 110, 20);

        FINAL2.setFont(FonteFinancas);
        FINAL2.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        FINAL2.setText(Lingua.getMensagem("grupo")+":");
        getContentPane().add(FINAL2);
        FINAL2.setBounds(20, 150, 120, 20);

        grupo.setFont(FonteFinancas);
        getContentPane().add(grupo);
        grupo.setBounds(150, 150, 190, 20);

        setSize(new java.awt.Dimension(410, 313));
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

    private void BFiltrarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_BFiltrarActionPerformed
        try {
            Despesas();
        } catch (ParseException ex) {
            Janelinha.Aviso((Lingua.getMensagem("erro")), Lingua.getMensagem("excecao")+" "+ex.getMessage());
        }
}//GEN-LAST:event_BFiltrarActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton BFiltrar;
    private javax.swing.JToolBar BarraDeFerramentas;
    private javax.swing.JLabel FINAL;
    private javax.swing.JLabel FINAL1;
    private javax.swing.JLabel FINAL2;
    private javax.swing.JLabel INICIO;
    private javax.swing.JLabel TEXTO;
    private javax.swing.JComboBox data_final;
    private javax.swing.JComboBox data_inicial;
    private javax.swing.JComboBox grupo;
    private javax.swing.JComboBox tipo;
    // End of variables declaration//GEN-END:variables

}
