#!/bin/sh
#
#  Script to create a 'pristine' tarball for the debian boxbackup source
#  package. Copyright (C) 2009, Reinhard Tartler
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

set -eu

usage() {
	cat >&2 <<EOF
usage: $0 [-dh]
  -h : display help
  -r : svn revision
  -o : output tarball name
EOF
}

debug () {
	$DEBUG && echo "DEBUG: $*" >&2
}

error () {
	echo "$1" >&2
	exit 1;
}

set +e
PARAMS=`getopt hr: "$@"`
if test $? -ne 0; then usage; exit 1; fi;
set -e

eval set -- "$PARAMS"

DEBUG=false
SVNREVISION=

while test $# -gt 0
do
	case $1 in
		-h) usage; exit 1 ;;
		-r) SVNREVISION=$2; shift ;;
		--) shift ; break ;;
		*)  echo "Internal error!" ; exit 1 ;;
	esac
	shift
done

# sanity checks now
dh_testdir

if [ -z $SVNREVISION ]; then
	error "you need to specify an svn revision."
fi

PACKAGENAME=boxbackup
baseurl="https://www.boxbackup.org/svn/box/RELEASE/0.11.1"
TARBALL=../${PACKAGENAME}_0.11.1~r${SVNREVISION}.orig.tar.gz

TMPDIR=`mktemp -d`
trap 'rm -rf ${TMPDIR}'  EXIT


svn export -r${SVNREVISION} \
	--ignore-externals \
	${baseurl}  \
	${TMPDIR}/${PACKAGENAME}

svn info -r${SVNREVISION} \
	${baseurl} \
	| awk '/^Revision/ {print $2}' \
	> ${TMPDIR}/${PACKAGENAME}/.svnrevision

tar czf ${TARBALL} -C ${TMPDIR} ${PACKAGENAME}
