package Boxer::Task::Classify;

use 5.010;
use strictures 1;
use utf8;
use autodie qw(:all);
use IPC::System::Simple;

use Moo;
use Boxer::Types qw( DataDir ClassDir NodeDir Suite );
use Types::Standard qw( Maybe Str Undef );
extends 'Boxer::Task';

use File::BaseDir qw(data_dirs);
use Capture::Tiny qw(capture_stdout);
use YAML::XS;

use Role::Commons -all;

our $AUTHORITY = 'cpan:JONASS';
our $VERSION = 'v1.1.4';

# permit callers to sloppily pass undefined values
sub BUILDARGS
{
	my ( $class, %args ) = @_;
	delete @args{ grep !defined( $args{$_} ), keys %args };
	return {%args};
}

has datadir => (
	is       => 'lazy',
	isa      => Maybe[DataDir],
	coerce   => 1,
	required => 1,
	default  => sub { undef },
);

has suite => (
	is       => 'ro',
	isa      => Suite,
	required => 1,
	coerce   => 1,
	default  => sub {'wheezy'},
);

has classdir => (
	is       => 'lazy',
	isa      => ClassDir,
	coerce   => 1,
	required => 1,
	default  => sub { $_[0]->datadir ? $_[0]->datadir->child('classes') : scalar( data_dirs( 'boxer', $_[0]->suite, 'classes' ) ) },
);

has nodedir => (
	is       => 'lazy',
	isa      => NodeDir,
	coerce   => 1,
	required => 1,
	default  => sub { $_[0]->datadir ? $_[0]->datadir->child('nodes') : '.' },
);

sub run
{
	my $self = shift;

	Load(
		scalar(
			capture_stdout {
				system(
					'reclass',
					'-b',
					'',
					'-c',
					$self->classdir,
					'-u',
					$self->nodedir,
					'--inventory',
				);
			}
		)
	);
}

1;
