/*
 *  publichubswidget.cpp
 *  ui
 *
 *  Created by Mikael Gransell on 3/21/06.
 *  Copyright 2006 __MyCompanyName__. All rights reserved.
 *
 */

#include <QHeaderView>

#include "publichubswidget.h"
#include "util.h"

int PublicHubs::PublicHubsModel::Entry::sortCol = 0;
Qt::SortOrder PublicHubs::PublicHubsModel::Entry::sortOrder = Qt::AscendingOrder;

PublicHubs::PublicHubs( const BackendConnectionPtr& backendConn,
						QWidget* parent )
: QWidget( parent ), 
  backendConnection(backendConn),
  model( new PublicHubsModel( this ) )
{
	ui.setupUi( this );
	  ui.hubList->setModel(model.get());
	  ui.hubList->header()->setClickable(true);
	  ui.hubList->header()->setSortIndicatorShown(true);
}


void PublicHubs::hubList( const QList<rpc_types::HubEntry>& hubs )
{
	model->setHubs( hubs );
}

PublicHubs::PublicHubsModel::PublicHubsModel( QObject* parent )
: QAbstractTableModel( parent )
{
}

void PublicHubs::on_connectButton_pressed()
{
	QModelIndex index = ui.hubList->selectionModel()->currentIndex();
	backendConnection->createSession(model->getUrl( index.row() ));
	
	emit close();
}

void PublicHubs::on_hubList_doubleClicked()
{
	on_connectButton_pressed();
}

void PublicHubs::on_refreshButton_pressed()
{
	backendConnection->getHubList(true);
}

QVariant PublicHubs::PublicHubsModel::data( const QModelIndex& index,
											int role ) const
{
	if(role==Qt::DisplayRole) {
		switch(index.column()) {
			case 0: return hubEntries[shownEntries[index.row()]].getData().name.c_str();
			case 1: return hubEntries[shownEntries[index.row()]].getData().server.c_str();
			case 2: return hubEntries[shownEntries[index.row()]].getData().description.c_str();
			case 3: return hubEntries[shownEntries[index.row()]].getData().country.c_str();
			case 4: return Util::bytesToStr(hubEntries[shownEntries[index.row()]].getData().minShare);
			case 5: return hubEntries[shownEntries[index.row()]].getData().users;
		}
	}
	return QVariant();
}

QVariant PublicHubs::PublicHubsModel::headerData( int section,
												  Qt::Orientation orientation,
												  int role ) const
{
	if( orientation==Qt::Horizontal && role==Qt::DisplayRole )
	{
		switch(section) {
			case 0: return tr("Name");
			case 1: return tr("Server");
			case 2: return tr("Description");
			case 3: return tr("Country");
			case 4: return tr("MinShare");
			case 5: return tr("Users");
		}
	}
	return QVariant();
}


const QString PublicHubs::PublicHubsModel::getUrl( int row ) const
{
	return hubEntries[shownEntries[row]].getData().server.c_str();
}

void PublicHubs::PublicHubsModel::setHubs( const QList<rpc_types::HubEntry> & hubs)
{
	if(!hubs.empty()) {
		hubEntries.clear();
		shownEntries.clear();
		QList<rpc_types::HubEntry>::const_iterator it = hubs.begin();
		int index = 0;
		while(it != hubs.end() ) {
			hubEntries.push_back(*it);
			++it;
			shownEntries+=index;
			index++;
		}
		emit layoutChanged();
	}
}

void PublicHubs::PublicHubsModel::sort( int col, Qt::SortOrder order )
{
	PublicHubs::PublicHubsModel::Entry::sortCol = col;
	PublicHubs::PublicHubsModel::Entry::sortOrder = order;
	qSort(hubEntries);
	applyFilter( filterPattern );
	emit layoutChanged();
}

void PublicHubs::PublicHubsModel::applyFilter( const QString & pattern )
{
	filterPattern = pattern;
	shownEntries.clear();
	
	for(int i=0;i < hubEntries.size();i++)
	{
		if( QString::fromStdString(hubEntries[i].getData().name).contains(pattern,Qt::CaseInsensitive )) shownEntries+=i;
	}
	
	emit layoutChanged();
}

void PublicHubs::on_filerEdit_textChanged( )
{
	model->applyFilter( ui.filerEdit->text() );
}

