#include <stdint.h>

struct DECOMP_SLICE
{
	uint16_t offset : 13;
	uint16_t length : 3;
};

enum
{
	NUM_DECOMP_LENGTHS=8,
	NUM_DECOMPS=9516,
};

static const uint8_t decomp_lengths[NUM_DECOMP_LENGTHS] = {
	0,
	1,
	2,
	3,
	4,
	5,
	7,
	15,
};

static const int32_t decomp_chars[NUM_DECOMPS] = {
	0x0,
	0x1,
	0x2,
	0x3,
	0x4,
	0x5,
	0x6,
	0x7,
	0x8,
	0x9,
	0xa,
	0xb,
	0xc,
	0xd,
	0xe,
	0xf,
	0x10,
	0x11,
	0x12,
	0x13,
	0x14,
	0x15,
	0x16,
	0x17,
	0x18,
	0x19,
	0x1a,
	0x1b,
	0x1c,
	0x1d,
	0x1e,
	0x1f,
	0x20,
	0x22,
	0x25,
	0x30,
	0x31,
	0x49,
	0x60,
	0x6c,
	0x6d,
	0x7c,
	0x7f,
	0x80,
	0x81,
	0x82,
	0x83,
	0x84,
	0x85,
	0x86,
	0x87,
	0x88,
	0x89,
	0x8a,
	0x8b,
	0x8c,
	0x8d,
	0x8e,
	0x8f,
	0x90,
	0x91,
	0x92,
	0x93,
	0x94,
	0x95,
	0x96,
	0x97,
	0x98,
	0x99,
	0x9a,
	0x9b,
	0x9c,
	0x9d,
	0x9e,
	0x9f,
	0xa0,
	0xa2,
	0xa5,
	0xad,
	0xaf,
	0xb4,
	0xb5,
	0xb8,
	0xc0,
	0xc1,
	0xc2,
	0xc3,
	0xc4,
	0xc5,
	0xc6,
	0xc7,
	0xc8,
	0xc9,
	0xca,
	0xcb,
	0xcc,
	0xcd,
	0xce,
	0xcf,
	0xd0,
	0xd1,
	0xd2,
	0xd3,
	0xd4,
	0xd5,
	0xd6,
	0xd7,
	0xd8,
	0xd9,
	0xda,
	0xdb,
	0xdc,
	0xdd,
	0xe0,
	0xe1,
	0xe2,
	0xe3,
	0xe4,
	0xe5,
	0xe6,
	0xe7,
	0xe8,
	0xe9,
	0xea,
	0xeb,
	0xec,
	0xed,
	0xee,
	0xef,
	0xf0,
	0xf1,
	0xf2,
	0xf3,
	0xf4,
	0xf5,
	0xf6,
	0xf8,
	0xf9,
	0xfa,
	0xfb,
	0xfc,
	0xfd,
	0xff,
	0x100,
	0x101,
	0x102,
	0x103,
	0x104,
	0x105,
	0x106,
	0x107,
	0x108,
	0x109,
	0x10a,
	0x10b,
	0x10c,
	0x10d,
	0x10e,
	0x10f,
	0x110,
	0x111,
	0x112,
	0x113,
	0x114,
	0x115,
	0x116,
	0x117,
	0x118,
	0x119,
	0x11a,
	0x11b,
	0x11c,
	0x11d,
	0x11e,
	0x11f,
	0x120,
	0x121,
	0x122,
	0x123,
	0x124,
	0x125,
	0x126,
	0x127,
	0x128,
	0x129,
	0x12a,
	0x12b,
	0x12c,
	0x12d,
	0x12e,
	0x12f,
	0x130,
	0x131,
	0x132,
	0x133,
	0x134,
	0x135,
	0x136,
	0x137,
	0x139,
	0x13a,
	0x13b,
	0x13c,
	0x13d,
	0x13e,
	0x13f,
	0x140,
	0x141,
	0x142,
	0x143,
	0x144,
	0x145,
	0x146,
	0x147,
	0x148,
	0x149,
	0x14c,
	0x14d,
	0x14e,
	0x14f,
	0x150,
	0x151,
	0x152,
	0x153,
	0x154,
	0x155,
	0x156,
	0x157,
	0x158,
	0x159,
	0x15a,
	0x15b,
	0x15c,
	0x15d,
	0x15e,
	0x15f,
	0x160,
	0x161,
	0x162,
	0x163,
	0x164,
	0x165,
	0x166,
	0x167,
	0x168,
	0x169,
	0x16a,
	0x16b,
	0x16c,
	0x16d,
	0x16e,
	0x16f,
	0x170,
	0x171,
	0x172,
	0x173,
	0x174,
	0x175,
	0x176,
	0x177,
	0x178,
	0x179,
	0x17a,
	0x17b,
	0x17c,
	0x17d,
	0x17e,
	0x17f,
	0x180,
	0x181,
	0x182,
	0x183,
	0x184,
	0x187,
	0x189,
	0x18a,
	0x18c,
	0x18d,
	0x191,
	0x192,
	0x193,
	0x196,
	0x197,
	0x198,
	0x199,
	0x19a,
	0x19d,
	0x19e,
	0x19f,
	0x1a0,
	0x1a1,
	0x1a4,
	0x1a5,
	0x1a6,
	0x1a7,
	0x1ac,
	0x1ad,
	0x1ae,
	0x1af,
	0x1b0,
	0x1b3,
	0x1b4,
	0x1b5,
	0x1b6,
	0x1b7,
	0x1bb,
	0x1bc,
	0x1bd,
	0x1bf,
	0x1c0,
	0x1c1,
	0x1c3,
	0x1c4,
	0x1c5,
	0x1c6,
	0x1c7,
	0x1c8,
	0x1c9,
	0x1ca,
	0x1cb,
	0x1cc,
	0x1cd,
	0x1ce,
	0x1cf,
	0x1d0,
	0x1d1,
	0x1d2,
	0x1d3,
	0x1d4,
	0x1d5,
	0x1d6,
	0x1d7,
	0x1d8,
	0x1d9,
	0x1da,
	0x1db,
	0x1dc,
	0x1de,
	0x1df,
	0x1e0,
	0x1e1,
	0x1e2,
	0x1e3,
	0x1e4,
	0x1e5,
	0x1e6,
	0x1e7,
	0x1e8,
	0x1e9,
	0x1ea,
	0x1eb,
	0x1ec,
	0x1ed,
	0x1ee,
	0x1ef,
	0x1f0,
	0x1f1,
	0x1f2,
	0x1f3,
	0x1f4,
	0x1f5,
	0x1f8,
	0x1f9,
	0x1fa,
	0x1fb,
	0x1fc,
	0x1fd,
	0x1fe,
	0x1ff,
	0x200,
	0x201,
	0x202,
	0x203,
	0x204,
	0x205,
	0x206,
	0x207,
	0x208,
	0x209,
	0x20a,
	0x20b,
	0x20c,
	0x20d,
	0x20e,
	0x20f,
	0x210,
	0x211,
	0x212,
	0x213,
	0x214,
	0x215,
	0x216,
	0x217,
	0x218,
	0x219,
	0x21a,
	0x21b,
	0x21c,
	0x21e,
	0x21f,
	0x222,
	0x223,
	0x224,
	0x225,
	0x226,
	0x227,
	0x228,
	0x229,
	0x22a,
	0x22b,
	0x22c,
	0x22d,
	0x22e,
	0x22f,
	0x230,
	0x231,
	0x232,
	0x233,
	0x23c,
	0x23e,
	0x241,
	0x244,
	0x246,
	0x247,
	0x248,
	0x249,
	0x24d,
	0x24e,
	0x24f,
	0x251,
	0x253,
	0x256,
	0x257,
	0x259,
	0x25a,
	0x25b,
	0x260,
	0x261,
	0x263,
	0x266,
	0x268,
	0x269,
	0x26a,
	0x26b,
	0x26d,
	0x26e,
	0x26f,
	0x271,
	0x273,
	0x275,
	0x276,
	0x27c,
	0x27d,
	0x282,
	0x28b,
	0x28f,
	0x290,
	0x292,
	0x294,
	0x2a0,
	0x2a3,
	0x2a4,
	0x2a5,
	0x2a6,
	0x2a7,
	0x2a8,
	0x2a9,
	0x2aa,
	0x2ab,
	0x2b3,
	0x2b9,
	0x2ba,
	0x2bb,
	0x2bc,
	0x2bd,
	0x2be,
	0x2bf,
	0x2c2,
	0x2c3,
	0x2c4,
	0x2c6,
	0x2c8,
	0x2ca,
	0x2cb,
	0x2d0,
	0x2d3,
	0x2d7,
	0x2d8,
	0x2d9,
	0x2da,
	0x2db,
	0x2dc,
	0x2dd,
	0x2e1,
	0x2e2,
	0x2e4,
	0x2ee,
	0x2f4,
	0x2f6,
	0x2f8,
	0x2fb,
	0x300,
	0x301,
	0x302,
	0x303,
	0x304,
	0x305,
	0x306,
	0x307,
	0x308,
	0x309,
	0x30a,
	0x30b,
	0x30c,
	0x30d,
	0x30e,
	0x30f,
	0x310,
	0x311,
	0x312,
	0x313,
	0x314,
	0x315,
	0x316,
	0x317,
	0x318,
	0x319,
	0x31a,
	0x31b,
	0x31c,
	0x31d,
	0x31e,
	0x31f,
	0x320,
	0x321,
	0x322,
	0x323,
	0x324,
	0x325,
	0x326,
	0x327,
	0x328,
	0x329,
	0x32a,
	0x32b,
	0x32c,
	0x32d,
	0x32e,
	0x32f,
	0x330,
	0x331,
	0x332,
	0x333,
	0x334,
	0x335,
	0x336,
	0x337,
	0x338,
	0x339,
	0x33a,
	0x33b,
	0x33c,
	0x33d,
	0x33e,
	0x33f,
	0x340,
	0x341,
	0x342,
	0x343,
	0x344,
	0x345,
	0x346,
	0x347,
	0x348,
	0x349,
	0x34a,
	0x34b,
	0x34c,
	0x34d,
	0x34e,
	0x34f,
	0x350,
	0x351,
	0x352,
	0x353,
	0x354,
	0x355,
	0x356,
	0x357,
	0x358,
	0x359,
	0x35a,
	0x35b,
	0x35c,
	0x35d,
	0x35e,
	0x35f,
	0x360,
	0x361,
	0x362,
	0x363,
	0x364,
	0x365,
	0x366,
	0x367,
	0x368,
	0x369,
	0x36a,
	0x36b,
	0x36c,
	0x36d,
	0x36e,
	0x36f,
	0x370,
	0x374,
	0x375,
	0x376,
	0x377,
	0x37a,
	0x37b,
	0x37d,
	0x37e,
	0x37f,
	0x384,
	0x385,
	0x386,
	0x387,
	0x388,
	0x389,
	0x38a,
	0x38c,
	0x38e,
	0x38f,
	0x390,
	0x391,
	0x392,
	0x395,
	0x396,
	0x397,
	0x398,
	0x399,
	0x39a,
	0x39b,
	0x39c,
	0x39d,
	0x39f,
	0x3a1,
	0x3a3,
	0x3a4,
	0x3a5,
	0x3a7,
	0x3aa,
	0x3ab,
	0x3ac,
	0x3ad,
	0x3ae,
	0x3af,
	0x3b0,
	0x3b1,
	0x3b2,
	0x3b3,
	0x3b4,
	0x3b5,
	0x3b7,
	0x3b8,
	0x3b9,
	0x3ba,
	0x3bd,
	0x3bf,
	0x3c1,
	0x3c3,
	0x3c4,
	0x3c5,
	0x3c6,
	0x3ca,
	0x3cb,
	0x3cc,
	0x3cd,
	0x3ce,
	0x3d0,
	0x3d1,
	0x3d2,
	0x3d3,
	0x3d4,
	0x3d5,
	0x3d6,
	0x3db,
	0x3dc,
	0x3e8,
	0x3e9,
	0x3f0,
	0x3f1,
	0x3f2,
	0x3f3,
	0x3f4,
	0x3f5,
	0x3f7,
	0x3f8,
	0x3f9,
	0x3fa,
	0x3fd,
	0x3ff,
	0x400,
	0x401,
	0x403,
	0x404,
	0x405,
	0x406,
	0x407,
	0x408,
	0x40c,
	0x40d,
	0x40e,
	0x410,
	0x411,
	0x412,
	0x413,
	0x415,
	0x417,
	0x419,
	0x41a,
	0x41b,
	0x41c,
	0x41d,
	0x41e,
	0x41f,
	0x420,
	0x421,
	0x422,
	0x423,
	0x424,
	0x425,
	0x42b,
	0x42c,
	0x42e,
	0x430,
	0x431,
	0x432,
	0x433,
	0x435,
	0x437,
	0x438,
	0x439,
	0x43a,
	0x43c,
	0x43d,
	0x43e,
	0x43f,
	0x440,
	0x441,
	0x442,
	0x443,
	0x444,
	0x445,
	0x44a,
	0x44b,
	0x44c,
	0x44f,
	0x450,
	0x451,
	0x453,
	0x454,
	0x455,
	0x456,
	0x457,
	0x458,
	0x45b,
	0x45c,
	0x45d,
	0x45e,
	0x461,
	0x462,
	0x463,
	0x470,
	0x471,
	0x472,
	0x473,
	0x474,
	0x475,
	0x476,
	0x477,
	0x47c,
	0x47d,
	0x483,
	0x484,
	0x485,
	0x486,
	0x487,
	0x488,
	0x489,
	0x48a,
	0x48b,
	0x48c,
	0x48d,
	0x490,
	0x491,
	0x492,
	0x493,
	0x496,
	0x497,
	0x498,
	0x499,
	0x49a,
	0x49b,
	0x49e,
	0x49f,
	0x4a2,
	0x4a3,
	0x4aa,
	0x4ab,
	0x4ac,
	0x4ad,
	0x4ae,
	0x4af,
	0x4b0,
	0x4b1,
	0x4b2,
	0x4bb,
	0x4bd,
	0x4be,
	0x4bf,
	0x4c0,
	0x4c1,
	0x4c2,
	0x4c5,
	0x4c6,
	0x4c7,
	0x4c8,
	0x4c9,
	0x4ca,
	0x4cb,
	0x4cc,
	0x4cd,
	0x4ce,
	0x4cf,
	0x4d0,
	0x4d1,
	0x4d2,
	0x4d3,
	0x4d4,
	0x4d5,
	0x4d6,
	0x4d7,
	0x4d8,
	0x4d9,
	0x4da,
	0x4db,
	0x4dc,
	0x4dd,
	0x4de,
	0x4df,
	0x4e0,
	0x4e1,
	0x4e2,
	0x4e3,
	0x4e4,
	0x4e5,
	0x4e6,
	0x4e7,
	0x4e8,
	0x4e9,
	0x4ea,
	0x4eb,
	0x4ec,
	0x4ed,
	0x4ee,
	0x4ef,
	0x4f0,
	0x4f1,
	0x4f2,
	0x4f3,
	0x4f4,
	0x4f5,
	0x4f8,
	0x4f9,
	0x501,
	0x50a,
	0x50c,
	0x50d,
	0x510,
	0x511,
	0x51b,
	0x51c,
	0x51d,
	0x53b,
	0x544,
	0x54a,
	0x54c,
	0x54d,
	0x54f,
	0x553,
	0x555,
	0x55a,
	0x55d,
	0x561,
	0x563,
	0x566,
	0x56e,
	0x570,
	0x575,
	0x578,
	0x57a,
	0x57c,
	0x57d,
	0x581,
	0x584,
	0x585,
	0x587,
	0x589,
	0x591,
	0x592,
	0x593,
	0x594,
	0x595,
	0x596,
	0x597,
	0x598,
	0x599,
	0x59a,
	0x59b,
	0x59c,
	0x59d,
	0x59e,
	0x59f,
	0x5a0,
	0x5a1,
	0x5a2,
	0x5a3,
	0x5a4,
	0x5a5,
	0x5a6,
	0x5a7,
	0x5a8,
	0x5a9,
	0x5aa,
	0x5ab,
	0x5ac,
	0x5ad,
	0x5ae,
	0x5af,
	0x5b0,
	0x5b1,
	0x5b2,
	0x5b3,
	0x5b4,
	0x5b5,
	0x5b6,
	0x5b7,
	0x5b8,
	0x5b9,
	0x5ba,
	0x5bb,
	0x5bc,
	0x5bd,
	0x5bf,
	0x5c0,
	0x5c1,
	0x5c2,
	0x5c3,
	0x5c4,
	0x5c5,
	0x5c7,
	0x5d5,
	0x5d8,
	0x5d9,
	0x5df,
	0x5e1,
	0x5f0,
	0x5f1,
	0x5f2,
	0x5f3,
	0x5f4,
	0x600,
	0x601,
	0x602,
	0x603,
	0x604,
	0x605,
	0x609,
	0x60a,
	0x60d,
	0x60f,
	0x610,
	0x611,
	0x612,
	0x613,
	0x614,
	0x615,
	0x616,
	0x617,
	0x618,
	0x619,
	0x61a,
	0x61c,
	0x622,
	0x623,
	0x624,
	0x625,
	0x626,
	0x627,
	0x62b,
	0x634,
	0x63d,
	0x63f,
	0x647,
	0x64a,
	0x64b,
	0x64c,
	0x64d,
	0x64e,
	0x64f,
	0x650,
	0x651,
	0x652,
	0x653,
	0x654,
	0x655,
	0x656,
	0x657,
	0x658,
	0x659,
	0x65a,
	0x65b,
	0x65c,
	0x65d,
	0x65e,
	0x65f,
	0x660,
	0x661,
	0x665,
	0x667,
	0x668,
	0x66a,
	0x66b,
	0x66c,
	0x66d,
	0x66e,
	0x66f,
	0x670,
	0x672,
	0x673,
	0x675,
	0x676,
	0x677,
	0x678,
	0x679,
	0x67e,
	0x681,
	0x685,
	0x688,
	0x68b,
	0x68e,
	0x691,
	0x692,
	0x698,
	0x69e,
	0x69f,
	0x6a4,
	0x6a7,
	0x6a8,
	0x6a9,
	0x6aa,
	0x6ad,
	0x6b4,
	0x6b5,
	0x6b7,
	0x6ba,
	0x6bb,
	0x6bd,
	0x6be,
	0x6c0,
	0x6c1,
	0x6c2,
	0x6c3,
	0x6c6,
	0x6c7,
	0x6c8,
	0x6c9,
	0x6cb,
	0x6cc,
	0x6ce,
	0x6d0,
	0x6d1,
	0x6d2,
	0x6d3,
	0x6d4,
	0x6d5,
	0x6d6,
	0x6d7,
	0x6d8,
	0x6d9,
	0x6da,
	0x6db,
	0x6dc,
	0x6dd,
	0x6df,
	0x6e0,
	0x6e1,
	0x6e2,
	0x6e3,
	0x6e4,
	0x6e7,
	0x6e8,
	0x6ea,
	0x6eb,
	0x6ec,
	0x6ed,
	0x6ee,
	0x6ef,
	0x6f0,
	0x6f1,
	0x6f2,
	0x6f3,
	0x6f4,
	0x6f5,
	0x6f6,
	0x6f7,
	0x6f8,
	0x6f9,
	0x6fd,
	0x6fe,
	0x6ff,
	0x701,
	0x702,
	0x703,
	0x704,
	0x70f,
	0x711,
	0x730,
	0x731,
	0x732,
	0x733,
	0x734,
	0x735,
	0x736,
	0x737,
	0x738,
	0x739,
	0x73a,
	0x73b,
	0x73c,
	0x73d,
	0x73e,
	0x73f,
	0x740,
	0x741,
	0x742,
	0x743,
	0x744,
	0x745,
	0x746,
	0x747,
	0x748,
	0x749,
	0x74a,
	0x751,
	0x756,
	0x762,
	0x763,
	0x767,
	0x768,
	0x769,
	0x76c,
	0x771,
	0x772,
	0x77e,
	0x7a6,
	0x7a7,
	0x7a8,
	0x7a9,
	0x7aa,
	0x7ab,
	0x7ac,
	0x7ad,
	0x7ae,
	0x7af,
	0x7b0,
	0x7c0,
	0x7ca,
	0x7eb,
	0x7ec,
	0x7ed,
	0x7ee,
	0x7ef,
	0x7f0,
	0x7f1,
	0x7f2,
	0x7f3,
	0x7f4,
	0x7f5,
	0x7fa,
	0x7fd,
	0x816,
	0x817,
	0x818,
	0x819,
	0x81b,
	0x81c,
	0x81d,
	0x81e,
	0x81f,
	0x820,
	0x821,
	0x822,
	0x823,
	0x825,
	0x826,
	0x827,
	0x829,
	0x82a,
	0x82b,
	0x82c,
	0x82d,
	0x859,
	0x85a,
	0x85b,
	0x8a1,
	0x8a4,
	0x8a7,
	0x8a8,
	0x8a9,
	0x8ae,
	0x8af,
	0x8b0,
	0x8b1,
	0x8b2,
	0x8b6,
	0x8b7,
	0x8b9,
	0x8ba,
	0x8bb,
	0x8bc,
	0x8bd,
	0x8d3,
	0x8d4,
	0x8d5,
	0x8d6,
	0x8d7,
	0x8d8,
	0x8d9,
	0x8da,
	0x8db,
	0x8dc,
	0x8dd,
	0x8de,
	0x8df,
	0x8e0,
	0x8e1,
	0x8e2,
	0x8e3,
	0x8e4,
	0x8e5,
	0x8e6,
	0x8e7,
	0x8e8,
	0x8e9,
	0x8ea,
	0x8eb,
	0x8ec,
	0x8ed,
	0x8ee,
	0x8ef,
	0x8f0,
	0x8f1,
	0x8f2,
	0x8f3,
	0x8f4,
	0x8f5,
	0x8f6,
	0x8f7,
	0x8f8,
	0x8f9,
	0x8fa,
	0x8fb,
	0x8fc,
	0x8fd,
	0x8fe,
	0x8ff,
	0x900,
	0x901,
	0x902,
	0x903,
	0x904,
	0x906,
	0x908,
	0x90d,
	0x90e,
	0x910,
	0x911,
	0x912,
	0x913,
	0x914,
	0x929,
	0x931,
	0x934,
	0x93a,
	0x93b,
	0x93c,
	0x93e,
	0x93f,
	0x940,
	0x941,
	0x942,
	0x943,
	0x944,
	0x945,
	0x946,
	0x947,
	0x948,
	0x949,
	0x94a,
	0x94b,
	0x94c,
	0x94d,
	0x94e,
	0x94f,
	0x951,
	0x952,
	0x953,
	0x954,
	0x955,
	0x956,
	0x957,
	0x958,
	0x959,
	0x95a,
	0x95b,
	0x95c,
	0x95d,
	0x95e,
	0x95f,
	0x962,
	0x963,
	0x965,
	0x966,
	0x967,
	0x97d,
	0x981,
	0x982,
	0x983,
	0x986,
	0x9bc,
	0x9be,
	0x9bf,
	0x9c0,
	0x9c1,
	0x9c2,
	0x9c3,
	0x9c4,
	0x9c7,
	0x9c8,
	0x9cb,
	0x9cc,
	0x9cd,
	0x9d7,
	0x9dc,
	0x9dd,
	0x9df,
	0x9e0,
	0x9e1,
	0x9e2,
	0x9e3,
	0x9e6,
	0x9ea,
	0x9ed,
	0x9fe,
	0xa01,
	0xa02,
	0xa03,
	0xa06,
	0xa07,
	0xa08,
	0xa09,
	0xa0a,
	0xa0f,
	0xa10,
	0xa14,
	0xa33,
	0xa36,
	0xa3c,
	0xa3e,
	0xa3f,
	0xa40,
	0xa41,
	0xa42,
	0xa47,
	0xa48,
	0xa4b,
	0xa4c,
	0xa4d,
	0xa51,
	0xa59,
	0xa5a,
	0xa5b,
	0xa5e,
	0xa66,
	0xa67,
	0xa6a,
	0xa70,
	0xa71,
	0xa75,
	0xa81,
	0xa82,
	0xa83,
	0xa86,
	0xa8d,
	0xa8f,
	0xa90,
	0xa91,
	0xa93,
	0xa94,
	0xabc,
	0xabd,
	0xabe,
	0xabf,
	0xac0,
	0xac1,
	0xac2,
	0xac3,
	0xac4,
	0xac5,
	0xac7,
	0xac8,
	0xac9,
	0xacb,
	0xacc,
	0xacd,
	0xae2,
	0xae3,
	0xae6,
	0xae8,
	0xae9,
	0xaea,
	0xaee,
	0xaf0,
	0xafa,
	0xafb,
	0xafc,
	0xafd,
	0xafe,
	0xaff,
	0xb01,
	0xb02,
	0xb03,
	0xb06,
	0xb20,
	0xb3c,
	0xb3e,
	0xb3f,
	0xb40,
	0xb41,
	0xb42,
	0xb43,
	0xb44,
	0xb47,
	0xb48,
	0xb4b,
	0xb4c,
	0xb4d,
	0xb56,
	0xb57,
	0xb5c,
	0xb5d,
	0xb62,
	0xb63,
	0xb66,
	0xb68,
	0xb82,
	0xb8a,
	0xb94,
	0xb9c,
	0xbb0,
	0xbbe,
	0xbbf,
	0xbc0,
	0xbc1,
	0xbc2,
	0xbc6,
	0xbc7,
	0xbc8,
	0xbca,
	0xbcb,
	0xbcc,
	0xbcd,
	0xbd7,
	0xbe6,
	0xbe7,
	0xbe8,
	0xbea,
	0xbeb,
	0xbec,
	0xbed,
	0xbee,
	0xbf0,
	0xbf2,
	0xbf4,
	0xbf5,
	0xbf7,
	0xbf8,
	0xbfa,
	0xc00,
	0xc01,
	0xc02,
	0xc03,
	0xc04,
	0xc13,
	0xc14,
	0xc20,
	0xc22,
	0xc25,
	0xc2d,
	0xc2e,
	0xc37,
	0xc39,
	0xc3e,
	0xc3f,
	0xc40,
	0xc41,
	0xc42,
	0xc43,
	0xc44,
	0xc46,
	0xc47,
	0xc48,
	0xc4a,
	0xc4b,
	0xc4c,
	0xc4d,
	0xc55,
	0xc56,
	0xc60,
	0xc61,
	0xc62,
	0xc63,
	0xc66,
	0xc81,
	0xc82,
	0xc83,
	0xc85,
	0xc86,
	0xc87,
	0xc92,
	0xc93,
	0xc94,
	0xc9c,
	0xc9e,
	0xca3,
	0xcaf,
	0xcb1,
	0xcb2,
	0xcbc,
	0xcbe,
	0xcbf,
	0xcc0,
	0xcc1,
	0xcc2,
	0xcc3,
	0xcc4,
	0xcc6,
	0xcc7,
	0xcc8,
	0xcca,
	0xccb,
	0xccc,
	0xccd,
	0xcd5,
	0xcd6,
	0xce1,
	0xce2,
	0xce3,
	0xce6,
	0xce7,
	0xce8,
	0xcef,
	0xd00,
	0xd01,
	0xd02,
	0xd03,
	0xd08,
	0xd09,
	0xd0a,
	0xd0c,
	0xd10,
	0xd13,
	0xd14,
	0xd19,
	0xd1c,
	0xd20,
	0xd23,
	0xd31,
	0xd34,
	0xd36,
	0xd3a,
	0xd3b,
	0xd3c,
	0xd3e,
	0xd3f,
	0xd40,
	0xd41,
	0xd42,
	0xd43,
	0xd44,
	0xd46,
	0xd47,
	0xd48,
	0xd4a,
	0xd4b,
	0xd4c,
	0xd4d,
	0xd4e,
	0xd57,
	0xd5a,
	0xd5f,
	0xd61,
	0xd62,
	0xd63,
	0xd66,
	0xd6a,
	0xd6b,
	0xd6c,
	0xd6d,
	0xd6e,
	0xd6f,
	0xd76,
	0xd79,
	0xd7b,
	0xd7c,
	0xd82,
	0xd83,
	0xdca,
	0xdcf,
	0xdd0,
	0xdd1,
	0xdd2,
	0xdd3,
	0xdd4,
	0xdd6,
	0xdd8,
	0xdd9,
	0xdda,
	0xddb,
	0xddc,
	0xddd,
	0xdde,
	0xddf,
	0xde9,
	0xdea,
	0xdeb,
	0xdef,
	0xdf2,
	0xdf3,
	0xe03,
	0xe0b,
	0xe0f,
	0xe14,
	0xe15,
	0xe17,
	0xe21,
	0xe26,
	0xe31,
	0xe33,
	0xe34,
	0xe35,
	0xe36,
	0xe37,
	0xe38,
	0xe39,
	0xe3a,
	0xe41,
	0xe45,
	0xe47,
	0xe48,
	0xe49,
	0xe4a,
	0xe4b,
	0xe4c,
	0xe4d,
	0xe4e,
	0xe50,
	0xe88,
	0xe8d,
	0xe9a,
	0xe9b,
	0xe9d,
	0xe9e,
	0xe9f,
	0xeb1,
	0xeb3,
	0xeb4,
	0xeb5,
	0xeb6,
	0xeb7,
	0xeb8,
	0xeb9,
	0xebb,
	0xebc,
	0xec8,
	0xec9,
	0xeca,
	0xecb,
	0xecc,
	0xecd,
	0xed0,
	0xedc,
	0xedd,
	0xf00,
	0xf02,
	0xf03,
	0xf0c,
	0xf0e,
	0xf18,
	0xf19,
	0xf1b,
	0xf1e,
	0xf1f,
	0xf35,
	0xf37,
	0xf39,
	0xf3e,
	0xf3f,
	0xf43,
	0xf4d,
	0xf52,
	0xf57,
	0xf5c,
	0xf69,
	0xf6a,
	0xf71,
	0xf72,
	0xf73,
	0xf74,
	0xf75,
	0xf76,
	0xf77,
	0xf78,
	0xf79,
	0xf7a,
	0xf7b,
	0xf7c,
	0xf7d,
	0xf7e,
	0xf7f,
	0xf80,
	0xf81,
	0xf82,
	0xf83,
	0xf84,
	0xf86,
	0xf87,
	0xf8d,
	0xf8e,
	0xf8f,
	0xf90,
	0xf91,
	0xf92,
	0xf93,
	0xf94,
	0xf95,
	0xf96,
	0xf97,
	0xf99,
	0xf9a,
	0xf9b,
	0xf9c,
	0xf9d,
	0xf9e,
	0xf9f,
	0xfa0,
	0xfa1,
	0xfa2,
	0xfa3,
	0xfa4,
	0xfa5,
	0xfa6,
	0xfa7,
	0xfa8,
	0xfa9,
	0xfaa,
	0xfab,
	0xfac,
	0xfad,
	0xfae,
	0xfaf,
	0xfb0,
	0xfb1,
	0xfb2,
	0xfb3,
	0xfb4,
	0xfb5,
	0xfb6,
	0xfb7,
	0xfb8,
	0xfb9,
	0xfba,
	0xfbb,
	0xfbc,
	0xfc6,
	0xfce,
	0xfd5,
	0xfd6,
	0x1000,
	0x1010,
	0x101d,
	0x101f,
	0x1026,
	0x1029,
	0x102a,
	0x102b,
	0x102c,
	0x102d,
	0x102e,
	0x102f,
	0x1030,
	0x1031,
	0x1032,
	0x1033,
	0x1034,
	0x1035,
	0x1036,
	0x1037,
	0x1038,
	0x1039,
	0x103a,
	0x103b,
	0x103c,
	0x103d,
	0x103e,
	0x1040,
	0x104b,
	0x1056,
	0x1057,
	0x1058,
	0x1059,
	0x105e,
	0x105f,
	0x1060,
	0x1062,
	0x1063,
	0x1064,
	0x1065,
	0x1066,
	0x1067,
	0x1068,
	0x1069,
	0x106a,
	0x106b,
	0x106c,
	0x106d,
	0x106f,
	0x1070,
	0x1071,
	0x1072,
	0x1073,
	0x1074,
	0x107e,
	0x1081,
	0x1082,
	0x1083,
	0x1084,
	0x1085,
	0x1086,
	0x1087,
	0x1088,
	0x1089,
	0x108a,
	0x108b,
	0x108c,
	0x108d,
	0x108f,
	0x109a,
	0x109b,
	0x109c,
	0x109d,
	0x109e,
	0x10a0,
	0x10e7,
	0x10f3,
	0x10ff,
	0x1101,
	0x1104,
	0x1108,
	0x110a,
	0x110d,
	0x1113,
	0x1114,
	0x1115,
	0x1116,
	0x1117,
	0x1118,
	0x1119,
	0x111a,
	0x111b,
	0x111c,
	0x111d,
	0x111e,
	0x111f,
	0x1120,
	0x1121,
	0x1122,
	0x1123,
	0x1124,
	0x1125,
	0x1126,
	0x1127,
	0x1128,
	0x1129,
	0x112a,
	0x112b,
	0x112c,
	0x112d,
	0x112e,
	0x112f,
	0x1130,
	0x1131,
	0x1132,
	0x1133,
	0x1134,
	0x1135,
	0x1136,
	0x1137,
	0x1138,
	0x1139,
	0x113a,
	0x113b,
	0x113d,
	0x113f,
	0x1141,
	0x1142,
	0x1143,
	0x1144,
	0x1145,
	0x1146,
	0x1147,
	0x1148,
	0x1149,
	0x114a,
	0x114b,
	0x114d,
	0x114f,
	0x1151,
	0x1152,
	0x1153,
	0x1156,
	0x1157,
	0x1158,
	0x115a,
	0x115b,
	0x115c,
	0x115d,
	0x115e,
	0x1162,
	0x1164,
	0x1166,
	0x1168,
	0x116a,
	0x116b,
	0x116c,
	0x116f,
	0x1170,
	0x1171,
	0x1173,
	0x1174,
	0x1175,
	0x1176,
	0x1177,
	0x1178,
	0x1179,
	0x117a,
	0x117b,
	0x117c,
	0x117d,
	0x117e,
	0x117f,
	0x1180,
	0x1181,
	0x1182,
	0x1183,
	0x1184,
	0x1185,
	0x1186,
	0x1187,
	0x1188,
	0x1189,
	0x118a,
	0x118b,
	0x118c,
	0x118d,
	0x118e,
	0x118f,
	0x1190,
	0x1191,
	0x1192,
	0x1193,
	0x1194,
	0x1195,
	0x1196,
	0x1197,
	0x1198,
	0x1199,
	0x119a,
	0x119b,
	0x119c,
	0x119d,
	0x119f,
	0x11a0,
	0x11a1,
	0x11a2,
	0x11a3,
	0x11a4,
	0x11a5,
	0x11a6,
	0x11a7,
	0x11a8,
	0x11a9,
	0x11aa,
	0x11ab,
	0x11ac,
	0x11ad,
	0x11ae,
	0x11af,
	0x11b0,
	0x11b1,
	0x11b2,
	0x11b3,
	0x11b4,
	0x11b5,
	0x11b6,
	0x11b7,
	0x11b8,
	0x11b9,
	0x11ba,
	0x11bb,
	0x11bc,
	0x11bd,
	0x11be,
	0x11bf,
	0x11c0,
	0x11c1,
	0x11c2,
	0x11c3,
	0x11c4,
	0x11c5,
	0x11c6,
	0x11c7,
	0x11c8,
	0x11c9,
	0x11ca,
	0x11cb,
	0x11cc,
	0x11cd,
	0x11ce,
	0x11cf,
	0x11d0,
	0x11d1,
	0x11d2,
	0x11d3,
	0x11d4,
	0x11d5,
	0x11d6,
	0x11d7,
	0x11d8,
	0x11d9,
	0x11da,
	0x11db,
	0x11dc,
	0x11dd,
	0x11de,
	0x11df,
	0x11e0,
	0x11e1,
	0x11e2,
	0x11e3,
	0x11e4,
	0x11e5,
	0x11e6,
	0x11e7,
	0x11e8,
	0x11e9,
	0x11ea,
	0x11eb,
	0x11ec,
	0x11ed,
	0x11ee,
	0x11ef,
	0x11f0,
	0x11f1,
	0x11f2,
	0x11f3,
	0x11f4,
	0x11f5,
	0x11f6,
	0x11f7,
	0x11f8,
	0x11f9,
	0x11fa,
	0x11fb,
	0x11fc,
	0x11fd,
	0x11fe,
	0x11ff,
	0x1200,
	0x1223,
	0x1240,
	0x1260,
	0x1294,
	0x12d0,
	0x135d,
	0x135e,
	0x135f,
	0x13a0,
	0x13a1,
	0x13a2,
	0x13a4,
	0x13a5,
	0x13a8,
	0x13a9,
	0x13aa,
	0x13ab,
	0x13ac,
	0x13ae,
	0x13b0,
	0x13b1,
	0x13b3,
	0x13b7,
	0x13bb,
	0x13bd,
	0x13be,
	0x13bf,
	0x13c0,
	0x13c2,
	0x13c3,
	0x13c7,
	0x13cb,
	0x13cc,
	0x13ce,
	0x13cf,
	0x13d2,
	0x13d4,
	0x13d5,
	0x13d9,
	0x13da,
	0x13de,
	0x13df,
	0x13e2,
	0x13e6,
	0x13e7,
	0x13eb,
	0x13ee,
	0x13f0,
	0x13f2,
	0x13f3,
	0x13f4,
	0x13fb,
	0x13fc,
	0x1400,
	0x1403,
	0x140c,
	0x140d,
	0x140e,
	0x140f,
	0x1410,
	0x1411,
	0x1412,
	0x1413,
	0x1414,
	0x1415,
	0x1417,
	0x1418,
	0x1419,
	0x141a,
	0x1427,
	0x142b,
	0x142c,
	0x142d,
	0x142e,
	0x142f,
	0x1431,
	0x1433,
	0x1437,
	0x1438,
	0x143a,
	0x143b,
	0x143c,
	0x143d,
	0x143e,
	0x143f,
	0x1440,
	0x1441,
	0x1442,
	0x1443,
	0x1444,
	0x1445,
	0x1446,
	0x1447,
	0x144a,
	0x144c,
	0x144e,
	0x1454,
	0x1457,
	0x1458,
	0x1459,
	0x145a,
	0x145b,
	0x145c,
	0x145d,
	0x145e,
	0x145f,
	0x1460,
	0x1461,
	0x1462,
	0x1463,
	0x1464,
	0x1467,
	0x1468,
	0x1469,
	0x146a,
	0x146d,
	0x146f,
	0x1474,
	0x1475,
	0x1476,
	0x1477,
	0x1478,
	0x1479,
	0x147a,
	0x147b,
	0x147c,
	0x147d,
	0x147e,
	0x147f,
	0x1480,
	0x1481,
	0x1485,
	0x1486,
	0x1487,
	0x1488,
	0x148d,
	0x1492,
	0x1493,
	0x1494,
	0x1495,
	0x1496,
	0x1497,
	0x1498,
	0x1499,
	0x149a,
	0x149b,
	0x149c,
	0x149d,
	0x149e,
	0x149f,
	0x14a5,
	0x14aa,
	0x14ac,
	0x14ad,
	0x14ae,
	0x14af,
	0x14b0,
	0x14b1,
	0x14b2,
	0x14b3,
	0x14b4,
	0x14b5,
	0x14b6,
	0x14b7,
	0x14b8,
	0x14b9,
	0x14bf,
	0x14c9,
	0x14ca,
	0x14cb,
	0x14cc,
	0x14cd,
	0x14ce,
	0x14d1,
	0x14dc,
	0x14dd,
	0x14de,
	0x14df,
	0x14e0,
	0x14e1,
	0x14e2,
	0x14e3,
	0x14e4,
	0x14e5,
	0x14e6,
	0x14e7,
	0x14e8,
	0x14e9,
	0x14f6,
	0x14f7,
	0x14f8,
	0x14f9,
	0x14fa,
	0x14fb,
	0x14fc,
	0x14fd,
	0x14fe,
	0x14ff,
	0x1500,
	0x1501,
	0x1502,
	0x1503,
	0x150c,
	0x150d,
	0x150e,
	0x150f,
	0x1517,
	0x1518,
	0x1519,
	0x151a,
	0x151b,
	0x151c,
	0x151d,
	0x151e,
	0x151f,
	0x1520,
	0x1521,
	0x1522,
	0x1523,
	0x1524,
	0x152f,
	0x1530,
	0x1531,
	0x1532,
	0x1533,
	0x1534,
	0x1535,
	0x1536,
	0x1537,
	0x1538,
	0x1539,
	0x153a,
	0x153b,
	0x153c,
	0x1540,
	0x1541,
	0x154e,
	0x154f,
	0x155b,
	0x155c,
	0x1568,
	0x1569,
	0x1577,
	0x157c,
	0x157d,
	0x157e,
	0x157f,
	0x1580,
	0x1581,
	0x1582,
	0x1583,
	0x1584,
	0x1585,
	0x1587,
	0x158e,
	0x158f,
	0x1590,
	0x1591,
	0x1592,
	0x1593,
	0x1594,
	0x15af,
	0x15b4,
	0x15b5,
	0x15b7,
	0x15c4,
	0x15c5,
	0x15de,
	0x15ea,
	0x15ef,
	0x15f0,
	0x15f7,
	0x1602,
	0x1603,
	0x1604,
	0x1607,
	0x1622,
	0x1623,
	0x1624,
	0x162e,
	0x162f,
	0x1634,
	0x1635,
	0x166d,
	0x166e,
	0x166f,
	0x1670,
	0x1671,
	0x1672,
	0x1673,
	0x1674,
	0x1675,
	0x1676,
	0x1677,
	0x1678,
	0x1679,
	0x167a,
	0x167b,
	0x167c,
	0x167d,
	0x1680,
	0x16b2,
	0x16b7,
	0x16c1,
	0x16c2,
	0x16cc,
	0x16d5,
	0x16d6,
	0x16d8,
	0x16e1,
	0x16eb,
	0x16ec,
	0x16ed,
	0x16f0,
	0x1712,
	0x1713,
	0x1714,
	0x1732,
	0x1733,
	0x1734,
	0x1735,
	0x1752,
	0x1753,
	0x1772,
	0x1773,
	0x17a3,
	0x17b4,
	0x17b5,
	0x17b6,
	0x17b7,
	0x17b8,
	0x17b9,
	0x17ba,
	0x17bb,
	0x17bc,
	0x17bd,
	0x17be,
	0x17bf,
	0x17c0,
	0x17c1,
	0x17c2,
	0x17c3,
	0x17c4,
	0x17c5,
	0x17c6,
	0x17c7,
	0x17c8,
	0x17c9,
	0x17ca,
	0x17cb,
	0x17cc,
	0x17cd,
	0x17ce,
	0x17cf,
	0x17d0,
	0x17d1,
	0x17d2,
	0x17d3,
	0x17d4,
	0x17d5,
	0x17d9,
	0x17da,
	0x17dd,
	0x1803,
	0x1809,
	0x180b,
	0x180c,
	0x180d,
	0x180e,
	0x1855,
	0x1885,
	0x1886,
	0x1896,
	0x18a9,
	0x18b3,
	0x18b6,
	0x18b9,
	0x18c2,
	0x18c6,
	0x18c7,
	0x18c8,
	0x18c9,
	0x18ca,
	0x18cb,
	0x18cc,
	0x18cd,
	0x18ce,
	0x18cf,
	0x18d0,
	0x18d1,
	0x18d2,
	0x18d3,
	0x18db,
	0x18dc,
	0x18dd,
	0x18e0,
	0x18e3,
	0x18e4,
	0x18e5,
	0x18e8,
	0x18ea,
	0x18ed,
	0x18f0,
	0x18f2,
	0x1920,
	0x1921,
	0x1922,
	0x1923,
	0x1924,
	0x1925,
	0x1926,
	0x1927,
	0x1928,
	0x1929,
	0x192a,
	0x192b,
	0x1930,
	0x1931,
	0x1932,
	0x1933,
	0x1934,
	0x1935,
	0x1936,
	0x1937,
	0x1938,
	0x1939,
	0x193a,
	0x193b,
	0x19d0,
	0x19d1,
	0x1a17,
	0x1a18,
	0x1a19,
	0x1a1a,
	0x1a1b,
	0x1a55,
	0x1a56,
	0x1a57,
	0x1a58,
	0x1a59,
	0x1a5a,
	0x1a5b,
	0x1a5c,
	0x1a5d,
	0x1a5e,
	0x1a60,
	0x1a61,
	0x1a62,
	0x1a63,
	0x1a64,
	0x1a65,
	0x1a66,
	0x1a67,
	0x1a68,
	0x1a69,
	0x1a6a,
	0x1a6b,
	0x1a6c,
	0x1a6d,
	0x1a6e,
	0x1a6f,
	0x1a70,
	0x1a71,
	0x1a72,
	0x1a73,
	0x1a74,
	0x1a75,
	0x1a76,
	0x1a77,
	0x1a78,
	0x1a79,
	0x1a7a,
	0x1a7b,
	0x1a7c,
	0x1a7f,
	0x1a80,
	0x1a90,
	0x1aa9,
	0x1aab,
	0x1ab0,
	0x1ab1,
	0x1ab2,
	0x1ab3,
	0x1ab4,
	0x1ab5,
	0x1ab6,
	0x1ab7,
	0x1ab8,
	0x1ab9,
	0x1aba,
	0x1abb,
	0x1abc,
	0x1abd,
	0x1abe,
	0x1b00,
	0x1b01,
	0x1b02,
	0x1b03,
	0x1b04,
	0x1b06,
	0x1b08,
	0x1b0a,
	0x1b0c,
	0x1b0e,
	0x1b12,
	0x1b34,
	0x1b35,
	0x1b36,
	0x1b37,
	0x1b38,
	0x1b39,
	0x1b3a,
	0x1b3b,
	0x1b3c,
	0x1b3d,
	0x1b3e,
	0x1b3f,
	0x1b40,
	0x1b41,
	0x1b42,
	0x1b43,
	0x1b44,
	0x1b52,
	0x1b53,
	0x1b58,
	0x1b5c,
	0x1b5f,
	0x1b6b,
	0x1b6c,
	0x1b6d,
	0x1b6e,
	0x1b6f,
	0x1b70,
	0x1b71,
	0x1b72,
	0x1b73,
	0x1b80,
	0x1b81,
	0x1b82,
	0x1ba1,
	0x1ba2,
	0x1ba3,
	0x1ba4,
	0x1ba5,
	0x1ba6,
	0x1ba7,
	0x1ba8,
	0x1ba9,
	0x1baa,
	0x1bab,
	0x1bac,
	0x1bad,
	0x1be6,
	0x1be7,
	0x1be8,
	0x1be9,
	0x1bea,
	0x1beb,
	0x1bec,
	0x1bed,
	0x1bee,
	0x1bef,
	0x1bf0,
	0x1bf1,
	0x1bf2,
	0x1bf3,
	0x1c24,
	0x1c25,
	0x1c26,
	0x1c27,
	0x1c28,
	0x1c29,
	0x1c2a,
	0x1c2b,
	0x1c2c,
	0x1c2d,
	0x1c2e,
	0x1c2f,
	0x1c30,
	0x1c31,
	0x1c32,
	0x1c33,
	0x1c34,
	0x1c35,
	0x1c36,
	0x1c37,
	0x1c3c,
	0x1c7f,
	0x1cd0,
	0x1cd1,
	0x1cd2,
	0x1cd3,
	0x1cd4,
	0x1cd5,
	0x1cd6,
	0x1cd7,
	0x1cd8,
	0x1cd9,
	0x1cda,
	0x1cdb,
	0x1cdc,
	0x1cdd,
	0x1cde,
	0x1cdf,
	0x1ce0,
	0x1ce1,
	0x1ce2,
	0x1ce3,
	0x1ce4,
	0x1ce5,
	0x1ce6,
	0x1ce7,
	0x1ce8,
	0x1ced,
	0x1cf2,
	0x1cf3,
	0x1cf4,
	0x1cf7,
	0x1cf8,
	0x1cf9,
	0x1d04,
	0x1d08,
	0x1d0b,
	0x1d0d,
	0x1d0f,
	0x1d10,
	0x1d11,
	0x1d14,
	0x1d1c,
	0x1d20,
	0x1d21,
	0x1d22,
	0x1d24,
	0x1d26,
	0x1d27,
	0x1d28,
	0x1d29,
	0x1d2b,
	0x1d3e,
	0x1d52,
	0x1d6b,
	0x1d6e,
	0x1d6f,
	0x1d70,
	0x1d72,
	0x1d73,
	0x1d74,
	0x1d75,
	0x1d76,
	0x1d78,
	0x1d7b,
	0x1d7c,
	0x1d7d,
	0x1d7e,
	0x1d7f,
	0x1d83,
	0x1d8c,
	0x1d90,
	0x1d9f,
	0x1da2,
	0x1dba,
	0x1dbb,
	0x1dc0,
	0x1dc1,
	0x1dc2,
	0x1dc3,
	0x1dc4,
	0x1dc5,
	0x1dc6,
	0x1dc7,
	0x1dc8,
	0x1dc9,
	0x1dca,
	0x1dcb,
	0x1dcc,
	0x1dcd,
	0x1dce,
	0x1dcf,
	0x1dd0,
	0x1dd1,
	0x1dd2,
	0x1dd3,
	0x1dd4,
	0x1dd5,
	0x1dd6,
	0x1dd7,
	0x1dd8,
	0x1dd9,
	0x1dda,
	0x1ddb,
	0x1ddc,
	0x1ddd,
	0x1dde,
	0x1ddf,
	0x1de0,
	0x1de1,
	0x1de2,
	0x1de3,
	0x1de4,
	0x1de5,
	0x1de6,
	0x1de7,
	0x1de8,
	0x1de9,
	0x1dea,
	0x1deb,
	0x1dec,
	0x1ded,
	0x1dee,
	0x1def,
	0x1df0,
	0x1df1,
	0x1df2,
	0x1df3,
	0x1df4,
	0x1df5,
	0x1df6,
	0x1df7,
	0x1df8,
	0x1df9,
	0x1dfb,
	0x1dfc,
	0x1dfd,
	0x1dfe,
	0x1dff,
	0x1e00,
	0x1e01,
	0x1e02,
	0x1e03,
	0x1e04,
	0x1e05,
	0x1e06,
	0x1e07,
	0x1e08,
	0x1e09,
	0x1e0a,
	0x1e0b,
	0x1e0c,
	0x1e0d,
	0x1e0e,
	0x1e0f,
	0x1e10,
	0x1e11,
	0x1e12,
	0x1e13,
	0x1e14,
	0x1e15,
	0x1e16,
	0x1e17,
	0x1e18,
	0x1e19,
	0x1e1a,
	0x1e1b,
	0x1e1c,
	0x1e1d,
	0x1e1e,
	0x1e1f,
	0x1e20,
	0x1e21,
	0x1e22,
	0x1e23,
	0x1e24,
	0x1e25,
	0x1e26,
	0x1e27,
	0x1e28,
	0x1e29,
	0x1e2a,
	0x1e2b,
	0x1e2c,
	0x1e2d,
	0x1e2e,
	0x1e2f,
	0x1e30,
	0x1e31,
	0x1e32,
	0x1e33,
	0x1e34,
	0x1e35,
	0x1e36,
	0x1e37,
	0x1e38,
	0x1e39,
	0x1e3a,
	0x1e3b,
	0x1e3c,
	0x1e3d,
	0x1e3e,
	0x1e3f,
	0x1e40,
	0x1e41,
	0x1e42,
	0x1e43,
	0x1e44,
	0x1e45,
	0x1e46,
	0x1e47,
	0x1e48,
	0x1e49,
	0x1e4a,
	0x1e4b,
	0x1e4c,
	0x1e4d,
	0x1e4e,
	0x1e4f,
	0x1e50,
	0x1e51,
	0x1e52,
	0x1e53,
	0x1e54,
	0x1e55,
	0x1e56,
	0x1e57,
	0x1e58,
	0x1e59,
	0x1e5a,
	0x1e5b,
	0x1e5c,
	0x1e5d,
	0x1e5e,
	0x1e5f,
	0x1e60,
	0x1e61,
	0x1e62,
	0x1e63,
	0x1e64,
	0x1e65,
	0x1e66,
	0x1e67,
	0x1e68,
	0x1e69,
	0x1e6a,
	0x1e6b,
	0x1e6c,
	0x1e6d,
	0x1e6e,
	0x1e6f,
	0x1e70,
	0x1e71,
	0x1e72,
	0x1e73,
	0x1e74,
	0x1e75,
	0x1e76,
	0x1e77,
	0x1e78,
	0x1e79,
	0x1e7a,
	0x1e7b,
	0x1e7c,
	0x1e7d,
	0x1e7e,
	0x1e7f,
	0x1e80,
	0x1e81,
	0x1e82,
	0x1e83,
	0x1e84,
	0x1e85,
	0x1e86,
	0x1e87,
	0x1e88,
	0x1e89,
	0x1e8a,
	0x1e8b,
	0x1e8c,
	0x1e8d,
	0x1e8e,
	0x1e8f,
	0x1e90,
	0x1e91,
	0x1e92,
	0x1e93,
	0x1e94,
	0x1e95,
	0x1e96,
	0x1e97,
	0x1e98,
	0x1e99,
	0x1e9a,
	0x1e9b,
	0x1e9d,
	0x1ea0,
	0x1ea1,
	0x1ea2,
	0x1ea3,
	0x1ea4,
	0x1ea5,
	0x1ea6,
	0x1ea7,
	0x1ea8,
	0x1ea9,
	0x1eaa,
	0x1eab,
	0x1eac,
	0x1ead,
	0x1eae,
	0x1eaf,
	0x1eb0,
	0x1eb1,
	0x1eb2,
	0x1eb3,
	0x1eb4,
	0x1eb5,
	0x1eb6,
	0x1eb7,
	0x1eb8,
	0x1eb9,
	0x1eba,
	0x1ebb,
	0x1ebc,
	0x1ebd,
	0x1ebe,
	0x1ebf,
	0x1ec0,
	0x1ec1,
	0x1ec2,
	0x1ec3,
	0x1ec4,
	0x1ec5,
	0x1ec6,
	0x1ec7,
	0x1ec8,
	0x1ec9,
	0x1eca,
	0x1ecb,
	0x1ecc,
	0x1ecd,
	0x1ece,
	0x1ecf,
	0x1ed0,
	0x1ed1,
	0x1ed2,
	0x1ed3,
	0x1ed4,
	0x1ed5,
	0x1ed6,
	0x1ed7,
	0x1ed8,
	0x1ed9,
	0x1eda,
	0x1edb,
	0x1edc,
	0x1edd,
	0x1ede,
	0x1edf,
	0x1ee0,
	0x1ee1,
	0x1ee2,
	0x1ee3,
	0x1ee4,
	0x1ee5,
	0x1ee6,
	0x1ee7,
	0x1ee8,
	0x1ee9,
	0x1eea,
	0x1eeb,
	0x1eec,
	0x1eed,
	0x1eee,
	0x1eef,
	0x1ef0,
	0x1ef1,
	0x1ef2,
	0x1ef3,
	0x1ef4,
	0x1ef5,
	0x1ef6,
	0x1ef7,
	0x1ef8,
	0x1ef9,
	0x1eff,
	0x1f00,
	0x1f01,
	0x1f02,
	0x1f03,
	0x1f04,
	0x1f05,
	0x1f06,
	0x1f07,
	0x1f08,
	0x1f09,
	0x1f0a,
	0x1f0b,
	0x1f0c,
	0x1f0d,
	0x1f0e,
	0x1f0f,
	0x1f10,
	0x1f11,
	0x1f12,
	0x1f13,
	0x1f14,
	0x1f15,
	0x1f18,
	0x1f19,
	0x1f1a,
	0x1f1b,
	0x1f1c,
	0x1f1d,
	0x1f20,
	0x1f21,
	0x1f22,
	0x1f23,
	0x1f24,
	0x1f25,
	0x1f26,
	0x1f27,
	0x1f28,
	0x1f29,
	0x1f2a,
	0x1f2b,
	0x1f2c,
	0x1f2d,
	0x1f2e,
	0x1f2f,
	0x1f30,
	0x1f31,
	0x1f32,
	0x1f33,
	0x1f34,
	0x1f35,
	0x1f36,
	0x1f37,
	0x1f38,
	0x1f39,
	0x1f3a,
	0x1f3b,
	0x1f3c,
	0x1f3d,
	0x1f3e,
	0x1f3f,
	0x1f40,
	0x1f41,
	0x1f42,
	0x1f43,
	0x1f44,
	0x1f45,
	0x1f48,
	0x1f49,
	0x1f4a,
	0x1f4b,
	0x1f4c,
	0x1f4d,
	0x1f50,
	0x1f51,
	0x1f52,
	0x1f53,
	0x1f54,
	0x1f55,
	0x1f56,
	0x1f57,
	0x1f59,
	0x1f5b,
	0x1f5d,
	0x1f5f,
	0x1f60,
	0x1f61,
	0x1f62,
	0x1f63,
	0x1f64,
	0x1f65,
	0x1f66,
	0x1f67,
	0x1f68,
	0x1f69,
	0x1f6a,
	0x1f6b,
	0x1f6c,
	0x1f6d,
	0x1f6e,
	0x1f6f,
	0x1f70,
	0x1f71,
	0x1f72,
	0x1f73,
	0x1f74,
	0x1f75,
	0x1f76,
	0x1f77,
	0x1f78,
	0x1f79,
	0x1f7a,
	0x1f7b,
	0x1f7c,
	0x1f7d,
	0x1f80,
	0x1f81,
	0x1f82,
	0x1f83,
	0x1f84,
	0x1f85,
	0x1f86,
	0x1f87,
	0x1f88,
	0x1f89,
	0x1f8a,
	0x1f8b,
	0x1f8c,
	0x1f8d,
	0x1f8e,
	0x1f8f,
	0x1f90,
	0x1f91,
	0x1f92,
	0x1f93,
	0x1f94,
	0x1f95,
	0x1f96,
	0x1f97,
	0x1f98,
	0x1f99,
	0x1f9a,
	0x1f9b,
	0x1f9c,
	0x1f9d,
	0x1f9e,
	0x1f9f,
	0x1fa0,
	0x1fa1,
	0x1fa2,
	0x1fa3,
	0x1fa4,
	0x1fa5,
	0x1fa6,
	0x1fa7,
	0x1fa8,
	0x1fa9,
	0x1faa,
	0x1fab,
	0x1fac,
	0x1fad,
	0x1fae,
	0x1faf,
	0x1fb0,
	0x1fb1,
	0x1fb2,
	0x1fb3,
	0x1fb4,
	0x1fb6,
	0x1fb7,
	0x1fb8,
	0x1fb9,
	0x1fba,
	0x1fbb,
	0x1fbc,
	0x1fbd,
	0x1fbe,
	0x1fbf,
	0x1fc0,
	0x1fc1,
	0x1fc2,
	0x1fc3,
	0x1fc4,
	0x1fc6,
	0x1fc7,
	0x1fc8,
	0x1fc9,
	0x1fca,
	0x1fcb,
	0x1fcc,
	0x1fcd,
	0x1fce,
	0x1fcf,
	0x1fd0,
	0x1fd1,
	0x1fd2,
	0x1fd3,
	0x1fd6,
	0x1fd7,
	0x1fd8,
	0x1fd9,
	0x1fda,
	0x1fdb,
	0x1fdd,
	0x1fde,
	0x1fdf,
	0x1fe0,
	0x1fe1,
	0x1fe2,
	0x1fe3,
	0x1fe4,
	0x1fe5,
	0x1fe6,
	0x1fe7,
	0x1fe8,
	0x1fe9,
	0x1fea,
	0x1feb,
	0x1fec,
	0x1fed,
	0x1fee,
	0x1fef,
	0x1ff2,
	0x1ff3,
	0x1ff4,
	0x1ff6,
	0x1ff7,
	0x1ff8,
	0x1ff9,
	0x1ffa,
	0x1ffb,
	0x1ffc,
	0x1ffd,
	0x1ffe,
	0x2000,
	0x2001,
	0x2002,
	0x2003,
	0x2004,
	0x2005,
	0x2006,
	0x2007,
	0x2008,
	0x2009,
	0x200a,
	0x200b,
	0x200c,
	0x200d,
	0x200e,
	0x200f,
	0x2010,
	0x2011,
	0x2012,
	0x2013,
	0x2014,
	0x2015,
	0x2016,
	0x2018,
	0x2019,
	0x201a,
	0x201b,
	0x201c,
	0x201d,
	0x201f,
	0x2022,
	0x2024,
	0x2025,
	0x2026,
	0x2027,
	0x2028,
	0x2029,
	0x202a,
	0x202b,
	0x202c,
	0x202d,
	0x202e,
	0x202f,
	0x2030,
	0x2031,
	0x2032,
	0x2033,
	0x2034,
	0x2035,
	0x2036,
	0x2037,
	0x2039,
	0x203a,
	0x203c,
	0x203e,
	0x2041,
	0x2043,
	0x2044,
	0x2047,
	0x2048,
	0x2049,
	0x204e,
	0x2052,
	0x2053,
	0x2057,
	0x205a,
	0x205d,
	0x205e,
	0x205f,
	0x2060,
	0x2061,
	0x2062,
	0x2063,
	0x2064,
	0x2066,
	0x2067,
	0x2068,
	0x2069,
	0x206a,
	0x206b,
	0x206c,
	0x206d,
	0x206e,
	0x206f,
	0x2070,
	0x2079,
	0x20a1,
	0x20a4,
	0x20a5,
	0x20a8,
	0x20a9,
	0x20ab,
	0x20ac,
	0x20ad,
	0x20ae,
	0x20b6,
	0x20bd,
	0x20d0,
	0x20d1,
	0x20d2,
	0x20d3,
	0x20d4,
	0x20d5,
	0x20d6,
	0x20d7,
	0x20d8,
	0x20d9,
	0x20da,
	0x20db,
	0x20dc,
	0x20dd,
	0x20de,
	0x20df,
	0x20e0,
	0x20e1,
	0x20e2,
	0x20e3,
	0x20e4,
	0x20e5,
	0x20e6,
	0x20e7,
	0x20e8,
	0x20e9,
	0x20ea,
	0x20eb,
	0x20ec,
	0x20ed,
	0x20ee,
	0x20ef,
	0x20f0,
	0x2100,
	0x2101,
	0x2102,
	0x2103,
	0x2105,
	0x2106,
	0x2107,
	0x2108,
	0x2109,
	0x210a,
	0x210b,
	0x210c,
	0x210d,
	0x210e,
	0x210f,
	0x2110,
	0x2111,
	0x2112,
	0x2113,
	0x2115,
	0x2116,
	0x2119,
	0x211a,
	0x211b,
	0x211c,
	0x211d,
	0x2121,
	0x2124,
	0x2126,
	0x2127,
	0x2128,
	0x2129,
	0x212a,
	0x212b,
	0x212c,
	0x212d,
	0x212e,
	0x212f,
	0x2130,
	0x2131,
	0x2133,
	0x2134,
	0x2135,
	0x2136,
	0x2137,
	0x2138,
	0x2139,
	0x213b,
	0x213c,
	0x213d,
	0x213e,
	0x213f,
	0x2140,
	0x2141,
	0x2142,
	0x2143,
	0x2145,
	0x2146,
	0x2147,
	0x2148,
	0x2149,
	0x2160,
	0x2161,
	0x2162,
	0x2163,
	0x2164,
	0x2165,
	0x2166,
	0x2167,
	0x2168,
	0x2169,
	0x216a,
	0x216b,
	0x216c,
	0x216d,
	0x216e,
	0x216f,
	0x2170,
	0x2171,
	0x2172,
	0x2173,
	0x2174,
	0x2175,
	0x2176,
	0x2177,
	0x2178,
	0x2179,
	0x217a,
	0x217b,
	0x217c,
	0x217d,
	0x217e,
	0x217f,
	0x2183,
	0x2184,
	0x2191,
	0x2195,
	0x219a,
	0x219b,
	0x21ae,
	0x21b5,
	0x21be,
	0x21bf,
	0x21cd,
	0x21ce,
	0x21cf,
	0x2200,
	0x2203,
	0x2204,
	0x2206,
	0x2209,
	0x220c,
	0x220f,
	0x2211,
	0x2212,
	0x2214,
	0x2215,
	0x2216,
	0x2217,
	0x2218,
	0x2219,
	0x221e,
	0x2223,
	0x2224,
	0x2225,
	0x2226,
	0x2228,
	0x2229,
	0x222a,
	0x222b,
	0x222c,
	0x222d,
	0x222f,
	0x2230,
	0x2236,
	0x2238,
	0x223c,
	0x2241,
	0x2244,
	0x2247,
	0x2249,
	0x2250,
	0x2251,
	0x2257,
	0x2259,
	0x225a,
	0x225e,
	0x2260,
	0x2262,
	0x2263,
	0x226a,
	0x226b,
	0x226d,
	0x226e,
	0x226f,
	0x2270,
	0x2271,
	0x2274,
	0x2275,
	0x2278,
	0x2279,
	0x2280,
	0x2281,
	0x2282,
	0x2283,
	0x2284,
	0x2285,
	0x2288,
	0x2289,
	0x2295,
	0x2296,
	0x2299,
	0x229d,
	0x22a4,
	0x22a5,
	0x22ac,
	0x22ad,
	0x22ae,
	0x22af,
	0x22c0,
	0x22c1,
	0x22c2,
	0x22c3,
	0x22c4,
	0x22c5,
	0x22c8,
	0x22d6,
	0x22d7,
	0x22d8,
	0x22d9,
	0x22e0,
	0x22e1,
	0x22e2,
	0x22e3,
	0x22ea,
	0x22eb,
	0x22ec,
	0x22ed,
	0x22ee,
	0x22ef,
	0x22f4,
	0x22ff,
	0x2300,
	0x2325,
	0x2329,
	0x232a,
	0x2341,
	0x2359,
	0x235a,
	0x235c,
	0x235f,
	0x2361,
	0x2362,
	0x2363,
	0x2364,
	0x2368,
	0x2369,
	0x236b,
	0x236c,
	0x2373,
	0x2374,
	0x2375,
	0x2376,
	0x2377,
	0x2378,
	0x2379,
	0x237a,
	0x237f,
	0x239c,
	0x239f,
	0x23a2,
	0x23a5,
	0x23aa,
	0x23ae,
	0x23c1,
	0x23c2,
	0x23c3,
	0x23c6,
	0x23e8,
	0x23fc,
	0x23fd,
	0x23fe,
	0x244a,
	0x2460,
	0x2461,
	0x2462,
	0x2463,
	0x2464,
	0x2465,
	0x2466,
	0x2467,
	0x2468,
	0x2469,
	0x2474,
	0x2475,
	0x2476,
	0x2477,
	0x2478,
	0x2479,
	0x247a,
	0x247b,
	0x247c,
	0x247d,
	0x247e,
	0x247f,
	0x2480,
	0x2481,
	0x2482,
	0x2483,
	0x2484,
	0x2485,
	0x2486,
	0x2487,
	0x2488,
	0x2489,
	0x248a,
	0x248b,
	0x248c,
	0x248d,
	0x248e,
	0x248f,
	0x2490,
	0x2491,
	0x2492,
	0x2493,
	0x2494,
	0x2495,
	0x2496,
	0x2497,
	0x2498,
	0x2499,
	0x249a,
	0x249b,
	0x249c,
	0x249d,
	0x249e,
	0x249f,
	0x24a0,
	0x24a1,
	0x24a2,
	0x24a3,
	0x24a4,
	0x24a5,
	0x24a6,
	0x24a7,
	0x24a8,
	0x24a9,
	0x24aa,
	0x24ab,
	0x24ac,
	0x24ad,
	0x24ae,
	0x24af,
	0x24b0,
	0x24b1,
	0x24b2,
	0x24b3,
	0x24b4,
	0x24b5,
	0x24b8,
	0x24c5,
	0x24c7,
	0x24db,
	0x2500,
	0x2501,
	0x2503,
	0x250f,
	0x2523,
	0x2571,
	0x2573,
	0x2588,
	0x2590,
	0x2594,
	0x2597,
	0x259d,
	0x25a0,
	0x25b1,
	0x25b3,
	0x25b7,
	0x25b8,
	0x25ba,
	0x25bd,
	0x25c1,
	0x25c7,
	0x25ca,
	0x25cb,
	0x25ce,
	0x25e0,
	0x25e6,
	0x2609,
	0x2610,
	0x2625,
	0x2630,
	0x2638,
	0x264e,
	0x2662,
	0x2669,
	0x266a,
	0x26ac,
	0x2768,
	0x2769,
	0x276e,
	0x276f,
	0x2772,
	0x2773,
	0x2774,
	0x2775,
	0x2795,
	0x2796,
	0x2797,
	0x27c2,
	0x27c8,
	0x27c9,
	0x27cb,
	0x27cd,
	0x27d9,
	0x27e8,
	0x27e9,
	0x2800,
	0x292b,
	0x292c,
	0x2963,
	0x2965,
	0x296e,
	0x296f,
	0x2999,
	0x29b0,
	0x29be,
	0x29c4,
	0x29c5,
	0x29c7,
	0x29d6,
	0x29d9,
	0x29f4,
	0x29f5,
	0x29f6,
	0x29f8,
	0x29f9,
	0x2a00,
	0x2a01,
	0x2a02,
	0x2a03,
	0x2a04,
	0x2a05,
	0x2a06,
	0x2a0c,
	0x2a1d,
	0x2a20,
	0x2a21,
	0x2a22,
	0x2a23,
	0x2a24,
	0x2a25,
	0x2a26,
	0x2a27,
	0x2a29,
	0x2a2a,
	0x2a2f,
	0x2a30,
	0x2a3d,
	0x2a3e,
	0x2a3f,
	0x2a6a,
	0x2a6e,
	0x2a74,
	0x2a75,
	0x2a76,
	0x2aa5,
	0x2aaa,
	0x2aab,
	0x2ad7,
	0x2adc,
	0x2afb,
	0x2afd,
	0x2bec,
	0x2bed,
	0x2bee,
	0x2bef,
	0x2c67,
	0x2c69,
	0x2c84,
	0x2c85,
	0x2c86,
	0x2c88,
	0x2c89,
	0x2c8e,
	0x2c92,
	0x2c94,
	0x2c95,
	0x2c96,
	0x2c98,
	0x2c9a,
	0x2c9e,
	0x2c9f,
	0x2ca0,
	0x2ca2,
	0x2ca3,
	0x2ca4,
	0x2ca5,
	0x2ca6,
	0x2ca8,
	0x2caa,
	0x2cab,
	0x2cac,
	0x2cad,
	0x2cae,
	0x2cb1,
	0x2cb4,
	0x2cba,
	0x2cbc,
	0x2cbd,
	0x2cc6,
	0x2cca,
	0x2ccc,
	0x2ccd,
	0x2cd0,
	0x2cd1,
	0x2cd2,
	0x2cdc,
	0x2ce4,
	0x2ce9,
	0x2cef,
	0x2cf0,
	0x2cf1,
	0x2cf9,
	0x2d31,
	0x2d37,
	0x2d38,
	0x2d39,
	0x2d3a,
	0x2d41,
	0x2d48,
	0x2d49,
	0x2d4f,
	0x2d51,
	0x2d54,
	0x2d55,
	0x2d59,
	0x2d5d,
	0x2d60,
	0x2d63,
	0x2d7f,
	0x2de0,
	0x2de1,
	0x2de2,
	0x2de3,
	0x2de4,
	0x2de5,
	0x2de6,
	0x2de7,
	0x2de8,
	0x2de9,
	0x2dea,
	0x2deb,
	0x2dec,
	0x2ded,
	0x2dee,
	0x2def,
	0x2df0,
	0x2df1,
	0x2df2,
	0x2df3,
	0x2df4,
	0x2df5,
	0x2df6,
	0x2df7,
	0x2df8,
	0x2df9,
	0x2dfa,
	0x2dfb,
	0x2dfc,
	0x2dfd,
	0x2dfe,
	0x2dff,
	0x2e1a,
	0x2e1e,
	0x2e1f,
	0x2e26,
	0x2e27,
	0x2e28,
	0x2e29,
	0x2e2a,
	0x2e2b,
	0x2e2c,
	0x2e2e,
	0x2e30,
	0x2e31,
	0x2e32,
	0x2e35,
	0x2e39,
	0x2e3d,
	0x2e3f,
	0x2e40,
	0x2e82,
	0x2e83,
	0x2e85,
	0x2e89,
	0x2e8b,
	0x2e8e,
	0x2e8f,
	0x2e90,
	0x2e92,
	0x2e93,
	0x2e94,
	0x2e96,
	0x2e97,
	0x2e98,
	0x2e99,
	0x2e9b,
	0x2e9e,
	0x2e9f,
	0x2ea0,
	0x2ea1,
	0x2ea2,
	0x2ea3,
	0x2ea4,
	0x2ea6,
	0x2ea8,
	0x2eab,
	0x2ead,
	0x2eaf,
	0x2eb1,
	0x2eb2,
	0x2eb9,
	0x2eba,
	0x2ebe,
	0x2ebf,
	0x2ec0,
	0x2ec1,
	0x2ec2,
	0x2ec3,
	0x2ec4,
	0x2ec5,
	0x2ec8,
	0x2ec9,
	0x2ecb,
	0x2ecc,
	0x2ecd,
	0x2ecf,
	0x2ed0,
	0x2ed1,
	0x2ed2,
	0x2ed3,
	0x2ed4,
	0x2ed6,
	0x2ed8,
	0x2ed9,
	0x2eda,
	0x2edb,
	0x2edc,
	0x2edd,
	0x2edf,
	0x2ee0,
	0x2ee2,
	0x2ee4,
	0x2ee5,
	0x2ee8,
	0x2ee9,
	0x2eeb,
	0x2eec,
	0x2eed,
	0x2eee,
	0x2eef,
	0x2ef0,
	0x2ef2,
	0x2ef3,
	0x2f00,
	0x2f01,
	0x2f02,
	0x2f03,
	0x2f04,
	0x2f05,
	0x2f06,
	0x2f07,
	0x2f08,
	0x2f09,
	0x2f0a,
	0x2f0b,
	0x2f0c,
	0x2f0d,
	0x2f0e,
	0x2f0f,
	0x2f10,
	0x2f11,
	0x2f12,
	0x2f13,
	0x2f14,
	0x2f15,
	0x2f16,
	0x2f17,
	0x2f18,
	0x2f19,
	0x2f1a,
	0x2f1b,
	0x2f1c,
	0x2f1d,
	0x2f1e,
	0x2f1f,
	0x2f20,
	0x2f21,
	0x2f22,
	0x2f23,
	0x2f24,
	0x2f25,
	0x2f26,
	0x2f27,
	0x2f28,
	0x2f29,
	0x2f2a,
	0x2f2b,
	0x2f2c,
	0x2f2d,
	0x2f2e,
	0x2f2f,
	0x2f30,
	0x2f31,
	0x2f32,
	0x2f33,
	0x2f34,
	0x2f35,
	0x2f36,
	0x2f37,
	0x2f38,
	0x2f39,
	0x2f3a,
	0x2f3b,
	0x2f3c,
	0x2f3d,
	0x2f3e,
	0x2f3f,
	0x2f40,
	0x2f41,
	0x2f42,
	0x2f43,
	0x2f44,
	0x2f45,
	0x2f46,
	0x2f47,
	0x2f48,
	0x2f49,
	0x2f4a,
	0x2f4b,
	0x2f4c,
	0x2f4d,
	0x2f4e,
	0x2f4f,
	0x2f50,
	0x2f51,
	0x2f52,
	0x2f53,
	0x2f54,
	0x2f55,
	0x2f56,
	0x2f57,
	0x2f58,
	0x2f59,
	0x2f5a,
	0x2f5b,
	0x2f5c,
	0x2f5d,
	0x2f5e,
	0x2f5f,
	0x2f60,
	0x2f61,
	0x2f62,
	0x2f63,
	0x2f64,
	0x2f65,
	0x2f66,
	0x2f67,
	0x2f68,
	0x2f69,
	0x2f6a,
	0x2f6b,
	0x2f6c,
	0x2f6d,
	0x2f6e,
	0x2f6f,
	0x2f70,
	0x2f71,
	0x2f72,
	0x2f73,
	0x2f74,
	0x2f75,
	0x2f76,
	0x2f77,
	0x2f78,
	0x2f79,
	0x2f7a,
	0x2f7b,
	0x2f7c,
	0x2f7d,
	0x2f7e,
	0x2f7f,
	0x2f80,
	0x2f81,
	0x2f82,
	0x2f83,
	0x2f84,
	0x2f85,
	0x2f86,
	0x2f87,
	0x2f88,
	0x2f89,
	0x2f8a,
	0x2f8b,
	0x2f8c,
	0x2f8d,
	0x2f8e,
	0x2f8f,
	0x2f90,
	0x2f91,
	0x2f92,
	0x2f93,
	0x2f94,
	0x2f95,
	0x2f96,
	0x2f97,
	0x2f98,
	0x2f99,
	0x2f9a,
	0x2f9b,
	0x2f9c,
	0x2f9d,
	0x2f9e,
	0x2f9f,
	0x2fa0,
	0x2fa1,
	0x2fa2,
	0x2fa3,
	0x2fa4,
	0x2fa5,
	0x2fa6,
	0x2fa7,
	0x2fa8,
	0x2fa9,
	0x2faa,
	0x2fab,
	0x2fac,
	0x2fad,
	0x2fae,
	0x2faf,
	0x2fb0,
	0x2fb1,
	0x2fb2,
	0x2fb3,
	0x2fb4,
	0x2fb5,
	0x2fb6,
	0x2fb7,
	0x2fb8,
	0x2fb9,
	0x2fba,
	0x2fbb,
	0x2fbc,
	0x2fbd,
	0x2fbe,
	0x2fbf,
	0x2fc0,
	0x2fc1,
	0x2fc2,
	0x2fc3,
	0x2fc4,
	0x2fc5,
	0x2fc6,
	0x2fc7,
	0x2fc8,
	0x2fc9,
	0x2fca,
	0x2fcb,
	0x2fcc,
	0x2fcd,
	0x2fce,
	0x2fcf,
	0x2fd0,
	0x2fd1,
	0x2fd2,
	0x2fd3,
	0x2fd4,
	0x2fd5,
	0x3000,
	0x3002,
	0x3003,
	0x3007,
	0x3008,
	0x3009,
	0x3012,
	0x3014,
	0x3015,
	0x301a,
	0x301b,
	0x302a,
	0x302b,
	0x302c,
	0x302d,
	0x302e,
	0x302f,
	0x3033,
	0x3036,
	0x3038,
	0x3039,
	0x303a,
	0x304c,
	0x304e,
	0x304f,
	0x3050,
	0x3052,
	0x3054,
	0x3056,
	0x3058,
	0x305a,
	0x305c,
	0x305e,
	0x3060,
	0x3062,
	0x3065,
	0x3067,
	0x3069,
	0x3070,
	0x3071,
	0x3073,
	0x3074,
	0x3076,
	0x3077,
	0x3079,
	0x307a,
	0x307c,
	0x307d,
	0x3094,
	0x3099,
	0x309a,
	0x309b,
	0x309c,
	0x309e,
	0x30a0,
	0x30a4,
	0x30a8,
	0x30ab,
	0x30ac,
	0x30ae,
	0x30b0,
	0x30b2,
	0x30b4,
	0x30b6,
	0x30b8,
	0x30ba,
	0x30bc,
	0x30be,
	0x30bf,
	0x30c0,
	0x30c2,
	0x30c5,
	0x30c7,
	0x30c8,
	0x30c9,
	0x30cb,
	0x30ce,
	0x30cf,
	0x30d0,
	0x30d1,
	0x30d3,
	0x30d4,
	0x30d6,
	0x30d7,
	0x30d8,
	0x30d9,
	0x30da,
	0x30dc,
	0x30dd,
	0x30ed,
	0x30f4,
	0x30f7,
	0x30f8,
	0x30f9,
	0x30fa,
	0x30fb,
	0x30fe,
	0x3131,
	0x3132,
	0x3133,
	0x3134,
	0x3135,
	0x3136,
	0x3137,
	0x3138,
	0x3139,
	0x313a,
	0x313b,
	0x313c,
	0x313d,
	0x313e,
	0x313f,
	0x3140,
	0x3141,
	0x3142,
	0x3143,
	0x3144,
	0x3145,
	0x3146,
	0x3147,
	0x3148,
	0x3149,
	0x314a,
	0x314b,
	0x314c,
	0x314d,
	0x314e,
	0x314f,
	0x3150,
	0x3151,
	0x3152,
	0x3153,
	0x3154,
	0x3155,
	0x3156,
	0x3157,
	0x3158,
	0x3159,
	0x315a,
	0x315b,
	0x315c,
	0x315d,
	0x315e,
	0x315f,
	0x3160,
	0x3161,
	0x3162,
	0x3163,
	0x3164,
	0x3165,
	0x3166,
	0x3167,
	0x3168,
	0x3169,
	0x316a,
	0x316b,
	0x316c,
	0x316d,
	0x316e,
	0x316f,
	0x3170,
	0x3171,
	0x3172,
	0x3173,
	0x3174,
	0x3175,
	0x3176,
	0x3177,
	0x3178,
	0x3179,
	0x317a,
	0x317b,
	0x317c,
	0x317d,
	0x317e,
	0x317f,
	0x3180,
	0x3181,
	0x3182,
	0x3183,
	0x3184,
	0x3185,
	0x3186,
	0x3187,
	0x3188,
	0x3189,
	0x318a,
	0x318b,
	0x318c,
	0x318d,
	0x318e,
	0x31d0,
	0x31d1,
	0x31d3,
	0x31d4,
	0x31d6,
	0x31da,
	0x31db,
	0x31df,
	0x31e0,
	0x3200,
	0x3201,
	0x3202,
	0x3203,
	0x3204,
	0x3205,
	0x3206,
	0x3207,
	0x3208,
	0x3209,
	0x320a,
	0x320b,
	0x320c,
	0x320d,
	0x320e,
	0x320f,
	0x3210,
	0x3211,
	0x3212,
	0x3213,
	0x3214,
	0x3215,
	0x3216,
	0x3217,
	0x3218,
	0x3219,
	0x321a,
	0x321b,
	0x321c,
	0x321d,
	0x321e,
	0x3220,
	0x3221,
	0x3222,
	0x3223,
	0x3224,
	0x3225,
	0x3226,
	0x3227,
	0x3228,
	0x3229,
	0x322a,
	0x322b,
	0x322c,
	0x322d,
	0x322e,
	0x322f,
	0x3230,
	0x3231,
	0x3232,
	0x3233,
	0x3234,
	0x3235,
	0x3236,
	0x3237,
	0x3238,
	0x3239,
	0x323a,
	0x323b,
	0x323c,
	0x323d,
	0x323e,
	0x323f,
	0x3240,
	0x3241,
	0x3242,
	0x3243,
	0x32c0,
	0x32c1,
	0x32c2,
	0x32c3,
	0x32c4,
	0x32c5,
	0x32c6,
	0x32c7,
	0x32c8,
	0x32c9,
	0x32ca,
	0x32cb,
	0x3358,
	0x3359,
	0x335a,
	0x335b,
	0x335c,
	0x335d,
	0x335e,
	0x335f,
	0x3360,
	0x3361,
	0x3362,
	0x3363,
	0x3364,
	0x3365,
	0x3366,
	0x3367,
	0x3368,
	0x3369,
	0x336a,
	0x336b,
	0x336c,
	0x336d,
	0x336e,
	0x336f,
	0x3370,
	0x33e0,
	0x33e1,
	0x33e2,
	0x33e3,
	0x33e4,
	0x33e5,
	0x33e6,
	0x33e7,
	0x33e8,
	0x33e9,
	0x33ea,
	0x33eb,
	0x33ec,
	0x33ed,
	0x33ee,
	0x33ef,
	0x33f0,
	0x33f1,
	0x33f2,
	0x33f3,
	0x33f4,
	0x33f5,
	0x33f6,
	0x33f7,
	0x33f8,
	0x33f9,
	0x33fa,
	0x33fb,
	0x33fc,
	0x33fd,
	0x33fe,
	0x39b3,
	0x439b,
	0x4420,
	0x4e00,
	0x4e36,
	0x4e3f,
	0x5002,
	0x503c,
	0x555f,
	0x56d7,
	0x586b,
	0x58eb,
	0x58ff,
	0x5b00,
	0x5e32,
	0x5e50,
	0x6238,
	0x6409,
	0x6663,
	0x6669,
	0x66f6,
	0x6726,
	0x67ff,
	0x69e9,
	0x6a27,
	0x6f59,
	0x784f,
	0x7d76,
	0x80a6,
	0x80ca,
	0x80d0,
	0x80f6,
	0x8101,
	0x8127,
	0x8141,
	0x81a7,
	0x853f,
	0x8641,
	0x8a1e,
	0x8a7d,
	0x8b8f,
	0x8c63,
	0x8d86,
	0x8dfa,
	0x8e9b,
	0x8f27,
	0x90de,
	0x93ae,
	0x96b8,
	0x9e43,
	0x9ed2,
	0x9fc3,
	0xa494,
	0xa49c,
	0xa49e,
	0xa4a7,
	0xa4a8,
	0xa4ac,
	0xa4b0,
	0xa4ba,
	0xa4be,
	0xa4bf,
	0xa4c0,
	0xa4c2,
	0xa4d0,
	0xa4d1,
	0xa4d2,
	0xa4d3,
	0xa4d4,
	0xa4d6,
	0xa4d7,
	0xa4d9,
	0xa4da,
	0xa4db,
	0xa4dc,
	0xa4dd,
	0xa4de,
	0xa4df,
	0xa4e0,
	0xa4e1,
	0xa4e2,
	0xa4e3,
	0xa4e5,
	0xa4e6,
	0xa4e7,
	0xa4ea,
	0xa4eb,
	0xa4ec,
	0xa4ed,
	0xa4ee,
	0xa4ef,
	0xa4f0,
	0xa4f1,
	0xa4f2,
	0xa4f3,
	0xa4f4,
	0xa4f5,
	0xa4f7,
	0xa4f8,
	0xa4f9,
	0xa4fa,
	0xa4fb,
	0xa4fd,
	0xa4fe,
	0xa4ff,
	0xa60e,
	0xa644,
	0xa645,
	0xa647,
	0xa64d,
	0xa650,
	0xa651,
	0xa668,
	0xa66f,
	0xa670,
	0xa671,
	0xa672,
	0xa674,
	0xa675,
	0xa676,
	0xa677,
	0xa678,
	0xa679,
	0xa67a,
	0xa67b,
	0xa67c,
	0xa67d,
	0xa67e,
	0xa695,
	0xa698,
	0xa699,
	0xa69a,
	0xa69e,
	0xa69f,
	0xa6a1,
	0xa6b0,
	0xa6b1,
	0xa6cd,
	0xa6ce,
	0xa6db,
	0xa6df,
	0xa6eb,
	0xa6ef,
	0xa6f0,
	0xa6f1,
	0xa6f4,
	0xa714,
	0xa716,
	0xa728,
	0xa729,
	0xa731,
	0xa732,
	0xa733,
	0xa734,
	0xa735,
	0xa736,
	0xa737,
	0xa738,
	0xa739,
	0xa73a,
	0xa73b,
	0xa73c,
	0xa73d,
	0xa740,
	0xa74a,
	0xa74b,
	0xa74e,
	0xa74f,
	0xa75a,
	0xa761,
	0xa76a,
	0xa76b,
	0xa76e,
	0xa777,
	0xa778,
	0xa77a,
	0xa789,
	0xa78c,
	0xa78f,
	0xa795,
	0xa798,
	0xa799,
	0xa79a,
	0xa79b,
	0xa79d,
	0xa79e,
	0xa79f,
	0xa7ab,
	0xa7b1,
	0xa7b2,
	0xa7b3,
	0xa7b4,
	0xa7b5,
	0xa7b6,
	0xa7b7,
	0xa7f7,
	0xa802,
	0xa806,
	0xa80b,
	0xa823,
	0xa824,
	0xa825,
	0xa826,
	0xa827,
	0xa830,
	0xa880,
	0xa881,
	0xa8b4,
	0xa8b5,
	0xa8b6,
	0xa8b7,
	0xa8b8,
	0xa8b9,
	0xa8ba,
	0xa8bb,
	0xa8bc,
	0xa8bd,
	0xa8be,
	0xa8bf,
	0xa8c0,
	0xa8c1,
	0xa8c2,
	0xa8c3,
	0xa8c4,
	0xa8c5,
	0xa8e0,
	0xa8e1,
	0xa8e2,
	0xa8e3,
	0xa8e4,
	0xa8e5,
	0xa8e6,
	0xa8e7,
	0xa8e8,
	0xa8e9,
	0xa8ea,
	0xa8eb,
	0xa8ec,
	0xa8ed,
	0xa8ee,
	0xa8ef,
	0xa8f0,
	0xa8f1,
	0xa8ff,
	0xa926,
	0xa927,
	0xa928,
	0xa929,
	0xa92a,
	0xa92b,
	0xa92c,
	0xa92d,
	0xa947,
	0xa948,
	0xa949,
	0xa94a,
	0xa94b,
	0xa94c,
	0xa94d,
	0xa94e,
	0xa94f,
	0xa950,
	0xa951,
	0xa952,
	0xa953,
	0xa960,
	0xa961,
	0xa962,
	0xa963,
	0xa964,
	0xa965,
	0xa966,
	0xa967,
	0xa968,
	0xa969,
	0xa96a,
	0xa96b,
	0xa96c,
	0xa96d,
	0xa96e,
	0xa96f,
	0xa970,
	0xa971,
	0xa972,
	0xa973,
	0xa974,
	0xa975,
	0xa976,
	0xa977,
	0xa978,
	0xa979,
	0xa97a,
	0xa97b,
	0xa97c,
	0xa980,
	0xa981,
	0xa982,
	0xa983,
	0xa992,
	0xa9a3,
	0xa9b3,
	0xa9b4,
	0xa9b5,
	0xa9b6,
	0xa9b7,
	0xa9b8,
	0xa9b9,
	0xa9ba,
	0xa9bb,
	0xa9bc,
	0xa9bd,
	0xa9be,
	0xa9bf,
	0xa9c0,
	0xa9c6,
	0xa9cf,
	0xa9e5,
	0xaa29,
	0xaa2a,
	0xaa2b,
	0xaa2c,
	0xaa2d,
	0xaa2e,
	0xaa2f,
	0xaa30,
	0xaa31,
	0xaa32,
	0xaa33,
	0xaa34,
	0xaa35,
	0xaa36,
	0xaa43,
	0xaa4c,
	0xaa4d,
	0xaa53,
	0xaa56,
	0xaa7b,
	0xaa7c,
	0xaa7d,
	0xaab0,
	0xaab2,
	0xaab3,
	0xaab4,
	0xaab7,
	0xaab8,
	0xaabe,
	0xaabf,
	0xaac1,
	0xaaeb,
	0xaaec,
	0xaaed,
	0xaaee,
	0xaaef,
	0xaaf5,
	0xaaf6,
	0xab32,
	0xab35,
	0xab3d,
	0xab3e,
	0xab3f,
	0xab41,
	0xab42,
	0xab47,
	0xab48,
	0xab4d,
	0xab4e,
	0xab52,
	0xab53,
	0xab55,
	0xab5a,
	0xab60,
	0xab62,
	0xab63,
	0xab70,
	0xab71,
	0xab72,
	0xab74,
	0xab75,
	0xab7a,
	0xab7b,
	0xab7c,
	0xab7e,
	0xab80,
	0xab81,
	0xab83,
	0xab87,
	0xab8b,
	0xab8e,
	0xab90,
	0xab93,
	0xab9b,
	0xab9c,
	0xab9f,
	0xaba2,
	0xaba9,
	0xabaa,
	0xabae,
	0xabaf,
	0xabb2,
	0xabb6,
	0xabbb,
	0xabe3,
	0xabe4,
	0xabe5,
	0xabe6,
	0xabe7,
	0xabe8,
	0xabe9,
	0xabea,
	0xabec,
	0xabed,
	0xd7b0,
	0xd7b1,
	0xd7b2,
	0xd7b3,
	0xd7b4,
	0xd7b5,
	0xd7b6,
	0xd7b7,
	0xd7b8,
	0xd7b9,
	0xd7ba,
	0xd7bb,
	0xd7bc,
	0xd7bd,
	0xd7be,
	0xd7bf,
	0xd7c0,
	0xd7c1,
	0xd7c2,
	0xd7c3,
	0xd7c4,
	0xd7c5,
	0xd7c6,
	0xd7cb,
	0xd7cc,
	0xd7cd,
	0xd7ce,
	0xd7cf,
	0xd7d0,
	0xd7d1,
	0xd7d2,
	0xd7d3,
	0xd7d4,
	0xd7d5,
	0xd7d6,
	0xd7d7,
	0xd7d8,
	0xd7d9,
	0xd7da,
	0xd7db,
	0xd7dc,
	0xd7dd,
	0xd7de,
	0xd7df,
	0xd7e0,
	0xd7e1,
	0xd7e2,
	0xd7e3,
	0xd7e4,
	0xd7e5,
	0xd7e6,
	0xd7e7,
	0xd7e8,
	0xd7e9,
	0xd7ea,
	0xd7eb,
	0xd7ec,
	0xd7ed,
	0xd7ee,
	0xd7ef,
	0xd7f0,
	0xd7f1,
	0xd7f2,
	0xd7f3,
	0xd7f4,
	0xd7f5,
	0xd7f6,
	0xd7f7,
	0xd7f8,
	0xd7f9,
	0xd7fa,
	0xd7fb,
	0xd800,
	0xdb7f,
	0xdb80,
	0xdbff,
	0xdc00,
	0xdfff,
	0xe000,
	0xf8ff,
	0xf900,
	0xf901,
	0xf902,
	0xf903,
	0xf904,
	0xf905,
	0xf906,
	0xf907,
	0xf908,
	0xf909,
	0xf90a,
	0xf90b,
	0xf90c,
	0xf90d,
	0xf90e,
	0xf90f,
	0xf910,
	0xf911,
	0xf912,
	0xf913,
	0xf914,
	0xf915,
	0xf916,
	0xf917,
	0xf918,
	0xf919,
	0xf91a,
	0xf91b,
	0xf91c,
	0xf91d,
	0xf91e,
	0xf91f,
	0xf920,
	0xf921,
	0xf922,
	0xf923,
	0xf924,
	0xf925,
	0xf926,
	0xf927,
	0xf928,
	0xf929,
	0xf92a,
	0xf92b,
	0xf92c,
	0xf92d,
	0xf92e,
	0xf92f,
	0xf930,
	0xf931,
	0xf932,
	0xf933,
	0xf934,
	0xf935,
	0xf936,
	0xf937,
	0xf938,
	0xf939,
	0xf93a,
	0xf93b,
	0xf93c,
	0xf93d,
	0xf93e,
	0xf93f,
	0xf940,
	0xf941,
	0xf942,
	0xf943,
	0xf944,
	0xf945,
	0xf946,
	0xf947,
	0xf948,
	0xf949,
	0xf94a,
	0xf94b,
	0xf94c,
	0xf94d,
	0xf94e,
	0xf94f,
	0xf950,
	0xf951,
	0xf952,
	0xf953,
	0xf954,
	0xf955,
	0xf956,
	0xf957,
	0xf958,
	0xf959,
	0xf95a,
	0xf95b,
	0xf95c,
	0xf95d,
	0xf95e,
	0xf95f,
	0xf960,
	0xf961,
	0xf962,
	0xf963,
	0xf964,
	0xf965,
	0xf966,
	0xf967,
	0xf968,
	0xf969,
	0xf96a,
	0xf96b,
	0xf96c,
	0xf96d,
	0xf96e,
	0xf96f,
	0xf970,
	0xf971,
	0xf972,
	0xf973,
	0xf974,
	0xf975,
	0xf976,
	0xf977,
	0xf978,
	0xf979,
	0xf97a,
	0xf97b,
	0xf97c,
	0xf97d,
	0xf97e,
	0xf97f,
	0xf980,
	0xf981,
	0xf982,
	0xf983,
	0xf984,
	0xf985,
	0xf986,
	0xf987,
	0xf988,
	0xf989,
	0xf98a,
	0xf98b,
	0xf98c,
	0xf98d,
	0xf98e,
	0xf98f,
	0xf990,
	0xf991,
	0xf992,
	0xf993,
	0xf994,
	0xf995,
	0xf996,
	0xf997,
	0xf998,
	0xf999,
	0xf99a,
	0xf99b,
	0xf99c,
	0xf99d,
	0xf99e,
	0xf99f,
	0xf9a0,
	0xf9a1,
	0xf9a2,
	0xf9a3,
	0xf9a4,
	0xf9a5,
	0xf9a6,
	0xf9a7,
	0xf9a8,
	0xf9a9,
	0xf9aa,
	0xf9ab,
	0xf9ac,
	0xf9ad,
	0xf9ae,
	0xf9af,
	0xf9b0,
	0xf9b1,
	0xf9b2,
	0xf9b3,
	0xf9b4,
	0xf9b5,
	0xf9b6,
	0xf9b7,
	0xf9b8,
	0xf9b9,
	0xf9ba,
	0xf9bb,
	0xf9bc,
	0xf9bd,
	0xf9be,
	0xf9bf,
	0xf9c0,
	0xf9c1,
	0xf9c2,
	0xf9c3,
	0xf9c4,
	0xf9c5,
	0xf9c6,
	0xf9c7,
	0xf9c8,
	0xf9c9,
	0xf9ca,
	0xf9cb,
	0xf9cc,
	0xf9cd,
	0xf9ce,
	0xf9cf,
	0xf9d0,
	0xf9d1,
	0xf9d2,
	0xf9d3,
	0xf9d4,
	0xf9d5,
	0xf9d6,
	0xf9d7,
	0xf9d8,
	0xf9d9,
	0xf9da,
	0xf9db,
	0xf9dc,
	0xf9dd,
	0xf9de,
	0xf9df,
	0xf9e0,
	0xf9e1,
	0xf9e2,
	0xf9e3,
	0xf9e4,
	0xf9e5,
	0xf9e6,
	0xf9e7,
	0xf9e8,
	0xf9e9,
	0xf9ea,
	0xf9eb,
	0xf9ec,
	0xf9ed,
	0xf9ee,
	0xf9ef,
	0xf9f0,
	0xf9f1,
	0xf9f2,
	0xf9f3,
	0xf9f4,
	0xf9f5,
	0xf9f6,
	0xf9f7,
	0xf9f8,
	0xf9f9,
	0xf9fa,
	0xf9fb,
	0xf9fc,
	0xf9fd,
	0xf9fe,
	0xf9ff,
	0xfa00,
	0xfa01,
	0xfa02,
	0xfa03,
	0xfa04,
	0xfa05,
	0xfa06,
	0xfa07,
	0xfa08,
	0xfa09,
	0xfa0a,
	0xfa0b,
	0xfa0c,
	0xfa0d,
	0xfa10,
	0xfa12,
	0xfa15,
	0xfa16,
	0xfa17,
	0xfa18,
	0xfa19,
	0xfa1a,
	0xfa1b,
	0xfa1c,
	0xfa1d,
	0xfa1e,
	0xfa20,
	0xfa22,
	0xfa25,
	0xfa26,
	0xfa2a,
	0xfa2b,
	0xfa2c,
	0xfa2d,
	0xfa2e,
	0xfa2f,
	0xfa30,
	0xfa31,
	0xfa32,
	0xfa33,
	0xfa34,
	0xfa35,
	0xfa36,
	0xfa37,
	0xfa38,
	0xfa39,
	0xfa3a,
	0xfa3b,
	0xfa3c,
	0xfa3d,
	0xfa3e,
	0xfa3f,
	0xfa40,
	0xfa41,
	0xfa42,
	0xfa43,
	0xfa44,
	0xfa45,
	0xfa46,
	0xfa47,
	0xfa48,
	0xfa49,
	0xfa4a,
	0xfa4b,
	0xfa4c,
	0xfa4d,
	0xfa4e,
	0xfa4f,
	0xfa50,
	0xfa51,
	0xfa52,
	0xfa53,
	0xfa54,
	0xfa55,
	0xfa56,
	0xfa57,
	0xfa58,
	0xfa59,
	0xfa5a,
	0xfa5b,
	0xfa5c,
	0xfa5d,
	0xfa5e,
	0xfa5f,
	0xfa60,
	0xfa61,
	0xfa62,
	0xfa63,
	0xfa64,
	0xfa65,
	0xfa66,
	0xfa67,
	0xfa68,
	0xfa69,
	0xfa6a,
	0xfa6b,
	0xfa6c,
	0xfa6d,
	0xfa70,
	0xfa71,
	0xfa72,
	0xfa73,
	0xfa74,
	0xfa75,
	0xfa76,
	0xfa77,
	0xfa78,
	0xfa79,
	0xfa7a,
	0xfa7b,
	0xfa7c,
	0xfa7d,
	0xfa7e,
	0xfa7f,
	0xfa80,
	0xfa81,
	0xfa82,
	0xfa83,
	0xfa84,
	0xfa85,
	0xfa86,
	0xfa87,
	0xfa88,
	0xfa89,
	0xfa8a,
	0xfa8b,
	0xfa8c,
	0xfa8d,
	0xfa8e,
	0xfa8f,
	0xfa90,
	0xfa91,
	0xfa92,
	0xfa93,
	0xfa94,
	0xfa95,
	0xfa96,
	0xfa97,
	0xfa98,
	0xfa99,
	0xfa9a,
	0xfa9b,
	0xfa9c,
	0xfa9d,
	0xfa9e,
	0xfa9f,
	0xfaa0,
	0xfaa1,
	0xfaa2,
	0xfaa3,
	0xfaa4,
	0xfaa5,
	0xfaa6,
	0xfaa7,
	0xfaa8,
	0xfaa9,
	0xfaaa,
	0xfaab,
	0xfaac,
	0xfaad,
	0xfaae,
	0xfaaf,
	0xfab0,
	0xfab1,
	0xfab2,
	0xfab3,
	0xfab4,
	0xfab5,
	0xfab6,
	0xfab7,
	0xfab8,
	0xfab9,
	0xfaba,
	0xfabb,
	0xfabc,
	0xfabd,
	0xfabe,
	0xfabf,
	0xfac0,
	0xfac1,
	0xfac2,
	0xfac3,
	0xfac4,
	0xfac5,
	0xfac6,
	0xfac7,
	0xfac8,
	0xfac9,
	0xfaca,
	0xfacb,
	0xfacc,
	0xfacd,
	0xface,
	0xfacf,
	0xfad0,
	0xfad1,
	0xfad2,
	0xfad3,
	0xfad4,
	0xfad5,
	0xfad6,
	0xfad7,
	0xfad8,
	0xfad9,
	0xfb00,
	0xfb01,
	0xfb02,
	0xfb03,
	0xfb04,
	0xfb06,
	0xfb13,
	0xfb14,
	0xfb15,
	0xfb16,
	0xfb17,
	0xfb1d,
	0xfb1e,
	0xfb1f,
	0xfb20,
	0xfb21,
	0xfb22,
	0xfb23,
	0xfb24,
	0xfb25,
	0xfb26,
	0xfb27,
	0xfb28,
	0xfb29,
	0xfb2a,
	0xfb2b,
	0xfb2c,
	0xfb2d,
	0xfb2e,
	0xfb2f,
	0xfb30,
	0xfb31,
	0xfb32,
	0xfb33,
	0xfb34,
	0xfb35,
	0xfb36,
	0xfb38,
	0xfb39,
	0xfb3a,
	0xfb3b,
	0xfb3c,
	0xfb3e,
	0xfb40,
	0xfb41,
	0xfb43,
	0xfb44,
	0xfb46,
	0xfb47,
	0xfb48,
	0xfb49,
	0xfb4a,
	0xfb4b,
	0xfb4c,
	0xfb4d,
	0xfb4e,
	0xfb4f,
	0xfb50,
	0xfb51,
	0xfb52,
	0xfb53,
	0xfb54,
	0xfb55,
	0xfb56,
	0xfb57,
	0xfb58,
	0xfb59,
	0xfb5a,
	0xfb5b,
	0xfb5c,
	0xfb5d,
	0xfb5e,
	0xfb5f,
	0xfb60,
	0xfb61,
	0xfb62,
	0xfb63,
	0xfb64,
	0xfb65,
	0xfb66,
	0xfb67,
	0xfb68,
	0xfb69,
	0xfb6a,
	0xfb6b,
	0xfb6c,
	0xfb6d,
	0xfb6e,
	0xfb6f,
	0xfb70,
	0xfb71,
	0xfb72,
	0xfb73,
	0xfb74,
	0xfb75,
	0xfb76,
	0xfb77,
	0xfb78,
	0xfb79,
	0xfb7a,
	0xfb7b,
	0xfb7c,
	0xfb7d,
	0xfb7e,
	0xfb7f,
	0xfb80,
	0xfb81,
	0xfb82,
	0xfb83,
	0xfb84,
	0xfb85,
	0xfb86,
	0xfb87,
	0xfb88,
	0xfb89,
	0xfb8a,
	0xfb8b,
	0xfb8c,
	0xfb8d,
	0xfb8e,
	0xfb8f,
	0xfb90,
	0xfb91,
	0xfb92,
	0xfb93,
	0xfb94,
	0xfb95,
	0xfb96,
	0xfb97,
	0xfb98,
	0xfb99,
	0xfb9a,
	0xfb9b,
	0xfb9c,
	0xfb9d,
	0xfb9e,
	0xfb9f,
	0xfba0,
	0xfba1,
	0xfba2,
	0xfba3,
	0xfba4,
	0xfba5,
	0xfba6,
	0xfba7,
	0xfba8,
	0xfba9,
	0xfbaa,
	0xfbab,
	0xfbac,
	0xfbad,
	0xfbae,
	0xfbaf,
	0xfbb0,
	0xfbb1,
	0xfbd3,
	0xfbd4,
	0xfbd5,
	0xfbd6,
	0xfbd7,
	0xfbd8,
	0xfbd9,
	0xfbda,
	0xfbdb,
	0xfbdc,
	0xfbdd,
	0xfbde,
	0xfbdf,
	0xfbe0,
	0xfbe1,
	0xfbe2,
	0xfbe3,
	0xfbe4,
	0xfbe5,
	0xfbe6,
	0xfbe7,
	0xfbe8,
	0xfbe9,
	0xfbea,
	0xfbeb,
	0xfbec,
	0xfbed,
	0xfbee,
	0xfbef,
	0xfbf0,
	0xfbf1,
	0xfbf2,
	0xfbf3,
	0xfbf4,
	0xfbf5,
	0xfbf6,
	0xfbf7,
	0xfbf8,
	0xfbf9,
	0xfbfa,
	0xfbfb,
	0xfbfc,
	0xfbfd,
	0xfbfe,
	0xfbff,
	0xfc00,
	0xfc01,
	0xfc02,
	0xfc03,
	0xfc04,
	0xfc05,
	0xfc06,
	0xfc07,
	0xfc08,
	0xfc09,
	0xfc0a,
	0xfc0b,
	0xfc0c,
	0xfc0d,
	0xfc0e,
	0xfc0f,
	0xfc10,
	0xfc11,
	0xfc12,
	0xfc13,
	0xfc14,
	0xfc15,
	0xfc16,
	0xfc17,
	0xfc18,
	0xfc19,
	0xfc1a,
	0xfc1b,
	0xfc1c,
	0xfc1d,
	0xfc1e,
	0xfc1f,
	0xfc20,
	0xfc21,
	0xfc22,
	0xfc23,
	0xfc24,
	0xfc25,
	0xfc26,
	0xfc27,
	0xfc28,
	0xfc29,
	0xfc2a,
	0xfc2b,
	0xfc2c,
	0xfc2d,
	0xfc2e,
	0xfc2f,
	0xfc30,
	0xfc31,
	0xfc32,
	0xfc33,
	0xfc34,
	0xfc35,
	0xfc36,
	0xfc37,
	0xfc38,
	0xfc39,
	0xfc3a,
	0xfc3b,
	0xfc3c,
	0xfc3d,
	0xfc3e,
	0xfc3f,
	0xfc40,
	0xfc41,
	0xfc42,
	0xfc43,
	0xfc44,
	0xfc45,
	0xfc46,
	0xfc47,
	0xfc48,
	0xfc49,
	0xfc4a,
	0xfc4b,
	0xfc4c,
	0xfc4d,
	0xfc4e,
	0xfc4f,
	0xfc50,
	0xfc51,
	0xfc52,
	0xfc53,
	0xfc54,
	0xfc55,
	0xfc56,
	0xfc57,
	0xfc58,
	0xfc59,
	0xfc5a,
	0xfc5b,
	0xfc5c,
	0xfc5d,
	0xfc5e,
	0xfc5f,
	0xfc60,
	0xfc61,
	0xfc62,
	0xfc63,
	0xfc64,
	0xfc65,
	0xfc66,
	0xfc67,
	0xfc68,
	0xfc69,
	0xfc6a,
	0xfc6b,
	0xfc6c,
	0xfc6d,
	0xfc6e,
	0xfc6f,
	0xfc70,
	0xfc71,
	0xfc72,
	0xfc73,
	0xfc74,
	0xfc75,
	0xfc76,
	0xfc77,
	0xfc78,
	0xfc79,
	0xfc7a,
	0xfc7b,
	0xfc7c,
	0xfc7d,
	0xfc7e,
	0xfc7f,
	0xfc80,
	0xfc81,
	0xfc82,
	0xfc83,
	0xfc84,
	0xfc85,
	0xfc86,
	0xfc87,
	0xfc88,
	0xfc89,
	0xfc8a,
	0xfc8b,
	0xfc8c,
	0xfc8d,
	0xfc8e,
	0xfc8f,
	0xfc90,
	0xfc91,
	0xfc92,
	0xfc93,
	0xfc94,
	0xfc95,
	0xfc96,
	0xfc97,
	0xfc98,
	0xfc99,
	0xfc9a,
	0xfc9b,
	0xfc9c,
	0xfc9d,
	0xfc9e,
	0xfc9f,
	0xfca0,
	0xfca1,
	0xfca2,
	0xfca3,
	0xfca4,
	0xfca5,
	0xfca6,
	0xfca7,
	0xfca8,
	0xfca9,
	0xfcaa,
	0xfcab,
	0xfcac,
	0xfcad,
	0xfcae,
	0xfcaf,
	0xfcb0,
	0xfcb1,
	0xfcb2,
	0xfcb3,
	0xfcb4,
	0xfcb5,
	0xfcb6,
	0xfcb7,
	0xfcb8,
	0xfcb9,
	0xfcba,
	0xfcbb,
	0xfcbc,
	0xfcbd,
	0xfcbe,
	0xfcbf,
	0xfcc0,
	0xfcc1,
	0xfcc2,
	0xfcc3,
	0xfcc4,
	0xfcc5,
	0xfcc6,
	0xfcc7,
	0xfcc8,
	0xfcc9,
	0xfcca,
	0xfccb,
	0xfccc,
	0xfccd,
	0xfcce,
	0xfccf,
	0xfcd0,
	0xfcd1,
	0xfcd2,
	0xfcd3,
	0xfcd4,
	0xfcd5,
	0xfcd6,
	0xfcd7,
	0xfcd8,
	0xfcd9,
	0xfcda,
	0xfcdb,
	0xfcdc,
	0xfcdd,
	0xfcde,
	0xfcdf,
	0xfce0,
	0xfce1,
	0xfce2,
	0xfce3,
	0xfce4,
	0xfce5,
	0xfce6,
	0xfce7,
	0xfce8,
	0xfce9,
	0xfcea,
	0xfceb,
	0xfcec,
	0xfced,
	0xfcee,
	0xfcef,
	0xfcf0,
	0xfcf1,
	0xfcf2,
	0xfcf3,
	0xfcf4,
	0xfcf5,
	0xfcf6,
	0xfcf7,
	0xfcf8,
	0xfcf9,
	0xfcfa,
	0xfcfb,
	0xfcfc,
	0xfcfd,
	0xfcfe,
	0xfcff,
	0xfd00,
	0xfd01,
	0xfd02,
	0xfd03,
	0xfd04,
	0xfd05,
	0xfd06,
	0xfd07,
	0xfd08,
	0xfd09,
	0xfd0a,
	0xfd0b,
	0xfd0c,
	0xfd0d,
	0xfd0e,
	0xfd0f,
	0xfd10,
	0xfd11,
	0xfd12,
	0xfd13,
	0xfd14,
	0xfd15,
	0xfd16,
	0xfd17,
	0xfd18,
	0xfd19,
	0xfd1a,
	0xfd1b,
	0xfd1c,
	0xfd1d,
	0xfd1e,
	0xfd1f,
	0xfd20,
	0xfd21,
	0xfd22,
	0xfd23,
	0xfd24,
	0xfd25,
	0xfd26,
	0xfd27,
	0xfd28,
	0xfd29,
	0xfd2a,
	0xfd2b,
	0xfd2c,
	0xfd2d,
	0xfd2e,
	0xfd2f,
	0xfd30,
	0xfd31,
	0xfd32,
	0xfd33,
	0xfd34,
	0xfd35,
	0xfd36,
	0xfd37,
	0xfd38,
	0xfd39,
	0xfd3a,
	0xfd3b,
	0xfd3c,
	0xfd3d,
	0xfd3e,
	0xfd3f,
	0xfd50,
	0xfd51,
	0xfd52,
	0xfd53,
	0xfd54,
	0xfd55,
	0xfd56,
	0xfd57,
	0xfd58,
	0xfd59,
	0xfd5a,
	0xfd5b,
	0xfd5c,
	0xfd5d,
	0xfd5e,
	0xfd5f,
	0xfd60,
	0xfd61,
	0xfd62,
	0xfd63,
	0xfd64,
	0xfd65,
	0xfd66,
	0xfd67,
	0xfd68,
	0xfd69,
	0xfd6a,
	0xfd6b,
	0xfd6c,
	0xfd6d,
	0xfd6e,
	0xfd6f,
	0xfd70,
	0xfd71,
	0xfd72,
	0xfd73,
	0xfd74,
	0xfd75,
	0xfd76,
	0xfd77,
	0xfd78,
	0xfd79,
	0xfd7a,
	0xfd7b,
	0xfd7c,
	0xfd7d,
	0xfd7e,
	0xfd7f,
	0xfd80,
	0xfd81,
	0xfd82,
	0xfd83,
	0xfd84,
	0xfd85,
	0xfd86,
	0xfd87,
	0xfd88,
	0xfd89,
	0xfd8a,
	0xfd8b,
	0xfd8c,
	0xfd8d,
	0xfd8e,
	0xfd8f,
	0xfd92,
	0xfd93,
	0xfd94,
	0xfd95,
	0xfd96,
	0xfd97,
	0xfd98,
	0xfd99,
	0xfd9a,
	0xfd9b,
	0xfd9c,
	0xfd9d,
	0xfd9e,
	0xfd9f,
	0xfda0,
	0xfda1,
	0xfda2,
	0xfda3,
	0xfda4,
	0xfda5,
	0xfda6,
	0xfda7,
	0xfda8,
	0xfda9,
	0xfdaa,
	0xfdab,
	0xfdac,
	0xfdad,
	0xfdae,
	0xfdaf,
	0xfdb0,
	0xfdb1,
	0xfdb2,
	0xfdb3,
	0xfdb4,
	0xfdb5,
	0xfdb6,
	0xfdb7,
	0xfdb8,
	0xfdb9,
	0xfdba,
	0xfdbb,
	0xfdbc,
	0xfdbd,
	0xfdbe,
	0xfdbf,
	0xfdc0,
	0xfdc1,
	0xfdc2,
	0xfdc3,
	0xfdc4,
	0xfdc5,
	0xfdc6,
	0xfdc7,
	0xfdf0,
	0xfdf1,
	0xfdf2,
	0xfdf3,
	0xfdf4,
	0xfdf5,
	0xfdf6,
	0xfdf7,
	0xfdf8,
	0xfdf9,
	0xfdfa,
	0xfdfb,
	0xfdfc,
	0xfe00,
	0xfe01,
	0xfe02,
	0xfe03,
	0xfe04,
	0xfe05,
	0xfe06,
	0xfe07,
	0xfe08,
	0xfe09,
	0xfe0a,
	0xfe0b,
	0xfe0c,
	0xfe0d,
	0xfe0e,
	0xfe0f,
	0xfe19,
	0xfe20,
	0xfe21,
	0xfe22,
	0xfe23,
	0xfe24,
	0xfe25,
	0xfe26,
	0xfe27,
	0xfe28,
	0xfe29,
	0xfe2a,
	0xfe2b,
	0xfe2c,
	0xfe2d,
	0xfe2e,
	0xfe2f,
	0xfe30,
	0xfe31,
	0xfe34,
	0xfe35,
	0xfe36,
	0xfe37,
	0xfe38,
	0xfe39,
	0xfe3a,
	0xfe49,
	0xfe4a,
	0xfe4b,
	0xfe4c,
	0xfe4d,
	0xfe4e,
	0xfe4f,
	0xfe58,
	0xfe68,
	0xfe80,
	0xfe81,
	0xfe82,
	0xfe83,
	0xfe84,
	0xfe85,
	0xfe86,
	0xfe87,
	0xfe88,
	0xfe89,
	0xfe8a,
	0xfe8b,
	0xfe8c,
	0xfe8d,
	0xfe8e,
	0xfe8f,
	0xfe90,
	0xfe91,
	0xfe92,
	0xfe93,
	0xfe94,
	0xfe95,
	0xfe96,
	0xfe97,
	0xfe98,
	0xfe99,
	0xfe9a,
	0xfe9b,
	0xfe9c,
	0xfe9d,
	0xfe9e,
	0xfe9f,
	0xfea0,
	0xfea1,
	0xfea2,
	0xfea3,
	0xfea4,
	0xfea5,
	0xfea6,
	0xfea7,
	0xfea8,
	0xfea9,
	0xfeaa,
	0xfeab,
	0xfeac,
	0xfead,
	0xfeae,
	0xfeaf,
	0xfeb0,
	0xfeb1,
	0xfeb2,
	0xfeb3,
	0xfeb4,
	0xfeb5,
	0xfeb6,
	0xfeb7,
	0xfeb8,
	0xfeb9,
	0xfeba,
	0xfebb,
	0xfebc,
	0xfebd,
	0xfebe,
	0xfebf,
	0xfec0,
	0xfec1,
	0xfec2,
	0xfec3,
	0xfec4,
	0xfec5,
	0xfec6,
	0xfec7,
	0xfec8,
	0xfec9,
	0xfeca,
	0xfecb,
	0xfecc,
	0xfecd,
	0xfece,
	0xfecf,
	0xfed0,
	0xfed1,
	0xfed2,
	0xfed3,
	0xfed4,
	0xfed5,
	0xfed6,
	0xfed7,
	0xfed8,
	0xfed9,
	0xfeda,
	0xfedb,
	0xfedc,
	0xfedd,
	0xfede,
	0xfedf,
	0xfee0,
	0xfee1,
	0xfee2,
	0xfee3,
	0xfee4,
	0xfee5,
	0xfee6,
	0xfee7,
	0xfee8,
	0xfee9,
	0xfeea,
	0xfeeb,
	0xfeec,
	0xfeed,
	0xfeee,
	0xfeef,
	0xfef0,
	0xfef1,
	0xfef2,
	0xfef3,
	0xfef4,
	0xfef5,
	0xfef6,
	0xfef7,
	0xfef8,
	0xfef9,
	0xfefa,
	0xfefb,
	0xfefc,
	0xfeff,
	0xff01,
	0xff02,
	0xff07,
	0xff0d,
	0xff1a,
	0xff21,
	0xff22,
	0xff23,
	0xff25,
	0xff28,
	0xff29,
	0xff2a,
	0xff2b,
	0xff2d,
	0xff2e,
	0xff2f,
	0xff30,
	0xff33,
	0xff34,
	0xff38,
	0xff39,
	0xff3a,
	0xff3b,
	0xff3c,
	0xff3d,
	0xff3e,
	0xff40,
	0xff41,
	0xff43,
	0xff45,
	0xff47,
	0xff48,
	0xff49,
	0xff4a,
	0xff4c,
	0xff4f,
	0xff50,
	0xff53,
	0xff56,
	0xff58,
	0xff59,
	0xff5c,
	0xff5e,
	0xff65,
	0xffe3,
	0xffe8,
	0xffed,
	0xfff9,
	0xfffa,
	0xfffb,
	0xfffc,
	0x10101,
	0x1018e,
	0x10196,
	0x10197,
	0x10198,
	0x10199,
	0x101a0,
	0x101fd,
	0x10282,
	0x10285,
	0x10286,
	0x10287,
	0x1028a,
	0x1028d,
	0x10290,
	0x10292,
	0x10294,
	0x10295,
	0x10296,
	0x10297,
	0x1029b,
	0x102a0,
	0x102a1,
	0x102a2,
	0x102a3,
	0x102a5,
	0x102ab,
	0x102ad,
	0x102b0,
	0x102b1,
	0x102b2,
	0x102b3,
	0x102b4,
	0x102b5,
	0x102b6,
	0x102b8,
	0x102cf,
	0x102e0,
	0x102e1,
	0x102e4,
	0x102e8,
	0x102f2,
	0x102f5,
	0x10301,
	0x10302,
	0x10309,
	0x10311,
	0x10312,
	0x10315,
	0x10317,
	0x1031a,
	0x1031f,
	0x10320,
	0x10322,
	0x10376,
	0x10377,
	0x10378,
	0x10379,
	0x1037a,
	0x103d1,
	0x103d3,
	0x10401,
	0x10404,
	0x10411,
	0x10415,
	0x1041b,
	0x1041f,
	0x10420,
	0x10423,
	0x10425,
	0x10429,
	0x1042a,
	0x1042c,
	0x1043d,
	0x1043f,
	0x10442,
	0x10443,
	0x10448,
	0x1044b,
	0x1044d,
	0x104a0,
	0x104b0,
	0x104b4,
	0x104bc,
	0x104c2,
	0x104c3,
	0x104c4,
	0x104cd,
	0x104ce,
	0x104d0,
	0x104d1,
	0x104d2,
	0x104d8,
	0x104db,
	0x104ea,
	0x104eb,
	0x104f6,
	0x104f9,
	0x10513,
	0x10516,
	0x10518,
	0x1051c,
	0x1051d,
	0x10525,
	0x10526,
	0x10527,
	0x10a01,
	0x10a02,
	0x10a03,
	0x10a05,
	0x10a06,
	0x10a0c,
	0x10a0d,
	0x10a0e,
	0x10a0f,
	0x10a38,
	0x10a39,
	0x10a3a,
	0x10a3f,
	0x10a50,
	0x10a57,
	0x10ae5,
	0x10ae6,
	0x10cfa,
	0x10cfc,
	0x10d24,
	0x10d25,
	0x10d26,
	0x10d27,
	0x10f46,
	0x10f47,
	0x10f48,
	0x10f49,
	0x10f4a,
	0x10f4b,
	0x10f4c,
	0x10f4d,
	0x10f4e,
	0x10f4f,
	0x10f50,
	0x11000,
	0x11001,
	0x11002,
	0x11038,
	0x11039,
	0x1103a,
	0x1103b,
	0x1103c,
	0x1103d,
	0x1103e,
	0x1103f,
	0x11040,
	0x11041,
	0x11042,
	0x11043,
	0x11044,
	0x11045,
	0x11046,
	0x1107f,
	0x11080,
	0x11081,
	0x11082,
	0x1109a,
	0x1109c,
	0x110ab,
	0x110b0,
	0x110b1,
	0x110b2,
	0x110b3,
	0x110b4,
	0x110b5,
	0x110b6,
	0x110b7,
	0x110b8,
	0x110b9,
	0x110ba,
	0x110bb,
	0x110bd,
	0x110cd,
	0x11100,
	0x11101,
	0x11102,
	0x11127,
	0x11128,
	0x11129,
	0x1112a,
	0x1112b,
	0x1112c,
	0x1112d,
	0x1112e,
	0x1112f,
	0x11130,
	0x11131,
	0x11132,
	0x11133,
	0x11134,
	0x11145,
	0x11146,
	0x11173,
	0x11180,
	0x11181,
	0x11182,
	0x111b3,
	0x111b4,
	0x111b5,
	0x111b6,
	0x111b7,
	0x111b8,
	0x111b9,
	0x111ba,
	0x111bb,
	0x111bc,
	0x111bd,
	0x111be,
	0x111bf,
	0x111c0,
	0x111c7,
	0x111c9,
	0x111ca,
	0x111cb,
	0x111cc,
	0x111db,
	0x111dc,
	0x111de,
	0x1122c,
	0x1122d,
	0x1122e,
	0x1122f,
	0x11230,
	0x11231,
	0x11232,
	0x11233,
	0x11234,
	0x11235,
	0x11236,
	0x11237,
	0x1123e,
	0x112df,
	0x112e0,
	0x112e1,
	0x112e2,
	0x112e3,
	0x112e4,
	0x112e5,
	0x112e6,
	0x112e7,
	0x112e8,
	0x112e9,
	0x112ea,
	0x11300,
	0x11301,
	0x11302,
	0x11303,
	0x1133b,
	0x1133c,
	0x1133e,
	0x1133f,
	0x11340,
	0x11341,
	0x11342,
	0x11343,
	0x11344,
	0x11347,
	0x11348,
	0x1134b,
	0x1134c,
	0x1134d,
	0x11357,
	0x11362,
	0x11363,
	0x11366,
	0x11367,
	0x11368,
	0x11369,
	0x1136a,
	0x1136b,
	0x1136c,
	0x11370,
	0x11371,
	0x11372,
	0x11373,
	0x11374,
	0x11413,
	0x11419,
	0x11424,
	0x1142a,
	0x1142d,
	0x1142f,
	0x11435,
	0x11436,
	0x11437,
	0x11438,
	0x11439,
	0x1143a,
	0x1143b,
	0x1143c,
	0x1143d,
	0x1143e,
	0x1143f,
	0x11440,
	0x11441,
	0x11442,
	0x11443,
	0x11444,
	0x11445,
	0x11446,
	0x1144c,
	0x1145e,
	0x11492,
	0x11494,
	0x11496,
	0x11498,
	0x11499,
	0x1149b,
	0x1149d,
	0x1149e,
	0x1149f,
	0x114a0,
	0x114a1,
	0x114a2,
	0x114a3,
	0x114a7,
	0x114a8,
	0x114a9,
	0x114aa,
	0x114ab,
	0x114ad,
	0x114ae,
	0x114b0,
	0x114b1,
	0x114b2,
	0x114b3,
	0x114b4,
	0x114b5,
	0x114b6,
	0x114b7,
	0x114b8,
	0x114b9,
	0x114ba,
	0x114bb,
	0x114bc,
	0x114bd,
	0x114be,
	0x114bf,
	0x114c0,
	0x114c1,
	0x114c2,
	0x114c3,
	0x114c4,
	0x114c5,
	0x114d0,
	0x114d1,
	0x114d2,
	0x114d6,
	0x115af,
	0x115b0,
	0x115b1,
	0x115b2,
	0x115b3,
	0x115b4,
	0x115b5,
	0x115b8,
	0x115b9,
	0x115ba,
	0x115bb,
	0x115bc,
	0x115bd,
	0x115be,
	0x115bf,
	0x115c0,
	0x115d8,
	0x115d9,
	0x115da,
	0x115db,
	0x115dc,
	0x115dd,
	0x11630,
	0x11631,
	0x11632,
	0x11633,
	0x11634,
	0x11635,
	0x11636,
	0x11637,
	0x11638,
	0x11639,
	0x1163a,
	0x1163b,
	0x1163c,
	0x1163d,
	0x1163e,
	0x1163f,
	0x11640,
	0x11642,
	0x116ab,
	0x116ac,
	0x116ad,
	0x116ae,
	0x116af,
	0x116b0,
	0x116b1,
	0x116b2,
	0x116b3,
	0x116b4,
	0x116b5,
	0x116b6,
	0x116b7,
	0x11700,
	0x11706,
	0x1170a,
	0x1170e,
	0x1170f,
	0x1171d,
	0x1171e,
	0x1171f,
	0x11720,
	0x11721,
	0x11722,
	0x11723,
	0x11724,
	0x11725,
	0x11726,
	0x11727,
	0x11728,
	0x11729,
	0x1172a,
	0x1172b,
	0x1182c,
	0x1182d,
	0x1182e,
	0x1182f,
	0x11830,
	0x11831,
	0x11832,
	0x11833,
	0x11834,
	0x11835,
	0x11836,
	0x11837,
	0x11838,
	0x11839,
	0x1183a,
	0x118a0,
	0x118a2,
	0x118a3,
	0x118a4,
	0x118a6,
	0x118a8,
	0x118a9,
	0x118ac,
	0x118ae,
	0x118af,
	0x118b2,
	0x118b5,
	0x118b7,
	0x118b8,
	0x118bb,
	0x118bc,
	0x118c0,
	0x118c1,
	0x118c2,
	0x118c3,
	0x118c4,
	0x118c6,
	0x118c8,
	0x118ca,
	0x118cc,
	0x118ce,
	0x118d5,
	0x118d6,
	0x118d7,
	0x118d8,
	0x118dc,
	0x118e0,
	0x118e3,
	0x118e4,
	0x118e5,
	0x118e6,
	0x118e9,
	0x118ec,
	0x118ef,
	0x118f2,
	0x11a01,
	0x11a02,
	0x11a03,
	0x11a04,
	0x11a05,
	0x11a06,
	0x11a07,
	0x11a08,
	0x11a09,
	0x11a0a,
	0x11a33,
	0x11a34,
	0x11a35,
	0x11a36,
	0x11a37,
	0x11a38,
	0x11a39,
	0x11a3b,
	0x11a3c,
	0x11a3d,
	0x11a3e,
	0x11a47,
	0x11a51,
	0x11a52,
	0x11a53,
	0x11a54,
	0x11a55,
	0x11a56,
	0x11a57,
	0x11a58,
	0x11a59,
	0x11a5a,
	0x11a5b,
	0x11a8a,
	0x11a8b,
	0x11a8c,
	0x11a8d,
	0x11a8e,
	0x11a8f,
	0x11a90,
	0x11a91,
	0x11a92,
	0x11a93,
	0x11a94,
	0x11a95,
	0x11a96,
	0x11a97,
	0x11a98,
	0x11a99,
	0x11ae6,
	0x11ae7,
	0x11ae8,
	0x11ae9,
	0x11aea,
	0x11aec,
	0x11aed,
	0x11aee,
	0x11af4,
	0x11af5,
	0x11af6,
	0x11af7,
	0x11af8,
	0x11c2f,
	0x11c30,
	0x11c31,
	0x11c32,
	0x11c33,
	0x11c34,
	0x11c35,
	0x11c36,
	0x11c38,
	0x11c39,
	0x11c3a,
	0x11c3b,
	0x11c3c,
	0x11c3d,
	0x11c3e,
	0x11c3f,
	0x11c42,
	0x11c92,
	0x11c93,
	0x11c94,
	0x11c95,
	0x11c96,
	0x11c97,
	0x11c98,
	0x11c99,
	0x11c9a,
	0x11c9b,
	0x11c9c,
	0x11c9d,
	0x11c9e,
	0x11c9f,
	0x11ca0,
	0x11ca1,
	0x11ca2,
	0x11ca3,
	0x11ca4,
	0x11ca5,
	0x11ca6,
	0x11ca7,
	0x11ca9,
	0x11caa,
	0x11cab,
	0x11cac,
	0x11cad,
	0x11cae,
	0x11caf,
	0x11cb0,
	0x11cb1,
	0x11cb2,
	0x11cb3,
	0x11cb4,
	0x11cb5,
	0x11cb6,
	0x11d31,
	0x11d32,
	0x11d33,
	0x11d34,
	0x11d35,
	0x11d36,
	0x11d3a,
	0x11d3c,
	0x11d3d,
	0x11d3f,
	0x11d40,
	0x11d41,
	0x11d42,
	0x11d43,
	0x11d44,
	0x11d45,
	0x11d47,
	0x11d8a,
	0x11d8b,
	0x11d8c,
	0x11d8d,
	0x11d8e,
	0x11d90,
	0x11d91,
	0x11d93,
	0x11d94,
	0x11d95,
	0x11d96,
	0x11d97,
	0x11ef3,
	0x11ef4,
	0x11ef5,
	0x11ef6,
	0x12038,
	0x132f9,
	0x16af0,
	0x16af1,
	0x16af2,
	0x16af3,
	0x16af4,
	0x16b30,
	0x16b31,
	0x16b32,
	0x16b33,
	0x16b34,
	0x16b35,
	0x16b36,
	0x16f07,
	0x16f08,
	0x16f0a,
	0x16f16,
	0x16f1a,
	0x16f1c,
	0x16f26,
	0x16f28,
	0x16f2d,
	0x16f35,
	0x16f3a,
	0x16f3b,
	0x16f3d,
	0x16f3f,
	0x16f40,
	0x16f42,
	0x16f43,
	0x16f51,
	0x16f52,
	0x16f53,
	0x16f54,
	0x16f55,
	0x16f56,
	0x16f57,
	0x16f58,
	0x16f59,
	0x16f5a,
	0x16f5b,
	0x16f5c,
	0x16f5d,
	0x16f5e,
	0x16f5f,
	0x16f60,
	0x16f61,
	0x16f62,
	0x16f63,
	0x16f64,
	0x16f65,
	0x16f66,
	0x16f67,
	0x16f68,
	0x16f69,
	0x16f6a,
	0x16f6b,
	0x16f6c,
	0x16f6d,
	0x16f6e,
	0x16f6f,
	0x16f70,
	0x16f71,
	0x16f72,
	0x16f73,
	0x16f74,
	0x16f75,
	0x16f76,
	0x16f77,
	0x16f78,
	0x16f79,
	0x16f7a,
	0x16f7b,
	0x16f7c,
	0x16f7d,
	0x16f7e,
	0x16f8f,
	0x16f90,
	0x16f91,
	0x16f92,
	0x1bc9d,
	0x1bc9e,
	0x1bca0,
	0x1bca1,
	0x1bca2,
	0x1bca3,
	0x1d114,
	0x1d15e,
	0x1d15f,
	0x1d160,
	0x1d161,
	0x1d162,
	0x1d163,
	0x1d164,
	0x1d165,
	0x1d166,
	0x1d167,
	0x1d168,
	0x1d169,
	0x1d16d,
	0x1d16e,
	0x1d16f,
	0x1d170,
	0x1d171,
	0x1d172,
	0x1d173,
	0x1d174,
	0x1d175,
	0x1d176,
	0x1d177,
	0x1d178,
	0x1d179,
	0x1d17a,
	0x1d17b,
	0x1d17c,
	0x1d17d,
	0x1d17e,
	0x1d17f,
	0x1d180,
	0x1d181,
	0x1d182,
	0x1d185,
	0x1d186,
	0x1d187,
	0x1d188,
	0x1d189,
	0x1d18a,
	0x1d18b,
	0x1d1aa,
	0x1d1ab,
	0x1d1ac,
	0x1d1ad,
	0x1d1bb,
	0x1d1bc,
	0x1d1bd,
	0x1d1be,
	0x1d1bf,
	0x1d1c0,
	0x1d202,
	0x1d206,
	0x1d20b,
	0x1d20d,
	0x1d20f,
	0x1d212,
	0x1d213,
	0x1d214,
	0x1d215,
	0x1d216,
	0x1d217,
	0x1d21a,
	0x1d21b,
	0x1d21c,
	0x1d221,
	0x1d222,
	0x1d22a,
	0x1d22b,
	0x1d230,
	0x1d236,
	0x1d237,
	0x1d238,
	0x1d239,
	0x1d23a,
	0x1d23b,
	0x1d23f,
	0x1d242,
	0x1d243,
	0x1d244,
	0x1d245,
	0x1d400,
	0x1d401,
	0x1d402,
	0x1d403,
	0x1d404,
	0x1d405,
	0x1d406,
	0x1d407,
	0x1d408,
	0x1d409,
	0x1d40a,
	0x1d40b,
	0x1d40c,
	0x1d40d,
	0x1d40e,
	0x1d40f,
	0x1d410,
	0x1d411,
	0x1d412,
	0x1d413,
	0x1d414,
	0x1d415,
	0x1d416,
	0x1d417,
	0x1d418,
	0x1d419,
	0x1d41a,
	0x1d41b,
	0x1d41c,
	0x1d41d,
	0x1d41e,
	0x1d41f,
	0x1d420,
	0x1d421,
	0x1d422,
	0x1d423,
	0x1d424,
	0x1d425,
	0x1d426,
	0x1d427,
	0x1d428,
	0x1d429,
	0x1d42a,
	0x1d42b,
	0x1d42c,
	0x1d42d,
	0x1d42e,
	0x1d42f,
	0x1d430,
	0x1d431,
	0x1d432,
	0x1d433,
	0x1d434,
	0x1d435,
	0x1d436,
	0x1d437,
	0x1d438,
	0x1d439,
	0x1d43a,
	0x1d43b,
	0x1d43c,
	0x1d43d,
	0x1d43e,
	0x1d43f,
	0x1d440,
	0x1d441,
	0x1d442,
	0x1d443,
	0x1d444,
	0x1d445,
	0x1d446,
	0x1d447,
	0x1d448,
	0x1d449,
	0x1d44a,
	0x1d44b,
	0x1d44c,
	0x1d44d,
	0x1d44e,
	0x1d44f,
	0x1d450,
	0x1d451,
	0x1d452,
	0x1d453,
	0x1d454,
	0x1d456,
	0x1d457,
	0x1d458,
	0x1d459,
	0x1d45a,
	0x1d45b,
	0x1d45c,
	0x1d45d,
	0x1d45e,
	0x1d45f,
	0x1d460,
	0x1d461,
	0x1d462,
	0x1d463,
	0x1d464,
	0x1d465,
	0x1d466,
	0x1d467,
	0x1d468,
	0x1d469,
	0x1d46a,
	0x1d46b,
	0x1d46c,
	0x1d46d,
	0x1d46e,
	0x1d46f,
	0x1d470,
	0x1d471,
	0x1d472,
	0x1d473,
	0x1d474,
	0x1d475,
	0x1d476,
	0x1d477,
	0x1d478,
	0x1d479,
	0x1d47a,
	0x1d47b,
	0x1d47c,
	0x1d47d,
	0x1d47e,
	0x1d47f,
	0x1d480,
	0x1d481,
	0x1d482,
	0x1d483,
	0x1d484,
	0x1d485,
	0x1d486,
	0x1d487,
	0x1d488,
	0x1d489,
	0x1d48a,
	0x1d48b,
	0x1d48c,
	0x1d48d,
	0x1d48e,
	0x1d48f,
	0x1d490,
	0x1d491,
	0x1d492,
	0x1d493,
	0x1d494,
	0x1d495,
	0x1d496,
	0x1d497,
	0x1d498,
	0x1d499,
	0x1d49a,
	0x1d49b,
	0x1d49c,
	0x1d49e,
	0x1d49f,
	0x1d4a2,
	0x1d4a5,
	0x1d4a6,
	0x1d4a9,
	0x1d4aa,
	0x1d4ab,
	0x1d4ac,
	0x1d4ae,
	0x1d4af,
	0x1d4b0,
	0x1d4b1,
	0x1d4b2,
	0x1d4b3,
	0x1d4b4,
	0x1d4b5,
	0x1d4b6,
	0x1d4b7,
	0x1d4b8,
	0x1d4b9,
	0x1d4bb,
	0x1d4bd,
	0x1d4be,
	0x1d4bf,
	0x1d4c0,
	0x1d4c1,
	0x1d4c2,
	0x1d4c3,
	0x1d4c5,
	0x1d4c6,
	0x1d4c7,
	0x1d4c8,
	0x1d4c9,
	0x1d4ca,
	0x1d4cb,
	0x1d4cc,
	0x1d4cd,
	0x1d4ce,
	0x1d4cf,
	0x1d4d0,
	0x1d4d1,
	0x1d4d2,
	0x1d4d3,
	0x1d4d4,
	0x1d4d5,
	0x1d4d6,
	0x1d4d7,
	0x1d4d8,
	0x1d4d9,
	0x1d4da,
	0x1d4db,
	0x1d4dc,
	0x1d4dd,
	0x1d4de,
	0x1d4df,
	0x1d4e0,
	0x1d4e1,
	0x1d4e2,
	0x1d4e3,
	0x1d4e4,
	0x1d4e5,
	0x1d4e6,
	0x1d4e7,
	0x1d4e8,
	0x1d4e9,
	0x1d4ea,
	0x1d4eb,
	0x1d4ec,
	0x1d4ed,
	0x1d4ee,
	0x1d4ef,
	0x1d4f0,
	0x1d4f1,
	0x1d4f2,
	0x1d4f3,
	0x1d4f4,
	0x1d4f5,
	0x1d4f6,
	0x1d4f7,
	0x1d4f8,
	0x1d4f9,
	0x1d4fa,
	0x1d4fb,
	0x1d4fc,
	0x1d4fd,
	0x1d4fe,
	0x1d4ff,
	0x1d500,
	0x1d501,
	0x1d502,
	0x1d503,
	0x1d504,
	0x1d505,
	0x1d507,
	0x1d508,
	0x1d509,
	0x1d50a,
	0x1d50d,
	0x1d50e,
	0x1d50f,
	0x1d510,
	0x1d511,
	0x1d512,
	0x1d513,
	0x1d514,
	0x1d516,
	0x1d517,
	0x1d518,
	0x1d519,
	0x1d51a,
	0x1d51b,
	0x1d51c,
	0x1d51e,
	0x1d51f,
	0x1d520,
	0x1d521,
	0x1d522,
	0x1d523,
	0x1d524,
	0x1d525,
	0x1d526,
	0x1d527,
	0x1d528,
	0x1d529,
	0x1d52a,
	0x1d52b,
	0x1d52c,
	0x1d52d,
	0x1d52e,
	0x1d52f,
	0x1d530,
	0x1d531,
	0x1d532,
	0x1d533,
	0x1d534,
	0x1d535,
	0x1d536,
	0x1d537,
	0x1d538,
	0x1d539,
	0x1d53b,
	0x1d53c,
	0x1d53d,
	0x1d53e,
	0x1d540,
	0x1d541,
	0x1d542,
	0x1d543,
	0x1d544,
	0x1d546,
	0x1d54a,
	0x1d54b,
	0x1d54c,
	0x1d54d,
	0x1d54e,
	0x1d54f,
	0x1d550,
	0x1d552,
	0x1d553,
	0x1d554,
	0x1d555,
	0x1d556,
	0x1d557,
	0x1d558,
	0x1d559,
	0x1d55a,
	0x1d55b,
	0x1d55c,
	0x1d55d,
	0x1d55e,
	0x1d55f,
	0x1d560,
	0x1d561,
	0x1d562,
	0x1d563,
	0x1d564,
	0x1d565,
	0x1d566,
	0x1d567,
	0x1d568,
	0x1d569,
	0x1d56a,
	0x1d56b,
	0x1d56c,
	0x1d56d,
	0x1d56e,
	0x1d56f,
	0x1d570,
	0x1d571,
	0x1d572,
	0x1d573,
	0x1d574,
	0x1d575,
	0x1d576,
	0x1d577,
	0x1d578,
	0x1d579,
	0x1d57a,
	0x1d57b,
	0x1d57c,
	0x1d57d,
	0x1d57e,
	0x1d57f,
	0x1d580,
	0x1d581,
	0x1d582,
	0x1d583,
	0x1d584,
	0x1d585,
	0x1d586,
	0x1d587,
	0x1d588,
	0x1d589,
	0x1d58a,
	0x1d58b,
	0x1d58c,
	0x1d58d,
	0x1d58e,
	0x1d58f,
	0x1d590,
	0x1d591,
	0x1d592,
	0x1d593,
	0x1d594,
	0x1d595,
	0x1d596,
	0x1d597,
	0x1d598,
	0x1d599,
	0x1d59a,
	0x1d59b,
	0x1d59c,
	0x1d59d,
	0x1d59e,
	0x1d59f,
	0x1d5a0,
	0x1d5a1,
	0x1d5a2,
	0x1d5a3,
	0x1d5a4,
	0x1d5a5,
	0x1d5a6,
	0x1d5a7,
	0x1d5a8,
	0x1d5a9,
	0x1d5aa,
	0x1d5ab,
	0x1d5ac,
	0x1d5ad,
	0x1d5ae,
	0x1d5af,
	0x1d5b0,
	0x1d5b1,
	0x1d5b2,
	0x1d5b3,
	0x1d5b4,
	0x1d5b5,
	0x1d5b6,
	0x1d5b7,
	0x1d5b8,
	0x1d5b9,
	0x1d5ba,
	0x1d5bb,
	0x1d5bc,
	0x1d5bd,
	0x1d5be,
	0x1d5bf,
	0x1d5c0,
	0x1d5c1,
	0x1d5c2,
	0x1d5c3,
	0x1d5c4,
	0x1d5c5,
	0x1d5c6,
	0x1d5c7,
	0x1d5c8,
	0x1d5c9,
	0x1d5ca,
	0x1d5cb,
	0x1d5cc,
	0x1d5cd,
	0x1d5ce,
	0x1d5cf,
	0x1d5d0,
	0x1d5d1,
	0x1d5d2,
	0x1d5d3,
	0x1d5d4,
	0x1d5d5,
	0x1d5d6,
	0x1d5d7,
	0x1d5d8,
	0x1d5d9,
	0x1d5da,
	0x1d5db,
	0x1d5dc,
	0x1d5dd,
	0x1d5de,
	0x1d5df,
	0x1d5e0,
	0x1d5e1,
	0x1d5e2,
	0x1d5e3,
	0x1d5e4,
	0x1d5e5,
	0x1d5e6,
	0x1d5e7,
	0x1d5e8,
	0x1d5e9,
	0x1d5ea,
	0x1d5eb,
	0x1d5ec,
	0x1d5ed,
	0x1d5ee,
	0x1d5ef,
	0x1d5f0,
	0x1d5f1,
	0x1d5f2,
	0x1d5f3,
	0x1d5f4,
	0x1d5f5,
	0x1d5f6,
	0x1d5f7,
	0x1d5f8,
	0x1d5f9,
	0x1d5fa,
	0x1d5fb,
	0x1d5fc,
	0x1d5fd,
	0x1d5fe,
	0x1d5ff,
	0x1d600,
	0x1d601,
	0x1d602,
	0x1d603,
	0x1d604,
	0x1d605,
	0x1d606,
	0x1d607,
	0x1d608,
	0x1d609,
	0x1d60a,
	0x1d60b,
	0x1d60c,
	0x1d60d,
	0x1d60e,
	0x1d60f,
	0x1d610,
	0x1d611,
	0x1d612,
	0x1d613,
	0x1d614,
	0x1d615,
	0x1d616,
	0x1d617,
	0x1d618,
	0x1d619,
	0x1d61a,
	0x1d61b,
	0x1d61c,
	0x1d61d,
	0x1d61e,
	0x1d61f,
	0x1d620,
	0x1d621,
	0x1d622,
	0x1d623,
	0x1d624,
	0x1d625,
	0x1d626,
	0x1d627,
	0x1d628,
	0x1d629,
	0x1d62a,
	0x1d62b,
	0x1d62c,
	0x1d62d,
	0x1d62e,
	0x1d62f,
	0x1d630,
	0x1d631,
	0x1d632,
	0x1d633,
	0x1d634,
	0x1d635,
	0x1d636,
	0x1d637,
	0x1d638,
	0x1d639,
	0x1d63a,
	0x1d63b,
	0x1d63c,
	0x1d63d,
	0x1d63e,
	0x1d63f,
	0x1d640,
	0x1d641,
	0x1d642,
	0x1d643,
	0x1d644,
	0x1d645,
	0x1d646,
	0x1d647,
	0x1d648,
	0x1d649,
	0x1d64a,
	0x1d64b,
	0x1d64c,
	0x1d64d,
	0x1d64e,
	0x1d64f,
	0x1d650,
	0x1d651,
	0x1d652,
	0x1d653,
	0x1d654,
	0x1d655,
	0x1d656,
	0x1d657,
	0x1d658,
	0x1d659,
	0x1d65a,
	0x1d65b,
	0x1d65c,
	0x1d65d,
	0x1d65e,
	0x1d65f,
	0x1d660,
	0x1d661,
	0x1d662,
	0x1d663,
	0x1d664,
	0x1d665,
	0x1d666,
	0x1d667,
	0x1d668,
	0x1d669,
	0x1d66a,
	0x1d66b,
	0x1d66c,
	0x1d66d,
	0x1d66e,
	0x1d66f,
	0x1d670,
	0x1d671,
	0x1d672,
	0x1d673,
	0x1d674,
	0x1d675,
	0x1d676,
	0x1d677,
	0x1d678,
	0x1d679,
	0x1d67a,
	0x1d67b,
	0x1d67c,
	0x1d67d,
	0x1d67e,
	0x1d67f,
	0x1d680,
	0x1d681,
	0x1d682,
	0x1d683,
	0x1d684,
	0x1d685,
	0x1d686,
	0x1d687,
	0x1d688,
	0x1d689,
	0x1d68a,
	0x1d68b,
	0x1d68c,
	0x1d68d,
	0x1d68e,
	0x1d68f,
	0x1d690,
	0x1d691,
	0x1d692,
	0x1d693,
	0x1d694,
	0x1d695,
	0x1d696,
	0x1d697,
	0x1d698,
	0x1d699,
	0x1d69a,
	0x1d69b,
	0x1d69c,
	0x1d69d,
	0x1d69e,
	0x1d69f,
	0x1d6a0,
	0x1d6a1,
	0x1d6a2,
	0x1d6a3,
	0x1d6a4,
	0x1d6a5,
	0x1d6a8,
	0x1d6a9,
	0x1d6aa,
	0x1d6ab,
	0x1d6ac,
	0x1d6ad,
	0x1d6ae,
	0x1d6af,
	0x1d6b0,
	0x1d6b1,
	0x1d6b2,
	0x1d6b3,
	0x1d6b4,
	0x1d6b5,
	0x1d6b6,
	0x1d6b7,
	0x1d6b8,
	0x1d6b9,
	0x1d6ba,
	0x1d6bb,
	0x1d6bc,
	0x1d6bd,
	0x1d6be,
	0x1d6bf,
	0x1d6c0,
	0x1d6c1,
	0x1d6c2,
	0x1d6c3,
	0x1d6c4,
	0x1d6c5,
	0x1d6c6,
	0x1d6c7,
	0x1d6c8,
	0x1d6c9,
	0x1d6ca,
	0x1d6cb,
	0x1d6cc,
	0x1d6cd,
	0x1d6ce,
	0x1d6cf,
	0x1d6d0,
	0x1d6d1,
	0x1d6d2,
	0x1d6d3,
	0x1d6d4,
	0x1d6d5,
	0x1d6d6,
	0x1d6d7,
	0x1d6d8,
	0x1d6d9,
	0x1d6da,
	0x1d6db,
	0x1d6dc,
	0x1d6dd,
	0x1d6de,
	0x1d6df,
	0x1d6e0,
	0x1d6e1,
	0x1d6e2,
	0x1d6e3,
	0x1d6e4,
	0x1d6e5,
	0x1d6e6,
	0x1d6e7,
	0x1d6e8,
	0x1d6e9,
	0x1d6ea,
	0x1d6eb,
	0x1d6ec,
	0x1d6ed,
	0x1d6ee,
	0x1d6ef,
	0x1d6f0,
	0x1d6f1,
	0x1d6f2,
	0x1d6f3,
	0x1d6f4,
	0x1d6f5,
	0x1d6f6,
	0x1d6f7,
	0x1d6f8,
	0x1d6f9,
	0x1d6fa,
	0x1d6fb,
	0x1d6fc,
	0x1d6fd,
	0x1d6fe,
	0x1d6ff,
	0x1d700,
	0x1d701,
	0x1d702,
	0x1d703,
	0x1d704,
	0x1d705,
	0x1d706,
	0x1d707,
	0x1d708,
	0x1d709,
	0x1d70a,
	0x1d70b,
	0x1d70c,
	0x1d70d,
	0x1d70e,
	0x1d70f,
	0x1d710,
	0x1d711,
	0x1d712,
	0x1d713,
	0x1d714,
	0x1d715,
	0x1d716,
	0x1d717,
	0x1d718,
	0x1d719,
	0x1d71a,
	0x1d71b,
	0x1d71c,
	0x1d71d,
	0x1d71e,
	0x1d71f,
	0x1d720,
	0x1d721,
	0x1d722,
	0x1d723,
	0x1d724,
	0x1d725,
	0x1d726,
	0x1d727,
	0x1d728,
	0x1d729,
	0x1d72a,
	0x1d72b,
	0x1d72c,
	0x1d72d,
	0x1d72e,
	0x1d72f,
	0x1d730,
	0x1d731,
	0x1d732,
	0x1d733,
	0x1d734,
	0x1d735,
	0x1d736,
	0x1d737,
	0x1d738,
	0x1d739,
	0x1d73a,
	0x1d73b,
	0x1d73c,
	0x1d73d,
	0x1d73e,
	0x1d73f,
	0x1d740,
	0x1d741,
	0x1d742,
	0x1d743,
	0x1d744,
	0x1d745,
	0x1d746,
	0x1d747,
	0x1d748,
	0x1d749,
	0x1d74a,
	0x1d74b,
	0x1d74c,
	0x1d74d,
	0x1d74e,
	0x1d74f,
	0x1d750,
	0x1d751,
	0x1d752,
	0x1d753,
	0x1d754,
	0x1d755,
	0x1d756,
	0x1d757,
	0x1d758,
	0x1d759,
	0x1d75a,
	0x1d75b,
	0x1d75c,
	0x1d75d,
	0x1d75e,
	0x1d75f,
	0x1d760,
	0x1d761,
	0x1d762,
	0x1d763,
	0x1d764,
	0x1d765,
	0x1d766,
	0x1d767,
	0x1d768,
	0x1d769,
	0x1d76a,
	0x1d76b,
	0x1d76c,
	0x1d76d,
	0x1d76e,
	0x1d76f,
	0x1d770,
	0x1d771,
	0x1d772,
	0x1d773,
	0x1d774,
	0x1d775,
	0x1d776,
	0x1d777,
	0x1d778,
	0x1d779,
	0x1d77a,
	0x1d77b,
	0x1d77c,
	0x1d77d,
	0x1d77e,
	0x1d77f,
	0x1d780,
	0x1d781,
	0x1d782,
	0x1d783,
	0x1d784,
	0x1d785,
	0x1d786,
	0x1d787,
	0x1d788,
	0x1d789,
	0x1d78a,
	0x1d78b,
	0x1d78c,
	0x1d78d,
	0x1d78e,
	0x1d78f,
	0x1d790,
	0x1d791,
	0x1d792,
	0x1d793,
	0x1d794,
	0x1d795,
	0x1d796,
	0x1d797,
	0x1d798,
	0x1d799,
	0x1d79a,
	0x1d79b,
	0x1d79c,
	0x1d79d,
	0x1d79e,
	0x1d79f,
	0x1d7a0,
	0x1d7a1,
	0x1d7a2,
	0x1d7a3,
	0x1d7a4,
	0x1d7a5,
	0x1d7a6,
	0x1d7a7,
	0x1d7a8,
	0x1d7a9,
	0x1d7aa,
	0x1d7ab,
	0x1d7ac,
	0x1d7ad,
	0x1d7ae,
	0x1d7af,
	0x1d7b0,
	0x1d7b1,
	0x1d7b2,
	0x1d7b3,
	0x1d7b4,
	0x1d7b5,
	0x1d7b6,
	0x1d7b7,
	0x1d7b8,
	0x1d7b9,
	0x1d7ba,
	0x1d7bb,
	0x1d7bc,
	0x1d7bd,
	0x1d7be,
	0x1d7bf,
	0x1d7c0,
	0x1d7c1,
	0x1d7c2,
	0x1d7c3,
	0x1d7c4,
	0x1d7c5,
	0x1d7c6,
	0x1d7c7,
	0x1d7c8,
	0x1d7c9,
	0x1d7ca,
	0x1d7cb,
	0x1d7ce,
	0x1d7cf,
	0x1d7d0,
	0x1d7d1,
	0x1d7d2,
	0x1d7d3,
	0x1d7d4,
	0x1d7d5,
	0x1d7d6,
	0x1d7d7,
	0x1d7d8,
	0x1d7d9,
	0x1d7da,
	0x1d7db,
	0x1d7dc,
	0x1d7dd,
	0x1d7de,
	0x1d7df,
	0x1d7e0,
	0x1d7e1,
	0x1d7e2,
	0x1d7e3,
	0x1d7e4,
	0x1d7e5,
	0x1d7e6,
	0x1d7e7,
	0x1d7e8,
	0x1d7e9,
	0x1d7ea,
	0x1d7eb,
	0x1d7ec,
	0x1d7ed,
	0x1d7ee,
	0x1d7ef,
	0x1d7f0,
	0x1d7f1,
	0x1d7f2,
	0x1d7f3,
	0x1d7f4,
	0x1d7f5,
	0x1d7f6,
	0x1d7f7,
	0x1d7f8,
	0x1d7f9,
	0x1d7fa,
	0x1d7fb,
	0x1d7fc,
	0x1d7fd,
	0x1d7fe,
	0x1d7ff,
	0x1da00,
	0x1da01,
	0x1da02,
	0x1da03,
	0x1da04,
	0x1da05,
	0x1da06,
	0x1da07,
	0x1da08,
	0x1da09,
	0x1da0a,
	0x1da0b,
	0x1da0c,
	0x1da0d,
	0x1da0e,
	0x1da0f,
	0x1da10,
	0x1da11,
	0x1da12,
	0x1da13,
	0x1da14,
	0x1da15,
	0x1da16,
	0x1da17,
	0x1da18,
	0x1da19,
	0x1da1a,
	0x1da1b,
	0x1da1c,
	0x1da1d,
	0x1da1e,
	0x1da1f,
	0x1da20,
	0x1da21,
	0x1da22,
	0x1da23,
	0x1da24,
	0x1da25,
	0x1da26,
	0x1da27,
	0x1da28,
	0x1da29,
	0x1da2a,
	0x1da2b,
	0x1da2c,
	0x1da2d,
	0x1da2e,
	0x1da2f,
	0x1da30,
	0x1da31,
	0x1da32,
	0x1da33,
	0x1da34,
	0x1da35,
	0x1da36,
	0x1da3b,
	0x1da3c,
	0x1da3d,
	0x1da3e,
	0x1da3f,
	0x1da40,
	0x1da41,
	0x1da42,
	0x1da43,
	0x1da44,
	0x1da45,
	0x1da46,
	0x1da47,
	0x1da48,
	0x1da49,
	0x1da4a,
	0x1da4b,
	0x1da4c,
	0x1da4d,
	0x1da4e,
	0x1da4f,
	0x1da50,
	0x1da51,
	0x1da52,
	0x1da53,
	0x1da54,
	0x1da55,
	0x1da56,
	0x1da57,
	0x1da58,
	0x1da59,
	0x1da5a,
	0x1da5b,
	0x1da5c,
	0x1da5d,
	0x1da5e,
	0x1da5f,
	0x1da60,
	0x1da61,
	0x1da62,
	0x1da63,
	0x1da64,
	0x1da65,
	0x1da66,
	0x1da67,
	0x1da68,
	0x1da69,
	0x1da6a,
	0x1da6b,
	0x1da6c,
	0x1da75,
	0x1da84,
	0x1da9b,
	0x1da9c,
	0x1da9d,
	0x1da9e,
	0x1da9f,
	0x1daa1,
	0x1daa2,
	0x1daa3,
	0x1daa4,
	0x1daa5,
	0x1daa6,
	0x1daa7,
	0x1daa8,
	0x1daa9,
	0x1daaa,
	0x1daab,
	0x1daac,
	0x1daad,
	0x1daae,
	0x1daaf,
	0x1e000,
	0x1e001,
	0x1e002,
	0x1e003,
	0x1e004,
	0x1e005,
	0x1e006,
	0x1e008,
	0x1e009,
	0x1e00a,
	0x1e00b,
	0x1e00c,
	0x1e00d,
	0x1e00e,
	0x1e00f,
	0x1e010,
	0x1e011,
	0x1e012,
	0x1e013,
	0x1e014,
	0x1e015,
	0x1e016,
	0x1e017,
	0x1e018,
	0x1e01b,
	0x1e01c,
	0x1e01d,
	0x1e01e,
	0x1e01f,
	0x1e020,
	0x1e021,
	0x1e023,
	0x1e024,
	0x1e026,
	0x1e027,
	0x1e028,
	0x1e029,
	0x1e02a,
	0x1e8c7,
	0x1e8c8,
	0x1e8c9,
	0x1e8cb,
	0x1e8cc,
	0x1e8cd,
	0x1e8d0,
	0x1e8d1,
	0x1e8d2,
	0x1e8d3,
	0x1e8d4,
	0x1e8d5,
	0x1e8d6,
	0x1e944,
	0x1e945,
	0x1e946,
	0x1e947,
	0x1e948,
	0x1e949,
	0x1e94a,
	0x1ee00,
	0x1ee01,
	0x1ee02,
	0x1ee03,
	0x1ee05,
	0x1ee06,
	0x1ee07,
	0x1ee08,
	0x1ee09,
	0x1ee0a,
	0x1ee0b,
	0x1ee0c,
	0x1ee0d,
	0x1ee0e,
	0x1ee0f,
	0x1ee10,
	0x1ee11,
	0x1ee12,
	0x1ee13,
	0x1ee14,
	0x1ee15,
	0x1ee16,
	0x1ee17,
	0x1ee18,
	0x1ee19,
	0x1ee1a,
	0x1ee1b,
	0x1ee1c,
	0x1ee1d,
	0x1ee1e,
	0x1ee1f,
	0x1ee21,
	0x1ee22,
	0x1ee24,
	0x1ee27,
	0x1ee29,
	0x1ee2a,
	0x1ee2b,
	0x1ee2c,
	0x1ee2d,
	0x1ee2e,
	0x1ee2f,
	0x1ee30,
	0x1ee31,
	0x1ee32,
	0x1ee34,
	0x1ee35,
	0x1ee36,
	0x1ee37,
	0x1ee39,
	0x1ee3b,
	0x1ee42,
	0x1ee47,
	0x1ee49,
	0x1ee4b,
	0x1ee4d,
	0x1ee4e,
	0x1ee4f,
	0x1ee51,
	0x1ee52,
	0x1ee54,
	0x1ee57,
	0x1ee59,
	0x1ee5b,
	0x1ee5d,
	0x1ee5f,
	0x1ee61,
	0x1ee62,
	0x1ee64,
	0x1ee67,
	0x1ee68,
	0x1ee69,
	0x1ee6a,
	0x1ee6c,
	0x1ee6d,
	0x1ee6e,
	0x1ee6f,
	0x1ee70,
	0x1ee71,
	0x1ee72,
	0x1ee74,
	0x1ee75,
	0x1ee76,
	0x1ee77,
	0x1ee79,
	0x1ee7a,
	0x1ee7b,
	0x1ee7c,
	0x1ee7e,
	0x1ee80,
	0x1ee81,
	0x1ee82,
	0x1ee83,
	0x1ee84,
	0x1ee85,
	0x1ee86,
	0x1ee87,
	0x1ee88,
	0x1ee89,
	0x1ee8b,
	0x1ee8c,
	0x1ee8d,
	0x1ee8e,
	0x1ee8f,
	0x1ee90,
	0x1ee91,
	0x1ee92,
	0x1ee93,
	0x1ee94,
	0x1ee95,
	0x1ee96,
	0x1ee97,
	0x1ee98,
	0x1ee99,
	0x1ee9a,
	0x1ee9b,
	0x1eea1,
	0x1eea2,
	0x1eea3,
	0x1eea5,
	0x1eea6,
	0x1eea7,
	0x1eea8,
	0x1eea9,
	0x1eeab,
	0x1eeac,
	0x1eead,
	0x1eeae,
	0x1eeaf,
	0x1eeb0,
	0x1eeb1,
	0x1eeb2,
	0x1eeb3,
	0x1eeb4,
	0x1eeb5,
	0x1eeb6,
	0x1eeb7,
	0x1eeb8,
	0x1eeb9,
	0x1eeba,
	0x1eebb,
	0x1f100,
	0x1f101,
	0x1f102,
	0x1f103,
	0x1f104,
	0x1f105,
	0x1f106,
	0x1f107,
	0x1f108,
	0x1f109,
	0x1f10a,
	0x1f110,
	0x1f111,
	0x1f112,
	0x1f113,
	0x1f114,
	0x1f115,
	0x1f116,
	0x1f117,
	0x1f118,
	0x1f119,
	0x1f11a,
	0x1f11b,
	0x1f11c,
	0x1f11d,
	0x1f11e,
	0x1f11f,
	0x1f120,
	0x1f121,
	0x1f122,
	0x1f123,
	0x1f124,
	0x1f125,
	0x1f126,
	0x1f127,
	0x1f128,
	0x1f129,
	0x1f12a,
	0x1f240,
	0x1f241,
	0x1f242,
	0x1f243,
	0x1f244,
	0x1f245,
	0x1f246,
	0x1f247,
	0x1f248,
	0x1f312,
	0x1f318,
	0x1f319,
	0x1f700,
	0x1f701,
	0x1f702,
	0x1f704,
	0x1f707,
	0x1f708,
	0x1f70a,
	0x1f714,
	0x1f728,
	0x1f73a,
	0x1f74c,
	0x1f754,
	0x1f755,
	0x1f75c,
	0x1f75e,
	0x1f768,
	0x1f76b,
	0x1f76c,
	0x1f771,
	0x21fe8,
	0x2f800,
	0x2f801,
	0x2f802,
	0x2f803,
	0x2f804,
	0x2f805,
	0x2f806,
	0x2f807,
	0x2f808,
	0x2f809,
	0x2f80a,
	0x2f80b,
	0x2f80c,
	0x2f80d,
	0x2f80e,
	0x2f80f,
	0x2f810,
	0x2f811,
	0x2f812,
	0x2f813,
	0x2f814,
	0x2f815,
	0x2f816,
	0x2f817,
	0x2f818,
	0x2f819,
	0x2f81a,
	0x2f81b,
	0x2f81c,
	0x2f81d,
	0x2f81e,
	0x2f81f,
	0x2f820,
	0x2f821,
	0x2f822,
	0x2f823,
	0x2f824,
	0x2f825,
	0x2f826,
	0x2f827,
	0x2f828,
	0x2f829,
	0x2f82a,
	0x2f82b,
	0x2f82c,
	0x2f82d,
	0x2f82e,
	0x2f82f,
	0x2f830,
	0x2f831,
	0x2f832,
	0x2f833,
	0x2f834,
	0x2f835,
	0x2f836,
	0x2f837,
	0x2f838,
	0x2f839,
	0x2f83a,
	0x2f83b,
	0x2f83c,
	0x2f83d,
	0x2f83e,
	0x2f83f,
	0x2f840,
	0x2f841,
	0x2f842,
	0x2f843,
	0x2f844,
	0x2f845,
	0x2f846,
	0x2f847,
	0x2f848,
	0x2f849,
	0x2f84a,
	0x2f84b,
	0x2f84c,
	0x2f84d,
	0x2f84e,
	0x2f84f,
	0x2f850,
	0x2f851,
	0x2f852,
	0x2f853,
	0x2f854,
	0x2f855,
	0x2f856,
	0x2f857,
	0x2f858,
	0x2f859,
	0x2f85a,
	0x2f85b,
	0x2f85c,
	0x2f85d,
	0x2f85e,
	0x2f85f,
	0x2f860,
	0x2f861,
	0x2f862,
	0x2f863,
	0x2f864,
	0x2f865,
	0x2f866,
	0x2f867,
	0x2f868,
	0x2f869,
	0x2f86a,
	0x2f86b,
	0x2f86c,
	0x2f86d,
	0x2f86e,
	0x2f86f,
	0x2f870,
	0x2f871,
	0x2f872,
	0x2f873,
	0x2f874,
	0x2f875,
	0x2f876,
	0x2f877,
	0x2f878,
	0x2f879,
	0x2f87a,
	0x2f87b,
	0x2f87c,
	0x2f87d,
	0x2f87e,
	0x2f87f,
	0x2f880,
	0x2f881,
	0x2f882,
	0x2f883,
	0x2f884,
	0x2f885,
	0x2f886,
	0x2f887,
	0x2f888,
	0x2f889,
	0x2f88a,
	0x2f88b,
	0x2f88c,
	0x2f88d,
	0x2f88e,
	0x2f88f,
	0x2f890,
	0x2f891,
	0x2f892,
	0x2f893,
	0x2f894,
	0x2f895,
	0x2f896,
	0x2f897,
	0x2f898,
	0x2f899,
	0x2f89a,
	0x2f89b,
	0x2f89c,
	0x2f89d,
	0x2f89e,
	0x2f89f,
	0x2f8a0,
	0x2f8a1,
	0x2f8a2,
	0x2f8a3,
	0x2f8a4,
	0x2f8a5,
	0x2f8a6,
	0x2f8a7,
	0x2f8a8,
	0x2f8a9,
	0x2f8aa,
	0x2f8ab,
	0x2f8ac,
	0x2f8ad,
	0x2f8ae,
	0x2f8af,
	0x2f8b0,
	0x2f8b1,
	0x2f8b2,
	0x2f8b3,
	0x2f8b4,
	0x2f8b5,
	0x2f8b6,
	0x2f8b7,
	0x2f8b8,
	0x2f8b9,
	0x2f8ba,
	0x2f8bb,
	0x2f8bc,
	0x2f8bd,
	0x2f8be,
	0x2f8bf,
	0x2f8c0,
	0x2f8c1,
	0x2f8c2,
	0x2f8c3,
	0x2f8c4,
	0x2f8c5,
	0x2f8c6,
	0x2f8c7,
	0x2f8c8,
	0x2f8c9,
	0x2f8ca,
	0x2f8cb,
	0x2f8cc,
	0x2f8cd,
	0x2f8ce,
	0x2f8cf,
	0x2f8d0,
	0x2f8d1,
	0x2f8d2,
	0x2f8d3,
	0x2f8d4,
	0x2f8d5,
	0x2f8d6,
	0x2f8d7,
	0x2f8d8,
	0x2f8d9,
	0x2f8da,
	0x2f8db,
	0x2f8dc,
	0x2f8dd,
	0x2f8de,
	0x2f8df,
	0x2f8e0,
	0x2f8e1,
	0x2f8e2,
	0x2f8e3,
	0x2f8e4,
	0x2f8e5,
	0x2f8e6,
	0x2f8e7,
	0x2f8e8,
	0x2f8e9,
	0x2f8ea,
	0x2f8eb,
	0x2f8ec,
	0x2f8ed,
	0x2f8ee,
	0x2f8ef,
	0x2f8f0,
	0x2f8f1,
	0x2f8f2,
	0x2f8f3,
	0x2f8f4,
	0x2f8f5,
	0x2f8f6,
	0x2f8f7,
	0x2f8f8,
	0x2f8f9,
	0x2f8fa,
	0x2f8fb,
	0x2f8fc,
	0x2f8fd,
	0x2f8fe,
	0x2f8ff,
	0x2f900,
	0x2f901,
	0x2f902,
	0x2f903,
	0x2f904,
	0x2f905,
	0x2f906,
	0x2f907,
	0x2f908,
	0x2f909,
	0x2f90a,
	0x2f90b,
	0x2f90c,
	0x2f90d,
	0x2f90e,
	0x2f90f,
	0x2f910,
	0x2f911,
	0x2f912,
	0x2f913,
	0x2f914,
	0x2f915,
	0x2f916,
	0x2f917,
	0x2f918,
	0x2f919,
	0x2f91a,
	0x2f91b,
	0x2f91c,
	0x2f91d,
	0x2f91e,
	0x2f91f,
	0x2f920,
	0x2f921,
	0x2f922,
	0x2f923,
	0x2f924,
	0x2f925,
	0x2f926,
	0x2f927,
	0x2f928,
	0x2f929,
	0x2f92a,
	0x2f92b,
	0x2f92c,
	0x2f92d,
	0x2f92e,
	0x2f92f,
	0x2f930,
	0x2f931,
	0x2f932,
	0x2f933,
	0x2f934,
	0x2f935,
	0x2f936,
	0x2f937,
	0x2f938,
	0x2f939,
	0x2f93a,
	0x2f93b,
	0x2f93c,
	0x2f93d,
	0x2f93e,
	0x2f93f,
	0x2f940,
	0x2f941,
	0x2f942,
	0x2f943,
	0x2f944,
	0x2f945,
	0x2f946,
	0x2f947,
	0x2f948,
	0x2f949,
	0x2f94a,
	0x2f94b,
	0x2f94c,
	0x2f94d,
	0x2f94e,
	0x2f94f,
	0x2f950,
	0x2f951,
	0x2f952,
	0x2f953,
	0x2f954,
	0x2f955,
	0x2f956,
	0x2f957,
	0x2f958,
	0x2f959,
	0x2f95a,
	0x2f95b,
	0x2f95c,
	0x2f95d,
	0x2f95e,
	0x2f95f,
	0x2f960,
	0x2f961,
	0x2f962,
	0x2f963,
	0x2f964,
	0x2f965,
	0x2f966,
	0x2f967,
	0x2f968,
	0x2f969,
	0x2f96a,
	0x2f96b,
	0x2f96c,
	0x2f96d,
	0x2f96e,
	0x2f96f,
	0x2f970,
	0x2f971,
	0x2f972,
	0x2f973,
	0x2f974,
	0x2f975,
	0x2f976,
	0x2f977,
	0x2f978,
	0x2f979,
	0x2f97a,
	0x2f97b,
	0x2f97c,
	0x2f97d,
	0x2f97e,
	0x2f97f,
	0x2f980,
	0x2f981,
	0x2f982,
	0x2f983,
	0x2f984,
	0x2f985,
	0x2f986,
	0x2f987,
	0x2f988,
	0x2f989,
	0x2f98a,
	0x2f98b,
	0x2f98c,
	0x2f98d,
	0x2f98e,
	0x2f98f,
	0x2f990,
	0x2f991,
	0x2f992,
	0x2f993,
	0x2f994,
	0x2f995,
	0x2f996,
	0x2f997,
	0x2f998,
	0x2f999,
	0x2f99a,
	0x2f99b,
	0x2f99c,
	0x2f99d,
	0x2f99e,
	0x2f99f,
	0x2f9a0,
	0x2f9a1,
	0x2f9a2,
	0x2f9a3,
	0x2f9a4,
	0x2f9a5,
	0x2f9a6,
	0x2f9a7,
	0x2f9a8,
	0x2f9a9,
	0x2f9aa,
	0x2f9ab,
	0x2f9ac,
	0x2f9ad,
	0x2f9ae,
	0x2f9af,
	0x2f9b0,
	0x2f9b1,
	0x2f9b2,
	0x2f9b3,
	0x2f9b4,
	0x2f9b5,
	0x2f9b6,
	0x2f9b7,
	0x2f9b8,
	0x2f9b9,
	0x2f9ba,
	0x2f9bb,
	0x2f9bc,
	0x2f9bd,
	0x2f9be,
	0x2f9bf,
	0x2f9c0,
	0x2f9c1,
	0x2f9c2,
	0x2f9c3,
	0x2f9c4,
	0x2f9c5,
	0x2f9c6,
	0x2f9c7,
	0x2f9c8,
	0x2f9c9,
	0x2f9ca,
	0x2f9cb,
	0x2f9cc,
	0x2f9cd,
	0x2f9ce,
	0x2f9cf,
	0x2f9d0,
	0x2f9d1,
	0x2f9d2,
	0x2f9d3,
	0x2f9d4,
	0x2f9d5,
	0x2f9d6,
	0x2f9d7,
	0x2f9d8,
	0x2f9d9,
	0x2f9da,
	0x2f9db,
	0x2f9dc,
	0x2f9dd,
	0x2f9de,
	0x2f9df,
	0x2f9e0,
	0x2f9e1,
	0x2f9e2,
	0x2f9e3,
	0x2f9e4,
	0x2f9e5,
	0x2f9e6,
	0x2f9e7,
	0x2f9e8,
	0x2f9e9,
	0x2f9ea,
	0x2f9eb,
	0x2f9ec,
	0x2f9ed,
	0x2f9ee,
	0x2f9ef,
	0x2f9f0,
	0x2f9f1,
	0x2f9f2,
	0x2f9f3,
	0x2f9f4,
	0x2f9f5,
	0x2f9f6,
	0x2f9f7,
	0x2f9f8,
	0x2f9f9,
	0x2f9fa,
	0x2f9fb,
	0x2f9fc,
	0x2f9fd,
	0x2f9fe,
	0x2f9ff,
	0x2fa00,
	0x2fa01,
	0x2fa02,
	0x2fa03,
	0x2fa04,
	0x2fa05,
	0x2fa06,
	0x2fa07,
	0x2fa08,
	0x2fa09,
	0x2fa0a,
	0x2fa0b,
	0x2fa0c,
	0x2fa0d,
	0x2fa0e,
	0x2fa0f,
	0x2fa10,
	0x2fa11,
	0x2fa12,
	0x2fa13,
	0x2fa14,
	0x2fa15,
	0x2fa16,
	0x2fa17,
	0x2fa18,
	0x2fa19,
	0x2fa1a,
	0x2fa1b,
	0x2fa1c,
	0x2fa1d,
	0xe0001,
	0xe0020,
	0xe0021,
	0xe0022,
	0xe0023,
	0xe0024,
	0xe0025,
	0xe0026,
	0xe0027,
	0xe0028,
	0xe0029,
	0xe002a,
	0xe002b,
	0xe002c,
	0xe002d,
	0xe002e,
	0xe002f,
	0xe0030,
	0xe0031,
	0xe0032,
	0xe0033,
	0xe0034,
	0xe0035,
	0xe0036,
	0xe0037,
	0xe0038,
	0xe0039,
	0xe003a,
	0xe003b,
	0xe003c,
	0xe003d,
	0xe003e,
	0xe003f,
	0xe0040,
	0xe0041,
	0xe0042,
	0xe0043,
	0xe0044,
	0xe0045,
	0xe0046,
	0xe0047,
	0xe0048,
	0xe0049,
	0xe004a,
	0xe004b,
	0xe004c,
	0xe004d,
	0xe004e,
	0xe004f,
	0xe0050,
	0xe0051,
	0xe0052,
	0xe0053,
	0xe0054,
	0xe0055,
	0xe0056,
	0xe0057,
	0xe0058,
	0xe0059,
	0xe005a,
	0xe005b,
	0xe005c,
	0xe005d,
	0xe005e,
	0xe005f,
	0xe0060,
	0xe0061,
	0xe0062,
	0xe0063,
	0xe0064,
	0xe0065,
	0xe0066,
	0xe0067,
	0xe0068,
	0xe0069,
	0xe006a,
	0xe006b,
	0xe006c,
	0xe006d,
	0xe006e,
	0xe006f,
	0xe0070,
	0xe0071,
	0xe0072,
	0xe0073,
	0xe0074,
	0xe0075,
	0xe0076,
	0xe0077,
	0xe0078,
	0xe0079,
	0xe007a,
	0xe007b,
	0xe007c,
	0xe007d,
	0xe007e,
	0xe007f,
	0xe0100,
	0xe0101,
	0xe0102,
	0xe0103,
	0xe0104,
	0xe0105,
	0xe0106,
	0xe0107,
	0xe0108,
	0xe0109,
	0xe010a,
	0xe010b,
	0xe010c,
	0xe010d,
	0xe010e,
	0xe010f,
	0xe0110,
	0xe0111,
	0xe0112,
	0xe0113,
	0xe0114,
	0xe0115,
	0xe0116,
	0xe0117,
	0xe0118,
	0xe0119,
	0xe011a,
	0xe011b,
	0xe011c,
	0xe011d,
	0xe011e,
	0xe011f,
	0xe0120,
	0xe0121,
	0xe0122,
	0xe0123,
	0xe0124,
	0xe0125,
	0xe0126,
	0xe0127,
	0xe0128,
	0xe0129,
	0xe012a,
	0xe012b,
	0xe012c,
	0xe012d,
	0xe012e,
	0xe012f,
	0xe0130,
	0xe0131,
	0xe0132,
	0xe0133,
	0xe0134,
	0xe0135,
	0xe0136,
	0xe0137,
	0xe0138,
	0xe0139,
	0xe013a,
	0xe013b,
	0xe013c,
	0xe013d,
	0xe013e,
	0xe013f,
	0xe0140,
	0xe0141,
	0xe0142,
	0xe0143,
	0xe0144,
	0xe0145,
	0xe0146,
	0xe0147,
	0xe0148,
	0xe0149,
	0xe014a,
	0xe014b,
	0xe014c,
	0xe014d,
	0xe014e,
	0xe014f,
	0xe0150,
	0xe0151,
	0xe0152,
	0xe0153,
	0xe0154,
	0xe0155,
	0xe0156,
	0xe0157,
	0xe0158,
	0xe0159,
	0xe015a,
	0xe015b,
	0xe015c,
	0xe015d,
	0xe015e,
	0xe015f,
	0xe0160,
	0xe0161,
	0xe0162,
	0xe0163,
	0xe0164,
	0xe0165,
	0xe0166,
	0xe0167,
	0xe0168,
	0xe0169,
	0xe016a,
	0xe016b,
	0xe016c,
	0xe016d,
	0xe016e,
	0xe016f,
	0xe0170,
	0xe0171,
	0xe0172,
	0xe0173,
	0xe0174,
	0xe0175,
	0xe0176,
	0xe0177,
	0xe0178,
	0xe0179,
	0xe017a,
	0xe017b,
	0xe017c,
	0xe017d,
	0xe017e,
	0xe017f,
	0xe0180,
	0xe0181,
	0xe0182,
	0xe0183,
	0xe0184,
	0xe0185,
	0xe0186,
	0xe0187,
	0xe0188,
	0xe0189,
	0xe018a,
	0xe018b,
	0xe018c,
	0xe018d,
	0xe018e,
	0xe018f,
	0xe0190,
	0xe0191,
	0xe0192,
	0xe0193,
	0xe0194,
	0xe0195,
	0xe0196,
	0xe0197,
	0xe0198,
	0xe0199,
	0xe019a,
	0xe019b,
	0xe019c,
	0xe019d,
	0xe019e,
	0xe019f,
	0xe01a0,
	0xe01a1,
	0xe01a2,
	0xe01a3,
	0xe01a4,
	0xe01a5,
	0xe01a6,
	0xe01a7,
	0xe01a8,
	0xe01a9,
	0xe01aa,
	0xe01ab,
	0xe01ac,
	0xe01ad,
	0xe01ae,
	0xe01af,
	0xe01b0,
	0xe01b1,
	0xe01b2,
	0xe01b3,
	0xe01b4,
	0xe01b5,
	0xe01b6,
	0xe01b7,
	0xe01b8,
	0xe01b9,
	0xe01ba,
	0xe01bb,
	0xe01bc,
	0xe01bd,
	0xe01be,
	0xe01bf,
	0xe01c0,
	0xe01c1,
	0xe01c2,
	0xe01c3,
	0xe01c4,
	0xe01c5,
	0xe01c6,
	0xe01c7,
	0xe01c8,
	0xe01c9,
	0xe01ca,
	0xe01cb,
	0xe01cc,
	0xe01cd,
	0xe01ce,
	0xe01cf,
	0xe01d0,
	0xe01d1,
	0xe01d2,
	0xe01d3,
	0xe01d4,
	0xe01d5,
	0xe01d6,
	0xe01d7,
	0xe01d8,
	0xe01d9,
	0xe01da,
	0xe01db,
	0xe01dc,
	0xe01dd,
	0xe01de,
	0xe01df,
	0xe01e0,
	0xe01e1,
	0xe01e2,
	0xe01e3,
	0xe01e4,
	0xe01e5,
	0xe01e6,
	0xe01e7,
	0xe01e8,
	0xe01e9,
	0xe01ea,
	0xe01eb,
	0xe01ec,
	0xe01ed,
	0xe01ee,
	0xe01ef,
	0xf0000,
	0xffffd,
	0x100000,
	0x10fffd,
};

static const struct DECOMP_SLICE decomp_slices[NUM_DECOMPS] = {
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{7, 2},
	{1281, 3},
	{733, 1},
	{850, 1},
	{850, 1},
	{6, 1},
	{850, 1},
	{1040, 2},
	{850, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{819, 1},
	{788, 1},
	{0, 0},
	{1355, 1},
	{6, 1},
	{1382, 1},
	{481, 1},
	{679, 1},
	{679, 1},
	{679, 1},
	{679, 1},
	{679, 1},
	{679, 1},
	{682, 2},
	{695, 1},
	{703, 1},
	{703, 1},
	{703, 1},
	{703, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{698, 1},
	{726, 1},
	{733, 1},
	{733, 1},
	{733, 1},
	{733, 1},
	{733, 1},
	{1075, 1},
	{733, 1},
	{762, 1},
	{762, 1},
	{762, 1},
	{762, 1},
	{788, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{806, 2},
	{819, 1},
	{837, 1},
	{837, 1},
	{837, 1},
	{837, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{3098, 1},
	{1006, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{1059, 1},
	{1059, 1},
	{1059, 1},
	{1059, 1},
	{1081, 1},
	{1081, 1},
	{679, 1},
	{797, 1},
	{679, 1},
	{797, 1},
	{679, 1},
	{797, 1},
	{695, 1},
	{819, 1},
	{695, 1},
	{819, 1},
	{695, 1},
	{819, 1},
	{695, 1},
	{819, 1},
	{698, 1},
	{826, 1},
	{698, 1},
	{826, 1},
	{703, 1},
	{837, 1},
	{703, 1},
	{837, 1},
	{703, 1},
	{837, 1},
	{703, 1},
	{837, 1},
	{703, 1},
	{837, 1},
	{708, 1},
	{848, 1},
	{708, 1},
	{848, 1},
	{708, 1},
	{848, 1},
	{708, 1},
	{848, 1},
	{711, 1},
	{849, 1},
	{711, 1},
	{849, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{932, 2},
	{972, 2},
	{712, 1},
	{1004, 1},
	{715, 1},
	{1005, 1},
	{718, 1},
	{850, 1},
	{718, 1},
	{850, 1},
	{718, 1},
	{850, 1},
	{984, 2},
	{984, 2},
	{718, 1},
	{850, 1},
	{726, 1},
	{1006, 1},
	{726, 1},
	{1006, 1},
	{726, 1},
	{1006, 1},
	{26, 2},
	{733, 1},
	{1009, 1},
	{733, 1},
	{1009, 1},
	{733, 1},
	{1009, 1},
	{740, 2},
	{1012, 2},
	{752, 1},
	{1037, 1},
	{752, 1},
	{1037, 1},
	{752, 1},
	{1037, 1},
	{755, 1},
	{1042, 1},
	{755, 1},
	{1042, 1},
	{755, 1},
	{1042, 1},
	{755, 1},
	{1042, 1},
	{756, 1},
	{1048, 1},
	{756, 1},
	{1048, 1},
	{756, 1},
	{1048, 1},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{781, 1},
	{1074, 1},
	{788, 1},
	{1081, 1},
	{788, 1},
	{789, 1},
	{1082, 1},
	{789, 1},
	{1082, 1},
	{789, 1},
	{1082, 1},
	{838, 1},
	{816, 1},
	{16, 2},
	{816, 1},
	{816, 1},
	{816, 1},
	{696, 2},
	{698, 1},
	{18, 2},
	{826, 1},
	{848, 1},
	{704, 1},
	{838, 1},
	{709, 2},
	{850, 1},
	{850, 1},
	{716, 2},
	{1005, 1},
	{850, 1},
	{726, 1},
	{1006, 1},
	{733, 1},
	{733, 1},
	{1009, 1},
	{20, 2},
	{1033, 1},
	{752, 1},
	{499, 1},
	{22, 2},
	{1048, 1},
	{756, 1},
	{762, 1},
	{1059, 1},
	{24, 2},
	{1081, 1},
	{789, 1},
	{1082, 1},
	{558, 1},
	{499, 1},
	{588, 1},
	{1042, 1},
	{1296, 1},
	{850, 1},
	{952, 2},
	{0, 1},
	{699, 2},
	{701, 2},
	{829, 2},
	{719, 2},
	{721, 2},
	{972, 2},
	{727, 2},
	{729, 2},
	{1007, 2},
	{679, 1},
	{797, 1},
	{850, 1},
	{850, 1},
	{733, 1},
	{1009, 1},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{679, 1},
	{797, 1},
	{679, 1},
	{797, 1},
	{682, 2},
	{806, 2},
	{708, 1},
	{848, 1},
	{708, 1},
	{848, 1},
	{715, 1},
	{1005, 1},
	{733, 1},
	{1009, 1},
	{733, 1},
	{1009, 1},
	{558, 1},
	{1315, 1},
	{1004, 1},
	{699, 2},
	{701, 2},
	{829, 2},
	{708, 1},
	{848, 1},
	{726, 1},
	{1006, 1},
	{679, 1},
	{797, 1},
	{682, 2},
	{806, 2},
	{733, 1},
	{1009, 1},
	{679, 1},
	{797, 1},
	{679, 1},
	{797, 1},
	{703, 1},
	{837, 1},
	{703, 1},
	{837, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{733, 1},
	{1009, 1},
	{733, 1},
	{1009, 1},
	{752, 1},
	{1037, 1},
	{752, 1},
	{1037, 1},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{755, 1},
	{1042, 1},
	{756, 1},
	{1048, 1},
	{558, 1},
	{711, 1},
	{849, 1},
	{621, 1},
	{621, 1},
	{789, 1},
	{1082, 1},
	{679, 1},
	{797, 1},
	{703, 1},
	{837, 1},
	{3165, 1},
	{1486, 1},
	{733, 1},
	{1009, 1},
	{733, 1},
	{1009, 1},
	{733, 1},
	{1009, 1},
	{788, 1},
	{1081, 1},
	{819, 1},
	{756, 1},
	{674, 1},
	{762, 1},
	{703, 1},
	{837, 1},
	{712, 1},
	{1004, 1},
	{1037, 1},
	{788, 1},
	{1081, 1},
	{797, 1},
	{816, 1},
	{826, 1},
	{826, 1},
	{1309, 1},
	{1312, 2},
	{4419, 1},
	{848, 1},
	{848, 1},
	{1081, 1},
	{849, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{986, 2},
	{1074, 1},
	{1040, 2},
	{1006, 1},
	{1009, 1},
	{1031, 2},
	{1037, 1},
	{1037, 1},
	{1042, 1},
	{1059, 1},
	{1081, 1},
	{1082, 1},
	{1315, 1},
	{674, 1},
	{1036, 1},
	{829, 2},
	{833, 2},
	{835, 2},
	{1051, 2},
	{1057, 2},
	{1055, 2},
	{846, 2},
	{974, 2},
	{982, 2},
	{3042, 1},
	{6, 1},
	{7, 2},
	{6, 1},
	{6, 1},
	{6, 1},
	{6, 1},
	{1421, 1},
	{650, 1},
	{664, 1},
	{795, 1},
	{795, 1},
	{6, 1},
	{6, 1},
	{6, 1},
	{643, 1},
	{1421, 1},
	{482, 1},
	{1354, 1},
	{2062, 1},
	{1090, 1},
	{850, 1},
	{1085, 1},
	{7, 2},
	{3041, 1},
	{3043, 1},
	{1353, 1},
	{7, 2},
	{6, 1},
	{7, 2},
	{643, 1},
	{1362, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{3211, 1},
	{6, 1},
	{1361, 1},
	{1395, 1},
	{3069, 1},
	{850, 1},
	{1322, 1},
	{4414, 1},
	{649, 1},
	{712, 1},
	{6, 1},
	{1087, 1},
	{679, 1},
	{1096, 1},
	{703, 1},
	{711, 1},
	{850, 1},
	{733, 1},
	{788, 1},
	{1379, 1},
	{850, 1},
	{679, 1},
	{694, 1},
	{703, 1},
	{789, 1},
	{711, 1},
	{733, 1},
	{850, 1},
	{715, 1},
	{1318, 1},
	{723, 1},
	{726, 1},
	{733, 1},
	{746, 1},
	{1306, 1},
	{756, 1},
	{788, 1},
	{782, 1},
	{850, 1},
	{788, 1},
	{797, 1},
	{4419, 1},
	{1006, 1},
	{850, 1},
	{1059, 1},
	{797, 1},
	{1294, 1},
	{1081, 1},
	{3076, 1},
	{4419, 1},
	{1006, 1},
	{733, 1},
	{850, 1},
	{1297, 1},
	{1064, 1},
	{1009, 1},
	{1033, 1},
	{1009, 1},
	{3072, 1},
	{1059, 1},
	{1330, 1},
	{850, 1},
	{1059, 1},
	{1009, 1},
	{1059, 1},
	{1388, 1},
	{1294, 1},
	{733, 1},
	{788, 1},
	{788, 1},
	{788, 1},
	{1330, 1},
	{1384, 1},
	{1385, 1},
	{704, 1},
	{499, 1},
	{1305, 1},
	{1297, 1},
	{1033, 1},
	{819, 1},
	{1004, 1},
	{733, 1},
	{4419, 1},
	{1293, 1},
	{1296, 1},
	{695, 1},
	{723, 1},
	{1301, 1},
	{4413, 1},
	{703, 1},
	{703, 1},
	{1365, 1},
	{4418, 1},
	{755, 1},
	{850, 1},
	{850, 1},
	{712, 1},
	{715, 1},
	{1395, 1},
	{788, 1},
	{679, 1},
	{816, 1},
	{694, 1},
	{1365, 1},
	{703, 1},
	{558, 1},
	{1395, 1},
	{715, 1},
	{1318, 1},
	{723, 1},
	{711, 1},
	{733, 1},
	{1376, 1},
	{746, 1},
	{695, 1},
	{756, 1},
	{788, 1},
	{1377, 1},
	{782, 1},
	{817, 2},
	{816, 1},
	{934, 2},
	{797, 1},
	{599, 1},
	{1348, 1},
	{1037, 1},
	{837, 1},
	{1325, 1},
	{3069, 1},
	{3069, 1},
	{1297, 1},
	{1346, 1},
	{1350, 1},
	{1009, 1},
	{1384, 1},
	{1033, 1},
	{819, 1},
	{3072, 1},
	{1081, 1},
	{1330, 1},
	{1075, 1},
	{1356, 2},
	{1299, 2},
	{1298, 1},
	{3071, 1},
	{837, 1},
	{837, 1},
	{1037, 1},
	{4419, 1},
	{1042, 1},
	{850, 1},
	{850, 1},
	{1004, 1},
	{849, 1},
	{1297, 1},
	{3069, 1},
	{1081, 1},
	{1074, 1},
	{816, 1},
	{816, 1},
	{1378, 1},
	{1387, 1},
	{733, 1},
	{1009, 1},
	{767, 1},
	{1064, 1},
	{767, 1},
	{1064, 1},
	{1407, 1},
	{1074, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{1395, 1},
	{3069, 1},
	{816, 1},
	{816, 1},
	{1366, 2},
	{1038, 2},
	{1365, 1},
	{1037, 1},
	{1394, 1},
	{1401, 1},
	{558, 1},
	{1325, 1},
	{715, 1},
	{1297, 1},
	{715, 1},
	{1297, 1},
	{711, 1},
	{1350, 1},
	{695, 1},
	{819, 1},
	{756, 1},
	{3072, 1},
	{788, 1},
	{1081, 1},
	{788, 1},
	{1081, 1},
	{782, 1},
	{849, 1},
	{837, 1},
	{1412, 1},
	{837, 1},
	{850, 1},
	{1394, 1},
	{1401, 1},
	{1318, 1},
	{1402, 1},
	{711, 1},
	{1350, 1},
	{711, 1},
	{1350, 1},
	{1410, 1},
	{1411, 1},
	{723, 1},
	{1346, 1},
	{850, 1},
	{679, 1},
	{797, 1},
	{679, 1},
	{797, 1},
	{682, 2},
	{806, 2},
	{703, 1},
	{837, 1},
	{1303, 1},
	{1309, 1},
	{1303, 1},
	{1309, 1},
	{1394, 1},
	{1401, 1},
	{558, 1},
	{1325, 1},
	{558, 1},
	{1315, 1},
	{1395, 1},
	{3069, 1},
	{1395, 1},
	{3069, 1},
	{733, 1},
	{1009, 1},
	{733, 1},
	{1009, 1},
	{733, 1},
	{1009, 1},
	{1400, 1},
	{1405, 1},
	{788, 1},
	{1081, 1},
	{788, 1},
	{1081, 1},
	{788, 1},
	{1081, 1},
	{1396, 1},
	{1403, 1},
	{817, 2},
	{1299, 2},
	{826, 1},
	{1314, 1},
	{708, 1},
	{1327, 1},
	{1304, 1},
	{4419, 1},
	{1036, 1},
	{781, 1},
	{1074, 1},
	{2760, 1},
	{2758, 1},
	{2761, 1},
	{2759, 1},
	{762, 1},
	{755, 1},
	{1377, 1},
	{733, 1},
	{6, 1},
	{6, 1},
	{1074, 1},
	{1036, 1},
	{1036, 1},
	{3076, 1},
	{849, 1},
	{1316, 1},
	{1006, 1},
	{1328, 1},
	{1006, 1},
	{1059, 1},
	{848, 1},
	{838, 1},
	{1009, 1},
	{1422, 2},
	{643, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{850, 1},
	{0, 0},
	{0, 0},
	{643, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{850, 1},
	{1064, 1},
	{6, 1},
	{850, 1},
	{1009, 1},
	{952, 2},
	{851, 2},
	{7, 2},
	{6, 1},
	{7, 2},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{1284, 4},
	{1288, 5},
	{481, 1},
	{1718, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{850, 1},
	{850, 1},
	{1935, 1},
	{850, 1},
	{1942, 1},
	{850, 1},
	{1942, 1},
	{1593, 1},
	{1942, 1},
	{1942, 1},
	{1009, 1},
	{1942, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{485, 1},
	{850, 1},
	{1009, 1},
	{767, 1},
	{1318, 1},
	{1281, 3},
	{481, 1},
	{1457, 1},
	{477, 1},
	{1942, 1},
	{2029, 1},
	{0, 0},
	{996, 2},
	{850, 1},
	{996, 2},
	{1940, 2},
	{1940, 2},
	{1973, 2},
	{1942, 1},
	{1942, 1},
	{1559, 1},
	{1559, 1},
	{1581, 1},
	{2025, 1},
	{1581, 1},
	{1583, 1},
	{1583, 1},
	{1583, 1},
	{1638, 1},
	{1699, 1},
	{2029, 1},
	{1751, 1},
	{2029, 1},
	{1787, 1},
	{1787, 1},
	{1787, 1},
	{2033, 1},
	{1808, 1},
	{1808, 1},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{1486, 1},
	{1935, 1},
	{1935, 1},
	{1935, 1},
	{1935, 1},
	{1935, 1},
	{1942, 1},
	{1942, 1},
	{2018, 1},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{482, 1},
	{1009, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{1581, 1},
	{1583, 1},
	{485, 1},
	{850, 1},
	{2011, 1},
	{2012, 1},
	{2013, 1},
	{1009, 1},
	{2014, 1},
	{767, 1},
	{1318, 1},
	{2015, 1},
	{1460, 1},
	{1850, 1},
	{1009, 1},
	{485, 1},
	{485, 1},
	{643, 1},
	{643, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{1461, 1},
	{1942, 1},
	{2032, 1},
	{1787, 1},
	{2037, 1},
	{1900, 1},
	{1900, 1},
	{1583, 1},
	{2028, 1},
	{1559, 1},
	{1593, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{733, 1},
	{850, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{6, 1},
	{6, 1},
	{796, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{1461, 1},
	{2030, 1},
	{1850, 1},
	{1942, 1},
	{2037, 1},
	{1581, 1},
	{1638, 1},
	{2033, 1},
	{1935, 1},
	{1592, 1},
	{1461, 1},
	{1942, 1},
	{1583, 1},
	{1942, 1},
	{2029, 1},
	{2029, 1},
	{1942, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{643, 1},
	{2038, 1},
	{2038, 1},
	{2050, 2},
	{2039, 1},
	{2039, 1},
	{2039, 1},
	{2038, 1},
	{2038, 1},
	{2038, 1},
	{2038, 1},
	{2046, 1},
	{2049, 1},
	{2052, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2040, 1},
	{2041, 1},
	{2042, 1},
	{2043, 1},
	{2044, 1},
	{2045, 1},
	{2047, 1},
	{2048, 1},
	{0, 0},
	{0, 0},
	{2055, 2},
	{1009, 1},
	{2015, 1},
	{674, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{2063, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2070, 1},
	{2071, 1},
	{2081, 1},
	{2064, 1},
	{2064, 1},
	{0, 0},
	{0, 0},
	{733, 1},
	{621, 1},
	{632, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2090, 1},
	{2097, 1},
	{2097, 1},
	{2098, 1},
	{2098, 1},
	{2097, 1},
	{2090, 1},
	{2090, 1},
	{2095, 1},
	{2096, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2091, 1},
	{2092, 1},
	{2093, 1},
	{2094, 1},
	{1009, 1},
	{632, 1},
	{621, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{643, 1},
	{2099, 1},
	{2099, 1},
	{2099, 1},
	{2099, 1},
	{2099, 1},
	{2099, 1},
	{2099, 1},
	{0, 0},
	{2053, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{1009, 1},
	{2057, 1},
	{2058, 1},
	{2059, 1},
	{2060, 1},
	{2061, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{621, 1},
	{2100, 1},
	{733, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2101, 1},
	{2102, 1},
	{0, 0},
	{0, 0},
	{733, 1},
	{632, 1},
	{0, 0},
	{2106, 2},
	{2112, 2},
	{2111, 1},
	{2104, 1},
	{2104, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2119, 1},
	{2104, 1},
	{2104, 1},
	{2122, 1},
	{0, 0},
	{2122, 1},
	{1009, 1},
	{2114, 1},
	{2105, 1},
	{2115, 1},
	{2104, 1},
	{2115, 1},
	{2108, 1},
	{2103, 1},
	{2121, 1},
	{2115, 1},
	{2120, 1},
	{2126, 1},
	{2109, 2},
	{2125, 1},
	{2118, 1},
	{0, 0},
	{0, 0},
	{1009, 1},
	{0, 0},
	{0, 0},
	{2132, 1},
	{2132, 1},
	{2140, 1},
	{2135, 1},
	{2137, 1},
	{2138, 1},
	{2143, 1},
	{2143, 1},
	{2143, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2130, 1},
	{2131, 1},
	{0, 0},
	{0, 0},
	{1009, 1},
	{0, 0},
	{1009, 1},
	{0, 0},
	{2127, 1},
	{2128, 1},
	{2129, 1},
	{2132, 1},
	{2132, 1},
	{2132, 1},
	{2133, 1},
	{2134, 1},
	{2136, 1},
	{2139, 1},
	{2141, 1},
	{2142, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2147, 1},
	{0, 0},
	{0, 0},
	{1009, 1},
	{2144, 1},
	{2145, 1},
	{2146, 1},
	{0, 0},
	{0, 0},
	{1009, 1},
	{0, 0},
	{2148, 1},
	{2105, 1},
	{2105, 1},
	{2154, 1},
	{2149, 1},
	{2150, 1},
	{2150, 1},
	{2154, 1},
	{2111, 1},
	{1009, 1},
	{2117, 1},
	{2159, 1},
	{2123, 1},
	{2124, 1},
	{2116, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2062, 1},
	{0, 0},
	{2157, 2},
	{1028, 3},
	{2151, 1},
	{0, 0},
	{0, 0},
	{1009, 1},
	{2159, 1},
	{2152, 2},
	{2155, 2},
	{632, 1},
	{2160, 2},
	{2154, 1},
	{2162, 2},
	{2154, 1},
	{2154, 1},
	{2159, 1},
	{1009, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2166, 1},
	{2164, 1},
	{2165, 1},
	{2166, 1},
	{0, 0},
	{0, 0},
	{2167, 1},
	{2171, 1},
	{2172, 1},
	{2168, 1},
	{2168, 1},
	{2173, 1},
	{2169, 1},
	{2179, 1},
	{0, 0},
	{2182, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2183, 2},
	{2182, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{1009, 1},
	{2170, 1},
	{2180, 1},
	{2174, 1},
	{2175, 1},
	{2176, 1},
	{2177, 1},
	{2178, 1},
	{0, 0},
	{2192, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{1009, 1},
	{2188, 2},
	{2190, 2},
	{2214, 1},
	{2210, 1},
	{2211, 2},
	{2193, 1},
	{2194, 2},
	{0, 0},
	{0, 0},
	{2196, 2},
	{2202, 2},
	{2198, 2},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2205, 1},
	{2206, 1},
	{2207, 1},
	{2208, 1},
	{2209, 1},
	{2204, 1},
	{2213, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2200, 2},
	{3498, 1},
	{3497, 1},
	{2215, 1},
	{1009, 1},
	{1009, 1},
	{2217, 1},
	{2219, 1},
	{2218, 1},
	{2218, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{1009, 1},
	{2221, 2},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2220, 1},
	{2217, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2217, 1},
	{2216, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2223, 1},
	{2215, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{4417, 1},
	{1081, 1},
	{1315, 1},
	{1009, 1},
	{2225, 2},
	{2272, 2},
	{2426, 2},
	{2484, 2},
	{2552, 2},
	{2247, 2},
	{2249, 2},
	{2251, 2},
	{2255, 2},
	{2270, 2},
	{2306, 2},
	{2316, 2},
	{2367, 2},
	{2357, 2},
	{2392, 2},
	{2402, 2},
	{2413, 2},
	{2415, 2},
	{2417, 2},
	{2431, 2},
	{2433, 3},
	{2436, 3},
	{2439, 3},
	{2442, 3},
	{2445, 3},
	{2453, 2},
	{2455, 2},
	{2459, 2},
	{2461, 2},
	{2451, 2},
	{2428, 3},
	{2466, 2},
	{2468, 2},
	{2470, 2},
	{2472, 2},
	{2474, 2},
	{2476, 2},
	{2478, 3},
	{2495, 3},
	{2498, 2},
	{2500, 2},
	{2502, 2},
	{2504, 2},
	{2506, 2},
	{2508, 2},
	{2367, 2},
	{2590, 2},
	{2592, 2},
	{2513, 2},
	{2518, 2},
	{2522, 2},
	{2524, 2},
	{2526, 2},
	{2542, 2},
	{2528, 2},
	{2530, 2},
	{2532, 2},
	{2536, 2},
	{2538, 2},
	{2550, 2},
	{2605, 2},
	{2607, 2},
	{2558, 2},
	{2560, 2},
	{2567, 2},
	{2571, 2},
	{2588, 2},
	{2229, 2},
	{2257, 2},
	{2259, 2},
	{2265, 2},
	{2277, 2},
	{2620, 2},
	{2629, 2},
	{2638, 2},
	{2647, 2},
	{2650, 2},
	{2652, 3},
	{2677, 2},
	{2702, 2},
	{2707, 3},
	{2717, 2},
	{3261, 1},
	{3275, 2},
	{3363, 1},
	{2614, 2},
	{2616, 2},
	{2623, 2},
	{2625, 2},
	{2632, 2},
	{2634, 2},
	{2636, 2},
	{2643, 2},
	{2645, 2},
	{2660, 2},
	{2662, 3},
	{2667, 3},
	{2670, 2},
	{2675, 2},
	{2685, 2},
	{2687, 3},
	{2685, 2},
	{2692, 2},
	{2694, 2},
	{2697, 2},
	{2699, 3},
	{2704, 3},
	{2712, 3},
	{2715, 2},
	{2723, 2},
	{2728, 2},
	{2730, 3},
	{2733, 2},
	{2735, 3},
	{2740, 2},
	{2742, 2},
	{3271, 2},
	{3273, 2},
	{3277, 3},
	{3364, 2},
	{3366, 2},
	{3379, 2},
	{3386, 2},
	{3392, 2},
	{3390, 2},
	{2747, 2},
	{2752, 2},
	{2756, 2},
	{2754, 2},
	{2618, 2},
	{2627, 2},
	{2641, 2},
	{2655, 2},
	{2657, 3},
	{2224, 1},
	{2225, 2},
	{2235, 2},
	{2246, 1},
	{2259, 2},
	{2265, 2},
	{2269, 1},
	{2294, 1},
	{2295, 2},
	{2321, 2},
	{2332, 2},
	{2352, 2},
	{2363, 2},
	{2365, 2},
	{2367, 2},
	{2378, 1},
	{2412, 1},
	{2431, 2},
	{2465, 1},
	{2484, 2},
	{2512, 1},
	{2544, 1},
	{2557, 1},
	{2562, 1},
	{2563, 1},
	{2566, 1},
	{2577, 1},
	{2231, 2},
	{2237, 3},
	{2247, 2},
	{2251, 2},
	{2257, 2},
	{2267, 2},
	{2263, 2},
	{2270, 2},
	{2277, 2},
	{2300, 3},
	{2306, 2},
	{2308, 2},
	{2313, 3},
	{2316, 2},
	{2323, 3},
	{2326, 3},
	{2340, 3},
	{2349, 3},
	{2343, 3},
	{2354, 3},
	{2369, 2},
	{2361, 2},
	{2373, 2},
	{2379, 2},
	{2388, 2},
	{2392, 2},
	{2397, 2},
	{2399, 3},
	{2410, 2},
	{2406, 2},
	{2408, 2},
	{2402, 2},
	{2419, 2},
	{2461, 2},
	{2463, 2},
	{2451, 2},
	{2466, 2},
	{2470, 2},
	{2472, 2},
	{2476, 2},
	{2594, 1},
	{2513, 2},
	{2515, 3},
	{2528, 2},
	{2534, 2},
	{2600, 1},
	{2526, 2},
	{2542, 2},
	{2567, 2},
	{2571, 2},
	{2578, 2},
	{2580, 2},
	{2582, 2},
	{2584, 2},
	{2609, 1},
	{2227, 2},
	{2233, 2},
	{2240, 2},
	{2242, 2},
	{2244, 2},
	{2249, 2},
	{762, 1},
	{1328, 1},
	{1377, 1},
	{1415, 1},
	{1424, 1},
	{733, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{698, 1},
	{752, 1},
	{756, 1},
	{734, 2},
	{850, 1},
	{3211, 1},
	{788, 1},
	{679, 1},
	{712, 1},
	{703, 1},
	{674, 1},
	{3211, 1},
	{1365, 1},
	{781, 1},
	{723, 1},
	{711, 1},
	{788, 1},
	{733, 1},
	{1307, 1},
	{708, 1},
	{849, 1},
	{789, 1},
	{1407, 1},
	{1304, 1},
	{762, 1},
	{575, 1},
	{816, 1},
	{752, 1},
	{781, 1},
	{755, 1},
	{767, 1},
	{755, 1},
	{718, 1},
	{695, 1},
	{746, 1},
	{715, 1},
	{826, 1},
	{733, 1},
	{599, 1},
	{1294, 1},
	{849, 1},
	{708, 1},
	{694, 1},
	{1327, 1},
	{1348, 1},
	{658, 1},
	{1370, 1},
	{1126, 2},
	{2763, 2},
	{1122, 2},
	{1371, 2},
	{1128, 2},
	{2767, 2},
	{1130, 2},
	{2769, 2},
	{1132, 2},
	{2773, 2},
	{1134, 2},
	{2775, 2},
	{1136, 2},
	{2779, 2},
	{1096, 1},
	{2765, 2},
	{1373, 2},
	{2771, 2},
	{2777, 2},
	{767, 1},
	{1318, 1},
	{664, 1},
	{1101, 2},
	{650, 1},
	{1111, 2},
	{779, 2},
	{1118, 2},
	{1319, 2},
	{1138, 2},
	{2785, 2},
	{1101, 2},
	{672, 2},
	{1140, 2},
	{2787, 2},
	{1099, 2},
	{656, 2},
	{1142, 2},
	{2790, 2},
	{6, 1},
	{762, 1},
	{1415, 1},
	{1146, 2},
	{1109, 2},
	{765, 2},
	{1124, 2},
	{1418, 2},
	{1144, 2},
	{2792, 2},
	{1146, 2},
	{2799, 2},
	{1148, 2},
	{2803, 2},
	{1150, 2},
	{2808, 2},
	{1152, 2},
	{2810, 2},
	{763, 2},
	{1416, 2},
	{2795, 2},
	{2806, 2},
	{746, 1},
	{826, 1},
	{1154, 2},
	{2814, 2},
	{1107, 2},
	{1034, 2},
	{1156, 2},
	{2816, 2},
	{1113, 2},
	{831, 2},
	{1158, 2},
	{2818, 2},
	{1160, 2},
	{2822, 2},
	{1162, 2},
	{2824, 2},
	{2812, 2},
	{747, 2},
	{827, 2},
	{2820, 2},
	{712, 1},
	{1164, 2},
	{2827, 2},
	{1166, 2},
	{2829, 2},
	{1168, 2},
	{2831, 2},
	{1103, 2},
	{713, 2},
	{1170, 2},
	{2833, 2},
	{1172, 2},
	{2836, 2},
	{1174, 2},
	{2838, 2},
	{1365, 1},
	{718, 1},
	{1176, 2},
	{2840, 2},
	{1120, 2},
	{1368, 2},
	{1178, 2},
	{2842, 2},
	{1180, 2},
	{2844, 2},
	{1182, 2},
	{2846, 2},
	{1105, 2},
	{984, 2},
	{1184, 2},
	{2848, 2},
	{499, 1},
	{1186, 2},
	{2850, 2},
	{1196, 2},
	{2860, 2},
	{1198, 2},
	{2862, 2},
	{2783, 1},
	{1200, 2},
	{2865, 2},
	{1202, 2},
	{2867, 2},
	{1204, 2},
	{2869, 2},
	{1206, 2},
	{2871, 2},
	{1208, 2},
	{2873, 2},
	{1210, 2},
	{2876, 2},
	{1212, 2},
	{2878, 2},
	{1214, 2},
	{2880, 2},
	{1216, 2},
	{2882, 2},
	{1218, 2},
	{2884, 2},
	{1220, 2},
	{2886, 2},
	{1222, 2},
	{2888, 2},
	{1224, 2},
	{2890, 2},
	{1226, 2},
	{2892, 2},
	{2894, 2},
	{2896, 2},
	{2898, 2},
	{2900, 2},
	{1228, 2},
	{2902, 2},
	{1230, 2},
	{2904, 2},
	{1232, 2},
	{2906, 2},
	{1234, 2},
	{2908, 2},
	{1236, 2},
	{2910, 2},
	{1238, 2},
	{2912, 2},
	{1240, 2},
	{2914, 2},
	{1097, 2},
	{580, 2},
	{1242, 2},
	{2916, 2},
	{1244, 2},
	{2918, 2},
	{1246, 2},
	{2920, 2},
	{1248, 2},
	{2922, 2},
	{1250, 2},
	{2924, 2},
	{1252, 2},
	{2926, 2},
	{2784, 1},
	{1075, 1},
	{1266, 2},
	{2933, 2},
	{1268, 2},
	{2953, 2},
	{1270, 2},
	{2959, 2},
	{3076, 1},
	{711, 1},
	{1075, 1},
	{2941, 2},
	{2935, 2},
	{2943, 2},
	{2937, 2},
	{2945, 2},
	{2947, 2},
	{2949, 2},
	{2951, 2},
	{752, 1},
	{2969, 2},
	{2971, 2},
	{2973, 2},
	{2965, 2},
	{2975, 2},
	{2977, 2},
	{2979, 2},
	{816, 1},
	{704, 1},
	{3081, 1},
	{4420, 1},
	{3209, 1},
	{679, 1},
	{698, 1},
	{698, 1},
	{1407, 1},
	{723, 1},
	{694, 1},
	{2835, 1},
	{2826, 1},
	{2864, 1},
	{2875, 1},
	{2928, 1},
	{2931, 1},
	{2932, 1},
	{1308, 1},
	{1379, 1},
	{1308, 1},
	{1379, 1},
	{782, 1},
	{1075, 1},
	{2939, 2},
	{2967, 2},
	{2983, 2},
	{2985, 2},
	{2981, 2},
	{2987, 2},
	{2989, 2},
	{2991, 2},
	{2995, 2},
	{2997, 2},
	{2999, 2},
	{3001, 2},
	{3003, 2},
	{3005, 2},
	{3007, 2},
	{0, 0},
	{650, 1},
	{782, 1},
	{850, 1},
	{3020, 1},
	{6, 1},
	{715, 1},
	{723, 1},
	{1378, 1},
	{3019, 1},
	{1096, 1},
	{643, 1},
	{478, 1},
	{1377, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{493, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{3034, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2181, 1},
	{2186, 1},
	{2185, 1},
	{2187, 1},
	{0, 0},
	{643, 1},
	{643, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{3035, 1},
	{0, 0},
	{0, 0},
	{3036, 1},
	{0, 0},
	{1272, 2},
	{1274, 2},
	{1276, 2},
	{1278, 2},
	{1188, 2},
	{2852, 2},
	{1190, 2},
	{2854, 2},
	{1192, 2},
	{2856, 2},
	{1194, 2},
	{2858, 2},
	{1254, 2},
	{1256, 2},
	{1258, 2},
	{1260, 2},
	{1262, 2},
	{1264, 2},
	{3043, 1},
	{3039, 2},
	{2781, 2},
	{2929, 2},
	{2955, 2},
	{2957, 2},
	{2961, 2},
	{2963, 2},
	{2993, 2},
	{1408, 2},
	{3012, 2},
	{3014, 2},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{3044, 1},
	{3045, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{3046, 1},
	{3046, 1},
	{3047, 2},
	{3049, 2},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{3051, 1},
	{3052, 1},
	{3053, 1},
	{3054, 1},
	{3055, 1},
	{3056, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{3055, 1},
	{3056, 1},
	{3057, 1},
	{3058, 1},
	{3059, 2},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{3061, 2},
	{3063, 2},
	{0, 0},
	{0, 0},
	{0, 0},
	{7, 2},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{819, 1},
	{1325, 1},
	{1297, 1},
	{1346, 1},
	{1009, 1},
	{1322, 1},
	{1009, 1},
	{1310, 2},
	{1059, 1},
	{1064, 1},
	{1074, 1},
	{1082, 1},
	{1305, 1},
	{1037, 1},
	{1345, 1},
	{1384, 1},
	{3070, 1},
	{1402, 1},
	{3038, 1},
	{1280, 1},
	{1060, 2},
	{838, 1},
	{1040, 2},
	{1006, 1},
	{1037, 1},
	{1331, 1},
	{1042, 1},
	{1048, 1},
	{1082, 1},
	{3073, 1},
	{850, 1},
	{850, 1},
	{1033, 1},
	{1059, 1},
	{1344, 1},
	{848, 1},
	{1081, 1},
	{1321, 1},
	{3074, 1},
	{3075, 1},
	{3037, 1},
	{3016, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{679, 1},
	{797, 1},
	{694, 1},
	{816, 1},
	{694, 1},
	{816, 1},
	{694, 1},
	{816, 1},
	{695, 1},
	{819, 1},
	{698, 1},
	{826, 1},
	{698, 1},
	{826, 1},
	{698, 1},
	{826, 1},
	{698, 1},
	{826, 1},
	{698, 1},
	{826, 1},
	{703, 1},
	{837, 1},
	{703, 1},
	{837, 1},
	{703, 1},
	{837, 1},
	{703, 1},
	{837, 1},
	{703, 1},
	{837, 1},
	{704, 1},
	{838, 1},
	{708, 1},
	{848, 1},
	{711, 1},
	{849, 1},
	{711, 1},
	{849, 1},
	{711, 1},
	{849, 1},
	{711, 1},
	{849, 1},
	{711, 1},
	{849, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{715, 1},
	{1005, 1},
	{715, 1},
	{1005, 1},
	{715, 1},
	{1005, 1},
	{718, 1},
	{850, 1},
	{718, 1},
	{850, 1},
	{718, 1},
	{850, 1},
	{718, 1},
	{850, 1},
	{723, 1},
	{1040, 2},
	{723, 1},
	{1040, 2},
	{723, 1},
	{1040, 2},
	{726, 1},
	{1006, 1},
	{726, 1},
	{1006, 1},
	{726, 1},
	{1006, 1},
	{726, 1},
	{1006, 1},
	{733, 1},
	{1009, 1},
	{733, 1},
	{1009, 1},
	{733, 1},
	{1009, 1},
	{733, 1},
	{1009, 1},
	{746, 1},
	{1033, 1},
	{746, 1},
	{1033, 1},
	{752, 1},
	{1037, 1},
	{752, 1},
	{1037, 1},
	{752, 1},
	{1037, 1},
	{752, 1},
	{1037, 1},
	{755, 1},
	{1042, 1},
	{755, 1},
	{1042, 1},
	{755, 1},
	{1042, 1},
	{755, 1},
	{1042, 1},
	{755, 1},
	{1042, 1},
	{756, 1},
	{1048, 1},
	{756, 1},
	{1048, 1},
	{756, 1},
	{1048, 1},
	{756, 1},
	{1048, 1},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{767, 1},
	{1064, 1},
	{767, 1},
	{1064, 1},
	{781, 1},
	{1074, 1},
	{781, 1},
	{1074, 1},
	{781, 1},
	{1074, 1},
	{781, 1},
	{1074, 1},
	{781, 1},
	{1074, 1},
	{782, 1},
	{1075, 1},
	{782, 1},
	{1075, 1},
	{788, 1},
	{1081, 1},
	{789, 1},
	{1082, 1},
	{789, 1},
	{1082, 1},
	{789, 1},
	{1082, 1},
	{849, 1},
	{1048, 1},
	{1074, 1},
	{1081, 1},
	{797, 1},
	{838, 1},
	{838, 1},
	{679, 1},
	{797, 1},
	{679, 1},
	{797, 1},
	{679, 1},
	{797, 1},
	{679, 1},
	{797, 1},
	{679, 1},
	{797, 1},
	{679, 1},
	{797, 1},
	{679, 1},
	{797, 1},
	{679, 1},
	{797, 1},
	{679, 1},
	{797, 1},
	{679, 1},
	{797, 1},
	{679, 1},
	{797, 1},
	{679, 1},
	{797, 1},
	{703, 1},
	{837, 1},
	{703, 1},
	{837, 1},
	{703, 1},
	{837, 1},
	{703, 1},
	{837, 1},
	{703, 1},
	{837, 1},
	{703, 1},
	{837, 1},
	{703, 1},
	{837, 1},
	{703, 1},
	{837, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{733, 1},
	{1009, 1},
	{733, 1},
	{1009, 1},
	{733, 1},
	{1009, 1},
	{733, 1},
	{1009, 1},
	{733, 1},
	{1009, 1},
	{733, 1},
	{1009, 1},
	{733, 1},
	{1009, 1},
	{734, 2},
	{1010, 2},
	{734, 2},
	{1010, 2},
	{734, 2},
	{1010, 2},
	{734, 2},
	{1010, 2},
	{734, 2},
	{1010, 2},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{762, 1},
	{1059, 1},
	{788, 1},
	{1081, 1},
	{788, 1},
	{1081, 1},
	{788, 1},
	{1081, 1},
	{788, 1},
	{1081, 1},
	{1081, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{679, 1},
	{679, 1},
	{679, 1},
	{679, 1},
	{679, 1},
	{679, 1},
	{679, 1},
	{679, 1},
	{4419, 1},
	{4419, 1},
	{4419, 1},
	{4419, 1},
	{4419, 1},
	{4419, 1},
	{703, 1},
	{703, 1},
	{703, 1},
	{703, 1},
	{703, 1},
	{703, 1},
	{1006, 1},
	{1006, 1},
	{1006, 1},
	{1006, 1},
	{1006, 1},
	{1006, 1},
	{1006, 1},
	{1006, 1},
	{711, 1},
	{711, 1},
	{711, 1},
	{711, 1},
	{711, 1},
	{711, 1},
	{711, 1},
	{711, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{733, 1},
	{733, 1},
	{733, 1},
	{733, 1},
	{733, 1},
	{733, 1},
	{1059, 1},
	{1059, 1},
	{1059, 1},
	{1059, 1},
	{1059, 1},
	{1059, 1},
	{1059, 1},
	{1059, 1},
	{788, 1},
	{788, 1},
	{788, 1},
	{788, 1},
	{1388, 1},
	{1388, 1},
	{1388, 1},
	{1388, 1},
	{1388, 1},
	{1388, 1},
	{1388, 1},
	{1388, 1},
	{1379, 1},
	{1379, 1},
	{1379, 1},
	{1379, 1},
	{1379, 1},
	{1379, 1},
	{1379, 1},
	{1379, 1},
	{797, 1},
	{797, 1},
	{4419, 1},
	{4419, 1},
	{1006, 1},
	{1006, 1},
	{850, 1},
	{850, 1},
	{1009, 1},
	{1009, 1},
	{1059, 1},
	{1059, 1},
	{1388, 1},
	{1388, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{679, 1},
	{679, 1},
	{679, 1},
	{679, 1},
	{679, 1},
	{679, 1},
	{679, 1},
	{679, 1},
	{1006, 1},
	{1006, 1},
	{1006, 1},
	{1006, 1},
	{1006, 1},
	{1006, 1},
	{1006, 1},
	{1006, 1},
	{711, 1},
	{711, 1},
	{711, 1},
	{711, 1},
	{711, 1},
	{711, 1},
	{711, 1},
	{711, 1},
	{1388, 1},
	{1388, 1},
	{1388, 1},
	{1388, 1},
	{1388, 1},
	{1388, 1},
	{1388, 1},
	{1388, 1},
	{1379, 1},
	{1379, 1},
	{1379, 1},
	{1379, 1},
	{1379, 1},
	{1379, 1},
	{1379, 1},
	{1379, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{797, 1},
	{679, 1},
	{679, 1},
	{679, 1},
	{679, 1},
	{679, 1},
	{6, 1},
	{850, 1},
	{6, 1},
	{1085, 1},
	{1087, 1},
	{1006, 1},
	{1006, 1},
	{1006, 1},
	{1006, 1},
	{1006, 1},
	{703, 1},
	{703, 1},
	{711, 1},
	{711, 1},
	{711, 1},
	{6, 1},
	{6, 1},
	{6, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{850, 1},
	{6, 1},
	{6, 1},
	{6, 1},
	{1059, 1},
	{1059, 1},
	{1059, 1},
	{1059, 1},
	{1033, 1},
	{1033, 1},
	{1059, 1},
	{1059, 1},
	{788, 1},
	{788, 1},
	{788, 1},
	{788, 1},
	{746, 1},
	{1087, 1},
	{1087, 1},
	{6, 1},
	{1388, 1},
	{1388, 1},
	{1388, 1},
	{1388, 1},
	{2762, 1},
	{733, 1},
	{733, 1},
	{1379, 1},
	{1379, 1},
	{1379, 1},
	{6, 1},
	{6, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{482, 1},
	{482, 1},
	{482, 1},
	{482, 1},
	{3261, 1},
	{3261, 1},
	{952, 2},
	{6, 1},
	{6, 1},
	{481, 1},
	{6, 1},
	{7, 2},
	{7, 2},
	{7, 2},
	{1096, 1},
	{485, 1},
	{488, 2},
	{490, 3},
	{1096, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{1284, 4},
	{1288, 5},
	{6, 1},
	{7, 2},
	{9, 3},
	{6, 1},
	{7, 2},
	{9, 3},
	{650, 1},
	{664, 1},
	{1, 2},
	{1355, 1},
	{493, 1},
	{482, 1},
	{493, 1},
	{677, 2},
	{675, 2},
	{3, 2},
	{477, 1},
	{1281, 3},
	{1085, 1},
	{12, 4},
	{643, 1},
	{3217, 1},
	{3216, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{1280, 1},
	{4415, 1},
	{695, 1},
	{1086, 1},
	{1040, 2},
	{753, 2},
	{781, 1},
	{826, 1},
	{4418, 1},
	{715, 1},
	{756, 1},
	{976, 2},
	{1420, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{798, 3},
	{801, 3},
	{695, 1},
	{1091, 2},
	{820, 3},
	{823, 3},
	{1304, 1},
	{1400, 1},
	{1093, 2},
	{848, 1},
	{711, 1},
	{711, 1},
	{711, 1},
	{849, 1},
	{849, 1},
	{850, 1},
	{850, 1},
	{718, 1},
	{850, 1},
	{726, 1},
	{731, 2},
	{746, 1},
	{749, 1},
	{752, 1},
	{752, 1},
	{752, 1},
	{759, 3},
	{789, 1},
	{1379, 1},
	{1308, 1},
	{789, 1},
	{1332, 1},
	{715, 1},
	{679, 1},
	{694, 1},
	{695, 1},
	{837, 1},
	{837, 1},
	{703, 1},
	{704, 1},
	{723, 1},
	{1009, 1},
	{1435, 1},
	{1438, 1},
	{1439, 1},
	{1440, 1},
	{850, 1},
	{705, 3},
	{1384, 1},
	{1081, 1},
	{1365, 1},
	{1376, 1},
	{1306, 1},
	{4405, 1},
	{4406, 1},
	{4508, 1},
	{698, 1},
	{826, 1},
	{837, 1},
	{850, 1},
	{1004, 1},
	{850, 1},
	{952, 2},
	{960, 3},
	{948, 2},
	{767, 1},
	{770, 2},
	{772, 3},
	{775, 4},
	{950, 2},
	{782, 1},
	{783, 2},
	{785, 3},
	{718, 1},
	{695, 1},
	{698, 1},
	{723, 1},
	{850, 1},
	{952, 2},
	{960, 3},
	{978, 2},
	{1064, 1},
	{1065, 2},
	{1067, 3},
	{1070, 4},
	{980, 2},
	{1075, 1},
	{1076, 2},
	{1078, 3},
	{850, 1},
	{819, 1},
	{826, 1},
	{1040, 2},
	{1301, 1},
	{1322, 1},
	{3022, 1},
	{3032, 1},
	{3083, 1},
	{3084, 1},
	{3085, 1},
	{3090, 1},
	{3028, 1},
	{3023, 1},
	{3095, 1},
	{3097, 1},
	{3096, 1},
	{3209, 1},
	{1302, 1},
	{1302, 1},
	{1370, 1},
	{3101, 1},
	{3102, 1},
	{1376, 1},
	{1306, 1},
	{482, 1},
	{478, 1},
	{493, 1},
	{790, 1},
	{477, 1},
	{1090, 1},
	{1096, 1},
	{1014, 2},
	{850, 1},
	{850, 1},
	{952, 2},
	{952, 2},
	{1064, 1},
	{1415, 1},
	{762, 1},
	{1334, 1},
	{1335, 2},
	{1337, 3},
	{3107, 2},
	{3109, 3},
	{643, 1},
	{482, 1},
	{1085, 1},
	{1085, 1},
	{3115, 1},
	{3116, 1},
	{3117, 1},
	{658, 1},
	{658, 1},
	{658, 1},
	{658, 1},
	{658, 1},
	{658, 1},
	{658, 1},
	{3120, 1},
	{3120, 1},
	{651, 2},
	{667, 2},
	{3118, 1},
	{650, 1},
	{664, 1},
	{3121, 1},
	{3122, 1},
	{3123, 1},
	{3124, 1},
	{3125, 1},
	{3126, 1},
	{3127, 1},
	{3128, 1},
	{2805, 1},
	{2794, 1},
	{2805, 1},
	{2794, 1},
	{3131, 1},
	{3132, 1},
	{4439, 1},
	{733, 1},
	{1347, 1},
	{733, 1},
	{756, 1},
	{4403, 1},
	{3145, 1},
	{3146, 1},
	{3147, 1},
	{3148, 1},
	{3106, 1},
	{1064, 1},
	{1415, 1},
	{762, 1},
	{3029, 1},
	{1096, 1},
	{3030, 1},
	{656, 2},
	{1101, 2},
	{653, 3},
	{669, 3},
	{3129, 1},
	{3130, 1},
	{3137, 1},
	{3138, 1},
	{3149, 1},
	{3150, 1},
	{3151, 1},
	{3152, 1},
	{3217, 1},
	{1115, 3},
	{4419, 1},
	{703, 1},
	{3099, 1},
	{3157, 1},
	{3190, 1},
	{3191, 1},
	{3219, 1},
	{1370, 1},
	{3029, 1},
	{1090, 1},
	{3142, 1},
	{756, 1},
	{3100, 1},
	{3153, 1},
	{1090, 1},
	{1085, 1},
	{2789, 1},
	{3100, 1},
	{733, 1},
	{850, 1},
	{1033, 1},
	{1388, 1},
	{797, 1},
	{4419, 1},
	{850, 1},
	{1388, 1},
	{797, 1},
	{3020, 1},
	{3363, 1},
	{3363, 1},
	{3363, 1},
	{3363, 1},
	{3363, 1},
	{3363, 1},
	{3164, 1},
	{3163, 1},
	{3162, 1},
	{3166, 1},
	{3077, 2},
	{3175, 1},
	{850, 1},
	{3189, 1},
	{791, 2},
	{3192, 1},
	{3193, 1},
	{3194, 1},
	{3195, 1},
	{3196, 1},
	{3197, 1},
	{3198, 1},
	{3199, 1},
	{3200, 1},
	{3201, 1},
	{158, 3},
	{31, 3},
	{38, 3},
	{41, 3},
	{44, 3},
	{47, 3},
	{50, 3},
	{53, 3},
	{56, 3},
	{193, 4},
	{197, 4},
	{161, 4},
	{165, 4},
	{169, 4},
	{173, 4},
	{177, 4},
	{181, 4},
	{185, 4},
	{189, 4},
	{34, 4},
	{855, 2},
	{502, 2},
	{561, 2},
	{578, 2},
	{591, 2},
	{602, 2},
	{613, 2},
	{624, 2},
	{635, 2},
	{936, 3},
	{954, 3},
	{857, 3},
	{869, 3},
	{878, 3},
	{887, 3},
	{896, 3},
	{905, 3},
	{914, 3},
	{923, 3},
	{537, 3},
	{134, 3},
	{137, 3},
	{140, 3},
	{143, 3},
	{146, 3},
	{149, 3},
	{152, 3},
	{155, 3},
	{158, 3},
	{201, 3},
	{204, 3},
	{158, 3},
	{222, 4},
	{207, 3},
	{210, 3},
	{213, 3},
	{216, 3},
	{219, 3},
	{226, 3},
	{229, 3},
	{232, 3},
	{235, 3},
	{238, 3},
	{241, 3},
	{244, 3},
	{247, 3},
	{1088, 1},
	{3080, 1},
	{1089, 1},
	{3176, 1},
	{3261, 1},
	{3261, 1},
	{3177, 1},
	{3178, 1},
	{3179, 1},
	{493, 1},
	{782, 1},
	{3103, 1},
	{3180, 1},
	{1355, 1},
	{3181, 1},
	{3182, 1},
	{3103, 1},
	{3174, 1},
	{1370, 1},
	{3150, 1},
	{3185, 1},
	{3185, 1},
	{4440, 1},
	{3149, 1},
	{3029, 1},
	{3029, 1},
	{1090, 1},
	{3159, 1},
	{3155, 1},
	{1090, 1},
	{1347, 1},
	{3183, 1},
	{4448, 1},
	{3213, 1},
	{3167, 1},
	{3119, 1},
	{3029, 1},
	{4510, 1},
	{4510, 1},
	{2061, 1},
	{28, 1},
	{474, 1},
	{650, 1},
	{664, 1},
	{28, 1},
	{474, 1},
	{1083, 1},
	{1084, 1},
	{478, 1},
	{482, 1},
	{1295, 1},
	{4403, 1},
	{793, 2},
	{2797, 2},
	{493, 1},
	{790, 1},
	{756, 1},
	{3190, 1},
	{3191, 1},
	{0, 0},
	{1075, 1},
	{1075, 1},
	{3024, 2},
	{3093, 2},
	{3026, 2},
	{3091, 2},
	{3216, 1},
	{3161, 1},
	{3159, 1},
	{3219, 1},
	{3160, 1},
	{3158, 1},
	{4441, 1},
	{3204, 1},
	{647, 2},
	{790, 1},
	{493, 1},
	{493, 1},
	{790, 1},
	{1347, 1},
	{4439, 1},
	{3141, 1},
	{3133, 1},
	{3134, 1},
	{3139, 1},
	{3140, 1},
	{1340, 4},
	{3030, 1},
	{667, 2},
	{3028, 1},
	{478, 1},
	{478, 1},
	{478, 1},
	{478, 1},
	{478, 1},
	{479, 2},
	{482, 1},
	{482, 1},
	{1075, 1},
	{1075, 1},
	{3156, 1},
	{3206, 1},
	{3104, 1},
	{1085, 1},
	{658, 1},
	{644, 3},
	{659, 2},
	{661, 3},
	{665, 2},
	{3010, 1},
	{3009, 1},
	{2801, 2},
	{3207, 1},
	{496, 3},
	{494, 2},
	{3086, 1},
	{3087, 1},
	{3088, 1},
	{3089, 1},
	{711, 1},
	{715, 1},
	{1365, 1},
	{1037, 1},
	{1370, 1},
	{4418, 1},
	{4419, 1},
	{711, 1},
	{850, 1},
	{715, 1},
	{1297, 1},
	{1381, 1},
	{723, 1},
	{726, 1},
	{733, 1},
	{1009, 1},
	{1376, 1},
	{746, 1},
	{1033, 1},
	{695, 1},
	{819, 1},
	{756, 1},
	{788, 1},
	{1377, 1},
	{1330, 1},
	{782, 1},
	{1386, 1},
	{1378, 1},
	{1388, 1},
	{656, 2},
	{482, 1},
	{1397, 1},
	{1404, 1},
	{493, 1},
	{632, 1},
	{558, 1},
	{1315, 1},
	{718, 1},
	{1351, 1},
	{599, 1},
	{1392, 1},
	{1389, 1},
	{3186, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{791, 2},
	{733, 1},
	{1318, 1},
	{767, 1},
	{703, 1},
	{1302, 1},
	{733, 1},
	{1115, 3},
	{1306, 1},
	{850, 1},
	{0, 1},
	{733, 1},
	{749, 1},
	{1347, 1},
	{782, 1},
	{1370, 1},
	{3033, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{482, 1},
	{1085, 1},
	{1085, 1},
	{2805, 1},
	{2794, 1},
	{29, 2},
	{475, 2},
	{3113, 1},
	{3112, 1},
	{3114, 1},
	{1459, 1},
	{1090, 1},
	{1096, 1},
	{1457, 1},
	{1458, 1},
	{3076, 1},
	{3216, 1},
	{1095, 1},
	{658, 1},
	{3404, 1},
	{3403, 1},
	{3413, 1},
	{3464, 1},
	{3286, 1},
	{3433, 1},
	{3605, 1},
	{3604, 1},
	{3629, 1},
	{3638, 1},
	{3657, 1},
	{3669, 1},
	{3297, 1},
	{3706, 1},
	{3736, 1},
	{3749, 1},
	{3813, 1},
	{3820, 1},
	{3824, 1},
	{3827, 1},
	{3828, 1},
	{3873, 1},
	{3891, 1},
	{3396, 1},
	{3904, 1},
	{4045, 1},
	{3979, 1},
	{4025, 1},
	{4046, 1},
	{4045, 1},
	{4057, 1},
	{4068, 1},
	{4093, 1},
	{4093, 1},
	{4093, 1},
	{4135, 1},
	{4157, 1},
	{4170, 1},
	{4169, 1},
	{4174, 1},
	{4193, 1},
	{4208, 1},
	{4229, 1},
	{4234, 1},
	{4234, 1},
	{4276, 1},
	{4266, 1},
	{4267, 1},
	{4268, 1},
	{4269, 1},
	{4274, 1},
	{4276, 1},
	{4298, 1},
	{4306, 1},
	{4316, 1},
	{4318, 1},
	{4320, 1},
	{4321, 1},
	{4322, 1},
	{4328, 1},
	{4337, 1},
	{4345, 1},
	{4350, 1},
	{4363, 1},
	{4366, 1},
	{3742, 1},
	{4382, 1},
	{3809, 1},
	{4384, 1},
	{4006, 1},
	{4387, 1},
	{3405, 1},
	{4389, 1},
	{3261, 1},
	{3363, 1},
	{790, 1},
	{493, 1},
	{3402, 1},
	{3407, 1},
	{3409, 1},
	{3410, 1},
	{3412, 1},
	{3432, 1},
	{3438, 1},
	{3442, 1},
	{3446, 1},
	{3450, 1},
	{3453, 1},
	{3461, 1},
	{3462, 1},
	{3463, 1},
	{3475, 1},
	{3484, 1},
	{3488, 1},
	{3490, 1},
	{3491, 1},
	{3493, 1},
	{3501, 1},
	{3502, 1},
	{3507, 1},
	{3508, 1},
	{3510, 1},
	{3513, 1},
	{3513, 1},
	{3548, 1},
	{3548, 1},
	{3568, 1},
	{3570, 1},
	{3571, 1},
	{3574, 1},
	{3580, 1},
	{3592, 1},
	{3593, 1},
	{3600, 1},
	{3603, 1},
	{3604, 1},
	{3606, 1},
	{3612, 1},
	{3613, 1},
	{3624, 1},
	{3627, 1},
	{3628, 1},
	{3631, 1},
	{3636, 1},
	{3638, 1},
	{3639, 1},
	{3650, 1},
	{3651, 1},
	{3653, 1},
	{3654, 1},
	{3656, 1},
	{3659, 1},
	{3663, 1},
	{3668, 1},
	{3699, 1},
	{3704, 1},
	{3705, 1},
	{3734, 1},
	{3735, 1},
	{3741, 1},
	{3743, 1},
	{3745, 1},
	{3746, 1},
	{3748, 1},
	{3752, 1},
	{3762, 1},
	{3766, 1},
	{3776, 1},
	{3805, 1},
	{3808, 1},
	{3812, 1},
	{3816, 1},
	{3819, 1},
	{3821, 1},
	{3822, 1},
	{3823, 1},
	{3825, 1},
	{3826, 1},
	{3872, 1},
	{3890, 1},
	{3893, 1},
	{3894, 1},
	{3895, 1},
	{3896, 1},
	{3898, 1},
	{3899, 1},
	{3903, 1},
	{3911, 1},
	{3913, 1},
	{3929, 1},
	{3930, 1},
	{3932, 1},
	{3933, 1},
	{3935, 1},
	{3936, 1},
	{3942, 1},
	{3943, 1},
	{3950, 1},
	{3951, 1},
	{3952, 1},
	{3953, 1},
	{3957, 1},
	{3966, 1},
	{3967, 1},
	{3968, 1},
	{3978, 1},
	{3994, 1},
	{3995, 1},
	{4002, 1},
	{4005, 1},
	{4008, 1},
	{4015, 1},
	{4024, 1},
	{4042, 1},
	{4044, 1},
	{4051, 1},
	{4054, 1},
	{4056, 1},
	{4059, 1},
	{4060, 1},
	{4061, 1},
	{4067, 1},
	{4069, 1},
	{4077, 1},
	{4079, 1},
	{4081, 1},
	{4082, 1},
	{4085, 1},
	{4087, 1},
	{4088, 1},
	{4089, 1},
	{4091, 1},
	{4092, 1},
	{4134, 1},
	{4140, 1},
	{4153, 1},
	{4154, 1},
	{4156, 1},
	{4168, 1},
	{4172, 1},
	{4175, 1},
	{4176, 1},
	{4194, 1},
	{4195, 1},
	{4197, 1},
	{4199, 1},
	{4200, 1},
	{4209, 1},
	{4210, 1},
	{4213, 1},
	{4220, 1},
	{4221, 1},
	{4230, 1},
	{4232, 1},
	{4233, 1},
	{4240, 1},
	{4247, 1},
	{4251, 1},
	{4252, 1},
	{4254, 1},
	{4267, 1},
	{4270, 1},
	{4275, 1},
	{4285, 1},
	{4287, 1},
	{4291, 1},
	{4297, 1},
	{4300, 1},
	{4301, 1},
	{4302, 1},
	{4303, 1},
	{4307, 1},
	{4308, 1},
	{4310, 1},
	{4317, 1},
	{4319, 1},
	{4321, 1},
	{4329, 1},
	{4330, 1},
	{4332, 1},
	{4338, 1},
	{4339, 1},
	{4340, 1},
	{4342, 1},
	{4343, 1},
	{4344, 1},
	{4345, 1},
	{4346, 1},
	{4351, 1},
	{4358, 1},
	{4359, 1},
	{4362, 1},
	{4364, 1},
	{4365, 1},
	{4367, 1},
	{4369, 1},
	{4370, 1},
	{4371, 1},
	{4374, 1},
	{4376, 1},
	{4378, 1},
	{4379, 1},
	{4381, 1},
	{4383, 1},
	{4385, 1},
	{4388, 1},
	{4390, 1},
	{0, 0},
	{1364, 1},
	{7, 2},
	{733, 1},
	{3190, 1},
	{3191, 1},
	{3079, 1},
	{28, 1},
	{474, 1},
	{3202, 1},
	{3203, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{493, 1},
	{3079, 1},
	{3493, 1},
	{3494, 1},
	{3495, 1},
	{3221, 1},
	{3222, 1},
	{3190, 1},
	{3190, 1},
	{3223, 1},
	{3224, 1},
	{3225, 1},
	{3226, 1},
	{3227, 1},
	{3228, 1},
	{3229, 1},
	{3230, 1},
	{3231, 1},
	{3232, 1},
	{3233, 1},
	{3234, 1},
	{3235, 1},
	{3235, 1},
	{3236, 1},
	{3236, 1},
	{3237, 1},
	{3237, 1},
	{3238, 1},
	{3238, 1},
	{3239, 1},
	{3239, 1},
	{3220, 1},
	{0, 0},
	{0, 0},
	{4437, 1},
	{4438, 1},
	{3240, 1},
	{658, 1},
	{3413, 1},
	{3627, 1},
	{3475, 1},
	{3475, 1},
	{3242, 1},
	{3243, 1},
	{3244, 1},
	{3245, 1},
	{3246, 1},
	{3247, 1},
	{3248, 1},
	{3249, 1},
	{3250, 1},
	{3571, 1},
	{3571, 1},
	{3251, 1},
	{3252, 1},
	{3253, 1},
	{3501, 1},
	{3501, 1},
	{3409, 1},
	{493, 1},
	{3442, 1},
	{3442, 1},
	{3442, 1},
	{3254, 1},
	{3254, 1},
	{3255, 1},
	{3255, 1},
	{3238, 1},
	{3238, 1},
	{3238, 1},
	{3256, 1},
	{3256, 1},
	{3513, 1},
	{3241, 1},
	{3257, 1},
	{3258, 1},
	{3259, 1},
	{3260, 1},
	{1096, 1},
	{3280, 1},
	{2224, 1},
	{2225, 2},
	{2235, 2},
	{2246, 1},
	{2259, 2},
	{2265, 2},
	{2269, 1},
	{2272, 2},
	{2294, 1},
	{2295, 2},
	{2321, 2},
	{2332, 2},
	{2352, 2},
	{2363, 2},
	{2365, 2},
	{2367, 2},
	{2378, 1},
	{2412, 1},
	{2426, 2},
	{2431, 2},
	{2465, 1},
	{2484, 2},
	{2512, 1},
	{2544, 1},
	{2552, 2},
	{2557, 1},
	{2562, 1},
	{2563, 1},
	{2566, 1},
	{2577, 1},
	{2613, 1},
	{2620, 2},
	{2622, 1},
	{2629, 2},
	{2631, 1},
	{2638, 2},
	{2640, 1},
	{2647, 2},
	{2649, 1},
	{2650, 2},
	{2652, 3},
	{2677, 2},
	{2679, 1},
	{2696, 1},
	{2702, 2},
	{2707, 3},
	{2717, 2},
	{2722, 1},
	{3261, 1},
	{3275, 2},
	{3363, 1},
	{2612, 1},
	{2249, 2},
	{2251, 2},
	{2257, 2},
	{2267, 2},
	{2300, 3},
	{2308, 2},
	{2340, 3},
	{2369, 2},
	{2373, 2},
	{2392, 2},
	{2397, 2},
	{2410, 2},
	{2402, 2},
	{2413, 2},
	{2417, 2},
	{2433, 3},
	{2436, 3},
	{2453, 2},
	{2459, 2},
	{2451, 2},
	{2428, 3},
	{2466, 2},
	{2468, 2},
	{2470, 2},
	{2476, 2},
	{2500, 2},
	{2594, 1},
	{2528, 2},
	{2600, 1},
	{2526, 2},
	{2542, 2},
	{2571, 2},
	{2588, 2},
	{2609, 1},
	{2685, 2},
	{2687, 3},
	{2694, 2},
	{2733, 2},
	{2735, 3},
	{2742, 2},
	{2744, 1},
	{2756, 2},
	{3261, 1},
	{3363, 1},
	{493, 1},
	{790, 1},
	{3404, 1},
	{3407, 1},
	{3190, 1},
	{3403, 1},
	{3402, 1},
	{250, 3},
	{253, 3},
	{256, 3},
	{259, 3},
	{262, 3},
	{265, 3},
	{268, 3},
	{271, 3},
	{274, 3},
	{277, 3},
	{280, 3},
	{283, 3},
	{286, 3},
	{289, 3},
	{421, 3},
	{424, 3},
	{427, 3},
	{430, 3},
	{433, 3},
	{436, 3},
	{439, 3},
	{442, 3},
	{453, 3},
	{459, 3},
	{462, 3},
	{465, 3},
	{468, 3},
	{471, 3},
	{456, 3},
	{445, 4},
	{449, 4},
	{292, 3},
	{304, 3},
	{298, 3},
	{343, 3},
	{307, 3},
	{322, 3},
	{295, 3},
	{319, 3},
	{301, 3},
	{331, 3},
	{364, 3},
	{382, 3},
	{379, 3},
	{370, 3},
	{418, 3},
	{346, 3},
	{361, 3},
	{376, 3},
	{367, 3},
	{397, 3},
	{337, 3},
	{388, 3},
	{412, 3},
	{400, 3},
	{325, 3},
	{310, 3},
	{340, 3},
	{349, 3},
	{394, 3},
	{313, 3},
	{415, 3},
	{334, 3},
	{403, 3},
	{316, 3},
	{406, 3},
	{409, 3},
	{1000, 2},
	{554, 2},
	{571, 2},
	{584, 2},
	{595, 2},
	{606, 2},
	{617, 2},
	{628, 2},
	{639, 2},
	{942, 3},
	{966, 3},
	{863, 3},
	{744, 2},
	{1002, 2},
	{556, 2},
	{573, 2},
	{586, 2},
	{597, 2},
	{608, 2},
	{619, 2},
	{630, 2},
	{641, 2},
	{945, 3},
	{969, 3},
	{866, 3},
	{875, 3},
	{884, 3},
	{893, 3},
	{902, 3},
	{911, 3},
	{920, 3},
	{929, 3},
	{543, 3},
	{549, 3},
	{507, 3},
	{513, 3},
	{519, 3},
	{998, 2},
	{552, 2},
	{569, 2},
	{582, 2},
	{593, 2},
	{604, 2},
	{615, 2},
	{626, 2},
	{637, 2},
	{939, 3},
	{963, 3},
	{860, 3},
	{872, 3},
	{881, 3},
	{890, 3},
	{899, 3},
	{908, 3},
	{917, 3},
	{926, 3},
	{540, 3},
	{546, 3},
	{504, 3},
	{510, 3},
	{516, 3},
	{522, 3},
	{525, 3},
	{528, 3},
	{531, 3},
	{534, 3},
	{563, 3},
	{566, 3},
	{3288, 1},
	{3287, 1},
	{3309, 1},
	{3261, 1},
	{790, 1},
	{493, 1},
	{3418, 1},
	{3425, 1},
	{3529, 1},
	{3513, 1},
	{3558, 1},
	{3548, 1},
	{3560, 1},
	{3587, 1},
	{3632, 1},
	{3308, 1},
	{3704, 1},
	{3301, 1},
	{3324, 1},
	{3755, 1},
	{3303, 1},
	{3338, 1},
	{3781, 1},
	{3312, 1},
	{3796, 1},
	{3854, 1},
	{3969, 1},
	{4030, 1},
	{3767, 1},
	{3769, 1},
	{3768, 1},
	{3307, 1},
	{3770, 1},
	{3772, 1},
	{4073, 1},
	{3775, 1},
	{4120, 1},
	{4132, 1},
	{3347, 1},
	{4177, 1},
	{4191, 1},
	{4198, 1},
	{4212, 1},
	{4216, 1},
	{4219, 1},
	{4223, 1},
	{4242, 1},
	{4263, 1},
	{4286, 1},
	{4357, 1},
	{4369, 1},
	{3323, 1},
	{4397, 1},
	{4393, 1},
	{4391, 1},
	{4402, 1},
	{4394, 1},
	{4392, 1},
	{4401, 1},
	{4400, 1},
	{4396, 1},
	{4395, 1},
	{4398, 1},
	{4399, 1},
	{694, 1},
	{746, 1},
	{826, 1},
	{698, 1},
	{756, 1},
	{708, 1},
	{715, 1},
	{712, 1},
	{695, 1},
	{1301, 1},
	{789, 1},
	{704, 1},
	{3081, 1},
	{723, 1},
	{726, 1},
	{718, 1},
	{755, 1},
	{752, 1},
	{1318, 1},
	{767, 1},
	{711, 1},
	{781, 1},
	{782, 1},
	{788, 1},
	{3017, 1},
	{679, 1},
	{3209, 1},
	{703, 1},
	{1302, 1},
	{850, 1},
	{733, 1},
	{762, 1},
	{1415, 1},
	{3011, 1},
	{485, 1},
	{481, 1},
	{488, 2},
	{486, 2},
	{643, 1},
	{483, 2},
	{658, 1},
	{485, 1},
	{499, 1},
	{1305, 1},
	{850, 1},
	{1388, 1},
	{1398, 2},
	{1358, 3},
	{1347, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{1354, 1},
	{849, 1},
	{742, 2},
	{1014, 2},
	{4439, 1},
	{0, 0},
	{0, 0},
	{1395, 1},
	{3018, 1},
	{3211, 1},
	{1352, 1},
	{1318, 1},
	{1376, 1},
	{767, 1},
	{674, 1},
	{499, 1},
	{0, 0},
	{0, 0},
	{4410, 2},
	{1363, 1},
	{1362, 1},
	{757, 2},
	{1053, 2},
	{1042, 1},
	{680, 2},
	{804, 2},
	{684, 2},
	{808, 2},
	{688, 2},
	{810, 2},
	{690, 2},
	{812, 2},
	{690, 2},
	{812, 2},
	{692, 2},
	{814, 2},
	{715, 1},
	{733, 1},
	{1009, 1},
	{742, 2},
	{1014, 2},
	{499, 1},
	{1074, 1},
	{558, 1},
	{1315, 1},
	{632, 1},
	{1049, 2},
	{5, 1},
	{4416, 1},
	{643, 1},
	{6, 1},
	{1096, 1},
	{4412, 1},
	{704, 1},
	{838, 1},
	{4445, 1},
	{4446, 1},
	{1349, 1},
	{4404, 1},
	{1059, 1},
	{558, 1},
	{4403, 1},
	{712, 1},
	{782, 1},
	{694, 1},
	{1294, 1},
	{4407, 1},
	{1388, 1},
	{3261, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2054, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2279, 2},
	{2281, 2},
	{2283, 2},
	{2288, 2},
	{2295, 2},
	{2297, 3},
	{2308, 2},
	{2310, 3},
	{2321, 2},
	{2332, 2},
	{2337, 3},
	{2343, 3},
	{2352, 2},
	{2359, 2},
	{2361, 2},
	{2379, 2},
	{2386, 2},
	{2397, 2},
	{2448, 3},
	{2457, 2},
	{2463, 2},
	{2492, 3},
	{2520, 2},
	{2540, 2},
	{2554, 3},
	{2564, 2},
	{2575, 2},
	{2586, 2},
	{2610, 2},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{3208, 1},
	{4423, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{4424, 1},
	{2011, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{4425, 1},
	{4426, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{837, 1},
	{838, 1},
	{1009, 1},
	{1009, 1},
	{1322, 1},
	{1310, 2},
	{1310, 2},
	{1037, 1},
	{1037, 1},
	{1334, 1},
	{1059, 1},
	{1059, 1},
	{1386, 1},
	{1386, 1},
	{1081, 1},
	{1406, 1},
	{1323, 2},
	{1062, 2},
	{3066, 1},
	{1333, 1},
	{3072, 1},
	{1009, 1},
	{850, 1},
	{3065, 1},
	{3068, 1},
	{3067, 1},
	{1317, 1},
	{3212, 1},
	{1037, 1},
	{1074, 1},
	{1346, 1},
	{1350, 1},
	{1009, 1},
	{1327, 1},
	{1082, 1},
	{4419, 1},
	{1059, 1},
	{1298, 1},
	{1333, 1},
	{1064, 1},
	{1042, 1},
	{1351, 1},
	{819, 1},
	{3070, 1},
	{1297, 1},
	{1009, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2665, 2},
	{2672, 3},
	{2680, 2},
	{2682, 3},
	{2690, 2},
	{2710, 2},
	{2719, 3},
	{2725, 3},
	{2738, 2},
	{3262, 2},
	{3264, 2},
	{3266, 3},
	{3269, 2},
	{3368, 3},
	{3371, 3},
	{3374, 2},
	{3376, 3},
	{3381, 3},
	{3384, 2},
	{3388, 2},
	{3394, 2},
	{2745, 2},
	{2749, 3},
	{2253, 2},
	{2261, 2},
	{2272, 2},
	{2274, 3},
	{2281, 2},
	{2283, 2},
	{2285, 3},
	{2288, 2},
	{2290, 2},
	{2292, 2},
	{2297, 3},
	{2303, 3},
	{2318, 3},
	{2329, 3},
	{2334, 3},
	{2346, 3},
	{2371, 2},
	{2375, 3},
	{2357, 2},
	{2381, 2},
	{2383, 3},
	{2390, 2},
	{2394, 3},
	{2404, 2},
	{2417, 2},
	{2421, 3},
	{2424, 2},
	{2426, 2},
	{2436, 3},
	{2453, 2},
	{2455, 2},
	{2474, 2},
	{2481, 3},
	{2486, 3},
	{2489, 3},
	{2510, 2},
	{2500, 2},
	{2502, 2},
	{2506, 2},
	{2367, 2},
	{2595, 2},
	{2597, 3},
	{2601, 2},
	{2603, 2},
	{2545, 2},
	{2547, 3},
	{2552, 2},
	{2569, 2},
	{2573, 2},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{4196, 1},
	{3763, 1},
	{4221, 1},
	{4204, 1},
	{3859, 1},
	{3397, 1},
	{3514, 1},
	{4388, 1},
	{4388, 1},
	{3577, 1},
	{4254, 1},
	{3533, 1},
	{3576, 1},
	{3697, 1},
	{3949, 1},
	{4050, 1},
	{4133, 1},
	{4149, 1},
	{4163, 1},
	{4239, 1},
	{3799, 1},
	{3837, 1},
	{3880, 1},
	{3917, 1},
	{4117, 1},
	{4248, 1},
	{4334, 1},
	{3406, 1},
	{3504, 1},
	{3804, 1},
	{3888, 1},
	{4131, 1},
	{4356, 1},
	{3618, 1},
	{3866, 1},
	{4127, 1},
	{4167, 1},
	{3709, 1},
	{4076, 1},
	{4152, 1},
	{3645, 1},
	{3771, 1},
	{3843, 1},
	{3907, 1},
	{4242, 1},
	{3420, 1},
	{3456, 1},
	{3481, 1},
	{3733, 1},
	{3802, 1},
	{3887, 1},
	{3956, 1},
	{4056, 1},
	{4129, 1},
	{4137, 1},
	{4217, 1},
	{4295, 1},
	{4347, 1},
	{4355, 1},
	{3972, 1},
	{3989, 1},
	{4033, 1},
	{4110, 1},
	{4261, 1},
	{4359, 1},
	{4183, 1},
	{3564, 1},
	{3652, 1},
	{4014, 1},
	{4066, 1},
	{3900, 1},
	{3974, 1},
	{4203, 1},
	{4293, 1},
	{3563, 1},
	{3609, 1},
	{3800, 1},
	{3848, 1},
	{3861, 1},
	{4029, 1},
	{4039, 1},
	{4278, 1},
	{3480, 1},
	{4070, 1},
	{3459, 1},
	{3458, 1},
	{3998, 1},
	{4034, 1},
	{4116, 1},
	{4280, 1},
	{4190, 1},
	{3710, 1},
	{3799, 1},
	{4186, 1},
	{3399, 1},
	{3597, 1},
	{3674, 1},
	{3912, 1},
	{3941, 1},
	{3489, 1},
	{3976, 1},
	{3424, 1},
	{3666, 1},
	{3361, 1},
	{3833, 1},
	{3740, 1},
	{4028, 1},
	{3509, 1},
	{3557, 1},
	{3959, 1},
	{4118, 1},
	{4179, 1},
	{3817, 1},
	{4232, 1},
	{3831, 1},
	{3714, 1},
	{4100, 1},
	{3720, 1},
	{3940, 1},
	{3411, 1},
	{3441, 1},
	{3457, 1},
	{3790, 1},
	{4022, 1},
	{4090, 1},
	{4182, 1},
	{4253, 1},
	{3483, 1},
	{3521, 1},
	{3580, 1},
	{3649, 1},
	{3747, 1},
	{3867, 1},
	{3977, 1},
	{4272, 1},
	{4336, 1},
	{4360, 1},
	{4368, 1},
	{3475, 1},
	{3761, 1},
	{3811, 1},
	{4228, 1},
	{3637, 1},
	{3691, 1},
	{3698, 1},
	{3731, 1},
	{3863, 1},
	{3882, 1},
	{3926, 1},
	{3996, 1},
	{4036, 1},
	{4064, 1},
	{4224, 1},
	{4121, 1},
	{4235, 1},
	{4262, 1},
	{3467, 1},
	{3476, 1},
	{3526, 1},
	{3879, 1},
	{4158, 1},
	{4179, 1},
	{3644, 1},
	{3672, 1},
	{3718, 1},
	{3815, 1},
	{4013, 1},
	{3909, 1},
	{3416, 1},
	{3545, 1},
	{3597, 1},
	{3623, 1},
	{3675, 1},
	{3916, 1},
	{3923, 1},
	{4053, 1},
	{4062, 1},
	{4255, 1},
	{4292, 1},
	{4296, 1},
	{4312, 1},
	{3421, 1},
	{3993, 1},
	{4250, 1},
	{4286, 1},
	{3681, 1},
	{3408, 1},
	{3430, 1},
	{3598, 1},
	{3607, 1},
	{3744, 1},
	{3799, 1},
	{3885, 1},
	{3948, 1},
	{4124, 1},
	{4238, 1},
	{4385, 1},
	{3757, 1},
	{4277, 1},
	{3474, 1},
	{3782, 1},
	{3785, 1},
	{3841, 1},
	{3855, 1},
	{3919, 1},
	{3939, 1},
	{3971, 1},
	{4027, 1},
	{4315, 1},
	{3443, 1},
	{3702, 1},
	{4281, 1},
	{3426, 1},
	{3616, 1},
	{3849, 1},
	{4225, 1},
	{3664, 1},
	{3683, 1},
	{3787, 1},
	{3912, 1},
	{4283, 1},
	{3468, 1},
	{3518, 1},
	{3611, 1},
	{3753, 1},
	{3777, 1},
	{3793, 1},
	{3835, 1},
	{3918, 1},
	{3944, 1},
	{4048, 1},
	{4159, 1},
	{4162, 1},
	{4252, 1},
	{4289, 1},
	{3492, 1},
	{3856, 1},
	{3519, 1},
	{3886, 1},
	{3927, 1},
	{4128, 1},
	{4284, 1},
	{4349, 1},
	{4361, 1},
	{3784, 1},
	{3847, 1},
	{4078, 1},
	{4005, 1},
	{4009, 1},
	{4017, 1},
	{3906, 1},
	{3877, 1},
	{4189, 1},
	{3414, 1},
	{4104, 1},
	{3469, 1},
	{3466, 1},
	{3640, 1},
	{3711, 1},
	{4020, 1},
	{3594, 1},
	{3838, 1},
	{3760, 1},
	{4227, 1},
	{4154, 1},
	{4279, 1},
	{4172, 1},
	{3647, 1},
	{3433, 1},
	{3538, 1},
	{3556, 1},
	{3756, 1},
	{3460, 1},
	{3908, 1},
	{3954, 1},
	{3980, 1},
	{3987, 1},
	{3988, 1},
	{3992, 1},
	{4299, 1},
	{4018, 1},
	{4054, 1},
	{4130, 1},
	{4185, 1},
	{4236, 1},
	{4244, 1},
	{4324, 1},
	{4325, 1},
	{4326, 1},
	{4354, 1},
	{4242, 1},
	{4286, 1},
	{3422, 1},
	{3431, 1},
	{3435, 1},
	{3479, 1},
	{3482, 1},
	{3499, 1},
	{3535, 1},
	{3541, 1},
	{3543, 1},
	{3555, 1},
	{3559, 1},
	{3610, 1},
	{3612, 1},
	{3678, 1},
	{3688, 1},
	{3690, 1},
	{3696, 1},
	{3737, 1},
	{3750, 1},
	{3758, 1},
	{3791, 1},
	{3844, 1},
	{3851, 1},
	{3862, 1},
	{3883, 1},
	{3891, 1},
	{3920, 1},
	{3973, 1},
	{3981, 1},
	{3983, 1},
	{3982, 1},
	{3984, 1},
	{3985, 1},
	{3986, 1},
	{3990, 1},
	{3991, 1},
	{3999, 1},
	{4003, 1},
	{4010, 1},
	{4036, 1},
	{4038, 1},
	{4040, 1},
	{4047, 1},
	{4058, 1},
	{4080, 1},
	{4093, 1},
	{4093, 1},
	{4119, 1},
	{4165, 1},
	{4173, 1},
	{4187, 1},
	{4188, 1},
	{4205, 1},
	{4206, 1},
	{4234, 1},
	{4236, 1},
	{4290, 1},
	{4309, 1},
	{4314, 1},
	{3676, 1},
	{4556, 1},
	{4086, 1},
	{3362, 1},
	{3455, 1},
	{3440, 1},
	{3419, 1},
	{3434, 1},
	{3445, 1},
	{3478, 1},
	{3485, 1},
	{3535, 1},
	{3530, 1},
	{3534, 1},
	{3540, 1},
	{3556, 1},
	{3562, 1},
	{3575, 1},
	{3578, 1},
	{3585, 1},
	{3590, 1},
	{3646, 1},
	{3648, 1},
	{3661, 1},
	{3667, 1},
	{3680, 1},
	{3686, 1},
	{3682, 1},
	{3690, 1},
	{3687, 1},
	{3696, 1},
	{3703, 1},
	{3722, 1},
	{3725, 1},
	{3727, 1},
	{3738, 1},
	{3756, 1},
	{3771, 1},
	{3773, 1},
	{3779, 1},
	{3812, 1},
	{3817, 1},
	{3841, 1},
	{3860, 1},
	{3858, 1},
	{3862, 1},
	{3869, 1},
	{3883, 1},
	{3965, 1},
	{3892, 1},
	{3905, 1},
	{3908, 1},
	{3924, 1},
	{3931, 1},
	{3937, 1},
	{3946, 1},
	{3947, 1},
	{3954, 1},
	{3955, 1},
	{3958, 1},
	{3963, 1},
	{3962, 1},
	{3975, 1},
	{4004, 1},
	{4010, 1},
	{4016, 1},
	{4031, 1},
	{4036, 1},
	{4043, 1},
	{4058, 1},
	{4105, 1},
	{4115, 1},
	{4147, 1},
	{4166, 1},
	{4171, 1},
	{4173, 1},
	{4180, 1},
	{4185, 1},
	{4181, 1},
	{4187, 1},
	{4186, 1},
	{4184, 1},
	{4188, 1},
	{4192, 1},
	{4206, 1},
	{4226, 1},
	{4237, 1},
	{4249, 1},
	{4257, 1},
	{4282, 1},
	{4290, 1},
	{4299, 1},
	{4304, 1},
	{4309, 1},
	{4311, 1},
	{4314, 1},
	{4341, 1},
	{4388, 1},
	{4535, 1},
	{4534, 1},
	{4544, 1},
	{3311, 1},
	{3322, 1},
	{3323, 1},
	{4570, 1},
	{4579, 1},
	{4603, 1},
	{4380, 1},
	{4386, 1},
	{839, 2},
	{844, 2},
	{844, 2},
	{841, 3},
	{841, 3},
	{1046, 2},
	{1431, 2},
	{1425, 2},
	{1427, 2},
	{1433, 2},
	{1429, 2},
	{6, 1},
	{0, 0},
	{7, 2},
	{1449, 1},
	{1435, 1},
	{1440, 1},
	{1441, 1},
	{1444, 1},
	{1445, 1},
	{1446, 1},
	{1454, 1},
	{1456, 1},
	{482, 1},
	{1455, 1},
	{1455, 1},
	{1455, 1},
	{1455, 1},
	{1435, 1},
	{1435, 1},
	{1435, 1},
	{1438, 1},
	{1439, 1},
	{1440, 1},
	{1441, 1},
	{850, 1},
	{1442, 1},
	{1064, 1},
	{6, 1},
	{1443, 1},
	{1444, 1},
	{1445, 1},
	{1447, 1},
	{1448, 1},
	{1009, 1},
	{1450, 1},
	{1451, 1},
	{1452, 1},
	{1453, 1},
	{1454, 1},
	{1455, 1},
	{1456, 1},
	{850, 1},
	{1438, 1},
	{1444, 1},
	{1451, 1},
	{1436, 2},
	{2016, 1},
	{2016, 1},
	{2018, 1},
	{2018, 1},
	{2018, 1},
	{2018, 1},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{2020, 1},
	{2020, 1},
	{2020, 1},
	{2020, 1},
	{2017, 1},
	{2017, 1},
	{2017, 1},
	{2017, 1},
	{2019, 1},
	{2019, 1},
	{2019, 1},
	{2019, 1},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{2029, 1},
	{2029, 1},
	{2029, 1},
	{2029, 1},
	{2031, 1},
	{2031, 1},
	{2031, 1},
	{2031, 1},
	{2022, 1},
	{2022, 1},
	{2022, 1},
	{2022, 1},
	{2021, 1},
	{2021, 1},
	{2021, 1},
	{2021, 1},
	{2023, 1},
	{2023, 1},
	{2023, 1},
	{2023, 1},
	{2024, 1},
	{2024, 1},
	{2024, 1},
	{2024, 1},
	{2027, 1},
	{2027, 1},
	{2026, 1},
	{2026, 1},
	{1581, 1},
	{1581, 1},
	{1581, 1},
	{1581, 1},
	{1583, 1},
	{1583, 1},
	{1583, 1},
	{1583, 1},
	{1787, 1},
	{1787, 1},
	{1787, 1},
	{1787, 1},
	{2033, 1},
	{2033, 1},
	{2033, 1},
	{2033, 1},
	{2035, 1},
	{2035, 1},
	{2035, 1},
	{2035, 1},
	{2034, 1},
	{2034, 1},
	{2034, 1},
	{2034, 1},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{1787, 1},
	{1787, 1},
	{1787, 1},
	{1787, 1},
	{1935, 1},
	{1935, 1},
	{1935, 1},
	{1935, 1},
	{1935, 1},
	{1935, 1},
	{1940, 2},
	{1935, 1},
	{1935, 1},
	{2036, 1},
	{2036, 1},
	{1935, 1},
	{1935, 1},
	{2018, 1},
	{2018, 1},
	{2018, 1},
	{2018, 1},
	{1942, 1},
	{1942, 1},
	{1975, 3},
	{1975, 3},
	{1978, 3},
	{1978, 3},
	{2002, 3},
	{2002, 3},
	{2002, 3},
	{2002, 3},
	{2002, 3},
	{2002, 3},
	{2002, 3},
	{2002, 3},
	{2008, 3},
	{2008, 3},
	{2008, 3},
	{2005, 3},
	{2005, 3},
	{2005, 3},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{1981, 3},
	{1984, 3},
	{1996, 3},
	{2005, 3},
	{2005, 3},
	{1464, 2},
	{1466, 2},
	{1471, 2},
	{1480, 2},
	{1484, 2},
	{1484, 2},
	{1490, 2},
	{1498, 2},
	{1506, 2},
	{1518, 2},
	{1534, 2},
	{1534, 2},
	{1945, 2},
	{1961, 2},
	{1971, 2},
	{1971, 2},
	{1537, 2},
	{1549, 2},
	{1560, 2},
	{1565, 2},
	{1573, 2},
	{1575, 2},
	{1577, 2},
	{1596, 2},
	{1604, 2},
	{1615, 2},
	{1622, 2},
	{1639, 2},
	{1673, 2},
	{1681, 2},
	{1683, 2},
	{1688, 2},
	{1695, 2},
	{1700, 2},
	{1702, 2},
	{1716, 2},
	{1719, 2},
	{1728, 2},
	{1739, 2},
	{1741, 2},
	{1752, 2},
	{1754, 2},
	{1756, 2},
	{1761, 2},
	{1766, 2},
	{1766, 2},
	{1769, 2},
	{1774, 2},
	{1785, 2},
	{1785, 2},
	{1788, 2},
	{1790, 2},
	{1792, 2},
	{1794, 2},
	{1796, 2},
	{1798, 2},
	{1806, 2},
	{1806, 2},
	{1816, 2},
	{1827, 2},
	{1835, 2},
	{1840, 2},
	{1848, 2},
	{1848, 2},
	{1853, 2},
	{1867, 2},
	{1882, 2},
	{1893, 2},
	{1898, 2},
	{1898, 2},
	{1471, 2},
	{1912, 2},
	{1920, 2},
	{1926, 2},
	{1933, 2},
	{1933, 2},
	{1016, 2},
	{1018, 2},
	{1026, 2},
	{1026, 2},
	{1945, 2},
	{1950, 2},
	{1955, 2},
	{1961, 2},
	{1971, 2},
	{1971, 2},
	{1582, 1},
	{1583, 1},
	{1942, 1},
	{4428, 1},
	{4429, 1},
	{4430, 1},
	{4432, 1},
	{4434, 1},
	{4436, 1},
	{1990, 3},
	{1993, 3},
	{1996, 3},
	{1999, 3},
	{2005, 3},
	{2005, 3},
	{1476, 2},
	{1478, 2},
	{1480, 2},
	{1482, 2},
	{1484, 2},
	{1484, 2},
	{1514, 2},
	{1516, 2},
	{1518, 2},
	{1532, 2},
	{1534, 2},
	{1534, 2},
	{1957, 2},
	{1959, 2},
	{1961, 2},
	{1969, 2},
	{1971, 2},
	{1971, 2},
	{1766, 2},
	{1766, 2},
	{1785, 2},
	{1785, 2},
	{1788, 2},
	{1796, 2},
	{1798, 2},
	{1806, 2},
	{1806, 2},
	{1840, 2},
	{1848, 2},
	{1848, 2},
	{1851, 2},
	{1893, 2},
	{1922, 2},
	{1924, 2},
	{1926, 2},
	{1931, 2},
	{1933, 2},
	{1933, 2},
	{1942, 1},
	{1957, 2},
	{1959, 2},
	{1961, 2},
	{1969, 2},
	{1971, 2},
	{1971, 2},
	{1981, 3},
	{1984, 3},
	{1987, 3},
	{1996, 3},
	{1978, 3},
	{1464, 2},
	{1466, 2},
	{1471, 2},
	{1480, 2},
	{1462, 2},
	{1490, 2},
	{1498, 2},
	{1506, 2},
	{1518, 2},
	{1488, 2},
	{1961, 2},
	{1537, 2},
	{1549, 2},
	{1560, 2},
	{1565, 2},
	{1573, 2},
	{1577, 2},
	{1596, 2},
	{1604, 2},
	{1615, 2},
	{1622, 2},
	{1639, 2},
	{1647, 2},
	{1673, 2},
	{1681, 2},
	{1683, 2},
	{1688, 2},
	{1695, 2},
	{1700, 2},
	{1716, 2},
	{1719, 2},
	{1728, 2},
	{1739, 2},
	{1741, 2},
	{1752, 2},
	{1754, 2},
	{1756, 2},
	{1761, 2},
	{1769, 2},
	{1774, 2},
	{1790, 2},
	{1792, 2},
	{1794, 2},
	{1796, 2},
	{1798, 2},
	{1816, 2},
	{1827, 2},
	{1835, 2},
	{1840, 2},
	{1814, 2},
	{1853, 2},
	{1867, 2},
	{1882, 2},
	{1893, 2},
	{1471, 2},
	{1912, 2},
	{1920, 2},
	{1926, 2},
	{1901, 2},
	{1016, 2},
	{1018, 2},
	{1009, 1},
	{1945, 2},
	{1950, 2},
	{1955, 2},
	{1961, 2},
	{1943, 2},
	{1996, 3},
	{1978, 3},
	{1480, 2},
	{1462, 2},
	{1518, 2},
	{1488, 2},
	{1961, 2},
	{1943, 2},
	{1622, 2},
	{1594, 2},
	{1622, 2},
	{1594, 2},
	{1796, 2},
	{1798, 2},
	{1840, 2},
	{1926, 2},
	{1901, 2},
	{1961, 2},
	{1943, 2},
	{4431, 1},
	{4433, 1},
	{4435, 1},
	{1713, 2},
	{1713, 2},
	{1736, 2},
	{1736, 2},
	{1749, 2},
	{1749, 2},
	{1636, 2},
	{1636, 2},
	{1636, 2},
	{1636, 2},
	{1570, 2},
	{1570, 2},
	{1557, 2},
	{1557, 2},
	{1579, 2},
	{1579, 2},
	{1678, 2},
	{1678, 2},
	{1697, 2},
	{1697, 2},
	{1596, 2},
	{1604, 2},
	{1615, 2},
	{1622, 2},
	{1620, 2},
	{1620, 2},
	{1649, 2},
	{1693, 2},
	{1713, 2},
	{1713, 2},
	{1736, 2},
	{1736, 2},
	{1749, 2},
	{1749, 2},
	{1636, 2},
	{1636, 2},
	{1636, 2},
	{1636, 2},
	{1570, 2},
	{1570, 2},
	{1557, 2},
	{1557, 2},
	{1579, 2},
	{1579, 2},
	{1678, 2},
	{1678, 2},
	{1697, 2},
	{1697, 2},
	{1596, 2},
	{1604, 2},
	{1615, 2},
	{1622, 2},
	{1620, 2},
	{1620, 2},
	{1649, 2},
	{1693, 2},
	{1596, 2},
	{1604, 2},
	{1615, 2},
	{1622, 2},
	{1594, 2},
	{1594, 2},
	{1702, 2},
	{1596, 2},
	{1604, 2},
	{1615, 2},
	{1596, 2},
	{1604, 2},
	{1615, 2},
	{1702, 2},
	{1716, 2},
	{850, 1},
	{850, 1},
	{28, 1},
	{474, 1},
	{1492, 3},
	{1500, 3},
	{1500, 3},
	{1503, 3},
	{1508, 3},
	{1520, 3},
	{1523, 3},
	{1526, 3},
	{1551, 3},
	{1551, 3},
	{1567, 3},
	{1567, 3},
	{1606, 3},
	{1598, 3},
	{1601, 3},
	{1627, 3},
	{1627, 3},
	{1624, 3},
	{1633, 3},
	{1633, 3},
	{1641, 3},
	{1641, 3},
	{1675, 3},
	{1609, 3},
	{1609, 3},
	{1601, 3},
	{1630, 3},
	{1630, 3},
	{1633, 3},
	{1633, 3},
	{1685, 3},
	{1690, 3},
	{1690, 3},
	{1704, 3},
	{1704, 3},
	{1707, 3},
	{1710, 3},
	{1721, 3},
	{1730, 3},
	{1730, 3},
	{1733, 3},
	{1743, 3},
	{1746, 3},
	{1746, 3},
	{1758, 3},
	{1758, 3},
	{1776, 3},
	{1779, 3},
	{1829, 3},
	{1832, 3},
	{1832, 3},
	{1818, 3},
	{1818, 3},
	{1837, 3},
	{1837, 3},
	{1842, 3},
	{1842, 3},
	{1869, 3},
	{1872, 3},
	{1879, 3},
	{1855, 3},
	{1861, 3},
	{1884, 3},
	{1887, 3},
	{1858, 3},
	{1020, 3},
	{1023, 3},
	{1914, 3},
	{1917, 3},
	{1906, 3},
	{1906, 3},
	{1909, 3},
	{1928, 3},
	{1928, 3},
	{1963, 3},
	{1963, 3},
	{1473, 3},
	{1495, 3},
	{1495, 3},
	{1511, 3},
	{1511, 3},
	{1529, 3},
	{1529, 3},
	{1554, 3},
	{1539, 3},
	{1554, 3},
	{1617, 3},
	{1644, 3},
	{1612, 3},
	{1685, 3},
	{1824, 3},
	{1845, 3},
	{1952, 3},
	{1947, 3},
	{1966, 3},
	{1895, 3},
	{1782, 3},
	{1917, 3},
	{1776, 3},
	{1829, 3},
	{1733, 3},
	{1803, 3},
	{1903, 3},
	{1890, 3},
	{1821, 3},
	{1800, 3},
	{1821, 3},
	{1903, 3},
	{1539, 3},
	{1562, 3},
	{1864, 3},
	{1763, 3},
	{1468, 3},
	{1800, 3},
	{1721, 3},
	{1675, 3},
	{1617, 3},
	{1909, 3},
	{1655, 3},
	{1771, 3},
	{992, 4},
	{988, 4},
	{1875, 4},
	{1651, 4},
	{1584, 4},
	{1724, 4},
	{1936, 4},
	{1655, 3},
	{1658, 7},
	{1542, 6},
	{1588, 4},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{3217, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{643, 1},
	{3177, 1},
	{3154, 1},
	{3168, 1},
	{3169, 1},
	{3170, 1},
	{3171, 1},
	{3172, 1},
	{3173, 1},
	{1355, 1},
	{1355, 1},
	{1355, 1},
	{1355, 1},
	{796, 1},
	{796, 1},
	{796, 1},
	{482, 1},
	{790, 1},
	{1460, 1},
	{850, 1},
	{850, 1},
	{996, 2},
	{996, 2},
	{1940, 2},
	{1940, 2},
	{850, 1},
	{850, 1},
	{1973, 2},
	{1973, 2},
	{1973, 2},
	{1973, 2},
	{850, 1},
	{850, 1},
	{1461, 1},
	{1461, 1},
	{1461, 1},
	{1461, 1},
	{1486, 1},
	{1486, 1},
	{1487, 1},
	{1487, 1},
	{1487, 1},
	{1487, 1},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{1536, 1},
	{1536, 1},
	{1536, 1},
	{1536, 1},
	{1559, 1},
	{1559, 1},
	{1559, 1},
	{1559, 1},
	{1572, 1},
	{1572, 1},
	{1572, 1},
	{1572, 1},
	{1581, 1},
	{1581, 1},
	{1582, 1},
	{1582, 1},
	{1583, 1},
	{1583, 1},
	{1592, 1},
	{1592, 1},
	{1593, 1},
	{1593, 1},
	{1593, 1},
	{1593, 1},
	{1593, 1},
	{1593, 1},
	{1593, 1},
	{1593, 1},
	{1638, 1},
	{1638, 1},
	{1638, 1},
	{1638, 1},
	{1680, 1},
	{1680, 1},
	{1680, 1},
	{1680, 1},
	{1699, 1},
	{1699, 1},
	{1699, 1},
	{1699, 1},
	{1715, 1},
	{1715, 1},
	{1715, 1},
	{1715, 1},
	{1718, 1},
	{1718, 1},
	{1718, 1},
	{1718, 1},
	{1738, 1},
	{1738, 1},
	{1738, 1},
	{1738, 1},
	{1751, 1},
	{1751, 1},
	{1751, 1},
	{1751, 1},
	{1768, 1},
	{1768, 1},
	{1768, 1},
	{1768, 1},
	{1787, 1},
	{1787, 1},
	{1787, 1},
	{1787, 1},
	{1808, 1},
	{1808, 1},
	{1808, 1},
	{1808, 1},
	{1850, 1},
	{1850, 1},
	{1850, 1},
	{1850, 1},
	{1900, 1},
	{1900, 1},
	{1900, 1},
	{1900, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{1009, 1},
	{1935, 1},
	{1935, 1},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{1942, 1},
	{1809, 2},
	{1809, 2},
	{1811, 3},
	{1811, 3},
	{1809, 2},
	{1809, 2},
	{1809, 2},
	{1809, 2},
	{0, 0},
	{0, 1},
	{7, 2},
	{6, 1},
	{3261, 1},
	{643, 1},
	{679, 1},
	{694, 1},
	{695, 1},
	{703, 1},
	{711, 1},
	{850, 1},
	{712, 1},
	{715, 1},
	{723, 1},
	{726, 1},
	{733, 1},
	{746, 1},
	{755, 1},
	{756, 1},
	{782, 1},
	{788, 1},
	{789, 1},
	{28, 1},
	{790, 1},
	{474, 1},
	{4427, 1},
	{6, 1},
	{797, 1},
	{819, 1},
	{837, 1},
	{848, 1},
	{849, 1},
	{850, 1},
	{1004, 1},
	{850, 1},
	{1009, 1},
	{1033, 1},
	{1042, 1},
	{1064, 1},
	{1075, 1},
	{1081, 1},
	{3177, 1},
	{3218, 1},
	{1096, 1},
	{1355, 1},
	{850, 1},
	{3184, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{1096, 1},
	{726, 1},
	{782, 1},
	{767, 1},
	{957, 3},
	{952, 2},
	{3214, 1},
	{0, 0},
	{694, 1},
	{1370, 1},
	{703, 1},
	{704, 1},
	{850, 1},
	{1318, 1},
	{782, 1},
	{733, 1},
	{3029, 1},
	{746, 1},
	{755, 1},
	{756, 1},
	{478, 1},
	{679, 1},
	{694, 1},
	{695, 1},
	{1370, 1},
	{704, 1},
	{733, 1},
	{1390, 1},
	{723, 1},
	{756, 1},
	{788, 1},
	{1377, 1},
	{782, 1},
	{1378, 1},
	{1379, 1},
	{3215, 1},
	{711, 1},
	{0, 0},
	{1581, 1},
	{1935, 1},
	{1699, 1},
	{1638, 1},
	{789, 1},
	{694, 1},
	{695, 1},
	{850, 1},
	{723, 1},
	{1390, 1},
	{756, 1},
	{782, 1},
	{621, 1},
	{477, 1},
	{850, 1},
	{782, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{4442, 1},
	{4443, 1},
	{1304, 1},
	{733, 1},
	{4406, 1},
	{695, 1},
	{718, 1},
	{3210, 1},
	{755, 1},
	{1301, 1},
	{1395, 1},
	{4419, 1},
	{1349, 1},
	{1009, 1},
	{819, 1},
	{1329, 1},
	{1326, 1},
	{1351, 1},
	{1042, 1},
	{1322, 1},
	{3069, 1},
	{4447, 1},
	{1318, 1},
	{752, 1},
	{1413, 1},
	{733, 1},
	{1347, 1},
	{1293, 1},
	{1393, 1},
	{762, 1},
	{3031, 1},
	{1378, 1},
	{610, 1},
	{1345, 1},
	{1381, 1},
	{1009, 1},
	{4409, 1},
	{1059, 1},
	{1387, 1},
	{726, 1},
	{733, 1},
	{715, 1},
	{695, 1},
	{767, 1},
	{704, 1},
	{718, 1},
	{782, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{485, 1},
	{4449, 2},
	{0, 0},
	{0, 0},
	{4452, 1},
	{4451, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{4453, 1},
	{4454, 1},
	{4455, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2061, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2061, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{4422, 1},
	{4421, 1},
	{3117, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{4456, 2},
	{4458, 2},
	{4460, 2},
	{4462, 2},
	{4464, 2},
	{4466, 2},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{4468, 2},
	{0, 0},
	{2065, 1},
	{2066, 1},
	{2067, 1},
	{2068, 1},
	{2069, 1},
	{2070, 1},
	{2083, 1},
	{2073, 1},
	{2074, 1},
	{2075, 1},
	{2076, 1},
	{2077, 1},
	{2078, 1},
	{2080, 1},
	{2081, 1},
	{2079, 1},
	{2072, 1},
	{2082, 1},
	{2084, 1},
	{2085, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{2086, 1},
	{1074, 1},
	{733, 1},
	{2087, 1},
	{2088, 1},
	{2089, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{4470, 1},
	{4470, 1},
	{4471, 1},
	{4472, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{4473, 2},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{1040, 2},
	{1064, 1},
	{1074, 1},
	{1074, 1},
	{1074, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{767, 1},
	{704, 1},
	{718, 1},
	{788, 1},
	{703, 1},
	{3100, 1},
	{789, 1},
	{632, 1},
	{703, 1},
	{575, 1},
	{718, 1},
	{733, 1},
	{3029, 1},
	{762, 1},
	{588, 1},
	{756, 1},
	{1064, 1},
	{1042, 1},
	{704, 1},
	{850, 1},
	{1082, 1},
	{610, 1},
	{1009, 1},
	{558, 1},
	{632, 1},
	{4419, 1},
	{599, 1},
	{632, 1},
	{1009, 1},
	{1059, 1},
	{1081, 1},
	{733, 1},
	{1040, 2},
	{2015, 1},
	{789, 1},
	{781, 1},
	{695, 1},
	{782, 1},
	{781, 1},
	{695, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{4483, 2},
	{4485, 2},
	{4475, 2},
	{4477, 3},
	{4480, 3},
	{4492, 2},
	{4487, 2},
	{4489, 3},
	{4494, 2},
	{4496, 2},
	{4498, 2},
	{4500, 3},
	{4503, 3},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{4506, 2},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{4444, 1},
	{4448, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{1365, 1},
	{767, 1},
	{756, 1},
	{718, 1},
	{1370, 1},
	{4408, 1},
	{4406, 1},
	{850, 1},
	{1304, 1},
	{752, 1},
	{755, 1},
	{558, 1},
	{1318, 1},
	{664, 1},
	{679, 1},
	{762, 1},
	{788, 1},
	{6, 1},
	{6, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{1083, 1},
	{4509, 1},
	{4510, 1},
	{4510, 1},
	{4510, 1},
	{4510, 1},
	{4510, 1},
	{4510, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{485, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{4511, 1},
	{4512, 1},
	{4511, 1},
	{4512, 1},
	{4511, 1},
	{4512, 1},
	{1414, 1},
	{558, 1},
	{1395, 1},
	{767, 1},
	{790, 1},
	{610, 1},
	{704, 1},
	{4440, 1},
	{4406, 1},
	{752, 1},
	{3209, 1},
	{733, 1},
	{3082, 1},
	{4403, 1},
	{1304, 1},
	{1407, 1},
	{718, 1},
	{4406, 1},
	{4420, 1},
	{650, 1},
	{664, 1},
	{3135, 1},
	{3136, 1},
	{493, 1},
	{790, 1},
	{3021, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{1415, 1},
	{679, 1},
	{694, 1},
	{695, 1},
	{698, 1},
	{703, 1},
	{704, 1},
	{708, 1},
	{711, 1},
	{850, 1},
	{712, 1},
	{715, 1},
	{718, 1},
	{723, 1},
	{726, 1},
	{733, 1},
	{746, 1},
	{749, 1},
	{752, 1},
	{755, 1},
	{756, 1},
	{762, 1},
	{767, 1},
	{781, 1},
	{782, 1},
	{788, 1},
	{789, 1},
	{797, 1},
	{816, 1},
	{819, 1},
	{826, 1},
	{837, 1},
	{838, 1},
	{848, 1},
	{849, 1},
	{850, 1},
	{1004, 1},
	{1005, 1},
	{850, 1},
	{1040, 2},
	{1006, 1},
	{1009, 1},
	{1033, 1},
	{1036, 1},
	{1037, 1},
	{1042, 1},
	{1048, 1},
	{1059, 1},
	{1064, 1},
	{1074, 1},
	{1075, 1},
	{1081, 1},
	{1082, 1},
	{679, 1},
	{694, 1},
	{695, 1},
	{698, 1},
	{703, 1},
	{704, 1},
	{708, 1},
	{711, 1},
	{850, 1},
	{712, 1},
	{715, 1},
	{718, 1},
	{723, 1},
	{726, 1},
	{733, 1},
	{746, 1},
	{749, 1},
	{752, 1},
	{755, 1},
	{756, 1},
	{762, 1},
	{767, 1},
	{781, 1},
	{782, 1},
	{788, 1},
	{789, 1},
	{797, 1},
	{816, 1},
	{819, 1},
	{826, 1},
	{837, 1},
	{838, 1},
	{848, 1},
	{850, 1},
	{1004, 1},
	{1005, 1},
	{850, 1},
	{1040, 2},
	{1006, 1},
	{1009, 1},
	{1033, 1},
	{1036, 1},
	{1037, 1},
	{1042, 1},
	{1048, 1},
	{1059, 1},
	{1064, 1},
	{1074, 1},
	{1075, 1},
	{1081, 1},
	{1082, 1},
	{679, 1},
	{694, 1},
	{695, 1},
	{698, 1},
	{703, 1},
	{704, 1},
	{708, 1},
	{711, 1},
	{850, 1},
	{712, 1},
	{715, 1},
	{718, 1},
	{723, 1},
	{726, 1},
	{733, 1},
	{746, 1},
	{749, 1},
	{752, 1},
	{755, 1},
	{756, 1},
	{762, 1},
	{767, 1},
	{781, 1},
	{782, 1},
	{788, 1},
	{789, 1},
	{797, 1},
	{816, 1},
	{819, 1},
	{826, 1},
	{837, 1},
	{838, 1},
	{848, 1},
	{849, 1},
	{850, 1},
	{1004, 1},
	{1005, 1},
	{850, 1},
	{1040, 2},
	{1006, 1},
	{1009, 1},
	{1033, 1},
	{1036, 1},
	{1037, 1},
	{1042, 1},
	{1048, 1},
	{1059, 1},
	{1064, 1},
	{1074, 1},
	{1075, 1},
	{1081, 1},
	{1082, 1},
	{679, 1},
	{695, 1},
	{698, 1},
	{708, 1},
	{712, 1},
	{715, 1},
	{726, 1},
	{733, 1},
	{746, 1},
	{749, 1},
	{755, 1},
	{756, 1},
	{762, 1},
	{767, 1},
	{781, 1},
	{782, 1},
	{788, 1},
	{789, 1},
	{797, 1},
	{816, 1},
	{819, 1},
	{826, 1},
	{838, 1},
	{849, 1},
	{850, 1},
	{1004, 1},
	{1005, 1},
	{850, 1},
	{1040, 2},
	{1006, 1},
	{1033, 1},
	{1036, 1},
	{1037, 1},
	{1042, 1},
	{1048, 1},
	{1059, 1},
	{1064, 1},
	{1074, 1},
	{1075, 1},
	{1081, 1},
	{1082, 1},
	{679, 1},
	{694, 1},
	{695, 1},
	{698, 1},
	{703, 1},
	{704, 1},
	{708, 1},
	{711, 1},
	{850, 1},
	{712, 1},
	{715, 1},
	{718, 1},
	{723, 1},
	{726, 1},
	{733, 1},
	{746, 1},
	{749, 1},
	{752, 1},
	{755, 1},
	{756, 1},
	{762, 1},
	{767, 1},
	{781, 1},
	{782, 1},
	{788, 1},
	{789, 1},
	{797, 1},
	{816, 1},
	{819, 1},
	{826, 1},
	{837, 1},
	{838, 1},
	{848, 1},
	{849, 1},
	{850, 1},
	{1004, 1},
	{1005, 1},
	{850, 1},
	{1040, 2},
	{1006, 1},
	{1009, 1},
	{1033, 1},
	{1036, 1},
	{1037, 1},
	{1042, 1},
	{1048, 1},
	{1059, 1},
	{1064, 1},
	{1074, 1},
	{1075, 1},
	{1081, 1},
	{1082, 1},
	{679, 1},
	{694, 1},
	{698, 1},
	{703, 1},
	{704, 1},
	{708, 1},
	{712, 1},
	{715, 1},
	{718, 1},
	{723, 1},
	{726, 1},
	{733, 1},
	{746, 1},
	{749, 1},
	{755, 1},
	{756, 1},
	{762, 1},
	{767, 1},
	{781, 1},
	{782, 1},
	{788, 1},
	{797, 1},
	{816, 1},
	{819, 1},
	{826, 1},
	{837, 1},
	{838, 1},
	{848, 1},
	{849, 1},
	{850, 1},
	{1004, 1},
	{1005, 1},
	{850, 1},
	{1040, 2},
	{1006, 1},
	{1009, 1},
	{1033, 1},
	{1036, 1},
	{1037, 1},
	{1042, 1},
	{1048, 1},
	{1059, 1},
	{1064, 1},
	{1074, 1},
	{1075, 1},
	{1081, 1},
	{1082, 1},
	{679, 1},
	{694, 1},
	{698, 1},
	{703, 1},
	{704, 1},
	{708, 1},
	{850, 1},
	{712, 1},
	{715, 1},
	{718, 1},
	{723, 1},
	{733, 1},
	{755, 1},
	{756, 1},
	{762, 1},
	{767, 1},
	{781, 1},
	{782, 1},
	{788, 1},
	{797, 1},
	{816, 1},
	{819, 1},
	{826, 1},
	{837, 1},
	{838, 1},
	{848, 1},
	{849, 1},
	{850, 1},
	{1004, 1},
	{1005, 1},
	{850, 1},
	{1040, 2},
	{1006, 1},
	{1009, 1},
	{1033, 1},
	{1036, 1},
	{1037, 1},
	{1042, 1},
	{1048, 1},
	{1059, 1},
	{1064, 1},
	{1074, 1},
	{1075, 1},
	{1081, 1},
	{1082, 1},
	{679, 1},
	{694, 1},
	{695, 1},
	{698, 1},
	{703, 1},
	{704, 1},
	{708, 1},
	{711, 1},
	{850, 1},
	{712, 1},
	{715, 1},
	{718, 1},
	{723, 1},
	{726, 1},
	{733, 1},
	{746, 1},
	{749, 1},
	{752, 1},
	{755, 1},
	{756, 1},
	{762, 1},
	{767, 1},
	{781, 1},
	{782, 1},
	{788, 1},
	{789, 1},
	{797, 1},
	{816, 1},
	{819, 1},
	{826, 1},
	{837, 1},
	{838, 1},
	{848, 1},
	{849, 1},
	{850, 1},
	{1004, 1},
	{1005, 1},
	{850, 1},
	{1040, 2},
	{1006, 1},
	{1009, 1},
	{1033, 1},
	{1036, 1},
	{1037, 1},
	{1042, 1},
	{1048, 1},
	{1059, 1},
	{1064, 1},
	{1074, 1},
	{1075, 1},
	{1081, 1},
	{1082, 1},
	{679, 1},
	{694, 1},
	{695, 1},
	{698, 1},
	{703, 1},
	{704, 1},
	{708, 1},
	{711, 1},
	{850, 1},
	{712, 1},
	{715, 1},
	{718, 1},
	{723, 1},
	{726, 1},
	{733, 1},
	{746, 1},
	{749, 1},
	{752, 1},
	{755, 1},
	{756, 1},
	{762, 1},
	{767, 1},
	{781, 1},
	{782, 1},
	{788, 1},
	{789, 1},
	{797, 1},
	{816, 1},
	{819, 1},
	{826, 1},
	{837, 1},
	{838, 1},
	{848, 1},
	{849, 1},
	{850, 1},
	{1004, 1},
	{1005, 1},
	{850, 1},
	{1040, 2},
	{1006, 1},
	{1009, 1},
	{1033, 1},
	{1036, 1},
	{1037, 1},
	{1042, 1},
	{1048, 1},
	{1059, 1},
	{1064, 1},
	{1074, 1},
	{1075, 1},
	{1081, 1},
	{1082, 1},
	{679, 1},
	{694, 1},
	{695, 1},
	{698, 1},
	{703, 1},
	{704, 1},
	{708, 1},
	{711, 1},
	{850, 1},
	{712, 1},
	{715, 1},
	{718, 1},
	{723, 1},
	{726, 1},
	{733, 1},
	{746, 1},
	{749, 1},
	{752, 1},
	{755, 1},
	{756, 1},
	{762, 1},
	{767, 1},
	{781, 1},
	{782, 1},
	{788, 1},
	{789, 1},
	{797, 1},
	{816, 1},
	{819, 1},
	{826, 1},
	{837, 1},
	{838, 1},
	{848, 1},
	{849, 1},
	{850, 1},
	{1004, 1},
	{1005, 1},
	{850, 1},
	{1040, 2},
	{1006, 1},
	{1009, 1},
	{1033, 1},
	{1036, 1},
	{1037, 1},
	{1042, 1},
	{1048, 1},
	{1059, 1},
	{1064, 1},
	{1074, 1},
	{1075, 1},
	{1081, 1},
	{1082, 1},
	{679, 1},
	{694, 1},
	{695, 1},
	{698, 1},
	{703, 1},
	{704, 1},
	{708, 1},
	{711, 1},
	{850, 1},
	{712, 1},
	{715, 1},
	{718, 1},
	{723, 1},
	{726, 1},
	{733, 1},
	{746, 1},
	{749, 1},
	{752, 1},
	{755, 1},
	{756, 1},
	{762, 1},
	{767, 1},
	{781, 1},
	{782, 1},
	{788, 1},
	{789, 1},
	{797, 1},
	{816, 1},
	{819, 1},
	{826, 1},
	{837, 1},
	{838, 1},
	{848, 1},
	{849, 1},
	{850, 1},
	{1004, 1},
	{1005, 1},
	{850, 1},
	{1040, 2},
	{1006, 1},
	{1009, 1},
	{1033, 1},
	{1036, 1},
	{1037, 1},
	{1042, 1},
	{1048, 1},
	{1059, 1},
	{1064, 1},
	{1074, 1},
	{1075, 1},
	{1081, 1},
	{1082, 1},
	{679, 1},
	{694, 1},
	{695, 1},
	{698, 1},
	{703, 1},
	{704, 1},
	{708, 1},
	{711, 1},
	{850, 1},
	{712, 1},
	{715, 1},
	{718, 1},
	{723, 1},
	{726, 1},
	{733, 1},
	{746, 1},
	{749, 1},
	{752, 1},
	{755, 1},
	{756, 1},
	{762, 1},
	{767, 1},
	{781, 1},
	{782, 1},
	{788, 1},
	{789, 1},
	{797, 1},
	{816, 1},
	{819, 1},
	{826, 1},
	{837, 1},
	{838, 1},
	{848, 1},
	{849, 1},
	{850, 1},
	{1004, 1},
	{1005, 1},
	{850, 1},
	{1040, 2},
	{1006, 1},
	{1009, 1},
	{1033, 1},
	{1036, 1},
	{1037, 1},
	{1042, 1},
	{1048, 1},
	{1059, 1},
	{1064, 1},
	{1074, 1},
	{1075, 1},
	{1081, 1},
	{1082, 1},
	{679, 1},
	{694, 1},
	{695, 1},
	{698, 1},
	{703, 1},
	{704, 1},
	{708, 1},
	{711, 1},
	{850, 1},
	{712, 1},
	{715, 1},
	{718, 1},
	{723, 1},
	{726, 1},
	{733, 1},
	{746, 1},
	{749, 1},
	{752, 1},
	{755, 1},
	{756, 1},
	{762, 1},
	{767, 1},
	{781, 1},
	{782, 1},
	{788, 1},
	{789, 1},
	{797, 1},
	{816, 1},
	{819, 1},
	{826, 1},
	{837, 1},
	{838, 1},
	{848, 1},
	{849, 1},
	{850, 1},
	{1004, 1},
	{1005, 1},
	{850, 1},
	{1040, 2},
	{1006, 1},
	{1009, 1},
	{1033, 1},
	{1036, 1},
	{1037, 1},
	{1042, 1},
	{1048, 1},
	{1059, 1},
	{1064, 1},
	{1074, 1},
	{1075, 1},
	{1081, 1},
	{1082, 1},
	{850, 1},
	{1316, 1},
	{679, 1},
	{694, 1},
	{1365, 1},
	{1370, 1},
	{703, 1},
	{789, 1},
	{711, 1},
	{733, 1},
	{850, 1},
	{715, 1},
	{1318, 1},
	{723, 1},
	{726, 1},
	{1375, 1},
	{733, 1},
	{1376, 1},
	{746, 1},
	{733, 1},
	{1306, 1},
	{756, 1},
	{788, 1},
	{1377, 1},
	{782, 1},
	{1378, 1},
	{1379, 1},
	{3100, 1},
	{797, 1},
	{1294, 1},
	{1081, 1},
	{3076, 1},
	{4419, 1},
	{1380, 1},
	{1006, 1},
	{733, 1},
	{850, 1},
	{1297, 1},
	{1381, 1},
	{1382, 1},
	{1064, 1},
	{1383, 1},
	{1009, 1},
	{1384, 1},
	{1033, 1},
	{1385, 1},
	{1009, 1},
	{3072, 1},
	{1059, 1},
	{1330, 1},
	{1386, 1},
	{1387, 1},
	{1388, 1},
	{3098, 1},
	{4419, 1},
	{733, 1},
	{1297, 1},
	{1330, 1},
	{1033, 1},
	{1384, 1},
	{679, 1},
	{694, 1},
	{1365, 1},
	{1370, 1},
	{703, 1},
	{789, 1},
	{711, 1},
	{733, 1},
	{850, 1},
	{715, 1},
	{1318, 1},
	{723, 1},
	{726, 1},
	{1375, 1},
	{733, 1},
	{1376, 1},
	{746, 1},
	{733, 1},
	{1306, 1},
	{756, 1},
	{788, 1},
	{1377, 1},
	{782, 1},
	{1378, 1},
	{1379, 1},
	{3100, 1},
	{797, 1},
	{1294, 1},
	{1081, 1},
	{3076, 1},
	{4419, 1},
	{1380, 1},
	{1006, 1},
	{733, 1},
	{850, 1},
	{1297, 1},
	{1381, 1},
	{1382, 1},
	{1064, 1},
	{1383, 1},
	{1009, 1},
	{1384, 1},
	{1033, 1},
	{1385, 1},
	{1009, 1},
	{3072, 1},
	{1059, 1},
	{1330, 1},
	{1386, 1},
	{1387, 1},
	{1388, 1},
	{3098, 1},
	{4419, 1},
	{733, 1},
	{1297, 1},
	{1330, 1},
	{1033, 1},
	{1384, 1},
	{679, 1},
	{694, 1},
	{1365, 1},
	{1370, 1},
	{703, 1},
	{789, 1},
	{711, 1},
	{733, 1},
	{850, 1},
	{715, 1},
	{1318, 1},
	{723, 1},
	{726, 1},
	{1375, 1},
	{733, 1},
	{1376, 1},
	{746, 1},
	{733, 1},
	{1306, 1},
	{756, 1},
	{788, 1},
	{1377, 1},
	{782, 1},
	{1378, 1},
	{1379, 1},
	{3100, 1},
	{797, 1},
	{1294, 1},
	{1081, 1},
	{3076, 1},
	{4419, 1},
	{1380, 1},
	{1006, 1},
	{733, 1},
	{850, 1},
	{1297, 1},
	{1381, 1},
	{1382, 1},
	{1064, 1},
	{1383, 1},
	{1009, 1},
	{1384, 1},
	{1033, 1},
	{1385, 1},
	{1009, 1},
	{3072, 1},
	{1059, 1},
	{1330, 1},
	{1386, 1},
	{1387, 1},
	{1388, 1},
	{3098, 1},
	{4419, 1},
	{733, 1},
	{1297, 1},
	{1330, 1},
	{1033, 1},
	{1384, 1},
	{679, 1},
	{694, 1},
	{1365, 1},
	{1370, 1},
	{703, 1},
	{789, 1},
	{711, 1},
	{733, 1},
	{850, 1},
	{715, 1},
	{1318, 1},
	{723, 1},
	{726, 1},
	{1375, 1},
	{733, 1},
	{1376, 1},
	{746, 1},
	{733, 1},
	{1306, 1},
	{756, 1},
	{788, 1},
	{1377, 1},
	{782, 1},
	{1378, 1},
	{1379, 1},
	{3100, 1},
	{797, 1},
	{1294, 1},
	{1081, 1},
	{3076, 1},
	{4419, 1},
	{1380, 1},
	{1006, 1},
	{733, 1},
	{850, 1},
	{1297, 1},
	{1381, 1},
	{1382, 1},
	{1064, 1},
	{1383, 1},
	{1009, 1},
	{1384, 1},
	{1033, 1},
	{1385, 1},
	{1009, 1},
	{3072, 1},
	{1059, 1},
	{1330, 1},
	{1386, 1},
	{1387, 1},
	{1388, 1},
	{3098, 1},
	{4419, 1},
	{733, 1},
	{1297, 1},
	{1330, 1},
	{1033, 1},
	{1384, 1},
	{679, 1},
	{694, 1},
	{1365, 1},
	{1370, 1},
	{703, 1},
	{789, 1},
	{711, 1},
	{733, 1},
	{850, 1},
	{715, 1},
	{1318, 1},
	{723, 1},
	{726, 1},
	{1375, 1},
	{733, 1},
	{1376, 1},
	{746, 1},
	{733, 1},
	{1306, 1},
	{756, 1},
	{788, 1},
	{1377, 1},
	{782, 1},
	{1378, 1},
	{1379, 1},
	{3100, 1},
	{797, 1},
	{1294, 1},
	{1081, 1},
	{3076, 1},
	{4419, 1},
	{1380, 1},
	{1006, 1},
	{733, 1},
	{850, 1},
	{1297, 1},
	{1381, 1},
	{1382, 1},
	{1064, 1},
	{1383, 1},
	{1009, 1},
	{1384, 1},
	{1033, 1},
	{1385, 1},
	{1009, 1},
	{3072, 1},
	{1059, 1},
	{1330, 1},
	{1386, 1},
	{1387, 1},
	{1388, 1},
	{3098, 1},
	{4419, 1},
	{733, 1},
	{1297, 1},
	{1330, 1},
	{1033, 1},
	{1384, 1},
	{704, 1},
	{1391, 1},
	{733, 1},
	{850, 1},
	{499, 1},
	{558, 1},
	{575, 1},
	{588, 1},
	{599, 1},
	{610, 1},
	{621, 1},
	{632, 1},
	{733, 1},
	{850, 1},
	{499, 1},
	{558, 1},
	{575, 1},
	{588, 1},
	{599, 1},
	{610, 1},
	{621, 1},
	{632, 1},
	{733, 1},
	{850, 1},
	{499, 1},
	{558, 1},
	{575, 1},
	{588, 1},
	{599, 1},
	{610, 1},
	{621, 1},
	{632, 1},
	{733, 1},
	{850, 1},
	{499, 1},
	{558, 1},
	{575, 1},
	{588, 1},
	{599, 1},
	{610, 1},
	{621, 1},
	{632, 1},
	{733, 1},
	{850, 1},
	{499, 1},
	{558, 1},
	{575, 1},
	{588, 1},
	{599, 1},
	{610, 1},
	{621, 1},
	{632, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{850, 1},
	{3105, 1},
	{2012, 1},
	{621, 1},
	{3098, 1},
	{3098, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{850, 1},
	{1461, 1},
	{1536, 1},
	{1581, 1},
	{1935, 1},
	{1592, 1},
	{1559, 1},
	{1699, 1},
	{1942, 1},
	{1787, 1},
	{1808, 1},
	{1850, 1},
	{1900, 1},
	{1593, 1},
	{1718, 1},
	{1751, 1},
	{1638, 1},
	{1768, 1},
	{1583, 1},
	{1593, 1},
	{1487, 1},
	{1942, 1},
	{1572, 1},
	{1582, 1},
	{1680, 1},
	{1715, 1},
	{1738, 1},
	{1942, 1},
	{1942, 1},
	{2029, 1},
	{2029, 1},
	{1461, 1},
	{1536, 1},
	{1009, 1},
	{1559, 1},
	{1942, 1},
	{1787, 1},
	{1808, 1},
	{1850, 1},
	{1900, 1},
	{1593, 1},
	{1718, 1},
	{1751, 1},
	{1638, 1},
	{1768, 1},
	{1593, 1},
	{1487, 1},
	{1942, 1},
	{1572, 1},
	{1680, 1},
	{1738, 1},
	{1536, 1},
	{1559, 1},
	{1942, 1},
	{1808, 1},
	{1900, 1},
	{1593, 1},
	{1718, 1},
	{1638, 1},
	{1768, 1},
	{1593, 1},
	{1572, 1},
	{1680, 1},
	{1738, 1},
	{1942, 1},
	{2029, 1},
	{1461, 1},
	{1536, 1},
	{1009, 1},
	{1559, 1},
	{1699, 1},
	{1942, 1},
	{1787, 1},
	{1850, 1},
	{1900, 1},
	{1593, 1},
	{1718, 1},
	{1751, 1},
	{1638, 1},
	{1768, 1},
	{1593, 1},
	{1487, 1},
	{1942, 1},
	{1572, 1},
	{1680, 1},
	{1715, 1},
	{1738, 1},
	{1942, 1},
	{2029, 1},
	{850, 1},
	{1461, 1},
	{1536, 1},
	{1581, 1},
	{1009, 1},
	{1935, 1},
	{1592, 1},
	{1559, 1},
	{1699, 1},
	{1942, 1},
	{1808, 1},
	{1850, 1},
	{1900, 1},
	{1593, 1},
	{1718, 1},
	{1751, 1},
	{1638, 1},
	{1768, 1},
	{1583, 1},
	{1593, 1},
	{1487, 1},
	{1942, 1},
	{1572, 1},
	{1582, 1},
	{1680, 1},
	{1715, 1},
	{1738, 1},
	{1461, 1},
	{1536, 1},
	{1581, 1},
	{1935, 1},
	{1592, 1},
	{1559, 1},
	{1699, 1},
	{1942, 1},
	{1808, 1},
	{1850, 1},
	{1900, 1},
	{1593, 1},
	{1718, 1},
	{1751, 1},
	{1638, 1},
	{1768, 1},
	{1583, 1},
	{1593, 1},
	{1487, 1},
	{1942, 1},
	{1572, 1},
	{1582, 1},
	{1680, 1},
	{1715, 1},
	{1738, 1},
	{738, 2},
	{736, 2},
	{853, 2},
	{500, 2},
	{559, 2},
	{576, 2},
	{589, 2},
	{600, 2},
	{611, 2},
	{622, 2},
	{633, 2},
	{59, 3},
	{62, 3},
	{65, 3},
	{68, 3},
	{71, 3},
	{74, 3},
	{77, 3},
	{80, 3},
	{158, 3},
	{83, 3},
	{86, 3},
	{89, 3},
	{92, 3},
	{95, 3},
	{98, 3},
	{101, 3},
	{104, 3},
	{107, 3},
	{110, 3},
	{113, 3},
	{116, 3},
	{119, 3},
	{122, 3},
	{125, 3},
	{128, 3},
	{131, 3},
	{110, 3},
	{373, 3},
	{298, 3},
	{304, 3},
	{352, 3},
	{385, 3},
	{355, 3},
	{391, 3},
	{328, 3},
	{358, 3},
	{3188, 1},
	{3189, 1},
	{3188, 1},
	{750, 2},
	{4408, 1},
	{1370, 1},
	{4440, 1},
	{686, 2},
	{767, 1},
	{3187, 1},
	{733, 1},
	{4439, 1},
	{3205, 1},
	{695, 1},
	{3029, 1},
	{3144, 1},
	{1043, 3},
	{3119, 1},
	{756, 1},
	{724, 2},
	{768, 2},
	{3143, 1},
	{3190, 1},
	{3400, 1},
	{3398, 1},
	{3401, 1},
	{4513, 1},
	{3417, 1},
	{3422, 1},
	{3423, 1},
	{3418, 1},
	{3427, 1},
	{3428, 1},
	{3431, 1},
	{3429, 1},
	{3281, 1},
	{4517, 1},
	{3435, 1},
	{3436, 1},
	{3437, 1},
	{3444, 1},
	{4514, 1},
	{3282, 1},
	{3439, 1},
	{3447, 1},
	{4516, 1},
	{3451, 1},
	{3452, 1},
	{3415, 1},
	{3454, 1},
	{3455, 1},
	{4611, 1},
	{3462, 1},
	{3465, 1},
	{3284, 1},
	{3470, 1},
	{3471, 1},
	{3472, 1},
	{3473, 1},
	{3285, 1},
	{3478, 1},
	{3479, 1},
	{3482, 1},
	{3485, 1},
	{3486, 1},
	{3487, 1},
	{3489, 1},
	{3496, 1},
	{3499, 1},
	{3500, 1},
	{3503, 1},
	{3505, 1},
	{3506, 1},
	{3506, 1},
	{3506, 1},
	{4520, 1},
	{3874, 1},
	{3511, 1},
	{3512, 1},
	{4521, 1},
	{3515, 1},
	{3516, 1},
	{3517, 1},
	{3524, 1},
	{3520, 1},
	{3522, 1},
	{3523, 1},
	{3525, 1},
	{3527, 1},
	{3528, 1},
	{3529, 1},
	{3531, 1},
	{3532, 1},
	{3532, 1},
	{3534, 1},
	{3536, 1},
	{3537, 1},
	{3539, 1},
	{3546, 1},
	{3541, 1},
	{3547, 1},
	{3542, 1},
	{3544, 1},
	{3466, 1},
	{3565, 1},
	{3550, 1},
	{3551, 1},
	{3552, 1},
	{3549, 1},
	{3554, 1},
	{3553, 1},
	{3561, 1},
	{4522, 1},
	{3566, 1},
	{3567, 1},
	{3569, 1},
	{3572, 1},
	{3573, 1},
	{3579, 1},
	{4523, 1},
	{4524, 1},
	{3582, 1},
	{3583, 1},
	{3584, 1},
	{3581, 1},
	{3586, 1},
	{3289, 1},
	{3290, 1},
	{3589, 1},
	{3591, 1},
	{3591, 1},
	{4525, 1},
	{3595, 1},
	{3596, 1},
	{3597, 1},
	{3599, 1},
	{4526, 1},
	{3601, 1},
	{3602, 1},
	{3658, 1},
	{3604, 1},
	{3291, 1},
	{3608, 1},
	{3612, 1},
	{3615, 1},
	{3614, 1},
	{4528, 1},
	{3617, 1},
	{4529, 1},
	{3620, 1},
	{3619, 1},
	{3621, 1},
	{3625, 1},
	{3626, 1},
	{3292, 1},
	{3630, 1},
	{3633, 1},
	{3634, 1},
	{3635, 1},
	{3293, 1},
	{4530, 1},
	{3294, 1},
	{3641, 1},
	{3642, 1},
	{3643, 1},
	{3645, 1},
	{4621, 1},
	{3651, 1},
	{4532, 1},
	{4532, 1},
	{4083, 1},
	{3655, 1},
	{3655, 1},
	{3295, 1},
	{4539, 1},
	{4581, 1},
	{3660, 1},
	{3662, 1},
	{3296, 1},
	{3665, 1},
	{3670, 1},
	{3671, 1},
	{3673, 1},
	{3677, 1},
	{3299, 1},
	{3298, 1},
	{3678, 1},
	{4533, 1},
	{3679, 1},
	{3684, 1},
	{3685, 1},
	{3686, 1},
	{3685, 1},
	{3689, 1},
	{3690, 1},
	{3694, 1},
	{3692, 1},
	{3693, 1},
	{3695, 1},
	{3696, 1},
	{3697, 1},
	{3700, 1},
	{3701, 1},
	{3707, 1},
	{3708, 1},
	{3712, 1},
	{3716, 1},
	{4536, 1},
	{3715, 1},
	{3713, 1},
	{3717, 1},
	{3719, 1},
	{3724, 1},
	{4537, 1},
	{3726, 1},
	{3723, 1},
	{3721, 1},
	{3300, 1},
	{3728, 1},
	{3730, 1},
	{3732, 1},
	{3729, 1},
	{3302, 1},
	{3737, 1},
	{3739, 1},
	{4538, 1},
	{3751, 1},
	{3764, 1},
	{3754, 1},
	{3306, 1},
	{3758, 1},
	{3305, 1},
	{3304, 1},
	{3448, 1},
	{3449, 1},
	{3765, 1},
	{3759, 1},
	{4071, 1},
	{3336, 1},
	{3771, 1},
	{3773, 1},
	{3774, 1},
	{3780, 1},
	{3778, 1},
	{4543, 1},
	{3310, 1},
	{3786, 1},
	{3783, 1},
	{3789, 1},
	{3791, 1},
	{4545, 1},
	{3792, 1},
	{3788, 1},
	{3794, 1},
	{3311, 1},
	{3795, 1},
	{3797, 1},
	{3798, 1},
	{3801, 1},
	{4546, 1},
	{3803, 1},
	{3313, 1},
	{3806, 1},
	{4547, 1},
	{3807, 1},
	{3314, 1},
	{3810, 1},
	{3814, 1},
	{3817, 1},
	{3818, 1},
	{4548, 1},
	{4527, 1},
	{4549, 1},
	{3829, 1},
	{4550, 1},
	{3832, 1},
	{3834, 1},
	{3830, 1},
	{3836, 1},
	{3840, 1},
	{3844, 1},
	{3841, 1},
	{3842, 1},
	{3845, 1},
	{3846, 1},
	{4551, 1},
	{3839, 1},
	{3852, 1},
	{3853, 1},
	{3315, 1},
	{3858, 1},
	{3857, 1},
	{4552, 1},
	{3850, 1},
	{3864, 1},
	{4553, 1},
	{4554, 1},
	{3865, 1},
	{3870, 1},
	{3869, 1},
	{3868, 1},
	{3316, 1},
	{3871, 1},
	{3876, 1},
	{3875, 1},
	{3878, 1},
	{4515, 1},
	{3881, 1},
	{4555, 1},
	{3884, 1},
	{4557, 1},
	{3889, 1},
	{3892, 1},
	{3897, 1},
	{4558, 1},
	{3901, 1},
	{3902, 1},
	{4559, 1},
	{4560, 1},
	{3910, 1},
	{3914, 1},
	{3317, 1},
	{3915, 1},
	{3318, 1},
	{3318, 1},
	{3921, 1},
	{3922, 1},
	{3924, 1},
	{3925, 1},
	{3928, 1},
	{3319, 1},
	{3934, 1},
	{4561, 1},
	{3938, 1},
	{4562, 1},
	{3941, 1},
	{4531, 1},
	{3945, 1},
	{4563, 1},
	{4564, 1},
	{4565, 1},
	{3320, 1},
	{3321, 1},
	{3958, 1},
	{4567, 1},
	{4566, 1},
	{4568, 1},
	{4569, 1},
	{3960, 1},
	{3961, 1},
	{3961, 1},
	{3963, 1},
	{3323, 1},
	{3964, 1},
	{3325, 1},
	{3326, 1},
	{4571, 1},
	{3970, 1},
	{3972, 1},
	{3975, 1},
	{3327, 1},
	{4572, 1},
	{3985, 1},
	{4573, 1},
	{4574, 1},
	{3992, 1},
	{3997, 1},
	{3328, 1},
	{3999, 1},
	{4000, 1},
	{4001, 1},
	{4575, 1},
	{4576, 1},
	{4576, 1},
	{4007, 1},
	{3329, 1},
	{4577, 1},
	{4011, 1},
	{4012, 1},
	{3330, 1},
	{4578, 1},
	{4019, 1},
	{3331, 1},
	{4023, 1},
	{4021, 1},
	{4026, 1},
	{4580, 1},
	{4032, 1},
	{3332, 1},
	{4035, 1},
	{4037, 1},
	{4041, 1},
	{3333, 1},
	{4582, 1},
	{4583, 1},
	{3334, 1},
	{4584, 1},
	{4049, 1},
	{4585, 1},
	{4052, 1},
	{4055, 1},
	{4058, 1},
	{4586, 1},
	{4587, 1},
	{4063, 1},
	{4588, 1},
	{4065, 1},
	{4540, 1},
	{3335, 1},
	{4072, 1},
	{4074, 1},
	{3337, 1},
	{4075, 1},
	{3588, 1},
	{4589, 1},
	{4590, 1},
	{4541, 1},
	{4542, 1},
	{4083, 1},
	{4084, 1},
	{4231, 1},
	{3339, 1},
	{4095, 1},
	{4094, 1},
	{4096, 1},
	{3477, 1},
	{4097, 1},
	{4098, 1},
	{4099, 1},
	{4101, 1},
	{4591, 1},
	{4100, 1},
	{4102, 1},
	{4107, 1},
	{4108, 1},
	{4103, 1},
	{4109, 1},
	{4114, 1},
	{4119, 1},
	{4106, 1},
	{4111, 1},
	{4112, 1},
	{4113, 1},
	{4592, 1},
	{4594, 1},
	{4593, 1},
	{3340, 1},
	{4122, 1},
	{4123, 1},
	{4125, 1},
	{4598, 1},
	{4126, 1},
	{4595, 1},
	{3341, 1},
	{3342, 1},
	{4596, 1},
	{4597, 1},
	{3343, 1},
	{4136, 1},
	{4137, 1},
	{4138, 1},
	{4139, 1},
	{4142, 1},
	{4141, 1},
	{4144, 1},
	{4143, 1},
	{4147, 1},
	{4145, 1},
	{4146, 1},
	{4148, 1},
	{3344, 1},
	{4150, 1},
	{4151, 1},
	{3345, 1},
	{4155, 1},
	{4156, 1},
	{4599, 1},
	{4160, 1},
	{4161, 1},
	{3346, 1},
	{4164, 1},
	{3283, 1},
	{4600, 1},
	{4601, 1},
	{3348, 1},
	{3349, 1},
	{4178, 1},
	{4184, 1},
	{4192, 1},
	{4197, 1},
	{4602, 1},
	{4201, 1},
	{4202, 1},
	{4207, 1},
	{4211, 1},
	{4604, 1},
	{4518, 1},
	{4215, 1},
	{4214, 1},
	{4218, 1},
	{4519, 1},
	{4222, 1},
	{4226, 1},
	{4605, 1},
	{4606, 1},
	{4241, 1},
	{4243, 1},
	{4245, 1},
	{4607, 1},
	{4246, 1},
	{4256, 1},
	{4259, 1},
	{4260, 1},
	{4258, 1},
	{4264, 1},
	{4265, 1},
	{4608, 1},
	{4271, 1},
	{3350, 1},
	{4273, 1},
	{4609, 1},
	{3351, 1},
	{4288, 1},
	{3622, 1},
	{4294, 1},
	{4610, 1},
	{4612, 1},
	{3352, 1},
	{3353, 1},
	{4305, 1},
	{4613, 1},
	{3354, 1},
	{4614, 1},
	{4311, 1},
	{4311, 1},
	{4313, 1},
	{4615, 1},
	{4323, 1},
	{3355, 1},
	{4327, 1},
	{4331, 1},
	{4333, 1},
	{4335, 1},
	{3356, 1},
	{4616, 1},
	{4341, 1},
	{4348, 1},
	{4352, 1},
	{3357, 1},
	{3358, 1},
	{4353, 1},
	{4617, 1},
	{3359, 1},
	{4618, 1},
	{4619, 1},
	{4620, 1},
	{4364, 1},
	{3360, 1},
	{4370, 1},
	{4372, 1},
	{4373, 1},
	{4375, 1},
	{4377, 1},
	{4379, 1},
	{4622, 1},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
};

static const int32_t decomp_data[] = {
	0x21,
	0x21,
	0x21,
	0x21,
	0x3f,
	0x26,
	0x27,
	0x27,
	0x27,
	0x27,
	0x27,
	0x27,
	0x27,
	0x27,
	0x27,
	0x27,
	0x27,
	0x42,
	0x27,
	0x44,
	0x27,
	0x50,
	0x27,
	0x54,
	0x27,
	0x59,
	0x27,
	0x6e,
	0x28,
	0x28,
	0x28,
	0x28,
	0x32,
	0x29,
	0x28,
	0x32,
	0x4f,
	0x29,
	0x28,
	0x33,
	0x29,
	0x28,
	0x34,
	0x29,
	0x28,
	0x35,
	0x29,
	0x28,
	0x36,
	0x29,
	0x28,
	0x37,
	0x29,
	0x28,
	0x38,
	0x29,
	0x28,
	0x39,
	0x29,
	0x28,
	0x41,
	0x29,
	0x28,
	0x42,
	0x29,
	0x28,
	0x43,
	0x29,
	0x28,
	0x44,
	0x29,
	0x28,
	0x45,
	0x29,
	0x28,
	0x46,
	0x29,
	0x28,
	0x47,
	0x29,
	0x28,
	0x48,
	0x29,
	0x28,
	0x4a,
	0x29,
	0x28,
	0x4b,
	0x29,
	0x28,
	0x4c,
	0x29,
	0x28,
	0x4d,
	0x29,
	0x28,
	0x4e,
	0x29,
	0x28,
	0x4f,
	0x29,
	0x28,
	0x50,
	0x29,
	0x28,
	0x51,
	0x29,
	0x28,
	0x52,
	0x29,
	0x28,
	0x53,
	0x29,
	0x28,
	0x54,
	0x29,
	0x28,
	0x55,
	0x29,
	0x28,
	0x56,
	0x29,
	0x28,
	0x57,
	0x29,
	0x28,
	0x58,
	0x29,
	0x28,
	0x59,
	0x29,
	0x28,
	0x5a,
	0x29,
	0x28,
	0x61,
	0x29,
	0x28,
	0x62,
	0x29,
	0x28,
	0x63,
	0x29,
	0x28,
	0x64,
	0x29,
	0x28,
	0x65,
	0x29,
	0x28,
	0x66,
	0x29,
	0x28,
	0x67,
	0x29,
	0x28,
	0x68,
	0x29,
	0x28,
	0x69,
	0x29,
	0x28,
	0x69,
	0x32,
	0x29,
	0x28,
	0x69,
	0x33,
	0x29,
	0x28,
	0x69,
	0x34,
	0x29,
	0x28,
	0x69,
	0x35,
	0x29,
	0x28,
	0x69,
	0x36,
	0x29,
	0x28,
	0x69,
	0x37,
	0x29,
	0x28,
	0x69,
	0x38,
	0x29,
	0x28,
	0x69,
	0x39,
	0x29,
	0x28,
	0x69,
	0x4f,
	0x29,
	0x28,
	0x69,
	0x69,
	0x29,
	0x28,
	0x6a,
	0x29,
	0x28,
	0x6b,
	0x29,
	0x28,
	0x6e,
	0x29,
	0x28,
	0x6f,
	0x29,
	0x28,
	0x70,
	0x29,
	0x28,
	0x71,
	0x29,
	0x28,
	0x72,
	0x29,
	0x28,
	0x72,
	0x6e,
	0x29,
	0x28,
	0x73,
	0x29,
	0x28,
	0x74,
	0x29,
	0x28,
	0x75,
	0x29,
	0x28,
	0x76,
	0x29,
	0x28,
	0x77,
	0x29,
	0x28,
	0x78,
	0x29,
	0x28,
	0x79,
	0x29,
	0x28,
	0x7a,
	0x29,
	0x28,
	0x1100,
	0x29,
	0x28,
	0x1102,
	0x29,
	0x28,
	0x1103,
	0x29,
	0x28,
	0x1105,
	0x29,
	0x28,
	0x1106,
	0x29,
	0x28,
	0x1107,
	0x29,
	0x28,
	0x1109,
	0x29,
	0x28,
	0x110b,
	0x29,
	0x28,
	0x110c,
	0x29,
	0x28,
	0x110e,
	0x29,
	0x28,
	0x110f,
	0x29,
	0x28,
	0x1110,
	0x29,
	0x28,
	0x1111,
	0x29,
	0x28,
	0x1112,
	0x29,
	0x28,
	0x30fc,
	0x29,
	0x28,
	0x4e03,
	0x29,
	0x28,
	0x4e09,
	0x29,
	0x28,
	0x4e5d,
	0x29,
	0x28,
	0x4e8c,
	0x29,
	0x28,
	0x4e94,
	0x29,
	0x28,
	0x4ee3,
	0x29,
	0x28,
	0x4f01,
	0x29,
	0x28,
	0x4f11,
	0x29,
	0x28,
	0x516b,
	0x29,
	0x28,
	0x516d,
	0x29,
	0x28,
	0x52b4,
	0x29,
	0x28,
	0x52dd,
	0x29,
	0x28,
	0x5341,
	0x29,
	0x28,
	0x5354,
	0x29,
	0x28,
	0x540d,
	0x29,
	0x28,
	0x547c,
	0x29,
	0x28,
	0x56db,
	0x29,
	0x28,
	0x571f,
	0x29,
	0x28,
	0x5b66,
	0x29,
	0x28,
	0x5b89,
	0x29,
	0x28,
	0x6253,
	0x29,
	0x28,
	0x6557,
	0x29,
	0x28,
	0x65e5,
	0x29,
	0x28,
	0x6708,
	0x29,
	0x28,
	0x6709,
	0x29,
	0x28,
	0x6728,
	0x29,
	0x28,
	0x672c,
	0x29,
	0x28,
	0x682a,
	0x29,
	0x28,
	0x6c34,
	0x29,
	0x28,
	0x706b,
	0x29,
	0x28,
	0x70b9,
	0x29,
	0x28,
	0x7279,
	0x29,
	0x28,
	0x76d7,
	0x29,
	0x28,
	0x76e3,
	0x29,
	0x28,
	0x793e,
	0x29,
	0x28,
	0x795d,
	0x29,
	0x28,
	0x796d,
	0x29,
	0x28,
	0x81ea,
	0x29,
	0x28,
	0x81f3,
	0x29,
	0x28,
	0x8ca1,
	0x29,
	0x28,
	0x8cc7,
	0x29,
	0x28,
	0x91d1,
	0x29,
	0x28,
	0xac00,
	0x29,
	0x28,
	0xb098,
	0x29,
	0x28,
	0xb2e4,
	0x29,
	0x28,
	0xb77c,
	0x29,
	0x28,
	0xb9c8,
	0x29,
	0x28,
	0xbc14,
	0x29,
	0x28,
	0xc0ac,
	0x29,
	0x28,
	0xc544,
	0x29,
	0x28,
	0xc624,
	0xc804,
	0x29,
	0x28,
	0xc624,
	0xd6c4,
	0x29,
	0x28,
	0xc790,
	0x29,
	0x28,
	0xc8fc,
	0x29,
	0x28,
	0xcc28,
	0x29,
	0x28,
	0xce74,
	0x29,
	0x28,
	0xd0c0,
	0x29,
	0x28,
	0xd30c,
	0x29,
	0x28,
	0xd558,
	0x29,
	0x29,
	0x29,
	0x29,
	0x2a,
	0x2b,
	0x2b,
	0x2082,
	0x2c,
	0x2d,
	0x2d,
	0x2e,
	0x2e,
	0x2e,
	0x2c,
	0x2e,
	0x2e,
	0x2e,
	0x2e,
	0x2e,
	0x2f,
	0x2f,
	0x2f,
	0x2f,
	0x2f,
	0x2f,
	0x32,
	0x32,
	0x2c,
	0x32,
	0x2e,
	0x32,
	0x32,
	0x65e5,
	0x32,
	0x32,
	0x70b9,
	0x32,
	0x33,
	0x65e5,
	0x32,
	0x33,
	0x70b9,
	0x32,
	0x34,
	0x65e5,
	0x32,
	0x34,
	0x70b9,
	0x32,
	0x35,
	0x65e5,
	0x32,
	0x36,
	0x65e5,
	0x32,
	0x37,
	0x65e5,
	0x32,
	0x38,
	0x65e5,
	0x32,
	0x39,
	0x65e5,
	0x32,
	0x4f,
	0x2e,
	0x32,
	0x4f,
	0x65e5,
	0x32,
	0x4f,
	0x70b9,
	0x32,
	0x69,
	0x65e5,
	0x32,
	0x69,
	0x70b9,
	0x32,
	0x65e5,
	0x32,
	0x6708,
	0x32,
	0x70b9,
	0x33,
	0x33,
	0x2c,
	0x33,
	0x2e,
	0x33,
	0x4f,
	0x65e5,
	0x33,
	0x69,
	0x65e5,
	0x33,
	0x65e5,
	0x33,
	0x6708,
	0x33,
	0x70b9,
	0x34,
	0x34,
	0x2c,
	0x34,
	0x2e,
	0x34,
	0xb7,
	0x34,
	0x65e5,
	0x34,
	0x6708,
	0x34,
	0x70b9,
	0x35,
	0x35,
	0x2c,
	0x35,
	0x2e,
	0x35,
	0x65e5,
	0x35,
	0x6708,
	0x35,
	0x70b9,
	0x36,
	0x36,
	0x2c,
	0x36,
	0x2e,
	0x36,
	0x65e5,
	0x36,
	0x6708,
	0x36,
	0x70b9,
	0x37,
	0x37,
	0x2c,
	0x37,
	0x2e,
	0x37,
	0x65e5,
	0x37,
	0x6708,
	0x37,
	0x70b9,
	0x38,
	0x38,
	0x2c,
	0x38,
	0x2e,
	0x38,
	0x65e5,
	0x38,
	0x6708,
	0x38,
	0x70b9,
	0x39,
	0x39,
	0x2c,
	0x39,
	0x2e,
	0x39,
	0x65e5,
	0x39,
	0x6708,
	0x39,
	0x70b9,
	0x3a,
	0x3a,
	0x3a,
	0x3d,
	0x3a,
	0x2192,
	0x3b,
	0x3c,
	0x3c,
	0x3c,
	0x3c,
	0x3c,
	0x3c,
	0x3c,
	0xb7,
	0x3d,
	0x3d,
	0x3d,
	0x3d,
	0x3d,
	0x3d,
	0x3e,
	0x3e,
	0x3c,
	0x3e,
	0x3e,
	0x3e,
	0x3e,
	0x3e,
	0x3e,
	0xb7,
	0x3f,
	0x3f,
	0x21,
	0x3f,
	0x3f,
	0x41,
	0x41,
	0x41,
	0x41,
	0x45,
	0x41,
	0x4f,
	0x41,
	0x52,
	0x41,
	0x55,
	0x41,
	0x56,
	0x41,
	0x59,
	0x42,
	0x43,
	0x43,
	0x27,
	0x44,
	0x44,
	0x5a,
	0x44,
	0x7a,
	0x45,
	0x46,
	0x46,
	0x41,
	0x58,
	0x47,
	0x47,
	0x27,
	0x48,
	0x4a,
	0x4a,
	0xb7,
	0x4b,
	0x4b,
	0x27,
	0x4c,
	0x4c,
	0x4a,
	0x4c,
	0x6a,
	0x4d,
	0x4d,
	0x42,
	0x4e,
	0x4e,
	0x4a,
	0x4e,
	0x6a,
	0x4e,
	0x6f,
	0x4f,
	0x4f,
	0x27,
	0x4f,
	0x2c,
	0x4f,
	0x2e,
	0x4f,
	0x45,
	0x4f,
	0x4f,
	0x4f,
	0x70b9,
	0x50,
	0x50,
	0x27,
	0x51,
	0x51,
	0x45,
	0x52,
	0x52,
	0x73,
	0x53,
	0x54,
	0x54,
	0x33,
	0x54,
	0x45,
	0x4c,
	0x55,
	0x55,
	0x27,
	0x55,
	0xb7,
	0x56,
	0x56,
	0x42,
	0x56,
	0x69,
	0x56,
	0x69,
	0x69,
	0x56,
	0x69,
	0x69,
	0x69,
	0x56,
	0xb7,
	0x57,
	0x58,
	0x58,
	0x69,
	0x58,
	0x69,
	0x69,
	0x59,
	0x5a,
	0x5c,
	0x5c,
	0x5c,
	0x5c,
	0x1455,
	0x5e,
	0x5f,
	0x61,
	0x61,
	0x2f,
	0x63,
	0x61,
	0x2f,
	0x73,
	0x61,
	0x61,
	0x61,
	0x65,
	0x61,
	0x6f,
	0x61,
	0x75,
	0x61,
	0x76,
	0x61,
	0x79,
	0x62,
	0x62,
	0x69,
	0x63,
	0x63,
	0x2f,
	0x6f,
	0x63,
	0x2f,
	0x75,
	0x64,
	0x64,
	0x27,
	0x64,
	0x7a,
	0x64,
	0xb7,
	0x64,
	0x21d,
	0x64,
	0x291,
	0x65,
	0x66,
	0x66,
	0x66,
	0x66,
	0x66,
	0x69,
	0x66,
	0x69,
	0x66,
	0x14b,
	0x67,
	0x68,
	0x69,
	0x69,
	0x27,
	0x69,
	0x2c,
	0x69,
	0x2e,
	0x69,
	0x32,
	0x2e,
	0x69,
	0x32,
	0x65e5,
	0x69,
	0x32,
	0x6708,
	0x69,
	0x32,
	0x70b9,
	0x69,
	0x33,
	0x2e,
	0x69,
	0x33,
	0x65e5,
	0x69,
	0x33,
	0x70b9,
	0x69,
	0x34,
	0x2e,
	0x69,
	0x34,
	0x65e5,
	0x69,
	0x34,
	0x70b9,
	0x69,
	0x35,
	0x2e,
	0x69,
	0x35,
	0x65e5,
	0x69,
	0x35,
	0x70b9,
	0x69,
	0x36,
	0x2e,
	0x69,
	0x36,
	0x65e5,
	0x69,
	0x36,
	0x70b9,
	0x69,
	0x37,
	0x2e,
	0x69,
	0x37,
	0x65e5,
	0x69,
	0x37,
	0x70b9,
	0x69,
	0x38,
	0x2e,
	0x69,
	0x38,
	0x65e5,
	0x69,
	0x38,
	0x70b9,
	0x69,
	0x39,
	0x2e,
	0x69,
	0x39,
	0x65e5,
	0x69,
	0x39,
	0x70b9,
	0x69,
	0x4a,
	0x69,
	0x4f,
	0x69,
	0x4f,
	0x2e,
	0x69,
	0x4f,
	0x65e5,
	0x69,
	0x4f,
	0x6708,
	0x69,
	0x4f,
	0x70b9,
	0x69,
	0x56,
	0x69,
	0x58,
	0x69,
	0x69,
	0x69,
	0x69,
	0x2e,
	0x69,
	0x69,
	0x53,
	0x69,
	0x69,
	0x69,
	0x69,
	0x69,
	0x65e5,
	0x69,
	0x69,
	0x6708,
	0x69,
	0x69,
	0x70b9,
	0x69,
	0x6a,
	0x69,
	0x73,
	0x69,
	0x74,
	0x69,
	0x76,
	0x69,
	0x78,
	0x69,
	0x7a,
	0x69,
	0xb7,
	0x69,
	0x21d,
	0x69,
	0x643,
	0x628,
	0x631,
	0x69,
	0x644,
	0x644,
	0x6f,
	0x69,
	0x674,
	0x69,
	0x65e5,
	0x69,
	0x6708,
	0x69,
	0x70b9,
	0x6a,
	0x6b,
	0x6e,
	0x6e,
	0x6a,
	0x6f,
	0x6f,
	0x27,
	0x6f,
	0x65,
	0x6f,
	0x6f,
	0x6f,
	0x62c,
	0x6f,
	0x645,
	0x6f,
	0x645,
	0x62c,
	0x6f,
	0x645,
	0x645,
	0x6f,
	0x649,
	0x6f,
	0xd30,
	0x6f,
	0x6f,
	0x1d07,
	0x70,
	0x70,
	0xb7,
	0x71,
	0x72,
	0x72,
	0x27,
	0x72,
	0x6e,
	0x73,
	0x73,
	0x73,
	0x73,
	0x73,
	0x74,
	0x74,
	0x74,
	0x66,
	0x74,
	0x73,
	0x74,
	0x21d,
	0x74,
	0x255,
	0x74,
	0x283,
	0x75,
	0x75,
	0x65,
	0x75,
	0x6f,
	0x76,
	0x76,
	0x69,
	0x76,
	0x69,
	0x69,
	0x76,
	0x69,
	0x69,
	0x69,
	0x77,
	0x78,
	0x78,
	0x69,
	0x78,
	0x69,
	0x69,
	0x79,
	0x7a,
	0x7b,
	0x7d,
	0x7e,
	0xa3,
	0xa8,
	0xa9,
	0xae,
	0xb0,
	0xb0,
	0x43,
	0xb0,
	0x46,
	0xb6,
	0xb7,
	0xb7,
	0x34,
	0xb7,
	0x3c,
	0xb7,
	0x3e,
	0xb7,
	0x4a,
	0xb7,
	0x4c,
	0xb7,
	0x50,
	0xb7,
	0x55,
	0xb7,
	0x56,
	0xb7,
	0x64,
	0xb7,
	0xb7,
	0xb7,
	0xb7,
	0x245,
	0xb7,
	0x393,
	0xb7,
	0x394,
	0xb7,
	0x548,
	0xb7,
	0x1401,
	0xb7,
	0x1404,
	0xb7,
	0x1405,
	0xb7,
	0x1406,
	0xb7,
	0x140a,
	0xb7,
	0x140b,
	0xb7,
	0x1432,
	0xb7,
	0x1434,
	0xb7,
	0x1439,
	0xb7,
	0x144f,
	0xb7,
	0x1450,
	0xb7,
	0x1451,
	0xb7,
	0x1455,
	0xb7,
	0x1456,
	0xb7,
	0x146b,
	0xb7,
	0x146e,
	0xb7,
	0x1470,
	0xb7,
	0x1472,
	0xb7,
	0x1473,
	0xb7,
	0x1489,
	0xb7,
	0x148b,
	0xb7,
	0x148c,
	0xb7,
	0x148e,
	0xb7,
	0x1490,
	0xb7,
	0x1491,
	0xb7,
	0x14a3,
	0xb7,
	0x14a6,
	0xb7,
	0x14a7,
	0xb7,
	0x14a8,
	0xb7,
	0x14ab,
	0xb7,
	0x14c0,
	0xb7,
	0x14c2,
	0xb7,
	0x14c3,
	0xb7,
	0x14c4,
	0xb7,
	0x14c5,
	0xb7,
	0x14c7,
	0xb7,
	0x14c8,
	0xb7,
	0x14d3,
	0xb7,
	0x14d5,
	0xb7,
	0x14d6,
	0xb7,
	0x14d7,
	0xb7,
	0x14d8,
	0xb7,
	0x14da,
	0xb7,
	0x14db,
	0xb7,
	0x14ed,
	0xb7,
	0x14ef,
	0xb7,
	0x14f0,
	0xb7,
	0x14f1,
	0xb7,
	0x14f2,
	0xb7,
	0x14f4,
	0xb7,
	0x14f5,
	0xb7,
	0x1510,
	0xb7,
	0x1511,
	0xb7,
	0x1512,
	0xb7,
	0x1513,
	0xb7,
	0x1514,
	0xb7,
	0x1515,
	0xb7,
	0x1516,
	0xb7,
	0x1528,
	0xb7,
	0x1529,
	0xb7,
	0x152a,
	0xb7,
	0x152b,
	0xb7,
	0x152d,
	0xb7,
	0x152e,
	0xb7,
	0x1543,
	0xb7,
	0x1546,
	0xb7,
	0x1547,
	0xb7,
	0x1548,
	0xb7,
	0x1549,
	0xb7,
	0x154b,
	0xb7,
	0x154c,
	0xb7,
	0x155a,
	0xb7,
	0x1567,
	0xb7,
	0x18b1,
	0xb7,
	0x18b4,
	0xb7,
	0x18b8,
	0xb7,
	0x18c0,
	0xba,
	0xba,
	0x2f,
	0x2080,
	0xba,
	0x2f,
	0x2080,
	0x2080,
	0xba,
	0x2f,
	0x2080,
	0x2080,
	0x2080,
	0xde,
	0xdf,
	0xf7,
	0xfe,
	0x138,
	0x185,
	0x185,
	0x69,
	0x186,
	0x18e,
	0x18f,
	0x190,
	0x1a8,
	0x1a9,
	0x1ab,
	0x1b1,
	0x1dd,
	0x1dd,
	0x6f,
	0x1dd,
	0x2de,
	0x1f6,
	0x21d,
	0x237,
	0x242,
	0x245,
	0x245,
	0xb7,
	0x24b,
	0x254,
	0x254,
	0x65,
	0x25c,
	0x25e,
	0x262,
	0x270,
	0x277,
	0x278,
	0x27e,
	0x27f,
	0x280,
	0x283,
	0x283,
	0x283,
	0x283,
	0x283,
	0x283,
	0x283,
	0x283,
	0x283,
	0x283,
	0x28a,
	0x28c,
	0x28d,
	0x298,
	0x299,
	0x29a,
	0x29c,
	0x29f,
	0x2a1,
	0x2c1,
	0x2c7,
	0x2c9,
	0x2c9,
	0x62,
	0x2c9,
	0x62,
	0x69,
	0x2cf,
	0x2ea,
	0x2eb,
	0x2f3,
	0x393,
	0x393,
	0x27,
	0x393,
	0xb7,
	0x394,
	0x394,
	0xb7,
	0x394,
	0x1420,
	0x39e,
	0x3a0,
	0x3a6,
	0x3a8,
	0x3a9,
	0x3b6,
	0x3bb,
	0x3bc,
	0x3be,
	0x3c0,
	0x3c2,
	0x3c7,
	0x3c8,
	0x3c9,
	0x3d7,
	0x3d8,
	0x3dd,
	0x3ec,
	0x40b,
	0x416,
	0x418,
	0x427,
	0x428,
	0x42a,
	0x69,
	0x42d,
	0x436,
	0x43b,
	0x447,
	0x448,
	0x44d,
	0x459,
	0x460,
	0x460,
	0xb7,
	0x4b6,
	0x4b7,
	0x4bc,
	0x4c3,
	0x4fe,
	0x548,
	0x548,
	0x27,
	0x548,
	0xb7,
	0x554,
	0x559,
	0x565,
	0x582,
	0x571,
	0x574,
	0x565,
	0x574,
	0x56b,
	0x574,
	0x56d,
	0x574,
	0x576,
	0x57e,
	0x576,
	0x5d0,
	0x5d0,
	0x5dc,
	0x5d1,
	0x5d2,
	0x5d3,
	0x5d4,
	0x5d6,
	0x5da,
	0x5db,
	0x5dc,
	0x5dd,
	0x5de,
	0x5e0,
	0x5e2,
	0x5e3,
	0x5e4,
	0x5e6,
	0x5e7,
	0x5e8,
	0x5e9,
	0x5ea,
	0x60c,
	0x61b,
	0x61f,
	0x621,
	0x628,
	0x628,
	0x6f,
	0x628,
	0x62c,
	0x628,
	0x62d,
	0x628,
	0x62d,
	0x649,
	0x628,
	0x62e,
	0x628,
	0x62e,
	0x649,
	0x628,
	0x631,
	0x628,
	0x632,
	0x628,
	0x645,
	0x628,
	0x646,
	0x628,
	0x649,
	0x629,
	0x62a,
	0x62a,
	0x6f,
	0x62a,
	0x62c,
	0x62a,
	0x62c,
	0x645,
	0x62a,
	0x62c,
	0x649,
	0x62a,
	0x62d,
	0x62a,
	0x62d,
	0x62c,
	0x62a,
	0x62d,
	0x645,
	0x62a,
	0x62e,
	0x62a,
	0x62e,
	0x645,
	0x62a,
	0x62e,
	0x649,
	0x62a,
	0x631,
	0x62a,
	0x632,
	0x62a,
	0x645,
	0x62a,
	0x645,
	0x62c,
	0x62a,
	0x645,
	0x62d,
	0x62a,
	0x645,
	0x62e,
	0x62a,
	0x645,
	0x649,
	0x62a,
	0x646,
	0x62a,
	0x649,
	0x62c,
	0x62c,
	0x62d,
	0x62c,
	0x62d,
	0x649,
	0x62c,
	0x644,
	0x62c,
	0x644,
	0x69,
	0x644,
	0x6f,
	0x62c,
	0x645,
	0x62c,
	0x645,
	0x62d,
	0x62c,
	0x645,
	0x649,
	0x62c,
	0x649,
	0x62d,
	0x62d,
	0x62c,
	0x62d,
	0x62c,
	0x649,
	0x62d,
	0x645,
	0x62d,
	0x645,
	0x649,
	0x62d,
	0x649,
	0x62e,
	0x62e,
	0x62c,
	0x62e,
	0x62d,
	0x62e,
	0x645,
	0x62e,
	0x649,
	0x62f,
	0x630,
	0x631,
	0x631,
	0x633,
	0x648,
	0x644,
	0x631,
	0x649,
	0x69,
	0x644,
	0x632,
	0x633,
	0x633,
	0x6f,
	0x633,
	0x62c,
	0x633,
	0x62c,
	0x62d,
	0x633,
	0x62c,
	0x649,
	0x633,
	0x62d,
	0x633,
	0x62d,
	0x62c,
	0x633,
	0x62d,
	0x645,
	0x633,
	0x62d,
	0x649,
	0x633,
	0x62e,
	0x633,
	0x62e,
	0x649,
	0x633,
	0x631,
	0x633,
	0x645,
	0x633,
	0x645,
	0x62c,
	0x633,
	0x645,
	0x62d,
	0x633,
	0x645,
	0x62e,
	0x633,
	0x645,
	0x645,
	0x633,
	0x649,
	0x635,
	0x635,
	0x62d,
	0x635,
	0x62d,
	0x62d,
	0x635,
	0x62d,
	0x649,
	0x635,
	0x62e,
	0x635,
	0x631,
	0x635,
	0x644,
	0x639,
	0x645,
	0x635,
	0x644,
	0x649,
	0x635,
	0x644,
	0x649,
	0x69,
	0x644,
	0x644,
	0x6f,
	0x639,
	0x644,
	0x649,
	0x6f,
	0x648,
	0x633,
	0x644,
	0x645,
	0x635,
	0x645,
	0x635,
	0x645,
	0x645,
	0x635,
	0x649,
	0x636,
	0x636,
	0x62c,
	0x636,
	0x62d,
	0x636,
	0x62d,
	0x649,
	0x636,
	0x62e,
	0x636,
	0x62e,
	0x645,
	0x636,
	0x631,
	0x636,
	0x645,
	0x636,
	0x649,
	0x637,
	0x637,
	0x62d,
	0x637,
	0x645,
	0x637,
	0x645,
	0x62d,
	0x637,
	0x645,
	0x645,
	0x637,
	0x645,
	0x649,
	0x637,
	0x649,
	0x638,
	0x638,
	0x645,
	0x639,
	0x639,
	0x62c,
	0x639,
	0x62c,
	0x645,
	0x639,
	0x644,
	0x649,
	0x6f,
	0x639,
	0x645,
	0x639,
	0x645,
	0x645,
	0x639,
	0x645,
	0x649,
	0x639,
	0x649,
	0x63a,
	0x63a,
	0x62c,
	0x63a,
	0x645,
	0x63a,
	0x645,
	0x645,
	0x63a,
	0x645,
	0x649,
	0x63a,
	0x649,
	0x641,
	0x641,
	0x62c,
	0x641,
	0x62d,
	0x641,
	0x62e,
	0x641,
	0x62e,
	0x645,
	0x641,
	0x645,
	0x641,
	0x645,
	0x649,
	0x641,
	0x649,
	0x642,
	0x642,
	0x62d,
	0x642,
	0x644,
	0x649,
	0x642,
	0x645,
	0x642,
	0x645,
	0x62d,
	0x642,
	0x645,
	0x645,
	0x642,
	0x645,
	0x649,
	0x642,
	0x649,
	0x643,
	0x643,
	0x69,
	0x643,
	0x62c,
	0x643,
	0x62d,
	0x643,
	0x62e,
	0x643,
	0x644,
	0x643,
	0x645,
	0x643,
	0x645,
	0x645,
	0x643,
	0x645,
	0x649,
	0x643,
	0x649,
	0x644,
	0x644,
	0x69,
	0x644,
	0x69,
	0x674,
	0x644,
	0x6f,
	0x644,
	0x62c,
	0x644,
	0x62c,
	0x62c,
	0x644,
	0x62c,
	0x645,
	0x644,
	0x62c,
	0x649,
	0x644,
	0x62d,
	0x644,
	0x62d,
	0x645,
	0x644,
	0x62d,
	0x649,
	0x644,
	0x62e,
	0x644,
	0x62e,
	0x645,
	0x644,
	0x645,
	0x644,
	0x645,
	0x62d,
	0x644,
	0x645,
	0x649,
	0x644,
	0x649,
	0x645,
	0x645,
	0x69,
	0x645,
	0x62c,
	0x645,
	0x62c,
	0x62d,
	0x645,
	0x62c,
	0x62e,
	0x645,
	0x62c,
	0x645,
	0x645,
	0x62c,
	0x649,
	0x645,
	0x62d,
	0x645,
	0x62d,
	0x62c,
	0x645,
	0x62d,
	0x645,
	0x645,
	0x62d,
	0x645,
	0x62f,
	0x645,
	0x62d,
	0x649,
	0x645,
	0x62e,
	0x645,
	0x62e,
	0x62c,
	0x645,
	0x62e,
	0x645,
	0x645,
	0x62e,
	0x649,
	0x645,
	0x645,
	0x645,
	0x645,
	0x649,
	0x645,
	0x649,
	0x646,
	0x646,
	0x6f,
	0x646,
	0x62c,
	0x62d,
	0x646,
	0x62c,
	0x645,
	0x646,
	0x62c,
	0x649,
	0x646,
	0x62d,
	0x646,
	0x62d,
	0x645,
	0x646,
	0x62d,
	0x649,
	0x646,
	0x62e,
	0x646,
	0x631,
	0x646,
	0x632,
	0x646,
	0x645,
	0x646,
	0x645,
	0x649,
	0x646,
	0x646,
	0x646,
	0x649,
	0x648,
	0x648,
	0x633,
	0x644,
	0x645,
	0x648,
	0x674,
	0x649,
	0x649,
	0x6f,
	0x649,
	0x62c,
	0x649,
	0x62c,
	0x649,
	0x649,
	0x62d,
	0x649,
	0x62d,
	0x649,
	0x649,
	0x62e,
	0x649,
	0x631,
	0x649,
	0x632,
	0x649,
	0x645,
	0x649,
	0x645,
	0x645,
	0x649,
	0x645,
	0x649,
	0x649,
	0x646,
	0x649,
	0x649,
	0x649,
	0x674,
	0x649,
	0x674,
	0x69,
	0x649,
	0x674,
	0x6f,
	0x649,
	0x674,
	0x62c,
	0x649,
	0x674,
	0x62d,
	0x649,
	0x674,
	0x62e,
	0x649,
	0x674,
	0x631,
	0x649,
	0x674,
	0x632,
	0x649,
	0x674,
	0x645,
	0x649,
	0x674,
	0x646,
	0x649,
	0x674,
	0x648,
	0x649,
	0x674,
	0x649,
	0x649,
	0x674,
	0x67b,
	0x662,
	0x663,
	0x664,
	0x666,
	0x669,
	0x671,
	0x67a,
	0x67b,
	0x67f,
	0x680,
	0x683,
	0x684,
	0x686,
	0x687,
	0x68a,
	0x68c,
	0x68d,
	0x697,
	0x6a1,
	0x6a2,
	0x6a6,
	0x6ac,
	0x6af,
	0x6b1,
	0x6b3,
	0x6c5,
	0x754,
	0x905,
	0x90f,
	0x915,
	0x916,
	0x917,
	0x91c,
	0x921,
	0x922,
	0x928,
	0x92b,
	0x92f,
	0x930,
	0x930,
	0x907,
	0x933,
	0x93d,
	0x964,
	0x964,
	0x964,
	0x968,
	0x969,
	0x96a,
	0x96e,
	0x970,
	0x971,
	0x985,
	0x98b,
	0x998,
	0x99a,
	0x99c,
	0x99e,
	0x99f,
	0x9a1,
	0x9a2,
	0x9a3,
	0x9a4,
	0x9a5,
	0x9a6,
	0x9a7,
	0x9a8,
	0x9aa,
	0x9ac,
	0x9ae,
	0x9af,
	0x9b0,
	0x9b2,
	0x9b7,
	0x9b8,
	0x9bd,
	0x9e7,
	0x9e8,
	0x9ec,
	0xa05,
	0xa16,
	0xa17,
	0xa1c,
	0xa2b,
	0xa32,
	0xa38,
	0xa72,
	0xa73,
	0xa85,
	0xb05,
	0xb21,
	0xb22,
	0xb85,
	0xb88,
	0xb89,
	0xb89,
	0xbb3,
	0xb8e,
	0xb8e,
	0xbb5,
	0xb90,
	0xb92,
	0xbb3,
	0xb95,
	0xb9a,
	0xb9f,
	0xba3,
	0xba8,
	0xba9,
	0xbae,
	0xbaf,
	0xbb3,
	0xbb4,
	0xbb6,
	0xbb7,
	0xbf3,
	0xc05,
	0xc06,
	0xc07,
	0xc0b,
	0xc0c,
	0xc12,
	0xc1c,
	0xc1e,
	0xc21,
	0xc23,
	0xc27,
	0xc2c,
	0xc2f,
	0xc30,
	0xc31,
	0xc32,
	0xc35,
	0xc67,
	0xc68,
	0xc6f,
	0xc8c,
	0xd07,
	0xd0e,
	0xd12,
	0xd1e,
	0xd26,
	0xd30,
	0xd28,
	0xd28,
	0xd28,
	0xd28,
	0xd2e,
	0xd30,
	0xd35,
	0xd30,
	0xd39,
	0xd2e,
	0xda2,
	0xdaf,
	0xde8,
	0xe02,
	0xe04,
	0xe06,
	0xe08,
	0xe0a,
	0xe0e,
	0xe11,
	0xe1a,
	0xe1b,
	0xe1d,
	0xe1e,
	0xe1f,
	0xe20,
	0xe22,
	0xe2f,
	0xe32,
	0xe40,
	0xe40,
	0xe4f,
	0xe5a,
	0xe5b,
	0xeab,
	0xe99,
	0xeab,
	0xea1,
	0xeb2,
	0xf0b,
	0xf0d,
	0xf0d,
	0xf1a,
	0xf1a,
	0xf1a,
	0xf1d,
	0xf1d,
	0xf1a,
	0xf1d,
	0xf1d,
	0xf40,
	0xf42,
	0xf4c,
	0xf51,
	0xf56,
	0xf5b,
	0xf60,
	0xf60,
	0xf14,
	0xf62,
	0xf68,
	0x1002,
	0x1003,
	0x1015,
	0x101e,
	0x1025,
	0x1041,
	0x104a,
	0x104a,
	0x107d,
	0x1100,
	0x1100,
	0x1100,
	0x1100,
	0x1102,
	0x1100,
	0x1103,
	0x1100,
	0x1105,
	0x1100,
	0x1107,
	0x1100,
	0x1109,
	0x1100,
	0x1109,
	0x1100,
	0x1100,
	0x110e,
	0x1100,
	0x110f,
	0x1100,
	0x1112,
	0x1102,
	0x1102,
	0x1100,
	0x1102,
	0x1102,
	0x1102,
	0x1103,
	0x1102,
	0x1105,
	0x1102,
	0x1107,
	0x1102,
	0x1109,
	0x1102,
	0x110c,
	0x1102,
	0x110e,
	0x1102,
	0x1110,
	0x1102,
	0x1112,
	0x1102,
	0x1140,
	0x1103,
	0x1103,
	0x1100,
	0x1103,
	0x1103,
	0x1103,
	0x1103,
	0x1107,
	0x1103,
	0x1105,
	0x1103,
	0x1106,
	0x1103,
	0x1107,
	0x1103,
	0x1109,
	0x1103,
	0x1109,
	0x1100,
	0x1103,
	0x110c,
	0x1103,
	0x110e,
	0x1103,
	0x1110,
	0x1105,
	0x1105,
	0x1100,
	0x1105,
	0x1100,
	0x1100,
	0x1105,
	0x1100,
	0x1109,
	0x1105,
	0x1100,
	0x1112,
	0x1105,
	0x1102,
	0x1105,
	0x1103,
	0x1105,
	0x1103,
	0x1103,
	0x1105,
	0x1103,
	0x1112,
	0x1105,
	0x1105,
	0x1105,
	0x1105,
	0x110f,
	0x1105,
	0x1106,
	0x1105,
	0x1106,
	0x1100,
	0x1105,
	0x1106,
	0x1109,
	0x1105,
	0x1106,
	0x1112,
	0x1105,
	0x1107,
	0x1105,
	0x1107,
	0x1103,
	0x1105,
	0x1107,
	0x1107,
	0x1105,
	0x1107,
	0x1109,
	0x1105,
	0x1107,
	0x110b,
	0x1105,
	0x1107,
	0x1111,
	0x1105,
	0x1107,
	0x1112,
	0x1105,
	0x1109,
	0x1105,
	0x1109,
	0x1109,
	0x1105,
	0x110b,
	0x1105,
	0x110c,
	0x1105,
	0x110f,
	0x1105,
	0x1110,
	0x1105,
	0x1111,
	0x1105,
	0x1112,
	0x1105,
	0x1140,
	0x1105,
	0x114c,
	0x1105,
	0x1159,
	0x1105,
	0x1159,
	0x1112,
	0x1106,
	0x1106,
	0x1100,
	0x1106,
	0x1102,
	0x1106,
	0x1102,
	0x1102,
	0x1106,
	0x1103,
	0x1106,
	0x1105,
	0x1106,
	0x1106,
	0x1106,
	0x1107,
	0x1106,
	0x1107,
	0x1109,
	0x1106,
	0x1109,
	0x1106,
	0x1109,
	0x1109,
	0x1106,
	0x110b,
	0x1106,
	0x110c,
	0x1106,
	0x110e,
	0x1106,
	0x1112,
	0x1106,
	0x1140,
	0x1107,
	0x1107,
	0x1100,
	0x1107,
	0x1102,
	0x1107,
	0x1103,
	0x1107,
	0x1105,
	0x1107,
	0x1105,
	0x1111,
	0x1107,
	0x1106,
	0x1107,
	0x1107,
	0x1107,
	0x1107,
	0x110b,
	0x1107,
	0x1109,
	0x1107,
	0x1109,
	0x1100,
	0x1107,
	0x1109,
	0x1103,
	0x1107,
	0x1109,
	0x1107,
	0x1107,
	0x1109,
	0x1109,
	0x1107,
	0x1109,
	0x110c,
	0x1107,
	0x1109,
	0x1110,
	0x1107,
	0x110b,
	0x1107,
	0x110c,
	0x1107,
	0x110e,
	0x1107,
	0x110f,
	0x1107,
	0x1110,
	0x1107,
	0x1111,
	0x1107,
	0x1112,
	0x1109,
	0x1109,
	0x1100,
	0x1109,
	0x1102,
	0x1109,
	0x1103,
	0x1109,
	0x1105,
	0x1109,
	0x1106,
	0x1109,
	0x1107,
	0x1109,
	0x1107,
	0x1100,
	0x1109,
	0x1107,
	0x110b,
	0x1109,
	0x1109,
	0x1109,
	0x1109,
	0x1100,
	0x1109,
	0x1109,
	0x1103,
	0x1109,
	0x1109,
	0x1107,
	0x1109,
	0x1109,
	0x1109,
	0x1109,
	0x110b,
	0x1109,
	0x110c,
	0x1109,
	0x110e,
	0x1109,
	0x110f,
	0x1109,
	0x1110,
	0x1109,
	0x1111,
	0x1109,
	0x1140,
	0x110b,
	0x110b,
	0x1100,
	0x110b,
	0x1100,
	0x1100,
	0x110b,
	0x1103,
	0x110b,
	0x1105,
	0x110b,
	0x1106,
	0x110b,
	0x1107,
	0x110b,
	0x1109,
	0x110b,
	0x110b,
	0x110b,
	0x110c,
	0x110b,
	0x110e,
	0x110b,
	0x110f,
	0x110b,
	0x1110,
	0x110b,
	0x1111,
	0x110b,
	0x1112,
	0x110b,
	0x1140,
	0x110c,
	0x110c,
	0x1107,
	0x110c,
	0x1107,
	0x1107,
	0x110c,
	0x110b,
	0x110c,
	0x110c,
	0x110c,
	0x110c,
	0x1112,
	0x110e,
	0x110e,
	0x110f,
	0x110e,
	0x1112,
	0x110f,
	0x1110,
	0x1110,
	0x1110,
	0x1111,
	0x1111,
	0x1107,
	0x1111,
	0x1109,
	0x1111,
	0x110b,
	0x1111,
	0x1110,
	0x1111,
	0x1112,
	0x1112,
	0x1112,
	0x1102,
	0x1112,
	0x1105,
	0x1112,
	0x1106,
	0x1112,
	0x1107,
	0x1112,
	0x1109,
	0x1112,
	0x1112,
	0x113c,
	0x113c,
	0x113e,
	0x113e,
	0x1140,
	0x1140,
	0x1107,
	0x1140,
	0x1107,
	0x110b,
	0x114c,
	0x114c,
	0x1106,
	0x114c,
	0x1112,
	0x114e,
	0x114e,
	0x1150,
	0x1150,
	0x1159,
	0x1159,
	0x1159,
	0x1160,
	0x1161,
	0x1161,
	0x1169,
	0x1161,
	0x116e,
	0x1161,
	0x30fc,
	0x1161,
	0x4e28,
	0x1163,
	0x1163,
	0x1169,
	0x1163,
	0x116d,
	0x1163,
	0x116e,
	0x1163,
	0x4e28,
	0x1165,
	0x1165,
	0x1169,
	0x1165,
	0x116e,
	0x1165,
	0x30fc,
	0x1165,
	0x4e28,
	0x1167,
	0x1167,
	0x1163,
	0x1167,
	0x1169,
	0x1167,
	0x116e,
	0x1167,
	0x4e28,
	0x1169,
	0x1169,
	0x1161,
	0x1169,
	0x1161,
	0x4e28,
	0x1169,
	0x1163,
	0x1169,
	0x1163,
	0x4e28,
	0x1169,
	0x1165,
	0x1169,
	0x1165,
	0x4e28,
	0x1169,
	0x1167,
	0x1169,
	0x1167,
	0x4e28,
	0x1169,
	0x1169,
	0x1169,
	0x1169,
	0x4e28,
	0x1169,
	0x116e,
	0x1169,
	0x4e28,
	0x116d,
	0x116d,
	0x1161,
	0x116d,
	0x1161,
	0x4e28,
	0x116d,
	0x1163,
	0x116d,
	0x1163,
	0x4e28,
	0x116d,
	0x1165,
	0x116d,
	0x1169,
	0x116d,
	0x4e28,
	0x116e,
	0x116e,
	0x1161,
	0x116e,
	0x1161,
	0x4e28,
	0x116e,
	0x1165,
	0x116e,
	0x1165,
	0x30fc,
	0x116e,
	0x1165,
	0x4e28,
	0x116e,
	0x1167,
	0x116e,
	0x1167,
	0x4e28,
	0x116e,
	0x116e,
	0x116e,
	0x4e28,
	0x116e,
	0x4e28,
	0x4e28,
	0x1172,
	0x1172,
	0x1161,
	0x1172,
	0x1161,
	0x4e28,
	0x1172,
	0x1165,
	0x1172,
	0x1165,
	0x4e28,
	0x1172,
	0x1167,
	0x1172,
	0x1167,
	0x4e28,
	0x1172,
	0x1169,
	0x1172,
	0x116e,
	0x1172,
	0x4e28,
	0x119e,
	0x119e,
	0x1161,
	0x119e,
	0x1165,
	0x119e,
	0x1165,
	0x4e28,
	0x119e,
	0x116e,
	0x119e,
	0x119e,
	0x119e,
	0x4e28,
	0x1206,
	0x1261,
	0x12ae,
	0x1323,
	0x13ef,
	0x1401,
	0xb7,
	0x1401,
	0x1420,
	0x1404,
	0xb7,
	0x1405,
	0xb7,
	0x1405,
	0x1420,
	0x1406,
	0xb7,
	0x140a,
	0xb7,
	0x140a,
	0x1420,
	0x140b,
	0xb7,
	0x141e,
	0x18df,
	0x1421,
	0x1429,
	0x1432,
	0xb7,
	0x1434,
	0xb7,
	0x1435,
	0x1439,
	0xb7,
	0x144f,
	0xb7,
	0x1450,
	0x1450,
	0x27,
	0x1450,
	0x2f,
	0x1450,
	0xb7,
	0x1450,
	0x1455,
	0x1451,
	0xb7,
	0x1455,
	0x1455,
	0x27,
	0x1455,
	0xb7,
	0x1456,
	0xb7,
	0x146b,
	0x27,
	0x146b,
	0xb7,
	0x146e,
	0xb7,
	0x1470,
	0xb7,
	0x1472,
	0x27,
	0x1472,
	0xb7,
	0x1473,
	0xb7,
	0x1489,
	0x1489,
	0xb7,
	0x148b,
	0xb7,
	0x148c,
	0xb7,
	0x148e,
	0xb7,
	0x1490,
	0x1490,
	0xb7,
	0x1491,
	0xb7,
	0x14a3,
	0xb7,
	0x14a6,
	0xb7,
	0x14a7,
	0xb7,
	0x14a8,
	0xb7,
	0x14ab,
	0xb7,
	0x14c0,
	0xb7,
	0x14c2,
	0xb7,
	0x14c3,
	0xb7,
	0x14c4,
	0xb7,
	0x14c5,
	0xb7,
	0x14c7,
	0xb7,
	0x14c8,
	0xb7,
	0x14d3,
	0x14d3,
	0xb7,
	0x14d5,
	0xb7,
	0x14d6,
	0xb7,
	0x14d7,
	0xb7,
	0x14d8,
	0xb7,
	0x14da,
	0x14da,
	0xb7,
	0x14db,
	0xb7,
	0x14ed,
	0xb7,
	0x14ef,
	0xb7,
	0x14f0,
	0xb7,
	0x14f1,
	0xb7,
	0x14f2,
	0xb7,
	0x14f4,
	0xb7,
	0x14f5,
	0xb7,
	0x150b,
	0x3c,
	0x150b,
	0x1455,
	0x150b,
	0x1472,
	0x150b,
	0x1490,
	0x1510,
	0xb7,
	0x1511,
	0xb7,
	0x1512,
	0xb7,
	0x1513,
	0xb7,
	0x1514,
	0xb7,
	0x1515,
	0xb7,
	0x1516,
	0xb7,
	0x1528,
	0xb7,
	0x1529,
	0xb7,
	0x152a,
	0xb7,
	0x152b,
	0xb7,
	0x152d,
	0xb7,
	0x152e,
	0xb7,
	0x1543,
	0x1543,
	0xb7,
	0x1546,
	0x154a,
	0x154c,
	0xb7,
	0x1550,
	0x50,
	0x1550,
	0x64,
	0x1550,
	0x146b,
	0x1550,
	0x146c,
	0x1550,
	0x146e,
	0x1550,
	0x1470,
	0x1550,
	0x1472,
	0x1550,
	0x1473,
	0x1550,
	0x1483,
	0x155a,
	0xb7,
	0x155e,
	0xb7,
	0x1566,
	0xb7,
	0x1567,
	0xb7,
	0x156b,
	0xb7,
	0x1586,
	0xb7,
	0x1595,
	0x4a,
	0x1595,
	0x1489,
	0x1595,
	0x148a,
	0x1595,
	0x148b,
	0x1595,
	0x148c,
	0x1595,
	0x148e,
	0x1595,
	0x1490,
	0x1595,
	0x1491,
	0x1596,
	0x4a,
	0x1596,
	0x148b,
	0x1596,
	0x148c,
	0x1596,
	0x148e,
	0x1596,
	0x1490,
	0x1596,
	0x1491,
	0x1597,
	0xb7,
	0x15a7,
	0xb7,
	0x15a8,
	0xb7,
	0x15a9,
	0xb7,
	0x15aa,
	0xb7,
	0x15ab,
	0xb7,
	0x15ac,
	0xb7,
	0x15ad,
	0xb7,
	0x15d2,
	0x15d5,
	0x15e1,
	0x15f4,
	0xb7,
	0x161b,
	0xb7,
	0x1646,
	0x1660,
	0x16b9,
	0x16bc,
	0x16bd,
	0x16cb,
	0x16cf,
	0x16d0,
	0x16d0,
	0x16da,
	0x16d0,
	0x21c2,
	0x16da,
	0x16dc,
	0x16de,
	0x16e6,
	0x16e8,
	0x16ef,
	0x17a2,
	0x1835,
	0x185c,
	0x18d4,
	0x18d6,
	0x18df,
	0x141e,
	0x18f3,
	0x18f4,
	0x18f5,
	0x199e,
	0x19b1,
	0x1a45,
	0x1aa8,
	0x1aa8,
	0x1aaa,
	0x1aa8,
	0x1b05,
	0x1b07,
	0x1b09,
	0x1b0b,
	0x1b0d,
	0x1b11,
	0x1b28,
	0x1b50,
	0x1b5e,
	0x1b5e,
	0x1c3b,
	0x1c3b,
	0x1c7e,
	0x1c7e,
	0x1d00,
	0x1d05,
	0x1d07,
	0x1d0a,
	0x1d0e,
	0x1d18,
	0x1d19,
	0x1d1b,
	0x1d34,
	0x1d4b,
	0x1d4d,
	0x1e9f,
	0x2081,
	0x2080,
	0x20b8,
	0x2117,
	0x2132,
	0x2144,
	0x2190,
	0x2192,
	0x2194,
	0x219e,
	0x219f,
	0x21a0,
	0x21a1,
	0x21b2,
	0x21c3,
	0x16da,
	0x21c3,
	0x21c2,
	0x21d0,
	0x21d2,
	0x21d4,
	0x2202,
	0x2205,
	0x2207,
	0x2208,
	0x220b,
	0x220e,
	0x2210,
	0x2220,
	0x2227,
	0x222e,
	0x222e,
	0x222e,
	0x222e,
	0x222e,
	0x2234,
	0x2235,
	0x2237,
	0x2243,
	0x2245,
	0x2248,
	0x224d,
	0x224f,
	0x2261,
	0x2264,
	0x2265,
	0x2272,
	0x2273,
	0x2276,
	0x2277,
	0x227a,
	0x227b,
	0x227c,
	0x227d,
	0x2286,
	0x2287,
	0x228d,
	0x228e,
	0x228f,
	0x2290,
	0x2291,
	0x2292,
	0x2293,
	0x2294,
	0x2297,
	0x229b,
	0x22a0,
	0x22a1,
	0x22a2,
	0x22a8,
	0x22a9,
	0x22ab,
	0x22b2,
	0x22b3,
	0x22b4,
	0x22b5,
	0x22c6,
	0x2307,
	0x2312,
	0x2319,
	0x2324,
	0x233b,
	0x233e,
	0x2342,
	0x2349,
	0x234b,
	0x234e,
	0x2355,
	0x2365,
	0x236d,
	0x2388,
	0x23dc,
	0x23dd,
	0x23de,
	0x23df,
	0x23e0,
	0x23e1,
	0x23e5,
	0x23fb,
	0x24be,
	0x2502,
	0x250c,
	0x251c,
	0x258c,
	0x2596,
	0x2598,
	0x25a1,
	0x25aa,
	0x25b6,
	0x2627,
	0x2629,
	0x263d,
	0x263e,
	0x276c,
	0x276d,
	0x2780,
	0x2781,
	0x2782,
	0x2783,
	0x2784,
	0x2785,
	0x2786,
	0x2787,
	0x2788,
	0x2789,
	0x27e6,
	0x27e7,
	0x299a,
	0x29df,
	0x2a1f,
	0x2add,
	0x2c3f,
	0x2c6f,
	0x2c70,
	0x2c75,
	0x2c76,
	0x2cb6,
	0x2ce8,
	0x2d40,
	0x2d42,
	0x2d57,
	0x301c,
	0x303c,
	0x3046,
	0x304b,
	0x304d,
	0x3051,
	0x3053,
	0x3055,
	0x3057,
	0x3059,
	0x305b,
	0x305d,
	0x305f,
	0x3061,
	0x3064,
	0x3066,
	0x3068,
	0x306f,
	0x3072,
	0x3075,
	0x3078,
	0x307b,
	0x309d,
	0x30a6,
	0x30ad,
	0x30af,
	0x30b1,
	0x30b3,
	0x30b5,
	0x30b7,
	0x30b9,
	0x30bb,
	0x30bd,
	0x30c1,
	0x30c4,
	0x30c6,
	0x30d2,
	0x30d5,
	0x30db,
	0x30ef,
	0x30f0,
	0x30f1,
	0x30f2,
	0x30fc,
	0x30fc,
	0x1161,
	0x30fc,
	0x1165,
	0x30fc,
	0x1165,
	0x4e28,
	0x30fc,
	0x1169,
	0x30fc,
	0x116e,
	0x30fc,
	0x30fc,
	0x30fc,
	0x4e28,
	0x30fc,
	0x4e28,
	0x116e,
	0x30fd,
	0x349e,
	0x34b9,
	0x34bb,
	0x34df,
	0x3515,
	0x353e,
	0x3588,
	0x363d,
	0x36ee,
	0x36fc,
	0x3781,
	0x382f,
	0x3862,
	0x387c,
	0x38c7,
	0x38e3,
	0x38fa,
	0x391c,
	0x393a,
	0x3a2e,
	0x3a41,
	0x3a6c,
	0x3ada,
	0x3ae4,
	0x3b08,
	0x3b19,
	0x3b35,
	0x3b3a,
	0x3b3b,
	0x3b49,
	0x3b9d,
	0x3ba3,
	0x3c18,
	0x3c4e,
	0x3d33,
	0x3d96,
	0x3eac,
	0x3eb8,
	0x3f1b,
	0x3ffc,
	0x4008,
	0x4018,
	0x4039,
	0x403f,
	0x4046,
	0x4096,
	0x40e3,
	0x412f,
	0x4202,
	0x4227,
	0x42a0,
	0x4301,
	0x4334,
	0x4359,
	0x43d5,
	0x43d9,
	0x440b,
	0x4443,
	0x446b,
	0x452b,
	0x455d,
	0x4561,
	0x456b,
	0x45d7,
	0x45f9,
	0x4635,
	0x46b6,
	0x46be,
	0x46c7,
	0x4995,
	0x49e6,
	0x4a6e,
	0x4a76,
	0x4ab2,
	0x4b33,
	0x4bce,
	0x4cce,
	0x4ced,
	0x4cf8,
	0x4d56,
	0x4e0d,
	0x4e26,
	0x4e28,
	0x4e28,
	0x1161,
	0x4e28,
	0x1163,
	0x4e28,
	0x1163,
	0x1169,
	0x4e28,
	0x1163,
	0x4e28,
	0x4e28,
	0x1167,
	0x4e28,
	0x1167,
	0x4e28,
	0x4e28,
	0x1169,
	0x4e28,
	0x1169,
	0x4e28,
	0x4e28,
	0x116d,
	0x4e28,
	0x116e,
	0x4e28,
	0x1172,
	0x4e28,
	0x119e,
	0x4e28,
	0x30fc,
	0x4e28,
	0x4e28,
	0x4e2c,
	0x4e32,
	0x4e38,
	0x4e39,
	0x4e3d,
	0x4e41,
	0x4e59,
	0x4e5a,
	0x4e5b,
	0x4e80,
	0x4e82,
	0x4e85,
	0x4e86,
	0x4e8c,
	0x4ea0,
	0x4eae,
	0x4eba,
	0x4ebb,
	0x4ec0,
	0x4ecc,
	0x4ee4,
	0x4f60,
	0x4f75,
	0x4f80,
	0x4f86,
	0x4f8b,
	0x4fae,
	0x4fbb,
	0x4fbf,
	0x5024,
	0x502b,
	0x507a,
	0x5099,
	0x50cf,
	0x50da,
	0x50e7,
	0x513f,
	0x5140,
	0x5145,
	0x514d,
	0x5154,
	0x5164,
	0x5165,
	0x5167,
	0x5168,
	0x5169,
	0x516b,
	0x516d,
	0x5177,
	0x5180,
	0x5182,
	0x518d,
	0x5192,
	0x5195,
	0x5196,
	0x5197,
	0x51a4,
	0x51ab,
	0x51ac,
	0x51b5,
	0x51b7,
	0x51c9,
	0x51cc,
	0x51dc,
	0x51de,
	0x51e0,
	0x51f5,
	0x5200,
	0x5202,
	0x5203,
	0x5207,
	0x5217,
	0x5229,
	0x523a,
	0x523b,
	0x5246,
	0x5272,
	0x5277,
	0x5289,
	0x529b,
	0x52a3,
	0x52b3,
	0x52c7,
	0x52c9,
	0x52d2,
	0x52de,
	0x52e4,
	0x52f5,
	0x52f9,
	0x52fa,
	0x5305,
	0x5306,
	0x5315,
	0x5317,
	0x531a,
	0x5338,
	0x533f,
	0x5341,
	0x5344,
	0x5345,
	0x5349,
	0x534d,
	0x5350,
	0x5351,
	0x535a,
	0x535c,
	0x5369,
	0x5373,
	0x5375,
	0x537d,
	0x537f,
	0x5382,
	0x53b6,
	0x53c3,
	0x53c8,
	0x53ca,
	0x53df,
	0x53e3,
	0x53e5,
	0x53eb,
	0x53f1,
	0x5406,
	0x540f,
	0x541d,
	0x5438,
	0x5442,
	0x5448,
	0x5468,
	0x549e,
	0x54a2,
	0x54bd,
	0x54f6,
	0x5510,
	0x5553,
	0x5555,
	0x5563,
	0x5584,
	0x5587,
	0x5599,
	0x559d,
	0x55ab,
	0x55b3,
	0x55c0,
	0x55c2,
	0x55e2,
	0x5606,
	0x5651,
	0x5668,
	0x5674,
	0x56f9,
	0x5716,
	0x5717,
	0x571f,
	0x578b,
	0x57ce,
	0x57f4,
	0x580d,
	0x5831,
	0x5832,
	0x5840,
	0x585a,
	0x585e,
	0x5861,
	0x58a8,
	0x58ab,
	0x58ac,
	0x58b3,
	0x58d8,
	0x58df,
	0x58ee,
	0x58f2,
	0x58f7,
	0x5902,
	0x5906,
	0x590a,
	0x5915,
	0x591a,
	0x5922,
	0x5927,
	0x5944,
	0x5948,
	0x5951,
	0x5954,
	0x5962,
	0x5973,
	0x59d8,
	0x59ec,
	0x5a1b,
	0x5a27,
	0x5a62,
	0x5a66,
	0x5aaf,
	0x5ab5,
	0x5b08,
	0x5b28,
	0x5b3e,
	0x5b50,
	0x5b80,
	0x5b85,
	0x5bc3,
	0x5bd8,
	0x5be7,
	0x5bee,
	0x5bf3,
	0x5bf8,
	0x5bff,
	0x5c06,
	0x5c0f,
	0x5c22,
	0x5c23,
	0x5c38,
	0x5c3f,
	0x5c60,
	0x5c62,
	0x5c64,
	0x5c65,
	0x5c6e,
	0x5c71,
	0x5c8d,
	0x5cc0,
	0x5d19,
	0x5d43,
	0x5d50,
	0x5d6b,
	0x5d6e,
	0x5d7c,
	0x5db2,
	0x5dba,
	0x5ddb,
	0x5de1,
	0x5de2,
	0x5de5,
	0x5df1,
	0x5df3,
	0x5dfd,
	0x5dfe,
	0x5e21,
	0x5e28,
	0x5e3d,
	0x5e69,
	0x5e72,
	0x5e74,
	0x5e7a,
	0x5e7f,
	0x5ea6,
	0x5eb0,
	0x5eb3,
	0x5eb6,
	0x5ec9,
	0x5eca,
	0x5ed2,
	0x5ed3,
	0x5ed9,
	0x5eec,
	0x5ef4,
	0x5efe,
	0x5f04,
	0x5f0b,
	0x5f13,
	0x5f22,
	0x5f50,
	0x5f51,
	0x5f53,
	0x5f61,
	0x5f62,
	0x5f69,
	0x5f6b,
	0x5f73,
	0x5f8b,
	0x5f9a,
	0x5fa9,
	0x5fad,
	0x5fc3,
	0x5fc4,
	0x5fcd,
	0x5fd7,
	0x5ff5,
	0x5ff9,
	0x6012,
	0x601c,
	0x6075,
	0x6081,
	0x6094,
	0x60c7,
	0x60d8,
	0x60e1,
	0x6108,
	0x6144,
	0x6148,
	0x614c,
	0x614e,
	0x6160,
	0x6168,
	0x617a,
	0x618e,
	0x6190,
	0x61a4,
	0x61af,
	0x61b2,
	0x61de,
	0x61f2,
	0x61f6,
	0x6200,
	0x6208,
	0x6210,
	0x621b,
	0x622e,
	0x6234,
	0x6236,
	0x624b,
	0x624c,
	0x625d,
	0x62b1,
	0x62c9,
	0x62cf,
	0x62d3,
	0x62d4,
	0x62fc,
	0x62fe,
	0x633d,
	0x6350,
	0x6368,
	0x637b,
	0x6383,
	0x63a0,
	0x63a9,
	0x63c4,
	0x63c5,
	0x63e4,
	0x641c,
	0x6422,
	0x6452,
	0x6469,
	0x6477,
	0x647e,
	0x649a,
	0x649d,
	0x64c4,
	0x652f,
	0x6534,
	0x6535,
	0x654f,
	0x6556,
	0x656c,
	0x6578,
	0x6587,
	0x6589,
	0x6597,
	0x6599,
	0x65a4,
	0x65b9,
	0x65c5,
	0x65e0,
	0x65e1,
	0x65e2,
	0x65e3,
	0x65e5,
	0x6613,
	0x6649,
	0x665a,
	0x6674,
	0x6688,
	0x6691,
	0x669c,
	0x66b4,
	0x66c6,
	0x66f0,
	0x66f4,
	0x66f8,
	0x6700,
	0x6708,
	0x670c,
	0x670f,
	0x6710,
	0x6713,
	0x6717,
	0x6718,
	0x671b,
	0x6721,
	0x6723,
	0x6728,
	0x674e,
	0x6753,
	0x6756,
	0x675e,
	0x676e,
	0x677b,
	0x6785,
	0x6797,
	0x67f3,
	0x67fa,
	0x6817,
	0x681f,
	0x6852,
	0x6881,
	0x6885,
	0x688e,
	0x68a8,
	0x6914,
	0x6942,
	0x699d,
	0x69a3,
	0x69ea,
	0x6a02,
	0x6a13,
	0x6aa8,
	0x6ad3,
	0x6adb,
	0x6b04,
	0x6b20,
	0x6b21,
	0x6b54,
	0x6b62,
	0x6b6f,
	0x6b72,
	0x6b77,
	0x6b79,
	0x6b7a,
	0x6b9f,
	0x6bae,
	0x6bb3,
	0x6bba,
	0x6bbb,
	0x6bcb,
	0x6bcd,
	0x6bd4,
	0x6bdb,
	0x6c0f,
	0x6c11,
	0x6c14,
	0x6c34,
	0x6c35,
	0x6c3a,
	0x6c4e,
	0x6c67,
	0x6c88,
	0x6cbf,
	0x6ccc,
	0x6ccd,
	0x6ce5,
	0x6d16,
	0x6d1b,
	0x6d1e,
	0x6d34,
	0x6d3e,
	0x6d41,
	0x6d69,
	0x6d6a,
	0x6d77,
	0x6d78,
	0x6d85,
	0x6dcb,
	0x6dda,
	0x6dea,
	0x6df9,
	0x6e1a,
	0x6e2f,
	0x6e6e,
	0x6e88,
	0x6e9c,
	0x6eba,
	0x6ec7,
	0x6ecb,
	0x6ed1,
	0x6edb,
	0x6f0f,
	0x6f22,
	0x6f23,
	0x6f6e,
	0x6fc6,
	0x6feb,
	0x6ffe,
	0x701b,
	0x701e,
	0x7039,
	0x704a,
	0x706b,
	0x706c,
	0x7070,
	0x7077,
	0x707d,
	0x7099,
	0x70ad,
	0x70c8,
	0x70d9,
	0x7145,
	0x7149,
	0x716e,
	0x719c,
	0x71ce,
	0x71d0,
	0x7210,
	0x721b,
	0x7228,
	0x722a,
	0x722b,
	0x7235,
	0x7236,
	0x723b,
	0x723f,
	0x7247,
	0x7250,
	0x7259,
	0x725b,
	0x7262,
	0x7280,
	0x7295,
	0x72ac,
	0x72ad,
	0x72af,
	0x72c0,
	0x72fc,
	0x732a,
	0x7375,
	0x737a,
	0x7384,
	0x7387,
	0x7389,
	0x738b,
	0x73a5,
	0x73b2,
	0x73de,
	0x7406,
	0x7409,
	0x7422,
	0x7447,
	0x745c,
	0x7469,
	0x7471,
	0x7485,
	0x7489,
	0x7498,
	0x74ca,
	0x74dc,
	0x74e6,
	0x7506,
	0x7518,
	0x751f,
	0x7524,
	0x7528,
	0x7530,
	0x753b,
	0x753e,
	0x7559,
	0x7565,
	0x7570,
	0x758b,
	0x7592,
	0x75e2,
	0x7610,
	0x761d,
	0x761f,
	0x7642,
	0x7669,
	0x7676,
	0x767d,
	0x76ae,
	0x76bf,
	0x76ca,
	0x76db,
	0x76e7,
	0x76ee,
	0x76f4,
	0x7701,
	0x771e,
	0x771f,
	0x7740,
	0x774a,
	0x778b,
	0x77a7,
	0x77db,
	0x77e2,
	0x77f3,
	0x7814,
	0x784e,
	0x786b,
	0x788c,
	0x7891,
	0x78ca,
	0x78cc,
	0x78fb,
	0x792a,
	0x793a,
	0x793b,
	0x793c,
	0x793e,
	0x7948,
	0x7949,
	0x7950,
	0x7956,
	0x795d,
	0x795e,
	0x7965,
	0x797f,
	0x798d,
	0x798e,
	0x798f,
	0x79ae,
	0x79b8,
	0x79be,
	0x79ca,
	0x79eb,
	0x7a1c,
	0x7a40,
	0x7a4a,
	0x7a4f,
	0x7a74,
	0x7a81,
	0x7ab1,
	0x7acb,
	0x7adc,
	0x7aee,
	0x7af9,
	0x7b20,
	0x7bc0,
	0x7bc6,
	0x7bc9,
	0x7c3e,
	0x7c60,
	0x7c73,
	0x7c7b,
	0x7c92,
	0x7cbe,
	0x7cd2,
	0x7cd6,
	0x7ce3,
	0x7ce7,
	0x7ce8,
	0x7cf8,
	0x7cf9,
	0x7d00,
	0x7d10,
	0x7d22,
	0x7d2f,
	0x7d55,
	0x7d5b,
	0x7d63,
	0x7da0,
	0x7dbe,
	0x7dc7,
	0x7df4,
	0x7e02,
	0x7e09,
	0x7e37,
	0x7e41,
	0x7e45,
	0x7f36,
	0x7f3e,
	0x7f51,
	0x7f52,
	0x7f53,
	0x7f72,
	0x7f79,
	0x7f7a,
	0x7f85,
	0x7f8a,
	0x7f95,
	0x7f9a,
	0x7fbd,
	0x7ffa,
	0x8001,
	0x8002,
	0x8005,
	0x800c,
	0x8012,
	0x8033,
	0x8046,
	0x8060,
	0x806f,
	0x8070,
	0x807e,
	0x807f,
	0x8080,
	0x8089,
	0x808b,
	0x80ad,
	0x80b2,
	0x80fc,
	0x8103,
	0x813e,
	0x81d8,
	0x81e3,
	0x81e8,
	0x81ea,
	0x81ed,
	0x81f3,
	0x81fc,
	0x8201,
	0x8204,
	0x820c,
	0x8218,
	0x821b,
	0x821f,
	0x826e,
	0x826f,
	0x8272,
	0x8278,
	0x8279,
	0x828b,
	0x8291,
	0x829d,
	0x82b1,
	0x82b3,
	0x82bd,
	0x82e5,
	0x82e6,
	0x831d,
	0x8323,
	0x8336,
	0x8352,
	0x8353,
	0x8363,
	0x83ad,
	0x83bd,
	0x83c9,
	0x83ca,
	0x83cc,
	0x83dc,
	0x83e7,
	0x83ef,
	0x83f1,
	0x843d,
	0x8449,
	0x8457,
	0x848d,
	0x84ee,
	0x84f1,
	0x84f3,
	0x84fc,
	0x8516,
	0x8564,
	0x85cd,
	0x85fa,
	0x8606,
	0x8612,
	0x862d,
	0x8637,
	0x863f,
	0x864d,
	0x864e,
	0x8650,
	0x865c,
	0x8667,
	0x8669,
	0x866b,
	0x8688,
	0x86a9,
	0x86e2,
	0x870e,
	0x8728,
	0x876b,
	0x8779,
	0x8786,
	0x87ba,
	0x87e1,
	0x8801,
	0x881f,
	0x8840,
	0x884c,
	0x8860,
	0x8863,
	0x8864,
	0x88c2,
	0x88cf,
	0x88d7,
	0x88de,
	0x88e1,
	0x88f8,
	0x88fa,
	0x8910,
	0x8941,
	0x8964,
	0x897e,
	0x897f,
	0x8980,
	0x8986,
	0x898b,
	0x8996,
	0x89c1,
	0x89d2,
	0x8a00,
	0x8a2e,
	0x8aa0,
	0x8aaa,
	0x8abf,
	0x8acb,
	0x8ad2,
	0x8ad6,
	0x8aed,
	0x8af8,
	0x8afe,
	0x8b01,
	0x8b39,
	0x8b58,
	0x8b80,
	0x8b86,
	0x8b8a,
	0x8ba0,
	0x8c37,
	0x8c46,
	0x8c48,
	0x8c55,
	0x8c5c,
	0x8c78,
	0x8c9d,
	0x8cab,
	0x8cc1,
	0x8cc2,
	0x8cc8,
	0x8cd3,
	0x8d08,
	0x8d1b,
	0x8d1d,
	0x8d64,
	0x8d70,
	0x8d77,
	0x8d7f,
	0x8db3,
	0x8dbc,
	0x8dcb,
	0x8de5,
	0x8def,
	0x8df0,
	0x8e97,
	0x8eab,
	0x8eca,
	0x8ed4,
	0x8eff,
	0x8f26,
	0x8f2a,
	0x8f38,
	0x8f3b,
	0x8f62,
	0x8f66,
	0x8f9b,
	0x8f9e,
	0x8fb0,
	0x8fb5,
	0x8fb6,
	0x9023,
	0x9038,
	0x9072,
	0x907c,
	0x908f,
	0x9091,
	0x9094,
	0x90ce,
	0x90f1,
	0x90fd,
	0x9111,
	0x911b,
	0x9149,
	0x916a,
	0x9199,
	0x91b4,
	0x91c6,
	0x91cc,
	0x91cf,
	0x91d1,
	0x9234,
	0x9238,
	0x9276,
	0x927c,
	0x92d7,
	0x92d8,
	0x9304,
	0x934a,
	0x93ad,
	0x93f9,
	0x9415,
	0x9485,
	0x9577,
	0x9578,
	0x957f,
	0x9580,
	0x958b,
	0x95ad,
	0x95b7,
	0x95e8,
	0x961c,
	0x961d,
	0x962e,
	0x964b,
	0x964d,
	0x9675,
	0x9678,
	0x967c,
	0x9686,
	0x96a3,
	0x96b6,
	0x96b7,
	0x96b9,
	0x96c3,
	0x96e2,
	0x96e3,
	0x96e8,
	0x96f6,
	0x96f7,
	0x9723,
	0x9732,
	0x9748,
	0x9751,
	0x9752,
	0x9756,
	0x975e,
	0x9762,
	0x9769,
	0x97cb,
	0x97db,
	0x97e0,
	0x97e6,
	0x97ed,
	0x97f3,
	0x97ff,
	0x9801,
	0x980b,
	0x9818,
	0x9829,
	0x983b,
	0x985e,
	0x9875,
	0x98a8,
	0x98ce,
	0x98db,
	0x98de,
	0x98df,
	0x98e0,
	0x98e2,
	0x98ef,
	0x98fc,
	0x9928,
	0x9929,
	0x9963,
	0x9996,
	0x9999,
	0x99a7,
	0x99ac,
	0x99c2,
	0x99f1,
	0x99fe,
	0x9a6a,
	0x9a6c,
	0x9aa8,
	0x9ad8,
	0x9adf,
	0x9b12,
	0x9b25,
	0x9b2f,
	0x9b32,
	0x9b3c,
	0x9b5a,
	0x9b6f,
	0x9c40,
	0x9c57,
	0x9c7c,
	0x9ce5,
	0x9cfd,
	0x9d67,
	0x9db4,
	0x9dfa,
	0x9e1e,
	0x9e42,
	0x9e75,
	0x9e7f,
	0x9e97,
	0x9e9f,
	0x9ea5,
	0x9ea6,
	0x9ebb,
	0x9ec3,
	0x9ec4,
	0x9ecd,
	0x9ece,
	0x9ed1,
	0x9ef9,
	0x9efd,
	0x9efe,
	0x9f05,
	0x9f0e,
	0x9f0f,
	0x9f13,
	0x9f16,
	0x9f20,
	0x9f3b,
	0x9f43,
	0x9f4a,
	0x9f50,
	0x9f52,
	0x9f7f,
	0x9f8d,
	0x9f8e,
	0x9f99,
	0x9f9c,
	0x9f9f,
	0x9fa0,
	0xa04a,
	0xa050,
	0xa0c0,
	0xa132,
	0xa259,
	0xa2b1,
	0xa2cd,
	0xa3ab,
	0xa3b5,
	0xa3bf,
	0xa3c2,
	0xa458,
	0xa4d5,
	0xa4e4,
	0xa4e8,
	0xa4f6,
	0xa64c,
	0xa658,
	0xa669,
	0xa6f3,
	0xa6f3,
	0xa727,
	0xa73e,
	0xa73f,
	0xa770,
	0xa779,
	0xa786,
	0xa792,
	0xa793,
	0xa7fb,
	0xa8fb,
	0xa8fc,
	0xa99d,
	0xa9d0,
	0xaa01,
	0xaa23,
	0xfe3f,
	0xfe72,
	0xfe74,
	0xfe76,
	0xfe77,
	0xfe78,
	0xfe79,
	0xfe7a,
	0xfe7b,
	0xfe7c,
	0xff9e,
	0xff9f,
	0x102a8,
	0x102bc,
	0x102c0,
	0x10382,
	0x10393,
	0x1039a,
	0x10412,
	0x1043a,
	0x10486,
	0x1099e,
	0x10a56,
	0x10a56,
	0x10c82,
	0x10ca5,
	0x11099,
	0x1109b,
	0x110a5,
	0x11434,
	0x11412,
	0x11434,
	0x11418,
	0x11434,
	0x11423,
	0x11434,
	0x11429,
	0x11434,
	0x1142c,
	0x11434,
	0x1142e,
	0x1144b,
	0x1144b,
	0x11582,
	0x11583,
	0x11584,
	0x11641,
	0x11641,
	0x11ae5,
	0x11ae5,
	0x11ae5,
	0x11ae5,
	0x11aef,
	0x11ae5,
	0x11ae5,
	0x11af0,
	0x11ae5,
	0x11aef,
	0x11ae5,
	0x11af0,
	0x11aeb,
	0x11aeb,
	0x11aeb,
	0x11aeb,
	0x11aef,
	0x11aeb,
	0x11aef,
	0x11af3,
	0x11aef,
	0x11af3,
	0x11af0,
	0x11af3,
	0x11af3,
	0x11af3,
	0x11af3,
	0x11aef,
	0x11af3,
	0x11af3,
	0x11af0,
	0x11c41,
	0x11c41,
	0x16f00,
	0x1d157,
	0x1d158,
	0x1d1b9,
	0x1d1ba,
	0x20122,
	0x2051c,
	0x20525,
	0x2054b,
	0x2063a,
	0x20804,
	0x208de,
	0x20a2c,
	0x20b63,
	0x214e4,
	0x216a8,
	0x216ea,
	0x219c8,
	0x21b18,
	0x21d0b,
	0x21de4,
	0x21de6,
	0x22183,
	0x2219f,
	0x22331,
	0x226d4,
	0x22844,
	0x2284a,
	0x22b0c,
	0x22bf1,
	0x2300a,
	0x232b8,
	0x2335f,
	0x23393,
	0x2339c,
	0x233c3,
	0x233d5,
	0x2346d,
	0x236a3,
	0x238a7,
	0x23a8d,
	0x23afa,
	0x23cbc,
	0x23d1e,
	0x23ed1,
	0x23f5e,
	0x23f8e,
	0x24263,
	0x242ee,
	0x243ab,
	0x24608,
	0x24735,
	0x24814,
	0x24c36,
	0x24c92,
	0x24fa1,
	0x24fb8,
	0x25044,
	0x250f2,
	0x250f3,
	0x25119,
	0x25133,
	0x25249,
	0x2541d,
	0x25626,
	0x2569a,
	0x256c5,
	0x2597c,
	0x25aa7,
	0x25bab,
	0x25c80,
	0x25cd0,
	0x25f86,
	0x261da,
	0x26228,
	0x26247,
	0x262d9,
	0x2633e,
	0x264da,
	0x26523,
	0x265a8,
	0x267a7,
	0x267b5,
	0x26b3c,
	0x26c36,
	0x26cd5,
	0x26d6b,
	0x26f2c,
	0x26fb1,
	0x270d2,
	0x273ca,
	0x27667,
	0x278ae,
	0x27966,
	0x27ca8,
	0x27ed3,
	0x27f2f,
	0x285d2,
	0x285ed,
	0x2872e,
	0x28bfa,
	0x28d77,
	0x29145,
	0x291df,
	0x2921a,
	0x2940a,
	0x29496,
	0x295b6,
	0x29b30,
	0x2a0ce,
	0x2a105,
	0x2a20e,
	0x2a291,
	0x2a392,
	0x2a600,
};
