#!/usr/bin/perl
use strict;
use warnings;
use Test::More tests => 3;
use File::Path qw(remove_tree);
use File::Copy::Recursive qw(dircopy);
use File::stat;
use Cwd;

my $root = Cwd::cwd;
$ENV{PATH} = "$root:$ENV{PATH}";
$ENV{DH_AUTOSCRIPTDIR} = $root;

sub prepare_source_package {
    die '$0 does not match expected format'
        unless ($0 =~ m#t/([0-9]+)\.t#);
    my $number = $1;
    my $srcdir = (-d "t/base/${number}") ? "t/base/${number}" : "t/base/default";
    my $testdir = "t/${number}";
    dircopy($srcdir, $testdir);
    chdir($testdir);
    return $testdir;
}

sub system_ok {
    ok(system(@_) == 0, "external command @_");
}

prepare_source_package();

system_ok('dh_runit', 'debian/test.runscript', 'name=test');
my $path = 'debian/dh-runit-test/var/lib/runit/supervise/test';
ok(-d $path, 'supervise directory correctly created');
my $info = stat($path);
my $mode = sprintf("%o", $info->mode & 0777);
is($mode, '700', 'supervise directory have conservative permissions');
