# Changelog

For more information on the list of deprecated flags and APIs, have a look at
https://docs.docker.com/engine/deprecated/ where you can find the target removal dates 

## 18.06.1-ce (2018-08-21)

### Builder

- Fix no error if build args are missing during docker build. [docker/engine#25](https://github.com/docker/engine/pull/25)
+ Set BuildKit's ExportedProduct variable to show useful errors. [docker/engine#21](https://github.com/docker/engine/pull/21)

### Client

+ Various shell completion script updates. [docker/cli#1229](https://github.com/docker/cli/pull/1229) [docker/cli#1268](https://github.com/docker/cli/pull/1268) [docker/cli#1272](https://github.com/docker/cli/pull/1272)
- Fix `DOCKER_CONFIG` warning message and fallback search. [docker/cli#1241](https://github.com/docker/cli/pull/1241)
- Fix help message flags on `docker stack` commands and sub-commands. [docker/cli#1267](https://github.com/docker/cli/pull/1267)

### Runtime

* Disable CRI plugin listening on port 10010 by default. [docker/engine#29](https://github.com/docker/engine/pull/29)
* Update containerd to v1.1.2. [docker/engine#33](https://github.com/docker/engine/pull/33)
- Windows: Do not invoke HCS shutdown if terminate called. [docker/engine#31](https://github.com/docker/engine/pull/31)
* Windows: Select polling-based watcher for Windows log watcher. [docker/engine#34](https://github.com/docker/engine/pull/34)

### Swarm Mode

- Fix the condition used for skipping over running tasks. [docker/swarmkit#2677](https://github.com/docker/swarmkit/pull/2677)
- Fix task sorting. [docker/swarmkit#2712](https://github.com/docker/swarmkit/pull/2712)

## 18.06.0-ce (2018-07-18)

### Important notes about this release

- Docker 18.06 CE will be the last release with a 4-month maintenance lifecycle. The planned Docker 18.09 CE release will be supported for 7 months with Docker 19.03 CE being the next release in line. More details about the release process can be found [here](https://docs.docker.com/install/).

### Builder

* Builder: fix layer leak on multi-stage wildcard copy. [moby/moby#37178](https://github.com/moby/moby/pull/37178)
* Fix parsing of invalid environment variable substitution . [moby/moby#37134](https://github.com/moby/moby/pull/37134)
* Builder: use the arch info from base image. [moby/moby#36816](https://github.com/moby/moby/pull/36816) [moby/moby#37197](https://github.com/moby/moby/pull/37197)
+ New experimental builder backend based on [BuildKit](https://github.com/moby/buildkit). To enable, run daemon in experimental mode and set `DOCKER_BUILDKIT=1` environment variable on the docker CLI. [moby/moby#37151](https://github.com/moby/moby/pull/37151) [docker/cli#1111](https://github.com/docker/cli/pull/1111)
- Fix handling uppercase targets names in multi-stage builds. [moby/moby#36960](https://github.com/moby/moby/pull/36960)

### Client

* Bump spf13/cobra to v0.0.3, pflag to v1.0.1. [moby/moby#37106](https://github.com/moby/moby/pull/37106)
* Add support for the new Stack API for Kubernetes v1beta2. [docker/cli#899](https://github.com/docker/cli/pull/899)
* K8s: more robust stack error detection on deploy. [docker/cli#948](https://github.com/docker/cli/pull/948)
* Support for rollback config in compose 3.7. [docker/cli#409](https://github.com/docker/cli/pull/409)
* Update Cobra and pflag, and use built-in --version feature. [docker/cli#1069](https://github.com/docker/cli/pull/1069)
* Fix `docker stack deploy --prune` with empty name removing all services. [docker/cli#1088](https://github.com/docker/cli/pull/1088)
* [Kubernetes] stack services filters. [docker/cli#1023](https://github.com/docker/cli/pull/1023)
+ Only show orchestrator flag in root, stack and version commands in help. [docker/cli#1106](https://github.com/docker/cli/pull/1106)
+ Add an `Extras` field on the compose config types. [docker/cli#1126](https://github.com/docker/cli/pull/1126)
+ Add options to the compose loader. [docker/cli#1128](https://github.com/docker/cli/pull/1128)
- Fix always listing nodes in docker stack ps command on Kubernetes. [docker/cli#1093](https://github.com/docker/cli/pull/1093)
- Fix output being shown twice on stack rm error message. [docker/cli#1093](https://github.com/docker/cli/pull/1093)
* Extend client API with custom HTTP requests. [moby/moby#37071](https://github.com/moby/moby/pull/37071)
* Changed error message for unreadable files to clarify possibility of a .Dockerignore entry. [docker/cli#1053](https://github.com/docker/cli/pull/1053)
* Restrict kubernetes.allNamespaces value to 'enabled' or 'disabled' in configuration file. [docker/cli#1087](https://github.com/docker/cli/pull/1087)
* Check errors when initializing the docker client in the help command. [docker/cli#1119](https://github.com/docker/cli/pull/1119)
* Better namespace experience with Kubernetes. Fix using namespace defined in ~/.kube/config for stack commands. Add a NAMESPACE column for docker stack ls command. Add a --all-namespaces flag for docker stack ls command. [docker/cli#991](https://github.com/docker/cli/pull/991)
* Export Push and Save. [docker/cli#1123](https://github.com/docker/cli/pull/1123)
* Export pull as a public function. [docker/cli#1026](https://github.com/docker/cli/pull/1026)
* Remove Kubernetes commands from experimental. [docker/cli#1068](https://github.com/docker/cli/pull/1068)
* Adding configs/secrets to service inspect pretty. [docker/cli#1006](https://github.com/docker/cli/pull/1006)
- Fix service filtering by name on Kubernetes. [docker/cli#1101](https://github.com/docker/cli/pull/1101)
- Fix component information alignment in `docker version`. [docker/cli#1065](https://github.com/docker/cli/pull/1065)
- Fix cpu/memory limits and reservations being reset on service update. [docker/cli#1079](https://github.com/docker/cli/pull/1079)
* Manifest list: request specific permissions. [docker/cli#1024](https://github.com/docker/cli/pull/1024)
* Setting --orchestrator=all also sets --all-namespaces unless specific --namespace are set. [docker/cli#1059](https://github.com/docker/cli/pull/1059)
- Fix panics when --compress and --stream are used together. [docker/cli#1105](https://github.com/docker/cli/pull/1105)
* Switch from x/net/context to context. [docker/cli#1038](https://github.com/docker/cli/pull/1038)
+ Add --init option to `docker service create`. [docker/cli#479](https://github.com/docker/cli/pull/479)
+ Fixed bug displaying garbage output for build command when --stream and --quiet flags combined. [docker/cli#1090](https://github.com/docker/cli/pull/1090)
+ Add `init` support in 3.7 schema. [docker/cli#1129](https://github.com/docker/cli/pull/1129)
- Fix docker trust signer removal. [docker/cli#1112](https://github.com/docker/cli/pull/1112)
- Fix error message from docker inspect. [docker/cli#1071](https://github.com/docker/cli/pull/1071)
* Allow `x-*` extension on 3rd level objects. [docker/cli#1097](https://github.com/docker/cli/pull/1097)
* An invalid orchestrator now generates an error instead of being silently ignored. [docker/cli#1055](https://github.com/docker/cli/pull/1055)
* Added ORCHESTRATOR column to docker stack ls command. [docker/cli#973](https://github.com/docker/cli/pull/973)
* Warn when using host-ip for published ports for services. [docker/cli#1017](https://github.com/docker/cli/pull/1017)
+ Added the option to enable experimental cli features through the `DOCKER_CLI_EXPERIMENTAL` environment variable. [docker/cli#1138](https://github.com/docker/cli/pull/1138)
+ Add exec_die to the list of known container events. [docker/cli#1028](https://github.com/docker/cli/pull/1028)
* [K8s] Do env-variable expansion on the uninterpreted Config files. [docker/cli#974](https://github.com/docker/cli/pull/974)
+ Print warnings on stderr for each unsupported features while parsing a compose file for deployment on Kubernetes. [docker/cli#903](https://github.com/docker/cli/pull/903)
+ Added description about pids count. [docker/cli#1045](https://github.com/docker/cli/pull/1045)
- Warn user of filter when pruning. [docker/cli#1043](https://github.com/docker/cli/pull/1043)
- Fix `--rollback-*` options overwriting `--update-*` options. [docker/cli#1052](https://github.com/docker/cli/pull/1052)
* Update Attach, Build, Commit, Cp, Create subcommand fish completions. [docker/cli#1005](https://github.com/docker/cli/pull/1005)
+ Add bash completion for `dockerd --default-address-pool`. [docker/cli#1173](https://github.com/docker/cli/pull/1173)
+ Add bash completion for `exec_die` event. [docker/cli#1173](https://github.com/docker/cli/pull/1173)
* Update docker-credential-helper so `pass` is not called on every docker command. [docker/cli#1184](https://github.com/docker/cli/pull/1184)
* Fix for rotating swarm external CA. [docker/cli#1199](https://github.com/docker/cli/pull/1199)
* Improve version output alignment. [docker/cli#1207](https://github.com/docker/cli/pull/1207)
+ Add bash completion for `service create|update --init`. [docker/cli#1210](https://github.com/docker/cli/pull/1210)

### Deprecation

* Document reserved namespaces deprecation. [docker/cli#1040](https://github.com/docker/cli/pull/1040)

### Logging

* Allow awslogs to use non-blocking mode. [moby/moby#36522](https://github.com/moby/moby/pull/36522)
* Improve logging of long log lines on fluentd log driver.. [moby/moby#36159](https://github.com/moby/moby/pull/36159)
* Re-order CHANGELOG.md to pass `make validate` test. [moby/moby#37047](https://github.com/moby/moby/pull/37047)
* Update Events, Exec, Export, History, Images, Import, Inspect, Load, and Login subcommand fish completions. [docker/cli#1061](https://github.com/docker/cli/pull/1061)
* Update documentation for RingLogger's ring buffer. [moby/moby#37084](https://github.com/moby/moby/pull/37084)
+ Add metrics for log failures/partials. [moby/moby#37034](https://github.com/moby/moby/pull/37034)
- Fix logging plugin crash unrecoverable. [moby/moby#37028](https://github.com/moby/moby/pull/37028)
- Fix logging test type. [moby/moby#37070](https://github.com/moby/moby/pull/37070)
- Fix race conditions in logs API. [moby/moby#37062](https://github.com/moby/moby/pull/37062)
- Fix some issues in logfile reader and rotation. [moby/moby#37063](https://github.com/moby/moby/pull/37063)

### Networking

* Allow user to specify default address pools for docker networks. [moby/moby#36396](https://github.com/moby/moby/pull/36396) [docker/cli#818](https://github.com/docker/cli/pull/818)
* Adding logs for ipam state [doccker/libnetwork#2417](https://github.com/docker/libnetwork/pull/2147)
* Fix race conditions in the overlay network driver [doccker/libnetwork#2143](https://github.com/docker/libnetwork/pull/2143)
* Add wait time into xtables lock warning [doccker/libnetwork#2142](https://github.com/docker/libnetwork/pull/2142)
* filter xtables lock warnings when firewalld is active [doccker/libnetwork#2135](https://github.com/docker/libnetwork/pull/2135)
* Switch from x/net/context to context [doccker/libnetwork#2140](https://github.com/docker/libnetwork/pull/2140)
* Adding a recovery mechanism for a split gossip cluster [doccker/libnetwork#2134](https://github.com/docker/libnetwork/pull/2134)
* Running docker inspect on network attachment tasks now returns a full task object. [moby/moby#35246](https://github.com/moby/moby/pull/35246)
* Some container/network cleanups. [moby/moby#37033](https://github.com/moby/moby/pull/37033)
- Fix network inspect for overlay network. [moby/moby#37045](https://github.com/moby/moby/pull/37045)
* Improve Scalability of the Linux load balancing. [docker/engine#16](https://github.com/docker/engine/pull/16)
* Change log level from error to warning. [docker/engine#19](https://github.com/docker/engine/pull/19)

### Runtime

* Aufs: log why aufs is not supported. [moby/moby#36995](https://github.com/moby/moby/pull/36995)
* Hide experimental checkpoint features on Windows. [docker/cli#1094](https://github.com/docker/cli/pull/1094)
* Lcow: Allow the client to customize capabilities and device cgroup rules for LCOW containers. [moby/moby#37294](https://github.com/moby/moby/pull/37294)
* Changed path given for executable output in windows to actual location of executable output. [moby/moby#37295](https://github.com/moby/moby/pull/37295)
+ Add windows recycle bin test and update hcsshim to v0.6.11. [moby/moby#36994](https://github.com/moby/moby/pull/36994)
* Allow to add any args when doing a make run. [moby/moby#37190](https://github.com/moby/moby/pull/37190)
* Optimize ContainerTop() aka docker top. [moby/moby#37131](https://github.com/moby/moby/pull/37131)
- Fix compilation on 32bit machines. [moby/moby#37292](https://github.com/moby/moby/pull/37292)
* Update API version to v1 38. [moby/moby#37141](https://github.com/moby/moby/pull/37141)
- Fix `docker service update --host-add` does not update existing host entry. [docker/cli#1054](https://github.com/docker/cli/pull/1054)
- Fix swagger file type for ExecIds. [moby/moby#36962](https://github.com/moby/moby/pull/36962)
- Fix swagger volume type generation. [moby/moby#37060](https://github.com/moby/moby/pull/37060)
- Fix wrong assertion in volume/service package. [moby/moby#37211](https://github.com/moby/moby/pull/37211)
- Fix daemon panic on restart when a plugin is running. [moby/moby#37234](https://github.com/moby/moby/pull/37234)
* Construct and add 'LABEL' command from 'label' option to last stage. [moby/moby#37011](https://github.com/moby/moby/pull/37011)
- Fix race condition between exec start and resize.. [moby/moby#37172](https://github.com/moby/moby/pull/37172)
* Alternative failure mitigation of `TestExecInteractiveStdinClose`. [moby/moby#37143](https://github.com/moby/moby/pull/37143)
* RawAccess allows a set of paths to be not set as masked or readonly. [moby/moby#36644](https://github.com/moby/moby/pull/36644)
* Be explicit about github.com prefix being a legacy feature. [moby/moby#37174](https://github.com/moby/moby/pull/37174)
* Bump Golang to 1.10.3. [docker/cli#1122](https://github.com/docker/cli/pull/1122)
* Close ReadClosers to prevent xz zombies. [moby/moby#34218](https://github.com/moby/moby/pull/34218)
* Daemon.ContainerStop(): fix for a negative timeout. [moby/moby#36874](https://github.com/moby/moby/pull/36874)
* Daemon.setMounts(): copy slice in place. [moby/moby#36991](https://github.com/moby/moby/pull/36991)
* Describe IP field of swagger Port definition. [moby/moby#36971](https://github.com/moby/moby/pull/36971)
* Extract volume interaction to a volumes service. [moby/moby#36688](https://github.com/moby/moby/pull/36688)
* Fixed markdown formatting in docker image v1, v1.1, and v1.2 spec. [moby/moby#37051](https://github.com/moby/moby/pull/37051)
* Improve GetTimestamp parsing. [moby/moby#35402](https://github.com/moby/moby/pull/35402)
* Jsonmessage: pass message to aux callback. [moby/moby#37064](https://github.com/moby/moby/pull/37064)
* Overlay2: remove unused cdMountFrom() helper function. [moby/moby#37041](https://github.com/moby/moby/pull/37041)
- Overlay: Fix overlay storage-driver silently ignoring unknown storage-driver options. [moby/moby#37040](https://github.com/moby/moby/pull/37040)
* Remove some unused contrib items. [moby/moby#36977](https://github.com/moby/moby/pull/36977)
* Restartmanager: do not apply restart policy on created containers. [moby/moby#36924](https://github.com/moby/moby/pull/36924)
* Set item-type for ExecIDs. [moby/moby#37121](https://github.com/moby/moby/pull/37121)
* Use go-systemd const instead of magic string in Linux version of dockerd. [moby/moby#37136](https://github.com/moby/moby/pull/37136)
* Use stdlib TLS dialer. [moby/moby#36687](https://github.com/moby/moby/pull/36687)
* Warn when an engine label using a reserved namespace (com.docker.\*, io.docker.\*, or org.dockerproject.\*) is configured, as per https://docs.docker.com/config/labels-custom-metadata/. [moby/moby#36921](https://github.com/moby/moby/pull/36921)
- Fix missing plugin name in message. [moby/moby#37052](https://github.com/moby/moby/pull/37052)
- Fix link anchors in CONTRIBUTING.md. [moby/moby#37276](https://github.com/moby/moby/pull/37276)
- Fix link to Docker Toolbox. [moby/moby#37240](https://github.com/moby/moby/pull/37240)
- Fix mis-used skip condition. [moby/moby#37179](https://github.com/moby/moby/pull/37179)
- Fix bind mounts not working in some cases. [moby/moby#37031](https://github.com/moby/moby/pull/37031)
- Fix fd leak on attach. [moby/moby#37184](https://github.com/moby/moby/pull/37184)
- Fix fluentd partial detection. [moby/moby#37029](https://github.com/moby/moby/pull/37029)
- Fix incorrect link in version-history.md. [moby/moby#37049](https://github.com/moby/moby/pull/37049)
* Allow vim to be case insensitive for D in dockerfile. [moby/moby#37235](https://github.com/moby/moby/pull/37235)
+ Add `t.Name()` to tests so that service names are unique. [moby/moby#37166](https://github.com/moby/moby/pull/37166)
+ Add additional message when backendfs is extfs without d_type support. [moby/moby#37022](https://github.com/moby/moby/pull/37022)
+ Add api version checking for tests from new feature. [moby/moby#37169](https://github.com/moby/moby/pull/37169)
+ Add image metrics for push and pull. [moby/moby#37233](https://github.com/moby/moby/pull/37233)
+ Add support for `init` on services. [moby/moby#37183](https://github.com/moby/moby/pull/37183)
+ Add verification of escapeKeys array length in pkg/term/proxy.go. [moby/moby#36918](https://github.com/moby/moby/pull/36918)
* When link id is empty for overlay2, do not remove this link.. [moby/moby#36161](https://github.com/moby/moby/pull/36161)
- Fix build on OpenBSD by defining Self(). [moby/moby#37301](https://github.com/moby/moby/pull/37301)
- Windows: Fix named pipe support for hyper-v isolated containers. [docker/engine#2](https://github.com/docker/engine/pull/2) [docker/cli#1165](https://github.com/docker/cli/pull/1165)
- Fix manifest lists to always use correct size. [docker/cli#1183](https://github.com/docker/cli/pull/1183)
* Register OCI media types. [docker/engine#4](https://github.com/docker/engine/pull/4)
* Update containerd to v1.1.1 [docker/engine#17](https://github.com/docker/engine/pull/17)
* LCOW: Prefer Windows over Linux in a manifest list. [docker/engine#3](https://github.com/docker/engine/pull/3)
* Add updated `MaskPaths` that are used in code paths directly using containerd to address [CVE-2018-10892](https://cve.mitre.org/cgi-bin/cvename.cgi?name=2018-10892). [docker/engine#15](https://github.com/docker/engine/pull/15)
* Add `/proc/acpi` to masked paths to address [CVE-2018-10892](https://cve.mitre.org/cgi-bin/cvename.cgi?name=2018-10892). [docker/engine#14](https://github.com/docker/engine/pull/14)
- Fix bindmount autocreate race. [docker/engine#11](https://github.com/docker/engine/pull/11)

### Swarm Mode

* List stacks for both Swarm and Kubernetes with --orchestrator=all in docker stack ls. Allow several occurrences of --namespace for Kubernetes with docker stack ls. [docker/cli#1031](https://github.com/docker/cli/pull/1031)
* Bump SwarmKit to remove deprecated grpc metadata wrappers. [moby/moby#36905](https://github.com/moby/moby/pull/36905)
* Issue an error for --orchestrator=all when working on mismatched Swarm and Kubernetes hosts. [docker/cli#1035](https://github.com/docker/cli/pull/1035)
- Fix broken swarm commands with Kubernetes defined as orchestrator. "--orchestrator" flag is no longer global but local to stack commands and subcommands [docker/cli#1137](https://github.com/docker/cli/pull/1137) [docker/cli#1139](https://github.com/docker/cli/pull/1139)
* Bump swarmkit to include task reaper fixes and more metrics. [docker/engine#13](https://github.com/docker/engine/pull/13)
- Avoid a leak when a service with unassigned tasks is deleted. [docker/engine#27](https://github.com/docker/engine/pull/27)
- Fix racy batching on the dispatcher. [docker/engine#27](https://github.com/docker/engine/pull/27)
