.\" dpkg manual page - dpkg-split(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2011 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-split 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOM
dpkg\-split \- outil de décomposition/recomposition des paquets Debian
.
.SH SYNOPSIS
\fBdpkg\-split\fP [\fIoption\fP...] \fIcommande\fP
.
.SH DESCRIPTION
\fBdpkg\-split\fP décompose les fichiers d'un paquet binaire Debian en parties
plus petites (et les recompose), pour permettre l'enregistrement des
fichiers d'un paquet volumineux sur des média de faible capacité tels que
les disquettes.

On peut s'en servir «\ à la main\ » avec les options \fB\-\-split\fP, \fB\-\-join\fP et
\fB\-\-info\fP.

Il possède aussi un mode automatique, appelé avec l'option \fB\-\-auto\fP, dans
lequel il conserve séparément dans une file les parties connues ou recompose
le fichier d'un paquet quand il connaît toutes ses parties. Les options
\fB\-\-listq\fP et \fB\-\-discard\fP permettent la gestion de cette file.

Toutes les opérations de décomposition, recomposition ou de mise en file
produisent des messages sur la sortie standard\ ; ils peuvent être
tranquillement ignorés.
.
.SH COMMANDES
.TP 
\fB\-s\fP, \fB\-\-split\fP \fIarchive\-complète\fP [\fIpréfixe\fP]
Décompose en plusieurs parties un paquet binaire Debian.

Le nom d'une partie est\ : \fIpréfixe\fP\fB.\fP\fIN\fP\fBde\fP\fIM\fP\fB.deb\fP où \fIN\fP le
numéro de partie, commençant à 1, et \fIM\fP est le nombre total de parties
(les deux sont des décimaux).

Quand on ne donne pas de \fIpréfixe\fP, le nom du fichier \fIarchive\-complète\fP
est utilisé, en incluant le répertoire et en supprimant tout \fB.deb\fP
restant.
.TP 
\fB\-j\fP, \fB\-\-join\fP \fIpartie\fP...
Rassemble les parties d'un fichier, recomposant ainsi le fichier d'origine
tel qu'il était avant la décomposition.

Ces parties, données comme arguments, doivent appartenir toutes au même
fichier binaire d'origine. Chaque partie ne doit apparaître qu'une seule
fois dans la liste des arguments\ ; mais il est inutile de les ordonner.

Les parties doivent bien sûr avoir été créées selon le même modèle (taille
maximum des parties), qui est déclaré au moment de la décomposition\ ; ce qui
signifie en fait qu'elles doivent avoir été créées par le même appel à
\fBdpkg\-split \-\-split\fP.

Les parties des noms ne sont pas significatives pour le processus de
recomposition.

Par défaut, le fichier produit
s'appelle\ \fIpaquet\fP\fB_\fP\fIversion\fP\fB_\fP\fIarch\fP\fB.deb\fP.

.TP 
\fB\-I\fP, \fB\-\-info\fP \fIpartie\fP...
Affiche les renseignements concernant telle partie dans un format lisible
par tous. Les arguments ne représentant pas la partie d'un fichier binaire
le disent aussi sur la sortie standard.
.TP 
\fB\-a\fP, \fB\-\-auto \-o\fP \fIfichier\-complet partie\fP
Met en file automatiquement les parties en vue de la recomposition d'un
paquet.

La \fIpartie\fP déclarée est examinée et comparée avec les autres parties du
même paquet qui se trouvent (si elles existent) dans la file.

Quand toutes les parties d'un fichier (auquel appartient la partie
\fIpartie\fP) sont présentes, le fichier est recomposé et créé en tant que
\fIfichier\-complet\fP (ce fichier ne devrait pas déjà exister, mais ce n'est
pas une erreur).

Quand ce n'est pas le cas, la partie \fIpartie\fP est mise dans la file et le
fichier \fIfichier\-complet\fP n'est pas créé.

Quand la \fIpartie\fP n'appartient pas à un paquet binaire décomposé,
\fBdpkg\-split\fP se termine avec un code de sortie égal à \fB1\fP\ ; s'il y a une
autre erreur, c'est un code de sortie égal à \fB2\fP.

L'option \fB\-\-output\fP ou \fB\-o\fP doit être fournie avec l'action \fB\-\-auto\fP. Si
cela n'était pas obligatoire, le programme appelant ne saurait pas quel
fichier attendre.
.TP 
\fB\-l\fP, \fB\-\-listq\fP
Liste le contenu d'une file de paquets à recomposer.

Pour chaque fichier possédant des parties dans la file, cette action donne
le nom du fichier, les parties présentes dans la file et le nombre total
d'octets conservés.
.TP 
\fB\-d\fP, \fB\-\-discard\fP [\fIpaquet\fP...]
Cette action laisse de côté certaines parties dans la file, celles qui sont
en attente des autres parties composant le paquet.

Quand aucun \fIpaquet\fP n'est donné, la file est vidée\ ; si un paquet est
donné, seules les parties de ce paquet sont détruites.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Affiche un message d'aide puis quitte.
.TP 
\fB\-\-version\fP
Affiche le numéro de version puis quitte.
.
.SH OPTIONS
.TP 
\fB\-\-depotdir\fP\fI répertoire\fP
Indique un répertoire différent pour la file comprenant les parties en
attente d'une recomposition automatique. Par défaut, c'est le répertoire
\fB/var/lib/dpkg\fP.
.TP 
\fB\-S\fP, \fB\-\-partsize\fP \fIkibi\-octets\fP
Indique, en kibi\-octets (1024 octets), la taille maximum d'une partie lors
d'une décomposition. Par défaut, la taille maximum est de 450\ Kio.
.TP 
\fB\-o\fP, \fB\-\-output\fP \fIfichier\-complet\fP
Indique le nom du fichier à produire pour une recomposition.

Cela annule le fichier par défaut lors d'une recomposition «\ à la main\ »
(\fB\-\-join\fP) et c'est obligatoire pour une recomposition ou une mise en file
automatiques (\fB\-\-auto\fP).
.TP 
\fB\-Q\fP, \fB\-\-npquiet\fP
Pour une recomposition ou une mise en file automatiques, \fBdpkg\-split\fP
affiche habituellement un message si on lui donne une \fIpartie\fP qui n'est
pas une partie d'un paquet binaire. Cette option supprime ce message\ ; cela
permet à des programmes comme \fBdpkg\fP de ne pas afficher de faux messages
quand il est confronté à des paquets décomposés et des paquets non
décomposés.
.TP 
\fB\-\-msdos\fP
Oblige le nom des fichiers produits par \fB\-\-split\fP à se conformer à msdos.

Cela supprime le préfixe \- soit celui par défaut dérivé du fichier d'entrée,
soit celui donné comme argument\ : les caractères alphanumériques sont en
minuscules, les signes plus sont remplacés par des \fBx\fP et tous les autres
caractères sont abandonnés.

Le résultat est alors tronqué autant que nécessaire et des fichiers de la
forme\ : \fIprefixN\fP\fBof\fP\fIM\fP\fB.deb\fP sont créés.
.
.SH "CODE DE SORTIE"
.TP 
\fB0\fP
La recomposition ou bien toute autre commande a réussi. Les commandes
\fB\-\-info\fP réussissent toujours même si les fichiers ne sont pas des parties
d'un paquet binaire.
.TP 
\fB1\fP
Ne peut apparaître qu'avec l'action \fB\-\-auto\fP et signale que le fichier
\fIpartie\fP n'est pas une partie d'un paquet binaire.
.TP 
\fB2\fP
Fatal or unrecoverable error due to invalid command\-line usage, a file that
looked like a package part file but was corrupted, or interactions with the
system, such as accesses to the database, memory allocations, etc.
.
.SH ENVIRONNEMENT
.TP 
\fBSOURCE_DATE_EPOCH\fP
If set, it will be used as the timestamp (as seconds since the epoch) in the
\fBdeb\-split\fP(5)'s \fBar\fP(5) container.
.
.SH FICHIERS
.TP 
\fI%ADMINDIR%/parts\fP
Le répertoire par défaut de la file contenant les fichiers qui attendent une
recomposition automatique.

Les noms de fichiers utilisés dans ce répertoire sont dans un format
particulier à \fBdpkg\-split\fP et ne sont sans doute pas utiles pour d'autres
programmes\ ; en tous cas on ne peut pas compter sur ce format de nom de
fichier.
.
.SH BOGUES
On ne peut pas obtenir tous les détails voulus sur les paquets présents dans
la file à moins d'aller voir soi\-même dans le répertoire de la file.

On ne peut pas facilement savoir si un fichier est vraiment la partie d'un
paquet binaire ou non.
.
.SH "VOIR AUSSI"
\fBdeb\fP(5), \fBdeb\-control\fP(5), \fBdpkg\-deb\fP(1), \fBdpkg\fP(1).
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
