/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.FloatSortedHitQueue;
import org.apache.lucene.search.IntegerSortedHitQueue;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.ScoreDocLookupComparator;
import org.apache.lucene.search.SortComparatorSource;
import org.apache.lucene.search.StringSortedHitQueue;
import org.apache.lucene.util.PriorityQueue;

abstract class FieldSortedHitQueue
extends PriorityQueue {
    protected static int lastReaderHash;
    protected static final Hashtable fieldCache;
    private final ScoreDocComparator[] comparators = new ScoreDocComparator[]{null, ScoreDocComparator.INDEXORDER};

    static ScoreDocComparator getCachedComparator(IndexReader reader, String field, int type, SortComparatorSource factory) throws IOException {
        ScoreDocComparator comparer;
        if (type == 1) {
            return ScoreDocComparator.INDEXORDER;
        }
        if (type == 0) {
            return ScoreDocComparator.RELEVANCE;
        }
        if (reader.hashCode() == lastReaderHash) {
            comparer = (ScoreDocLookupComparator)fieldCache.get(field);
            if (comparer != null && comparer.sizeMatches(reader.maxDoc())) {
                return comparer;
            }
        } else {
            lastReaderHash = reader.hashCode();
            fieldCache.clear();
        }
        comparer = null;
        switch (type) {
            case 2: {
                comparer = FieldSortedHitQueue.determineComparator(reader, field);
                break;
            }
            case 3: {
                comparer = StringSortedHitQueue.comparator(reader, field);
                break;
            }
            case 4: {
                comparer = IntegerSortedHitQueue.comparator(reader, field);
                break;
            }
            case 5: {
                comparer = FloatSortedHitQueue.comparator(reader, field);
                break;
            }
            case 9: {
                comparer = factory.newComparator(reader, field);
                break;
            }
            default: {
                throw new RuntimeException("invalid sort field type: " + type);
            }
        }
        fieldCache.put(field, comparer);
        return comparer;
    }

    static void clearCache() {
        fieldCache.clear();
    }

    static FieldSortedHitQueue getInstance(ScoreDocComparator comparator, int size) {
        return new FieldSortedHitQueue(comparator, size){

            protected ScoreDocLookupComparator createComparator(IndexReader reader, String field) throws IOException {
                return null;
            }
        };
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static ScoreDocComparator determineComparator(IndexReader reader, String field) throws IOException {
        field = field.intern();
        TermEnum enumerator = reader.terms(new Term(field, ""));
        try {
            Term term = enumerator.term();
            if (term == null) {
                throw new RuntimeException("no terms in field " + field + " - cannot determine sort type");
            }
            if (term.field() != field) throw new RuntimeException("field \"" + field + "\" does not appear to be indexed");
            String termtext = term.text().trim();
            try {
                Integer.parseInt(termtext);
                ScoreDocLookupComparator scoreDocLookupComparator = IntegerSortedHitQueue.comparator(reader, enumerator, field);
                return scoreDocLookupComparator;
            }
            catch (NumberFormatException nfe2) {
                Float.parseFloat(termtext);
                ScoreDocLookupComparator nfe2 = FloatSortedHitQueue.comparator(reader, enumerator, field);
                enumerator.close();
                return nfe2;
                {
                    catch (NumberFormatException nfe3) {
                        ScoreDocLookupComparator scoreDocLookupComparator = StringSortedHitQueue.comparator(reader, enumerator, field);
                        enumerator.close();
                        return scoreDocLookupComparator;
                    }
                }
            }
        }
        finally {
            enumerator.close();
        }
    }

    FieldSortedHitQueue(IndexReader reader, String field, int size) throws IOException {
        int hash = reader.hashCode();
        if (hash != lastReaderHash) {
            lastReaderHash = hash;
            fieldCache.clear();
        }
        this.initialize(size);
        this.comparators[0] = this.initializeSort(reader, field);
    }

    protected FieldSortedHitQueue(ScoreDocComparator comparator, int size) {
        this.initialize(size);
        this.comparators[0] = comparator;
    }

    protected final boolean lessThan(Object a, Object b) {
        ScoreDoc docA = (ScoreDoc)a;
        ScoreDoc docB = (ScoreDoc)b;
        int n = this.comparators.length;
        int c = 0;
        for (int i = 0; i < n && c == 0; ++i) {
            c = this.comparators[i].compare(docA, docB);
        }
        return c > 0;
    }

    protected final ScoreDocComparator initializeSort(IndexReader reader, String field) throws IOException {
        ScoreDocLookupComparator comparer = (ScoreDocLookupComparator)fieldCache.get(field);
        if (comparer == null || !comparer.sizeMatches(reader.maxDoc())) {
            comparer = this.createComparator(reader, field);
            fieldCache.put(field, comparer);
        }
        return comparer;
    }

    protected abstract ScoreDocLookupComparator createComparator(IndexReader var1, String var2) throws IOException;

    static {
        fieldCache = new Hashtable();
    }
}

