/**************************************************************************

   Fotoxx      edit photos and manage collections

   Copyright 2007-2014 Michael Cornelison
   Source URL: http://kornelix.com/fotoxx
   Contact: kornelix@posteo.de
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see http://www.gnu.org/licenses/.

***************************************************************************/

#define EX extern                                                          //  enable extern declarations
#include "fotoxx.h"                                                        //  (variables in fotoxx.h are refs)


GtkWidget   *mFile, *mTools, *mMeta, *mArea;
GtkWidget   *mEdit, *mRep, *mBend, *mEff, *mComb;
GtkWidget   *mPlug, *mHelp;
GtkWidget   *mToolsG;                                                      //  v.14.07

GtkWidget   *popmenu_main, *popmenu_thumb, *popmenu_coll_thumb, *popmenu_raw;
int         NFmenu, NGmenu, NWmenu;


//  initialize widgets and menus for F/G/W view modes

void build_widgets()
{
   //  build the window widgets for the three view modes F/G/W

   GtkStateFlags  gtksf = (GtkStateFlags) 0;

   Mwin = gtk_window_new(GTK_WINDOW_TOPLEVEL);                             //  create main window 
   gtk_window_set_title(MWIN,Frelease);
   Mvbox = gtk_box_new(VERTICAL,0);                                        //  top container
   gtk_container_add(GTK_CONTAINER(Mwin),Mvbox);
   gtk_widget_show_all(Mwin);

   G_SIGNAL(Mwin,"delete_event",delete_event,0);                           //  connect signals to main window
   G_SIGNAL(Mwin,"destroy",destroy_event,0);
   G_SIGNAL(Mwin,"window-state-event",state_event,0);
   G_SIGNAL(Mwin,"key-press-event",KBpress,0);                             //  connect KB events to main window
   G_SIGNAL(Mwin,"key-release-event",KBrelease,0);

   drag_drop_connect(Mwin,m_open_drag);                                    //  connect drag-drop to main window

   //  F view widgets - image file 

   Fhbox = gtk_box_new(HORIZONTAL,0);                                      //  top container
   gtk_box_pack_start(GTK_BOX(Mvbox),Fhbox,1,1,0);
   Fmenu = gtk_box_new(VERTICAL,0);                                        //  left vbox for vert. menu
   gtk_box_pack_start(GTK_BOX(Fhbox),Fmenu,0,0,0);
   Fvbox = gtk_box_new(VERTICAL,0);                                        //  right vbox for image
   gtk_box_pack_start(GTK_BOX(Fhbox),Fvbox,1,1,0);
   Fpanel = gtk_box_new(HORIZONTAL,0);                                     //  panel over image
   gtk_box_pack_start(GTK_BOX(Fvbox),Fpanel,0,0,0);
   Fpanlab = gtk_label_new("panel"); 
   gtk_widget_override_font(Fpanlab,panelfont);
   gtk_box_pack_start(GTK_BOX(Fpanel),Fpanlab,0,0,0);
   Fdrawin = gtk_drawing_area_new();                                       //  image drawing area
   gtk_widget_override_background_color(Fdrawin,gtksf,&GDKbackground); 
   gtk_box_pack_start(GTK_BOX(Fvbox),Fdrawin,1,1,0);
   gtk_widget_hide(Fhbox);

   gtk_widget_add_events(Fdrawin,GDK_BUTTON_PRESS_MASK);                   //  connect mouse events to image window
   gtk_widget_add_events(Fdrawin,GDK_BUTTON_RELEASE_MASK);
   gtk_widget_add_events(Fdrawin,GDK_BUTTON_MOTION_MASK);
   gtk_widget_add_events(Fdrawin,GDK_POINTER_MOTION_MASK);
   gtk_widget_add_events(Fdrawin,GDK_SCROLL_MASK);
   G_SIGNAL(Fdrawin,"button-press-event",mouse_event,0);                   //  connect signals
   G_SIGNAL(Fdrawin,"button-release-event",mouse_event,0);
   G_SIGNAL(Fdrawin,"motion-notify-event",mouse_event,0);
   G_SIGNAL(Fdrawin,"scroll-event",mouse_event,0);
   G_SIGNAL(Fdrawin,"draw",Fpaint,0);

   //  G view widgets - thumbnail gallery

   Ghbox = gtk_box_new(HORIZONTAL,0);                                      //  top container
   gtk_box_pack_start(GTK_BOX(Mvbox),Ghbox,1,1,0);
   Gmenu = gtk_box_new(VERTICAL,0);                                        //  left vbox for vert. menu
   gtk_box_pack_start(GTK_BOX(Ghbox),Gmenu,0,0,0);
   Gvbox = gtk_box_new(VERTICAL,0);                                        //  right vbox for gallery
   gtk_box_pack_start(GTK_BOX(Ghbox),Gvbox,1,1,0);
   Gpanel = gtk_box_new(HORIZONTAL,0);                                     //  panel over gallery
   gtk_box_pack_start(GTK_BOX(Gvbox),Gpanel,0,0,0);
   Gtop = gtk_button_new_with_label(ZTX("TOP"));                           //  [TOP] button in panel
   gtk_box_pack_start(GTK_BOX(Gpanel),Gtop,0,0,3);
   Gpath = gtk_entry_new();                                                //  directory path in panel
   gtk_box_pack_start(GTK_BOX(Gpanel),Gpath,1,1,0);
   gtk_entry_set_text(GTK_ENTRY(Gpath),"path");
   gtk_widget_set_can_focus(Gpath,0);                                      //  stop unwanted focus
   gtk_widget_override_font(Gpath,panelfont);
   Gscroll = gtk_scrolled_window_new(0,0);                                 //  scrolled window for gallery
   gtk_scrolled_window_set_policy(SCROLLWIN(Gscroll),NEVER,ALWAYS);
   Gadjust = gtk_scrolled_window_get_vadjustment(SCROLLWIN(Gscroll));
   gtk_box_pack_start(GTK_BOX(Gvbox),Gscroll,1,1,0);
   Gdrawin = gtk_drawing_area_new();                                       //  gallery drawing area
   gtk_container_add(GTK_CONTAINER(Gscroll),Gdrawin);
   gtk_widget_hide(Ghbox);

   gtk_widget_add_events(Gpath,GDK_BUTTON_PRESS_MASK);
   gtk_widget_add_events(Gdrawin,GDK_BUTTON_PRESS_MASK);                   //  connect mouse events to gallery window
   gtk_widget_add_events(Gdrawin,GDK_BUTTON_RELEASE_MASK);
   gtk_widget_add_events(Gdrawin,GDK_POINTER_MOTION_MASK);
   G_SIGNAL(Gpath,"button-press-event",navi::changedirk,0);                //  connect signals
   G_SIGNAL(Gtop,"clicked",navi::newtop,0);
   G_SIGNAL(Gdrawin,"button-press-event",navi::mouse_event,0);             //  v.14.08
   G_SIGNAL(Gdrawin,"button-release-event",navi::mouse_event,0);
   G_SIGNAL(Gdrawin,"motion-notify-event",navi::mouse_event,0);            //  v.14.08
   G_SIGNAL(Gdrawin,"draw",navi::gallery_paint,0);

   //  W view widgets - world map

   Whbox = gtk_box_new(HORIZONTAL,0);                                      //  top container
   gtk_box_pack_start(GTK_BOX(Mvbox),Whbox,1,1,0);
   Wmenu = gtk_box_new(VERTICAL,0);                                        //  left vbox for vert. menu
   gtk_box_pack_start(GTK_BOX(Whbox),Wmenu,0,0,0);
   Wvbox = gtk_box_new(VERTICAL,0);                                        //  right vbox for world map
   gtk_box_pack_start(GTK_BOX(Whbox),Wvbox,1,1,0);
   Wdrawin = gtk_drawing_area_new();                                       //  world map drawing area
   gtk_widget_override_background_color(Wdrawin,gtksf,&GDKbackground); 
   gtk_box_pack_start(GTK_BOX(Wvbox),Wdrawin,1,1,0);
   gtk_widget_hide(Whbox);

   gtk_widget_add_events(Wdrawin,GDK_BUTTON_PRESS_MASK);                   //  connect mouse events to world map window
   gtk_widget_add_events(Wdrawin,GDK_BUTTON_RELEASE_MASK);
   gtk_widget_add_events(Wdrawin,GDK_BUTTON_MOTION_MASK);
   gtk_widget_add_events(Wdrawin,GDK_POINTER_MOTION_MASK);
   gtk_widget_add_events(Wdrawin,GDK_SCROLL_MASK);
   G_SIGNAL(Wdrawin,"button-press-event",mouse_event,0);                   //  connect signals
   G_SIGNAL(Wdrawin,"button-release-event",mouse_event,0);
   G_SIGNAL(Wdrawin,"motion-notify-event",mouse_event,0);                  //  v.14.08
   G_SIGNAL(Wdrawin,"scroll-event",mouse_event,0);
   G_SIGNAL(Wdrawin,"draw",Fpaint,0);
   
   //  prepare menus for F/G/W view modes

   int      me, ii, err;

   #define MENUENT(_topmenu,_text,_icon,_desc,_func,_arg)         \
   {  me = Nmenus++;                                              \
      menutab[me].topmenu = _topmenu;                             \
      menutab[me].menu = _text;                                   \
      menutab[me].icon = _icon;                                   \
      menutab[me].desc = _desc;                                   \
      menutab[me].func = _func;                                   \
      if (_arg) menutab[me].arg = _arg;                           \
      else menutab[me].arg = _text;                               \
   }

   Nmenus = 0;                                                             

   mFile = create_popmenu();                                               //  top level menus for F view
   mTools = create_popmenu();
   mMeta = create_popmenu();
   mArea = create_popmenu();
   mEdit = create_popmenu();                                               //  v.14.07
   mRep = create_popmenu();
   mBend = create_popmenu();
   mEff = create_popmenu();
   mComb = create_popmenu();
   mHelp = create_popmenu();
   mPlug = create_popmenu();
   
   cchar * imagefile_tip = ZTX("Current Image File");
   cchar * gallery_tip = ZTX("Thumbnail Gallery");
   cchar * worldmap_tip = ZTX("World Map");
   cchar * favorites_tip = ZTX("Favorite Functions");
   cchar * file_tip = ZTX("File: Sync, Open, Save, Trash, Rename, Print");
   cchar * tools_tip = ZTX("Tools: Index, Settings, Collections, Batch Funcs ...");
   cchar * metadata_tip = ZTX("Metadata: Captions, Tags, Ratings, Geotags, Search ... ");
   cchar * areas_tip = ZTX("Areas: Select areas to edit, copy and paste");
   cchar * edit_tip = ZTX("Edit: Trim, Rotate, Resize, Brightness, Contrast, Text ...");
   cchar * repair_tip = ZTX("Repair: Sharpen, Noise, Red-eyes, Color, Paint, Clone ...");
   cchar * bend_tip = ZTX("Bend: Fix Perspective, Bend/Warp image ...");
   cchar * effects_tip = ZTX("Effects: Special Effects, Arty Transforms");
   cchar * combine_tip = ZTX("Combine: HDR, HDF, Panorama, Stack, Mashup");
   cchar * plugins_tip = ZTX("Plugins: Use other image editors within Fotoxx");
   cchar * help_tip = ZTX("Help: Quick Start, User Guide, Recent Changes ...");
   cchar * undo_redo_tip = ZTX("Undo or Redo one edit (left/right mouse click) \n hold key A to include all edits");
   cchar * prev_next_tip = ZTX("Open previous or next file (left/right mouse click)");
   cchar * save_tip = ZTX("Save modified image file to disk");
   cchar * sync_G_tip = ZTX("Set gallery from current image file");

   MENUENT(0,  ZTX("Gallery"),      "viewG.png",      gallery_tip,      m_viewmode, "G" );
   MENUENT(0,  ZTX("World Map"),    "viewW.png",      worldmap_tip,     m_viewmode, "W" );
   MENUENT(0,  ZTX("Favorites"),    "favorites.png",  favorites_tip,    m_favorites, 0 );
   MENUENT(0,  ZTX("File"),         "file.png",       file_tip,         (cbFunc *) popup_menu,  (cchar *) mFile);
   MENUENT(0,  ZTX("Tools"),        "tools.png",      tools_tip,        (cbFunc *) popup_menu,  (cchar *) mTools);
   MENUENT(0,  ZTX("Metadata"),     "metadata.png",   metadata_tip,     (cbFunc *) popup_menu,  (cchar *) mMeta);
   MENUENT(0,  ZTX("Areas"),        "areas.png",      areas_tip,        (cbFunc *) popup_menu,  (cchar *) mArea);
   MENUENT(0,  ZTX("Edit"),         "edit.png",       edit_tip,         (cbFunc *) popup_menu,  (cchar *) mEdit);
   MENUENT(0,  ZTX("Repair"),       "repair.png",     repair_tip,       (cbFunc *) popup_menu,  (cchar *) mRep);
   MENUENT(0,  ZTX("Bend"),         "bend.png",       bend_tip,         (cbFunc *) popup_menu,  (cchar *) mBend);
   MENUENT(0,  ZTX("Effects"),      "effects.png",    effects_tip,      (cbFunc *) popup_menu,  (cchar *) mEff);
   MENUENT(0,  ZTX("Combine"),      "combine.png",    combine_tip,      (cbFunc *) popup_menu,  (cchar *) mComb);
   MENUENT(0,  ZTX("Plugins"),      "plugins.png",    plugins_tip,      (cbFunc *) popup_menu,  (cchar *) mPlug);
   MENUENT(0,  ZTX("Help"),         "help.png",       help_tip,         (cbFunc *) popup_menu,  (cchar *) mHelp);
   MENUENT(0,  ZTX("Undo/Redo"),    "undo_redo.png",  undo_redo_tip,    m_undo_redo, 0 );
   MENUENT(0,  ZTX("Prev/Next"),    "prev_next.png",  prev_next_tip,    m_prev_next, 0 );
   MENUENT(0,  ZTX("Save"),         "save.png",       save_tip,         m_file_save, 0 );

   MENUENT(0,  ZTX("Undo"),         "KB shortcut",    0,                m_undo, 0 );               //  KB shortcut only  v.14.07.1
   MENUENT(0,  ZTX("Redo"),         "KB shortcut",    0,                m_redo, 0 );               //  KB shortcut only

   MENUENT(mFile,    ZTX("Sync Gallery"), 0,                   sync_G_tip,                               navi::menufuncx, 0 );
   MENUENT(mFile,    ZTX("New Window"), 0,                     ZTX("Open another window"),               m_clone, 0 );
   MENUENT(mFile,    ZTX("Open Image File"), 0,                ZTX("Open a new image file"),             m_open, 0 );
   MENUENT(mFile,    ZTX("Open Previous File"), 0,             ZTX("Open the previously seen file"),     m_previous, 0 );
   MENUENT(mFile,    ZTX("Recently Seen Images"), 0,           ZTX("Open a recently seen file"),         m_recentfiles, 0 );
   MENUENT(mFile,    ZTX("Newest Images"), 0,                  ZTX("Open a newly added file"),           m_newfiles, 0 );
   MENUENT(mFile,    ZTX("Open RAW file (ufraw)"), 0,          ZTX("Open and edit a camera RAW file"),   m_ufraw, 0 );
   MENUENT(mFile,    ZTX("Open RAW file (Raw Therapee)"), 0,   ZTX("Open and edit a camera RAW file"),   m_rawtherapee, 0 );
   MENUENT(mFile,    ZTX("Save to Disk"), 0,                   ZTX("Save modified image file to disk"),  m_file_save, 0 );
   MENUENT(mFile,    ZTX("Rename Image File"), 0,              ZTX("Change the image file name"),        m_rename, 0 );
   MENUENT(mFile,    ZTX("New Blank Image"), 0,                ZTX("Create a blank image"),              m_create, 0 );
   MENUENT(mFile,    ZTX("Trash Image File"), 0,               ZTX("Move image file to Trash"),          m_trash, 0 );
   MENUENT(mFile,    ZTX("Delete Image File"), 0,              ZTX("Permanently delete image file"),     m_delete, 0 );
   MENUENT(mFile,    ZTX("Print Image"), 0,                    ZTX("Print the current image"),           m_print, 0 );
   MENUENT(mFile,    ZTX("Quit Fotoxx"), 0,                    ZTX("Quit Fotoxx"),                       m_quit, 0 );

   MENUENT(mTools,   ZTX("Index Image Files"), 0,              ZTX("Index new files and make thumbnails"),           m_index, 0 );
   MENUENT(mTools,   ZTX("User Settings"), 0,                  ZTX("Change user preferences"),                       m_settings, 0 );
   MENUENT(mTools,   ZTX("Keyboard Shortcuts"), 0,             ZTX("Change Keyboard Shortcut Keys"),                 m_KBshortcuts, 0 );
   MENUENT(mTools,   ZTX("Manage Collections"), 0,             ZTX("Organize images into collections"),              m_manage_coll, 0 );
   MENUENT(mTools,   ZTX("Slide Show"), 0,                     ZTX("Start a slide show"),                            m_slideshow, 0 );
   MENUENT(mTools,   ZTX("Batch Convert"), 0,                  ZTX("Rename/convert/resize/move multiple files"),     m_batch_convert, 0 );
   MENUENT(mTools,   ZTX("Batch Upright"), 0,                  ZTX("Upright multiple files rotated 90º"),            m_batch_upright, 0 );
   MENUENT(mTools,   ZTX("Batch RAW (DCraw)"), 0,              ZTX("Convert camera RAW files using DCraw"),          m_batch_dcraw, 0 );
   MENUENT(mTools,   ZTX("Batch RAW (Raw Therapee)"), 0,       ZTX("Convert camera RAW files using Raw Therapee"),   m_batch_rawtherapee, 0 );
   MENUENT(mTools,   ZTX("Show Brightness Distribution"), 0,   ZTX("Show a brightness distribution graph"),          m_show_brdist, 0 );
   MENUENT(mTools,   ZTX("Grid Lines"), 0,                     ZTX("Show or revise grid lines"),                     m_gridlines, 0 );
   MENUENT(mTools,   ZTX("Line Color"), 0,                     ZTX("Change color of foreground lines"),              m_fg_color, 0 );
   MENUENT(mTools,   ZTX("Show RGB"), 0,                       ZTX("Show RGB colors at mouse click"),                m_show_RGB, 0 );
   MENUENT(mTools,   ZTX("Dark/Bright Pixels"), 0,             ZTX("Highlight darkest and brightest pixels"),        m_darkbrite, 0 );
   MENUENT(mTools,   ZTX("Find Duplicate Images"), 0,          ZTX("Search all image files and report duplicates"),  m_duplicates, 0 );
   MENUENT(mTools,   ZTX("Monitor Color"), 0,                  ZTX("Chart to adjust monitor color"),                 m_moncheck, 0 );
   MENUENT(mTools,   ZTX("Monitor Gamma"), 0,                  ZTX("Chart to adjust monitor gamma"),                 m_mongamma, 0 );
   MENUENT(mTools,   ZTX("Change Language"), 0,                ZTX("Change the GUI language"),                       m_lang, 0 );
   MENUENT(mTools,   ZTX("Missing Translations"), 0,           ZTX("Report missing translations"),                   m_untranslated, 0 );
   MENUENT(mTools,   ZTX("Menu and Launcher"), 0,              ZTX("Create a Gnome menu and launcher"),              m_menu_launcher, 0 );
   MENUENT(mTools,   ZTX("Burn Images to CD/DVD"), 0,          ZTX("Burn selected image files to CD or DVD"),        m_burn, 0 );
   MENUENT(mTools,   ZTX("Resources"), 0,                      ZTX("Memory and CPU (to terminal/logfile)"),          m_resources, 0 );
///MENUENT(mTools,   ZTX("zappcrash test"), 0,                     "deliberate zappcrash",                           m_zappcrash, 0 );

   MENUENT(mMeta,    ZTX("View Metadata (short)"), 0,       ZTX("List a few key metadata items"),           m_meta_view_short, 0 );
   MENUENT(mMeta,    ZTX("View Metadata (long)"), 0,        ZTX("List all metadata items"),                 m_meta_view_long, 0 );
   MENUENT(mMeta,    ZTX("View Captions and Comments"), 0,  ZTX("List captions and comments only"),         m_meta_view_capcomm, 0 );
   MENUENT(mMeta,    ZTX("Show Captions on Image"), 0,      ZTX("(Toggle) show captions and comments"),     m_captions, 0 );
   MENUENT(mMeta,    ZTX("Edit Metadata"), 0,               ZTX("Edit image tags/caption/rating ..."),      m_edit_metadata, 0 );
   MENUENT(mMeta,    ZTX("Edit Any Metadata"), 0,           ZTX("Edit any image metadata"),                 m_meta_edit_any, 0 );
   MENUENT(mMeta,    ZTX("Delete Metadata"), 0,             ZTX("Remove all metadata from an image"),       m_meta_delete, 0 );
   MENUENT(mMeta,    ZTX("Batch Add/Remove Tags"), 0,       ZTX("Add/remove tags for multiple images"),     m_batchTags, 0 );
   MENUENT(mMeta,    ZTX("Download Geolocations"), 0,       ZTX("Download initial geolocation database"),   m_download_geolocs, 0 );
///MENUENT(mMeta,        "World Map Test", 0,                   "Test world map coordinates conversion",    m_worldmap_test, 0 );
   MENUENT(mMeta,    ZTX("Edit Geotags"), 0,                ZTX("Edit image location and geotags"),         m_edit_geotags, 0 );
   MENUENT(mMeta,    ZTX("Batch Add Geotags"), 0,           ZTX("Add geotags to multiple images"),          m_batch_add_geotags, 0 );
   MENUENT(mMeta,    ZTX("Images by Location/Date"), 0,     ZTX("Find all images for a location [date]"),   m_geotag_groups, 0 );
   MENUENT(mMeta,    ZTX("Images by Map Location"), 0,      ZTX("Find images by clicking a world map"),     m_geotag_worldmap, 0 );
   MENUENT(mMeta,    ZTX("Search Images"), 0,               ZTX("Find images meeting select criteria"),     m_search_images, 0 );

   MENUENT(mArea,    ZTX("Select"), 0,          ZTX("Select object or area for editing"),                m_select, 0 );
   MENUENT(mArea,    ZTX("Show"), 0,            ZTX("Show (outline) existing area"),                     m_select_show, 0 );
   MENUENT(mArea,    ZTX("Hide"), 0,            ZTX("Hide existing area"),                               m_select_hide, 0 );
   MENUENT(mArea,    ZTX("Enable"), 0,          ZTX("Enable area for editing"),                          m_select_enable, 0 );
   MENUENT(mArea,    ZTX("Disable"), 0,         ZTX("Disable area for editing"),                         m_select_disable, 0 );
   MENUENT(mArea,    ZTX("Invert"), 0,          ZTX("Reverse existing area"),                            m_select_invert, 0 );
   MENUENT(mArea,    ZTX("Unselect"), 0,        ZTX("Erase existing area"),                              m_select_unselect, 0 );
   MENUENT(mArea,    ZTX("Area Color"), 0,      ZTX("Change color of area outlines"),                    m_fg_color, 0 );
   MENUENT(mArea,    ZTX("Copy"), 0,            ZTX("Copy an area for later pasting"),                   m_select_copy, 0 );
   MENUENT(mArea,    ZTX("Paste"), 0,           ZTX("Paste an area into the current image"),             m_select_paste, 0 );
   MENUENT(mArea,    ZTX("Open"), 0,            ZTX("Open a file with a saved area"),                    m_select_open, 0 );
   MENUENT(mArea,    ZTX("Save"), 0,            ZTX("Save an area to a file"),                           m_select_save, 0 );
   MENUENT(mArea,    ZTX("Save PNG"), 0,        ZTX("Save an area to a PNG file with transparency"),     m_select_save_png, 0 );

   MENUENT(mEdit,    ZTX("Trim/Rotate"), 0,              ZTX("Trim/Crop margins and/or Rotate"),            m_trimrotate, 0 );
   MENUENT(mEdit,    ZTX("Rotate 90º"), 0,               ZTX("Rotate 90 degrees"),                          m_rotate90, 0 );
   MENUENT(mEdit,    ZTX("Auto-Trim"), 0,                ZTX("Remove margins from warp, panorama, etc."),   m_autotrim, 0 );
   MENUENT(mEdit,    ZTX("Voodoo Enhance"), 0,           ZTX("Fast auto enhance that may work OK"),         m_voodoo, 0 );
   MENUENT(mEdit,    ZTX("Retouch Combo"), 0,            ZTX("Adjust brightness, contrast, color"),         m_combo, 0 );
   MENUENT(mEdit,    ZTX("Tone Mapping"), 0,             ZTX("Add local contrast, enhance details"),        m_tonemap, 0 );
   MENUENT(mEdit,    ZTX("Brightness Distribution"), 0,  ZTX("Adjust brightness distribution"),             m_adjust_brdist, 0 );
   MENUENT(mEdit,    ZTX("Resize"), 0,                   ZTX("Change pixel dimensions"),                    m_resize, 0 );
   MENUENT(mEdit,    ZTX("Flip"), 0,                     ZTX("Mirror image horizontally or vertically"),    m_flip, 0 );
   MENUENT(mEdit,    ZTX("Add Text"), 0,                 ZTX("Write text on image"),                        m_write_text, 0 );
   MENUENT(mEdit,    ZTX("Add Lines"), 0,                ZTX("Write lines or arrows on image"),             m_write_line, 0 );
   MENUENT(mEdit,    ZTX("Brightness Ramp"), 0,          ZTX("Fix brightness uniformity across image"),     m_brightramp, 0 );
   MENUENT(mEdit,    ZTX("Paint Edits"), 0,              ZTX("Paint edit function gradually with mouse"),   m_paint_edits, 0 );
   MENUENT(mEdit,    ZTX("Leverage Edits"), 0,           ZTX("Leverage edits by brightness or color"),      m_lever_edits, 0 );

   MENUENT(mRep,  ZTX("Sharpen"), 0,               ZTX("Make the image look sharper"),                   m_sharpen, 0 );
   MENUENT(mRep,  ZTX("Blur"), 0,                  ZTX("Make the image look fuzzy"),                     m_blur, 0 );
   MENUENT(mRep,  ZTX("Reduce Noise"), 0,          ZTX("Filter noise from low-light photos"),            m_denoise, 0 );
   MENUENT(mRep,  ZTX("Smart Erase"), 0,           ZTX("Remove unwanted objects"),                       m_smart_erase, 0 );
   MENUENT(mRep,  ZTX("Red Eyes"), 0,              ZTX("Fix red-eyes from electronic flash"),            m_redeye, 0 );
   MENUENT(mRep,  ZTX("Paint/Clone Pixels"), 0,    ZTX("Paint image pixels using the mouse"),            m_paint_clone, 0 );
   MENUENT(mRep,  ZTX("Remove Dust"), 0,           ZTX("Remove dust spots from scanned slides"),         m_dust, 0 );
   MENUENT(mRep,  ZTX("Anti-alias"), 0,            ZTX("Smoothen edges with jaggies"),                   m_antialias, 0 );
   MENUENT(mRep,  ZTX("Fix Color Fringes"), 0,     ZTX("Reduce Chromatic Abberation"),                   m_chromatic, 0 );
   MENUENT(mRep,  ZTX("Fix Stuck Pixels"), 0,      ZTX("Erase known hot and dark pixels"),               m_stuckpix, 0 );
   MENUENT(mRep,  ZTX("Shift Colors"), 0,          ZTX("Shift/convert colors into other colors"),        m_shift_colors, 0 );
   MENUENT(mRep,  ZTX("Color Mode"), 0,            ZTX("Make BW/color, negative/positive, sepia"),       m_colormode, 0 );
   MENUENT(mRep,  ZTX("Color Profile"), 0,         ZTX("Convert to another color profile"),              m_colorprof, 0 );
   MENUENT(mRep,  ZTX("Match Colors"), 0,          ZTX("Match colors on one image with another"),        m_match_color, 0 );
   MENUENT(mRep,  ZTX("Revise RGB"), 0,            ZTX("Adjust color in selected image areas"),          m_revise_RGB, 0 );
   MENUENT(mRep,      "CMYK", 0,                   ZTX("Adjust color using CMYK or RGB values"),         m_CMYK, 0 );

   MENUENT(mBend,    ZTX("Unbend"), 0,             ZTX("Remove curvature, esp. panoramas"),         m_unbend, 0 );
   MENUENT(mBend,    ZTX("Fix Perspective"), 0,    ZTX("Straighten objects seen from an angle"),    m_perspective, 0 );
   MENUENT(mBend,    ZTX("Warp area"), 0,          ZTX("Distort image areas using the mouse"),      m_warp_area, 0 );
   MENUENT(mBend,    ZTX("Warp curved"), 0,        ZTX("Distort the whole image using the mouse"),  m_warp_curved, 0 );
   MENUENT(mBend,    ZTX("Warp linear"), 0,        ZTX("Distort the whole image using the mouse"),  m_warp_linear, 0 );
   MENUENT(mBend,    ZTX("Warp affine"), 0,        ZTX("Distort the whole image using the mouse"),  m_warp_affine, 0 );
   MENUENT(mBend,    ZTX("Flatten Book Page"), 0,  ZTX("Flatten a photographed book page"),         m_flatbook, 0 );

   MENUENT(mEff,  ZTX("Color Depth"), 0,     ZTX("Reduce color depth (posterize)"),                   m_colordep, 0 );
   MENUENT(mEff,  ZTX("Sketch"), 0,          ZTX("Convert to pencil sketch"),                         m_sketch, 0 );
   MENUENT(mEff,  ZTX("Line Drawing"), 0,    ZTX("Convert to line drawing (edge detection)"),         m_linedraw, 0 );
   MENUENT(mEff,  ZTX("Color Drawing"), 0,   ZTX("Convert to solid color drawing"),                   m_colordraw, 0 );
   MENUENT(mEff,  ZTX("Graduated Blur"), 0,  ZTX("Graduated Blur depending on contrast"),             m_gradblur, 0 );
   MENUENT(mEff,  ZTX("Embossing"), 0,       ZTX("Create an embossed or 3D appearance"),              m_emboss, 0 );
   MENUENT(mEff,  ZTX("Tiles"), 0,           ZTX("Convert to square tiles"),                          m_tiles, 0 );
   MENUENT(mEff,  ZTX("Dots"), 0,            ZTX("Convert to dots (Roy Lichtenstein effect)"),        m_dots, 0 );
   MENUENT(mEff,  ZTX("Painting"), 0,        ZTX("Convert into a simulated painting"),                m_painting, 0 );
   MENUENT(mEff,  ZTX("Vignette"), 0,        ZTX("Change brightness or color radially"),              m_vignette, 0 );
   MENUENT(mEff,  ZTX("Texture"), 0,         ZTX("Add texture to an image"),                          m_texture, 0 );
   MENUENT(mEff,  ZTX("Pattern"), 0,         ZTX("Tile image with a repeating pattern"),              m_pattern, 0 );
   MENUENT(mEff,  ZTX("Mosaic"), 0,          ZTX("Create a mosaic with tiles made from all images"),  m_mosaic, 0);
   MENUENT(mEff,  ZTX("Custom Kernel"), 0,   ZTX("Process an image using a custom kernel"),           m_anykernel, 0);
   MENUENT(mEff,  ZTX("Make Waves"), 0,      ZTX("Warp an image with a wave pattern"),                m_waves, 0);

   MENUENT(mComb,    ZTX("High Dynamic Range"), 0,  ZTX("Combine bright/dark images for better detail"),    m_HDR, 0 );
   MENUENT(mComb,    ZTX("High Depth of Field"), 0, ZTX("Combine near/far focus images for deeper focus"),  m_HDF, 0 );
   MENUENT(mComb,    ZTX("Stack / Paint"), 0,       ZTX("Combine images to erase passing people, etc."),    m_STP, 0 );
   MENUENT(mComb,    ZTX("Stack / Noise"), 0,       ZTX("Combine noisy images into a low-noise image"),     m_STN, 0 );
   MENUENT(mComb,    ZTX("Panorama"), 0,            ZTX("Combine images into a panorama"),                  m_pano, 0 );
   MENUENT(mComb,    ZTX("Vertical Panorama"), 0,   ZTX("Combine images into a vertical panorama"),         m_vpano, 0 );
   MENUENT(mComb,    ZTX("Mashup"), 0,              ZTX("Arrange multiple images on a background image"),   m_mashup, 0 );

   MENUENT(mPlug,    ZTX("Edit Plugins"), 0, ZTX("Add another image editor to the menu"), m_edit_plugins, 0);

   MENUENT(mHelp,    ZTX("Quick Start"), 0,            ZTX("Quick Start mini-guide"),                 m_help, 0 );
   MENUENT(mHelp,    ZTX("User Guide"), 0,             ZTX("Read the user guide"),                    m_help, 0 );
   MENUENT(mHelp,    ZTX("User Guide Changes"), 0,     ZTX("Recent user guide changes"),              m_help, 0 );
   MENUENT(mHelp,    ZTX("Edit Functions Summary"), 0, ZTX("Summary of image edit functions"),        m_help, 0 );
   MENUENT(mHelp,    ZTX("README"), 0,                 ZTX("Technical installation notes"),           m_help, 0 );
   MENUENT(mHelp,    ZTX("Change Log"), 0,             ZTX("List updates by Fotoxx version"),         m_help, 0 );
   MENUENT(mHelp,    ZTX("Log File"), 0,               ZTX("View the log file and error messages"),   m_help, 0 );
   MENUENT(mHelp,    ZTX("Translations"), 0,           ZTX("How to do Fotoxx translations"),          m_help, 0 );
   MENUENT(mHelp,    ZTX("Home Page"), 0,              ZTX("Show the Fotoxx web page"),               m_help, 0 );
   MENUENT(mHelp,    ZTX("About"), 0,                  ZTX("Version, license, contact, credits"),     m_help, 0 );

   NFmenu = Nmenus;                                                        //  end of F view menus
   
   //  G view menu

   MENUENT(0,  ZTX("Image"),        "viewF.png",      imagefile_tip,                               m_viewmode, "F" );
   MENUENT(0,  ZTX("World Map"),    "viewW.png",      worldmap_tip,                                m_viewmode, "W" );
   MENUENT(0,  ZTX("Sync.G"),       "sync.G.png",     sync_G_tip,                                  navi::menufuncx, 0 );
   MENUENT(0,  ZTX("Open"),         "open.png",       ZTX("open another directory"),               navi::menufuncx, 0 );
   MENUENT(0,  ZTX("GoTo"),         "goto.png",       ZTX("go to bookmarked image"),               navi::menufuncx, 0 );
   MENUENT(0,  ZTX("Zoom+"),        "zoom+.png",      ZTX("increase thumbnail size"),              navi::menufuncx, 0 );
   MENUENT(0,  ZTX("Zoom-"),        "zoom-.png",      ZTX("reduce thumbnail size"),                navi::menufuncx, 0 );
   MENUENT(0,  ZTX("Sort"),         "sort.png",       ZTX("change sort order"),                    navi::menufuncx, 0 );
   MENUENT(0,  ZTX("First"),        "top.png",        ZTX("jump to beginning (top)"),              navi::menufuncx, 0 );
   MENUENT(0,  ZTX("Last"),         "bottom.png",     ZTX("jump to end (bottom)"),                 navi::menufuncx, 0 );
   MENUENT(0,  ZTX("Page↑"),        "up+.png",       ZTX("previous page"),                        navi::menufuncx, 0 );
   MENUENT(0,  ZTX("Page↓"),        "down+.png",     ZTX("next page"),                            navi::menufuncx, 0 );
   MENUENT(0,  ZTX("Row↑"),         "up.png",        ZTX("previous row"),                         navi::menufuncx, 0 );
   MENUENT(0,  ZTX("Row↓"),         "down.png",      ZTX("next row"),                             navi::menufuncx, 0 );
   MENUENT(0,  ZTX("Scroll"),       "scroll.png",     ZTX("slow scroll"),                          navi::menufuncx, 0 );

   mToolsG = create_popmenu();                                             //  v.14.07  v.14.09
   cchar * toolsG_tip = ZTX("Batch functions, Combine functions");

   MENUENT(0,  ZTX("Tools"),        "tools.png",      toolsG_tip,               (cbFunc *) popup_menu,  (cchar *) mToolsG);

   MENUENT(mToolsG,  ZTX("Batch Convert"), 0,               ZTX("Rename/convert/resize/move multiple files"),        m_batch_convert, 0 );
   MENUENT(mToolsG,  ZTX("Batch RAW (DCraw)"), 0,           ZTX("Convert camera RAW files using DCraw"),             m_batch_dcraw, 0 );
   MENUENT(mToolsG,  ZTX("Batch RAW (Raw Therapee)"), 0,    ZTX("Convert camera RAW files using Raw Therapee"),      m_batch_rawtherapee, 0 );
   MENUENT(mToolsG,  ZTX("Batch Add Geotags"), 0,           ZTX("Add geotags to multiple images"),                   m_batch_add_geotags, 0 );
   MENUENT(mToolsG,  ZTX("Images by Location/Date"), 0,     ZTX("Find all images for a location [date]"),            m_geotag_groups, 0 );
   MENUENT(mToolsG,  ZTX("Images by Map Location"), 0,      ZTX("Find images by clicking a world map"),              m_geotag_worldmap, 0 );
   MENUENT(mToolsG,  ZTX("Search Images"), 0,               ZTX("Find images meeting select criteria"),              m_search_images, 0 );
   MENUENT(mToolsG,  ZTX("Find Duplicate Images"), 0,       ZTX("Search all image files and report duplicates"),     m_duplicates, 0 );
   MENUENT(mToolsG,  ZTX("High Dynamic Range"), 0,          ZTX("Combine bright/dark images for better detail"),     m_HDR, 0 );
   MENUENT(mToolsG,  ZTX("High Depth of Field"), 0,         ZTX("Combine near/far focus images for deeper focus"),   m_HDF, 0 );
   MENUENT(mToolsG,  ZTX("Stack / Paint"), 0,               ZTX("Combine images to erase passing people, etc."),     m_STP, 0 );
   MENUENT(mToolsG,  ZTX("Stack / Noise"), 0,               ZTX("Combine noisy images into a low-noise image"),      m_STN, 0 );
   MENUENT(mToolsG,  ZTX("Panorama"), 0,                    ZTX("Combine images into a panorama"),                   m_pano, 0 );
   MENUENT(mToolsG,  ZTX("Vertical Panorama"), 0,           ZTX("Combine images into a vertical panorama"),          m_vpano, 0 );

   NGmenu = Nmenus;                                                        //  end of G view menus
   
   //  W view menu

   MENUENT(0,  ZTX("Image"),        "viewF.png",      imagefile_tip,       m_viewmode, "F" );
   MENUENT(0,  ZTX("Gallery"),      "viewG.png",      gallery_tip,         m_viewmode, "G" );

   NWmenu = Nmenus;
   
   //  build the vertical menus for the F/G/W windows
   
   Vmenu *Fvm = Vmenu_new(Fmenu);
   Vmenu *Gvm = Vmenu_new(Gmenu);
   Vmenu *Wvm = Vmenu_new(Wmenu);
   Vmenu *Xvm;
   int   iz = iconsize;

   for (me = 0; me < Nmenus; me++)
   {
      cchar *pp = menutab[me].icon;                                        //  skip entries for KB shortcuts
      if (pp && strEqu(pp,"KB shortcut")) continue;                        //  bugfix                             v.14.07.1

      if (me < NFmenu) Xvm = Fvm;
      else if (me < NGmenu) Xvm = Gvm;
      else Xvm = Wvm;
      
      if (menutab[me].topmenu)
         add_popmenu_item(menutab[me].topmenu, menutab[me].menu,           //  submenu within top menu 
                menutab[me].func, menutab[me].arg, menutab[me].desc);
      else {                                                               //  top menu
         if (strEqu(menu_style,"icons")) {
            if (menutab[me].icon)
               Vmenu_add(Xvm, 0, menutab[me].icon,iz,iz,menutab[me].desc, 
                                 menutab[me].func, menutab[me].arg);
            else
               Vmenu_add(Xvm, menutab[me].menu, 0, 0, 0, menutab[me].desc, 
                              menutab[me].func, menutab[me].arg);
         }
         else  /* both */                                                  //  bugfix                             v.14.10.1
            Vmenu_add(Xvm, menutab[me].menu, menutab[me].icon,iz,iz, 
                           menutab[me].desc, menutab[me].func, menutab[me].arg);
      }
   }
   
   //  add plugin menu items to plugins menu

   char     plugfile[200], buff[200], *pp;
   FILE     *fid;
   STATB    stbuff;

   snprintf(plugfile,200,"%s/plugins",get_zuserdir());                     //  plugins file

   err = stat(plugfile,&stbuff);                                           //  exists?
   if (err)
   {
      fid = fopen(plugfile,"w");                                           //  no, create default
      fprintf(fid,"Gimp = gimp %%s \n");
      fprintf(fid,"auto-gamma = mogrify -auto-gamma %%s \n"); 
      fprintf(fid,"whiteboard cleanup = mogrify "                          //  ImageMagick white board cleanup    v.14.05
                  "-morphology Convolve DoG:15,100,0 "
                  "-negate -normalize -blur 0x1 -channel RBG "
                  "-level 60%%,91%%,0.1 %%s \n"); 
      fclose(fid);
   }

   fid = fopen(plugfile,"r");                                              //  open plugins file
   if (fid)
   {   
      for (ii = 0; ii < 99; ii++)                                          //  read list of plugins
      {
         pp = fgets_trim(buff,199,fid,1);
         if (! pp) break;
         plugins[ii] = zstrdup(buff);
      }

      fclose(fid);
      Nplugins = ii;
   }

   for (ii = 0; ii < Nplugins; ii++)
   {
      char *pp = strstr(plugins[ii]," = ");
      if (! pp) continue;
      *pp = 0;
      add_popmenu_item(mPlug, plugins[ii], m_run_plugin, 0, ZTX("Run as Fotoxx edit function"));  
      *pp = ' ';
   }
   
   //  do setups for right-click popup menus

   cchar    *menupopimage = ZTX("Popup Image");                            //  v.14.03
   cchar    *menupopimageadd = ZTX("Popup Image (add)");                   //  v.14.09
   cchar    *menumetadata1 = ZTX("View Metadata");
   cchar    *menumetadata2 = ZTX("Edit Metadata");
   cchar    *menurename = ZTX("Rename");
   cchar    *menucopytoloc = ZTX("Copy to Location");
   cchar    *menumovetoloc = ZTX("Move to Location");
   cchar    *menucopytoclip = ZTX("Copy to Clipboard");
   cchar    *menuremovefromcoll = ZTX("Remove from Collection");
   cchar    *menucuttocache = ZTX("Cut to Image Cache");
   cchar    *menucopytocache = ZTX("Copy to Image Cache");
   cchar    *menupastecachehere = ZTX("Paste Image Cache Here (clear)");
   cchar    *menupastecachekeep = ZTX("Paste Image Cache Here (keep)");
   cchar    *menutrimrotate = ZTX("Trim/Rotate");
   cchar    *menuresize = ZTX("Resize");
   cchar    *menurotate90 = ZTX("Rotate 90º");
   cchar    *menuvoodoo = ZTX("Voodoo Enhance");
   cchar    *menucombo = ZTX("Retouch Combo");
   cchar    *menubrightdist = ZTX("Brightness Distribution");
   cchar    *menutonemap = ZTX("Tone Mapping");
   cchar    *menuredeyes = ZTX("Red Eyes");
   cchar    *menugrid = ZTX("Grid Lines");
   cchar    *menuselect = ZTX("Select Area");
   cchar    *menuopenraw1 = ZTX("Open RAW file (ufraw)");
   cchar    *menuopenraw2 = ZTX("Open RAW file (Raw Therapee)");
   cchar    *menutrash = ZTX("Trash");
   cchar    *menudelete = Bdelete;

   popmenu_main = create_popmenu();                                        //  main window image
   add_popmenu_item(popmenu_main,menumetadata1,popup_menufunc,"view metadata");
   add_popmenu_item(popmenu_main,menumetadata2,popup_menufunc,"edit metadata");
   add_popmenu_item(popmenu_main,menurename,popup_menufunc,"rename");
   add_popmenu_item(popmenu_main,menucopytoloc,popup_menufunc,"copytoloc");
   add_popmenu_item(popmenu_main,menumovetoloc,popup_menufunc,"movetoloc");
   add_popmenu_item(popmenu_main,menucopytoclip,popup_menufunc,"copytoclip");
   add_popmenu_item(popmenu_main,menurotate90,popup_menufunc,"rotate 90º");
   add_popmenu_item(popmenu_main,menutrimrotate,popup_menufunc,"trim/rotate");
   add_popmenu_item(popmenu_main,menuresize,popup_menufunc,"resize");
   add_popmenu_item(popmenu_main,menuvoodoo,popup_menufunc,"voodoo");
   add_popmenu_item(popmenu_main,menucombo,popup_menufunc,"combo");
   add_popmenu_item(popmenu_main,menubrightdist,popup_menufunc,"brightness dist");
   add_popmenu_item(popmenu_main,menutonemap,popup_menufunc,"tonemap");
   add_popmenu_item(popmenu_main,menuredeyes,popup_menufunc,"redeyes");
   add_popmenu_item(popmenu_main,menugrid,popup_menufunc,"grid");
   add_popmenu_item(popmenu_main,menuselect,popup_menufunc,"select");
   add_popmenu_item(popmenu_main,menutrash,popup_menufunc,"trash");
   add_popmenu_item(popmenu_main,menudelete,popup_menufunc,"delete");

   popmenu_thumb = create_popmenu();                                       //  gallery thumbnail
   add_popmenu_item(popmenu_thumb,menupopimage,popup_menufunc,"popimage");
   add_popmenu_item(popmenu_thumb,menupopimageadd,popup_menufunc,"popimageadd");
   add_popmenu_item(popmenu_thumb,menumetadata1,popup_menufunc,"view metadata");
   add_popmenu_item(popmenu_thumb,menurename,popup_menufunc,"rename");
   add_popmenu_item(popmenu_thumb,menurotate90,popup_menufunc,"rotate 90º thumb");
   add_popmenu_item(popmenu_thumb,menucopytoloc,popup_menufunc,"copytoloc");
   add_popmenu_item(popmenu_thumb,menumovetoloc,popup_menufunc,"movetoloc");
   add_popmenu_item(popmenu_thumb,menucopytocache,popup_menufunc,"copytocache");
   add_popmenu_item(popmenu_thumb,menucopytoclip,popup_menufunc,"copytoclip");
   add_popmenu_item(popmenu_thumb,menutrash,popup_menufunc,"trash");
   add_popmenu_item(popmenu_thumb,menudelete,popup_menufunc,"delete");

   popmenu_raw = create_popmenu();                                         //  gallery thumbnail, RAW file
   add_popmenu_item(popmenu_raw,menuopenraw1,m_ufraw,0);
   add_popmenu_item(popmenu_raw,menuopenraw2,m_rawtherapee,0);
   add_popmenu_item(popmenu_raw,menumetadata1,popup_menufunc,"view metadata");
   add_popmenu_item(popmenu_raw,menurename,popup_menufunc,"rename");
   add_popmenu_item(popmenu_raw,menucopytoloc,popup_menufunc,"copytoloc");
   add_popmenu_item(popmenu_raw,menumovetoloc,popup_menufunc,"movetoloc");
   add_popmenu_item(popmenu_raw,menutrash,popup_menufunc,"trash");
   add_popmenu_item(popmenu_raw,menudelete,popup_menufunc,"delete");

   popmenu_coll_thumb = create_popmenu();                                  //  gallery thumbnail (collection)
   add_popmenu_item(popmenu_coll_thumb,menucopytocache,popup_menufunc,"copytocache");
   add_popmenu_item(popmenu_coll_thumb,menucuttocache,popup_menufunc,"cuttocache");
   add_popmenu_item(popmenu_coll_thumb,menucopytoclip,popup_menufunc,"copytoclip");
   add_popmenu_item(popmenu_coll_thumb,menupastecachekeep,popup_menufunc,"pastecachekeep");
   add_popmenu_item(popmenu_coll_thumb,menupastecachehere,popup_menufunc,"pastecachehere");
   add_popmenu_item(popmenu_coll_thumb,menuremovefromcoll,popup_menufunc,"removefromcoll");

   return;
}


//  set window view mode, F/G/W

void m_viewmode(GtkWidget *, cchar *fgw)
{
   if (FGW == *fgw) return;                                                //  no change
   FGW = *fgw;

   if (*fgw == 'F')                                                        //  set F view mode for image file
   {
      gtk_widget_hide(Ghbox);
      gtk_widget_hide(Whbox);
      gtk_widget_show_all(Fhbox);
      set_mwin_title(); 

      Cstate = &Fstate;                                                    //  set drawing area
      Cdrawin = Fdrawin;
      gdkwin = gtk_widget_get_window(Fdrawin);                             //  GDK window
   }

   if (*fgw == 'G')                                                        //  set G view mode for thumbnail gallery
   {
      gtk_widget_hide(Fhbox);
      gtk_widget_hide(Whbox);
      gtk_widget_show_all(Ghbox);

      static int ftf = 1;                                                  //  required to avoid lack of scroll for the
      if (ftf) zmainloop();                                                //    first time gallery is painted (GTK bug?)
      ftf = 0;

      Cstate = 0;                                                          //  no F/W image drawing area
      Cdrawin = 0;
      gdkwin = 0;
      
      if (curr_file) gallery(curr_file,"paint");                           //  set gallery posn. at curr. file    v.14.10
      else gallery(0,"paint",-1);                                          //  else leave unchanged
   }

   if (*fgw == 'W')                                                        //  set W view mode for world map
   {
      if (! load_worldmap()) return;                                       //  initialize world map and geolocs

      gtk_widget_hide(Fhbox);
      gtk_widget_hide(Ghbox);
      gtk_widget_show_all(Whbox);
   
      Cstate = &Wstate;                                                    //  set drawing area
      Cdrawin = Wdrawin;
      gdkwin = gtk_widget_get_window(Wdrawin);                             //  GDK window

      m_geotag_worldmap(0,0);                                              //  activate clickable world map

      gtk_window_set_title(MWIN,ZTX("Image Locations"));                   //  window title                       v.14.07
      Fpaint2();
   }
   
   return;
}


//  right-click popup menu function

void popup_menufunc(GtkWidget *, cchar *menu)                              //  v.12.12
{
   if (strEqu(menu,"popimage")) popimage(0);                               //  funcs for main and gallery windows
   if (strEqu(menu,"popimageadd")) popimage(1);
   if (strEqu(menu,"view metadata")) meta_view(1);
   if (strEqu(menu,"edit metadata")) m_edit_metadata(0,0);
   if (strEqu(menu,"rename")) m_rename(0,0);                               //  these funcs use clicked_file if defined,
   if (strEqu(menu,"rotate 90º thumb")) m_rotate90_thumb(0,0);             //    else they use curr_file.
   if (strEqu(menu,"copytoloc")) m_copytoloc(0,0);                         //  set clicked_file to null after use.
   if (strEqu(menu,"movetoloc")) m_movetoloc(0,0);
   if (strEqu(menu,"delete")) m_delete(0,0);
   if (strEqu(menu,"trash")) m_trash(0,0);
   if (strEqu(menu,"copytoclip")) copyto_clip(0,0);

   if (strEqu(menu,"removefromcoll")) coll_popup_remove(0,0);              //  funcs for collection gallery 
   if (strEqu(menu,"cuttocache")) coll_popup_cutfile(0,0);                 //  depend on clicked_file being defined
   if (strEqu(menu,"copytocache")) coll_popup_copyfile(0,0);               //  set clicked_file to null after use
   if (strEqu(menu,"pastecachehere")) coll_popup_pastecache(0,"clear");
   if (strEqu(menu,"pastecachekeep")) coll_popup_pastecache(0,"keep");

   if (strEqu(menu,"trim/rotate")) m_trimrotate(0,0);                      //  functions using curr_file only
   if (strEqu(menu,"resize")) m_resize(0,0);                               //  (not used for gallery/thumbnail click)
   if (strEqu(menu,"rotate 90º")) m_rotate90(0,0);
   if (strEqu(menu,"voodoo")) m_voodoo(0,0);
   if (strEqu(menu,"combo")) m_combo(0,0);
   if (strEqu(menu,"brightness dist")) m_adjust_brdist(0,0);
   if (strEqu(menu,"tonemap")) m_tonemap(0,0);
   if (strEqu(menu,"redeyes")) m_redeye(0,0);
   if (strEqu(menu,"grid")) toggle_grid(2);
   if (strEqu(menu,"select")) m_select(0,0);

   return;
}


//  main window mouse right-click popup menu

void image_Rclick_popup(int Nth)
{
   if (! curr_file) return;
   popup_menu(Mwin,popmenu_main);
   return;
}


//  gallery thumbnail mouse left-click function
//  open the clicked file in view mode F

void gallery_Lclick_func(int Nth)
{
   char     *file;

   F1_help_topic = "navigation";
   
   file = gallery(0,"find",Nth);
   if (! file) return;
   f_open(file,Nth,0,1);                                                   //  clicked file >> current file
   zfree(file);
   m_viewmode(0,"F");
   return;
}


//  gallery thumbnail mouse right-click popup menu

void gallery_Rclick_popup(int Nth)
{
   int      ftyp;
   
   clicked_posn = Nth;                                                     //  clicked gallery position (0 base)
   clicked_file = gallery(0,"find",Nth);                                   //  clicked_file is subject for zfree()
   if (! clicked_file) return;
   ftyp = image_file_type(clicked_file);
   
   if (navi::gallerytype == 4)                                             //  gallery type is collection
      popup_menu(Mwin,popmenu_coll_thumb);
   
   else if (ftyp == 2)                                                     //  clicked thumbnail is an image file
      popup_menu(Mwin,popmenu_thumb);

   else if (ftyp == 3)                                                     //  clicked thumbnail is a RAW file
      popup_menu(Mwin,popmenu_raw);

   return;
}



