------------------------------------------------------------------------------
--                                                                          --
--                	        G N A T . RAVENSCAR                         --
--                                                                          --
--                      Copyright (C) 2008-2015, AdaCore                    --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

pragma Profile (Ravenscar);

with Ada.Real_Time; use Ada.Real_Time;
with System;
with Test_All;
with Test_All.Multiple_Queue_Cyclic_Server;
use Test_All.Multiple_Queue_Cyclic_Server;

procedure Test_Multiple_Queue_Cyclic_Server is
   pragma Priority (System.Priority'First);
   R1 : Param_T (REQ1);
   R2 : Param_T (REQ2);
begin
   R1.REQ1_I := 0;
   R2.REQ2_I := 0;
   Test_All.Multiple_Queue_Cyclic_Server.
     My_Cyclic_Server.Put_Request (R1, REQ1);
   R1.REQ1_I := R1.REQ1_I + 1;
   Test_All.Multiple_Queue_Cyclic_Server.
     My_Cyclic_Server.Put_Request (R2, REQ2);
   R2.REQ2_I := R2.REQ2_I + 1;
   Test_All.Multiple_Queue_Cyclic_Server.
     My_Cyclic_Server.Put_Request (R1, REQ1);
   R1.REQ1_I := R1.REQ1_I + 1;
   delay until Test_All.System_Start_Up + Milliseconds (100);
   Test_All.Multiple_Queue_Cyclic_Server.
     My_Cyclic_Server.Put_Request (R1, REQ1);
   R1.REQ1_I := R1.REQ1_I + 1;
   Test_All.Multiple_Queue_Cyclic_Server.
     My_Cyclic_Server.Put_Request (R2, REQ2);
   R2.REQ2_I := R2.REQ2_I + 1;
   Test_All.Multiple_Queue_Cyclic_Server.
     My_Cyclic_Server.Put_Request (R1, REQ1);
   R1.REQ1_I := R1.REQ1_I + 1;
   delay until Test_All.System_Start_Up + Milliseconds (200);
   Test_All.Multiple_Queue_Cyclic_Server.
     My_Cyclic_Server.Put_Request (R2, REQ2);
   R2.REQ2_I := R2.REQ2_I + 1;
   Test_All.Multiple_Queue_Cyclic_Server.
     My_Cyclic_Server.Put_Request (R1, REQ1);
   R1.REQ1_I := R1.REQ1_I + 1;
   Test_All.Multiple_Queue_Cyclic_Server.
     My_Cyclic_Server.Put_Request (R2, REQ2);
   R2.REQ2_I := R2.REQ2_I + 1;
end Test_Multiple_Queue_Cyclic_Server;
