#ifndef _MOVE_SIGNATURE_H
#define _MOVE_SIGNATURE_H
#include "osl/misc/carray.h"
#include "osl/ptype.h"
#include "osl/ptypeTraits.h"
#include <iosfwd>

namespace osl
{
  namespace effect
  {
  /**
   * マスの利きを表す型(SignatureEffectで使う予定).
   * 動ける方向を示す8ビットの情報
   */
  // enumにするとsizeof(MoveSignature)が1にならない可能性があるので
  typedef unsigned char MoveSignature;
  const int MS_PLAYER=(1<<7);
  const int MS_LONG_U=(1<<5);
  const int MS_U=(1<<4);
  const int MS_UL_UR=(1<<3);
  const int MS_L_R_D=(1<<2);
  const int MS_DL_DR=(1<<1);
  const int MS_UUL_UUR=(1<<0);

  template<Player P>
  inline MoveSignature getPlayerMask();

  template<>
  inline MoveSignature getPlayerMask<BLACK>(){ return 0; }

  template<>
  inline MoveSignature getPlayerMask<WHITE>(){ return MS_PLAYER; }
  
  std::ostream& operator<<(std::ostream& os,const MoveSignature signature);

  template<Ptype T>
  struct SignatureTraits{
    static const MoveSignature signature=
    ((PtypeTraits<T>::moveMask & DirectionTraits<LONG_U>::mask)!=0 ? MS_LONG_U : 0) |
    ((PtypeTraits<T>::moveMask & (DirectionTraits<LONG_U>::mask | DirectionTraits<U>::mask) )!=0 ? MS_U : 0) |
    ((PtypeTraits<T>::moveMask & (DirectionTraits<LONG_UL>::mask | DirectionTraits<UL>::mask) )!=0 ? MS_UL_UR : 0) |
    ((PtypeTraits<T>::moveMask & (DirectionTraits<LONG_L>::mask | DirectionTraits<L>::mask) )!=0 ? MS_L_R_D : 0) |
    ((PtypeTraits<T>::moveMask & (DirectionTraits<LONG_DL>::mask | DirectionTraits<DL>::mask) )!=0 ? MS_DL_DR : 0) |
    ((PtypeTraits<T>::moveMask & DirectionTraits<UUL>::mask)!=0 ? MS_UUL_UUR : 0);
  };

  const MoveSignature signature_EMPTY=getPlayerMask<BLACK>();
  const MoveSignature signature_EDGE=getPlayerMask<WHITE>();

    /**
     * PtypeOからMoveSignatureを求めるテーブル.
     */
  class MoveSignatureTable{
    CArray<MoveSignature,PTYPEO_SIZE> signatures;
  private:
    template<Ptype T>
    void setSignature();
    template<Ptype T>
    void setSignatures(Int2Type<T>);
  public:
    MoveSignatureTable();
    MoveSignature getSignature(PtypeO ptypeo) const{
      assert(isValidPtypeO(ptypeo));
      return signatures[static_cast<int>(ptypeo)-PTYPEO_MIN];
    }
  };
  extern const MoveSignatureTable Move_Signature_Table;
  } // namespace effect
} // namespace osl
#endif // _MOVE_SIGNATURE_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
