#!/bin/sh
set -Cefu

# For each revision in a linear history from (included) revision
from=h:com.adacore.xmlada
# back to (excluded) last branchpoint
last_branchpoint=5691b07a92fd6b8bb51a14f2c9dfbc704a51da92
# display diff lines count with directory
year=2016
archive_contents=../xmlada-gpl-$year-src

revision=`mtn automate select $from`
while test $revision != $last_branchpoint; do
    mtn automate update -r $revision 2> /dev/null
    version=`sed 's|^AC_INIT(XML/Ada,\(.*\),report@adacore\.com,xmlada)$|\1|;q' configure.in`
    diff_lines=`diff -urN $archive_contents . --exclude _MTN | wc -l`
    echo "$revision $version $diff_lines"
    revision=`mtn automate parents $revision`
done
