static char rcsid[] = "$Id: genome128_hr.c 151045 2014-10-16 19:08:17Z twu $";
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifndef HAVE_MEMCPY
# define memcpy(d,s,n) bcopy((s),(d),(n))
#endif
#ifndef HAVE_MEMMOVE
# define memmove(d,s,n) bcopy((s),(d),(n))
#endif

#include "genome128_hr.h"

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>		/* For tolower() */

#include "assert.h"
#include "except.h"
#include "cmet.h"
#include "atoi.h"
#include "compress.h"
#include "popcount.h"

#ifdef HAVE_SSE2
#include <emmintrin.h>
#endif
#ifdef HAVE_SSE4_1
#include <smmintrin.h>
#endif
#ifdef HAVE_POPCNT
#include <immintrin.h>
#elif defined(HAVE_MM_POPCNT)
#include <nmmintrin.h>
#endif

#if defined(HAVE_LZCNT) || defined(HAVE_BMI1)
#include <immintrin.h>
#endif

#ifdef WORDS_BIGENDIAN
#include "bigendian.h"
#else
#include "littleendian.h"
#endif


#ifdef DEBUG
#define debug(x) x
#else
#define debug(x)
#endif

/* Fragments */
#ifdef DEBUG1
#define debug1(x) x
#else
#define debug1(x)
#endif

/* Genome_consecutive_matches_pair */
#ifdef DEBUG2
#define debug2(x) x
#else
#define debug2(x)
#endif

/* clear_highbit and clear_lowbit */
#ifdef DEBUG3
#define debug3(x) x
#else
#define debug3(x)
#endif

/* count_leading_zeroes and count_trailing_zeroes */
#ifdef DEBUG4
#define debug4(x) x
#else
#define debug4(x)
#endif

/* 32-bit shortcuts */
#ifdef DEBUG14
#define debug14(x) x
#else
#define debug14(x)
#endif


/* bestscore, besti, totalscore from low bit */
static const int score_low[] =
{16,15, 16,14,15, 14,14,15, 14,12,15, 12,14,15, 14,12,15, 12,12,15, 12,10,15, 10,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 10, 9, 10, 8, 9,  8, 8, 9,  8, 6, 9,  6, 8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 10, 9, 10, 8, 9,  8, 8, 9,  8, 6, 9,  6, 8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 12,11, 12,10,11, 10,10,11, 10, 8,11,  8,10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 10, 9, 10, 8, 9,  8, 8, 9,  8, 6, 9,  6, 8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 11,10, 10, 9,10,  8, 9,10,  8, 7,10,  6, 9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 10, 9,  8, 8, 9,  6, 8, 9,  6, 6, 9,  4, 8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  9, 8,  6, 7, 8,  4, 7, 8,  4, 5, 8,  2, 7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
 14,13, 14,12,13, 12,12,13, 12,10,13, 10,12,13, 12,10,13, 10,10,13, 10, 8,13,  8,
 12,13, 12,10,13, 10,10,13, 10, 8,13,  8,10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6,
 12,13, 12,10,13, 10,10,13, 10, 8,13,  8,10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
 12,13, 12,10,13, 10,10,13, 10, 8,13,  8,10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
 12,13, 12,10,13, 10,10,13, 10, 8,13,  8,10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
 12,13, 12,10,13, 10,10,13, 10, 8,13,  8,10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 12,13, 12,10,13, 10,10,13, 10, 8,13,  8,10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 12,13, 12,10,13, 10,10,13, 10, 8,13,  8,10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 12,13, 12,10,13, 10,10,13, 10, 8,13,  8,10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 12,13, 12,10,13, 10,10,13, 10, 8,13,  8,10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 10, 9, 10, 8, 9,  8, 8, 9,  8, 6, 9,  6, 8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 12,11, 12,10,11, 10,10,11, 10, 8,11,  8,10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 10, 9, 10, 8, 9,  8, 8, 9,  8, 6, 9,  6, 8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 11,10, 10, 9,10,  8, 9,10,  8, 7,10,  6, 9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 10, 9,  8, 8, 9,  6, 8, 9,  6, 6, 9,  4, 8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  9, 8,  6, 7, 8,  4, 7, 8,  4, 5, 8,  2, 7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
 13,12, 12,11,12, 10,11,12, 10, 9,12,  8,11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 11,10, 10, 9,10,  8, 9,10,  8, 7,10,  6, 9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 10, 9,  8, 8, 9,  6, 8, 9,  6, 6, 9,  4, 8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  9, 8,  6, 7, 8,  4, 7, 8,  4, 5, 8,  2, 7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
 12,11, 10,10,11,  8,10,11,  8, 8,11,  6,10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 10, 9,  8, 8, 9,  6, 8, 9,  6, 6, 9,  4, 8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  9, 8,  6, 7, 8,  4, 7, 8,  4, 5, 8,  2, 7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
 11,10,  8, 9,10,  6, 9,10,  6, 7,10,  4, 9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  9, 8,  6, 7, 8,  4, 7, 8,  4, 5, 8,  2, 7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
 10, 9,  6, 8, 9,  4, 8, 9,  4, 6, 9,  2, 8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  9, 8,  4, 7, 8,  2, 7, 8,  2, 5, 8,  0, 7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  8, 7,  2, 6, 7,  0, 6, 7,  0, 4, 7, -2, 6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  7, 6,  0, 5, 6, -2, 5, 6, -2, 3, 6, -4, 5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6,
  5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6, 3, 6, -4, 1, 6, -6, 1, 0, -6,-1, 0, -8,
  5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6, 3, 6, -4, 1, 6, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  6, 5, -2, 4, 5, -4, 4, 5, -4, 2, 5, -6, 4, 5, -4, 2, 5, -6, 2, 5, -6, 0, 5, -8,
  4, 5, -4, 2, 5, -6, 2, 5, -6, 0, 5, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  5, 4, -4, 3, 4, -6, 3, 4, -6, 1, 4, -8, 3, 4, -6, 1, 4, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  4, 3, -6, 2, 3, -8, 2, 3, -8, 0, 3,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  3, 2, -8, 1, 2,-10, 1, 0,-10,-1, 0,-12, 2, 1,-10, 0, 1,-12, 1, 0,-12,-1, 0,-14,
 15,14, 14,13,14, 12,13,14, 12,11,14, 10,13,14, 12,11,14, 10,11,14, 10, 9,14,  8,
 13,14, 12,11,14, 10,11,14, 10, 9,14,  8,11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6,
 13,14, 12,11,14, 10,11,14, 10, 9,14,  8,11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
 13,14, 12,11,14, 10,11,14, 10, 9,14,  8,11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
 13,14, 12,11,14, 10,11,14, 10, 9,14,  8,11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
 13,14, 12,11,14, 10,11,14, 10, 9,14,  8,11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
 13,14, 12,11,14, 10,11,14, 10, 9,14,  8,11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 13,14, 12,11,14, 10,11,14, 10, 9,14,  8,11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 13,14, 12,11,14, 10,11,14, 10, 9,14,  8,11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 13,14, 12,11,14, 10,11,14, 10, 9,14,  8,11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 13,14, 12,11,14, 10,11,14, 10, 9,14,  8,11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 11,14, 10, 9,14,  8, 9,14,  8, 7,14,  6, 9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,14,  8, 7,14,  6, 7,14,  6, 5,14,  4, 7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,14,  6, 5,14,  4, 5,14,  4, 3,14,  2, 5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  5,14,  4, 3,14,  2, 3,14,  2, 1,14,  0, 3,14,  2, 1,14,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 11,10, 10, 9,10,  8, 9,10,  8, 7,10,  6, 9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 10, 9,  8, 8, 9,  6, 8, 9,  6, 6, 9,  4, 8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  9, 8,  6, 7, 8,  4, 7, 8,  4, 5, 8,  2, 7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
 13,12, 12,11,12, 10,11,12, 10, 9,12,  8,11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 11,10, 10, 9,10,  8, 9,10,  8, 7,10,  6, 9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 10, 9,  8, 8, 9,  6, 8, 9,  6, 6, 9,  4, 8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  9, 8,  6, 7, 8,  4, 7, 8,  4, 5, 8,  2, 7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
 12,11, 10,10,11,  8,10,11,  8, 8,11,  6,10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 10, 9,  8, 8, 9,  6, 8, 9,  6, 6, 9,  4, 8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  9, 8,  6, 7, 8,  4, 7, 8,  4, 5, 8,  2, 7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
 11,10,  8, 9,10,  6, 9,10,  6, 7,10,  4, 9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  9, 8,  6, 7, 8,  4, 7, 8,  4, 5, 8,  2, 7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
 10, 9,  6, 8, 9,  4, 8, 9,  4, 6, 9,  2, 8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  9, 8,  4, 7, 8,  2, 7, 8,  2, 5, 8,  0, 7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  8, 7,  2, 6, 7,  0, 6, 7,  0, 4, 7, -2, 6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  7, 6,  0, 5, 6, -2, 5, 6, -2, 3, 6, -4, 5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6,
  5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6, 3, 6, -4, 1, 6, -6, 1, 0, -6,-1, 0, -8,
  5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6, 3, 6, -4, 1, 6, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  6, 5, -2, 4, 5, -4, 4, 5, -4, 2, 5, -6, 4, 5, -4, 2, 5, -6, 2, 5, -6, 0, 5, -8,
  4, 5, -4, 2, 5, -6, 2, 5, -6, 0, 5, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  5, 4, -4, 3, 4, -6, 3, 4, -6, 1, 4, -8, 3, 4, -6, 1, 4, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  4, 3, -6, 2, 3, -8, 2, 3, -8, 0, 3,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  3, 2, -8, 1, 2,-10, 1, 0,-10,-1, 0,-12, 2, 1,-10, 0, 1,-12, 1, 0,-12,-1, 0,-14,
 14,13, 12,12,13, 10,12,13, 10,10,13,  8,12,13, 10,10,13,  8,10,13,  8, 8,13,  6,
 12,13, 10,10,13,  8,10,13,  8, 8,13,  6,10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4,
 12,13, 10,10,13,  8,10,13,  8, 8,13,  6,10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
 12,13, 10,10,13,  8,10,13,  8, 8,13,  6,10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
 12,13, 10,10,13,  8,10,13,  8, 8,13,  6,10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
 12,13, 10,10,13,  8,10,13,  8, 8,13,  6,10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 12,13, 10,10,13,  8,10,13,  8, 8,13,  6,10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 12,13, 10,10,13,  8,10,13,  8, 8,13,  6,10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 12,13, 10,10,13,  8,10,13,  8, 8,13,  6,10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 12,13, 10,10,13,  8,10,13,  8, 8,13,  6,10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 10,13,  8, 8,13,  6, 8,13,  6, 6,13,  4, 8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8,13,  6, 6,13,  4, 6,13,  4, 4,13,  2, 6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,13,  4, 4,13,  2, 4,13,  2, 2,13,  0, 4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2,
  4,13,  2, 2,13,  0, 2,13,  0, 0,13, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 10, 9,  8, 8, 9,  6, 8, 9,  6, 6, 9,  4, 8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  9, 8,  6, 7, 8,  4, 7, 8,  4, 5, 8,  2, 7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
 12,11, 10,10,11,  8,10,11,  8, 8,11,  6,10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 10,11,  8, 8,11,  6, 8,11,  6, 6,11,  4, 8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8,11,  6, 6,11,  4, 6,11,  4, 4,11,  2, 6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6,11,  4, 4,11,  2, 4,11,  2, 2,11,  0, 4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2,
  4,11,  2, 2,11,  0, 2,11,  0, 0,11, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 10, 9,  8, 8, 9,  6, 8, 9,  6, 6, 9,  4, 8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  9, 8,  6, 7, 8,  4, 7, 8,  4, 5, 8,  2, 7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
 11,10,  8, 9,10,  6, 9,10,  6, 7,10,  4, 9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  9, 8,  6, 7, 8,  4, 7, 8,  4, 5, 8,  2, 7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
 10, 9,  6, 8, 9,  4, 8, 9,  4, 6, 9,  2, 8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  9, 8,  4, 7, 8,  2, 7, 8,  2, 5, 8,  0, 7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  8, 7,  2, 6, 7,  0, 6, 7,  0, 4, 7, -2, 6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  7, 6,  0, 5, 6, -2, 5, 6, -2, 3, 6, -4, 5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6,
  5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6, 3, 6, -4, 1, 6, -6, 1, 0, -6,-1, 0, -8,
  5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6, 3, 6, -4, 1, 6, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  6, 5, -2, 4, 5, -4, 4, 5, -4, 2, 5, -6, 4, 5, -4, 2, 5, -6, 2, 5, -6, 0, 5, -8,
  4, 5, -4, 2, 5, -6, 2, 5, -6, 0, 5, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  5, 4, -4, 3, 4, -6, 3, 4, -6, 1, 4, -8, 3, 4, -6, 1, 4, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  4, 3, -6, 2, 3, -8, 2, 3, -8, 0, 3,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  3, 2, -8, 1, 2,-10, 1, 0,-10,-1, 0,-12, 2, 1,-10, 0, 1,-12, 1, 0,-12,-1, 0,-14,
 13,12, 10,11,12,  8,11,12,  8, 9,12,  6,11,12,  8, 9,12,  6, 9,12,  6, 7,12,  4,
 11,12,  8, 9,12,  6, 9,12,  6, 7,12,  4, 9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2,
 11,12,  8, 9,12,  6, 9,12,  6, 7,12,  4, 9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
 11,12,  8, 9,12,  6, 9,12,  6, 7,12,  4, 9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
 11,12,  8, 9,12,  6, 9,12,  6, 7,12,  4, 9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
 11,12,  8, 9,12,  6, 9,12,  6, 7,12,  4, 9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 11,12,  8, 9,12,  6, 9,12,  6, 7,12,  4, 9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 11,12,  8, 9,12,  6, 9,12,  6, 7,12,  4, 9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 11,12,  8, 9,12,  6, 9,12,  6, 7,12,  4, 9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9,12,  6, 7,12,  4, 7,12,  4, 5,12,  2, 7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7,12,  4, 5,12,  2, 5,12,  2, 3,12,  0, 5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  5,12,  2, 3,12,  0, 3,12,  0, 1,12, -2, 3,12,  0, 1,12, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  9, 8,  6, 7, 8,  4, 7, 8,  4, 5, 8,  2, 7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
 11,10,  8, 9,10,  6, 9,10,  6, 7,10,  4, 9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9,10,  6, 7,10,  4, 7,10,  4, 5,10,  2, 7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7,10,  4, 5,10,  2, 5,10,  2, 3,10,  0, 5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  5,10,  2, 3,10,  0, 3,10,  0, 1,10, -2, 3,10,  0, 1,10, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  9, 8,  6, 7, 8,  4, 7, 8,  4, 5, 8,  2, 7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
 10, 9,  6, 8, 9,  4, 8, 9,  4, 6, 9,  2, 8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  9, 8,  4, 7, 8,  2, 7, 8,  2, 5, 8,  0, 7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  8, 7,  2, 6, 7,  0, 6, 7,  0, 4, 7, -2, 6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  7, 6,  0, 5, 6, -2, 5, 6, -2, 3, 6, -4, 5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6,
  5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6, 3, 6, -4, 1, 6, -6, 1, 0, -6,-1, 0, -8,
  5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6, 3, 6, -4, 1, 6, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  6, 5, -2, 4, 5, -4, 4, 5, -4, 2, 5, -6, 4, 5, -4, 2, 5, -6, 2, 5, -6, 0, 5, -8,
  4, 5, -4, 2, 5, -6, 2, 5, -6, 0, 5, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  5, 4, -4, 3, 4, -6, 3, 4, -6, 1, 4, -8, 3, 4, -6, 1, 4, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  4, 3, -6, 2, 3, -8, 2, 3, -8, 0, 3,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  3, 2, -8, 1, 2,-10, 1, 0,-10,-1, 0,-12, 2, 1,-10, 0, 1,-12, 1, 0,-12,-1, 0,-14,
 12,11,  8,10,11,  6,10,11,  6, 8,11,  4,10,11,  6, 8,11,  4, 8,11,  4, 6,11,  2,
 10,11,  6, 8,11,  4, 8,11,  4, 6,11,  2, 8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0,
 10,11,  6, 8,11,  4, 8,11,  4, 6,11,  2, 8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
 10,11,  6, 8,11,  4, 8,11,  4, 6,11,  2, 8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
 10,11,  6, 8,11,  4, 8,11,  4, 6,11,  2, 8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,11,  6, 8,11,  4, 8,11,  4, 6,11,  2, 8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 10,11,  6, 8,11,  4, 8,11,  4, 6,11,  2, 8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 10,11,  6, 8,11,  4, 8,11,  4, 6,11,  2, 8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8,11,  4, 6,11,  2, 6,11,  2, 4,11,  0, 6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6,11,  2, 4,11,  0, 4,11,  0, 2,11, -2, 4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4,
  4,11,  0, 2,11, -2, 2,11, -2, 0,11, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
 10, 9,  6, 8, 9,  4, 8, 9,  4, 6, 9,  2, 8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 9,  4, 6, 9,  2, 6, 9,  2, 4, 9,  0, 6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 9,  2, 4, 9,  0, 4, 9,  0, 2, 9, -2, 4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4,
  4, 9,  0, 2, 9, -2, 2, 9, -2, 0, 9, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  9, 8,  4, 7, 8,  2, 7, 8,  2, 5, 8,  0, 7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  8, 7,  2, 6, 7,  0, 6, 7,  0, 4, 7, -2, 6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  7, 6,  0, 5, 6, -2, 5, 6, -2, 3, 6, -4, 5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6,
  5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6, 3, 6, -4, 1, 6, -6, 1, 0, -6,-1, 0, -8,
  5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6, 3, 6, -4, 1, 6, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  6, 5, -2, 4, 5, -4, 4, 5, -4, 2, 5, -6, 4, 5, -4, 2, 5, -6, 2, 5, -6, 0, 5, -8,
  4, 5, -4, 2, 5, -6, 2, 5, -6, 0, 5, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  5, 4, -4, 3, 4, -6, 3, 4, -6, 1, 4, -8, 3, 4, -6, 1, 4, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  4, 3, -6, 2, 3, -8, 2, 3, -8, 0, 3,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  3, 2, -8, 1, 2,-10, 1, 0,-10,-1, 0,-12, 2, 1,-10, 0, 1,-12, 1, 0,-12,-1, 0,-14,
 11,10,  6, 9,10,  4, 9,10,  4, 7,10,  2, 9,10,  4, 7,10,  2, 7,10,  2, 5,10,  0,
  9,10,  4, 7,10,  2, 7,10,  2, 5,10,  0, 7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2,
  9,10,  4, 7,10,  2, 7,10,  2, 5,10,  0, 7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2,
  7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2, 5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4,
  9,10,  4, 7,10,  2, 7,10,  2, 5,10,  0, 7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2,
  7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2, 5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4,
  7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2, 5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4,
  5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4, 3,10, -2, 1,10, -4, 1, 0, -4,-1, 0, -6,
  9,10,  4, 7,10,  2, 7,10,  2, 5,10,  0, 7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2,
  7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2, 5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4,
  7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2, 5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4,
  5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4, 3,10, -2, 1,10, -4, 1, 0, -4,-1, 0, -6,
  7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2, 5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4,
  5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4, 3,10, -2, 1,10, -4, 1, 0, -4,-1, 0, -6,
  5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4, 3,10, -2, 1,10, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9,10,  4, 7,10,  2, 7,10,  2, 5,10,  0, 7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2,
  7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2, 5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4,
  7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2, 5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4,
  5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4, 3,10, -2, 1,10, -4, 1, 0, -4,-1, 0, -6,
  7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2, 5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4,
  5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4, 3,10, -2, 1,10, -4, 1, 0, -4,-1, 0, -6,
  5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4, 3,10, -2, 1,10, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2, 5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4,
  5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4, 3,10, -2, 1,10, -4, 1, 0, -4,-1, 0, -6,
  5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4, 3,10, -2, 1,10, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  9,10,  4, 7,10,  2, 7,10,  2, 5,10,  0, 7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2,
  7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2, 5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4,
  7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2, 5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4,
  5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4, 3,10, -2, 1,10, -4, 1, 0, -4,-1, 0, -6,
  7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2, 5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4,
  5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4, 3,10, -2, 1,10, -4, 1, 0, -4,-1, 0, -6,
  5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4, 3,10, -2, 1,10, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7,10,  2, 5,10,  0, 5,10,  0, 3,10, -2, 5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4,
  5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4, 3,10, -2, 1,10, -4, 1, 0, -4,-1, 0, -6,
  5,10,  0, 3,10, -2, 3,10, -2, 1,10, -4, 3,10, -2, 1,10, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  9, 8,  4, 7, 8,  2, 7, 8,  2, 5, 8,  0, 7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 8,  2, 5, 8,  0, 5, 8,  0, 3, 8, -2, 5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  5, 8,  0, 3, 8, -2, 3, 8, -2, 1, 8, -4, 3, 8, -2, 1, 8, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  8, 7,  2, 6, 7,  0, 6, 7,  0, 4, 7, -2, 6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  7, 6,  0, 5, 6, -2, 5, 6, -2, 3, 6, -4, 5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6,
  5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6, 3, 6, -4, 1, 6, -6, 1, 0, -6,-1, 0, -8,
  5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6, 3, 6, -4, 1, 6, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  6, 5, -2, 4, 5, -4, 4, 5, -4, 2, 5, -6, 4, 5, -4, 2, 5, -6, 2, 5, -6, 0, 5, -8,
  4, 5, -4, 2, 5, -6, 2, 5, -6, 0, 5, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  5, 4, -4, 3, 4, -6, 3, 4, -6, 1, 4, -8, 3, 4, -6, 1, 4, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  4, 3, -6, 2, 3, -8, 2, 3, -8, 0, 3,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  3, 2, -8, 1, 2,-10, 1, 0,-10,-1, 0,-12, 2, 1,-10, 0, 1,-12, 1, 0,-12,-1, 0,-14,
 10, 9,  4, 8, 9,  2, 8, 9,  2, 6, 9,  0, 8, 9,  2, 6, 9,  0, 6, 9,  0, 4, 9, -2,
  8, 9,  2, 6, 9,  0, 6, 9,  0, 4, 9, -2, 6, 9,  0, 4, 9, -2, 4, 9, -2, 2, 9, -4,
  8, 9,  2, 6, 9,  0, 6, 9,  0, 4, 9, -2, 6, 9,  0, 4, 9, -2, 4, 9, -2, 2, 9, -4,
  6, 9,  0, 4, 9, -2, 4, 9, -2, 2, 9, -4, 4, 9, -2, 2, 9, -4, 2, 9, -4, 0, 9, -6,
  8, 9,  2, 6, 9,  0, 6, 9,  0, 4, 9, -2, 6, 9,  0, 4, 9, -2, 4, 9, -2, 2, 9, -4,
  6, 9,  0, 4, 9, -2, 4, 9, -2, 2, 9, -4, 4, 9, -2, 2, 9, -4, 2, 9, -4, 0, 9, -6,
  6, 9,  0, 4, 9, -2, 4, 9, -2, 2, 9, -4, 4, 9, -2, 2, 9, -4, 2, 9, -4, 0, 9, -6,
  4, 9, -2, 2, 9, -4, 2, 9, -4, 0, 9, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 9,  2, 6, 9,  0, 6, 9,  0, 4, 9, -2, 6, 9,  0, 4, 9, -2, 4, 9, -2, 2, 9, -4,
  6, 9,  0, 4, 9, -2, 4, 9, -2, 2, 9, -4, 4, 9, -2, 2, 9, -4, 2, 9, -4, 0, 9, -6,
  6, 9,  0, 4, 9, -2, 4, 9, -2, 2, 9, -4, 4, 9, -2, 2, 9, -4, 2, 9, -4, 0, 9, -6,
  4, 9, -2, 2, 9, -4, 2, 9, -4, 0, 9, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 9,  0, 4, 9, -2, 4, 9, -2, 2, 9, -4, 4, 9, -2, 2, 9, -4, 2, 9, -4, 0, 9, -6,
  4, 9, -2, 2, 9, -4, 2, 9, -4, 0, 9, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 9,  2, 6, 9,  0, 6, 9,  0, 4, 9, -2, 6, 9,  0, 4, 9, -2, 4, 9, -2, 2, 9, -4,
  6, 9,  0, 4, 9, -2, 4, 9, -2, 2, 9, -4, 4, 9, -2, 2, 9, -4, 2, 9, -4, 0, 9, -6,
  6, 9,  0, 4, 9, -2, 4, 9, -2, 2, 9, -4, 4, 9, -2, 2, 9, -4, 2, 9, -4, 0, 9, -6,
  4, 9, -2, 2, 9, -4, 2, 9, -4, 0, 9, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 9,  0, 4, 9, -2, 4, 9, -2, 2, 9, -4, 4, 9, -2, 2, 9, -4, 2, 9, -4, 0, 9, -6,
  4, 9, -2, 2, 9, -4, 2, 9, -4, 0, 9, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  8, 7,  2, 6, 7,  0, 6, 7,  0, 4, 7, -2, 6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 7,  0, 4, 7, -2, 4, 7, -2, 2, 7, -4, 4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6,
  4, 7, -2, 2, 7, -4, 2, 7, -4, 0, 7, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  7, 6,  0, 5, 6, -2, 5, 6, -2, 3, 6, -4, 5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6,
  5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6, 3, 6, -4, 1, 6, -6, 1, 0, -6,-1, 0, -8,
  5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6, 3, 6, -4, 1, 6, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  6, 5, -2, 4, 5, -4, 4, 5, -4, 2, 5, -6, 4, 5, -4, 2, 5, -6, 2, 5, -6, 0, 5, -8,
  4, 5, -4, 2, 5, -6, 2, 5, -6, 0, 5, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  5, 4, -4, 3, 4, -6, 3, 4, -6, 1, 4, -8, 3, 4, -6, 1, 4, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  4, 3, -6, 2, 3, -8, 2, 3, -8, 0, 3,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  3, 2, -8, 1, 2,-10, 1, 0,-10,-1, 0,-12, 2, 1,-10, 0, 1,-12, 1, 0,-12,-1, 0,-14,
  9, 8,  2, 7, 8,  0, 7, 8,  0, 5, 8, -2, 7, 8,  0, 5, 8, -2, 5, 8, -2, 3, 8, -4,
  7, 8,  0, 5, 8, -2, 5, 8, -2, 3, 8, -4, 5, 8, -2, 3, 8, -4, 3, 8, -4, 1, 8, -6,
  7, 8,  0, 5, 8, -2, 5, 8, -2, 3, 8, -4, 5, 8, -2, 3, 8, -4, 3, 8, -4, 1, 8, -6,
  5, 8, -2, 3, 8, -4, 3, 8, -4, 1, 8, -6, 3, 8, -4, 1, 8, -6, 1, 0, -6,-1, 0, -8,
  7, 8,  0, 5, 8, -2, 5, 8, -2, 3, 8, -4, 5, 8, -2, 3, 8, -4, 3, 8, -4, 1, 8, -6,
  5, 8, -2, 3, 8, -4, 3, 8, -4, 1, 8, -6, 3, 8, -4, 1, 8, -6, 1, 0, -6,-1, 0, -8,
  5, 8, -2, 3, 8, -4, 3, 8, -4, 1, 8, -6, 3, 8, -4, 1, 8, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 8,  0, 5, 8, -2, 5, 8, -2, 3, 8, -4, 5, 8, -2, 3, 8, -4, 3, 8, -4, 1, 8, -6,
  5, 8, -2, 3, 8, -4, 3, 8, -4, 1, 8, -6, 3, 8, -4, 1, 8, -6, 1, 0, -6,-1, 0, -8,
  5, 8, -2, 3, 8, -4, 3, 8, -4, 1, 8, -6, 3, 8, -4, 1, 8, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  7, 6,  0, 5, 6, -2, 5, 6, -2, 3, 6, -4, 5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6,
  5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6, 3, 6, -4, 1, 6, -6, 1, 0, -6,-1, 0, -8,
  5, 6, -2, 3, 6, -4, 3, 6, -4, 1, 6, -6, 3, 6, -4, 1, 6, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  6, 5, -2, 4, 5, -4, 4, 5, -4, 2, 5, -6, 4, 5, -4, 2, 5, -6, 2, 5, -6, 0, 5, -8,
  4, 5, -4, 2, 5, -6, 2, 5, -6, 0, 5, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  5, 4, -4, 3, 4, -6, 3, 4, -6, 1, 4, -8, 3, 4, -6, 1, 4, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  4, 3, -6, 2, 3, -8, 2, 3, -8, 0, 3,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  3, 2, -8, 1, 2,-10, 1, 0,-10,-1, 0,-12, 2, 1,-10, 0, 1,-12, 1, 0,-12,-1, 0,-14,
  8, 7,  0, 6, 7, -2, 6, 7, -2, 4, 7, -4, 6, 7, -2, 4, 7, -4, 4, 7, -4, 2, 7, -6,
  6, 7, -2, 4, 7, -4, 4, 7, -4, 2, 7, -6, 4, 7, -4, 2, 7, -6, 2, 7, -6, 0, 7, -8,
  6, 7, -2, 4, 7, -4, 4, 7, -4, 2, 7, -6, 4, 7, -4, 2, 7, -6, 2, 7, -6, 0, 7, -8,
  4, 7, -4, 2, 7, -6, 2, 7, -6, 0, 7, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 7, -2, 4, 7, -4, 4, 7, -4, 2, 7, -6, 4, 7, -4, 2, 7, -6, 2, 7, -6, 0, 7, -8,
  4, 7, -4, 2, 7, -6, 2, 7, -6, 0, 7, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  6, 5, -2, 4, 5, -4, 4, 5, -4, 2, 5, -6, 4, 5, -4, 2, 5, -6, 2, 5, -6, 0, 5, -8,
  4, 5, -4, 2, 5, -6, 2, 5, -6, 0, 5, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  5, 4, -4, 3, 4, -6, 3, 4, -6, 1, 4, -8, 3, 4, -6, 1, 4, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  4, 3, -6, 2, 3, -8, 2, 3, -8, 0, 3,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  3, 2, -8, 1, 2,-10, 1, 0,-10,-1, 0,-12, 2, 1,-10, 0, 1,-12, 1, 0,-12,-1, 0,-14,
  7, 6, -2, 5, 6, -4, 5, 6, -4, 3, 6, -6, 5, 6, -4, 3, 6, -6, 3, 6, -6, 1, 6, -8,
  5, 6, -4, 3, 6, -6, 3, 6, -6, 1, 6, -8, 3, 6, -6, 1, 6, -8, 1, 0, -8,-1, 0,-10,
  5, 6, -4, 3, 6, -6, 3, 6, -6, 1, 6, -8, 3, 6, -6, 1, 6, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  5, 4, -4, 3, 4, -6, 3, 4, -6, 1, 4, -8, 3, 4, -6, 1, 4, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  4, 3, -6, 2, 3, -8, 2, 3, -8, 0, 3,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  3, 2, -8, 1, 2,-10, 1, 0,-10,-1, 0,-12, 2, 1,-10, 0, 1,-12, 1, 0,-12,-1, 0,-14,
  6, 5, -4, 4, 5, -6, 4, 5, -6, 2, 5, -8, 4, 5, -6, 2, 5, -8, 2, 5, -8, 0, 5,-10,
  4, 5, -6, 2, 5, -8, 2, 5, -8, 0, 5,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  4, 3, -6, 2, 3, -8, 2, 3, -8, 0, 3,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
  3, 2, -8, 1, 2,-10, 1, 0,-10,-1, 0,-12, 2, 1,-10, 0, 1,-12, 1, 0,-12,-1, 0,-14,
  5, 4, -6, 3, 4, -8, 3, 4, -8, 1, 4,-10, 3, 4, -8, 1, 4,-10, 1, 0,-10,-1, 0,-12,
  3, 2, -8, 1, 2,-10, 1, 0,-10,-1, 0,-12, 2, 1,-10, 0, 1,-12, 1, 0,-12,-1, 0,-14,
  4, 3, -8, 2, 3,-10, 2, 3,-10, 0, 3,-12, 2, 1,-10, 0, 1,-12, 1, 0,-12,-1, 0,-14,
  3, 2,-10, 1, 2,-12, 1, 0,-12,-1, 0,-14, 2, 1,-12, 0, 1,-14, 1, 0,-14,-1, 0,-16,
};
 
/* bestscore, besti, totalscore from high bit */
static const int score_high[] =
{16,15, 16,15,14, 14,14,13, 14,14,13, 12,14,15, 14,13,12, 12,13,12, 12,13,12, 10,
 14,15, 14,13,14, 12,12,11, 12,12,11, 10,12,11, 12,12,11, 10,12,11, 10,12,11,  8,
 14,15, 14,13,14, 12,12,13, 12,12,13, 10,12,15, 12,11,10, 10,11,10, 10,11,10,  8,
 12,15, 12,11,10, 10,11,10, 10,11,10,  8,11,10, 10,11,10,  8,11,10,  8,11,10,  6,
 14,15, 14,13,14, 12,12,13, 12,12,13, 10,12,15, 12,11,12, 10,11,12, 10,11,12,  8,
 12,15, 12,11,14, 10,10, 9, 10,10, 9,  8,10, 9, 10,10, 9,  8,10, 9,  8,10, 9,  6,
 12,15, 12,11,14, 10,10, 9, 10,10, 9,  8,10, 9, 10,10, 9,  8,10, 9,  8,10, 9,  6,
 10, 9, 10,10, 9,  8,10, 9,  8,10, 9,  6,10, 9,  8,10, 9,  6,10, 9,  6,10, 9,  4,
 14,15, 14,13,14, 12,12,13, 12,12,13, 10,12,15, 12,11,12, 10,11,12, 10,11,12,  8,
 12,15, 12,11,14, 10,10,11, 10,10,11,  8,10,11, 10,10,11,  8,10,11,  8,10,11,  6,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9, 8,  8, 9, 8,  8, 9, 8,  6,
 10,15, 10, 9, 8,  8, 9, 8,  8, 9, 8,  6, 9, 8,  8, 9, 8,  6, 9, 8,  6, 9, 8,  4,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9, 8,  8, 9, 8,  8, 9, 8,  6,
 10,15, 10, 9, 8,  8, 9, 8,  8, 9, 8,  6, 9, 8,  8, 9, 8,  6, 9, 8,  6, 9, 8,  4,
 10,15, 10, 9, 8,  8, 9, 8,  8, 9, 8,  6, 9, 8,  8, 9, 8,  6, 9, 8,  6, 9, 8,  4,
  9, 8,  8, 9, 8,  6, 9, 8,  6, 9, 8,  4, 9, 8,  6, 9, 8,  4, 9, 8,  4, 9, 8,  2,
 14,15, 14,13,14, 12,12,13, 12,12,13, 10,12,15, 12,11,12, 10,11,12, 10,11,12,  8,
 12,15, 12,11,14, 10,10,11, 10,10,11,  8,10,11, 10,10,11,  8,10,11,  8,10,11,  6,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,10,  8, 9,10,  8, 9,10,  6,
 10,15, 10, 9,10,  8, 9,10,  8, 9,10,  6, 9,10,  8, 9,10,  6, 9,10,  6, 9,10,  4,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8, 7,  8, 8, 7,  6, 8, 7,  8, 8, 7,  6, 8, 7,  6, 8, 7,  4,
 10,15, 10, 9,14,  8, 8, 7,  8, 8, 7,  6, 8, 7,  8, 8, 7,  6, 8, 7,  6, 8, 7,  4,
  8, 7,  8, 8, 7,  6, 8, 7,  6, 8, 7,  4, 8, 7,  6, 8, 7,  4, 8, 7,  4, 8, 7,  2,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8, 7,  8, 8, 7,  6, 8, 7,  8, 8, 7,  6, 8, 7,  6, 8, 7,  4,
 10,15, 10, 9,14,  8, 8, 7,  8, 8, 7,  6, 8, 7,  8, 8, 7,  6, 8, 7,  6, 8, 7,  4,
  8, 7,  8, 8, 7,  6, 8, 7,  6, 8, 7,  4, 8, 7,  6, 8, 7,  4, 8, 7,  4, 8, 7,  2,
 10,15, 10, 9,14,  8, 8, 7,  8, 8, 7,  6, 8, 7,  8, 8, 7,  6, 8, 7,  6, 8, 7,  4,
  8, 7,  8, 8, 7,  6, 8, 7,  6, 8, 7,  4, 8, 7,  6, 8, 7,  4, 8, 7,  4, 8, 7,  2,
  8, 7,  8, 8, 7,  6, 8, 7,  6, 8, 7,  4, 8, 7,  6, 8, 7,  4, 8, 7,  4, 8, 7,  2,
  8, 7,  6, 8, 7,  4, 8, 7,  4, 8, 7,  2, 8, 7,  4, 8, 7,  2, 8, 7,  2, 8, 7,  0,
 14,15, 14,13,14, 12,12,13, 12,12,13, 10,12,15, 12,11,12, 10,11,12, 10,11,12,  8,
 12,15, 12,11,14, 10,10,11, 10,10,11,  8,10,11, 10,10,11,  8,10,11,  8,10,11,  6,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,10,  8, 9,10,  8, 9,10,  6,
 10,15, 10, 9,10,  8, 9,10,  8, 9,10,  6, 9,10,  8, 9,10,  6, 9,10,  6, 9,10,  4,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8, 9,  8, 8, 9,  6, 8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4,
 10,15, 10, 9,14,  8, 8, 9,  8, 8, 9,  6, 8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4,
  8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4, 8, 9,  6, 8, 9,  4, 8, 9,  4, 8, 9,  2,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7, 6,  6, 7, 6,  6, 7, 6,  4,
  8,15,  8, 7, 6,  6, 7, 6,  6, 7, 6,  4, 7, 6,  6, 7, 6,  4, 7, 6,  4, 7, 6,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7, 6,  6, 7, 6,  6, 7, 6,  4,
  8,15,  8, 7, 6,  6, 7, 6,  6, 7, 6,  4, 7, 6,  6, 7, 6,  4, 7, 6,  4, 7, 6,  2,
  8,15,  8, 7, 6,  6, 7, 6,  6, 7, 6,  4, 7, 6,  6, 7, 6,  4, 7, 6,  4, 7, 6,  2,
  7, 6,  6, 7, 6,  4, 7, 6,  4, 7, 6,  2, 7, 6,  4, 7, 6,  2, 7, 6,  2, 7, 6,  0,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7, 6,  6, 7, 6,  6, 7, 6,  4,
  8,15,  8, 7, 6,  6, 7, 6,  6, 7, 6,  4, 7, 6,  6, 7, 6,  4, 7, 6,  4, 7, 6,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7, 6,  6, 7, 6,  6, 7, 6,  4,
  8,15,  8, 7, 6,  6, 7, 6,  6, 7, 6,  4, 7, 6,  6, 7, 6,  4, 7, 6,  4, 7, 6,  2,
  8,15,  8, 7, 6,  6, 7, 6,  6, 7, 6,  4, 7, 6,  6, 7, 6,  4, 7, 6,  4, 7, 6,  2,
  7, 6,  6, 7, 6,  4, 7, 6,  4, 7, 6,  2, 7, 6,  4, 7, 6,  2, 7, 6,  2, 7, 6,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7, 6,  6, 7, 6,  6, 7, 6,  4,
  8,15,  8, 7, 6,  6, 7, 6,  6, 7, 6,  4, 7, 6,  6, 7, 6,  4, 7, 6,  4, 7, 6,  2,
  8,15,  8, 7, 6,  6, 7, 6,  6, 7, 6,  4, 7, 6,  6, 7, 6,  4, 7, 6,  4, 7, 6,  2,
  7, 6,  6, 7, 6,  4, 7, 6,  4, 7, 6,  2, 7, 6,  4, 7, 6,  2, 7, 6,  2, 7, 6,  0,
  8,15,  8, 7, 6,  6, 7, 6,  6, 7, 6,  4, 7, 6,  6, 7, 6,  4, 7, 6,  4, 7, 6,  2,
  7, 6,  6, 7, 6,  4, 7, 6,  4, 7, 6,  2, 7, 6,  4, 7, 6,  2, 7, 6,  2, 7, 6,  0,
  7, 6,  6, 7, 6,  4, 7, 6,  4, 7, 6,  2, 7, 6,  4, 7, 6,  2, 7, 6,  2, 7, 6,  0,
  7, 6,  4, 7, 6,  2, 7, 6,  2, 7, 6,  0, 7, 6,  2, 7, 6,  0, 7, 6,  0, 7, 6, -2,
 14,15, 14,13,14, 12,12,13, 12,12,13, 10,12,15, 12,11,12, 10,11,12, 10,11,12,  8,
 12,15, 12,11,14, 10,10,11, 10,10,11,  8,10,11, 10,10,11,  8,10,11,  8,10,11,  6,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,10,  8, 9,10,  8, 9,10,  6,
 10,15, 10, 9,10,  8, 9,10,  8, 9,10,  6, 9,10,  8, 9,10,  6, 9,10,  6, 9,10,  4,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8, 9,  8, 8, 9,  6, 8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4,
 10,15, 10, 9,14,  8, 8, 9,  8, 8, 9,  6, 8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4,
  8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4, 8, 9,  6, 8, 9,  4, 8, 9,  4, 8, 9,  2,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4,
  8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4, 7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4,
  8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4, 7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2,
  8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4, 7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2,
  7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2, 7, 8,  4, 7, 8,  2, 7, 8,  2, 7, 8,  0,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 5,  6, 6, 5,  4, 6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2,
  8,15,  8, 7,14,  6, 6, 5,  6, 6, 5,  4, 6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2,
  6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2, 6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 5,  6, 6, 5,  4, 6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2,
  8,15,  8, 7,14,  6, 6, 5,  6, 6, 5,  4, 6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2,
  6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2, 6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0,
  8,15,  8, 7,14,  6, 6, 5,  6, 6, 5,  4, 6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2,
  6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2, 6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0,
  6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2, 6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0,
  6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0, 6, 5,  2, 6, 5,  0, 6, 5,  0, 6, 5, -2,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 5,  6, 6, 5,  4, 6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2,
  8,15,  8, 7,14,  6, 6, 5,  6, 6, 5,  4, 6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2,
  6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2, 6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 5,  6, 6, 5,  4, 6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2,
  8,15,  8, 7,14,  6, 6, 5,  6, 6, 5,  4, 6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2,
  6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2, 6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0,
  8,15,  8, 7,14,  6, 6, 5,  6, 6, 5,  4, 6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2,
  6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2, 6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0,
  6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2, 6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0,
  6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0, 6, 5,  2, 6, 5,  0, 6, 5,  0, 6, 5, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 5,  6, 6, 5,  4, 6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2,
  8,15,  8, 7,14,  6, 6, 5,  6, 6, 5,  4, 6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2,
  6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2, 6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0,
  8,15,  8, 7,14,  6, 6, 5,  6, 6, 5,  4, 6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2,
  6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2, 6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0,
  6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2, 6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0,
  6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0, 6, 5,  2, 6, 5,  0, 6, 5,  0, 6, 5, -2,
  8,15,  8, 7,14,  6, 6, 5,  6, 6, 5,  4, 6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2,
  6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2, 6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0,
  6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2, 6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0,
  6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0, 6, 5,  2, 6, 5,  0, 6, 5,  0, 6, 5, -2,
  6, 5,  6, 6, 5,  4, 6, 5,  4, 6, 5,  2, 6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0,
  6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0, 6, 5,  2, 6, 5,  0, 6, 5,  0, 6, 5, -2,
  6, 5,  4, 6, 5,  2, 6, 5,  2, 6, 5,  0, 6, 5,  2, 6, 5,  0, 6, 5,  0, 6, 5, -2,
  6, 5,  2, 6, 5,  0, 6, 5,  0, 6, 5, -2, 6, 5,  0, 6, 5, -2, 6, 5, -2, 6, 5, -4,
 14,15, 14,13,14, 12,12,13, 12,12,13, 10,12,15, 12,11,12, 10,11,12, 10,11,12,  8,
 12,15, 12,11,14, 10,10,11, 10,10,11,  8,10,11, 10,10,11,  8,10,11,  8,10,11,  6,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,10,  8, 9,10,  8, 9,10,  6,
 10,15, 10, 9,10,  8, 9,10,  8, 9,10,  6, 9,10,  8, 9,10,  6, 9,10,  6, 9,10,  4,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8, 9,  8, 8, 9,  6, 8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4,
 10,15, 10, 9,14,  8, 8, 9,  8, 8, 9,  6, 8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4,
  8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4, 8, 9,  6, 8, 9,  4, 8, 9,  4, 8, 9,  2,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4,
  8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4, 7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4,
  8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4, 7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2,
  8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4, 7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2,
  7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2, 7, 8,  4, 7, 8,  2, 7, 8,  2, 7, 8,  0,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
  6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0, 6, 7,  2, 6, 7,  0, 6, 7,  0, 6, 7, -2,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
  5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2, 5, 4,  0, 5, 4, -2, 5, 4, -2, 5, 4, -4,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
  5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2, 5, 4,  0, 5, 4, -2, 5, 4, -2, 5, 4, -4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
  5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2, 5, 4,  0, 5, 4, -2, 5, 4, -2, 5, 4, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
  5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2, 5, 4,  0, 5, 4, -2, 5, 4, -2, 5, 4, -4,
  6,15,  6, 5, 4,  4, 5, 4,  4, 5, 4,  2, 5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
  5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2, 5, 4,  0, 5, 4, -2, 5, 4, -2, 5, 4, -4,
  5, 4,  4, 5, 4,  2, 5, 4,  2, 5, 4,  0, 5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2,
  5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2, 5, 4,  0, 5, 4, -2, 5, 4, -2, 5, 4, -4,
  5, 4,  2, 5, 4,  0, 5, 4,  0, 5, 4, -2, 5, 4,  0, 5, 4, -2, 5, 4, -2, 5, 4, -4,
  5, 4,  0, 5, 4, -2, 5, 4, -2, 5, 4, -4, 5, 4, -2, 5, 4, -4, 5, 4, -4, 5, 4, -6,
 14,15, 14,13,14, 12,12,13, 12,12,13, 10,12,15, 12,11,12, 10,11,12, 10,11,12,  8,
 12,15, 12,11,14, 10,10,11, 10,10,11,  8,10,11, 10,10,11,  8,10,11,  8,10,11,  6,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,10,  8, 9,10,  8, 9,10,  6,
 10,15, 10, 9,10,  8, 9,10,  8, 9,10,  6, 9,10,  8, 9,10,  6, 9,10,  6, 9,10,  4,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8, 9,  8, 8, 9,  6, 8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4,
 10,15, 10, 9,14,  8, 8, 9,  8, 8, 9,  6, 8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4,
  8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4, 8, 9,  6, 8, 9,  4, 8, 9,  4, 8, 9,  2,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4,
  8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4, 7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4,
  8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4, 7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2,
  8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4, 7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2,
  7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2, 7, 8,  4, 7, 8,  2, 7, 8,  2, 7, 8,  0,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
  6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0, 6, 7,  2, 6, 7,  0, 6, 7,  0, 6, 7, -2,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
  5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2, 5, 6,  0, 5, 6, -2, 5, 6, -2, 5, 6, -4,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0, 5, 8,  2, 5, 8,  0, 5, 8,  0, 5, 8, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4, 4, 3, -2, 4, 3, -4, 4, 3, -4, 4, 3, -6,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0, 5, 8,  2, 5, 8,  0, 5, 8,  0, 5, 8, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4, 4, 3, -2, 4, 3, -4, 4, 3, -4, 4, 3, -6,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4, 4, 3, -2, 4, 3, -4, 4, 3, -4, 4, 3, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4, 4, 3, -2, 4, 3, -4, 4, 3, -4, 4, 3, -6,
  6,15,  6, 5,14,  4, 4, 3,  4, 4, 3,  2, 4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4, 4, 3, -2, 4, 3, -4, 4, 3, -4, 4, 3, -6,
  4, 3,  4, 4, 3,  2, 4, 3,  2, 4, 3,  0, 4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4, 4, 3, -2, 4, 3, -4, 4, 3, -4, 4, 3, -6,
  4, 3,  2, 4, 3,  0, 4, 3,  0, 4, 3, -2, 4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4,
  4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4, 4, 3, -2, 4, 3, -4, 4, 3, -4, 4, 3, -6,
  4, 3,  0, 4, 3, -2, 4, 3, -2, 4, 3, -4, 4, 3, -2, 4, 3, -4, 4, 3, -4, 4, 3, -6,
  4, 3, -2, 4, 3, -4, 4, 3, -4, 4, 3, -6, 4, 3, -4, 4, 3, -6, 4, 3, -6, 4, 3, -8,
 14,15, 14,13,14, 12,12,13, 12,12,13, 10,12,15, 12,11,12, 10,11,12, 10,11,12,  8,
 12,15, 12,11,14, 10,10,11, 10,10,11,  8,10,11, 10,10,11,  8,10,11,  8,10,11,  6,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,10,  8, 9,10,  8, 9,10,  6,
 10,15, 10, 9,10,  8, 9,10,  8, 9,10,  6, 9,10,  8, 9,10,  6, 9,10,  6, 9,10,  4,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8, 9,  8, 8, 9,  6, 8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4,
 10,15, 10, 9,14,  8, 8, 9,  8, 8, 9,  6, 8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4,
  8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4, 8, 9,  6, 8, 9,  4, 8, 9,  4, 8, 9,  2,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4,
  8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4, 7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4,
  8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4, 7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2,
  8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4, 7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2,
  7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2, 7, 8,  4, 7, 8,  2, 7, 8,  2, 7, 8,  0,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
  6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0, 6, 7,  2, 6, 7,  0, 6, 7,  0, 6, 7, -2,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
  5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2, 5, 6,  0, 5, 6, -2, 5, 6, -2, 5, 6, -4,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0, 5, 8,  2, 5, 8,  0, 5, 8,  0, 5, 8, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2, 4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2, 4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2, 4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2, 4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2, 4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4,
  4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2, 4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4,
  4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4, 4, 5, -2, 4, 5, -4, 4, 5, -4, 4, 5, -6,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0, 5, 8,  2, 5, 8,  0, 5, 8,  0, 5, 8, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2, 4, 7,  0, 4, 7, -2, 4, 7, -2, 4, 7, -4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6, 3, 2, -4, 3, 2, -6, 3, 2, -6, 3, 2, -8,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0, 5, 8,  2, 5, 8,  0, 5, 8,  0, 5, 8, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2, 4, 7,  0, 4, 7, -2, 4, 7, -2, 4, 7, -4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6, 3, 2, -4, 3, 2, -6, 3, 2, -6, 3, 2, -8,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6, 3, 2, -4, 3, 2, -6, 3, 2, -6, 3, 2, -8,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6, 3, 2, -4, 3, 2, -6, 3, 2, -6, 3, 2, -8,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6, 3, 2, -4, 3, 2, -6, 3, 2, -6, 3, 2, -8,
  4,15,  4, 3, 2,  2, 3, 2,  2, 3, 2,  0, 3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6, 3, 2, -4, 3, 2, -6, 3, 2, -6, 3, 2, -8,
  3, 2,  2, 3, 2,  0, 3, 2,  0, 3, 2, -2, 3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6, 3, 2, -4, 3, 2, -6, 3, 2, -6, 3, 2, -8,
  3, 2,  0, 3, 2, -2, 3, 2, -2, 3, 2, -4, 3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6,
  3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6, 3, 2, -4, 3, 2, -6, 3, 2, -6, 3, 2, -8,
  3, 2, -2, 3, 2, -4, 3, 2, -4, 3, 2, -6, 3, 2, -4, 3, 2, -6, 3, 2, -6, 3, 2, -8,
  3, 2, -4, 3, 2, -6, 3, 2, -6, 3, 2, -8, 3, 2, -6, 3, 2, -8, 3, 2, -8, 3, 2,-10,
 14,15, 14,13,14, 12,12,13, 12,12,13, 10,12,15, 12,11,12, 10,11,12, 10,11,12,  8,
 12,15, 12,11,14, 10,10,11, 10,10,11,  8,10,11, 10,10,11,  8,10,11,  8,10,11,  6,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,10,  8, 9,10,  8, 9,10,  6,
 10,15, 10, 9,10,  8, 9,10,  8, 9,10,  6, 9,10,  8, 9,10,  6, 9,10,  6, 9,10,  4,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8, 9,  8, 8, 9,  6, 8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4,
 10,15, 10, 9,14,  8, 8, 9,  8, 8, 9,  6, 8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4,
  8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4, 8, 9,  6, 8, 9,  4, 8, 9,  4, 8, 9,  2,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4,
  8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4, 7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4,
  8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4, 7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2,
  8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4, 7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2,
  7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2, 7, 8,  4, 7, 8,  2, 7, 8,  2, 7, 8,  0,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
  6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0, 6, 7,  2, 6, 7,  0, 6, 7,  0, 6, 7, -2,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
  5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2, 5, 6,  0, 5, 6, -2, 5, 6, -2, 5, 6, -4,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0, 5, 8,  2, 5, 8,  0, 5, 8,  0, 5, 8, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2, 4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2, 4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2, 4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2, 4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2, 4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4,
  4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2, 4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4,
  4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4, 4, 5, -2, 4, 5, -4, 4, 5, -4, 4, 5, -6,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0, 5, 8,  2, 5, 8,  0, 5, 8,  0, 5, 8, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2, 4, 7,  0, 4, 7, -2, 4, 7, -2, 4, 7, -4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4, 3, 4, -2, 3, 4, -4, 3, 4, -4, 3, 4, -6,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4, 3, 4, -2, 3, 4, -4, 3, 4, -4, 3, 4, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4, 3, 4, -2, 3, 4, -4, 3, 4, -4, 3, 4, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4, 3, 4, -2, 3, 4, -4, 3, 4, -4, 3, 4, -6,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4, 3, 4, -2, 3, 4, -4, 3, 4, -4, 3, 4, -6,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4, 3, 4, -2, 3, 4, -4, 3, 4, -4, 3, 4, -6,
  3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4, 3, 4, -2, 3, 4, -4, 3, 4, -4, 3, 4, -6,
  3, 4, -2, 3, 4, -4, 3, 4, -4, 3, 4, -6, 3, 4, -4, 3, 4, -6, 3, 4, -6, 3, 4, -8,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0, 5, 8,  2, 5, 8,  0, 5, 8,  0, 5, 8, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2, 4, 7,  0, 4, 7, -2, 4, 7, -2, 4, 7, -4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4, 3, 6, -2, 3, 6, -4, 3, 6, -4, 3, 6, -6,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2, 3, 8,  0, 3, 8, -2, 3, 8, -2, 3, 8, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2, 3, 8,  0, 3, 8, -2, 3, 8, -2, 3, 8, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8, 2, 1, -6, 2, 1, -8, 2, 1, -8, 2, 1,-10,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0, 5, 8,  2, 5, 8,  0, 5, 8,  0, 5, 8, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2, 4, 7,  0, 4, 7, -2, 4, 7, -2, 4, 7, -4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4, 3, 6, -2, 3, 6, -4, 3, 6, -4, 3, 6, -6,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2, 3, 8,  0, 3, 8, -2, 3, 8, -2, 3, 8, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2, 3, 8,  0, 3, 8, -2, 3, 8, -2, 3, 8, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8, 2, 1, -6, 2, 1, -8, 2, 1, -8, 2, 1,-10,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2, 3, 8,  0, 3, 8, -2, 3, 8, -2, 3, 8, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8, 2, 1, -6, 2, 1, -8, 2, 1, -8, 2, 1,-10,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8, 2, 1, -6, 2, 1, -8, 2, 1, -8, 2, 1,-10,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8, 2, 1, -6, 2, 1, -8, 2, 1, -8, 2, 1,-10,
  4,15,  4, 3,14,  2, 2, 1,  2, 2, 1,  0, 2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8, 2, 1, -6, 2, 1, -8, 2, 1, -8, 2, 1,-10,
  2, 1,  2, 2, 1,  0, 2, 1,  0, 2, 1, -2, 2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8, 2, 1, -6, 2, 1, -8, 2, 1, -8, 2, 1,-10,
  2, 1,  0, 2, 1, -2, 2, 1, -2, 2, 1, -4, 2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8, 2, 1, -6, 2, 1, -8, 2, 1, -8, 2, 1,-10,
  2, 1, -2, 2, 1, -4, 2, 1, -4, 2, 1, -6, 2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8,
  2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8, 2, 1, -6, 2, 1, -8, 2, 1, -8, 2, 1,-10,
  2, 1, -4, 2, 1, -6, 2, 1, -6, 2, 1, -8, 2, 1, -6, 2, 1, -8, 2, 1, -8, 2, 1,-10,
  2, 1, -6, 2, 1, -8, 2, 1, -8, 2, 1,-10, 2, 1, -8, 2, 1,-10, 2, 1,-10, 2, 1,-12,
 14,15, 14,13,14, 12,12,13, 12,12,13, 10,12,15, 12,11,12, 10,11,12, 10,11,12,  8,
 12,15, 12,11,14, 10,10,11, 10,10,11,  8,10,11, 10,10,11,  8,10,11,  8,10,11,  6,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,10,  8, 9,10,  8, 9,10,  6,
 10,15, 10, 9,10,  8, 9,10,  8, 9,10,  6, 9,10,  8, 9,10,  6, 9,10,  6, 9,10,  4,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8, 9,  8, 8, 9,  6, 8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4,
 10,15, 10, 9,14,  8, 8, 9,  8, 8, 9,  6, 8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4,
  8, 9,  8, 8, 9,  6, 8, 9,  6, 8, 9,  4, 8, 9,  6, 8, 9,  4, 8, 9,  4, 8, 9,  2,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4,
  8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4, 7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4,
  8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4, 7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2,
  8,15,  8, 7, 8,  6, 7, 8,  6, 7, 8,  4, 7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2,
  7, 8,  6, 7, 8,  4, 7, 8,  4, 7, 8,  2, 7, 8,  4, 7, 8,  2, 7, 8,  2, 7, 8,  0,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
  8,15,  8, 7,14,  6, 6, 7,  6, 6, 7,  4, 6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
  6, 7,  6, 6, 7,  4, 6, 7,  4, 6, 7,  2, 6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0,
  6, 7,  4, 6, 7,  2, 6, 7,  2, 6, 7,  0, 6, 7,  2, 6, 7,  0, 6, 7,  0, 6, 7, -2,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
  6,15,  6, 5, 6,  4, 5, 6,  4, 5, 6,  2, 5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
  5, 6,  4, 5, 6,  2, 5, 6,  2, 5, 6,  0, 5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2,
  5, 6,  2, 5, 6,  0, 5, 6,  0, 5, 6, -2, 5, 6,  0, 5, 6, -2, 5, 6, -2, 5, 6, -4,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0, 5, 8,  2, 5, 8,  0, 5, 8,  0, 5, 8, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2, 4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2, 4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2, 4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4,
  6,15,  6, 5,14,  4, 4, 5,  4, 4, 5,  2, 4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2, 4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4,
  4, 5,  4, 4, 5,  2, 4, 5,  2, 4, 5,  0, 4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2,
  4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2, 4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4,
  4, 5,  2, 4, 5,  0, 4, 5,  0, 4, 5, -2, 4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4,
  4, 5,  0, 4, 5, -2, 4, 5, -2, 4, 5, -4, 4, 5, -2, 4, 5, -4, 4, 5, -4, 4, 5, -6,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0, 5, 8,  2, 5, 8,  0, 5, 8,  0, 5, 8, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2, 4, 7,  0, 4, 7, -2, 4, 7, -2, 4, 7, -4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4, 3, 4, -2, 3, 4, -4, 3, 4, -4, 3, 4, -6,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4, 3, 4, -2, 3, 4, -4, 3, 4, -4, 3, 4, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4, 3, 4, -2, 3, 4, -4, 3, 4, -4, 3, 4, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4, 3, 4, -2, 3, 4, -4, 3, 4, -4, 3, 4, -6,
  4,15,  4, 3, 4,  2, 3, 4,  2, 3, 4,  0, 3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4, 3, 4, -2, 3, 4, -4, 3, 4, -4, 3, 4, -6,
  3, 4,  2, 3, 4,  0, 3, 4,  0, 3, 4, -2, 3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4,
  3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4, 3, 4, -2, 3, 4, -4, 3, 4, -4, 3, 4, -6,
  3, 4,  0, 3, 4, -2, 3, 4, -2, 3, 4, -4, 3, 4, -2, 3, 4, -4, 3, 4, -4, 3, 4, -6,
  3, 4, -2, 3, 4, -4, 3, 4, -4, 3, 4, -6, 3, 4, -4, 3, 4, -6, 3, 4, -6, 3, 4, -8,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0, 5, 8,  2, 5, 8,  0, 5, 8,  0, 5, 8, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2, 4, 7,  0, 4, 7, -2, 4, 7, -2, 4, 7, -4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4, 3, 6, -2, 3, 6, -4, 3, 6, -4, 3, 6, -6,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2, 3, 8,  0, 3, 8, -2, 3, 8, -2, 3, 8, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6, 2, 3, -4, 2, 3, -6, 2, 3, -6, 2, 3, -8,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2, 3, 8,  0, 3, 8, -2, 3, 8, -2, 3, 8, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6, 2, 3, -4, 2, 3, -6, 2, 3, -6, 2, 3, -8,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6, 2, 3, -4, 2, 3, -6, 2, 3, -6, 2, 3, -8,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6, 2, 3, -4, 2, 3, -6, 2, 3, -6, 2, 3, -8,
  4,15,  4, 3,14,  2, 2, 3,  2, 2, 3,  0, 2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6, 2, 3, -4, 2, 3, -6, 2, 3, -6, 2, 3, -8,
  2, 3,  2, 2, 3,  0, 2, 3,  0, 2, 3, -2, 2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6, 2, 3, -4, 2, 3, -6, 2, 3, -6, 2, 3, -8,
  2, 3,  0, 2, 3, -2, 2, 3, -2, 2, 3, -4, 2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6,
  2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6, 2, 3, -4, 2, 3, -6, 2, 3, -6, 2, 3, -8,
  2, 3, -2, 2, 3, -4, 2, 3, -4, 2, 3, -6, 2, 3, -4, 2, 3, -6, 2, 3, -6, 2, 3, -8,
  2, 3, -4, 2, 3, -6, 2, 3, -6, 2, 3, -8, 2, 3, -6, 2, 3, -8, 2, 3, -8, 2, 3,-10,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0, 5, 8,  2, 5, 8,  0, 5, 8,  0, 5, 8, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2, 4, 7,  0, 4, 7, -2, 4, 7, -2, 4, 7, -4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4, 3, 6, -2, 3, 6, -4, 3, 6, -4, 3, 6, -6,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2, 3, 8,  0, 3, 8, -2, 3, 8, -2, 3, 8, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4, 2, 5, -2, 2, 5, -4, 2, 5, -4, 2, 5, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4, 2, 5, -2, 2, 5, -4, 2, 5, -4, 2, 5, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4, 2, 5, -2, 2, 5, -4, 2, 5, -4, 2, 5, -6,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4, 2, 5, -2, 2, 5, -4, 2, 5, -4, 2, 5, -6,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4, 2, 5, -2, 2, 5, -4, 2, 5, -4, 2, 5, -6,
  2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4, 2, 5, -2, 2, 5, -4, 2, 5, -4, 2, 5, -6,
  2, 5, -2, 2, 5, -4, 2, 5, -4, 2, 5, -6, 2, 5, -4, 2, 5, -6, 2, 5, -6, 2, 5, -8,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2, 3, 8,  0, 3, 8, -2, 3, 8, -2, 3, 8, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4, 2, 7, -2, 2, 7, -4, 2, 7, -4, 2, 7, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2, 2, 9,  0, 2, 9, -2, 2, 9, -2, 2, 9, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2, 2, 9,  0, 2, 9, -2, 2, 9, -2, 2, 9, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2, 3, 8,  0, 3, 8, -2, 3, 8, -2, 3, 8, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4, 2, 7, -2, 2, 7, -4, 2, 7, -4, 2, 7, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2, 2, 9,  0, 2, 9, -2, 2, 9, -2, 2, 9, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2, 2, 9,  0, 2, 9, -2, 2, 9, -2, 2, 9, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2, 2, 9,  0, 2, 9, -2, 2, 9, -2, 2, 9, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10, 1, 0, -8, 1, 0,-10, 1, 0,-10, 1, 0,-12,
 12,15, 12,11,14, 10,10,13, 10,10,13,  8,10,15, 10, 9,12,  8, 9,12,  8, 9,12,  6,
 10,15, 10, 9,14,  8, 8,11,  8, 8,11,  6, 8,11,  8, 8,11,  6, 8,11,  6, 8,11,  4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4,
  8,15,  8, 7,10,  6, 7,10,  6, 7,10,  4, 7,10,  6, 7,10,  4, 7,10,  4, 7,10,  2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  8,15,  8, 7,14,  6, 6, 9,  6, 6, 9,  4, 6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2,
  6, 9,  6, 6, 9,  4, 6, 9,  4, 6, 9,  2, 6, 9,  4, 6, 9,  2, 6, 9,  2, 6, 9,  0,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  6,15,  6, 5, 8,  4, 5, 8,  4, 5, 8,  2, 5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0,
  5, 8,  4, 5, 8,  2, 5, 8,  2, 5, 8,  0, 5, 8,  2, 5, 8,  0, 5, 8,  0, 5, 8, -2,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  6,15,  6, 5,14,  4, 4, 7,  4, 4, 7,  2, 4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  4, 7,  4, 4, 7,  2, 4, 7,  2, 4, 7,  0, 4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2,
  4, 7,  2, 4, 7,  0, 4, 7,  0, 4, 7, -2, 4, 7,  0, 4, 7, -2, 4, 7, -2, 4, 7, -4,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  4,15,  4, 3, 6,  2, 3, 6,  2, 3, 6,  0, 3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  3, 6,  2, 3, 6,  0, 3, 6,  0, 3, 6, -2, 3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4,
  3, 6,  0, 3, 6, -2, 3, 6, -2, 3, 6, -4, 3, 6, -2, 3, 6, -4, 3, 6, -4, 3, 6, -6,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2, 3, 8,  0, 3, 8, -2, 3, 8, -2, 3, 8, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4, 2, 5, -2, 2, 5, -4, 2, 5, -4, 2, 5, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4, 2, 5, -2, 2, 5, -4, 2, 5, -4, 2, 5, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4, 2, 5, -2, 2, 5, -4, 2, 5, -4, 2, 5, -6,
  4,15,  4, 3,14,  2, 2, 5,  2, 2, 5,  0, 2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4, 2, 5, -2, 2, 5, -4, 2, 5, -4, 2, 5, -6,
  2, 5,  2, 2, 5,  0, 2, 5,  0, 2, 5, -2, 2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4,
  2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4, 2, 5, -2, 2, 5, -4, 2, 5, -4, 2, 5, -6,
  2, 5,  0, 2, 5, -2, 2, 5, -2, 2, 5, -4, 2, 5, -2, 2, 5, -4, 2, 5, -4, 2, 5, -6,
  2, 5, -2, 2, 5, -4, 2, 5, -4, 2, 5, -6, 2, 5, -4, 2, 5, -6, 2, 5, -6, 2, 5, -8,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2, 3, 8,  0, 3, 8, -2, 3, 8, -2, 3, 8, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4, 2, 7, -2, 2, 7, -4, 2, 7, -4, 2, 7, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2, 2, 9,  0, 2, 9, -2, 2, 9, -2, 2, 9, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2, 2, 9,  0, 2, 9, -2, 2, 9, -2, 2, 9, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2, 3, 8,  0, 3, 8, -2, 3, 8, -2, 3, 8, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4, 2, 7, -2, 2, 7, -4, 2, 7, -4, 2, 7, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2, 2, 9,  0, 2, 9, -2, 2, 9, -2, 2, 9, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2, 2, 9,  0, 2, 9, -2, 2, 9, -2, 2, 9, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2, 2, 9,  0, 2, 9, -2, 2, 9, -2, 2, 9, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10, 1, 0, -8, 1, 0,-10, 1, 0,-10, 1, 0,-12,
 10,15, 10, 9,14,  8, 8,13,  8, 8,13,  6, 8,15,  8, 7,12,  6, 7,12,  6, 7,12,  4,
  8,15,  8, 7,14,  6, 6,11,  6, 6,11,  4, 6,11,  6, 6,11,  4, 6,11,  4, 6,11,  2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2,
  6,15,  6, 5,10,  4, 5,10,  4, 5,10,  2, 5,10,  4, 5,10,  2, 5,10,  2, 5,10,  0,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  6,15,  6, 5,14,  4, 4, 9,  4, 4, 9,  2, 4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0,
  4, 9,  4, 4, 9,  2, 4, 9,  2, 4, 9,  0, 4, 9,  2, 4, 9,  0, 4, 9,  0, 4, 9, -2,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  4,15,  4, 3, 8,  2, 3, 8,  2, 3, 8,  0, 3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2,
  3, 8,  2, 3, 8,  0, 3, 8,  0, 3, 8, -2, 3, 8,  0, 3, 8, -2, 3, 8, -2, 3, 8, -4,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  4,15,  4, 3,14,  2, 2, 7,  2, 2, 7,  0, 2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  2, 7,  2, 2, 7,  0, 2, 7,  0, 2, 7, -2, 2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4,
  2, 7,  0, 2, 7, -2, 2, 7, -2, 2, 7, -4, 2, 7, -2, 2, 7, -4, 2, 7, -4, 2, 7, -6,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2, 2, 9,  0, 2, 9, -2, 2, 9, -2, 2, 9, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2, 2, 9,  0, 2, 9, -2, 2, 9, -2, 2, 9, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2, 2, 9,  0, 2, 9, -2, 2, 9, -2, 2, 9, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10, 1, 0, -8, 1, 0,-10, 1, 0,-10, 1, 0,-12,
  8,15,  8, 7,14,  6, 6,13,  6, 6,13,  4, 6,15,  6, 5,12,  4, 5,12,  4, 5,12,  2,
  6,15,  6, 5,14,  4, 4,11,  4, 4,11,  2, 4,11,  4, 4,11,  2, 4,11,  2, 4,11,  0,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0,
  4,15,  4, 3,10,  2, 3,10,  2, 3,10,  0, 3,10,  2, 3,10,  0, 3,10,  0, 3,10, -2,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  4,15,  4, 3,14,  2, 2, 9,  2, 2, 9,  0, 2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2,
  2, 9,  2, 2, 9,  0, 2, 9,  0, 2, 9, -2, 2, 9,  0, 2, 9, -2, 2, 9, -2, 2, 9, -4,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6, 1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  1, 0, -4, 1, 0, -6, 1, 0, -6, 1, 0, -8, 1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10,
  1, 0, -6, 1, 0, -8, 1, 0, -8, 1, 0,-10, 1, 0, -8, 1, 0,-10, 1, 0,-10, 1, 0,-12,
  6,15,  6, 5,14,  4, 4,13,  4, 4,13,  2, 4,15,  4, 3,12,  2, 3,12,  2, 3,12,  0,
  4,15,  4, 3,14,  2, 2,11,  2, 2,11,  0, 2,11,  2, 2,11,  0, 2,11,  0, 2,11, -2,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  4,15,  4, 3,14,  2, 2,13,  2, 2,13,  0, 2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  2,15,  2, 1, 0,  0, 1, 0,  0, 1, 0, -2, 1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0,  0, 1, 0, -2, 1, 0, -2, 1, 0, -4, 1, 0, -2, 1, 0, -4, 1, 0, -4, 1, 0, -6,
  1, 0, -2, 1, 0, -4, 