/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.gatk.engine.GenomeAnalysisEngine;
import org.broadinstitute.gatk.engine.datasources.reads.SAMReaderID;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.sam.NWaySAMFileWriter;

public class BySampleSAMFileWriter
extends NWaySAMFileWriter {
    private final Map<String, SAMReaderID> sampleToWriterMap;

    public BySampleSAMFileWriter(GenomeAnalysisEngine toolkit, String ext, SAMFileHeader.SortOrder order, boolean presorted, boolean indexOnTheFly, boolean generateMD5, SAMProgramRecord pRecord, boolean keep_records) {
        super(toolkit, ext, order, presorted, indexOnTheFly, generateMD5, pRecord, keep_records);
        this.sampleToWriterMap = new HashMap<String, SAMReaderID>(toolkit.getSAMFileHeader().getReadGroups().size() * 2);
        for (SAMReaderID readerID : toolkit.getReadsDataSource().getReaderIDs()) {
            for (SAMReadGroupRecord rg : toolkit.getReadsDataSource().getHeader(readerID).getReadGroups()) {
                String sample = rg.getSample();
                if (this.sampleToWriterMap.containsKey(sample) && this.sampleToWriterMap.get(sample) != readerID) {
                    throw new ReviewedGATKException("The same sample appears in multiple files, this input cannot be multiplexed using the BySampleSAMFileWriter, try NWaySAMFileWriter instead.");
                }
                this.sampleToWriterMap.put(sample, readerID);
            }
        }
    }

    @Override
    public void addAlignment(SAMRecord samRecord) {
        super.addAlignment(samRecord, this.sampleToWriterMap.get(samRecord.getReadGroup().getSample()));
    }
}

