/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter;

import java.util.Locale;
import java.util.Map;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.formatter.CodeFormatterParser;
import org.eclipse.jdt.internal.formatter.CodeFormatterVisitor;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.text.edits.TextEdit;

public class DefaultCodeFormatter
extends CodeFormatter {
    public static final boolean DEBUG = false;
    private CodeFormatterVisitor newCodeFormatter;
    private Map options;
    private DefaultCodeFormatterOptions preferences;

    private static ASTNode[] parseClassBodyDeclarations(char[] source, Map settings) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        CompilerOptions compilerOptions = new CompilerOptions(settings);
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory(Locale.getDefault()));
        CodeFormatterParser parser = new CodeFormatterParser(problemReporter, false);
        CompilationUnit sourceUnit = new CompilationUnit(source, "", compilerOptions.defaultEncoding);
        return parser.parseClassBodyDeclarations(source, new CompilationUnitDeclaration(problemReporter, new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit), source.length));
    }

    private static CompilationUnitDeclaration parseCompilationUnit(char[] source, Map settings) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        CompilerOptions compilerOptions = new CompilerOptions(settings);
        CodeFormatterParser parser = new CodeFormatterParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory(Locale.getDefault())), false);
        CompilationUnit sourceUnit = new CompilationUnit(source, "", compilerOptions.defaultEncoding);
        CompilationUnitDeclaration compilationUnitDeclaration = parser.dietParse(sourceUnit, new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit));
        if (compilationUnitDeclaration.ignoreMethodBodies) {
            compilationUnitDeclaration.ignoreFurtherInvestigation = true;
            return compilationUnitDeclaration;
        }
        parser.scanner.setSource(source);
        TypeDeclaration[] types = compilationUnitDeclaration.types;
        if (types != null) {
            int i = types.length;
            while (--i >= 0) {
                types[i].parseMethod(parser, compilationUnitDeclaration);
            }
        }
        return compilationUnitDeclaration;
    }

    private static Expression parseExpression(char[] source, Map settings) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        CompilerOptions compilerOptions = new CompilerOptions(settings);
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory(Locale.getDefault()));
        CodeFormatterParser parser = new CodeFormatterParser(problemReporter, false);
        CompilationUnit sourceUnit = new CompilationUnit(source, "", compilerOptions.defaultEncoding);
        return parser.parseExpression(source, new CompilationUnitDeclaration(problemReporter, new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit), source.length));
    }

    private static ConstructorDeclaration parseStatements(char[] source, Map settings) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        CompilerOptions compilerOptions = new CompilerOptions(settings);
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory(Locale.getDefault()));
        CodeFormatterParser parser = new CodeFormatterParser(problemReporter, false);
        CompilationUnit sourceUnit = new CompilationUnit(source, "", compilerOptions.defaultEncoding);
        CompilationResult compilationResult = new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit);
        CompilationUnitDeclaration compilationUnitDeclaration = new CompilationUnitDeclaration(problemReporter, compilationResult, source.length);
        ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(compilationResult);
        constructorDeclaration.sourceEnd = -1;
        constructorDeclaration.declarationSourceEnd = source.length - 1;
        constructorDeclaration.bodyStart = 0;
        constructorDeclaration.bodyEnd = source.length - 1;
        parser.scanner.setSource(source);
        parser.parse(constructorDeclaration, compilationUnitDeclaration);
        return constructorDeclaration;
    }

    public DefaultCodeFormatter() {
        this(new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getDefaultSettings()), null);
    }

    public DefaultCodeFormatter(DefaultCodeFormatterOptions preferences) {
        this(preferences, null);
    }

    public DefaultCodeFormatter(DefaultCodeFormatterOptions preferences, Map options) {
        if (options == null) {
            options = JavaCore.getOptions();
        }
        this.options = options;
        if (options != null) {
            this.preferences = new DefaultCodeFormatterOptions(options);
            if (preferences != null) {
                this.preferences.set(preferences.getMap());
            }
        } else {
            this.preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getDefaultSettings());
            if (preferences != null) {
                this.preferences.set(preferences.getMap());
            }
        }
    }

    public DefaultCodeFormatter(Map options) {
        this(null, options);
    }

    public TextEdit format(int kind, String source, int offset, int length, int indentationLevel, String lineSeparator) {
        if (offset < 0 || length < 0 || length > source.length()) {
            throw new IllegalArgumentException();
        }
        switch (kind) {
            case 4: {
                return this.formatClassBodyDeclarations(source, indentationLevel, lineSeparator, offset, length);
            }
            case 8: {
                return this.formatCompilationUnit(source, indentationLevel, lineSeparator, offset, length);
            }
            case 1: {
                return this.formatExpression(source, indentationLevel, lineSeparator, offset, length);
            }
            case 2: {
                return this.formatStatements(source, indentationLevel, lineSeparator, offset, length);
            }
            case 0: {
                return this.probeFormatting(source, indentationLevel, lineSeparator, offset, length);
            }
        }
        return null;
    }

    private TextEdit formatClassBodyDeclarations(String source, int indentationLevel, String lineSeparator, int offset, int length) {
        ASTNode[] bodyDeclarations = DefaultCodeFormatter.parseClassBodyDeclarations(source.toCharArray(), this.options);
        if (bodyDeclarations == null) {
            return null;
        }
        return this.internalFormatClassBodyDeclarations(source, indentationLevel, lineSeparator, bodyDeclarations, offset, length);
    }

    private TextEdit formatCompilationUnit(String source, int indentationLevel, String lineSeparator, int offset, int length) {
        CompilationUnitDeclaration compilationUnitDeclaration = DefaultCodeFormatter.parseCompilationUnit(source.toCharArray(), this.options);
        this.preferences.line_separator = lineSeparator != null ? lineSeparator : System.getProperty("line.separator");
        this.preferences.initial_indentation_level = indentationLevel;
        this.newCodeFormatter = new CodeFormatterVisitor(this.preferences, this.options, offset, length);
        return this.newCodeFormatter.format(source, compilationUnitDeclaration);
    }

    private TextEdit formatExpression(String source, int indentationLevel, String lineSeparator, int offset, int length) {
        Expression expression = DefaultCodeFormatter.parseExpression(source.toCharArray(), this.options);
        if (expression == null) {
            return null;
        }
        return this.internalFormatExpression(source, indentationLevel, lineSeparator, expression, offset, length);
    }

    private TextEdit formatStatements(String source, int indentationLevel, String lineSeparator, int offset, int length) {
        ConstructorDeclaration constructorDeclaration = DefaultCodeFormatter.parseStatements(source.toCharArray(), this.options);
        if (constructorDeclaration.statements == null) {
            return null;
        }
        return this.internalFormatStatements(source, indentationLevel, lineSeparator, constructorDeclaration, offset, length);
    }

    public String getDebugOutput() {
        return this.newCodeFormatter.scribe.toString();
    }

    private TextEdit internalFormatClassBodyDeclarations(String source, int indentationLevel, String lineSeparator, ASTNode[] bodyDeclarations, int offset, int length) {
        this.preferences.line_separator = lineSeparator != null ? lineSeparator : System.getProperty("line.separator");
        this.preferences.initial_indentation_level = indentationLevel;
        this.newCodeFormatter = new CodeFormatterVisitor(this.preferences, this.options, offset, length);
        return this.newCodeFormatter.format(source, bodyDeclarations);
    }

    private TextEdit internalFormatExpression(String source, int indentationLevel, String lineSeparator, Expression expression, int offset, int length) {
        this.preferences.line_separator = lineSeparator != null ? lineSeparator : System.getProperty("line.separator");
        this.preferences.initial_indentation_level = indentationLevel;
        this.newCodeFormatter = new CodeFormatterVisitor(this.preferences, this.options, offset, length);
        return this.newCodeFormatter.format(source, expression);
    }

    private TextEdit internalFormatStatements(String source, int indentationLevel, String lineSeparator, ConstructorDeclaration constructorDeclaration, int offset, int length) {
        this.preferences.line_separator = lineSeparator != null ? lineSeparator : System.getProperty("line.separator");
        this.preferences.initial_indentation_level = indentationLevel;
        this.newCodeFormatter = new CodeFormatterVisitor(this.preferences, this.options, offset, length);
        return this.newCodeFormatter.format(source, constructorDeclaration);
    }

    private TextEdit probeFormatting(String source, int indentationLevel, String lineSeparator, int offset, int length) {
        Expression expression = DefaultCodeFormatter.parseExpression(source.toCharArray(), this.options);
        if (expression != null) {
            return this.internalFormatExpression(source, indentationLevel, lineSeparator, expression, offset, length);
        }
        ConstructorDeclaration constructorDeclaration = DefaultCodeFormatter.parseStatements(source.toCharArray(), this.options);
        if (constructorDeclaration.statements != null) {
            return this.internalFormatStatements(source, indentationLevel, lineSeparator, constructorDeclaration, offset, length);
        }
        ASTNode[] bodyDeclarations = DefaultCodeFormatter.parseClassBodyDeclarations(source.toCharArray(), this.options);
        if (bodyDeclarations != null) {
            return this.internalFormatClassBodyDeclarations(source, indentationLevel, lineSeparator, bodyDeclarations, offset, length);
        }
        return this.formatCompilationUnit(source, indentationLevel, lineSeparator, offset, length);
    }
}

