/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.cfg;

import com.mchange.v1.xml.DomParseUtils;
import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.cfg.NamedScope;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class C3P0ConfigUtils {
    public static final String XML_CONFIG_RSRC_PATH = "/c3p0-config.xml";
    public static final String PROPS_FILE_RSRC_PATH = "/c3p0.properties";
    public static final String PROPS_FILE_PROP_PFX = "c3p0.";
    public static final int PROPS_FILE_PROP_PFX_LEN = 5;
    public static final String LINESEP;
    static final MLogger logger;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$cfg$C3P0ConfigUtils;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$C3P0Defaults;

    public static HashMap extractHardcodedC3P0Defaults(boolean stringify) {
        HashMap<String, Object> out = new HashMap<String, Object>();
        try {
            Method[] methods = (class$com$mchange$v2$c3p0$impl$C3P0Defaults == null ? (class$com$mchange$v2$c3p0$impl$C3P0Defaults = C3P0ConfigUtils.class$("com.mchange.v2.c3p0.impl.C3P0Defaults")) : class$com$mchange$v2$c3p0$impl$C3P0Defaults).getMethods();
            int len = methods.length;
            for (int i = 0; i < len; ++i) {
                Method m = methods[i];
                int mods = m.getModifiers();
                if ((mods & 1) == 0 || (mods & 8) == 0 || m.getParameterTypes().length != 0) continue;
                if (stringify) {
                    Object val = m.invoke(null, null);
                    if (val == null) continue;
                    out.put(m.getName(), String.valueOf(val));
                    continue;
                }
                out.put(m.getName(), m.invoke(null, null));
            }
        }
        catch (Exception e) {
            logger.log(MLevel.WARNING, "Failed to extract hardcoded default config!?", e);
        }
        return out;
    }

    public static HashMap extractHardcodedC3P0Defaults() {
        return C3P0ConfigUtils.extractHardcodedC3P0Defaults(true);
    }

    public static HashMap extractC3P0PropertiesResources() {
        HashMap<String, String> out = new HashMap<String, String>();
        Properties props = C3P0ConfigUtils.findAllC3P0Properties();
        Iterator<Object> ii = props.keySet().iterator();
        while (ii.hasNext()) {
            String key = (String)ii.next();
            String val = (String)props.get(key);
            if (!key.startsWith(PROPS_FILE_PROP_PFX)) continue;
            out.put(key.substring(5).trim(), val.trim());
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static C3P0Config extractXmlConfigFromDefaultResource() throws Exception {
        C3P0Config c3P0Config;
        block7: {
            InputStream is = null;
            try {
                is = (class$com$mchange$v2$c3p0$cfg$C3P0ConfigUtils == null ? (class$com$mchange$v2$c3p0$cfg$C3P0ConfigUtils = C3P0ConfigUtils.class$("com.mchange.v2.c3p0.cfg.C3P0ConfigUtils")) : class$com$mchange$v2$c3p0$cfg$C3P0ConfigUtils).getResourceAsStream(XML_CONFIG_RSRC_PATH);
                c3P0Config = is == null ? null : C3P0ConfigUtils.extractXmlConfigFromInputStream(is);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var3_3 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(MLevel.FINE)) break block8;
                        logger.log(MLevel.FINE, "Exception on resource InputStream close.", e);
                    }
                }
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(MLevel.FINE)) break block7;
                logger.log(MLevel.FINE, "Exception on resource InputStream close.", e);
            }
        }
        return c3P0Config;
    }

    public static C3P0Config extractXmlConfigFromInputStream(InputStream is) throws Exception {
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = fact.newDocumentBuilder();
        Document doc = db.parse(is);
        return C3P0ConfigUtils.extractConfigFromXmlDoc(doc);
    }

    public static C3P0Config extractConfigFromXmlDoc(Document doc) throws Exception {
        Element docElem = doc.getDocumentElement();
        if (docElem.getTagName().equals("c3p0-config")) {
            HashMap<String, NamedScope> configNamesToNamedScopes = new HashMap<String, NamedScope>();
            Element defaultConfigElem = DomParseUtils.uniqueChild(docElem, "default-config");
            NamedScope defaults = defaultConfigElem != null ? C3P0ConfigUtils.extractNamedScopeFromLevel(defaultConfigElem) : new NamedScope();
            NodeList nl = DomParseUtils.immediateChildElementsByTagName(docElem, "named-config");
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                Element namedConfigElem = (Element)nl.item(i);
                String configName = namedConfigElem.getAttribute("name");
                if (configName != null && configName.length() > 0) {
                    NamedScope namedConfig = C3P0ConfigUtils.extractNamedScopeFromLevel(namedConfigElem);
                    configNamesToNamedScopes.put(configName, namedConfig);
                    continue;
                }
                logger.warning("Configuration XML contained named-config element without name attribute: " + namedConfigElem);
            }
            return new C3P0Config(defaults, configNamesToNamedScopes);
        }
        throw new Exception("Root element of c3p0 config xml should be 'c3p0-config', not '" + docElem.getTagName() + "'.");
    }

    public static C3P0Config configFromFlatDefaults(HashMap flatDefaults) {
        NamedScope defaults = new NamedScope();
        defaults.props.putAll(flatDefaults);
        HashMap configNamesToNamedScopes = new HashMap();
        return new C3P0Config(defaults, configNamesToNamedScopes);
    }

    private static NamedScope extractNamedScopeFromLevel(Element elem) {
        HashMap props = C3P0ConfigUtils.extractPropertiesFromLevel(elem);
        HashMap<String, HashMap> userNamesToOverrides = new HashMap<String, HashMap>();
        NodeList nl = DomParseUtils.immediateChildElementsByTagName(elem, "user-overrides");
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Element perUserConfigElem = (Element)nl.item(i);
            String userName = perUserConfigElem.getAttribute("user");
            if (userName != null && userName.length() > 0) {
                HashMap userProps = C3P0ConfigUtils.extractPropertiesFromLevel(perUserConfigElem);
                userNamesToOverrides.put(userName, userProps);
                continue;
            }
            logger.warning("Configuration XML contained user-overrides element without user attribute: " + LINESEP + perUserConfigElem);
        }
        return new NamedScope(props, userNamesToOverrides);
    }

    private static HashMap extractPropertiesFromLevel(Element elem) {
        HashMap<String, String> out = new HashMap<String, String>();
        try {
            NodeList nl = DomParseUtils.immediateChildElementsByTagName(elem, "property");
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                Element propertyElem = (Element)nl.item(i);
                String propName = propertyElem.getAttribute("name");
                if (propName != null && propName.length() > 0) {
                    String propVal = DomParseUtils.allTextFromElement(propertyElem, true);
                    out.put(propName, propVal);
                    continue;
                }
                logger.warning("Configuration XML contained property element without name attribute: " + LINESEP + propertyElem);
            }
        }
        catch (Exception e) {
            logger.log(MLevel.WARNING, "An exception occurred while reading config XML. Some configuration information has probably been ignored.", e);
        }
        return out;
    }

    private static Properties findResourceProperties() {
        return MultiPropertiesConfig.readVmConfig().getPropertiesByResourcePath(PROPS_FILE_RSRC_PATH);
    }

    private static Properties findAllC3P0Properties() {
        return MultiPropertiesConfig.readVmConfig().getPropertiesByPrefix("c3p0");
    }

    static Properties findAllC3P0SystemProperties() {
        Properties out = new Properties();
        SecurityException sampleExc = null;
        try {
            Iterator ii = C3P0Defaults.getKnownProperties().iterator();
            while (ii.hasNext()) {
                String key = (String)ii.next();
                String prefixedKey = PROPS_FILE_PROP_PFX + key;
                String value = System.getProperty(prefixedKey);
                if (value == null || value.trim().length() <= 0) continue;
                out.put(key, value);
            }
        }
        catch (SecurityException e) {
            sampleExc = e;
        }
        return out;
    }

    private C3P0ConfigUtils() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String ls;
        try {
            ls = System.getProperty("line.separator", "\r\n");
        }
        catch (Exception e) {
            ls = "\r\n";
        }
        LINESEP = ls;
        logger = MLog.getLogger(class$com$mchange$v2$c3p0$cfg$C3P0ConfigUtils == null ? (class$com$mchange$v2$c3p0$cfg$C3P0ConfigUtils = C3P0ConfigUtils.class$("com.mchange.v2.c3p0.cfg.C3P0ConfigUtils")) : class$com$mchange$v2$c3p0$cfg$C3P0ConfigUtils);
    }
}

