/*
 * Copyright (c) 2019, 2021, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2.0, as
 * published by the Free Software Foundation.
 *
 * This program is also distributed with certain software (including
 * but not limited to OpenSSL) that is licensed under separate terms,
 * as designated in a particular file or component or in included license
 * documentation.  The authors of MySQL hereby grant you an
 * additional permission to link the program and your derivative works
 * with the separately licensed software that they have included with
 * MySQL.
 *
 * Without limiting anything contained in the foregoing, this file,
 * which is part of MySQL Connector/Node.js, is also subject to the
 * Universal FOSS Exception, version 1.0, a copy of which can be found at
 * http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

'use strict';

const collations = [{
    charset: 'big5',
    id: 1,
    name: 'big5_chinese_ci'
}, {
    charset: 'latin2',
    id: 2,
    name: 'latin2_czech_cs'
}, {
    charset: 'dec8',
    id: 3,
    name: 'dec8_swedish_ci'
}, {
    charset: 'cp850',
    id: 4,
    name: 'cp850_general_ci'
}, {
    charset: 'latin1',
    id: 5,
    name: 'latin1_german1_ci'
}, {
    charset: 'hp8',
    id: 6,
    name: 'hp8_english_ci'
}, {
    charset: 'koi8r',
    id: 7,
    name: 'koi8r_general_ci'
}, {
    charset: 'latin1',
    id: 8,
    name: 'latin1_swedish_ci'
}, {
    charset: 'latin2',
    id: 9,
    name: 'latin2_general_ci'
}, {
    charset: 'swe7',
    id: 10,
    name: 'swe7_swedish_ci'
}, {
    charset: 'ascii',
    id: 11,
    name: 'ascii_general_ci'
}, {
    charset: 'ujis',
    id: 12,
    name: 'ujis_japanese_ci'
}, {
    charset: 'sjis',
    id: 13,
    name: 'sjis_japanese_ci'
}, {
    charset: 'cp1251',
    id: 14,
    name: 'cp1251_bulgarian_ci'
}, {
    charset: 'latin1',
    id: 15,
    name: 'latin1_danish_ci'
}, {
    charset: 'hebrew',
    id: 16,
    name: 'hebrew_general_ci'
}, {
    charset: 'tis620',
    id: 18,
    name: 'tis620_thai_ci'
}, {
    charset: 'euckr',
    id: 19,
    name: 'euckr_korean_ci'
}, {
    charset: 'latin7',
    id: 20,
    name: 'latin7_estonian_cs'
}, {
    charset: 'latin2',
    id: 21,
    name: 'latin2_hungarian_ci'
}, {
    charset: 'koi8u',
    id: 22,
    name: 'koi8u_general_ci'
}, {
    charset: 'cp1251',
    id: 23,
    name: 'cp1251_ukrainian_ci'
}, {
    charset: 'gb2312',
    id: 24,
    name: 'gb2312_chinese_ci'
}, {
    charset: 'greek',
    id: 25,
    name: 'greek_general_ci'
}, {
    charset: 'cp1250',
    id: 26,
    name: 'cp1250_general_ci'
}, {
    charset: 'latin2',
    id: 27,
    name: 'latin2_croatian_ci'
}, {
    charset: 'gbk',
    id: 28,
    name: 'gbk_chinese_ci'
}, {
    charset: 'cp1257',
    id: 29,
    name: 'cp1257_lithuanian_ci'
}, {
    charset: 'latin5',
    id: 30,
    name: 'latin5_turkish_ci'
}, {
    charset: 'latin1',
    id: 31,
    name: 'latin1_german2_ci'
}, {
    charset: 'armscii8',
    id: 32,
    name: 'armscii8_general_ci'
}, {
    charset: 'utf8',
    id: 33,
    name: 'utf8_general_ci'
}, {
    charset: 'cp1250',
    id: 34,
    name: 'cp1250_czech_cs'
}, {
    charset: 'ucs2',
    id: 35,
    name: 'ucs2_general_ci'
}, {
    charset: 'cp866',
    id: 36,
    name: 'cp866_general_ci'
}, {
    charset: 'keybcs2',
    id: 37,
    name: 'keybcs2_general_ci'
}, {
    charset: 'macce',
    id: 38,
    name: 'macce_general_ci'
}, {
    charset: 'macroman',
    id: 39,
    name: 'macroman_general_ci'
}, {
    charset: 'cp852',
    id: 40,
    name: 'cp852_general_ci'
}, {
    charset: 'latin7',
    id: 41,
    name: 'latin7_general_ci'
}, {
    charset: 'latin7',
    id: 42,
    name: 'latin7_general_cs'
}, {
    charset: 'macce',
    id: 43,
    name: 'macce_bin'
}, {
    charset: 'cp1250',
    id: 44,
    name: 'cp1250_croatian_ci'
}, {
    charset: 'utf8mb4',
    id: 45,
    name: 'utf8mb4_general_ci'
}, {
    charset: 'utf8mb4',
    id: 46,
    name: 'utf8mb4_bin'
}, {
    charset: 'latin1',
    id: 47,
    name: 'latin1_bin'
}, {
    charset: 'latin1',
    id: 48,
    name: 'latin1_general_ci'
}, {
    charset: 'latin1',
    id: 49,
    name: 'latin1_general_cs'
}, {
    charset: 'cp1251',
    id: 50,
    name: 'cp1251_bin'
}, {
    charset: 'cp1251',
    id: 51,
    name: 'cp1251_general_ci'
}, {
    charset: 'cp1251',
    id: 52,
    name: 'cp1251_general_cs'
}, {
    charset: 'macroman',
    id: 53,
    name: 'macroman_bin'
}, {
    charset: 'utf16',
    id: 54,
    name: 'utf16_general_ci'
}, {
    charset: 'utf16',
    id: 55,
    name: 'utf16_bin'
}, {
    charset: 'utf16le',
    id: 56,
    name: 'utf16le_general_ci'
}, {
    charset: 'cp1256',
    id: 57,
    name: 'cp1256_general_ci'
}, {
    charset: 'cp1257',
    id: 58,
    name: 'cp1257_bin'
}, {
    charset: 'cp1257',
    id: 59,
    name: 'cp1257_general_ci'
}, {
    charset: 'utf32',
    id: 60,
    name: 'utf32_general_ci'
}, {
    charset: 'utf32',
    id: 61,
    name: 'utf32_bin'
}, {
    charset: 'utf16le',
    id: 62,
    name: 'utf16le_bin'
}, {
    charset: 'binary',
    id: 63,
    name: 'binary'
}, {
    charset: 'armscii8',
    id: 64,
    name: 'armscii8_bin'
}, {
    charset: 'ascii',
    id: 65,
    name: 'ascii_bin'
}, {
    charset: 'cp1250',
    id: 66,
    name: 'cp1250_bin'
}, {
    charset: 'cp1256',
    id: 67,
    name: 'cp1256_bin'
}, {
    charset: 'cp866',
    id: 68,
    name: 'cp866_bin'
}, {
    charset: 'dec8',
    id: 69,
    name: 'dec8_bin'
}, {
    charset: 'greek',
    id: 70,
    name: 'greek_bin'
}, {
    charset: 'hebrew',
    id: 71,
    name: 'hebrew_bin'
}, {
    charset: 'hp8',
    id: 72,
    name: 'hp8_bin'
}, {
    charset: 'keybcs2',
    id: 73,
    name: 'keybcs2_bin'
}, {
    charset: 'koi8r',
    id: 74,
    name: 'koi8r_bin'
}, {
    charset: 'koi8u',
    id: 75,
    name: 'koi8u_bin'
}, {
    charset: 'utf8',
    id: 76,
    name: 'utf8_tolower_ci'
}, {
    charset: 'latin2',
    id: 77,
    name: 'latin2_bin'
}, {
    charset: 'latin5',
    id: 78,
    name: 'latin5_bin'
}, {
    charset: 'latin7',
    id: 79,
    name: 'latin7_bin'
}, {
    charset: 'cp850',
    id: 80,
    name: 'cp850_bin'
}, {
    charset: 'cp852',
    id: 81,
    name: 'cp852_bin'
}, {
    charset: 'swe7',
    id: 82,
    name: 'swe7_bin'
}, {
    charset: 'utf8',
    id: 83,
    name: 'utf8_bin'
}, {
    charset: 'big5',
    id: 84,
    name: 'big5_bin'
}, {
    charset: 'euckr',
    id: 85,
    name: 'euckr_bin'
}, {
    charset: 'gb2312',
    id: 86,
    name: 'gb2312_bin'
}, {
    charset: 'gbk',
    id: 87,
    name: 'gbk_bin'
}, {
    charset: 'sjis',
    id: 88,
    name: 'sjis_bin'
}, {
    charset: 'tis620',
    id: 89,
    name: 'tis620_bin'
}, {
    charset: 'ucs2',
    id: 90,
    name: 'ucs2_bin'
}, {
    charset: 'ujis',
    id: 91,
    name: 'ujis_bin'
}, {
    charset: 'geostd8',
    id: 92,
    name: 'geostd8_general_ci'
}, {
    charset: 'geostd8',
    id: 93,
    name: 'geostd8_bin'
}, {
    charset: 'latin1',
    id: 94,
    name: 'latin1_spanish_ci'
}, {
    charset: 'cp932',
    id: 95,
    name: 'cp932_japanese_ci'
}, {
    charset: 'cp932',
    id: 96,
    name: 'cp932_bin'
}, {
    charset: 'eucjpms',
    id: 97,
    name: 'eucjpms_japanese_ci'
}, {
    charset: 'eucjpms',
    id: 98,
    name: 'eucjpms_bin'
}, {
    charset: 'cp1250',
    id: 99,
    name: 'cp1250_polish_ci'
}, {
    charset: 'utf16',
    id: 101,
    name: 'utf16_unicode_ci'
}, {
    charset: 'utf16',
    id: 102,
    name: 'utf16_icelandic_ci'
}, {
    charset: 'utf16',
    id: 103,
    name: 'utf16_latvian_ci'
}, {
    charset: 'utf16',
    id: 104,
    name: 'utf16_romanian_ci'
}, {
    charset: 'utf16',
    id: 105,
    name: 'utf16_slovenian_ci'
}, {
    charset: 'utf16',
    id: 106,
    name: 'utf16_polish_ci'
}, {
    charset: 'utf16',
    id: 107,
    name: 'utf16_estonian_ci'
}, {
    charset: 'utf16',
    id: 108,
    name: 'utf16_spanish_ci'
}, {
    charset: 'utf16',
    id: 109,
    name: 'utf16_swedish_ci'
}, {
    charset: 'utf16',
    id: 110,
    name: 'utf16_turkish_ci'
}, {
    charset: 'utf16',
    id: 111,
    name: 'utf16_czech_ci'
}, {
    charset: 'utf16',
    id: 112,
    name: 'utf16_danish_ci'
}, {
    charset: 'utf16',
    id: 113,
    name: 'utf16_lithuanian_ci'
}, {
    charset: 'utf16',
    id: 114,
    name: 'utf16_slovak_ci'
}, {
    charset: 'utf16',
    id: 115,
    name: 'utf16_spanish2_ci'
}, {
    charset: 'utf16',
    id: 116,
    name: 'utf16_roman_ci'
}, {
    charset: 'utf16',
    id: 117,
    name: 'utf16_persian_ci'
}, {
    charset: 'utf16',
    id: 118,
    name: 'utf16_esperanto_ci'
}, {
    charset: 'utf16',
    id: 119,
    name: 'utf16_hungarian_ci'
}, {
    charset: 'utf16',
    id: 120,
    name: 'utf16_sinhala_ci'
}, {
    charset: 'utf16',
    id: 121,
    name: 'utf16_german2_ci'
}, {
    charset: 'utf16',
    id: 122,
    name: 'utf16_croatian_ci'
}, {
    charset: 'utf16',
    id: 123,
    name: 'utf16_unicode_520_ci'
}, {
    charset: 'utf16',
    id: 124,
    name: 'utf16_vietnamese_ci'
}, {
    charset: 'ucs2',
    id: 128,
    name: 'ucs2_unicode_ci'
}, {
    charset: 'ucs2',
    id: 129,
    name: 'ucs2_icelandic_ci'
}, {
    charset: 'ucs2',
    id: 130,
    name: 'ucs2_latvian_ci'
}, {
    charset: 'ucs2',
    id: 131,
    name: 'ucs2_romanian_ci'
}, {
    charset: 'ucs2',
    id: 132,
    name: 'ucs2_slovenian_ci'
}, {
    charset: 'ucs2',
    id: 133,
    name: 'ucs2_polish_ci'
}, {
    charset: 'ucs2',
    id: 134,
    name: 'ucs2_estonian_ci'
}, {
    charset: 'ucs2',
    id: 135,
    name: 'ucs2_spanish_ci'
}, {
    charset: 'ucs2',
    id: 136,
    name: 'ucs2_swedish_ci'
}, {
    charset: 'ucs2',
    id: 137,
    name: 'ucs2_turkish_ci'
}, {
    charset: 'ucs2',
    id: 138,
    name: 'ucs2_czech_ci'
}, {
    charset: 'ucs2',
    id: 139,
    name: 'ucs2_danish_ci'
}, {
    charset: 'ucs2',
    id: 140,
    name: 'ucs2_lithuanian_ci'
}, {
    charset: 'ucs2',
    id: 141,
    name: 'ucs2_slovak_ci'
}, {
    charset: 'ucs2',
    id: 142,
    name: 'ucs2_spanish2_ci'
}, {
    charset: 'ucs2',
    id: 143,
    name: 'ucs2_roman_ci'
}, {
    charset: 'ucs2',
    id: 144,
    name: 'ucs2_persian_ci'
}, {
    charset: 'ucs2',
    id: 145,
    name: 'ucs2_esperanto_ci'
}, {
    charset: 'ucs2',
    id: 146,
    name: 'ucs2_hungarian_ci'
}, {
    charset: 'ucs2',
    id: 147,
    name: 'ucs2_sinhala_ci'
}, {
    charset: 'ucs2',
    id: 148,
    name: 'ucs2_german2_ci'
}, {
    charset: 'ucs2',
    id: 149,
    name: 'ucs2_croatian_ci'
}, {
    charset: 'ucs2',
    id: 150,
    name: 'ucs2_unicode_520_ci'
}, {
    charset: 'ucs2',
    id: 151,
    name: 'ucs2_vietnamese_ci'
}, {
    charset: 'ucs2',
    id: 159,
    name: 'ucs2_general_mysql500_ci'
}, {
    charset: 'utf32',
    id: 160,
    name: 'utf32_unicode_ci'
}, {
    charset: 'utf32',
    id: 161,
    name: 'utf32_icelandic_ci'
}, {
    charset: 'utf32',
    id: 162,
    name: 'utf32_latvian_ci'
}, {
    charset: 'utf32',
    id: 163,
    name: 'utf32_romanian_ci'
}, {
    charset: 'utf32',
    id: 164,
    name: 'utf32_slovenian_ci'
}, {
    charset: 'utf32',
    id: 165,
    name: 'utf32_polish_ci'
}, {
    charset: 'utf32',
    id: 166,
    name: 'utf32_estonian_ci'
}, {
    charset: 'utf32',
    id: 167,
    name: 'utf32_spanish_ci'
}, {
    charset: 'utf32',
    id: 168,
    name: 'utf32_swedish_ci'
}, {
    charset: 'utf32',
    id: 169,
    name: 'utf32_turkish_ci'
}, {
    charset: 'utf32',
    id: 170,
    name: 'utf32_czech_ci'
}, {
    charset: 'utf32',
    id: 171,
    name: 'utf32_danish_ci'
}, {
    charset: 'utf32',
    id: 172,
    name: 'utf32_lithuanian_ci'
}, {
    charset: 'utf32',
    id: 173,
    name: 'utf32_slovak_ci'
}, {
    charset: 'utf32',
    id: 174,
    name: 'utf32_spanish2_ci'
}, {
    charset: 'utf32',
    id: 175,
    name: 'utf32_roman_ci'
}, {
    charset: 'utf32',
    id: 176,
    name: 'utf32_persian_ci'
}, {
    charset: 'utf32',
    id: 177,
    name: 'utf32_esperanto_ci'
}, {
    charset: 'utf32',
    id: 178,
    name: 'utf32_hungarian_ci'
}, {
    charset: 'utf32',
    id: 179,
    name: 'utf32_sinhala_ci'
}, {
    charset: 'utf32',
    id: 180,
    name: 'utf32_german2_ci'
}, {
    charset: 'utf32',
    id: 181,
    name: 'utf32_croatian_ci'
}, {
    charset: 'utf32',
    id: 182,
    name: 'utf32_unicode_520_ci'
}, {
    charset: 'utf32',
    id: 183,
    name: 'utf32_vietnamese_ci'
}, {
    charset: 'utf8',
    id: 192,
    name: 'utf8_unicode_ci'
}, {
    charset: 'utf8',
    id: 193,
    name: 'utf8_icelandic_ci'
}, {
    charset: 'utf8',
    id: 194,
    name: 'utf8_latvian_ci'
}, {
    charset: 'utf8',
    id: 195,
    name: 'utf8_romanian_ci'
}, {
    charset: 'utf8',
    id: 196,
    name: 'utf8_slovenian_ci'
}, {
    charset: 'utf8',
    id: 197,
    name: 'utf8_polish_ci'
}, {
    charset: 'utf8',
    id: 198,
    name: 'utf8_estonian_ci'
}, {
    charset: 'utf8',
    id: 199,
    name: 'utf8_spanish_ci'
}, {
    charset: 'utf8',
    id: 200,
    name: 'utf8_swedish_ci'
}, {
    charset: 'utf8',
    id: 201,
    name: 'utf8_turkish_ci'
}, {
    charset: 'utf8',
    id: 202,
    name: 'utf8_czech_ci'
}, {
    charset: 'utf8',
    id: 203,
    name: 'utf8_danish_ci'
}, {
    charset: 'utf8',
    id: 204,
    name: 'utf8_lithuanian_ci'
}, {
    charset: 'utf8',
    id: 205,
    name: 'utf8_slovak_ci'
}, {
    charset: 'utf8',
    id: 206,
    name: 'utf8_spanish2_ci'
}, {
    charset: 'utf8',
    id: 207,
    name: 'utf8_roman_ci'
}, {
    charset: 'utf8',
    id: 208,
    name: 'utf8_persian_ci'
}, {
    charset: 'utf8',
    id: 209,
    name: 'utf8_esperanto_ci'
}, {
    charset: 'utf8',
    id: 210,
    name: 'utf8_hungarian_ci'
}, {
    charset: 'utf8',
    id: 211,
    name: 'utf8_sinhala_ci'
}, {
    charset: 'utf8',
    id: 212,
    name: 'utf8_german2_ci'
}, {
    charset: 'utf8',
    id: 213,
    name: 'utf8_croatian_ci'
}, {
    charset: 'utf8',
    id: 214,
    name: 'utf8_unicode_520_ci'
}, {
    charset: 'utf8',
    id: 215,
    name: 'utf8_vietnamese_ci'
}, {
    charset: 'utf8',
    id: 223,
    name: 'utf8_general_mysql500_ci'
}, {
    charset: 'utf8mb4',
    id: 224,
    name: 'utf8mb4_unicode_ci'
}, {
    charset: 'utf8mb4',
    id: 225,
    name: 'utf8mb4_icelandic_ci'
}, {
    charset: 'utf8mb4',
    id: 226,
    name: 'utf8mb4_latvian_ci'
}, {
    charset: 'utf8mb4',
    id: 227,
    name: 'utf8mb4_romanian_ci'
}, {
    charset: 'utf8mb4',
    id: 228,
    name: 'utf8mb4_slovenian_ci'
}, {
    charset: 'utf8mb4',
    id: 229,
    name: 'utf8mb4_polish_ci'
}, {
    charset: 'utf8mb4',
    id: 230,
    name: 'utf8mb4_estonian_ci'
}, {
    charset: 'utf8mb4',
    id: 231,
    name: 'utf8mb4_spanish_ci'
}, {
    charset: 'utf8mb4',
    id: 232,
    name: 'utf8mb4_swedish_ci'
}, {
    charset: 'utf8mb4',
    id: 233,
    name: 'utf8mb4_turkish_ci'
}, {
    charset: 'utf8mb4',
    id: 234,
    name: 'utf8mb4_czech_ci'
}, {
    charset: 'utf8mb4',
    id: 235,
    name: 'utf8mb4_danish_ci'
}, {
    charset: 'utf8mb4',
    id: 236,
    name: 'utf8mb4_lithuanian_ci'
}, {
    charset: 'utf8mb4',
    id: 237,
    name: 'utf8mb4_slovak_ci'
}, {
    charset: 'utf8mb4',
    id: 238,
    name: 'utf8mb4_spanish2_ci'
}, {
    charset: 'utf8mb4',
    id: 239,
    name: 'utf8mb4_roman_ci'
}, {
    charset: 'utf8mb4',
    id: 240,
    name: 'utf8mb4_persian_ci'
}, {
    charset: 'utf8mb4',
    id: 241,
    name: 'utf8mb4_esperanto_ci'
}, {
    charset: 'utf8mb4',
    id: 242,
    name: 'utf8mb4_hungarian_ci'
}, {
    charset: 'utf8mb4',
    id: 243,
    name: 'utf8mb4_sinhala_ci'
}, {
    charset: 'utf8mb4',
    id: 244,
    name: 'utf8mb4_german2_ci'
}, {
    charset: 'utf8mb4',
    id: 245,
    name: 'utf8mb4_croatian_ci'
}, {
    charset: 'utf8mb4',
    id: 246,
    name: 'utf8mb4_unicode_520_ci'
}, {
    charset: 'utf8mb4',
    id: 247,
    name: 'utf8mb4_vietnamese_ci'
}, {
    charset: 'gb18030',
    id: 248,
    name: 'gb18030_chinese_ci'
}, {
    charset: 'gb18030',
    id: 249,
    name: 'gb18030_bin'
}, {
    charset: 'gb18030',
    id: 250,
    name: 'gb18030_unicode_520_ci'
}, {
    charset: 'utf8mb4',
    id: 255,
    name: 'utf8mb4_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 256,
    name: 'utf8mb4_de_pb_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 257,
    name: 'utf8mb4_is_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 258,
    name: 'utf8mb4_lv_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 259,
    name: 'utf8mb4_ro_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 260,
    name: 'utf8mb4_sl_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 261,
    name: 'utf8mb4_pl_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 262,
    name: 'utf8mb4_et_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 263,
    name: 'utf8mb4_es_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 264,
    name: 'utf8mb4_sv_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 265,
    name: 'utf8mb4_tr_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 266,
    name: 'utf8mb4_cs_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 267,
    name: 'utf8mb4_da_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 268,
    name: 'utf8mb4_lt_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 269,
    name: 'utf8mb4_sk_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 270,
    name: 'utf8mb4_es_trad_0900_ai_c'
}, {
    charset: 'utf8mb4',
    id: 271,
    name: 'utf8mb4_la_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 273,
    name: 'utf8mb4_eo_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 274,
    name: 'utf8mb4_hu_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 275,
    name: 'utf8mb4_hr_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 277,
    name: 'utf8mb4_vi_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 278,
    name: 'utf8mb4_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 279,
    name: 'utf8mb4_de_pb_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 280,
    name: 'utf8mb4_is_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 281,
    name: 'utf8mb4_lv_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 282,
    name: 'utf8mb4_ro_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 283,
    name: 'utf8mb4_sl_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 284,
    name: 'utf8mb4_pl_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 285,
    name: 'utf8mb4_et_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 286,
    name: 'utf8mb4_es_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 287,
    name: 'utf8mb4_sv_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 288,
    name: 'utf8mb4_tr_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 289,
    name: 'utf8mb4_cs_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 290,
    name: 'utf8mb4_da_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 291,
    name: 'utf8mb4_lt_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 292,
    name: 'utf8mb4_sk_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 293,
    name: 'utf8mb4_es_trad_0900_as_c'
}, {
    charset: 'utf8mb4',
    id: 294,
    name: 'utf8mb4_la_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 296,
    name: 'utf8mb4_eo_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 297,
    name: 'utf8mb4_hu_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 298,
    name: 'utf8mb4_hr_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 300,
    name: 'utf8mb4_vi_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 303,
    name: 'utf8mb4_ja_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 304,
    name: 'utf8mb4_ja_0900_as_cs_ks'
}, {
    charset: 'utf8mb4',
    id: 305,
    name: 'utf8mb4_0900_as_ci'
}, {
    charset: 'utf8mb4',
    id: 306,
    name: 'utf8mb4_ru_0900_ai_ci'
}, {
    charset: 'utf8mb4',
    id: 307,
    name: 'utf8mb4_ru_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 308,
    name: 'utf8mb4_zh_0900_as_cs'
}, {
    charset: 'utf8mb4',
    id: 309,
    name: 'utf8mb4_0900_bin'
}];

/**
 * Get the details of a given collation.
 * @private
 * @param {Number} id - the collation id (array index)
 * @returns {Object} An object containing the collation details.
 */
exports.find = function (id) {
    let collation;
    let iterator = 0;

    // The collation ids are incremental but not necessarily sequential.
    // So, when the collation id does not match the respective array index,
    // we just need to increment the index until we get a proper match.
    do {
        collation = collations[iterator];
        ++iterator;
    } while (iterator < collations.length && collation.id !== id);

    return collation;
};
