#ifndef CGI_APP_H
#define CGI_APP_H

#include <fstream.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <string>
#include <vector>
#include "cgi_app_section.h"
#include "cgi_form.h"

class CgiApp
 {
  protected:
    vector<CgiAppSection*> *sections;
    vector<CgiForm> cgi_form_list;

  public:
   CgiApp(vector<CgiAppSection*> *init_sections);
   ~CgiApp();
   void  set_cgi_form_list(const vector<CgiForm>& init_cgi_form_list) 
    {
     cgi_form_list = init_cgi_form_list;
    }

   const CgiForm* get_form(string& form_name)
    {
     unsigned int i;
     for(i = 0; i < cgi_form_list.size(); i++)
      if(cgi_form_list[i].name == form_name)
       return &(cgi_form_list[i]);
    }

   void write_c(ofstream& os);
   void write_c_forms(ofstream& os);
   void write_c_functions(ofstream& os);
   void write_c_sections(ofstream& os);
   void write_c_includes(ofstream& os);
   void write_c_globals(ofstream& os);
 };

#endif
