#ifndef _UDM_DBMS_H
#define _UDM_DBMS_H

/* for stl_info_t */
#include "udm_search_tl.h"

/* Database type */
#define UDM_DB_UNK		0
#define UDM_DB_MSQL		1
#define UDM_DB_MYSQL		2
#define UDM_DB_PGSQL		3
#define UDM_DB_SOLID		4
#define UDM_DB_ORACLE		5
#define UDM_DB_VIRT		6
#define UDM_DB_IBASE		7
#define UDM_DB_ORACLE8		8
#define UDM_DB_ORACLE7		9
#define UDM_DB_MSSQL		10
#define UDM_DB_SAPDB            11
#define UDM_DB_FILES		100

/* FIXME: hide this function into SQL.c */
extern char * UdmDBEscStr(int dbtype,char * dst,const char *src);

extern int * UdmGetURLList(UDM_AGENT * Indexer);
extern int UdmLoadStopList(UDM_AGENT * Indexer,const char * table);
extern int UdmLoadServerTable(UDM_AGENT * Indexer, char * path,int flags);
extern int UdmFindURL(UDM_AGENT * Indexer,char *url);
extern int UdmAddURL(UDM_AGENT * Indexer,char *url,int referrer,int hops, char * msg_id, char * tag,char * cat);
extern int UdmDeleteWordFromURL(UDM_AGENT* Indexer,int url_id);
extern int UdmDeleteCrossWordFromURL(UDM_AGENT* Indexer,int url_id,int ref_id);
extern int UdmDeleteUrl(UDM_AGENT* Indexer,int url_id);
extern int UdmUpdateUrl(UDM_AGENT* Indexer,int url_id,int status,int period);
extern int UdmBuildExtIndex(UDM_AGENT * query);

#ifdef NEWS_EXT
extern int UdmRegisterChild(UDM_AGENT *Indexer, int parent_id, int child_id);
extern int UdmFindMsgID(UDM_AGENT *Indexer, const char * msg_id);
extern int UdmDeleteAllFromThread(UDM_AGENT* Indexer);
extern int UdmLongUpdateUrl(UDM_AGENT *Indexer,
	int url_id,int status,int changed,int size,int period,
	char * tag,
	time_t last_mod_time,
	char *text_escaped,
	char *title_escaped,
	char *content_type,
	char *keywords_escaped,
	char *descript_escaped,
	udmcrc32_t crc32,
	char *lang,
	char *category,
	char *hd_date,
	char *hd_subj,
	char *hd_from,
	char *hd_group,
	char *hd_ref,
	char *msg_id
);
#else
extern int UdmLongUpdateUrl(UDM_AGENT* Indexer,
	int url_id,int status,int is_changed,
	int size,int period,char *tag,
	time_t last_mod_time,
	char *text_escaped,
	char *title_escaped,
	char *content_type,
	char *keywords_escaped,
	char *descript_escaped,
	udmcrc32_t crc32,
	char *lang,
	char *category);
#endif

extern int UdmStoreWords(UDM_AGENT * Indexer, int url_id, int site_id,const char * cat, const char * tag, int status);
extern int UdmStoreCrossWords(UDM_AGENT * Indexer, int url_id);
extern int UdmFindOrigin(UDM_AGENT* Indexer, udmcrc32_t crc32, int size);
extern int UdmUpdateClone(UDM_AGENT* Indexer, int url_id, int status, int period,
	char *content_type, time_t last_mod_time, udmcrc32_t crc32);

extern int UdmDeleteAllFromDict(UDM_AGENT* Indexer);
extern int UdmDeleteAllFromUrl(UDM_AGENT* Indexer);
extern int UdmDeleteRobotsFromHost(UDM_AGENT* Indexer,char *hostinfo);
extern int UdmAddRobotsToHost(UDM_AGENT* Indexer,char *hostinfo,char *s);


extern UDM_RESULT * UdmFind(UDM_AGENT *,char * text);
extern UDM_RESULT * UdmCloneList(UDM_AGENT*, udmcrc32_t crc32);
extern __INDLIB__ void UdmFreeResult(UDM_RESULT*);
extern UDM_DOCUMENT * UdmGetDocInfo(UDM_AGENT* Indexer,int expired_first);

extern char * UdmDBErrorMsg(void *db);
extern int UdmDBErrorCode(void *db);
extern void * UdmAllocDB(UDM_AGENT * Indexer,int mode);
extern void   UdmFreeDB(UDM_AGENT * Indexer);

extern int    UdmLoadRobots(UDM_AGENT *Indexer);
extern __INDLIB__ int UdmMarkForReindex(UDM_AGENT * Indexer);
extern int    UdmClearDB(UDM_AGENT * Indexer);

extern int UdmImportDictionaryFromDB(UDM_AGENT *);
extern int         UdmInsertSpell(UDM_AGENT *,const char *,const char *,const char *);
extern UDM_SPELL * UdmFindWordDB(UDM_AGENT *,const char * w);
extern int 	   UdmInsertAffix(UDM_AGENT *,int ,const char *,const char *,const char *,const char *,const char *);
extern int         UdmDBImportAffixes(UDM_AGENT*, int LCharset);
extern UDM_CATEGORY  *  UdmCatPath(UDM_AGENT *,const char * addr);
extern UDM_CATEGORY  *  UdmCatList(UDM_AGENT *,const char * addr);

extern __INDLIB__ int UdmAddTagLimit(UDM_ENV * Conf,char * tag);
extern __INDLIB__ int UdmAddStatusLimit(UDM_ENV* Conf,int status);
extern __INDLIB__ int UdmAddURLLimit(UDM_ENV *,char * URL);
extern __INDLIB__ int UdmAddLangLimit(UDM_ENV *,char * lang);
extern __INDLIB__ int UdmAddTimeLimit(UDM_ENV *,struct udm_stl_info_t *stl);
extern __INDLIB__ int UdmAddCatLimit(UDM_ENV *,char * category);
extern __INDLIB__ int UdmAddWeightLimit(UDM_ENV*,int weight_id);
extern __INDLIB__ int UdmClearURLLimit(UDM_ENV*);
extern __INDLIB__ int UdmClearLimits(UDM_ENV*);

extern __INDLIB__ int UdmGetReferers(UDM_AGENT * Indexer);
extern __INDLIB__ int UdmGetStatistics(UDM_AGENT * Indexer);
extern __INDLIB__ int UdmGetDocCount(UDM_AGENT * Indexer);
extern __INDLIB__ const char * UdmVersion(void);

#ifdef USE_HTDB
int UdmHTDBGet(UDM_AGENT * Indexer,char *path,char *filename, char * htdb_list,char * htdb_doc);
#endif

#ifdef ENABLE_DB_UPDATE
extern int UpdateDatabase(UDM_AGENT * Indexer);
#endif /* ENABLE_DB_UPDATE */

extern __INDLIB__ UDM_URLSTATE * UdmGetURLState(UDM_AGENT * Agent,const char * hostinfo,time_t lmt);

extern void UdmFreeUrlRes(UDM_ENV *Conf);

#endif
