#include <sys/types.h>

#include "udm_config.h"
#include "udm_common.h"
#include "udm_boolean.h"


#ifdef DEBUG_BOOL
static char item_type(int cmd,int arg){
	switch(cmd){
		case UDM_STACK_LEFT:	return('(');
		case UDM_STACK_RIGHT:	return(')');
		case UDM_STACK_OR:	return('|');
		case UDM_STACK_AND:	return('&');
		case UDM_STACK_NOT:	return('~');
		case UDM_STACK_WORD:	return(arg?'1':'0');
		default:		return('?');
	}
}
#endif

static int TOPCMD(UDM_BOOLSTACK * s){
	if(s->ncstack)
		return(s->cstack[s->ncstack-1]);
	else
		return(UDM_STACK_BOT);
}

static int POPARG(UDM_BOOLSTACK * s){
	if(s->nastack>0){
		s->nastack--;
		return(s->astack[s->nastack]);
	}else{
		return(UDM_STACK_BOT);
	}
}

static int POPCMD(UDM_BOOLSTACK * s){
	if(s->ncstack>0){
		s->ncstack--;
		return(s->cstack[s->ncstack]);
	}else{
		return(UDM_STACK_BOT);
	}
}

static void PUSHARG(UDM_BOOLSTACK * s,int arg){
	s->astack[s->nastack]=arg;
	s->nastack++;
}

static void PUSHCMD(UDM_BOOLSTACK * s,int arg){
	s->cstack[s->ncstack]=arg;
	s->ncstack++;
}

/* Compute one operation and store result */
static int perform(UDM_BOOLSTACK * s,int com){
	int res,x1,x2;
	switch(com){
		case UDM_STACK_OR:
			/* This is to avoid compiler      */
			/* optimization in || calculation */
			x1=POPARG(s);
			x2=POPARG(s);
			res=(x1||x2);
#ifdef DEBUG_BOOL
			fprintf(stderr,"Perform %d | %d\n",x1,x2);
#endif
			PUSHARG(s,res);
			break;
		case UDM_STACK_AND:
			x1=POPARG(s);
			x2=POPARG(s);
			res=(x1&&x2);
#ifdef DEBUG_BOOL
			fprintf(stderr,"Perform %d & %d\n",x1,x2);
#endif
			PUSHARG(s,res);
			break;
		case UDM_STACK_NOT:
			x1=POPARG(s);
			res=x1?0:1;
#ifdef DEBUG_BOOL
			fprintf(stderr,"Perform ~%d\n",x1);
#endif
			PUSHARG(s,res);
			break;
	}
	return(0);
}


/* Main function to calculate items sequence */
int UdmCalcBoolItems(UDM_STACK_ITEM * items, size_t nitems){
	UDM_BOOLSTACK s;
	int res;
	size_t i;

	/* Init stack */
	s.ncstack=0;
	s.nastack=0;

#ifdef DEBUG_BOOL
	fprintf(stderr,"--------\n");
#endif
	for(i=0;i<nitems;i++){
		int c;
#ifdef DEBUG_BOOL
		fprintf(stderr,"[%d] %c\n",i,item_type(items[i].cmd,items[i].arg));
#endif
		switch(c=items[i].cmd){
			case UDM_STACK_RIGHT:
				/* Perform till LEFT bracket */
				while((TOPCMD(&s)!=UDM_STACK_LEFT)&&(TOPCMD(&s)!=UDM_STACK_BOT))
					perform(&s,POPCMD(&s));
				/* Pop LEFT bracket itself */
				if(TOPCMD(&s)==UDM_STACK_LEFT)
					POPCMD(&s);
				break;
			case UDM_STACK_OR:
			case UDM_STACK_AND:
				while(c<=TOPCMD(&s)){
					perform(&s,POPCMD(&s));
				}
				/* IMPORTANT! No break here! That's OK*/
				/*   ! */
			case UDM_STACK_LEFT:
			case UDM_STACK_NOT:
				PUSHCMD(&s,c);
				break;
			case UDM_STACK_WORD:
			default:
				PUSHARG(&s,items[i].arg);
				break;
		}
	}
	while(TOPCMD(&s)!=UDM_STACK_BOT){
		perform(&s,POPCMD(&s));
	}
	res=POPARG(&s);
	return(res);
}
