#ifndef _UDM_CONF_H
#define _UDM_CONF_H

/* Allow/Disallow/CheckOnly constants*/

#define UDM_NOTFOUND	0
#define UDM_ALLOW	1
#define UDM_DISALLOW	2
#define UDM_HEAD	3
#define UDM_HREFONLY	4

/* Aliases item structure */
typedef struct alias_struct {
	char *find;
	char *replace;
} UDM_ALIAS;

extern int		UdmInit();
extern int		UdmFilterType(char * param, char *reason);
extern int		UdmMaxDocSize();

extern UDM_SERVER	* UdmFindServer(char *url);
extern UDM_ALIAS	* UdmFindAlias(char * str);
extern char		* UdmExtraHeaders();
extern char		* UdmUserAgent();

extern __INDLIB__ int	UdmLoadConfig(char *conf_name,int config_level,int load_flags);
extern __INDLIB__ char* UdmConfErrMsg();
extern __INDLIB__ int	UdmSetDBAddr(char * str);
extern __INDLIB__ int	UdmSetDBMode(char * str);
extern __INDLIB__ int   UdmSetDBType(char *str);
extern __INDLIB__ int   UdmSetTrackMode(int mode);


/* Database parameters */
extern char *DBHost;		/* EXT */
extern char *DBName;		/* EXT */
extern char *DBUser;		/* EXT */
extern char *DBPass;		/* EXT */
extern int  DBPort;		/* EXT */
extern int  DBType;		/* EXT */
extern int  DBMode;		/* EXT */
extern int  DBUseLock;		/* EXT */
extern int Force1251;		/* EXT */
extern int TrackMode;		/* EXT */


#endif
