//@ Initialization
||

//@<OUT> DocResult help
NAME
      DocResult - Allows traversing the DbDoc objects returned by a
                  Collection.find operation.

DESCRIPTION
      Allows traversing the DbDoc objects returned by a Collection.find
      operation.

PROPERTIES
      affectedItemsCount
            Same as getAffectedItemsCount

      executionTime
            Same as getExecutionTime

      warningCount
            Same as getWarningCount

            ATTENTION: This property will be removed in a future release, use
                       the warningsCount property instead.

      warnings
            Same as getWarnings

      warningsCount
            Same as getWarningsCount

FUNCTIONS
      fetchAll()
            Returns a list of DbDoc objects which contains an element for every
            unread document.

      fetchOne()
            Retrieves the next DbDoc on the DocResult.

      getAffectedItemsCount()
            The the number of affected items for the last operation.

      getExecutionTime()
            Retrieves a string value indicating the execution time of the
            executed operation.

      getWarningCount()
            The number of warnings produced by the last statement execution.

            ATTENTION: This function will be removed in a future release, use
                       the getWarningsCount function instead.

      getWarnings()
            Retrieves the warnings generated by the executed operation.

      getWarningsCount()
            The number of warnings produced by the last statement execution.

      help([member])
            Provides help about this class and it's members

//@<OUT> Help on affectedItemsCount
NAME
      affectedItemsCount - Same as getAffectedItemsCount

SYNTAX
      <DocResult>.affectedItemsCount

//@<OUT> Help on executionTime
NAME
      executionTime - Same as getExecutionTime

SYNTAX
      <DocResult>.executionTime

//@<OUT> Help on warningCount
NAME
      warningCount - Same as getWarningCount

SYNTAX
      <DocResult>.warningCount

DESCRIPTION
      ATTENTION: This property will be removed in a future release, use the
                 warningsCount property instead.

//@<OUT> Help on warnings
NAME
      warnings - Same as getWarnings

SYNTAX
      <DocResult>.warnings

//@<OUT> Help on warningsCount
NAME
      warningsCount - Same as getWarningsCount

SYNTAX
      <DocResult>.warningsCount

//@<OUT> Help on fetchAll
NAME
      fetchAll - Returns a list of DbDoc objects which contains an element for
                 every unread document.

SYNTAX
      <DocResult>.fetchAll()

RETURNS
       A List of DbDoc objects.

DESCRIPTION
      If this function is called right after executing a query, it will return
      a DbDoc for every document on the resultset.

      If fetchOne is called before this function, when this function is called
      it will return a DbDoc for each of the remaining documents on the
      resultset.

//@<OUT> Help on fetchOne
NAME
      fetchOne - Retrieves the next DbDoc on the DocResult.

SYNTAX
      <DocResult>.fetchOne()

RETURNS
       A DbDoc object representing the next Document in the result.

//@<OUT> Help on getAffectedItemsCount
NAME
      getAffectedItemsCount - The the number of affected items for the last
                              operation.

SYNTAX
      <DocResult>.getAffectedItemsCount()

RETURNS
       the number of affected items.

DESCRIPTION
      Returns the number of records affected by the executed operation

//@<OUT> Help on getExecutionTime
NAME
      getExecutionTime - Retrieves a string value indicating the execution time
                         of the executed operation.

SYNTAX
      <DocResult>.getExecutionTime()

//@<OUT> Help on getWarningCount
NAME
      getWarningCount - The number of warnings produced by the last statement
                        execution.

SYNTAX
      <DocResult>.getWarningCount()

RETURNS
       the number of warnings.

DESCRIPTION
      This is the same value than C API mysql_warning_count, see
      https://dev.mysql.com/doc/refman/en/mysql-warning-count.html

      See getWarnings() for more details.

      ATTENTION: This function will be removed in a future release, use the
                 getWarningsCount function instead.

//@<OUT> Help on getWarnings
NAME
      getWarnings - Retrieves the warnings generated by the executed operation.

SYNTAX
      <DocResult>.getWarnings()

RETURNS
       A list containing a warning object for each generated warning.

DESCRIPTION
      This is the same value than C API mysql_warning_count, see
      https://dev.mysql.com/doc/refman/en/mysql-warning-count.html

      Each warning object contains a key/value pair describing the information
      related to a specific warning.

      This information includes: Level, Code and Message.

//@<OUT> Help on getWarningsCount
NAME
      getWarningsCount - The number of warnings produced by the last statement
                         execution.

SYNTAX
      <DocResult>.getWarningsCount()

RETURNS
       the number of warnings.

DESCRIPTION
      This is the same value than C API mysql_warning_count, see
      https://dev.mysql.com/doc/refman/en/mysql-warning-count.html

      See getWarnings() for more details.

//@<OUT> Help on help
NAME
      help - Provides help about this class and it's members

SYNTAX
      <DocResult>.help([member])

WHERE
      member: If specified, provides detailed information on the given member.

//@ Finalization
||
