//@ Initialization
||

//@<OUT> Result help
NAME
      Result - Allows retrieving information about non query operations
               performed on the database.

DESCRIPTION
      An instance of this class will be returned on the CRUD operations that
      change the content of the database:

      - On Table: insert, update and delete
      - On Collection: add, modify and remove

      Other functions on the Session class also return an instance of this
      class:

      - Transaction handling functions
      - Transaction handling functions

PROPERTIES
      affectedItemCount
            Same as getAffectedItemCount

            ATTENTION: This property will be removed in a future release, use
                       the affectedItemsCount property instead.

      affectedItemsCount
            Same as getAffectedItemsCount

      autoIncrementValue
            Same as getAutoIncrementValue

      executionTime
            Same as getExecutionTime

      generatedIds
            Same as getGeneratedIds.

      warningCount
            Same as getWarningCount

            ATTENTION: This property will be removed in a future release, use
                       the warningsCount property instead.

      warnings
            Same as getWarnings

      warningsCount
            Same as getWarningsCount

FUNCTIONS
      getAffectedItemCount()
            The the number of affected items for the last operation.

            ATTENTION: This function will be removed in a future release, use
                       the getAffectedItemsCount function instead.

      getAffectedItemsCount()
            The the number of affected items for the last operation.

      getAutoIncrementValue()
            The last insert id auto generated (from an insert operation)

      getExecutionTime()
            Retrieves a string value indicating the execution time of the
            executed operation.

      getGeneratedIds()
            Returns the list of document ids generated on the server.

      getWarningCount()
            The number of warnings produced by the last statement execution.

            ATTENTION: This function will be removed in a future release, use
                       the getWarningsCount function instead.

      getWarnings()
            Retrieves the warnings generated by the executed operation.

      getWarningsCount()
            The number of warnings produced by the last statement execution.

      help([member])
            Provides help about this class and it's members

//@<OUT> Help on affectedItemCount
NAME
      affectedItemCount - Same as getAffectedItemCount

SYNTAX
      <Result>.affectedItemCount

DESCRIPTION
      ATTENTION: This property will be removed in a future release, use the
                 affectedItemsCount property instead.

//@<OUT> Help on affectedItemsCount
NAME
      affectedItemsCount - Same as getAffectedItemsCount

SYNTAX
      <Result>.affectedItemsCount

//@<OUT> Help on autoIncrementValue
NAME
      autoIncrementValue - Same as getAutoIncrementValue

SYNTAX
      <Result>.autoIncrementValue

//@<OUT> Help on executionTime
NAME
      executionTime - Same as getExecutionTime

SYNTAX
      <Result>.executionTime

//@<OUT> Help on generatedIds
NAME
      generatedIds - Same as getGeneratedIds.

SYNTAX
      <Result>.generatedIds

//@<OUT> Help on warningCount
NAME
      warningCount - Same as getWarningCount

SYNTAX
      <Result>.warningCount

DESCRIPTION
      ATTENTION: This property will be removed in a future release, use the
                 warningsCount property instead.

//@<OUT> Help on warningsCount
NAME
      warningsCount - Same as getWarningsCount

SYNTAX
      <Result>.warningsCount

//@<OUT> Help on warnings
NAME
      warnings - Same as getWarnings

SYNTAX
      <Result>.warnings

//@<OUT> Help on getAffectedItemCount
NAME
      getAffectedItemCount - The the number of affected items for the last
                             operation.

SYNTAX
      <Result>.getAffectedItemCount()

RETURNS
       the number of affected items.

DESCRIPTION
      This is the value of the C API mysql_affected_rows(), see
      https://dev.mysql.com/doc/refman/en/mysql-affected-rows.html

      ATTENTION: This function will be removed in a future release, use the
                 getAffectedItemsCount function instead.

//@<OUT> Help on getAffectedItemsCount
NAME
      getAffectedItemsCount - The the number of affected items for the last
                              operation.

SYNTAX
      <Result>.getAffectedItemsCount()

RETURNS
       the number of affected items.

DESCRIPTION
      Returns the number of records affected by the executed operation

//@<OUT> Help on getAutoIncrementValue
NAME
      getAutoIncrementValue - The last insert id auto generated (from an insert
                              operation)

SYNTAX
      <Result>.getAutoIncrementValue()

RETURNS
       the integer representing the last insert id

DESCRIPTION
      For more details, see
      https://dev.mysql.com/doc/refman/en/information-functions.html#function_last-insert-id

      Note that this value will be available only when the result is for a
      Table.insert operation.

//@<OUT> Help on getExecutionTime
NAME
      getExecutionTime - Retrieves a string value indicating the execution time
                         of the executed operation.

SYNTAX
      <Result>.getExecutionTime()

//@<OUT> Help on getGeneratedIds
NAME
      getGeneratedIds - Returns the list of document ids generated on the
                        server.

SYNTAX
      <Result>.getGeneratedIds()

RETURNS
       a list of strings containing the generated ids.

DESCRIPTION
      When adding documents into a collection, it is required that an ID is
      associated to the document, if a document is added without an '_id'
      field, an error will be generated.

      At MySQL 8.0.11 if the documents being added do not have an '_id' field,
      the server will automatically generate an ID and assign it to the
      document.

      This function returns a list of the IDs that were generated for the
      server to satisfy this requirement.

//@<OUT> Help on getWarningCount
NAME
      getWarningCount - The number of warnings produced by the last statement
                        execution.

SYNTAX
      <Result>.getWarningCount()

RETURNS
       the number of warnings.

DESCRIPTION
      This is the same value than C API mysql_warning_count, see
      https://dev.mysql.com/doc/refman/en/mysql-warning-count.html

      See getWarnings() for more details.

      ATTENTION: This function will be removed in a future release, use the
                 getWarningsCount function instead.

//@<OUT> Help on getWarningsCount
NAME
      getWarningsCount - The number of warnings produced by the last statement
                         execution.

SYNTAX
      <Result>.getWarningsCount()

RETURNS
       the number of warnings.

DESCRIPTION
      This is the same value than C API mysql_warning_count, see
      https://dev.mysql.com/doc/refman/en/mysql-warning-count.html

      See getWarnings() for more details.

//@<OUT> Help on getWarnings
NAME
      getWarnings - Retrieves the warnings generated by the executed operation.

SYNTAX
      <Result>.getWarnings()

RETURNS
       A list containing a warning object for each generated warning.

DESCRIPTION
      This is the same value than C API mysql_warning_count, see
      https://dev.mysql.com/doc/refman/en/mysql-warning-count.html

      Each warning object contains a key/value pair describing the information
      related to a specific warning.

      This information includes: Level, Code and Message.

//@<OUT> Help on help
NAME
      help - Provides help about this class and it's members

SYNTAX
      <Result>.help([member])

WHERE
      member: If specified, provides detailed information on the given member.

//@ Finalization
||
