//@ Test Schema Creation
||

//@<OUT> X Table Format
+-------+
| data  |
+-------+
| ab cd |
| ab	cd |
| ab
cd |
+-------+


//@<OUT> X Vertical Format
*************************** 1. row ***************************
data: ab cd
*************************** 2. row ***************************
data: ab	cd
*************************** 3. row ***************************
data: ab
cd


//@<OUT> X Tabbed Format
data
ab\0cd
ab\tcd
ab\ncd

//@<OUT> X Json Format
{
    "data": "ab\u0000cd"
}
{
    "data": "ab\tcd"
}
{
    "data": "ab\ncd"
}
3 rows in set ([[*]] sec)

//@<OUT> X Raw Json Format
{"data":"ab\u0000cd"}
{"data":"ab\tcd"}
{"data":"ab\ncd"}
3 rows in set ([[*]] sec)

//@<OUT> X Json Wrapping
{
    "hasData": true,
    "rows": [
        {
            "data": "ab\u0000cd"
        },
        {
            "data": "ab\tcd"
        },
        {
            "data": "ab\ncd"
        }
    ],
    "executionTime": "[[*]] sec",
    "affectedRowCount": 0,
    "affectedItemsCount": 0,
    "warningCount": 0,
    "warningsCount": 0,
    "warnings": [],
    "info": "",
    "autoIncrementValue": 0
}

//@<OUT> Classic Table Format
+-------+
| data  |
+-------+
| ab cd |
| ab	cd |
| ab
cd |
+-------+

//@<OUT> Classic Vertical Format
*************************** 1. row ***************************
data: ab cd
*************************** 2. row ***************************
data: ab	cd
*************************** 3. row ***************************
data: ab
cd

//@<OUT> Classic Tabbed Format
data
ab\0cd
ab\tcd
ab\ncd

//@<OUT> Classic Json Format
{
    "data": "ab\u0000cd"
}
{
    "data": "ab\tcd"
}
{
    "data": "ab\ncd"
}
3 rows in set ([[*]] sec)

//@<OUT> Classic Raw Json Format
{"data":"ab\u0000cd"}
{"data":"ab\tcd"}
{"data":"ab\ncd"}
3 rows in set ([[*]] sec)

//@<OUT> Classic Json Wrapping
{
    "hasData": true,
    "rows": [
        {
            "data": "ab\u0000cd"
        },
        {
            "data": "ab\tcd"
        },
        {
            "data": "ab\ncd"
        }
    ],
    "executionTime": "[[*]] sec",
    "affectedRowCount": 0,
    "affectedItemsCount": 0,
    "warningCount": 0,
    "warningsCount": 0,
    "warnings": [],
    "info": "",
    "autoIncrementValue": 0
}


//@<OUT> table in table format {__os_type != "windows"}
+---------------------------+
| data                      |
+---------------------------+
| 生活是美好的 生活是美好的 |
| 辛德勒的名单 辛德勒的名单 |
| 指環王 指環王             |
| 尋找尼莫 尋找尼莫         |
| 😁😍😠 😭🙅🙉                   |
| ✅✨✋ ✈❄❔➗                  |
| 🚀🚑 🚙🚬🚻🛀                   |
| 🇯🇵🈳🆕🆒                     |
| ®7⃣⏰☕♒♣ ⛽🌄🌠🎨🐍🐾             |
+---------------------------+

//@<OUT> table in table format {__os_type == "windows"}
+---------------------------+
| data                      |
+---------------------------+
| 生活是美好的 生活是美好的 |
| 辛德勒的名单 辛德勒的名单 |
| 指環王 指環王             |
| 尋找尼莫 尋找尼莫         |
| 😁😍😠 😭🙅🙉             |
| ✅✨✋ ✈❄❔➗                  |
| 🚀🚑 🚙🚬🚻🛀             |
| 🇯🇵🈳🆕🆒                |
| ®7⃣⏰☕♒♣ ⛽🌄🌠🎨🐍🐾        |
+---------------------------+

//@<OUT> table in tabbed format
data
生活是美好的\0生活是美好的
辛德勒的名单\0辛德勒的名单
指環王\0指環王
尋找尼莫\0尋找尼莫
😁😍😠\0😭🙅🙉
✅✨✋\0✈❄❔➗
🚀🚑\0🚙🚬🚻🛀
🇯🇵🈳🆕🆒
®7⃣⏰☕♒♣\0⛽🌄🌠🎨🐍🐾


//@<OUT> table in vertical format
*************************** 1. row ***************************
data: 生活是美好的 生活是美好的
*************************** 2. row ***************************
data: 辛德勒的名单 辛德勒的名单
*************************** 3. row ***************************
data: 指環王 指環王
*************************** 4. row ***************************
data: 尋找尼莫 尋找尼莫
*************************** 5. row ***************************
data: 😁😍😠 😭🙅🙉
*************************** 6. row ***************************
data: ✅✨✋ ✈❄❔➗
*************************** 7. row ***************************
data: 🚀🚑 🚙🚬🚻🛀
*************************** 8. row ***************************
data: 🇯🇵🈳🆕🆒
*************************** 9. row ***************************
data: ®7⃣⏰☕♒♣ ⛽🌄🌠🎨🐍🐾


//@<OUT> Pulling as collection in JSON format
{
    "_id": "1",
    "name": "生活是美好的",
    "year": 1997
}
{
    "_id": "10",
    "name": "®7⃣⏰☕♒♣⛽🌄🌠🎨🐍🐾",
    "year": 2004
}
{
    "_id": "2",
    "name": "辛德勒的名单",
    "year": 1993
}
{
    "_id": "3",
    "name": "指環王",
    "year": 2001
}
{
    "_id": "4",
    "name": "尋找尼莫",
    "year": 2003
}
{
    "_id": "5",
    "name": "الجنة الآن",
    "year": 2003
}
{
    "_id": "6",
    "name": "😁😍😠😭🙅🙉",
    "year": 2004
}
{
    "_id": "7",
    "name": "✅✨✋✈❄❔➗",
    "year": 2004
}
{
    "_id": "8",
    "name": "🚀🚑🚙🚬🚻🛀",
    "year": 2004
}
{
    "_id": "9",
    "name": "🇯🇵🈳🆕🆒",
    "year": 2004
}


//@<OUT> pulling as table in table format {__os_type != "windows"}
+-----------------------------------------------------+-----+
| doc                                                 | _id |
+-----------------------------------------------------+-----+
| {"_id": "1", "name": "生活是美好的", "year": 1997}  | 1   |
| {"_id": "10", "name": "®7⃣⏰☕♒♣⛽🌄🌠🎨🐍🐾", "year": 2004} | 10  |
| {"_id": "2", "name": "辛德勒的名单", "year": 1993}  | 2   |
| {"_id": "3", "name": "指環王", "year": 2001}        | 3   |
| {"_id": "4", "name": "尋找尼莫", "year": 2003}      | 4   |
| {"_id": "5", "name": "الجنة الآن", "year": 2003}    | 5   |
| {"_id": "6", "name": "😁😍😠😭🙅🙉", "year": 2004}        | 6   |
| {"_id": "7", "name": "✅✨✋✈❄❔➗", "year": 2004}       | 7   |
| {"_id": "8", "name": "🚀🚑🚙🚬🚻🛀", "year": 2004}        | 8   |
| {"_id": "9", "name": "🇯🇵🈳🆕🆒", "year": 2004}         | 9   |
+-----------------------------------------------------+-----+

//@<OUT> pulling as table in table format {__os_type == "windows"}
+----------------------------------------------------------+-----+
| doc                                                      | _id |
+----------------------------------------------------------+-----+
| {"_id": "1", "name": "生活是美好的", "year": 1997}       | 1   |
| {"_id": "10", "name": "®7⃣⏰☕♒♣⛽🌄🌠🎨🐍🐾", "year": 2004} | 10  |
| {"_id": "2", "name": "辛德勒的名单", "year": 1993}       | 2   |
| {"_id": "3", "name": "指環王", "year": 2001}             | 3   |
| {"_id": "4", "name": "尋找尼莫", "year": 2003}           | 4   |
| {"_id": "5", "name": "الجنة الآن", "year": 2003}         | 5   |
| {"_id": "6", "name": "😁😍😠😭🙅🙉", "year": 2004}       | 6   |
| {"_id": "7", "name": "✅✨✋✈❄❔➗", "year": 2004}            | 7   |
| {"_id": "8", "name": "🚀🚑🚙🚬🚻🛀", "year": 2004}       | 8   |
| {"_id": "9", "name": "🇯🇵🈳🆕🆒", "year": 2004}         | 9   |
+----------------------------------------------------------+-----+

//@<OUT> pulling as table in tabbed format
{"_id": "1", "name": "生活是美好的", "year": 1997}	1
{"_id": "10", "name": "®7⃣⏰☕♒♣⛽🌄🌠🎨🐍🐾", "year": 2004}	10
{"_id": "2", "name": "辛德勒的名单", "year": 1993}	2
{"_id": "3", "name": "指環王", "year": 2001}	3
{"_id": "4", "name": "尋找尼莫", "year": 2003}	4
{"_id": "5", "name": "الجنة الآن", "year": 2003}	5
{"_id": "6", "name": "😁😍😠😭🙅🙉", "year": 2004}	6
{"_id": "7", "name": "✅✨✋✈❄❔➗", "year": 2004}	7
{"_id": "8", "name": "🚀🚑🚙🚬🚻🛀", "year": 2004}	8
{"_id": "9", "name": "🇯🇵🈳🆕🆒", "year": 2004}	9

//@<OUT> pulling as table in vertical format
*************************** 1. row ***************************
doc: {"_id": "1", "name": "生活是美好的", "year": 1997}
_id: 1
*************************** 2. row ***************************
doc: {"_id": "10", "name": "®7⃣⏰☕♒♣⛽🌄🌠🎨🐍🐾", "year": 2004}
_id: 10
*************************** 3. row ***************************
doc: {"_id": "2", "name": "辛德勒的名单", "year": 1993}
_id: 2
*************************** 4. row ***************************
doc: {"_id": "3", "name": "指環王", "year": 2001}
_id: 3
*************************** 5. row ***************************
doc: {"_id": "4", "name": "尋找尼莫", "year": 2003}
_id: 4
*************************** 6. row ***************************
doc: {"_id": "5", "name": "الجنة الآن", "year": 2003}
_id: 5
*************************** 7. row ***************************
doc: {"_id": "6", "name": "😁😍😠😭🙅🙉", "year": 2004}
_id: 6
*************************** 8. row ***************************
doc: {"_id": "7", "name": "✅✨✋✈❄❔➗", "year": 2004}
_id: 7
*************************** 9. row ***************************
doc: {"_id": "8", "name": "🚀🚑🚙🚬🚻🛀", "year": 2004}
_id: 8
*************************** 10. row ***************************
doc: {"_id": "9", "name": "🇯🇵🈳🆕🆒", "year": 2004}
_id: 9
