#@ __global__
||

#@<OUT> docresult
NAME
      DocResult - Allows traversing the DbDoc objects returned by a
                  Collection.find operation.

DESCRIPTION
      Allows traversing the DbDoc objects returned by a Collection.find
      operation.

PROPERTIES
      affected_items_count
            Same as get_affected_items_count

      execution_time
            Same as get_execution_time

      warning_count
            Same as get_warning_count

            ATTENTION: This property will be removed in a future release, use
                       the warnings_count property instead.

      warnings
            Same as get_warnings

      warnings_count
            Same as get_warnings_count

FUNCTIONS
      fetch_all()
            Returns a list of DbDoc objects which contains an element for every
            unread document.

      fetch_one()
            Retrieves the next DbDoc on the DocResult.

      get_affected_items_count()
            The the number of affected items for the last operation.

      get_execution_time()
            Retrieves a string value indicating the execution time of the
            executed operation.

      get_warning_count()
            The number of warnings produced by the last statement execution.

            ATTENTION: This function will be removed in a future release, use
                       the get_warnings_count function instead.

      get_warnings()
            Retrieves the warnings generated by the executed operation.

      get_warnings_count()
            The number of warnings produced by the last statement execution.

      help([member])
            Provides help about this class and it's members

#@<OUT> docresult.affected_items_count
NAME
      affected_items_count - Same as get_affected_items_count

SYNTAX
      <DocResult>.affected_items_count

#@<OUT> docresult.execution_time
NAME
      execution_time - Same as get_execution_time

SYNTAX
      <DocResult>.execution_time

#@<OUT> docresult.fetch_all
NAME
      fetch_all - Returns a list of DbDoc objects which contains an element for
                  every unread document.

SYNTAX
      <DocResult>.fetch_all()

RETURNS
       A List of DbDoc objects.

DESCRIPTION
      If this function is called right after executing a query, it will return
      a DbDoc for every document on the resultset.

      If fetchOne is called before this function, when this function is called
      it will return a DbDoc for each of the remaining documents on the
      resultset.

#@<OUT> docresult.fetch_one
NAME
      fetch_one - Retrieves the next DbDoc on the DocResult.

SYNTAX
      <DocResult>.fetch_one()

RETURNS
       A DbDoc object representing the next Document in the result.

#@<OUT> docresult.get_affected_items_count
NAME
      get_affected_items_count - The the number of affected items for the last
                                 operation.

SYNTAX
      <DocResult>.get_affected_items_count()

RETURNS
       the number of affected items.

DESCRIPTION
      Returns the number of records affected by the executed operation

#@<OUT> docresult.get_execution_time
NAME
      get_execution_time - Retrieves a string value indicating the execution
                           time of the executed operation.

SYNTAX
      <DocResult>.get_execution_time()

#@<OUT> docresult.get_warning_count
NAME
      get_warning_count - The number of warnings produced by the last statement
                          execution.

SYNTAX
      <DocResult>.get_warning_count()

RETURNS
       the number of warnings.

DESCRIPTION
      This is the same value than C API mysql_warning_count, see
      https://dev.mysql.com/doc/refman/en/mysql-warning-count.html

      See get_warnings() for more details.

      ATTENTION: This function will be removed in a future release, use the
                 get_warnings_count function instead.

#@<OUT> docresult.get_warnings
NAME
      get_warnings - Retrieves the warnings generated by the executed
                     operation.

SYNTAX
      <DocResult>.get_warnings()

RETURNS
       A list containing a warning object for each generated warning.

DESCRIPTION
      This is the same value than C API mysql_warning_count, see
      https://dev.mysql.com/doc/refman/en/mysql-warning-count.html

      Each warning object contains a key/value pair describing the information
      related to a specific warning.

      This information includes: Level, Code and Message.

#@<OUT> docresult.get_warnings_count
NAME
      get_warnings_count - The number of warnings produced by the last
                           statement execution.

SYNTAX
      <DocResult>.get_warnings_count()

RETURNS
       the number of warnings.

DESCRIPTION
      This is the same value than C API mysql_warning_count, see
      https://dev.mysql.com/doc/refman/en/mysql-warning-count.html

      See get_warnings() for more details.

#@<OUT> docresult.help
NAME
      help - Provides help about this class and it's members

SYNTAX
      <DocResult>.help([member])

WHERE
      member: If specified, provides detailed information on the given member.

#@<OUT> docresult.warning_count
NAME
      warning_count - Same as get_warning_count

SYNTAX
      <DocResult>.warning_count

DESCRIPTION
      ATTENTION: This property will be removed in a future release, use the
                 warnings_count property instead.

#@<OUT> docresult.warnings
NAME
      warnings - Same as get_warnings

SYNTAX
      <DocResult>.warnings

#@<OUT> docresult.warnings_count
NAME
      warnings_count - Same as get_warnings_count

SYNTAX
      <DocResult>.warnings_count
