# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AuthorizeScopePolicy(object):
    """
    If authentication has been performed, validate that the given scope is active for the request.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AuthorizeScopePolicy object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param allowed_scope:
            The value to assign to the allowed_scope property of this AuthorizeScopePolicy.
        :type allowed_scope: list[str]

        """
        self.swagger_types = {
            'allowed_scope': 'list[str]'
        }

        self.attribute_map = {
            'allowed_scope': 'allowedScope'
        }

        self._allowed_scope = None

    @property
    def allowed_scope(self):
        """
        Gets the allowed_scope of this AuthorizeScopePolicy.
        A user whose scope includes any of these access ranges is allowed on
        this route. Access ranges are case-sensitive.


        :return: The allowed_scope of this AuthorizeScopePolicy.
        :rtype: list[str]
        """
        return self._allowed_scope

    @allowed_scope.setter
    def allowed_scope(self, allowed_scope):
        """
        Sets the allowed_scope of this AuthorizeScopePolicy.
        A user whose scope includes any of these access ranges is allowed on
        this route. Access ranges are case-sensitive.


        :param allowed_scope: The allowed_scope of this AuthorizeScopePolicy.
        :type: list[str]
        """
        self._allowed_scope = allowed_scope

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
