# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.

from __future__ import absolute_import

from .batch_instance import BatchInstance
from .batch_instance_summary import BatchInstanceSummary
from .compute_environment import ComputeEnvironment
from .compute_environment_summary import ComputeEnvironmentSummary
from .create_batch_instance_details import CreateBatchInstanceDetails
from .create_compute_environment_details import CreateComputeEnvironmentDetails
from .create_job_definition_details import CreateJobDefinitionDetails
from .create_job_definition_details_environment_variables import CreateJobDefinitionDetailsEnvironmentVariables
from .create_job_details import CreateJobDetails
from .job import Job
from .job_definition import JobDefinition
from .job_definition_summary import JobDefinitionSummary
from .job_summary import JobSummary
from .log_summary import LogSummary
from .update_batch_instance_details import UpdateBatchInstanceDetails
from .update_compute_environment_details import UpdateComputeEnvironmentDetails
from .update_job_definition_details import UpdateJobDefinitionDetails
from .update_job_details import UpdateJobDetails

# Maps type names to classes for batch services.
batch_type_mapping = {
    "BatchInstance": BatchInstance,
    "BatchInstanceSummary": BatchInstanceSummary,
    "ComputeEnvironment": ComputeEnvironment,
    "ComputeEnvironmentSummary": ComputeEnvironmentSummary,
    "CreateBatchInstanceDetails": CreateBatchInstanceDetails,
    "CreateComputeEnvironmentDetails": CreateComputeEnvironmentDetails,
    "CreateJobDefinitionDetails": CreateJobDefinitionDetails,
    "CreateJobDefinitionDetailsEnvironmentVariables": CreateJobDefinitionDetailsEnvironmentVariables,
    "CreateJobDetails": CreateJobDetails,
    "Job": Job,
    "JobDefinition": JobDefinition,
    "JobDefinitionSummary": JobDefinitionSummary,
    "JobSummary": JobSummary,
    "LogSummary": LogSummary,
    "UpdateBatchInstanceDetails": UpdateBatchInstanceDetails,
    "UpdateComputeEnvironmentDetails": UpdateComputeEnvironmentDetails,
    "UpdateJobDefinitionDetails": UpdateJobDefinitionDetails,
    "UpdateJobDetails": UpdateJobDetails
}
