# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BatchInstance(object):
    """
    batch instance
    """

    #: A constant which can be used with the lifecycle_state property of a BatchInstance.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a BatchInstance.
    #: This constant has a value of "DISABLING"
    LIFECYCLE_STATE_DISABLING = "DISABLING"

    #: A constant which can be used with the lifecycle_state property of a BatchInstance.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a BatchInstance.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new BatchInstance object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this BatchInstance.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this BatchInstance.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this BatchInstance.
        :type compartment_id: str

        :param cluster_id:
            The value to assign to the cluster_id property of this BatchInstance.
        :type cluster_id: str

        :param created_by_user_id:
            The value to assign to the created_by_user_id property of this BatchInstance.
        :type created_by_user_id: str

        :param deleted_by_user_id:
            The value to assign to the deleted_by_user_id property of this BatchInstance.
        :type deleted_by_user_id: str

        :param namespace:
            The value to assign to the namespace property of this BatchInstance.
        :type namespace: str

        :param time_created:
            The value to assign to the time_created property of this BatchInstance.
        :type time_created: datetime

        :param time_deleted:
            The value to assign to the time_deleted property of this BatchInstance.
        :type time_deleted: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this BatchInstance.
            Allowed values for this property are: "ACTIVE", "DISABLING", "INACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param modified_by_user_id:
            The value to assign to the modified_by_user_id property of this BatchInstance.
        :type modified_by_user_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this BatchInstance.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this BatchInstance.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'cluster_id': 'str',
            'created_by_user_id': 'str',
            'deleted_by_user_id': 'str',
            'namespace': 'str',
            'time_created': 'datetime',
            'time_deleted': 'datetime',
            'lifecycle_state': 'str',
            'modified_by_user_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'cluster_id': 'clusterId',
            'created_by_user_id': 'createdByUserId',
            'deleted_by_user_id': 'deletedByUserId',
            'namespace': 'namespace',
            'time_created': 'timeCreated',
            'time_deleted': 'timeDeleted',
            'lifecycle_state': 'lifecycleState',
            'modified_by_user_id': 'modifiedByUserId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._cluster_id = None
        self._created_by_user_id = None
        self._deleted_by_user_id = None
        self._namespace = None
        self._time_created = None
        self._time_deleted = None
        self._lifecycle_state = None
        self._modified_by_user_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def id(self):
        """
        Gets the id of this BatchInstance.
        The OCID of the batch instance.


        :return: The id of this BatchInstance.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this BatchInstance.
        The OCID of the batch instance.


        :param id: The id of this BatchInstance.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this BatchInstance.
        The name of the batch instance.


        :return: The display_name of this BatchInstance.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this BatchInstance.
        The name of the batch instance.


        :param display_name: The display_name of this BatchInstance.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this BatchInstance.
        The OCID of the compartment.


        :return: The compartment_id of this BatchInstance.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this BatchInstance.
        The OCID of the compartment.


        :param compartment_id: The compartment_id of this BatchInstance.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def cluster_id(self):
        """
        Gets the cluster_id of this BatchInstance.
        The OCID of the cluster.


        :return: The cluster_id of this BatchInstance.
        :rtype: str
        """
        return self._cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):
        """
        Sets the cluster_id of this BatchInstance.
        The OCID of the cluster.


        :param cluster_id: The cluster_id of this BatchInstance.
        :type: str
        """
        self._cluster_id = cluster_id

    @property
    def created_by_user_id(self):
        """
        Gets the created_by_user_id of this BatchInstance.
        The user OCID who created the batch instance.


        :return: The created_by_user_id of this BatchInstance.
        :rtype: str
        """
        return self._created_by_user_id

    @created_by_user_id.setter
    def created_by_user_id(self, created_by_user_id):
        """
        Sets the created_by_user_id of this BatchInstance.
        The user OCID who created the batch instance.


        :param created_by_user_id: The created_by_user_id of this BatchInstance.
        :type: str
        """
        self._created_by_user_id = created_by_user_id

    @property
    def deleted_by_user_id(self):
        """
        Gets the deleted_by_user_id of this BatchInstance.
        The user OCID who deleted the batch instance.


        :return: The deleted_by_user_id of this BatchInstance.
        :rtype: str
        """
        return self._deleted_by_user_id

    @deleted_by_user_id.setter
    def deleted_by_user_id(self, deleted_by_user_id):
        """
        Sets the deleted_by_user_id of this BatchInstance.
        The user OCID who deleted the batch instance.


        :param deleted_by_user_id: The deleted_by_user_id of this BatchInstance.
        :type: str
        """
        self._deleted_by_user_id = deleted_by_user_id

    @property
    def namespace(self):
        """
        Gets the namespace of this BatchInstance.
        The Kubernetes namespace containing the batch instance.


        :return: The namespace of this BatchInstance.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this BatchInstance.
        The Kubernetes namespace containing the batch instance.


        :param namespace: The namespace of this BatchInstance.
        :type: str
        """
        self._namespace = namespace

    @property
    def time_created(self):
        """
        Gets the time_created of this BatchInstance.
        The date and time the batch instance was created. Format defined by RFC3339.


        :return: The time_created of this BatchInstance.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this BatchInstance.
        The date and time the batch instance was created. Format defined by RFC3339.


        :param time_created: The time_created of this BatchInstance.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_deleted(self):
        """
        Gets the time_deleted of this BatchInstance.
        The date and time the batch instance was deleted. Format defined by RFC3339.


        :return: The time_deleted of this BatchInstance.
        :rtype: datetime
        """
        return self._time_deleted

    @time_deleted.setter
    def time_deleted(self, time_deleted):
        """
        Sets the time_deleted of this BatchInstance.
        The date and time the batch instance was deleted. Format defined by RFC3339.


        :param time_deleted: The time_deleted of this BatchInstance.
        :type: datetime
        """
        self._time_deleted = time_deleted

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this BatchInstance.
        The current state of the batch instance.
        - ACTIVE state means the batch instance is ready for customer to use.
        - DISABLING is in process of disable, it is a transient state on the way to INACTIVE, the batch instance is
        in read-only mode, not allow any resource creation (compute environment, job definition, job).
        - INACTIVE means the batch instance is in read-only mode, all job finished in the batch instance,
        ready for delete.
        - DELETED means cascade delete the batch instance's resources.

        Allowed values for this property are: "ACTIVE", "DISABLING", "INACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this BatchInstance.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this BatchInstance.
        The current state of the batch instance.
        - ACTIVE state means the batch instance is ready for customer to use.
        - DISABLING is in process of disable, it is a transient state on the way to INACTIVE, the batch instance is
        in read-only mode, not allow any resource creation (compute environment, job definition, job).
        - INACTIVE means the batch instance is in read-only mode, all job finished in the batch instance,
        ready for delete.
        - DELETED means cascade delete the batch instance's resources.


        :param lifecycle_state: The lifecycle_state of this BatchInstance.
        :type: str
        """
        allowed_values = ["ACTIVE", "DISABLING", "INACTIVE", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def modified_by_user_id(self):
        """
        Gets the modified_by_user_id of this BatchInstance.
        The user OCID who modified the batch instance.


        :return: The modified_by_user_id of this BatchInstance.
        :rtype: str
        """
        return self._modified_by_user_id

    @modified_by_user_id.setter
    def modified_by_user_id(self, modified_by_user_id):
        """
        Sets the modified_by_user_id of this BatchInstance.
        The user OCID who modified the batch instance.


        :param modified_by_user_id: The modified_by_user_id of this BatchInstance.
        :type: str
        """
        self._modified_by_user_id = modified_by_user_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this BatchInstance.
        Free-form tags associated with this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this BatchInstance.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this BatchInstance.
        Free-form tags associated with this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this BatchInstance.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this BatchInstance.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this BatchInstance.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this BatchInstance.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this BatchInstance.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
