# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComputeEnvironment(object):
    """
    Compute environment is definition of nodepool, does NOT mean nodepool will
    be created immediately.
    """

    #: A constant which can be used with the lifecycle_state property of a ComputeEnvironment.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ComputeEnvironment.
    #: This constant has a value of "DISABLING"
    LIFECYCLE_STATE_DISABLING = "DISABLING"

    #: A constant which can be used with the lifecycle_state property of a ComputeEnvironment.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ComputeEnvironment.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new ComputeEnvironment object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ComputeEnvironment.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this ComputeEnvironment.
        :type display_name: str

        :param batch_instance_id:
            The value to assign to the batch_instance_id property of this ComputeEnvironment.
        :type batch_instance_id: str

        :param machine_image_name:
            The value to assign to the machine_image_name property of this ComputeEnvironment.
        :type machine_image_name: str

        :param shape_name:
            The value to assign to the shape_name property of this ComputeEnvironment.
        :type shape_name: str

        :param subnet_id:
            The value to assign to the subnet_id property of this ComputeEnvironment.
        :type subnet_id: str

        :param kube_version:
            The value to assign to the kube_version property of this ComputeEnvironment.
        :type kube_version: str

        :param time_created:
            The value to assign to the time_created property of this ComputeEnvironment.
        :type time_created: datetime

        :param created_by_user_id:
            The value to assign to the created_by_user_id property of this ComputeEnvironment.
        :type created_by_user_id: str

        :param modified_by_user_id:
            The value to assign to the modified_by_user_id property of this ComputeEnvironment.
        :type modified_by_user_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ComputeEnvironment.
            Allowed values for this property are: "ACTIVE", "DISABLING", "INACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param status_description:
            The value to assign to the status_description property of this ComputeEnvironment.
        :type status_description: str

        :param error_code:
            The value to assign to the error_code property of this ComputeEnvironment.
        :type error_code: str

        :param is_auto_scale_down:
            The value to assign to the is_auto_scale_down property of this ComputeEnvironment.
        :type is_auto_scale_down: bool

        :param ssh_public_key:
            The value to assign to the ssh_public_key property of this ComputeEnvironment.
        :type ssh_public_key: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ComputeEnvironment.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ComputeEnvironment.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'batch_instance_id': 'str',
            'machine_image_name': 'str',
            'shape_name': 'str',
            'subnet_id': 'str',
            'kube_version': 'str',
            'time_created': 'datetime',
            'created_by_user_id': 'str',
            'modified_by_user_id': 'str',
            'lifecycle_state': 'str',
            'status_description': 'str',
            'error_code': 'str',
            'is_auto_scale_down': 'bool',
            'ssh_public_key': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'batch_instance_id': 'batchInstanceId',
            'machine_image_name': 'machineImageName',
            'shape_name': 'shapeName',
            'subnet_id': 'subnetId',
            'kube_version': 'kubeVersion',
            'time_created': 'timeCreated',
            'created_by_user_id': 'createdByUserId',
            'modified_by_user_id': 'modifiedByUserId',
            'lifecycle_state': 'lifecycleState',
            'status_description': 'statusDescription',
            'error_code': 'errorCode',
            'is_auto_scale_down': 'isAutoScaleDown',
            'ssh_public_key': 'sshPublicKey',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._id = None
        self._display_name = None
        self._batch_instance_id = None
        self._machine_image_name = None
        self._shape_name = None
        self._subnet_id = None
        self._kube_version = None
        self._time_created = None
        self._created_by_user_id = None
        self._modified_by_user_id = None
        self._lifecycle_state = None
        self._status_description = None
        self._error_code = None
        self._is_auto_scale_down = None
        self._ssh_public_key = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def id(self):
        """
        Gets the id of this ComputeEnvironment.
        The OCID of the compute environment.


        :return: The id of this ComputeEnvironment.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ComputeEnvironment.
        The OCID of the compute environment.


        :param id: The id of this ComputeEnvironment.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this ComputeEnvironment.
        The name of the compute environment.


        :return: The display_name of this ComputeEnvironment.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ComputeEnvironment.
        The name of the compute environment.


        :param display_name: The display_name of this ComputeEnvironment.
        :type: str
        """
        self._display_name = display_name

    @property
    def batch_instance_id(self):
        """
        Gets the batch_instance_id of this ComputeEnvironment.
        The OCID of the batch instance.


        :return: The batch_instance_id of this ComputeEnvironment.
        :rtype: str
        """
        return self._batch_instance_id

    @batch_instance_id.setter
    def batch_instance_id(self, batch_instance_id):
        """
        Sets the batch_instance_id of this ComputeEnvironment.
        The OCID of the batch instance.


        :param batch_instance_id: The batch_instance_id of this ComputeEnvironment.
        :type: str
        """
        self._batch_instance_id = batch_instance_id

    @property
    def machine_image_name(self):
        """
        Gets the machine_image_name of this ComputeEnvironment.
        The machine image name.


        :return: The machine_image_name of this ComputeEnvironment.
        :rtype: str
        """
        return self._machine_image_name

    @machine_image_name.setter
    def machine_image_name(self, machine_image_name):
        """
        Sets the machine_image_name of this ComputeEnvironment.
        The machine image name.


        :param machine_image_name: The machine_image_name of this ComputeEnvironment.
        :type: str
        """
        self._machine_image_name = machine_image_name

    @property
    def shape_name(self):
        """
        Gets the shape_name of this ComputeEnvironment.
        The shape for compute environment


        :return: The shape_name of this ComputeEnvironment.
        :rtype: str
        """
        return self._shape_name

    @shape_name.setter
    def shape_name(self, shape_name):
        """
        Sets the shape_name of this ComputeEnvironment.
        The shape for compute environment


        :param shape_name: The shape_name of this ComputeEnvironment.
        :type: str
        """
        self._shape_name = shape_name

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this ComputeEnvironment.
        The OCID for subnet.


        :return: The subnet_id of this ComputeEnvironment.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this ComputeEnvironment.
        The OCID for subnet.


        :param subnet_id: The subnet_id of this ComputeEnvironment.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def kube_version(self):
        """
        Gets the kube_version of this ComputeEnvironment.
        Kubernetes version.


        :return: The kube_version of this ComputeEnvironment.
        :rtype: str
        """
        return self._kube_version

    @kube_version.setter
    def kube_version(self, kube_version):
        """
        Sets the kube_version of this ComputeEnvironment.
        Kubernetes version.


        :param kube_version: The kube_version of this ComputeEnvironment.
        :type: str
        """
        self._kube_version = kube_version

    @property
    def time_created(self):
        """
        Gets the time_created of this ComputeEnvironment.
        The date and time the compute environment was created. Format defined by RFC3339.


        :return: The time_created of this ComputeEnvironment.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ComputeEnvironment.
        The date and time the compute environment was created. Format defined by RFC3339.


        :param time_created: The time_created of this ComputeEnvironment.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def created_by_user_id(self):
        """
        Gets the created_by_user_id of this ComputeEnvironment.
        The user OCID who created the compute environment.


        :return: The created_by_user_id of this ComputeEnvironment.
        :rtype: str
        """
        return self._created_by_user_id

    @created_by_user_id.setter
    def created_by_user_id(self, created_by_user_id):
        """
        Sets the created_by_user_id of this ComputeEnvironment.
        The user OCID who created the compute environment.


        :param created_by_user_id: The created_by_user_id of this ComputeEnvironment.
        :type: str
        """
        self._created_by_user_id = created_by_user_id

    @property
    def modified_by_user_id(self):
        """
        Gets the modified_by_user_id of this ComputeEnvironment.
        The user OCID who modified the compute environment.


        :return: The modified_by_user_id of this ComputeEnvironment.
        :rtype: str
        """
        return self._modified_by_user_id

    @modified_by_user_id.setter
    def modified_by_user_id(self, modified_by_user_id):
        """
        Sets the modified_by_user_id of this ComputeEnvironment.
        The user OCID who modified the compute environment.


        :param modified_by_user_id: The modified_by_user_id of this ComputeEnvironment.
        :type: str
        """
        self._modified_by_user_id = modified_by_user_id

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this ComputeEnvironment.
        The current state of the compute environment.
        - ACTIVE state means the compute environment is ready to use, user can select
        the compute environment when submitting job.
        - DISABLING is in process of disable, it is a transient state on the way to INACTIVE, waiting for all running
        job complete in the compute environment, user can not select the compute environment when submitting job.
        - INACTIVE means user can not select the compute environment when submitting job,
        all job finished in the compute environment, ready for delete.
        - DELETED means cascade delete the compute environment's resource, including node pool, worker node.

        Allowed values for this property are: "ACTIVE", "DISABLING", "INACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ComputeEnvironment.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ComputeEnvironment.
        The current state of the compute environment.
        - ACTIVE state means the compute environment is ready to use, user can select
        the compute environment when submitting job.
        - DISABLING is in process of disable, it is a transient state on the way to INACTIVE, waiting for all running
        job complete in the compute environment, user can not select the compute environment when submitting job.
        - INACTIVE means user can not select the compute environment when submitting job,
        all job finished in the compute environment, ready for delete.
        - DELETED means cascade delete the compute environment's resource, including node pool, worker node.


        :param lifecycle_state: The lifecycle_state of this ComputeEnvironment.
        :type: str
        """
        allowed_values = ["ACTIVE", "DISABLING", "INACTIVE", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def status_description(self):
        """
        Gets the status_description of this ComputeEnvironment.
        Describe the backend operation details.


        :return: The status_description of this ComputeEnvironment.
        :rtype: str
        """
        return self._status_description

    @status_description.setter
    def status_description(self, status_description):
        """
        Sets the status_description of this ComputeEnvironment.
        Describe the backend operation details.


        :param status_description: The status_description of this ComputeEnvironment.
        :type: str
        """
        self._status_description = status_description

    @property
    def error_code(self):
        """
        Gets the error_code of this ComputeEnvironment.
        Describe the error message if the backend operation encounter error.


        :return: The error_code of this ComputeEnvironment.
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code):
        """
        Sets the error_code of this ComputeEnvironment.
        Describe the error message if the backend operation encounter error.


        :param error_code: The error_code of this ComputeEnvironment.
        :type: str
        """
        self._error_code = error_code

    @property
    def is_auto_scale_down(self):
        """
        Gets the is_auto_scale_down of this ComputeEnvironment.
        Auto Scale Down


        :return: The is_auto_scale_down of this ComputeEnvironment.
        :rtype: bool
        """
        return self._is_auto_scale_down

    @is_auto_scale_down.setter
    def is_auto_scale_down(self, is_auto_scale_down):
        """
        Sets the is_auto_scale_down of this ComputeEnvironment.
        Auto Scale Down


        :param is_auto_scale_down: The is_auto_scale_down of this ComputeEnvironment.
        :type: bool
        """
        self._is_auto_scale_down = is_auto_scale_down

    @property
    def ssh_public_key(self):
        """
        Gets the ssh_public_key of this ComputeEnvironment.
        A public key is OpenSSH .pub format that can be used for verifying digital signatures generated
        using a corresponding private key, you need generate a new public/private rsa key pair
        or use existing ssh key. For example:
        ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQDd25ZgCEms2Cnt922S4PZVQolmvPDLJsWG8dAGEijlqPh7vepzJvCayaIymU6C6DEDtAqRN/CPm6tcIG/TFvy4al9pseIXAngfPfwNoC1jYdBYM941cEt2legcmkBCoB/wIK69SefRbO3nfbLxh/2ebtRWTJey5658wUS3JODoE9wd22EAg87I0P2Fbpo1W3kVZqF+cj7x0+t1ewZ4Rg2Bf98+hs9U9JmnmgPdk7cpo9CfF6FoiSRMMWb1kxaqESP8Q/gleajk6g1GZQkE7hEy9OxwI1QpLaAy/557vD/wJ5C0di9h+dA5gYe0QXeBeZ6zPlllJhilWehPtJIfT5hC57ks9+fBwZPqNwE92lICq5tiU8PfpamqRb1F1KiPN88G2fNUKGJHejN5DziKw6b4+RzzLneRv5VtK/FGm9wPGRdRhLzi7Wk59um9NDvd63GDV5ebQCjYBOGd1B82S9bpZlSHoewWXL9yavL5un5X8+/fETXlUkkKB4DRuKU6/aSbe0tKynngY0ZsdyJ/OcS1UbibOAXrt/AYl2/g15gWFYIRvm7VC20immiT4wf1B2fi87o5fbHfWuViJsxhjG4Eb1/0rTkJCTPV8RnNnjiKUJ9k7SRsw+NaK88MNFye0E7sTvl3Z+5vcuKZRatSVdRuP0XztvfyjXmlx2goM/dWMw== jet_sample_ww_grp@oracle.com


        :return: The ssh_public_key of this ComputeEnvironment.
        :rtype: str
        """
        return self._ssh_public_key

    @ssh_public_key.setter
    def ssh_public_key(self, ssh_public_key):
        """
        Sets the ssh_public_key of this ComputeEnvironment.
        A public key is OpenSSH .pub format that can be used for verifying digital signatures generated
        using a corresponding private key, you need generate a new public/private rsa key pair
        or use existing ssh key. For example:
        ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQDd25ZgCEms2Cnt922S4PZVQolmvPDLJsWG8dAGEijlqPh7vepzJvCayaIymU6C6DEDtAqRN/CPm6tcIG/TFvy4al9pseIXAngfPfwNoC1jYdBYM941cEt2legcmkBCoB/wIK69SefRbO3nfbLxh/2ebtRWTJey5658wUS3JODoE9wd22EAg87I0P2Fbpo1W3kVZqF+cj7x0+t1ewZ4Rg2Bf98+hs9U9JmnmgPdk7cpo9CfF6FoiSRMMWb1kxaqESP8Q/gleajk6g1GZQkE7hEy9OxwI1QpLaAy/557vD/wJ5C0di9h+dA5gYe0QXeBeZ6zPlllJhilWehPtJIfT5hC57ks9+fBwZPqNwE92lICq5tiU8PfpamqRb1F1KiPN88G2fNUKGJHejN5DziKw6b4+RzzLneRv5VtK/FGm9wPGRdRhLzi7Wk59um9NDvd63GDV5ebQCjYBOGd1B82S9bpZlSHoewWXL9yavL5un5X8+/fETXlUkkKB4DRuKU6/aSbe0tKynngY0ZsdyJ/OcS1UbibOAXrt/AYl2/g15gWFYIRvm7VC20immiT4wf1B2fi87o5fbHfWuViJsxhjG4Eb1/0rTkJCTPV8RnNnjiKUJ9k7SRsw+NaK88MNFye0E7sTvl3Z+5vcuKZRatSVdRuP0XztvfyjXmlx2goM/dWMw== jet_sample_ww_grp@oracle.com


        :param ssh_public_key: The ssh_public_key of this ComputeEnvironment.
        :type: str
        """
        self._ssh_public_key = ssh_public_key

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ComputeEnvironment.
        Free-form tags associated with this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ComputeEnvironment.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ComputeEnvironment.
        Free-form tags associated with this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ComputeEnvironment.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ComputeEnvironment.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ComputeEnvironment.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ComputeEnvironment.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ComputeEnvironment.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
