# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateBatchInstanceDetails(object):
    """
    Details for creating a new batch instance.
    Batch instance is a definition that associate an OKE cluster with Batch Service,
    customer can create Compute environment, Job definition and submit Job upon Batch instance.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateBatchInstanceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateBatchInstanceDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateBatchInstanceDetails.
        :type display_name: str

        :param cluster_id:
            The value to assign to the cluster_id property of this CreateBatchInstanceDetails.
        :type cluster_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateBatchInstanceDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateBatchInstanceDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'cluster_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'cluster_id': 'clusterId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._compartment_id = None
        self._display_name = None
        self._cluster_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateBatchInstanceDetails.
        The OCID of the cmpartment.


        :return: The compartment_id of this CreateBatchInstanceDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateBatchInstanceDetails.
        The OCID of the cmpartment.


        :param compartment_id: The compartment_id of this CreateBatchInstanceDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateBatchInstanceDetails.
        The name of the batch instance must consist of lower case alphanumeric characters or \u2018-\u2019,
        start with an alphabetic character, and end with an alphanumeric character,
        (e.g.\u2019my-name\u2019 or \u2018abc-123\u2019 or 'batchinstance')
        When not provided, the system generate value using the format \"<resourceType><timestamp>\", example: batchinstance20181211220642.


        :return: The display_name of this CreateBatchInstanceDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateBatchInstanceDetails.
        The name of the batch instance must consist of lower case alphanumeric characters or \u2018-\u2019,
        start with an alphabetic character, and end with an alphanumeric character,
        (e.g.\u2019my-name\u2019 or \u2018abc-123\u2019 or 'batchinstance')
        When not provided, the system generate value using the format \"<resourceType><timestamp>\", example: batchinstance20181211220642.


        :param display_name: The display_name of this CreateBatchInstanceDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def cluster_id(self):
        """
        **[Required]** Gets the cluster_id of this CreateBatchInstanceDetails.
        The OCID of the cluster.


        :return: The cluster_id of this CreateBatchInstanceDetails.
        :rtype: str
        """
        return self._cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):
        """
        Sets the cluster_id of this CreateBatchInstanceDetails.
        The OCID of the cluster.


        :param cluster_id: The cluster_id of this CreateBatchInstanceDetails.
        :type: str
        """
        self._cluster_id = cluster_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateBatchInstanceDetails.
        Free-form tags associated with this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateBatchInstanceDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateBatchInstanceDetails.
        Free-form tags associated with this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateBatchInstanceDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateBatchInstanceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateBatchInstanceDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateBatchInstanceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateBatchInstanceDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
