# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateComputeEnvironmentDetails(object):
    """
    Details for creating a new compute environment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateComputeEnvironmentDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateComputeEnvironmentDetails.
        :type display_name: str

        :param batch_instance_id:
            The value to assign to the batch_instance_id property of this CreateComputeEnvironmentDetails.
        :type batch_instance_id: str

        :param machine_image_name:
            The value to assign to the machine_image_name property of this CreateComputeEnvironmentDetails.
        :type machine_image_name: str

        :param shape_name:
            The value to assign to the shape_name property of this CreateComputeEnvironmentDetails.
        :type shape_name: str

        :param subnet_id:
            The value to assign to the subnet_id property of this CreateComputeEnvironmentDetails.
        :type subnet_id: str

        :param kube_version:
            The value to assign to the kube_version property of this CreateComputeEnvironmentDetails.
        :type kube_version: str

        :param is_auto_scale_down:
            The value to assign to the is_auto_scale_down property of this CreateComputeEnvironmentDetails.
        :type is_auto_scale_down: bool

        :param ssh_public_key:
            The value to assign to the ssh_public_key property of this CreateComputeEnvironmentDetails.
        :type ssh_public_key: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateComputeEnvironmentDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateComputeEnvironmentDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'batch_instance_id': 'str',
            'machine_image_name': 'str',
            'shape_name': 'str',
            'subnet_id': 'str',
            'kube_version': 'str',
            'is_auto_scale_down': 'bool',
            'ssh_public_key': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'batch_instance_id': 'batchInstanceId',
            'machine_image_name': 'machineImageName',
            'shape_name': 'shapeName',
            'subnet_id': 'subnetId',
            'kube_version': 'kubeVersion',
            'is_auto_scale_down': 'isAutoScaleDown',
            'ssh_public_key': 'sshPublicKey',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._display_name = None
        self._batch_instance_id = None
        self._machine_image_name = None
        self._shape_name = None
        self._subnet_id = None
        self._kube_version = None
        self._is_auto_scale_down = None
        self._ssh_public_key = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateComputeEnvironmentDetails.
        The name of the compute environment. When not provided, the system generate value using the format
        \"<resourceType><timestamp>\", example: computeEnvironment20181211220642.


        :return: The display_name of this CreateComputeEnvironmentDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateComputeEnvironmentDetails.
        The name of the compute environment. When not provided, the system generate value using the format
        \"<resourceType><timestamp>\", example: computeEnvironment20181211220642.


        :param display_name: The display_name of this CreateComputeEnvironmentDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def batch_instance_id(self):
        """
        **[Required]** Gets the batch_instance_id of this CreateComputeEnvironmentDetails.
        The OCID of the batch instance.


        :return: The batch_instance_id of this CreateComputeEnvironmentDetails.
        :rtype: str
        """
        return self._batch_instance_id

    @batch_instance_id.setter
    def batch_instance_id(self, batch_instance_id):
        """
        Sets the batch_instance_id of this CreateComputeEnvironmentDetails.
        The OCID of the batch instance.


        :param batch_instance_id: The batch_instance_id of this CreateComputeEnvironmentDetails.
        :type: str
        """
        self._batch_instance_id = batch_instance_id

    @property
    def machine_image_name(self):
        """
        **[Required]** Gets the machine_image_name of this CreateComputeEnvironmentDetails.
        The machine image name.


        :return: The machine_image_name of this CreateComputeEnvironmentDetails.
        :rtype: str
        """
        return self._machine_image_name

    @machine_image_name.setter
    def machine_image_name(self, machine_image_name):
        """
        Sets the machine_image_name of this CreateComputeEnvironmentDetails.
        The machine image name.


        :param machine_image_name: The machine_image_name of this CreateComputeEnvironmentDetails.
        :type: str
        """
        self._machine_image_name = machine_image_name

    @property
    def shape_name(self):
        """
        **[Required]** Gets the shape_name of this CreateComputeEnvironmentDetails.
        The shape for compute environment


        :return: The shape_name of this CreateComputeEnvironmentDetails.
        :rtype: str
        """
        return self._shape_name

    @shape_name.setter
    def shape_name(self, shape_name):
        """
        Sets the shape_name of this CreateComputeEnvironmentDetails.
        The shape for compute environment


        :param shape_name: The shape_name of this CreateComputeEnvironmentDetails.
        :type: str
        """
        self._shape_name = shape_name

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this CreateComputeEnvironmentDetails.
        The OCID for subnet.


        :return: The subnet_id of this CreateComputeEnvironmentDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CreateComputeEnvironmentDetails.
        The OCID for subnet.


        :param subnet_id: The subnet_id of this CreateComputeEnvironmentDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def kube_version(self):
        """
        Gets the kube_version of this CreateComputeEnvironmentDetails.
        Kubernetes version.


        :return: The kube_version of this CreateComputeEnvironmentDetails.
        :rtype: str
        """
        return self._kube_version

    @kube_version.setter
    def kube_version(self, kube_version):
        """
        Sets the kube_version of this CreateComputeEnvironmentDetails.
        Kubernetes version.


        :param kube_version: The kube_version of this CreateComputeEnvironmentDetails.
        :type: str
        """
        self._kube_version = kube_version

    @property
    def is_auto_scale_down(self):
        """
        Gets the is_auto_scale_down of this CreateComputeEnvironmentDetails.
        Auto Scale Down


        :return: The is_auto_scale_down of this CreateComputeEnvironmentDetails.
        :rtype: bool
        """
        return self._is_auto_scale_down

    @is_auto_scale_down.setter
    def is_auto_scale_down(self, is_auto_scale_down):
        """
        Sets the is_auto_scale_down of this CreateComputeEnvironmentDetails.
        Auto Scale Down


        :param is_auto_scale_down: The is_auto_scale_down of this CreateComputeEnvironmentDetails.
        :type: bool
        """
        self._is_auto_scale_down = is_auto_scale_down

    @property
    def ssh_public_key(self):
        """
        Gets the ssh_public_key of this CreateComputeEnvironmentDetails.
        A public key is OpenSSH .pub format key that can be used for verifying digital signatures generated
        using a corresponding private key, you need generate a new public/private rsa key pair
        or use existing ssh key. For example:
        ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQDd25ZgCEms2Cnt922S4PZVQolmvPDLJsWG8dAGEijlqPh7vepzJvCayaIymU6C6DEDtAqRN/CPm6tcIG/TFvy4al9pseIXAngfPfwNoC1jYdBYM941cEt2legcmkBCoB/wIK69SefRbO3nfbLxh/2ebtRWTJey5658wUS3JODoE9wd22EAg87I0P2Fbpo1W3kVZqF+cj7x0+t1ewZ4Rg2Bf98+hs9U9JmnmgPdk7cpo9CfF6FoiSRMMWb1kxaqESP8Q/gleajk6g1GZQkE7hEy9OxwI1QpLaAy/557vD/wJ5C0di9h+dA5gYe0QXeBeZ6zPlllJhilWehPtJIfT5hC57ks9+fBwZPqNwE92lICq5tiU8PfpamqRb1F1KiPN88G2fNUKGJHejN5DziKw6b4+RzzLneRv5VtK/FGm9wPGRdRhLzi7Wk59um9NDvd63GDV5ebQCjYBOGd1B82S9bpZlSHoewWXL9yavL5un5X8+/fETXlUkkKB4DRuKU6/aSbe0tKynngY0ZsdyJ/OcS1UbibOAXrt/AYl2/g15gWFYIRvm7VC20immiT4wf1B2fi87o5fbHfWuViJsxhjG4Eb1/0rTkJCTPV8RnNnjiKUJ9k7SRsw+NaK88MNFye0E7sTvl3Z+5vcuKZRatSVdRuP0XztvfyjXmlx2goM/dWMw== jet_sample_ww_grp@oracle.com


        :return: The ssh_public_key of this CreateComputeEnvironmentDetails.
        :rtype: str
        """
        return self._ssh_public_key

    @ssh_public_key.setter
    def ssh_public_key(self, ssh_public_key):
        """
        Sets the ssh_public_key of this CreateComputeEnvironmentDetails.
        A public key is OpenSSH .pub format key that can be used for verifying digital signatures generated
        using a corresponding private key, you need generate a new public/private rsa key pair
        or use existing ssh key. For example:
        ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQDd25ZgCEms2Cnt922S4PZVQolmvPDLJsWG8dAGEijlqPh7vepzJvCayaIymU6C6DEDtAqRN/CPm6tcIG/TFvy4al9pseIXAngfPfwNoC1jYdBYM941cEt2legcmkBCoB/wIK69SefRbO3nfbLxh/2ebtRWTJey5658wUS3JODoE9wd22EAg87I0P2Fbpo1W3kVZqF+cj7x0+t1ewZ4Rg2Bf98+hs9U9JmnmgPdk7cpo9CfF6FoiSRMMWb1kxaqESP8Q/gleajk6g1GZQkE7hEy9OxwI1QpLaAy/557vD/wJ5C0di9h+dA5gYe0QXeBeZ6zPlllJhilWehPtJIfT5hC57ks9+fBwZPqNwE92lICq5tiU8PfpamqRb1F1KiPN88G2fNUKGJHejN5DziKw6b4+RzzLneRv5VtK/FGm9wPGRdRhLzi7Wk59um9NDvd63GDV5ebQCjYBOGd1B82S9bpZlSHoewWXL9yavL5un5X8+/fETXlUkkKB4DRuKU6/aSbe0tKynngY0ZsdyJ/OcS1UbibOAXrt/AYl2/g15gWFYIRvm7VC20immiT4wf1B2fi87o5fbHfWuViJsxhjG4Eb1/0rTkJCTPV8RnNnjiKUJ9k7SRsw+NaK88MNFye0E7sTvl3Z+5vcuKZRatSVdRuP0XztvfyjXmlx2goM/dWMw== jet_sample_ww_grp@oracle.com


        :param ssh_public_key: The ssh_public_key of this CreateComputeEnvironmentDetails.
        :type: str
        """
        self._ssh_public_key = ssh_public_key

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateComputeEnvironmentDetails.
        Free-form tags associated with this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateComputeEnvironmentDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateComputeEnvironmentDetails.
        Free-form tags associated with this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateComputeEnvironmentDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateComputeEnvironmentDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateComputeEnvironmentDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateComputeEnvironmentDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateComputeEnvironmentDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
