# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateJobDefinitionDetails(object):
    """
    Details for creating a new job definition.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateJobDefinitionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateJobDefinitionDetails.
        :type display_name: str

        :param batch_instance_id:
            The value to assign to the batch_instance_id property of this CreateJobDefinitionDetails.
        :type batch_instance_id: str

        :param docker_image:
            The value to assign to the docker_image property of this CreateJobDefinitionDetails.
        :type docker_image: str

        :param container_ocpu:
            The value to assign to the container_ocpu property of this CreateJobDefinitionDetails.
        :type container_ocpu: float

        :param container_memory_size_in_mbs:
            The value to assign to the container_memory_size_in_mbs property of this CreateJobDefinitionDetails.
        :type container_memory_size_in_mbs: int

        :param docker_registry_secret:
            The value to assign to the docker_registry_secret property of this CreateJobDefinitionDetails.
        :type docker_registry_secret: str

        :param retry_times:
            The value to assign to the retry_times property of this CreateJobDefinitionDetails.
        :type retry_times: int

        :param timeout_seconds:
            The value to assign to the timeout_seconds property of this CreateJobDefinitionDetails.
        :type timeout_seconds: int

        :param command:
            The value to assign to the command property of this CreateJobDefinitionDetails.
        :type command: list[str]

        :param args:
            The value to assign to the args property of this CreateJobDefinitionDetails.
        :type args: list[str]

        :param environment_variables:
            The value to assign to the environment_variables property of this CreateJobDefinitionDetails.
        :type environment_variables: list[CreateJobDefinitionDetailsEnvironmentVariables]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateJobDefinitionDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateJobDefinitionDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'batch_instance_id': 'str',
            'docker_image': 'str',
            'container_ocpu': 'float',
            'container_memory_size_in_mbs': 'int',
            'docker_registry_secret': 'str',
            'retry_times': 'int',
            'timeout_seconds': 'int',
            'command': 'list[str]',
            'args': 'list[str]',
            'environment_variables': 'list[CreateJobDefinitionDetailsEnvironmentVariables]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'batch_instance_id': 'batchInstanceId',
            'docker_image': 'dockerImage',
            'container_ocpu': 'containerOcpu',
            'container_memory_size_in_mbs': 'containerMemorySizeInMbs',
            'docker_registry_secret': 'dockerRegistrySecret',
            'retry_times': 'retryTimes',
            'timeout_seconds': 'timeoutSeconds',
            'command': 'command',
            'args': 'args',
            'environment_variables': 'environmentVariables',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._display_name = None
        self._batch_instance_id = None
        self._docker_image = None
        self._container_ocpu = None
        self._container_memory_size_in_mbs = None
        self._docker_registry_secret = None
        self._retry_times = None
        self._timeout_seconds = None
        self._command = None
        self._args = None
        self._environment_variables = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateJobDefinitionDetails.
        The name of the job definition. When not provided, the system generate value using the format
        \"<resourceType><timestamp>\", example: jobDefinition20181211220642.


        :return: The display_name of this CreateJobDefinitionDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateJobDefinitionDetails.
        The name of the job definition. When not provided, the system generate value using the format
        \"<resourceType><timestamp>\", example: jobDefinition20181211220642.


        :param display_name: The display_name of this CreateJobDefinitionDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def batch_instance_id(self):
        """
        **[Required]** Gets the batch_instance_id of this CreateJobDefinitionDetails.
        The OCID of the batch instance.


        :return: The batch_instance_id of this CreateJobDefinitionDetails.
        :rtype: str
        """
        return self._batch_instance_id

    @batch_instance_id.setter
    def batch_instance_id(self, batch_instance_id):
        """
        Sets the batch_instance_id of this CreateJobDefinitionDetails.
        The OCID of the batch instance.


        :param batch_instance_id: The batch_instance_id of this CreateJobDefinitionDetails.
        :type: str
        """
        self._batch_instance_id = batch_instance_id

    @property
    def docker_image(self):
        """
        **[Required]** Gets the docker_image of this CreateJobDefinitionDetails.
        The docker image of the job.


        :return: The docker_image of this CreateJobDefinitionDetails.
        :rtype: str
        """
        return self._docker_image

    @docker_image.setter
    def docker_image(self, docker_image):
        """
        Sets the docker_image of this CreateJobDefinitionDetails.
        The docker image of the job.


        :param docker_image: The docker_image of this CreateJobDefinitionDetails.
        :type: str
        """
        self._docker_image = docker_image

    @property
    def container_ocpu(self):
        """
        **[Required]** Gets the container_ocpu of this CreateJobDefinitionDetails.
        An OCPU is defined as the CPU capacity equivalent of one physical core of an Intel Xeon processor
        with hyper threading enabled. OCPU for each container, for example 0.5.


        :return: The container_ocpu of this CreateJobDefinitionDetails.
        :rtype: float
        """
        return self._container_ocpu

    @container_ocpu.setter
    def container_ocpu(self, container_ocpu):
        """
        Sets the container_ocpu of this CreateJobDefinitionDetails.
        An OCPU is defined as the CPU capacity equivalent of one physical core of an Intel Xeon processor
        with hyper threading enabled. OCPU for each container, for example 0.5.


        :param container_ocpu: The container_ocpu of this CreateJobDefinitionDetails.
        :type: float
        """
        self._container_ocpu = container_ocpu

    @property
    def container_memory_size_in_mbs(self):
        """
        **[Required]** Gets the container_memory_size_in_mbs of this CreateJobDefinitionDetails.
        MB of memory for each container, for example 512.


        :return: The container_memory_size_in_mbs of this CreateJobDefinitionDetails.
        :rtype: int
        """
        return self._container_memory_size_in_mbs

    @container_memory_size_in_mbs.setter
    def container_memory_size_in_mbs(self, container_memory_size_in_mbs):
        """
        Sets the container_memory_size_in_mbs of this CreateJobDefinitionDetails.
        MB of memory for each container, for example 512.


        :param container_memory_size_in_mbs: The container_memory_size_in_mbs of this CreateJobDefinitionDetails.
        :type: int
        """
        self._container_memory_size_in_mbs = container_memory_size_in_mbs

    @property
    def docker_registry_secret(self):
        """
        Gets the docker_registry_secret of this CreateJobDefinitionDetails.
        The secret name of the docker registry.


        :return: The docker_registry_secret of this CreateJobDefinitionDetails.
        :rtype: str
        """
        return self._docker_registry_secret

    @docker_registry_secret.setter
    def docker_registry_secret(self, docker_registry_secret):
        """
        Sets the docker_registry_secret of this CreateJobDefinitionDetails.
        The secret name of the docker registry.


        :param docker_registry_secret: The docker_registry_secret of this CreateJobDefinitionDetails.
        :type: str
        """
        self._docker_registry_secret = docker_registry_secret

    @property
    def retry_times(self):
        """
        Gets the retry_times of this CreateJobDefinitionDetails.
        Specifies the number of retries before marking this job failed.


        :return: The retry_times of this CreateJobDefinitionDetails.
        :rtype: int
        """
        return self._retry_times

    @retry_times.setter
    def retry_times(self, retry_times):
        """
        Sets the retry_times of this CreateJobDefinitionDetails.
        Specifies the number of retries before marking this job failed.


        :param retry_times: The retry_times of this CreateJobDefinitionDetails.
        :type: int
        """
        self._retry_times = retry_times

    @property
    def timeout_seconds(self):
        """
        Gets the timeout_seconds of this CreateJobDefinitionDetails.
        Timeout seconds of JOB.


        :return: The timeout_seconds of this CreateJobDefinitionDetails.
        :rtype: int
        """
        return self._timeout_seconds

    @timeout_seconds.setter
    def timeout_seconds(self, timeout_seconds):
        """
        Sets the timeout_seconds of this CreateJobDefinitionDetails.
        Timeout seconds of JOB.


        :param timeout_seconds: The timeout_seconds of this CreateJobDefinitionDetails.
        :type: int
        """
        self._timeout_seconds = timeout_seconds

    @property
    def command(self):
        """
        Gets the command of this CreateJobDefinitionDetails.
        The command used to run the Job. The command and args must can be combined into one runnable command serially,
        such as \"command\": [\"ls\",\"-ll\"], \"args\": [\"/home\"], the command run to the job will be \"ls -ll /home\" .
        If you do not supply command or args, the defaults defined in the job will be used.


        :return: The command of this CreateJobDefinitionDetails.
        :rtype: list[str]
        """
        return self._command

    @command.setter
    def command(self, command):
        """
        Sets the command of this CreateJobDefinitionDetails.
        The command used to run the Job. The command and args must can be combined into one runnable command serially,
        such as \"command\": [\"ls\",\"-ll\"], \"args\": [\"/home\"], the command run to the job will be \"ls -ll /home\" .
        If you do not supply command or args, the defaults defined in the job will be used.


        :param command: The command of this CreateJobDefinitionDetails.
        :type: list[str]
        """
        self._command = command

    @property
    def args(self):
        """
        Gets the args of this CreateJobDefinitionDetails.
        The arguments passed to the command to run the Job, it's multiple such as
        [\"-a\",\"-k\"]. If you do not supply command or args, the defaults defined in the job will be used.


        :return: The args of this CreateJobDefinitionDetails.
        :rtype: list[str]
        """
        return self._args

    @args.setter
    def args(self, args):
        """
        Sets the args of this CreateJobDefinitionDetails.
        The arguments passed to the command to run the Job, it's multiple such as
        [\"-a\",\"-k\"]. If you do not supply command or args, the defaults defined in the job will be used.


        :param args: The args of this CreateJobDefinitionDetails.
        :type: list[str]
        """
        self._args = args

    @property
    def environment_variables(self):
        """
        Gets the environment_variables of this CreateJobDefinitionDetails.
        Environment variables used to run the JOB - user provided data -
        it's multiple such as [{\"name\": \"xxx\",\"value\": \"xxx\"}].


        :return: The environment_variables of this CreateJobDefinitionDetails.
        :rtype: list[CreateJobDefinitionDetailsEnvironmentVariables]
        """
        return self._environment_variables

    @environment_variables.setter
    def environment_variables(self, environment_variables):
        """
        Sets the environment_variables of this CreateJobDefinitionDetails.
        Environment variables used to run the JOB - user provided data -
        it's multiple such as [{\"name\": \"xxx\",\"value\": \"xxx\"}].


        :param environment_variables: The environment_variables of this CreateJobDefinitionDetails.
        :type: list[CreateJobDefinitionDetailsEnvironmentVariables]
        """
        self._environment_variables = environment_variables

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateJobDefinitionDetails.
        Free-form tags associated with this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateJobDefinitionDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateJobDefinitionDetails.
        Free-form tags associated with this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateJobDefinitionDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateJobDefinitionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateJobDefinitionDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateJobDefinitionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateJobDefinitionDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
