# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateJobDetails(object):
    """
    Details for creating a new job.
    When submit a job, user can select a defined Compute Environment and Job Definition,
    job properties will override those of referenced job definition.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateJobDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateJobDetails.
        :type display_name: str

        :param compute_environment_id:
            The value to assign to the compute_environment_id property of this CreateJobDetails.
        :type compute_environment_id: str

        :param job_definition_id:
            The value to assign to the job_definition_id property of this CreateJobDetails.
        :type job_definition_id: str

        :param batch_instance_id:
            The value to assign to the batch_instance_id property of this CreateJobDetails.
        :type batch_instance_id: str

        :param docker_image:
            The value to assign to the docker_image property of this CreateJobDetails.
        :type docker_image: str

        :param command:
            The value to assign to the command property of this CreateJobDetails.
        :type command: list[str]

        :param args:
            The value to assign to the args property of this CreateJobDetails.
        :type args: list[str]

        :param environment_variables:
            The value to assign to the environment_variables property of this CreateJobDetails.
        :type environment_variables: list[CreateJobDefinitionDetailsEnvironmentVariables]

        :param container_ocpu:
            The value to assign to the container_ocpu property of this CreateJobDetails.
        :type container_ocpu: float

        :param container_memory_size_in_mbs:
            The value to assign to the container_memory_size_in_mbs property of this CreateJobDetails.
        :type container_memory_size_in_mbs: int

        :param concurrency:
            The value to assign to the concurrency property of this CreateJobDetails.
        :type concurrency: int

        :param count:
            The value to assign to the count property of this CreateJobDetails.
        :type count: int

        :param retry_times:
            The value to assign to the retry_times property of this CreateJobDetails.
        :type retry_times: int

        :param timeout_seconds:
            The value to assign to the timeout_seconds property of this CreateJobDetails.
        :type timeout_seconds: int

        :param priority:
            The value to assign to the priority property of this CreateJobDetails.
        :type priority: int

        :param docker_registry_secret:
            The value to assign to the docker_registry_secret property of this CreateJobDetails.
        :type docker_registry_secret: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateJobDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateJobDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'compute_environment_id': 'str',
            'job_definition_id': 'str',
            'batch_instance_id': 'str',
            'docker_image': 'str',
            'command': 'list[str]',
            'args': 'list[str]',
            'environment_variables': 'list[CreateJobDefinitionDetailsEnvironmentVariables]',
            'container_ocpu': 'float',
            'container_memory_size_in_mbs': 'int',
            'concurrency': 'int',
            'count': 'int',
            'retry_times': 'int',
            'timeout_seconds': 'int',
            'priority': 'int',
            'docker_registry_secret': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'compute_environment_id': 'computeEnvironmentId',
            'job_definition_id': 'jobDefinitionId',
            'batch_instance_id': 'batchInstanceId',
            'docker_image': 'dockerImage',
            'command': 'command',
            'args': 'args',
            'environment_variables': 'environmentVariables',
            'container_ocpu': 'containerOcpu',
            'container_memory_size_in_mbs': 'containerMemorySizeInMbs',
            'concurrency': 'concurrency',
            'count': 'count',
            'retry_times': 'retryTimes',
            'timeout_seconds': 'timeoutSeconds',
            'priority': 'priority',
            'docker_registry_secret': 'dockerRegistrySecret',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._display_name = None
        self._compute_environment_id = None
        self._job_definition_id = None
        self._batch_instance_id = None
        self._docker_image = None
        self._command = None
        self._args = None
        self._environment_variables = None
        self._container_ocpu = None
        self._container_memory_size_in_mbs = None
        self._concurrency = None
        self._count = None
        self._retry_times = None
        self._timeout_seconds = None
        self._priority = None
        self._docker_registry_secret = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateJobDetails.
        The name of the job, job name must consist of lower case alphanumeric characters,
        '-' or '.', and must start and end with an alphanumeric character.
        When not provided, the system generate value using the format
        \"<resourceType><timestamp>\", example: job20181211220642.


        :return: The display_name of this CreateJobDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateJobDetails.
        The name of the job, job name must consist of lower case alphanumeric characters,
        '-' or '.', and must start and end with an alphanumeric character.
        When not provided, the system generate value using the format
        \"<resourceType><timestamp>\", example: job20181211220642.


        :param display_name: The display_name of this CreateJobDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def compute_environment_id(self):
        """
        **[Required]** Gets the compute_environment_id of this CreateJobDetails.
        The OCID of the compute environment.


        :return: The compute_environment_id of this CreateJobDetails.
        :rtype: str
        """
        return self._compute_environment_id

    @compute_environment_id.setter
    def compute_environment_id(self, compute_environment_id):
        """
        Sets the compute_environment_id of this CreateJobDetails.
        The OCID of the compute environment.


        :param compute_environment_id: The compute_environment_id of this CreateJobDetails.
        :type: str
        """
        self._compute_environment_id = compute_environment_id

    @property
    def job_definition_id(self):
        """
        **[Required]** Gets the job_definition_id of this CreateJobDetails.
        The OCID of the job definition.


        :return: The job_definition_id of this CreateJobDetails.
        :rtype: str
        """
        return self._job_definition_id

    @job_definition_id.setter
    def job_definition_id(self, job_definition_id):
        """
        Sets the job_definition_id of this CreateJobDetails.
        The OCID of the job definition.


        :param job_definition_id: The job_definition_id of this CreateJobDetails.
        :type: str
        """
        self._job_definition_id = job_definition_id

    @property
    def batch_instance_id(self):
        """
        **[Required]** Gets the batch_instance_id of this CreateJobDetails.
        The OCID of the batch instance.


        :return: The batch_instance_id of this CreateJobDetails.
        :rtype: str
        """
        return self._batch_instance_id

    @batch_instance_id.setter
    def batch_instance_id(self, batch_instance_id):
        """
        Sets the batch_instance_id of this CreateJobDetails.
        The OCID of the batch instance.


        :param batch_instance_id: The batch_instance_id of this CreateJobDetails.
        :type: str
        """
        self._batch_instance_id = batch_instance_id

    @property
    def docker_image(self):
        """
        Gets the docker_image of this CreateJobDetails.
        The docker image of the job.


        :return: The docker_image of this CreateJobDetails.
        :rtype: str
        """
        return self._docker_image

    @docker_image.setter
    def docker_image(self, docker_image):
        """
        Sets the docker_image of this CreateJobDetails.
        The docker image of the job.


        :param docker_image: The docker_image of this CreateJobDetails.
        :type: str
        """
        self._docker_image = docker_image

    @property
    def command(self):
        """
        Gets the command of this CreateJobDetails.
        The command used to run the Job. The command and args must can be combined into one runnable command serially,
        such as \"command\": [\"ls\",\"-ll\"], \"args\": [\"/home\"], the command run to the job will be \"ls -ll /home\" .
        If you do not supply command or args, the defined in the job definition will be used.


        :return: The command of this CreateJobDetails.
        :rtype: list[str]
        """
        return self._command

    @command.setter
    def command(self, command):
        """
        Sets the command of this CreateJobDetails.
        The command used to run the Job. The command and args must can be combined into one runnable command serially,
        such as \"command\": [\"ls\",\"-ll\"], \"args\": [\"/home\"], the command run to the job will be \"ls -ll /home\" .
        If you do not supply command or args, the defined in the job definition will be used.


        :param command: The command of this CreateJobDetails.
        :type: list[str]
        """
        self._command = command

    @property
    def args(self):
        """
        Gets the args of this CreateJobDetails.
        The arguments passed to the command to run the Job, it's multiple such as
        [\"-a\",\"-k\"]. If you do not supply command or args, the defined in the job definition will be used.


        :return: The args of this CreateJobDetails.
        :rtype: list[str]
        """
        return self._args

    @args.setter
    def args(self, args):
        """
        Sets the args of this CreateJobDetails.
        The arguments passed to the command to run the Job, it's multiple such as
        [\"-a\",\"-k\"]. If you do not supply command or args, the defined in the job definition will be used.


        :param args: The args of this CreateJobDetails.
        :type: list[str]
        """
        self._args = args

    @property
    def environment_variables(self):
        """
        Gets the environment_variables of this CreateJobDetails.
        Environment variables used to run the JOB - user provided data -
        it's multiple such as [{\"name\": \"xxx\",\"value\": \"xxx\"}].


        :return: The environment_variables of this CreateJobDetails.
        :rtype: list[CreateJobDefinitionDetailsEnvironmentVariables]
        """
        return self._environment_variables

    @environment_variables.setter
    def environment_variables(self, environment_variables):
        """
        Sets the environment_variables of this CreateJobDetails.
        Environment variables used to run the JOB - user provided data -
        it's multiple such as [{\"name\": \"xxx\",\"value\": \"xxx\"}].


        :param environment_variables: The environment_variables of this CreateJobDetails.
        :type: list[CreateJobDefinitionDetailsEnvironmentVariables]
        """
        self._environment_variables = environment_variables

    @property
    def container_ocpu(self):
        """
        Gets the container_ocpu of this CreateJobDetails.
        An OCPU is defined as the CPU capacity equivalent of one physical core of an Intel Xeon processor
        with hyper threading enabled. OCPU for each container, for example 0.5.


        :return: The container_ocpu of this CreateJobDetails.
        :rtype: float
        """
        return self._container_ocpu

    @container_ocpu.setter
    def container_ocpu(self, container_ocpu):
        """
        Sets the container_ocpu of this CreateJobDetails.
        An OCPU is defined as the CPU capacity equivalent of one physical core of an Intel Xeon processor
        with hyper threading enabled. OCPU for each container, for example 0.5.


        :param container_ocpu: The container_ocpu of this CreateJobDetails.
        :type: float
        """
        self._container_ocpu = container_ocpu

    @property
    def container_memory_size_in_mbs(self):
        """
        Gets the container_memory_size_in_mbs of this CreateJobDetails.
        MB of memory for each container, for example 512.


        :return: The container_memory_size_in_mbs of this CreateJobDetails.
        :rtype: int
        """
        return self._container_memory_size_in_mbs

    @container_memory_size_in_mbs.setter
    def container_memory_size_in_mbs(self, container_memory_size_in_mbs):
        """
        Sets the container_memory_size_in_mbs of this CreateJobDetails.
        MB of memory for each container, for example 512.


        :param container_memory_size_in_mbs: The container_memory_size_in_mbs of this CreateJobDetails.
        :type: int
        """
        self._container_memory_size_in_mbs = container_memory_size_in_mbs

    @property
    def concurrency(self):
        """
        Gets the concurrency of this CreateJobDetails.
        Number of pods running on a job concurrently.


        :return: The concurrency of this CreateJobDetails.
        :rtype: int
        """
        return self._concurrency

    @concurrency.setter
    def concurrency(self, concurrency):
        """
        Sets the concurrency of this CreateJobDetails.
        Number of pods running on a job concurrently.


        :param concurrency: The concurrency of this CreateJobDetails.
        :type: int
        """
        self._concurrency = concurrency

    @property
    def count(self):
        """
        Gets the count of this CreateJobDetails.
        The number of pods that must successfully terminate before a job can reach the SUCCEEDED state.
        Pods that terminate unsuccessfully are retried until retryTimes has been exhausted or a job times out.


        :return: The count of this CreateJobDetails.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this CreateJobDetails.
        The number of pods that must successfully terminate before a job can reach the SUCCEEDED state.
        Pods that terminate unsuccessfully are retried until retryTimes has been exhausted or a job times out.


        :param count: The count of this CreateJobDetails.
        :type: int
        """
        self._count = count

    @property
    def retry_times(self):
        """
        Gets the retry_times of this CreateJobDetails.
        Specifies the number of retries before marking this job failed.


        :return: The retry_times of this CreateJobDetails.
        :rtype: int
        """
        return self._retry_times

    @retry_times.setter
    def retry_times(self, retry_times):
        """
        Sets the retry_times of this CreateJobDetails.
        Specifies the number of retries before marking this job failed.


        :param retry_times: The retry_times of this CreateJobDetails.
        :type: int
        """
        self._retry_times = retry_times

    @property
    def timeout_seconds(self):
        """
        Gets the timeout_seconds of this CreateJobDetails.
        Timeout seconds of JOB. The default value of timeoutSeconds is 3600.


        :return: The timeout_seconds of this CreateJobDetails.
        :rtype: int
        """
        return self._timeout_seconds

    @timeout_seconds.setter
    def timeout_seconds(self, timeout_seconds):
        """
        Sets the timeout_seconds of this CreateJobDetails.
        Timeout seconds of JOB. The default value of timeoutSeconds is 3600.


        :param timeout_seconds: The timeout_seconds of this CreateJobDetails.
        :type: int
        """
        self._timeout_seconds = timeout_seconds

    @property
    def priority(self):
        """
        Gets the priority of this CreateJobDetails.
        The priority of the job, higher values take precedence.


        :return: The priority of this CreateJobDetails.
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """
        Sets the priority of this CreateJobDetails.
        The priority of the job, higher values take precedence.


        :param priority: The priority of this CreateJobDetails.
        :type: int
        """
        self._priority = priority

    @property
    def docker_registry_secret(self):
        """
        Gets the docker_registry_secret of this CreateJobDetails.
        The secret name of the docker registry.


        :return: The docker_registry_secret of this CreateJobDetails.
        :rtype: str
        """
        return self._docker_registry_secret

    @docker_registry_secret.setter
    def docker_registry_secret(self, docker_registry_secret):
        """
        Sets the docker_registry_secret of this CreateJobDetails.
        The secret name of the docker registry.


        :param docker_registry_secret: The docker_registry_secret of this CreateJobDetails.
        :type: str
        """
        self._docker_registry_secret = docker_registry_secret

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateJobDetails.
        Free-form tags associated with this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateJobDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateJobDetails.
        Free-form tags associated with this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateJobDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateJobDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateJobDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateJobDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateJobDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
