# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Job(object):
    """
    User submit job with selection of a compute environment and a job
    definition.
    """

    #: A constant which can be used with the lifecycle_state property of a Job.
    #: This constant has a value of "ACCEPTED"
    LIFECYCLE_STATE_ACCEPTED = "ACCEPTED"

    #: A constant which can be used with the lifecycle_state property of a Job.
    #: This constant has a value of "IN_PROGRESS"
    LIFECYCLE_STATE_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the lifecycle_state property of a Job.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a Job.
    #: This constant has a value of "SUCCEEDED"
    LIFECYCLE_STATE_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the lifecycle_state property of a Job.
    #: This constant has a value of "CANCELING"
    LIFECYCLE_STATE_CANCELING = "CANCELING"

    #: A constant which can be used with the lifecycle_state property of a Job.
    #: This constant has a value of "CANCELED"
    LIFECYCLE_STATE_CANCELED = "CANCELED"

    #: A constant which can be used with the lifecycle_state property of a Job.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new Job object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Job.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this Job.
        :type display_name: str

        :param compute_environment_id:
            The value to assign to the compute_environment_id property of this Job.
        :type compute_environment_id: str

        :param job_definition_id:
            The value to assign to the job_definition_id property of this Job.
        :type job_definition_id: str

        :param batch_instance_id:
            The value to assign to the batch_instance_id property of this Job.
        :type batch_instance_id: str

        :param docker_image:
            The value to assign to the docker_image property of this Job.
        :type docker_image: str

        :param command:
            The value to assign to the command property of this Job.
        :type command: list[str]

        :param args:
            The value to assign to the args property of this Job.
        :type args: list[str]

        :param environment_variables:
            The value to assign to the environment_variables property of this Job.
        :type environment_variables: list[CreateJobDefinitionDetailsEnvironmentVariables]

        :param container_ocpu:
            The value to assign to the container_ocpu property of this Job.
        :type container_ocpu: float

        :param container_memory_size_in_mbs:
            The value to assign to the container_memory_size_in_mbs property of this Job.
        :type container_memory_size_in_mbs: int

        :param concurrency:
            The value to assign to the concurrency property of this Job.
        :type concurrency: int

        :param count:
            The value to assign to the count property of this Job.
        :type count: int

        :param retry_times:
            The value to assign to the retry_times property of this Job.
        :type retry_times: int

        :param timeout_seconds:
            The value to assign to the timeout_seconds property of this Job.
        :type timeout_seconds: int

        :param priority:
            The value to assign to the priority property of this Job.
        :type priority: int

        :param docker_registry_secret:
            The value to assign to the docker_registry_secret property of this Job.
        :type docker_registry_secret: str

        :param created_by_user_id:
            The value to assign to the created_by_user_id property of this Job.
        :type created_by_user_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Job.
            Allowed values for this property are: "ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param status_description:
            The value to assign to the status_description property of this Job.
        :type status_description: str

        :param error_code:
            The value to assign to the error_code property of this Job.
        :type error_code: str

        :param job_kube_name:
            The value to assign to the job_kube_name property of this Job.
        :type job_kube_name: str

        :param time_created:
            The value to assign to the time_created property of this Job.
        :type time_created: datetime

        :param time_started:
            The value to assign to the time_started property of this Job.
        :type time_started: datetime

        :param time_completed:
            The value to assign to the time_completed property of this Job.
        :type time_completed: datetime

        :param node_pool_id:
            The value to assign to the node_pool_id property of this Job.
        :type node_pool_id: str

        :param job_log_stderr_path:
            The value to assign to the job_log_stderr_path property of this Job.
        :type job_log_stderr_path: str

        :param job_log_stdout_path:
            The value to assign to the job_log_stdout_path property of this Job.
        :type job_log_stdout_path: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this Job.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this Job.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compute_environment_id': 'str',
            'job_definition_id': 'str',
            'batch_instance_id': 'str',
            'docker_image': 'str',
            'command': 'list[str]',
            'args': 'list[str]',
            'environment_variables': 'list[CreateJobDefinitionDetailsEnvironmentVariables]',
            'container_ocpu': 'float',
            'container_memory_size_in_mbs': 'int',
            'concurrency': 'int',
            'count': 'int',
            'retry_times': 'int',
            'timeout_seconds': 'int',
            'priority': 'int',
            'docker_registry_secret': 'str',
            'created_by_user_id': 'str',
            'lifecycle_state': 'str',
            'status_description': 'str',
            'error_code': 'str',
            'job_kube_name': 'str',
            'time_created': 'datetime',
            'time_started': 'datetime',
            'time_completed': 'datetime',
            'node_pool_id': 'str',
            'job_log_stderr_path': 'str',
            'job_log_stdout_path': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compute_environment_id': 'computeEnvironmentId',
            'job_definition_id': 'jobDefinitionId',
            'batch_instance_id': 'batchInstanceId',
            'docker_image': 'dockerImage',
            'command': 'command',
            'args': 'args',
            'environment_variables': 'environmentVariables',
            'container_ocpu': 'containerOcpu',
            'container_memory_size_in_mbs': 'containerMemorySizeInMbs',
            'concurrency': 'concurrency',
            'count': 'count',
            'retry_times': 'retryTimes',
            'timeout_seconds': 'timeoutSeconds',
            'priority': 'priority',
            'docker_registry_secret': 'dockerRegistrySecret',
            'created_by_user_id': 'createdByUserId',
            'lifecycle_state': 'lifecycleState',
            'status_description': 'statusDescription',
            'error_code': 'errorCode',
            'job_kube_name': 'jobKubeName',
            'time_created': 'timeCreated',
            'time_started': 'timeStarted',
            'time_completed': 'timeCompleted',
            'node_pool_id': 'nodePoolId',
            'job_log_stderr_path': 'jobLogStderrPath',
            'job_log_stdout_path': 'jobLogStdoutPath',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._id = None
        self._display_name = None
        self._compute_environment_id = None
        self._job_definition_id = None
        self._batch_instance_id = None
        self._docker_image = None
        self._command = None
        self._args = None
        self._environment_variables = None
        self._container_ocpu = None
        self._container_memory_size_in_mbs = None
        self._concurrency = None
        self._count = None
        self._retry_times = None
        self._timeout_seconds = None
        self._priority = None
        self._docker_registry_secret = None
        self._created_by_user_id = None
        self._lifecycle_state = None
        self._status_description = None
        self._error_code = None
        self._job_kube_name = None
        self._time_created = None
        self._time_started = None
        self._time_completed = None
        self._node_pool_id = None
        self._job_log_stderr_path = None
        self._job_log_stdout_path = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def id(self):
        """
        Gets the id of this Job.
        The OCID of the job.


        :return: The id of this Job.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Job.
        The OCID of the job.


        :param id: The id of this Job.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this Job.
        The name of the job, job name must consist of lower case alphanumeric characters,
        '-' or '.', and must start and end with an alphanumeric character.


        :return: The display_name of this Job.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Job.
        The name of the job, job name must consist of lower case alphanumeric characters,
        '-' or '.', and must start and end with an alphanumeric character.


        :param display_name: The display_name of this Job.
        :type: str
        """
        self._display_name = display_name

    @property
    def compute_environment_id(self):
        """
        Gets the compute_environment_id of this Job.
        The OCID of the compute environment.


        :return: The compute_environment_id of this Job.
        :rtype: str
        """
        return self._compute_environment_id

    @compute_environment_id.setter
    def compute_environment_id(self, compute_environment_id):
        """
        Sets the compute_environment_id of this Job.
        The OCID of the compute environment.


        :param compute_environment_id: The compute_environment_id of this Job.
        :type: str
        """
        self._compute_environment_id = compute_environment_id

    @property
    def job_definition_id(self):
        """
        Gets the job_definition_id of this Job.
        The OCID of the job definition.


        :return: The job_definition_id of this Job.
        :rtype: str
        """
        return self._job_definition_id

    @job_definition_id.setter
    def job_definition_id(self, job_definition_id):
        """
        Sets the job_definition_id of this Job.
        The OCID of the job definition.


        :param job_definition_id: The job_definition_id of this Job.
        :type: str
        """
        self._job_definition_id = job_definition_id

    @property
    def batch_instance_id(self):
        """
        Gets the batch_instance_id of this Job.
        The OCID of the batch instance.


        :return: The batch_instance_id of this Job.
        :rtype: str
        """
        return self._batch_instance_id

    @batch_instance_id.setter
    def batch_instance_id(self, batch_instance_id):
        """
        Sets the batch_instance_id of this Job.
        The OCID of the batch instance.


        :param batch_instance_id: The batch_instance_id of this Job.
        :type: str
        """
        self._batch_instance_id = batch_instance_id

    @property
    def docker_image(self):
        """
        Gets the docker_image of this Job.
        The docker image of the job.


        :return: The docker_image of this Job.
        :rtype: str
        """
        return self._docker_image

    @docker_image.setter
    def docker_image(self, docker_image):
        """
        Sets the docker_image of this Job.
        The docker image of the job.


        :param docker_image: The docker_image of this Job.
        :type: str
        """
        self._docker_image = docker_image

    @property
    def command(self):
        """
        Gets the command of this Job.
        The command used to run the Job. The command and args must can be combined into one runnable command serially,
        such as \"command\": [\"ls\",\"-ll\"], \"args\": [\"/home\"], the command run to the job will be \"ls -ll /home\" .
        If you do not supply command or args, the defined in the job definition will be used.


        :return: The command of this Job.
        :rtype: list[str]
        """
        return self._command

    @command.setter
    def command(self, command):
        """
        Sets the command of this Job.
        The command used to run the Job. The command and args must can be combined into one runnable command serially,
        such as \"command\": [\"ls\",\"-ll\"], \"args\": [\"/home\"], the command run to the job will be \"ls -ll /home\" .
        If you do not supply command or args, the defined in the job definition will be used.


        :param command: The command of this Job.
        :type: list[str]
        """
        self._command = command

    @property
    def args(self):
        """
        Gets the args of this Job.
        The arguments passed to the command to run the Job, it's multiple such as
        [\"-a\",\"-k\"]. If you do not supply command or args, the defined in the job definition will be used.


        :return: The args of this Job.
        :rtype: list[str]
        """
        return self._args

    @args.setter
    def args(self, args):
        """
        Sets the args of this Job.
        The arguments passed to the command to run the Job, it's multiple such as
        [\"-a\",\"-k\"]. If you do not supply command or args, the defined in the job definition will be used.


        :param args: The args of this Job.
        :type: list[str]
        """
        self._args = args

    @property
    def environment_variables(self):
        """
        Gets the environment_variables of this Job.
        Environment variables used to run the JOB - user provided data -
        it's multiple such as [{\"name\": \"xxx\",\"value\": \"xxx\"}].


        :return: The environment_variables of this Job.
        :rtype: list[CreateJobDefinitionDetailsEnvironmentVariables]
        """
        return self._environment_variables

    @environment_variables.setter
    def environment_variables(self, environment_variables):
        """
        Sets the environment_variables of this Job.
        Environment variables used to run the JOB - user provided data -
        it's multiple such as [{\"name\": \"xxx\",\"value\": \"xxx\"}].


        :param environment_variables: The environment_variables of this Job.
        :type: list[CreateJobDefinitionDetailsEnvironmentVariables]
        """
        self._environment_variables = environment_variables

    @property
    def container_ocpu(self):
        """
        Gets the container_ocpu of this Job.
        An OCPU is defined as the CPU capacity equivalent of one physical core of an Intel Xeon processor
        with hyper threading enabled. OCPU for each container, for example 0.5.


        :return: The container_ocpu of this Job.
        :rtype: float
        """
        return self._container_ocpu

    @container_ocpu.setter
    def container_ocpu(self, container_ocpu):
        """
        Sets the container_ocpu of this Job.
        An OCPU is defined as the CPU capacity equivalent of one physical core of an Intel Xeon processor
        with hyper threading enabled. OCPU for each container, for example 0.5.


        :param container_ocpu: The container_ocpu of this Job.
        :type: float
        """
        self._container_ocpu = container_ocpu

    @property
    def container_memory_size_in_mbs(self):
        """
        Gets the container_memory_size_in_mbs of this Job.
        MB of memory for each container, for example 512.


        :return: The container_memory_size_in_mbs of this Job.
        :rtype: int
        """
        return self._container_memory_size_in_mbs

    @container_memory_size_in_mbs.setter
    def container_memory_size_in_mbs(self, container_memory_size_in_mbs):
        """
        Sets the container_memory_size_in_mbs of this Job.
        MB of memory for each container, for example 512.


        :param container_memory_size_in_mbs: The container_memory_size_in_mbs of this Job.
        :type: int
        """
        self._container_memory_size_in_mbs = container_memory_size_in_mbs

    @property
    def concurrency(self):
        """
        Gets the concurrency of this Job.
        Number of pods running on a job concurrently.


        :return: The concurrency of this Job.
        :rtype: int
        """
        return self._concurrency

    @concurrency.setter
    def concurrency(self, concurrency):
        """
        Sets the concurrency of this Job.
        Number of pods running on a job concurrently.


        :param concurrency: The concurrency of this Job.
        :type: int
        """
        self._concurrency = concurrency

    @property
    def count(self):
        """
        Gets the count of this Job.
        The number of pods that must successfully terminate before a job can reach the SUCCEEDED state.
        Pods that terminate unsuccessfully are retried until retryTimes has been exhausted or a job times out.


        :return: The count of this Job.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this Job.
        The number of pods that must successfully terminate before a job can reach the SUCCEEDED state.
        Pods that terminate unsuccessfully are retried until retryTimes has been exhausted or a job times out.


        :param count: The count of this Job.
        :type: int
        """
        self._count = count

    @property
    def retry_times(self):
        """
        Gets the retry_times of this Job.
        Specifies the number of retries before marking this job failed.


        :return: The retry_times of this Job.
        :rtype: int
        """
        return self._retry_times

    @retry_times.setter
    def retry_times(self, retry_times):
        """
        Sets the retry_times of this Job.
        Specifies the number of retries before marking this job failed.


        :param retry_times: The retry_times of this Job.
        :type: int
        """
        self._retry_times = retry_times

    @property
    def timeout_seconds(self):
        """
        Gets the timeout_seconds of this Job.
        Timeout seconds of JOB.


        :return: The timeout_seconds of this Job.
        :rtype: int
        """
        return self._timeout_seconds

    @timeout_seconds.setter
    def timeout_seconds(self, timeout_seconds):
        """
        Sets the timeout_seconds of this Job.
        Timeout seconds of JOB.


        :param timeout_seconds: The timeout_seconds of this Job.
        :type: int
        """
        self._timeout_seconds = timeout_seconds

    @property
    def priority(self):
        """
        Gets the priority of this Job.
        The priority of the job, higher values take precedence.


        :return: The priority of this Job.
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """
        Sets the priority of this Job.
        The priority of the job, higher values take precedence.


        :param priority: The priority of this Job.
        :type: int
        """
        self._priority = priority

    @property
    def docker_registry_secret(self):
        """
        Gets the docker_registry_secret of this Job.
        The secret name of the docker registry.


        :return: The docker_registry_secret of this Job.
        :rtype: str
        """
        return self._docker_registry_secret

    @docker_registry_secret.setter
    def docker_registry_secret(self, docker_registry_secret):
        """
        Sets the docker_registry_secret of this Job.
        The secret name of the docker registry.


        :param docker_registry_secret: The docker_registry_secret of this Job.
        :type: str
        """
        self._docker_registry_secret = docker_registry_secret

    @property
    def created_by_user_id(self):
        """
        Gets the created_by_user_id of this Job.
        The user OCID who created the job.


        :return: The created_by_user_id of this Job.
        :rtype: str
        """
        return self._created_by_user_id

    @created_by_user_id.setter
    def created_by_user_id(self, created_by_user_id):
        """
        Sets the created_by_user_id of this Job.
        The user OCID who created the job.


        :param created_by_user_id: The created_by_user_id of this Job.
        :type: str
        """
        self._created_by_user_id = created_by_user_id

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this Job.
        The current work request status of the job.

        Allowed values for this property are: "ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this Job.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this Job.
        The current work request status of the job.


        :param lifecycle_state: The lifecycle_state of this Job.
        :type: str
        """
        allowed_values = ["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def status_description(self):
        """
        Gets the status_description of this Job.
        Describe the backend operation details.


        :return: The status_description of this Job.
        :rtype: str
        """
        return self._status_description

    @status_description.setter
    def status_description(self, status_description):
        """
        Sets the status_description of this Job.
        Describe the backend operation details.


        :param status_description: The status_description of this Job.
        :type: str
        """
        self._status_description = status_description

    @property
    def error_code(self):
        """
        Gets the error_code of this Job.
        Describe the error message if the backend operation encounter error.


        :return: The error_code of this Job.
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code):
        """
        Sets the error_code of this Job.
        Describe the error message if the backend operation encounter error.


        :param error_code: The error_code of this Job.
        :type: str
        """
        self._error_code = error_code

    @property
    def job_kube_name(self):
        """
        Gets the job_kube_name of this Job.
        Job name in kubernetes.


        :return: The job_kube_name of this Job.
        :rtype: str
        """
        return self._job_kube_name

    @job_kube_name.setter
    def job_kube_name(self, job_kube_name):
        """
        Sets the job_kube_name of this Job.
        Job name in kubernetes.


        :param job_kube_name: The job_kube_name of this Job.
        :type: str
        """
        self._job_kube_name = job_kube_name

    @property
    def time_created(self):
        """
        Gets the time_created of this Job.
        The date and time the job was submitted. Format defined by RFC3339.


        :return: The time_created of this Job.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Job.
        The date and time the job was submitted. Format defined by RFC3339.


        :param time_created: The time_created of this Job.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_started(self):
        """
        Gets the time_started of this Job.
        The date and time the job was started. Format defined by RFC3339.


        :return: The time_started of this Job.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this Job.
        The date and time the job was started. Format defined by RFC3339.


        :param time_started: The time_started of this Job.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_completed(self):
        """
        Gets the time_completed of this Job.
        The date and time the job was completed. Format defined by RFC3339.


        :return: The time_completed of this Job.
        :rtype: datetime
        """
        return self._time_completed

    @time_completed.setter
    def time_completed(self, time_completed):
        """
        Sets the time_completed of this Job.
        The date and time the job was completed. Format defined by RFC3339.


        :param time_completed: The time_completed of this Job.
        :type: datetime
        """
        self._time_completed = time_completed

    @property
    def node_pool_id(self):
        """
        Gets the node_pool_id of this Job.
        The OCID of the node pool.


        :return: The node_pool_id of this Job.
        :rtype: str
        """
        return self._node_pool_id

    @node_pool_id.setter
    def node_pool_id(self, node_pool_id):
        """
        Sets the node_pool_id of this Job.
        The OCID of the node pool.


        :param node_pool_id: The node_pool_id of this Job.
        :type: str
        """
        self._node_pool_id = node_pool_id

    @property
    def job_log_stderr_path(self):
        """
        Gets the job_log_stderr_path of this Job.
        LOG PATH for job stderr path.


        :return: The job_log_stderr_path of this Job.
        :rtype: str
        """
        return self._job_log_stderr_path

    @job_log_stderr_path.setter
    def job_log_stderr_path(self, job_log_stderr_path):
        """
        Sets the job_log_stderr_path of this Job.
        LOG PATH for job stderr path.


        :param job_log_stderr_path: The job_log_stderr_path of this Job.
        :type: str
        """
        self._job_log_stderr_path = job_log_stderr_path

    @property
    def job_log_stdout_path(self):
        """
        Gets the job_log_stdout_path of this Job.
        LOG PATH for job stdout path.


        :return: The job_log_stdout_path of this Job.
        :rtype: str
        """
        return self._job_log_stdout_path

    @job_log_stdout_path.setter
    def job_log_stdout_path(self, job_log_stdout_path):
        """
        Sets the job_log_stdout_path of this Job.
        LOG PATH for job stdout path.


        :param job_log_stdout_path: The job_log_stdout_path of this Job.
        :type: str
        """
        self._job_log_stdout_path = job_log_stdout_path

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this Job.
        Free-form tags associated with this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this Job.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this Job.
        Free-form tags associated with this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this Job.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this Job.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this Job.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this Job.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this Job.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
