# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JobDefinitionSummary(object):
    """
    Condensed JobDefinition data when listing job definitions.
    """

    #: A constant which can be used with the lifecycle_state property of a JobDefinitionSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a JobDefinitionSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new JobDefinitionSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this JobDefinitionSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this JobDefinitionSummary.
        :type display_name: str

        :param batch_instance_id:
            The value to assign to the batch_instance_id property of this JobDefinitionSummary.
        :type batch_instance_id: str

        :param docker_image:
            The value to assign to the docker_image property of this JobDefinitionSummary.
        :type docker_image: str

        :param container_ocpu:
            The value to assign to the container_ocpu property of this JobDefinitionSummary.
        :type container_ocpu: float

        :param container_memory_size_in_mbs:
            The value to assign to the container_memory_size_in_mbs property of this JobDefinitionSummary.
        :type container_memory_size_in_mbs: int

        :param docker_registry_secret:
            The value to assign to the docker_registry_secret property of this JobDefinitionSummary.
        :type docker_registry_secret: str

        :param retry_times:
            The value to assign to the retry_times property of this JobDefinitionSummary.
        :type retry_times: int

        :param timeout_seconds:
            The value to assign to the timeout_seconds property of this JobDefinitionSummary.
        :type timeout_seconds: int

        :param command:
            The value to assign to the command property of this JobDefinitionSummary.
        :type command: list[str]

        :param time_created:
            The value to assign to the time_created property of this JobDefinitionSummary.
        :type time_created: datetime

        :param created_by_user_id:
            The value to assign to the created_by_user_id property of this JobDefinitionSummary.
        :type created_by_user_id: str

        :param modified_by_user_id:
            The value to assign to the modified_by_user_id property of this JobDefinitionSummary.
        :type modified_by_user_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this JobDefinitionSummary.
            Allowed values for this property are: "ACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this JobDefinitionSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this JobDefinitionSummary.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'batch_instance_id': 'str',
            'docker_image': 'str',
            'container_ocpu': 'float',
            'container_memory_size_in_mbs': 'int',
            'docker_registry_secret': 'str',
            'retry_times': 'int',
            'timeout_seconds': 'int',
            'command': 'list[str]',
            'time_created': 'datetime',
            'created_by_user_id': 'str',
            'modified_by_user_id': 'str',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'batch_instance_id': 'batchInstanceId',
            'docker_image': 'dockerImage',
            'container_ocpu': 'containerOcpu',
            'container_memory_size_in_mbs': 'containerMemorySizeInMbs',
            'docker_registry_secret': 'dockerRegistrySecret',
            'retry_times': 'retryTimes',
            'timeout_seconds': 'timeoutSeconds',
            'command': 'command',
            'time_created': 'timeCreated',
            'created_by_user_id': 'createdByUserId',
            'modified_by_user_id': 'modifiedByUserId',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._id = None
        self._display_name = None
        self._batch_instance_id = None
        self._docker_image = None
        self._container_ocpu = None
        self._container_memory_size_in_mbs = None
        self._docker_registry_secret = None
        self._retry_times = None
        self._timeout_seconds = None
        self._command = None
        self._time_created = None
        self._created_by_user_id = None
        self._modified_by_user_id = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def id(self):
        """
        Gets the id of this JobDefinitionSummary.
        The OCID of the job definition.


        :return: The id of this JobDefinitionSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this JobDefinitionSummary.
        The OCID of the job definition.


        :param id: The id of this JobDefinitionSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this JobDefinitionSummary.
        The name of the job definition.


        :return: The display_name of this JobDefinitionSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this JobDefinitionSummary.
        The name of the job definition.


        :param display_name: The display_name of this JobDefinitionSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def batch_instance_id(self):
        """
        Gets the batch_instance_id of this JobDefinitionSummary.
        The OCID of the batch instance.


        :return: The batch_instance_id of this JobDefinitionSummary.
        :rtype: str
        """
        return self._batch_instance_id

    @batch_instance_id.setter
    def batch_instance_id(self, batch_instance_id):
        """
        Sets the batch_instance_id of this JobDefinitionSummary.
        The OCID of the batch instance.


        :param batch_instance_id: The batch_instance_id of this JobDefinitionSummary.
        :type: str
        """
        self._batch_instance_id = batch_instance_id

    @property
    def docker_image(self):
        """
        Gets the docker_image of this JobDefinitionSummary.
        The docker image of the job.


        :return: The docker_image of this JobDefinitionSummary.
        :rtype: str
        """
        return self._docker_image

    @docker_image.setter
    def docker_image(self, docker_image):
        """
        Sets the docker_image of this JobDefinitionSummary.
        The docker image of the job.


        :param docker_image: The docker_image of this JobDefinitionSummary.
        :type: str
        """
        self._docker_image = docker_image

    @property
    def container_ocpu(self):
        """
        Gets the container_ocpu of this JobDefinitionSummary.
        An OCPU is defined as the CPU capacity equivalent of one physical core of an Intel Xeon processor
        with hyper threading enabled. OCPU for each container, for example 0.5.


        :return: The container_ocpu of this JobDefinitionSummary.
        :rtype: float
        """
        return self._container_ocpu

    @container_ocpu.setter
    def container_ocpu(self, container_ocpu):
        """
        Sets the container_ocpu of this JobDefinitionSummary.
        An OCPU is defined as the CPU capacity equivalent of one physical core of an Intel Xeon processor
        with hyper threading enabled. OCPU for each container, for example 0.5.


        :param container_ocpu: The container_ocpu of this JobDefinitionSummary.
        :type: float
        """
        self._container_ocpu = container_ocpu

    @property
    def container_memory_size_in_mbs(self):
        """
        Gets the container_memory_size_in_mbs of this JobDefinitionSummary.
        MB of memory for each container, for example 512.


        :return: The container_memory_size_in_mbs of this JobDefinitionSummary.
        :rtype: int
        """
        return self._container_memory_size_in_mbs

    @container_memory_size_in_mbs.setter
    def container_memory_size_in_mbs(self, container_memory_size_in_mbs):
        """
        Sets the container_memory_size_in_mbs of this JobDefinitionSummary.
        MB of memory for each container, for example 512.


        :param container_memory_size_in_mbs: The container_memory_size_in_mbs of this JobDefinitionSummary.
        :type: int
        """
        self._container_memory_size_in_mbs = container_memory_size_in_mbs

    @property
    def docker_registry_secret(self):
        """
        Gets the docker_registry_secret of this JobDefinitionSummary.
        The secret name of the docker registry.


        :return: The docker_registry_secret of this JobDefinitionSummary.
        :rtype: str
        """
        return self._docker_registry_secret

    @docker_registry_secret.setter
    def docker_registry_secret(self, docker_registry_secret):
        """
        Sets the docker_registry_secret of this JobDefinitionSummary.
        The secret name of the docker registry.


        :param docker_registry_secret: The docker_registry_secret of this JobDefinitionSummary.
        :type: str
        """
        self._docker_registry_secret = docker_registry_secret

    @property
    def retry_times(self):
        """
        Gets the retry_times of this JobDefinitionSummary.
        Specifies the number of retries before marking this job failed.


        :return: The retry_times of this JobDefinitionSummary.
        :rtype: int
        """
        return self._retry_times

    @retry_times.setter
    def retry_times(self, retry_times):
        """
        Sets the retry_times of this JobDefinitionSummary.
        Specifies the number of retries before marking this job failed.


        :param retry_times: The retry_times of this JobDefinitionSummary.
        :type: int
        """
        self._retry_times = retry_times

    @property
    def timeout_seconds(self):
        """
        Gets the timeout_seconds of this JobDefinitionSummary.
        Timeout seconds of JOB.


        :return: The timeout_seconds of this JobDefinitionSummary.
        :rtype: int
        """
        return self._timeout_seconds

    @timeout_seconds.setter
    def timeout_seconds(self, timeout_seconds):
        """
        Sets the timeout_seconds of this JobDefinitionSummary.
        Timeout seconds of JOB.


        :param timeout_seconds: The timeout_seconds of this JobDefinitionSummary.
        :type: int
        """
        self._timeout_seconds = timeout_seconds

    @property
    def command(self):
        """
        Gets the command of this JobDefinitionSummary.
        The command used to run the Job. The command and args must can be combined into one runnable command serially,
        such as \"command\": [\"ls\",\"-ll\"], \"args\": [\"/home\"], the command run to the job will be \"ls -ll /home\" .
        If you do not supply command or args, the defaults defined in the job will be used.


        :return: The command of this JobDefinitionSummary.
        :rtype: list[str]
        """
        return self._command

    @command.setter
    def command(self, command):
        """
        Sets the command of this JobDefinitionSummary.
        The command used to run the Job. The command and args must can be combined into one runnable command serially,
        such as \"command\": [\"ls\",\"-ll\"], \"args\": [\"/home\"], the command run to the job will be \"ls -ll /home\" .
        If you do not supply command or args, the defaults defined in the job will be used.


        :param command: The command of this JobDefinitionSummary.
        :type: list[str]
        """
        self._command = command

    @property
    def time_created(self):
        """
        Gets the time_created of this JobDefinitionSummary.
        The date and time the job definition was created. Format defined by RFC3339.


        :return: The time_created of this JobDefinitionSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this JobDefinitionSummary.
        The date and time the job definition was created. Format defined by RFC3339.


        :param time_created: The time_created of this JobDefinitionSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def created_by_user_id(self):
        """
        Gets the created_by_user_id of this JobDefinitionSummary.
        The user OCID who created the job definition.


        :return: The created_by_user_id of this JobDefinitionSummary.
        :rtype: str
        """
        return self._created_by_user_id

    @created_by_user_id.setter
    def created_by_user_id(self, created_by_user_id):
        """
        Sets the created_by_user_id of this JobDefinitionSummary.
        The user OCID who created the job definition.


        :param created_by_user_id: The created_by_user_id of this JobDefinitionSummary.
        :type: str
        """
        self._created_by_user_id = created_by_user_id

    @property
    def modified_by_user_id(self):
        """
        Gets the modified_by_user_id of this JobDefinitionSummary.
        The user OCID who modified the job definition.


        :return: The modified_by_user_id of this JobDefinitionSummary.
        :rtype: str
        """
        return self._modified_by_user_id

    @modified_by_user_id.setter
    def modified_by_user_id(self, modified_by_user_id):
        """
        Sets the modified_by_user_id of this JobDefinitionSummary.
        The user OCID who modified the job definition.


        :param modified_by_user_id: The modified_by_user_id of this JobDefinitionSummary.
        :type: str
        """
        self._modified_by_user_id = modified_by_user_id

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this JobDefinitionSummary.
        The current state of the job definition.

        Allowed values for this property are: "ACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this JobDefinitionSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this JobDefinitionSummary.
        The current state of the job definition.


        :param lifecycle_state: The lifecycle_state of this JobDefinitionSummary.
        :type: str
        """
        allowed_values = ["ACTIVE", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this JobDefinitionSummary.
        Free-form tags associated with this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this JobDefinitionSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this JobDefinitionSummary.
        Free-form tags associated with this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this JobDefinitionSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this JobDefinitionSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this JobDefinitionSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this JobDefinitionSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this JobDefinitionSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
