# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LogSummary(object):
    """
    Log file for a job's execution.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LogSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this LogSummary.
        :type id: str

        :param job_log_url:
            The value to assign to the job_log_url property of this LogSummary.
        :type job_log_url: str

        """
        self.swagger_types = {
            'id': 'str',
            'job_log_url': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'job_log_url': 'jobLogUrl'
        }

        self._id = None
        self._job_log_url = None

    @property
    def id(self):
        """
        Gets the id of this LogSummary.
        Log id.


        :return: The id of this LogSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this LogSummary.
        Log id.


        :param id: The id of this LogSummary.
        :type: str
        """
        self._id = id

    @property
    def job_log_url(self):
        """
        Gets the job_log_url of this LogSummary.
        URL for the log content.


        :return: The job_log_url of this LogSummary.
        :rtype: str
        """
        return self._job_log_url

    @job_log_url.setter
    def job_log_url(self, job_log_url):
        """
        Sets the job_log_url of this LogSummary.
        URL for the log content.


        :param job_log_url: The job_log_url of this LogSummary.
        :type: str
        """
        self._job_log_url = job_log_url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
