# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RemoveCloudSqlDetails(object):
    """
    The information about removed Cloud SQL capability
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RemoveCloudSqlDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cluster_admin_password:
            The value to assign to the cluster_admin_password property of this RemoveCloudSqlDetails.
        :type cluster_admin_password: str

        """
        self.swagger_types = {
            'cluster_admin_password': 'str'
        }

        self.attribute_map = {
            'cluster_admin_password': 'clusterAdminPassword'
        }

        self._cluster_admin_password = None

    @property
    def cluster_admin_password(self):
        """
        **[Required]** Gets the cluster_admin_password of this RemoveCloudSqlDetails.
        Base-64 encoded password for Cloudera Manager admin user


        :return: The cluster_admin_password of this RemoveCloudSqlDetails.
        :rtype: str
        """
        return self._cluster_admin_password

    @cluster_admin_password.setter
    def cluster_admin_password(self, cluster_admin_password):
        """
        Sets the cluster_admin_password of this RemoveCloudSqlDetails.
        Base-64 encoded password for Cloudera Manager admin user


        :param cluster_admin_password: The cluster_admin_password of this RemoveCloudSqlDetails.
        :type: str
        """
        self._cluster_admin_password = cluster_admin_password

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
