# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.

from __future__ import absolute_import

from .create_replicated_cache_details import CreateReplicatedCacheDetails
from .end_point import EndPoint
from .redis_node_details import RedisNodeDetails
from .redis_shape_summary import RedisShapeSummary
from .redis_version_summary import RedisVersionSummary
from .replicated_cache import ReplicatedCache
from .replicated_cache_summary import ReplicatedCacheSummary
from .update_replicated_cache_details import UpdateReplicatedCacheDetails
from .work_request import WorkRequest
from .work_request_error import WorkRequestError
from .work_request_log_entry import WorkRequestLogEntry
from .work_request_resource import WorkRequestResource
from .work_request_summary import WorkRequestSummary

# Maps type names to classes for cache services.
cache_type_mapping = {
    "CreateReplicatedCacheDetails": CreateReplicatedCacheDetails,
    "EndPoint": EndPoint,
    "RedisNodeDetails": RedisNodeDetails,
    "RedisShapeSummary": RedisShapeSummary,
    "RedisVersionSummary": RedisVersionSummary,
    "ReplicatedCache": ReplicatedCache,
    "ReplicatedCacheSummary": ReplicatedCacheSummary,
    "UpdateReplicatedCacheDetails": UpdateReplicatedCacheDetails,
    "WorkRequest": WorkRequest,
    "WorkRequestError": WorkRequestError,
    "WorkRequestLogEntry": WorkRequestLogEntry,
    "WorkRequestResource": WorkRequestResource,
    "WorkRequestSummary": WorkRequestSummary
}
