# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateReplicatedCacheDetails(object):
    """
    The properties that are required to create the Redis replicated cache.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateReplicatedCacheDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateReplicatedCacheDetails.
        :type compartment_id: str

        :param name:
            The value to assign to the name property of this CreateReplicatedCacheDetails.
        :type name: str

        :param description:
            The value to assign to the description property of this CreateReplicatedCacheDetails.
        :type description: str

        :param vcn_id:
            The value to assign to the vcn_id property of this CreateReplicatedCacheDetails.
        :type vcn_id: str

        :param redis_nodes:
            The value to assign to the redis_nodes property of this CreateReplicatedCacheDetails.
        :type redis_nodes: list[RedisNodeDetails]

        :param replica_count:
            The value to assign to the replica_count property of this CreateReplicatedCacheDetails.
        :type replica_count: int

        :param shape:
            The value to assign to the shape property of this CreateReplicatedCacheDetails.
        :type shape: str

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateReplicatedCacheDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateReplicatedCacheDetails.
        :type freeform_tags: dict(str, str)

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'name': 'str',
            'description': 'str',
            'vcn_id': 'str',
            'redis_nodes': 'list[RedisNodeDetails]',
            'replica_count': 'int',
            'shape': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'name': 'name',
            'description': 'description',
            'vcn_id': 'vcnId',
            'redis_nodes': 'redisNodes',
            'replica_count': 'replicaCount',
            'shape': 'shape',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags'
        }

        self._compartment_id = None
        self._name = None
        self._description = None
        self._vcn_id = None
        self._redis_nodes = None
        self._replica_count = None
        self._shape = None
        self._defined_tags = None
        self._freeform_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateReplicatedCacheDetails.
        The OCID of a compartment in the customer's tenancy. A Redis replicated cache object is created in this compartment. The object represents the logical set of Redis server instances that are deployed in an Oracle-managed tenancy. The Redis server instances are network accessible from the customer's tenancy.


        :return: The compartment_id of this CreateReplicatedCacheDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateReplicatedCacheDetails.
        The OCID of a compartment in the customer's tenancy. A Redis replicated cache object is created in this compartment. The object represents the logical set of Redis server instances that are deployed in an Oracle-managed tenancy. The Redis server instances are network accessible from the customer's tenancy.


        :param compartment_id: The compartment_id of this CreateReplicatedCacheDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreateReplicatedCacheDetails.
        A user-friendly name. Avoid entering confidential information.


        :return: The name of this CreateReplicatedCacheDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateReplicatedCacheDetails.
        A user-friendly name. Avoid entering confidential information.


        :param name: The name of this CreateReplicatedCacheDetails.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this CreateReplicatedCacheDetails.
        A description of the Redis replicated cache. Avoid entering confidential information.


        :return: The description of this CreateReplicatedCacheDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateReplicatedCacheDetails.
        A description of the Redis replicated cache. Avoid entering confidential information.


        :param description: The description of this CreateReplicatedCacheDetails.
        :type: str
        """
        self._description = description

    @property
    def vcn_id(self):
        """
        **[Required]** Gets the vcn_id of this CreateReplicatedCacheDetails.
        The OCID of a VCN in the customer's tenancy. The VCN must be located in the specified compartment. The VCN contains the network resources and subnets that allow access to the Redis nodes that are deployed in an Oracle-managed tenancy.


        :return: The vcn_id of this CreateReplicatedCacheDetails.
        :rtype: str
        """
        return self._vcn_id

    @vcn_id.setter
    def vcn_id(self, vcn_id):
        """
        Sets the vcn_id of this CreateReplicatedCacheDetails.
        The OCID of a VCN in the customer's tenancy. The VCN must be located in the specified compartment. The VCN contains the network resources and subnets that allow access to the Redis nodes that are deployed in an Oracle-managed tenancy.


        :param vcn_id: The vcn_id of this CreateReplicatedCacheDetails.
        :type: str
        """
        self._vcn_id = vcn_id

    @property
    def redis_nodes(self):
        """
        Gets the redis_nodes of this CreateReplicatedCacheDetails.
        The primary Redis node and up to 5 replication nodes. Each node hosts a Redis server instance and is associated with a specific availability domain and subnet.


        :return: The redis_nodes of this CreateReplicatedCacheDetails.
        :rtype: list[RedisNodeDetails]
        """
        return self._redis_nodes

    @redis_nodes.setter
    def redis_nodes(self, redis_nodes):
        """
        Sets the redis_nodes of this CreateReplicatedCacheDetails.
        The primary Redis node and up to 5 replication nodes. Each node hosts a Redis server instance and is associated with a specific availability domain and subnet.


        :param redis_nodes: The redis_nodes of this CreateReplicatedCacheDetails.
        :type: list[RedisNodeDetails]
        """
        self._redis_nodes = redis_nodes

    @property
    def replica_count(self):
        """
        **[Required]** Gets the replica_count of this CreateReplicatedCacheDetails.
        The number of Redis replication nodes.


        :return: The replica_count of this CreateReplicatedCacheDetails.
        :rtype: int
        """
        return self._replica_count

    @replica_count.setter
    def replica_count(self, replica_count):
        """
        Sets the replica_count of this CreateReplicatedCacheDetails.
        The number of Redis replication nodes.


        :param replica_count: The replica_count of this CreateReplicatedCacheDetails.
        :type: int
        """
        self._replica_count = replica_count

    @property
    def shape(self):
        """
        **[Required]** Gets the shape of this CreateReplicatedCacheDetails.
        The physical characteristics (memory, network bandwidth, OCPUs, and so on) of the virtual machine on which the Redis node runs. The shape determines the amount of memory allocated to the Redis replicated cache.


        :return: The shape of this CreateReplicatedCacheDetails.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this CreateReplicatedCacheDetails.
        The physical characteristics (memory, network bandwidth, OCPUs, and so on) of the virtual machine on which the Redis node runs. The shape determines the amount of memory allocated to the Redis replicated cache.


        :param shape: The shape of this CreateReplicatedCacheDetails.
        :type: str
        """
        self._shape = shape

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateReplicatedCacheDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`


        :return: The defined_tags of this CreateReplicatedCacheDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateReplicatedCacheDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`


        :param defined_tags: The defined_tags of this CreateReplicatedCacheDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateReplicatedCacheDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        Example: `{\"Department\": \"Finance\"}`


        :return: The freeform_tags of this CreateReplicatedCacheDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateReplicatedCacheDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        Example: `{\"Department\": \"Finance\"}`


        :param freeform_tags: The freeform_tags of this CreateReplicatedCacheDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
