# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EndPoint(object):
    """
    An endpoint for accessing a Redis replicated cache.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new EndPoint object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param hostname:
            The value to assign to the hostname property of this EndPoint.
        :type hostname: str

        :param ip:
            The value to assign to the ip property of this EndPoint.
        :type ip: str

        :param port:
            The value to assign to the port property of this EndPoint.
        :type port: int

        :param is_primary:
            The value to assign to the is_primary property of this EndPoint.
        :type is_primary: bool

        :param subnet_id:
            The value to assign to the subnet_id property of this EndPoint.
        :type subnet_id: str

        :param availability_domain:
            The value to assign to the availability_domain property of this EndPoint.
        :type availability_domain: str

        """
        self.swagger_types = {
            'hostname': 'str',
            'ip': 'str',
            'port': 'int',
            'is_primary': 'bool',
            'subnet_id': 'str',
            'availability_domain': 'str'
        }

        self.attribute_map = {
            'hostname': 'hostname',
            'ip': 'ip',
            'port': 'port',
            'is_primary': 'isPrimary',
            'subnet_id': 'subnetId',
            'availability_domain': 'availabilityDomain'
        }

        self._hostname = None
        self._ip = None
        self._port = None
        self._is_primary = None
        self._subnet_id = None
        self._availability_domain = None

    @property
    def hostname(self):
        """
        Gets the hostname of this EndPoint.
        The hostname of the endpoint.


        :return: The hostname of this EndPoint.
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """
        Sets the hostname of this EndPoint.
        The hostname of the endpoint.


        :param hostname: The hostname of this EndPoint.
        :type: str
        """
        self._hostname = hostname

    @property
    def ip(self):
        """
        **[Required]** Gets the ip of this EndPoint.
        The IP of the endpoint.


        :return: The ip of this EndPoint.
        :rtype: str
        """
        return self._ip

    @ip.setter
    def ip(self, ip):
        """
        Sets the ip of this EndPoint.
        The IP of the endpoint.


        :param ip: The ip of this EndPoint.
        :type: str
        """
        self._ip = ip

    @property
    def port(self):
        """
        **[Required]** Gets the port of this EndPoint.
        The port of the endpoint.


        :return: The port of this EndPoint.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this EndPoint.
        The port of the endpoint.


        :param port: The port of this EndPoint.
        :type: int
        """
        self._port = port

    @property
    def is_primary(self):
        """
        **[Required]** Gets the is_primary of this EndPoint.
        A flag that indicates the primary Redis node.


        :return: The is_primary of this EndPoint.
        :rtype: bool
        """
        return self._is_primary

    @is_primary.setter
    def is_primary(self, is_primary):
        """
        Sets the is_primary of this EndPoint.
        A flag that indicates the primary Redis node.


        :param is_primary: The is_primary of this EndPoint.
        :type: bool
        """
        self._is_primary = is_primary

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this EndPoint.
        The subnet id of this Redis node.


        :return: The subnet_id of this EndPoint.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this EndPoint.
        The subnet id of this Redis node.


        :param subnet_id: The subnet_id of this EndPoint.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this EndPoint.
        The availability domain of this Redis node.


        :return: The availability_domain of this EndPoint.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this EndPoint.
        The availability domain of this Redis node.


        :param availability_domain: The availability_domain of this EndPoint.
        :type: str
        """
        self._availability_domain = availability_domain

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
