# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RedisNodeDetails(object):
    """
    The Redis nodes that host the Redis servers. The nodes are created in the specified availability domain.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RedisNodeDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param availability_domain:
            The value to assign to the availability_domain property of this RedisNodeDetails.
        :type availability_domain: str

        :param subnet_id:
            The value to assign to the subnet_id property of this RedisNodeDetails.
        :type subnet_id: str

        :param is_primary:
            The value to assign to the is_primary property of this RedisNodeDetails.
        :type is_primary: bool

        """
        self.swagger_types = {
            'availability_domain': 'str',
            'subnet_id': 'str',
            'is_primary': 'bool'
        }

        self.attribute_map = {
            'availability_domain': 'availabilityDomain',
            'subnet_id': 'subnetId',
            'is_primary': 'isPrimary'
        }

        self._availability_domain = None
        self._subnet_id = None
        self._is_primary = None

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this RedisNodeDetails.
        The name of the availability domain where the Redis node should be located.


        :return: The availability_domain of this RedisNodeDetails.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this RedisNodeDetails.
        The name of the availability domain where the Redis node should be located.


        :param availability_domain: The availability_domain of this RedisNodeDetails.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this RedisNodeDetails.
        The subnet id to which this Redis node is attached.


        :return: The subnet_id of this RedisNodeDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this RedisNodeDetails.
        The subnet id to which this Redis node is attached.


        :param subnet_id: The subnet_id of this RedisNodeDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def is_primary(self):
        """
        Gets the is_primary of this RedisNodeDetails.
        Whether this node should be the primary Redis node. The default value is `false`.


        :return: The is_primary of this RedisNodeDetails.
        :rtype: bool
        """
        return self._is_primary

    @is_primary.setter
    def is_primary(self, is_primary):
        """
        Sets the is_primary of this RedisNodeDetails.
        Whether this node should be the primary Redis node. The default value is `false`.


        :param is_primary: The is_primary of this RedisNodeDetails.
        :type: bool
        """
        self._is_primary = is_primary

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
