# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RedisShapeSummary(object):
    """
    The amount of memory allocated to the Redis replicated cache.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RedisShapeSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param shape:
            The value to assign to the shape property of this RedisShapeSummary.
        :type shape: str

        """
        self.swagger_types = {
            'shape': 'str'
        }

        self.attribute_map = {
            'shape': 'shape'
        }

        self._shape = None

    @property
    def shape(self):
        """
        **[Required]** Gets the shape of this RedisShapeSummary.
        Redis shape


        :return: The shape of this RedisShapeSummary.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this RedisShapeSummary.
        Redis shape


        :param shape: The shape of this RedisShapeSummary.
        :type: str
        """
        self._shape = shape

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
