# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReplicatedCache(object):
    """
    Details of the Redis replicated cache. Redis replicated caches are comprised of Oracle-managed Redis nodes that each contain a replica of the cached data. The cache is accessible from a tenant's compartment using a published endpoint.
    """

    #: A constant which can be used with the lifecycle_state property of a ReplicatedCache.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a ReplicatedCache.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ReplicatedCache.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a ReplicatedCache.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a ReplicatedCache.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a ReplicatedCache.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new ReplicatedCache object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ReplicatedCache.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ReplicatedCache.
        :type compartment_id: str

        :param vcn_id:
            The value to assign to the vcn_id property of this ReplicatedCache.
        :type vcn_id: str

        :param name:
            The value to assign to the name property of this ReplicatedCache.
        :type name: str

        :param description:
            The value to assign to the description property of this ReplicatedCache.
        :type description: str

        :param replica_count:
            The value to assign to the replica_count property of this ReplicatedCache.
        :type replica_count: int

        :param shape:
            The value to assign to the shape property of this ReplicatedCache.
        :type shape: str

        :param redis_nodes:
            The value to assign to the redis_nodes property of this ReplicatedCache.
        :type redis_nodes: list[EndPoint]

        :param time_created:
            The value to assign to the time_created property of this ReplicatedCache.
        :type time_created: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ReplicatedCache.
            Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param defined_tags:
            The value to assign to the defined_tags property of this ReplicatedCache.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ReplicatedCache.
        :type freeform_tags: dict(str, str)

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'vcn_id': 'str',
            'name': 'str',
            'description': 'str',
            'replica_count': 'int',
            'shape': 'str',
            'redis_nodes': 'list[EndPoint]',
            'time_created': 'datetime',
            'lifecycle_state': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)'
        }

        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'vcn_id': 'vcnId',
            'name': 'name',
            'description': 'description',
            'replica_count': 'replicaCount',
            'shape': 'shape',
            'redis_nodes': 'redisNodes',
            'time_created': 'timeCreated',
            'lifecycle_state': 'lifecycleState',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags'
        }

        self._id = None
        self._compartment_id = None
        self._vcn_id = None
        self._name = None
        self._description = None
        self._replica_count = None
        self._shape = None
        self._redis_nodes = None
        self._time_created = None
        self._lifecycle_state = None
        self._defined_tags = None
        self._freeform_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ReplicatedCache.
        The OCID of the Redis replicated cache.


        :return: The id of this ReplicatedCache.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ReplicatedCache.
        The OCID of the Redis replicated cache.


        :param id: The id of this ReplicatedCache.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ReplicatedCache.
        The compartment OCID from which the Redis replicated cache is accessible.


        :return: The compartment_id of this ReplicatedCache.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ReplicatedCache.
        The compartment OCID from which the Redis replicated cache is accessible.


        :param compartment_id: The compartment_id of this ReplicatedCache.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def vcn_id(self):
        """
        **[Required]** Gets the vcn_id of this ReplicatedCache.
        The VCN OCID that contains the network resources and subnets to which the Redis nodes are attached.


        :return: The vcn_id of this ReplicatedCache.
        :rtype: str
        """
        return self._vcn_id

    @vcn_id.setter
    def vcn_id(self, vcn_id):
        """
        Sets the vcn_id of this ReplicatedCache.
        The VCN OCID that contains the network resources and subnets to which the Redis nodes are attached.


        :param vcn_id: The vcn_id of this ReplicatedCache.
        :type: str
        """
        self._vcn_id = vcn_id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this ReplicatedCache.
        The name of the Redis replicated cache


        :return: The name of this ReplicatedCache.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ReplicatedCache.
        The name of the Redis replicated cache


        :param name: The name of this ReplicatedCache.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this ReplicatedCache.
        A brief description of the Redis replicated cache


        :return: The description of this ReplicatedCache.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ReplicatedCache.
        A brief description of the Redis replicated cache


        :param description: The description of this ReplicatedCache.
        :type: str
        """
        self._description = description

    @property
    def replica_count(self):
        """
        **[Required]** Gets the replica_count of this ReplicatedCache.
        The number of replica nodes that make up the Redis replicated cache.


        :return: The replica_count of this ReplicatedCache.
        :rtype: int
        """
        return self._replica_count

    @replica_count.setter
    def replica_count(self, replica_count):
        """
        Sets the replica_count of this ReplicatedCache.
        The number of replica nodes that make up the Redis replicated cache.


        :param replica_count: The replica_count of this ReplicatedCache.
        :type: int
        """
        self._replica_count = replica_count

    @property
    def shape(self):
        """
        **[Required]** Gets the shape of this ReplicatedCache.
        The amount of memory allocated to the Redis replicated cache.


        :return: The shape of this ReplicatedCache.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this ReplicatedCache.
        The amount of memory allocated to the Redis replicated cache.


        :param shape: The shape of this ReplicatedCache.
        :type: str
        """
        self._shape = shape

    @property
    def redis_nodes(self):
        """
        **[Required]** Gets the redis_nodes of this ReplicatedCache.
        The endpoints of the replicas that make up the Redis replicated cache.


        :return: The redis_nodes of this ReplicatedCache.
        :rtype: list[EndPoint]
        """
        return self._redis_nodes

    @redis_nodes.setter
    def redis_nodes(self, redis_nodes):
        """
        Sets the redis_nodes of this ReplicatedCache.
        The endpoints of the replicas that make up the Redis replicated cache.


        :param redis_nodes: The redis_nodes of this ReplicatedCache.
        :type: list[EndPoint]
        """
        self._redis_nodes = redis_nodes

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ReplicatedCache.
        Cache creation timestamp. Format defined by RFC3339.


        :return: The time_created of this ReplicatedCache.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ReplicatedCache.
        Cache creation timestamp. Format defined by RFC3339.


        :param time_created: The time_created of this ReplicatedCache.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ReplicatedCache.
        The `lifecycleState` of the Redis replicated cache.

        Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ReplicatedCache.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ReplicatedCache.
        The `lifecycleState` of the Redis replicated cache.


        :param lifecycle_state: The lifecycle_state of this ReplicatedCache.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ReplicatedCache.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`


        :return: The defined_tags of this ReplicatedCache.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ReplicatedCache.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`


        :param defined_tags: The defined_tags of this ReplicatedCache.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ReplicatedCache.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        Example: `{\"Department\": \"Finance\"}`


        :return: The freeform_tags of this ReplicatedCache.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ReplicatedCache.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        Example: `{\"Department\": \"Finance\"}`


        :param freeform_tags: The freeform_tags of this ReplicatedCache.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
