# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReplicatedCacheSummary(object):
    """
    Summary information of the Redis replicated cache.
    """

    #: A constant which can be used with the lifecycle_state property of a ReplicatedCacheSummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a ReplicatedCacheSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ReplicatedCacheSummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a ReplicatedCacheSummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a ReplicatedCacheSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a ReplicatedCacheSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new ReplicatedCacheSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ReplicatedCacheSummary.
        :type id: str

        :param name:
            The value to assign to the name property of this ReplicatedCacheSummary.
        :type name: str

        :param description:
            The value to assign to the description property of this ReplicatedCacheSummary.
        :type description: str

        :param replica_count:
            The value to assign to the replica_count property of this ReplicatedCacheSummary.
        :type replica_count: int

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ReplicatedCacheSummary.
            Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param resource_uri:
            The value to assign to the resource_uri property of this ReplicatedCacheSummary.
        :type resource_uri: str

        :param shape:
            The value to assign to the shape property of this ReplicatedCacheSummary.
        :type shape: str

        :param defined_tags:
            The value to assign to the defined_tags property of this ReplicatedCacheSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ReplicatedCacheSummary.
        :type freeform_tags: dict(str, str)

        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'replica_count': 'int',
            'lifecycle_state': 'str',
            'resource_uri': 'str',
            'shape': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'replica_count': 'replicaCount',
            'lifecycle_state': 'lifecycleState',
            'resource_uri': 'resourceUri',
            'shape': 'shape',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags'
        }

        self._id = None
        self._name = None
        self._description = None
        self._replica_count = None
        self._lifecycle_state = None
        self._resource_uri = None
        self._shape = None
        self._defined_tags = None
        self._freeform_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ReplicatedCacheSummary.
        The OCID of the Redis replicated cache.


        :return: The id of this ReplicatedCacheSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ReplicatedCacheSummary.
        The OCID of the Redis replicated cache.


        :param id: The id of this ReplicatedCacheSummary.
        :type: str
        """
        self._id = id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this ReplicatedCacheSummary.
        The name of the Redis replicated cache.


        :return: The name of this ReplicatedCacheSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ReplicatedCacheSummary.
        The name of the Redis replicated cache.


        :param name: The name of this ReplicatedCacheSummary.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this ReplicatedCacheSummary.
        A brief description of the Redis replicated cache.


        :return: The description of this ReplicatedCacheSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ReplicatedCacheSummary.
        A brief description of the Redis replicated cache.


        :param description: The description of this ReplicatedCacheSummary.
        :type: str
        """
        self._description = description

    @property
    def replica_count(self):
        """
        **[Required]** Gets the replica_count of this ReplicatedCacheSummary.
        The number of replicas that make up the Redis replicated cache.


        :return: The replica_count of this ReplicatedCacheSummary.
        :rtype: int
        """
        return self._replica_count

    @replica_count.setter
    def replica_count(self, replica_count):
        """
        Sets the replica_count of this ReplicatedCacheSummary.
        The number of replicas that make up the Redis replicated cache.


        :param replica_count: The replica_count of this ReplicatedCacheSummary.
        :type: int
        """
        self._replica_count = replica_count

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ReplicatedCacheSummary.
        The `lifecycleState` of the Redis replicated cache.

        Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ReplicatedCacheSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ReplicatedCacheSummary.
        The `lifecycleState` of the Redis replicated cache.


        :param lifecycle_state: The lifecycle_state of this ReplicatedCacheSummary.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def resource_uri(self):
        """
        **[Required]** Gets the resource_uri of this ReplicatedCacheSummary.
        The URI to access detailed information about the Redis replicated cache.


        :return: The resource_uri of this ReplicatedCacheSummary.
        :rtype: str
        """
        return self._resource_uri

    @resource_uri.setter
    def resource_uri(self, resource_uri):
        """
        Sets the resource_uri of this ReplicatedCacheSummary.
        The URI to access detailed information about the Redis replicated cache.


        :param resource_uri: The resource_uri of this ReplicatedCacheSummary.
        :type: str
        """
        self._resource_uri = resource_uri

    @property
    def shape(self):
        """
        **[Required]** Gets the shape of this ReplicatedCacheSummary.
        The amount of memory allocated to the Redis replicated cache.


        :return: The shape of this ReplicatedCacheSummary.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this ReplicatedCacheSummary.
        The amount of memory allocated to the Redis replicated cache.


        :param shape: The shape of this ReplicatedCacheSummary.
        :type: str
        """
        self._shape = shape

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this ReplicatedCacheSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`


        :return: The defined_tags of this ReplicatedCacheSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ReplicatedCacheSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`


        :param defined_tags: The defined_tags of this ReplicatedCacheSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this ReplicatedCacheSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        Example: `{\"Department\": \"Finance\"}`


        :return: The freeform_tags of this ReplicatedCacheSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ReplicatedCacheSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        Example: `{\"Department\": \"Finance\"}`


        :param freeform_tags: The freeform_tags of this ReplicatedCacheSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
