# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.

from __future__ import absolute_import

from .classifier import Classifier
from .contact import Contact
from .contact_list import ContactList
from .create_incident_details import CreateIncidentDetails
from .incident import Incident
from .incident_type import IncidentType
from .item import Item
from .limit_item import LimitItem
from .paginated_response import PaginatedResponse
from .paginated_response_incident import PaginatedResponseIncident
from .paginated_response_incident_type import PaginatedResponseIncidentType
from .reporter import Reporter
from .resource import Resource
from .status import Status
from .tenant import Tenant
from .ticket import Ticket
from .type import Type
from .update_incident_details import UpdateIncidentDetails
from .validation_response import ValidationResponse

# Maps type names to classes for cims services.
cims_type_mapping = {
    "Classifier": Classifier,
    "Contact": Contact,
    "ContactList": ContactList,
    "CreateIncidentDetails": CreateIncidentDetails,
    "Incident": Incident,
    "IncidentType": IncidentType,
    "Item": Item,
    "LimitItem": LimitItem,
    "PaginatedResponse": PaginatedResponse,
    "PaginatedResponseIncident": PaginatedResponseIncident,
    "PaginatedResponseIncidentType": PaginatedResponseIncidentType,
    "Reporter": Reporter,
    "Resource": Resource,
    "Status": Status,
    "Tenant": Tenant,
    "Ticket": Ticket,
    "Type": Type,
    "UpdateIncidentDetails": UpdateIncidentDetails,
    "ValidationResponse": ValidationResponse
}
