# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Classifier(object):
    """
    Incident Classifier
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Classifier object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Classifier.
        :type id: str

        :param name:
            The value to assign to the name property of this Classifier.
        :type name: str

        :param label:
            The value to assign to the label property of this Classifier.
        :type label: str

        :param description:
            The value to assign to the description property of this Classifier.
        :type description: str

        :param scope:
            The value to assign to the scope property of this Classifier.
        :type scope: Scope

        :param unit:
            The value to assign to the unit property of this Classifier.
        :type unit: Unit

        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'label': 'str',
            'description': 'str',
            'scope': 'Scope',
            'unit': 'Unit'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'label': 'label',
            'description': 'description',
            'scope': 'scope',
            'unit': 'unit'
        }

        self._id = None
        self._name = None
        self._label = None
        self._description = None
        self._scope = None
        self._unit = None

    @property
    def id(self):
        """
        Gets the id of this Classifier.

        :return: The id of this Classifier.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Classifier.

        :param id: The id of this Classifier.
        :type: str
        """
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Classifier.

        :return: The name of this Classifier.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Classifier.

        :param name: The name of this Classifier.
        :type: str
        """
        self._name = name

    @property
    def label(self):
        """
        Gets the label of this Classifier.

        :return: The label of this Classifier.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this Classifier.

        :param label: The label of this Classifier.
        :type: str
        """
        self._label = label

    @property
    def description(self):
        """
        Gets the description of this Classifier.

        :return: The description of this Classifier.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Classifier.

        :param description: The description of this Classifier.
        :type: str
        """
        self._description = description

    @property
    def scope(self):
        """
        Gets the scope of this Classifier.

        :return: The scope of this Classifier.
        :rtype: Scope
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """
        Sets the scope of this Classifier.

        :param scope: The scope of this Classifier.
        :type: Scope
        """
        self._scope = scope

    @property
    def unit(self):
        """
        Gets the unit of this Classifier.

        :return: The unit of this Classifier.
        :rtype: Unit
        """
        return self._unit

    @unit.setter
    def unit(self, unit):
        """
        Sets the unit of this Classifier.

        :param unit: The unit of this Classifier.
        :type: Unit
        """
        self._unit = unit

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
