# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Contact(object):
    """
    Contact object
    """

    #: A constant which can be used with the contact_type property of a Contact.
    #: This constant has a value of "PRIMARY"
    CONTACT_TYPE_PRIMARY = "PRIMARY"

    #: A constant which can be used with the contact_type property of a Contact.
    #: This constant has a value of "ALTERNATE"
    CONTACT_TYPE_ALTERNATE = "ALTERNATE"

    #: A constant which can be used with the contact_type property of a Contact.
    #: This constant has a value of "ADMIN"
    CONTACT_TYPE_ADMIN = "ADMIN"

    def __init__(self, **kwargs):
        """
        Initializes a new Contact object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this Contact.
        :type name: str

        :param email:
            The value to assign to the email property of this Contact.
        :type email: str

        :param phone:
            The value to assign to the phone property of this Contact.
        :type phone: str

        :param contact_type:
            The value to assign to the contact_type property of this Contact.
            Allowed values for this property are: "PRIMARY", "ALTERNATE", "ADMIN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type contact_type: str

        """
        self.swagger_types = {
            'name': 'str',
            'email': 'str',
            'phone': 'str',
            'contact_type': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'email': 'email',
            'phone': 'phone',
            'contact_type': 'contactType'
        }

        self._name = None
        self._email = None
        self._phone = None
        self._contact_type = None

    @property
    def name(self):
        """
        Gets the name of this Contact.

        :return: The name of this Contact.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Contact.

        :param name: The name of this Contact.
        :type: str
        """
        self._name = name

    @property
    def email(self):
        """
        Gets the email of this Contact.

        :return: The email of this Contact.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this Contact.

        :param email: The email of this Contact.
        :type: str
        """
        self._email = email

    @property
    def phone(self):
        """
        Gets the phone of this Contact.

        :return: The phone of this Contact.
        :rtype: str
        """
        return self._phone

    @phone.setter
    def phone(self, phone):
        """
        Sets the phone of this Contact.

        :param phone: The phone of this Contact.
        :type: str
        """
        self._phone = phone

    @property
    def contact_type(self):
        """
        Gets the contact_type of this Contact.
        Allowed values for this property are: "PRIMARY", "ALTERNATE", "ADMIN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The contact_type of this Contact.
        :rtype: str
        """
        return self._contact_type

    @contact_type.setter
    def contact_type(self, contact_type):
        """
        Sets the contact_type of this Contact.

        :param contact_type: The contact_type of this Contact.
        :type: str
        """
        allowed_values = ["PRIMARY", "ALTERNATE", "ADMIN"]
        if not value_allowed_none_or_none_sentinel(contact_type, allowed_values):
            contact_type = 'UNKNOWN_ENUM_VALUE'
        self._contact_type = contact_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
